/**
 * @license
 * Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
 * This code may only be used under the BSD style license found at
 * http://polymer.github.io/LICENSE.txt The complete set of authors may be found
 * at http://polymer.github.io/AUTHORS.txt The complete set of contributors may
 * be found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by
 * Google as part of the polymer project is also subject to an additional IP
 * rights grant found at http://polymer.github.io/PATENTS.txt
 */
import{Base}from"../polymer/polymer_bundled.min.js";const HAS_NEW_MOUSE=(()=>{let has=false;try{has=Boolean(new MouseEvent("x"))}catch(_){}return has})();const HAS_NEW_TOUCH=(()=>{let has=false;try{has=Boolean(new TouchEvent("x"))}catch(_){}return has})();export function middleOfNode(node){const bcr=node.getBoundingClientRect();return{y:bcr.top+bcr.height/2,x:bcr.left+bcr.width/2}}export function topLeftOfNode(node){const bcr=node.getBoundingClientRect();return{y:bcr.top,x:bcr.left}}export function makeTouches(xyList,node){let id=0;return xyList.map((function(xy){var touchInit={identifier:id++,target:node,clientX:xy.x,clientY:xy.y};return HAS_NEW_TOUCH?new window.Touch(touchInit):touchInit}))}export function makeSoloTouchEvent(type,xy,node){xy=xy||middleOfNode(node);const touches=makeTouches([xy],node);const touchEventInit={touches:touches,targetTouches:touches,changedTouches:touches};let event;if(HAS_NEW_TOUCH){touchEventInit.bubbles=true;touchEventInit.cancelable=true;event=new TouchEvent(type,touchEventInit)}else{event=new CustomEvent(type,{bubbles:true,cancelable:true,composed:true});for(const property in touchEventInit){event[property]=touchEventInit[property]}}node.dispatchEvent(event)}export function makeMouseEvent(type,xy,node){const props={bubbles:true,cancelable:true,clientX:xy.x,clientY:xy.y,composed:true,buttons:1};let e;if(HAS_NEW_MOUSE){e=new MouseEvent(type,props)}else{e=document.createEvent("MouseEvent");e.initMouseEvent(type,props.bubbles,props.cancelable,null,null,0,0,props.clientX,props.clientY,false,false,false,false,0,null)}node.dispatchEvent(e)}export function move(node,fromXY,toXY,steps){steps=steps||5;var dx=Math.round((fromXY.x-toXY.x)/steps);var dy=Math.round((fromXY.y-toXY.y)/steps);var xy={x:fromXY.x,y:fromXY.y};for(var i=steps;i>0;i--){makeMouseEvent("mousemove",xy,node);xy.x+=dx;xy.y+=dy}makeMouseEvent("mousemove",{x:toXY.x,y:toXY.y},node)}export function track(target,dx,dy,steps){dx=dx|0;dy=dy|0;steps=steps||5;down(target);var xy=middleOfNode(target);var xy2={x:xy.x+dx,y:xy.y+dy};move(target,xy,xy2,steps);up(target,xy2)}export function down(node,xy){xy=xy||middleOfNode(node);makeMouseEvent("mousedown",xy,node)}export function up(node,xy){xy=xy||middleOfNode(node);makeMouseEvent("mouseup",xy,node)}export function click(node,xy){xy=xy||middleOfNode(node);makeMouseEvent("click",xy,node)}export function touchstart(node,xy){xy=xy||middleOfNode(node);makeSoloTouchEvent("touchstart",xy,node)}export function touchend(node,xy){xy=xy||middleOfNode(node);makeSoloTouchEvent("touchend",xy,node)}export function downAndUp(target,callback,options){if(options&&options.emulateTouch){touchstart(target);touchend(target)}down(target);Base.async((function(){up(target);click(target);callback&&callback()}))}export function tap(node,options){if(window.getComputedStyle(node)["pointer-events"]==="none"){return}const xy=middleOfNode(node);if(options&&options.emulateTouch){touchstart(node,xy);touchend(node,xy)}down(node,xy);up(node,xy);click(node,xy)}export function focus(target){Base.fire("focus",{},{bubbles:false,node:target})}export function blur(target){Base.fire("blur",{},{bubbles:false,node:target})}export function keyboardEventFor(type,keyCode,modifiers,key){const event=new CustomEvent(type,{detail:0,bubbles:true,cancelable:true,composed:true});event.keyCode=keyCode;event.code=keyCode;modifiers=modifiers||[];if(typeof modifiers==="string"){modifiers=[modifiers]}event.shiftKey=modifiers.indexOf("shift")!==-1;event.altKey=modifiers.indexOf("alt")!==-1;event.ctrlKey=modifiers.indexOf("ctrl")!==-1;event.metaKey=modifiers.indexOf("meta")!==-1;event.key=key;return event}export function keyEventOn(target,type,keyCode,modifiers,key){target.dispatchEvent(keyboardEventFor(type,keyCode,modifiers,key))}export function keyDownOn(target,keyCode,modifiers,key){keyEventOn(target,"keydown",keyCode,modifiers,key)}export function keyUpOn(target,keyCode,modifiers,key){keyEventOn(target,"keyup",keyCode,modifiers,key)}export function pressAndReleaseKeyOn(target,keyCode,modifiers,key){keyDownOn(target,keyCode,modifiers,key);Base.async((function(){keyUpOn(target,keyCode,modifiers,key)}),1)}export function pressEnter(target){pressAndReleaseKeyOn(target,13)}export function pressSpace(target){pressAndReleaseKeyOn(target,32)}window.MockInteractions={middleOfNode:middleOfNode,topLeftOfNode:topLeftOfNode,makeTouches:makeTouches,makeSoloTouchEvent:makeSoloTouchEvent,makeMouseEvent:makeMouseEvent,move:move,track:track,down:down,up:up,click:click,touchstart:touchstart,touchend:touchend,downAndUp:downAndUp,tap:tap,focus:focus,blur:blur,keyboardEventFor:keyboardEventFor,keyEventOn:keyEventOn,keyDownOn:keyDownOn,keyUpOn:keyUpOn,pressAndReleaseKeyOn:pressAndReleaseKeyOn,pressEnter:pressEnter,pressSpace:pressSpace};