// ui/accessibility/mojom/ax_mode.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'ui/accessibility/mojom/ax_mode.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('ax.mojom');



  function AXMode(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AXMode.prototype.initDefaults_ = function() {
    this.flags = 0;
    this.filterFlags = 0;
  };
  AXMode.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AXMode.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  AXMode.encodedSize = codec.kStructHeaderSize + 8;

  AXMode.decode = function(decoder) {
    var packed;
    var val = new AXMode();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.flags =
        decoder.decodeStruct(codec.Uint32);
    val.filterFlags =
        decoder.decodeStruct(codec.Uint32);
    return val;
  };

  AXMode.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AXMode.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.flags);
    encoder.encodeStruct(codec.Uint32, val.filterFlags);
  };
  exports.AXMode = AXMode;
})();