// ui/accessibility/mojom/ax_tree_update.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'ui/accessibility/mojom/ax_tree_update.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('ax.mojom');
  var ax_enums$ =
      mojo.internal.exposeNamespace('ax.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/accessibility/ax_enums.mojom', '../ax_enums.mojom.js');
  }
  var ax_event_intent$ =
      mojo.internal.exposeNamespace('ax.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/accessibility/mojom/ax_event_intent.mojom', 'ax_event_intent.mojom.js');
  }
  var ax_node_data$ =
      mojo.internal.exposeNamespace('ax.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/accessibility/mojom/ax_node_data.mojom', 'ax_node_data.mojom.js');
  }
  var ax_tree_data$ =
      mojo.internal.exposeNamespace('ax.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/accessibility/mojom/ax_tree_data.mojom', 'ax_tree_data.mojom.js');
  }
  var ax_tree_checks$ =
      mojo.internal.exposeNamespace('ax.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/accessibility/mojom/ax_tree_checks.mojom', 'ax_tree_checks.mojom.js');
  }



  function AXTreeUpdate(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AXTreeUpdate.prototype.initDefaults_ = function() {
    this.hasTreeData = false;
    this.nodeIdToClear = 0;
    this.treeData = null;
    this.rootId = 0;
    this.eventFrom = 0;
    this.nodes = null;
    this.eventFromAction = 0;
    this.eventIntents = null;
    this.treeChecks = null;
  };
  AXTreeUpdate.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AXTreeUpdate.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 64}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate AXTreeUpdate.treeData
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, ax_tree_data$.AXTreeData, false);
    if (err !== validator.validationError.NONE)
        return err;




    // validate AXTreeUpdate.nodes
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 24, 8, new codec.PointerTo(ax_node_data$.AXNodeData), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AXTreeUpdate.eventFrom
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 20, ax_enums$.EventFrom);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AXTreeUpdate.eventFromAction
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 32, ax_enums$.Action);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AXTreeUpdate.eventIntents
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 40, 8, new codec.PointerTo(ax_event_intent$.EventIntent), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AXTreeUpdate.treeChecks
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 48, ax_tree_checks$.AXTreeChecks, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AXTreeUpdate.encodedSize = codec.kStructHeaderSize + 56;

  AXTreeUpdate.decode = function(decoder) {
    var packed;
    var val = new AXTreeUpdate();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.hasTreeData = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.nodeIdToClear =
        decoder.decodeStruct(codec.Int32);
    val.treeData =
        decoder.decodeStructPointer(ax_tree_data$.AXTreeData);
    val.rootId =
        decoder.decodeStruct(codec.Int32);
    val.eventFrom =
        decoder.decodeStruct(new codec.Enum(ax_enums$.EventFrom));
    val.nodes =
        decoder.decodeArrayPointer(new codec.PointerTo(ax_node_data$.AXNodeData));
    val.eventFromAction =
        decoder.decodeStruct(new codec.Enum(ax_enums$.Action));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.eventIntents =
        decoder.decodeArrayPointer(new codec.PointerTo(ax_event_intent$.EventIntent));
    val.treeChecks =
        decoder.decodeStructPointer(ax_tree_checks$.AXTreeChecks);
    return val;
  };

  AXTreeUpdate.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AXTreeUpdate.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.hasTreeData & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.nodeIdToClear);
    encoder.encodeStructPointer(ax_tree_data$.AXTreeData, val.treeData);
    encoder.encodeStruct(codec.Int32, val.rootId);
    encoder.encodeStruct(codec.Int32, val.eventFrom);
    encoder.encodeArrayPointer(new codec.PointerTo(ax_node_data$.AXNodeData), val.nodes);
    encoder.encodeStruct(codec.Int32, val.eventFromAction);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeArrayPointer(new codec.PointerTo(ax_event_intent$.EventIntent), val.eventIntents);
    encoder.encodeStructPointer(ax_tree_checks$.AXTreeChecks, val.treeChecks);
  };
  exports.AXTreeUpdate = AXTreeUpdate;
})();