// ui/base/ime/mojom/ime_types.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../mojo/public/js/bindings.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const TextInputModeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const TextInputMode = {
  
  kDefault: 0,
  kNone: 1,
  kText: 2,
  kTel: 3,
  kUrl: 4,
  kEmail: 5,
  kNumeric: 6,
  kDecimal: 7,
  kSearch: 8,
  MIN_VALUE: 0,
  MAX_VALUE: 8,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const TextInputActionSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const TextInputAction = {
  
  kDefault: 0,
  kEnter: 1,
  kDone: 2,
  kGo: 3,
  kNext: 4,
  kPrevious: 5,
  kSearch: 6,
  kSend: 7,
  MIN_VALUE: 0,
  MAX_VALUE: 7,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const TextInputTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const TextInputType = {
  
  NONE: 0,
  TEXT: 1,
  PASSWORD: 2,
  SEARCH: 3,
  EMAIL: 4,
  NUMBER: 5,
  TELEPHONE: 6,
  URL: 7,
  DATE: 8,
  DATE_TIME: 9,
  DATE_TIME_LOCAL: 10,
  MONTH: 11,
  TIME: 12,
  WEEK: 13,
  TEXT_AREA: 14,
  CONTENT_EDITABLE: 15,
  DATE_TIME_FIELD: 16,
  TYPE_NULL: 17,
  MAX: 17,
  MIN_VALUE: 0,
  MAX_VALUE: 17,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const ImeTextSpanTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const ImeTextSpanType = {
  
  kComposition: 0,
  kSuggestion: 1,
  kMisspellingSuggestion: 2,
  kAutocorrect: 3,
  kGrammarSuggestion: 4,
  MIN_VALUE: 0,
  MAX_VALUE: 4,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const ImeTextSpanThicknessSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const ImeTextSpanThickness = {
  
  kNone: 0,
  kThin: 1,
  kThick: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const ImeTextSpanUnderlineStyleSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const ImeTextSpanUnderlineStyle = {
  
  kNone: 0,
  kSolid: 1,
  kDot: 2,
  kDash: 3,
  kSquiggle: 4,
  MIN_VALUE: 0,
  MAX_VALUE: 4,
};


/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ImeTextSpanSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    ImeTextSpanSpec.$,
    'ImeTextSpan',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        ImeTextSpanTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'startOffset', 4,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'endOffset', 8,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'underlineColor', 12,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'thickness', 16,
        0,
        ImeTextSpanThicknessSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'underlineStyle', 20,
        0,
        ImeTextSpanUnderlineStyleSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'textColor', 24,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'backgroundColor', 28,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'suggestionHighlightColor', 32,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'removeOnFinishComposing', 36,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'interimCharSelection', 36,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'suggestions', 40,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'shouldHideSuggestionMenu', 36,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 56],]);



/**
 * @record
 */
export class ImeTextSpan {
  constructor() {
    /** @type { !ImeTextSpanType } */
    this.type;
    /** @type { !number } */
    this.startOffset;
    /** @type { !number } */
    this.endOffset;
    /** @type { !number } */
    this.underlineColor;
    /** @type { !ImeTextSpanThickness } */
    this.thickness;
    /** @type { !ImeTextSpanUnderlineStyle } */
    this.underlineStyle;
    /** @type { !number } */
    this.textColor;
    /** @type { !number } */
    this.backgroundColor;
    /** @type { !number } */
    this.suggestionHighlightColor;
    /** @type { !boolean } */
    this.removeOnFinishComposing;
    /** @type { !boolean } */
    this.interimCharSelection;
    /** @type { !Array<!string> } */
    this.suggestions;
    /** @type { !boolean } */
    this.shouldHideSuggestionMenu;
  }
}

