// ui/display/mojom/display_snapshot.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');

goog.require('display.mojom.DisplayConnectionType');
goog.require('display.mojom.PanelOrientation');
goog.require('display.mojom.PrivacyScreenState');
goog.require('display.mojom.VariableRefreshRateState');
goog.require('gfx.mojom.ColorSpace');
goog.require('display.mojom.DisplayMode');
goog.require('mojoBase.mojom.FilePath');
goog.require('gfx.mojom.HDRStaticMetadata');
goog.require('gfx.mojom.Point');
goog.require('gfx.mojom.Size');
goog.require('skia.mojom.SkColorSpacePrimaries');






goog.provide('display.mojom.DisplaySnapshotColorInfoSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
display.mojom.DisplaySnapshotColorInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('display.mojom.DisplaySnapshotSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
display.mojom.DisplaySnapshotSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    display.mojom.DisplaySnapshotColorInfoSpec.$,
    'DisplaySnapshotColorInfo',
    [
      mojo.internal.StructField(
        'colorSpace', 0,
        0,
        gfx.mojom.ColorSpaceSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'edidPrimaries', 8,
        0,
        skia.mojom.SkColorSpacePrimariesSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'edidGamma', 16,
        0,
        mojo.internal.Float,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hdrStaticMetadata', 24,
        0,
        gfx.mojom.HDRStaticMetadataSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'supportsColorTemperatureAdjustment', 20,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'bitsPerChannel', 32,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 48],]);



goog.provide('display.mojom.DisplaySnapshotColorInfo');

/** @record */
display.mojom.DisplaySnapshotColorInfo = class {
  constructor() {
    /** @export { !gfx.mojom.ColorSpace } */
    this.colorSpace;
    /** @export { !skia.mojom.SkColorSpacePrimaries } */
    this.edidPrimaries;
    /** @export { !number } */
    this.edidGamma;
    /** @export { (gfx.mojom.HDRStaticMetadata|undefined) } */
    this.hdrStaticMetadata;
    /** @export { !boolean } */
    this.supportsColorTemperatureAdjustment;
    /** @export { !number } */
    this.bitsPerChannel;
  }
};



mojo.internal.Struct(
    display.mojom.DisplaySnapshotSpec.$,
    'DisplaySnapshot',
    [
      mojo.internal.StructField(
        'displayId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'portDisplayId', 8,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'edidDisplayId', 16,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'connectorIndex', 24,
        0,
        mojo.internal.Uint16,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'origin', 32,
        0,
        gfx.mojom.PointSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'physicalSize', 40,
        0,
        gfx.mojom.SizeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'type', 28,
        0,
        display.mojom.DisplayConnectionTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'baseConnectorId', 48,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'pathTopology', 56,
        0,
        mojo.internal.Array(mojo.internal.Uint64, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isAspectPreservingScaling', 26,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hasOverscan', 26,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'privacyScreenState', 64,
        0,
        display.mojom.PrivacyScreenStateSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hasContentProtectionKey', 26,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'colorInfo', 72,
        0,
        display.mojom.DisplaySnapshotColorInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'displayName', 80,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sysPath', 88,
        0,
        mojoBase.mojom.FilePathSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'modes', 96,
        0,
        mojo.internal.Array(display.mojom.DisplayModeSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'panelOrientation', 68,
        0,
        display.mojom.PanelOrientationSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'edid', 104,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'currentModeIndex', 112,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hasCurrentMode', 26,
        3,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'nativeModeIndex', 120,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hasNativeMode', 26,
        4,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'productCode', 128,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'yearOfManufacture', 136,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'maximumCursorSize', 144,
        0,
        gfx.mojom.SizeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'variableRefreshRateState', 140,
        0,
        display.mojom.VariableRefreshRateStateSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'drmFormatsAndModifiers', 152,
        0,
        mojo.internal.Map(mojo.internal.Uint32, mojo.internal.Array(mojo.internal.Uint64, false), false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 168],]);



goog.provide('display.mojom.DisplaySnapshot');

/** @record */
display.mojom.DisplaySnapshot = class {
  constructor() {
    /** @export { !bigint } */
    this.displayId;
    /** @export { !bigint } */
    this.portDisplayId;
    /** @export { !bigint } */
    this.edidDisplayId;
    /** @export { !number } */
    this.connectorIndex;
    /** @export { !gfx.mojom.Point } */
    this.origin;
    /** @export { !gfx.mojom.Size } */
    this.physicalSize;
    /** @export { !display.mojom.DisplayConnectionType } */
    this.type;
    /** @export { !bigint } */
    this.baseConnectorId;
    /** @export { !Array<!bigint> } */
    this.pathTopology;
    /** @export { !boolean } */
    this.isAspectPreservingScaling;
    /** @export { !boolean } */
    this.hasOverscan;
    /** @export { !display.mojom.PrivacyScreenState } */
    this.privacyScreenState;
    /** @export { !boolean } */
    this.hasContentProtectionKey;
    /** @export { !display.mojom.DisplaySnapshotColorInfo } */
    this.colorInfo;
    /** @export { !string } */
    this.displayName;
    /** @export { !mojoBase.mojom.FilePath } */
    this.sysPath;
    /** @export { !Array<!display.mojom.DisplayMode> } */
    this.modes;
    /** @export { !display.mojom.PanelOrientation } */
    this.panelOrientation;
    /** @export { !Array<!number> } */
    this.edid;
    /** @export { !bigint } */
    this.currentModeIndex;
    /** @export { !boolean } */
    this.hasCurrentMode;
    /** @export { !bigint } */
    this.nativeModeIndex;
    /** @export { !boolean } */
    this.hasNativeMode;
    /** @export { !bigint } */
    this.productCode;
    /** @export { !number } */
    this.yearOfManufacture;
    /** @export { !gfx.mojom.Size } */
    this.maximumCursorSize;
    /** @export { !display.mojom.VariableRefreshRateState } */
    this.variableRefreshRateState;
    /** @export { !Object<!number, !Array<!bigint>> } */
    this.drmFormatsAndModifiers;
  }
};

