// ui/display/mojom/display_snapshot.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../mojo/public/js/bindings.js';

import {
  FilePath as mojoBase_mojom_FilePath,
  FilePathSpec as mojoBase_mojom_FilePathSpec
} from '../../../mojo/public/mojom/base/file_path.mojom.m.js';

import {
  SkColorSpacePrimaries as skia_mojom_SkColorSpacePrimaries,
  SkColorSpacePrimariesSpec as skia_mojom_SkColorSpacePrimariesSpec
} from '../../../skia/public/mojom/skcolorspace_primaries.mojom.m.js';

import {
  Point as gfx_mojom_Point,
  PointSpec as gfx_mojom_PointSpec,
  Size as gfx_mojom_Size,
  SizeSpec as gfx_mojom_SizeSpec
} from '../../gfx/geometry/mojom/geometry.mojom.m.js';

import {
  ColorSpace as gfx_mojom_ColorSpace,
  ColorSpaceSpec as gfx_mojom_ColorSpaceSpec
} from '../../gfx/mojom/color_space.mojom.m.js';

import {
  HDRStaticMetadata as gfx_mojom_HDRStaticMetadata,
  HDRStaticMetadataSpec as gfx_mojom_HDRStaticMetadataSpec
} from '../../gfx/mojom/hdr_static_metadata.mojom.m.js';

import {
  DisplayConnectionType as display_mojom_DisplayConnectionType,
  DisplayConnectionTypeSpec as display_mojom_DisplayConnectionTypeSpec,
  PanelOrientation as display_mojom_PanelOrientation,
  PanelOrientationSpec as display_mojom_PanelOrientationSpec,
  PrivacyScreenState as display_mojom_PrivacyScreenState,
  PrivacyScreenStateSpec as display_mojom_PrivacyScreenStateSpec,
  VariableRefreshRateState as display_mojom_VariableRefreshRateState,
  VariableRefreshRateStateSpec as display_mojom_VariableRefreshRateStateSpec
} from './display_constants.mojom.m.js';

import {
  DisplayMode as display_mojom_DisplayMode,
  DisplayModeSpec as display_mojom_DisplayModeSpec
} from './display_mode.mojom.m.js';



/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DisplaySnapshotColorInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DisplaySnapshotSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    DisplaySnapshotColorInfoSpec.$,
    'DisplaySnapshotColorInfo',
    [
      mojo.internal.StructField(
        'colorSpace', 0,
        0,
        gfx_mojom_ColorSpaceSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'edidPrimaries', 8,
        0,
        skia_mojom_SkColorSpacePrimariesSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'edidGamma', 16,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hdrStaticMetadata', 24,
        0,
        gfx_mojom_HDRStaticMetadataSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'supportsColorTemperatureAdjustment', 20,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'bitsPerChannel', 32,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 48],]);



/**
 * @record
 */
export class DisplaySnapshotColorInfo {
  constructor() {
    /** @type { !gfx_mojom_ColorSpace } */
    this.colorSpace;
    /** @type { !skia_mojom_SkColorSpacePrimaries } */
    this.edidPrimaries;
    /** @type { !number } */
    this.edidGamma;
    /** @type { (gfx_mojom_HDRStaticMetadata|undefined) } */
    this.hdrStaticMetadata;
    /** @type { !boolean } */
    this.supportsColorTemperatureAdjustment;
    /** @type { !number } */
    this.bitsPerChannel;
  }
}



mojo.internal.Struct(
    DisplaySnapshotSpec.$,
    'DisplaySnapshot',
    [
      mojo.internal.StructField(
        'displayId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'portDisplayId', 8,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'edidDisplayId', 16,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'connectorIndex', 24,
        0,
        mojo.internal.Uint16,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'origin', 32,
        0,
        gfx_mojom_PointSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'physicalSize', 40,
        0,
        gfx_mojom_SizeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'type', 28,
        0,
        display_mojom_DisplayConnectionTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'baseConnectorId', 48,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'pathTopology', 56,
        0,
        mojo.internal.Array(mojo.internal.Uint64, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isAspectPreservingScaling', 26,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hasOverscan', 26,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'privacyScreenState', 64,
        0,
        display_mojom_PrivacyScreenStateSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hasContentProtectionKey', 26,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'colorInfo', 72,
        0,
        DisplaySnapshotColorInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'displayName', 80,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sysPath', 88,
        0,
        mojoBase_mojom_FilePathSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'modes', 96,
        0,
        mojo.internal.Array(display_mojom_DisplayModeSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'panelOrientation', 68,
        0,
        display_mojom_PanelOrientationSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'edid', 104,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'currentModeIndex', 112,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hasCurrentMode', 26,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'nativeModeIndex', 120,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hasNativeMode', 26,
        4,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'productCode', 128,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'yearOfManufacture', 136,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maximumCursorSize', 144,
        0,
        gfx_mojom_SizeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'variableRefreshRateState', 140,
        0,
        display_mojom_VariableRefreshRateStateSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'drmFormatsAndModifiers', 152,
        0,
        mojo.internal.Map(mojo.internal.Uint32, mojo.internal.Array(mojo.internal.Uint64, false), false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 168],]);



/**
 * @record
 */
export class DisplaySnapshot {
  constructor() {
    /** @type { !bigint } */
    this.displayId;
    /** @type { !bigint } */
    this.portDisplayId;
    /** @type { !bigint } */
    this.edidDisplayId;
    /** @type { !number } */
    this.connectorIndex;
    /** @type { !gfx_mojom_Point } */
    this.origin;
    /** @type { !gfx_mojom_Size } */
    this.physicalSize;
    /** @type { !display_mojom_DisplayConnectionType } */
    this.type;
    /** @type { !bigint } */
    this.baseConnectorId;
    /** @type { !Array<!bigint> } */
    this.pathTopology;
    /** @type { !boolean } */
    this.isAspectPreservingScaling;
    /** @type { !boolean } */
    this.hasOverscan;
    /** @type { !display_mojom_PrivacyScreenState } */
    this.privacyScreenState;
    /** @type { !boolean } */
    this.hasContentProtectionKey;
    /** @type { !DisplaySnapshotColorInfo } */
    this.colorInfo;
    /** @type { !string } */
    this.displayName;
    /** @type { !mojoBase_mojom_FilePath } */
    this.sysPath;
    /** @type { !Array<!display_mojom_DisplayMode> } */
    this.modes;
    /** @type { !display_mojom_PanelOrientation } */
    this.panelOrientation;
    /** @type { !Array<!number> } */
    this.edid;
    /** @type { !bigint } */
    this.currentModeIndex;
    /** @type { !boolean } */
    this.hasCurrentMode;
    /** @type { !bigint } */
    this.nativeModeIndex;
    /** @type { !boolean } */
    this.hasNativeMode;
    /** @type { !bigint } */
    this.productCode;
    /** @type { !number } */
    this.yearOfManufacture;
    /** @type { !gfx_mojom_Size } */
    this.maximumCursorSize;
    /** @type { !display_mojom_VariableRefreshRateState } */
    this.variableRefreshRateState;
    /** @type { !Object<!number, !Array<!bigint>> } */
    this.drmFormatsAndModifiers;
  }
}

