// Copyright 2012 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{loadTimeData}from"chrome://resources/ash/common/load_time_data.m.js";import"chrome://resources/js/cr.js";var ProgressItemState;(function(ProgressItemState){ProgressItemState["SCANNING"]="scanning";ProgressItemState["PROGRESSING"]="progressing";ProgressItemState["COMPLETED"]="completed";ProgressItemState["ERROR"]="error";ProgressItemState["CANCELED"]="canceled";ProgressItemState["PAUSED"]="paused"})(ProgressItemState||(ProgressItemState={}));var PolicyErrorType;(function(PolicyErrorType){PolicyErrorType["DLP"]="dlp";PolicyErrorType["ENTERPRISE_CONNECTORS"]="enterprise_connectors";PolicyErrorType["DLP_WARNING_TIMEOUT"]="dlp_warning_timeout"})(PolicyErrorType||(PolicyErrorType={}));var ProgressItemType;(function(ProgressItemType){ProgressItemType["COPY"]="copy";ProgressItemType["DELETE"]="delete";ProgressItemType["EMPTY_TRASH"]="empty-trash";ProgressItemType["EXTRACT"]="extract";ProgressItemType["MOVE"]="move";ProgressItemType["ZIP"]="zip";ProgressItemType["SYNC"]="sync";ProgressItemType["RESTORE"]="restore";ProgressItemType["RESTORE_TO_DESTINATION"]="restore_to_destination";ProgressItemType["TRANSFER"]="transfer";ProgressItemType["TRASH"]="trash";ProgressItemType["FORMAT"]="format";ProgressItemType["MOUNT_ARCHIVE"]="mount_archive";ProgressItemType["PARTITION"]="partition"})(ProgressItemType||(ProgressItemType={}));class ProgressCenterItem{constructor(){this.id_="";this.state=ProgressItemState.PROGRESSING;this.message="";this.sourceMessage="";this.destinationMessage="";this.itemCount=0;this.progressMax=0;this.progressValue=0;this.type=null;this.single=true;this.quiet=false;this.cancelCallback=null;this.dismissCallback=null;this.remainingTime=0;this.extraButton=new Map;this.isDestinationDrive=false;this.policyError=null;this.policyFileCount=null;this.policyFileName=null;this.skippedEncryptedFiles=[]}setExtraButton(state,text,callback){if(!text||!callback){console.warn("Text and callback must be supplied");return}if(this.extraButton.has(state)){console.warn("Extra button already defined for state:",state);return}const extraButton={text:text,callback:callback};this.extraButton.set(state,extraButton)}set id(value){if(!this.id_){this.id_=value}else{console.error("The ID is already set. (current ID: "+this.id_+")")}}get id(){return this.id_}get progressRateInPercent(){switch(this.state){case ProgressItemState.CANCELED:return 0;case ProgressItemState.COMPLETED:return 100;default:return~~(100*this.progressValue/this.progressMax)}}get cancelable(){return!!(this.state===ProgressItemState.PROGRESSING&&this.cancelCallback&&this.single)||!!(this.state===ProgressItemState.PAUSED&&this.cancelCallback)}clone(){const clonedItem=Object.assign(new ProgressCenterItem,this);return clonedItem}}function assert(value,message){if(value){return}throw new Error("Assertion failed"+(message?`: ${message}`:""))}function assertNotReached(message="Unreachable code hit"){assert(false,message)}const ALLOWED_SCRIPT_URLS=new Set(["foreground/js/main.js","background/js/runtime_loaded_test_util.js","foreground/js/deferred_elements.js","foreground/js/metadata/metadata_dispatcher.js"]);if(!window.hasOwnProperty("trustedScriptUrlPolicy_")){assert(window.trustedTypes);window.trustedScriptUrlPolicy_=window.trustedTypes.createPolicy("file-manager-trusted-script",{createScriptURL:url=>{if(!ALLOWED_SCRIPT_URLS.has(url)){throw new Error("Script URL not allowed: "+url)}return url},createHTML:()=>assertNotReached(),createScript:()=>assertNotReached()})}function getSanitizedScriptUrl(url){assert(window.trustedScriptUrlPolicy_);return window.trustedScriptUrlPolicy_.createScriptURL(url)}class ScriptLoader{constructor(src_,params={}){this.src_=src_;this.type_=params.type;this.defer_=params.defer}async load(){return new Promise(((resolve,reject)=>{const script=document.createElement("script");if(this.type_!==undefined){script.type=this.type_}if(this.defer_!==undefined){script.defer=this.defer_}script.onload=()=>resolve(this.src_);script.onerror=error=>reject(error);script.src=getSanitizedScriptUrl(this.src_);document.head.append(script)}))}}function iconSetToCSSBackgroundImageValue(iconSet){let lowDpiPart=null;let highDpiPart=null;if(iconSet.icon16x16Url){lowDpiPart="url("+iconSet.icon16x16Url+") 1x"}if(iconSet.icon32x32Url){highDpiPart="url("+iconSet.icon32x32Url+") 2x"}if(lowDpiPart&&highDpiPart){return"image-set("+lowDpiPart+", "+highDpiPart+")"}else if(lowDpiPart){return"image-set("+lowDpiPart+")"}else if(highDpiPart){return"image-set("+highDpiPart+")"}return"none"}var FileErrorToDomError;(function(FileErrorToDomError){FileErrorToDomError["ABORT_ERR"]="AbortError";FileErrorToDomError["INVALID_MODIFICATION_ERR"]="InvalidModificationError";FileErrorToDomError["INVALID_STATE_ERR"]="InvalidStateError";FileErrorToDomError["NO_MODIFICATION_ALLOWED_ERR"]="NoModificationAllowedError";FileErrorToDomError["NOT_FOUND_ERR"]="NotFoundError";FileErrorToDomError["NOT_READABLE_ERR"]="NotReadable";FileErrorToDomError["PATH_EXISTS_ERR"]="PathExistsError";FileErrorToDomError["QUOTA_EXCEEDED_ERR"]="QuotaExceededError";FileErrorToDomError["TYPE_MISMATCH_ERR"]="TypeMismatchError";FileErrorToDomError["ENCODING_ERR"]="EncodingError"})(FileErrorToDomError||(FileErrorToDomError={}));function descriptorEqual(left,right){return left.appId===right.appId&&left.taskType===right.taskType&&left.actionId===right.actionId}function debug(...vars){console.debug(...vars)}window.test=window.test||{};const test=window.test;test.util={};test.util.sync={};test.util.async={};function sanitizeDate(strDate){return strDate.replace(" "," ")}test.util.sync.getFileList=contentWindow=>{const table=contentWindow.document.querySelector("#detail-table");const rows=table.querySelectorAll("li");const fileList=[];for(const row of rows){fileList.push([row.querySelector(".filename-label")?.textContent??"",row.querySelector(".size")?.textContent??"",row.querySelector(".type")?.textContent??"",sanitizeDate(row.querySelector(".date")?.textContent||"")])}return fileList};test.util.sync.getSelectedFiles=contentWindow=>{const table=contentWindow.document.querySelector("#detail-table");const rows=table.querySelectorAll("li");const selected=[];for(const row of rows){if(row.hasAttribute("selected")){selected.push(row.querySelector(".filename-label")?.textContent??"")}}return selected};test.util.sync.selectFile=(contentWindow,filename)=>{const rows=contentWindow.document.querySelectorAll("#detail-table li");test.util.sync.focus(contentWindow,"#file-list");test.util.sync.fakeKeyDown(contentWindow,"#file-list","Home",false,false,false);for(let index=0;index<rows.length;++index){const selection=test.util.sync.getSelectedFiles(contentWindow);if(selection.length===1&&selection[0]===filename){return true}test.util.sync.fakeKeyDown(contentWindow,"#file-list","ArrowDown",false,false,false)}console.warn('Failed to select file "'+filename+'"');return false};test.util.sync.openFile=(contentWindow,filename)=>{const query="#file-list li.table-row[selected] .filename-label span";return test.util.sync.selectFile(contentWindow,filename)&&test.util.sync.fakeMouseDoubleClick(contentWindow,query)};test.util.sync.getLastVisitedURL=contentWindow=>contentWindow.fileManager.getLastVisitedUrl();test.util.sync.getTranslatedString=(contentWindow,id)=>contentWindow.fileManager.getTranslatedString(id);test.util.async.executeScriptInWebView=(contentWindow,webViewQuery,code,callback)=>{const webView=contentWindow.document.querySelector(webViewQuery);webView.executeScript({code:code},callback)};test.util.sync.copyFile=(contentWindow,filename)=>{if(!test.util.sync.selectFile(contentWindow,filename)){return false}test.util.sync.fakeKeyDown(contentWindow,"#file-list","c",true,false,false);test.util.sync.fakeKeyDown(contentWindow,"#file-list","v",true,false,false);return true};test.util.sync.deleteFile=(contentWindow,filename)=>{if(!test.util.sync.selectFile(contentWindow,filename)){return false}test.util.sync.fakeKeyDown(contentWindow,"#file-list","Delete",false,false,false);return true};test.util.sync.execCommand=(contentWindow,command)=>{const ret=contentWindow.document.execCommand(command);if(!ret){console.warn(`execCommand(${command}) returned false for SWA, forcing `+`return value to true. b/191831968`);return true}return ret};test.util.sync.overrideTasks=(contentWindow,taskList,isPolicyDefault=false)=>{const getFileTasks=(_entries,_sourceUrls,onTasks)=>{setTimeout((()=>{const policyDefaultHandlerStatus=isPolicyDefault?chrome.fileManagerPrivate.PolicyDefaultHandlerStatus.DEFAULT_HANDLER_ASSIGNED_BY_POLICY:undefined;onTasks({tasks:taskList,policyDefaultHandlerStatus:policyDefaultHandlerStatus})}),0)};const executeTask=(descriptor,entries,callback)=>{executedTasks.push({descriptor:descriptor,entries:entries,callback:callback})};const setDefaultTask=descriptor=>{for(const task of taskList){task.isDefault=descriptorEqual(task.descriptor,descriptor)}};executedTasks=[];contentWindow.chrome.fileManagerPrivate.getFileTasks=getFileTasks;contentWindow.chrome.fileManagerPrivate.executeTask=executeTask;contentWindow.chrome.fileManagerPrivate.setDefaultTask=setDefaultTask;return true};test.util.sync.getExecutedTasks=_contentWindow=>{if(!executedTasks){console.error("Please call overrideTasks() first.");return null}return executedTasks.map((task=>({descriptor:task.descriptor,fileNames:task.entries.map((e=>e.name))})))};test.util.sync.taskWasExecuted=(_contentWindow,descriptor,fileNames)=>{if(!executedTasks){console.error("Please call overrideTasks() first.");return null}const fileNamesStr=JSON.stringify(fileNames);const task=executedTasks.find((task=>descriptorEqual(task.descriptor,descriptor)&&fileNamesStr===JSON.stringify(task.entries.map((e=>e.name)))));return task!==undefined};let executedTasks=null;test.util.sync.replyExecutedTask=(_contentWindow,descriptor,responseArgs)=>{if(!executedTasks){console.error("Please call overrideTasks() first.");return false}const found=executedTasks.find((task=>descriptorEqual(task.descriptor,descriptor)));if(!found){const{appId:appId,taskType:taskType,actionId:actionId}=descriptor;console.error(`No task with id ${appId}|${taskType}|${actionId}`);return false}found.callback(...responseArgs);return true};test.util.sync.unload=contentWindow=>{contentWindow.fileManager.onUnloadForTest()};test.util.sync.getBreadcrumbPath=contentWindow=>{const doc=contentWindow.document;const breadcrumb=doc.querySelector("#location-breadcrumbs xf-breadcrumb");if(!breadcrumb){return""}return"/"+breadcrumb.path};test.util.async.getPreferences=callback=>{chrome.fileManagerPrivate.getPreferences(callback)};test.util.sync.overrideFormat=contentWindow=>{contentWindow.chrome.fileManagerPrivate.formatVolume=(_volumeId,_filesystem,_volumeLabel)=>{};return true};test.util.async.requestAnimationFrame=(contentWindow,callback)=>{contentWindow.requestAnimationFrame((()=>{callback(true)}))};test.util.async.renderWindowTextDirectionRTL=(contentWindow,callback)=>{contentWindow.document.documentElement.setAttribute("dir","rtl");contentWindow.document.body.setAttribute("dir","rtl");contentWindow.requestAnimationFrame((()=>{callback(true)}))};const foregroundReplacedObjects={};function staticFakeFactory(attrName,staticValue){return(...args)=>{setTimeout((()=>{for(const arg of args){if(typeof arg==="function"){console.warn(`staticFake for ${attrName} value: ${staticValue}`);return arg(staticValue)}}throw new Error(`Couldn't find callback for ${attrName}`)}),0)}}function staticPromiseFakeFactory(attrName,staticValue){return async(..._args)=>{console.warn(`staticPromiseFake for "${attrName}" returning value: ${staticValue}`);return staticValue}}const fakes={static_fake:staticFakeFactory,static_promise_fake:staticPromiseFakeFactory};class PrepareFake{constructor(attrName_,fakeId_,context_,...args){this.attrName_=attrName_;this.fakeId_=fakeId_;this.context_=context_;this.fake_=null;this.parentObject_=null;this.leafAttrName_="";this.original_=null;this.prepared_=false;this.callCounter=0;this.calledArgs=[];this.args_=args}prepare(){this.buildFake_();this.traverseContext_();this.prepared_=true}replace(contentWindow){const suffix=`for ${this.attrName_} ${this.fakeId_}`;if(!this.prepared_){throw new Error(`PrepareFake prepare() not called ${suffix}`)}if(!this.parentObject_){throw new Error(`Missing parentObject_ ${suffix}`)}if(!this.fake_){throw new Error(`Missing fake_ ${suffix}`)}if(!this.leafAttrName_){throw new Error(`Missing leafAttrName_ ${suffix}`)}this.saveOriginal_(contentWindow);this.parentObject_[this.leafAttrName_]=async(...args)=>{const result=await this.fake_(...args);this.callCounter++;this.calledArgs.push([...args]);return result}}restore(){if(!this.original_){return}this.parentObject_[this.leafAttrName_]=this.original_;this.original_=null}saveOriginal_(contentWindow){const windowFakes=foregroundReplacedObjects[contentWindow.appID]||{};foregroundReplacedObjects[contentWindow.appID]=windowFakes;if(!windowFakes[this.attrName_]){if(!this.parentObject_){console.error(`Failed to find the fake context: ${this.attrName_}`);return}const original=this.parentObject_[this.leafAttrName_];this.original_=original;windowFakes[this.attrName_]=this}return}buildFake_(){const factory=fakes[this.fakeId_];if(!factory){throw new Error(`Failed to find the fake factory for ${this.fakeId_}`)}this.fake_=factory(this.attrName_,...this.args_)}traverseContext_(){let target=this.context_;let parentObj=null;let attr="";for(const a of this.attrName_.split(".")){attr=a;parentObj=target;target=target[a];if(target===undefined){throw new Error(`Couldn't find "${0}" from "${this.attrName_}"`)}}this.parentObject_=parentObj;this.leafAttrName_=attr}}test.util.sync.foregroundFake=(contentWindow,fakeData)=>{const entries=Object.entries(fakeData);for(const[path,mockValue]of entries){const fakeId=mockValue[0];const fakeArgs=mockValue[1]||[];const fake=new PrepareFake(path,fakeId,contentWindow,...fakeArgs);fake.prepare();fake.replace(contentWindow)}return entries.length};test.util.sync.removeAllForegroundFakes=contentWindow=>{const windowFakes=foregroundReplacedObjects[contentWindow.appID];if(!windowFakes){console.error(`Failed to find the fakes for window ${contentWindow.appID}`);return 0}const savedFakes=Object.entries(windowFakes);let removedCount=0;for(const[_path,fake]of savedFakes){fake.restore();removedCount++}return removedCount};test.util.sync.staticFakeCounter=(contentWindow,fakedApi)=>{const windowFakes=foregroundReplacedObjects[contentWindow.appID];if(!windowFakes){console.error(`Failed to find the fakes for window ${contentWindow.appID}`);return-1}const fake=windowFakes[fakedApi];return fake?.callCounter??-1};test.util.sync.staticFakeCalledArgs=(contentWindow,fakedApi)=>{const fake=foregroundReplacedObjects[contentWindow.appID][fakedApi];return fake.calledArgs};test.util.sync.sendProgressItem=(id,type,state,message,remainingTime,progressMax=1,progressValue=0,count=1)=>{const item=new ProgressCenterItem;item.id=id;item.type=type;item.state=state;item.message=message;item.remainingTime=remainingTime;item.progressMax=progressMax;item.progressValue=progressValue;item.itemCount=count;window.background.progressCenter.updateItem(item);return true};test.util.executeTestMessage=(_request,_callback)=>{throw new Error("executeTestMessage not implemented")};test.swaTestMessageListener=request=>{request.contentWindow=window;return new Promise((resolve=>{test.util.executeTestMessage(request,(response=>{response=response===undefined?"@undefined@":response;resolve(JSON.stringify(response))}))}))};let testUtilsLoaded=null;test.swaLoadTestUtils=async()=>{const scriptUrl="background/js/runtime_loaded_test_util.js";try{if(!testUtilsLoaded){console.info("Loading "+scriptUrl);testUtilsLoaded=new ScriptLoader(scriptUrl,{type:"module"}).load()}await testUtilsLoaded;console.info("Loaded "+scriptUrl);return true}catch(error){testUtilsLoaded=null;return false}};test.getSwaAppId=async()=>{if(!testUtilsLoaded){await test.swaLoadTestUtils()}return String(window.appID)};const ACTIONS_MODEL_METADATA_PREFETCH_PROPERTY_NAMES=["canPin","hosted","pinned"];const FILE_SELECTION_METADATA_PREFETCH_PROPERTY_NAMES=["availableOffline","contentMimeType","hosted","canPin"];const LIST_CONTAINER_METADATA_PREFETCH_PROPERTY_NAMES=["availableOffline","contentMimeType","customIconUrl","hosted","modificationTime","modificationByMeTime","pinned","shared","size","canCopy","canDelete","canRename","canAddChildren","canShare","canPin","isMachineRoot","isExternalMedia","isArbitrarySyncFolder"];const DLP_METADATA_PREFETCH_PROPERTY_NAMES=["isDlpRestricted","sourceUrl","isRestrictedForDestination"];const ICON_TYPES={ANDROID_FILES:"android_files",ARCHIVE:"archive",AUDIO:"audio",BLANK:"blank",BRUSCHETTA:"bruschetta",BULK_PINNING_BATTERY_SAVER:"bulk_pinning_battery_saver",BULK_PINNING_DONE:"bulk_pinning_done",BULK_PINNING_OFFLINE:"bulk_pinning_offline",CAMERA_FOLDER:"camera-folder",CANT_PIN:"cant-pin",CHECK:"check",CLOUD_DONE:"cloud_done",CLOUD_ERROR:"cloud_error",CLOUD_OFFLINE:"cloud_offline",CLOUD_PAUSED:"cloud_paused",CLOUD_SYNC:"cloud_sync",CLOUD:"cloud",COMPUTER:"computer",COMPUTERS_GRAND_ROOT:"computers_grand_root",CROSTINI:"crostini",DOWNLOADS:"downloads",DRIVE_BULK_PINNING:"drive_bulk_pinning",DRIVE_LOGO:"drive_logo",DRIVE_OFFLINE:"drive_offline",DRIVE_RECENT:"drive_recent",DRIVE_SHARED_WITH_ME:"drive_shared_with_me",DRIVE:"drive",ERROR:"error",ERROR_BANNER:"error_banner",EXCEL:"excel",EXTERNAL_MEDIA:"external_media",FOLDER:"folder",GENERIC:"generic",GOOGLE_DOC:"gdoc",GOOGLE_DRAW:"gdraw",GOOGLE_FORM:"gform",GOOGLE_LINK:"glink",GOOGLE_MAP:"gmap",GOOGLE_SHEET:"gsheet",GOOGLE_SITE:"gsite",GOOGLE_SLIDES:"gslides",GOOGLE_TABLE:"gtable",IMAGE:"image",MTP:"mtp",MY_FILES:"my_files",OFFLINE:"offline",ODFS:"odfs",OPTICAL:"optical",PDF:"pdf",PLUGIN_VM:"plugin_vm",POWERPOINT:"ppt",RAW:"raw",RECENT:"recent",REMOVABLE:"removable",SCRIPT:"script",SD_CARD:"sd",SERVICE_DRIVE:"service_drive",SHARED_DRIVE:"shared_drive",SHARED_DRIVES_GRAND_ROOT:"shared_drives_grand_root",SHARED_FOLDER:"shared_folder",SHORTCUT:"shortcut",SITES:"sites",SMB:"smb",STAR:"star",TEAM_DRIVE:"team_drive",THUMBNAIL_GENERIC:"thumbnail_generic",TINI:"tini",TRASH:"trash",UNKNOWN_REMOVABLE:"unknown_removable",USB:"usb",VIDEO:"video",WORD:"word"};const ODFS_EXTENSION_ID="gnnndjlaomemikopnjhhnoombakkkkdg";function vmTypeToIconName(vmType){if(vmType===undefined){console.error("vmType: is undefined");return""}switch(vmType){case chrome.fileManagerPrivate.VmType.BRUSCHETTA:return ICON_TYPES.BRUSCHETTA;case chrome.fileManagerPrivate.VmType.ARCVM:return ICON_TYPES.ANDROID_FILES;case chrome.fileManagerPrivate.VmType.TERMINA:return ICON_TYPES.CROSTINI;default:console.error("Unable to determine icon for vmType: "+vmType);return""}}var AllowedPaths;(function(AllowedPaths){AllowedPaths["NATIVE_PATH"]="nativePath";AllowedPaths["ANY_PATH"]="anyPath";AllowedPaths["ANY_PATH_OR_URL"]="anyPathOrUrl"})(AllowedPaths||(AllowedPaths={}));var VolumeType;(function(VolumeType){VolumeType["TESTING"]="testing";VolumeType["DRIVE"]="drive";VolumeType["DOWNLOADS"]="downloads";VolumeType["REMOVABLE"]="removable";VolumeType["ARCHIVE"]="archive";VolumeType["MTP"]="mtp";VolumeType["PROVIDED"]="provided";VolumeType["MEDIA_VIEW"]="media_view";VolumeType["DOCUMENTS_PROVIDER"]="documents_provider";VolumeType["CROSTINI"]="crostini";VolumeType["GUEST_OS"]="guest_os";VolumeType["ANDROID_FILES"]="android_files";VolumeType["MY_FILES"]="my_files";VolumeType["SMB"]="smb";VolumeType["SYSTEM_INTERNAL"]="system_internal";VolumeType["TRASH"]="trash"})(VolumeType||(VolumeType={}));var DialogType;(function(DialogType){DialogType["SELECT_FOLDER"]="folder";DialogType["SELECT_UPLOAD_FOLDER"]="upload-folder";DialogType["SELECT_SAVEAS_FILE"]="saveas-file";DialogType["SELECT_OPEN_FILE"]="open-file";DialogType["SELECT_OPEN_MULTI_FILE"]="open-multi-file";DialogType["FULL_PAGE"]="full-page"})(DialogType||(DialogType={}));var FileSystemType;(function(FileSystemType){FileSystemType["UNKNOWN"]="";FileSystemType["VFAT"]="vfat";FileSystemType["EXFAT"]="exfat";FileSystemType["NTFS"]="ntfs";FileSystemType["HFSPLUS"]="hfsplus";FileSystemType["EXT2"]="ext2";FileSystemType["EXT3"]="ext3";FileSystemType["EXT4"]="ext4";FileSystemType["ISO9660"]="iso9660";FileSystemType["UDF"]="udf";FileSystemType["FUSEBOX"]="fusebox"})(FileSystemType||(FileSystemType={}));({[FileSystemType.VFAT]:11,[FileSystemType.EXFAT]:15,[FileSystemType.NTFS]:32});var RootType;(function(RootType){RootType["DOWNLOADS"]="downloads";RootType["ARCHIVE"]="archive";RootType["REMOVABLE"]="removable";RootType["DRIVE"]="drive";RootType["SHARED_DRIVES_GRAND_ROOT"]="shared_drives_grand_root";RootType["SHARED_DRIVE"]="team_drive";RootType["MTP"]="mtp";RootType["PROVIDED"]="provided";RootType["DRIVE_OFFLINE"]="drive_offline";RootType["DRIVE_SHARED_WITH_ME"]="drive_shared_with_me";RootType["DRIVE_RECENT"]="drive_recent";RootType["MEDIA_VIEW"]="media_view";RootType["DOCUMENTS_PROVIDER"]="documents_provider";RootType["RECENT"]="recent";RootType["DRIVE_FAKE_ROOT"]="drive_fake_root";RootType["CROSTINI"]="crostini";RootType["GUEST_OS"]="guest_os";RootType["ANDROID_FILES"]="android_files";RootType["MY_FILES"]="my_files";RootType["COMPUTERS_GRAND_ROOT"]="computers_grand_root";RootType["COMPUTER"]="computer";RootType["EXTERNAL_MEDIA"]="external_media";RootType["SMB"]="smb";RootType["TRASH"]="trash"})(RootType||(RootType={}));[RootType.DOWNLOADS,RootType.ARCHIVE,RootType.REMOVABLE,RootType.DRIVE,RootType.SHARED_DRIVES_GRAND_ROOT,RootType.SHARED_DRIVE,RootType.MTP,RootType.PROVIDED,"DEPRECATED_DRIVE_OTHER",RootType.DRIVE_OFFLINE,RootType.DRIVE_SHARED_WITH_ME,RootType.DRIVE_RECENT,RootType.MEDIA_VIEW,RootType.RECENT,RootType.DRIVE_FAKE_ROOT,"DEPRECATED_ADD_NEW_SERVICES_MENU",RootType.CROSTINI,RootType.ANDROID_FILES,RootType.MY_FILES,RootType.COMPUTERS_GRAND_ROOT,RootType.COMPUTER,RootType.EXTERNAL_MEDIA,RootType.DOCUMENTS_PROVIDER,RootType.SMB,"DEPRECATED_RECENT_AUDIO","DEPRECATED_RECENT_IMAGES","DEPRECATED_RECENT_VIDEOS",RootType.TRASH,RootType.GUEST_OS];var VolumeError;(function(VolumeError){VolumeError["TIMEOUT"]="timeout";VolumeError["SUCCESS"]="success";VolumeError["IN_PROGRESS"]="in_progress";VolumeError["UNKNOWN_ERROR"]="unknown_error";VolumeError["INTERNAL_ERROR"]="internal_error";VolumeError["INVALID_ARGUMENT"]="invalid_argument";VolumeError["INVALID_PATH"]="invalid_path";VolumeError["PATH_ALREADY_MOUNTED"]="path_already_mounted";VolumeError["PATH_NOT_MOUNTED"]="path_not_mounted";VolumeError["DIRECTORY_CREATION_FAILED"]="directory_creation_failed";VolumeError["INVALID_MOUNT_OPTIONS"]="invalid_mount_options";VolumeError["INSUFFICIENT_PERMISSIONS"]="insufficient_permissions";VolumeError["MOUNT_PROGRAM_NOT_FOUND"]="mount_program_not_found";VolumeError["MOUNT_PROGRAM_FAILED"]="mount_program_failed";VolumeError["INVALID_DEVICE_PATH"]="invalid_device_path";VolumeError["UNKNOWN_FILESYSTEM"]="unknown_filesystem";VolumeError["UNSUPPORTED_FILESYSTEM"]="unsupported_filesystem";VolumeError["NEED_PASSWORD"]="need_password";VolumeError["CANCELLED"]="cancelled";VolumeError["BUSY"]="busy";VolumeError["CORRUPTED"]="corrupted"})(VolumeError||(VolumeError={}));var Source;(function(Source){Source["FILE"]="file";Source["DEVICE"]="device";Source["NETWORK"]="network";Source["SYSTEM"]="system"})(Source||(Source={}));function shouldProvideIcons(volumeType){switch(volumeType){case VolumeType.ANDROID_FILES:case VolumeType.DOCUMENTS_PROVIDER:case VolumeType.PROVIDED:return true}return false}var MediaViewRootType;(function(MediaViewRootType){MediaViewRootType["IMAGES"]="images_root";MediaViewRootType["VIDEOS"]="videos_root";MediaViewRootType["AUDIO"]="audio_root";MediaViewRootType["DOCUMENTS"]="documents_root"})(MediaViewRootType||(MediaViewRootType={}));function getMediaViewRootTypeFromVolumeId(volumeId){return volumeId.split(":",2)[1]}const SHARED_DRIVES_DIRECTORY_NAME="team_drives";const SHARED_DRIVES_DIRECTORY_PATH="/"+SHARED_DRIVES_DIRECTORY_NAME;const COMPUTERS_DIRECTORY_NAME="Computers";const COMPUTERS_DIRECTORY_PATH="/"+COMPUTERS_DIRECTORY_NAME;class FilesAppEntry{constructor(rootType=null){this.rootType=rootType}get typeName(){return"FilesAppEntry"}get isDirectory(){return false}get isFile(){return true}get filesystem(){return null}get fullPath(){return""}get name(){return""}getParent(_success,error){if(error){setTimeout(error,0,new Error("Not implemented"))}}getMetadata(_success,error){if(error){setTimeout(error,0,new Error("Not implemented"))}}get isNativeType(){return false}getNativeEntry(){return null}copyTo(_newParent,_newName,_success,error){if(error){setTimeout(error,0,new Error("Not implemented"))}}moveTo(_newParent,_newName,_success,error){if(error){setTimeout(error,0,new Error("Not implemented"))}}remove(_success,error){if(error){setTimeout(error,0,new Error("Not implemented"))}}}class FilesAppDirEntry extends FilesAppEntry{get typeName(){return"FilesAppDirEntry"}get isDirectory(){return true}get isFile(){return false}createReader(){return{}}getFile(_path,_options,_success,error){if(error){setTimeout(error,0,new Error("Not implemented"))}}getDirectory(_path,_options,_success,error){if(error){setTimeout(error,0,new Error("Not implemented"))}}removeRecursively(_success,error){if(error){setTimeout(error,0,new Error("Not implemented"))}}}class StaticReader{constructor(entries_){this.entries_=entries_}readEntries(success,_error){const entries=this.entries_;this.entries_=[];setTimeout((()=>success(entries)),0)}}class CombinedReaders{constructor(readers_){this.readers_=readers_;this.readers_.reverse();this.currentReader_=this.readers_.pop()}readEntries(success,error){if(!this.currentReader_){success([]);return}this.currentReader_.readEntries((results=>{if(results.length){success(results)}else{if(!this.readers_.length){success([]);return}this.currentReader_=this.readers_.pop();this.readEntries(success,error)}}),error)}}class EntryList extends FilesAppDirEntry{constructor(label,rootType,devicePath=""){super(rootType);this.label=label;this.devicePath=devicePath;this.children_=[];this.disabled=false}get typeName(){return"EntryList"}get isDirectory(){return true}get isFile(){return false}get fullPath(){return"/"}getUiChildren(){return this.children_}get name(){return this.label}get isNativeType(){return false}getMetadata(success,_error){setTimeout((()=>success({modificationTime:new Date,size:0})),0)}toURL(){let url=`entry-list://${this.rootType}`;if(this.devicePath){url+=`/${this.devicePath}`}return url}getParent(success,_error){if(success){setTimeout((()=>success(this)),0)}}addEntry(entry){this.children_.push(entry);const volumeEntry=entry;if(volumeEntry.typeName==="VolumeEntry"){volumeEntry.setPrefix(this)}}createReader(){return new StaticReader(this.children_)}findIndexByVolumeInfo(volumeInfo){return this.children_.findIndex((childEntry=>childEntry.volumeInfo?childEntry.volumeInfo.volumeId===volumeInfo.volumeId:false))}removeByVolumeType(volumeType){const childIndex=this.children_.findIndex((childEntry=>{const volumeInfo=childEntry.volumeInfo;return volumeInfo&&volumeInfo.volumeType===volumeType}));if(childIndex!==-1){this.children_.splice(childIndex,1);return true}return false}removeAllByRootType(rootType){this.children_=this.children_.filter((entry=>entry.rootType!==rootType))}removeAllByVolumeType(volumeType){this.children_=this.children_.filter((entry=>entry.volumeType!==volumeType))}removeChildEntry(entry){const childIndex=this.children_.findIndex((childEntry=>isSameEntry(childEntry,entry)));if(childIndex!==-1){this.children_.splice(childIndex,1);return true}return false}removeAllChildren(){this.children_=[]}getNativeEntry(){return null}get volumeType(){switch(this.rootType){case RootType.MY_FILES:return VolumeType.DOWNLOADS;case RootType.DRIVE_FAKE_ROOT:return VolumeType.DRIVE;default:return null}}}class VolumeEntry extends FilesAppDirEntry{constructor(volumeInfo){super();this.volumeInfo=volumeInfo;this.children_=[];this.disabled=false;this.rootEntry_=this.volumeInfo.displayRoot;if(!this.rootEntry_){this.volumeInfo.resolveDisplayRoot((displayRoot=>{this.rootEntry_=displayRoot}))}}get typeName(){return"VolumeEntry"}get volumeType(){return this.volumeInfo.volumeType}get filesystem(){return this.rootEntry_?this.rootEntry_.filesystem:null}getUiChildren(){return this.children_}get fullPath(){return this.rootEntry_?this.rootEntry_.fullPath:""}get isDirectory(){return this.rootEntry_?this.rootEntry_.isDirectory:true}get isFile(){return this.rootEntry_?this.rootEntry_.isFile:false}getDirectory(path,options,success,error){if(!this.rootEntry_){if(error){setTimeout((()=>error(new Error("Root entry not resolved yet"))),0)}return}this.rootEntry_.getDirectory(path,options,success,error)}getFile(path,options,success,error){if(!this.rootEntry_){if(error){setTimeout((()=>error(new Error("Root entry not resolved yet"))),0)}return}this.rootEntry_.getFile(path,options,success,error)}get name(){return this.volumeInfo.label}toURL(){return this.rootEntry_?.toURL()??""}get iconName(){if(this.volumeInfo.volumeType===VolumeType.GUEST_OS){return vmTypeToIconName(this.volumeInfo.vmType)}if(this.volumeInfo.volumeType===VolumeType.DOWNLOADS){return VolumeType.MY_FILES}return this.volumeInfo.volumeType}getParent(success,_error){if(success){setTimeout((()=>success(this)),0)}}getMetadata(success,error){this.rootEntry_.getMetadata(success,error)}get isNativeType(){return true}getNativeEntry(){return this.rootEntry_}createReader(){const readers=[];if(this.rootEntry_){readers.push(this.rootEntry_.createReader())}if(this.children_.length){readers.push(new StaticReader(this.children_))}return new CombinedReaders(readers)}setPrefix(entry){this.volumeInfo.prefixEntry=entry}addEntry(entry){this.children_.push(entry);const volumeEntry=entry;if(volumeEntry.typeName==="VolumeEntry"){volumeEntry.setPrefix(this)}}findIndexByVolumeInfo(volumeInfo){return this.children_.findIndex((childEntry=>childEntry.volumeInfo?.volumeId===volumeInfo.volumeId))}removeByVolumeType(volumeType){const childIndex=this.children_.findIndex((childEntry=>childEntry.volumeInfo?.volumeType===volumeType));if(childIndex!==-1){this.children_.splice(childIndex,1);return true}return false}removeAllByRootType(rootType){this.children_=this.children_.filter((entry=>entry.rootType!==rootType))}removeAllByVolumeType(volumeType){this.children_=this.children_.filter((entry=>entry.volumeType!==volumeType))}removeChildEntry(entry){const childIndex=this.children_.findIndex((childEntry=>isSameEntry(childEntry,entry)));if(childIndex!==-1){this.children_.splice(childIndex,1);return true}return false}}function isFlagEnabled(flagName){return loadTimeData.isInitialized()&&loadTimeData.valueExists(flagName)&&loadTimeData.getBoolean(flagName)}function isGuestOsEnabled(){return isFlagEnabled("GUEST_OS")}function isSinglePartitionFormatEnabled(){return isFlagEnabled("FILES_SINGLE_PARTITION_FORMAT_ENABLED")}function isSkyvaultV2Enabled(){return isFlagEnabled("SKYVAULT_V2_ENABLED")}function str(id){try{return loadTimeData.getString(id)}catch(e){console.warn("Failed to get string for",id);return id}}const collator=new Intl.Collator([],{usage:"sort",numeric:true,sensitivity:"base"});function getRootTypeLabel(locationInfo){const volumeInfoLabel=locationInfo.volumeInfo?.label||"";switch(locationInfo.rootType){case RootType.DOWNLOADS:return volumeInfoLabel;case RootType.DRIVE:return str("DRIVE_MY_DRIVE_LABEL");case RootType.SHARED_DRIVE:case RootType.SHARED_DRIVES_GRAND_ROOT:return str("DRIVE_SHARED_DRIVES_LABEL");case RootType.COMPUTER:case RootType.COMPUTERS_GRAND_ROOT:return str("DRIVE_COMPUTERS_LABEL");case RootType.DRIVE_OFFLINE:return str("DRIVE_OFFLINE_COLLECTION_LABEL");case RootType.DRIVE_SHARED_WITH_ME:return str("DRIVE_SHARED_WITH_ME_COLLECTION_LABEL");case RootType.DRIVE_RECENT:return str("DRIVE_RECENT_COLLECTION_LABEL");case RootType.DRIVE_FAKE_ROOT:return str("DRIVE_DIRECTORY_LABEL");case RootType.RECENT:return str("RECENT_ROOT_LABEL");case RootType.CROSTINI:return str("LINUX_FILES_ROOT_LABEL");case RootType.MY_FILES:return str("MY_FILES_ROOT_LABEL");case RootType.TRASH:return str("TRASH_ROOT_LABEL");case RootType.MEDIA_VIEW:const mediaViewRootType=getMediaViewRootTypeFromVolumeId(locationInfo.volumeInfo?.volumeId||"");switch(mediaViewRootType){case MediaViewRootType.IMAGES:return str("MEDIA_VIEW_IMAGES_ROOT_LABEL");case MediaViewRootType.VIDEOS:return str("MEDIA_VIEW_VIDEOS_ROOT_LABEL");case MediaViewRootType.AUDIO:return str("MEDIA_VIEW_AUDIO_ROOT_LABEL");case MediaViewRootType.DOCUMENTS:return str("MEDIA_VIEW_DOCUMENTS_ROOT_LABEL");default:console.error("Unsupported media view root type: "+mediaViewRootType);return volumeInfoLabel}case RootType.ARCHIVE:case RootType.REMOVABLE:case RootType.MTP:case RootType.PROVIDED:case RootType.ANDROID_FILES:case RootType.DOCUMENTS_PROVIDER:case RootType.SMB:case RootType.GUEST_OS:return volumeInfoLabel;default:console.error("Unsupported root type: "+locationInfo.rootType);return volumeInfoLabel}}function getEntryLabel(locationInfo,entry){if(isOneDrivePlaceholder(entry)){return entry.name}if(locationInfo){if(locationInfo.hasFixedLabel){return getRootTypeLabel(locationInfo)}if(entry.filesystem&&entry.filesystem.root===entry){return getRootTypeLabel(locationInfo)}}if(locationInfo&&locationInfo.rootType===RootType.DOWNLOADS){if(entry.fullPath==="/Downloads"){return str("DOWNLOADS_DIRECTORY_LABEL")}if(entry.fullPath==="/PvmDefault"){return str("PLUGIN_VM_DIRECTORY_LABEL")}if(entry.fullPath==="/Camera"){return str("CAMERA_DIRECTORY_LABEL")}}return entry.name}class ConcurrentActionInvalidatedError extends Error{}function isActionsProducer(value){return value.next!==undefined&&value.throw!==undefined}class SelectorController{constructor(host,value,subscribe){this.host=host;this.value=value;this.subscribe=subscribe;this.host.addController(this)}hostConnected(){this.unsubscribe=this.subscribe((value=>{this.value=value;this.host.requestUpdate()}))}hostDisconnected(){this.unsubscribe()}}class SelectorNode{constructor(parents,select,name,isEqual_=strictlyEqual){this.select=select;this.name=name;this.isEqual_=isEqual_;this.value_=undefined;this.subscribers_=[];this.parents_=[];this.depth=0;this.children=[];this.parents=parents}static createSourceNode(select,name){return new SelectorNode([],select,name)}static createDisconnectedNode(name){return new SelectorNode([],(()=>undefined),name)}get parents(){return this.parents_}set parents(parents){this.disconnect_();this.parents_=parents;for(const parent of parents){parent.children.push(this);this.depth=Math.max(this.depth,parent.depth+1)}this.emit()}disconnect_(){this.parents.forEach((p=>p.disconnectChild_(this)));this.parents_=[]}disconnectChild_(node){this.children.splice(this.children.indexOf(node),1)}emit(){const parentValues=this.parents.map((p=>p.get()));const newValue=this.select(...parentValues);if(this.isEqual_(this.value_,newValue)){return false}if(isDebugStoreEnabled()&&this.name){console.info(`Selector '${this.name}' emitted a new value:`);console.info(newValue)}this.value_=newValue;for(const subscriber of this.subscribers_){try{subscriber(newValue)}catch(e){console.error(e)}}return true}get(){return this.value_}subscribe(cb){this.subscribers_.push(cb);return()=>this.subscribers_.splice(this.subscribers_.indexOf(cb),1)}createController(host){return new SelectorController(host,this.get(),this.subscribe.bind(this))}delete(){if(this.children.length>0){throw new Error("Attempting to delete node that still has children.")}this.disconnect_();this.subscribers_=[]}}function combine1Selector(combineFunction,s1,name,isEqual=strictlyEqual){return new SelectorNode([s1],combineFunction,name,isEqual)}class SelectorEmitter{constructor(){this.sourceNodes_=[]}addSource(node){this.sourceNodes_.push(node)}processChange(){const toExplore=[...this.sourceNodes_];while(toExplore.length>0){const node=toExplore.pop();if(node.emit()){toExplore.push(...node.children);toExplore.sort(((a,b)=>b.depth-a.depth))}}}}function strictlyEqual(oldValue,newValue){return oldValue===newValue}class Slice{constructor(name){this.name=name;this.reducers=new Map;this.selector=SelectorNode.createDisconnectedNode(this.name)}prependSliceName_(type){const isFullName=type[0]==="[";return isFullName?type:`[${this.name}] ${type}`}addReducer(localType,reducer){const type=this.prependSliceName_(localType);if(this.reducers.get(type)){throw new Error("Attempting to register multiple reducers "+`within slice for the same action type: ${type}`)}this.reducers.set(type,reducer);const actionFactory=payload=>({type:type,payload:payload});actionFactory.type=type;return actionFactory}}class BaseStore{constructor(state,slices){this.reducers_=new Map;this.initialized_=false;this.batchMode_=false;this.selectorEmitter_=new SelectorEmitter;this.state_=state;this.queuedActions_=[];this.observers_=[];this.initialized_=false;this.batchMode_=false;const sliceNames=new Set(slices.map((slice=>slice.name)));if(sliceNames.size!==slices.length){throw new Error("One or more given slices have the same name. "+"Please ensure slices are uniquely named: "+[...sliceNames].join(", "))}const rootSelector=SelectorNode.createSourceNode((()=>this.state_),"root");this.selectorEmitter_.addSource(rootSelector);this.selector=rootSelector;for(const slice of slices){slice.selector.select=state=>state[slice.name];slice.selector.parents=[rootSelector];for(const[type,reducer]of slice.reducers.entries()){const reducerList=this.reducers_.get(type);if(!reducerList){this.reducers_.set(type,[reducer])}else{reducerList.push(reducer)}}}}init(initialState){this.state_=initialState;this.queuedActions_.forEach((action=>{if(isActionsProducer(action)){this.consumeProducedActions_(action)}else{this.dispatchInternal_(action)}}));this.initialized_=true;this.selectorEmitter_.processChange();this.notifyObservers_(this.state_)}isInitialized(){return this.initialized_}subscribe(observer){this.observers_.push(observer);return this.unsubscribe.bind(this,observer)}unsubscribe(observer){this.observers_=this.observers_.filter((o=>o!==observer))}beginBatchUpdate(){this.batchMode_=true}endBatchUpdate(){this.batchMode_=false;this.notifyObservers_(this.state_)}getState(){return this.state_}dispatch(action){if(!this.initialized_){this.queuedActions_.push(action);return}if(isActionsProducer(action)){this.consumeProducedActions_(action)}else{this.dispatchInternal_(action)}}setDebug(isDebug){if(isDebug){localStorage.setItem("DEBUG_STORE","1")}else{localStorage.removeItem("DEBUG_STORE")}}dispatchInternal_(action){this.reduce(action)}async consumeProducedActions_(actionsProducer){while(true){try{const{done:done,value:value}=await actionsProducer.next();if(value!==undefined){this.dispatch(value)}if(done){return}}catch(error){if(isInvalidationError(error)){return}console.warn("Failure executing actions producer",error)}}}reduce(action){const isDebugStore=isDebugStoreEnabled();if(isDebugStore){console.groupCollapsed(`Action: ${action.type}`);console.dir(action.payload)}const reducers=this.reducers_.get(action.type);if(!reducers||reducers.length===0){console.error(`No registered reducers for action: ${action.type}`);return}this.state_=reducers.reduce(((state,reducer)=>reducer(state,action.payload)),this.state_);if(this.initialized_&&!this.batchMode_){this.notifyObservers_(this.state_)}if(this.selector.get()!==this.state_){this.selectorEmitter_.processChange()}if(isDebugStore){console.groupEnd()}}notifyObservers_(state){this.observers_.forEach((o=>{try{o.onStateChanged(state)}catch(error){console.error(error)}}))}}function isInvalidationError(error){if(!error){return false}if(error instanceof ConcurrentActionInvalidatedError){return true}if(error.constructor?.name==="ConcurrentActionInvalidatedError"){return true}return false}function isDebugStoreEnabled(){return localStorage.getItem("DEBUG_STORE")==="1"}var EntryType;(function(EntryType){EntryType["FS_API"]="FS_API";EntryType["VOLUME_ROOT"]="VOLUME_ROOT";EntryType["ENTRY_LIST"]="ENTRY_LIST";EntryType["PLACEHOLDER"]="PLACEHOLDER";EntryType["TRASH"]="TRASH";EntryType["RECENT"]="RECENT"})(EntryType||(EntryType={}));var PropStatus;(function(PropStatus){PropStatus["STARTED"]="STARTED";PropStatus["SUCCESS"]="SUCCESS";PropStatus["ERROR"]="ERROR"})(PropStatus||(PropStatus={}));var FileTaskType;(function(FileTaskType){FileTaskType["UNKNOWN"]="";FileTaskType["FILE"]="file";FileTaskType["APP"]="app";FileTaskType["ARC"]="arc";FileTaskType["CROSTINI"]="crostini";FileTaskType["PLUGIN_VM"]="pluginvm";FileTaskType["WEB"]="web"})(FileTaskType||(FileTaskType={}));var SearchLocation;(function(SearchLocation){SearchLocation["EVERYWHERE"]="everywhere";SearchLocation["ROOT_FOLDER"]="root_folder";SearchLocation["THIS_FOLDER"]="this_folder"})(SearchLocation||(SearchLocation={}));var SearchRecency;(function(SearchRecency){SearchRecency["ANYTIME"]="anytime";SearchRecency["TODAY"]="today";SearchRecency["YESTERDAY"]="yesterday";SearchRecency["LAST_WEEK"]="last_week";SearchRecency["LAST_MONTH"]="last_month";SearchRecency["LAST_YEAR"]="last_year"})(SearchRecency||(SearchRecency={}));var NavigationSection;(function(NavigationSection){NavigationSection["TOP"]="top";NavigationSection["MY_FILES"]="my_files";NavigationSection["GOOGLE_DRIVE"]="google_drive";NavigationSection["ODFS"]="odfs";NavigationSection["CLOUD"]="cloud";NavigationSection["TRASH"]="trash";NavigationSection["ANDROID_APPS"]="android_apps";NavigationSection["REMOVABLE"]="removable"})(NavigationSection||(NavigationSection={}));var NavigationType;(function(NavigationType){NavigationType["SHORTCUT"]="shortcut";NavigationType["VOLUME"]="volume";NavigationType["RECENT"]="recent";NavigationType["CROSTINI"]="crostini";NavigationType["GUEST_OS"]="guest_os";NavigationType["ENTRY_LIST"]="entry_list";NavigationType["DRIVE"]="drive";NavigationType["ANDROID_APPS"]="android_apps";NavigationType["TRASH"]="trash"})(NavigationType||(NavigationType={}));const EXTENSION_TO_TYPE=new Map([[".jpeg",{extensions:[".jpeg",".jpg",".jfif",".pjpeg",".pjp"],mime:"image/jpeg",subtype:"JPEG",translationKey:"IMAGE_FILE_TYPE",type:"image"}],[".jpg",{extensions:[".jpeg",".jpg",".jfif",".pjpeg",".pjp"],mime:"image/jpeg",subtype:"JPEG",translationKey:"IMAGE_FILE_TYPE",type:"image"}],[".jfif",{extensions:[".jpeg",".jpg",".jfif",".pjpeg",".pjp"],mime:"image/jpeg",subtype:"JPEG",translationKey:"IMAGE_FILE_TYPE",type:"image"}],[".pjpeg",{extensions:[".jpeg",".jpg",".jfif",".pjpeg",".pjp"],mime:"image/jpeg",subtype:"JPEG",translationKey:"IMAGE_FILE_TYPE",type:"image"}],[".pjp",{extensions:[".jpeg",".jpg",".jfif",".pjpeg",".pjp"],mime:"image/jpeg",subtype:"JPEG",translationKey:"IMAGE_FILE_TYPE",type:"image"}],[".bmp",{extensions:[".bmp"],mime:"image/bmp",subtype:"BMP",translationKey:"IMAGE_FILE_TYPE",type:"image"}],[".gif",{extensions:[".gif"],mime:"image/gif",subtype:"GIF",translationKey:"IMAGE_FILE_TYPE",type:"image"}],[".ico",{extensions:[".ico"],mime:"image/x-icon",subtype:"ICO",translationKey:"IMAGE_FILE_TYPE",type:"image"}],[".png",{extensions:[".png"],mime:"image/png",subtype:"PNG",translationKey:"IMAGE_FILE_TYPE",type:"image"}],[".webp",{extensions:[".webp"],mime:"image/webp",subtype:"WebP",translationKey:"IMAGE_FILE_TYPE",type:"image"}],[".tif",{extensions:[".tif",".tiff"],mime:"image/tiff",subtype:"TIFF",translationKey:"IMAGE_FILE_TYPE",type:"image"}],[".tiff",{extensions:[".tif",".tiff"],mime:"image/tiff",subtype:"TIFF",translationKey:"IMAGE_FILE_TYPE",type:"image"}],[".svg",{extensions:[".svg",".svgz"],mime:"image/svg+xml",subtype:"SVG",translationKey:"IMAGE_FILE_TYPE",type:"image"}],[".svgz",{extensions:[".svg",".svgz"],mime:"image/svg+xml",subtype:"SVG",translationKey:"IMAGE_FILE_TYPE",type:"image"}],[".avif",{extensions:[".avif"],mime:"image/avif",subtype:"AVIF",translationKey:"IMAGE_FILE_TYPE",type:"image"}],[".jxl",{extensions:[".jxl"],mime:"image/jxl",subtype:"JXL",translationKey:"IMAGE_FILE_TYPE",type:"image"}],[".xbm",{extensions:[".xbm"],mime:"image/x-xbitmap",subtype:"XBM",translationKey:"IMAGE_FILE_TYPE",type:"image"}],[".arw",{extensions:[".arw"],icon:"image",mime:"image/x-sony-arw",subtype:"ARW",translationKey:"IMAGE_FILE_TYPE",type:"raw"}],[".cr2",{extensions:[".cr2"],icon:"image",mime:"image/x-canon-cr2",subtype:"CR2",translationKey:"IMAGE_FILE_TYPE",type:"raw"}],[".dng",{extensions:[".dng"],icon:"image",mime:"image/x-adobe-dng",subtype:"DNG",translationKey:"IMAGE_FILE_TYPE",type:"raw"}],[".nef",{extensions:[".nef"],icon:"image",mime:"image/x-nikon-nef",subtype:"NEF",translationKey:"IMAGE_FILE_TYPE",type:"raw"}],[".nrw",{extensions:[".nrw"],icon:"image",mime:"image/x-nikon-nrw",subtype:"NRW",translationKey:"IMAGE_FILE_TYPE",type:"raw"}],[".orf",{extensions:[".orf"],icon:"image",mime:"image/x-olympus-orf",subtype:"ORF",translationKey:"IMAGE_FILE_TYPE",type:"raw"}],[".raf",{extensions:[".raf"],icon:"image",mime:"image/x-fuji-raf",subtype:"RAF",translationKey:"IMAGE_FILE_TYPE",type:"raw"}],[".rw2",{extensions:[".rw2"],icon:"image",mime:"image/x-panasonic-rw2",subtype:"RW2",translationKey:"IMAGE_FILE_TYPE",type:"raw"}],[".3gp",{extensions:[".3gp",".3gpp"],mime:"video/3gpp",subtype:"3GP",translationKey:"VIDEO_FILE_TYPE",type:"video"}],[".3gpp",{extensions:[".3gp",".3gpp"],mime:"video/3gpp",subtype:"3GP",translationKey:"VIDEO_FILE_TYPE",type:"video"}],[".avi",{extensions:[".avi"],mime:"video/x-msvideo",subtype:"AVI",translationKey:"VIDEO_FILE_TYPE",type:"video"}],[".mov",{extensions:[".mov"],mime:"video/quicktime",subtype:"QuickTime",translationKey:"VIDEO_FILE_TYPE",type:"video"}],[".mkv",{extensions:[".mkv"],mime:"video/x-matroska",subtype:"MKV",translationKey:"VIDEO_FILE_TYPE",type:"video"}],[".mp4",{extensions:[".mp4",".m4v",".mpg4",".mpeg4"],mime:"video/mp4",subtype:"MPEG",translationKey:"VIDEO_FILE_TYPE",type:"video"}],[".m4v",{extensions:[".mp4",".m4v",".mpg4",".mpeg4"],mime:"video/mp4",subtype:"MPEG",translationKey:"VIDEO_FILE_TYPE",type:"video"}],[".mpg4",{extensions:[".mp4",".m4v",".mpg4",".mpeg4"],mime:"video/mp4",subtype:"MPEG",translationKey:"VIDEO_FILE_TYPE",type:"video"}],[".mpeg4",{extensions:[".mp4",".m4v",".mpg4",".mpeg4"],mime:"video/mp4",subtype:"MPEG",translationKey:"VIDEO_FILE_TYPE",type:"video"}],[".mpg",{extensions:[".mpg",".mpeg"],mime:"video/mpeg",subtype:"MPEG",translationKey:"VIDEO_FILE_TYPE",type:"video"}],[".mpeg",{extensions:[".mpg",".mpeg"],mime:"video/mpeg",subtype:"MPEG",translationKey:"VIDEO_FILE_TYPE",type:"video"}],[".ogm",{extensions:[".ogm",".ogv",".ogx"],mime:"video/ogg",subtype:"OGG",translationKey:"VIDEO_FILE_TYPE",type:"video"}],[".ogv",{extensions:[".ogm",".ogv",".ogx"],mime:"video/ogg",subtype:"OGG",translationKey:"VIDEO_FILE_TYPE",type:"video"}],[".ogx",{extensions:[".ogm",".ogv",".ogx"],mime:"video/ogg",subtype:"OGG",translationKey:"VIDEO_FILE_TYPE",type:"video"}],[".webm",{extensions:[".webm"],mime:"video/webm",subtype:"WebM",translationKey:"VIDEO_FILE_TYPE",type:"video"}],[".amr",{extensions:[".amr"],mime:"audio/amr",subtype:"AMR",translationKey:"AUDIO_FILE_TYPE",type:"audio"}],[".flac",{extensions:[".flac"],mime:"audio/flac",subtype:"FLAC",translationKey:"AUDIO_FILE_TYPE",type:"audio"}],[".mp3",{extensions:[".mp3"],mime:"audio/mpeg",subtype:"MP3",translationKey:"AUDIO_FILE_TYPE",type:"audio"}],[".m4a",{extensions:[".m4a"],mime:"audio/mp4a-latm",subtype:"MPEG",translationKey:"AUDIO_FILE_TYPE",type:"audio"}],[".oga",{extensions:[".oga",".ogg",".opus"],mime:"audio/ogg",subtype:"OGG",translationKey:"AUDIO_FILE_TYPE",type:"audio"}],[".ogg",{extensions:[".oga",".ogg",".opus"],mime:"audio/ogg",subtype:"OGG",translationKey:"AUDIO_FILE_TYPE",type:"audio"}],[".opus",{extensions:[".oga",".ogg",".opus"],mime:"audio/ogg",subtype:"OGG",translationKey:"AUDIO_FILE_TYPE",type:"audio"}],[".wav",{extensions:[".wav"],mime:"audio/x-wav",subtype:"WAV",translationKey:"AUDIO_FILE_TYPE",type:"audio"}],[".weba",{extensions:[".weba"],mime:"audio/webm",subtype:"WEBA",translationKey:"AUDIO_FILE_TYPE",type:"audio"}],[".txt",{extensions:[".txt",".text"],mime:"text/plain",subtype:"TXT",translationKey:"PLAIN_TEXT_FILE_TYPE",type:"text"}],[".text",{extensions:[".txt",".text"],mime:"text/plain",subtype:"TXT",translationKey:"PLAIN_TEXT_FILE_TYPE",type:"text"}],[".csv",{extensions:[".csv"],mime:"text/csv",subtype:"CSV",translationKey:"CSV_TEXT_FILE_TYPE",type:"text"}],[".zip",{extensions:[".zip"],mime:"application/zip",subtype:"ZIP",translationKey:"ARCHIVE_FILE_TYPE",type:"archive"}],[".rar",{extensions:[".rar"],mime:"application/x-rar-compressed",subtype:"RAR",translationKey:"ARCHIVE_FILE_TYPE",type:"archive"}],[".iso",{extensions:[".iso"],mime:"application/x-iso9660-image",subtype:"ISO",translationKey:"ARCHIVE_FILE_TYPE",type:"archive"}],[".7z",{extensions:[".7z"],mime:"application/x-7z-compressed",subtype:"7-Zip",translationKey:"ARCHIVE_FILE_TYPE",type:"archive"}],[".crx",{extensions:[".crx"],mime:"application/x-chrome-extension",subtype:"CRX",translationKey:"ARCHIVE_FILE_TYPE",type:"archive"}],[".tar",{extensions:[".tar"],mime:"application/x-tar",subtype:"TAR",translationKey:"ARCHIVE_FILE_TYPE",type:"archive"}],[".bz2",{extensions:[".bz2",".bz",".tbz",".tbz2",".tz2",".tb2"],mime:"application/x-bzip2",subtype:"BZIP2",translationKey:"ARCHIVE_FILE_TYPE",type:"archive"}],[".bz",{extensions:[".bz2",".bz",".tbz",".tbz2",".tz2",".tb2"],mime:"application/x-bzip2",subtype:"BZIP2",translationKey:"ARCHIVE_FILE_TYPE",type:"archive"}],[".tbz",{extensions:[".bz2",".bz",".tbz",".tbz2",".tz2",".tb2"],mime:"application/x-bzip2",subtype:"BZIP2",translationKey:"ARCHIVE_FILE_TYPE",type:"archive"}],[".tbz2",{extensions:[".bz2",".bz",".tbz",".tbz2",".tz2",".tb2"],mime:"application/x-bzip2",subtype:"BZIP2",translationKey:"ARCHIVE_FILE_TYPE",type:"archive"}],[".tz2",{extensions:[".bz2",".bz",".tbz",".tbz2",".tz2",".tb2"],mime:"application/x-bzip2",subtype:"BZIP2",translationKey:"ARCHIVE_FILE_TYPE",type:"archive"}],[".tb2",{extensions:[".bz2",".bz",".tbz",".tbz2",".tz2",".tb2"],mime:"application/x-bzip2",subtype:"BZIP2",translationKey:"ARCHIVE_FILE_TYPE",type:"archive"}],[".gz",{extensions:[".gz",".tgz"],mime:"application/x-gzip",subtype:"GZIP",translationKey:"ARCHIVE_FILE_TYPE",type:"archive"}],[".tgz",{extensions:[".gz",".tgz"],mime:"application/x-gzip",subtype:"GZIP",translationKey:"ARCHIVE_FILE_TYPE",type:"archive"}],[".lz",{extensions:[".lz"],mime:"application/x-lzip",subtype:"LZIP",translationKey:"ARCHIVE_FILE_TYPE",type:"archive"}],[".lzo",{extensions:[".lzo"],mime:"application/x-lzop",subtype:"LZOP",translationKey:"ARCHIVE_FILE_TYPE",type:"archive"}],[".lzma",{extensions:[".lzma",".tlzma",".tlz"],mime:"application/x-lzma",subtype:"LZMA",translationKey:"ARCHIVE_FILE_TYPE",type:"archive"}],[".tlzma",{extensions:[".lzma",".tlzma",".tlz"],mime:"application/x-lzma",subtype:"LZMA",translationKey:"ARCHIVE_FILE_TYPE",type:"archive"}],[".tlz",{extensions:[".lzma",".tlzma",".tlz"],mime:"application/x-lzma",subtype:"LZMA",translationKey:"ARCHIVE_FILE_TYPE",type:"archive"}],[".xz",{extensions:[".xz",".txz"],mime:"application/x-xz",subtype:"XZ",translationKey:"ARCHIVE_FILE_TYPE",type:"archive"}],[".txz",{extensions:[".xz",".txz"],mime:"application/x-xz",subtype:"XZ",translationKey:"ARCHIVE_FILE_TYPE",type:"archive"}],[".z",{extensions:[".z",".taz",".tz"],mime:"application/x-compress",subtype:"Z",translationKey:"ARCHIVE_FILE_TYPE",type:"archive"}],[".taz",{extensions:[".z",".taz",".tz"],mime:"application/x-compress",subtype:"Z",translationKey:"ARCHIVE_FILE_TYPE",type:"archive"}],[".tz",{extensions:[".z",".taz",".tz"],mime:"application/x-compress",subtype:"Z",translationKey:"ARCHIVE_FILE_TYPE",type:"archive"}],[".zst",{extensions:[".zst",".tzst"],mime:"application/zstd",subtype:"Zstandard",translationKey:"ARCHIVE_FILE_TYPE",type:"archive"}],[".tzst",{extensions:[".zst",".tzst"],mime:"application/zstd",subtype:"Zstandard",translationKey:"ARCHIVE_FILE_TYPE",type:"archive"}],[".gdoc",{extensions:[".gdoc"],icon:"gdoc",mime:"application/vnd.google-apps.document",subtype:"doc",translationKey:"GDOC_DOCUMENT_FILE_TYPE",type:"hosted"}],[".gsheet",{extensions:[".gsheet"],icon:"gsheet",mime:"application/vnd.google-apps.spreadsheet",subtype:"sheet",translationKey:"GSHEET_DOCUMENT_FILE_TYPE",type:"hosted"}],[".gslides",{extensions:[".gslides"],icon:"gslides",mime:"application/vnd.google-apps.presentation",subtype:"slides",translationKey:"GSLIDES_DOCUMENT_FILE_TYPE",type:"hosted"}],[".gdraw",{extensions:[".gdraw"],icon:"gdraw",mime:"application/vnd.google-apps.drawing",subtype:"draw",translationKey:"GDRAW_DOCUMENT_FILE_TYPE",type:"hosted"}],[".gtable",{extensions:[".gtable"],icon:"gtable",mime:"application/vnd.google-apps.fusiontable",subtype:"table",translationKey:"GTABLE_DOCUMENT_FILE_TYPE",type:"hosted"}],[".glink",{extensions:[".glink"],icon:"glink",mime:"application/vnd.google-apps.shortcut",subtype:"glink",translationKey:"GLINK_DOCUMENT_FILE_TYPE",type:"hosted"}],[".gform",{extensions:[".gform"],icon:"gform",mime:"application/vnd.google-apps.form",subtype:"form",translationKey:"GFORM_DOCUMENT_FILE_TYPE",type:"hosted"}],[".gmap",{extensions:[".gmap"],icon:"gmap",mime:"application/vnd.google-apps.map",subtype:"map",translationKey:"GMAP_DOCUMENT_FILE_TYPE",type:"hosted"}],[".gsite",{extensions:[".gsite"],icon:"gsite",mime:"application/vnd.google-apps.site",subtype:"site",translationKey:"GSITE_DOCUMENT_FILE_TYPE",type:"hosted"}],[".gmaillayout",{extensions:[".gmaillayout"],icon:"gmaillayout",mime:"application/vnd.google-apps.mail-layout",subtype:"emaillayouts",translationKey:"EMAIL_LAYOUTS_DOCUMENT_FILE_TYPE",type:"hosted"}],[".pdf",{extensions:[".pdf"],icon:"pdf",mime:"application/pdf",subtype:"PDF",translationKey:"PDF_DOCUMENT_FILE_TYPE",type:"document"}],[".htm",{extensions:[".htm",".html",".mht",".mhtml",".shtml",".xht",".xhtml"],mime:"text/html",subtype:"HTML",translationKey:"HTML_DOCUMENT_FILE_TYPE",type:"document"}],[".html",{extensions:[".htm",".html",".mht",".mhtml",".shtml",".xht",".xhtml"],mime:"text/html",subtype:"HTML",translationKey:"HTML_DOCUMENT_FILE_TYPE",type:"document"}],[".mht",{extensions:[".htm",".html",".mht",".mhtml",".shtml",".xht",".xhtml"],mime:"text/html",subtype:"HTML",translationKey:"HTML_DOCUMENT_FILE_TYPE",type:"document"}],[".mhtml",{extensions:[".htm",".html",".mht",".mhtml",".shtml",".xht",".xhtml"],mime:"text/html",subtype:"HTML",translationKey:"HTML_DOCUMENT_FILE_TYPE",type:"document"}],[".shtml",{extensions:[".htm",".html",".mht",".mhtml",".shtml",".xht",".xhtml"],mime:"text/html",subtype:"HTML",translationKey:"HTML_DOCUMENT_FILE_TYPE",type:"document"}],[".xht",{extensions:[".htm",".html",".mht",".mhtml",".shtml",".xht",".xhtml"],mime:"text/html",subtype:"HTML",translationKey:"HTML_DOCUMENT_FILE_TYPE",type:"document"}],[".xhtml",{extensions:[".htm",".html",".mht",".mhtml",".shtml",".xht",".xhtml"],mime:"text/html",subtype:"HTML",translationKey:"HTML_DOCUMENT_FILE_TYPE",type:"document"}],[".doc",{extensions:[".doc"],icon:"word",mime:"application/msword",subtype:"Word",translationKey:"WORD_DOCUMENT_FILE_TYPE",type:"document"}],[".docx",{extensions:[".docx"],icon:"word",mime:"application/vnd.openxmlformats-officedocument.wordprocessingml.document",subtype:"Word",translationKey:"WORD_DOCUMENT_FILE_TYPE",type:"document"}],[".ppt",{extensions:[".ppt"],icon:"ppt",mime:"application/vnd.ms-powerpoint",subtype:"PPT",translationKey:"POWERPOINT_PRESENTATION_FILE_TYPE",type:"document"}],[".pptx",{extensions:[".pptx"],icon:"ppt",mime:"application/vnd.openxmlformats-officedocument.presentationml.presentation",subtype:"PPT",translationKey:"POWERPOINT_PRESENTATION_FILE_TYPE",type:"document"}],[".xls",{extensions:[".xls"],icon:"excel",mime:"application/vnd.ms-excel",subtype:"Excel",translationKey:"EXCEL_FILE_TYPE",type:"document"}],[".xlsx",{extensions:[".xlsx"],icon:"excel",mime:"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet",subtype:"Excel",translationKey:"EXCEL_FILE_TYPE",type:"document"}],[".xlsm",{extensions:[".xlsm"],icon:"excel",mime:"application/vnd.ms-excel.sheet.macroEnabled.12",subtype:"Excel",translationKey:"EXCEL_FILE_TYPE",type:"document"}],[".tini",{extensions:[".tini"],icon:"tini",subtype:"TGZ",translationKey:"TINI_FILE_TYPE",type:"archive"}]]);const PLACEHOLDER={translationKey:"NO_EXTENSION_FILE_TYPE",type:"UNKNOWN",icon:"",subtype:"",extensions:undefined,mime:undefined,encrypted:undefined,originalMimeType:undefined};function getFinalExtension(fileName){if(!fileName){return""}const lowerCaseFileName=fileName.toLowerCase();const parts=lowerCaseFileName.split(".");if(parts.length===1){return""}if(parts.length===2){return`.${parts.pop()}`}const last=`.${parts.pop()}`;const secondLast=`.${parts.pop()}`;const doubleExtension=`${secondLast}${last}`;if(EXTENSION_TO_TYPE.has(doubleExtension)){return doubleExtension}return last}function getFileTypeForName(name){const extension=getFinalExtension(name);if(EXTENSION_TO_TYPE.has(extension)){return EXTENSION_TO_TYPE.get(extension)}if(extension===""){return PLACEHOLDER}return{translationKey:"GENERIC_FILE_TYPE",type:"UNKNOWN",subtype:extension.substr(1).toUpperCase(),icon:"",extensions:undefined,mime:undefined,encrypted:undefined,originalMimeType:undefined}}const DIRECTORY={translationKey:"FOLDER",type:".folder",icon:"folder",subtype:"",extensions:undefined,mime:undefined,encrypted:undefined,originalMimeType:undefined};function getType(entry,mimeType){if(entry.isDirectory){const volumeInfo=entry.volumeInfo;if(volumeInfo&&volumeInfo.diskFileSystemType){return{translationKey:"",type:"partition",subtype:volumeInfo.diskFileSystemType,icon:"",extensions:undefined,mime:undefined,encrypted:undefined,originalMimeType:undefined}}return DIRECTORY}return getFileTypeForName(entry.name)}function getIcon(entry,mimeType,rootType){if(entry&&"iconName"in entry){return entry.iconName}let icon;if(entry){const ventry=entry;const fileType=getType(ventry);const overridenIcon=getIconOverrides(ventry,rootType);icon=overridenIcon||fileType.icon||fileType.type}return icon||"unknown"}function getIconOverrides(entry,rootType){if(!rootType){return""}const overrides={[RootType.DOWNLOADS]:{"/Camera":"camera-folder","/Downloads":VolumeType.DOWNLOADS,"/PvmDefault":"plugin_vm"}};const root=overrides[rootType];if(!root){return""}return root[entry.fullPath]??""}function convertName(name){return"FileBrowser."+name}function callAPI(name,args){try{const method=chrome.metricsPrivate[name];method.apply(chrome.metricsPrivate,args)}catch(e){console.error(e.stack)}}function recordEnum(name,value,validValues){console.assert(validValues!==undefined);let index=validValues.indexOf(value);const boundaryValue=validValues.length;if(index<0||index>=boundaryValue){index=boundaryValue-1}const metricDescr={metricName:convertName(name),type:chrome.metricsPrivate.MetricTypeType.HISTOGRAM_LINEAR,min:1,max:boundaryValue-1,buckets:boundaryValue};callAPI("recordValue",[metricDescr,index])}const LEGACY_FILES_EXTENSION_ID="hhaomjibdihmijegdhdafkllkbggdgoj";const SWA_FILES_APP_HOST="file-manager";new URL(`chrome-extension://${LEGACY_FILES_EXTENSION_ID}`);new URL(`chrome://${SWA_FILES_APP_HOST}`);class PathComponent{constructor(name,url_,fakeEntry_){this.name=name;this.url_=url_;this.fakeEntry_=fakeEntry_}resolveEntry(){if(this.fakeEntry_){return Promise.resolve(this.fakeEntry_)}else{return new Promise(window.webkitResolveLocalFileSystemURL.bind(null,this.url_))}}getKey(){return this.url_}static computeComponentsFromEntry(entry,volumeManager){const replaceRootName=(url,newRoot)=>url.slice(0,url.length-"/root".length)+newRoot;const components=[];const locationInfo=volumeManager.getLocationInfo(entry);if(!locationInfo){return components}if(isFakeEntry(entry)){components.push(new PathComponent(getEntryLabel(locationInfo,entry),entry.toURL(),entry));return components}const volumeInfo=locationInfo.volumeInfo;if(!volumeInfo){return components}let displayRootUrl=volumeInfo.displayRoot.toURL();let displayRootFullPath=volumeInfo.displayRoot.fullPath;const prefixEntry=volumeInfo.prefixEntry;if(prefixEntry&&prefixEntry.rootType!==RootType.DRIVE_FAKE_ROOT){components.push(new PathComponent(prefixEntry.name,prefixEntry.toURL(),prefixEntry))}if(locationInfo.rootType===RootType.DRIVE_SHARED_WITH_ME){const match=entry.fullPath.match(/^\/\.(files|shortcut-targets)-by-id\/.+?\//);if(match){displayRootFullPath=match[0]}else{console.warn("Unexpected shared DriveFS path: ",entry.fullPath)}displayRootUrl=replaceRootName(displayRootUrl,displayRootFullPath);const sharedWithMeFakeEntry=volumeInfo.fakeEntries[RootType.DRIVE_SHARED_WITH_ME];if(sharedWithMeFakeEntry){components.push(new PathComponent(str("DRIVE_SHARED_WITH_ME_COLLECTION_LABEL"),sharedWithMeFakeEntry.toURL(),sharedWithMeFakeEntry))}}else if(locationInfo.rootType===RootType.SHARED_DRIVE){displayRootUrl=replaceRootName(displayRootUrl,SHARED_DRIVES_DIRECTORY_PATH);components.push(new PathComponent(getRootTypeLabel(locationInfo),displayRootUrl))}else if(locationInfo.rootType===RootType.COMPUTER){displayRootUrl=replaceRootName(displayRootUrl,COMPUTERS_DIRECTORY_PATH);components.push(new PathComponent(getRootTypeLabel(locationInfo),displayRootUrl))}else{components.push(new PathComponent(getRootTypeLabel(locationInfo),displayRootUrl))}let relativePath=entry.fullPath.slice(displayRootFullPath.length);if(entry.fullPath.startsWith(SHARED_DRIVES_DIRECTORY_PATH)){relativePath=entry.fullPath.slice(SHARED_DRIVES_DIRECTORY_PATH.length)}else if(entry.fullPath.startsWith(COMPUTERS_DIRECTORY_PATH)){relativePath=entry.fullPath.slice(COMPUTERS_DIRECTORY_PATH.length)}if(relativePath.indexOf("/")===0){relativePath=relativePath.slice(1)}if(relativePath.length===0){return components}let currentUrl=/^.+\/$/.test(displayRootUrl)?displayRootUrl.slice(0,displayRootUrl.length-1):displayRootUrl;const paths=relativePath.split("/");for(let i=0;i<paths.length;i++){currentUrl+="/"+encodeURIComponent(paths[i]);let path=paths[i];if(i===0&&locationInfo.rootType===RootType.DOWNLOADS){if(path==="Downloads"){path=str("DOWNLOADS_DIRECTORY_LABEL")}if(path==="PvmDefault"){path=str("PLUGIN_VM_DIRECTORY_LABEL")}if(path==="Camera"){path=str("CAMERA_DIRECTORY_LABEL")}}components.push(new PathComponent(path,currentUrl))}return components}}const slice$c=new Slice("currentDirectory");function getEmptySelection(keys=[]){return{keys:keys,dirCount:0,fileCount:0,hostedCount:0,offlineCachedCount:0,fileTasks:{tasks:[],defaultTask:undefined,policyDefaultHandlerStatus:undefined,status:PropStatus.STARTED}}}function hasDlpDisabledFiles(currentState){const content=currentState.currentDirectory?.content;if(!content){return false}for(const key of content.keys){const fileData=currentState.allEntries[key];if(!fileData){console.warn(`Missing entry: ${key}`);continue}if(fileData.metadata.isRestrictedForDestination){return true}}return false}slice$c.addReducer("set",changeDirectoryReducer);function changeDirectoryReducer(currentState,payload){if(payload.to){cacheEntries(currentState,[payload.to])}const{to:to,toKey:toKey}=payload;const key=toKey||to.toURL();const status=payload.status||PropStatus.STARTED;const fileData=currentState.allEntries[key];let selection=currentState.currentDirectory?.selection;if(!selection||currentState.currentDirectory?.key!==key){selection={keys:[],dirCount:0,fileCount:0,hostedCount:undefined,offlineCachedCount:0,fileTasks:{tasks:[],policyDefaultHandlerStatus:undefined,defaultTask:undefined,status:PropStatus.SUCCESS}}}let content=currentState.currentDirectory?.content;let hasDlpDisabledFiles=currentState.currentDirectory?.hasDlpDisabledFiles||false;if(!content||currentState.currentDirectory?.key!==key){content={keys:[],status:PropStatus.SUCCESS};hasDlpDisabledFiles=false}let currentDirectory={key:key,status:status,pathComponents:[],content:content,rootType:undefined,selection:selection,hasDlpDisabledFiles:hasDlpDisabledFiles};if(fileData){const{volumeManager:volumeManager}=window.fileManager;if(!volumeManager){debug(`VolumeManager not available yet.`);currentDirectory=currentState.currentDirectory||currentDirectory}else{const components=PathComponent.computeComponentsFromEntry(fileData.entry,volumeManager);currentDirectory.pathComponents=components.map((c=>({name:c.name,label:c.name,key:c.getKey()})));const locationInfo=volumeManager.getLocationInfo(fileData.entry);currentDirectory.rootType=locationInfo?.rootType}}return{...currentState,currentDirectory:currentDirectory}}slice$c.addReducer("set-selection",updateSelectionReducer);function updateSelectionReducer(currentState,payload){cacheEntries(currentState,payload.entries);const updatingToEmpty=payload.entries.length===0&&payload.selectedKeys.length===0;if(!currentState.currentDirectory){if(!updatingToEmpty){console.warn("Missing `currentDirectory`");debug("Dropping action:",payload)}return currentState}if(!currentState.currentDirectory.content){if(!updatingToEmpty){console.warn("Missing `currentDirectory.content`");debug("Dropping action:",payload)}return currentState}const selectedKeys=payload.selectedKeys;const contentKeys=new Set(currentState.currentDirectory.content.keys);const missingKeys=selectedKeys.filter((k=>!contentKeys.has(k)));if(missingKeys.length>0){console.warn("Got selected keys that are not in current directory, "+"continuing anyway");debug(`Missing keys: ${missingKeys.join("\n")} \nexisting keys:\n ${(currentState.currentDirectory?.content?.keys??[]).join("\n")}`)}const selection=getEmptySelection(selectedKeys);for(const key of selectedKeys){const fileData=currentState.allEntries[key];if(!fileData){console.warn(`Missing entry: ${key}`);continue}if(fileData.isDirectory){selection.dirCount++}else{selection.fileCount++}const metadata=fileData.metadata;const isHosted=metadata?.hosted;if(isHosted===undefined){selection.hostedCount=undefined}else{if(selection.hostedCount!==undefined&&isHosted){selection.hostedCount++}}const isOfflineCached=metadata?.availableOffline===undefined||metadata?.availableOffline;if(isOfflineCached){selection.offlineCachedCount++}}const currentDirectory={...currentState.currentDirectory,selection:selection};return{...currentState,currentDirectory:currentDirectory}}slice$c.addReducer("set-file-tasks",updateFileTasksReducer);function updateFileTasksReducer(currentState,payload){const initialSelection=currentState.currentDirectory?.selection??getEmptySelection();const fileTasks={...initialSelection.fileTasks,...payload};const selection={...initialSelection,fileTasks:fileTasks};const currentDirectory={...currentState.currentDirectory,selection:selection};return{...currentState,currentDirectory:currentDirectory}}slice$c.addReducer("update-content",updateDirectoryContentReducer);function updateDirectoryContentReducer(currentState,payload){if(payload.entries){cacheEntries(currentState,payload.entries)}if(!currentState.currentDirectory){console.warn("Missing `currentDirectory`");return currentState}const initialContent=currentState.currentDirectory?.content??{keys:[]};const status=payload.status;const keys=(payload.entries??[]).map((e=>e.toURL()));const content={...initialContent,keys:keys,status:status};let currentDirectory={...currentState.currentDirectory,content:content};const newState={...currentState,currentDirectory:currentDirectory};currentDirectory={...currentDirectory,hasDlpDisabledFiles:hasDlpDisabledFiles(newState)};return{...newState,currentDirectory:currentDirectory}}combine1Selector((currentDir=>currentDir?.content),slice$c.selector);const slice$b=new Slice("allEntries");const clearCachedEntries=slice$b.addReducer("clear-stale-cache",clearCachedEntriesReducer);function clearCachedEntriesReducer(state){const entries=state.allEntries;const currentDirectoryKey=state.currentDirectory?.key;const entriesToKeep=new Set;if(currentDirectoryKey){entriesToKeep.add(currentDirectoryKey);for(const component of state.currentDirectory.pathComponents){entriesToKeep.add(component.key)}for(const key of state.currentDirectory.content.keys){entriesToKeep.add(key)}}const selectionKeys=state.currentDirectory?.selection.keys??[];if(selectionKeys){for(const key of selectionKeys){entriesToKeep.add(key)}}for(const volume of Object.values(state.volumes)){if(!volume.rootKey){continue}entriesToKeep.add(volume.rootKey);if(volume.prefixKey){entriesToKeep.add(volume.prefixKey)}}for(const key of state.uiEntries){entriesToKeep.add(key)}for(const key of state.folderShortcuts){entriesToKeep.add(key)}for(const root of state.navigation.roots){entriesToKeep.add(root.key)}for(const fileData of Object.values(entries)){if(fileData.expanded){if(fileData.children){for(const child of fileData.children){entriesToKeep.add(child)}}}}for(const key of entriesToKeep){const fileData=entries[key];if(fileData?.children){for(const child of fileData.children){entriesToKeep.add(child)}}}const isDebugStore=isDebugStoreEnabled();for(const key of Object.keys(entries)){if(entriesToKeep.has(key)){continue}delete entries[key];if(isDebugStore){console.info(`Clear entry: ${key}`)}}return state}function scheduleClearCachedEntries(){if(clearCachedEntriesRequestId===0){const options=window.IN_TEST?{timeout:50}:{};clearCachedEntriesRequestId=requestIdleCallback(startClearCache,options)}}let clearCachedEntriesRequestId=0;function startClearCache(){const store=getStore();store.dispatch(clearCachedEntries());clearCachedEntriesRequestId=0}const prefetchPropertyNames=Array.from(new Set([...LIST_CONTAINER_METADATA_PREFETCH_PROPERTY_NAMES,...ACTIONS_MODEL_METADATA_PREFETCH_PROPERTY_NAMES,...FILE_SELECTION_METADATA_PREFETCH_PROPERTY_NAMES,...DLP_METADATA_PREFETCH_PROPERTY_NAMES]));function getEntryIcon(entry,locationInfo,volumeType){const url=entry.toURL();const urlToIconPath={[recentRootKey]:ICON_TYPES.RECENT,[myFilesEntryListKey]:ICON_TYPES.MY_FILES,[driveRootEntryListKey]:ICON_TYPES.SERVICE_DRIVE};if(urlToIconPath[url]){return urlToIconPath[url]}const grandRootPathToIconMap={[COMPUTERS_DIRECTORY_PATH]:ICON_TYPES.COMPUTERS_GRAND_ROOT,[SHARED_DRIVES_DIRECTORY_PATH]:ICON_TYPES.SHARED_DRIVES_GRAND_ROOT};if(volumeType===VolumeType.DRIVE&&grandRootPathToIconMap[entry.fullPath]){return grandRootPathToIconMap[entry.fullPath]}if("rootType"in entry&&entry.rootType===RootType.REMOVABLE){return ICON_TYPES.USB}if(isVolumeEntry(entry)&&entry.volumeInfo){switch(entry.volumeInfo.volumeType){case VolumeType.DOWNLOADS:return ICON_TYPES.MY_FILES;case VolumeType.SMB:return ICON_TYPES.SMB;case VolumeType.PROVIDED:case VolumeType.DOCUMENTS_PROVIDER:{const iconSet=entry.volumeInfo.iconSet;if(iconSet){const backgroundImage=iconSetToCSSBackgroundImageValue(entry.volumeInfo.iconSet);if(backgroundImage!=="none"){return iconSet}}if(volumeType&&shouldProvideIcons(volumeType)){return ICON_TYPES.GENERIC}return""}case VolumeType.MTP:return ICON_TYPES.MTP;case VolumeType.ARCHIVE:return ICON_TYPES.ARCHIVE;case VolumeType.REMOVABLE:return entry.volumeInfo.prefixEntry?ICON_TYPES.UNKNOWN_REMOVABLE:ICON_TYPES.USB;case VolumeType.DRIVE:return ICON_TYPES.DRIVE}}return getIcon(entry,undefined,locationInfo?.rootType)}function isVolumeSlowToScan(volume){return volume?.source===Source.NETWORK&&volume.volumeType===VolumeType.SMB}function convertEntryToFileData(entry){const{volumeManager:volumeManager,metadataModel:metadataModel}=window.fileManager;const volumeInfo=isVolumeEntry(entry)?entry.volumeInfo:volumeManager.getVolumeInfo(entry);const locationInfo=volumeManager.getLocationInfo(entry);const label=getEntryLabel(locationInfo,entry);const volumeType="volumeType"in entry&&entry.volumeType?entry.volumeType:volumeInfo?.volumeType||null;const volumeId=volumeInfo?.volumeId||null;const icon=getEntryIcon(entry,locationInfo,volumeType);if("disabled"in entry&&volumeType){entry.disabled=volumeManager.isDisabled(volumeType)}const metadata=metadataModel?metadataModel.getCache([entry],prefetchPropertyNames)[0]:{};const fileData={key:entry.toURL(),fullPath:entry.fullPath,entry:entry,icon:icon,type:getEntryType(entry),isDirectory:entry.isDirectory,label:label,volumeId:volumeId,rootType:locationInfo?.rootType??null,metadata:metadata,expanded:false,disabled:"disabled"in entry?entry.disabled:false,isRootEntry:!!locationInfo?.isRootEntry,canExpand:false,isEjectable:false,children:[]};fileData.canExpand=isVolumeSlowToScan(volumeInfo);return fileData}function appendEntry(state,entry){const allEntries=state.allEntries||{};const key=entry.toURL();const existingFileData=allEntries[key]||{};if(existingFileData.type===EntryType.VOLUME_ROOT&&getEntryType(entry)!==EntryType.VOLUME_ROOT){return}const fileData=convertEntryToFileData(entry);allEntries[key]={...fileData,expanded:existingFileData.expanded??fileData.expanded,isEjectable:existingFileData.isEjectable??fileData.isEjectable,canExpand:existingFileData.canExpand??fileData.canExpand,children:existingFileData.children??fileData.children,key:key};state.allEntries=allEntries}function updateFileDataInPlace(state,key,changes){if(!state.allEntries[key]){console.warn(`Entry FileData not found in the store: ${key}`);return}const newFileData={...state.allEntries[key],...changes,key:key};state.allEntries[key]=newFileData;return newFileData}function cacheEntries(currentState,entries){scheduleClearCachedEntries();for(const entry of entries){appendEntry(currentState,entry)}}function getEntryType(entry){if(!("typeName"in entry)){return EntryType.FS_API}switch(entry.typeName){case"EntryList":return EntryType.ENTRY_LIST;case"VolumeEntry":return EntryType.VOLUME_ROOT;case"FakeEntry":switch(entry.rootType){case RootType.RECENT:return EntryType.RECENT;case RootType.TRASH:return EntryType.TRASH;case RootType.DRIVE_FAKE_ROOT:return EntryType.ENTRY_LIST;case RootType.CROSTINI:case RootType.ANDROID_FILES:return EntryType.PLACEHOLDER;case RootType.DRIVE_OFFLINE:case RootType.DRIVE_SHARED_WITH_ME:return EntryType.RECENT;case RootType.PROVIDED:return EntryType.PLACEHOLDER}console.warn(`Invalid fakeEntry.rootType='${entry.rootType} rootType`);return EntryType.PLACEHOLDER;case"GuestOsPlaceholder":return EntryType.PLACEHOLDER;case"TrashEntry":return EntryType.TRASH;case"OneDrivePlaceholder":return EntryType.PLACEHOLDER;default:console.warn(`Invalid entry.typeName='${entry.typeName}`);return EntryType.FS_API}}slice$b.addReducer("update-metadata",updateMetadataReducer);function updateMetadataReducer(currentState,payload){cacheEntries(currentState,payload.metadata.map((m=>m.entry)));for(const entryMetadata of payload.metadata){const key=entryMetadata.entry.toURL();const fileData=currentState.allEntries[key];const metadata={...fileData.metadata,...entryMetadata.metadata};currentState.allEntries[key]={...fileData,metadata:metadata,key:key}}if(!currentState.currentDirectory){console.warn("Missing `currentDirectory`");return currentState}const currentDirectory={...currentState.currentDirectory,hasDlpDisabledFiles:hasDlpDisabledFiles(currentState)};return{...currentState,currentDirectory:currentDirectory}}function findVolumeByType(volumes,volumeType){return Object.values(volumes).find((v=>v.rootKey&&v.volumeType===volumeType))??null}function getMyFiles(state){const localFilesAllowed=state.preferences?.localUserFilesAllowed!==false;if(!isSkyvaultV2Enabled()){if(!localFilesAllowed){return{myFilesEntry:null,myFilesVolume:null}}}const{volumes:volumes}=state;const myFilesVolume=findVolumeByType(volumes,VolumeType.DOWNLOADS);const myFilesVolumeEntry=myFilesVolume?getEntry(state,myFilesVolume.rootKey):null;let myFilesEntryList=getEntry(state,myFilesEntryListKey);if(localFilesAllowed&&!myFilesVolumeEntry&&!myFilesEntryList){myFilesEntryList=new EntryList(str("MY_FILES_ROOT_LABEL"),RootType.MY_FILES);appendEntry(state,myFilesEntryList);state.uiEntries=[...state.uiEntries,myFilesEntryList.toURL()]}if(isSkyvaultV2Enabled()&&!localFilesAllowed&&!myFilesVolume){return{myFilesEntry:null,myFilesVolume:myFilesVolume}}return{myFilesEntry:myFilesVolumeEntry||myFilesEntryList,myFilesVolume:myFilesVolume}}slice$b.addReducer("add-children",addChildEntriesReducer);function addChildEntriesReducer(currentState,payload){cacheEntries(currentState,payload.entries);const{parentKey:parentKey,entries:entries}=payload;const{allEntries:allEntries}=currentState;if(!allEntries[parentKey]){return currentState}const newEntryKeys=entries.map((entry=>entry.toURL()));const parentFileData={...allEntries[parentKey],children:newEntryKeys,canExpand:newEntryKeys.length>0};return{...currentState,allEntries:{...allEntries,[parentKey]:parentFileData}}}slice$b.addReducer("update-file-data",updateFileDataReducer);function updateFileDataReducer(currentState,payload){const{key:key,partialFileData:partialFileData}=payload;const fileData=getFileData(currentState,key);if(!fileData){return currentState}currentState.allEntries[key]={...fileData,...partialFileData,key:key};return{...currentState}}const slice$a=new Slice("androidApps");slice$a.addReducer("add",addAndroidAppsReducer);function addAndroidAppsReducer(currentState,payload){const androidApps={};for(const app of payload.apps){let icon=ICON_TYPES.GENERIC;if(app.iconSet){const backgroundImage=iconSetToCSSBackgroundImageValue(app.iconSet);if(backgroundImage!=="none"){icon=app.iconSet}}androidApps[app.packageName]={...app,icon:icon}}return{...currentState,androidApps:androidApps}}const slice$9=new Slice("bulkPinning");slice$9.addReducer("set-progress",((state,bulkPinning)=>({...state,bulkPinning:bulkPinning})));const slice$8=new Slice("device");const updateDeviceConnectionState=slice$8.addReducer("set-connection-state",updateDeviceConnectionStateReducer$1);function updateDeviceConnectionStateReducer$1(currentState,payload){let device;if(payload.connection!==currentState.device.connection){device={...currentState.device,connection:payload.connection}}return device?{...currentState,device:device}:currentState}const slice$7=new Slice("drive");slice$7.addReducer("set-drive-connection-status",updateDriveConnectionStatusReducer);function updateDriveConnectionStatusReducer(currentState,payload){const drive={...currentState.drive};if(payload.type!==currentState.drive.connectionType){drive.connectionType=payload.type}if(payload.type===chrome.fileManagerPrivate.DriveConnectionStateType.OFFLINE&&payload.reason!==currentState.drive.offlineReason){drive.offlineReason=payload.reason}else{drive.offlineReason=undefined}return{...currentState,drive:drive}}const slice$6=new Slice("folderShortcuts");slice$6.addReducer("refresh",refreshFolderShortcutReducer);function refreshFolderShortcutReducer(currentState,payload){cacheEntries(currentState,payload.entries);return{...currentState,folderShortcuts:payload.entries.map((entry=>entry.toURL()))}}slice$6.addReducer("add",addFolderShortcutReducer);function addFolderShortcutReducer(currentState,payload){cacheEntries(currentState,[payload.entry]);const{entry:entry}=payload;const key=entry.toURL();const{folderShortcuts:folderShortcuts}=currentState;for(let i=0;i<folderShortcuts.length;i++){if(key===folderShortcuts[i]){return currentState}const shortcutEntry=getEntry(currentState,folderShortcuts[i]);if(comparePath(shortcutEntry,entry)>0){return{...currentState,folderShortcuts:[...folderShortcuts.slice(0,i),key,...folderShortcuts.slice(i)]}}}return{...currentState,folderShortcuts:folderShortcuts.concat(key)}}slice$6.addReducer("remove",removeFolderShortcutReducer);function removeFolderShortcutReducer(currentState,payload){const{key:key}=payload;const{folderShortcuts:folderShortcuts}=currentState;const isExisted=folderShortcuts.find((k=>k===key));if(!isExisted){return currentState}return{...currentState,folderShortcuts:folderShortcuts.filter((k=>k!==key))}}const slice$5=new Slice("launchParams");function launchParamsReducer(state,launchParams){const storedLaunchParams=state.launchParams||{};if(launchParams.dialogType!==storedLaunchParams.dialogType){return{...state,launchParams:launchParams}}return state}slice$5.addReducer("set",launchParamsReducer);const slice$4=new Slice("navigation");const sections=new Map;sections.set(VolumeType.DOWNLOADS,NavigationSection.MY_FILES);sections.set(VolumeType.DRIVE,NavigationSection.CLOUD);sections.set(VolumeType.SMB,NavigationSection.CLOUD);sections.set(VolumeType.PROVIDED,NavigationSection.CLOUD);sections.set(VolumeType.DOCUMENTS_PROVIDER,NavigationSection.CLOUD);sections.set(VolumeType.REMOVABLE,NavigationSection.REMOVABLE);sections.set(VolumeType.MTP,NavigationSection.REMOVABLE);sections.set(VolumeType.ARCHIVE,NavigationSection.REMOVABLE);function getPrefixEntryOrEntry(state,volume){if(volume.prefixKey){const entry=getEntry(state,volume.prefixKey);return entry}if(volume.volumeType===VolumeType.DOWNLOADS){return getMyFiles(state).myFilesEntry}const entry=getEntry(state,volume.rootKey);return entry}slice$4.addReducer("refresh-roots",refreshNavigationRootsReducer);function refreshNavigationRootsReducer(currentState){const{navigation:{roots:previousRoots},folderShortcuts:folderShortcuts,androidApps:androidApps}=currentState;const roots=[];const processedEntryKeys=new Set;const recentRoot=previousRoots.find((root=>root.key===recentRootKey));if(recentRoot){roots.push(recentRoot);processedEntryKeys.add(recentRootKey)}else{const recentEntry=getEntry(currentState,recentRootKey);if(recentEntry){roots.push({key:recentRootKey,section:NavigationSection.TOP,separator:false,type:NavigationType.RECENT});processedEntryKeys.add(recentRootKey)}}folderShortcuts.forEach((shortcutKey=>{const shortcutEntry=getEntry(currentState,shortcutKey);if(shortcutEntry){roots.push({key:shortcutKey,section:NavigationSection.TOP,separator:false,type:NavigationType.SHORTCUT});processedEntryKeys.add(shortcutKey)}}));const{myFilesEntry:myFilesEntry,myFilesVolume:myFilesVolume}=getMyFiles(currentState);if(myFilesEntry){roots.push({key:myFilesEntry.toURL(),section:NavigationSection.MY_FILES,separator:processedEntryKeys.size>0,type:myFilesVolume?NavigationType.VOLUME:NavigationType.ENTRY_LIST});processedEntryKeys.add(myFilesEntry.toURL())}const driveEntryKeyExist=currentState.uiEntries.includes(driveRootEntryListKey);const driveEntry=getEntry(currentState,driveRootEntryListKey);if(driveEntryKeyExist&&driveEntry){roots.push({key:driveEntry.toURL(),section:NavigationSection.GOOGLE_DRIVE,separator:true,type:NavigationType.DRIVE});processedEntryKeys.add(driveEntry.toURL())}if(isSkyvaultV2Enabled()){const oneDriveUIEntryExists=currentState.uiEntries.includes(oneDriveFakeRootKey);const oneDriveVolumeExists=Object.values(currentState.volumes).find((v=>isOneDrive(v)))!==undefined;if(oneDriveUIEntryExists&&!oneDriveVolumeExists){roots.push({key:oneDriveFakeRootKey,section:NavigationSection.ODFS,separator:true,type:NavigationType.VOLUME});processedEntryKeys.add(oneDriveFakeRootKey)}}const volumesOrder={[VolumeType.SMB]:1,[VolumeType.PROVIDED]:2,[VolumeType.DOCUMENTS_PROVIDER]:3,[VolumeType.REMOVABLE]:4,[VolumeType.ARCHIVE]:5,[VolumeType.MTP]:6};const{volumeManager:volumeManager}=window.fileManager;const filteredVolumes=Object.values(currentState.volumes).filter((volume=>{const volumeEntry=getEntry(currentState,volume.rootKey);return volumeManager.isAllowedVolume(volumeEntry.volumeInfo)}));function getVolumeOrder(volume){if(isOneDriveId(volume.providerId)){return 0}return volumesOrder[volume.volumeType]??999}const volumes=filteredVolumes.filter((v=>v.rootKey&&!(v.volumeType===VolumeType.DOWNLOADS||v.volumeType===VolumeType.DRIVE||v.volumeType===VolumeType.MEDIA_VIEW))).sort(((v1,v2)=>{const v1Order=getVolumeOrder(v1);const v2Order=getVolumeOrder(v2);return v1Order-v2Order}));let lastSection=null;for(const volume of volumes){const volumeEntry=getPrefixEntryOrEntry(currentState,volume);if(volumeEntry&&!processedEntryKeys.has(volumeEntry.toURL())){let section=sections.get(volume.volumeType)??NavigationSection.REMOVABLE;if(isOneDriveId(volume.providerId)){section=NavigationSection.ODFS}const isSectionStart=section!==lastSection;roots.push({key:volumeEntry.toURL(),section:section,separator:isSectionStart,type:NavigationType.VOLUME});processedEntryKeys.add(volumeEntry.toURL());lastSection=section}}Object.values(androidApps).forEach(((app,index)=>{roots.push({key:app.packageName,section:NavigationSection.ANDROID_APPS,separator:index===0,type:NavigationType.ANDROID_APPS});processedEntryKeys.add(app.packageName)}));const{dialogType:dialogType}=window.fileManager;const shouldShowTrash=dialogType===DialogType.FULL_PAGE&&!volumeManager.getMediaStoreFilesOnlyFilterEnabled();const trashEntryKeyExist=currentState.uiEntries.includes(trashRootKey);const trashEntry=getEntry(currentState,trashRootKey);if(shouldShowTrash&&trashEntryKeyExist&&trashEntry){roots.push({key:trashRootKey,section:NavigationSection.TRASH,separator:true,type:NavigationType.TRASH});processedEntryKeys.add(trashRootKey)}return{...currentState,navigation:{roots:roots}}}const slice$3=new Slice("preferences");function isPreferencesChange(payload){if(payload.driveEnabled!==undefined){return false}return true}function updateIfDefined(updatedPreferences,newPreferences,key){if(!(key in newPreferences)||newPreferences[key]===undefined){return false}if(updatedPreferences[key]===newPreferences[key]){return false}updatedPreferences[key]=newPreferences[key];return true}slice$3.addReducer("set",updatePreferencesReducer);function updatePreferencesReducer(currentState,payload){const preferences=payload;if(!isPreferencesChange(preferences)){return{...currentState,preferences:preferences}}const updatedPreferences={...currentState.preferences};const keysToCheck=["driveSyncEnabledOnMeteredNetwork","arcEnabled","arcRemovableMediaAccessEnabled","folderShortcuts","driveFsBulkPinningEnabled"];let updated=false;for(const key of keysToCheck){updated=updateIfDefined(updatedPreferences,preferences,key)||updated}if(!updated){return currentState}return{...currentState,preferences:updatedPreferences}}const slice$2=new Slice("search");function isSearchEmpty(search){return Object.values(search).every((f=>f===undefined))}function optionsChanged(stored,fresh){if(fresh===undefined){return false}if(stored===undefined){return true}return fresh.location!==stored.location||fresh.recency!==stored.recency||fresh.fileCategory!==stored.fileCategory}slice$2.addReducer("set",searchReducer);function searchReducer(state,payload){const blankSearch={query:undefined,status:undefined,options:undefined};if(isSearchEmpty(payload)){if(state.search&&!isSearchEmpty(state.search)){return{...state,search:blankSearch}}return state}const currentSearch=state.search||blankSearch;const search={...currentSearch};let changed=false;if(payload.query!==undefined&&payload.query!==currentSearch.query){search.query=payload.query;changed=true}if(payload.status!==undefined&&payload.status!==currentSearch.status){search.status=payload.status;changed=true}if(optionsChanged(currentSearch.options,payload.options)){search.options={...payload.options};changed=true}return changed?{...state,search:search}:state}const slice$1=new Slice("uiEntries");new Set([RootType.ANDROID_FILES,RootType.CROSTINI,RootType.GUEST_OS]);slice$1.addReducer("add",addUiEntryReducer);function addUiEntryReducer(currentState,payload){cacheEntries(currentState,[payload.entry]);const{entry:entry}=payload;const key=entry.toURL();const uiEntries=[...currentState.uiEntries,key];return{...currentState,uiEntries:uiEntries}}slice$1.addReducer("remove",removeUiEntryReducer);function removeUiEntryReducer(currentState,payload){const{key:key}=payload;const uiEntries=currentState.uiEntries.filter((k=>k!==key));return{...currentState,uiEntries:uiEntries}}function getStore(){if(!window.store){window.store=new BaseStore(getEmptyState(),[slice$2,slice,slice$9,slice$1,slice$a,slice$6,slice$4,slice$3,slice$8,slice$7,slice$c,slice$b,slice$5])}return window.store}function getEmptyState(){return{allEntries:{},currentDirectory:undefined,device:{connection:chrome.fileManagerPrivate.DeviceConnectionState.ONLINE},drive:{connectionType:chrome.fileManagerPrivate.DriveConnectionStateType.ONLINE,offlineReason:undefined},search:{query:undefined,status:undefined,options:undefined},navigation:{roots:[]},volumes:{},uiEntries:[],folderShortcuts:[],androidApps:{},bulkPinning:undefined,preferences:undefined,launchParams:{dialogType:undefined}}}function getFileData(state,key){const fileData=state.allEntries[key];if(fileData){return fileData}return null}function getEntry(state,key){const fileData=state.allEntries[key];return fileData?.entry??null}const slice=new Slice("volumes");const myFilesEntryListKey=`entry-list://${RootType.MY_FILES}`;`fake-entry://${RootType.CROSTINI}`;`fake-entry://${RootType.DRIVE_FAKE_ROOT}`;const recentRootKey=`fake-entry://${RootType.RECENT}/all`;const trashRootKey=`fake-entry://${RootType.TRASH}`;const driveRootEntryListKey=`entry-list://${RootType.DRIVE_FAKE_ROOT}`;const oneDriveFakeRootKey=`fake-entry://${RootType.PROVIDED}/${ODFS_EXTENSION_ID}`;const makeRemovableParentKey=volume=>{if(volume.devicePath){return`entry-list://${RootType.REMOVABLE}/${volume.devicePath}`}return`entry-list://${RootType.REMOVABLE}`};const removableGroupKey=volume=>`${volume.devicePath}/${volume.driveLabel}`;function getVolumeTypesNestedInMyFiles(){const myFilesNestedVolumeTypes=new Set([VolumeType.ANDROID_FILES,VolumeType.CROSTINI]);if(isGuestOsEnabled()){myFilesNestedVolumeTypes.add(VolumeType.GUEST_OS)}return myFilesNestedVolumeTypes}function convertVolumeInfoAndMetadataToVolume(volumeInfo,volumeMetadata){const volumeRootKey=volumeInfo.displayRoot.toURL();return{volumeId:volumeMetadata.volumeId,volumeType:volumeMetadata.volumeType,rootKey:volumeRootKey,status:PropStatus.SUCCESS,label:volumeInfo.label,error:volumeMetadata.mountCondition,deviceType:volumeMetadata.deviceType,devicePath:volumeMetadata.devicePath,isReadOnly:volumeMetadata.isReadOnly,isReadOnlyRemovableDevice:volumeMetadata.isReadOnlyRemovableDevice,providerId:volumeMetadata.providerId,configurable:volumeMetadata.configurable,watchable:volumeMetadata.watchable,source:volumeMetadata.source,diskFileSystemType:volumeMetadata.diskFileSystemType,iconSet:volumeMetadata.iconSet,driveLabel:volumeMetadata.driveLabel,vmType:volumeMetadata.vmType,isDisabled:false,prefixKey:undefined,isInteractive:true}}function updateVolume(state,volumeId,changes){const volume=state.volumes[volumeId];if(!volume){console.warn(`Volume not found in the store: ${volumeId}`);return}return{...volume,...changes}}function appendChildIfNotExisted(parentEntry,childEntry){if(!parentEntry.getUiChildren().find((entry=>isSameEntry(entry,childEntry)))){parentEntry.addEntry(childEntry);return true}return false}function shouldGroupRemovable(volumes,volumeInfo,volumeMetadata){if(isSinglePartitionFormatEnabled()){return true}const groupingKey=removableGroupKey(volumeMetadata);return Object.values(volumes).some((v=>v.volumeType===VolumeType.REMOVABLE&&removableGroupKey(v)===groupingKey&&v.volumeId!==volumeInfo.volumeId))}slice.addReducer("add",addVolumeReducer);function addVolumeReducer(currentState,payload){const{volumeMetadata:volumeMetadata,volumeInfo:volumeInfo}=payload;const newVolumeEntry=new VolumeEntry(payload.volumeInfo);cacheEntries(currentState,[newVolumeEntry]);const volumeRootKey=newVolumeEntry.toURL();currentState.allEntries[volumeRootKey]={...currentState.allEntries[volumeRootKey],isEjectable:volumeInfo.source===Source.DEVICE&&volumeInfo.volumeType!==VolumeType.MTP||volumeInfo.source===Source.FILE};const volume=convertVolumeInfoAndMetadataToVolume(volumeInfo,volumeMetadata);volume.isDisabled=!!newVolumeEntry.disabled;const myFilesNestedVolumeTypes=getVolumeTypesNestedInMyFiles();const{myFilesEntry:myFilesEntry}=getMyFiles(currentState);if(myFilesEntry&&myFilesNestedVolumeTypes.has(volume.volumeType)){volume.prefixKey=myFilesEntry.toURL();const uiEntryPlaceholder=myFilesEntry.getUiChildren().find((childEntry=>childEntry.name===newVolumeEntry.name));if(uiEntryPlaceholder){myFilesEntry.removeChildEntry(uiEntryPlaceholder)}appendChildIfNotExisted(myFilesEntry,newVolumeEntry)}if(volume.volumeType===VolumeType.DOWNLOADS){for(const v of Object.values(currentState.volumes)){if(myFilesNestedVolumeTypes.has(v.volumeType)){v.prefixKey=volumeRootKey}}const myFilesEntryList=getEntry(currentState,myFilesEntryListKey);if(myFilesEntryList){const uiChildren=[...myFilesEntryList.getUiChildren()];for(const childEntry of uiChildren){appendChildIfNotExisted(newVolumeEntry,childEntry);myFilesEntryList.removeChildEntry(childEntry)}currentState.uiEntries=currentState.uiEntries.filter((uiEntryKey=>uiEntryKey!==myFilesEntryListKey))}}if(volume.volumeType===VolumeType.DRIVE){let driveFakeRoot=getEntry(currentState,driveRootEntryListKey);if(!driveFakeRoot){driveFakeRoot=new EntryList(str("DRIVE_DIRECTORY_LABEL"),RootType.DRIVE_FAKE_ROOT);cacheEntries(currentState,[driveFakeRoot])}if(!currentState.uiEntries.includes(driveFakeRoot.toURL())){currentState.uiEntries=[...currentState.uiEntries,driveFakeRoot.toURL()]}driveFakeRoot.removeAllChildren();driveFakeRoot.addEntry(newVolumeEntry);const{sharedDriveDisplayRoot:sharedDriveDisplayRoot,computersDisplayRoot:computersDisplayRoot,fakeEntries:fakeEntries}=volumeInfo;if(sharedDriveDisplayRoot){cacheEntries(currentState,[sharedDriveDisplayRoot]);driveFakeRoot.addEntry(sharedDriveDisplayRoot)}if(computersDisplayRoot){cacheEntries(currentState,[computersDisplayRoot]);driveFakeRoot.addEntry(computersDisplayRoot)}const fakeSharedWithMe=fakeEntries[RootType.DRIVE_SHARED_WITH_ME];if(fakeSharedWithMe){cacheEntries(currentState,[fakeSharedWithMe]);currentState.uiEntries=[...currentState.uiEntries,fakeSharedWithMe.toURL()];driveFakeRoot.addEntry(fakeSharedWithMe)}const fakeOffline=fakeEntries[RootType.DRIVE_OFFLINE];if(fakeOffline){cacheEntries(currentState,[fakeOffline]);currentState.uiEntries=[...currentState.uiEntries,fakeOffline.toURL()];driveFakeRoot.addEntry(fakeOffline)}volume.prefixKey=driveFakeRoot.toURL()}if(volume.volumeType===VolumeType.REMOVABLE){const groupingKey=removableGroupKey(volumeMetadata);const shouldGroup=shouldGroupRemovable(currentState.volumes,volumeInfo,volumeMetadata);if(shouldGroup){const parentKey=makeRemovableParentKey(volumeMetadata);let parentEntry=getEntry(currentState,parentKey);if(!parentEntry){parentEntry=new EntryList(volumeMetadata.driveLabel||"",RootType.REMOVABLE,volumeMetadata.devicePath);cacheEntries(currentState,[parentEntry]);currentState.uiEntries=[...currentState.uiEntries,parentEntry.toURL()]}Object.values(currentState.volumes).filter((v=>v.volumeType===VolumeType.REMOVABLE&&removableGroupKey(v)===groupingKey)).forEach((v=>{const fileData=getFileData(currentState,v.rootKey);if(!fileData||!fileData?.entry){return}if(!v.prefixKey){v.prefixKey=parentEntry.toURL();appendChildIfNotExisted(parentEntry,fileData.entry);currentState.allEntries[v.rootKey]={...fileData,icon:ICON_TYPES.UNKNOWN_REMOVABLE,isEjectable:false}}}));appendChildIfNotExisted(parentEntry,newVolumeEntry);volume.prefixKey=parentEntry.toURL();const fileData=getFileData(currentState,volumeRootKey);currentState.allEntries[volumeRootKey]={...fileData,icon:ICON_TYPES.UNKNOWN_REMOVABLE,isEjectable:false};currentState.allEntries[parentKey]={...getFileData(currentState,parentKey),isEjectable:true}}}return{...currentState,volumes:{...currentState.volumes,[volume.volumeId]:volume}}}slice.addReducer("remove",removeVolumeReducer);function removeVolumeReducer(currentState,payload){delete currentState.volumes[payload.volumeId];currentState.volumes={...currentState.volumes};return{...currentState}}slice.addReducer("set-is-interactive",updateIsInteractiveVolumeReducer);function updateIsInteractiveVolumeReducer(currentState,payload){const volumes={...currentState.volumes};const updatedVolume={...volumes[payload.volumeId],isInteractive:payload.isInteractive};return{...currentState,volumes:{...volumes,[payload.volumeId]:updatedVolume}}}slice.addReducer(updateDeviceConnectionState.type,updateDeviceConnectionStateReducer);function updateDeviceConnectionStateReducer(currentState,payload){let volumes;const disableODFS=payload.connection===chrome.fileManagerPrivate.DeviceConnectionState.OFFLINE;for(const volume of Object.values(currentState.volumes)){if(!isOneDriveId(volume.providerId)||volume.isDisabled===disableODFS){continue}const updatedVolume=updateVolume(currentState,volume.volumeId,{isDisabled:disableODFS});if(updatedVolume){if(!volumes){volumes={...currentState.volumes,[volume.volumeId]:updatedVolume}}else{volumes[volume.volumeId]=updatedVolume}}updateFileDataInPlace(currentState,volume.rootKey,{disabled:disableODFS});const odfsVolumeEntry=getEntry(currentState,volume.rootKey);if(odfsVolumeEntry){odfsVolumeEntry.disabled=disableODFS}}return volumes?{...currentState,volumes:volumes}:currentState}function isVolumeEntry(entry){return"volumeInfo"in entry}function isFakeEntry(entry){if(entry?.getParent===undefined){return true}return"isNativeType"in entry?!entry.isNativeType:false}function isOneDrivePlaceholder(entry){return isFakeEntry(entry)&&isOneDrivePlaceholderKey(entry.toURL())}function isSameEntry(entry1,entry2){if(!entry1&&!entry2){return true}if(!entry1||!entry2){return false}return entry1.toURL()===entry2.toURL()}function comparePath(entry1,entry2){return collator.compare(entry1.fullPath,entry2.fullPath)}function entriesToURLs(entries){return entries.map((entry=>{if("cachedUrl"in entry){return entry["cachedUrl"]||entry.toURL()}return entry.toURL()}))}const isOneDriveId=providerId=>providerId===ODFS_EXTENSION_ID;function isOneDrive(volumeInfo){return isOneDriveId(volumeInfo?.providerId)}function isOneDrivePlaceholderKey(key){if(!key){return false}return isOneDriveId(key.substr(key.lastIndexOf("/")+1))}function extractElementInfo(element,contentWindow,styleNames){const attributes={};for(const attr of element.attributes){attributes[attr.nodeName]=attr.nodeValue}const result={attributes:attributes,styles:{},text:element.textContent,innerText:element.innerText,value:element.value,hidden:!!element.hidden,hasShadowRoot:!!element.shadowRoot};styleNames=styleNames||[];assert(Array.isArray(styleNames));if(!styleNames.length){return result}const size=element.getBoundingClientRect();const computedStyle=contentWindow.getComputedStyle(element);for(const style of styleNames){result.styles[style]=computedStyle.getPropertyValue(style)}result.imageWidth=Number(element.width);result.imageHeight=Number(element.height);result.renderedWidth=size.width;result.renderedHeight=size.height;result.renderedTop=size.top;result.renderedLeft=size.left;result.scrollLeft=element.scrollLeft;result.scrollTop=element.scrollTop;result.scrollWidth=element.scrollWidth;result.scrollHeight=element.scrollHeight;return result}test.util.sync.getErrorCount=()=>window.JSErrorCount;test.util.sync.resizeWindow=(width,height)=>{window.resizeTo(width,height);return true};test.util.sync.queryAllElements=(contentWindow,targetQuery,styleNames)=>test.util.sync.deepQueryAllElements(contentWindow,targetQuery,styleNames);test.util.sync.deepQueryAllElements=(contentWindow,targetQuery,styleNames)=>{if(!contentWindow.document){return[]}if(typeof targetQuery==="string"){targetQuery=[targetQuery]}const elems=deepQuerySelectorAll(contentWindow.document,targetQuery);return elems.map((element=>extractElementInfo(element,contentWindow,styleNames)))};test.util.async.countElements=(contentWindow,query,count,callback)=>{contentWindow.requestIdleCallback((()=>{const elements=deepQuerySelectorAll(contentWindow.document,query);callback(elements.length===count)}))};function deepQuerySelectorAll(root,targetQuery){const elems=Array.prototype.slice.call(root.querySelectorAll(targetQuery[0]));const remaining=targetQuery.slice(1);if(remaining.length===0){return elems}let res=[];for(const elem of elems){if("shadowRoot"in elem){res=res.concat(deepQuerySelectorAll(elem.shadowRoot,remaining))}}return res}test.util.sync.getActiveElement=(contentWindow,styleNames)=>{if(!contentWindow.document||!contentWindow.document.activeElement){return null}return extractElementInfo(contentWindow.document.activeElement,contentWindow,styleNames)};test.util.sync.deepGetActiveElement=(contentWindow,styleNames)=>{if(!contentWindow.document||!contentWindow.document.activeElement){return null}let activeElement=contentWindow.document.activeElement;while(true){const shadow=activeElement.shadowRoot;if(shadow&&shadow.activeElement){activeElement=shadow.activeElement}else{break}}return extractElementInfo(activeElement,contentWindow,styleNames)};test.util.sync.deepGetActivePath=(contentWindow,styleNames)=>{if(!contentWindow.document||!contentWindow.document.activeElement){return[]}const path=[contentWindow.document.activeElement];while(true){const shadow=path[path.length-1]?.shadowRoot;if(shadow&&shadow.activeElement){path.push(shadow.activeElement)}else{break}}return path.map((el=>extractElementInfo(el,contentWindow,styleNames)))};test.util.sync.inputText=(contentWindow,query,text)=>{if(typeof query==="string"){query=[query]}const elems=deepQuerySelectorAll(contentWindow.document,query);if(elems.length===0){console.error(`Input element not found: [${query.join(",")}]`);return false}const input=elems[0];input.value=text;input.dispatchEvent(new Event("change"));return true};test.util.sync.setScrollLeft=(contentWindow,query,position)=>{contentWindow.document.querySelector(query).scrollLeft=position;return true};test.util.sync.setScrollTop=(contentWindow,query,position)=>{contentWindow.document.querySelector(query).scrollTop=position;return true};test.util.sync.setElementStyles=(contentWindow,query,properties)=>{const element=contentWindow.document.querySelector(query);if(element===null){console.error(`Failed to locate element using query "${query}"`);return false}for(const[key,value]of Object.entries(properties)){element.style.setProperty(key,value)}return true};test.util.sync.sendEvent=(contentWindow,targetQuery,event)=>{if(!contentWindow.document){return false}let target;if(targetQuery===null){target=contentWindow.document.activeElement}else if(typeof targetQuery==="string"){target=contentWindow.document.querySelector(targetQuery)}else if(Array.isArray(targetQuery)){const elements=deepQuerySelectorAll(contentWindow.document,targetQuery);if(elements.length>0){target=elements[0]}}if(!target){return false}target.dispatchEvent(event);return true};test.util.sync.fakeEvent=(contentWindow,targetQuery,eventType,additionalProperties)=>{const isCustomEvent="detail"in(additionalProperties||{});const event=isCustomEvent?new CustomEvent(eventType,additionalProperties||{}):new Event(eventType,additionalProperties||{});if(!isCustomEvent&&additionalProperties){for(const name in additionalProperties){if(name==="bubbles"){continue}event[name]=additionalProperties[name]}}return test.util.sync.sendEvent(contentWindow,targetQuery,event)};test.util.sync.fakeKeyDown=(contentWindow,targetQuery,key,ctrl,shift,alt)=>{const event=new KeyboardEvent("keydown",{bubbles:true,composed:true,key:key,ctrlKey:ctrl,shiftKey:shift,altKey:alt});return test.util.sync.sendEvent(contentWindow,targetQuery,event)};test.util.sync.fakeMouseClick=(contentWindow,targetQuery,keyModifiers,button,eventProperties)=>{const modifiers=keyModifiers||{};eventProperties=eventProperties||{};const props=Object.assign({bubbles:true,detail:1,composed:true,ctrlKey:modifiers.ctrl,shiftKey:modifiers.shift,altKey:modifiers.alt},eventProperties);if(button!==undefined){props.button=button}if(!targetQuery){return false}if(typeof targetQuery==="string"){targetQuery=[targetQuery]}const elems=deepQuerySelectorAll(contentWindow.document,targetQuery);if(elems.length===0){return false}const target=elems[0];const mouseOverEvent=new MouseEvent("mouseover",props);const resultMouseOver=target.dispatchEvent(mouseOverEvent);const mouseDownEvent=new MouseEvent("mousedown",props);const resultMouseDown=target.dispatchEvent(mouseDownEvent);const mouseUpEvent=new MouseEvent("mouseup",props);const resultMouseUp=target.dispatchEvent(mouseUpEvent);const clickEvent=new MouseEvent("click",props);const resultClick=target.dispatchEvent(clickEvent);return resultMouseOver&&resultMouseDown&&resultMouseUp&&resultClick};test.util.sync.fakeMouseOver=(contentWindow,targetQuery,keyModifiers)=>{const modifiers=keyModifiers||{};const props={bubbles:true,detail:1,composed:true,ctrlKey:modifiers.ctrl,shiftKey:modifiers.shift,altKey:modifiers.alt};const mouseOverEvent=new MouseEvent("mouseover",props);return test.util.sync.sendEvent(contentWindow,targetQuery,mouseOverEvent)};test.util.sync.fakeMouseOut=(contentWindow,targetQuery,keyModifiers)=>{const modifiers=keyModifiers||{};const props={bubbles:true,detail:1,composed:true,ctrlKey:modifiers.ctrl,shiftKey:modifiers.shift,altKey:modifiers.alt};const mouseOutEvent=new MouseEvent("mouseout",props);return test.util.sync.sendEvent(contentWindow,targetQuery,mouseOutEvent)};test.util.sync.fakeMouseRightClick=(contentWindow,targetQuery,keyModifiers)=>{const clickResult=test.util.sync.fakeMouseClick(contentWindow,targetQuery,keyModifiers,2);if(!clickResult){return false}return test.util.sync.fakeContextMenu(contentWindow,targetQuery)};test.util.sync.fakeContextMenu=(contentWindow,targetQuery)=>{const contextMenuEvent=new MouseEvent("contextmenu",{bubbles:true,composed:true});return test.util.sync.sendEvent(contentWindow,targetQuery,contextMenuEvent)};test.util.sync.fakeTouchClick=(contentWindow,targetQuery)=>{const touchStartEvent=new TouchEvent("touchstart");if(!test.util.sync.sendEvent(contentWindow,targetQuery,touchStartEvent)){return false}const touchEndEvent=new TouchEvent("touchend");if(!test.util.sync.sendEvent(contentWindow,targetQuery,touchEndEvent)){return false}return true};test.util.sync.fakeMouseDoubleClick=(contentWindow,targetQuery)=>{if(!test.util.sync.fakeMouseClick(contentWindow,targetQuery)){return false}let event=new MouseEvent("click",{bubbles:true,detail:2,composed:true});if(!test.util.sync.sendEvent(contentWindow,targetQuery,event)){return false}event=new MouseEvent("dblclick",{bubbles:true,composed:true});if(!test.util.sync.sendEvent(contentWindow,targetQuery,event)){return false}return true};test.util.sync.fakeMouseDown=(contentWindow,targetQuery)=>{const event=new MouseEvent("mousedown",{bubbles:true,composed:true});return test.util.sync.sendEvent(contentWindow,targetQuery,event)};test.util.sync.fakeMouseUp=(contentWindow,targetQuery)=>{const event=new MouseEvent("mouseup",{bubbles:true,composed:true});return test.util.sync.sendEvent(contentWindow,targetQuery,event)};test.util.sync.rightClickOffset=(contentWindow,targetQuery,offsetBottom,offsetRight)=>{const target=contentWindow.document&&contentWindow.document.querySelector(targetQuery);if(!target){return false}const targetRect=target.getBoundingClientRect();const props={clientX:targetRect.right+(offsetRight?offsetRight:0),clientY:targetRect.bottom+(offsetBottom?offsetBottom:0)};const keyModifiers=undefined;const rightButton=2;if(!test.util.sync.fakeMouseClick(contentWindow,targetQuery,keyModifiers,rightButton,props)){return false}return true};test.util.async.fakeDragAndDrop=(contentWindow,sourceQuery,targetQuery,skipDrop,callback)=>{const source=contentWindow.document.querySelector(sourceQuery);const target=contentWindow.document.querySelector(targetQuery);if(!source||!target){setTimeout((()=>{callback(false)}),0);return}const targetOptions={bubbles:true,composed:true,dataTransfer:new DataTransfer};const sourceRect=source.getBoundingClientRect();const sourceOptions=Object.assign({},targetOptions);sourceOptions.clientX=sourceRect.left+sourceRect.width/2;sourceOptions.clientY=sourceRect.top+sourceRect.height/2;let dragEventPhase=0;let event=null;function sendPhasedDragDropEvents(){assert(source);assert(target);let result=true;switch(dragEventPhase){case 0:event=new DragEvent("dragstart",sourceOptions);result=source.dispatchEvent(event);break;case 1:targetOptions.relatedTarget=source;event=new DragEvent("dragenter",targetOptions);result=target.dispatchEvent(event);break;case 2:targetOptions.relatedTarget=null;event=new DragEvent("dragover",targetOptions);result=target.dispatchEvent(event);break;case 3:if(!skipDrop){targetOptions.relatedTarget=null;event=new DragEvent("drop",targetOptions);result=target.dispatchEvent(event)}break;case 4:if(!skipDrop){event=new DragEvent("dragend",sourceOptions);result=source.dispatchEvent(event)}break;default:result=false;break}if(!result){callback(false)}else if(++dragEventPhase<=4){contentWindow.requestIdleCallback(sendPhasedDragDropEvents)}else{callback(true)}}sendPhasedDragDropEvents()};test.util.async.fakeDragLeaveOrDrop=(contentWindow,sourceQuery,targetQuery,dragLeave,callback)=>{const source=contentWindow.document.querySelector(sourceQuery);const target=contentWindow.document.querySelector(targetQuery);if(!source||!target){setTimeout((()=>{callback(false)}),0);return}const targetOptions={bubbles:true,composed:true,dataTransfer:new DataTransfer};const sourceRect=source.getBoundingClientRect();const sourceOptions=Object.assign({},targetOptions);sourceOptions.clientX=sourceRect.left+sourceRect.width/2;sourceOptions.clientY=sourceRect.top+sourceRect.height/2;const targetType=dragLeave?"dragleave":"drop";let dragEventPhase=0;let event=null;function sendPhasedDragEndEvents(){let result=false;assert(source);assert(target);switch(dragEventPhase){case 0:event=new DragEvent(targetType,targetOptions);result=target.dispatchEvent(event);break;case 1:event=new DragEvent("dragend",sourceOptions);result=source.dispatchEvent(event);break}if(!result){callback(false)}else if(++dragEventPhase<=1){contentWindow.requestIdleCallback(sendPhasedDragEndEvents)}else{callback(true)}}sendPhasedDragEndEvents()};test.util.async.fakeDropBrowserFile=(contentWindow,fileName,fileContent,fileMimeType,targetQuery,callback)=>{const target=contentWindow.document.querySelector(targetQuery);if(!target){setTimeout((()=>callback(false)));return}const file=new File([fileContent],fileName,{type:fileMimeType});const dataTransfer=new DataTransfer;dataTransfer.items.add(file);callback(target.dispatchEvent(new DragEvent("drop",{bubbles:true,composed:true,dataTransfer:dataTransfer})))};test.util.sync.fakeResizeEvent=contentWindow=>{const resize=contentWindow.document.createEvent("Event");resize.initEvent("resize",false,false);return contentWindow.dispatchEvent(resize)};test.util.sync.focus=(contentWindow,targetQuery)=>{const target=contentWindow.document&&contentWindow.document.querySelector(targetQuery);if(!target){return false}target.focus();return true};test.util.async.getNotificationIDs=_callback=>{throw new Error("See b/189173190 and b/296960734 to renable the tests using this function")};test.util.async.getFilesUnderVolume=async(volumeType,names,callback)=>{const volumeManager=await window.background.getVolumeManager();let volumeInfo=null;let displayRoot=null;while(!(volumeInfo&&displayRoot)){volumeInfo=volumeManager.getCurrentProfileVolumeInfo(volumeType);if(volumeInfo){displayRoot=await volumeInfo.resolveDisplayRoot()}if(!displayRoot){await new Promise((resolve=>setTimeout(resolve,100)))}}const filesPromise=names.map((name=>{if(volumeType===VolumeType.DOWNLOADS){name="Downloads/"+name}return new Promise(displayRoot.getFile.bind(displayRoot,name,{}))}));try{const urls=await Promise.all(filesPromise);const result=entriesToURLs(urls);callback(result)}catch(error){console.error(error);callback([])}};test.util.async.unmount=async(volumeType,callback)=>{const volumeManager=await window.background.getVolumeManager();const volumeInfo=volumeManager.getCurrentProfileVolumeInfo(volumeType);try{if(volumeInfo){await volumeManager.unmount(volumeInfo);callback(true);return}}catch(error){console.error(error)}callback(false)};test.util.executeTestMessage=(request,sendResponse)=>{window.IN_TEST=true;if(!request.func||request.func[request.func.length-1]==="_"){request.func=""}if(!("args"in request)){throw new Error("Invalid request: no args provided.")}const args=request.args.slice();if(request.appId){if(request.contentWindow){args.unshift(request.contentWindow)}else{console.error("Specified window not found: "+request.appId);return false}}if(test.util.async[request.func]){args[test.util.async[request.func].length-1]=function(...innerArgs){debug("Received the result of "+request.func);sendResponse.apply(null,innerArgs)};debug("Waiting for the result of "+request.func);test.util.async[request.func].apply(null,args);return true}else if(test.util.sync[request.func]){try{sendResponse(test.util.sync[request.func].apply(null,args))}catch(e){console.error(`Failure executing ${request.func}: ${e}`);sendResponse(null)}return false}else{console.error("Invalid function name: "+request.func);return false}};test.util.sync.getMetadataStats=contentWindow=>contentWindow.fileManager.metadataModel.getStats();test.util.async.getContentMetadata=(contentWindow,properties,callback)=>{const entries=contentWindow.fileManager.directoryModel.getSelectedEntries_();assert(entries.length>0);const metaPromise=contentWindow.fileManager.metadataModel.get(entries,properties);metaPromise.then((resultsList=>{callback(resultsList)}))};test.util.sync.isFileManagerLoaded=contentWindow=>{if(contentWindow&&contentWindow.fileManager){try{return contentWindow.fileManager.ui.element.hasAttribute("loaded")}catch(e){console.warn(e);return false}}return false};test.util.sync.getA11yAnnounces=contentWindow=>{if(contentWindow&&contentWindow.fileManager&&contentWindow.fileManager.ui){return contentWindow.fileManager.ui.a11yAnnounces}return null};test.util.async.getVolumesCount=callback=>window.background.getVolumeManager().then((volumeManager=>{callback(volumeManager.volumeInfoList.length)}));test.util.sync.setPreferences=preferences=>{chrome.fileManagerPrivate.setPreferences(preferences);return true};test.util.sync.recordEnumMetric=(name,value,validValues)=>{recordEnum(name,value,validValues);return true};test.util.sync.progressCenterNeverNotifyCompleted=()=>{window.background.progressCenter.neverNotifyCompleted();return true};test.util.async.waitForBackgroundReady=async callback=>{await window.background.ready();callback()};test.util.async.isolateBannerForTesting=async(contentWindow,bannerTagName,callback)=>{try{await contentWindow.fileManager.ui.banners.isolateBannerForTesting(bannerTagName);callback(true);return}catch(e){console.error(`Error isolating banner with tagName ${bannerTagName} for testing: ${e}`)}callback(false)};test.util.async.disableBannersForTesting=async(contentWindow,callback)=>{try{await contentWindow.fileManager.ui.banners.disableBannersForTesting();callback(true);return}catch(e){console.error(`Error disabling banners for testing: ${e}`)}callback(false)};test.util.async.disableNudgeExpiry=async(contentWindow,callback)=>{contentWindow.fileManager.ui.nudgeContainer.setExpiryPeriodEnabledForTesting=false;callback(true)};