import { du as PaperRippleMixin, k as assert, Y as XfBase, g as getStore, a as RateLimiter, d as str, c as strf, df as getCurrentLocaleOrDefault, b8 as bytesToString, dv as calculateBulkPinRequiredSpace, v as visitURL, aM as getTrustedHTML, A as AsyncQueue, dw as validateExternalDriveName, bp as isSinglePartitionFormatEnabled, dx as toSandboxedURL, dd as PanelType, dy as getPluralString } from './shared.rollup.js';
import { html, PolymerElement, Polymer, Base, dom, dedupingMixin } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import { query, customElement, html as html$1, css, property, svg } from 'chrome://resources/mwc/lit/index.js';
import 'chrome://resources/ash/common/load_time_data.m.js';
import 'chrome://resources/js/cr.js';

function getTemplate$d() {
    return html `<!--_html_template_start_--><style>:host{-webkit-tap-highlight-color:transparent;align-items:center;cursor:pointer;display:flex;outline:none;user-select:none;--cr-checkbox-border-size:2px;--cr-checkbox-size:16px;--cr-checkbox-ripple-size:40px;--cr-checkbox-ripple-offset:calc(var(--cr-checkbox-size)/2 - var(--cr-checkbox-ripple-size)/2 - var(--cr-checkbox-border-size));--cr-checkbox-checked-box-color:var(--cr-checked-color);--cr-checkbox-ripple-checked-color:var(--cr-checked-color);--cr-checkbox-checked-ripple-opacity:.2;--cr-checkbox-mark-color:white;--cr-checkbox-ripple-unchecked-color:var(--google-grey-900);--cr-checkbox-unchecked-box-color:var(--google-grey-700);--cr-checkbox-unchecked-ripple-opacity:.15}@media (prefers-color-scheme:dark){:host{--cr-checkbox-checked-ripple-opacity:.4;--cr-checkbox-mark-color:var(--google-grey-900);--cr-checkbox-ripple-unchecked-color:var(--google-grey-500);--cr-checkbox-unchecked-box-color:var(--google-grey-500);--cr-checkbox-unchecked-ripple-opacity:.4}}:host-context([chrome-refresh-2023]):host{--cr-checkbox-ripple-size:32px;--cr-checkbox-mark-color:var(--color-checkbox-check,var(--cr-fallback-color-on-primary));--cr-checkbox-checked-box-color:var(--color-checkbox-foreground-checked,var(--cr-fallback-color-primary));--cr-checkbox-unchecked-box-color:var(--color-checkbox-foreground-unchecked,var(--cr-fallback-color-outline));--cr-checkbox-ripple-checked-color:var(--cr-active-background-color);--cr-checkbox-ripple-unchecked-color:var(--cr-active-background-color);--cr-checkbox-ripple-offset:50%;--cr-checkbox-ripple-opacity:1}:host([disabled]){cursor:initial;opacity:var(--cr-disabled-opacity);pointer-events:none}:host-context([chrome-refresh-2023]):host([disabled]){opacity:1;--cr-checkbox-checked-box-color:var(--color-checkbox-container-disabled,var(--cr-fallback-color-disabled-background));--cr-checkbox-unchecked-box-color:var(--color-checkbox-outline-disabled,var(--cr-fallback-color-disabled-background));--cr-checkbox-mark-color:var(--color-checkbox-check-disabled,var(--cr-fallback-color-disabled-foreground))}#checkbox{background:none;border:var(--cr-checkbox-border-size) solid var(--cr-checkbox-unchecked-box-color);border-radius:2px;box-sizing:border-box;cursor:pointer;display:block;flex-shrink:0;height:var(--cr-checkbox-size);isolation:isolate;margin:0;outline:none;padding:0;position:relative;transform:none;width:var(--cr-checkbox-size)}:host-context([chrome-refresh-2023]):host([disabled][checked]) #checkbox{border-color:transparent}:host-context([chrome-refresh-2023]) #hover-layer{display:none}:host-context([chrome-refresh-2023]) #checkbox:hover #hover-layer{background-color:var(--cr-hover-background-color);border-radius:50%;display:block;height:32px;left:50%;overflow:hidden;pointer-events:none;position:absolute;top:50%;transform:translate(-50%,-50%);width:32px}@media (forced-colors:active){:host(:focus) #checkbox{outline:var(--cr-focus-outline-hcm)}}:host-context([chrome-refresh-2023]) #checkbox:focus-visible{outline:var(--cr-checkbox-focus-outline,2px solid var(--cr-focus-outline-color));outline-offset:2px}#checkmark{display:block;forced-color-adjust:auto;position:relative;transform:scale(0);z-index:1}#checkmark path{fill:var(--cr-checkbox-mark-color)}:host([checked]) #checkmark{transform:scale(1);transition:transform 140ms ease-out}:host([checked]) #checkbox{background:var(--cr-checkbox-checked-box-background-color,var(--cr-checkbox-checked-box-color));border-color:var(--cr-checkbox-checked-box-color)}paper-ripple{--paper-ripple-opacity:var(--cr-checkbox-ripple-opacity,var(--cr-checkbox-unchecked-ripple-opacity));color:var(--cr-checkbox-ripple-unchecked-color);height:var(--cr-checkbox-ripple-size);left:var(--cr-checkbox-ripple-offset);outline:var(--cr-checkbox-ripple-ring,none);pointer-events:none;top:var(--cr-checkbox-ripple-offset);transition:color linear 80ms;width:var(--cr-checkbox-ripple-size)}:host([checked]) paper-ripple{--paper-ripple-opacity:var(--cr-checkbox-ripple-opacity,var(--cr-checkbox-checked-ripple-opacity));color:var(--cr-checkbox-ripple-checked-color)}:host-context([dir=rtl]) paper-ripple{left:auto;right:var(--cr-checkbox-ripple-offset)}:host-context([chrome-refresh-2023]) paper-ripple{transform:translate(-50%,-50%)}:host-context([dir=rtl][chrome-refresh-2023]) paper-ripple{transform:translate(50%,-50%)}#label-container{color:var(--cr-checkbox-label-color,var(--cr-primary-text-color));padding-inline-start:var(--cr-checkbox-label-padding-start,20px);white-space:normal}:host(.label-first) #label-container{order:-1;padding-inline-end:var(--cr-checkbox-label-padding-end,20px);padding-inline-start:0}:host(.no-label) #label-container{display:none}#ariaDescription{height:0;overflow:hidden;width:0}</style>
<div id="checkbox" tabindex$="[[tabIndex]]" role="checkbox"
    on-keydown="onKeyDown_" on-keyup="onKeyUp_" aria-disabled="false"
    aria-checked="false" aria-labelledby="label-container"
    aria-describedby="ariaDescription">
  <!-- Inline SVG paints faster than loading it from a separate file. -->
  <svg id="checkmark" width="12" height="12" viewBox="0 0 12 12"
      fill="none" xmlns="http://www.w3.org/2000/svg">
    <path fill-rule="evenodd" clip-rule="evenodd" d="m10.192 2.121-6.01 6.01-2.121-2.12L1 7.07l2.121 2.121.707.707.354.354 7.071-7.071-1.06-1.06Z">
  </svg>
  <div id="hover-layer"></div>
</div>
<div id="label-container" aria-hidden="true" aria-label$="[[ariaLabelOverride]]" part="label-container">
  <slot></slot>
</div>
<div id="ariaDescription" aria-hidden="true">[[ariaDescription]]</div>
<!--_html_template_end_-->`;
}

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview 'cr-checkbox' is a component similar to native checkbox.
 *
 * Forked from ui/webui/resources/cr_elements/cr_checkbox/cr_checkbox.ts
 *
 * Fires a 'change' event *only* when its state changes as a result of a user
 * interaction. By default it assumes there will be child(ren) passed in to be
 * used as labels. If no label will be provided, a .no-label class should be
 * added to hide the spacing between the checkbox and the label container.
 *
 * If a label is provided, it will be shown by default after the checkbox. A
 * .label-first CSS class can be added to show the label before the checkbox.
 *
 * List of customizable styles:
 *  --cr-checkbox-border-size
 *  --cr-checkbox-checked-box-background-color
 *  --cr-checkbox-checked-box-color
 *  --cr-checkbox-label-color
 *  --cr-checkbox-label-padding-start
 *  --cr-checkbox-mark-color
 *  --cr-checkbox-ripple-checked-color
 *  --cr-checkbox-ripple-size
 *  --cr-checkbox-ripple-unchecked-color
 *  --cr-checkbox-size
 *  --cr-checkbox-unchecked-box-color
 */
const CrCheckboxElementBase = PaperRippleMixin(PolymerElement);
class CrCheckboxElement extends CrCheckboxElementBase {
    static get is() {
        return 'cr-checkbox';
    }
    static get template() {
        return getTemplate$d();
    }
    static get properties() {
        return {
            checked: {
                type: Boolean,
                value: false,
                reflectToAttribute: true,
                observer: 'checkedChanged_',
                notify: true,
            },
            disabled: {
                type: Boolean,
                value: false,
                reflectToAttribute: true,
                observer: 'disabledChanged_',
            },
            ariaDescription: String,
            ariaLabelOverride: String,
            tabIndex: {
                type: Number,
                value: 0,
                observer: 'onTabIndexChanged_',
            },
        };
    }
    ready() {
        super.ready();
        // TODO(b/309689294) Remove this once CrOS UIs migrate to Jellybean
        // components and no longer use cr-elements.
        // Force stamp the ripple element to enable CrOS focus styles. Ripple
        // visibility is controlled by the event listeners below.
        if (document.documentElement.hasAttribute('chrome-refresh-2023')) {
            this.getRipple();
        }
        this.removeAttribute('unresolved');
        this.addEventListener('click', this.onClick_.bind(this));
        this.addEventListener('pointerup', this.hideRipple_.bind(this));
        if (document.documentElement.hasAttribute('chrome-refresh-2023')) {
            this.addEventListener('pointerdown', this.showRipple_.bind(this));
            this.addEventListener('pointerleave', this.hideRipple_.bind(this));
        }
        else {
            this.addEventListener('blur', this.hideRipple_.bind(this));
            this.addEventListener('focus', this.showRipple_.bind(this));
        }
    }
    focus() {
        this.$.checkbox.focus();
    }
    getFocusableElement() {
        return this.$.checkbox;
    }
    checkedChanged_() {
        this.$.checkbox.setAttribute('aria-checked', this.checked ? 'true' : 'false');
    }
    disabledChanged_(_current, previous) {
        if (previous === undefined && !this.disabled) {
            return;
        }
        this.tabIndex = this.disabled ? -1 : 0;
        this.$.checkbox.setAttribute('aria-disabled', this.disabled ? 'true' : 'false');
    }
    showRipple_() {
        if (this.noink) {
            return;
        }
        this.getRipple().showAndHoldDown();
    }
    hideRipple_() {
        this.getRipple().clear();
    }
    onClick_(e) {
        if (this.disabled || e.target.tagName === 'A') {
            return;
        }
        // Prevent |click| event from bubbling. It can cause parents of this
        // elements to erroneously re-toggle this control.
        e.stopPropagation();
        e.preventDefault();
        this.checked = !this.checked;
        this.dispatchEvent(new CustomEvent('change', { bubbles: true, composed: true, detail: this.checked }));
    }
    onKeyDown_(e) {
        if (e.key !== ' ' && e.key !== 'Enter') {
            return;
        }
        e.preventDefault();
        e.stopPropagation();
        if (e.repeat) {
            return;
        }
        if (e.key === 'Enter') {
            this.click();
        }
    }
    onKeyUp_(e) {
        if (e.key === ' ' || e.key === 'Enter') {
            e.preventDefault();
            e.stopPropagation();
        }
        if (e.key === ' ') {
            this.click();
        }
    }
    onTabIndexChanged_() {
        // :host shouldn't have a tabindex because it's set on #checkbox.
        this.removeAttribute('tabindex');
    }
    // Overridden from PaperRippleMixin
    /* eslint-disable-next-line @typescript-eslint/naming-convention */
    _createRipple() {
        this._rippleContainer = this.$.checkbox;
        const ripple = super._createRipple();
        ripple.id = 'ink';
        ripple.setAttribute('recenters', '');
        ripple.classList.add('circle');
        return ripple;
    }
}
customElements.define(CrCheckboxElement.is, CrCheckboxElement);

/**
@license
Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at
http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
part of the polymer project is also subject to an additional IP rights grant
found at http://polymer.github.io/PATENTS.txt
*/

/**

The `iron-icon` element displays an icon. By default an icon renders as a 24px
square.

Example using src:

    <iron-icon src="star.png"></iron-icon>

Example setting size to 32px x 32px:

    <iron-icon class="big" src="big_star.png"></iron-icon>

    <style is="custom-style">
      .big {
        --iron-icon-height: 32px;
        --iron-icon-width: 32px;
      }
    </style>

The iron elements include several sets of icons. To use the default set of
icons, import `iron-icons.js` and use the `icon` attribute to specify an icon:

    <script type="module">
      import "../iron-icons/iron-icons.js";
    </script>

    <iron-icon icon="menu"></iron-icon>

To use a different built-in set of icons, import the specific
`iron-icons/<iconset>-icons.js`, and specify the icon as `<iconset>:<icon>`.
For example, to use a communication icon, you would use:

    <script type="module">
      import "../iron-icons/communication-icons.js";
    </script>

    <iron-icon icon="communication:email"></iron-icon>

You can also create custom icon sets of bitmap or SVG icons.

Example of using an icon named `cherry` from a custom iconset with the ID
`fruit`:

    <iron-icon icon="fruit:cherry"></iron-icon>

See `<iron-iconset>` and `<iron-iconset-svg>` for more information about how to
create a custom iconset.

See the `iron-icons` demo to see the icons available in the various iconsets.

### Styling

The following custom properties are available for styling:

Custom property | Description | Default
----------------|-------------|----------
`--iron-icon` | Mixin applied to the icon | {}
`--iron-icon-width` | Width of the icon | `24px`
`--iron-icon-height` | Height of the icon | `24px`
`--iron-icon-fill-color` | Fill color of the svg icon | `currentcolor`
`--iron-icon-stroke-color` | Stroke color of the svg icon | none

@group Iron Elements
@element iron-icon
@demo demo/index.html
@hero hero.svg
@homepage polymer.github.io
*/
Polymer({
  _template: html`
    <style>
      :host {
        align-items: center;
        display: inline-flex;
        justify-content: center;
        position: relative;

        vertical-align: middle;

        fill: var(--iron-icon-fill-color, currentcolor);
        stroke: var(--iron-icon-stroke-color, none);

        width: var(--iron-icon-width, 24px);
        height: var(--iron-icon-height, 24px);
      }

      :host([hidden]) {
        display: none;
      }
    </style>
`,

  is: 'iron-icon',

  properties: {

    /**
     * The name of the icon to use. The name should be of the form:
     * `iconset_name:icon_name`.
     */
    icon: {type: String},

    /**
     * The name of the theme to used, if one is specified by the
     * iconset.
     */
    theme: {type: String},

    /**
     * If using iron-icon without an iconset, you can set the src to be
     * the URL of an individual icon image file. Note that this will take
     * precedence over a given icon attribute.
     */
    src: {type: String},

    /**
     * @type {!IronMeta}
     */
    _meta: {value: Base.create('iron-meta', {type: 'iconset'})}

  },

  observers: [
    '_updateIcon(_meta, isAttached)',
    '_updateIcon(theme, isAttached)',
    '_srcChanged(src, isAttached)',
    '_iconChanged(icon, isAttached)'
  ],

  _DEFAULT_ICONSET: 'icons',

  _iconChanged: function(icon) {
    var parts = (icon || '').split(':');
    this._iconName = parts.pop();
    this._iconsetName = parts.pop() || this._DEFAULT_ICONSET;
    this._updateIcon();
  },

  _srcChanged: function(src) {
    this._updateIcon();
  },

  _usesIconset: function() {
    return this.icon || !this.src;
  },

  /** @suppress {visibility} */
  _updateIcon: function() {
    if (this._usesIconset()) {
      if (this._img && this._img.parentNode) {
        dom(this.root).removeChild(this._img);
      }
      if (this._iconName === '') {
        if (this._iconset) {
          this._iconset.removeIcon(this);
        }
      } else if (this._iconsetName && this._meta) {
        this._iconset = /** @type {?Polymer.Iconset} */ (
            this._meta.byKey(this._iconsetName));
        if (this._iconset) {
          this._iconset.applyIcon(this, this._iconName, this.theme);
          this.unlisten(window, 'iron-iconset-added', '_updateIcon');
        } else {
          this.listen(window, 'iron-iconset-added', '_updateIcon');
        }
      }
    } else {
      if (this._iconset) {
        this._iconset.removeIcon(this);
      }
      if (!this._img) {
        this._img = document.createElement('img');
        this._img.style.width = '100%';
        this._img.style.height = '100%';
        this._img.draggable = false;
      }
      this._img.src = this.src;
      dom(this.root).appendChild(this._img);
    }
  }
});

function getTemplate$c() {
    return html `<!--_html_template_start_--><style>:host{--cr-icon-button-fill-color:var(--google-grey-700);--cr-icon-button-icon-start-offset:0;--cr-icon-button-icon-size:20px;--cr-icon-button-size:36px;--cr-icon-button-height:var(--cr-icon-button-size);--cr-icon-button-transition:150ms ease-in-out;--cr-icon-button-width:var(--cr-icon-button-size);-webkit-tap-highlight-color:transparent;border-radius:50%;color:var(--cr-icon-button-stroke-color,var(--cr-icon-button-fill-color));cursor:pointer;display:inline-flex;flex-shrink:0;height:var(--cr-icon-button-height);margin-inline-end:var(--cr-icon-button-margin-end,var(--cr-icon-ripple-margin));margin-inline-start:var(--cr-icon-button-margin-start);outline:none;overflow:hidden;user-select:none;vertical-align:middle;width:var(--cr-icon-button-width)}:host-context([chrome-refresh-2023]):host{--cr-icon-button-fill-color:currentColor;--cr-icon-button-size:32px;position:relative}:host(:hover){background-color:var(--cr-icon-button-hover-background-color,var(--cr-hover-background-color))}:host(:focus-visible:focus){box-shadow:inset 0 0 0 2px var(--cr-icon-button-focus-outline-color,var(--cr-focus-outline-color))}@media (forced-colors:active){:host(:focus-visible:focus){outline:var(--cr-focus-outline-hcm)}}:host-context(html:not([chrome-refresh-2023])) :host(:active){background-color:var(--cr-icon-button-active-background-color,var(--cr-active-background-color))}paper-ripple{display:none}:host-context([chrome-refresh-2023]) paper-ripple{--paper-ripple-opacity:1;color:var(--cr-active-background-color);display:block}:host([disabled]){cursor:initial;opacity:var(--cr-disabled-opacity);pointer-events:none}:host(.no-overlap){--cr-icon-button-margin-end:0;--cr-icon-button-margin-start:0}:host-context([dir=rtl]):host(:not([dir=ltr]):not([multiple-icons_])){transform:scaleX(-1)}:host-context([dir=rtl]):host(:not([dir=ltr])[multiple-icons_]) iron-icon{transform:scaleX(-1)}:host(:not([iron-icon])) #maskedImage{-webkit-mask-image:var(--cr-icon-image);-webkit-mask-position:center;-webkit-mask-repeat:no-repeat;-webkit-mask-size:var(--cr-icon-button-icon-size);-webkit-transform:var(--cr-icon-image-transform,none);background-color:var(--cr-icon-button-fill-color);height:100%;transition:background-color var(--cr-icon-button-transition);width:100%}@media (forced-colors:active){:host(:not([iron-icon])) #maskedImage{background-color:ButtonText}}#icon{align-items:center;border-radius:4px;display:flex;height:100%;justify-content:center;padding-inline-start:var(--cr-icon-button-icon-start-offset);position:relative;width:100%}iron-icon{--iron-icon-fill-color:var(--cr-icon-button-fill-color);--iron-icon-stroke-color:var(--cr-icon-button-stroke-color,none);--iron-icon-height:var(--cr-icon-button-icon-size);--iron-icon-width:var(--cr-icon-button-icon-size);transition:fill var(--cr-icon-button-transition),stroke var(--cr-icon-button-transition)}@media (prefers-color-scheme:dark){:host{--cr-icon-button-fill-color:var(--google-grey-500)}}</style>
<div id="icon">
  <div id="maskedImage"></div>
</div>
<!--_html_template_end_-->`;
}

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview 'cr-icon-button' is a button which displays an icon with a
 * ripple. It can be interacted with like a normal button using click as well as
 * space and enter to effectively click the button and fire a 'click' event.
 *
 * Forked from ui/webui/resources/cr_elements/cr_icon_button/cr_icon_button.ts
 *
 * There are two sources to icons, cr-icons and iron-iconset-svg. The cr-icon's
 * are defined as background images with a reference to a resource file
 * associated with a CSS class name. The iron-icon's are defined as inline SVG's
 * under a key that is stored in a global map that is accessible to the
 * iron-icon element.
 *
 * Example of using a cr-icon:
 * <link rel="import" href="chrome://resources/ash/common/cr_elements/cr_icons.css.html">
 * <dom-module id="module">
 *   <template>
 *     <style includes="cr-icons"></style>
 *     <cr-icon-button class="icon-class-name"></cr-icon-button>
 *   </template>
 * </dom-module>
 *
 * In general when an icon is specified using a class, the expectation is the
 * class will set an image to the --cr-icon-image variable.
 *
 * Example of using an iron-icon:
 * In the TS file:
 * import 'chrome://resources/ash/common/cr_elements/icons.html.js';
 *
 * In the HTML template file:
 * <cr-icon-button iron-icon="cr:icon-key"></cr-icon-button>
 *
 * The color of the icon can be overridden using CSS variables. When using
 * iron-icon both the fill and stroke can be overridden the variables:
 * --cr-icon-button-fill-color
 * --cr-icon-button-stroke-color
 *
 * When not using iron-icon (ie. specifying --cr-icon-image), the icons support
 * one color and the 'stroke' variables are ignored.
 *
 * When using iron-icon's, more than one icon can be specified by setting
 * the |ironIcon| property to a comma-delimited list of keys.
 */
const CrIconbuttonElementBase = PaperRippleMixin(PolymerElement);
class CrIconButtonElement extends CrIconbuttonElementBase {
    static get is() {
        return 'cr-icon-button';
    }
    static get template() {
        return getTemplate$c();
    }
    static get properties() {
        return {
            disabled: {
                type: Boolean,
                value: false,
                reflectToAttribute: true,
                observer: 'disabledChanged_',
            },
            /**
             * Use this property in order to configure the "tabindex" attribute.
             */
            customTabIndex: {
                type: Number,
                observer: 'applyTabIndex_',
            },
            ironIcon: {
                type: String,
                observer: 'onIronIconChanged_',
                reflectToAttribute: true,
            },
            multipleIcons_: {
                type: Boolean,
                reflectToAttribute: true,
            },
        };
    }
    constructor() {
        super();
        /**
         * It is possible to activate a tab when the space key is pressed down. When
         * this element has focus, the keyup event for the space key should not
         * perform a 'click'. |spaceKeyDown_| tracks when a space pressed and
         * handled by this element. Space keyup will only result in a 'click' when
         * |spaceKeyDown_| is true. |spaceKeyDown_| is set to false when element
         * loses focus.
         */
        this.spaceKeyDown_ = false;
        this.addEventListener('blur', this.onBlur_.bind(this));
        this.addEventListener('click', this.onClick_.bind(this));
        this.addEventListener('keydown', this.onKeyDown_.bind(this));
        this.addEventListener('keyup', this.onKeyUp_.bind(this));
        if (document.documentElement.hasAttribute('chrome-refresh-2023')) {
            this.addEventListener('pointerdown', this.onPointerDown_.bind(this));
        }
    }
    ready() {
        super.ready();
        this.setAttribute('aria-disabled', this.disabled ? 'true' : 'false');
        if (!this.hasAttribute('role')) {
            this.setAttribute('role', 'button');
        }
        if (!this.hasAttribute('tabindex')) {
            this.setAttribute('tabindex', '0');
        }
    }
    toggleClass(className) {
        this.classList.toggle(className);
    }
    disabledChanged_(newValue, oldValue) {
        if (!newValue && oldValue === undefined) {
            return;
        }
        if (this.disabled) {
            this.blur();
        }
        this.setAttribute('aria-disabled', this.disabled ? 'true' : 'false');
        this.applyTabIndex_();
    }
    /**
     * Updates the tabindex HTML attribute to the actual value.
     */
    applyTabIndex_() {
        let value = this.customTabIndex;
        if (value === undefined) {
            value = this.disabled ? -1 : 0;
        }
        this.setAttribute('tabindex', value.toString());
    }
    onBlur_() {
        this.spaceKeyDown_ = false;
    }
    onClick_(e) {
        if (this.disabled) {
            e.stopImmediatePropagation();
        }
    }
    onIronIconChanged_() {
        this.shadowRoot.querySelectorAll('iron-icon').forEach(el => el.remove());
        if (!this.ironIcon) {
            return;
        }
        const icons = (this.ironIcon || '').split(',');
        this.multipleIcons_ = icons.length > 1;
        icons.forEach(icon => {
            const ironIcon = document.createElement('iron-icon');
            ironIcon.icon = icon;
            this.$.icon.appendChild(ironIcon);
            if (ironIcon.shadowRoot) {
                ironIcon.shadowRoot.querySelectorAll('svg, img')
                    .forEach(child => child.setAttribute('role', 'none'));
            }
        });
    }
    onKeyDown_(e) {
        if (e.key !== ' ' && e.key !== 'Enter') {
            return;
        }
        e.preventDefault();
        e.stopPropagation();
        if (e.repeat) {
            return;
        }
        if (e.key === 'Enter') {
            this.click();
        }
        else if (e.key === ' ') {
            this.spaceKeyDown_ = true;
        }
    }
    onKeyUp_(e) {
        if (e.key === ' ' || e.key === 'Enter') {
            e.preventDefault();
            e.stopPropagation();
        }
        if (this.spaceKeyDown_ && e.key === ' ') {
            this.spaceKeyDown_ = false;
            this.click();
        }
    }
    onPointerDown_() {
        this.ensureRipple();
    }
}
customElements.define(CrIconButtonElement.is, CrIconButtonElement);

// Copyright 2017 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview CrContainerShadowMixin holds logic for showing a drop shadow
 * near the top of a container element, when the content has scrolled.
 *
 * Forked from ui/webui/resources/cr_elements/cr_container_shadow_mixin.ts
 *
 * Elements using this mixin are expected to define a #container element,
 * which is the element being scrolled. If the #container element has a
 * show-bottom-shadow attribute, a drop shadow will also be shown near the
 * bottom of the container element, when there is additional content to scroll
 * to. Examples:
 *
 * For both top and bottom shadows:
 * <div id="container" show-bottom-shadow>...</div>
 *
 * For top shadow only:
 * <div id="container">...</div>
 *
 * The mixin will take care of inserting an element with ID
 * 'cr-container-shadow-top' which holds the drop shadow effect, and,
 * optionally, an element with ID 'cr-container-shadow-bottom' which holds the
 * same effect. A 'has-shadow' CSS class is automatically added to/removed from
 * both elements while scrolling, as necessary. Note that the show-bottom-shadow
 * attribute is inspected only during attached(), and any changes to it that
 * occur after that point will not be respected.
 *
 * Clients should either use the existing shared styling in
 * cr_shared_style.css, '#cr-container-shadow-[top/bottom]' and
 * '#cr-container-shadow-[top/bottom].has-shadow', or define their own styles.
 */
var CrContainerShadowSide;
(function (CrContainerShadowSide) {
    CrContainerShadowSide["TOP"] = "top";
    CrContainerShadowSide["BOTTOM"] = "bottom";
})(CrContainerShadowSide || (CrContainerShadowSide = {}));
const CrContainerShadowMixin = dedupingMixin((superClass) => {
    class CrContainerShadowMixin extends superClass {
        constructor() {
            super(...arguments);
            this.intersectionObserver_ = null;
            this.dropShadows_ = new Map();
            this.intersectionProbes_ = new Map();
            this.sides_ = null;
        }
        connectedCallback() {
            super.connectedCallback();
            const hasBottomShadow = this.getContainer_().hasAttribute('show-bottom-shadow');
            this.sides_ = hasBottomShadow ?
                [CrContainerShadowSide.TOP, CrContainerShadowSide.BOTTOM] :
                [CrContainerShadowSide.TOP];
            this.sides_.forEach(side => {
                // The element holding the drop shadow effect to be shown.
                const shadow = document.createElement('div');
                shadow.id = `cr-container-shadow-${side}`;
                shadow.classList.add('cr-container-shadow');
                this.dropShadows_.set(side, shadow);
                this.intersectionProbes_.set(side, document.createElement('div'));
            });
            this.getContainer_().parentNode.insertBefore(this.dropShadows_.get(CrContainerShadowSide.TOP), this.getContainer_());
            this.getContainer_().prepend(this.intersectionProbes_.get(CrContainerShadowSide.TOP));
            if (hasBottomShadow) {
                this.getContainer_().parentNode.insertBefore(this.dropShadows_.get(CrContainerShadowSide.BOTTOM), this.getContainer_().nextSibling);
                this.getContainer_().append(this.intersectionProbes_.get(CrContainerShadowSide.BOTTOM));
            }
            this.enableShadowBehavior(true);
        }
        disconnectedCallback() {
            super.disconnectedCallback();
            this.enableShadowBehavior(false);
        }
        getContainer_() {
            return this.shadowRoot.querySelector('#container');
        }
        getIntersectionObserver_() {
            const callback = (entries) => {
                // In some rare cases, there could be more than one entry per
                // observed element, in which case the last entry's result
                // stands.
                for (const entry of entries) {
                    const target = entry.target;
                    this.sides_.forEach(side => {
                        if (target === this.intersectionProbes_.get(side)) {
                            this.dropShadows_.get(side).classList.toggle('has-shadow', entry.intersectionRatio === 0);
                        }
                    });
                }
            };
            return new IntersectionObserver(callback, { root: this.getContainer_(), threshold: 0 });
        }
        /**
         * @param enable Whether to enable the mixin or disable it.
         *     This function does nothing if the mixin is already in the
         *     requested state.
         */
        enableShadowBehavior(enable) {
            // Behavior is already enabled/disabled. Return early.
            if (enable === !!this.intersectionObserver_) {
                return;
            }
            if (!enable) {
                this.intersectionObserver_.disconnect();
                this.intersectionObserver_ = null;
                return;
            }
            this.intersectionObserver_ = this.getIntersectionObserver_();
            // Need to register the observer within a setTimeout() callback,
            // otherwise the drop shadow flashes once on startup, because of the
            // DOM modifications earlier in this function causing a relayout.
            window.setTimeout(() => {
                if (this.intersectionObserver_) {
                    // In case this is already detached.
                    this.intersectionProbes_.forEach(probe => {
                        this.intersectionObserver_.observe(probe);
                    });
                }
            });
        }
        /**
         * Shows the shadows. The shadow mixin must be disabled before
         * calling this method, otherwise the intersection observer might
         * show the shadows again.
         */
        showDropShadows() {
            assert(!this.intersectionObserver_);
            assert(this.sides_);
            for (const side of this.sides_) {
                this.dropShadows_.get(side).classList.toggle('has-shadow', true);
            }
        }
    }
    return CrContainerShadowMixin;
});

function getTemplate$b() {
    return html `<!--_html_template_start_--><style include="cr-hidden-style cr-icons">dialog{--cr-dialog-background-color:var(--cros-sys-dialog_container);--cr-dialog-border-radius:20px;--cr-dialog-title-font:var(--cros-display-7-font);--scroll-border-color:#e0e0e0;--scroll-border:1px solid var(--scroll-border-color);background-color:var(--cr-dialog-background-color);border:0;border-radius:var(--cr-dialog-border-radius);bottom:50%;box-shadow:var(--cros-sys-app-elevation-3-shadow);color:inherit;max-height:initial;max-width:initial;overflow-y:hidden;padding:0;position:absolute;top:50%;width:var(--cr-dialog-width,512px)}@media (prefers-color-scheme:dark){dialog{--scroll-border-color:var(--google-grey-700)}}@media (forced-colors:active){dialog{border:var(--cr-border-hcm)}}dialog[open] #content-wrapper{display:flex;flex-direction:column;max-height:100vh;overflow:auto}.top-container,:host ::slotted([slot=button-container]),:host ::slotted([slot=footer]){flex-shrink:0}dialog::backdrop{background-color:rgba(0,0,0,0.6);bottom:0;left:0;position:fixed;right:0;top:0}:host ::slotted([slot=body]){color:var(--cr-secondary-text-color);padding:0 var(--cr-dialog-body-padding-horizontal,20px)}:host ::slotted([slot=title]){color:var(--cr-primary-text-color);flex:1;font:var(--cr-dialog-title-font);padding-bottom:var(--cr-dialog-title-slot-padding-bottom,16px);padding-inline-end:var(--cr-dialog-title-slot-padding-end,20px);padding-inline-start:var(--cr-dialog-title-slot-padding-start,20px);padding-top:var(--cr-dialog-title-slot-padding-top,20px)}:host ::slotted([slot=button-container]){display:flex;justify-content:flex-end;padding-bottom:var(--cr-dialog-button-container-padding-bottom,16px);padding-inline-end:var(--cr-dialog-button-container-padding-horizontal,16px);padding-inline-start:var(--cr-dialog-button-container-padding-horizontal,16px);padding-top:var(--cr-dialog-button-container-padding-top,16px)}:host ::slotted([slot=footer]){border-bottom-left-radius:inherit;border-bottom-right-radius:inherit;border-top:1px solid #dbdbdb;margin:0;padding:16px 20px}:host([hide-backdrop]) dialog::backdrop{opacity:0}@media (prefers-color-scheme:dark){:host ::slotted([slot=footer]){border-top-color:var(--cr-separator-color)}}.body-container{box-sizing:border-box;display:flex;flex-direction:column;min-height:1.375rem;overflow:auto}:host{--transparent-border:1px solid transparent}#cr-container-shadow-top{border-bottom:var(--cr-dialog-body-border-top,var(--transparent-border))}#cr-container-shadow-bottom{border-bottom:var(--cr-dialog-body-border-bottom,var(--transparent-border))}#cr-container-shadow-top.has-shadow,#cr-container-shadow-bottom.has-shadow{border-bottom:var(--scroll-border)}.top-container{align-items:flex-start;display:flex;min-height:var(--cr-dialog-top-container-min-height,31px)}.title-container{display:flex;flex:1;font-size:inherit;font-weight:inherit;margin:0;outline:none}#close{align-self:flex-start;margin-inline-end:4px;margin-top:4px}</style>
<dialog id="dialog" on-close="onNativeDialogClose_"
    on-cancel="onNativeDialogCancel_" part="dialog"
    aria-labelledby="title" aria-description$="[[ariaDescriptionText]]">
<!-- This wrapper is necessary, such that the "pulse" animation is not
    erroneously played when the user clicks on the outer-most scrollbar. -->
  <div id="content-wrapper" part="wrapper">
    <div class="top-container">
      <h2 id="title" class="title-container" tabindex="-1">
        <slot name="title"></slot>
      </h2>
      <cr-icon-button id="close" class="icon-clear"
          hidden$="[[!showCloseButton]]" aria-label$="[[closeText]]"
          on-click="cancel" on-keypress="onCloseKeypress_">
      </cr-icon-button>
    </div>
    <slot name="header"></slot>
    <div class="body-container" id="container" show-bottom-shadow
        part="body-container">
      <slot name="body"></slot>
    </div>
    <slot name="button-container"></slot>
    <slot name="footer"></slot>
  </div>
</dialog>
<!--_html_template_end_-->`;
}

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview 'cr-dialog' is a component for showing a modal dialog. If the
 * dialog is closed via close(), a 'close' event is fired. If the dialog is
 * canceled via cancel(), a 'cancel' event is fired followed by a 'close' event.
 *
 * Additionally clients can get a reference to the internal native <dialog> via
 * calling getNative() and inspecting the |returnValue| property inside
 * the 'close' event listener to determine whether it was canceled or just
 * closed, where a truthy value means success, and a falsy value means it was
 * canceled.
 *
 * Note that <cr-dialog> wrapper itself always has 0x0 dimensions, and
 * specifying width/height on <cr-dialog> directly will have no effect on the
 * internal native <dialog>. Instead use cr-dialog::part(dialog) to specify
 * width/height (as well as other available mixins to style other parts of the
 * dialog contents).
 *
 * Forked from ui/webui/resources/cr_elements/cr_dialog/cr_dialog.ts
 */
const CrDialogElementBase = CrContainerShadowMixin(PolymerElement);
class CrDialogElement extends CrDialogElementBase {
    constructor() {
        super(...arguments);
        this.intersectionObserver_ = null;
        this.mutationObserver_ = null;
        this.boundKeydown_ = null;
    }
    static get is() {
        return 'cr-dialog';
    }
    static get template() {
        return getTemplate$b();
    }
    static get properties() {
        return {
            open: {
                type: Boolean,
                value: false,
                reflectToAttribute: true,
            },
            /**
             * Alt-text for the dialog close button.
             */
            closeText: String,
            /**
             * True if the dialog should remain open on 'popstate' events. This is
             * used for navigable dialogs that have their separate navigation handling
             * code.
             */
            ignorePopstate: {
                type: Boolean,
                value: false,
            },
            /**
             * True if the dialog should ignore 'Enter' keypresses.
             */
            ignoreEnterKey: {
                type: Boolean,
                value: false,
            },
            /**
             * True if the dialog should consume 'keydown' events. If ignoreEnterKey
             * is true, 'Enter' key won't be consumed.
             */
            consumeKeydownEvent: {
                type: Boolean,
                value: false,
            },
            /**
             * True if the dialog should not be able to be cancelled, which will
             * prevent 'Escape' key presses from closing the dialog.
             */
            noCancel: {
                type: Boolean,
                value: false,
            },
            // True if dialog should show the 'X' close button.
            showCloseButton: {
                type: Boolean,
                value: false,
            },
            showOnAttach: {
                type: Boolean,
                value: false,
            },
            /**
             * Text for the aria description.
             */
            ariaDescriptionText: String,
        };
    }
    ready() {
        super.ready();
        // If the active history entry changes (i.e. user clicks back button),
        // all open dialogs should be cancelled.
        window.addEventListener('popstate', () => {
            if (!this.ignorePopstate && this.$.dialog.open) {
                this.cancel();
            }
        });
        if (!this.ignoreEnterKey) {
            this.addEventListener('keypress', this.onKeypress_.bind(this));
        }
        this.addEventListener('pointerdown', e => this.onPointerdown_(e));
    }
    connectedCallback() {
        super.connectedCallback();
        const mutationObserverCallback = () => {
            if (this.$.dialog.open) {
                this.enableShadowBehavior(true);
                this.addKeydownListener_();
            }
            else {
                this.enableShadowBehavior(false);
                this.removeKeydownListener_();
            }
        };
        this.mutationObserver_ = new MutationObserver(mutationObserverCallback);
        this.mutationObserver_.observe(this.$.dialog, {
            attributes: true,
            attributeFilter: ['open'],
        });
        // In some cases dialog already has the 'open' attribute by this point.
        mutationObserverCallback();
        if (this.showOnAttach) {
            this.showModal();
        }
    }
    disconnectedCallback() {
        super.disconnectedCallback();
        this.removeKeydownListener_();
        if (this.mutationObserver_) {
            this.mutationObserver_.disconnect();
            this.mutationObserver_ = null;
        }
    }
    addKeydownListener_() {
        if (!this.consumeKeydownEvent) {
            return;
        }
        this.boundKeydown_ = this.boundKeydown_ || this.onKeydown_.bind(this);
        this.addEventListener('keydown', this.boundKeydown_);
        // Sometimes <body> is key event's target and in that case the event
        // will bypass cr-dialog. We should consume those events too in order to
        // behave modally. This prevents accidentally triggering keyboard commands.
        document.body.addEventListener('keydown', this.boundKeydown_);
    }
    removeKeydownListener_() {
        if (!this.boundKeydown_) {
            return;
        }
        this.removeEventListener('keydown', this.boundKeydown_);
        document.body.removeEventListener('keydown', this.boundKeydown_);
        this.boundKeydown_ = null;
    }
    showModal() {
        this.$.dialog.showModal();
        assert(this.$.dialog.open);
        this.open = true;
        this.dispatchEvent(new CustomEvent('cr-dialog-open', { bubbles: true, composed: true }));
    }
    cancel() {
        this.dispatchEvent(new CustomEvent('cancel', { bubbles: true, composed: true }));
        this.$.dialog.close();
        assert(!this.$.dialog.open);
        this.open = false;
    }
    close() {
        this.$.dialog.close('success');
        assert(!this.$.dialog.open);
        this.open = false;
    }
    /**
     * Set the title of the dialog for a11y reader.
     * @param title Title of the dialog.
     */
    setTitleAriaLabel(title) {
        this.$.dialog.removeAttribute('aria-labelledby');
        this.$.dialog.setAttribute('aria-label', title);
    }
    onCloseKeypress_(e) {
        // Because the dialog may have a default Enter key handler, prevent
        // keypress events from bubbling up from this element.
        e.stopPropagation();
    }
    onNativeDialogClose_(e) {
        // Ignore any 'close' events not fired directly by the <dialog> element.
        if (e.target !== this.getNative()) {
            return;
        }
        // Catch and re-fire the 'close' event such that it bubbles across Shadow
        // DOM v1.
        this.dispatchEvent(new CustomEvent('close', { bubbles: true, composed: true }));
    }
    onNativeDialogCancel_(e) {
        // Ignore any 'cancel' events not fired directly by the <dialog> element.
        if (e.target !== this.getNative()) {
            return;
        }
        if (this.noCancel) {
            e.preventDefault();
            return;
        }
        // When the dialog is dismissed using the 'Esc' key, need to manually update
        // the |open| property (since close() is not called).
        this.open = false;
        // Catch and re-fire the native 'cancel' event such that it bubbles across
        // Shadow DOM v1.
        this.dispatchEvent(new CustomEvent('cancel', { bubbles: true, composed: true }));
    }
    /**
     * Expose the inner native <dialog> for some rare cases where it needs to be
     * directly accessed (for example to programmatically setheight/width, which
     * would not work on the wrapper).
     */
    getNative() {
        return this.$.dialog;
    }
    onKeypress_(e) {
        if (e.key !== 'Enter') {
            return;
        }
        // Accept Enter keys from either the dialog itself, or a child cr-input,
        // considering that the event may have been retargeted, for example if the
        // cr-input is nested inside another element. Also exclude inputs of type
        // 'search', since hitting 'Enter' on a search field most likely intends to
        // trigger searching.
        const accept = e.target === this ||
            e.composedPath().some(el => el.tagName === 'CR-INPUT' &&
                el.type !== 'search');
        if (!accept) {
            return;
        }
        const actionButton = this.querySelector('.action-button:not([disabled]):not([hidden])');
        if (actionButton) {
            actionButton.click();
            e.preventDefault();
        }
    }
    onKeydown_(e) {
        assert(this.consumeKeydownEvent);
        if (!this.getNative().open) {
            return;
        }
        if (this.ignoreEnterKey && e.key === 'Enter') {
            return;
        }
        // Stop propagation to behave modally.
        e.stopPropagation();
    }
    onPointerdown_(e) {
        // Only show pulse animation if user left-clicked outside of the dialog
        // contents.
        if (e.button !== 0 ||
            e.composedPath()[0].tagName !== 'DIALOG') {
            return;
        }
        this.$.dialog.animate([
            { transform: 'scale(1)', offset: 0 },
            { transform: 'scale(1.02)', offset: 0.4 },
            { transform: 'scale(1.02)', offset: 0.6 },
            { transform: 'scale(1)', offset: 1 },
        ], {
            duration: 180,
            easing: 'ease-in-out',
            iterations: 1,
        });
        // Prevent any text from being selected within the dialog when clicking in
        // the backdrop area.
        e.preventDefault();
    }
    focus() {
        const titleContainer = this.shadowRoot.querySelector('.title-container');
        assert(titleContainer);
        titleContainer.focus();
    }
}
customElements.define(CrDialogElement.is, CrDialogElement);

function getTemplate$a() {
    return html `<!--_html_template_start_--><style>
  :host {
    --cr-toast-background: var(--cros-toast-background-color);
    --cr-toast-button-color: var(--cros-toast-button-color);
    --cr-toast-text-color: var(--cros-toast-text-color);
    --iron-icon-fill-color: var(--cros-toast-icon-color);
  }

  :host {
    align-items: center;
    background: var(--cr-toast-background);
    border-radius: 4px;
    bottom: 0;
    box-shadow: 0 2px 4px 0 rgba(0, 0, 0, 0.28);
    box-sizing: border-box;
    display: flex;
    margin: 24px;
    max-width: 568px;
    min-height: 52px;
    min-width: 288px;
    opacity: 0;
    padding: 0 24px;
    position: fixed;
    transform: translateY(100px);
    transition: opacity 300ms, transform 300ms;
    visibility: hidden;
    z-index: 1;
  }

  :host-context([chrome-refresh-2023]):host {
    border-radius: 8px;
    line-height: 20px;
    padding: 0 16px;
  }

  :host-context([dir=ltr]) {
    left: 0;
  }

  :host-context([dir=rtl]) {
    right: 0;
  }

  :host([open]) {
    opacity: 1;
    transform: translateY(0);
    visibility: visible;
  }

  /* Note: this doesn't work on slotted text nodes. Something like
   * <cr-toast>hey!</cr-toast> wont get the right text color. */
  :host ::slotted(*) {
    color: var(--cr-toast-text-color);
  }

  :host ::slotted(cr-button) {
    background-color: transparent !important;
    border: none !important;
    color: var(--cr-toast-button-color) !important;
    margin-inline-start: 32px !important;
    min-width: 52px !important;
    padding: 8px !important;
  }

  :host ::slotted(cr-button:hover) {
    background-color: transparent !important;
  }

  :host-context([chrome-refresh-2023]) ::slotted(cr-button:last-of-type) {
    margin-inline-end: -8px;
  }
</style>
<slot></slot>
<!--_html_template_end_-->`;
}

// Copyright 2017 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview A lightweight toast.
 *
 * Forked from ui/webui/resources/cr_elements/cr_toast/cr_toast.ts
 */
class CrToastElement extends PolymerElement {
    constructor() {
        super(...arguments);
        this.hideTimeoutId_ = null;
    }
    static get is() {
        return 'cr-toast';
    }
    static get template() {
        return getTemplate$a();
    }
    static get properties() {
        return {
            duration: {
                type: Number,
                value: 0,
            },
            open: {
                readOnly: true,
                type: Boolean,
                value: false,
                reflectToAttribute: true,
            },
        };
    }
    static get observers() {
        return ['resetAutoHide_(duration, open)'];
    }
    /**
     * Cancels existing auto-hide, and sets up new auto-hide.
     */
    resetAutoHide_() {
        if (this.hideTimeoutId_ !== null) {
            window.clearTimeout(this.hideTimeoutId_);
            this.hideTimeoutId_ = null;
        }
        if (this.open && this.duration !== 0) {
            this.hideTimeoutId_ = window.setTimeout(() => {
                this.hide();
            }, this.duration);
        }
    }
    /**
     * Shows the toast and auto-hides after |this.duration| milliseconds has
     * passed. If the toast is currently being shown, any preexisting auto-hide
     * is cancelled and replaced with a new auto-hide.
     */
    show() {
        // Force autohide to reset if calling show on an already shown toast.
        const shouldResetAutohide = this.open;
        // The role attribute is removed first so that screen readers to better
        // ensure that screen readers will read out the content inside the toast.
        // If the role is not removed and re-added back in, certain screen readers
        // do not read out the contents, especially if the text remains exactly
        // the same as a previous toast.
        this.removeAttribute('role');
        // Reset the aria-hidden attribute as screen readers need to access the
        // contents of an opened toast.
        this.removeAttribute('aria-hidden');
        this._setOpen(true);
        this.setAttribute('role', 'alert');
        if (shouldResetAutohide) {
            this.resetAutoHide_();
        }
    }
    /**
     * Hides the toast and ensures that screen readers cannot its contents while
     * hidden.
     */
    hide() {
        this.setAttribute('aria-hidden', 'true');
        this._setOpen(false);
    }
}
customElements.define(CrToastElement.is, CrToastElement);

function getTemplate$9() {
    return html `<!--_html_template_start_--><style>:host{--cr-toggle-checked-bar-color:var(--google-blue-600);--cr-toggle-checked-button-color:var(--google-blue-600);--cr-toggle-checked-ripple-color:rgba(var(--google-blue-600-rgb),.2);--cr-toggle-ripple-diameter:40px;--cr-toggle-unchecked-bar-color:var(--google-grey-400);--cr-toggle-unchecked-button-color:white;--cr-toggle-unchecked-ripple-color:rgba(var(--google-grey-600-rgb),.15);-webkit-tap-highlight-color:transparent;cursor:pointer;display:block;min-width:34px;outline:none;position:relative;width:34px}:host-context([chrome-refresh-2023]):host{--cr-toggle-checked-bar-color:var(--color-toggle-button-track-on,var(--cr-fallback-color-primary));--cr-toggle-checked-button-color:var(--color-toggle-button-thumb-on,var(--cr-fallback-color-on-primary));--cr-toggle-unchecked-bar-color:var(--color-toggle-button-track-off,var(--cr-fallback-color-surface-variant));--cr-toggle-unchecked-button-color:var(--color-toggle-button-thumb-off,var(--cr-fallback-color-outline));--cr-toggle-disabled-opacity:1;--cr-toggle-checked-ripple-color:var(--cr-active-background-color);--cr-toggle-unchecked-ripple-color:var(--cr-active-background-color);--cr-toggle-ripple-diameter:20px;--cr-toggle-bar-border-color:var(--cr-toggle-unchecked-button-color);--cr-toggle-bar-border:1px solid var(--cr-toggle-bar-border-color);--cr-toggle-bar-width:26px;--cr-toggle-knob-diameter:8px;height:fit-content;isolation:isolate;min-width:initial;width:fit-content}@media (forced-colors:active){:host{forced-color-adjust:none}}@media (prefers-color-scheme:dark){:host{--cr-toggle-checked-bar-color:var(--google-blue-300);--cr-toggle-checked-button-color:var(--google-blue-300);--cr-toggle-checked-ripple-color:rgba(var(--google-blue-300-rgb),.4);--cr-toggle-unchecked-bar-color:var(--google-grey-500);--cr-toggle-unchecked-button-color:var(--google-grey-300);--cr-toggle-unchecked-ripple-color:rgba(var(--google-grey-300-rgb),.4)}}:host([dark]){--cr-toggle-checked-bar-color:var(--google-blue-300);--cr-toggle-checked-button-color:var(--google-blue-300);--cr-toggle-checked-ripple-color:rgba(var(--google-blue-300-rgb),.4);--cr-toggle-unchecked-bar-color:var(--google-grey-500);--cr-toggle-unchecked-button-color:var(--google-grey-300);--cr-toggle-unchecked-ripple-color:rgba(var(--google-grey-300-rgb),.4)}:host-context([chrome-refresh-2023]):host(:active){--cr-toggle-knob-diameter:10px}:host-context([chrome-refresh-2023]):host([checked]){--cr-toggle-bar-border-color:var(--cr-toggle-checked-bar-color);--cr-toggle-knob-diameter:12px}:host-context([chrome-refresh-2023]):host([checked]:active){--cr-toggle-knob-diameter:14px}:host([disabled]){cursor:initial;opacity:var(--cr-disabled-opacity);pointer-events:none}:host-context([chrome-refresh-2023]):host([disabled]){--cr-toggle-checked-bar-color:var(--color-toggle-button-track-on-disabled,var(--cr-fallback-color-disabled-background));--cr-toggle-checked-button-color:var(--color-toggle-button-thumb-on-disabled,var(--cr-fallback-color-surface));--cr-toggle-unchecked-bar-color:transparent;--cr-toggle-unchecked-button-color:var(--color-toggle-button-thumb-off-disabled,var(--cr-fallback-color-disabled-foreground));--cr-toggle-bar-border-color:var(--cr-toggle-unchecked-button-color);opacity:var(--cr-toggle-disabled-opacity)}:host-context([chrome-refresh-2023]):host([checked][disabled]){--cr-toggle-bar-border:none}#bar{background-color:var(--cr-toggle-unchecked-bar-color);border-radius:8px;height:12px;left:3px;position:absolute;top:2px;transition:background-color linear 80ms;width:28px;z-index:0}:host([checked]) #bar{background-color:var(--cr-toggle-checked-bar-color);opacity:var(--cr-toggle-checked-bar-opacity,0.5)}:host-context([chrome-refresh-2023]) #bar{border:var(--cr-toggle-bar-border);border-radius:50px;box-sizing:border-box;display:block;height:16px;opacity:1;position:initial;width:var(--cr-toggle-bar-width)}:host-context([chrome-refresh-2023]):host(:focus-visible) #bar{outline:2px solid var(--cr-toggle-checked-bar-color);outline-offset:2px}#knob{background-color:var(--cr-toggle-unchecked-button-color);border-radius:50%;box-shadow:var(--cr-toggle-box-shadow,0 1px 3px 0 rgba(0,0,0,.4));display:block;height:16px;position:relative;transition:transform linear 80ms,background-color linear 80ms;width:16px;z-index:1}:host([checked]) #knob{background-color:var(--cr-toggle-checked-button-color);transform:translate3d(18px,0,0)}:host-context([dir=rtl]):host([checked]) #knob{transform:translate3d(-18px,0,0)}:host-context([chrome-refresh-2023]) #knob{--cr-toggle-knob-center-edge-distance_:8px;--cr-toggle-knob-direction_:1;--cr-toggle-knob-travel-distance_:calc(0.5 * var(--cr-toggle-bar-width) - var(--cr-toggle-knob-center-edge-distance_));--cr-toggle-knob-position-center_:calc(0.5 * var(--cr-toggle-bar-width) + -50%);--cr-toggle-knob-position-start_:calc(var(--cr-toggle-knob-position-center_) - var(--cr-toggle-knob-direction_) * var(--cr-toggle-knob-travel-distance_));--cr-toggle-knob-position-end_:calc(var(--cr-toggle-knob-position-center_) + var(--cr-toggle-knob-direction_) * var(--cr-toggle-knob-travel-distance_));box-shadow:none;height:var(--cr-toggle-knob-diameter);position:absolute;top:50%;transform:translate(var(--cr-toggle-knob-position-start_),-50%);transition:transform linear 80ms,background-color linear 80ms,width linear 80ms,height linear 80ms;width:var(--cr-toggle-knob-diameter)}:host-context([dir=rtl][chrome-refresh-2023]) #knob{left:0;--cr-toggle-knob-direction_:-1}:host-context([chrome-refresh-2023]):host([checked]) #knob{transform:translate(var(--cr-toggle-knob-position-end_),-50%)}:host-context([chrome-refresh-2023]):host([checked]:active) #knob,:host-context([chrome-refresh-2023]):host([checked]:hover) #knob{--cr-toggle-checked-button-color:var(--color-toggle-button-thumb-on-hover,var(--cr-fallback-color-primary-container))}:host-context([chrome-refresh-2023]):host(:hover) #knob::before{background-color:var(--cr-hover-background-color);border-radius:50%;content:'';height:var(--cr-toggle-ripple-diameter);left:calc(var(--cr-toggle-knob-diameter) / 2);position:absolute;top:calc(var(--cr-toggle-knob-diameter) / 2);transform:translate(-50%,-50%);width:var(--cr-toggle-ripple-diameter)}paper-ripple{--paper-ripple-opacity:1;color:var(--cr-toggle-unchecked-ripple-color);height:var(--cr-toggle-ripple-diameter);left:50%;outline:var(--cr-toggle-ripple-ring,none);pointer-events:none;position:absolute;top:50%;transform:translate(-50%,-50%);transition:color linear 80ms;width:var(--cr-toggle-ripple-diameter)}:host([checked]) paper-ripple{color:var(--cr-toggle-checked-ripple-color)}:host-context([dir=rtl]) paper-ripple{left:auto;right:50%;transform:translate(50%,-50%)}</style>
<span id="bar"></span>
<span id="knob"></span>
<!--_html_template_end_-->`;
}

// Copyright 2017 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * Number of pixels required to move to consider the pointermove event as
 * intentional.
 */
const MOVE_THRESHOLD_PX = 5;
const CrToggleElementBase = PaperRippleMixin(PolymerElement);
class CrToggleElement extends CrToggleElementBase {
    constructor() {
        super(...arguments);
        this.boundPointerMove_ = null;
        /**
         * Whether the state of the toggle has already taken into account by
         * |pointeremove| handlers. Used in the 'click' handler.
         */
        this.handledInPointerMove_ = false;
        this.pointerDownX_ = 0;
    }
    static get is() {
        return 'cr-toggle';
    }
    static get template() {
        return getTemplate$9();
    }
    static get properties() {
        return {
            checked: {
                type: Boolean,
                value: false,
                reflectToAttribute: true,
                observer: 'checkedChanged_',
                notify: true,
            },
            dark: {
                type: Boolean,
                value: false,
                reflectToAttribute: true,
            },
            disabled: {
                type: Boolean,
                value: false,
                reflectToAttribute: true,
                observer: 'disabledChanged_',
            },
        };
    }
    ready() {
        super.ready();
        if (!this.hasAttribute('role')) {
            this.setAttribute('role', 'button');
        }
        if (!this.hasAttribute('tabindex')) {
            this.setAttribute('tabindex', '0');
        }
        this.setAttribute('aria-pressed', this.checked ? 'true' : 'false');
        this.setAttribute('aria-disabled', this.disabled ? 'true' : 'false');
        if (!document.documentElement.hasAttribute('chrome-refresh-2023')) {
            this.addEventListener('blur', this.hideRipple_.bind(this));
            this.addEventListener('focus', this.onFocus_.bind(this));
        }
        this.addEventListener('click', this.onClick_.bind(this));
        this.addEventListener('keydown', this.onKeyDown_.bind(this));
        this.addEventListener('keyup', this.onKeyUp_.bind(this));
        this.addEventListener('pointerdown', this.onPointerDown_.bind(this));
        this.addEventListener('pointerup', this.onPointerUp_.bind(this));
    }
    connectedCallback() {
        super.connectedCallback();
        const direction = this.matches(':host-context([dir=rtl]) cr-toggle') ? -1 : 1;
        this.boundPointerMove_ = (e) => {
            // Prevent unwanted text selection to occur while moving the pointer, this
            // is important.
            e.preventDefault();
            const diff = e.clientX - this.pointerDownX_;
            if (Math.abs(diff) < MOVE_THRESHOLD_PX) {
                return;
            }
            this.handledInPointerMove_ = true;
            const shouldToggle = (diff * direction < 0 && this.checked) ||
                (diff * direction > 0 && !this.checked);
            if (shouldToggle) {
                this.toggleState_(/* fromKeyboard= */ false);
            }
        };
    }
    checkedChanged_() {
        this.setAttribute('aria-pressed', this.checked ? 'true' : 'false');
    }
    disabledChanged_() {
        this.setAttribute('tabindex', this.disabled ? '-1' : '0');
        this.setAttribute('aria-disabled', this.disabled ? 'true' : 'false');
    }
    onFocus_() {
        this.getRipple().showAndHoldDown();
    }
    hideRipple_() {
        this.getRipple().clear();
    }
    onPointerUp_() {
        assert(this.boundPointerMove_);
        this.removeEventListener('pointermove', this.boundPointerMove_);
        this.hideRipple_();
    }
    onPointerDown_(e) {
        // Don't do anything if this was not a primary button click or touch event.
        if (e.button !== 0) {
            return;
        }
        // This is necessary to have follow up pointer events fire on |this|, even
        // if they occur outside of its bounds.
        this.setPointerCapture(e.pointerId);
        this.pointerDownX_ = e.clientX;
        this.handledInPointerMove_ = false;
        assert(this.boundPointerMove_);
        this.addEventListener('pointermove', this.boundPointerMove_);
    }
    onClick_(e) {
        // Prevent |click| event from bubbling. It can cause parents of this
        // elements to erroneously re-toggle this control.
        e.stopPropagation();
        e.preventDefault();
        // User gesture has already been taken care of inside |pointermove|
        // handlers, Do nothing here.
        if (this.handledInPointerMove_) {
            return;
        }
        // If no pointermove event fired, then user just clicked on the
        // toggle button and therefore it should be toggled.
        this.toggleState_(/* fromKeyboard= */ false);
    }
    toggleState_(fromKeyboard) {
        // Ignore cases where the 'click' or 'keypress' handlers are triggered while
        // disabled.
        if (this.disabled) {
            return;
        }
        if (!fromKeyboard) {
            this.hideRipple_();
        }
        this.checked = !this.checked;
        this.dispatchEvent(new CustomEvent('change', { bubbles: true, composed: true, detail: this.checked }));
    }
    onKeyDown_(e) {
        if (e.key !== ' ' && e.key !== 'Enter') {
            return;
        }
        e.preventDefault();
        e.stopPropagation();
        if (e.repeat) {
            return;
        }
        if (e.key === 'Enter') {
            this.toggleState_(/* fromKeyboard= */ true);
        }
    }
    onKeyUp_(e) {
        if (e.key !== ' ' && e.key !== 'Enter') {
            return;
        }
        e.preventDefault();
        e.stopPropagation();
        if (e.key === ' ') {
            this.toggleState_(/* fromKeyboard= */ true);
        }
    }
    // Overridden from PaperRippleMixin
    /* eslint-disable-next-line @typescript-eslint/naming-convention */
    _createRipple() {
        this._rippleContainer = this.$.knob;
        const ripple = super._createRipple();
        ripple.id = 'ink';
        ripple.setAttribute('recenters', '');
        ripple.classList.add('circle');
        return ripple;
    }
}
customElements.define(CrToggleElement.is, CrToggleElement);

// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
// Different flavors of the XfBulkPinningDialog.
var DialogState;
(function (DialogState) {
    // The dialog is not displayed.
    DialogState[DialogState["CLOSED"] = 0] = "CLOSED";
    // Currently offline. Cannot compute space requirement for the time being.
    DialogState[DialogState["OFFLINE"] = 1] = "OFFLINE";
    // Currently not running due to battery saver mode active.
    DialogState[DialogState["BATTERY_SAVER"] = 2] = "BATTERY_SAVER";
    // Listing files and computing space requirements.
    DialogState[DialogState["LISTING"] = 3] = "LISTING";
    // An error occurred while computing the space requirements.
    DialogState[DialogState["ERROR"] = 4] = "ERROR";
    // There isn't enough space to activate the bulk-pinning feature.
    DialogState[DialogState["NOT_ENOUGH_SPACE"] = 5] = "NOT_ENOUGH_SPACE";
    // Computed space requirements and ready to activate the bulk-pinning feature.
    DialogState[DialogState["READY"] = 6] = "READY";
})(DialogState || (DialogState = {}));
const BulkPinStage = chrome.fileManagerPrivate.BulkPinStage;
/**
 * Dialog that shows the benefits of enabling bulk pinning along with storage
 * information if the feature can't be enabled.
 */
let XfBulkPinningDialog = class XfBulkPinningDialog extends XfBase {
    constructor() {
        super(...arguments);
        this.store_ = getStore();
        this.stage_ = '';
        this.requiredBytes_ = 0;
        this.freeBytes_ = 0;
        this.listedFiles_ = 0;
        this.updateListedFilesDebounced_ = new RateLimiter(() => this.updateListedFiles_(), 5000);
    }
    updateListedFiles_() {
        if (this.listedFiles_ === 0) {
            this.$listingFilesText_.innerText = str('BULK_PINNING_LISTING');
        }
        else if (this.listedFiles_ === 1) {
            this.$listingFilesText_.innerText =
                str('BULK_PINNING_LISTING_WITH_SINGLE_ITEM');
        }
        else {
            this.$listingFilesText_.innerText = strf('BULK_PINNING_LISTING_WITH_MULTIPLE_ITEMS', this.listedFiles_.toLocaleString(getCurrentLocaleOrDefault()));
        }
    }
    // Called when the app has changed state.
    onStateChanged(state) {
        // If bulk-pinning gets enabled while this dialog is open, just cancel this
        // dialog.
        if (state.preferences?.driveFsBulkPinningEnabled) {
            this.onCancel();
            return;
        }
        // We're only interested in the bulk-pinning part of the app state.
        const bpp = state.bulkPinning;
        if (!bpp) {
            return;
        }
        if (this.freeBytes_ !== bpp.freeSpaceBytes ||
            this.requiredBytes_ !== bpp.requiredSpaceBytes) {
            this.freeBytes_ = bpp.freeSpaceBytes;
            this.requiredBytes_ = bpp.requiredSpaceBytes;
            this.$readyFooter_.innerText = strf('BULK_PINNING_SPACE', bytesToString(this.requiredBytes_), bytesToString(this.freeBytes_));
        }
        if (bpp.stage === BulkPinStage.LISTING_FILES && bpp.listedFiles > 0 &&
            bpp.listedFiles !== this.listedFiles_) {
            this.listedFiles_ = bpp.listedFiles;
            this.updateListedFilesDebounced_.run();
        }
        if (bpp.stage === this.stage_) {
            return;
        }
        this.stage_ = bpp.stage;
        switch (bpp.stage) {
            case BulkPinStage.PAUSED_OFFLINE:
                this.state = DialogState.OFFLINE;
                break;
            case BulkPinStage.PAUSED_BATTERY_SAVER:
                this.state = DialogState.BATTERY_SAVER;
                break;
            case BulkPinStage.GETTING_FREE_SPACE:
            case BulkPinStage.LISTING_FILES:
                this.state = DialogState.LISTING;
                break;
            case BulkPinStage.SUCCESS:
                this.state = DialogState.READY;
                break;
            case BulkPinStage.SYNCING:
                this.$dialog_.close();
                break;
            case BulkPinStage.NOT_ENOUGH_SPACE:
                this.state = DialogState.NOT_ENOUGH_SPACE;
                break;
            default:
                console.warn(`Cannot calculate bulk-pinning space requirements: ${this.stage_}`);
                this.state = DialogState.ERROR;
                break;
        }
    }
    // Shows the footer matching the given state.
    // Enables or disables the 'Continue' button according to the given state.
    set state(s) {
        this.$offlineFooter_.style.display =
            s === DialogState.OFFLINE ? 'initial' : 'none';
        this.$batterySaverFooter_.style.display =
            s === DialogState.BATTERY_SAVER ? 'initial' : 'none';
        this.$listingFooter_.style.display =
            s === DialogState.LISTING ? 'flex' : 'none';
        this.$errorFooter_.style.display =
            s === DialogState.ERROR ? 'initial' : 'none';
        this.$notEnoughSpaceFooter_.style.display =
            s === DialogState.NOT_ENOUGH_SPACE ? 'initial' : 'none';
        this.$readyFooter_.style.display =
            s === DialogState.READY ? 'initial' : 'none';
        this.$button_.disabled = s !== DialogState.READY;
    }
    // Indicates if this dialog is currently open.
    get is_open() {
        return this.$dialog_.open;
    }
    // Shows the dialog and starts calculating the required space for
    // bulk-pinning.
    async show() {
        this.stage_ = BulkPinStage.LISTING_FILES;
        this.state = DialogState.LISTING;
        this.$dialog_.showModal();
        this.store_.subscribe(this);
        try {
            await calculateBulkPinRequiredSpace();
        }
        catch (e) {
            console.error('Cannot calculate required space for bulk-pinning:', e);
            this.state = DialogState.ERROR;
        }
    }
    onClose(_) {
        this.state = DialogState.CLOSED;
        this.listedFiles_ = 0;
        this.updateListedFilesDebounced_.runImmediately();
        this.store_.unsubscribe(this);
    }
    // Called when the "Continue" button is clicked.
    onContinue() {
        this.$dialog_.close();
        chrome.fileManagerPrivate.setPreferences({ driveFsBulkPinningEnabled: true });
    }
    // Called when the "Cancel" button is clicked.
    onCancel() {
        this.$dialog_.cancel();
    }
    // Called when the "Learn more" link is clicked.
    onLearnMore(e) {
        e.preventDefault();
        visitURL('https://support.google.com/chromebook?p=my_drive_cbx');
    }
    // Called when the "View storage" link is clicked.
    onViewStorage(e) {
        e.preventDefault();
        chrome.fileManagerPrivate.openSettingsSubpage('storage');
    }
    render() {
        return html$1 `
      <cr-dialog @close="${this.onClose}">
        <div slot="title">
          <xf-icon type="drive_bulk_pinning" size="medium"></xf-icon>
          <div class="title" style="flex: 1 0 0">
            ${str('BULK_PINNING_TITLE')}
          </div>
        </div>
        <div slot="body">
          <div class="description">
            ${str('BULK_PINNING_EXPLANATION')}
            <a id="learn-more-link" href="_blank" @click="${this.onLearnMore}">
              ${str('LEARN_MORE_LABEL')}
            </a>
          </div>
          <ul>
            <li>
              <xf-icon type="my_files"></xf-icon>
              ${str('BULK_PINNING_POINT_1')}
            </li>
          </ul>
          <div id="offline-footer" class="offline-footer">
            ${str('BULK_PINNING_OFFLINE')}
          </div>
          <div id="battery-saver-footer" class="battery-saver-footer">
            ${str('BULK_PINNING_BATTERY_SAVER')}
          </div>
          <div id="listing-footer" class="normal-footer">
            <files-spinner></files-spinner>
            <span id="listing-files-text">
              ${str('BULK_PINNING_LISTING')}
            </span>
          </div>
          <div id="error-footer" class="error-footer">
            ${str('BULK_PINNING_ERROR')}
          </div>
          <div id="not-enough-space-footer" class="error-footer">
            ${str('BULK_PINNING_NOT_ENOUGH_SPACE')}
            <a id="view-storage-link" href="_blank"
              @click="${this.onViewStorage}">
              ${str('BULK_PINNING_VIEW_STORAGE')}
            </a>
          </div>
          <div id="ready-footer" class="normal-footer"></div>
        </div>
        <div slot="button-container">
          <cr-button id="cancel-button" class="cancel-button"
            @click="${this.onCancel}">
            ${str('CANCEL_LABEL')}
          </cr-button>
          <cr-button id="continue-button" class="continue-button action-button"
            @click="${this.onContinue}">
            ${str('BULK_PINNING_TURN_ON')}
          </cr-button>
        </div>
      </cr-dialog>
    `;
    }
    static get styles() {
        return css `
      cr-dialog {
        --cr-dialog-background-color: var(--cros-sys-dialog_container);
        --cr-dialog-body-padding-horizontal: 0;
        --cr-dialog-button-container-padding-bottom: 0;
        --cr-dialog-button-container-padding-horizontal: 0;
        --cr-dialog-title-slot-padding-bottom: 16px;
        --cr-dialog-title-slot-padding-end: 0;
        --cr-dialog-title-slot-padding-start: 0;
        --cr-dialog-title-slot-padding-top: 0;
        --cr-primary-text-color: var(--cros-sys-on_surface);
        --cr-secondary-text-color: var(--cros-sys-on_surface_variant);
      }

      cr-dialog::part(dialog) {
        border-radius: 20px;
      }

      cr-dialog::part(dialog)::backdrop {
        background-color: var(--cros-sys-scrim);
      }

      cr-dialog::part(wrapper) {
        padding: 32px;
        padding-bottom: 28px;
      }

      cr-dialog [slot="body"] {
        display: flex;
        flex-direction: column;
        font: var(--cros-body-1-font);
      }

      cr-dialog [slot="button-container"] {
        padding-top: 32px;
      }

      cr-dialog [slot="title"] {
        align-items: center;
        display: flex;
        font: var(--cros-display-7-font);
      }

      cr-dialog [slot="title"] xf-icon {
        --xf-icon-color: var(--cros-sys-primary);
        margin-inline-end: 16px;
      }

      .description {
        margin-bottom: 24px;
      }

      ul {
        border-radius: 12px 12px 0 0;
        border: 1px solid var(--cros-separator-color);
        border-bottom-style: none;
        margin: 0;
        padding: 20px 18px;
      }

      .normal-footer {
        align-items: center;
        background-color: var(--cros-sys-app_base_shaded);
        border: 1px solid var(--cros-separator-color);
        border-radius: 0 0 12px 12px;
        border-top-style: none;
        color: var(--cros-sys-on_surface);
        padding: 16px;
      }

      .error-footer {
        background-color: var(--cros-sys-error_container);
        border: 1px solid var(--cros-separator-color);
        border-radius: 0 0 12px 12px;
        border-top-style: none;
        color: var(--cros-sys-on_error_container);
        padding: 16px;
      }

      .offline-footer, .battery-saver-footer {
        background-color: var(--cros-sys-surface_variant);
        border: 1px solid var(--cros-separator-color);
        border-radius: 0 0 12px 12px;
        border-top-style: none;
        color: var(--cros-sys-on_surface_variant);
        padding: 16px;
      }

      a {
        color: var(--cros-sys-primary);
      }

      .error-footer > a {
        color: inherit;
      }

      files-spinner {
        transform: scale(0.666);
        margin: 0;
        margin-inline-end: 10px;
      }

      li {
        color: var(--cros-sys-on_surface);
        display: flex;
      }

      li + li {
        margin-top: 16px;
      }

      li > xf-icon {
        --xf-icon-color: var(--cros-sys-secondary);
        margin-inline-end: 10px;
      }

      cr-button {
        --active-bg: transparent;
        --active-shadow: none;
        --active-shadow-action: none;
        --bg-action: var(--cros-sys-primary);
        --cr-button-height: 36px;
        --disabled-bg-action: var(--cros-sys-disabled_container);
        --disabled-bg: var(--cros-sys-disabled_container);
        --disabled-text-color: var(--cros-sys-disabled);
        --hover-bg-action: var(--cros-sys-primary);
        --hover-bg-color: var(--cros-sys-primary_container);
        --ink-color: var(--cros-sys-ripple_primary);
        --ripple-opacity-action: 1;
        --ripple-opacity: 1;
        --text-color-action: var(--cros-sys-on_primary);
        --text-color: var(--cros-sys-on_primary_container);
        border: none;
        border-radius: 18px;
        box-shadow: none;
        font: var(--cros-button-2-font);
        position: relative;
      }

      cr-button.cancel-button {
        background-color: var(--cros-sys-primary_container);
      }

      cr-button.cancel-button:hover::part(hoverBackground) {
        background-color: var(--cros-sys-hover_on_subtle);
        display: block;
      }

      cr-button.action-button:hover::part(hoverBackground) {
        background-color: var(--cros-sys-hover_on_prominent);
        display: block;
      }

      :host-context(.focus-outline-visible) cr-button:focus {
        outline: 2px solid var(--cros-sys-focus_ring);
        outline-offset: 2px;
      }
    `;
    }
};
__decorate([
    query('cr-dialog')
], XfBulkPinningDialog.prototype, "$dialog_", void 0);
__decorate([
    query('#continue-button')
], XfBulkPinningDialog.prototype, "$button_", void 0);
__decorate([
    query('#offline-footer')
], XfBulkPinningDialog.prototype, "$offlineFooter_", void 0);
__decorate([
    query('#battery-saver-footer')
], XfBulkPinningDialog.prototype, "$batterySaverFooter_", void 0);
__decorate([
    query('#listing-footer')
], XfBulkPinningDialog.prototype, "$listingFooter_", void 0);
__decorate([
    query('#error-footer')
], XfBulkPinningDialog.prototype, "$errorFooter_", void 0);
__decorate([
    query('#not-enough-space-footer')
], XfBulkPinningDialog.prototype, "$notEnoughSpaceFooter_", void 0);
__decorate([
    query('#ready-footer')
], XfBulkPinningDialog.prototype, "$readyFooter_", void 0);
__decorate([
    query('#listing-files-text')
], XfBulkPinningDialog.prototype, "$listingFilesText_", void 0);
XfBulkPinningDialog = __decorate([
    customElement('xf-bulk-pinning-dialog')
], XfBulkPinningDialog);

function getTemplate$8() {
    return getTrustedHTML `<!--_html_template_start_--><!--
Copyright 2022 The Chromium Authors
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
-->

<style>
  [hidden] {
    display: none !important;
  }

  cr-dialog::part(dialog) {
    --cr-dialog-top-container-min-height: 0px;
    background-color: var(--cros-bg-color-elevation-3);
    border-radius: 12px;
    box-shadow: var(--cros-elevation-3-shadow);
    user-select: none;
    width: 448px;
  }

  cr-dialog::part(dialog)::backdrop {
    background-color: var(--cros-app-shield-60);
  }

  cr-dialog::part(wrapper) {
    /* subtract the internal padding in <cr-dialog> */
    padding: calc(24px - 20px);
  }

  cr-dialog #message {
    color: var(--cros-text-color-primary);
    outline: none;
    padding: 20px 0;
  }

  cr-checkbox {
    margin-bottom: 16px;
    margin-inline-start: 4px;
  }

  cr-dialog [slot=button-container] {
    padding-top: 0;
  }

  cr-button {
    --active-bg: transparent;
    --active-shadow:
      0 1px 2px var(--cros-button-active-shadow-color-key-secondary),
      0 1px 3px var(--cros-button-active-shadow-color-ambient-secondary);
    --active-shadow-action:
      0 1px 2px var(--cros-button-active-shadow-color-key-primary),
      0 1px 3px var(--cros-button-active-shadow-color-ambient-primary);
    --bg-action: var(--cros-button-background-color-primary);
    --border-color: var(--cros-button-stroke-color-secondary);
    --disabled-bg-action:
      var(--cros-button-background-color-primary-disabled);
    --disabled-bg: var(--cros-button-background-color-primary-disabled);
    --disabled-border-color:
      var(--cros-button-stroke-color-secondary-disabled);
    --disabled-text-color: var(--cros-button-label-color-secondary-disabled);
    --hover-bg-action: var(--cros-button-background-color-primary-hover-preblended);
    --hover-bg-color: var(--cros-button-background-color-secondary-hover);
    --hover-border-color: var(--cros-button-stroke-color-secondary-hover);
    --ink-color: var(--cros-button-ripple-color-secondary);
    --ripple-opacity-action: var(--cros-button-primary-ripple-opacity);
    --ripple-opacity: var(--cros-button-secondary-ripple-opacity);
    --text-color-action: var(--cros-button-label-color-primary);
    --text-color: var(--cros-button-label-color-secondary);
  }

  #keepboth {
    margin-inline-start: auto;
  }

  #replace {
    margin-inline-end: 0;
  }

  :host-context(.pointer-active) cr-button:not(:active):hover {
    background: transparent;
    cursor: unset;
  }

  :host-context(.pointer-active) cr-button:focus {
    box-shadow: none;
  }

  :host-context(.focus-outline-visible) cr-button:focus {
    box-shadow: none;
    outline: 2px solid var(--cros-focus-ring-color);
    outline-offset: 2px;
  }
</style>

<cr-dialog id="conflict-dialog" consume-keydown-event>
  <div slot="body">
    <div id="message" tabindex="0">
    </div>
    <cr-checkbox id="checkbox">
      $i18n{CONFLICT_DIALOG_APPLY_TO_ALL}
    </cr-checkbox>
  </div>
  <div slot="button-container">
    <cr-button class="cancel-button" id="cancel">
      $i18n{CANCEL_LABEL}
    </cr-button>
    <cr-button class="cancel-button" id="keepboth">
      $i18n{CONFLICT_DIALOG_KEEP_BOTH}
    </cr-button>
    <cr-button class="cancel-button" id="replace">
      $i18n{CONFLICT_DIALOG_REPLACE}
    </cr-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`;
}

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * Files Conflict Dialog: if the target file of a copy/move operation exists,
 * the conflict dialog can be used to ask the user what to do in that case.
 *
 * The user can choose to 'cancel' the copy/move operation by cancelling the
 * dialog. Otherwise, the user can choose to 'replace' the file or 'keepboth'
 * to keep the file.
 */
class XfConflictDialog extends HTMLElement {
    /**
     * Construct.
     */
    constructor() {
        super();
        /**
         * Mutex used to serialize conflict modal dialog use.
         */
        this.mutex_ = new AsyncQueue();
        /**
         * Either 'keepboth' or 'replace' on dialog success, or an empty string if
         * the dialog was cancelled.
         */
        this.action_ = '';
        // Create element content.
        const template = document.createElement('template');
        template.innerHTML = getTemplate$8();
        const fragment = template.content.cloneNode(true);
        this.attachShadow({ mode: 'open' }).appendChild(fragment);
        this.dialog_ = this.getDialogElement();
        this.resolve_ = console.info;
        this.reject_ = console.info;
    }
    /**
     * DOM connected callback.
     */
    connectedCallback() {
        this.dialog_.addEventListener('close', this.closed_.bind(this));
        this.getCheckboxElement().onchange = this.checked_.bind(this);
        this.getCancelButton().onclick = this.cancel_.bind(this);
        this.getKeepbothButton().onclick = this.keepboth_.bind(this);
        this.getReplaceButton().onclick = this.replace_.bind(this);
    }
    /**
     * Open the modal dialog to ask the user to resolve a conflict for the given
     * |filename|. The default parameters after |filename| are as follows:
     *
     * Set |checkbox| true to display the 'Apply to all' checkbox in the dialog,
     *   and should be set true if there are potentially, multiple file names in
     *   a copy or move operation that conflict. The default is false.
     *
     * Set |directory| true if the |filename| is a directory (aka a folder). The
     *   default is false.
     */
    async show(filename, checkbox = false, directory = false) {
        const unlock = await this.mutex_.lock();
        try {
            return await new Promise((resolve, reject) => {
                this.resolve_ = resolve;
                this.reject_ = reject;
                this.showModal_(filename, checkbox, directory);
            });
        }
        finally {
            unlock();
        }
    }
    /**
     * Resets the dialog for the given |filename| |checkbox| and |folder| values
     * and then shows the modal dialog.
     */
    showModal_(filename, checkbox, folder) {
        const message = // 'A folder named ...' or 'A file named ...'
         folder ? 'CONFLICT_DIALOG_FOLDER_MESSAGE' : 'CONFLICT_DIALOG_MESSAGE';
        this.getMessageElement().innerText = strf(message, filename);
        const applyToAll = this.getCheckboxElement();
        applyToAll.hidden = !checkbox;
        applyToAll.checked = false;
        this.action_ = '';
        this.checked_();
        this.dialog_.showModal();
        this.setFocus_();
    }
    /**
     * The conflict dialog has no title. Remove the <cr-dialog> title child that
     * would focus, remove its <dialog> aria-labelledby and aria-describedby, so
     * ARIA announces the #message (that is the initial focus) once.
     *
     * Per https://w3c.github.io/aria-practices/#dialog_roles_states_props, adds
     * aria-modal='true' meaning all content outside the <dialog> is inert.
     */
    setFocus_() {
        this.dialog_.shadowRoot.querySelector('#title')?.remove();
        const element = this.getHtmlDialogElement();
        element.setAttribute('aria-modal', 'true');
        element.removeAttribute('aria-labelledby');
        element.removeAttribute('aria-describedby');
        this.getMessageElement().focus();
    }
    /**
     * Returns 'dialog' element.
     */
    getDialogElement() {
        return this.shadowRoot.querySelector('#conflict-dialog');
    }
    /**
     * Returns 'dialog' <dialog> element.
     */
    getHtmlDialogElement() {
        return this.dialog_.getNative();
    }
    /**
     * Returns 'message' element.
     */
    getMessageElement() {
        return this.dialog_.querySelector('#message');
    }
    /**
     * Returns 'Apply to all' checkbox element.
     */
    getCheckboxElement() {
        return this.shadowRoot.querySelector('#checkbox');
    }
    /**
     * 'Apply to all' checkbox value changed.
     */
    checked_() {
        const checked = this.getCheckboxElement().checked;
        if (checked) {
            this.getKeepbothButton().innerText = str('CONFLICT_DIALOG_KEEP_ALL');
            this.getReplaceButton().innerText = str('CONFLICT_DIALOG_REPLACE_ALL');
        }
        else {
            this.getKeepbothButton().innerText = str('CONFLICT_DIALOG_KEEP_BOTH');
            this.getReplaceButton().innerText = str('CONFLICT_DIALOG_REPLACE');
        }
        this.getCheckboxElement().focus();
        this.toggleAttribute('checked', checked);
    }
    /**
     * Returns 'cancel' button element.
     */
    getCancelButton() {
        return this.shadowRoot.querySelector('#cancel');
    }
    /**
     * Dialog was cancelled.
     */
    cancel_() {
        this.action_ = '';
        this.dialog_.close();
    }
    /**
     * Returns 'keepboth' button element.
     */
    getKeepbothButton() {
        return this.shadowRoot.querySelector('#keepboth');
    }
    /**
     * Dialog 'keepboth' button was clicked.
     */
    keepboth_() {
        this.action_ = ConflictResolveType.KEEPBOTH;
        this.dialog_.close();
    }
    /*
     * Returns 'replace' button element.
     */
    getReplaceButton() {
        return this.shadowRoot.querySelector('#replace');
    }
    /**
     * Dialog 'replace' button was clicked.
     */
    replace_() {
        this.action_ = ConflictResolveType.REPLACE;
        this.dialog_.close();
    }
    /*
     * Triggered by the modal dialog close(): rejects the Promise if the dialog
     * was cancelled or resolves it with the dialog result.
     */
    closed_() {
        if (!this.action_) {
            this.reject_(new Error('dialog cancelled'));
            return;
        }
        const applyToAll = this.getCheckboxElement().checked;
        this.resolve_({
            resolve: this.action_, // Either 'keepboth' or 'replace'.
            checked: applyToAll, // True or False.
        });
    }
}
var ConflictResolveType;
(function (ConflictResolveType) {
    ConflictResolveType["KEEPBOTH"] = "keepboth";
    ConflictResolveType["REPLACE"] = "replace";
})(ConflictResolveType || (ConflictResolveType = {}));
customElements.define('xf-conflict-dialog', XfConflictDialog);

function getTemplate$7() {
    return getTrustedHTML `<!--_html_template_start_--><style include="cr-shared-style">
    [slot='title'] {
      font: var(--cros-display-7-font);
    }

    [slot='body'] {
      font: var(--cros-body-1-font);
    }

    [slot='body'] #message {
      margin-bottom: 20px;
    }

    cr-dialog::part(dialog) {
      border-radius: 20px;
      box-shadow: var(--cros-elevation-3-shadow);
      max-height: 480px;
      width: 512px;
    }

    cr-dialog {
      --cr-dialog-background-color: var(--cros-sys-dialog_container);
      --cr-dialog-body-padding-horizontal: 0;
      --cr-dialog-button-container-padding-bottom: 0;
      --cr-dialog-button-container-padding-horizontal: 0;
      --cr-dialog-title-slot-padding-bottom: 16px;
      --cr-dialog-title-slot-padding-end: 0;
      --cr-dialog-title-slot-padding-start: 0;
      /* horizontally align with the  close button */
      --cr-dialog-title-slot-padding-top: 8px;
      --cr-primary-text-color: var(--cros-sys-on_surface);
      --cr-secondary-text-color: var(--cros-sys-on_surface_variant);
    }

    cr-dialog::part(dialog)::backdrop {
      background-color: var(--cros-sys-scrim);
    }

    cr-dialog::part(wrapper) {
      padding: 32px;
      padding-bottom: 28px;
    }
</style>

<cr-dialog id="dialog"
  consume-keydown-event show-close-button close-text=$i18n{CLOSE_LABEL}>
  <div slot="title">
    $i18n{DLP_RESTRICTION_DETAILS_TITLE}
  </div>
  <div slot="body">
    <div id="message" cr-dialog-text>$i18n{DLP_RESTRICTION_DETAILS_MESSAGE}</div>
    <div id="details-container">
      <span id="block-details" hidden=true>
        <label>$i18n{DLP_RESTRICTION_DETAILS_BLOCK}</label>
        <ul id="block-list">
          <li id="block-li-urls" hidden=true>
            <label id="block-urls"></label>
          </li>
          <li id="block-li-components" hidden=true>
            <label id="block-components"></label>
          </li>
        </ul>
      </span>
      <span id="warn-details" hidden=true>
        <label>$i18n{DLP_RESTRICTION_DETAILS_WARN}</label>
        <ul id="warn-list">
          <li id="warn-li-urls" hidden=true>
            <label id="warn-urls"></label>
          </li>
          <li id="warn-li-components" hidden=true>
            <label id="warn-components"></label>
          </li>
        </ul>
      </span>
      <span id="report-details" hidden=true>
        <label>$i18n{DLP_RESTRICTION_DETAILS_REPORT}</label>
          <ul id="report-list">
            <li id="report-li-urls" hidden=true>
              <label id="report-urls"></label>
            </li>
            <li id="report-li-components" hidden=true>
              <label id="report-components"></label>
            </li>
          </ul>
        </span>
    </div>
  </div>
</cr-dialog>
<!--_html_template_end_-->`;
}

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * Dialog to show Data Leak Prevention (DLP) restriction details about a file.
 */
class XfDlpRestrictionDetailsDialog extends HTMLElement {
    constructor() {
        super();
        this.details = [];
        // Create element content.
        const template = document.createElement('template');
        template.innerHTML = getTemplate$7();
        const fragment = template.content.cloneNode(true);
        this.attachShadow({ mode: 'open' }).appendChild(fragment);
        this.dialog = this.shadowRoot.querySelector('#dialog');
    }
    /**
     * Shows the dialog.
     * @param details DLP restriction details. Should not be empty and should
     *     contain at most one element per level (only the first one will be
     * used).
     */
    showDlpRestrictionDetailsDialog(details) {
        if (details.length === 0) {
            console.error(`No DLP restriction details to display.`);
            return;
        }
        this.details = details;
        // Add a section for each restriction level.
        this.showDetailsForLevel(chrome.fileManagerPrivate.DlpLevel.BLOCK);
        this.showDetailsForLevel(chrome.fileManagerPrivate.DlpLevel.WARN);
        this.showDetailsForLevel(chrome.fileManagerPrivate.DlpLevel.REPORT);
        this.dialog.showModal();
    }
    /**
     * Renders restriction details for the given level.
     * @param level DLP level. Must be one of BLOCK, WARN, REPORT.
     */
    showDetailsForLevel(level) {
        if (level === chrome.fileManagerPrivate.DlpLevel.ALLOW) {
            console.warn('Should not be called for ALLOW.');
            return;
        }
        const details = this.details.find((d) => d.level === level);
        const detailsContainer = this.shadowRoot?.querySelector(`#${level}-details`);
        if (!details ||
            (details.urls.length === 0 && details.components.length === 0)) {
            detailsContainer.toggleAttribute('hidden', true);
            return;
        }
        detailsContainer.toggleAttribute('hidden', false);
        this.showUrlsForLevel(details.urls, level);
        this.showComponentsForLevel(details.components, level);
    }
    /**
     * If `urls` is not empty, creates a formatted string with the restricted
     * destination URLs and shows it in the label designated for `level`. If
     * `urls` is empty, hides the corresponding element in the dialog. Expects
     * that `level` is one of BLOCK, WARN, REPORT.
     *
     * If the restricted list includes a wildcard, then instead of a list "all
     * urls" is used. In that case, if there's a level with higher priority than
     * the one being rendered, "all urls except..." is used.
     *
     * @param urls List of restricted URLs.
     * @param level DLP level. Must be one of BLOCK, WARN, REPORT.
     */
    showUrlsForLevel(urls, level) {
        if (level === chrome.fileManagerPrivate.DlpLevel.ALLOW) {
            console.warn('Should not be called for ALLOW.');
            return;
        }
        const urlsListItem = this.shadowRoot?.querySelector(`#${level}-li-urls`);
        if (urls.length === 0) {
            urlsListItem.toggleAttribute('hidden', true);
            return;
        }
        urlsListItem.toggleAttribute('hidden', false);
        const urlsLabel = this.shadowRoot?.querySelector(`#${level}-urls`);
        const wildcardIdx = urls.indexOf('*');
        if (wildcardIdx !== -1) {
            const excludedUrls = [];
            // Append "except" all higher levels.
            const higherLevels = this.getHigherLevels(level);
            for (const level of higherLevels) {
                const exceptDetails = this.details.find((d) => d.level === level);
                if (exceptDetails && exceptDetails.urls.length > 0) {
                    excludedUrls.push(exceptDetails.urls);
                }
            }
            if (excludedUrls.length === 0) {
                urlsLabel.textContent = str('DLP_RESTRICTION_DETAILS_FILE_ACCESS_ALL');
            }
            else {
                urlsLabel.textContent = strf('DLP_RESTRICTION_DETAILS_FILE_ACCESS_ALL_EXCEPT', excludedUrls.join(', '));
            }
        }
        else {
            urlsLabel.textContent =
                strf('DLP_RESTRICTION_DETAILS_FILE_ACCESS', urls.join(', '));
        }
    }
    /**
     * @param level Level to be checked.
     * @returns List of levels, if any, with higher priority.
     */
    getHigherLevels(level) {
        switch (level) {
            case chrome.fileManagerPrivate.DlpLevel.BLOCK:
                return [chrome.fileManagerPrivate.DlpLevel.ALLOW];
            case chrome.fileManagerPrivate.DlpLevel.WARN:
                return [
                    chrome.fileManagerPrivate.DlpLevel.ALLOW,
                    chrome.fileManagerPrivate.DlpLevel.BLOCK,
                ];
            case chrome.fileManagerPrivate.DlpLevel.REPORT:
                return [
                    chrome.fileManagerPrivate.DlpLevel.ALLOW,
                    chrome.fileManagerPrivate.DlpLevel.BLOCK,
                    chrome.fileManagerPrivate.DlpLevel.WARN,
                ];
            case chrome.fileManagerPrivate.DlpLevel.ALLOW:
            default:
                return [];
        }
    }
    /**
     * If `components` is not empty, creates a formatted string with the
     * restricted components and shows it in the label designated for `level`. If
     * `components` is empty, hides the corresponding element in the dialog.
     * Expects that `level` is one of BLOCK, WARN, REPORT.
     *
     * @param components List of restricted components.
     * @param level DLP level. Must be one of BLOCK, WARN, REPORT.
     */
    showComponentsForLevel(components, level) {
        if (level === chrome.fileManagerPrivate.DlpLevel.ALLOW) {
            console.warn('Should not be called for ALLOW.');
            return;
        }
        const componentsListItem = this.shadowRoot?.querySelector(`#${level}-li-components`);
        if (components.length === 0) {
            componentsListItem.toggleAttribute('hidden', true);
            return;
        }
        componentsListItem.toggleAttribute('hidden', false);
        const componentsLabel = this.shadowRoot?.querySelector(`#${level}-components`);
        componentsLabel.textContent = strf('DLP_RESTRICTION_DETAILS_FILE_TRANSFER', components.map((component) => this.componentToI18n(component))
            .join(', '));
    }
    componentToI18n(component) {
        switch (component) {
            case chrome.fileManagerPrivate.VolumeType.DRIVE:
                return str('DRIVE_DIRECTORY_LABEL');
            case chrome.fileManagerPrivate.VolumeType.REMOVABLE:
                return str('DLP_COMPONENT_REMOVABLE');
            case chrome.fileManagerPrivate.VolumeType.CROSTINI:
                return str('DLP_COMPONENT_LINUX');
            case chrome.fileManagerPrivate.VolumeType.ANDROID_FILES:
                return str('DLP_COMPONENT_PLAY');
            case chrome.fileManagerPrivate.VolumeType.GUEST_OS:
                return str('DLP_COMPONENT_VM');
            case chrome.fileManagerPrivate.VolumeType.DOCUMENTS_PROVIDER:
                return str('DLP_COMPONENT_MICROSOFT_ONEDRIVE');
            default:
                console.warn(`Got unexpected VolumeType value ${component}.`);
                return '';
        }
    }
}
window.customElements.define('xf-dlp-restriction-details-dialog', XfDlpRestrictionDetailsDialog);

// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const SyncStatus = chrome.fileManagerPrivate.SyncStatus;
/**
 * Sync status element used in both table and grid views that indicates sync
 * progress and file pinning.
 */
let XfInlineStatus = class XfInlineStatus extends XfBase {
    constructor() {
        super(...arguments);
        this.cantPin = false;
        this.availableOffline = false;
        this.progress = 0;
        this.syncStatus = SyncStatus.NOT_FOUND;
    }
    connectedCallback() {
        super.connectedCallback();
        document.querySelector('files-tooltip').addTarget(this);
    }
    static get styles() {
        return getCSS$1();
    }
    render() {
        const { progress, syncStatus, availableOffline, cantPin } = this;
        if (syncStatus !== SyncStatus.NOT_FOUND) {
            // Syncing, hence displaying "queued" or "in progress".
            this.ariaLabel = progress === 0 ?
                str('QUEUED_LABEL') :
                strf('IN_PROGRESS_PERCENTAGE_LABEL', (progress * 100).toFixed(0));
            return html$1 `<xf-pie-progress progress=${progress} />`;
        }
        if (cantPin) {
            this.ariaLabel = str('DRIVE_ITEM_UNAVAILABLE_OFFLINE');
            return this.renderIcon_('cant-pin');
        }
        if (availableOffline) {
            this.ariaLabel = str('OFFLINE_COLUMN_LABEL');
            return this.renderIcon_('offline');
        }
        this.ariaLabel = '';
        return html$1 ``;
    }
    renderIcon_(type) {
        return html$1 `<xf-icon size="extra_small" type="${type}" />`;
    }
};
__decorate([
    property({ type: Boolean, reflect: true, attribute: 'cant-pin' })
], XfInlineStatus.prototype, "cantPin", void 0);
__decorate([
    property({ type: Boolean, reflect: true, attribute: 'available-offline' })
], XfInlineStatus.prototype, "availableOffline", void 0);
__decorate([
    property({ type: Number, reflect: true })
], XfInlineStatus.prototype, "progress", void 0);
__decorate([
    property({ type: SyncStatus, reflect: true, attribute: 'sync-status' })
], XfInlineStatus.prototype, "syncStatus", void 0);
XfInlineStatus = __decorate([
    customElement('xf-inline-status')
], XfInlineStatus);
function getCSS$1() {
    return css `
    xf-pie-progress, xf-icon {
      display: flex;
      height: 16px;
      width: 16px;
    }

    xf-icon {
      --xf-icon-color: currentColor;
    }
  `;
}

// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * Displays a pie shaped progress indicator.
 * Accepts a `progress` property ranging from 0 to 1.
 */
let XfPieProgress = class XfPieProgress extends XfBase {
    constructor() {
        super(...arguments);
        // This should be a number between 0 and 1.
        this.progress = 0;
        this.size = 16; // Size of the SVG square measured by its side length.
        this.center = this.size / 2.0; // Center of the pie circle (both X and Y).
        this.radius = 5.4; // Radius of the pie circle.
        this.outlineShape = svg `
    <circle
      class="outline"
      cx="${this.center}"
      cy="${this.center}"
      r="${this.center}"
    />`;
        this.queuedShape = svg `
    <circle
      class="queued"
      stroke-width="1.6"
      cx="${this.center}"
      cy="${this.center}"
      r="5.6"
    />`;
        this.edgeShape = svg `
    <circle
      class="edge"
      stroke-width="2"
      cx="${this.center}"
      cy="${this.center}"
      r="${this.radius}"
    />`;
    }
    static get styles() {
        return getCSS();
    }
    render() {
        const { progress, size, center, radius } = this;
        const isQueued = progress === 0;
        // The progress pie is drawn as an arc with a thick stroke width (as thick
        // as the radius of the pie).
        const arcRadius = radius * 0.5;
        const maxArcLength = 2.0 * Math.PI * arcRadius;
        const pie = svg `
      <circle class="pie"
        stroke-width="${radius}"
        stroke-dasharray="${maxArcLength}"
        stroke-dashoffset="${maxArcLength * (1 - progress)}"
        cx="${center}"
        cy="${center}"
        r="${arcRadius}"
        transform="rotate(-90, ${center}, ${center})"
        visibility="${isQueued ? 'hidden' : 'visible'}"
      />`;
        const edge = isQueued ? this.queuedShape : this.edgeShape;
        return html$1 `
      <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 ${size} ${size}">
        ${this.outlineShape} ${pie} ${edge}
      </svg>
    `;
    }
};
__decorate([
    property({ type: Number, reflect: true })
], XfPieProgress.prototype, "progress", void 0);
XfPieProgress = __decorate([
    customElement('xf-pie-progress')
], XfPieProgress);
function getCSS() {
    return css `
    svg {
      height: 100%;
      width: 100%;
    }

    .queued {
      fill: none;
      stroke: currentColor
    }

    .edge {
      fill: none;
      stroke: var(--cros-sys-progress);
    }

    .pie {
      fill: none;
      stroke: var(--cros-sys-progress);
      transition: stroke-dashoffset 1s ease-out;
    }

    .outline {
      fill: var(--xf-icon-color-outline, transparent);
      stroke: none;
    }
  `;
}

const template = html `<!--
List commonly used icons here to prevent duplication.
Do not add rarely used icons here; place those in your application.
Note that 20px and 24px icons are specified separately (size="", below).

Icons are rendered at 20x20 px, but we don't have 20 px SVGs for everything.
The 24 px icons are used where 20 px icons are unavailable (which may appear
blurry at 20 px). Please use 20 px icons when available.
-->
<iron-iconset-svg name="cr20" size="20">
  <svg>
    <defs>
      <!--
      Keep these in sorted order by id="".
      -->
      <g id="block">
        <path fill-rule="evenodd" clip-rule="evenodd"
          d="M10 0C4.48 0 0 4.48 0 10C0 15.52 4.48 20 10 20C15.52 20 20 15.52 20 10C20 4.48 15.52 0 10 0ZM2 10C2 5.58 5.58 2 10 2C11.85 2 13.55 2.63 14.9 3.69L3.69 14.9C2.63 13.55 2 11.85 2 10ZM5.1 16.31C6.45 17.37 8.15 18 10 18C14.42 18 18 14.42 18 10C18 8.15 17.37 6.45 16.31 5.1L5.1 16.31Z">
        </path>
      </g>
      <g id="cloud-off">
        <path
          d="M16 18.125L13.875 16H5C3.88889 16 2.94444 15.6111 2.16667 14.8333C1.38889 14.0556 1 13.1111 1 12C1 10.9444 1.36111 10.0347 2.08333 9.27083C2.80556 8.50694 3.6875 8.09028 4.72917 8.02083C4.77083 7.86805 4.8125 7.72222 4.85417 7.58333C4.90972 7.44444 4.97222 7.30555 5.04167 7.16667L1.875 4L2.9375 2.9375L17.0625 17.0625L16 18.125ZM5 14.5H12.375L6.20833 8.33333C6.15278 8.51389 6.09722 8.70139 6.04167 8.89583C6 9.07639 5.95139 9.25694 5.89583 9.4375L4.83333 9.52083C4.16667 9.57639 3.61111 9.84028 3.16667 10.3125C2.72222 10.7708 2.5 11.3333 2.5 12C2.5 12.6944 2.74306 13.2847 3.22917 13.7708C3.71528 14.2569 4.30556 14.5 5 14.5ZM17.5 15.375L16.3958 14.2917C16.7153 14.125 16.9792 13.8819 17.1875 13.5625C17.3958 13.2431 17.5 12.8889 17.5 12.5C17.5 11.9444 17.3056 11.4722 16.9167 11.0833C16.5278 10.6944 16.0556 10.5 15.5 10.5H14.125L14 9.14583C13.9028 8.11806 13.4722 7.25694 12.7083 6.5625C11.9444 5.85417 11.0417 5.5 10 5.5C9.65278 5.5 9.31944 5.54167 9 5.625C8.69444 5.70833 8.39583 5.82639 8.10417 5.97917L7.02083 4.89583C7.46528 4.61806 7.93056 4.40278 8.41667 4.25C8.91667 4.08333 9.44444 4 10 4C11.4306 4 12.6736 4.48611 13.7292 5.45833C14.7847 6.41667 15.375 7.59722 15.5 9C16.4722 9 17.2986 9.34028 17.9792 10.0208C18.6597 10.7014 19 11.5278 19 12.5C19 13.0972 18.8611 13.6458 18.5833 14.1458C18.3194 14.6458 17.9583 15.0556 17.5 15.375Z">
        </path>
      </g>
      <g id="domain">
        <path
          d="M2,3 L2,17 L11.8267655,17 L13.7904799,17 L18,17 L18,7 L12,7 L12,3 L2,3 Z M8,13 L10,13 L10,15 L8,15 L8,13 Z M4,13 L6,13 L6,15 L4,15 L4,13 Z M8,9 L10,9 L10,11 L8,11 L8,9 Z M4,9 L6,9 L6,11 L4,11 L4,9 Z M12,9 L16,9 L16,15 L12,15 L12,9 Z M12,11 L14,11 L14,13 L12,13 L12,11 Z M8,5 L10,5 L10,7 L8,7 L8,5 Z M4,5 L6,5 L6,7 L4,7 L4,5 Z">
        </path>
      </g>
      <g id="kite">
        <path fill-rule="evenodd" clip-rule="evenodd"
          d="M4.6327 8.00094L10.3199 2L16 8.00094L10.1848 16.8673C10.0995 16.9873 10.0071 17.1074 9.90047 17.2199C9.42417 17.7225 8.79147 18 8.11611 18C7.44076 18 6.80806 17.7225 6.33175 17.2199C5.85545 16.7173 5.59242 16.0497 5.59242 15.3371C5.59242 14.977 5.46445 14.647 5.22275 14.3919C4.98104 14.1369 4.66825 14.0019 4.32701 14.0019H4V12.6667H4.32701C5.00237 12.6667 5.63507 12.9442 6.11137 13.4468C6.58768 13.9494 6.85071 14.617 6.85071 15.3296C6.85071 15.6896 6.97867 16.0197 7.22038 16.2747C7.46209 16.5298 7.77488 16.6648 8.11611 16.6648C8.45735 16.6648 8.77014 16.5223 9.01185 16.2747C9.02396 16.2601 9.03607 16.246 9.04808 16.2319C9.08541 16.1883 9.12176 16.1458 9.15403 16.0947L9.55213 15.4946L4.6327 8.00094ZM10.3199 13.9371L6.53802 8.17116L10.3199 4.1814L14.0963 8.17103L10.3199 13.9371Z">
        </path>
      </g>
      <g id="menu">
        <path d="M2 4h16v2H2zM2 9h16v2H2zM2 14h16v2H2z"></path>
      </g>
        <g id="banner-warning">
          <path fill-rule="evenodd" clip-rule="evenodd"
            d="M9.13177 1.50386C9.51566 0.832046 10.4844 0.832046 10.8683 1.50386L18.8683 15.5039C19.2492 16.1705 18.7678 17 18 17H2.00001C1.23219 17 0.750823 16.1705 1.13177 15.5039L9.13177 1.50386ZM10 4.01556L3.72321 15H16.2768L10 4.01556ZM9 11H11V7H9V11ZM11 14H9V12H11V14Z">
          </path>
        </g>
        <g id="warning">
          <path fill-rule="evenodd" clip-rule="evenodd"
            d="M9.13177 1.50386C9.51566 0.832046 10.4844 0.832046 10.8683 1.50386L18.8683 15.5039C19.2492 16.1705 18.7678 17 18 17H2.00001C1.23219 17 0.750823 16.1705 1.13177 15.5039L9.13177 1.50386ZM10 4.01556L3.72321 15H16.2768L10 4.01556ZM9 11H11V7H9V11ZM11 14H9V12H11V14Z">
          </path>
        </g>
  </svg>
</iron-iconset-svg>

<!-- NOTE: In the common case that the final icon will be 20x20, export the SVG
     at 20px and place it in the section above. -->
<iron-iconset-svg name="cr" size="24">
  <svg>
    <defs>
      <!--
      These icons are copied from Polymer's iron-icons and kept in sorted order.
      -->
      <g id="account-child-invert" viewBox="0 0 48 48">
        <path d="M24 4c3.31 0 6 2.69 6 6s-2.69 6-6 6-6-2.69-6-6 2.69-6 6-6z"></path>
        <path fill="none" d="M0 0h48v48H0V0z"></path>
        <circle fill="none" cx="24" cy="26" r="4"></circle>
        <path
          d="M24 18c-6.16 0-13 3.12-13 7.23v11.54c0 2.32 2.19 4.33 5.2 5.63 2.32 1 5.12 1.59 7.8 1.59.66 0 1.33-.06 2-.14v-5.2c-.67.08-1.34.14-2 .14-2.63 0-5.39-.57-7.68-1.55.67-2.12 4.34-3.65 7.68-3.65.86 0 1.75.11 2.6.29 2.79.62 5.2 2.15 5.2 4.04v4.47c3.01-1.31 5.2-3.31 5.2-5.63V25.23C37 21.12 30.16 18 24 18zm0 12c-2.21 0-4-1.79-4-4s1.79-4 4-4 4 1.79 4 4-1.79 4-4 4z">
        </path>
      </g>
      <g id="add">
        <path d="M19 13h-6v6h-2v-6H5v-2h6V5h2v6h6v2z" />
      </g>
      <g id="arrow-back">
        <path
          d="M20 11H7.83l5.59-5.59L12 4l-8 8 8 8 1.41-1.41L7.83 13H20v-2z">
        </path>
      </g>
      <g id="arrow-drop-up">
        <path d="M7 14l5-5 5 5z"></path>
      </g>
      <g id="arrow-drop-down">
        <path d="M7 10l5 5 5-5z"></path>
      </g>
      <g id="arrow-forward">
        <path
          d="M12 4l-1.41 1.41L16.17 11H4v2h12.17l-5.58 5.59L12 20l8-8z">
        </path>
      </g>
      <g id="arrow-right">
        <path d="M10 7l5 5-5 5z"></path>
      </g>
        <g id="bluetooth">
          <path
            d="M17.71 7.71L12 2h-1v7.59L6.41 5 5 6.41 10.59 12 5 17.59 6.41 19 11 14.41V22h1l5.71-5.71-4.3-4.29 4.3-4.29zM13 5.83l1.88 1.88L13 9.59V5.83zm1.88 10.46L13 18.17v-3.76l1.88 1.88z">
          </path>
        </g>
        <g id="camera-alt">
          <circle cx="12" cy="12" r="3.2"></circle>
          <path
            d="M9 2L7.17 4H4c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2h-3.17L15 2H9zm3 15c-2.76 0-5-2.24-5-5s2.24-5 5-5 5 2.24 5 5-2.24 5-5 5z">
          </path>
        </g>
        <g id="work">
          <path
            d="M20 6h-4V4c0-1.11-.89-2-2-2h-4c-1.11 0-2 .89-2 2v2H4c-1.11 0-1.99.89-1.99 2L2 19c0 1.11.89 2 2 2h16c1.11 0 2-.89 2-2V8c0-1.11-.89-2-2-2zm-6 0h-4V4h4v2z">
          </path>
        </g>
      <g id="cancel">
        <path
          d="M12 2C6.47 2 2 6.47 2 12s4.47 10 10 10 10-4.47 10-10S17.53 2 12 2zm5 13.59L15.59 17 12 13.41 8.41 17 7 15.59 10.59 12 7 8.41 8.41 7 12 10.59 15.59 7 17 8.41 13.41 12 17 15.59z">
        </path>
      </g>
      <g id="check">
        <path d="M9 16.17L4.83 12l-1.42 1.41L9 19 21 7l-1.41-1.41z"></path>
      </g>
      <g id="check-circle">
        <path
          d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-2 15l-5-5 1.41-1.41L10 14.17l7.59-7.59L19 8l-9 9z">
        </path>
      </g>
      <g id="chevron-left">
        <path d="M15.41 7.41L14 6l-6 6 6 6 1.41-1.41L10.83 12z"></path>
      </g>
      <g id="chevron-right">
        <path d="M10 6L8.59 7.41 13.17 12l-4.58 4.59L10 18l6-6z"></path>
      </g>
      <g id="clear">
        <path
          d="M19 6.41L17.59 5 12 10.59 6.41 5 5 6.41 10.59 12 5 17.59 6.41 19 12 13.41 17.59 19 19 17.59 13.41 12z">
        </path>
      </g>
      <g id="close">
        <path
          d="M19 6.41L17.59 5 12 10.59 6.41 5 5 6.41 10.59 12 5 17.59 6.41 19 12 13.41 17.59 19 19 17.59 13.41 12z">
        </path>
      </g>
      <g id="computer">
        <path
          d="M20 18c1.1 0 1.99-.9 1.99-2L22 6c0-1.1-.9-2-2-2H4c-1.1 0-2 .9-2 2v10c0 1.1.9 2 2 2H0v2h24v-2h-4zM4 6h16v10H4V6z">
        </path>
      </g>
      <g id="create">
        <path
          d="M3 17.25V21h3.75L17.81 9.94l-3.75-3.75L3 17.25zM20.71 7.04c.39-.39.39-1.02 0-1.41l-2.34-2.34c-.39-.39-1.02-.39-1.41 0l-1.83 1.83 3.75 3.75 1.83-1.83z">
        </path>
      </g>
      <g id="delete">
        <path
          d="M6 19c0 1.1.9 2 2 2h8c1.1 0 2-.9 2-2V7H6v12zM19 4h-3.5l-1-1h-5l-1 1H5v2h14V4z">
        </path>
      </g>
      <g id="domain">
        <path
          d="M12 7V3H2v18h20V7H12zM6 19H4v-2h2v2zm0-4H4v-2h2v2zm0-4H4V9h2v2zm0-4H4V5h2v2zm4 12H8v-2h2v2zm0-4H8v-2h2v2zm0-4H8V9h2v2zm0-4H8V5h2v2zm10 12h-8v-2h2v-2h-2v-2h2v-2h-2V9h8v10zm-2-8h-2v2h2v-2zm0 4h-2v2h2v-2z">
        </path>
      </g>
      <g id="error">
        <path
          d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm1 15h-2v-2h2v2zm0-4h-2V7h2v6z">
        </path>
      </g>
      <g id="error-outline">
        <path
          d="M11 15h2v2h-2zm0-8h2v6h-2zm.99-5C6.47 2 2 6.48 2 12s4.47 10 9.99 10C17.52 22 22 17.52 22 12S17.52 2 11.99 2zM12 20c-4.42 0-8-3.58-8-8s3.58-8 8-8 8 3.58 8 8-3.58 8-8 8z">
        </path>
      </g>
      <g id="expand-less">
        <path d="M12 8l-6 6 1.41 1.41L12 10.83l4.59 4.58L18 14z"></path>
      </g>
      <g id="expand-more">
        <path d="M16.59 8.59L12 13.17 7.41 8.59 6 10l6 6 6-6z"></path>
      </g>
      <g id="extension">
        <path
          d="M20.5 11H19V7c0-1.1-.9-2-2-2h-4V3.5C13 2.12 11.88 1 10.5 1S8 2.12 8 3.5V5H4c-1.1 0-1.99.9-1.99 2v3.8H3.5c1.49 0 2.7 1.21 2.7 2.7s-1.21 2.7-2.7 2.7H2V20c0 1.1.9 2 2 2h3.8v-1.5c0-1.49 1.21-2.7 2.7-2.7 1.49 0 2.7 1.21 2.7 2.7V22H17c1.1 0 2-.9 2-2v-4h1.5c1.38 0 2.5-1.12 2.5-2.5S21.88 11 20.5 11z">
        </path>
      </g>
      <g id="file-download">
        <path d="M19 9h-4V3H9v6H5l7 7 7-7zM5 18v2h14v-2H5z"></path>
      </g>
        <g id="folder-filled">
          <path
            d="M10 4H4c-1.1 0-1.99.9-1.99 2L2 18c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V8c0-1.1-.9-2-2-2h-8l-2-2z">
          </path>
        </g>
      <g id="fullscreen">
        <path
          d="M7 14H5v5h5v-2H7v-3zm-2-4h2V7h3V5H5v5zm12 7h-3v2h5v-5h-2v3zM14 5v2h3v3h2V5h-5z">
        </path>
      </g>
      <g id="group">
        <path
          d="M16 11c1.66 0 2.99-1.34 2.99-3S17.66 5 16 5c-1.66 0-3 1.34-3 3s1.34 3 3 3zm-8 0c1.66 0 2.99-1.34 2.99-3S9.66 5 8 5C6.34 5 5 6.34 5 8s1.34 3 3 3zm0 2c-2.33 0-7 1.17-7 3.5V19h14v-2.5c0-2.33-4.67-3.5-7-3.5zm8 0c-.29 0-.62.02-.97.05 1.16.84 1.97 1.97 1.97 3.45V19h6v-2.5c0-2.33-4.67-3.5-7-3.5z">
        </path>
      </g>
      <g id="help-outline">
        <path
          d="M11 18h2v-2h-2v2zm1-16C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8zm0-14c-2.21 0-4 1.79-4 4h2c0-1.1.9-2 2-2s2 .9 2 2c0 2-3 1.75-3 5h2c0-2.25 3-2.5 3-5 0-2.21-1.79-4-4-4z">
        </path>
      </g>
      <g id="history">
        <path
          d="M12.945312 22.75 C 10.320312 22.75 8.074219 21.839844 6.207031 20.019531 C 4.335938 18.199219 3.359375 15.972656 3.269531 13.34375 L 5.089844 13.34375 C 5.175781 15.472656 5.972656 17.273438 7.480469 18.742188 C 8.988281 20.210938 10.808594 20.945312 12.945312 20.945312 C 15.179688 20.945312 17.070312 20.164062 18.621094 18.601562 C 20.167969 17.039062 20.945312 15.144531 20.945312 12.910156 C 20.945312 10.714844 20.164062 8.855469 18.601562 7.335938 C 17.039062 5.816406 15.15625 5.054688 12.945312 5.054688 C 11.710938 5.054688 10.554688 5.339844 9.480469 5.902344 C 8.402344 6.46875 7.476562 7.226562 6.699219 8.179688 L 9.585938 8.179688 L 9.585938 9.984375 L 3.648438 9.984375 L 3.648438 4.0625 L 5.453125 4.0625 L 5.453125 6.824219 C 6.386719 5.707031 7.503906 4.828125 8.804688 4.199219 C 10.109375 3.566406 11.488281 3.25 12.945312 3.25 C 14.300781 3.25 15.570312 3.503906 16.761719 4.011719 C 17.949219 4.519531 18.988281 5.214844 19.875 6.089844 C 20.761719 6.964844 21.464844 7.992188 21.976562 9.167969 C 22.492188 10.34375 22.75 11.609375 22.75 12.964844 C 22.75 14.316406 22.492188 15.589844 21.976562 16.777344 C 21.464844 17.964844 20.761719 19.003906 19.875 19.882812 C 18.988281 20.765625 17.949219 21.464844 16.761719 21.976562 C 15.570312 22.492188 14.300781 22.75 12.945312 22.75 Z M 16.269531 17.460938 L 12.117188 13.34375 L 12.117188 7.527344 L 13.921875 7.527344 L 13.921875 12.601562 L 17.550781 16.179688 Z M 16.269531 17.460938">
        </path>
      </g>
      <g id="info">
        <path
          d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm1 15h-2v-6h2v6zm0-8h-2V7h2v2z">
        </path>
      </g>
      <g id="info-outline">
        <path
          d="M11 17h2v-6h-2v6zm1-15C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8zM11 9h2V7h-2v2z">
        </path>
      </g>
      <g id="insert-drive-file">
        <path
          d="M6 2c-1.1 0-1.99.9-1.99 2L4 20c0 1.1.89 2 1.99 2H18c1.1 0 2-.9 2-2V8l-6-6H6zm7 7V3.5L18.5 9H13z">
        </path>
      </g>
      <g id="location-on">
        <path
          d="M12 2C8.13 2 5 5.13 5 9c0 5.25 7 13 7 13s7-7.75 7-13c0-3.87-3.13-7-7-7zm0 9.5c-1.38 0-2.5-1.12-2.5-2.5s1.12-2.5 2.5-2.5 2.5 1.12 2.5 2.5-1.12 2.5-2.5 2.5z">
        </path>
      </g>
      <g id="mic">
        <path
          d="M12 14c1.66 0 2.99-1.34 2.99-3L15 5c0-1.66-1.34-3-3-3S9 3.34 9 5v6c0 1.66 1.34 3 3 3zm5.3-3c0 3-2.54 5.1-5.3 5.1S6.7 14 6.7 11H5c0 3.41 2.72 6.23 6 6.72V21h2v-3.28c3.28-.48 6-3.3 6-6.72h-1.7z">
        </path>
      </g>
      <g id="more-vert">
        <path
          d="M12 8c1.1 0 2-.9 2-2s-.9-2-2-2-2 .9-2 2 .9 2 2 2zm0 2c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zm0 6c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2z">
        </path>
      </g>
      <g id="open-in-new">
        <path
          d="M19 19H5V5h7V3H5c-1.11 0-2 .9-2 2v14c0 1.1.89 2 2 2h14c1.1 0 2-.9 2-2v-7h-2v7zM14 3v2h3.59l-9.83 9.83 1.41 1.41L19 6.41V10h2V3h-7z">
        </path>
      </g>
      <g id="person">
        <path
          d="M12 12c2.21 0 4-1.79 4-4s-1.79-4-4-4-4 1.79-4 4 1.79 4 4 4zm0 2c-2.67 0-8 1.34-8 4v2h16v-2c0-2.66-5.33-4-8-4z">
        </path>
      </g>
      <g id="phonelink">
        <path
          d="M4 6h18V4H4c-1.1 0-2 .9-2 2v11H0v3h14v-3H4V6zm19 2h-6c-.55 0-1 .45-1 1v10c0 .55.45 1 1 1h6c.55 0 1-.45 1-1V9c0-.55-.45-1-1-1zm-1 9h-4v-7h4v7z">
        </path>
      </g>
      <g id="print">
        <path
          d="M19 8H5c-1.66 0-3 1.34-3 3v6h4v4h12v-4h4v-6c0-1.66-1.34-3-3-3zm-3 11H8v-5h8v5zm3-7c-.55 0-1-.45-1-1s.45-1 1-1 1 .45 1 1-.45 1-1 1zm-1-9H6v4h12V3z">
        </path>
      </g>
      <g id="schedule">
        <path
          d="M11.99 2C6.47 2 2 6.48 2 12s4.47 10 9.99 10C17.52 22 22 17.52 22 12S17.52 2 11.99 2zM12 20c-4.42 0-8-3.58-8-8s3.58-8 8-8 8 3.58 8 8-3.58 8-8 8zm.5-13H11v6l5.25 3.15.75-1.23-4.5-2.67z">
        </path>
      </g>
      <g id="search">
        <path
          d="M15.5 14h-.79l-.28-.27C15.41 12.59 16 11.11 16 9.5 16 5.91 13.09 3 9.5 3S3 5.91 3 9.5 5.91 16 9.5 16c1.61 0 3.09-.59 4.23-1.57l.27.28v.79l5 4.99L20.49 19l-4.99-5zm-6 0C7.01 14 5 11.99 5 9.5S7.01 5 9.5 5 14 7.01 14 9.5 11.99 14 9.5 14z">
        </path>
      </g>
      <g id="security">
        <path
          d="M12 1L3 5v6c0 5.55 3.84 10.74 9 12 5.16-1.26 9-6.45 9-12V5l-9-4zm0 10.99h7c-.53 4.12-3.28 7.79-7 8.94V12H5V6.3l7-3.11v8.8z">
        </path>
      </g>
        <g id="sim-card-alert">
          <path
            d="M18 2h-8L4.02 8 4 20c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zm-5 15h-2v-2h2v2zm0-4h-2V8h2v5z">
          </path>
        </g>
        <g id="sim-lock">
          <path
            d="M18 8h-1V6c0-2.76-2.24-5-5-5S7 3.24 7 6v2H6c-1.1 0-2 .9-2 2v10c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2V10c0-1.1-.9-2-2-2zm-6 9c-1.1 0-2-.9-2-2s.9-2 2-2 2 .9 2 2-.9 2-2 2zm3.1-9H8.9V6c0-1.71 1.39-3.1 3.1-3.1 1.71 0 3.1 1.39 3.1 3.1v2z">
          </path>
        </g>
        <g id="sms-connect">
          <path
            d="M20,2C21.1,2 22,2.9 22,4L22,16C22,17.1 21.1,18 20,18L6,18L2,22L2.01,4C2.01,2.9 2.9,2 4,2L20,2ZM8,8L4,12L8,16L8,13L14,13L14,11L8,11L8,8ZM19.666,7.872L16.038,4.372L16.038,6.997L10,6.997L10,9L16.038,9L16.038,11.372L19.666,7.872Z">
          </path>
        </g>
      <!-- The <g> IDs are exposed as global variables in Vulcanized mode, which
        conflicts with the "settings" namespace of MD Settings. Using an "_icon"
        suffix prevents the naming conflict. -->
      <g id="settings_icon">
        <path
          d="M19.43 12.98c.04-.32.07-.64.07-.98s-.03-.66-.07-.98l2.11-1.65c.19-.15.24-.42.12-.64l-2-3.46c-.12-.22-.39-.3-.61-.22l-2.49 1c-.52-.4-1.08-.73-1.69-.98l-.38-2.65C14.46 2.18 14.25 2 14 2h-4c-.25 0-.46.18-.49.42l-.38 2.65c-.61.25-1.17.59-1.69.98l-2.49-1c-.23-.09-.49 0-.61.22l-2 3.46c-.13.22-.07.49.12.64l2.11 1.65c-.04.32-.07.65-.07.98s.03.66.07.98l-2.11 1.65c-.19.15-.24.42-.12.64l2 3.46c.12.22.39.3.61.22l2.49-1c.52.4 1.08.73 1.69.98l.38 2.65c.03.24.24.42.49.42h4c.25 0 .46-.18.49-.42l.38-2.65c.61-.25 1.17-.59 1.69-.98l2.49 1c.23.09.49 0 .61-.22l2-3.46c.12-.22.07-.49-.12-.64l-2.11-1.65zM12 15.5c-1.93 0-3.5-1.57-3.5-3.5s1.57-3.5 3.5-3.5 3.5 1.57 3.5 3.5-1.57 3.5-3.5 3.5z">
        </path>
      </g>
      <g id="star">
        <path
          d="M12 17.27L18.18 21l-1.64-7.03L22 9.24l-7.19-.61L12 2 9.19 8.63 2 9.24l5.46 4.73L5.82 21z">
        </path>
      </g>
      <g id="sync">
        <path
          d="M12 4V1L8 5l4 4V6c3.31 0 6 2.69 6 6 0 1.01-.25 1.97-.7 2.8l1.46 1.46C19.54 15.03 20 13.57 20 12c0-4.42-3.58-8-8-8zm0 14c-3.31 0-6-2.69-6-6 0-1.01.25-1.97.7-2.8L5.24 7.74C4.46 8.97 4 10.43 4 12c0 4.42 3.58 8 8 8v3l4-4-4-4v3z">
        </path>
      </g>
      <g id="thumbs-down">
        <path
            d="M6 3h11v13l-7 7-1.25-1.25a1.454 1.454 0 0 1-.3-.475c-.067-.2-.1-.392-.1-.575v-.35L9.45 16H3c-.533 0-1-.2-1.4-.6-.4-.4-.6-.867-.6-1.4v-2c0-.117.017-.242.05-.375s.067-.258.1-.375l3-7.05c.15-.333.4-.617.75-.85C5.25 3.117 5.617 3 6 3Zm9 2H6l-3 7v2h9l-1.35 5.5L15 15.15V5Zm0 10.15V5v10.15Zm2 .85v-2h3V5h-3V3h5v13h-5Z">
        </path>
      </g>
      <g id="thumbs-down-filled">
        <path
            d="M6 3h10v13l-7 7-1.25-1.25a1.336 1.336 0 0 1-.29-.477 1.66 1.66 0 0 1-.108-.574v-.347L8.449 16H3c-.535 0-1-.2-1.398-.602C1.199 15 1 14.535 1 14v-2c0-.117.012-.242.04-.375.022-.133.062-.258.108-.375l3-7.05c.153-.333.403-.618.75-.848A1.957 1.957 0 0 1 6 3Zm12 13V3h4v13Zm0 0">
        </path>
      </g>
      <g id="thumbs-up">
        <path
            d="M18 21H7V8l7-7 1.25 1.25c.117.117.208.275.275.475.083.2.125.392.125.575v.35L14.55 8H21c.533 0 1 .2 1.4.6.4.4.6.867.6 1.4v2c0 .117-.017.242-.05.375s-.067.258-.1.375l-3 7.05c-.15.333-.4.617-.75.85-.35.233-.717.35-1.1.35Zm-9-2h9l3-7v-2h-9l1.35-5.5L9 8.85V19ZM9 8.85V19 8.85ZM7 8v2H4v9h3v2H2V8h5Z">
        </path>
      </g>
      <g id="thumbs-up-filled">
        <path
            d="M18 21H8V8l7-7 1.25 1.25c.117.117.21.273.29.477.073.199.108.39.108.574v.347L15.551 8H21c.535 0 1 .2 1.398.602C22.801 9 23 9.465 23 10v2c0 .117-.012.242-.04.375a1.897 1.897 0 0 1-.108.375l-3 7.05a2.037 2.037 0 0 1-.75.848A1.957 1.957 0 0 1 18 21ZM6 8v13H2V8Zm0 0">
      </g>
      <g id="videocam">
        <path
          d="M17 10.5V7c0-.55-.45-1-1-1H4c-.55 0-1 .45-1 1v10c0 .55.45 1 1 1h12c.55 0 1-.45 1-1v-3.5l4 4v-11l-4 4z">
        </path>
      </g>
      <g id="warning">
        <path d="M1 21h22L12 2 1 21zm12-3h-2v-2h2v2zm0-4h-2v-4h2v4z"></path>
      </g>
    </defs>
  </svg>
</iron-iconset-svg>
`;
document.head.appendChild(template.content);

const styleMod = document.createElement('dom-module');
styleMod.appendChild(html `
  <template>
    <style>
.md-select{--md-arrow-width:10px;--md-select-bg-color:var(--cros-sys-input_field_on_base);--md-select-focus-shadow-color:var(--cros-sys-primary);--md-select-option-bg-color:var(--cros-sys-base_elevated);--md-select-side-padding:8px;--md-select-text-color:var(--cros-sys-on_surface);-webkit-appearance:none;background:url(//resources/images/arrow_down.svg) calc(100% - var(--md-select-side-padding)) center no-repeat;background-color:var(--md-select-bg-color);background-size:var(--md-arrow-width);border:none;border-radius:4px;color:var(--md-select-text-color);cursor:pointer;font-family:inherit;font-size:inherit;line-height:inherit;max-width:100%;outline:none;padding-bottom:6px;padding-inline-end:calc(var(--md-select-side-padding) + var(--md-arrow-width) + 3px);padding-inline-start:var(--md-select-side-padding);padding-top:6px;width:var(--md-select-width,200px)}@media (prefers-color-scheme:dark){.md-select{background-image:url(//resources/images/dark/arrow_down.svg)}}:host-context([chrome-refresh-2023]) .md-select{--md-select-bg-color:transparent;--md-arrow-width:7px;--md-select-side-padding:10px;--md-select-text-color:inherit;border:solid 1px var(--color-combobox-container-outline,var(--cr-fallback-color-neutral-outline));border-radius:8px;box-sizing:border-box;font-size:12px;height:36px;line-height:36px;padding-bottom:0;padding-top:0}:host-context([chrome-refresh-2023]) .md-select:hover{background-color:var(--color-comboxbox-ink-drop-hovered,var(--cr-hover-on-subtle-background-color))}.md-select :-webkit-any(option,optgroup){background-color:var(--md-select-option-bg-color)}.md-select[disabled]{opacity:var(--cr-disabled-opacity);pointer-events:none}:host-context([chrome-refresh-2023]) .md-select[disabled]{background-color:var(--color-combobox-background-disabled,var(--cr-fallback-color-disabled-background));border-color:transparent;color:var(--color-textfield-foreground-disabled,var(--cr-fallback-color-disabled-foreground));opacity:1}.md-select:focus{box-shadow:0 0 0 2px var(--md-select-focus-shadow-color)}:host-context([chrome-refresh-2023]) .md-select:focus{box-shadow:none;outline:solid 2px var(--cr-focus-outline-color);outline-offset:-1px}@media (forced-colors:active){.md-select:focus{outline:var(--cr-focus-outline-hcm)}}.md-select:active{box-shadow:none}:host-context([dir=rtl]) .md-select{background-position-x:var(--md-select-side-padding)}
    </style>
  </template>
`.content);
styleMod.register('md-select');

function getTemplate$6() {
    return html `<!--_html_template_start_--><!--
Copyright 2019 The Chromium Authors
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
-->
<style include="cr-shared-style md-select">[slot='body']>div{font:var(--cros-body-1-font);margin-bottom:var(--cr-form-field-bottom-spacing)}[slot='body']>#disk-format{margin-bottom:0;padding:0 2px 2px}[slot='button-container']{--cr-dialog-button-container-padding-bottom:0;--cr-dialog-button-container-padding-horizontal:0;padding-top:32px}#warning-icon{--iron-icon-fill-color:var(--cros-sys-error)}#warning-message{color:var(--cros-sys-error);display:inline-block;margin-inline-start:8px}cr-dialog::part(dialog){--cr-dialog-background-color:var(--cros-sys-dialog_container);border-radius:20px}cr-dialog::part(dialog)::backdrop{background-color:var(--cros-sys-scrim)}cr-dialog::part(wrapper){padding:32px;padding-bottom:28px}[slot='title']{--cr-dialog-title-slot-padding-bottom:16px;--cr-dialog-title-slot-padding-end:0;--cr-dialog-title-slot-padding-start:0;--cr-dialog-title-slot-padding-top:0;--cr-primary-text-color:var(--cros-sys-on_surface);font:var(--cros-display-7-font)}[slot='body']{--cr-dialog-body-padding-horizontal:0;--cr-secondary-text-color:var(--cros-sys-on_surface_variant);font:var(--cros-body-1-font)}.md-select{--md-select-bg-color:var(--cros-sys-input_field_on_base);--md-select-focus-shadow-color:var(--cros-sys-focus_ring);--md-select-text-color:var(--cros-sys-on_surface);--md-select-side-padding:16px;border-radius:8px;height:36px;width:100%}cr-input{--cr-form-field-label-color:var(--cros-sys-on_surface);--cr-input-background-color:var(--cros-sys-input_field_on_base);--cr-input-border-radius:8px;--cr-input-color:var(--cros-sys-on_surface);--cr-input-error-color:var(--cros-sys-error);--cr-input-focus-color:var(--cros-sys-primary);--cr-input-min-height:36px;--cr-input-padding-end:16px;--cr-input-padding-start:16px;--cr-input-placeholder-color:var(--cros-sys-secondary);font:var(--cros-body-2-font)}cr-button{--active-bg:transparent;--active-shadow:none;--active-shadow-action:none;--bg-action:var(--cros-sys-primary);--cr-button-height:36px;--disabled-bg-action:var(--cros-sys-disabled_container);--disabled-bg:var(--cros-sys-disabled_container);--disabled-text-color:var(--cros-sys-disabled);--hover-bg-action:var(--cros-sys-primary);--hover-bg-color:var(--cros-sys-primary_container);--ink-color:var(--cros-sys-ripple_primary);--ripple-opacity-action:1;--ripple-opacity:1;--text-color-action:var(--cros-sys-on_primary);--text-color:var(--cros-sys-on_primary_container);border:none;border-radius:18px;box-shadow:none;font:var(--cros-button-2-font);position:relative}cr-button.cancel-button{background-color:var(--cros-sys-primary_container)}cr-button.cancel-button:hover::part(hoverBackground){background-color:var(--cros-sys-hover_on_subtle);display:block}cr-button.action-button:hover::part(hoverBackground){background-color:var(--cros-sys-hover_on_prominent);display:block}:host-context(.focus-outline-visible) cr-button:focus{outline:2px solid var(--cros-sys-focus_ring);outline-offset:2px}</style>

<cr-dialog id="dialog" close-text="$i18n{CLOSE_LABEL}"
           single-partition-format$="[[getSinglePartitionFormat()]]">
  <div slot="title">
    [[getStrf('FORMAT_DIALOG_TITLE', title)]]
  </div>
  <div slot="body">
    <div>[[getDialogMessage(isErase_)]]</div>
    <div id="warning-container" hidden="[[!spaceUsed_]]" role="alert">
      <iron-icon id="warning-icon" icon="cr:warning"></iron-icon>
      <div id="warning-message">
        [[getStrf('FORMAT_DIALOG_DELETE_WARNING', spaceUsed_)]]
      </div>
    </div>
    <cr-input label="$i18n{FORMAT_DIALOG_DRIVE_NAME_LABEL}"
        id="label" value="{{label_}}" auto-validate="true">
    </cr-input>
    <div id="disk-format">
      <label id="format-type-label" class="cr-form-field-label">
        $i18n{FORMAT_DIALOG_FORMAT_LABEL}
      </label>
      <select class="md-select" aria-labelledby="format-type-label"
          value="{{formatType_::change}}">
        <option value="vfat">FAT32</option>
        <option value="exfat">exFAT</option>
        <option value="ntfs">NTFS</option>
      </select>
    </div>
  </div>
  <div slot="button-container">
    <cr-button class="cancel-button" on-click="cancel" id="cancel">
      $i18n{CANCEL_LABEL}
    </cr-button>
    <cr-button class="action-button" on-click="format"
        id="format-button">
      [[getConfirmLabel(isErase_)]]
    </cr-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`;
}

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function getVolumeInfoDisplayRoot(entry) {
    if ('volumeInfo' in entry) {
        return entry.volumeInfo.displayRoot || null;
    }
    return null;
}
class FilesFormatDialog extends PolymerElement {
    constructor() {
        super(...arguments);
        this.volumeInfo_ = null;
        this.root_ = null;
    }
    static get is() {
        return 'files-format-dialog';
    }
    static get template() {
        return getTemplate$6();
    }
    static get properties() {
        return {
            label_: {
                type: String,
                value: '',
            },
            formatType_: {
                type: String,
                value: chrome.fileManagerPrivate.FormatFileSystemType.VFAT,
            },
            spaceUsed_: {
                type: String,
                value: '',
            },
            isErase_: {
                type: Boolean,
                value: false,
            },
        };
    }
    ready() {
        super.ready();
        this.$.dialog.consumeKeydownEvent = true;
    }
    cancel() {
        this.$.dialog.cancel();
    }
    format() {
        try {
            validateExternalDriveName(this.label_, this.formatType_);
        }
        catch (error) {
            this.$.label.setAttribute('error-message', error.message);
            this.$.label.invalid = true;
            return;
        }
        if (this.isErase_) {
            chrome.fileManagerPrivate.singlePartitionFormat(this.root_?.devicePath || '', this.formatType_, this.label_);
        }
        else {
            chrome.fileManagerPrivate.formatVolume(this.volumeInfo_?.volumeId || '', this.formatType_, this.label_);
        }
        this.$.dialog.close();
    }
    /**
     * Used to set "single-partition-format" attribute on element.
     * It is used to check flag status in the tests.
     */
    getSinglePartitionFormat() {
        if (isSinglePartitionFormatEnabled()) {
            return 'single-partition-format';
        }
        return '';
    }
    getConfirmLabel(isErase) {
        if (isSinglePartitionFormatEnabled()) {
            if (isErase) {
                return str('REPARTITION_DIALOG_CONFIRM_LABEL');
            }
            else {
                return str('FORMAT_DIALOG_CONFIRM_SHORT_LABEL');
            }
        }
        else {
            return str('FORMAT_DIALOG_CONFIRM_LABEL');
        }
    }
    getDialogMessage(isErase) {
        if (isSinglePartitionFormatEnabled()) {
            if (isErase) {
                return str('REPARTITION_DIALOG_MESSAGE');
            }
            else {
                return str('FORMAT_PARTITION_DIALOG_MESSAGE');
            }
        }
        else {
            return str('FORMAT_DIALOG_MESSAGE');
        }
    }
    getStrf(token, value) {
        return strf(token, value);
    }
    /**
     * Shows the dialog for drive represented by |volumeInfo|.
     */
    showModal(volumeInfo) {
        this.isErase_ = false;
        this.label_ = '';
        this.formatType_ = chrome.fileManagerPrivate.FormatFileSystemType.VFAT;
        this.spaceUsed_ = '';
        this.volumeInfo_ = volumeInfo;
        this.title = this.volumeInfo_.label;
        if (volumeInfo.displayRoot) {
            chrome.fileManagerPrivate.getDirectorySize(volumeInfo.displayRoot, (spaceUsed) => {
                if (spaceUsed > 0 && volumeInfo === this.volumeInfo_) {
                    this.spaceUsed_ = bytesToString(spaceUsed);
                }
                if (window.IN_TEST) {
                    this.$['warning-container'].setAttribute('fully-initialized', '');
                }
            });
        }
        this.$.dialog.showModal();
    }
    /**
     * Shows the dialog for erasing device.
     */
    showEraseModal(root) {
        this.isErase_ = true;
        this.label_ = '';
        this.formatType_ = chrome.fileManagerPrivate.FormatFileSystemType.VFAT;
        this.spaceUsed_ = '';
        this.root_ = root;
        this.title = root.label;
        const childVolumes = this.root_.getUiChildren();
        let totalSpaceUsed = 0;
        const getSpaceUsedRequests = childVolumes.map((childVolume) => {
            return new Promise((resolve) => {
                const displayRoot = getVolumeInfoDisplayRoot(childVolume);
                if (displayRoot) {
                    chrome.fileManagerPrivate.getDirectorySize(displayRoot, (spaceUsed) => {
                        totalSpaceUsed += spaceUsed;
                        if (totalSpaceUsed > 0) {
                            this.spaceUsed_ = bytesToString(totalSpaceUsed);
                        }
                        resolve();
                    });
                }
            });
        });
        Promise.all(getSpaceUsedRequests).then(() => {
            if (window.IN_TEST) {
                this.$['warning-container'].setAttribute('fully-initialized', '');
            }
        });
        this.$.dialog.showModal();
    }
}
customElements.define(FilesFormatDialog.is, FilesFormatDialog);

function getTemplate$5() {
    return html `<!--_html_template_start_--><!--
Copyright 2016 The Chromium Authors
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
-->

<style>#content{height:100%;width:100%}#content.audio{height:54px}iframe{border:0;display:inline-block;height:100%;width:100%}</style>
<div id="content" class$="[[type]]"></div>
<!--_html_template_end_-->`;
}

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * Polymer element to render media securely in a chrome-untrusted:// <iframe>
 * element.
 *
 * When tapped, 'files-safe-media-tap-inside', 'files-safe-media-tap-outside'
 * events are fired depending on the position of the tap.
 */
class FilesSafeMedia extends PolymerElement {
    constructor() {
        super(...arguments);
        this.contentsNode_ = null;
    }
    static get is() {
        return 'files-safe-media';
    }
    static get template() {
        return getTemplate$5();
    }
    static get properties() {
        return {
            /**
             * Source content accessible from the sandboxed environment.
             */
            src: {
                type: Object,
                observer: 'onSrcChange_',
                reflectToAttribute: true,
            },
            /**
             * <files-safe-media> media type: e.g. audio, image, video, html.
             */
            type: {
                type: String,
                readonly: true,
            },
        };
    }
    sourceFile_() {
        switch (this.type) {
            case 'image':
                return toSandboxedURL('untrusted_resources/files_img_content.html')
                    .toString();
            case 'audio':
                return toSandboxedURL('untrusted_resources/files_audio_content.html')
                    .toString();
            case 'video':
                return toSandboxedURL('untrusted_resources/files_video_content.html')
                    .toString();
            case 'html':
                return toSandboxedURL('untrusted_resources/files_text_content.html')
                    .toString();
            default:
                console.warn('Unsupported type: ' + this.type);
                return '';
        }
    }
    onSrcChange_() {
        const hasContent = this.src.dataType !== '';
        if (!hasContent) {
            // Remove untrusted iframe to clean up unnecessary processes.
            if (this.contentsNode_) {
                this.$.content.removeChild(this.contentsNode_);
                this.contentsNode_ = null;
            }
            return;
        }
        if (this.contentsNode_ && this.contentsNode_.isVideoMedia_) {
            // Remove old video item first to stop UI flicker when drawing the new
            // video content: bug b/260619403
            this.$.content.removeChild(this.contentsNode_);
            this.contentsNode_ = null;
        }
        if (!this.contentsNode_) {
            // Create the node, which will callback here (onSrcChange_) when done.
            this.createUntrustedContents_();
            return;
        }
        const data = {
            type: this.type,
            sourceContent: this.src,
        };
        if (this.contentsNode_.contentWindow) {
            this.contentsNode_.isVideoMedia_ = (this.type === 'video');
            // Send the data to preview to the untrusted <iframe>.
            this.contentsNode_.contentWindow.postMessage(data, toSandboxedURL().origin);
        }
    }
    createUntrustedContents_() {
        const node = document.createElement('iframe');
        this.contentsNode_ = node;
        // Allow autoplay for audio files.
        if (this.type === 'audio') {
            node.setAttribute('allow', 'autoplay');
        }
        this.$.content.appendChild(node);
        node.addEventListener('load', () => this.onSrcChange_());
        node.src = this.sourceFile_();
    }
    created() {
        /**
         * Holds the untrusted iframe when a source to preview is set. Set to null
         * otherwise.
         */
        this.contentsNode_ = null;
    }
    ready() {
        super.ready();
        this.addEventListener('focus', () => {
            if (this.type === 'audio' || this.type === 'video') {
                // Avoid setting the focus on the files-safe-media itself, rather sends
                // it down to its untrusted iframe element.
                if (this.contentsNode_) {
                    this.contentsNode_.focus();
                }
            }
        });
        window.addEventListener('message', event => {
            if (event.origin !== toSandboxedURL().origin) {
                console.warn('Unknown origin: ' + event.origin);
                return;
            }
            if (event.data === 'tap-inside') {
                this.dispatchEvent(new CustomEvent('files-safe-media-tap-inside', { bubbles: true, composed: true }));
            }
            else if (event.data === 'tap-outside') {
                this.dispatchEvent(new CustomEvent('files-safe-media-tap-outside', { bubbles: true, composed: true }));
            }
            else if (event.data === 'webview-loaded') {
                if (this.contentsNode_) {
                    this.contentsNode_.setAttribute('loaded', '');
                }
            }
            else if (event.data === 'webview-cleared') {
                if (this.contentsNode_) {
                    this.contentsNode_.removeAttribute('loaded');
                }
            }
            else if (event.data === 'content-decode-failed') {
                this.dispatchEvent(new CustomEvent('files-safe-media-load-error', { bubbles: true, composed: true }));
            }
        });
    }
}
customElements.define(FilesSafeMedia.is, FilesSafeMedia);

function getTemplate$4() {
    return html `<!--_html_template_start_--><!--
Copyright 2016 The Chromium Authors
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
-->

<link rel="stylesheet" href="chrome://resources/css/text_defaults.css">
<link rel="stylesheet" href="foreground/css/common.css">
<link rel="stylesheet" href="foreground/elements/files_quick_view.css">

<dialog id="dialog" on-close="onDialogClose">
  <div id="toolbar">
    <div class="buttons-group">
      <cr-button id="back-button" on-click="close" aria-label="$i18n{QUICK_VIEW_CLOSE_BUTTON_LABEL}" has-tooltip invert-tooltip>
        <iron-icon icon="files:arrow-back"></iron-icon>
        <span class="icon"></span>
      </cr-button>
    </div>
    <div id="file-path">[[filePath]]</div>
    <div class="buttons-group">
      <cr-button id="open-button" on-click="onOpenInNewButtonClick" hidden$="[[!shouldShowOpenButton(hasTask, isModal)]]" aria-label="$i18n{QUICK_VIEW_OPEN_IN_NEW_BUTTON_LABEL}" has-tooltip invert-tooltip>
        <span class="icon">$i18n{QUICK_VIEW_OPEN_IN_NEW_BUTTON_LABEL}</span>
      </cr-button>
      <cr-button id="delete-button" on-click="onDeleteButtonClick" hidden$="[[!shouldShowDeleteButton(canDelete, isModal)]]" aria-label="$i18n{QUICK_VIEW_DELETE_BUTTON_LABEL}" has-tooltip invert-tooltip>
        <span class="icon"></span>
      </cr-button>
      <cr-button id="info-button" on-click="onMetadataButtonClick" aria-pressed="{{metadataBoxActive}}" aria-label="$i18n{QUICK_VIEW_TOGGLE_METADATA_BOX_BUTTON_LABEL}" has-tooltip invert-tooltip>
        <span class="icon"></span>
      </cr-button>
    </div>
  </div>
  <div id="mainPanel">
    <div id="contentPanel" metadata-box-active$="[[metadataBoxActive]]" on-tap="onContentPanelClick">
      <div id="innerContentPanel" type$="[[type]]">
        <!-- PDF, Text -->
        <template is="dom-if" if="[[browsable]]">
          <iframe id="untrusted" style="color: transparent; background: transparent; width: 100%; height: 100%; border: 0px;" on-load="refreshUntrustedIframe" class="content text-content" src="chrome-untrusted://file-manager/untrusted_resources/files_browsable_content.html"></iframe>
        </template>
        <!-- document/HTML -->
        <template is="dom-if" if="[[isHtml(type, subtype)]]">
          <files-safe-media hidden="[[!hasContent(sourceContent)]]" type="html" class="content text-content" src="[[sourceContent]]"></files-safe-media>
          <template is="dom-if" if="[[!hasContent(sourceContent)]]">
            <div class="no-preview-container">
              <div generic-thumbnail="[[type]]"></div>
              <div class="no-preview">[[noPreviewText]]</div>
            </div>
          </template>
        </template>
        <!-- Image -->
        <template is="dom-if" if="[[isImage(type)]]">
          <files-safe-media hidden="[[!hasContent(sourceContent)]]" type="image" class="content no-close-on-click" src="[[sourceContent]]"></files-safe-media>
          <template is="dom-if" if="[[!hasContent(sourceContent)]]">
            <div class="no-preview-container">
              <div generic-thumbnail="image"></div>
              <div class="no-preview">[[noPreviewText]]</div>
            </div>
          </template>
        </template>
        <!-- Video -->
        <template is="dom-if" if="[[isVideo(type)]]">
          <template is="dom-if" if="[[!hasContent(sourceContent)]]">
            <div class="thumbnail" hidden="[[!videoPoster]]">
              <files-safe-media type="image" id="video-poster" src="[[videoPoster]]"></files-safe-media>
            </div>
            <div class="no-preview-container">
              <div hidden="[[videoPoster]]" generic-thumbnail="video"></div>
              <div class="no-preview">[[noPlaybackText]]</div>
            </div>
          </template>
          <template is="dom-if" if="[[hasContent(sourceContent)]]">
            <files-safe-media id="videoSafeMedia" tabindex="0" type="video" class="content no-close-on-click" controls autoplay="[[autoplay]]" src="[[sourceContent]]" poster="[[videoPoster]]"></files-safe-media>
          </template>
        </template>
        <!-- Audio -->
        <template is="dom-if" if="[[isAudio(type)]]">
          <template is="dom-if" if="[[hasContent(audioArtwork)]]">
            <files-safe-media type="image" id="audio-artwork" class="no-close-on-click" src="[[audioArtwork]]"></files-safe-media>
          </template>
        </template>
        <div>
          <files-safe-media tabindex="0" type="audio" class="no-close-on-click" controls autoplay="[[autoplay]]" src="[[audioContent(sourceContent, type)]]" hidden="[[!isAudio(type)]]"></files-safe-media>
        </div>
        <template is="dom-if" if="[[isAudio(type)]]">
          <template is="dom-if" if="[[!hasContent(sourceContent)]]">
            <div class="no-preview-container">
              <div generic-thumbnail="audio"></div>
              <div class="no-preview">[[noPlaybackText]]</div>
            </div>
          </template>
        </template>
        <div class="no-preview-container" hidden="[[!isUnsupported(type, subtype, browsable)]]">
          <div generic-thumbnail$="[[type]]"></div>
          <div class="no-preview">[[noPreviewText]]</div>
        </div>
      </div> <!-- innerContentPanel -->
    </div> <!-- contentPanel -->
    <files-metadata-box id="metadata-box" hidden$="[[!metadataBoxActive]]"></files-metadata-box>
  </div> <!-- mainPanel -->
  <files-tooltip></files-tooltip>
</dialog>
<!--_html_template_end_-->`;
}

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class FilesQuickView extends PolymerElement {
    static get is() {
        return 'files-quick-view';
    }
    static get template() {
        return getTemplate$4();
    }
    static get properties() {
        return {
            // File media type, e.g. image, video.
            type: String,
            subtype: String,
            filePath: String,
            // True if there is a file task that can open the file type.
            hasTask: Boolean,
            /**
             * True if the entry shown in Quick View can be deleted.
             */
            canDelete: Boolean,
            /**
             * Preview content to be sent rendered in a sandboxed environment.
             */
            sourceContent: {
                type: Object,
                observer: 'refreshUntrustedIframe',
            },
            videoPoster: String,
            audioArtwork: String,
            // Autoplay property for audio, video.
            autoplay: Boolean,
            // True if this file is not image, audio, video or HTML, but is
            // supported by Chrome - content that is directly preview-able in
            // Chrome by setting the untrusted <iframe> src attribute. Examples:
            // pdf, text.
            browsable: Boolean,
            // The metadata-box-active-changed event is fired on attribute change.
            metadataBoxActive: {
                value: true,
                type: Boolean,
                notify: true,
            },
            // Text shown when there is no playback/preview available.
            noPlaybackText: String,
            noPreviewText: String,
            /**
             * True if the Files app window is a dialog, e.g. save-as or
             * open-with.
             */
            isModal: Boolean,
        };
    }
    ready() {
        super.ready();
        this.$.dialog.addEventListener('files-safe-media-tap-inside', this.clickInside.bind(this));
        this.$.dialog.addEventListener('files-safe-media-tap-outside', this.close.bind(this));
        this.$.dialog.addEventListener('files-safe-media-load-error', this.loaderror.bind(this));
        this.$.contentPanel.addEventListener('click', this.onContentPanelClick.bind(this));
    }
    /**
     * Send browsable preview content (i.e. content that can be displayed by the
     * browser directly e.g. PDF/text) to the chrome-untrusted:// <iframe>.
     */
    refreshUntrustedIframe() {
        if (!this.browsable) {
            return;
        }
        const iframe = this.shadowRoot.querySelector('#untrusted');
        if (!iframe) {
            return;
        }
        const data = {
            browsable: this.browsable,
            subtype: this.subtype,
            sourceContent: this.sourceContent,
        };
        iframe.contentWindow?.postMessage(data, toSandboxedURL().origin);
    }
    // Clears fields.
    clear() {
        this.setProperties({
            type: '',
            subtype: '',
            filePath: '',
            hasTask: false,
            canDelete: false,
            sourceContent: {
                data: null,
                dataType: '',
            },
            videoPoster: '',
            audioArtwork: '',
            autoplay: false,
            browsable: false,
        });
        // Remove the video's untrusted <iframe> child. The <iframe> contains the
        // <video> element. Removing the <iframe> removes the <video>: that stops
        // the video and its audio track playing: crbug.com/970192
        const video = this.$.contentPanel.querySelector('#videoSafeMedia');
        if (video) {
            video.src = {
                data: null,
                dataType: '',
            };
        }
        this.removeAttribute('load-error');
    }
    // Handle load error from the files-safe-media container.
    loaderror() {
        this.setAttribute('load-error', '');
        this.sourceContent = {
            data: null,
            dataType: '',
        };
    }
    isOpened() {
        return this.$.dialog?.open;
    }
    // Opens the dialog.
    open() {
        if (!this.isOpened()) {
            this.$.dialog.showModal();
            // Make dialog focusable and set focus to a dialog. This is how we can
            // prevent default behaviour of a dialog which by default sets focus to
            // the first input inside itself. When a dialog gains focus we remove
            // focusability to prevent selecting dialog when moving with a keyboard.
            this.$.dialog.setAttribute('tabindex', '0');
            this.$.dialog.focus();
            this.$.dialog.setAttribute('tabindex', '-1');
        }
    }
    // Closes the dialog.
    close() {
        if (this.isOpened()) {
            this.$.dialog.close();
        }
    }
    clickInside() {
        if (this.type === 'image') {
            const dialog = this.shadowRoot.querySelector('#dialog');
            dialog?.focus();
        }
    }
    getFilesMetadataBox() {
        return this.$['metadata-box'];
    }
    /**
     * Client should assign the function to open the file.
     */
    onOpenInNewButtonClick(_) { }
    shouldShowOpenButton(hasTask, isModal) {
        return hasTask && !isModal;
    }
    /**
     * Client should assign the function to delete the file.
     */
    onDeleteButtonClick(_) { }
    shouldShowDeleteButton(canDelete, isModal) {
        return canDelete && !isModal;
    }
    /**
     * See the changes on crbug.com/641587, but crbug.com/779044#c11 later undid
     * that work. So the focus remains on the metadata button when clicked after
     * the crbug.com/779044 "ghost focus" fix.
     *
     * crbug.com/641587 mentions a different UI behavior, that was wanted to fix
     * that bug. TODO(files-ng): UX to resolve the correct behavior needed here.
     */
    onMetadataButtonClick(_) {
        this.metadataBoxActive = !this.metadataBoxActive;
    }
    /**
     * Close Quick View unless the clicked target or its ancestor contains
     * 'no-close-on-click' class.
     */
    onContentPanelClick(event) {
        let target = event.target;
        while (target) {
            if (target.classList.contains('no-close-on-click')) {
                return;
            }
            target = target.parentElement;
        }
        this.close();
    }
    hasContent(sourceContent) {
        return sourceContent.dataType !== '';
    }
    isHtml(type, subtype) {
        return type === 'document' && subtype === 'HTML';
    }
    isImage(type) {
        return type === 'image';
    }
    isVideo(type) {
        return type === 'video';
    }
    isAudio(type) {
        return type === 'audio';
    }
    audioContent(sourceContent, type) {
        if (this.isAudio(type)) {
            return sourceContent;
        }
        return {
            data: null,
            dataType: '',
        };
    }
    isUnsupported(type, subtype, browsable) {
        return !this.isImage(type) && !this.isVideo(type) && !this.isAudio(type) &&
            !this.isHtml(type, subtype) && !browsable;
    }
    onDialogClose(e) {
        if (e.target !== this.$.dialog) {
            return;
        }
        this.clear();
        // Catch and re-fire the 'close' event such that it bubbles across Shadow
        // DOM v1.
        this.dispatchEvent(new CustomEvent('close', { bubbles: true, composed: true }));
    }
}
customElements.define(FilesQuickView.is, FilesQuickView);

function getTemplate$3() {
    return getTrustedHTML `<!--_html_template_start_--><!--
Copyright 2020 The Chromium Authors
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
-->

<style>
  :host([hidden]) {
    display: none !important;
  }

  :host {
    display: flex;
    height: 24px;
    margin: 12px;
    width: 24px;
  }

  svg {
    animation: rotate 1.67s linear infinite;
    transform-origin: 50% 50%;
  }

  @keyframes rotate {
    to {
      transform: rotate(360deg);
    }
  }

  circle {
    animation: spin 1.34s ease infinite;
    stroke: var(--cros-sys-primary);
    stroke-dasharray: 65;
    stroke-linecap: round;
    stroke-width: 3px;
    transform-origin: 50% 50%;
  }

  @keyframes spin {
    0% {
      stroke-dashoffset: 64;
    }

    58% {
      stroke-dashoffset: 19;
      transform: rotate(50deg);
    }

    to {
      stroke-dashoffset: 64;
      transform: rotate(360deg);
    }
  }
</style>

<svg width='24' height='24' viewBox='0 0 24 24'>
  <circle cx='12' cy='12' r='10' fill='none'></circle>
</svg>
<!--_html_template_end_-->`;
}

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class FilesSpinner extends HTMLElement {
    constructor() {
        super();
        const template = document.createElement('template');
        template.innerHTML = getTemplate$3();
        const fragment = template.content.cloneNode(true);
        this.attachShadow({ mode: 'open' }).appendChild(fragment);
    }
    static get is() {
        return 'files-spinner';
    }
    /**
     * DOM connected: set aria attributes.
     */
    connectedCallback() {
        if (!this.shadowRoot) {
            return;
        }
        const host = this.shadowRoot.host;
        host.setAttribute('role', 'progressbar');
        host.setAttribute('aria-disabled', 'false');
        host.setAttribute('aria-valuemin', '0');
        host.setAttribute('aria-valuemax', '1');
    }
}
customElements.define(FilesSpinner.is, FilesSpinner);

function getTemplate$2() {
    return html `<!--_html_template_start_--><!--
Copyright 2015 The Chromium Authors
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
-->
<style>.container{--cr-toast-background:var(--cros-sys-base_elevated);--cr-toast-button-color:var(--cros-sys-primary);--cr-toast-text-color:var(--cros-sys-on_surface);border-radius:8px;box-shadow:var(--cros-elevation-2-shadow);font:var(--cros-body-2-font);justify-content:space-between;max-width:336px;min-height:48px;min-width:256px;padding:14px 0}:host-context(:root[dir=ltr]) .container{left:unset;right:0}:host-context(:root[dir=rtl]) .container{left:0;right:unset}.text{-webkit-box-orient:vertical;-webkit-line-clamp:2;display:-webkit-box;margin-inline-start:24px;overflow:hidden}.action{--ink-color:var(--cros-sys-ripple_neutral_on_subtle);--paper-ripple-opacity:100%;border-radius:18px;height:36px;margin-inline-end:12px}.action:active{box-shadow:none}:host-context(.focus-outline-visible) .action:focus{--focus-shadow-color:none;outline:2px solid var(--cros-sys-focus_ring)}</style>
<cr-toast class="container" id="container" duration="5000">
  <div class="text" id="text"></div>
  <cr-button class="action" id="action" on-click="onActionClicked_"></cr-button>
</cr-toast>
<!--_html_template_end_-->`;
}

// Copyright 2015 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * Files Toast.
 *
 * The toast is shown at the bottom-right in LTR, bottom-left in RTL. Usage:
 *
 * toast.show('Toast without action.');
 * toast.show('Toast with action', {text: 'Action', callback:function(){}});
 * toast.hide();
 */
class FilesToast extends PolymerElement {
    constructor() {
        super(...arguments);
        this.action_ = null;
        this.queue_ = [];
        this.visible = false;
    }
    static get is() {
        return 'files-toast';
    }
    static get template() {
        return getTemplate$2();
    }
    static get properties() {
        return {
            visible: {
                type: Boolean,
                value: false,
            },
        };
    }
    connectedCallback() {
        super.connectedCallback();
        this.$.container.ontransitionend = this.onTransitionEnd_.bind(this);
    }
    /**
     * Shows toast. If a toast is already shown, add the toast to the pending
     * queue. It will shown later when other toasts have completed.
     *
     * @param text Text of toast.
     * @param action Action. The |Action.callback| is called if the user taps or
     *     clicks the action button.
     */
    show(text, action) {
        if (this.visible) {
            this.queue_.push({ text: text, action: action });
            return;
        }
        this.visible = true;
        this.$.text.innerText = text;
        this.action_ = action || null;
        if (this.action_) {
            this.$.text.setAttribute('style', 'margin-inline-end: 0');
            this.$.action.innerText = this.action_.text;
            this.$.action.hidden = false;
        }
        else {
            this.$.text.removeAttribute('style');
            this.$.action.innerText = '';
            this.$.action.hidden = true;
        }
        this.$.container.show();
    }
    /** Handles action button tap/click. */
    onActionClicked_() {
        if (this.action_ && this.action_.callback) {
            this.action_.callback();
            this.hide();
        }
    }
    /**
     * Handles the <cr-toast> transitionend event. On a hide transition, show
     * the next queued toast if any.
     */
    onTransitionEnd_() {
        const hide = !this.$.container.open;
        if (hide && this.visible) {
            this.visible = false;
            if (this.queue_.length > 0) {
                const next = this.queue_.shift();
                setTimeout(this.show.bind(this), 0, next.text, next.action);
            }
        }
    }
    /**
     * Hides toast if visible.
     */
    hide() {
        if (this.visible) {
            this.$.container.hide();
        }
    }
}
customElements.define(FilesToast.is, FilesToast);

function getTemplate$1() {
    return html `<!--_html_template_start_--><!--
Copyright 2015 The Chromium Authors
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
-->
<style>:host{background-color:var(--cros-sys-on_surface);border-radius:6px;box-sizing:border-box;color:var(--cros-sys-inverse_on_surface);display:flex;height:28px;opacity:0;padding:5px 8px;position:absolute;transition:opacity 300ms;z-index:1000}:host([visible]){opacity:100%}#label,#link.link-label{align-items:center;border-radius:2px;display:inline-flex;font:var(--cros-annotation-1-font);white-space:nowrap}:host(.card-tooltip){background-color:var(--cros-sys-base_elevated);border-radius:8px;box-shadow:var(--cros-elevation-1-shadow);color:var(--cros-sys-on_surface);height:auto;margin-top:4px;padding:16px}:host(.link-tooltip){align-items:flex-start;flex-direction:column}#label.card-label,#link.link-label{line-height:18px;margin:0;max-width:192px;padding:0;white-space:normal}#label.card-label a,#link.link-label a{color:var(--cros-sys-primary)}#link{display:none;text-decoration:none}#link:focus-visible{outline:2px solid var(--cros-sys-focus_ring)}</style>
<div id="label"></div>
<a id="link" target="_blank" href="#"></a>
<!--_html_template_end_-->`;
}

// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * Files Tooltip.
 *
 * Adds target elements with addTarget or addTargets. Value of aria-label is
 * used as a label of the tooltip.
 *
 * Usage:
 * document.querySelector('files-tooltip').addTargets(
 *     document.querySelectorAll('[has-tooltip]'))
 */
class FilesTooltip extends PolymerElement {
    constructor() {
        super(...arguments);
        this.showTooltipTimerId_ = 0;
        this.hideTooltipTimerId_ = 0;
        this.onMouseOver_ = (event) => {
            const actualTarget = event?.currentTarget || this.visibleTooltipTarget_;
            if (actualTarget) {
                this.initShowingTooltip_(actualTarget);
            }
        };
        this.onMouseOut_ = (event) => {
            const actualTarget = event?.currentTarget || this.visibleTooltipTarget_;
            if (actualTarget) {
                this.initHidingTooltip_(actualTarget);
            }
        };
        this.onFocus_ = (event) => {
            this.initShowingTooltip_(event.currentTarget);
        };
        this.onBlur_ = (event) => {
            this.initHidingTooltip_(event.currentTarget);
        };
        this.onDocumentMouseDown_ = () => {
            this.hideTooltip_();
            // Additionally prevent any scheduled tooltips from showing up.
            if (this.showTooltipTimerId_) {
                clearTimeout(this.showTooltipTimerId_);
                this.showTooltipTimerId_ = 0;
            }
        };
        this.onTransitionEnd_ = () => {
            // Clear card and link tooltip.
            if (!this.hasAttribute('visible')) {
                this.cleanupLinkTooltip_();
                this.cleanupCardTooltip_();
            }
        };
    }
    static get is() {
        return 'files-tooltip';
    }
    static get template() {
        return getTemplate$1();
    }
    static get properties() {
        return {
            /**
             * Delay for showing the tooltip in milliseconds.
             */
            showTimeout: {
                type: Number,
                value: 500, // ms
                readOnly: true,
            },
            /**
             * Delay for hiding the tooltip in milliseconds.
             */
            hideTimeout: {
                type: Number,
                value: 500, // ms
                readOnly: true,
            },
        };
    }
    connectedCallback() {
        super.connectedCallback();
        document.body.addEventListener('mousedown', this.onDocumentMouseDown_);
        window.addEventListener('resize', this.onDocumentMouseDown_);
        this.addEventListener('transitionend', this.onTransitionEnd_);
        this.addEventListener('mouseover', this.onMouseOver_);
        this.addEventListener('mouseout', this.onMouseOut_);
    }
    /**
     * Adds targets to tooltip.
     */
    addTargets(targets) {
        for (let i = 0; i < targets.length; i++) {
            this.addTarget(targets[i]);
        }
    }
    /**
     * Adds a target to tooltip.
     */
    addTarget(target) {
        target.addEventListener('mouseover', this.onMouseOver_);
        target.addEventListener('mouseout', this.onMouseOut_);
        target.addEventListener('focus', this.onFocus_);
        target.addEventListener('blur', this.onBlur_);
    }
    /**
     * Hides currently visible tooltip if there is. In some cases, mouseout event
     * is not dispatched. This method is used to handle these cases manually.
     */
    hideTooltip() {
        if (this.showTooltipTimerId_) {
            clearTimeout(this.showTooltipTimerId_);
        }
        if (this.visibleTooltipTarget_) {
            this.initHidingTooltip_(this.visibleTooltipTarget_);
        }
    }
    /**
     * Update the tooltip text with the passed-in target.
     */
    updateTooltipText(target) {
        this.initShowingTooltip_(target);
    }
    initShowingTooltip_(target) {
        // Some tooltip is already visible.
        if (this.visibleTooltipTarget_) {
            if (this.hideTooltipTimerId_) {
                clearTimeout(this.hideTooltipTimerId_);
                this.hideTooltipTimerId_ = 0;
            }
        }
        // Even the current target is the visible tooltip target, we still need to
        // check if the label is different from the existing tooltip text, because
        // if label text changes, we need to show the tooltip.
        if (this.visibleTooltipTarget_ === target &&
            target.hasAttribute('aria-label') &&
            this.$.label.textContent === target.getAttribute('aria-label')) {
            return;
        }
        this.upcomingTooltipTarget_ = target;
        if (this.showTooltipTimerId_) {
            clearTimeout(this.showTooltipTimerId_);
        }
        this.showTooltipTimerId_ = setTimeout(this.showTooltip_.bind(this, target), this.visibleTooltipTarget_ ? 0 : this.showTimeout);
    }
    initHidingTooltip_(target) {
        // The tooltip is not visible.
        if (this.visibleTooltipTarget_ !== target) {
            if (this.upcomingTooltipTarget_ === target) {
                clearTimeout(this.showTooltipTimerId_);
                this.showTooltipTimerId_ = 0;
            }
            return;
        }
        if (this.hideTooltipTimerId_) {
            clearTimeout(this.hideTooltipTimerId_);
        }
        this.hideTooltipTimerId_ =
            setTimeout(this.hideTooltip_.bind(this), this.hideTimeout);
    }
    showTooltip_(target) {
        if (this.showTooltipTimerId_) {
            clearTimeout(this.showTooltipTimerId_);
            this.showTooltipTimerId_ = 0;
        }
        this.visibleTooltipTarget_ = target;
        const useCardTooltip = target.hasAttribute('show-card-tooltip');
        const useLinkTooltip = target.dataset['tooltipLinkHref'] &&
            target.dataset['tooltipLinkAriaLabel'] &&
            target.dataset['tooltipLinkText'];
        const windowEdgePadding = 6;
        const label = target.getAttribute('aria-label');
        if (!label) {
            return;
        }
        this.$.label.textContent = label;
        if (useLinkTooltip) {
            this.classList.add('link-tooltip');
            this.$.link.setAttribute('href', target.dataset['tooltipLinkHref']);
            this.$.link.setAttribute('aria-label', target.dataset['tooltipLinkAriaLabel']);
            this.$.link.textContent = target.dataset['tooltipLinkText'];
            this.$.link.setAttribute('aria-hidden', 'false');
            this.$.link.classList.add('link-label');
        }
        else {
            this.cleanupLinkTooltip_();
        }
        const invert = 'invert-tooltip';
        this.$.label.toggleAttribute('invert', target.hasAttribute(invert));
        const rect = target.getBoundingClientRect();
        let top = rect.top + rect.height;
        if (!useCardTooltip) {
            top += 8;
        }
        if (top + this.offsetHeight > document.body.offsetHeight) {
            top = rect.top - this.offsetHeight;
        }
        this.style.top = `${Math.round(top)}px`;
        let left;
        if (useCardTooltip) {
            this.classList.add('card-tooltip');
            this.$.label.classList.add('card-label');
            // Push left to the body's left when tooltip is longer than viewport.
            if (this.offsetWidth > document.body.offsetWidth) {
                left = 0;
            }
            else if (document.dir === 'rtl') {
                // Calculate position for rtl mode to align to the right of target.
                const width = this.getBoundingClientRect().width;
                const minLeft = rect.right - width;
                // The tooltip remains inside viewport if right align push it outside.
                left = Math.max(minLeft, 0);
            }
            else {
                // The tooltip remains inside viewport if left align push it outside.
                let maxLeft = document.body.offsetWidth - this.offsetWidth;
                maxLeft = Math.max(0, maxLeft);
                // Stick to the body's right if it goes outside viewport from right.
                left = Math.min(rect.left, maxLeft);
            }
        }
        else {
            // Clearing out style in case card-tooltip displayed previously.
            this.cleanupCardTooltip_();
            left = rect.left + rect.width / 2 - this.offsetWidth / 2;
            if (left < windowEdgePadding) {
                left = windowEdgePadding;
            }
            const maxLeft = document.body.offsetWidth - this.offsetWidth - windowEdgePadding;
            if (left > maxLeft) {
                left = maxLeft;
            }
        }
        left = Math.round(left);
        this.style.left = `${left}px`;
        this.setAttribute('aria-hidden', 'false');
        this.setAttribute('visible', 'true');
    }
    hideTooltip_() {
        if (this.hideTooltipTimerId_) {
            clearTimeout(this.hideTooltipTimerId_);
            this.hideTooltipTimerId_ = 0;
        }
        this.visibleTooltipTarget_ = undefined;
        this.removeAttribute('visible');
        this.setAttribute('aria-hidden', 'true');
    }
    /**
     * Clear card tooltip styles to prevent overwriting normal tooltip rules.
     */
    cleanupCardTooltip_() {
        this.classList.remove('card-tooltip');
        this.$.label.className = '';
    }
    /**
     * Clear link tooltip styles to prevent overwriting normal tooltip rules.
     */
    cleanupLinkTooltip_() {
        this.$.link.setAttribute('href', '#');
        this.$.link.removeAttribute('aria-label');
        this.$.link.setAttribute('aria-hidden', 'true');
        this.$.link.textContent = '';
        this.$.link.classList.remove('link-label');
        this.classList.remove('link-tooltip');
    }
}
customElements.define(FilesTooltip.is, FilesTooltip);
// #
// sourceURL=//ui/file_manager/file_manager/foreground/elements/files_tooltip.ts

function getTemplate() {
    return getTrustedHTML `<!--_html_template_start_--><style>
  :host {
    max-width: 504px;
    outline: none;
  }
  #container {
    align-items: stretch;
    background-color: var(--cros-sys-base_elevated);
    border-radius: 8px;
    box-shadow: var(--cros-elevation-2-shadow);
    display: flex;
    flex-direction: column;
    max-width: min-content;
    z-index: 100;
  }
  #separator {
    background-color: var(--cros-sys-separator);
    height: 1px;
  }
  /* Limit to 3 visible progress panels before scroll. */
  #panels {
    max-height: calc(192px + 28px);
    overflow-y: auto;
  }
  xf-panel-item:not(:only-child) {
    --progress-height: 64px;
  }
  xf-panel-item:not(:only-child):first-child {
    --progress-padding-top: 14px;
  }
  xf-panel-item:not(:only-child):last-child {
    --progress-padding-bottom: 14px;
  }
  xf-panel-item:only-child {
    --progress-height: 68px;
  }
  @keyframes setcollapse {
    0% {
      max-height: 0;
      max-width: 0;
      opacity: 0;
    }
    75% {
      max-height: calc(192px + 28px);
      opacity: 0;
      width: 504px;
    }
    100% {
      max-height: calc(192px + 28px);
      opacity: 1;
      width: 504px;
    }
  }

  @keyframes setexpand {
    0% {
      max-height: calc(192px + 28px);
      max-width: 504px;
      opacity: 1;
    }
    25% {
      max-height: calc(192px + 28px);
      max-width: 504px;
      opacity: 0;
    }
    100% {
      max-height: 0;
      max-width: 0;
      opacity: 0;
    }
  }
  .expanded {
    animation: setcollapse 200ms forwards;
    width: 504px;
  }
  .collapsed {
    animation: setexpand 200ms forwards;
  }
  .expanding {
    overflow: hidden;
  }
  .expandfinished {
    max-height: calc(192px + 28px);
    opacity: 1;
    overflow-y: auto;
    width: 504px;
  }
  xf-panel-item:not(:only-child) {
    --multi-progress-height: 92px;
  }
</style>
<div id="container">
  <div id="summary"></div>
  <div id="separator" hidden></div>
  <div id="panels"></div>
</div>
<!--_html_template_end_-->`;
}

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * A panel to display a collection of PanelItem.
 */
class DisplayPanel extends HTMLElement {
    static get is() {
        return 'xf-display-panel';
    }
    constructor() {
        super();
        /**
         * True if the panel is collapsed to summary view.
         */
        this.collapsed_ = true;
        /**
         * Collection of PanelItems hosted in this DisplayPanel.
         */
        this.items_ = [];
        this.toggleSummaryBound_ = this.toggleSummary_.bind(this);
        this.createElement_();
        this.summary_ = this.shadowRoot.querySelector('#summary');
        this.separator_ =
            this.shadowRoot.querySelector('#separator');
        this.panels_ = this.shadowRoot.querySelector('#panels');
    }
    /**
     * Creates an instance of DisplayPanel, attaching the template clone.
     */
    createElement_() {
        const template = document.createElement('template');
        template.innerHTML = getTemplate();
        const fragment = template.content.cloneNode(true);
        this.attachShadow({ mode: 'open' }).appendChild(fragment);
    }
    /**
     * We cannot set attributes in the constructor for custom elements when using
     * `createElement()`. Set attributes in the connected callback instead.
     */
    connectedCallback() {
        this.setAriaHidden_();
    }
    /**
     * Re-enable scrollbar visibility after expand/contract animation.
     */
    panelExpandFinished_(_) {
        this.panels_.classList.remove('expanding');
        this.panels_.classList.add('expandfinished');
    }
    /**
     * Hides the active panel items at end of collapse animation.
     */
    panelCollapseFinished_(_) {
        this.panels_.hidden = true;
        this.panels_.setAttribute('aria-hidden', 'true');
        this.panels_.classList.remove('expanding');
        this.panels_.classList.add('expandfinished');
    }
    /**
     * Set attributes and style for expanded summary panel.
     */
    setSummaryExpandedState(expandButton) {
        expandButton.setAttribute('data-category', 'collapse');
        expandButton.setAttribute('aria-label', str('FEEDBACK_COLLAPSE_LABEL'));
        expandButton.setAttribute('aria-expanded', 'true');
        this.panels_.hidden = false;
        this.separator_.hidden = false;
    }
    /**
     * Event handler to toggle the visible state of panel items.
     */
    toggleSummary_(_) {
        const summaryPanel = this.summary_.querySelector('xf-panel-item');
        const expandButton = summaryPanel.shadowRoot.querySelector('#primary-action');
        if (this.collapsed_) {
            this.collapsed_ = false;
            this.setSummaryExpandedState(expandButton);
            this.panels_.addEventListener('animationend', this.panelExpandFinished_.bind(this), { once: true });
            this.panels_.setAttribute('class', 'expanded expanding');
            summaryPanel.setAttribute('data-category', 'expanded');
        }
        else {
            this.collapsed_ = true;
            expandButton.setAttribute('data-category', 'expand');
            expandButton.setAttribute('aria-label', str('FEEDBACK_EXPAND_LABEL'));
            expandButton.setAttribute('aria-expanded', 'false');
            this.separator_.hidden = true;
            this.panels_.addEventListener('animationend', this.panelCollapseFinished_.bind(this), { once: true });
            this.panels_.setAttribute('class', 'collapsed expanding');
            summaryPanel.setAttribute('data-category', 'collapsed');
        }
    }
    /**
     * Get an array of panel items that are connected to the DOM.
     */
    connectedPanelItems_() {
        return this.items_.filter(item => item.isConnected);
    }
    /**
     * Update the summary panel item progress indicator.
     */
    async updateProgress() {
        let total = 0;
        if (this.items_.length === 0) {
            return;
        }
        let errors = 0;
        let warnings = 0;
        let progressCount = 0;
        const connectedPanels = this.connectedPanelItems_();
        for (const panel of connectedPanels) {
            // Only sum progress for attached progress panels.
            if (panel.panelType === PanelType.PROGRESS ||
                panel.panelType === PanelType.FORMAT_PROGRESS ||
                panel.panelType === PanelType.SYNC_PROGRESS) {
                total += Number(panel.progress);
                progressCount++;
            }
            else if (panel.panelType === PanelType.ERROR) {
                errors++;
            }
            else if (panel.panelType === PanelType.INFO) {
                warnings++;
            }
        }
        if (progressCount > 0) {
            total /= progressCount;
        }
        const summaryPanel = this.summary_.querySelector('xf-panel-item');
        if (!summaryPanel) {
            return;
        }
        // Show either a progress indicator or a status indicator (success, warning,
        // error) if no operations are ongoing.
        if (progressCount > 0) {
            // Make sure we have a progress indicator on the summary panel.
            if (summaryPanel.indicator !== 'largeprogress') {
                summaryPanel.indicator = 'largeprogress';
            }
            summaryPanel.primaryText = strf('PERCENT_COMPLETE', total.toFixed(0));
            summaryPanel.progress = String(total);
            summaryPanel.setAttribute('count', String(progressCount));
            summaryPanel.errorMarkerVisibility = (errors > 0) ? 'visible' : 'hidden';
            return;
        }
        if (summaryPanel.indicator !== 'status') {
            // Make sure we have a status indicator on the summary panel.
            summaryPanel.indicator = 'status';
        }
        if (errors > 0 && warnings > 0) {
            // Both errors and warnings: show the error indicator, along with counts
            // of both.
            summaryPanel.status = 'failure';
            const errorMessage = await this.generateErrorMessage_(errors);
            const warningMessage = await this.generateWarningMessage_(errors);
            summaryPanel.primaryText = `${errorMessage} ${warningMessage}`;
            return;
        }
        if (errors > 0) {
            // Only errors, but no warnings.
            summaryPanel.status = 'failure';
            summaryPanel.primaryText = await this.generateErrorMessage_(errors);
            return;
        }
        if (warnings > 0) {
            // Only warnings, but no errors.
            summaryPanel.status = 'warning';
            summaryPanel.primaryText = await this.generateWarningMessage_(warnings);
            return;
        }
        // No errors or warnings.
        summaryPanel.status = 'success';
        summaryPanel.primaryText = strf('PERCENT_COMPLETE', 100);
    }
    /**
     * Update the summary panel.
     * @public
     */
    updateSummaryPanel() {
        const summaryHost = this.shadowRoot.querySelector('#summary');
        let summaryPanel = summaryHost.querySelector('#summary-panel');
        // Make the display panel available by tab if there are panels to
        // show and there's an aria-label for use by a screen reader.
        if (this.hasAttribute('aria-label')) {
            this.tabIndex = this.items_.length ? 0 : -1;
        }
        // Work out how many panel items are being shown.
        const count = this.connectedPanelItems_().length;
        // If there's only one panel item active, no need for summary.
        if (count <= 1 && summaryPanel) {
            const button = summaryPanel.primaryButton;
            if (button) {
                button.removeEventListener('click', this.toggleSummaryBound_);
            }
            // For transfer summary details.
            const textDiv = summaryPanel.textDiv;
            if (textDiv) {
                textDiv.removeEventListener('click', this.toggleSummaryBound_);
            }
            summaryPanel.remove();
            this.panels_.hidden = false;
            this.separator_.hidden = true;
            this.panels_.classList.remove('collapsed');
            return;
        }
        // Show summary panel if there are more than 1 panel items.
        if (count > 1 && !summaryPanel) {
            summaryPanel = document.createElement('xf-panel-item');
            summaryPanel.panelType = PanelType.SUMMARY;
            summaryPanel.id = 'summary-panel';
            summaryPanel.setAttribute('detailed-summary', '');
            const button = summaryPanel.primaryButton;
            if (button) {
                button.addEventListener('click', this.toggleSummaryBound_);
            }
            const textDiv = summaryPanel.textDiv;
            if (textDiv) {
                textDiv.addEventListener('click', this.toggleSummaryBound_);
            }
            summaryHost.appendChild(summaryPanel);
            // Setup the panels based on expand/collapse state of the summary panel.
            if (this.collapsed_) {
                this.panels_.hidden = true;
                summaryPanel.setAttribute('data-category', 'collapsed');
            }
            else {
                this.setSummaryExpandedState(button);
                this.panels_.classList.add('expandfinished');
                summaryPanel.setAttribute('data-category', 'expanded');
            }
        }
        if (summaryPanel) {
            this.updateProgress();
        }
    }
    /**
     * Create a panel item suitable for attaching to our display panel.
     * @param id The identifier attached to this panel.
     */
    createPanelItem(id) {
        const panel = document.createElement('xf-panel-item');
        panel.id = id;
        panel.updateProgress = this.updateProgress.bind(this);
        panel.updateSummaryPanel = this.updateSummaryPanel.bind(this);
        panel.setAttribute('indicator', 'progress');
        this.items_.push(panel);
        this.setAriaHidden_();
        this.setAttribute('detailed-panel', 'detailed-panel');
        return panel;
    }
    /**
     * Attach a panel item element inside our display panel.
     * @param panel The panel item to attach.
     */
    attachPanelItem(panel) {
        // Only attach the panel if it hasn't been removed.
        const index = this.items_.indexOf(panel);
        if (index === -1) {
            return;
        }
        // If it's already attached, nothing to do here.
        if (panel.isConnected) {
            return;
        }
        this.panels_.appendChild(panel);
        this.updateSummaryPanel();
        this.setAriaHidden_();
    }
    /**
     * Add a panel entry element inside our display panel.
     * @param id The identifier attached to this panel.
     */
    addPanelItem(id) {
        const panel = this.createPanelItem(id);
        this.attachPanelItem(panel);
        return panel;
    }
    /**
     * Remove a panel from this display panel.
     * @param item The PanelItem to remove.
     * @public
     */
    removePanelItem(item) {
        const index = this.items_.indexOf(item);
        if (index === -1) {
            return;
        }
        item.remove();
        this.items_.splice(index, 1);
        this.setAriaHidden_();
        this.updateSummaryPanel();
    }
    /**
     * Set aria-hidden to false if there is no panel.
     */
    setAriaHidden_() {
        const hasItems = this.connectedPanelItems_().length > 0;
        this.setAttribute('aria-hidden', String(!hasItems));
    }
    /**
     * Find a panel with given 'id'.
     */
    findPanelItemById(id) {
        for (const item of this.items_) {
            if (item.getAttribute('id') === id) {
                return item;
            }
        }
        return null;
    }
    /**
     * Remove all panel items.
     */
    removeAllPanelItems() {
        for (const item of this.items_) {
            item.remove();
        }
        this.items_ = [];
        this.setAriaHidden_();
        this.updateSummaryPanel();
    }
    /**
     * Generates the summary panel title message based on the number of errors.
     * @param errors Number of error subpanels.
     * @return Title text.
     */
    async generateErrorMessage_(errors) {
        if (errors <= 0) {
            console.warn(`generateWarningMessage_ expected errors > 0, but got ${errors}.`);
            return '';
        }
        return getPluralString('ERROR_PROGRESS_SUMMARY', errors);
    }
    /**
     * Generates the summary panel title message based on the number of warnings.
     * @param warnings Number of warning subpanels.
     * @return Title text.
     */
    async generateWarningMessage_(warnings) {
        if (warnings <= 0) {
            console.warn(`generateWarningMessage_ expected warnings > 0, but got ${warnings}.`);
            return '';
        }
        return getPluralString('WARNING_PROGRESS_SUMMARY', warnings);
    }
}
window.customElements.define(DisplayPanel.is, DisplayPanel);
//# sourceMappingURL=deferred_elements.rollup.js.map
