import { s as startInterval, r as recordEnum, _ as __decorate$1, A as AsyncQueue, o as openWindow, R as RootType, a as RateLimiter, g as getStore, u as unwrapEntry, t as toFilesAppURL, b as urlToEntry, c as strf, d as str, v as visitURL, V as VolumeType, e as startIOTask, f as checkAPIError, h as getFileErrorString, i as isRecentRootType, D as DialogType, j as isDriveFsBulkPinningEnabled, F as FakeEntryImpl, S as SHARED_DRIVES_DIRECTORY_NAME, C as COMPUTERS_DIRECTORY_NAME, k as assert$1, p as promisify, l as debug, m as VolumeError, n as removeVolume, q as isSameFileSystem, w as isSameEntry, x as isFakeEntry, y as getRootType, z as isOneDrivePlaceholder, B as SHARED_DRIVES_DIRECTORY_PATH, E as isTeamDriveRoot, G as COMPUTERS_DIRECTORY_PATH, H as isComputersRoot, I as getRootTypeFromVolumeType, J as getMediaViewRootTypeFromVolumeId, M as MediaViewRootType, K as timeoutPromise, L as addVolume, N as recordInterval, O as VOLUME_ALREADY_MOUNTED, P as isInGuestMode, Q as getDirectory, T as ARCHIVE_OPENED_EVENT_TYPE, U as Source, W as assertNotReached$1, X as descriptorEqual, Y as XfBase, Z as isCrosComponentsEnabled, $ as isFuseBoxDebugEnabled, a0 as isNative, a1 as AllowedPaths, a2 as getEntry, a3 as oneDriveFakeRootKey, a4 as isOneDrive, a5 as parseTrashInfoFiles, a6 as recordMediumCount, a7 as isFileEntry, a8 as isDirectoryEntry, a9 as dispatchPropertyChange, aa as convertToKebabCase, ab as domAttrSetter, ac as boolAttrSetter, ad as crInjectTypeAndInit, ae as assertInstanceof$1, af as CrButtonElement, ag as isTreeItem, ah as isXfTree, ai as handleTreeSlotChange, aj as refreshNavigationRoots, ak as PropStatus, al as NavigationType, am as getFileData, an as isVolumeFileData, ao as getVolume, ap as driveRootEntryListKey, aq as isOneDriveId, ar as ICON_TYPES, as as shouldSupportDriveSpecificIcons, at as vmTypeToIconName, au as isMyFilesFileData, av as readSubDirectoriesToCheckDirectoryChildren, aw as updateFileData, ax as readSubDirectories, ay as shouldDelayLoadingChildren, az as clearSearch, aA as canHaveSubDirectories, aB as RootTypesForUMA, aC as changeDirectory, aD as recordUserAction, aE as maybeShowTooltip, aF as convertEntryToFileData, aG as isInsideDrive, aH as isGrandRootEntryInDrive, aI as isTrashFileData, aJ as isRecentFileData, aK as traverseAndExpandPathEntries, aL as SearchLocation, aM as getTrustedHTML, aN as isSameVolume, aO as FSP_ACTIONS_HIDDEN, aP as dispatchSimpleEvent, aQ as getEntryProperties, aR as recordBoolean, aS as updateSelection, aT as isDlpEnabled, aU as isReadOnlyForDelete, aV as FILE_SELECTION_METADATA_PREFETCH_PROPERTY_NAMES, aW as isEncrypted, aX as getFocusedTreeItem, aY as getTreeItemEntry, aZ as addAndroidApps, a_ as getLocaleBasedWeekStart, a$ as SearchRecency, b0 as isImage, b1 as isRaw, b2 as compareName, b3 as compareLabel, b4 as getType, b5 as collator, b6 as queryRequiredElement, b7 as isRecentRoot, b8 as bytesToString, b9 as isNullOrUndefined, ba as recordValue, bb as PHOTOS_DOCUMENTS_PROVIDER_VOLUME_ID, bc as DEFAULT_CROSTINI_VM, bd as PLUGIN_VM$1, be as slice, bf as isGoogleOneOfferFilesBannerEligibleAndEnabled, bg as isSkyvaultV2Enabled, bh as getTeamDriveName, bi as getDriveQuotaMetadata, bj as getSizeStats, bk as jsSetter, bl as isInteractiveVolume, bm as isTeamDrivesGrandRoot, bn as isTrashRootType, bo as EntryList, bp as isSinglePartitionFormatEnabled, bq as isTrashEntry$1, br as PathComponent, bs as isTrashRoot, bt as isNonModifiable, bu as FileSystemType, bv as isRecentArcEntry, bw as entriesToURLs, bx as getHoldingSpaceState, by as getDlpRestrictionDetails, bz as getExtension, bA as isMirrorSyncEnabled, bB as DEFAULT_BRUSCHETTA_VM, bC as addUiEntry, bD as removeUiEntry, bE as crostiniPlaceHolderKey, bF as UserCanceledError, bG as testSendMessage, bH as createDOMError, bI as FileErrorToDomError, bJ as getDefaultSearchOptions, bK as readEntriesRecursively, bL as isDriveRootType, bM as CROSTINI_CONNECT_ERR, bN as mountGuest, bO as LIST_CONTAINER_METADATA_PREFETCH_PROPERTY_NAMES, bP as ACTIONS_MODEL_METADATA_PREFETCH_PROPERTY_NAMES, bQ as DLP_METADATA_PREFETCH_PROPERTY_NAMES, bR as ConcurrentQueue, bS as directoryContentSelector, bT as fetchDirectoryContents, bU as isType, bV as Aggregator, bW as getVolumeTypeFromRootType, bX as convertURLsToEntries, bY as isNativeEntry, bZ as getEntryLabel, b_ as getMyFiles, b$ as isGuestOs, c0 as updateSearch, c1 as validateEntryName, c2 as renameEntry, c3 as readSubDirectoriesForRenamedEntry, c4 as getKeyModifiers, c5 as myFilesEntryListKey, c6 as recentRootKey, c7 as getODFSMetadataQueryEntry, c8 as FSP_ACTION_HIDDEN_ONEDRIVE_ACCOUNT_STATE, c9 as FSP_ACTION_HIDDEN_ONEDRIVE_REAUTHENTICATION_REQUIRED, ca as FSP_ACTION_HIDDEN_ONEDRIVE_USER_EMAIL, cb as updateIsInteractiveVolume, cc as isOneDrivePlaceholderKey, cd as ODFS_EXTENSION_ID, ce as getDisallowedTransfers, cf as htmlEscape, cg as getIcon, ch as isSiblingEntry, ci as getFileTypeForName, cj as isSharedDriveEntry, ck as grantAccess, cl as getParentEntry$1, cm as getFile, cn as makeTaskID, co as getFilesData, cp as fetchFileTasks, cq as getMimeType, cr as recordDirectoryListLoadWithTolerance, cs as waitForState, ct as getDefaultTask, cu as getFilesAppModalDialogInstance, cv as getFileTasks, cw as INSTALL_LINUX_PACKAGE_TASK_DESCRIPTOR, cx as annotateTasks, cy as recordTime, cz as parseActionId, cA as isFilesAppId, cB as splitExtension, cC as LEGACY_FILES_EXTENSION_ID, cD as executeTask, cE as isTeleported, cF as extractFilePath, cG as USER_CANCELLED, cH as isSearchEmpty, cI as createChild, cJ as refreshFolderShortcut, cK as recordSmallCount, cL as getPreferences, cM as comparePath, cN as addFolderShortcut, cO as removeFolderShortcut, cP as Group, cQ as isGuestOsEnabled, cR as listMountableGuests, cS as GuestOsPlaceholder, cT as getMediaType, cU as isVideo, cV as isPDF, cW as getContentMetadata, cX as getContentMimeType, cY as getDlpMetadata, cZ as MetadataStats, c_ as isAudio, c$ as updateMetadata, d0 as validateFileName, d1 as OneDrivePlaceholder, d2 as updateDirectoryContent, d3 as XfCloudPanel, d4 as canBulkPinningCloudPanelShow, d5 as FocusOutlineManager, d6 as mouseEnterMaybeShowTooltip, d7 as getCrActionMenuTop, d8 as SEARCH_RESULTS_KEY, d9 as getVolumeType, da as CloudPanelType, db as queryDecoratedElement, dc as secondsToRemainingTimeString, dd as PanelType, de as iconSetToCSSBackgroundImageValue, df as getCurrentLocaleOrDefault, dg as getLastVisitedURL, dh as getBulkPinProgress, di as updateBulkPinProgress, dj as getEmptyState, dk as setLaunchParameters, dl as runningInBrowser, dm as updatePreferences, dn as getDialogCaller, dp as getDlpBlockedComponents, dq as getDriveConnectionState, dr as updateDriveConnectionStatus, ds as updateDeviceConnectionState, dt as trashRootKey } from './shared.rollup.js';
import 'chrome://file-manager/strings.m.js';
import { loadTimeData } from 'chrome://resources/ash/common/load_time_data.m.js';
import { isServer, property, LitElement, css, customElement, state, query, html, classMap, nothing, ifDefined, styleMap, queryAssignedElements } from 'chrome://resources/mwc/lit/index.js';
import { mojo } from 'chrome://resources/mojo/mojo/public/js/bindings.js';
import { html as html$1, PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import 'chrome://resources/js/cr.js';

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview Metrics calls to start measurement of script loading.  Include
 * this as the first script in main_background.js.
 */
startInterval('Load.BackgroundScript');

// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * Possible error metrics. We allow for errors intercepted by an error counter.
 * These are unhandled errors and promise rejections.
 *
 * These values are persisted to logs. Entries should not be renumbered and
 * numeric values should never be reused.
 *
 * Must be kept in synch with FileManagerGlitch defined in
 * //tools/metrics/histograms/enums.xml
 */
var GlitchType;
(function (GlitchType) {
    GlitchType[GlitchType["UNKNOWN"] = 0] = "UNKNOWN";
    GlitchType[GlitchType["UNHANDLED_ERROR"] = 1] = "UNHANDLED_ERROR";
    GlitchType[GlitchType["UNHANDLED_REJECTION"] = 2] = "UNHANDLED_REJECTION";
    // Do not use it to report all caught exceptions. Only those exceptions that
    // we catch to work around errors that should never occur.
    GlitchType[GlitchType["CAUGHT_EXCEPTION"] = 3] = "CAUGHT_EXCEPTION";
})(GlitchType || (GlitchType = {}));
/**
 * @param glitchType What type of glitch was it.
 */
function reportGlitch(glitchType) {
    recordEnum(`Glitch`, glitchType, Object.values(GlitchType));
}

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * This variable is checked in several integration and unit tests, to make sure
 * that new code changes don't cause unhandled exceptions.
 */
window.JSErrorCount = 0;
/**
 * Creates a list of arguments extended with stack information.
 * @param prefix The prefix indicating type of error situation.
 * @param args The remaining, if any, arguments of the call.
 * @return A string representing args and stack traces.
 */
function createLoggableArgs(prefix, ...args) {
    const argsStack = args && args[0] && args[0].stack;
    if (args.length) {
        const args0 = args[0];
        args[0] = `[${prefix}]: ` +
            (args0 instanceof PromiseRejectionEvent ? args0.reason : args0);
    }
    else {
        args.push(prefix);
    }
    const currentStack = new Error('current stack').stack.split('\n');
    // Remove stack trace that is specific to this function.
    currentStack.splice(1, 1);
    args.push(currentStack.join('\n'));
    if (argsStack) {
        args.push('Original stack:\n' + argsStack);
    }
    return args.join('\n');
}
/**
 * Count uncaught exceptions.
 */
window.onerror = () => {
    window.JSErrorCount++;
    reportGlitch(GlitchType.UNHANDLED_ERROR);
};
/**
 * Count uncaught errors in promises.
 */
window.addEventListener('unhandledrejection', (event) => {
    window.JSErrorCount++;
    reportGlitch(GlitchType.UNHANDLED_REJECTION);
    console.warn(createLoggableArgs('unhandled-rejection', event));
});
/**
 * Overrides console.error() to count errors.
 *
 * @param args Message and/or objects to be logged.
 */
console.error = (() => {
    const orig = console.error;
    return (...args) => {
        window.JSErrorCount++;
        return orig.apply(undefined, [createLoggableArgs('unhandled-error', ...args)]);
    };
})();
/**
 * Overrides console.assert() to count errors.
 *
 * @param condition If false, log a message and stack trace.
 * @param args Message and/or objects to be logged when condition is
 * false.
 */
console.assert = (() => {
    const orig = console.assert;
    return (condition, ...args) => {
        const stack = new Error('original stack').stack;
        args.push(stack);
        if (!condition) {
            window.JSErrorCount++;
        }
        return orig.apply(undefined, [condition].concat(args));
    };
})();

// Copyright 2015 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview Metrics calls to start measurement of script loading.  Include
 * this as the first script in main.html (i.e. after the common scripts that
 * define the metrics namespace).
 */
startInterval('Load.Total');
startInterval('Load.Script');

/**
 * @license
 * Copyright 2023 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
/**
 * A key to retrieve an `Attachable` element's `AttachableController` from a
 * global `MutationObserver`.
 */
const ATTACHABLE_CONTROLLER = Symbol('attachableController');
let FOR_ATTRIBUTE_OBSERVER;
if (!isServer) {
    /**
     * A global `MutationObserver` that reacts to `for` attribute changes on
     * `Attachable` elements. If the `for` attribute changes, the controller will
     * re-attach to the new referenced element.
     */
    FOR_ATTRIBUTE_OBSERVER = new MutationObserver((records) => {
        for (const record of records) {
            // When a control's `for` attribute changes, inform its
            // `AttachableController` to update to a new control.
            record.target[ATTACHABLE_CONTROLLER]?.hostConnected();
        }
    });
}
/**
 * A controller that provides an implementation for `Attachable` elements.
 *
 * @example
 * ```ts
 * class MyElement extends LitElement implements Attachable {
 *   get control() { return this.attachableController.control; }
 *
 *   private readonly attachableController = new AttachableController(
 *     this,
 *     (previousControl, newControl) => {
 *       previousControl?.removeEventListener('click', this.handleClick);
 *       newControl?.addEventListener('click', this.handleClick);
 *     }
 *   );
 *
 *   // Implement remaining `Attachable` properties/methods that call the
 *   // controller's properties/methods.
 * }
 * ```
 */
class AttachableController {
    get htmlFor() {
        return this.host.getAttribute('for');
    }
    set htmlFor(htmlFor) {
        if (htmlFor === null) {
            this.host.removeAttribute('for');
        }
        else {
            this.host.setAttribute('for', htmlFor);
        }
    }
    get control() {
        if (this.host.hasAttribute('for')) {
            if (!this.htmlFor || !this.host.isConnected) {
                return null;
            }
            return this.host.getRootNode().querySelector(`#${this.htmlFor}`);
        }
        return this.currentControl || this.host.parentElement;
    }
    set control(control) {
        if (control) {
            this.attach(control);
        }
        else {
            this.detach();
        }
    }
    /**
     * Creates a new controller for an `Attachable` element.
     *
     * @param host The `Attachable` element.
     * @param onControlChange A callback with two parameters for the previous and
     *     next control. An `Attachable` element may perform setup or teardown
     *     logic whenever the control changes.
     */
    constructor(host, onControlChange) {
        this.host = host;
        this.onControlChange = onControlChange;
        this.currentControl = null;
        host.addController(this);
        host[ATTACHABLE_CONTROLLER] = this;
        FOR_ATTRIBUTE_OBSERVER?.observe(host, { attributeFilter: ['for'] });
    }
    attach(control) {
        if (control === this.currentControl) {
            return;
        }
        this.setCurrentControl(control);
        // When imperatively attaching, remove the `for` attribute so
        // that the attached control is used instead of a referenced one.
        this.host.removeAttribute('for');
    }
    detach() {
        this.setCurrentControl(null);
        // When imperatively detaching, add an empty `for=""` attribute. This will
        // ensure the control is `null` rather than the `parentElement`.
        this.host.setAttribute('for', '');
    }
    /** @private */
    hostConnected() {
        this.setCurrentControl(this.control);
    }
    /** @private */
    hostDisconnected() {
        this.setCurrentControl(null);
    }
    setCurrentControl(control) {
        this.onControlChange(this.currentControl, control);
        this.currentControl = control;
    }
}

/**
 * @license
 * Copyright 2021 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
/**
 * Events that the focus ring listens to.
 */
const EVENTS$1 = ['focusin', 'focusout', 'pointerdown'];
/**
 * A focus ring component.
 *
 * @fires visibility-changed {Event} Fired whenever `visible` changes.
 */
class FocusRing extends LitElement {
    constructor() {
        super(...arguments);
        /**
         * Makes the focus ring visible.
         */
        this.visible = false;
        /**
         * Makes the focus ring animate inwards instead of outwards.
         */
        this.inward = false;
        this.attachableController = new AttachableController(this, this.onControlChange.bind(this));
    }
    get htmlFor() {
        return this.attachableController.htmlFor;
    }
    set htmlFor(htmlFor) {
        this.attachableController.htmlFor = htmlFor;
    }
    get control() {
        return this.attachableController.control;
    }
    set control(control) {
        this.attachableController.control = control;
    }
    attach(control) {
        this.attachableController.attach(control);
    }
    detach() {
        this.attachableController.detach();
    }
    connectedCallback() {
        super.connectedCallback();
        // Needed for VoiceOver, which will create a "group" if the element is a
        // sibling to other content.
        this.setAttribute('aria-hidden', 'true');
    }
    /** @private */
    handleEvent(event) {
        if (event[HANDLED_BY_FOCUS_RING]) {
            // This ensures the focus ring does not activate when multiple focus rings
            // are used within a single component.
            return;
        }
        switch (event.type) {
            default:
                return;
            case 'focusin':
                this.visible = this.control?.matches(':focus-visible') ?? false;
                break;
            case 'focusout':
            case 'pointerdown':
                this.visible = false;
                break;
        }
        event[HANDLED_BY_FOCUS_RING] = true;
    }
    onControlChange(prev, next) {
        if (isServer)
            return;
        for (const event of EVENTS$1) {
            prev?.removeEventListener(event, this);
            next?.addEventListener(event, this);
        }
    }
    update(changed) {
        if (changed.has('visible')) {
            // This logic can be removed once the `:has` selector has been introduced
            // to Firefox. This is necessary to allow correct submenu styles.
            this.dispatchEvent(new Event('visibility-changed'));
        }
        super.update(changed);
    }
}
__decorate$1([
    property({ type: Boolean, reflect: true })
], FocusRing.prototype, "visible", void 0);
__decorate$1([
    property({ type: Boolean, reflect: true })
], FocusRing.prototype, "inward", void 0);
const HANDLED_BY_FOCUS_RING = Symbol('handledByFocusRing');

/**
 * @license
 * Copyright 2024 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
// Generated stylesheet for ./focus/internal/focus-ring-styles.css.
const styles$7 = css `:host{animation-delay:0s,calc(var(--md-focus-ring-duration, 600ms)*.25);animation-duration:calc(var(--md-focus-ring-duration, 600ms)*.25),calc(var(--md-focus-ring-duration, 600ms)*.75);animation-timing-function:cubic-bezier(0.2, 0, 0, 1);box-sizing:border-box;color:var(--md-focus-ring-color, var(--md-sys-color-secondary, #625b71));display:none;pointer-events:none;position:absolute}:host([visible]){display:flex}:host(:not([inward])){animation-name:outward-grow,outward-shrink;border-end-end-radius:calc(var(--md-focus-ring-shape-end-end, var(--md-focus-ring-shape, var(--md-sys-shape-corner-full, 9999px))) + var(--md-focus-ring-outward-offset, 2px));border-end-start-radius:calc(var(--md-focus-ring-shape-end-start, var(--md-focus-ring-shape, var(--md-sys-shape-corner-full, 9999px))) + var(--md-focus-ring-outward-offset, 2px));border-start-end-radius:calc(var(--md-focus-ring-shape-start-end, var(--md-focus-ring-shape, var(--md-sys-shape-corner-full, 9999px))) + var(--md-focus-ring-outward-offset, 2px));border-start-start-radius:calc(var(--md-focus-ring-shape-start-start, var(--md-focus-ring-shape, var(--md-sys-shape-corner-full, 9999px))) + var(--md-focus-ring-outward-offset, 2px));inset:calc(-1*var(--md-focus-ring-outward-offset, 2px));outline:var(--md-focus-ring-width, 3px) solid currentColor}:host([inward]){animation-name:inward-grow,inward-shrink;border-end-end-radius:calc(var(--md-focus-ring-shape-end-end, var(--md-focus-ring-shape, var(--md-sys-shape-corner-full, 9999px))) - var(--md-focus-ring-inward-offset, 0px));border-end-start-radius:calc(var(--md-focus-ring-shape-end-start, var(--md-focus-ring-shape, var(--md-sys-shape-corner-full, 9999px))) - var(--md-focus-ring-inward-offset, 0px));border-start-end-radius:calc(var(--md-focus-ring-shape-start-end, var(--md-focus-ring-shape, var(--md-sys-shape-corner-full, 9999px))) - var(--md-focus-ring-inward-offset, 0px));border-start-start-radius:calc(var(--md-focus-ring-shape-start-start, var(--md-focus-ring-shape, var(--md-sys-shape-corner-full, 9999px))) - var(--md-focus-ring-inward-offset, 0px));border:var(--md-focus-ring-width, 3px) solid currentColor;inset:var(--md-focus-ring-inward-offset, 0px)}@keyframes outward-grow{from{outline-width:0}to{outline-width:var(--md-focus-ring-active-width, 8px)}}@keyframes outward-shrink{from{outline-width:var(--md-focus-ring-active-width, 8px)}}@keyframes inward-grow{from{border-width:0}to{border-width:var(--md-focus-ring-active-width, 8px)}}@keyframes inward-shrink{from{border-width:var(--md-focus-ring-active-width, 8px)}}@media(prefers-reduced-motion){:host{animation:none}}
`;

/**
 * @license
 * Copyright 2021 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
/**
 * TODO(b/267336424): add docs
 *
 * @final
 * @suppress {visibility}
 */
let MdFocusRing = class MdFocusRing extends FocusRing {
};
MdFocusRing.styles = [styles$7];
MdFocusRing = __decorate$1([
    customElement('md-focus-ring')
], MdFocusRing);

/**
 * @license
 * Copyright 2021 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
/**
 * Easing functions to use for web animations.
 *
 * **NOTE:** `EASING.EMPHASIZED` is approximated with unknown accuracy.
 *
 * TODO(b/241113345): replace with tokens
 */
const EASING = {
    STANDARD: 'cubic-bezier(0.2, 0, 0, 1)',
    STANDARD_ACCELERATE: 'cubic-bezier(.3,0,1,1)',
    STANDARD_DECELERATE: 'cubic-bezier(0,0,0,1)',
    EMPHASIZED: 'cubic-bezier(.3,0,0,1)',
    EMPHASIZED_ACCELERATE: 'cubic-bezier(.3,0,.8,.15)',
    EMPHASIZED_DECELERATE: 'cubic-bezier(.05,.7,.1,1)',
};

/**
 * @license
 * Copyright 2022 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
const PRESS_GROW_MS = 450;
const MINIMUM_PRESS_MS = 225;
const INITIAL_ORIGIN_SCALE = 0.2;
const PADDING = 10;
const SOFT_EDGE_MINIMUM_SIZE = 75;
const SOFT_EDGE_CONTAINER_RATIO = 0.35;
const PRESS_PSEUDO = '::after';
const ANIMATION_FILL = 'forwards';
/**
 * Interaction states for the ripple.
 *
 * On Touch:
 *  - `INACTIVE -> TOUCH_DELAY -> WAITING_FOR_CLICK -> INACTIVE`
 *  - `INACTIVE -> TOUCH_DELAY -> HOLDING -> WAITING_FOR_CLICK -> INACTIVE`
 *
 * On Mouse or Pen:
 *   - `INACTIVE -> WAITING_FOR_CLICK -> INACTIVE`
 */
var State;
(function (State) {
    /**
     * Initial state of the control, no touch in progress.
     *
     * Transitions:
     *   - on touch down: transition to `TOUCH_DELAY`.
     *   - on mouse down: transition to `WAITING_FOR_CLICK`.
     */
    State[State["INACTIVE"] = 0] = "INACTIVE";
    /**
     * Touch down has been received, waiting to determine if it's a swipe or
     * scroll.
     *
     * Transitions:
     *   - on touch up: begin press; transition to `WAITING_FOR_CLICK`.
     *   - on cancel: transition to `INACTIVE`.
     *   - after `TOUCH_DELAY_MS`: begin press; transition to `HOLDING`.
     */
    State[State["TOUCH_DELAY"] = 1] = "TOUCH_DELAY";
    /**
     * A touch has been deemed to be a press
     *
     * Transitions:
     *  - on up: transition to `WAITING_FOR_CLICK`.
     */
    State[State["HOLDING"] = 2] = "HOLDING";
    /**
     * The user touch has finished, transition into rest state.
     *
     * Transitions:
     *   - on click end press; transition to `INACTIVE`.
     */
    State[State["WAITING_FOR_CLICK"] = 3] = "WAITING_FOR_CLICK";
})(State || (State = {}));
/**
 * Events that the ripple listens to.
 */
const EVENTS = [
    'click',
    'contextmenu',
    'pointercancel',
    'pointerdown',
    'pointerenter',
    'pointerleave',
    'pointerup',
];
/**
 * Delay reacting to touch so that we do not show the ripple for a swipe or
 * scroll interaction.
 */
const TOUCH_DELAY_MS = 150;
/**
 * Used to detect if HCM is active. Events do not process during HCM when the
 * ripple is not displayed.
 */
const FORCED_COLORS = isServer
    ? null
    : window.matchMedia('(forced-colors: active)');
/**
 * A ripple component.
 */
class Ripple extends LitElement {
    constructor() {
        super(...arguments);
        /**
         * Disables the ripple.
         */
        this.disabled = false;
        this.hovered = false;
        this.pressed = false;
        this.rippleSize = '';
        this.rippleScale = '';
        this.initialSize = 0;
        this.state = State.INACTIVE;
        this.checkBoundsAfterContextMenu = false;
        this.attachableController = new AttachableController(this, this.onControlChange.bind(this));
    }
    get htmlFor() {
        return this.attachableController.htmlFor;
    }
    set htmlFor(htmlFor) {
        this.attachableController.htmlFor = htmlFor;
    }
    get control() {
        return this.attachableController.control;
    }
    set control(control) {
        this.attachableController.control = control;
    }
    attach(control) {
        this.attachableController.attach(control);
    }
    detach() {
        this.attachableController.detach();
    }
    connectedCallback() {
        super.connectedCallback();
        // Needed for VoiceOver, which will create a "group" if the element is a
        // sibling to other content.
        this.setAttribute('aria-hidden', 'true');
    }
    render() {
        const classes = {
            'hovered': this.hovered,
            'pressed': this.pressed,
        };
        return html `<div class="surface ${classMap(classes)}"></div>`;
    }
    update(changedProps) {
        if (changedProps.has('disabled') && this.disabled) {
            this.hovered = false;
            this.pressed = false;
        }
        super.update(changedProps);
    }
    /**
     * TODO(b/269799771): make private
     * @private only public for slider
     */
    handlePointerenter(event) {
        if (!this.shouldReactToEvent(event)) {
            return;
        }
        this.hovered = true;
    }
    /**
     * TODO(b/269799771): make private
     * @private only public for slider
     */
    handlePointerleave(event) {
        if (!this.shouldReactToEvent(event)) {
            return;
        }
        this.hovered = false;
        // release a held mouse or pen press that moves outside the element
        if (this.state !== State.INACTIVE) {
            this.endPressAnimation();
        }
    }
    handlePointerup(event) {
        if (!this.shouldReactToEvent(event)) {
            return;
        }
        if (this.state === State.HOLDING) {
            this.state = State.WAITING_FOR_CLICK;
            return;
        }
        if (this.state === State.TOUCH_DELAY) {
            this.state = State.WAITING_FOR_CLICK;
            this.startPressAnimation(this.rippleStartEvent);
            return;
        }
    }
    async handlePointerdown(event) {
        if (!this.shouldReactToEvent(event)) {
            return;
        }
        this.rippleStartEvent = event;
        if (!this.isTouch(event)) {
            this.state = State.WAITING_FOR_CLICK;
            this.startPressAnimation(event);
            return;
        }
        // after a longpress contextmenu event, an extra `pointerdown` can be
        // dispatched to the pressed element. Check that the down is within
        // bounds of the element in this case.
        if (this.checkBoundsAfterContextMenu && !this.inBounds(event)) {
            return;
        }
        this.checkBoundsAfterContextMenu = false;
        // Wait for a hold after touch delay
        this.state = State.TOUCH_DELAY;
        await new Promise((resolve) => {
            setTimeout(resolve, TOUCH_DELAY_MS);
        });
        if (this.state !== State.TOUCH_DELAY) {
            return;
        }
        this.state = State.HOLDING;
        this.startPressAnimation(event);
    }
    handleClick() {
        // Click is a MouseEvent in Firefox and Safari, so we cannot use
        // `shouldReactToEvent`
        if (this.disabled) {
            return;
        }
        if (this.state === State.WAITING_FOR_CLICK) {
            this.endPressAnimation();
            return;
        }
        if (this.state === State.INACTIVE) {
            // keyboard synthesized click event
            this.startPressAnimation();
            this.endPressAnimation();
        }
    }
    handlePointercancel(event) {
        if (!this.shouldReactToEvent(event)) {
            return;
        }
        this.endPressAnimation();
    }
    handleContextmenu() {
        if (this.disabled) {
            return;
        }
        this.checkBoundsAfterContextMenu = true;
        this.endPressAnimation();
    }
    determineRippleSize() {
        const { height, width } = this.getBoundingClientRect();
        const maxDim = Math.max(height, width);
        const softEdgeSize = Math.max(SOFT_EDGE_CONTAINER_RATIO * maxDim, SOFT_EDGE_MINIMUM_SIZE);
        const initialSize = Math.floor(maxDim * INITIAL_ORIGIN_SCALE);
        const hypotenuse = Math.sqrt(width ** 2 + height ** 2);
        const maxRadius = hypotenuse + PADDING;
        this.initialSize = initialSize;
        this.rippleScale = `${(maxRadius + softEdgeSize) / initialSize}`;
        this.rippleSize = `${initialSize}px`;
    }
    getNormalizedPointerEventCoords(pointerEvent) {
        const { scrollX, scrollY } = window;
        const { left, top } = this.getBoundingClientRect();
        const documentX = scrollX + left;
        const documentY = scrollY + top;
        const { pageX, pageY } = pointerEvent;
        return { x: pageX - documentX, y: pageY - documentY };
    }
    getTranslationCoordinates(positionEvent) {
        const { height, width } = this.getBoundingClientRect();
        // end in the center
        const endPoint = {
            x: (width - this.initialSize) / 2,
            y: (height - this.initialSize) / 2,
        };
        let startPoint;
        if (positionEvent instanceof PointerEvent) {
            startPoint = this.getNormalizedPointerEventCoords(positionEvent);
        }
        else {
            startPoint = {
                x: width / 2,
                y: height / 2,
            };
        }
        // center around start point
        startPoint = {
            x: startPoint.x - this.initialSize / 2,
            y: startPoint.y - this.initialSize / 2,
        };
        return { startPoint, endPoint };
    }
    startPressAnimation(positionEvent) {
        if (!this.mdRoot) {
            return;
        }
        this.pressed = true;
        this.growAnimation?.cancel();
        this.determineRippleSize();
        const { startPoint, endPoint } = this.getTranslationCoordinates(positionEvent);
        const translateStart = `${startPoint.x}px, ${startPoint.y}px`;
        const translateEnd = `${endPoint.x}px, ${endPoint.y}px`;
        this.growAnimation = this.mdRoot.animate({
            top: [0, 0],
            left: [0, 0],
            height: [this.rippleSize, this.rippleSize],
            width: [this.rippleSize, this.rippleSize],
            transform: [
                `translate(${translateStart}) scale(1)`,
                `translate(${translateEnd}) scale(${this.rippleScale})`,
            ],
        }, {
            pseudoElement: PRESS_PSEUDO,
            duration: PRESS_GROW_MS,
            easing: EASING.STANDARD,
            fill: ANIMATION_FILL,
        });
    }
    async endPressAnimation() {
        this.rippleStartEvent = undefined;
        this.state = State.INACTIVE;
        const animation = this.growAnimation;
        let pressAnimationPlayState = Infinity;
        if (typeof animation?.currentTime === 'number') {
            pressAnimationPlayState = animation.currentTime;
        }
        else if (animation?.currentTime) {
            pressAnimationPlayState = animation.currentTime.to('ms').value;
        }
        if (pressAnimationPlayState >= MINIMUM_PRESS_MS) {
            this.pressed = false;
            return;
        }
        await new Promise((resolve) => {
            setTimeout(resolve, MINIMUM_PRESS_MS - pressAnimationPlayState);
        });
        if (this.growAnimation !== animation) {
            // A new press animation was started. The old animation was canceled and
            // should not finish the pressed state.
            return;
        }
        this.pressed = false;
    }
    /**
     * Returns `true` if
     *  - the ripple element is enabled
     *  - the pointer is primary for the input type
     *  - the pointer is the pointer that started the interaction, or will start
     * the interaction
     *  - the pointer is a touch, or the pointer state has the primary button
     * held, or the pointer is hovering
     */
    shouldReactToEvent(event) {
        if (this.disabled || !event.isPrimary) {
            return false;
        }
        if (this.rippleStartEvent &&
            this.rippleStartEvent.pointerId !== event.pointerId) {
            return false;
        }
        if (event.type === 'pointerenter' || event.type === 'pointerleave') {
            return !this.isTouch(event);
        }
        const isPrimaryButton = event.buttons === 1;
        return this.isTouch(event) || isPrimaryButton;
    }
    /**
     * Check if the event is within the bounds of the element.
     *
     * This is only needed for the "stuck" contextmenu longpress on Chrome.
     */
    inBounds({ x, y }) {
        const { top, left, bottom, right } = this.getBoundingClientRect();
        return x >= left && x <= right && y >= top && y <= bottom;
    }
    isTouch({ pointerType }) {
        return pointerType === 'touch';
    }
    /** @private */
    async handleEvent(event) {
        if (FORCED_COLORS?.matches) {
            // Skip event logic since the ripple is `display: none`.
            return;
        }
        switch (event.type) {
            case 'click':
                this.handleClick();
                break;
            case 'contextmenu':
                this.handleContextmenu();
                break;
            case 'pointercancel':
                this.handlePointercancel(event);
                break;
            case 'pointerdown':
                await this.handlePointerdown(event);
                break;
            case 'pointerenter':
                this.handlePointerenter(event);
                break;
            case 'pointerleave':
                this.handlePointerleave(event);
                break;
            case 'pointerup':
                this.handlePointerup(event);
                break;
        }
    }
    onControlChange(prev, next) {
        if (isServer)
            return;
        for (const event of EVENTS) {
            prev?.removeEventListener(event, this);
            next?.addEventListener(event, this);
        }
    }
}
__decorate$1([
    property({ type: Boolean, reflect: true })
], Ripple.prototype, "disabled", void 0);
__decorate$1([
    state()
], Ripple.prototype, "hovered", void 0);
__decorate$1([
    state()
], Ripple.prototype, "pressed", void 0);
__decorate$1([
    query('.surface')
], Ripple.prototype, "mdRoot", void 0);

/**
 * @license
 * Copyright 2024 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
// Generated stylesheet for ./ripple/internal/ripple-styles.css.
const styles$6 = css `:host{display:flex;margin:auto;pointer-events:none}:host([disabled]){display:none}@media(forced-colors: active){:host{display:none}}:host,.surface{border-radius:inherit;position:absolute;inset:0;overflow:hidden}.surface{-webkit-tap-highlight-color:rgba(0,0,0,0)}.surface::before,.surface::after{content:"";opacity:0;position:absolute}.surface::before{background-color:var(--md-ripple-hover-color, var(--md-sys-color-on-surface, #1d1b20));inset:0;transition:opacity 15ms linear,background-color 15ms linear}.surface::after{background:radial-gradient(closest-side, var(--md-ripple-pressed-color, var(--md-sys-color-on-surface, #1d1b20)) max(100% - 70px, 65%), transparent 100%);transform-origin:center center;transition:opacity 375ms linear}.hovered::before{background-color:var(--md-ripple-hover-color, var(--md-sys-color-on-surface, #1d1b20));opacity:var(--md-ripple-hover-opacity, 0.08)}.pressed::after{opacity:var(--md-ripple-pressed-opacity, 0.12);transition-duration:105ms}
`;

/**
 * @license
 * Copyright 2022 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
/**
 * @summary Ripples, also known as state layers, are visual indicators used to
 * communicate the status of a component or interactive element.
 *
 * @description A state layer is a semi-transparent covering on an element that
 * indicates its state. State layers provide a systematic approach to
 * visualizing states by using opacity. A layer can be applied to an entire
 * element or in a circular shape and only one state layer can be applied at a
 * given time.
 *
 * @final
 * @suppress {visibility}
 */
let MdRipple = class MdRipple extends Ripple {
};
MdRipple.styles = [styles$6];
MdRipple = __decorate$1([
    customElement('md-ripple')
], MdRipple);

/**
 * @license
 * Copyright 2023 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
/**
 * Accessibility Object Model reflective aria properties.
 */
const ARIA_PROPERTIES = [
    'role',
    'ariaAtomic',
    'ariaAutoComplete',
    'ariaBusy',
    'ariaChecked',
    'ariaColCount',
    'ariaColIndex',
    'ariaColSpan',
    'ariaCurrent',
    'ariaDisabled',
    'ariaExpanded',
    'ariaHasPopup',
    'ariaHidden',
    'ariaInvalid',
    'ariaKeyShortcuts',
    'ariaLabel',
    'ariaLevel',
    'ariaLive',
    'ariaModal',
    'ariaMultiLine',
    'ariaMultiSelectable',
    'ariaOrientation',
    'ariaPlaceholder',
    'ariaPosInSet',
    'ariaPressed',
    'ariaReadOnly',
    'ariaRequired',
    'ariaRoleDescription',
    'ariaRowCount',
    'ariaRowIndex',
    'ariaRowSpan',
    'ariaSelected',
    'ariaSetSize',
    'ariaSort',
    'ariaValueMax',
    'ariaValueMin',
    'ariaValueNow',
    'ariaValueText',
];
/**
 * Accessibility Object Model aria attributes.
 */
const ARIA_ATTRIBUTES = ARIA_PROPERTIES.map(ariaPropertyToAttribute);
/**
 * Checks if an attribute is one of the AOM aria attributes.
 *
 * @example
 * isAriaAttribute('aria-label'); // true
 *
 * @param attribute The attribute to check.
 * @return True if the attribute is an aria attribute, or false if not.
 */
function isAriaAttribute(attribute) {
    return ARIA_ATTRIBUTES.includes(attribute);
}
/**
 * Converts an AOM aria property into its corresponding attribute.
 *
 * @example
 * ariaPropertyToAttribute('ariaLabel'); // 'aria-label'
 *
 * @param property The aria property.
 * @return The aria attribute.
 */
function ariaPropertyToAttribute(property) {
    return property
        .replace('aria', 'aria-')
        // IDREF attributes also include an "Element" or "Elements" suffix
        .replace(/Elements?/g, '')
        .toLowerCase();
}

/**
 * @license
 * Copyright 2023 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
// Private symbols
const privateIgnoreAttributeChangesFor = Symbol('privateIgnoreAttributeChangesFor');
/**
 * Mixes in aria delegation for elements that delegate focus and aria to inner
 * shadow root elements.
 *
 * This mixin fixes invalid aria announcements with shadow roots, caused by
 * duplicate aria attributes on both the host and the inner shadow root element.
 *
 * Note: this mixin **does not yet support** ID reference attributes, such as
 * `aria-labelledby` or `aria-controls`.
 *
 * @example
 * ```ts
 * class MyButton extends mixinDelegatesAria(LitElement) {
 *   static shadowRootOptions = {mode: 'open', delegatesFocus: true};
 *
 *   render() {
 *     return html`
 *       <button aria-label=${this.ariaLabel || nothing}>
 *         <slot></slot>
 *       </button>
 *     `;
 *   }
 * }
 * ```
 * ```html
 * <my-button aria-label="Plus one">+1</my-button>
 * ```
 *
 * Use `ARIAMixinStrict` for lit analyzer strict types, such as the "role"
 * attribute.
 *
 * @example
 * ```ts
 * return html`
 *   <button role=${(this as ARIAMixinStrict).role || nothing}>
 *     <slot></slot>
 *   </button>
 * `;
 * ```
 *
 * In the future, updates to the Accessibility Object Model (AOM) will provide
 * built-in aria delegation features that will replace this mixin.
 *
 * @param base The class to mix functionality into.
 * @return The provided class with aria delegation mixed in.
 */
function mixinDelegatesAria(base) {
    var _a;
    if (isServer) {
        // Don't shift attributes when running with lit-ssr. The SSR renderer
        // implements a subset of DOM APIs, including the methods this mixin
        // overrides, causing errors. We don't need to shift on the server anyway
        // since elements will shift attributes immediately once they hydrate.
        return base;
    }
    class WithDelegatesAriaElement extends base {
        constructor() {
            super(...arguments);
            this[_a] = new Set();
        }
        attributeChangedCallback(name, oldValue, newValue) {
            if (!isAriaAttribute(name)) {
                super.attributeChangedCallback(name, oldValue, newValue);
                return;
            }
            if (this[privateIgnoreAttributeChangesFor].has(name)) {
                return;
            }
            // Don't trigger another `attributeChangedCallback` once we remove the
            // aria attribute from the host. We check the explicit name of the
            // attribute to ignore since `attributeChangedCallback` can be called
            // multiple times out of an expected order when hydrating an element with
            // multiple attributes.
            this[privateIgnoreAttributeChangesFor].add(name);
            this.removeAttribute(name);
            this[privateIgnoreAttributeChangesFor].delete(name);
            const dataProperty = ariaAttributeToDataProperty(name);
            if (newValue === null) {
                delete this.dataset[dataProperty];
            }
            else {
                this.dataset[dataProperty] = newValue;
            }
            this.requestUpdate(ariaAttributeToDataProperty(name), oldValue);
        }
        getAttribute(name) {
            if (isAriaAttribute(name)) {
                return super.getAttribute(ariaAttributeToDataAttribute(name));
            }
            return super.getAttribute(name);
        }
        removeAttribute(name) {
            super.removeAttribute(name);
            if (isAriaAttribute(name)) {
                super.removeAttribute(ariaAttributeToDataAttribute(name));
                // Since `aria-*` attributes are already removed`, we need to request
                // an update because `attributeChangedCallback` will not be called.
                this.requestUpdate();
            }
        }
    }
    _a = privateIgnoreAttributeChangesFor;
    setupDelegatesAriaProperties(WithDelegatesAriaElement);
    return WithDelegatesAriaElement;
}
/**
 * Overrides the constructor's native `ARIAMixin` properties to ensure that
 * aria properties reflect the values that were shifted to a data attribute.
 *
 * @param ctor The `ReactiveElement` constructor to patch.
 */
function setupDelegatesAriaProperties(ctor) {
    for (const ariaProperty of ARIA_PROPERTIES) {
        // The casing between ariaProperty and the dataProperty may be different.
        // ex: aria-haspopup -> ariaHasPopup
        const ariaAttribute = ariaPropertyToAttribute(ariaProperty);
        // ex: aria-haspopup -> data-aria-haspopup
        const dataAttribute = ariaAttributeToDataAttribute(ariaAttribute);
        // ex: aria-haspopup -> dataset.ariaHaspopup
        const dataProperty = ariaAttributeToDataProperty(ariaAttribute);
        // Call `ReactiveElement.createProperty()` so that the `aria-*` and `data-*`
        // attributes are added to the `static observedAttributes` array. This
        // triggers `attributeChangedCallback` for the delegates aria mixin to
        // handle.
        ctor.createProperty(ariaProperty, {
            attribute: ariaAttribute,
            noAccessor: true,
        });
        ctor.createProperty(Symbol(dataAttribute), {
            attribute: dataAttribute,
            noAccessor: true,
        });
        // Re-define the `ARIAMixin` properties to handle data attribute shifting.
        // It is safe to use `Object.defineProperty` here because the properties
        // are native and not renamed.
        // tslint:disable-next-line:ban-unsafe-reflection
        Object.defineProperty(ctor.prototype, ariaProperty, {
            configurable: true,
            enumerable: true,
            get() {
                return this.dataset[dataProperty] ?? null;
            },
            set(value) {
                const prevValue = this.dataset[dataProperty] ?? null;
                if (value === prevValue) {
                    return;
                }
                if (value === null) {
                    delete this.dataset[dataProperty];
                }
                else {
                    this.dataset[dataProperty] = value;
                }
                this.requestUpdate(ariaProperty, prevValue);
            },
        });
    }
}
function ariaAttributeToDataAttribute(ariaAttribute) {
    // aria-haspopup -> data-aria-haspopup
    return `data-${ariaAttribute}`;
}
function ariaAttributeToDataProperty(ariaAttribute) {
    // aria-haspopup -> dataset.ariaHaspopup
    return ariaAttribute.replace(/-\w/, (dashLetter) => dashLetter[1].toUpperCase());
}

/**
 * @license
 * Copyright 2023 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
/**
 * A symbol used to access dispatch hooks on an event.
 */
const dispatchHooks = Symbol('dispatchHooks');
/**
 * Add a hook for an event that is called after the event is dispatched and
 * propagates to other event listeners.
 *
 * This is useful for behaviors that need to check if an event is canceled.
 *
 * The callback is invoked synchronously, which allows for better integration
 * with synchronous platform APIs (like `<form>` or `<label>` clicking).
 *
 * Note: `setupDispatchHooks()` must be called on the element before adding any
 * other event listeners. Call it in the constructor of an element or
 * controller.
 *
 * @example
 * ```ts
 * class MyControl extends LitElement {
 *   constructor() {
 *     super();
 *     setupDispatchHooks(this, 'click');
 *     this.addEventListener('click', event => {
 *       afterDispatch(event, () => {
 *         if (event.defaultPrevented) {
 *           return
 *         }
 *
 *         // ... perform logic
 *       });
 *     });
 *   }
 * }
 * ```
 *
 * @example
 * ```ts
 * class MyController implements ReactiveController {
 *   constructor(host: ReactiveElement) {
 *     // setupDispatchHooks() may be called multiple times for the same
 *     // element and events, making it safe for multiple controllers to use it.
 *     setupDispatchHooks(host, 'click');
 *     host.addEventListener('click', event => {
 *       afterDispatch(event, () => {
 *         if (event.defaultPrevented) {
 *           return;
 *         }
 *
 *         // ... perform logic
 *       });
 *     });
 *   }
 * }
 * ```
 *
 * @param event The event to add a hook to.
 * @param callback A hook that is called after the event finishes dispatching.
 */
function afterDispatch(event, callback) {
    const hooks = event[dispatchHooks];
    if (!hooks) {
        throw new Error(`'${event.type}' event needs setupDispatchHooks().`);
    }
    hooks.addEventListener('after', callback);
}
/**
 * A lookup map of elements and event types that have a dispatch hook listener
 * set up. Used to ensure we don't set up multiple hook listeners on the same
 * element for the same event.
 */
const ELEMENT_DISPATCH_HOOK_TYPES = new WeakMap();
/**
 * Sets up an element to add dispatch hooks to given event types. This must be
 * called before adding any event listeners that need to use dispatch hooks
 * like `afterDispatch()`.
 *
 * This function is safe to call multiple times with the same element or event
 * types. Call it in the constructor of elements, mixins, and controllers to
 * ensure it is set up before external listeners.
 *
 * @example
 * ```ts
 * class MyControl extends LitElement {
 *   constructor() {
 *     super();
 *     setupDispatchHooks(this, 'click');
 *     this.addEventListener('click', this.listenerUsingAfterDispatch);
 *   }
 * }
 * ```
 *
 * @param element The element to set up event dispatch hooks for.
 * @param eventTypes The event types to add dispatch hooks to.
 */
function setupDispatchHooks(element, ...eventTypes) {
    let typesAlreadySetUp = ELEMENT_DISPATCH_HOOK_TYPES.get(element);
    if (!typesAlreadySetUp) {
        typesAlreadySetUp = new Set();
        ELEMENT_DISPATCH_HOOK_TYPES.set(element, typesAlreadySetUp);
    }
    for (const eventType of eventTypes) {
        // Don't register multiple dispatch hook listeners. A second registration
        // would lead to the second listener re-dispatching a re-dispatched event,
        // which can cause an infinite loop inside the other one.
        if (typesAlreadySetUp.has(eventType)) {
            continue;
        }
        // When we re-dispatch the event, it's going to immediately trigger this
        // listener again. Use a flag to ignore it.
        let isRedispatching = false;
        element.addEventListener(eventType, (event) => {
            if (isRedispatching) {
                return;
            }
            // Do not let the event propagate to any other listener (not just
            // bubbling listeners with `stopPropagation()`).
            event.stopImmediatePropagation();
            // Make a copy.
            const eventCopy = Reflect.construct(event.constructor, [
                event.type,
                event,
            ]);
            // Add hooks onto the event.
            const hooks = new EventTarget();
            eventCopy[dispatchHooks] = hooks;
            // Re-dispatch the event. We can't reuse `redispatchEvent()` since we
            // need to add the hooks to the copy before it's dispatched.
            isRedispatching = true;
            const dispatched = element.dispatchEvent(eventCopy);
            isRedispatching = false;
            if (!dispatched) {
                event.preventDefault();
            }
            // Synchronously call afterDispatch() hooks.
            hooks.dispatchEvent(new Event('after'));
        }, {
            // Ensure this listener runs before other listeners.
            // `setupDispatchHooks()` should be called in constructors to also
            // ensure they run before any other externally-added capture listeners.
            capture: true,
        });
        typesAlreadySetUp.add(eventType);
    }
}

/**
 * @license
 * Copyright 2021 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
/**
 * Dispatches a click event to the given element that triggers a native action,
 * but is not composed and therefore is not seen outside the element.
 *
 * This is useful for responding to an external click event on the host element
 * that should trigger an internal action like a button click.
 *
 * Note, a helper is provided because setting this up correctly is a bit tricky.
 * In particular, calling `click` on an element creates a composed event, which
 * is not desirable, and a manually dispatched event must specifically be a
 * `MouseEvent` to trigger a native action.
 *
 * @example
 * hostClickListener = (event: MouseEvent) {
 *   if (isActivationClick(event)) {
 *     this.dispatchActivationClick(this.buttonElement);
 *   }
 * }
 *
 */
function dispatchActivationClick(element) {
    const event = new MouseEvent('click', { bubbles: true });
    element.dispatchEvent(event);
    return event;
}
/**
 * Returns true if the click event should trigger an activation behavior. The
 * behavior is defined by the element and is whatever it should do when
 * clicked.
 *
 * Typically when an element needs to handle a click, the click is generated
 * from within the element and an event listener within the element implements
 * the needed behavior; however, it's possible to fire a click directly
 * at the element that the element should handle. This method helps
 * distinguish these "external" clicks.
 *
 * An "external" click can be triggered in a number of ways: via a click
 * on an associated label for a form  associated element, calling
 * `element.click()`, or calling
 * `element.dispatchEvent(new MouseEvent('click', ...))`.
 *
 * Also works around Firefox issue
 * https://bugzilla.mozilla.org/show_bug.cgi?id=1804576 by squelching
 * events for a microtask after called.
 *
 * @example
 * hostClickListener = (event: MouseEvent) {
 *   if (isActivationClick(event)) {
 *     this.dispatchActivationClick(this.buttonElement);
 *   }
 * }
 *
 */
function isActivationClick(event) {
    // Event must start at the event target.
    if (event.currentTarget !== event.target) {
        return false;
    }
    // Event must not be retargeted from shadowRoot.
    if (event.composedPath()[0] !== event.target) {
        return false;
    }
    // Target must not be disabled; this should only occur for a synthetically
    // dispatched click.
    if (event.target.disabled) {
        return false;
    }
    // This is an activation if the event should not be squelched.
    return !squelchEvent(event);
}
// TODO(https://bugzilla.mozilla.org/show_bug.cgi?id=1804576)
//  Remove when Firefox bug is addressed.
function squelchEvent(event) {
    const squelched = isSquelchingEvents;
    if (squelched) {
        event.preventDefault();
        event.stopImmediatePropagation();
    }
    squelchEventsForMicrotask();
    return squelched;
}
// Ignore events for one microtask only.
let isSquelchingEvents = false;
async function squelchEventsForMicrotask() {
    isSquelchingEvents = true;
    // Need to pause for just one microtask.
    // tslint:disable-next-line
    await null;
    isSquelchingEvents = false;
}

/**
 * @license
 * Copyright 2021 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
/**
 * Re-dispatches an event from the provided element.
 *
 * This function is useful for forwarding non-composed events, such as `change`
 * events.
 *
 * @example
 * class MyInput extends LitElement {
 *   render() {
 *     return html`<input @change=${this.redispatchEvent}>`;
 *   }
 *
 *   protected redispatchEvent(event: Event) {
 *     redispatchEvent(this, event);
 *   }
 * }
 *
 * @param element The element to dispatch the event from.
 * @param event The event to re-dispatch.
 * @return Whether or not the event was dispatched (if cancelable).
 */
function redispatchEvent(element, event) {
    // For bubbling events in SSR light DOM (or composed), stop their propagation
    // and dispatch the copy.
    if (event.bubbles && (!element.shadowRoot || event.composed)) {
        event.stopPropagation();
    }
    const copy = Reflect.construct(event.constructor, [event.type, event]);
    const dispatched = element.dispatchEvent(copy);
    if (!dispatched) {
        event.preventDefault();
    }
    return dispatched;
}

/**
 * @license
 * Copyright 2023 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
/**
 * A unique symbol used for protected access to an instance's
 * `ElementInternals`.
 *
 * @example
 * ```ts
 * class MyElement extends mixinElementInternals(LitElement) {
 *   constructor() {
 *     super();
 *     this[internals].role = 'button';
 *   }
 * }
 * ```
 */
const internals = Symbol('internals');
// Private symbols
const privateInternals = Symbol('privateInternals');
/**
 * Mixes in an attached `ElementInternals` instance.
 *
 * This mixin is only needed when other shared code needs access to a
 * component's `ElementInternals`, such as form-associated mixins.
 *
 * @param base The class to mix functionality into.
 * @return The provided class with `WithElementInternals` mixed in.
 */
function mixinElementInternals(base) {
    class WithElementInternalsElement extends base {
        get [internals]() {
            // Create internals in getter so that it can be used in methods called on
            // construction in `ReactiveElement`, such as `requestUpdate()`.
            if (!this[privateInternals]) {
                // Cast needed for closure
                this[privateInternals] = this.attachInternals();
            }
            return this[privateInternals];
        }
    }
    return WithElementInternalsElement;
}

/**
 * @license
 * Copyright 2023 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
/**
 * A symbol property used to create a constraint validation `Validator`.
 * Required for all `mixinConstraintValidation()` elements.
 */
const createValidator = Symbol('createValidator');
/**
 * A symbol property used to return an anchor for constraint validation popups.
 * Required for all `mixinConstraintValidation()` elements.
 */
const getValidityAnchor = Symbol('getValidityAnchor');
// Private symbol members, used to avoid name clashing.
const privateValidator = Symbol('privateValidator');
const privateSyncValidity = Symbol('privateSyncValidity');
const privateCustomValidationMessage = Symbol('privateCustomValidationMessage');
/**
 * Mixes in constraint validation APIs for an element.
 *
 * See https://developer.mozilla.org/en-US/docs/Web/HTML/Constraint_validation
 * for more details.
 *
 * Implementations must provide a validator to cache and compute its validity,
 * along with a shadow root element to anchor validation popups to.
 *
 * @example
 * ```ts
 * const baseClass = mixinConstraintValidation(
 *   mixinFormAssociated(mixinElementInternals(LitElement))
 * );
 *
 * class MyCheckbox extends baseClass {
 *   \@property({type: Boolean}) checked = false;
 *   \@property({type: Boolean}) required = false;
 *
 *   [createValidator]() {
 *     return new CheckboxValidator(() => this);
 *   }
 *
 *   [getValidityAnchor]() {
 *     return this.renderRoot.querySelector('.root');
 *   }
 * }
 * ```
 *
 * @param base The class to mix functionality into.
 * @return The provided class with `ConstraintValidation` mixed in.
 */
function mixinConstraintValidation(base) {
    var _a;
    class ConstraintValidationElement extends base {
        constructor() {
            super(...arguments);
            /**
             * Needed for Safari, see https://bugs.webkit.org/show_bug.cgi?id=261432
             * Replace with this[internals].validity.customError when resolved.
             */
            this[_a] = '';
        }
        get validity() {
            this[privateSyncValidity]();
            return this[internals].validity;
        }
        get validationMessage() {
            this[privateSyncValidity]();
            return this[internals].validationMessage;
        }
        get willValidate() {
            this[privateSyncValidity]();
            return this[internals].willValidate;
        }
        checkValidity() {
            this[privateSyncValidity]();
            return this[internals].checkValidity();
        }
        reportValidity() {
            this[privateSyncValidity]();
            return this[internals].reportValidity();
        }
        setCustomValidity(error) {
            this[privateCustomValidationMessage] = error;
            this[privateSyncValidity]();
        }
        requestUpdate(name, oldValue, options) {
            super.requestUpdate(name, oldValue, options);
            this[privateSyncValidity]();
        }
        firstUpdated(changed) {
            super.firstUpdated(changed);
            // Sync the validity again when the element first renders, since the
            // validity anchor is now available.
            //
            // Elements that `delegatesFocus: true` to an `<input>` will throw an
            // error in Chrome and Safari when a form tries to submit or call
            // `form.reportValidity()`:
            // "An invalid form control with name='' is not focusable"
            //
            // The validity anchor MUST be provided in `internals.setValidity()` and
            // MUST be the `<input>` element rendered.
            //
            // See https://lit.dev/playground/#gist=6c26e418e0010f7a5aac15005cde8bde
            // for a reproduction.
            this[privateSyncValidity]();
        }
        [(_a = privateCustomValidationMessage, privateSyncValidity)]() {
            if (isServer) {
                return;
            }
            if (!this[privateValidator]) {
                this[privateValidator] = this[createValidator]();
            }
            const { validity, validationMessage: nonCustomValidationMessage } = this[privateValidator].getValidity();
            const customError = !!this[privateCustomValidationMessage];
            const validationMessage = this[privateCustomValidationMessage] || nonCustomValidationMessage;
            this[internals].setValidity({ ...validity, customError }, validationMessage, this[getValidityAnchor]() ?? undefined);
        }
        [createValidator]() {
            throw new Error('Implement [createValidator]');
        }
        [getValidityAnchor]() {
            throw new Error('Implement [getValidityAnchor]');
        }
    }
    return ConstraintValidationElement;
}

/**
 * @license
 * Copyright 2023 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
/**
 * A symbol property to retrieve the form value for an element.
 */
const getFormValue = Symbol('getFormValue');
/**
 * A symbol property to retrieve the form state for an element.
 */
const getFormState = Symbol('getFormState');
/**
 * Mixes in form-associated behavior for a class. This allows an element to add
 * values to `<form>` elements.
 *
 * Implementing classes should provide a `[formValue]` to return the current
 * value of the element, as well as reset and restore callbacks.
 *
 * @example
 * ```ts
 * const base = mixinFormAssociated(mixinElementInternals(LitElement));
 *
 * class MyControl extends base {
 *   \@property()
 *   value = '';
 *
 *   override [getFormValue]() {
 *     return this.value;
 *   }
 *
 *   override formResetCallback() {
 *     const defaultValue = this.getAttribute('value');
 *     this.value = defaultValue;
 *   }
 *
 *   override formStateRestoreCallback(state: string) {
 *     this.value = state;
 *   }
 * }
 * ```
 *
 * Elements may optionally provide a `[formState]` if their values do not
 * represent the state of the component.
 *
 * @example
 * ```ts
 * const base = mixinFormAssociated(mixinElementInternals(LitElement));
 *
 * class MyCheckbox extends base {
 *   \@property()
 *   value = 'on';
 *
 *   \@property({type: Boolean})
 *   checked = false;
 *
 *   override [getFormValue]() {
 *     return this.checked ? this.value : null;
 *   }
 *
 *   override [getFormState]() {
 *     return String(this.checked);
 *   }
 *
 *   override formResetCallback() {
 *     const defaultValue = this.hasAttribute('checked');
 *     this.checked = defaultValue;
 *   }
 *
 *   override formStateRestoreCallback(state: string) {
 *     this.checked = Boolean(state);
 *   }
 * }
 * ```
 *
 * IMPORTANT: Requires declares for lit-analyzer
 * @example
 * ```ts
 * const base = mixinFormAssociated(mixinElementInternals(LitElement));
 * class MyControl extends base {
 *   // Writable mixin properties for lit-html binding, needed for lit-analyzer
 *   declare disabled: boolean;
 *   declare name: string;
 * }
 * ```
 *
 * @param base The class to mix functionality into. The base class must use
 *     `mixinElementInternals()`.
 * @return The provided class with `FormAssociated` mixed in.
 */
function mixinFormAssociated(base) {
    class FormAssociatedElement extends base {
        get form() {
            return this[internals].form;
        }
        get labels() {
            return this[internals].labels;
        }
        // Use @property for the `name` and `disabled` properties to add them to the
        // `observedAttributes` array and trigger `attributeChangedCallback()`.
        //
        // We don't use Lit's default getter/setter (`noAccessor: true`) because
        // the attributes need to be updated synchronously to work with synchronous
        // form APIs, and Lit updates attributes async by default.
        get name() {
            return this.getAttribute('name') ?? '';
        }
        set name(name) {
            // Note: setting name to null or empty does not remove the attribute.
            this.setAttribute('name', name);
            // We don't need to call `requestUpdate()` since it's called synchronously
            // in `attributeChangedCallback()`.
        }
        get disabled() {
            return this.hasAttribute('disabled');
        }
        set disabled(disabled) {
            this.toggleAttribute('disabled', disabled);
            // We don't need to call `requestUpdate()` since it's called synchronously
            // in `attributeChangedCallback()`.
        }
        attributeChangedCallback(name, old, value) {
            // Manually `requestUpdate()` for `name` and `disabled` when their
            // attribute or property changes.
            // The properties update their attributes, so this callback is invoked
            // immediately when the properties are set. We call `requestUpdate()` here
            // instead of letting Lit set the properties from the attribute change.
            // That would cause the properties to re-set the attribute and invoke this
            // callback again in a loop. This leads to stale state when Lit tries to
            // determine if a property changed or not.
            if (name === 'name' || name === 'disabled') {
                // Disabled's value is only false if the attribute is missing and null.
                const oldValue = name === 'disabled' ? old !== null : old;
                // Trigger a lit update when the attribute changes.
                this.requestUpdate(name, oldValue);
                return;
            }
            super.attributeChangedCallback(name, old, value);
        }
        requestUpdate(name, oldValue, options) {
            super.requestUpdate(name, oldValue, options);
            // If any properties change, update the form value, which may have changed
            // as well.
            // Update the form value synchronously in `requestUpdate()` rather than
            // `update()` or `updated()`, which are async. This is necessary to ensure
            // that form data is updated in time for synchronous event listeners.
            this[internals].setFormValue(this[getFormValue](), this[getFormState]());
        }
        [getFormValue]() {
            // Closure does not allow abstract symbol members, so a default
            // implementation is needed.
            throw new Error('Implement [getFormValue]');
        }
        [getFormState]() {
            return this[getFormValue]();
        }
        formDisabledCallback(disabled) {
            this.disabled = disabled;
        }
    }
    /** @nocollapse */
    FormAssociatedElement.formAssociated = true;
    __decorate$1([
        property({ noAccessor: true })
    ], FormAssociatedElement.prototype, "name", null);
    __decorate$1([
        property({ type: Boolean, noAccessor: true })
    ], FormAssociatedElement.prototype, "disabled", null);
    return FormAssociatedElement;
}

/**
 * @license
 * Copyright 2023 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
/**
 * A class that computes and caches `ValidityStateFlags` for a component with
 * a given `State` interface.
 *
 * Cached performance before computing validity is important since constraint
 * validation must be checked frequently and synchronously when properties
 * change.
 *
 * @template State The expected interface of properties relevant to constraint
 *     validation.
 */
class Validator {
    /**
     * Creates a new validator.
     *
     * @param getCurrentState A callback that returns the current state of
     *     constraint validation-related properties.
     */
    constructor(getCurrentState) {
        this.getCurrentState = getCurrentState;
        /**
         * The current validity state and message. This is cached and returns if
         * constraint validation state does not change.
         */
        this.currentValidity = {
            validity: {},
            validationMessage: '',
        };
    }
    /**
     * Returns the current `ValidityStateFlags` and validation message for the
     * validator.
     *
     * If the constraint validation state has not changed, this will return a
     * cached result. This is important since `getValidity()` can be called
     * frequently in response to synchronous property changes.
     *
     * @return The current validity and validation message.
     */
    getValidity() {
        const state = this.getCurrentState();
        const hasStateChanged = !this.prevState || !this.equals(this.prevState, state);
        if (!hasStateChanged) {
            return this.currentValidity;
        }
        const { validity, validationMessage } = this.computeValidity(state);
        this.prevState = this.copy(state);
        this.currentValidity = {
            validationMessage,
            validity: {
                // Change any `ValidityState` instances into `ValidityStateFlags` since
                // `ValidityState` cannot be easily `{...spread}`.
                badInput: validity.badInput,
                customError: validity.customError,
                patternMismatch: validity.patternMismatch,
                rangeOverflow: validity.rangeOverflow,
                rangeUnderflow: validity.rangeUnderflow,
                stepMismatch: validity.stepMismatch,
                tooLong: validity.tooLong,
                tooShort: validity.tooShort,
                typeMismatch: validity.typeMismatch,
                valueMissing: validity.valueMissing,
            },
        };
        return this.currentValidity;
    }
}

/**
 * @license
 * Copyright 2023 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
/**
 * A validator that provides constraint validation that emulates
 * `<input type="checkbox">` validation.
 */
class CheckboxValidator extends Validator {
    computeValidity(state) {
        if (!this.checkboxControl) {
            // Lazily create the platform input
            this.checkboxControl = document.createElement('input');
            this.checkboxControl.type = 'checkbox';
        }
        this.checkboxControl.checked = state.checked;
        this.checkboxControl.required = state.required;
        return {
            validity: this.checkboxControl.validity,
            validationMessage: this.checkboxControl.validationMessage,
        };
    }
    equals(prev, next) {
        return prev.checked === next.checked && prev.required === next.required;
    }
    copy({ checked, required }) {
        return { checked, required };
    }
}

/**
 * @license
 * Copyright 2021 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
// Separate variable needed for closure.
const switchBaseClass = mixinDelegatesAria(mixinConstraintValidation(mixinFormAssociated(mixinElementInternals(LitElement))));
/**
 * @fires input {InputEvent} Fired whenever `selected` changes due to user
 * interaction (bubbles and composed).
 * @fires change {Event} Fired whenever `selected` changes due to user
 * interaction (bubbles).
 */
let Switch$1 = class Switch extends switchBaseClass {
    constructor() {
        super();
        /**
         * Puts the switch in the selected state and sets the form submission value to
         * the `value` property.
         */
        this.selected = false;
        /**
         * Shows both the selected and deselected icons.
         */
        this.icons = false;
        /**
         * Shows only the selected icon, and not the deselected icon. If `true`,
         * overrides the behavior of the `icons` property.
         */
        this.showOnlySelectedIcon = false;
        /**
         * When true, require the switch to be selected when participating in
         * form submission.
         *
         * https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input/checkbox#validation
         */
        this.required = false;
        /**
         * The value associated with this switch on form submission. `null` is
         * submitted when `selected` is `false`.
         */
        this.value = 'on';
        if (isServer) {
            return;
        }
        // This click listener does not currently need dispatch hooks since it does
        // not check `event.defaultPrevented`.
        this.addEventListener('click', (event) => {
            if (!isActivationClick(event) || !this.input) {
                return;
            }
            this.focus();
            dispatchActivationClick(this.input);
        });
        // Add the aria keyboard interaction pattern for switch and the Enter key.
        // See https://www.w3.org/WAI/ARIA/apg/patterns/switch/.
        setupDispatchHooks(this, 'keydown');
        this.addEventListener('keydown', (event) => {
            afterDispatch(event, () => {
                const ignoreEvent = event.defaultPrevented || event.key !== 'Enter';
                if (ignoreEvent || this.disabled || !this.input) {
                    return;
                }
                this.input.click();
            });
        });
    }
    render() {
        return html `
      <div class="switch ${classMap(this.getRenderClasses())}">
        <input
          id="switch"
          class="touch"
          type="checkbox"
          role="switch"
          aria-label=${this.ariaLabel || nothing}
          ?checked=${this.selected}
          ?disabled=${this.disabled}
          ?required=${this.required}
          @input=${this.handleInput}
          @change=${this.handleChange} />

        <md-focus-ring part="focus-ring" for="switch"></md-focus-ring>
        <span class="track"> ${this.renderHandle()} </span>
      </div>
    `;
    }
    getRenderClasses() {
        return {
            'selected': this.selected,
            'unselected': !this.selected,
            'disabled': this.disabled,
        };
    }
    renderHandle() {
        const classes = {
            'with-icon': this.showOnlySelectedIcon ? this.selected : this.icons,
        };
        return html `
      ${this.renderTouchTarget()}
      <span class="handle-container">
        <md-ripple for="switch" ?disabled="${this.disabled}"></md-ripple>
        <span class="handle ${classMap(classes)}">
          ${this.shouldShowIcons() ? this.renderIcons() : html ``}
        </span>
      </span>
    `;
    }
    renderIcons() {
        return html `
      <div class="icons">
        ${this.renderOnIcon()}
        ${this.showOnlySelectedIcon ? html `` : this.renderOffIcon()}
      </div>
    `;
    }
    /**
     * https://fonts.google.com/icons?selected=Material%20Symbols%20Outlined%3Acheck%3AFILL%400%3Bwght%40500%3BGRAD%400%3Bopsz%4024
     */
    renderOnIcon() {
        return html `
      <slot class="icon icon--on" name="on-icon">
        <svg viewBox="0 0 24 24">
          <path
            d="M9.55 18.2 3.65 12.3 5.275 10.675 9.55 14.95 18.725 5.775 20.35 7.4Z" />
        </svg>
      </slot>
    `;
    }
    /**
     * https://fonts.google.com/icons?selected=Material%20Symbols%20Outlined%3Aclose%3AFILL%400%3Bwght%40500%3BGRAD%400%3Bopsz%4024
     */
    renderOffIcon() {
        return html `
      <slot class="icon icon--off" name="off-icon">
        <svg viewBox="0 0 24 24">
          <path
            d="M6.4 19.2 4.8 17.6 10.4 12 4.8 6.4 6.4 4.8 12 10.4 17.6 4.8 19.2 6.4 13.6 12 19.2 17.6 17.6 19.2 12 13.6Z" />
        </svg>
      </slot>
    `;
    }
    renderTouchTarget() {
        return html `<span class="touch"></span>`;
    }
    shouldShowIcons() {
        return this.icons || this.showOnlySelectedIcon;
    }
    handleInput(event) {
        const target = event.target;
        this.selected = target.checked;
        // <input> 'input' event bubbles and is composed, don't re-dispatch it.
    }
    handleChange(event) {
        // <input> 'change' event is not composed, re-dispatch it.
        redispatchEvent(this, event);
    }
    [getFormValue]() {
        return this.selected ? this.value : null;
    }
    [getFormState]() {
        return String(this.selected);
    }
    formResetCallback() {
        // The selected property does not reflect, so the original attribute set by
        // the user is used to determine the default value.
        this.selected = this.hasAttribute('selected');
    }
    formStateRestoreCallback(state) {
        this.selected = state === 'true';
    }
    [createValidator]() {
        return new CheckboxValidator(() => ({
            checked: this.selected,
            required: this.required,
        }));
    }
    [getValidityAnchor]() {
        return this.input;
    }
};
/** @nocollapse */
Switch$1.shadowRootOptions = {
    mode: 'open',
    delegatesFocus: true,
};
__decorate$1([
    property({ type: Boolean })
], Switch$1.prototype, "selected", void 0);
__decorate$1([
    property({ type: Boolean })
], Switch$1.prototype, "icons", void 0);
__decorate$1([
    property({ type: Boolean, attribute: 'show-only-selected-icon' })
], Switch$1.prototype, "showOnlySelectedIcon", void 0);
__decorate$1([
    property({ type: Boolean })
], Switch$1.prototype, "required", void 0);
__decorate$1([
    property()
], Switch$1.prototype, "value", void 0);
__decorate$1([
    query('input')
], Switch$1.prototype, "input", void 0);

/**
 * @license
 * Copyright 2024 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
// Generated stylesheet for ./switch/internal/switch-styles.css.
const styles$5 = css `@layer styles, hcm;@layer styles{:host{display:inline-flex;outline:none;vertical-align:top;-webkit-tap-highlight-color:rgba(0,0,0,0);cursor:pointer}:host([disabled]){cursor:default}:host([touch-target=wrapper]){margin:max(0px,(48px - var(--md-switch-track-height, 32px))/2) 0px}md-focus-ring{--md-focus-ring-shape-start-start: var(--md-switch-track-shape-start-start, var(--md-switch-track-shape, var(--md-sys-shape-corner-full, 9999px)));--md-focus-ring-shape-start-end: var(--md-switch-track-shape-start-end, var(--md-switch-track-shape, var(--md-sys-shape-corner-full, 9999px)));--md-focus-ring-shape-end-end: var(--md-switch-track-shape-end-end, var(--md-switch-track-shape, var(--md-sys-shape-corner-full, 9999px)));--md-focus-ring-shape-end-start: var(--md-switch-track-shape-end-start, var(--md-switch-track-shape, var(--md-sys-shape-corner-full, 9999px)))}.switch{align-items:center;display:inline-flex;flex-shrink:0;position:relative;width:var(--md-switch-track-width, 52px);height:var(--md-switch-track-height, 32px);border-start-start-radius:var(--md-switch-track-shape-start-start, var(--md-switch-track-shape, var(--md-sys-shape-corner-full, 9999px)));border-start-end-radius:var(--md-switch-track-shape-start-end, var(--md-switch-track-shape, var(--md-sys-shape-corner-full, 9999px)));border-end-end-radius:var(--md-switch-track-shape-end-end, var(--md-switch-track-shape, var(--md-sys-shape-corner-full, 9999px)));border-end-start-radius:var(--md-switch-track-shape-end-start, var(--md-switch-track-shape, var(--md-sys-shape-corner-full, 9999px)))}input{appearance:none;height:max(100%,var(--md-switch-touch-target-size, 48px));outline:none;margin:0;position:absolute;width:max(100%,var(--md-switch-touch-target-size, 48px));z-index:1;cursor:inherit;top:50%;left:50%;transform:translate(-50%, -50%)}:host([touch-target=none]) input{display:none}}@layer styles{.track{position:absolute;width:100%;height:100%;box-sizing:border-box;border-radius:inherit;display:flex;justify-content:center;align-items:center}.track::before{content:"";display:flex;position:absolute;height:100%;width:100%;border-radius:inherit;box-sizing:border-box;transition-property:opacity,background-color;transition-timing-function:linear;transition-duration:67ms}.disabled .track{background-color:rgba(0,0,0,0);border-color:rgba(0,0,0,0)}.disabled .track::before,.disabled .track::after{transition:none;opacity:var(--md-switch-disabled-track-opacity, 0.12)}.disabled .track::before{background-clip:content-box}.selected .track::before{background-color:var(--md-switch-selected-track-color, var(--md-sys-color-primary, #6750a4))}.selected:hover .track::before{background-color:var(--md-switch-selected-hover-track-color, var(--md-sys-color-primary, #6750a4))}.selected:focus-within .track::before{background-color:var(--md-switch-selected-focus-track-color, var(--md-sys-color-primary, #6750a4))}.selected:active .track::before{background-color:var(--md-switch-selected-pressed-track-color, var(--md-sys-color-primary, #6750a4))}.selected.disabled .track{background-clip:border-box}.selected.disabled .track::before{background-color:var(--md-switch-disabled-selected-track-color, var(--md-sys-color-on-surface, #1d1b20))}.unselected .track::before{background-color:var(--md-switch-track-color, var(--md-sys-color-surface-container-highest, #e6e0e9));border-color:var(--md-switch-track-outline-color, var(--md-sys-color-outline, #79747e));border-style:solid;border-width:var(--md-switch-track-outline-width, 2px)}.unselected:hover .track::before{background-color:var(--md-switch-hover-track-color, var(--md-sys-color-surface-container-highest, #e6e0e9));border-color:var(--md-switch-hover-track-outline-color, var(--md-sys-color-outline, #79747e))}.unselected:focus-visible .track::before{background-color:var(--md-switch-focus-track-color, var(--md-sys-color-surface-container-highest, #e6e0e9));border-color:var(--md-switch-focus-track-outline-color, var(--md-sys-color-outline, #79747e))}.unselected:active .track::before{background-color:var(--md-switch-pressed-track-color, var(--md-sys-color-surface-container-highest, #e6e0e9));border-color:var(--md-switch-pressed-track-outline-color, var(--md-sys-color-outline, #79747e))}.unselected.disabled .track::before{background-color:var(--md-switch-disabled-track-color, var(--md-sys-color-surface-container-highest, #e6e0e9));border-color:var(--md-switch-disabled-track-outline-color, var(--md-sys-color-on-surface, #1d1b20))}}@layer hcm{@media(forced-colors: active){.selected .track::before{background:ButtonText;border-color:ButtonText}.disabled .track::before{border-color:GrayText;opacity:1}.disabled.selected .track::before{background:GrayText}}}@layer styles{.handle-container{display:flex;place-content:center;place-items:center;position:relative;transition:margin 300ms cubic-bezier(0.175, 0.885, 0.32, 1.275)}.selected .handle-container{margin-inline-start:calc(var(--md-switch-track-width, 52px) - var(--md-switch-track-height, 32px))}.unselected .handle-container{margin-inline-end:calc(var(--md-switch-track-width, 52px) - var(--md-switch-track-height, 32px))}.disabled .handle-container{transition:none}.handle{border-start-start-radius:var(--md-switch-handle-shape-start-start, var(--md-switch-handle-shape, var(--md-sys-shape-corner-full, 9999px)));border-start-end-radius:var(--md-switch-handle-shape-start-end, var(--md-switch-handle-shape, var(--md-sys-shape-corner-full, 9999px)));border-end-end-radius:var(--md-switch-handle-shape-end-end, var(--md-switch-handle-shape, var(--md-sys-shape-corner-full, 9999px)));border-end-start-radius:var(--md-switch-handle-shape-end-start, var(--md-switch-handle-shape, var(--md-sys-shape-corner-full, 9999px)));height:var(--md-switch-handle-height, 16px);width:var(--md-switch-handle-width, 16px);transform-origin:center;transition-property:height,width;transition-duration:250ms,250ms;transition-timing-function:cubic-bezier(0.2, 0, 0, 1),cubic-bezier(0.2, 0, 0, 1);z-index:0}.handle::before{content:"";display:flex;inset:0;position:absolute;border-radius:inherit;box-sizing:border-box;transition:background-color 67ms linear}.disabled .handle,.disabled .handle::before{transition:none}.selected .handle{height:var(--md-switch-selected-handle-height, 24px);width:var(--md-switch-selected-handle-width, 24px)}.handle.with-icon{height:var(--md-switch-with-icon-handle-height, 24px);width:var(--md-switch-with-icon-handle-width, 24px)}.selected:not(.disabled):active .handle,.unselected:not(.disabled):active .handle{height:var(--md-switch-pressed-handle-height, 28px);width:var(--md-switch-pressed-handle-width, 28px);transition-timing-function:linear;transition-duration:100ms}.selected .handle::before{background-color:var(--md-switch-selected-handle-color, var(--md-sys-color-on-primary, #fff))}.selected:hover .handle::before{background-color:var(--md-switch-selected-hover-handle-color, var(--md-sys-color-primary-container, #eaddff))}.selected:focus-within .handle::before{background-color:var(--md-switch-selected-focus-handle-color, var(--md-sys-color-primary-container, #eaddff))}.selected:active .handle::before{background-color:var(--md-switch-selected-pressed-handle-color, var(--md-sys-color-primary-container, #eaddff))}.selected.disabled .handle::before{background-color:var(--md-switch-disabled-selected-handle-color, var(--md-sys-color-surface, #fef7ff));opacity:var(--md-switch-disabled-selected-handle-opacity, 1)}.unselected .handle::before{background-color:var(--md-switch-handle-color, var(--md-sys-color-outline, #79747e))}.unselected:hover .handle::before{background-color:var(--md-switch-hover-handle-color, var(--md-sys-color-on-surface-variant, #49454f))}.unselected:focus-within .handle::before{background-color:var(--md-switch-focus-handle-color, var(--md-sys-color-on-surface-variant, #49454f))}.unselected:active .handle::before{background-color:var(--md-switch-pressed-handle-color, var(--md-sys-color-on-surface-variant, #49454f))}.unselected.disabled .handle::before{background-color:var(--md-switch-disabled-handle-color, var(--md-sys-color-on-surface, #1d1b20));opacity:var(--md-switch-disabled-handle-opacity, 0.38)}md-ripple{border-radius:var(--md-switch-state-layer-shape, var(--md-sys-shape-corner-full, 9999px));height:var(--md-switch-state-layer-size, 40px);inset:unset;width:var(--md-switch-state-layer-size, 40px)}.selected md-ripple{--md-ripple-hover-color: var(--md-switch-selected-hover-state-layer-color, var(--md-sys-color-primary, #6750a4));--md-ripple-pressed-color: var(--md-switch-selected-pressed-state-layer-color, var(--md-sys-color-primary, #6750a4));--md-ripple-hover-opacity: var(--md-switch-selected-hover-state-layer-opacity, 0.08);--md-ripple-pressed-opacity: var(--md-switch-selected-pressed-state-layer-opacity, 0.12)}.unselected md-ripple{--md-ripple-hover-color: var(--md-switch-hover-state-layer-color, var(--md-sys-color-on-surface, #1d1b20));--md-ripple-pressed-color: var(--md-switch-pressed-state-layer-color, var(--md-sys-color-on-surface, #1d1b20));--md-ripple-hover-opacity: var(--md-switch-hover-state-layer-opacity, 0.08);--md-ripple-pressed-opacity: var(--md-switch-pressed-state-layer-opacity, 0.12)}}@layer hcm{@media(forced-colors: active){.unselected .handle::before{background:ButtonText}.disabled .handle::before{opacity:1}.disabled.unselected .handle::before{background:GrayText}}}@layer styles{.icons{position:relative;height:100%;width:100%}.icon{position:absolute;inset:0;margin:auto;display:flex;align-items:center;justify-content:center;fill:currentColor;transition:fill 67ms linear,opacity 33ms linear,transform 167ms cubic-bezier(0.2, 0, 0, 1);opacity:0}.disabled .icon{transition:none}.selected .icon--on,.unselected .icon--off{opacity:1}.unselected .handle:not(.with-icon) .icon--on{transform:rotate(-45deg)}.icon--off{width:var(--md-switch-icon-size, 16px);height:var(--md-switch-icon-size, 16px);color:var(--md-switch-icon-color, var(--md-sys-color-surface-container-highest, #e6e0e9))}.unselected:hover .icon--off{color:var(--md-switch-hover-icon-color, var(--md-sys-color-surface-container-highest, #e6e0e9))}.unselected:focus-within .icon--off{color:var(--md-switch-focus-icon-color, var(--md-sys-color-surface-container-highest, #e6e0e9))}.unselected:active .icon--off{color:var(--md-switch-pressed-icon-color, var(--md-sys-color-surface-container-highest, #e6e0e9))}.unselected.disabled .icon--off{color:var(--md-switch-disabled-icon-color, var(--md-sys-color-surface-container-highest, #e6e0e9));opacity:var(--md-switch-disabled-icon-opacity, 0.38)}.icon--on{width:var(--md-switch-selected-icon-size, 16px);height:var(--md-switch-selected-icon-size, 16px);color:var(--md-switch-selected-icon-color, var(--md-sys-color-on-primary-container, #21005d))}.selected:hover .icon--on{color:var(--md-switch-selected-hover-icon-color, var(--md-sys-color-on-primary-container, #21005d))}.selected:focus-within .icon--on{color:var(--md-switch-selected-focus-icon-color, var(--md-sys-color-on-primary-container, #21005d))}.selected:active .icon--on{color:var(--md-switch-selected-pressed-icon-color, var(--md-sys-color-on-primary-container, #21005d))}.selected.disabled .icon--on{color:var(--md-switch-disabled-selected-icon-color, var(--md-sys-color-on-surface, #1d1b20));opacity:var(--md-switch-disabled-selected-icon-opacity, 0.38)}}@layer hcm{@media(forced-colors: active){.icon--off{fill:Canvas}.icon--on{fill:ButtonText}.disabled.unselected .icon--off,.disabled.selected .icon--on{opacity:1}.disabled .icon--on{fill:GrayText}}}
`;

/**
 * @license
 * Copyright 2021 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
/**
 * @summary Switches toggle the state of a single item on or off.
 *
 * @description
 * There's one type of switch in Material. Use this selection control when the
 * user needs to toggle a single item on or off.
 *
 * @final
 * @suppress {visibility}
 */
let MdSwitch = class MdSwitch extends Switch$1 {
};
MdSwitch.styles = [styles$5];
MdSwitch = __decorate$1([
    customElement('md-switch')
], MdSwitch);

/**
 * @license
 * Copyright 2023 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
/**
 * @fileoverview A set of chromium safe helper functions. Many of these exist
 * in google3 already but we reimplement so they can also be imported in
 * chromium.
 */
/**
 * Asserts that `arg` is not null or undefined and informs typescript of this so
 * that code that runs after this check will know `arg` is not null. If `arg` is
 * null, throws an error with `msg`.
 *
 * NOTE: unlike the internal counterpart this ALWAYS throws an error when given
 * null or undefined. This is not compiled out for prod.
 */
/**
 * Whether `event.target` should forward a click event to its children and local
 * state. False means a child should already be aware of the click.
 */
function shouldProcessClick(event) {
    // Event must start at the event target.
    if (event.currentTarget !== event.target) {
        return false;
    }
    // Event must not be retargeted from shadowRoot.
    if (event.composedPath()[0] !== event.target) {
        return false;
    }
    // Target must not be disabled; this should only occur for a synthetically
    // dispatched click.
    if (event.target.disabled) {
        return false;
    }
    return true;
}

/**
 * @license
 * Copyright 2023 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
/** A chromeOS switch component. */
class Switch extends LitElement {
    /** @nocollapse */
    static { this.styles = css `
    :host {
      display: inline-block;
    }
    md-switch {
      --md-focus-ring-duration: 0s;

      --md-switch-handle-height: 12px;
      --md-switch-handle-width: 12px;

      --md-switch-selected-handle-height: 12px;
      --md-switch-selected-handle-width: 12px;

      --md-switch-pressed-handle-height: 12px;
      --md-switch-pressed-handle-width: 12px;

      --md-switch-track-height: 16px;
      --md-switch-track-outline-width: 0;
      --md-switch-track-width: 32px;

      --md-switch-state-layer-size: 32px;

      /* selected */
      --md-switch-selected-track-color: var(--cros-sys-primary);
      --md-switch-selected-hover-track-color: var(--cros-sys-primary);
      --md-switch-selected-focus-track-color: var(--cros-sys-primary);
      --md-switch-selected-pressed-track-color: var(--cros-sys-primary);

      --md-switch-selected-handle-color: var(--cros-sys-on_primary);
      --md-switch-selected-hover-handle-color: var(--cros-sys-on_primary);
      --md-switch-selected-focus-handle-color: var(--cros-sys-on_primary);
      --md-switch-selected-pressed-handle-color: var(--cros-sys-on_primary);

      --md-switch-selected-hover-state-layer-color: var(--cros-sys-hover_on_subtle);
      --md-switch-selected-pressed-state-layer-color: var(--cros-sys-ripple_primary);
      --md-switch-selected-hover-state-layer-opacity: 1;
      --md-switch-selected-pressed-state-layer-opacity: 1;

      /* unselected */
      --md-switch-track-color: var(--cros-sys-secondary);
      --md-switch-hover-track-color: var(--cros-sys-secondary);
      --md-switch-focus-track-color: var(--cros-sys-secondary);
      --md-switch-pressed-track-color: var(--cros-sys-secondary);

      --md-switch-handle-color: var(--cros-sys-on_secondary);
      --md-switch-hover-handle-color: var(--cros-sys-on_secondary);
      --md-switch-focus-handle-color: var(--cros-sys-on_secondary);
      --md-switch-pressed-handle-color: var(--cros-sys-on_secondary);

      --md-switch-hover-state-layer-color: var(--cros-sys-hover_on_subtle);
      --md-switch-pressed-state-layer-color: var(--cros-sys-ripple_neutral_on_subtle);
      --md-switch-hover-state-layer-opacity: 1;
      --md-switch-pressed-state-layer-opacity: 1;
    }

    md-switch::part(focus-ring) {
      --md-focus-ring-width: 2px;
      --md-focus-ring-color: var(--cros-sys-primary);
    }

    /* disabled */
    md-switch[disabled] {
      opacity: 0.38;
      --md-switch-disabled-handle-color: var(--cros-sys-on_secondary);
      --md-switch-disabled-handle-opacity: 1;
      --md-switch-disabled-track-color: var(--cros-sys-secondary);
      --md-switch-disabled-track-opacity: 1;

      --md-switch-disabled-selected-handle-color: var(--cros-sys-on_primary);
      --md-switch-disabled-selected-handle-opacity: 1;
      --md-switch-disabled-selected-track-color: var(--cros-sys-primary);
    }
  `; }
    /** @nocollapse */
    static { this.shadowRootOptions = {
        ...LitElement.shadowRootOptions,
        delegatesFocus: true,
    }; }
    /** @nocollapse */
    static { this.properties = {
        selected: { type: Boolean, reflect: true },
        disabled: { type: Boolean, reflect: true },
        ariaLabel: { type: String, reflect: true, attribute: 'aria-label' },
    }; }
    /** @nocollapse */
    static { this.events = {
        /** The switch value changed via user input. */
        CHANGE: 'change',
    }; }
    get mdSwitch() {
        return this.shadowRoot.querySelector('md-switch');
    }
    constructor() {
        super();
        this.disabled = false;
        this.selected = false;
        this.addEventListener('click', (event) => {
            if (shouldProcessClick(event)) {
                this.click();
            }
        });
    }
    render() {
        return html `
      <md-switch
          ?disabled=${this.disabled}
          ?selected=${this.selected}
          @change=${this.onChange}
          aria-label=${this.ariaLabel ?? nothing}>
      </md-switch>
    `;
    }
    onChange() {
        this.selected = this.mdSwitch.selected;
        this.dispatchEvent(new Event('change', { bubbles: true }));
    }
    click() {
        this.mdSwitch?.click();
    }
    updated(changedProperties) {
        if (changedProperties.has('disabled')) {
            // Work around for b/315384008.
            this.renderRoot.querySelector('md-switch')?.requestUpdate();
        }
    }
}
customElements.define('cros-switch', Switch);

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

/**
 * @fileoverview Assertion support.
 */

/**
 * Note: This method is deprecated. Use the equvalent method in assert_ts.ts
 * instead.
 * Verify |condition| is truthy and return |condition| if so.
 * @template T
 * @param {T} condition A condition to check for truthiness.  Note that this
 *     may be used to test whether a value is defined or not, and we don't want
 *     to force a cast to Boolean.
 * @param {string=} opt_message A message to show on failure.
 * @return {T} A non-null |condition|.
 * @closurePrimitive {asserts.truthy}
 * @suppress {reportUnknownTypes} because T is not sufficiently constrained.
 */
function assert(condition, opt_message) {
  if (!condition) {
    let message = 'Assertion failed';
    if (opt_message) {
      message = message + ': ' + opt_message;
    }
    const error = new Error(message);
    const global = function() {
      const thisOrSelf = this || self;
      /** @type {boolean} */
      thisOrSelf.traceAssertionsForTesting;
      return thisOrSelf;
    }();
    if (global.traceAssertionsForTesting) {
      console.warn(error.stack);
    }
    throw error;
  }
  return condition;
}

/**
 * Note: This method is deprecated. Use the equvalent method in assert_ts.ts
 * instead.
 * Call this from places in the code that should never be reached.
 *
 * For example, handling all the values of enum with a switch() like this:
 *
 *   function getValueFromEnum(enum) {
 *     switch (enum) {
 *       case ENUM_FIRST_OF_TWO:
 *         return first
 *       case ENUM_LAST_OF_TWO:
 *         return last;
 *     }
 *     assertNotReached();
 *     return document;
 *   }
 *
 * This code should only be hit in the case of serious programmer error or
 * unexpected input.
 *
 * @param {string=} message A message to show when this is hit.
 * @closurePrimitive {asserts.fail}
 */
function assertNotReached(message) {
  assert(false, message || 'Unreachable code hit');
}

/**
 * @param {*} value The value to check.
 * @param {function(new: T, ...)} type A user-defined constructor.
 * @param {string=} message A message to show when this is hit.
 * @return {T}
 * @template T
 */
function assertInstanceof(value, type, message) {
  // We don't use assert immediately here so that we avoid constructing an error
  // message if we don't have to.
  if (!(value instanceof type)) {
    assertNotReached(
        'Value ' + value + ' is not a[n] ' + (type.name || typeof type));
  }
  return value;
}

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/** Coordinates the creation of new windows for Files app.  */
class AppWindowWrapper {
    constructor() {
        this.appState_ = null;
        this.openingOrOpened_ = false;
        this.queue_ = new AsyncQueue();
    }
    /**
     * Gets the launch lock, used to synchronize the asynchronous initialization
     * steps.
     */
    async getLaunchLock() {
        return this.queue_.lock();
    }
    /**
     * Opens the window.
     * @return Resolves when the window is launched.
     */
    async launch(appState) {
        // Check if the window is opened or not.
        if (this.openingOrOpened_) {
            console.warn('The window is already opened.');
            return Promise.resolve();
        }
        this.openingOrOpened_ = true;
        // Save application state.
        this.appState_ = appState;
        return this.launch_();
    }
    /**
     * Opens a new window for the SWA. Returns a Promise which resolves when the
     * window is launched.
     */
    async launch_() {
        const unlock = await this.getLaunchLock();
        try {
            await this.createWindow_();
        }
        catch (error) {
            console.error(error);
        }
        finally {
            unlock();
        }
    }
    /**
     * Return a Promise which resolves when the new window is opened.
     */
    async createWindow_() {
        const url = this.appState_.currentDirectoryURL?.toString() || '';
        const result = await openWindow({
            currentDirectoryURL: url,
            selectionURL: this.appState_.selectionURL,
        });
        if (!result) {
            throw new Error(`Failed to create window for ${url}`);
        }
    }
}

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview Handles shares for Crostini VMs.
 */
/**
 * Default Crostini VM is 'termina'.
 */
const DEFAULT_VM = 'termina';
/**
 * Plugin VM 'PvmDefault'.
 */
const PLUGIN_VM = 'PvmDefault';
/**
 * Valid root types to their share location.
 */
const VALID_ROOT_TYPES_FOR_SHARE = new Map([
    [RootType.DOWNLOADS, 'Downloads'],
    [RootType.REMOVABLE, 'Removable'],
    [RootType.ANDROID_FILES, 'AndroidFiles'],
    [RootType.COMPUTERS_GRAND_ROOT, 'DriveComputers'],
    [RootType.COMPUTER, 'DriveComputers'],
    [RootType.DRIVE, 'MyDrive'],
    [RootType.SHARED_DRIVES_GRAND_ROOT, 'TeamDrive'],
    [RootType.SHARED_DRIVE, 'TeamDrive'],
    [RootType.DRIVE_SHARED_WITH_ME, 'SharedWithMe'],
    [RootType.CROSTINI, 'Crostini'],
    [RootType.GUEST_OS, 'GuestOs'],
    [RootType.ARCHIVE, 'Archive'],
    [RootType.SMB, 'SMB'],
]);
/**
 * Implementation of Crostini shared path state handler.
 */
class Crostini {
    constructor() {
        /**
         * Keys maintaining enablement state for VMs that is keyed by vm then subkeyed
         * by the container name.
         */
        this.enabled_ = {};
        /**
         * A list of shared paths keyed by the VM name.
         */
        this.sharedPaths_ = {};
        /**
         * The volume manager instance.
         */
        this.volumeManager_ = null;
    }
    /**
     * Initialize enabled settings and register for any shared path changes.
     * Must be done after loadTimeData is available.
     */
    initEnabled() {
        const guests = loadTimeData.getValue('VMS_FOR_SHARING');
        for (const guest of guests) {
            this.setEnabled(guest.vmName, guest.containerName, true);
        }
        chrome.fileManagerPrivate.onCrostiniChanged.addListener(this.onCrostiniChanged_.bind(this));
    }
    /**
     * Initialize Volume Manager.
     */
    initVolumeManager(volumeManager) {
        this.volumeManager_ = volumeManager;
    }
    /**
     * Set whether the specified Guest is enabled.
     */
    setEnabled(vmName, containerName, enabled) {
        if (!this.enabled_[vmName]) {
            this.enabled_[vmName] = {};
        }
        this.enabled_[vmName][containerName] = enabled;
    }
    /**
     * Returns true if the specified VM is enabled.
     */
    isEnabled(vmName) {
        return (!!this.enabled_[vmName]) &&
            Object.values(this.enabled_[vmName]).includes(true);
    }
    /**
     * Get the root type for the supplied `entry`.
     */
    getRoot_(entry) {
        const info = this.volumeManager_ && this.volumeManager_.getLocationInfo(entry);
        return info && info.rootType;
    }
    /**
     * Registers an entry as a shared path for the specified VM.
     */
    registerSharedPath(vmName, entry) {
        const url = entry.toURL();
        // Remove any existing paths that are children of the new path.
        // These paths will still be shared as a result of a parent path being
        // shared, but if the parent is unshared in the future, these children
        // paths should not remain.
        for (const [path, _] of Object.entries(this.sharedPaths_)) {
            if (path.startsWith(url)) {
                this.unregisterSharedPath_(vmName, path);
            }
        }
        if (this.sharedPaths_[url]) {
            this.sharedPaths_[url].push(vmName);
        }
        else {
            this.sharedPaths_[url] = [vmName];
        }
    }
    /**
     * Unregisters path as a shared path from the specified VM.
     */
    unregisterSharedPath_(vmName, path) {
        const vms = this.sharedPaths_[path];
        if (vms) {
            const newVms = vms.filter(vm => vm !== vmName);
            if (newVms.length > 0) {
                this.sharedPaths_[path] = newVms;
            }
            else {
                delete this.sharedPaths_[path];
            }
        }
    }
    /**
     * Unregisters entry as a shared path from the specified VM.
     */
    unregisterSharedPath(vmName, entry) {
        this.unregisterSharedPath_(vmName, entry.toURL());
    }
    /**
     * Handles events for enable/disable, share/unshare.
     */
    onCrostiniChanged_(event) {
        const CrostiniEventType = chrome.fileManagerPrivate.CrostiniEventType;
        switch (event.eventType) {
            case CrostiniEventType.ENABLE:
                this.setEnabled(event.vmName, event.containerName, true);
                break;
            case CrostiniEventType.DISABLE:
                this.setEnabled(event.vmName, event.containerName, false);
                break;
            case CrostiniEventType.SHARE:
                for (const entry of event.entries) {
                    this.registerSharedPath(event.vmName, assert(entry));
                }
                break;
            case CrostiniEventType.UNSHARE:
                for (const entry of event.entries) {
                    this.unregisterSharedPath(event.vmName, assert(entry));
                }
                break;
        }
    }
    /**
     * Returns true if entry is shared with the specified VM. Returns true if path
     * is shared either by a direct share or from one of its ancestor directories.
     */
    isPathShared(vmName, entry) {
        // Check path and all ancestor directories.
        let path = entry.toURL();
        let root = path;
        if (entry && entry.filesystem && entry.filesystem.root) {
            root = entry.filesystem.root.toURL();
        }
        while (path.length > root.length) {
            const vms = this.sharedPaths_[path];
            if (vms && vms.includes(vmName)) {
                return true;
            }
            path = path.substring(0, path.lastIndexOf('/'));
        }
        const rootVms = this.sharedPaths_[root];
        return !!rootVms && rootVms.includes(vmName);
    }
    /**
     * Returns true if entry can be shared with the specified VM.
     */
    canSharePath(vmName, entry, persist) {
        if (!this.isEnabled(vmName)) {
            return false;
        }
        // Only directories for persistent shares.
        if (persist && !entry.isDirectory) {
            return false;
        }
        const root = this.getRoot_(entry);
        // TODO(crbug.com/40607763): Remove when DriveFS enforces allowed write paths.
        // Disallow Computers Grand Root, and Computer Root.
        if (root === RootType.COMPUTERS_GRAND_ROOT ||
            (root === RootType.COMPUTER && entry.fullPath.split('/').length <= 3)) {
            return false;
        }
        // TODO(crbug.com/41456343): Sharing Play files root is disallowed until
        // we can ensure it will not also share Downloads.
        if (root === RootType.ANDROID_FILES && entry.fullPath === '/') {
            return false;
        }
        // Special case to disallow PluginVm sharing on /MyFiles/PluginVm and
        // subfolders since it gets shared by default.
        if (vmName === PLUGIN_VM && root === RootType.DOWNLOADS &&
            entry.fullPath.split('/')[1] === PLUGIN_VM) {
            return false;
        }
        // Disallow sharing LinuxFiles with itself.
        if (vmName === DEFAULT_VM && root === RootType.CROSTINI) {
            return false;
        }
        // Cannot share root of Shared with me since it represents 2 dirs:
        // `.files-by-id` and `.shortcut-targets-by-id`.
        if (root === RootType.DRIVE_SHARED_WITH_ME && entry.fullPath === '/') {
            return false;
        }
        return !!root && VALID_ROOT_TYPES_FOR_SHARE.has(root);
    }
}

// Copyright 2010 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

/**
* @fileoverview Work-around for
* https://github.com/google/closure-compiler/issues/3143, such that WebUI code
* can use the native EventTarget class.
* TODO(dpapad): Remove this entire file if/when that issue is fixed.
*/

/**
 * @constructor
 * @implements {EventTarget}
 */
const NativeEventTarget = self['EventTarget'];

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/** State of progress items. */
var ProgressItemState;
(function (ProgressItemState) {
    ProgressItemState["SCANNING"] = "scanning";
    ProgressItemState["PROGRESSING"] = "progressing";
    ProgressItemState["COMPLETED"] = "completed";
    ProgressItemState["ERROR"] = "error";
    ProgressItemState["CANCELED"] = "canceled";
    ProgressItemState["PAUSED"] = "paused";
})(ProgressItemState || (ProgressItemState = {}));
/**
 * Policy error type. Only applicable if DLP or Enterprise Connectors policies
 * apply.
 */
var PolicyErrorType;
(function (PolicyErrorType) {
    PolicyErrorType["DLP"] = "dlp";
    PolicyErrorType["ENTERPRISE_CONNECTORS"] = "enterprise_connectors";
    PolicyErrorType["DLP_WARNING_TIMEOUT"] = "dlp_warning_timeout";
})(PolicyErrorType || (PolicyErrorType = {}));
/** Type of progress items. */
var ProgressItemType;
(function (ProgressItemType) {
    // The item is file copy operation.
    ProgressItemType["COPY"] = "copy";
    // The item is file delete operation.
    ProgressItemType["DELETE"] = "delete";
    // The item is emptying the trash operation.
    ProgressItemType["EMPTY_TRASH"] = "empty-trash";
    // The item is file extract operation.
    ProgressItemType["EXTRACT"] = "extract";
    // The item is file move operation.
    ProgressItemType["MOVE"] = "move";
    // The item is file zip operation.
    ProgressItemType["ZIP"] = "zip";
    // The item is drive sync operation.
    ProgressItemType["SYNC"] = "sync";
    // The item is restoring the trash.
    ProgressItemType["RESTORE"] = "restore";
    ProgressItemType["RESTORE_TO_DESTINATION"] = "restore_to_destination";
    // The item is general file transfer operation.
    // This is used for the mixed operation of summarized item.
    ProgressItemType["TRANSFER"] = "transfer";
    // The item is being trashed.
    ProgressItemType["TRASH"] = "trash";
    // The item is external drive format operation.
    ProgressItemType["FORMAT"] = "format";
    // The item is archive operation.
    ProgressItemType["MOUNT_ARCHIVE"] = "mount_archive";
    // The item is external drive partitioning operation.
    ProgressItemType["PARTITION"] = "partition";
})(ProgressItemType || (ProgressItemType = {}));
/** Item of the progress center. */
class ProgressCenterItem {
    constructor() {
        /** Item ID. */
        this.id_ = '';
        /** State of the progress item. */
        this.state = ProgressItemState.PROGRESSING;
        /** Message of the progress item. */
        this.message = '';
        /** Source message for the progress item. */
        this.sourceMessage = '';
        /** Destination message for the progress item. */
        this.destinationMessage = '';
        /** Number of items being processed. */
        this.itemCount = 0;
        /** Max value of the progress. */
        this.progressMax = 0;
        /** Current value of the progress. */
        this.progressValue = 0;
        /*** Type of progress item. */
        this.type = null;
        /** Whether the item represents a single item or not. */
        this.single = true;
        /**
         * If the property is true, only the message of item shown in the progress
         * center and the notification of the item is created as priority = -1.
         */
        this.quiet = false;
        /** Callback function to cancel the item. */
        this.cancelCallback = null;
        /** Optional callback to be invoked after dismissing the item. */
        this.dismissCallback = null;
        /** The predicted remaining time to complete the progress item in seconds. */
        this.remainingTime = 0;
        /**
         * Contains the text and callback on an extra button when the progress
         * center item is either in COMPLETED, ERROR, or PAUSED state.
         */
        this.extraButton = new Map();
        /**
         * In the case of a copy/move operation, whether the destination folder is
         * a child of My Drive.
         */
        this.isDestinationDrive = false;
        /** The type of policy error that occurred, if any. */
        this.policyError = null;
        /** The number of files with a policy restriction, if any. */
        this.policyFileCount = null;
        /** The name of the first file with a policy restriction, if any. */
        this.policyFileName = null;
        /**
         * List of files skipped during the operation because we couldn't decrypt
         * them.
         */
        this.skippedEncryptedFiles = [];
    }
    /**
     * Sets the extra button text and callback. Use this to add an additional
     * button with configurable functionality.
     * @param text Text to use for the button.
     * @param state Which state to show the button for. Currently only
     *     `ProgressItemState.COMPLETED`, `ProgressItemState.ERROR`, and
     *     `ProgressItemState.PAUSED` are supported.
     * @param callback The callback to invoke when the button is pressed.
     */
    setExtraButton(state, text, callback) {
        if (!text || !callback) {
            console.warn('Text and callback must be supplied');
            return;
        }
        if (this.extraButton.has(state)) {
            console.warn('Extra button already defined for state:', state);
            return;
        }
        const extraButton = { text, callback };
        this.extraButton.set(state, extraButton);
    }
    /** Sets the Item ID. */
    set id(value) {
        if (!this.id_) {
            this.id_ = value;
        }
        else {
            console.error('The ID is already set. (current ID: ' + this.id_ + ')');
        }
    }
    /** Gets the Item ID. */
    get id() {
        return this.id_;
    }
    /**
     * Gets progress rate in percent.
     *
     * If the current state is canceled or completed, it always returns 0 or 100
     * respectively.
     */
    get progressRateInPercent() {
        switch (this.state) {
            case ProgressItemState.CANCELED:
                return 0;
            case ProgressItemState.COMPLETED:
                return 100;
            default:
                return ~~(100 * this.progressValue / this.progressMax);
        }
    }
    /** Whether the item can be canceled or not. */
    get cancelable() {
        return !!(this.state === ProgressItemState.PROGRESSING &&
            this.cancelCallback && this.single) ||
            !!(this.state === ProgressItemState.PAUSED && this.cancelCallback);
    }
    /** Clones the item. */
    clone() {
        const clonedItem = Object.assign(new ProgressCenterItem(), this);
        return clonedItem;
    }
}

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview Handles notifications supplied by drivefs.
 */
/**
 * Shorthand for metadata keys.
 */
const SYNC_STATUS = 'syncStatus';
const PROGRESS = 'progress';
const SYNC_COMPLETED_TIME = 'syncCompletedTime';
const AVAILABLE_OFFLINE = 'availableOffline';
const PINNED = 'pinned';
const CAN_PIN = 'canPin';
/**
 * Shorthand for sync statuses.
 */
const { COMPLETED } = chrome.fileManagerPrivate.SyncStatus;
/**
 * Prefix for Out of Quota sync messages to ensure they reuse existing
 * notification messages instead of starting new ones.
 */
var DriveErrorId;
(function (DriveErrorId) {
    DriveErrorId[DriveErrorId["OUT_OF_QUOTA"] = 1] = "OUT_OF_QUOTA";
    DriveErrorId[DriveErrorId["SHARED_DRIVE_NO_STORAGE"] = 2] = "SHARED_DRIVE_NO_STORAGE";
    DriveErrorId[DriveErrorId["MAX_VALUE"] = 2] = "MAX_VALUE";
})(DriveErrorId || (DriveErrorId = {}));
/**
 * The completed event name.
 */
const DRIVE_SYNC_COMPLETED_EVENT = 'completed';
/**
 * A list of prefixes used to disambiguate errors that come from the same source
 * to ensure separate notifications are generated.
 */
var ErrorPrefix;
(function (ErrorPrefix) {
    ErrorPrefix["NORMAL"] = "drive-sync-error-";
    ErrorPrefix["ORGANIZATION"] = "drive-sync-error-organization";
})(ErrorPrefix || (ErrorPrefix = {}));
class DriveSyncHandlerImpl extends NativeEventTarget {
    constructor(progressCenter_) {
        super();
        this.progressCenter_ = progressCenter_;
        this.errorIdCounter_ = DriveErrorId.MAX_VALUE + 1;
        /**
         * Recently completed URLs whose metadata should be updated after 300ms.
         */
        this.completedUrls_ = [];
        /**
         * With a rate limit of 200ms, update entries that have completed 300ms ago or
         * longer.
         */
        this.updateCompletedRateLimiter_ = new RateLimiter(async () => {
            if (this.completedUrls_.length === 0) {
                return;
            }
            const entriesToUpdate = [];
            this.completedUrls_ = this.completedUrls_.filter(url => {
                const [entry, syncCompletedTime] = this.getEntryAndSyncCompletedTimeForUrl_(url);
                // Stop tracking URLs that are no longer in the store.
                if (!entry) {
                    return false;
                }
                // Update URLs that have completed over 300ms and stop tracking them.
                if (Date.now() - syncCompletedTime > 300) {
                    entriesToUpdate.push(entry);
                    return false;
                }
                // Keep tracking URLs that are in the store and have completed <300ms ago.
                return true;
            });
            if (entriesToUpdate.length) {
                this.metadataModel_?.notifyEntriesChanged(entriesToUpdate);
                // TODO(austinct): Check if we can remove the `as MetadataKey[]` assertion
                // once we only have typescript bindings for fileManagerPrivate.
                this.metadataModel_?.get(entriesToUpdate, [
                    SYNC_STATUS,
                    PROGRESS,
                    AVAILABLE_OFFLINE,
                    PINNED,
                    CAN_PIN,
                ]);
            }
            this.updateCompletedRateLimiter_.run();
        }, 200);
        // Register events.
        chrome.fileManagerPrivate.onIndividualFileTransfersUpdated.addListener(this.updateSyncStateMetadata_.bind(this));
        chrome.fileManagerPrivate.onDriveSyncError.addListener(this.onDriveSyncError_.bind(this));
        chrome.fileManagerPrivate.onDriveConnectionStatusChanged.addListener(this.onDriveConnectionStatusChanged_.bind(this));
    }
    /**
     * Sets the MetadataModel on the DriveSyncHandler.
     */
    set metadataModel(model) {
        this.metadataModel_ = model;
    }
    /**
     * Returns the completed event name.
     */
    getCompletedEventName() {
        return DRIVE_SYNC_COMPLETED_EVENT;
    }
    getEntryAndSyncCompletedTimeForUrl_(url) {
        const entry = getStore().getState().allEntries[url]?.entry;
        if (!entry) {
            return [null, 0];
        }
        // TODO(austinct): Check if we can remove the `as MetadataKey` assertion
        // once we only have typescript bindings for fileManagerPrivate.
        const metadata = this.metadataModel_?.getCache([entry], [SYNC_COMPLETED_TIME])[0];
        return [
            unwrapEntry(entry),
            metadata?.syncCompletedTime || 0,
        ];
    }
    /**
     * Handles file transfer status updates for individual files, updating their
     * sync status metadata.
     */
    async updateSyncStateMetadata_(syncStates) {
        const urlsToUpdate = [];
        const valuesToUpdate = [];
        for (const { fileUrl, syncStatus, progress } of syncStates) {
            if (syncStatus !== COMPLETED) {
                urlsToUpdate.push(fileUrl);
                valuesToUpdate.push([syncStatus, progress, 0]);
                continue;
            }
            // Only update status to completed if the previous status was different.
            // Note: syncCompletedTime is 0 if the last event wasn't completed.
            if (!this.getEntryAndSyncCompletedTimeForUrl_(fileUrl)[1]) {
                urlsToUpdate.push(fileUrl);
                valuesToUpdate.push([syncStatus, progress, Date.now()]);
                this.completedUrls_.push(fileUrl);
            }
        }
        this.metadataModel_?.update(urlsToUpdate, [SYNC_STATUS, PROGRESS, SYNC_COMPLETED_TIME], valuesToUpdate);
        this.updateCompletedRateLimiter_.run();
    }
    /**
     * Attempts to infer of the given event is processable by the drive sync
     * handler. It uses fileUrl to make a decision. It
     * errs on the side of 'yes', when passing the judgement.
     */
    isProcessableEvent(event) {
        const fileUrl = event.fileUrl;
        if (fileUrl) {
            return fileUrl.startsWith(`filesystem:${toFilesAppURL()}`);
        }
        return true;
    }
    /**
     * Handles drive's sync errors.
     */
    async onDriveSyncError_(event) {
        if (!this.isProcessableEvent(event)) {
            return;
        }
        const postError = (name) => {
            const item = new ProgressCenterItem();
            item.type = ProgressItemType.SYNC;
            item.quiet = true;
            item.state = ProgressItemState.ERROR;
            switch (event.type) {
                case 'delete_without_permission':
                    item.message = strf('SYNC_DELETE_WITHOUT_PERMISSION_ERROR', name);
                    break;
                case 'service_unavailable':
                    item.message = str('SYNC_SERVICE_UNAVAILABLE_ERROR');
                    break;
                case 'no_server_space':
                    item.message = str('SYNC_NO_SERVER_SPACE');
                    item.setExtraButton(ProgressItemState.ERROR, str('LEARN_MORE_LABEL'), () => visitURL(str('GOOGLE_DRIVE_MANAGE_STORAGE_URL')));
                    // This error will reappear every time sync is retried, so we use
                    // a fixed ID to avoid spamming the user.
                    item.id = ErrorPrefix.NORMAL + DriveErrorId.OUT_OF_QUOTA;
                    break;
                case 'no_server_space_organization':
                    item.message = str('SYNC_NO_SERVER_SPACE_ORGANIZATION');
                    item.setExtraButton(ProgressItemState.ERROR, str('LEARN_MORE_LABEL'), () => visitURL(str('GOOGLE_DRIVE_MANAGE_STORAGE_URL')));
                    // This error will reappear every time sync is retried, so we use
                    // a fixed ID to avoid spamming the user.
                    item.id = ErrorPrefix.ORGANIZATION + DriveErrorId.OUT_OF_QUOTA;
                    break;
                case 'no_local_space':
                    item.message = strf('DRIVE_OUT_OF_SPACE_HEADER', name);
                    break;
                case 'no_shared_drive_space':
                    item.message =
                        strf('SYNC_ERROR_SHARED_DRIVE_OUT_OF_SPACE', event.sharedDrive);
                    item.setExtraButton(ProgressItemState.ERROR, str('LEARN_MORE_LABEL'), () => visitURL(str('GOOGLE_DRIVE_ENTERPRISE_MANAGE_STORAGE_URL')));
                    // Shared drives will keep trying to sync the file until it is either
                    // removed or available storage is increased. This ensures each
                    // subsequent error message only ever shows once for each individual
                    // shared drive.
                    item.id = `${ErrorPrefix.NORMAL}${DriveErrorId.SHARED_DRIVE_NO_STORAGE}${event.sharedDrive}`;
                    break;
                case 'misc':
                    item.message = strf('SYNC_MISC_ERROR', name);
                    break;
            }
            if (!item.id) {
                item.id = ErrorPrefix.NORMAL + (this.errorIdCounter_++);
            }
            this.progressCenter_.updateItem(item);
        };
        if (!event.fileUrl) {
            postError('');
            return;
        }
        try {
            this.updateSyncStateMetadata_([
                {
                    fileUrl: event.fileUrl,
                    syncStatus: chrome.fileManagerPrivate.SyncStatus.QUEUED,
                    progress: 0,
                },
            ]);
            const entry = await urlToEntry(event.fileUrl);
            postError(entry.name);
        }
        catch (error) {
            postError('');
        }
    }
    /**
     * Handles connection state change.
     */
    onDriveConnectionStatusChanged_() {
        chrome.fileManagerPrivate.getDriveConnectionState((state) => {
            // If offline, hide any sync progress notifications. When online again,
            // the Drive sync client may retry syncing and trigger
            // onFileTransfersUpdated events, causing it to be shown again.
            if (state.type ===
                chrome.fileManagerPrivate.DriveConnectionStateType.OFFLINE &&
                state.reason ===
                    chrome.fileManagerPrivate.DriveOfflineReason.NO_NETWORK) {
                this.dispatchEvent(new Event(this.getCompletedEventName()));
            }
        });
    }
}

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * An event handler of the background page for file operations.
 */
class FileOperationHandler {
    constructor(progressCenter_) {
        this.progressCenter_ = progressCenter_;
        chrome.fileManagerPrivate.onIOTaskProgressStatus.addListener(this.onIoTaskProgressStatus_.bind(this));
    }
    /**
     * Process the IO Task ProgressStatus events.
     */
    onIoTaskProgressStatus_(event) {
        const taskId = String(event.taskId);
        let newItem = false;
        let item = this.progressCenter_.getItemById(taskId);
        if (!item) {
            item = new ProgressCenterItem();
            newItem = true;
            item.id = taskId;
            item.type = getTypeFromIoTaskType(event.type);
            item.itemCount = event.itemCount;
            const state = getStore().getState();
            const volume = state.volumes[event.destinationVolumeId];
            item.isDestinationDrive = volume?.volumeType === VolumeType.DRIVE;
            item.cancelCallback = () => {
                chrome.fileManagerPrivate.cancelIOTask(event.taskId);
            };
        }
        item.message = getMessageFromProgressEvent(event);
        item.sourceMessage = event.sourceName;
        item.destinationMessage = event.destinationName;
        switch (event.state) {
            case chrome.fileManagerPrivate.IoTaskState.QUEUED:
                item.progressMax = event.totalBytes;
                item.progressValue = event.bytesTransferred;
                item.remainingTime = event.remainingSeconds;
                break;
            case chrome.fileManagerPrivate.IoTaskState.SCANNING:
                item.sourceMessage = event.sourceName;
                item.destinationMessage = event.destinationName;
                item.state = ProgressItemState.SCANNING;
                // For scanning, the progress is the percentage of scanned items out of
                // the total count.
                item.progressMax = event.itemCount;
                item.progressValue = event.sourcesScanned;
                item.remainingTime = event.remainingSeconds;
                break;
            case chrome.fileManagerPrivate.IoTaskState.PAUSED:
                // Check if the task is paused because of warning level restrictions.
                if (event.pauseParams && event.pauseParams.policyParams) {
                    item.state = ProgressItemState.PAUSED;
                    item.policyFileCount = event.pauseParams.policyParams.policyFileCount;
                    item.policyFileName = event.pauseParams.policyParams.fileName;
                    const extraButtonText = getPolicyExtraButtonText(event);
                    if (event.pauseParams.policyParams.policyFileCount === 1 &&
                        !event.pauseParams.policyParams.alwaysShowReview) {
                        item.setExtraButton(ProgressItemState.PAUSED, extraButtonText, () => {
                            // Proceed/cancel the action directly from the notification.
                            chrome.fileManagerPrivate.resumeIOTask(event.taskId, {
                                policyParams: { type: event.pauseParams.policyParams.type },
                                conflictParams: undefined,
                            });
                        });
                    }
                    else {
                        item.setExtraButton(ProgressItemState.PAUSED, extraButtonText, () => {
                            // Show the dialog to proceed/cancel.
                            chrome.fileManagerPrivate.showPolicyDialog(event.taskId, chrome.fileManagerPrivate.PolicyDialogType.WARNING, checkAPIError);
                        });
                    }
                    break;
                }
            // Otherwise same is in-progress - fall through
            case chrome.fileManagerPrivate.IoTaskState.IN_PROGRESS:
                item.progressMax = event.totalBytes;
                item.progressValue = event.bytesTransferred;
                item.remainingTime = event.remainingSeconds;
                item.state = ProgressItemState.PROGRESSING;
                break;
            case chrome.fileManagerPrivate.IoTaskState.SUCCESS:
            case chrome.fileManagerPrivate.IoTaskState.CANCELLED:
            case chrome.fileManagerPrivate.IoTaskState.ERROR:
                if (newItem) {
                    // ERROR events can be dispatched before BEGIN events.
                    item.progressMax = 1;
                }
                if (event.state === chrome.fileManagerPrivate.IoTaskState.SUCCESS) {
                    item.state = ProgressItemState.COMPLETED;
                    item.progressValue = item.progressMax;
                    item.remainingTime = event.remainingSeconds;
                    if (item.type === ProgressItemType.TRASH) {
                        const infoEntries = (event.outputs ||
                            []).filter((o) => o.name.endsWith('.trashinfo'));
                        item.setExtraButton(ProgressItemState.COMPLETED, str('UNDO_DELETE_ACTION_LABEL'), () => {
                            startIOTask(chrome.fileManagerPrivate.IoTaskType.RESTORE, infoEntries, 
                            /*params=*/ {});
                        });
                    }
                }
                else if (event.state === chrome.fileManagerPrivate.IoTaskState.CANCELLED) {
                    item.state = ProgressItemState.CANCELED;
                }
                else { // ERROR
                    item.state = ProgressItemState.ERROR;
                    item.skippedEncryptedFiles = event.skippedEncryptedFiles;
                    // Check if there was a policy error.
                    if (event.policyError) {
                        item.policyError =
                            getPolicyErrorFromIOTaskPolicyError(event.policyError.type);
                        item.policyFileCount = event.policyError.policyFileCount;
                        item.policyFileName = event.policyError.fileName;
                        item.dismissCallback = () => {
                            // For policy errors, we keep track of the task's info since it
                            // might be required to review the details. Notify when dismissed
                            // that this can be cleared.
                            chrome.fileManagerPrivate.dismissIOTask(event.taskId, checkAPIError);
                        };
                        const extraButtonText = getPolicyExtraButtonText(event);
                        if (event.policyError.type !==
                            PolicyErrorType.DLP_WARNING_TIMEOUT &&
                            (event.policyError.policyFileCount > 1 ||
                                event.policyError.alwaysShowReview)) {
                            item.setExtraButton(ProgressItemState.ERROR, extraButtonText, () => {
                                chrome.fileManagerPrivate.showPolicyDialog(event.taskId, chrome.fileManagerPrivate.PolicyDialogType.ERROR, checkAPIError);
                            });
                        }
                        else if (event.policyError.type !==
                            PolicyErrorType.ENTERPRISE_CONNECTORS) {
                            // There is not a default learn more URL for EC, and when a custom
                            // one is set we show the review button defined above instead.
                            item.setExtraButton(ProgressItemState.ERROR, extraButtonText, () => {
                                visitURL(str('DLP_HELP_URL'));
                            });
                        }
                    }
                }
                break;
            case chrome.fileManagerPrivate.IoTaskState.NEED_PASSWORD:
                // Set state to canceled so notification doesn't display.
                item.state = ProgressItemState.CANCELED;
                break;
            default:
                console.error(`Invalid IoTaskState: ${event.state}`);
        }
        if (!event.showNotification) {
            // Set state to canceled so notification doesn't display.
            item.state = ProgressItemState.CANCELED;
        }
        this.progressCenter_.updateItem(item);
    }
}
/**
 * Obtains ProgressItemType from OperationType of ProgressStatus.type.
 */
function getTypeFromIoTaskType(type) {
    switch (type) {
        case chrome.fileManagerPrivate.IoTaskType.COPY:
            return ProgressItemType.COPY;
        case chrome.fileManagerPrivate.IoTaskType.DELETE:
            return ProgressItemType.DELETE;
        case chrome.fileManagerPrivate.IoTaskType.EMPTY_TRASH:
            return ProgressItemType.EMPTY_TRASH;
        case chrome.fileManagerPrivate.IoTaskType.EXTRACT:
            return ProgressItemType.EXTRACT;
        case chrome.fileManagerPrivate.IoTaskType.MOVE:
            return ProgressItemType.MOVE;
        case chrome.fileManagerPrivate.IoTaskType.RESTORE:
            return ProgressItemType.RESTORE;
        case chrome.fileManagerPrivate.IoTaskType.RESTORE_TO_DESTINATION:
            return ProgressItemType.RESTORE_TO_DESTINATION;
        case chrome.fileManagerPrivate.IoTaskType.TRASH:
            return ProgressItemType.TRASH;
        case chrome.fileManagerPrivate.IoTaskType.ZIP:
            return ProgressItemType.ZIP;
        default:
            console.error('Unknown operation type: ' + type);
            return ProgressItemType.TRANSFER;
    }
}
/**
 * Generate a progress message from the event.
 */
function getMessageFromProgressEvent(event) {
    // The non-error states text is managed directly in the
    // ProgressCenterPanel.
    if (event.state !== chrome.fileManagerPrivate.IoTaskState.ERROR) {
        return '';
    }
    // TODO(b/295438773): Remove this special case for the "in use" error once
    // the files app error strings are made consistent and an "in use" string is
    // properly added.
    if (event.errorName === 'InUseError' && event.itemCount === 1) {
        switch (event.type) {
            case chrome.fileManagerPrivate.IoTaskType.MOVE:
                return str('MOVE_IN_USE_ERROR');
            case chrome.fileManagerPrivate.IoTaskType.DELETE:
                return str('DELETE_IN_USE_ERROR');
        }
    }
    const detail = getFileErrorString(event.errorName);
    switch (event.type) {
        case chrome.fileManagerPrivate.IoTaskType.COPY:
            return strf('COPY_FILESYSTEM_ERROR', detail);
        case chrome.fileManagerPrivate.IoTaskType.EMPTY_TRASH:
            return str('EMPTY_TRASH_UNEXPECTED_ERROR');
        case chrome.fileManagerPrivate.IoTaskType.EXTRACT:
            return strf('EXTRACT_FILESYSTEM_ERROR', detail);
        case chrome.fileManagerPrivate.IoTaskType.MOVE:
            return strf('MOVE_FILESYSTEM_ERROR', detail);
        case chrome.fileManagerPrivate.IoTaskType.ZIP:
            return strf('ZIP_FILESYSTEM_ERROR', detail);
        case chrome.fileManagerPrivate.IoTaskType.DELETE:
            return str('DELETE_ERROR');
        case chrome.fileManagerPrivate.IoTaskType.RESTORE:
        case chrome.fileManagerPrivate.IoTaskType.RESTORE_TO_DESTINATION:
            return str('RESTORE_FROM_TRASH_ERROR');
        case chrome.fileManagerPrivate.IoTaskType.TRASH:
            return str('TRASH_UNEXPECTED_ERROR');
        default:
            console.warn(`Unexpected operation type: ${event.type}`);
            return str('FILE_ERROR_GENERIC');
    }
}
/**
 * Converts fileManagerPrivate.PolicyErrorType to
 * ProgressCenterItem.PolicyErrorType.
 */
function getPolicyErrorFromIOTaskPolicyError(error) {
    if (!error) {
        return null;
    }
    switch (error) {
        case chrome.fileManagerPrivate.PolicyErrorType.DLP:
            return PolicyErrorType.DLP;
        case chrome.fileManagerPrivate.PolicyErrorType.ENTERPRISE_CONNECTORS:
            return PolicyErrorType.ENTERPRISE_CONNECTORS;
        case chrome.fileManagerPrivate.PolicyErrorType.DLP_WARNING_TIMEOUT:
            return PolicyErrorType.DLP_WARNING_TIMEOUT;
        default:
            console.warn(`Unexpected policy error type: ${error}`);
            return null;
    }
}
/**
 * Returns the extra button text for policy panel items. Currently only
 * supported for PAUSED and ERROR states due to policy, and for COPY or MOVE
 * operation types.
 */
function getPolicyExtraButtonText(event) {
    if (event.state === chrome.fileManagerPrivate.IoTaskState.PAUSED &&
        event.pauseParams && event.pauseParams.policyParams) {
        if (event.pauseParams.policyParams.policyFileCount > 1 ||
            event.pauseParams.policyParams.alwaysShowReview) {
            return str('DLP_FILES_REVIEW_BUTTON');
        }
        // Single item:
        switch (event.type) {
            case chrome.fileManagerPrivate.IoTaskType.COPY:
                return str('DLP_FILES_COPY_WARN_CONTINUE_BUTTON');
            case chrome.fileManagerPrivate.IoTaskType.MOVE:
            case chrome.fileManagerPrivate.IoTaskType.RESTORE_TO_DESTINATION:
                return str('DLP_FILES_MOVE_WARN_CONTINUE_BUTTON');
            default:
                console.error('Unexpected operation type: ' + event.type);
                return '';
        }
    }
    if (event.state === chrome.fileManagerPrivate.IoTaskState.ERROR &&
        event.policyError) {
        if (event.policyError.type !== PolicyErrorType.DLP_WARNING_TIMEOUT &&
            (event.policyError.policyFileCount > 1 ||
                event.policyError.alwaysShowReview)) {
            return str('DLP_FILES_REVIEW_BUTTON');
        }
        else {
            return str('LEARN_MORE_LABEL');
        }
    }
    return '';
}

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * Implementation of ProgressCenter at the background page.
 */
class ProgressCenter {
    constructor() {
        /**
         * Current items managed by the progress center.
         */
        this.items_ = [];
        /**
         * List of panel UI managed by the progress center.
         */
        this.panels_ = [];
        /**
         * Inhibit end of operation updates for testing.
         */
        this.neverNotifyCompleted_ = false;
    }
    /**
     * Turns off sending updates when a file operation reaches 'completed' state.
     * Used for testing UI that can be ephemeral otherwise.
     */
    neverNotifyCompleted() {
        if (window.IN_TEST) {
            this.neverNotifyCompleted_ = true;
        }
    }
    /**
     * Updates the item in the progress center.
     * If the item has a new ID, the item is added to the item list.
     */
    updateItem(item) {
        // Update item.
        const index = this.getItemIndex_(item.id);
        if (item.state === ProgressItemState.PROGRESSING ||
            item.state === ProgressItemState.SCANNING) {
            if (index === -1) {
                this.items_.push(item);
            }
            else {
                this.items_[index] = item;
            }
        }
        else {
            // Error item is not removed until user explicitly dismiss it.
            if (item.state !== ProgressItemState.ERROR && index !== -1) {
                if (this.neverNotifyCompleted_) {
                    item.state = ProgressItemState.PROGRESSING;
                    return;
                }
                this.items_.splice(index, 1);
            }
        }
        // Update panels.
        for (const panelItem of this.panels_) {
            panelItem.updateItem(item);
        }
    }
    /**
     * Requests to cancel the progress item.
     * @param id Progress ID to be requested to cancel.
     */
    requestCancel(id) {
        const item = this.getItemById(id);
        if (item && item.cancelCallback) {
            item.cancelCallback();
        }
    }
    /**
     * Adds a panel UI to the notification center.
     * @param panel Panel UI.
     */
    addPanel(panel) {
        if (this.panels_.indexOf(panel) !== -1) {
            return;
        }
        // Update the panel list.
        this.panels_.push(panel);
        // Set the current items.
        for (const item of this.items_) {
            panel.updateItem(item);
        }
        // Register the cancel callback.
        panel.cancelCallback = this.requestCancel.bind(this);
        // Register the dismiss error item callback.
        panel.dismissErrorItemCallback = this.dismissErrorItem_.bind(this);
    }
    /**
     * Removes a panel UI from the notification center.
     * @param panel Panel UI.
     */
    removePanel(panel) {
        const index = this.panels_.indexOf(panel);
        if (index === -1) {
            return;
        }
        this.panels_.splice(index, 1);
        panel.cancelCallback = null;
    }
    /**
     * Obtains item by ID.
     * @param id ID of progress item.
     * @return Progress center item having the
     *     specified ID. Null if the item is not found.
     */
    getItemById(id) {
        return this.items_[this.getItemIndex_(id)];
    }
    /**
     * Obtains item index that have the specifying ID.
     * @param id Item ID.
     * @return Item index. Returns -1 If the item is not found.
     */
    getItemIndex_(id) {
        for (const [i, item] of this.items_.entries()) {
            if (item.id === id) {
                return i;
            }
        }
        return -1;
    }
    /**
     * Requests all panels to dismiss an error item.
     * @param id Item ID.
     */
    dismissErrorItem_(id) {
        const index = this.getItemIndex_(id);
        if (index > -1) {
            this.items_.splice(index, 1);
        }
        for (const panelItem of this.panels_) {
            panelItem.dismissErrorItem(id);
        }
    }
    /**
     * Testing method to construct a new notification panel item.
     * @param props partial properties from the `ProgressCenterItem`.
     */
    constructTestItem_(props = {}) {
        const item = new ProgressCenterItem();
        const defaults = {
            id: Math.ceil(Math.random() * 10000).toString(),
            itemCount: Math.ceil(Math.random() * 5),
            sourceMessage: 'fake_file.test',
            destinationMessage: 'Downloads',
            type: ProgressItemType.COPY,
            progressMax: 100,
        };
        // Apply defaults and overrides.
        Object.assign(item, defaults, props);
        return item;
    }
    /**
     * Testing method to add the notification panel item to the notification
     * panel.
     * @param item the panel item to be added.
     */
    addItemToPanel_(item) {
        this.panels_[0].setTimingForTests(
        // Make notification panel item show immediately.
        0, 
        // Make notification panel item keep showing for 5 minutes.
        5 * 60 * 1000);
        // Add the item to the panel.
        this.items_.push(item);
        this.updateItem(item);
    }
    /**
     * Testing method to add a new "progressing" state notification panel item.
     * @param props partial properties from the `ProgressCenterItem`.
     */
    addProcessingTestItem_(props = {}) {
        const item = this.constructTestItem_({
            state: ProgressItemState.PROGRESSING,
            progressValue: Math.ceil(Math.random() * 90),
            remainingTime: 150,
            ...props,
        });
        this.addItemToPanel_(item);
        return item;
    }
    /**
     * Testing method to add a new "completed" state notification panel item.
     * @param props partial properties from the `ProgressCenterItem`.
     */
    addCompletedTestItem_(props = {}) {
        const item = this.constructTestItem_({
            state: ProgressItemState.COMPLETED,
            progressValue: 100,
            ...props,
        });
        // Completed item needs to be in the panel before it completes.
        const oldItem = item.clone();
        oldItem.state = ProgressItemState.PROGRESSING;
        this.panels_[0]?.updateItem(oldItem);
        this.addItemToPanel_(item);
        return item;
    }
    /**
     * Testing method to add a new "error" state notification panel item.
     * @param props partial properties from the `ProgressCenterItem`.
     */
    addErrorTestItem_(props = {}) {
        const item = this.constructTestItem_({
            state: ProgressItemState.ERROR,
            message: 'Something went wrong. This is a very long error message.',
            ...props,
        });
        item.extraButton.set(ProgressItemState.ERROR, {
            text: 'Learn more',
            callback: () => { },
        });
        this.addItemToPanel_(item);
        return item;
    }
    /**
     * Testing method to add a new "scanning" state notification panel item.
     * @param props partial properties from the `ProgressCenterItem`.
     */
    addScanningTestItem_(props = {}) {
        const item = this.constructTestItem_({
            state: ProgressItemState.SCANNING,
            progressValue: Math.ceil(Math.random() * 90),
            remainingTime: 100,
            ...props,
        });
        // Scanning item needs to be in the panel before it starts to scan.
        const oldItem = item.clone();
        this.panels_[0]?.updateItem(oldItem);
        this.addItemToPanel_(item);
        return item;
    }
    /**
     * Testing method to add a new "paused" state notification panel item.
     * @param props partial properties from the `ProgressCenterItem`.
     */
    addPausedTestItem_(props = {}) {
        const item = this.constructTestItem_({
            state: ProgressItemState.PAUSED,
            ...props,
        });
        // Paused item needs to be in the panel before it pauses.
        const oldItem = item.clone();
        this.panels_[0]?.updateItem(oldItem);
        this.addItemToPanel_(item);
        return item;
    }
}

// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
// TS is complaining `EventMap` is not used and we can't use `_EventMap` here
// because we need to keep the class and interface exactly the same to do
// declaration merge, hence adding the eslint-disable below.
// eslint-disable-next-line @typescript-eslint/no-unused-vars
class FilesEventTarget extends EventTarget {
}

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * Location information which shows where the path points in FileManager's
 * file system.
 */
class EntryLocation {
    constructor(volumeInfo, rootType, isRootEntry, isReadOnly) {
        this.volumeInfo = volumeInfo;
        this.rootType = rootType;
        this.isRootEntry = isRootEntry;
        this.isReadOnly = isReadOnly;
        this.isSpecialSearchRoot = this.rootType === RootType.DRIVE_OFFLINE ||
            this.rootType === RootType.DRIVE_SHARED_WITH_ME ||
            this.rootType === RootType.DRIVE_RECENT ||
            isRecentRootType(this.rootType);
        this.isDriveBased = this.rootType === RootType.DRIVE ||
            this.rootType === RootType.DRIVE_SHARED_WITH_ME ||
            this.rootType === RootType.DRIVE_RECENT ||
            this.rootType === RootType.DRIVE_OFFLINE ||
            this.rootType === RootType.SHARED_DRIVES_GRAND_ROOT ||
            this.rootType === RootType.SHARED_DRIVE ||
            this.rootType === RootType.COMPUTERS_GRAND_ROOT ||
            this.rootType === RootType.COMPUTER;
        this.hasFixedLabel = this.isRootEntry &&
            (rootType !== RootType.SHARED_DRIVE && rootType !== RootType.COMPUTER &&
                rootType !== RootType.REMOVABLE && rootType !== RootType.TRASH &&
                rootType !== RootType.GUEST_OS);
        Object.freeze(this);
    }
}

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * Represents each volume, such as "drive", "download directory", each "USB
 * flush storage", or "mounted zip archive" etc.
 */
class VolumeInfo {
    /**
     * @param volumeType is the type of the volume.
     * @param volumeId is the ID of the volume.
     * @param fileSystem is the file system object for this volume.
     * @param error is the error if an error is found. Note: This represents if
     *     the mounting of the volume is successfully done or not. (If error is
     *     empty string, the mount is successfully done).
     * @param deviceType is the type of device
     *     ('usb'|'sd'|'optical'|'mobile'|'unknown') (as defined in
     *     chromeos/ash/components/disks/disk_mount_manager.cc). Can be undefined.
     * @param devicePath is the identifier of the device that the volume belongs
     *     to. Can be undefined.
     * @param isReadOnly is true if the volume is read only.
     * @param isReadOnlyRemovableDevice is true if the volume is read only
     *     removable device.
     * @param profile is the profile information.
     * @param label is the abel of the volume.
     * @param providerId is the Id of the provider for this volume. Undefined for
     *     non-FSP volumes.
     * @param configurable is true when the volume can be configured.
     * @param watchable is true when the volume can be watched.
     * @param source is the source of the volume's data.
     * @param diskFileSystemType is the file system type identifier.
     * @param iconSet is the set of icons for this volume.
     * @param driveLabel is the drive label of the volume. Removable partitions
     *     belonging to the same device will share the same drive label.
     * @param remoteMountPath is the path on the remote host where this volume is
     *     mounted, for crostini this is the user's homedir (/home/<username>).
     * @param vmType is the type of the VM which owns the volume if this is a
     *     GuestOS volume.
     */
    constructor(volumeType_, volumeId_, fileSystem_, error_, deviceType_, devicePath_, isReadOnly_, isReadOnlyRemovableDevice_, profile_, label_, providerId_, configurable_, watchable_, source_, diskFileSystemType_, iconSet_, driveLabel_, remoteMountPath_, vmType_) {
        this.volumeType_ = volumeType_;
        this.volumeId_ = volumeId_;
        this.fileSystem_ = fileSystem_;
        this.error_ = error_;
        this.deviceType_ = deviceType_;
        this.devicePath_ = devicePath_;
        this.isReadOnly_ = isReadOnly_;
        this.isReadOnlyRemovableDevice_ = isReadOnlyRemovableDevice_;
        this.profile_ = profile_;
        this.label_ = label_;
        this.providerId_ = providerId_;
        this.configurable_ = configurable_;
        this.watchable_ = watchable_;
        this.source_ = source_;
        this.diskFileSystemType_ = diskFileSystemType_;
        this.iconSet_ = iconSet_;
        this.driveLabel_ = driveLabel_;
        this.remoteMountPath_ = remoteMountPath_;
        this.vmType_ = vmType_;
        this.displayRoot_ = null;
        this.sharedDriveDisplayRoot_ = null;
        this.computersDisplayRoot_ = null;
        /**
         * An entry to be used as prefix of this volume on breadcrumbs, e.g. "My Files
         * > Downloads", "My Files" is a prefixEntry on "Downloads" VolumeInfo.
         */
        this.prefixEntry_ = null;
        this.fakeEntries_ = {};
        this.displayRoot_ = null;
        this.sharedDriveDisplayRoot_ = null;
        this.computersDisplayRoot_ = null;
        this.prefixEntry_ = null;
        this.fakeEntries_ = {};
        this.displayRootPromise_ = this.resolveDisplayRootImpl_();
        this.initializeFakeEntries_();
    }
    initializeFakeEntries_() {
        if (this.volumeType_ !== VolumeType.DRIVE) {
            return;
        }
        const dialogType = getStore().getState().launchParams.dialogType;
        const isSaveAs = dialogType === DialogType.SELECT_SAVEAS_FILE;
        if (isSaveAs) {
            // Users can't create new files directinly in Offline or Shared With Me
            // roots.
            return;
        }
        if (!isDriveFsBulkPinningEnabled()) {
            this.fakeEntries_[RootType.DRIVE_OFFLINE] = new FakeEntryImpl(str('DRIVE_OFFLINE_COLLECTION_LABEL'), RootType.DRIVE_OFFLINE);
        }
        this.fakeEntries_[RootType.DRIVE_SHARED_WITH_ME] = new FakeEntryImpl(str('DRIVE_SHARED_WITH_ME_COLLECTION_LABEL'), RootType.DRIVE_SHARED_WITH_ME);
    }
    get volumeType() {
        return this.volumeType_;
    }
    get volumeId() {
        return this.volumeId_;
    }
    get fileSystem() {
        return this.fileSystem_;
    }
    /** Display root path. It is null before finishing to resolve the entry. */
    get displayRoot() {
        return this.displayRoot_;
    }
    /**
     * The display root path of Shared Drives directory. It is null before
     * finishing to resolve the entry. Valid only for Drive volume.
     */
    get sharedDriveDisplayRoot() {
        return this.sharedDriveDisplayRoot_;
    }
    /**
     * The display root path of Computers directory. It is null before finishing
     * to resolve the entry. Valid only for Drive volume.
     */
    get computersDisplayRoot() {
        return this.computersDisplayRoot_;
    }
    /**
     * The volume's fake entries such as Recent, Offline, Shared with me, etc...
     * in Google Drive.
     */
    get fakeEntries() {
        return this.fakeEntries_;
    }
    /**
     * This represents if the mounting of the volume is successfully done or
     * not. (If error is empty string, the mount is successfully done)
     */
    get error() {
        return this.error_;
    }
    /**
     * The type of device. (e.g. USB, SD card, DVD etc.)
     */
    get deviceType() {
        return this.deviceType_;
    }
    /**
     * If the volume is removable, devicePath is the path of the system device
     * this device's block is a part of. (e.g.
     * /sys/devices/pci0000:00/.../8:0:0:0/) Otherwise, this should be empty.
     */
    get devicePath() {
        return this.devicePath_;
    }
    get isReadOnly() {
        return this.isReadOnly_;
    }
    /**
     * Whether the device is read-only removable device or not.
     */
    get isReadOnlyRemovableDevice() {
        return this.isReadOnlyRemovableDevice_;
    }
    get profile() {
        return this.profile_;
    }
    /**
     * Label for the volume if the volume is either removable or a provided file
     * system. In case of removables, if disk is a parent, then its label, else
     * parent's label (e.g. "TransMemory").
     */
    get label() {
        return this.label_;
    }
    /**
     * ID of a provider for this volume.
     */
    get providerId() {
        return this.providerId_;
    }
    /**
     * True if the volume is configurable.
     * See https://developer.chrome.com/apps/fileSystemProvider.
     */
    get configurable() {
        return this.configurable_;
    }
    /**
     * True if the volume notifies about changes via file/directory watchers.
     */
    get watchable() {
        return this.watchable_;
    }
    /**
     * Source of the volume's data.
     */
    get source() {
        return this.source_;
    }
    /**
     * File system type identifier.
     */
    get diskFileSystemType() {
        return this.diskFileSystemType_;
    }
    /**
     * Set of icons for this volume.
     */
    get iconSet() {
        return this.iconSet_;
    }
    /**
     * Drive label for the volume. Removable partitions belonging to the same
     * physical media device will share the same drive label.
     */
    get driveLabel() {
        return this.driveLabel_;
    }
    /**
     * The path on the remote host where this volume is mounted, for crostini this
     * is the user's homedir (/home/<username>).
     */
    get remoteMountPath() {
        return this.remoteMountPath_;
    }
    /**
     * An entry to be used as prefix of this volume on breadcrumbs,
     * e.g. "My Files > Downloads"
     * "My Files" is a prefixEntry on "Downloads" VolumeInfo.
     */
    get prefixEntry() {
        return this.prefixEntry_;
    }
    set prefixEntry(entry) {
        this.prefixEntry_ = entry;
    }
    /**
     * If this is a GuestOS volume, the type of the VM which owns this volume.
     */
    get vmType() {
        return this.vmType_;
    }
    /**
     * Returns a promise to the entry for the given URL
     */
    static resolveFileSystemUrl_(url) {
        return new Promise(window.webkitResolveLocalFileSystemURL.bind(null, url));
    }
    /**
     * Sets |sharedDriveDisplayRoot_| if team drives are enabled.
     *
     * The return value will resolve once this operation is complete.
     */
    resolveSharedDrivesRoot_() {
        if (!this.fileSystem_) {
            return Promise.reject(this.error);
        }
        return VolumeInfo
            .resolveFileSystemUrl_(this.fileSystem_.root.toURL() + SHARED_DRIVES_DIRECTORY_NAME)
            .then(sharedDrivesRoot => {
            this.sharedDriveDisplayRoot_ = sharedDrivesRoot;
        }, error => {
            if (error.name !== 'NotFoundError') {
                throw error;
            }
        });
    }
    /**
     * Sets |computersDisplayRoot_| if Computers are enabled.
     *
     * If Computers are not enabled, resolveFileSystemUrl_ will return a
     * 'NotFoundError' which will be caught here. Any other errors will be
     * rethrown.
     *
     * The return value will resolve once this operation is complete.
     */
    resolveComputersRoot_() {
        if (!this.fileSystem_) {
            return Promise.reject(this.error);
        }
        return VolumeInfo
            .resolveFileSystemUrl_(this.fileSystem_.root.toURL() + COMPUTERS_DIRECTORY_NAME)
            .then((computersRoot) => {
            this.computersDisplayRoot_ = computersRoot;
        }, (error) => {
            if (error.name !== 'NotFoundError') {
                throw error;
            }
        });
    }
    /**
     * Returns a promise that resolves when the display root is resolved.
     */
    async resolveDisplayRootImpl_() {
        if (!this.fileSystem_) {
            return Promise.reject(this.error);
        }
        if (this.volumeType !== VolumeType.DRIVE) {
            this.displayRoot_ = this.fileSystem_.root;
            return Promise.resolve(this.displayRoot_);
        }
        // For Drive, we need to resolve.
        const displayRootURL = this.fileSystem_.root.toURL() + 'root';
        const [displayRoot] = await Promise.all([
            VolumeInfo.resolveFileSystemUrl_(displayRootURL),
            this.resolveSharedDrivesRoot_(),
            this.resolveComputersRoot_(),
        ]);
        // Store the obtained displayRoot.
        this.displayRoot_ = displayRoot;
        return this.displayRoot_;
    }
    /**
     * Starts resolving the display root and obtains it.  It may take long time
     * for Drive. Once resolved, it is cached.
     *
     * @param onSuccess Success callback with the display root directory as an
     *     argument.
     */
    resolveDisplayRoot(optOnSuccess, optOnFailure) {
        if (optOnSuccess) {
            this.displayRootPromise_.then(optOnSuccess, optOnFailure);
        }
        return assert(this.displayRootPromise_);
    }
}

// Copyright 2012 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview This is a data model representin
 */
/**
 * Default compare function.
 */
function defaultValuesCompareFunction(a, b) {
    // We could insert i18n comparisons here.
    if (a < b) {
        return -1;
    }
    if (a > b) {
        return 1;
    }
    return 0;
}
/**
 * A data model that wraps a simple array and supports sorting by storing
 * initial indexes of elements for each position in sorted array.
 */
class ArrayDataModel extends FilesEventTarget {
    /**
     * @param array The underlying array.
     */
    constructor(array_) {
        super();
        this.array_ = array_;
        this.indexes_ = [];
        this.compareFunctions_ = {};
        this.sortStatus_ = { field: null, direction: null };
        for (let i = 0; i < this.array_.length; i++) {
            this.indexes_.push(i);
        }
    }
    /**
     * The length of the data model.
     */
    get length() {
        return this.array_.length;
    }
    /**
     * Returns the item at the given index.
     * This implementation returns the item at the given index in the sorted
     * array.
     * @param index The index of the element to get.
     * @return The element at the given index.
     */
    item(index) {
        if (index >= 0 && index < this.length) {
            return this.array_[this.indexes_[index]];
        }
        return undefined;
    }
    /**
     * Returns compare function set for given field.
     * @param field The field to get compare function for.
     * @return Compare function set for given field.
     */
    compareFunction(field) {
        return this.compareFunctions_[field];
    }
    /**
     * Sets compare function for given field.
     * @param field The field to set compare function.
     * @param compareFunction Compare function to set for given field.
     */
    setCompareFunction(field, compareFunction) {
        if (!this.compareFunctions_) {
            this.compareFunctions_ = {};
        }
        this.compareFunctions_[field] = compareFunction;
    }
    /**
     * Returns true if the field has a compare function.
     * @param field The field to check.
     * @return True if the field is sortable.
     */
    isSortable(field) {
        return this.compareFunctions_ && field in this.compareFunctions_;
    }
    /**
     * Returns current sort status.
     * @return Current sort status.
     */
    get sortStatus() {
        if (this.sortStatus_) {
            return this.createSortStatus(this.sortStatus_.field, this.sortStatus_.direction);
        }
        else {
            return this.createSortStatus(null, null);
        }
    }
    /**
     * Returns the first matching item.
     * @param item The item to find.
     * @param fromIndex If provided, then the searching start at the fromIndex.
     * @return The index of the first found element or -1 if not found.
     */
    indexOf(item, fromIndex) {
        for (let i = fromIndex || 0; i < this.indexes_.length; i++) {
            if (item === this.item(i)) {
                return i;
            }
        }
        return -1;
    }
    /**
     * Returns an array of elements in a selected range.
     * @param from The starting index of the selected range.
     * @param to The ending index of selected range.
     * @return An array of elements in the selected range.
     */
    slice(from, to) {
        const arr = this.array_;
        return this.indexes_.slice(from, to).map((index) => {
            return arr[index];
        });
    }
    /**
     * This removes and adds items to the model.
     * This dispatches a splice event.
     * This implementation runs sort after splice and creates permutation for
     * the whole change.
     * @param index The index of the item to update.
     * @param deleteCount The number of items to remove.
     * @param itemsToAdd The items to add.
     * @return An array with the removed items.
     */
    splice(index, deleteCount, ...itemsToAdd) {
        const addCount = itemsToAdd.length;
        const newIndexes = [];
        const deletePermutation = [];
        const deletedItems = [];
        const newArray = [];
        index = Math.min(index, this.indexes_.length);
        deleteCount = Math.min(deleteCount, this.indexes_.length - index);
        // Copy items before the insertion point.
        let i;
        for (i = 0; i < index; i++) {
            newIndexes.push(newArray.length);
            deletePermutation.push(i);
            newArray.push(this.array_[this.indexes_[i]]);
        }
        // Delete items.
        for (; i < index + deleteCount; i++) {
            deletePermutation.push(-1);
            deletedItems.push(this.array_[this.indexes_[i]]);
        }
        // Insert new items instead deleted ones.
        for (let j = 0; j < addCount; j++) {
            newIndexes.push(newArray.length);
            newArray.push(arguments[j + 2]);
        }
        // Copy items after the insertion point.
        for (; i < this.indexes_.length; i++) {
            newIndexes.push(newArray.length);
            deletePermutation.push(i - deleteCount + addCount);
            newArray.push(this.array_[this.indexes_[i]]);
        }
        this.indexes_ = newIndexes;
        this.array_ = newArray;
        // TODO(arv): Maybe unify splice and change events?
        const spliceEventDetail = {
            removed: deletedItems,
            added: itemsToAdd,
        };
        const status = this.sortStatus;
        // if sortStatus.field is null, this restores original order.
        const sortPermutation = this.doSort_(this.sortStatus.field, this.sortStatus.direction);
        if (sortPermutation) {
            const splicePermutation = deletePermutation.map((element) => {
                return element !== -1 ? sortPermutation[element] : -1;
            });
            this.dispatchPermutedEvent_(splicePermutation);
            spliceEventDetail.index = sortPermutation[index];
        }
        else {
            this.dispatchPermutedEvent_(deletePermutation);
            spliceEventDetail.index = index;
        }
        this.dispatchEvent(new CustomEvent('splice', { detail: spliceEventDetail }));
        // Still need to finish the sorting above (including events), so
        // list will not go to inconsistent state.
        if (status.field) {
            this.delayedSort_(status.field, status.direction);
        }
        return deletedItems;
    }
    /**
     * Appends items to the end of the model.
     *
     * This dispatches a splice event.
     *
     * @param itemsToAppend The items to append.
     * @return The new length of the model.
     */
    push(...itemsToAppend) {
        this.splice(this.length, 0, ...itemsToAppend);
        return this.length;
    }
    /**
     * Updates the existing item with the new item.
     *
     * The existing item and the new item are regarded as the same item and the
     * permutation tracks these indexes.
     *
     * @param oldItem Old item that is contained in the model. If the item is not
     *     found in the model, the method call is just ignored.
     * @param newItem New item.
     */
    replaceItem(oldItem, newItem) {
        const index = this.indexOf(oldItem);
        if (index < 0) {
            return;
        }
        this.array_[this.indexes_[index]] = newItem;
        this.updateIndex(index);
    }
    /**
     * Use this to update a given item in the array. This does not remove and
     * reinsert a new item.
     * This dispatches a change event.
     * This runs sort after updating.
     * @param index The index of the item to update.
     */
    updateIndex(index) {
        this.updateIndexes([index]);
    }
    /**
     * Notifies of update of the items in the array. This does not remove and
     * reinsert new items.
     * This dispatches one or more change events.
     * This runs sort after updating.
     * @param indexes The index list of items to update.
     */
    updateIndexes(indexes) {
        indexes.forEach(index => {
            assert$1(index >= 0 && index < this.length, 'Invalid index');
        });
        for (const index of indexes) {
            const e = new CustomEvent('change', { detail: { index } });
            this.dispatchEvent(e);
        }
        if (!this.sortStatus.field) {
            return;
        }
        const status = this.sortStatus;
        const sortPermutation = this.doSort_(this.sortStatus.field, this.sortStatus.direction);
        if (sortPermutation) {
            this.dispatchPermutedEvent_(sortPermutation);
        }
        // Still need to finish the sorting above (including events), so
        // list will not go to inconsistent state.
        this.delayedSort_(status.field, status.direction);
    }
    /**
     * Creates sort status with given field and direction.
     * @param field Sort field.
     * @param direction Sort direction.
     * @return Created sort status.
     */
    createSortStatus(field, direction) {
        return { field: field, direction: direction };
    }
    /**
     * Sorts data model according to given field and direction and dispatches
     * sorted event with delay. If no need to delay, use sort() instead.
     * @param field Sort field.
     * @param direction Sort direction.
     */
    delayedSort_(field, direction) {
        setTimeout(() => {
            // If the sort status has been changed, sorting has already done
            // on the change event.
            if (field === this.sortStatus.field &&
                direction === this.sortStatus.direction) {
                this.sort(field, direction);
            }
        }, 0);
    }
    /**
     * Sorts data model according to given field and direction and dispatches
     * sorted event.
     * @param field Sort field.
     * @param direction Sort direction.
     */
    sort(field, direction) {
        const sortPermutation = this.doSort_(field, direction);
        if (sortPermutation) {
            this.dispatchPermutedEvent_(sortPermutation);
        }
        this.dispatchSortEvent_();
    }
    /**
     * Sorts data model according to given field and direction.
     * @param field Sort field.
     * @param direction Sort direction.
     */
    doSort_(field, direction) {
        const compareFunction = this.sortFunction_(field, direction);
        const positions = [];
        for (let i = 0; i < this.length; i++) {
            positions[this.indexes_[i]] = i;
        }
        const sorted = this.indexes_.every((element, index, array) => {
            return index === 0 || compareFunction(element, array[index - 1]) >= 0;
        });
        if (!sorted) {
            this.indexes_.sort(compareFunction);
        }
        this.sortStatus_ = this.createSortStatus(field, direction);
        const sortPermutation = [];
        let changed = false;
        for (let i = 0; i < this.length; i++) {
            if (positions[this.indexes_[i]] !== i) {
                changed = true;
            }
            sortPermutation[positions[this.indexes_[i]]] = i;
        }
        if (changed) {
            return sortPermutation;
        }
        return null;
    }
    dispatchSortEvent_() {
        const e = new Event('sorted');
        this.dispatchEvent(e);
    }
    dispatchPermutedEvent_(permutation) {
        const e = new CustomEvent('permuted', { detail: { permutation, newLength: this.length } });
        this.dispatchEvent(e);
    }
    /**
     * Creates compare function for the field.
     * Returns the function set as sortFunction for given field or default compare
     * function
     * @param field Sort field.
     * @return Compare function.
     */
    createCompareFunction_(field) {
        const compareFunction = this.compareFunctions_ ? this.compareFunctions_[field] : null;
        if (compareFunction) {
            return compareFunction;
        }
        else {
            return function (a, b) {
                return defaultValuesCompareFunction(a[field], b[field]);
            };
        }
    }
    /**
     * Creates compare function for given field and direction.
     * @param field Sort field.
     * @param direction Sort direction.
     */
    sortFunction_(field, direction) {
        let compareFunction = null;
        if (field !== null) {
            compareFunction = this.createCompareFunction_(field);
        }
        const dirMultiplier = direction === 'desc' ? -1 : 1;
        return (index1, index2) => {
            const item1 = this.array_[index1];
            const item2 = this.array_[index2];
            let compareResult = 0;
            if (typeof (compareFunction) === 'function') {
                compareResult = compareFunction(item1, item2);
            }
            if (compareResult !== 0) {
                return dirMultiplier * compareResult;
            }
            return dirMultiplier * defaultValuesCompareFunction(index1, index2);
        };
    }
}

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview The container of the VolumeInfo for each mounted volume.
 */
/**
 * The container of the VolumeInfo for each mounted volume.
 */
class VolumeInfoList extends ArrayDataModel {
    constructor() {
        super([]);
    }
    /**
     * Adds the volumeInfo to the appropriate position. If there already exists,
     * just replaces it.
     */
    add(volumeInfo) {
        const index = this.findIndex(volumeInfo.volumeId);
        if (index !== -1) {
            super.splice(index, 1, volumeInfo);
        }
        else {
            super.push(volumeInfo);
        }
    }
    /**
     * Removes the VolumeInfo having the given ID.
     */
    remove(volumeId) {
        const index = this.findIndex(volumeId);
        if (index !== -1) {
            super.splice(index, 1);
        }
    }
    item(index) {
        return super.item(index);
    }
    /**
     * Obtains an index from the volume ID.
     */
    findIndex(volumeId) {
        for (let i = 0; i < this.length; i++) {
            if (this.item(i).volumeId === volumeId) {
                return i;
            }
        }
        return -1;
    }
}

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * Time in milliseconds that we wait a response for general volume operations
 * such as mount, unmount, and requestFileSystem. If no response on
 * mount/unmount received the request supposed failed.
 */
const TIMEOUT = 15 * 60 * 1000;
const TIMEOUT_STR_REQUEST_FILE_SYSTEM = 'timeout(requestFileSystem)';
/**
 * A list of RequestType
 */
var RequestType;
(function (RequestType) {
    RequestType["MOUNT"] = "mount";
    RequestType["UNMOUNT"] = "unmount";
})(RequestType || (RequestType = {}));
/**
 * Logs a warning message if the given error is not in
 * VolumeError.
 *
 * @param error Status string usually received from APIs.
 */
function validateError(error) {
    const found = Object.values(VolumeError).find(value => value === error);
    if (found) {
        return;
    }
    console.warn(`Invalid mount error: ${error}`);
}
/**
 * Builds the VolumeInfo data from chrome.fileManagerPrivate.VolumeMetadata.
 * @param volumeMetadata Metadata instance for the volume.
 * @return Promise settled with the VolumeInfo instance.
 */
async function createVolumeInfo(volumeMetadata) {
    let localizedLabel;
    switch (volumeMetadata.volumeType) {
        case VolumeType.DOWNLOADS:
            localizedLabel = str('MY_FILES_ROOT_LABEL');
            break;
        case VolumeType.DRIVE:
            localizedLabel = str('DRIVE_DIRECTORY_LABEL');
            break;
        case VolumeType.MEDIA_VIEW:
            switch (getMediaViewRootTypeFromVolumeId(volumeMetadata.volumeId)) {
                case MediaViewRootType.IMAGES:
                    localizedLabel = str('MEDIA_VIEW_IMAGES_ROOT_LABEL');
                    break;
                case MediaViewRootType.VIDEOS:
                    localizedLabel = str('MEDIA_VIEW_VIDEOS_ROOT_LABEL');
                    break;
                case MediaViewRootType.AUDIO:
                    localizedLabel = str('MEDIA_VIEW_AUDIO_ROOT_LABEL');
                    break;
            }
            break;
        case VolumeType.CROSTINI:
            localizedLabel = str('LINUX_FILES_ROOT_LABEL');
            break;
        case VolumeType.ANDROID_FILES:
            localizedLabel = str('ANDROID_FILES_ROOT_LABEL');
            break;
        default:
            // TODO(mtomasz): Calculate volumeLabel for all types of volumes in the
            // C++ layer.
            localizedLabel = volumeMetadata.volumeLabel ||
                volumeMetadata.volumeId.split(':', 2)[1];
            break;
    }
    debug(`Getting file system '${volumeMetadata.volumeId}'`);
    return timeoutPromise(new Promise((resolve, reject) => {
        chrome.fileManagerPrivate.getVolumeRoot({
            volumeId: volumeMetadata.volumeId,
            writable: !volumeMetadata.isReadOnly,
        }, (rootDirectoryEntry) => {
            if (chrome.runtime.lastError) {
                reject(chrome.runtime.lastError.message);
            }
            else {
                resolve(rootDirectoryEntry);
            }
        });
    }), TIMEOUT, TIMEOUT_STR_REQUEST_FILE_SYSTEM + ': ' + volumeMetadata.volumeId)
        .then(rootDirectoryEntry => {
        debug(`Got file system '${volumeMetadata.volumeId}'`);
        return new VolumeInfo(volumeMetadata.volumeType, volumeMetadata.volumeId, rootDirectoryEntry.filesystem, volumeMetadata.mountCondition, volumeMetadata.deviceType, volumeMetadata.devicePath, volumeMetadata.isReadOnly, volumeMetadata.isReadOnlyRemovableDevice, volumeMetadata.profile, localizedLabel, volumeMetadata.providerId, volumeMetadata.configurable, volumeMetadata.watchable, volumeMetadata.source, volumeMetadata.diskFileSystemType, volumeMetadata.iconSet, volumeMetadata.driveLabel, volumeMetadata.remoteMountPath, volumeMetadata.vmType);
    })
        .then(async (volumeInfo) => {
        // resolveDisplayRoot() is a promise, but instead of using await here,
        // we just pass a onSuccess function to it, because we don't want to it
        // to interfere the startup time.
        volumeInfo.resolveDisplayRoot(() => {
            getStore().dispatch(addVolume(volumeInfo, volumeMetadata));
        });
        return volumeInfo;
    })
        .catch(error => {
        console.warn(`Cannot mount file system '${volumeMetadata.volumeId}': ${error.stack || error}`);
        // TODO(crbug.com/41391739): Report a mount error via UMA.
        throw error;
    });
}
/**
 * VolumeManager is responsible for tracking list of mounted volumes.
 */
class VolumeManager extends FilesEventTarget {
    constructor(createVolumeInfo_ = createVolumeInfo) {
        super();
        this.createVolumeInfo_ = createVolumeInfo_;
        /**
         * The list of VolumeInfo instances for each mounted volume.
         */
        this.volumeInfoList = new VolumeInfoList();
        /**
         * The list of archives requested to mount. We will show contents once
         * archive is mounted, but only for mounts from within this filebrowser tab.
         */
        this.requests_ = {};
        // The status should be merged into VolumeManager.
        // TODO(hidehiko): Remove them after the migration.
        /**
         * Connection state of the Drive.
         */
        this.driveConnectionState_ = {
            type: chrome.fileManagerPrivate.DriveConnectionStateType.OFFLINE,
            reason: chrome.fileManagerPrivate.DriveOfflineReason.NO_SERVICE,
        };
        /**
         * Holds the resolver for the `waitForInitialization_` promise.
         */
        this.finishInitialization_ = null;
        /**
         * Promise used to wait for the initialize() method to finish.
         */
        this.waitForInitialization_ = new Promise(resolve => this.finishInitialization_ = resolve);
        chrome.fileManagerPrivate.onDriveConnectionStatusChanged.addListener(this.onDriveConnectionStatusChanged_.bind(this));
        this.onDriveConnectionStatusChanged_();
        // Subscribe to mount event as early as possible, but after the
        // waitForInitialization_ above.
        chrome.fileManagerPrivate.onMountCompleted.addListener(this.onMountCompleted_.bind(this));
    }
    /**
     * Gets the 'media-store-files-only' filter state: true if enabled, false if
     * disabled. The filter is only enabled by the Android (ARC) file picker, and
     * implemented by {FilteredVolumeManager} override.
     */
    getMediaStoreFilesOnlyFilterEnabled() {
        return false;
    }
    /**
     * Disposes the instance. After the invocation of this method, any other
     * method should not be called.
     */
    dispose() { }
    /**
     * Invoked when the drive connection status is changed.
     */
    onDriveConnectionStatusChanged_() {
        chrome.fileManagerPrivate.getDriveConnectionState(state => {
            this.driveConnectionState_ = state;
            this.dispatchEvent(new CustomEvent('drive-connection-changed'));
        });
    }
    /**
     * Returns the drive connection state.
     */
    getDriveConnectionState() {
        return this.driveConnectionState_;
    }
    /**
     * Adds new volume info from the given volumeMetadata. If the corresponding
     * volume info has already been added, the volumeMetadata is ignored.
     */
    addVolumeInfo_(volumeInfo) {
        const volumeType = volumeInfo.volumeType;
        if (this.volumeInfoList.findIndex(volumeInfo.volumeId) === -1) {
            this.volumeInfoList.add(volumeInfo);
            // Update the network connection status, because until the drive
            // is initialized, the status is set to not ready.
            // TODO(mtomasz): The connection status should be migrated into
            // chrome.fileManagerPrivate.VolumeMetadata.
            if (volumeType === VolumeType.DRIVE) {
                this.onDriveConnectionStatusChanged_();
            }
        }
        else if (volumeType === VolumeType.REMOVABLE) {
            // Update for remounted USB external storage, because they were
            // remounted to switch read-only policy.
            this.volumeInfoList.add(volumeInfo);
        }
        return volumeInfo;
    }
    /**
     * Initializes mount points.
     */
    async initialize() {
        let finished = false;
        /**
         * Resolves the initialization promise to unblock any code awaiting for
         * it.
         */
        const finishInitialization = () => {
            if (finished) {
                return;
            }
            finished = true;
            console.warn('Volumes initialization finished');
            if (this.finishInitialization_) {
                this.finishInitialization_();
            }
        };
        try {
            console.warn('Getting volumes');
            let volumeMetadataList = await promisify(chrome.fileManagerPrivate.getVolumeMetadataList);
            if (!volumeMetadataList) {
                console.warn('Cannot get volumes');
                finishInitialization();
                return;
            }
            volumeMetadataList = volumeMetadataList.filter(volume => !volume.hidden);
            debug(`There are ${volumeMetadataList.length} volumes`);
            let counter = 0;
            // Create VolumeInfo for each volume.
            volumeMetadataList.map(async (volumeMetadata, idx) => {
                const volumeId = volumeMetadata.volumeId;
                let volumeInfo = null;
                try {
                    debug(`Initializing volume #${idx} '${volumeId}'`);
                    // createVolumeInfo() requests the filesystem and resolve its root,
                    // after that it only creates a VolumeInfo.
                    volumeInfo = await this.createVolumeInfo_(volumeMetadata);
                    // Add addVolumeInfo_() changes the VolumeInfoList which propagates
                    // to the foreground.
                    this.addVolumeInfo_(volumeInfo);
                    debug(`Initialized volume #${idx} ${volumeId}'`);
                }
                catch (error) {
                    console.warn(`Error initializing #${idx} ${volumeId}: ${error}`);
                }
                finally {
                    counter += 1;
                    // Finish after all volumes have been processed, or at least Downloads
                    // or Drive.
                    const isDriveOrDownloads = volumeInfo &&
                        (volumeInfo.volumeType === VolumeType.DOWNLOADS ||
                            volumeInfo.volumeType === VolumeType.DRIVE);
                    if (counter === volumeMetadataList.length || isDriveOrDownloads) {
                        finishInitialization();
                    }
                }
            });
            // At this point the volumes are still initializing.
            console.warn(`Queued the initialization of all ` +
                `${volumeMetadataList.length} volumes`);
            if (volumeMetadataList.length === 0) {
                finishInitialization();
            }
        }
        catch (error) {
            finishInitialization();
            throw error;
        }
    }
    /**
     * Event handler called when some volume was mounted or unmounted.
     */
    async onMountCompleted_(event) {
        // Wait for the initialization to guarantee that the initialize() runs for
        // some volumes before any mount event, because the mounted volume can be
        // unresponsive, getting stuck when resolving the root in the method
        // createVolumeInfo(). crbug.com/504366
        await this.waitForInitialization_;
        const { eventType, status, volumeMetadata } = event;
        const { sourcePath = '', volumeId } = volumeMetadata;
        const volumeError = status;
        switch (eventType) {
            case 'mount': {
                const requestKey = this.makeRequestKey_(RequestType.MOUNT, sourcePath);
                switch (volumeError) {
                    case VolumeError.SUCCESS:
                    case VolumeError.UNKNOWN_FILESYSTEM:
                    case VolumeError.UNSUPPORTED_FILESYSTEM: {
                        debug(`Mounted '${sourcePath}' as '${volumeId}'`);
                        if (volumeMetadata.hidden) {
                            debug(`Mount discarded for hidden volume: '${volumeId}'`);
                            this.finishRequest_(requestKey, volumeError);
                            return;
                        }
                        let volumeInfo;
                        try {
                            volumeInfo = await this.createVolumeInfo_(volumeMetadata);
                        }
                        catch (error) {
                            console.warn('Unable to create volumeInfo for ' +
                                `${volumeId} mounted on ${sourcePath}.` +
                                `Mount status: ${volumeError}. Error: ${error.stack || error}.`);
                            this.finishRequest_(requestKey, volumeError);
                            return;
                        }
                        this.addVolumeInfo_(volumeInfo);
                        this.finishRequest_(requestKey, volumeError, volumeInfo);
                        return;
                    }
                    case VolumeError.PATH_ALREADY_MOUNTED: {
                        console.warn(`Cannot mount (redacted): Already mounted as '${volumeId}'`);
                        debug(`Cannot mount '${sourcePath}': Already mounted as '${volumeId}'`);
                        const navigationEvent = new CustomEvent('volume_already_mounted', { detail: { volumeId } });
                        this.dispatchEvent(navigationEvent);
                        this.finishRequest_(requestKey, volumeError);
                        return;
                    }
                    case VolumeError.NEED_PASSWORD:
                    case VolumeError.CANCELLED:
                    default:
                        console.warn('Cannot mount (redacted):', volumeError);
                        debug(`Cannot mount '${sourcePath}':`, volumeError);
                        this.finishRequest_(requestKey, volumeError);
                        return;
                }
            }
            case 'unmount': {
                const requestKey = this.makeRequestKey_(RequestType.UNMOUNT, volumeId);
                const volumeInfoIndex = this.volumeInfoList.findIndex(volumeId);
                const volumeInfo = volumeInfoIndex !== -1 ?
                    this.volumeInfoList.item(volumeInfoIndex) :
                    null;
                switch (volumeError) {
                    case VolumeError.SUCCESS: {
                        const requested = requestKey in this.requests_;
                        if (!requested && volumeInfo) {
                            debug(`Unmounted '${volumeId}' without request`);
                            this.dispatchEvent(new CustomEvent('externally-unmounted', { detail: volumeInfo }));
                        }
                        else {
                            debug(`Unmounted '${volumeId}'`);
                        }
                        getStore().dispatch(removeVolume(volumeId));
                        this.volumeInfoList.remove(volumeId);
                        this.finishRequest_(requestKey, volumeError);
                        return;
                    }
                    default:
                        console.warn('Cannot unmount (redacted):', volumeError);
                        debug(`Cannot unmount '${volumeId}':`, volumeError);
                        this.finishRequest_(requestKey, volumeError);
                        return;
                }
            }
        }
    }
    /**
     * Creates string to match mount events with requests.
     * @param requestType 'mount' | 'unmount'.
     * @param argument Argument describing the request, eg. source file
     *     path of the archive to be mounted, or a volumeId for unmounting.
     * @return Key for |this.requests_|.
     */
    makeRequestKey_(requestType, argument) {
        return requestType + ':' + argument;
    }
    /**
     * @param fileUrl File url to the archive file.
     * @param password Password to decrypt archive file.
     * @return Fulfilled on success, otherwise rejected with a VolumeError.
     */
    async mountArchive(fileUrl, password) {
        const path = await promisify(chrome.fileManagerPrivate.addMount, fileUrl, password);
        debug(`Mounting '${path}'`);
        const key = this.makeRequestKey_(RequestType.MOUNT, path);
        return this.startRequest_(key);
    }
    /**
     * Cancels mounting an archive.
     * @param fileUrl File url to the archive file.
     * @return Fulfilled on success, otherwise rejected with a VolumeError.
     */
    async cancelMounting(fileUrl) {
        debug(`Cancelling mounting archive at '${fileUrl}'`);
        return promisify(chrome.fileManagerPrivate.cancelMounting, fileUrl);
    }
    /**
     * Unmounts a volume.
     * @param volumeInfo Volume to be unmounted.
     * @return Fulfilled on success, otherwise rejected with a VolumeError.
     */
    async unmount({ volumeId }) {
        debug(`Unmounting '${volumeId}'`);
        const key = this.makeRequestKey_(RequestType.UNMOUNT, volumeId);
        const request = this.startRequest_(key);
        await promisify(chrome.fileManagerPrivate.removeMount, volumeId);
        await request;
    }
    /**
     * Configures a volume.
     * @param volumeInfo Volume to be configured.
     * @return Fulfilled on success, otherwise rejected with an error message.
     */
    configure(volumeInfo) {
        return promisify(chrome.fileManagerPrivate.configureVolume, volumeInfo.volumeId);
    }
    /**
     * Obtains a volume info containing the passed entry.
     * @param entry Entry on the volume to be returned. Can be fake.
     */
    getVolumeInfo(entry) {
        if (!entry) {
            console.warn(`Invalid entry passed to getVolumeInfo: ${entry}`);
            return null;
        }
        for (let i = 0; i < this.volumeInfoList.length; i++) {
            const volumeInfo = this.volumeInfoList.item(i);
            if (volumeInfo.fileSystem &&
                isSameFileSystem(volumeInfo.fileSystem, entry.filesystem)) {
                return volumeInfo;
            }
            // Additionally, check fake entries.
            for (const fakeEntry of Object.values(volumeInfo.fakeEntries)) {
                if (isSameEntry(fakeEntry, entry)) {
                    return volumeInfo;
                }
            }
        }
        return null;
    }
    /**
     * Obtains volume information of the current profile.
     */
    getCurrentProfileVolumeInfo(volumeType) {
        for (let i = 0; i < this.volumeInfoList.length; i++) {
            const volumeInfo = this.volumeInfoList.item(i);
            if (volumeInfo.profile.isCurrentProfile &&
                volumeInfo.volumeType === volumeType) {
                return volumeInfo;
            }
        }
        return null;
    }
    /**
     * Obtains location information from an entry.
     * @param entry File or directory entry. It can be a fake entry.
     */
    getLocationInfo(entry) {
        if (!entry) {
            console.warn(`Invalid entry passed to getLocationInfo: ${entry}`);
            return null;
        }
        const volumeInfo = this.getVolumeInfo(entry);
        if (isFakeEntry(entry)) {
            const rootType = getRootType(entry);
            assert$1(rootType);
            // Aggregated views like RECENTS and TRASH exist as fake entries but may
            // actually defer their logic to some underlying implementation or
            // delegate to the location filesystem.
            let isReadOnly = true;
            if (rootType === RootType.RECENT || rootType === RootType.TRASH ||
                (isOneDrivePlaceholder(entry))) {
                isReadOnly = false;
            }
            return new EntryLocation(volumeInfo, rootType, true /* The entry points a root directory. */, isReadOnly);
        }
        if (!volumeInfo) {
            return null;
        }
        let rootType;
        let isReadOnly;
        let isRootEntry;
        if (volumeInfo.volumeType === VolumeType.DRIVE) {
            // For Drive, the roots are /root, /team_drives, /Computers and /other,
            // instead of /. Root URLs contain trailing slashes.
            if (entry.fullPath === '/root' ||
                entry.fullPath.indexOf('/root/') === 0) {
                rootType = RootType.DRIVE;
                isReadOnly = volumeInfo.isReadOnly;
                isRootEntry = entry.fullPath === '/root';
            }
            else if (entry.fullPath === SHARED_DRIVES_DIRECTORY_PATH ||
                entry.fullPath.indexOf(SHARED_DRIVES_DIRECTORY_PATH + '/') === 0) {
                if (entry.fullPath === SHARED_DRIVES_DIRECTORY_PATH) {
                    rootType = RootType.SHARED_DRIVES_GRAND_ROOT;
                    isReadOnly = true;
                    isRootEntry = true;
                }
                else {
                    rootType = RootType.SHARED_DRIVE;
                    if (isTeamDriveRoot(entry)) {
                        isReadOnly = false;
                        isRootEntry = true;
                    }
                    else {
                        // Regular files/directories under Shared Drives.
                        isRootEntry = false;
                        isReadOnly = volumeInfo.isReadOnly;
                    }
                }
            }
            else if (entry.fullPath === COMPUTERS_DIRECTORY_PATH ||
                entry.fullPath.indexOf(COMPUTERS_DIRECTORY_PATH + '/') === 0) {
                if (entry.fullPath === COMPUTERS_DIRECTORY_PATH) {
                    rootType = RootType.COMPUTERS_GRAND_ROOT;
                    isReadOnly = true;
                    isRootEntry = true;
                }
                else {
                    rootType = RootType.COMPUTER;
                    if (isComputersRoot(entry)) {
                        isReadOnly = true;
                        isRootEntry = true;
                    }
                    else {
                        // Regular files/directories under a Computer entry.
                        isRootEntry = false;
                        isReadOnly = volumeInfo.isReadOnly;
                    }
                }
            }
            else if (entry.fullPath === '/.files-by-id' ||
                entry.fullPath.indexOf('/.files-by-id/') === 0) {
                rootType = RootType.DRIVE_SHARED_WITH_ME;
                // /.files-by-id/<id> is read-only, but /.files-by-id/<id>/foo is
                // read-write.
                isReadOnly = entry.fullPath.split('/').length < 4;
                isRootEntry = entry.fullPath === '/.files-by-id';
            }
            else if (entry.fullPath === '/.shortcut-targets-by-id' ||
                entry.fullPath.indexOf('/.shortcut-targets-by-id/') === 0) {
                rootType = RootType.DRIVE_SHARED_WITH_ME;
                // /.shortcut-targets-by-id/<id> is read-only, but
                // /.shortcut-targets-by-id/<id>/foo is read-write.
                isReadOnly = entry.fullPath.split('/').length < 4;
                isRootEntry = entry.fullPath === '/.shortcut-targets-by-id';
            }
            else if (entry.fullPath === '/.Trash-1000' ||
                entry.fullPath.indexOf('/.Trash-1000/') === 0) {
                // Drive uses "$topdir/.Trash-$uid" as the trash dir as per XDG spec.
                // User chronos is always uid 1000.
                rootType = RootType.TRASH;
                isReadOnly = false;
                isRootEntry = entry.fullPath === '/.Trash-1000';
            }
            else {
                // Accessing Drive files outside of /drive/root and /drive/other is not
                // allowed, but can happen. Therefore returning null.
                return null;
            }
        }
        else {
            assert$1(volumeInfo.volumeType);
            rootType = getRootTypeFromVolumeType(volumeInfo.volumeType);
            isRootEntry = isSameEntry(entry, volumeInfo.fileSystem.root);
            // Although "Play files" root directory is writable in file system level,
            // we prohibit write operations on it in the UI level to avoid confusion.
            // Users can still have write access in sub directories like
            // /Play files/Pictures, /Play files/DCIM, etc...
            if (volumeInfo.volumeType === VolumeType.ANDROID_FILES && isRootEntry) {
                isReadOnly = true;
            }
            else {
                isReadOnly = volumeInfo.isReadOnly;
            }
        }
        return new EntryLocation(volumeInfo, rootType, isRootEntry, isReadOnly);
    }
    /**
     * Searches the information of the volume that exists on the given device
     * path.
     * @param devicePath Path of the device to search.
     * @return The volume's information, or null if not found.
     */
    findByDevicePath(devicePath) {
        for (let i = 0; i < this.volumeInfoList.length; i++) {
            const volumeInfo = this.volumeInfoList.item(i);
            if (volumeInfo.devicePath && volumeInfo.devicePath === devicePath) {
                return volumeInfo;
            }
        }
        return null;
    }
    /**
     * Returns a promise that will be resolved when volume info, identified by
     * `volumeId` is created.
     * @return Resolved with the `VolumeInfo`. It won't resolve if the volume is
     *     never mounted.
     */
    whenVolumeInfoReady(volumeId) {
        return new Promise((fulfill) => {
            const handler = () => {
                const index = this.volumeInfoList.findIndex(volumeId);
                if (index !== -1) {
                    fulfill(this.volumeInfoList.item(index));
                    this.volumeInfoList.removeEventListener('splice', handler);
                }
            };
            this.volumeInfoList.addEventListener('splice', handler);
            handler();
        });
    }
    /**
     * Obtains the default display root entry.
     * @returns Default display root promise, fulfilled when resolved
     *     successfully.
     */
    async getDefaultDisplayRoot() {
        console.warn('Unexpected call to VolumeManager.getDefaultDisplayRoot');
        return null;
    }
    /**
     * @param key Key produced by |makeRequestKey_|.
     * @return Fulfilled on success, otherwise rejected with a
     *     VolumeError.
     */
    startRequest_(key) {
        return new Promise((successCallback, errorCallback) => {
            if (key in this.requests_) {
                const request = this.requests_[key];
                request.successCallbacks.push(successCallback);
                request.errorCallbacks.push(errorCallback);
            }
            else {
                this.requests_[key] = {
                    successCallbacks: [successCallback],
                    errorCallbacks: [errorCallback],
                    timeout: setTimeout(this.onTimeout_.bind(this, key), TIMEOUT),
                };
            }
        });
    }
    /**
     * Called if no response received in |TIMEOUT|.
     * @param key Key produced by |makeRequestKey_|.
     */
    onTimeout_(key) {
        this.invokeRequestCallbacks_(this.requests_[key], VolumeError.TIMEOUT);
        delete this.requests_[key];
    }
    /**
     * @param key Key produced by |makeRequestKey_|.
     * @param status Status received from the API.
     * @param volumeInfo Volume info of the mounted volume.
     */
    finishRequest_(key, status, volumeInfo) {
        const request = this.requests_[key];
        if (!request) {
            return;
        }
        clearTimeout(request.timeout);
        this.invokeRequestCallbacks_(request, status, volumeInfo);
        delete this.requests_[key];
    }
    /**
     * @param request Structure created in |startRequest_|.
     * @param status If status === 'success' success callbacks are called.
     * @param volumeInfo Volume info of the mounted volume.
     */
    invokeRequestCallbacks_(request, status, volumeInfo) {
        if (status === VolumeError.SUCCESS) {
            request.successCallbacks.map(cb => cb(volumeInfo));
        }
        else {
            validateError(status);
            request.errorCallbacks.map(cb => cb(status));
        }
    }
    /**
     * Checks if any volumes are disabled for selection.
     * See overridden implementation in `FilteredVolumeManager`.
     */
    hasDisabledVolumes() {
        return false;
    }
    /**
     * Checks whether the given volume is disabled for selection.
     * See overridden implementation in `FilteredVolumeManager`.
     * @param volume Volume to check.
     */
    isDisabled(_volume) {
        return false;
    }
    /**
     * Checks if a volume is allowed.
     * See overridden implementation in `FilteredVolumeManager`.
     */
    isAllowedVolume(_volumeInfo) {
        return true;
    }
}

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const volumeManagerFactory = (() => {
    /**
     * The singleton instance of VolumeManager. Initialized by the first
     * invocation of getInstance().
     */
    let instance = null;
    let instanceInitialized = null;
    /**
     * Returns the VolumeManager instance asynchronously. If it has not been
     * created or is under initialization, it will waits for the finish of the
     * initialization.
     */
    async function getInstance() {
        if (!instance) {
            instance = new VolumeManager();
            instanceInitialized = instance.initialize();
        }
        await instanceInitialized;
        return instance;
    }
    /**
     * Returns instance of VolumeManager for debug purpose.
     * This method returns VolumeManager.instance which may not be initialized.
     *
     */
    function getInstanceForDebug() {
        return instance;
    }
    /**
     * Revokes the singleton instance for testing.
     */
    function revokeInstanceForTesting() {
        instanceInitialized = null;
        instance = null;
    }
    return {
        getInstance: getInstance,
        getInstanceForDebug: getInstanceForDebug,
        revokeInstanceForTesting: revokeInstanceForTesting,
    };
})();

// Copyright 2012 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * Root class of the former background page.
 */
class FileManagerBase {
    constructor() {
        this.fileOperationHandler_ = null;
        /**
         * Map of all currently open file dialogs. The key is an app ID.
         */
        this.dialogs = {};
        /**
         * Progress center of the background page.
         */
        this.progressCenter = new ProgressCenter();
        /**
         * Drive sync handler.
         */
        this.driveSyncHandler = new DriveSyncHandlerImpl(this.progressCenter);
        this.crostini = new Crostini();
        /**
         * String assets.
         */
        this.stringData = null;
        /**
         * Initializes the strings. This needs for the volume manager.
         */
        this.initializationPromise_ = new Promise((fulfill) => {
            chrome.fileManagerPrivate.getStrings(stringData => {
                if (chrome.runtime.lastError) {
                    console.error(chrome.runtime.lastError.message);
                    return;
                }
                if (!loadTimeData.isInitialized()) {
                    loadTimeData.data = assert$1(stringData);
                }
                fulfill(stringData);
            });
        });
        this.initializationPromise_.then(strings => {
            this.stringData = strings;
            this.crostini.initEnabled();
            volumeManagerFactory.getInstance().then(volumeManager => {
                volumeManager.addEventListener(VOLUME_ALREADY_MOUNTED, this.handleViewEvent_.bind(this));
                this.crostini.initVolumeManager(volumeManager);
            });
            this.fileOperationHandler_ =
                new FileOperationHandler(this.progressCenter);
        });
        // Handle newly mounted FSP file systems. Workaround for crbug.com/456648.
        // TODO(mtomasz): Replace this hack with a proper solution.
        chrome.fileManagerPrivate.onMountCompleted.addListener(this.onMountCompleted_.bind(this));
    }
    async getVolumeManager() {
        return volumeManagerFactory.getInstance();
    }
    async ready() {
        await this.initializationPromise_;
    }
    /**
     * Registers dialog window to the background page.
     *
     * @param dialogWindow Window of the dialog.
     */
    registerDialog(dialogWindow) {
        const id = DIALOG_ID_PREFIX + (nextFileManagerDialogID++);
        this.dialogs[id] = dialogWindow;
        if (window.IN_TEST) {
            dialogWindow.IN_TEST = true;
        }
        dialogWindow.addEventListener('pagehide', () => {
            delete this.dialogs[id];
        });
    }
    /**
     * Launches a new File Manager window.
     *
     * @param appState App state.
     * @return Resolved when the new window is opened.
     */
    async launchFileManager(appState = {}) {
        await this.initializationPromise_;
        const appWindow = new AppWindowWrapper();
        return appWindow.launch(appState || {});
    }
    /**
     * Opens the volume root (or opt directoryPath) in main UI.
     *
     * @param event An event with the volumeId or
     *     devicePath.
     */
    async handleViewEvent_(event) {
        const isPrimaryContext = await isInGuestMode();
        if (isPrimaryContext) {
            this.handleViewEventInternal_(event);
        }
    }
    /**
     * @param event An event with the volumeId.
     */
    async handleViewEventInternal_(event) {
        await volumeManagerFactory.getInstance();
        this.navigateToVolumeInFocusedWindowWhenReady_(event.detail.volumeId);
    }
    /**
     * Retrieves the root file entry of the volume on the requested device.
     *
     * @param volumeId ID of the volume to navigate to.
     */
    async retrieveVolumeInfo_(volumeId) {
        const volumeManager = await volumeManagerFactory.getInstance();
        try {
            return await volumeManager.whenVolumeInfoReady(volumeId);
        }
        catch (e) {
            console.warn('Unable to find volume for id: ' + volumeId +
                '. Error: ' + e.message);
        }
    }
    /**
     * Opens the volume root (or opt directoryPath) in main UI.
     *
     * @param volumeId ID of the volume to navigate to.
     * @param directoryPath Optional path to be opened.
     */
    async navigateToVolumeWhenReady_(volumeId, directoryPath) {
        const volume = await this.retrieveVolumeInfo_(volumeId);
        if (volume) {
            this.navigateToVolumeRoot_(volume, directoryPath);
        }
    }
    /**
     * Opens the volume root (or opt directoryPath) in the main UI of the focused
     * window.
     *
     * @param volumeId ID of the volume to navigate to.
     * @param directoryPath Optional path to be opened.
     */
    async navigateToVolumeInFocusedWindowWhenReady_(volumeId, directoryPath) {
        const volume = await this.retrieveVolumeInfo_(volumeId);
        if (volume) {
            this.navigateToVolumeInFocusedWindow_(volume, directoryPath);
        }
    }
    /**
     * If a path was specified, retrieve that directory entry,
     * otherwise return the root entry of the volume.
     *
     * @param directoryPath Optional directory path to be opened.
     */
    async retrieveEntryInVolume_(volume, directoryPath) {
        const root = await volume.resolveDisplayRoot();
        if (directoryPath) {
            return getDirectory(root, directoryPath, { create: false });
        }
        return root;
    }
    /**
     * Opens the volume root (or opt directoryPath) in main UI.
     *
     * @param directoryPath Optional directory path to be opened.
     */
    async navigateToVolumeRoot_(volume, directoryPath) {
        const directory = await this.retrieveEntryInVolume_(volume, directoryPath);
        /**
         * Launches app opened on {@code directory}.
         */
        this.launchFileManager({ currentDirectoryURL: directory.toURL() });
    }
    /**
     * Opens the volume root (or opt directoryPath) in main UI of the focused
     * window.
     *
     * @param directoryPath Optional directory path to be opened.
     */
    async navigateToVolumeInFocusedWindow_(volume, directoryPath) {
        const directoryEntry = await this.retrieveEntryInVolume_(volume, directoryPath);
        if (directoryEntry) {
            const volumeManager = await volumeManagerFactory.getInstance();
            volumeManager.dispatchEvent(new CustomEvent(ARCHIVE_OPENED_EVENT_TYPE, { detail: { mountPoint: directoryEntry } }));
        }
    }
    /**
     * Handles mounted FSP volumes and fires the Files app. This is a quick fix
     * for crbug.com/456648.
     * @param event Event details.
     */
    async onMountCompleted_(event) {
        const isPrimaryContext = await isInGuestMode();
        if (isPrimaryContext) {
            this.onMountCompletedInternal_(event);
        }
    }
    /**
     * @param event Event details.
     */
    onMountCompletedInternal_(event) {
        const statusOK = event.status === chrome.fileManagerPrivate.MountError.SUCCESS ||
            event.status ===
                chrome.fileManagerPrivate.MountError.PATH_ALREADY_MOUNTED;
        const volumeTypeOK = event.volumeMetadata.volumeType === VolumeType.PROVIDED &&
            event.volumeMetadata.source === Source.FILE;
        if (event.eventType === 'mount' && statusOK &&
            event.volumeMetadata.mountContext === 'user' && volumeTypeOK) {
            this.navigateToVolumeWhenReady_(event.volumeMetadata.volumeId);
        }
    }
}
/**
 * Prefix for the dialog ID.
 */
const DIALOG_ID_PREFIX = 'dialog#';
/**
 * Value of the next file manager dialog ID.
 */
let nextFileManagerDialogID = 0;
/**
 * Singleton instance of Background object.
 */
const background = new FileManagerBase();
window.background = background;
/**
 * End recording of the background page Load.BackgroundScript metric.
 */
recordInterval('Load.BackgroundScript');

// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
// Trusted script URLs used by the Files app.
const ALLOWED_SCRIPT_URLS = new Set([
    'foreground/js/main.js',
    'background/js/runtime_loaded_test_util.js',
    'foreground/js/deferred_elements.js',
    'foreground/js/metadata/metadata_dispatcher.js',
]);
if (!window.hasOwnProperty('trustedScriptUrlPolicy_')) {
    assert$1(window.trustedTypes);
    window.trustedScriptUrlPolicy_ =
        window.trustedTypes.createPolicy('file-manager-trusted-script', {
            createScriptURL: (url) => {
                if (!ALLOWED_SCRIPT_URLS.has(url)) {
                    throw new Error('Script URL not allowed: ' + url);
                }
                return url;
            },
            createHTML: () => assertNotReached$1(),
            createScript: () => assertNotReached$1(),
        });
}
/**
 * Create a TrustedTypes script URL policy from a list of allowed sources, and
 * return a sanitized script URL using this policy.
 *
 * @param url Script URL to be sanitized.
 */
function getSanitizedScriptUrl(url) {
    assert$1(window.trustedScriptUrlPolicy_);
    return window.trustedScriptUrlPolicy_.createScriptURL(url);
}

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * Used to load scripts at a runtime. Typical use:
 *
 * await new ScriptLoader('its_time.js').load();
 *
 * Optional parameters may be also specified:
 *
 * await new ScriptLoader('its_time.js', {type: 'module'}).load();
 */
class ScriptLoader {
    /**
     * Creates a loader that loads the script specified by |src| once the load
     * method is called. Optional |params| can specify other script attributes.
     */
    constructor(src_, params = {}) {
        this.src_ = src_;
        this.type_ = params.type;
        this.defer_ = params.defer;
    }
    async load() {
        return new Promise((resolve, reject) => {
            const script = document.createElement('script');
            if (this.type_ !== undefined) {
                script.type = this.type_;
            }
            if (this.defer_ !== undefined) {
                script.defer = this.defer_;
            }
            script.onload = () => resolve(this.src_);
            script.onerror = (error) => reject(error);
            script.src = getSanitizedScriptUrl(this.src_);
            document.head.append(script);
        });
    }
}

// Copyright 2015 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * Namespace for test related things.
 */
window.test = window.test || {};
const test = window.test;
/**
 * Namespace for test utility functions.
 *
 * Public functions in the test.util.sync and the test.util.async namespaces are
 * published to test cases and can be called by using callRemoteTestUtil. The
 * arguments are serialized as JSON internally. If application ID is passed to
 * callRemoteTestUtil, the content window of the application is added as the
 * first argument. The functions in the test.util.async namespace are passed the
 * callback function as the last argument.
 */
test.util = {};
/**
 * Namespace for synchronous utility functions.
 */
test.util.sync = {};
/**
 * Namespace for asynchronous utility functions.
 */
test.util.async = {};

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * Sanitizes the formatted date. Replaces unusual space with normal space.
 * @param strDate the date already in the string format.
 */
function sanitizeDate(strDate) {
    return strDate.replace('\u202f', ' ');
}
/**
 * Returns details about each file shown in the file list: name, size, type and
 * modification time.
 *
 * Since FilesApp normally has a fixed display size in test, and also since the
 * #detail-table recycles its file row elements, this call only returns details
 * about the visible file rows (11 rows normally, see crbug.com/850834).
 *
 * @param contentWindow Window to be tested.
 * @return Details for each visible file row.
 */
test.util.sync.getFileList = (contentWindow) => {
    const table = contentWindow.document.querySelector('#detail-table');
    const rows = table.querySelectorAll('li');
    const fileList = [];
    for (const row of rows) {
        fileList.push([
            row.querySelector('.filename-label')?.textContent ?? '',
            row.querySelector('.size')?.textContent ?? '',
            row.querySelector('.type')?.textContent ?? '',
            sanitizeDate(row.querySelector('.date')?.textContent || ''),
        ]);
    }
    return fileList;
};
/**
 * Returns the name of the files currently selected in the file list. Note the
 * routine has the same 'visible files' limitation as getFileList() above.
 *
 * @param contentWindow Window to be tested.
 * @return Selected file names.
 */
test.util.sync.getSelectedFiles = (contentWindow) => {
    const table = contentWindow.document.querySelector('#detail-table');
    const rows = table.querySelectorAll('li');
    const selected = [];
    for (const row of rows) {
        if (row.hasAttribute('selected')) {
            selected.push(row.querySelector('.filename-label')?.textContent ?? '');
        }
    }
    return selected;
};
/**
 * Fakes pressing the down arrow until the given |filename| is selected.
 *
 * @param contentWindow Window to be tested.
 * @param filename Name of the file to be selected.
 * @return True if file got selected, false otherwise.
 */
test.util.sync.selectFile =
    (contentWindow, filename) => {
        const rows = contentWindow.document.querySelectorAll('#detail-table li');
        test.util.sync.focus(contentWindow, '#file-list');
        test.util.sync.fakeKeyDown(contentWindow, '#file-list', 'Home', false, false, false);
        for (let index = 0; index < rows.length; ++index) {
            const selection = test.util.sync.getSelectedFiles(contentWindow);
            if (selection.length === 1 && selection[0] === filename) {
                return true;
            }
            test.util.sync.fakeKeyDown(contentWindow, '#file-list', 'ArrowDown', false, false, false);
        }
        console.warn('Failed to select file "' + filename + '"');
        return false;
    };
/**
 * Open the file by selectFile and fakeMouseDoubleClick.
 *
 * @param contentWindow Window to be tested.
 * @param filename Name of the file to be opened.
 * @return True if file got selected and a double click message is
 *     sent, false otherwise.
 */
test.util.sync.openFile =
    (contentWindow, filename) => {
        const query = '#file-list li.table-row[selected] .filename-label span';
        return test.util.sync.selectFile(contentWindow, filename) &&
            test.util.sync.fakeMouseDoubleClick(contentWindow, query);
    };
/**
 * Returns the last URL visited with visitURL() (e.g. for "Manage in Drive").
 *
 * @param contentWindow The window where visitURL() was called.
 * @return The URL of the last URL visited.
 */
test.util.sync.getLastVisitedURL = (contentWindow) => {
    return contentWindow.fileManager.getLastVisitedUrl();
};
/**
 * Returns a string translation from its translation ID.
 * @param id The id of the translated string.
 */
test.util.sync.getTranslatedString =
    (contentWindow, id) => {
        return contentWindow.fileManager.getTranslatedString(id);
    };
/**
 * Executes Javascript code on a webview and returns the result.
 *
 * @param contentWindow Window to be tested.
 * @param webViewQuery Selector for the web view.
 * @param code Javascript code to be executed within the web view.
 * @param callback Callback function with results returned by the script.
 */
test.util.async.executeScriptInWebView =
    (contentWindow, webViewQuery, code, callback) => {
        const webView = contentWindow.document.querySelector(webViewQuery);
        webView.executeScript({ code: code }, callback);
    };
/**
 * Selects |filename| and fakes pressing Ctrl+C, Ctrl+V (copy, paste).
 *
 * @param contentWindow Window to be tested.
 * @param filename Name of the file to be copied.
 * @return True if copying got simulated successfully. It does not
 *     say if the file got copied, or not.
 */
test.util.sync.copyFile =
    (contentWindow, filename) => {
        if (!test.util.sync.selectFile(contentWindow, filename)) {
            return false;
        }
        // Ctrl+C and Ctrl+V
        test.util.sync.fakeKeyDown(contentWindow, '#file-list', 'c', true, false, false);
        test.util.sync.fakeKeyDown(contentWindow, '#file-list', 'v', true, false, false);
        return true;
    };
/**
 * Selects |filename| and fakes pressing the Delete key.
 *
 * @param contentWindow Window to be tested.
 * @param filename Name of the file to be deleted.
 * @return True if deleting got simulated successfully. It does not
 *     say if the file got deleted, or not.
 */
test.util.sync.deleteFile =
    (contentWindow, filename) => {
        if (!test.util.sync.selectFile(contentWindow, filename)) {
            return false;
        }
        // Delete
        test.util.sync.fakeKeyDown(contentWindow, '#file-list', 'Delete', false, false, false);
        return true;
    };
/**
 * Execute a command on the document in the specified window.
 *
 * @param contentWindow Window to be tested.
 * @param command Command name.
 * @return True if the command is executed successfully.
 */
test.util.sync.execCommand =
    (contentWindow, command) => {
        const ret = contentWindow.document.execCommand(command);
        if (!ret) {
            // TODO(b/191831968): Fix execCommand for SWA.
            console.warn(`execCommand(${command}) returned false for SWA, forcing ` +
                `return value to true. b/191831968`);
            return true;
        }
        return ret;
    };
/**
 * Override the task-related methods in private api for test.
 *
 * @param contentWindow Window to be tested.
 * @param taskList List of tasks to be returned in
 *     fileManagerPrivate.getFileTasks().
 * @param isPolicyDefault Whether the default is set by policy.
 * @return Always return true.
 */
test.util.sync.overrideTasks =
    (contentWindow, taskList, isPolicyDefault = false) => {
        const getFileTasks = (_entries, _sourceUrls, onTasks) => {
            // Call onTask asynchronously (same with original getFileTasks).
            setTimeout(() => {
                const policyDefaultHandlerStatus = isPolicyDefault ?
                    chrome.fileManagerPrivate.PolicyDefaultHandlerStatus
                        .DEFAULT_HANDLER_ASSIGNED_BY_POLICY :
                    undefined;
                onTasks({ tasks: taskList, policyDefaultHandlerStatus });
            }, 0);
        };
        const executeTask = (descriptor, entries, callback) => {
            executedTasks.push({ descriptor, entries, callback });
        };
        const setDefaultTask = (descriptor) => {
            for (const task of taskList) {
                task.isDefault = descriptorEqual(task.descriptor, descriptor);
            }
        };
        executedTasks = [];
        contentWindow.chrome.fileManagerPrivate.getFileTasks = getFileTasks;
        contentWindow.chrome.fileManagerPrivate.executeTask = executeTask;
        contentWindow.chrome.fileManagerPrivate.setDefaultTask = setDefaultTask;
        return true;
    };
/**
 * Obtains the list of executed tasks.
 */
test.util.sync.getExecutedTasks = (_contentWindow) => {
    if (!executedTasks) {
        console.error('Please call overrideTasks() first.');
        return null;
    }
    return executedTasks.map((task) => {
        return {
            descriptor: task.descriptor,
            fileNames: task.entries.map(e => e.name),
        };
    });
};
/**
 * Obtains the list of executed tasks.
 * @param _contentWindow Window to be tested.
 * @param descriptor the task to *     check.
 * @param fileNames Name of files that should have been passed to the
 *     executeTasks().
 * @return True if the task was executed.
 */
test.util.sync.taskWasExecuted =
    (_contentWindow, descriptor, fileNames) => {
        if (!executedTasks) {
            console.error('Please call overrideTasks() first.');
            return null;
        }
        const fileNamesStr = JSON.stringify(fileNames);
        const task = executedTasks.find((task) => descriptorEqual(task.descriptor, descriptor) &&
            fileNamesStr === JSON.stringify(task.entries.map(e => e.name)));
        return task !== undefined;
    };
let executedTasks = null;
/**
 * Invokes an executed task with |responseArgs|.
 * @param _contentWindow Window to be tested.
 * @param descriptor the task to be replied to.
 * @param responseArgs the arguments to invoke the callback with.
 */
test.util.sync.replyExecutedTask =
    (_contentWindow, descriptor, responseArgs) => {
        if (!executedTasks) {
            console.error('Please call overrideTasks() first.');
            return false;
        }
        const found = executedTasks.find((task) => descriptorEqual(task.descriptor, descriptor));
        if (!found) {
            const { appId, taskType, actionId } = descriptor;
            console.error(`No task with id ${appId}|${taskType}|${actionId}`);
            return false;
        }
        found.callback(...responseArgs);
        return true;
    };
/**
 * Calls the unload handler for the window.
 * @param contentWindow Window to be tested.
 */
test.util.sync.unload = (contentWindow) => {
    contentWindow.fileManager.onUnloadForTest();
};
/**
 * Returns the path shown in the breadcrumb.
 *
 * @param contentWindow Window to be tested.
 * @return The breadcrumb path.
 */
test.util.sync.getBreadcrumbPath = (contentWindow) => {
    const doc = contentWindow.document;
    const breadcrumb = doc.querySelector('#location-breadcrumbs xf-breadcrumb');
    if (!breadcrumb) {
        return '';
    }
    return '/' + breadcrumb.path;
};
/**
 * Obtains the preferences.
 * @param callback Callback function with results returned by the script.
 */
test.util.async.getPreferences = (callback) => {
    chrome.fileManagerPrivate.getPreferences(callback);
};
/**
 * Stubs out the formatVolume() function in fileManagerPrivate.
 *
 * @param contentWindow Window to be affected.
 */
test.util.sync.overrideFormat = (contentWindow) => {
    contentWindow.chrome.fileManagerPrivate.formatVolume =
        (_volumeId, _filesystem, _volumeLabel) => { };
    return true;
};
/**
 * Run a contentWindow.requestAnimationFrame() cycle and resolve the
 * callback when that requestAnimationFrame completes.
 * @param contentWindow Window to be tested.
 * @param callback Completion callback.
 */
test.util.async.requestAnimationFrame =
    (contentWindow, callback) => {
        contentWindow.requestAnimationFrame(() => {
            callback(true);
        });
    };
/**
 * Set the window text direction to RTL and wait for the window to redraw.
 * @param contentWindow Window to be tested.
 * @param callback Completion callback.
 */
test.util.async.renderWindowTextDirectionRTL =
    (contentWindow, callback) => {
        contentWindow.document.documentElement.setAttribute('dir', 'rtl');
        contentWindow.document.body.setAttribute('dir', 'rtl');
        contentWindow.requestAnimationFrame(() => {
            callback(true);
        });
    };
/**
 * Map the appId to a map of all fakes applied in the foreground window e.g.:
 *  {'files#0': {'chrome.bla.api': FAKE}
 */
const foregroundReplacedObjects = {};
/**
 * A factory that returns a fake (aka function) that returns a static value.
 * Used to force a callback-based API to return always the same value.
 */
function staticFakeFactory(attrName, staticValue) {
    return (...args) => {
        // This code is executed when the production code calls the function that
        // has been replaced by the test.
        // `args` is the arguments provided by the production code.
        setTimeout(() => {
            // Find the first callback.
            for (const arg of args) {
                if (typeof arg === 'function') {
                    console.warn(`staticFake for ${attrName} value: ${staticValue}`);
                    return arg(staticValue);
                }
            }
            throw new Error(`Couldn't find callback for ${attrName}`);
        }, 0);
    };
}
/**
 * A factory that returns an async function (aka a Promise) that returns a
 * static value. Used to force a promise-based API to return always the same
 * value.
 */
function staticPromiseFakeFactory(attrName, staticValue) {
    return async (..._args) => {
        // This code is executed when the production code calls the function that
        // has been replaced by the test.
        // `args` is the arguments provided by the production code.
        console.warn(`staticPromiseFake for "${attrName}" returning value: ${staticValue}`);
        return staticValue;
    };
}
/**
 * Registry of available fakes, it maps the an string ID to a factory
 * function which returns the actual fake used to replace an implementation.
 *
 */
const fakes = {
    'static_fake': staticFakeFactory,
    'static_promise_fake': staticPromiseFakeFactory,
};
/**
 * Class holds the information for applying and restoring fakes.
 */
class PrepareFake {
    /**
     * @param attrName Name of the attribute to be replaced by the fake
     *   e.g.: "chrome.app.window.create".
     * @param fakeId The name of the fake to be used from `fakes_`.
     * @param context The context where the attribute will be traversed from,
     *   e.g.: Window object.
     * @param args Additional args provided from the integration test to the fake,
     *     e.g.: static return value.
     */
    constructor(attrName_, fakeId_, context_, ...args) {
        this.attrName_ = attrName_;
        this.fakeId_ = fakeId_;
        this.context_ = context_;
        /**
         * The instance of the fake to be used, ready to be used.
         */
        this.fake_ = null;
        /**
         * After traversing |context_| the object that holds the attribute to be
         * replaced by the fake.
         */
        this.parentObject_ = null;
        /**
         * After traversing |context_| the attribute name in |parentObject_| that
         * will be replaced by the fake.
         */
        this.leafAttrName_ = '';
        /**
         * Original object that was replaced by the fake.
         */
        this.original_ = null;
        /**
         * If this fake object has been constructed and everything initialized.
         */
        this.prepared_ = false;
        /**
         * Counter to record the number of times the static fake is called.
         */
        this.callCounter = 0;
        /**
         * List to record the arguments provided to the static fake calls.
         */
        this.calledArgs = [];
        this.args_ = args;
    }
    /**
     * Initializes the fake and traverse |context_| to be ready to replace the
     * original implementation with the fake.
     */
    prepare() {
        this.buildFake_();
        this.traverseContext_();
        this.prepared_ = true;
    }
    /**
     * Replaces the original implementation with the fake.
     * NOTE: It requires prepare() to have been called.
     * @param contentWindow Window to be tested.
     */
    replace(contentWindow) {
        const suffix = `for ${this.attrName_} ${this.fakeId_}`;
        if (!this.prepared_) {
            throw new Error(`PrepareFake prepare() not called ${suffix}`);
        }
        if (!this.parentObject_) {
            throw new Error(`Missing parentObject_ ${suffix}`);
        }
        if (!this.fake_) {
            throw new Error(`Missing fake_ ${suffix}`);
        }
        if (!this.leafAttrName_) {
            throw new Error(`Missing leafAttrName_ ${suffix}`);
        }
        this.saveOriginal_(contentWindow);
        this.parentObject_[this.leafAttrName_] = async (...args) => {
            const result = await this.fake_(...args);
            this.callCounter++;
            this.calledArgs.push([...args]);
            return result;
        };
    }
    /**
     * Restores the original implementation that had been previously replaced by
     * the fake.
     */
    restore() {
        if (!this.original_) {
            return;
        }
        this.parentObject_[this.leafAttrName_] = this.original_;
        this.original_ = null;
    }
    /**
     * Saves the original implementation to be able restore it later.
     * @param contentWindow Window to be tested.
     */
    saveOriginal_(contentWindow) {
        const windowFakes = foregroundReplacedObjects[contentWindow.appID] || {};
        foregroundReplacedObjects[contentWindow.appID] = windowFakes;
        // Only save once, otherwise it can save an object that is already fake.
        if (!windowFakes[this.attrName_]) {
            if (!this.parentObject_) {
                console.error(`Failed to find the fake context: ${this.attrName_}`);
                return;
            }
            const original = this.parentObject_[this.leafAttrName_];
            this.original_ = original;
            windowFakes[this.attrName_] = this;
        }
        return;
    }
    /**
     * Constructs the fake.
     */
    buildFake_() {
        const factory = fakes[this.fakeId_];
        if (!factory) {
            throw new Error(`Failed to find the fake factory for ${this.fakeId_}`);
        }
        this.fake_ = factory(this.attrName_, ...this.args_);
    }
    /**
     * Finds the parent and the object to be replaced by fake.
     */
    traverseContext_() {
        let target = this.context_;
        let parentObj = null;
        let attr = '';
        for (const a of this.attrName_.split('.')) {
            attr = a;
            parentObj = target;
            target = target[a];
            if (target === undefined) {
                throw new Error(`Couldn't find "${0}" from "${this.attrName_}"`);
            }
        }
        this.parentObject_ = parentObj;
        this.leafAttrName_ = attr;
    }
}
/**
 * Replaces implementations in the foreground page with fakes.
 *
 * @param contentWindow Window to be tested.
 * @param fakeData An object mapping the path to the
 * object to be replaced and the value is the Array with fake id and
 * additional arguments for the fake constructor, e.g.: fakeData = {
 *     'chrome.app.window.create' : [
 *       'static_fake',
 *       ['some static value', 'other arg'],
 *     ]
 *   }
 *
 *  This will replace the API 'chrome.app.window.create' with a static fake,
 *  providing the additional data to static fake: ['some static value',
 * 'other value'].
 */
test.util.sync.foregroundFake =
    (contentWindow, fakeData) => {
        const entries = Object.entries(fakeData);
        for (const [path, mockValue] of entries) {
            const fakeId = mockValue[0];
            const fakeArgs = mockValue[1] || [];
            const fake = new PrepareFake(path, fakeId, contentWindow, ...fakeArgs);
            fake.prepare();
            fake.replace(contentWindow);
        }
        return entries.length;
    };
/**
 * Removes all fakes that were applied to the foreground page.
 * @param contentWindow Window to be tested.
 */
test.util.sync.removeAllForegroundFakes = (contentWindow) => {
    const windowFakes = foregroundReplacedObjects[contentWindow.appID];
    if (!windowFakes) {
        console.error(`Failed to find the fakes for window ${contentWindow.appID}`);
        return 0;
    }
    const savedFakes = Object.entries(windowFakes);
    let removedCount = 0;
    for (const [_path, fake] of savedFakes) {
        fake.restore();
        removedCount++;
    }
    return removedCount;
};
/**
 * Obtains the number of times the static fake api is called.
 * @param contentWindow Window to be tested.
 * @param fakedApi Path of the method that is faked.
 * @return Number of times the fake api called.
 */
test.util.sync.staticFakeCounter =
    (contentWindow, fakedApi) => {
        const windowFakes = foregroundReplacedObjects[contentWindow.appID];
        if (!windowFakes) {
            console.error(`Failed to find the fakes for window ${contentWindow.appID}`);
            return -1;
        }
        const fake = windowFakes[fakedApi];
        return fake?.callCounter ?? -1;
    };
/**
 * Obtains the list of arguments with which the static fake api was called.
 * @param contentWindow Window to be tested.
 * @param fakedApi Path of the method that is faked.
 * @return An array with all calls to this fake, each item
 *     is an array with all args passed in when the fake was called.
 */
test.util.sync.staticFakeCalledArgs =
    (contentWindow, fakedApi) => {
        const fake = foregroundReplacedObjects[contentWindow.appID][fakedApi];
        return fake.calledArgs;
    };
/**
 * Send progress item to Foreground page to display.
 * @param id Progress item id.
 * @param type Type of progress item.
 * @param state State of the progress item.
 * @param message Message of the progress item.
 * @param remainingTime The remaining time of the progress in second.
 * @param progressMax Max value of the progress.
 * @param progressValue Current value of the progress.
 * @param count Number of items being processed.
 */
test.util.sync.sendProgressItem =
    (id, type, state, message, remainingTime, progressMax = 1, progressValue = 0, count = 1) => {
        const item = new ProgressCenterItem();
        item.id = id;
        item.type = type;
        item.state = state;
        item.message = message;
        item.remainingTime = remainingTime;
        item.progressMax = progressMax;
        item.progressValue = progressValue;
        item.itemCount = count;
        window.background.progressCenter.updateItem(item);
        return true;
    };
/**
 * Remote call API handler. This function handles messages coming from the
 * test harness to execute known functions and return results. This is a
 * dummy implementation that is replaced by a real one once the test harness
 * is fully loaded.
 */
test.util.executeTestMessage =
    (_request, _callback) => {
        throw new Error('executeTestMessage not implemented');
    };
/**
 * Handles a direct call from the integration test harness. We execute
 * swaTestMessageListener call directly from the FileManagerBrowserTest.
 * This method avoids enabling external callers to Files SWA. We forward
 * the response back to the caller, as a serialized JSON string.
 */
test.swaTestMessageListener = (request) => {
    request.contentWindow = window;
    return new Promise(resolve => {
        test.util.executeTestMessage(request, (response) => {
            response = response === undefined ? '@undefined@' : response;
            resolve(JSON.stringify(response));
        });
    });
};
let testUtilsLoaded = null;
test.swaLoadTestUtils = async () => {
    const scriptUrl = 'background/js/runtime_loaded_test_util.js';
    try {
        if (!testUtilsLoaded) {
            console.info('Loading ' + scriptUrl);
            testUtilsLoaded = new ScriptLoader(scriptUrl, { type: 'module' }).load();
        }
        await testUtilsLoaded;
        console.info('Loaded ' + scriptUrl);
        return true;
    }
    catch (error) {
        testUtilsLoaded = null;
        return false;
    }
};
test.getSwaAppId = async () => {
    if (!testUtilsLoaded) {
        await test.swaLoadTestUtils();
    }
    return String(window.appID);
};

// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview Element which controls pre- and post-jellybean migration UI.
 */
let XfJellybean = class XfJellybean extends XfBase {
    render() {
        if (isCrosComponentsEnabled()) {
            return html `
        <slot name="jelly">
          Jelly
        <slot>
      `;
        }
        return html `
      <slot name="old">
        Big Belly
      <slot>`;
    }
    firstUpdated() {
        // Jellybean status does not change during runtime. We can cleanup the
        // unused variant.
        const unusedElements = isCrosComponentsEnabled() ?
            this.querySelectorAll('[slot="old"]') :
            this.querySelectorAll('[slot="jelly"]');
        unusedElements.forEach((el) => el.remove());
    }
};
XfJellybean = __decorate([
    customElement('xf-jellybean')
], XfJellybean);

// ui/webui/resources/cr_components/color_change_listener/color_change_listener.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class PageHandlerPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'color_change_listener.mojom.PageHandler', scope);
    }
}
class PageHandlerRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PageHandlerPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    setPage(page) {
        this.proxy.sendMessage(0, PageHandler_SetPage_ParamsSpec.$, null, [
            page
        ], false);
    }
}
class PageHandler {
    static get $interfaceName() {
        return "color_change_listener.mojom.PageHandler";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new PageHandlerRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
class PagePendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'color_change_listener.mojom.Page', scope);
    }
}
class PageRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PagePendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onColorProviderChanged() {
        this.proxy.sendMessage(0, Page_OnColorProviderChanged_ParamsSpec.$, null, [], false);
    }
}
/**
 * An object which receives request messages for the Page
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
class PageCallbackRouter {
    helper_internal_;
    $;
    router_;
    onColorProviderChanged;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.onColorProviderChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, Page_OnColorProviderChanged_ParamsSpec.$, null, this.onColorProviderChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
const PageHandler_SetPage_ParamsSpec = { $: {} };
const Page_OnColorProviderChanged_ParamsSpec = { $: {} };
mojo.internal.Struct(PageHandler_SetPage_ParamsSpec.$, 'PageHandler_SetPage_Params', [
    mojo.internal.StructField('page', 0, 0, mojo.internal.InterfaceProxy(PageRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Page_OnColorProviderChanged_ParamsSpec.$, 'Page_OnColorProviderChanged_Params', [], [[0, 8],]);

// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview This file provides a singleton class that exposes the Mojo
 * handler interface used for one way communication between the JS and the
 * browser.
 * TODO(tluk): Convert this into typescript once all dependencies have been
 * fully migrated.
 */
let instance$1 = null;
class BrowserProxy {
    callbackRouter;
    constructor() {
        this.callbackRouter = new PageCallbackRouter();
        const pageHandlerRemote = PageHandler.getRemote();
        pageHandlerRemote.setPage(this.callbackRouter.$.bindNewPipeAndPassRemote());
    }
    static getInstance() {
        return instance$1 || (instance$1 = new BrowserProxy());
    }
    static setInstance(newInstance) {
        instance$1 = newInstance;
    }
}

// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview This file holds the functions that allow WebUI to update its
 * colors CSS stylesheet when a ColorProvider change in the browser is detected.
 */
/**
 * The CSS selector used to get the <link> node with the colors.css stylesheet.
 * The wildcard is needed since the URL ends with a timestamp.
 */
const COLORS_CSS_SELECTOR = 'link[href*=\'//theme/colors.css\']';
let documentInstance = null;
// 
// Event fired after updated colors have been fetched and applied.
const COLOR_PROVIDER_CHANGED = 'color-provider-changed';
// 
class ColorChangeUpdater {
    listenerId_ = null;
    root_;
    // 
    eventTarget = new EventTarget();
    // 
    constructor(root) {
        assert$1(documentInstance === null || root !== document);
        this.root_ = root;
    }
    /**
     * Starts listening for ColorProvider changes from the browser and updates the
     * `root_` whenever changes occur.
     */
    start() {
        if (this.listenerId_ !== null) {
            return;
        }
        this.listenerId_ = BrowserProxy.getInstance()
            .callbackRouter.onColorProviderChanged.addListener(this.onColorProviderChanged.bind(this));
    }
    // TODO(dpapad): Figure out how to properly trigger
    // `callbackRouter.onColorProviderChanged` listeners from tests and make this
    // method private.
    async onColorProviderChanged() {
        await this.refreshColorsCss();
        // 
        this.eventTarget.dispatchEvent(new CustomEvent(COLOR_PROVIDER_CHANGED));
        // 
    }
    /**
     * Forces `root_` to refresh its colors.css stylesheet. This is used to
     * fetch an updated stylesheet when the ColorProvider associated with the
     * WebUI has changed.
     * @return A promise which resolves to true once the new colors are loaded and
     *     installed into the DOM. In the case of an error returns false. When a
     *     new colors.css is loaded, this will always freshly query the existing
     *     colors.css, allowing multiple calls to successfully remove existing,
     *     outdated CSS.
     */
    async refreshColorsCss() {
        const colorCssNode = this.root_.querySelector(COLORS_CSS_SELECTOR);
        if (!colorCssNode) {
            return false;
        }
        const href = colorCssNode.getAttribute('href');
        if (!href) {
            return false;
        }
        const hrefURL = new URL(href, location.href);
        const params = new URLSearchParams(hrefURL.search);
        params.set('version', new Date().getTime().toString());
        const newHref = `${hrefURL.origin}${hrefURL.pathname}?${params.toString()}`;
        // A flickering effect may take place when setting the href property of
        // the existing color css node with a new value. In order to avoid
        // flickering, we create a new link element and once it is loaded we
        // remove the old one. See crbug.com/1365320 for additional details.
        const newColorsCssLink = document.createElement('link');
        newColorsCssLink.setAttribute('href', newHref);
        newColorsCssLink.rel = 'stylesheet';
        newColorsCssLink.type = 'text/css';
        const newColorsLoaded = new Promise(resolve => {
            newColorsCssLink.onload = resolve;
        });
        if (this.root_ === document) {
            document.getElementsByTagName('body')[0].appendChild(newColorsCssLink);
        }
        else {
            this.root_.appendChild(newColorsCssLink);
        }
        await newColorsLoaded;
        const oldColorCssNode = document.querySelector(COLORS_CSS_SELECTOR);
        if (oldColorCssNode) {
            oldColorCssNode.remove();
        }
        return true;
    }
    static forDocument() {
        return documentInstance ||
            (documentInstance = new ColorChangeUpdater(document));
    }
}

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function isModal(type) {
    return type === DialogType.SELECT_FOLDER ||
        type === DialogType.SELECT_UPLOAD_FOLDER ||
        type === DialogType.SELECT_SAVEAS_FILE ||
        type === DialogType.SELECT_OPEN_FILE ||
        type === DialogType.SELECT_OPEN_MULTI_FILE;
}
function isFolderDialogType(type) {
    return type === DialogType.SELECT_FOLDER ||
        type === DialogType.SELECT_UPLOAD_FOLDER;
}

// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * Implementation of VolumeInfoList for FilteredVolumeManager.
 * In foreground/ we want to enforce this list to be filtered, so we forbid
 * adding/removing/splicing of the list.
 * The inner list ownership is shared between FilteredVolumeInfoList and
 * FilteredVolumeManager to enforce these constraints.
 */
class FilteredVolumeInfoList extends VolumeInfoList {
    add(_volumeInfo) {
        throw new Error('FilteredVolumeInfoList.add not allowed in foreground');
    }
    remove(_volumeInfo) {
        throw new Error('FilteredVolumeInfoList.remove not allowed in foreground');
    }
    item(index) {
        return super.item(index);
    }
}
/**
 * Volume types that match the Android 'media-store-files-only' volume filter,
 * viz., the volume content is indexed by the Android MediaStore.
 */
const MEDIA_STORE_VOLUME_TYPES = [
    VolumeType.DOWNLOADS,
    VolumeType.REMOVABLE,
];
/**
 * Thin wrapper for VolumeManager. This should be an interface proxy to talk
 * to VolumeManager. This class also filters some "disallowed" volumes;
 * for example, Drive volumes are dropped if Drive is disabled, and read-only
 * volumes are dropped in save-as dialogs.
 */
class FilteredVolumeManager extends VolumeManager {
    /**
     * @param allowedPaths_ Which paths are supported in the Files app dialog.
     * @param writableOnly_ If true, only writable volumes are returned.
     *     volumeManagerGetter Promise that resolves when the VolumeManager has
     *     been initialized.
     * @param volumeManagerGetter_ Promise that resolves when the VolumeManager
     *     has been initialized.
     * @param volumeFilter Array of Files app mode dependent volume filter names
     *     from Files app launch params, [] typically.
     * @param disabledVolumes_ List of volumes that should be visible but can't be
     *     selected.
     */
    constructor(allowedPaths_, writableOnly_, volumeManagerGetter_, volumeFilter, disabledVolumes_) {
        super();
        this.allowedPaths_ = allowedPaths_;
        this.writableOnly_ = writableOnly_;
        this.volumeManagerGetter_ = volumeManagerGetter_;
        this.disabledVolumes_ = disabledVolumes_;
        // VolumeManager.volumeInfoList property accessed by callers.
        this.volumeInfoList = new FilteredVolumeInfoList();
        this.volumeManager_ = null;
        this.disposed_ = false;
        this.onEventBound_ = this.onEvent_.bind(this);
        /**
         * True if chrome://flags#fuse-box-debug is enabled. This shows additional
         * UI elements, for manual fusebox testing.
         */
        this.isFuseBoxDebugEnabled_ = isFuseBoxDebugEnabled();
        /**
         * Tracks async initialization of volume manager.
         */
        this.initialized_ = this.initialize_();
        this.onVolumeInfoListUpdatedBound_ = this.onVolumeInfoListUpdated_.bind(this);
        this.isMediaStoreOnly_ = volumeFilter.includes('media-store-files-only');
        this.store_ = getStore();
    }
    getMediaStoreFilesOnlyFilterEnabled() {
        return this.isMediaStoreOnly_;
    }
    /**
     * List of disabled volumes.
     */
    get disabledVolumes() {
        return this.disabledVolumes_;
    }
    /**
     * True if the volume content is indexed by the Android MediaStore.
     */
    isMediaStoreVolume_(volumeInfo) {
        return MEDIA_STORE_VOLUME_TYPES.indexOf(volumeInfo.volumeType) >= 0;
    }
    /**
     * Checks if a volume is allowed.
     */
    isAllowedVolume(volumeInfo) {
        if (!volumeInfo.volumeType) {
            return false;
        }
        if (this.writableOnly_ && volumeInfo.isReadOnly) {
            return false;
        }
        // If the media store filter is enabled and the volume is not supported
        // by the Android MediaStore, remove the volume from the UI.
        if (this.isMediaStoreOnly_ && !this.isMediaStoreVolume_(volumeInfo)) {
            return false;
        }
        // Volumes come in three categories: NAT, FSF and FWF.
        //
        //  - NAT volumes are 'native'. Their '/foo/bar.dat' file paths are visible
        //    at the kernel level (and hence visible to all chromes).
        //  - FSF (Foreign Sans (without) FuseBox) volumes are 'virtual',
        //    non-native. Their '/fake/file.paths' file paths are only visible to
        //    ash-chrome. An example of this is attaching a phone to a Chromebook
        //    by a USB cable and viewing the phone's Downloads folder on the
        //    Chromebook's file manager, via MTP (Media Transfer Protocol).
        //  - FWF (Foreign With FuseBox) volumes use FuseBox to provide
        //    kernel-visible file paths for non-native volumes.
        //
        // In terms of boolean expressions:
        //
        //  - NAT: isNative(volumeType)
        //  - FSF: !isNative(volumeType) && (diskFileSystemType !== 'fusebox')
        //  - FWF: !isNative(volumeType) && (diskFileSystemType === 'fusebox')
        //
        // Note that both FSF-MTP and FWF-MTP volumes have the same volumeType
        // value: VolumeType.MTP. Their FSF/FWF-ness (FuseBox-ness) is instead
        // carried by the diskFileSystemType field.
        //
        // As of February 2024, when attaching a phone, Chrome's C++ will actually
        // create two MTP volumes - FSF and FWF variants - and it is up to the
        // TypeScript code to filter out (hide) one of them. FSF-MTP and FWF-MTP
        // are roughly equivalent, in terms of functionality. But in terms of
        // performance, FWF-MTP has higher overheads (as it indirects through the
        // kernel's FUSE protocol and other IPC). Hence, we prefer FSF-MTP when
        // feasible (i.e. when in ash-chrome) but FWF-MTP when FSF-MTP won't work
        // at all.
        //
        // There's also the isFuseBoxDebugEnabled_ field, corresponding to
        // chrome://flags#fuse-box-debug. When true, we should show both FSF and
        // FWF volumes, for manual testing. But normally, we should show only one
        // of the FSF and FWF categories.
        //
        // FuseBox (and its FWF volumes) was invented in 2021. Before then, there
        // were only NAT and FSF volumes: native and non-native. There was also the
        // AllowedPaths.NATIVE_PATH enum value, which originally meant 'only
        // native': only NAT. After FuseBox was invented, AllowedPaths.NATIVE_PATH
        // was retconned to mean 'kernel-visible' here: NAT or FWF.
        //
        // In the long term, we might be able to remove the NATIVE_PATH concept
        // here (or remove it entirely). The original authors of that NATIVE_PATH
        // code no longer maintain it, so it's hard to be sure, but it dates from a
        // time before FuseBox but also possibly where non-native volume types like
        // FSP (File System Provider) or MTP didn't have good write-support and,
        // for some workflows, read-support was facilitated by first downloading a
        // virtual file's contents to a temporary 'snapshot file' and passing on
        // the snapshot file path. When showing e.g. a browser's "Save As" dialog,
        // we'd therefore want to hide FSP, MTP, etc. volumes and an easy way to do
        // that might have been to hide non-native volumes.
        //
        // However, "Save As" passes NATIVE_PATH and combining that with FSF
        // volumes currently crashes here:
        // https://source.chromium.org/chromium/chromium/src/+/main:chrome/browser/ash/extensions/file_manager/private_api_util.cc;l=83;drc=ccce03e75fc4822e12fb63e60021e0a5e5e9f5b0
        // Its 'unreachable' comment is from 2014
        // (https://codereview.chromium.org/339503003 and
        // https://crrev.com/c/1868529) but things have changed since then.
        const nat = isNative(volumeInfo.volumeType);
        const fsf = !nat && (volumeInfo.diskFileSystemType !== 'fusebox');
        // fwf is equivalent to (!nat && !fsf).
        switch (this.allowedPaths_) {
            case AllowedPaths.ANY_PATH:
            case AllowedPaths.ANY_PATH_OR_URL:
                if (this.isFuseBoxDebugEnabled_) {
                    // chrome://flags#fuse-box-debug is enabled. Show everything.
                    return true; // Equivalent to (nat || fsf || fwf).
                }
                else {
                    // If not nat (native), prefer fsf (foreign-sans-fusebox) over fwf
                    // (foreign-with-fusebox).
                    return nat || fsf; // Equivalent to (!fwf).
                }
            case AllowedPaths.NATIVE_PATH:
                // 'Kernel-visible' means native (nat) or fusebox (fwf) volumes.
                return !fsf; // Equivalent to (nat || fwf).
        }
    }
    /**
     * Async part of the initialization.
     */
    async initialize_() {
        this.volumeManager_ = await this.volumeManagerGetter_;
        if (this.disposed_) {
            return;
        }
        // Subscribe to VolumeManager.
        this.volumeManager_.addEventListener('drive-connection-changed', this.onEventBound_);
        this.volumeManager_.addEventListener('externally-unmounted', this.onEventBound_);
        this.volumeManager_.addEventListener(ARCHIVE_OPENED_EVENT_TYPE, this.onEventBound_);
        // Dispatch 'drive-connection-changed' to listeners, since the return value
        // of FilteredVolumeManager.getDriveConnectionState() can be changed by
        // setting this.volumeManager_.
        this.dispatchEvent(new CustomEvent('drive-connection-changed'));
        // Cache volumeInfoList.
        const volumeInfoList = [];
        for (let i = 0; i < this.volumeManager_.volumeInfoList.length; i++) {
            const volumeInfo = this.volumeManager_.volumeInfoList.item(i);
            if (!this.isAllowedVolume(volumeInfo)) {
                continue;
            }
            volumeInfoList.push(volumeInfo);
        }
        this.volumeInfoList.splice(0, this.volumeInfoList.length, ...volumeInfoList);
        // Subscribe to VolumeInfoList.
        // In VolumeInfoList, we only use 'splice' event.
        this.volumeManager_.volumeInfoList.addEventListener('splice', this.onVolumeInfoListUpdatedBound_);
    }
    /**
     * Disposes the instance. After the invocation of this method, any other
     * method should not be called.
     */
    dispose() {
        this.disposed_ = true;
        if (!this.volumeManager_) {
            return;
        }
        this.volumeManager_.removeEventListener('drive-connection-changed', this.onEventBound_);
        this.volumeManager_.removeEventListener('externally-unmounted', this.onEventBound_);
        this.volumeManager_.volumeInfoList.removeEventListener('splice', this.onVolumeInfoListUpdatedBound_);
    }
    /**
     * Called on events sent from VolumeManager. This has responsibility to
     * re-dispatch the event to the listeners.
     * @param event Custom event object sent from VolumeManager.
     */
    onEvent_(event) {
        // Note: Can not re-dispatch the same |event| object, because it throws a
        // runtime "The event is already being dispatched." error.
        switch (event.type) {
            case 'drive-connection-changed':
                this.dispatchEvent(new CustomEvent('drive-connection-changed'));
                break;
            case 'externally-unmounted':
                if (this.isAllowedVolume(event.detail)) {
                    this.dispatchEvent(new CustomEvent('externally-unmount', { detail: event.detail }));
                }
                break;
            case ARCHIVE_OPENED_EVENT_TYPE:
                if (this.getVolumeInfo(event.detail.mountPoint)) {
                    this.dispatchEvent(new CustomEvent(event.type, { detail: event.detail }));
                }
                break;
        }
    }
    /**
     * Called on events of modifying VolumeInfoList.
     * @param event Event object sent from VolumeInfoList.
     */
    onVolumeInfoListUpdated_(event) {
        const spliceEventDetail = event.detail;
        // Filters some volumes.
        let index = spliceEventDetail.index;
        if (spliceEventDetail.index && index) {
            for (let i = 0; i < spliceEventDetail.index; i++) {
                const volumeInfo = this.volumeManager_.volumeInfoList.item(i);
                if (!this.isAllowedVolume(volumeInfo)) {
                    index--;
                }
            }
        }
        let numRemovedVolumes = 0;
        for (let i = 0; i < spliceEventDetail.removed.length; i++) {
            const volumeInfo = spliceEventDetail.removed[i];
            if (this.isAllowedVolume(volumeInfo)) {
                numRemovedVolumes++;
            }
        }
        const addedVolumes = [];
        for (let i = 0; i < spliceEventDetail.added.length; i++) {
            const volumeInfo = spliceEventDetail.added[i];
            if (this.isAllowedVolume(volumeInfo)) {
                addedVolumes.push(volumeInfo);
            }
        }
        this.volumeInfoList.splice(index, numRemovedVolumes, ...addedVolumes);
    }
    /**
     * Ensures the VolumeManager is initialized, and then invokes callback.
     * If the VolumeManager is already initialized, callback will be called
     * immediately.
     * @param callback Called on initialization completion.
     */
    ensureInitialized(callback) {
        this.initialized_.then(callback);
    }
    /**
     * @return Current drive connection state.
     */
    getDriveConnectionState() {
        if (!this.volumeManager_) {
            return {
                type: chrome.fileManagerPrivate.DriveConnectionStateType.OFFLINE,
                reason: chrome.fileManagerPrivate.DriveOfflineReason.NO_SERVICE,
            };
        }
        return this.volumeManager_.getDriveConnectionState();
    }
    getVolumeInfo(entry) {
        return this.filterDisallowedVolume_(this.volumeManager_ && this.volumeManager_.getVolumeInfo(entry));
    }
    /**
     * Obtains a volume information of the current profile.
     * @param volumeType Volume type.
     * @return Found volume info.
     */
    getCurrentProfileVolumeInfo(volumeType) {
        return this.filterDisallowedVolume_(this.volumeManager_ &&
            this.volumeManager_.getCurrentProfileVolumeInfo(volumeType));
    }
    async getDefaultDisplayRoot() {
        await this.initialized_;
        // If SkyVault is disabled, this should always be set to MyFiles.
        // If SkyVault is enabled, the default root might be MyFiles, Google
        // Drive, or OneDrive. Fallback to MyFiles if not set, it won't be resolved
        // if unavailable due to policy restrictions.
        const location = this.store_.getState()?.preferences?.defaultLocation ??
            chrome.fileManagerPrivate.DefaultLocation.MY_FILES;
        let volumeInfo;
        switch (location) {
            case chrome.fileManagerPrivate.DefaultLocation.MY_FILES:
                volumeInfo = this.getCurrentProfileVolumeInfo(VolumeType.DOWNLOADS);
                break;
            case chrome.fileManagerPrivate.DefaultLocation.GOOGLE_DRIVE:
                volumeInfo = this.getCurrentProfileVolumeInfo(VolumeType.DRIVE);
                break;
            case chrome.fileManagerPrivate.DefaultLocation.ONEDRIVE:
                volumeInfo = this.getOneDriveVolumeInfo_();
                if (!volumeInfo) {
                    // Check if the placeholder is there.
                    const entry = getEntry(this.store_.getState(), oneDriveFakeRootKey);
                    if (entry) {
                        return entry;
                    }
                }
                break;
            default:
                console.warn(`Invalid default location: ${location}`);
                volumeInfo = null;
                break;
        }
        if (!volumeInfo) {
            console.warn(`Cannot get display root for ${location}`);
            return null;
        }
        return volumeInfo.resolveDisplayRoot();
    }
    /**
     * Obtains a Microsoft OneDrive volume information if available.
     * @returns OneDrive volume info, or null if it cannot be found.
     */
    getOneDriveVolumeInfo_() {
        for (let i = 0; i < this.volumeInfoList.length; i++) {
            const volumeInfo = this.volumeInfoList.item(i);
            if (isOneDrive(volumeInfo)) {
                return volumeInfo;
            }
        }
        return null;
    }
    /**
     * Obtains location information from an entry.
     *
     * @param entry File or directory entry.
     * @return Location information.
     */
    getLocationInfo(entry) {
        const locationInfo = this.volumeManager_ && this.volumeManager_.getLocationInfo(entry);
        if (!locationInfo) {
            return null;
        }
        if (locationInfo.volumeInfo &&
            !this.filterDisallowedVolume_(locationInfo.volumeInfo)) {
            return null;
        }
        return locationInfo;
    }
    findByDevicePath(devicePath) {
        for (let i = 0; i < this.volumeInfoList.length; i++) {
            const volumeInfo = this.volumeInfoList.item(i);
            if (volumeInfo.devicePath && volumeInfo.devicePath === devicePath) {
                return this.filterDisallowedVolume_(volumeInfo);
            }
        }
        return null;
    }
    /**
     * Returns a promise that will be resolved when volume info, identified
     * by {@code volumeId} is created.
     *
     * @return The VolumeInfo. Will not resolve if the volume is never mounted.
     */
    async whenVolumeInfoReady(volumeId) {
        await this.initialized_;
        const volumeInfo = this.filterDisallowedVolume_(await this.volumeManager_.whenVolumeInfoReady(volumeId));
        if (!volumeInfo) {
            throw new Error(`Volume not allowed: ${volumeId}`);
        }
        return volumeInfo;
    }
    async mountArchive(fileUrl, password) {
        await this.initialized_;
        return this.volumeManager_.mountArchive(fileUrl, password);
    }
    async cancelMounting(fileUrl) {
        await this.initialized_;
        return this.volumeManager_.cancelMounting(fileUrl);
    }
    async unmount(volumeInfo) {
        await this.initialized_;
        return this.volumeManager_.unmount(volumeInfo);
    }
    /**
     * Requests configuring of the specified volume.
     * @param volumeInfo Volume to be configured.
     * @return Fulfilled on success, otherwise rejected with an error message.
     */
    async configure(volumeInfo) {
        await this.initialized_;
        return this.volumeManager_.configure(volumeInfo);
    }
    /**
     * Filters volume info by isAllowedVolume_().
     *
     * @return Null if the volume is disallowed. Otherwise just returns the
     *     volume.
     */
    filterDisallowedVolume_(volumeInfo) {
        if (volumeInfo && this.isAllowedVolume(volumeInfo)) {
            return volumeInfo;
        }
        else {
            return null;
        }
    }
    hasDisabledVolumes() {
        return this.disabledVolumes_.length > 0;
    }
    isDisabled(volume) {
        return this.disabledVolumes_.includes(volume);
    }
}

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview Trash implementation is based on
 * https://specifications.freedesktop.org/trash-spec/trashspec-1.0.html.
 *
 * When you move /dir/hello.txt to trash, you get:
 *  .Trash/files/hello.txt
 *  .Trash/info/hello.trashinfo
 *
 * .Trash/files/hello.txt is the original file.  .Trash/files.hello.trashinfo is
 * a text file which looks like:
 *  [Trash Info]
 *  Path=/dir/hello.txt
 *  DeletionDate=2020-11-02T07:35:38.964Z
 *
 * TrashEntry combines both files for display.
 */
/**
 * Configuration for where Trash is stored in a volume.
 */
class TrashConfig {
    constructor(volumeType, topDir, trashDir, deleteIsForever) {
        this.volumeType = volumeType;
        this.topDir = topDir;
        this.trashDir = trashDir;
        this.deleteIsForever = deleteIsForever;
        this.id = `${volumeType}-${topDir}`;
    }
}
/**
 * Volumes supported for Trash, and location of Trash dir. Items will be
 * searched in order.
 */
const TRASH_CONFIG = [
    // MyFiles/Downloads is a separate volume on a physical device, and doing a
    // move from MyFiles/Downloads/<path> to MyFiles/.Trash actually does a
    // copy across volumes, so we have a dedicated MyFiles/Downloads/.Trash.
    new TrashConfig(VolumeType.DOWNLOADS, '/Downloads/', '/Downloads/.Trash/', 
    /*deleteIsForever=*/ true),
    new TrashConfig(VolumeType.DOWNLOADS, '/', '/.Trash/', 
    /*deleteIsForever=*/ true),
];
if (loadTimeData.getBoolean('FILES_TRASH_DRIVE_ENABLED')) {
    TRASH_CONFIG.push(new TrashConfig(VolumeType.DRIVE, '/', '/.Trash-1000/', 
    /*deleteIsForever=*/ false));
}
/**
 * Interval (ms) until items in trash are permanently deleted. 30 days.
 */
const AUTO_DELETE_INTERVAL_MS = 30 * 24 * 60 * 60 * 1000;
/**
 * Interval (ms) when .trashinfo files with no related files entry can be
 * considered stale and should be removed. 1 hour.
 */
const STALE_TRASHINFO_INTERVAL_MS = 60 * 60 * 1000;
/**
 * Returns a list of strings that represent volumes that are enabled for Trash.
 * Used to validate drag drop data without resolving the URLs to Entry's.
 */
function getEnabledTrashVolumeURLs(volumeManager, includeTrashPath = false, deleteIsForeverOnly = false) {
    const urls = [];
    for (let i = 0; i < volumeManager.volumeInfoList.length; i++) {
        const volumeInfo = volumeManager.volumeInfoList.item(i);
        for (const config of TRASH_CONFIG) {
            if (deleteIsForeverOnly && !config.deleteIsForever) {
                continue;
            }
            if (volumeInfo.volumeType === config.volumeType) {
                if (!includeTrashPath) {
                    urls.push(volumeInfo.fileSystem.root.toURL());
                    continue;
                }
                let fileSystemRootURL = volumeInfo.fileSystem.root.toURL();
                if (fileSystemRootURL.endsWith('/')) {
                    fileSystemRootURL =
                        fileSystemRootURL.substring(0, fileSystemRootURL.length - 1);
                }
                urls.push(fileSystemRootURL + config.trashDir);
            }
        }
    }
    return urls;
}
/**
 * Returns true if all supplied entries reside at a known trash location.
 */
function isAllTrashEntries(entries, volumeManager) {
    const enabledTrashVolumeURLs = getEnabledTrashVolumeURLs(volumeManager, /*includeTrashPath=*/ true);
    return entries.every((e) => {
        for (const volumeURL of enabledTrashVolumeURLs) {
            if (e.toURL().startsWith(volumeURL)) {
                return true;
            }
        }
        return false;
    });
}
/**
 * Returns true if all supplied entries are on a volume where delete or empty
 * from trash will delete forever.
 */
function deleteIsForever(entries, volumeManager) {
    const enabledTrashVolumeURLs = getEnabledTrashVolumeURLs(volumeManager, /*includeTrashPath=*/ false, 
    /*deleteIsForeverOnly=*/ true);
    return entries.every((e) => {
        for (const volumeURL of enabledTrashVolumeURLs) {
            if (e.toURL().startsWith(volumeURL)) {
                return true;
            }
        }
        return false;
    });
}
/**
 * Returns true if all entries are on a trashable volume and they aren't already
 * trashed.
 */
function shouldMoveToTrash(entries, volumeManager) {
    const urls = [];
    for (let i = 0; i < volumeManager.volumeInfoList.length; i++) {
        const volumeInfo = volumeManager.volumeInfoList.item(i);
        for (const config of TRASH_CONFIG) {
            if (volumeInfo.volumeType === config.volumeType) {
                let fileSystemRootURL = volumeInfo.fileSystem.root.toURL();
                if (fileSystemRootURL.endsWith('/')) {
                    fileSystemRootURL =
                        fileSystemRootURL.substring(0, fileSystemRootURL.length - 1);
                }
                const trashURLs = {
                    volume: volumeInfo.fileSystem.root.toURL(),
                    volumeAndTrashPath: fileSystemRootURL + config.trashDir,
                };
                urls.push(trashURLs);
            }
        }
    }
    return entries.every(e => {
        let onAllowedVolume = false;
        for (const { volume, volumeAndTrashPath } of urls) {
            // All trash directories in configuration have a trailing slash, so if the
            // entry URL is a directory and doesn't have a trailing slash, add one to
            // ensure a .Trash directory doesn't show a "Move to trash" button.
            let entryURL = e.toURL();
            if (e.isDirectory && !entryURL.endsWith('/')) {
                entryURL = entryURL + '/';
            }
            if (entryURL.startsWith(volumeAndTrashPath)) {
                return false;
            }
            if (entryURL.startsWith(volume)) {
                onAllowedVolume = true;
            }
        }
        return onAllowedVolume;
    });
}
/**
 * Wrapper for /.Trash/files and /.Trash/info directories.
 */
class TrashDirs {
    constructor(files, info) {
        this.files = files;
        this.info = info;
    }
    /**
     * Promise wrapper for FileSystemDirectoryEntry.getDirectory().
     */
    static getDirectory(dirEntry, path, create) {
        return new Promise((resolve) => {
            dirEntry.getDirectory(path, { create }, (entry) => {
                resolve(entry);
            }, () => resolve(null));
        });
    }
    /**
     * Get trash dirs from file system as specified in config.
     */
    static async getTrashDirs(fileSystem, config, create) {
        let trashRoot = fileSystem.root;
        const parts = config.trashDir.split('/');
        for (const part of parts) {
            if (part) {
                trashRoot = await TrashDirs.getDirectory(trashRoot, part, create);
                if (!trashRoot) {
                    return null;
                }
            }
        }
        const files = await TrashDirs.getDirectory(trashRoot, 'files', create);
        const info = await TrashDirs.getDirectory(trashRoot, 'info', create);
        return files && info ? new TrashDirs(files, info) : null;
    }
}
/**
 * Represents a file moved to trash. Combines the info from both .Trash/info and
 * ./Trash/files.
 */
class TrashEntry {
    constructor(name, deletionDate_, filesEntry, infoEntry, restoreEntry) {
        this.name = name;
        this.deletionDate_ = deletionDate_;
        this.filesEntry = filesEntry;
        this.infoEntry = infoEntry;
        this.restoreEntry = restoreEntry;
        /**
         * The trash root type.
         */
        this.rootType = RootType.TRASH;
        /**
         * The type name of TrashEntry.
         */
        this.typeName = 'TrashEntry';
        this.filesystem = filesEntry.filesystem;
        this.fullPath = filesEntry.fullPath;
        this.isDirectory = filesEntry.isDirectory;
        this.isFile = filesEntry.isFile;
    }
    /**
     * Use filesEntry toURL() so this entry can be used as that file to view,
     * copy, etc.
     */
    // Adding suppression since this class implements FileSystemEntry from
    // https://developer.mozilla.org/en-US/docs/Web/API/FileSystemEntry
    // eslint-disable-next-line @typescript-eslint/naming-convention
    toURL() {
        return this.filesEntry.toURL();
    }
    /**
     * Pass through to getMetadata() of filesEntry, keep size, but use
     * DeletionDate from infoEntry for modificationTime.
     *
     * @override Entry
     */
    getMetadata(success, error) {
        this.filesEntry.getMetadata(m => {
            success({ modificationTime: this.deletionDate_, size: m.size });
        }, error);
    }
    /**
     * Remove filesEntry first, then remove infoEntry. Overrides Entry.
     */
    remove(success, error) {
        this.filesEntry.remove(() => this.infoEntry.remove(success, error), error);
    }
    /**
     * Pass through to filesEntry. Overrides FileEntry.
     */
    file(success, error) {
        if (isFileEntry(this.filesEntry)) {
            this.filesEntry.file(success, error);
            return;
        }
        console.error('file attempted on FileSystemDirectoryEntry');
    }
    /**
     * Pass through to filesEntry. Overrides DirectoryEntry.
     */
    getFile(path, options, success, error) {
        if (isDirectoryEntry(this.filesEntry)) {
            this.filesEntry.getFile(path, options, success, error);
            return;
        }
        console.error('getFile attempted on FileSystemFileEntry');
    }
    /**
     * Remove filesEntry first, then remove infoEntry. Overrides DirectoryEntry.
     */
    removeRecursively(success, error) {
        if (isDirectoryEntry(this.filesEntry)) {
            this.filesEntry.removeRecursively(() => this.infoEntry.remove(success, error), error);
            return;
        }
        console.error('removeRecursively attempted on FileSystemFileEntry');
    }
    /**
     * Trash entries should not allow the following methods, specifically `moveTo`
     * and `copyTo` should be handled by the restore IO task.
     */
    getParent() { }
    moveTo() { }
    copyTo() { }
    /**
     * We must set entry.isNativeType to true, so that this is not considered a
     * FakeEntry, and we are allowed to delete the item.
     */
    get isNativeType() {
        return true;
    }
    getNativeEntry() {
        return this.filesEntry;
    }
}
/**
 * Reads all entries in each of .Trash/info and .Trash/files and produces a
 * single stream of TrashEntry.
 */
class TrashDirectoryReader {
    constructor(fileSystem_, config_) {
        this.fileSystem_ = fileSystem_;
        this.config_ = config_;
        /**
         * The entries that exist in this .Trash directory.
         */
        this.filesEntries_ = {};
        /**
         * A directory reader used to read the items out of the .Trash/info directory.
         */
        this.infoReader_ = null;
    }
    /**
     * Create a trash entry if infoEntry and matching files entry are valid, else
     * return null.
     */
    createTrashEntry_(parsedEntry, infoEntry) {
        const filesEntry = this.getFilesEntry(parsedEntry.trashInfoFileName);
        // Ignore any .trashinfo file with no matching file entry.
        if (!filesEntry) {
            console.warn('Ignoring trash info file with no matching files entry');
            return null;
        }
        return new TrashEntry(parsedEntry.restoreEntry.name, new Date(parsedEntry.deletionDate), filesEntry, infoEntry, parsedEntry.restoreEntry);
    }
    /**
     * Returns the Entry from the cached files entries.
     */
    getFilesEntry(trashInfoFileName) {
        const filesEntry = this.filesEntries_[trashInfoFileName];
        delete this.filesEntries_[trashInfoFileName];
        return filesEntry;
    }
    /**
     * Async version of readEntries(). This function may be called multiple times
     * and returns an empty result to indicate end of stream.
     *
     * Reads all items in .Trash/files on first call and caches them. Then reads
     * 1 or more batches of infoReader until we have at least 1 valid result to
     * send, or reader is exhausted.
     */
    async readEntriesAsync_(success, error) {
        const ls = (reader) => {
            return new Promise((resolve, reject) => {
                reader.readEntries(results => resolve(results), error => reject(error));
            });
        };
        // Read all of .Trash/files on first call.
        if (!this.infoReader_) {
            const trashDirs = await TrashDirs.getTrashDirs(this.fileSystem_, this.config_, /*create=*/ false);
            // If trash dirs do not yet exist, then return successful empty read.
            if (!trashDirs) {
                return success([]);
            }
            // Get all entries in trash/files.
            const filesReader = trashDirs.files.createReader();
            try {
                while (true) {
                    const entries = await ls(filesReader);
                    if (!entries.length) {
                        break;
                    }
                    entries.forEach(entry => this.filesEntries_[entry.name + '.trashinfo'] = entry);
                }
            }
            catch (e) {
                console.warn('Error reading trash files entries', e);
                error(e);
                return;
            }
            this.infoReader_ = trashDirs.info.createReader();
        }
        // Consume infoReader which is initialized in the first call. Read from
        // .Trash/info until we have at least 1 result, or end of stream.
        const result = [];
        const entriesToDelete = [];
        const dateNow = Date.now();
        while (true) {
            let entries = [];
            try {
                entries = await ls(this.infoReader_);
            }
            catch (e) {
                console.warn('Error reading trash info entries', e);
                error(e);
                return;
            }
            if (!entries.length) {
                break;
            }
            const infoEntryMap = {};
            for (const e of entries) {
                if (!e.isFile || !e.name.endsWith('.trashinfo')) {
                    continue;
                }
                infoEntryMap[e.name] = e;
            }
            let parsedEntries = [];
            try {
                parsedEntries = await parseTrashInfoFiles(entries);
            }
            catch (e) {
                console.warn('Error parsing trash info entries', e);
                error(e);
                return;
            }
            for (const parsedEntry of parsedEntries) {
                const infoEntry = infoEntryMap[parsedEntry.trashInfoFileName];
                if (!infoEntry) {
                    continue;
                }
                // In the event the parsed entry was deleted more than 30 days ago,
                // schedule them for deletion and don't render them in the view.
                if (parsedEntry.deletionDate < (dateNow - AUTO_DELETE_INTERVAL_MS)) {
                    entriesToDelete.push(infoEntry);
                    const trashEntry = this.getFilesEntry(parsedEntry.trashInfoFileName);
                    if (trashEntry) {
                        entriesToDelete.push(trashEntry);
                    }
                    delete infoEntryMap[parsedEntry.trashInfoFileName];
                    continue;
                }
                const trashEntry = this.createTrashEntry_(parsedEntry, infoEntry);
                if (trashEntry) {
                    result.push(trashEntry);
                }
                delete infoEntryMap[parsedEntry.trashInfoFileName];
            }
            // Any leftover entries in the `infoEntryMap` have no corresponding file
            // entry. This can be due to 2 possible reasons:
            // 1. An in progress trash operation that has written the trashinfo file
            //    but not moved the corresponding item.
            // 2. The trashinfo has been removed or is dangling from a previously
            //    failed operation.
            // To avoid (1) check the `modificationDate` and ensure it's >1 hour old,
            // given a trash operation is atomic (no cross filesystem trashes) this
            // should be sufficient time to ensure there is no file to be moved.
            for (const entry of Object.values(infoEntryMap)) {
                let itemMetadata = null;
                try {
                    itemMetadata = await getFileMetadata(entry);
                }
                catch (e) {
                    console.warn('Error getting trashinfo metadata:', e);
                    continue;
                }
                if (itemMetadata.modificationTime.getTime() <
                    (dateNow - STALE_TRASHINFO_INTERVAL_MS)) {
                    entriesToDelete.push(entry);
                }
            }
        }
        success(result);
        if (entriesToDelete.length > 0) {
            startIOTask(chrome.fileManagerPrivate.IoTaskType.DELETE, entriesToDelete, {
                showNotification: false,
                destinationFolder: undefined,
                password: undefined,
            });
        }
        // Record the amount of files seen for this particularly directory reader.
        recordMediumCount(
        /*name=*/ `TrashFiles.${this.config_.volumeType}`, result.length);
    }
    readEntries(success, error) {
        this.readEntriesAsync_(success, error);
    }
}
/**
 * Root Trash entry sits inside "My files". It shows the combined entries of
 * trashes defined in TrashConfig.
 */
class TrashRootEntry extends FakeEntryImpl {
    constructor() {
        super(str('TRASH_ROOT_LABEL'), RootType.TRASH);
    }
}
/**
 * Returns all the Trash directory readers.
 */
function createTrashReaders(volumeManager) {
    const readers = [];
    TRASH_CONFIG.forEach(c => {
        const info = volumeManager.getCurrentProfileVolumeInfo(c.volumeType);
        if (info && info.fileSystem) {
            readers.push(new TrashDirectoryReader(info.fileSystem, c));
        }
    });
    return readers;
}
/**
 * Promisifies retrieval of a files metadata.
 */
async function getFileMetadata(file) {
    return new Promise((resolve, reject) => {
        file.getMetadata(resolve, reject);
    });
}
// The UMA to track the enum that is reported below.
const RestoreFailedUMA = 'Trash.RestoreFailedNoParent';
const RestoreFailedType = {
    // A single item has attempted to be restored but the parent has been removed.
    SINGLE_ITEM: 'single-item',
    // Multiple items have attempted to be restored where they all shared the same
    // parent folder, but it has been removed.
    MULTIPLE_ITEMS_SAME_PARENTS: 'multiple-items-same-parents',
    // Multiple items have attempted to be restored and they all have different
    // parent folders but all the parent folders have been removed.
    MULTIPLE_ITEMS_DIFFERENT_PARENTS: 'multiple-items-different-parents',
    // Multiple items have attempted to be restored from different parents with
    // some parent folders still existing and some have been removed.
    MULTIPLE_ITEMS_MIXED: 'multiple-items-mixed',
};
/**
 * Keep the order of this in sync with RestoreFailedNoParentType in
 * tools/metrics/histograms/enums.xml.
 */
const RestoreFailedTypesUMA = [
    RestoreFailedType.SINGLE_ITEM, // 0
    RestoreFailedType.MULTIPLE_ITEMS_SAME_PARENTS, // 1
    RestoreFailedType.MULTIPLE_ITEMS_DIFFERENT_PARENTS, // 2
    RestoreFailedType.MULTIPLE_ITEMS_MIXED, // 3
];

// Copyright 2012 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.


/**
 * Check the directionality of the page.
 * @return {boolean} True if Chrome is running an RTL UI.
 */
function isRTL$1() {
  return document.documentElement.dir === 'rtl';
}

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// Note: This file is deprecated and retained only for legacy JS code that is
// still using closure compiler for type checking. New code should use
// keyboard_shortcut_list.ts.

/** This is used to identify keyboard shortcuts. */
class KeyboardShortcut {
  /**
   * @param {string} shortcut The text used to describe the keys for this
   *     keyboard shortcut.
   */
  constructor(shortcut) {
    /** @private {boolean} */
    this.useKeyCode_ = false;

    /** @private {Object} */
    this.mods_ = {};

    /** @private {?string} */
    this.key_ = null;

    /** @private {?number} */
    this.keyCode_ = null;

    shortcut.split('|').forEach((part) => {
      const partLc = part.toLowerCase();
      switch (partLc) {
        case 'alt':
        case 'ctrl':
        case 'meta':
        case 'shift':
          this.mods_[partLc + 'Key'] = true;
          break;
        default:
          if (this.key_) {
            throw Error('Invalid shortcut');
          }
          this.key_ = part;
          // For single key alpha shortcuts use event.keyCode rather than
          // event.key to match how chrome handles shortcuts and allow
          // non-english language input to work.
          if (part.match(/^[a-z]$/)) {
            this.useKeyCode_ = true;
            this.keyCode_ = part.toUpperCase().charCodeAt(0);
          }
      }
    });
  }

  /**
   * Whether the keyboard shortcut object matches a keyboard event.
   * @param {!Event} e The keyboard event object.
   * @return {boolean} Whether we found a match or not.
   */
  matchesEvent(e) {
    if ((this.useKeyCode_ && e.keyCode === this.keyCode_) ||
        e.key === this.key_) {
      // All keyboard modifiers need to match.
      const mods = this.mods_;
      return ['altKey', 'ctrlKey', 'metaKey', 'shiftKey'].every(function(k) {
        return e[k] === !!mods[k];
      });
    }
    return false;
  }
}

/** A list of keyboard shortcuts which all perform one command. */
class KeyboardShortcutList {
  /**
   * @param {string} shortcuts Text-based representation of one or more
   *     keyboard shortcuts, separated by spaces.
   */
  constructor(shortcuts) {
    this.shortcuts_ = shortcuts.split(/\s+/).map(function(shortcut) {
      return new KeyboardShortcut(shortcut);
    });
  }

  /**
   * Returns true if any of the keyboard shortcuts in the list matches a
   * keyboard event.
   * @param {!Event} e
   * @return {boolean}
   */
  matchesEvent(e) {
    return this.shortcuts_.some(function(keyboardShortcut) {
      return keyboardShortcut.matchesEvent(e);
    });
  }
}

// Copyright 2012 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview A command is an abstraction of an action a user can do in the
 * UI.
 *
 * When the focus changes in the document for each command a canExecute event
 * is dispatched on the active element. By listening to this event you can
 * enable and disable the command by setting the event.canExecute property.
 *
 * When a command is executed a command event is dispatched on the active
 * element. Note that you should stop the propagation after you have handled the
 * command if there might be other command listeners higher up in the DOM tree.
 */
/**
 * Creates a new command element.
 */
class Command extends HTMLElement {
    constructor() {
        super(...arguments);
        this.shortcut_ = null;
        this.keyboardShortcuts_ = null;
    }
    /**
     * Initializes the command.
     */
    initialize() {
        assert$1(this.ownerDocument);
        CommandManager.init(this.ownerDocument);
        if (this.hasAttribute('shortcut')) {
            this.shortcut = this.getAttribute('shortcut');
        }
    }
    /**
     * Executes the command by dispatching a command event on the given element.
     * If `element` isn't given, the active element is used instead.
     * If the command is `disabled` this does nothing.
     * @param element Optional element to dispatch event on.
     */
    execute(element) {
        if (this.disabled) {
            return;
        }
        const doc = this.ownerDocument;
        if (doc.activeElement) {
            const e = new CustomEvent('command', {
                bubbles: true,
                detail: {
                    command: this,
                },
            });
            (element || doc.activeElement).dispatchEvent(e);
        }
    }
    /**
     * Sets 'hidden' property of a Command instance which dispatches
     * 'hiddenChange' event automatically, so that associated MenuItem can
     * handle the event.
     *
     * @param value New value of hidden property.
     */
    setHidden(value) {
        this.hidden = value;
    }
    /**
     * Call this when there have been changes that might change whether the
     * command can be executed or not.
     * @param node Node for which to actuate command state.
     */
    canExecuteChange(node) {
        dispatchCanExecuteEvent(this, node ?? this.ownerDocument.activeElement);
    }
    /**
     * The keyboard shortcut that triggers the command. This is a string
     * consisting of a key (as reported by WebKit in keydown) as
     * well as optional key modifiers joined with a '|'.
     *
     * Multiple keyboard shortcuts can be provided by separating them by
     * whitespace.
     *
     * For example:
     *   "F1"
     *   "Backspace|Meta" for Apple command backspace.
     *   "a|Ctrl" for Control A
     *   "Delete Backspace|Meta" for Delete and Command Backspace
     *
     */
    get shortcut() {
        return this.shortcut_ ?? '';
    }
    set shortcut(shortcut) {
        const oldShortcut = this.shortcut_;
        if (shortcut !== oldShortcut) {
            this.keyboardShortcuts_ = new KeyboardShortcutList(shortcut);
            // Set this after the keyboardShortcuts_ since that might throw.
            this.shortcut_ = shortcut;
            dispatchPropertyChange(this, 'shortcut', this.shortcut_, oldShortcut);
        }
    }
    /**
     * Whether the event object matches the shortcut for this command.
     * @param e The key event object.
     * @return Whether it matched or not.
     */
    matchesEvent(e) {
        if (!this.keyboardShortcuts_) {
            return false;
        }
        return this.keyboardShortcuts_.matchesEvent(e);
    }
    /**
     * The label of the command.
     */
    get label() {
        return this.getAttribute(convertToKebabCase('label')) ?? '';
    }
    set label(value) {
        domAttrSetter(this, 'label', value);
    }
    /**
     * Whether the command is disabled or not.
     */
    get disabled() {
        return this.hasAttribute(convertToKebabCase('disabled'));
    }
    set disabled(value) {
        boolAttrSetter(this, 'disabled', value);
    }
    /**
     * Whether the command is hidden or not.
     */
    get hidden() {
        return this.hasAttribute(convertToKebabCase('hidden'));
    }
    set hidden(value) {
        boolAttrSetter(this, 'hidden', value);
    }
    /**
     * Whether the command is checked or not.
     */
    get checked() {
        return this.hasAttribute(convertToKebabCase('checked'));
    }
    set checked(value) {
        boolAttrSetter(this, 'checked', value);
    }
    /**
     * The flag that prevents the shortcut text from being displayed on menu.
     *
     * If false, the keyboard shortcut text (eg. "Ctrl+X" for the cut command)
     * is displayed in menu when the command is associated with a menu item.
     * Otherwise, no text is displayed.
     */
    get hideShortcutText() {
        return this.hasAttribute(convertToKebabCase('hideShortcutText'));
    }
    set hideShortcutText(value) {
        boolAttrSetter(this, 'hideShortcutText', value);
    }
}
/**
 * Dispatches a canExecute event on the target.
 * @param command The command that we are testing for.
 * @param target The target element to dispatch the event on.
 */
function dispatchCanExecuteEvent(command, target) {
    const e = new CanExecuteEvent(command);
    target.dispatchEvent(e);
    command.disabled = !e.canExecute;
}
/**
 * The command managers for different documents.
 */
const commandManagers = new Map();
/**
 * Keeps track of the focused element and updates the commands when the focus
 * changes.
 */
class CommandManager {
    /**
     * @param doc The document that we are managing the commands for.
     */
    constructor(doc) {
        doc.addEventListener('focus', this.handleFocus_.bind(this), true);
        // Make sure we add the listener to the bubbling phase so that elements can
        // prevent the command.
        doc.addEventListener('keydown', this.handleKeyDown_.bind(this), false);
    }
    /**
     * Initializes a command manager for the document as needed.
     * @param doc The document to manage the commands for.
     */
    static init(doc) {
        if (!commandManagers.has(doc)) {
            commandManagers.set(doc, new CommandManager(doc));
        }
    }
    /**
     * Handles focus changes on the document.
     * @param e The focus event object.
     */
    handleFocus_(e) {
        const target = e.target;
        // Ignore focus on a menu button or command item.
        if ('menu' in target || 'command' in target ||
            (target instanceof MenuItem)) {
            return;
        }
        for (const command of target.ownerDocument.querySelectorAll('command')) {
            dispatchCanExecuteEvent(command, target);
        }
    }
    /**
     * Handles the keydown event and routes it to the right command.
     * @param e The keydown event.
     */
    handleKeyDown_(e) {
        const target = e.target;
        for (const command of target.ownerDocument.querySelectorAll('command')) {
            if (!command.matchesEvent) {
                // Because Command uses injected methods the <command> in the DOM might
                // not have been initialized yet.
                continue;
            }
            if (!command.matchesEvent(e)) {
                continue;
            }
            // When invoking a command via a shortcut, we have to manually check if it
            // can be executed, since focus might not have been changed what would
            // have updated the command's state.
            command.canExecuteChange();
            if (!command.disabled) {
                e.preventDefault();
                // We do not want any other element to handle this.
                e.stopPropagation();
                command.execute();
                return;
            }
        }
    }
}
/**
 * The event type used for canExecute events.
 */
class CanExecuteEvent extends Event {
    /**
     * @param command The command that we are evaluating.
     */
    constructor(command) {
        super('canExecute', { bubbles: true, cancelable: true });
        this.command = command;
        /**
         * Whether the target can execute the command. Setting this also stops the
         * propagation and prevents the default. Callers can tell if an event has
         * been handled via |this.defaultPrevented|.
         */
        this.canExecute_ = false;
    }
    get canExecute() {
        return this.canExecute_;
    }
    set canExecute(canExecute) {
        this.canExecute_ = !!canExecute;
        this.stopPropagation();
        this.preventDefault();
    }
}

// Copyright 2012 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class MenuItem extends HTMLElement {
    constructor() {
        super(...arguments);
        this.command_ = null;
    }
    /**
     * Initializes the menu item.
     */
    initialize() {
        this.command_ = null;
        const commandId = this.getAttribute('command');
        if (commandId) {
            this.command = commandId;
        }
        this.addEventListener('mouseup', this.handleMouseUp_);
        // Adding the 'custom-appearance' class prevents widgets.css from changing
        // the appearance of this element.
        this.classList.add('custom-appearance');
        // Enable Text to Speech on the menu. Additionally, ID has to be set,
        // since it is used in element's aria-activedescendant attribute.
        if (!this.isSeparator()) {
            this.setAttribute('role', 'menuitem');
            this.setAttribute('tabindex', this.getAttribute('tabindex') || '-1');
        }
        const iconUrl = this.getAttribute('icon');
        if (iconUrl) {
            this.iconUrl = iconUrl;
        }
    }
    /**
     * Creates a new menu separator element.
     * @return The new separator element.
     */
    static createSeparator() {
        const el = document.createElement('hr');
        return crInjectTypeAndInit(el, MenuItem);
    }
    /**
     * The command associated with this menu item. If this is set to a string
     * of the form "#element-id" then the element is looked up in the document
     * of the command.
     */
    get command() {
        return this.command_;
    }
    set command(command) {
        if (this.command_) {
            this.command_.removeEventListener('labelChange', this);
            this.command_.removeEventListener('disabledChange', this);
            this.command_.removeEventListener('hiddenChange', this);
            this.command_.removeEventListener('checkedChange', this);
        }
        if (typeof command === 'string' && command[0] === '#') {
            command = this.ownerDocument.body.querySelector(command);
            assert$1(command);
            crInjectTypeAndInit(command, Command);
        }
        command = command;
        this.command_ = command;
        if (command) {
            if (command.id) {
                this.setAttribute('command', '#' + command.id);
            }
            if (command.label) {
                this.label = command.label;
            }
            this.disabled = command.disabled;
            this.hidden = command.hidden;
            this.checked = command.checked;
            this.command_.addEventListener('labelChange', this);
            this.command_.addEventListener('disabledChange', this);
            this.command_.addEventListener('hiddenChange', this);
            this.command_.addEventListener('checkedChange', this);
        }
        this.updateShortcut_();
    }
    /**
     * The text label.
     */
    get label() {
        return this.textContent;
    }
    set label(label) {
        this.textContent = label;
    }
    /**
     * Menu icon.
     */
    get iconUrl() {
        return this.style.backgroundImage;
    }
    set iconUrl(url) {
        this.style.backgroundImage = 'url(' + url + ')';
    }
    /**
     * @return Whether the menu item is a separator.
     */
    isSeparator() {
        return this.tagName === 'HR';
    }
    /**
     * Updates shortcut text according to associated command. If command has
     * multiple shortcuts, only first one is displayed.
     */
    updateShortcut_() {
        this.removeAttribute('shortcutText');
        if (!this.command_ || !this.command_.shortcut ||
            this.command_.hideShortcutText) {
            return;
        }
        const shortcuts = this.command_.shortcut.split(/\s+/);
        if (shortcuts.length === 0) {
            return;
        }
        const shortcut = shortcuts[0];
        const mods = {};
        let ident = '';
        shortcut.split('|').forEach((part) => {
            const partUc = part.toUpperCase();
            switch (partUc) {
                case 'CTRL':
                case 'ALT':
                case 'SHIFT':
                case 'META':
                    mods[partUc] = true;
                    break;
                default:
                    console.assert(!ident, 'Shortcut has two non-modifier keys');
                    ident = part;
            }
        });
        let shortcutText = '';
        ['CTRL', 'ALT', 'SHIFT', 'META'].forEach((mod) => {
            if (mods[mod]) {
                shortcutText += loadTimeData.getString('SHORTCUT_' + mod) + '+';
            }
        });
        if (ident === ' ') {
            ident = 'Space';
        }
        if (ident.length !== 1) {
            shortcutText += loadTimeData.getString('SHORTCUT_' + ident.toUpperCase());
        }
        else {
            shortcutText += ident.toUpperCase();
        }
        this.setAttribute('shortcutText', shortcutText);
    }
    /**
     * Handles mouseup events. This dispatches an activate event; if there is an
     * associated command, that command is executed.
     * @param e The mouseup event object.
     */
    handleMouseUp_(e) {
        // Only dispatch an activate event for left or middle click.
        if (e.button > 1) {
            return;
        }
        if (!this.disabled && !this.isSeparator() && this.selected) {
            // Store |contextElement| since it'll be removed by {Menu} on handling
            // 'activate' event.
            const parent = this.parentElement;
            const contextElement = parent.contextElement;
            const activationEvent = document.createEvent('Event');
            activationEvent.initEvent('activate', true, true);
            activationEvent.originalEvent = e;
            // Dispatch command event followed by executing the command object.
            if (this.dispatchEvent(activationEvent)) {
                const command = this.command;
                if (command) {
                    command.execute(contextElement);
                    swallowDoubleClick(e);
                }
            }
        }
    }
    /**
     * Updates command according to the node on which this menu was invoked.
     * @param node Node on which menu was opened.
     */
    updateCommand(node) {
        if (this.command_) {
            this.command_.canExecuteChange(node);
        }
    }
    /**
     * Handles changes to the associated command.
     * @param e The event object.
     */
    handleEvent(e) {
        if (!this.command) {
            return;
        }
        switch (e.type) {
            case 'disabledChange':
                this.disabled = this.command.disabled;
                break;
            case 'hiddenChange':
                this.hidden = this.command.hidden;
                break;
            case 'labelChange':
                this.label = this.command.label;
                break;
            case 'checkedChange':
                this.checked = this.command.checked;
                break;
        }
    }
    /**
     * Whether the menu item is disabled or not.
     */
    get disabled() {
        return this.hasAttribute('disabled');
    }
    set disabled(value) {
        boolAttrSetter(this, 'disabled', value);
    }
    /**
     * Whether the menu item is hidden or not.
     */
    get hidden() {
        return this.hasAttribute('hidden');
    }
    set hidden(value) {
        boolAttrSetter(this, 'hidden', value);
    }
    /**
     * Whether the menu item is selected or not.
     */
    get selected() {
        return this.hasAttribute('selected');
    }
    set selected(value) {
        boolAttrSetter(this, 'selected', value);
    }
    /**
     * Whether the menu item is checked or not.
     */
    get checked() {
        return this.hasAttribute('checked');
    }
    set checked(value) {
        boolAttrSetter(this, 'checked', value);
    }
    /**
     * Whether the menu item is checkable or not.
     */
    get checkable() {
        return this.hasAttribute('checkable');
    }
    set checkable(value) {
        boolAttrSetter(this, 'checkable', value);
    }
}
/**
 * Users complain they occasionally use doubleclicks instead of clicks
 * (http://crbug.com/140364). To fix it we freeze click handling for the
 * double-click time interval.
 * @param e Initial click event.
 */
function swallowDoubleClick(e) {
    const target = e.target;
    const doc = target.ownerDocument;
    let counter = Math.min(1, e.detail);
    function swallow(e) {
        e.stopPropagation();
        e.preventDefault();
    }
    function onclick(e) {
        if (e.detail > counter) {
            counter = e.detail;
            // Swallow the click since it's a click inside the double-click timeout.
            swallow(e);
        }
        else {
            // Stop tracking clicks and let regular handling.
            doc.removeEventListener('dblclick', swallow, true);
            doc.removeEventListener('click', onclick, true);
        }
    }
    // The following 'click' event (if e.type === 'mouseup') mustn't be taken
    // into account (it mustn't stop tracking clicks). Start event listening
    // after zero timeout.
    setTimeout(() => {
        doc.addEventListener('click', onclick, true);
        doc.addEventListener('dblclick', swallow, true);
    });
}

// Copyright 2012 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class Menu extends HTMLElement {
    constructor() {
        super(...arguments);
        this.selectedIndex_ = -1;
        /**
         * Element for which menu is being shown.
         */
        this.contextElement = null;
        this.shown_ = null;
    }
    /**
     * Initializes the menu element.
     */
    initialize() {
        this.selectedIndex_ = -1;
        this.contextElement = null;
        this.shown_ = null;
        this.addEventListener('mouseover', this.handleMouseOver_);
        this.addEventListener('mouseout', this.handleMouseOut_);
        this.addEventListener('mouseup', this.handleMouseUp_, true);
        this.classList.add('decorated');
        this.setAttribute('role', 'menu');
        this.hidden = true; // Hide the menu by default.
        // Decorate the children as menu items.
        for (const item of this.menuItems) {
            crInjectTypeAndInit(item, MenuItem);
        }
    }
    /**
     * Adds menu item at the end of the list.
     * @param item Menu item properties.
     * @return The created menu item.
     */
    addMenuItem(item = {}) {
        const menuItem = this.ownerDocument.createElement('cr-menu-item');
        this.appendChild(menuItem);
        crInjectTypeAndInit(menuItem, MenuItem);
        if (item.label) {
            menuItem.label = item.label;
        }
        if (item.iconUrl) {
            menuItem.iconUrl = item.iconUrl;
        }
        return menuItem;
    }
    /**
     * Adds separator at the end of the list.
     */
    addSeparator() {
        const separator = this.ownerDocument.createElement('hr');
        crInjectTypeAndInit(separator, MenuItem);
        this.appendChild(separator);
    }
    /**
     * Clears menu.
     */
    clear() {
        this.selectedItem = undefined;
        this.textContent = '';
    }
    /**
     * Walks up the ancestors of |node| until a menu item belonging to this menu
     * is found.
     * @param node The node to start searching from.
     * @return The found menu item or undefined.
     */
    findMenuItem(node) {
        while (node && node.parentNode !== this && !(node instanceof MenuItem)) {
            node = node.parentNode;
        }
        if (node) {
            assertInstanceof$1(node, MenuItem);
            return node;
        }
        return undefined;
    }
    /**
     * Handles mouseover events and selects the hovered item.
     */
    handleMouseOver_(e) {
        const target = e.target;
        const overItem = this.findMenuItem(target);
        this.selectedItem = overItem;
    }
    /**
     * Handles mouseout events and deselects any selected item.
     * @param e The mouseout event.
     */
    handleMouseOut_(_e) {
        this.selectedItem = undefined;
    }
    /**
     * If there's a mouseup that happens quickly in about the same position,
     * stop it from propagating to items. This is to prevent accidentally
     * selecting a menu item that's created under the mouse cursor.
     * @param e A mouseup event on the menu (in capturing phase).
     */
    handleMouseUp_(e) {
        const target = e.target;
        assert$1(this.contains(target));
        assert$1(this.shown_);
        if (!this.trustEvent_(e) || Date.now() - this.shown_.time > 200) {
            return;
        }
        const pos = this.shown_.mouseDownPos;
        if (!pos || Math.abs(pos.x - e.screenX) + Math.abs(pos.y - e.screenY) > 4) {
            return;
        }
        e.preventDefault();
        e.stopPropagation();
    }
    /**
     * @return Whether `e` can be trusted.
     */
    trustEvent_(e) {
        return e.isTrusted || e.isTrustedForTesting;
    }
    get menuItems() {
        return Array.from(this.querySelectorAll(this.menuItemSelector || '*'));
    }
    /**
     * The selected menu item or undefined if none.
     */
    get selectedItem() {
        return this.menuItems[this.selectedIndex];
    }
    set selectedItem(item) {
        const index = this.menuItems.indexOf(item);
        this.selectedIndex = index;
    }
    /**
     * Focuses the selected item. If selectedIndex is invalid, set it to 0
     * first.
     */
    focusSelectedItem() {
        const items = this.menuItems;
        if (this.selectedIndex < 0 || this.selectedIndex > items.length) {
            // Find first visible item to focus by default.
            for (const [idx, item] of items.entries()) {
                if (item.hasAttribute('hidden') || item.isSeparator()) {
                    continue;
                }
                // If the item is disabled we accept it, but try to find the next
                // enabled item, but keeping the first disabled item.
                if (!item.disabled) {
                    this.selectedIndex = idx;
                    break;
                }
                else if (this.selectedIndex === -1) {
                    this.selectedIndex = idx;
                }
            }
        }
        if (this.selectedItem) {
            this.selectedItem.focus();
            this.setAttribute('aria-activedescendant', this.selectedItem.id);
        }
    }
    /**
     * Menu length
     */
    get length() {
        return this.menuItems.length;
    }
    /**
     * Returns whether the given menu item is visible.
     */
    isItemVisible_(menuItem) {
        if (menuItem.hidden) {
            return false;
        }
        if (menuItem.offsetParent) {
            return true;
        }
        // A "position: fixed" element won't have an offsetParent, so we have to
        // do the full style computation.
        return window.getComputedStyle(menuItem).display !== 'none';
    }
    /**
     * Returns whether the menu has any visible items.
     * @return True if the menu has visible item. Otherwise, false.
     */
    hasVisibleItems() {
        // Inspect items in reverse order to determine if the separator above each
        // set of items is required.
        for (const menuItem of this.menuItems) {
            if (this.isItemVisible_(menuItem)) {
                return true;
            }
        }
        return false;
    }
    /**
     * This is the function that handles keyboard navigation. This is usually
     * called by the element responsible for managing the menu.
     * @param e The keydown event object.
     * @return Whether the event was handled be the menu.
     */
    handleKeyDown(e) {
        let item = this.selectedItem;
        const self = this;
        const selectNextAvailable = (m) => {
            const menuItems = self.menuItems;
            const len = menuItems.length;
            if (!len) {
                // Edge case when there are no items.
                return;
            }
            let i = self.selectedIndex;
            if (i === -1 && m === -1) {
                // Edge case when needed to go the last item first.
                i = 0;
            }
            // `i` may be negative(-1), so modulus operation and cycle below
            // wouldn't work as assumed. This trick makes startPosition positive
            // without altering it's modulo.
            const startPosition = (i + len) % len;
            while (true) {
                i = (i + m + len) % len;
                // Check not to enter into infinite loop if all items are hidden or
                // disabled.
                if (i === startPosition) {
                    break;
                }
                item = menuItems[i];
                if (item && !item.isSeparator() && !item.disabled &&
                    this.isItemVisible_(item)) {
                    break;
                }
            }
            if (item && !item.disabled) {
                self.selectedIndex = i;
            }
        };
        switch (e.key) {
            case 'ArrowDown':
                selectNextAvailable(1);
                this.focusSelectedItem();
                return true;
            case 'ArrowUp':
                selectNextAvailable(-1);
                this.focusSelectedItem();
                return true;
            case 'Enter':
            case ' ':
                if (item) {
                    // Store |contextElement| since it'll be removed when handling the
                    // 'activate' event.
                    const contextElement = this.contextElement;
                    const activationEvent = document.createEvent('Event');
                    activationEvent.initEvent('activate', true, true);
                    activationEvent.originalEvent = e;
                    if (item.dispatchEvent(activationEvent)) {
                        if (item.command) {
                            item.command.execute(contextElement);
                        }
                    }
                }
                return true;
        }
        return false;
    }
    hide() {
        this.hidden = true;
        this.shown_ = null;
    }
    show(mouseDownPos) {
        this.shown_ = { mouseDownPos: mouseDownPos, time: Date.now() };
        this.hidden = false;
    }
    /**
     * Updates menu items command according to context.
     * @param node Node for which to actuate commands state.
     */
    updateCommands(node) {
        const menuItems = this.menuItems;
        for (const menuItem of menuItems) {
            if (!menuItem.isSeparator()) {
                menuItem.updateCommand(node);
            }
        }
        let separatorRequired = false;
        let lastSeparator = null;
        // Hide any separators without a visible item between them and the next
        // separator or the end of the menu.
        for (const menuItem of menuItems) {
            if (menuItem.isSeparator()) {
                if (separatorRequired) {
                    lastSeparator = menuItem;
                }
                menuItem.hidden = true;
                separatorRequired = false;
                continue;
            }
            if (this.isItemVisible_(menuItem)) {
                if (lastSeparator) {
                    lastSeparator.hidden = false;
                }
                separatorRequired = true;
            }
        }
    }
    selectedIndexChanged_(oldSelectedIndex) {
        const oldSelectedItem = this.menuItems[oldSelectedIndex];
        if (oldSelectedItem) {
            oldSelectedItem.selected = false;
            oldSelectedItem.blur();
        }
        const item = this.selectedItem;
        if (item) {
            item.selected = true;
        }
    }
    /**
     * The selected menu item.
     */
    get selectedIndex() {
        return this.selectedIndex_;
    }
    set selectedIndex(value) {
        const oldValue = this.selectedIndex_;
        this.selectedIndex_ = value;
        this.selectedIndexChanged_(oldValue);
        dispatchPropertyChange(this, 'selectedIndex', value, oldValue);
    }
    /**
     * Selector for children which are menu items.
     */
    get menuItemSelector() {
        return this.getAttribute(convertToKebabCase('menuItemSelector')) ?? '';
    }
    set menuItemSelector(value) {
        domAttrSetter(this, 'menuItemSelector', value);
    }
}

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * Creates a menu that supports sub-menus.
 *
 * This works almost identically to Menu apart from supporting
 * sub menus hanging off a <cr-menu-item> element. To add a sub menu
 * to a top level menu item, add a 'sub-menu' attribute which has as
 * its value an id selector for another <cr-menu> element.
 * (e.g. <cr-menu-item sub-menu="other-menu">).
 */
class MultiMenu extends Menu {
    constructor() {
        super(...arguments);
        /**
         * Whether a sub-menu is positioned on the left of its parent.
         * Used to direct the arrow key navigation.
         */
        this.subMenuOnLeft = null;
        /**
         * Property that hosts sub-menus for filling with overflow items.
         * Used for menu-items that overflow parent menu.
         */
        this.overflow = null;
        /**
         * Reference to the menu that the user is currently navigating.
         * Used to route events to the correct menu.
         */
        this.currentMenu = undefined;
        /** Sub menu being used. */
        this.subMenu = null;
        /** Menu item hosting a sub menu. */
        this.parentMenuItem = undefined;
        /**
         * Padding used when restricting menu height when the window is too small
         * to show the entire menu.
      
         * Padding on cr.menu + 2px.
         */
        this.menuEndGap_ = 0;
        /**
         * AbortController allows for global aborting of all event listeners and thus
         * their removal from the DOM.
         */
        this.abortController_ = null;
    }
    initialize() {
        super.initialize();
        this.currentMenu = this;
        this.menuEndGap_ = 18; // padding on cr.menu + 2px
    }
    /**
     * Handles event callbacks.
     * @param e The event object.
     */
    handleEvent(e) {
        switch (e.type) {
            case 'activate':
                if (e.currentTarget === this) {
                    const target = e.target;
                    // Don't activate if there's a sub-menu to show
                    const item = this.findMenuItem(target);
                    if (item) {
                        const subMenuId = item.getAttribute('sub-menu');
                        if (subMenuId) {
                            e.preventDefault();
                            e.stopPropagation();
                            // Show the sub menu if needed.
                            if (!item.getAttribute('sub-menu-shown')) {
                                this.showSubMenu();
                            }
                        }
                    }
                }
                else {
                    // If the event was fired by the sub-menu, send an activate event to
                    // the top level menu.
                    const activationEvent = document.createEvent('Event');
                    activationEvent.initEvent('activate', true, true);
                    activationEvent.originalEvent =
                        e.originalEvent;
                    this.dispatchEvent(activationEvent);
                }
                break;
            case 'keydown':
                switch (e.key) {
                    case 'ArrowLeft':
                    case 'ArrowRight':
                        if (!this.currentMenu) {
                            break;
                        }
                        const key = e.key;
                        if (this.currentMenu === this) {
                            const menuItem = this.currentMenu.selectedItem;
                            const subMenu = this.getSubMenuFromItem(menuItem);
                            if (subMenu) {
                                if (subMenu.hidden) {
                                    break;
                                }
                                if (this.subMenuOnLeft && key === 'ArrowLeft') {
                                    this.moveSelectionToSubMenu_(subMenu);
                                }
                                else if (this.subMenuOnLeft === false && key === 'ArrowRight') {
                                    this.moveSelectionToSubMenu_(subMenu);
                                }
                            }
                        }
                        else {
                            const subMenu = this.currentMenu;
                            // We only move off the sub-menu if we're on the top item
                            if (subMenu.selectedIndex === 0) {
                                if (this.subMenuOnLeft && key === 'ArrowRight') {
                                    this.moveSelectionToTopMenu_(subMenu);
                                }
                                else if (this.subMenuOnLeft === false && key === 'ArrowLeft') {
                                    this.moveSelectionToTopMenu_(subMenu);
                                }
                            }
                        }
                        break;
                    case 'ArrowDown':
                    case 'ArrowUp':
                        // Hide any showing sub-menu if we're moving in the parent.
                        if (this.currentMenu === this) {
                            this.hideSubMenu_();
                        }
                        break;
                }
                break;
            case 'mouseover':
            case 'mouseout':
                this.manageSubMenu(e);
                break;
        }
    }
    /**
     * This event handler is used to redirect keydown events to
     * the top level and sub-menus when they're active.
     * Menu has a handleKeyDown() method and to support
     * sub-menus we monkey patch the cr.ui.menu call via
     * this.handleKeyDown_() and if any sub menu is active, by
     * calling the Menu method directly.
     * @param e The keydown event object.
     * @return Whether the event was handled be the menu.
     */
    handleKeyDown(e) {
        if (!this.currentMenu) {
            return false;
        }
        if (this.currentMenu === this) {
            return super.handleKeyDown(e);
        }
        else {
            return this.currentMenu.handleKeyDown(e);
        }
    }
    /**
     * Position the sub menu adjacent to the cr-menu-item that triggered it.
     * @param item The menu item to position against.
     * @param subMenu The child (sub) menu to be positioned.
     */
    positionSubMenu_(item, subMenu) {
        const style = subMenu.style;
        style.marginTop = '0'; // crbug.com/1066727
        // The sub-menu needs to sit aligned to the top and side of
        // the menu-item passed in. It also needs to fit inside the viewport
        const itemRect = item.getBoundingClientRect();
        const viewportWidth = window.innerWidth;
        const viewportHeight = window.innerHeight;
        const childRect = subMenu.getBoundingClientRect();
        const maxShift = itemRect.width / 2;
        // See if it fits on the right, if not position on the left
        // if there's more room on the left.
        style.left = style.right = style.top = style.bottom = 'auto';
        if ((itemRect.right + childRect.width) > viewportWidth &&
            ((viewportWidth - itemRect.right) < itemRect.left)) {
            let leftPosition = itemRect.left - childRect.width;
            // Allow some menu overlap if sub menu will be clipped off.
            if (leftPosition < 0) {
                if (leftPosition < -maxShift) {
                    leftPosition += maxShift;
                }
                else {
                    leftPosition = 0;
                }
            }
            this.subMenuOnLeft = true;
            style.left = leftPosition + 'px';
        }
        else {
            let rightPosition = itemRect.right;
            // Allow overlap on the right to reduce sub menu clip.
            if ((rightPosition + childRect.width) > viewportWidth) {
                if ((rightPosition + childRect.width - viewportWidth) > maxShift) {
                    rightPosition -= maxShift;
                }
                else {
                    rightPosition = viewportWidth - childRect.width;
                }
            }
            this.subMenuOnLeft = false;
            style.left = rightPosition + 'px';
        }
        style.top = itemRect.top + 'px';
        // Size the subMenu to fit inside the height of the viewport
        // Always set the maximum height so that expanding the window
        // allows the menu height to grow crbug/934207
        style.maxHeight = (viewportHeight - itemRect.top - this.menuEndGap_) + 'px';
        // Let the browser deal with scroll bar generation.
        style.overflowY = 'auto';
    }
    /**
     * Get the subMenu hanging off a menu-item if it exists.
     * @param item The menu item.
     */
    getSubMenuFromItem(item) {
        if (!item) {
            return null;
        }
        const subMenuId = item.getAttribute('sub-menu');
        if (subMenuId === null) {
            return null;
        }
        return document.querySelector(subMenuId);
    }
    /**
     * Display any sub-menu hanging off the current selection.
     */
    showSubMenu() {
        const item = this.selectedItem;
        const subMenu = this.getSubMenuFromItem(item);
        if (subMenu) {
            this.subMenu = subMenu;
            if (item) {
                item.setAttribute('sub-menu-shown', 'shown');
                this.positionSubMenu_(item, subMenu);
            }
            subMenu.show();
            subMenu.parentMenuItem = item;
            this.moveSelectionToSubMenu_(subMenu);
        }
    }
    /**
     * Find any sub-menu hanging off the event target and show/hide it.
     * @param e The event object.
     */
    manageSubMenu(e) {
        const target = e.target;
        const item = this.findMenuItem(target);
        const subMenu = this.getSubMenuFromItem(item);
        if (!subMenu) {
            return;
        }
        this.subMenu = subMenu;
        switch (e.type) {
            case 'activate':
            case 'mouseover':
                // Hide any other sub menu being shown.
                const showing = this.querySelector('cr-menu-item[sub-menu-shown]');
                if (showing && showing !== item) {
                    showing.removeAttribute('sub-menu-shown');
                    const shownSubMenu = this.getSubMenuFromItem(showing);
                    if (shownSubMenu) {
                        shownSubMenu.hide();
                    }
                }
                if (item) {
                    item.setAttribute('sub-menu-shown', 'shown');
                    this.positionSubMenu_(item, subMenu);
                }
                subMenu.show();
                break;
            case 'mouseout':
                // If we're on top of the sub-menu, we don't want to dismiss it
                const childRect = subMenu.getBoundingClientRect();
                if (childRect.left <= e.clientX && e.clientX < childRect.right &&
                    childRect.top <= e.clientY && e.clientY < childRect.bottom) {
                    this.currentMenu = subMenu;
                    break;
                }
                item?.removeAttribute('sub-menu-shown');
                subMenu.hide();
                this.subMenu = null;
                this.currentMenu = this;
                break;
        }
    }
    /**
     * Change the selection from the top level menu to the first item
     * in the subMenu passed in.
     * @param subMenu sub-menu that should take selection.
     */
    moveSelectionToSubMenu_(subMenu) {
        this.selectedItem = undefined;
        this.currentMenu = subMenu;
        subMenu.selectedIndex = 0;
        subMenu.focusSelectedItem();
    }
    /**
     * Change the selection from the sub menu to the top level menu.
     * @param subMenu sub-menu that should lose selection.
     */
    moveSelectionToTopMenu_(subMenu) {
        subMenu.selectedItem = undefined;
        this.currentMenu = this;
        this.selectedItem = subMenu.parentMenuItem;
        this.focusSelectedItem();
    }
    /**
     * Add event listeners to any sub menus.
     */
    addSubMenuListeners() {
        const items = this.querySelectorAll('cr-menu-item[sub-menu]');
        items.forEach((menuItem) => {
            const subMenuId = menuItem.getAttribute('sub-menu');
            if (subMenuId) {
                const subMenu = document.querySelector(subMenuId);
                if (subMenu) {
                    subMenu.addEventListener('activate', this, { signal: this.abortController_?.signal });
                }
            }
        });
    }
    show(mouseDownPos) {
        super.show(mouseDownPos);
        // When the menu is shown we steal all keyboard events.
        const doc = this.ownerDocument;
        this.abortController_ = new AbortController();
        const signal = this.abortController_.signal;
        if (doc) {
            doc.addEventListener('keydown', this, { capture: true, signal });
        }
        this.addEventListener('activate', this, { capture: true, signal });
        // Handle mouse-over to trigger sub menu opening on hover.
        this.addEventListener('mouseover', this, { signal });
        this.addEventListener('mouseout', this, { signal });
        this.addSubMenuListeners();
    }
    /**
     * Hides any sub-menu that is active.
     */
    hideSubMenu_() {
        const items = this.querySelectorAll('cr-menu-item[sub-menu][sub-menu-shown]');
        for (const menuItem of items) {
            const subMenuId = menuItem.getAttribute('sub-menu');
            if (subMenuId) {
                const subMenu = document.querySelector(subMenuId);
                if (subMenu) {
                    subMenu.hide();
                }
                menuItem.removeAttribute('sub-menu-shown');
            }
        }
        this.currentMenu = this;
    }
    hide() {
        this.abortController_?.abort();
        // Hide any visible sub-menus first
        this.hideSubMenu_();
        super.hide();
    }
    /**
     * Check if a DOM element is containd within the main top
     * level menu or any sub-menu hanging off the top level menu.
     * @param node Node being tested for containment.
     */
    contains(node) {
        return super.contains(node) ||
            (this.subMenu ? this.subMenu.contains(node) : false);
    }
}

// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview This file provides utility functions for position popups.
 */
/**
 * Enum for defining how to anchor a popup to an anchor element.
 */
var AnchorType;
(function (AnchorType) {
    /**
     * The popup's right edge is aligned with the left edge of the anchor.
     * The popup's top edge is aligned with the top edge of the anchor.
     */
    AnchorType[AnchorType["BEFORE"] = 1] = "BEFORE";
    /**
     * The popop's left edge is aligned with the right edge of the anchor.
     * The popup's top edge is aligned with the top edge of the anchor.
     */
    AnchorType[AnchorType["AFTER"] = 2] = "AFTER";
    /**
     * The popop's bottom edge is aligned with the top edge of the anchor.
     * The popup's left edge is aligned with the left edge of the anchor.
     */
    AnchorType[AnchorType["ABOVE"] = 3] = "ABOVE";
    /**
     * The popop's top edge is aligned with the bottom edge of the anchor.
     * The popup's left edge is aligned with the left edge of the anchor.
     */
    AnchorType[AnchorType["BELOW"] = 4] = "BELOW";
})(AnchorType || (AnchorType = {}));
/**
 * Helper function for positionPopupAroundElement and positionPopupAroundRect.
 * @param anchorRect The rect for the anchor.
 * @param popupElement The element used for the popup.
 * @param type The type of anchoring to do.
 * @param invertLeftRight [Optional] Whether to invert the right/left
 *     alignment.
 */
function positionPopupAroundRect(anchorRect, popupElement, type, invertLeftRight) {
    const popupRect = popupElement.getBoundingClientRect();
    let availRect;
    const ownerDoc = popupElement.ownerDocument;
    const cs = ownerDoc.defaultView.getComputedStyle(popupElement);
    const docElement = ownerDoc.documentElement;
    if (cs.position === 'fixed') {
        // For 'fixed' positioned popups, the available rectangle should be based
        // on the viewport rather than the document.
        availRect = {
            height: docElement.clientHeight,
            width: docElement.clientWidth,
            top: 0,
            bottom: docElement.clientHeight,
            left: 0,
            right: docElement.clientWidth,
        };
    }
    else {
        availRect = popupElement.offsetParent.getBoundingClientRect();
    }
    if (cs.direction === 'rtl') {
        invertLeftRight = !invertLeftRight;
    }
    // Flip BEFORE, AFTER based on alignment.
    if (invertLeftRight) {
        if (type === AnchorType.BEFORE) {
            type = AnchorType.AFTER;
        }
        else if (type === AnchorType.AFTER) {
            type = AnchorType.BEFORE;
        }
    }
    // Flip type based on available size
    switch (type) {
        case AnchorType.BELOW:
            if (anchorRect.bottom + popupRect.height > availRect.height &&
                popupRect.height <= anchorRect.top) {
                type = AnchorType.ABOVE;
            }
            break;
        case AnchorType.ABOVE:
            if (popupRect.height > anchorRect.top &&
                anchorRect.bottom + popupRect.height <= availRect.height) {
                type = AnchorType.BELOW;
            }
            break;
        case AnchorType.AFTER:
            if (anchorRect.right + popupRect.width > availRect.width &&
                popupRect.width <= anchorRect.left) {
                type = AnchorType.BEFORE;
            }
            break;
        case AnchorType.BEFORE:
            if (popupRect.width > anchorRect.left &&
                anchorRect.right + popupRect.width <= availRect.width) {
                type = AnchorType.AFTER;
            }
            break;
    }
    // flipping done
    const style = popupElement.style;
    // Reset all directions.
    style.left = style.right = style.top = style.bottom = 'auto';
    // Primary direction
    switch (type) {
        case AnchorType.BELOW:
            if (anchorRect.bottom + popupRect.height <= availRect.height) {
                style.top = anchorRect.bottom + 'px';
            }
            else {
                style.bottom = '0';
            }
            break;
        case AnchorType.ABOVE:
            if (availRect.height - anchorRect.top >= 0) {
                style.bottom = availRect.height - anchorRect.top + 'px';
            }
            else {
                style.top = '0';
            }
            break;
        case AnchorType.AFTER:
            if (anchorRect.right + popupRect.width <= availRect.width) {
                style.left = anchorRect.right + 'px';
            }
            else {
                style.right = '0';
            }
            break;
        case AnchorType.BEFORE:
            if (availRect.width - anchorRect.left >= 0) {
                style.right = availRect.width - anchorRect.left + 'px';
            }
            else {
                style.left = '0';
            }
            break;
    }
    // Secondary direction
    switch (type) {
        case AnchorType.BELOW:
        case AnchorType.ABOVE:
            if (invertLeftRight) {
                // align right edges
                if (anchorRect.right - popupRect.width >= 0) {
                    style.right = availRect.width - anchorRect.right + 'px';
                    // align left edges
                }
                else if (anchorRect.left + popupRect.width <= availRect.width) {
                    style.left = anchorRect.left + 'px';
                    // not enough room on either side
                }
                else {
                    style.right = '0';
                }
            }
            else {
                // align left edges
                if (anchorRect.left + popupRect.width <= availRect.width) {
                    style.left = anchorRect.left + 'px';
                    // align right edges
                }
                else if (anchorRect.right - popupRect.width >= 0) {
                    style.right = availRect.width - anchorRect.right + 'px';
                    // not enough room on either side
                }
                else {
                    style.left = '0';
                }
            }
            break;
        case AnchorType.AFTER:
        case AnchorType.BEFORE:
            // align top edges
            if (anchorRect.top + popupRect.height <= availRect.height) {
                style.top = anchorRect.top + 'px';
                // align bottom edges
            }
            else if (anchorRect.bottom - popupRect.height >= 0) {
                style.bottom = availRect.height - anchorRect.bottom + 'px';
                // not enough room on either side
            }
            else {
                style.top = '0';
            }
            break;
    }
}
/**
 * Positions a popup element relative to an anchor element. The popup element
 * should have position set to absolute and it should be a child of the body
 * element.
 * @param anchorElement The element that the popup is anchored
 *     to.
 * @param popupElement The popup element we are positioning.
 * @param type The type of anchoring we want.
 * @param invertLeftRight [Optional] Whether to invert the right/left
 *     alignment.
 */
function positionPopupAroundElement(anchorElement, popupElement, type, invertLeftRight) {
    const anchorRect = anchorElement.getBoundingClientRect();
    positionPopupAroundRect(anchorRect, popupElement, type, !!invertLeftRight);
}
/**
 * Positions a popup around a point.
 * @param x The client x position.
 * @param y The client y position.
 * @param popupElement The popup element we are positioning.
 * @param anchorType [Optional] The type of anchoring we want.
 */
function positionPopupAtPoint(x, y, popupElement, anchorType = AnchorType.BELOW) {
    positionPopupAroundRect(new DOMRect(x, y, 0, 0), popupElement, anchorType);
}

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * Enum for type of hide. Delayed is used when called by clicking on a
 * checkable menu item.
 */
var HideType;
(function (HideType) {
    HideType[HideType["INSTANT"] = 0] = "INSTANT";
    HideType[HideType["DELAYED"] = 1] = "DELAYED";
})(HideType || (HideType = {}));
/**
 * A button that displays a MultiMenu (menu with sub-menus).
 */
class MultiMenuButton extends CrButtonElement {
    constructor() {
        super(...arguments);
        /**
         * Property that hosts sub-menus for filling with overflow items.
         * Used for menu-items that overflow parent menu.
         */
        this.overflow = null;
        /**
         * Padding used when restricting menu height when the window is too small
         * to show the entire menu.
         */
        this.menuEndGap_ = 0; // padding on cr.menu + 2px
        this.abortController_ = null;
        this.menu_ = null;
        this.observer_ = null;
        this.observedElement_ = null;
    }
    /**
     * Initializes the menu button.
     */
    initialize() {
        this.setAttribute('aria-expanded', 'false');
        // Listen to the touch events on the document so that we can handle it
        // before cancelled by other UI components.
        this.ownerDocument.addEventListener('touchstart', this, { passive: true });
        this.addEventListener('mousedown', this);
        this.addEventListener('keydown', this);
        this.addEventListener('dblclick', this);
        this.addEventListener('blur', this);
        this.menuEndGap_ = 18; // padding on cr.menu + 2px
        // Adding the 'custom-appearance' class prevents widgets.css from
        // changing the appearance of this element.
        this.classList.add('custom-appearance');
        this.classList.add('menu-button'); // For styles in menu_button.css.
        this.menu = this.getAttribute('menu');
        // Align the menu if the button moves. When the button moves, the parent
        // container resizes.
        this.observer_ = new ResizeObserver(() => {
            this.positionMenu_();
        });
    }
    get menu() {
        return this.menu_;
    }
    setMenu_(menu) {
        if (typeof menu === 'string' && menu[0] === '#') {
            menu = this.ownerDocument.body.querySelector(menu);
            assert$1(menu);
            crInjectTypeAndInit(menu, MultiMenu);
        }
        this.menu_ = menu;
        if (menu) {
            if ('id' in this.menu_) {
                this.setAttribute('menu', '#' + this.menu_.id);
            }
        }
    }
    set menu(menu) {
        this.setMenu_(menu);
    }
    /**
     * Checks if the menu(s) should be closed based on the target of a mouse
     * click or a touch event target.
     * @param e The event object.
     */
    shouldDismissMenu_(e) {
        // All menus are dismissed when clicking outside the menus. If we are
        // showing a sub-menu, we need to detect if the target is the top
        // level menu, or in the sub menu when the sub menu is being shown.
        // The button is excluded here because it should toggle show/hide the
        // menu and handled separately.
        return e.target instanceof Node && !this.contains(e.target) &&
            !this.menu?.contains(e.target);
    }
    /**
     * Display any sub-menu hanging off the current selection.
     */
    showSubMenu() {
        if (!this.isMenuShown()) {
            return;
        }
        this.menu.showSubMenu();
    }
    /**
     * Do we have a menu visible to handle a keyboard event.
     * @return True if there's a visible menu.
     */
    hasVisibleMenu_() {
        if (this.isMenuShown()) {
            return true;
        }
        return false;
    }
    /**
     * Handles event callbacks.
     */
    handleEvent(e) {
        if (!this.menu) {
            return;
        }
        switch (e.type) {
            case 'touchstart':
                // Touch on the menu button itself is ignored to avoid that the menu
                // opened again by the mousedown event following the touch events.
                if (this.shouldDismissMenu_(e)) {
                    this.hideMenuWithoutTakingFocus_();
                }
                break;
            case 'mousedown':
                if (e.currentTarget === this.ownerDocument) {
                    if (this.shouldDismissMenu_(e)) {
                        this.hideMenuWithoutTakingFocus_();
                    }
                    else {
                        e.preventDefault();
                    }
                }
                else {
                    if (this.isMenuShown()) {
                        this.hideMenuWithoutTakingFocus_();
                    }
                    else if (e.button === 0) {
                        // Only show the menu when using left mouse button.
                        const mouseEvent = e;
                        this.showMenu(false, { x: mouseEvent.screenX, y: mouseEvent.screenY });
                        // Prevent the button from stealing focus on mousedown unless
                        // focus is on another button or cr-input element.
                        if (!(document.hasFocus() &&
                            (document.activeElement?.tagName === 'BUTTON' ||
                                document.activeElement?.tagName === 'CR-BUTTON' ||
                                document.activeElement?.tagName === 'CR-INPUT'))) {
                            e.preventDefault();
                        }
                    }
                }
                // Hide the focus ring on mouse click.
                this.classList.add('using-mouse');
                break;
            case 'keydown':
                this.handleKeyDown(e);
                // If a menu is visible we let it handle keyboard events intended for
                // the menu.
                if (e.currentTarget === this.ownerDocument && this.hasVisibleMenu_() &&
                    this.isMenuEvent(e)) {
                    this.menu.handleKeyDown(e);
                    e.preventDefault();
                    e.stopPropagation();
                }
                // Show the focus ring on keypress.
                this.classList.remove('using-mouse');
                break;
            case 'focus':
                if (this.shouldDismissMenu_(e)) {
                    this.hideMenu();
                    // Show the focus ring on focus - if it's come from a mouse event,
                    // the focus ring will be hidden in the mousedown event handler,
                    // executed after this.
                    this.classList.remove('using-mouse');
                }
                break;
            case 'blur':
                // No need to hide the focus ring anymore, without having focus.
                this.classList.remove('using-mouse');
                break;
            case 'activate':
                const hideDelayed = e.target instanceof MenuItem && e.target.checkable;
                const hideType = hideDelayed ? HideType.DELAYED : HideType.INSTANT;
                // If the menu-item hosts a sub-menu, don't hide
                if (this.menu.getSubMenuFromItem(e.target) !== null) {
                    break;
                }
                const activateEvent = e;
                if (activateEvent.originalEvent instanceof MouseEvent ||
                    activateEvent.originalEvent instanceof TouchEvent) {
                    this.hideMenuWithoutTakingFocus_(hideType);
                }
                else {
                    // Keyboard. Take focus to continue keyboard operation.
                    this.hideMenu(hideType);
                }
                break;
            case 'popstate':
            case 'resize':
                this.hideMenu();
                break;
            case 'contextmenu':
                if ((!this.menu || !this.menu.contains(e.target))) {
                    const mouseEvent = e;
                    this.showMenu(true, { x: mouseEvent.screenX, y: mouseEvent.screenY });
                }
                e.preventDefault();
                // Don't allow elements further up in the DOM to show their menus.
                e.stopPropagation();
                break;
            case 'dblclick':
                // Don't allow double click events to propagate.
                e.preventDefault();
                e.stopPropagation();
                break;
        }
    }
    /**
     * Shows the menu.
     * @param shouldSetFocus Whether to set focus on the
     *     selected menu item.
     * @param mousePos The position of the mouse
     *     when shown (in screen coordinates).
     */
    showMenu(shouldSetFocus, mousePos) {
        this.hideMenu();
        assert$1(this.menu);
        this.menu.updateCommands(this);
        const event = new UIEvent('menushow', { bubbles: true, cancelable: true, view: window });
        if (!this.dispatchEvent(event)) {
            return;
        }
        // Track element for which menu was opened so that command events are
        // dispatched to the correct element.
        this.menu.contextElement = this;
        this.menu.show(mousePos);
        // Toggle aria and open state.
        this.setAttribute('aria-expanded', 'true');
        this.setAttribute('menu-shown', '');
        // When the menu is shown we steal all keyboard events.
        const doc = this.ownerDocument;
        assert$1(doc.defaultView);
        const win = doc.defaultView;
        this.abortController_ = new AbortController();
        const signal = this.abortController_.signal;
        doc.addEventListener('keydown', this, { capture: true, signal });
        doc.addEventListener('mousedown', this, { capture: true, signal });
        doc.addEventListener('focus', this, { capture: true, signal });
        doc.addEventListener('scroll', this, { capture: true, signal });
        win.addEventListener('popstate', this, { signal });
        win.addEventListener('resize', this, { signal });
        this.menu.addEventListener('contextmenu', this, { signal });
        this.menu.addEventListener('activate', this, { signal });
        this.observedElement_ = this.parentElement;
        assert$1(this.observedElement_);
        assert$1(this.observer_);
        this.observer_.observe(this.observedElement_);
        this.positionMenu_();
        if (shouldSetFocus) {
            this.menu.focusSelectedItem();
        }
    }
    /**
     * Hides the menu. If your menu can go out of scope, make sure to call this
     * first.
     * @param hideType Type of hide.
     *     default: HideType.INSTANT.
     */
    hideMenu(hideType) {
        this.hideMenuInternal_(true, hideType);
    }
    /**
     * Hides the menu. If your menu can go out of scope, make sure to call this
     * first.
     * @param hideType Type of hide.
     *     default: HideType.INSTANT.
     */
    hideMenuWithoutTakingFocus_(hideType) {
        this.hideMenuInternal_(false, hideType);
    }
    /**
     * Hides the menu. If your menu can go out of scope, make sure to call this
     * first.
     * @param shouldTakeFocus Moves the focus to the button if true.
     * @param hideType Type of hide.
     *     default: HideType.INSTANT.
     */
    hideMenuInternal_(shouldTakeFocus, hideType) {
        if (!this.isMenuShown()) {
            return;
        }
        // Toggle aria and open state.
        this.setAttribute('aria-expanded', 'false');
        this.removeAttribute('menu-shown');
        assert$1(this.menu);
        assert$1(this.observer_);
        assert$1(this.observedElement_);
        if (hideType === HideType.DELAYED) {
            this.menu.classList.add('hide-delayed');
        }
        else {
            this.menu.classList.remove('hide-delayed');
        }
        this.menu.hide();
        this.abortController_?.abort();
        if (shouldTakeFocus) {
            this.focus();
        }
        this.observer_.unobserve(this.observedElement_);
        const event = new UIEvent('menuhide', { bubbles: true, cancelable: false, view: window });
        this.dispatchEvent(event);
    }
    /**
     * Whether the menu is shown.
     */
    isMenuShown() {
        return this.hasAttribute('menu-shown');
    }
    /**
     * Positions the menu below the menu button. We check the menu fits
     * in the viewport, and enable scrolling if required.
     */
    positionMenu_() {
        assert$1(this.menu);
        const style = this.menu.style;
        style.marginTop = '8px'; // crbug.com/1066727
        // Clear any maxHeight we've set from previous calls into here.
        style.maxHeight = 'none';
        const invertLeftRight = false;
        const anchorType = AnchorType.BELOW;
        positionPopupAroundElement(this, this.menu, anchorType, invertLeftRight);
        // Check if menu is larger than the viewport and adjust its height to
        // enable scrolling if so. Note: style.bottom would have been set to 0.
        const viewportHeight = window.innerHeight;
        const menuRect = this.menu.getBoundingClientRect();
        // Limit the height to fit in the viewport.
        style.maxHeight = (viewportHeight - this.menuEndGap_) + 'px';
        // If the menu is too tall, position 2px from the bottom of the viewport
        // so users can see the end of the menu (helps when scroll is needed).
        if ((menuRect.height + this.menuEndGap_) > viewportHeight) {
            style.bottom = '2px';
        }
        // Let the browser deal with scroll bar generation.
        style.overflowY = 'auto';
    }
    /**
     * Handles the keydown event for the menu button.
     */
    handleKeyDown(e) {
        switch (e.key) {
            case 'ArrowDown':
            case 'ArrowUp':
            case 'Enter':
            case ' ':
                if (!this.isMenuShown()) {
                    this.showMenu(true);
                }
                e.preventDefault();
                break;
            case 'Escape':
            case 'Tab':
                this.hideMenu();
                break;
        }
    }
    isMenuEvent(e) {
        switch (e.key) {
            case 'ArrowDown':
            case 'ArrowUp':
            case 'ArrowLeft':
            case 'ArrowRight':
            case 'Enter':
            case ' ':
            case 'Escape':
            case 'Tab':
                return true;
        }
        return false;
    }
}

// Copyright 2012 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * Handles context menus.
 */
class ContextMenuHandler extends FilesEventTarget {
    constructor() {
        super(...arguments);
        this.abortController_ = null;
        this.menu_ = null;
        this.hideTimestamp_ = null;
        this.keyIsDown_ = false;
        this.resizeObserver_ = null;
    }
    get menu() {
        return this.menu_;
    }
    isMenuEvent(e) {
        switch (e.key) {
            case 'ArrowDown':
            case 'ArrowUp':
            case 'ArrowLeft':
            case 'ArrowRight':
            case 'Enter':
            case ' ':
            case 'Escape':
            case 'Tab':
                return true;
        }
        return false;
    }
    getMenuPosition_(target, clientX, clientY) {
        // When the user presses the context menu key (on the keyboard) we need
        // to detect this.
        let x;
        let y;
        if (this.keyIsDown_) {
            let rect;
            if ('getRectForContextMenu' in target) {
                rect = target.getRectForContextMenu();
            }
            else {
                rect = target.getBoundingClientRect();
            }
            const offset = Math.min(rect.width, rect.height) / 2;
            x = rect.left + offset;
            y = rect.top + offset;
        }
        else {
            x = clientX;
            y = clientY;
        }
        return { x, y };
    }
    /**
     * Shows a menu as a context menu.
     * @param e The event triggering the show (usually a contextmenu event).
     * @param menu The menu to show.
     */
    showMenu(e, menu) {
        assertInstanceof$1(e.currentTarget, Node);
        menu.updateCommands(e.currentTarget);
        if (!menu.hasVisibleItems()) {
            return;
        }
        const htmlElement = e.currentTarget;
        const { x, y } = this.getMenuPosition_(htmlElement, e.clientX, e.clientY);
        this.menu_ = menu;
        menu.classList.remove('hide-delayed');
        menu.show({ x, y });
        menu.contextElement = htmlElement;
        // When the menu is shown we steal a lot of events.
        const doc = menu.ownerDocument;
        if (this.resizeObserver_) {
            this.resizeObserver_.disconnect();
        }
        this.resizeObserver_ = new ResizeObserver((_entries) => {
            positionPopupAtPoint(x, y, menu);
        });
        this.resizeObserver_.observe(menu);
        this.abortController_ = new AbortController();
        const signal = this.abortController_.signal;
        doc.addEventListener('keydown', this.handleKeyboardEvent_.bind(this), { signal, capture: true });
        doc.addEventListener('mousedown', this.handleMouseEvent_.bind(this), { signal, capture: true });
        doc.addEventListener('touchstart', this.handleTouchEvent_.bind(this), { signal, capture: true });
        doc.addEventListener('focus', this.handleFocusEvent_.bind(this), { signal });
        doc.defaultView?.addEventListener('popstate', this.handleHideMenuEvent_.bind(this), { signal });
        doc.defaultView?.addEventListener('resize', this.handleHideMenuEvent_.bind(this), { signal });
        doc.defaultView?.addEventListener('blur', this.handleHideMenuEvent_.bind(this), { signal });
        menu.addEventListener('contextmenu', this.handleContextMenuEvent_.bind(this), { signal });
        menu.addEventListener('activate', this.handleActivateEvent_.bind(this), { signal });
        const ev = new CustomEvent('show', { detail: { element: menu.contextElement, menu } });
        this.dispatchEvent(ev);
    }
    /**
     * Hide the currently shown menu.
     * @param hideType Type of hide.
     *     default: HideType.INSTANT.
     */
    hideMenu(hideType) {
        const menu = this.menu;
        if (!menu) {
            return;
        }
        if (hideType === HideType.DELAYED) {
            menu.classList.add('hide-delayed');
        }
        else {
            menu.classList.remove('hide-delayed');
        }
        menu.hide();
        const originalContextElement = menu.contextElement;
        menu.contextElement = null;
        this.abortController_?.abort();
        if (this.resizeObserver_) {
            this.resizeObserver_.unobserve(menu);
            this.resizeObserver_ = null;
        }
        menu.selectedIndex = -1;
        this.menu_ = null;
        // On windows we might hide the menu in a right mouse button up and if
        // that is the case we wait some short period before we allow the menu
        // to be shown again.
        this.hideTimestamp_ = 0;
        const ev = new CustomEvent('hide', { detail: { element: originalContextElement, menu } });
        this.dispatchEvent(ev);
    }
    handleKeyboardEvent_(e) {
        // Keep track of keydown state so that we can use that to determine the
        // reason for the contextmenu event.
        switch (e.type) {
            case 'keydown':
                this.keyIsDown_ = !e.ctrlKey && !e.altKey &&
                    // context menu key or Shift-F10.
                    (e.keyCode === 93 && !e.shiftKey || e.key === 'F10' && e.shiftKey);
                break;
            case 'keyup':
                this.keyIsDown_ = false;
                break;
        }
        if (!this.menu || e.type !== 'keydown') {
            return;
        }
        if (e.key === 'Escape') {
            this.hideMenu();
            e.stopPropagation();
            e.preventDefault();
            // If the menu is visible we let it handle all the keyboard events
            // intended for the menu.
        }
        else if (this.menu && this.isMenuEvent(e)) {
            this.menu.handleKeyDown(e);
            e.preventDefault();
            e.stopPropagation();
        }
    }
    handleTouchEvent_(e) {
        if (!this.menu?.contains(e.target)) {
            this.hideMenu();
        }
    }
    handleFocusEvent_(e) {
        if (!this.menu?.contains(e.target)) {
            this.hideMenu();
        }
    }
    handleHideMenuEvent_(_e) {
        if (this.menu) {
            this.hideMenu();
        }
    }
    handleActivateEvent_(e) {
        if (this.menu) {
            const hideDelayed = e.target instanceof MenuItem && e.target.checkable;
            this.hideMenu(hideDelayed ? HideType.DELAYED : HideType.INSTANT);
        }
    }
    handleContextMenuEvent_(e) {
        if ((!this.menu || !this.menu.contains(e.target)) &&
            (!this.hideTimestamp_ || Date.now() - this.hideTimestamp_ > 50)) {
            // Focus the item which triggers the context menu before showing the menu,
            // so when the menu hides, the focus can be brought back to the item.
            if (document.activeElement !== e.currentTarget) {
                e.currentTarget.focus();
            }
            this.showMenu(e, e.currentTarget.contextMenu);
        }
        e.preventDefault();
        e.stopPropagation();
    }
    /**
     * Handles mouse event callbacks.
     */
    handleMouseEvent_(e) {
        if (!this.menu) {
            return;
        }
        if (!this.menu.contains(e.target)) {
            this.hideMenu();
        }
        else {
            e.preventDefault();
        }
    }
    /**
     * Adds a contextMenu property to an element or element class.
     * @param elementOrClass The element or class to add the contextMenu property
     *     to.
     */
    addContextMenuProperty(elementOrClass) {
        const target = typeof elementOrClass === 'function' ?
            elementOrClass.prototype :
            elementOrClass;
        Object.defineProperty(target, 'contextMenu', {
            get: function () {
                return this.contextMenu_;
            },
            set: function (menu) {
                const oldContextMenu = this.contextMenu;
                if (typeof menu === 'string' && menu[0] === '#') {
                    menu = this.ownerDocument.getElementById(menu.slice(1));
                    crInjectTypeAndInit(menu, Menu);
                }
                if (menu === oldContextMenu) {
                    return;
                }
                if (oldContextMenu && !menu) {
                    this.abortController_?.abort();
                }
                if (menu && !oldContextMenu) {
                    this.abortController_ = new AbortController();
                    const signal = this.abortController_.signal;
                    this.addEventListener('contextmenu', contextMenuHandler.handleContextMenuEvent_.bind(contextMenuHandler), { signal });
                    this.addEventListener('keydown', contextMenuHandler.handleKeyboardEvent_.bind(contextMenuHandler), { signal });
                    this.addEventListener('keyup', contextMenuHandler.handleKeyboardEvent_.bind(contextMenuHandler), { signal });
                }
                this.contextMenu_ = menu;
                if (menu && menu.id) {
                    this.setAttribute('contextmenu', '#' + menu.id);
                }
                dispatchPropertyChange(this, 'contextMenu', menu, oldContextMenu);
            },
        });
        if (!target.getRectForContextMenu) {
            /**
             * @return The rect to use for positioning the context menu when the
             *     context menu is not opened using a mouse position.
             */
            target.getRectForContextMenu = function () {
                return this.getBoundingClientRect();
            };
        }
    }
    /**
     * Sets the given contextMenu to the given element. A contextMenu property
     * would be added if necessary.
     * @param element The element or class to set the contextMenu to.
     * @param contextMenu The contextMenu property to be set.
     */
    setContextMenu(element, contextMenu) {
        if (!element || !element.contextMenu) {
            this.addContextMenuProperty(element);
        }
        element.contextMenu = contextMenu;
    }
}
/**
 * The singleton context menu handler.
 */
const contextMenuHandler = new ContextMenuHandler();

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
var XfTreeItem_1;
/**
 * The number of pixels to indent per level.
 */
const TREE_ITEM_INDENT = 20;
let XfTreeItem = XfTreeItem_1 = class XfTreeItem extends XfBase {
    constructor() {
        super(...arguments);
        /**
         * `separator` attribute will show a top border for the tree item. It's
         * mainly used to identify this tree item is a start of the new section.
         */
        this.separator = false;
        /**
         * Indicate if a tree item is disabled or not. Disabled tree item will have
         * a grey out color, can't be selected, can't get focus. It can still have
         * children, but it can't be expanded, and the expand icon will be hidden.
         */
        this.disabled = false;
        /** Indicate if a tree item has been selected or not. */
        this.selected = false;
        /** Indicate if a tree item has been expanded or not. */
        this.expanded = false;
        /** Indicate if a tree item is in renaming mode or not. */
        this.renaming = false;
        /**
         * A tree item will have children if the child tree items have been inserted
         * to its default slot. Only use `mayHaveChildren` if we want the tree item
         * to appeared as having children even without the actual child tree items
         * (e.g. no DOM children). This is mainly used when we asynchronously loads
         * child tree items.
         */
        this.mayHaveChildren = false;
        /**
         * The icon of the tree item, will be displayed before the label text.
         * The icon value should come from `ICON_TYPES`, it will be passed
         * as `type` to a <xf-icon> widget to render an icon element.
         */
        this.icon = '';
        /**
         * The icon set is an object which contains multiple base64 image data, it
         * will be passed as `iconSet` property to `<xf-icon>` widget.
         * Note: `icon` will be ignored if `iconSet` is provided.
         */
        this.iconSet = null;
        /** The label text of the tree item. */
        this.label = '';
        /**
         * Indicate the level of this tree item, we use it to calculate the padding
         * indentation. Note: "aria-level" can be calculated by DOM structure so
         * no need to provide it explicitly.
         */
        this.level_ = 1;
        /** The child tree items. */
        this.items_ = [];
    }
    static get events() {
        return {
            /** Triggers when a tree item has been expanded. */
            TREE_ITEM_EXPANDED: 'tree_item_expanded',
            /** Triggers when a tree item has been collapsed. */
            TREE_ITEM_COLLAPSED: 'tree_item_collapsed',
        };
    }
    /** The level of the tree item, starting from 1. */
    get level() {
        return this.level_;
    }
    /** The child tree items. */
    get items() {
        return this.items_;
    }
    /** The child tree items which can be tabbed. */
    get tabbableItems() {
        return this.items_.filter(item => !item.disabled);
    }
    hasChildren() {
        return this.mayHaveChildren || this.items_.length > 0;
    }
    /**
     * Toggle the focusable for the item. We put the tabindex on the <li> element
     * instead of the whole <xf-tree-item> because <xf-tree-item> also includes
     * all children slots.
     *
     * We are delegate the focus to the <li> element in the shadow DOM, to make
     * sure the update is synchronous, we are operating on the DOM directly here
     * instead of updating this in the render() function.
     *
     * Note: "tabindex = -1" is also considered as "focusable" according to the
     * spec
     * https://html.spec.whatwg.org/multipage/interaction.html#the-tabindex-attribute,
     * so we need to remove the "tabindex" attribute below to make it
     * non-focusable.
     */
    toggleFocusable(focusable) {
        if (focusable) {
            this.$treeItem_.setAttribute('tabindex', '0');
        }
        else {
            this.$treeItem_.removeAttribute('tabindex');
        }
    }
    /**
     * Override focus() so we can manually focus the tree row element inside
     * shadow DOM.
     */
    focus() {
        console.assert(!this.disabled, 'Called focus() on a disabled XfTreeItem() isn\'t allowed');
        // Make sure this is the only focusable item in the tree before calling
        // focus().
        if (this.tree) {
            this.tree.focusedItem = this;
        }
        this.$treeItem_.focus();
    }
    /**
     * Return the parent XfTreeItem if there is one, for top level XfTreeItem
     * which doesn't have parent XfTreeItem, return null.
     */
    get parentItem() {
        let p = this.parentElement;
        while (p) {
            if (isTreeItem(p)) {
                return p;
            }
            if (isXfTree(p)) {
                return null;
            }
            p = p.parentElement;
        }
        return p;
    }
    get tree() {
        let t = this.parentElement;
        while (t && !isXfTree(t)) {
            t = t.parentElement;
        }
        return t;
    }
    /**
     * Expands all parent items.
     */
    reveal() {
        let pi = this.parentItem;
        while (pi) {
            pi.expanded = true;
            pi = pi.parentItem;
        }
    }
    /**
     * This will be called when tree item is being set as a drop target.
     */
    doDropTargetAction() {
        this.expanded = true;
    }
    static get styles() {
        return getCSS$4();
    }
    render() {
        const showExpandIcon = this.hasChildren() && !this.disabled;
        const treeRowStyles = {
            paddingInlineStart: `max(0px, calc(var(--xf-tree-item-indent) * ${this.level_ - 1}px))`,
        };
        return html `
      <li
        class="tree-item"
        role="treeitem"
        aria-labelledby="tree-label"
        aria-selected=${this.selected}
        aria-expanded=${ifDefined(showExpandIcon ? this.expanded : undefined)}
        aria-disabled=${this.disabled}
      >
        <div class="tree-row-wrapper">
          <div
            class="tree-row"
            style=${styleMap(treeRowStyles)}
          >
            <paper-ripple></paper-ripple>
            <span class="expand-icon"></span>
            <xf-icon
              class="tree-label-icon"
              type=${ifDefined(this.iconSet ? undefined : this.icon)}
              .iconSet=${this.iconSet}
            ></xf-icon>
            <span class="tree-label" id="tree-label">${this.label || ''}</span>
            <slot name="rename"></slot>
            <slot name="trailingIcon"></slot>
          </div>
        </div>
        <ul
          class="tree-children"
          role="group"
        >
          <slot @slotchange=${this.onSlotChanged_}></slot>
        </ul>
      </li>
    `;
    }
    connectedCallback() {
        super.connectedCallback();
        if (!this.tree) {
            throw new Error('<xf-tree-item> can not be used without a parent <xf-tree>');
        }
    }
    /**
     * When <xf-tree-item> responds to the "contextmenu" event, the `e.target`
     * will always be the host element even if we put the focus on the inner
     * ".tree-row" element, this is because it's inside the shadow DOM. To make
     * sure the context menu shows in the correct location (when triggered by
     * keyboard), we need to expose this method to re-position the menu based on
     * the ".tree-row"'s bounding box. This method will be invoked by
     * `ContextMenuHandler`.
     */
    getRectForContextMenu() {
        return this.$treeRow_.getBoundingClientRect();
    }
    onSlotChanged_() {
        const oldItems = new Set(this.items_);
        // Update `items_` every time when the children slot changes (e.g.
        // add/remove).
        this.items_ = this.$childrenSlot_.assignedElements().filter(isTreeItem);
        let updateScheduled = false;
        // If an expanded item's last children is deleted, update expanded property.
        if (this.items_.length === 0 && this.expanded) {
            this.expanded = false;
            updateScheduled = true;
        }
        const newItems = new Set(this.items_);
        if (this.tree) {
            handleTreeSlotChange(this.tree, oldItems, newItems);
        }
        if (!updateScheduled) {
            // Explicitly trigger an update because render() relies on hasChildren(),
            // which relies on `this.items_`.
            this.requestUpdate();
        }
    }
    firstUpdated() {
        this.updateLevel_();
    }
    updated(changedProperties) {
        super.updated(changedProperties);
        // For browser test use only.
        this.setAttribute('has-children', String(this.items_.length > 0));
        if (changedProperties.has('expanded')) {
            this.onExpandChanged_();
        }
        if (changedProperties.has('selected')) {
            this.onSelectedChanged_();
        }
    }
    onExpandChanged_() {
        if (this.expanded) {
            const expandedEvent = new CustomEvent(XfTreeItem_1.events.TREE_ITEM_EXPANDED, {
                bubbles: true,
                composed: true,
                detail: { item: this },
            });
            this.dispatchEvent(expandedEvent);
        }
        else {
            const collapseEvent = new CustomEvent(XfTreeItem_1.events.TREE_ITEM_COLLAPSED, {
                bubbles: true,
                composed: true,
                detail: { item: this },
            });
            this.dispatchEvent(collapseEvent);
        }
    }
    onSelectedChanged_() {
        const tree = this.tree;
        if (this.selected) {
            this.reveal();
            if (tree) {
                tree.selectedItem = this;
            }
        }
        else {
            if (tree && tree.selectedItem === this) {
                tree.selectedItem = null;
            }
        }
    }
    /** Update the level of the tree item by traversing upwards. */
    updateLevel_() {
        // Traverse upwards to determine the level.
        let level = 0;
        let current = this;
        while (current) {
            current = current.parentItem;
            level++;
        }
        this.level_ = level;
    }
};
__decorate([
    property({ type: Boolean, reflect: true })
], XfTreeItem.prototype, "separator", void 0);
__decorate([
    property({ type: Boolean, reflect: true })
], XfTreeItem.prototype, "disabled", void 0);
__decorate([
    property({ type: Boolean, reflect: true })
], XfTreeItem.prototype, "selected", void 0);
__decorate([
    property({ type: Boolean, reflect: true })
], XfTreeItem.prototype, "expanded", void 0);
__decorate([
    property({ type: Boolean, reflect: true })
], XfTreeItem.prototype, "renaming", void 0);
__decorate([
    property({ type: Boolean, reflect: true, attribute: 'may-have-children' })
], XfTreeItem.prototype, "mayHaveChildren", void 0);
__decorate([
    property({ type: String, reflect: true })
], XfTreeItem.prototype, "icon", void 0);
__decorate([
    property({ attribute: false })
], XfTreeItem.prototype, "iconSet", void 0);
__decorate([
    property({ type: String, reflect: true })
], XfTreeItem.prototype, "label", void 0);
__decorate([
    state()
], XfTreeItem.prototype, "level_", void 0);
__decorate([
    query('li')
], XfTreeItem.prototype, "$treeItem_", void 0);
__decorate([
    query('.tree-row')
], XfTreeItem.prototype, "$treeRow_", void 0);
__decorate([
    query('slot:not([name])')
], XfTreeItem.prototype, "$childrenSlot_", void 0);
XfTreeItem = XfTreeItem_1 = __decorate([
    customElement('xf-tree-item')
], XfTreeItem);
function getCSS$4() {
    return css `
    :host {
      --xf-tree-item-indent: ${TREE_ITEM_INDENT};
      display: block;
    }

    ul {
      list-style: none;
      margin: 0;
      outline: none;
      padding: 0;
    }

    li {
      display: block;
    }

    li:focus-visible {
      outline: none;
    }

    :host([separator])::before {
      border-bottom: 1px solid var(--cros-separator-color);
      content: '';
      display: block;
      margin: 8px 0;
      width: 100%;
    }

    /* We need this layer to make sure there's no gap between tree items, so
    when we drag items onto the tree items, it won't activate the parent tree
    item unexpectedly. */
    .tree-row-wrapper {
      cursor: pointer;
      padding: 4px;
    }

    .tree-row {
      align-items: center;
      border-inline-start-width: 0 !important;
      border-radius: 20px;
      box-sizing: border-box;
      color: var(--cros-sys-on_surface);
      display: flex;
      height: 40px;
      padding-inline-end: 12px;
      position: relative;
      user-select: none;
      white-space: nowrap;
    }

    :host(:not([selected]):not([disabled]):not([renaming]):not(:focus))
        .tree-row:hover {
      background-color: var(--cros-sys-hover_on_subtle);
    }

    :host([selected]) .tree-row {
      background-color: var(--cros-sys-primary);
      color: var(--cros-sys-on_primary);
    }

    :host([disabled]) .tree-row {
      color: var(--cros-sys-disabled);
      pointer-events: none;
    }

    :host-context(.focus-outline-visible):host(:focus) .tree-row {
      outline: 2px solid var(--cros-sys-focus_ring);
      outline-offset: 2px;
      z-index: 2;
    }

    :host-context(.pointer-active):host(:not([selected]):not([disabled]):not([renaming]):not(:focus))
        .tree-row:not(:hover):active {
      background-color: var(--cros-sys-hover_on_subtle);
    }

    :host-context(.pointer-active) .tree-row:not(:active) {
      cursor: default;
    }

    :host-context(.pointer-active):host(:not([selected]):not([disabled]):not([renaming]):not(:focus))
        .tree-row:not(:active):hover {
      background-color: unset;
    }

    :host-context(html.drag-drop-active):host(.denies) .tree-row {
      background-color: var(--cros-sys-error_container);
      color: var(--cros-sys-on_error_container);
    }

    :host-context(html.drag-drop-active):host(.accepts) .tree-row {
      background-color: var(--cros-sys-hover_on_subtle);
    }

    :host-context(html.drag-drop-active):host(.accepts[selected]) .tree-row {
      background-color: var(--cros-sys-primary);
    }

    .expand-icon {
      -webkit-mask-image: url(../foreground/images/files/ui/sort_desc.svg);
      -webkit-mask-position: center;
      -webkit-mask-repeat: no-repeat;
      background-color: currentColor;
      flex: none;
      height: 20px;
      margin-inline-start: 8px;
      position: relative;
      transform: rotate(-90deg);
      transition: all 150ms;
      visibility: hidden;
      width: 20px;
    }

    li[aria-expanded] .expand-icon {
      visibility: visible;
    }

    :host-context(html[dir=rtl]) .expand-icon {
      transform: rotate(90deg);
    }

    :host([expanded]) .expand-icon {
      transform: rotate(0);
    }

    .tree-label-icon {
      --xf-icon-color: var(--cros-sys-on_surface);
      flex: none;
    }

    :host([selected]) .tree-label-icon {
      --xf-icon-color: var(--cros-sys-on_primary)
    }

    :host([disabled]) .tree-label-icon {
      --xf-icon-color: var(--cros-sys-disabled);
    }

    .tree-label {
      display: block;
      flex: auto;
      font: var(--cros-button-2-font);
      margin-inline-end: 2px;
      margin-inline-start: 8px;
      min-width: 0;
      overflow: hidden;
      text-overflow: ellipsis;
      white-space: pre;
    }

    /** input is attached by DirectoryTreeNamingController. */
    slot[name="rename"]::slotted(input) {
      background-color: var(--cros-sys-app_base);
      border-radius: 4px;
      border: none;
      color: var(--cros-sys-on_surface);
      display: none;
      font: var(--cros-body-2-font);
      height: 20px;
      width: 100%;
      margin: 0 10px;
      outline: 2px solid var(--cros-sys-focus_ring);
      overflow: hidden;
      padding: 1px 8px;
    }

    :host([renaming]) slot[name="rename"]::slotted(input) {
      display: block;
    }

    :host([renaming]) .tree-label {
      display: none;
    }

    :host([selected]) slot[name="rename"]::slotted(input) {
      outline: 2px solid var(--cros-sys-inverse_primary);
    }

    paper-ripple {
      border-radius: 20px;
      color: var(--cros-sys-ripple_primary);
    }

    /* We need to ensure that even empty labels take up space. */
    .tree-label:empty::after {
      content: ' ';
      white-space: pre;
    }

    .tree-children {
      display: none;
    }

    :host([expanded]) .tree-children {
      display: block;
    }

    /* Trailing icon styles. */
    slot[name="trailingIcon"]::slotted(.align-right-icon) {
      --ink-color: var(--cros-sys-ripple_neutral_on_subtle);
      --iron-icon-height: 20px;
      --iron-icon-width: 20px;
      -ripple-opacity: 100%;
      border: none;
      border-radius: 20px;
      box-sizing: border-box;
      height: 40px;
      position: relative;
      right: -12px; /* Same as padding inline end of tree row. */
      width: 40px;
      z-index: 1;
    }

    :host-context([dir="rtl"]) slot[name="trailingIcon"]::slotted(.align-right-icon) {
      left: -12px; /* Same as padding inline end of tree row. */
      right: unset;
    }

    slot[name="trailingIcon"]::slotted(.external-link-icon iron-icon) {
      padding: 6px;
    }

    slot[name="trailingIcon"]::slotted(.root-eject) {
      --text-color: currentColor;
      --hover-bg-color: none;
      --ripple-opacity: 1;
      min-width: 32px;
      padding: 0;
    }

    slot[name="trailingIcon"]::slotted(.root-eject:focus) {
      outline: 2px solid var(--cros-sys-focus_ring);
      outline-offset: 2px;
    }

    :host([selected]) slot[name="trailingIcon"]::slotted(.root-eject:focus) {
      outline: 2px solid var(--cros-sys-inverse_primary);
    }

    slot[name="trailingIcon"]::slotted(.root-eject:active) {
      --ink-color: var(--cros-sys-ripple_neutral_on_subtle);
    }

    :host([selected]) slot[name="trailingIcon"]::slotted(.root-eject:active) {
      --ink-color: var(--cros-sys-ripple_neutral_on_prominent);
    }
  `;
}

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
var XfTree_1;
/**
 * <xf-tree> is the container of the <xf-tree-item> elements. An example
 * DOM structure is like this:
 *
 * <xf-tree>
 *   <xf-tree-item>
 *     <xf-tree-item></xf-tree-item>
 *   </xf-tree-item>
 *   <xf-tree-item></xf-tree-item>
 * </xf-tree>
 *
 * The selection and focus of <xf-tree-item> is controlled in <xf-tree>,
 * this is because we need to make sure only one item is being selected or
 * focused.
 *
 */
let XfTree = XfTree_1 = class XfTree extends XfBase {
    constructor() {
        super(...arguments);
        /** The child tree items. */
        this.items_ = [];
        /**
         * Maintain these in the tree level so we can make sure at most one tree item
         * can be selected/focused.
         */
        this.selectedItem_ = null;
        this.focusedItem_ = null;
        /**
         * Value to set aria-setsize, which is the number of the top level child tree
         * items.
         */
        this.ariaSetSize_ = 0;
    }
    static get events() {
        return {
            /** Triggers when a tree item has been selected. */
            TREE_SELECTION_CHANGED: 'tree_selection_changed',
        };
    }
    /** Return the selected tree item, could be null. */
    get selectedItem() {
        return this.selectedItem_;
    }
    set selectedItem(item) {
        this.selectItem_(item);
    }
    /** Return the focused tree item, could be null. */
    get focusedItem() {
        return this.focusedItem_;
    }
    set focusedItem(item) {
        this.makeItemFocusable_(item);
    }
    /** The child tree items. */
    get items() {
        return this.items_;
    }
    /** The child tree items which can be tabbed/focused into. */
    get tabbableItems() {
        return this.items_.filter(item => !item.disabled);
    }
    static get styles() {
        return getCSS$3();
    }
    /**
     * The <xf-tree> itself is not focusable, it will delegate the focus down to
     * its `focusedItem_`.
     *
     * Note: previously we use `delegatesFocus: true` in the shadowRootOptions,
     * but it triggers weird behavior b/320580121, hence the override here.
     */
    focus() {
        if (this.focusedItem_) {
            this.focusedItem_.focus();
        }
    }
    render() {
        return html `
      <ul
        class="tree"
        role="tree"
        aria-setsize=${this.ariaSetSize_}
        @tree_item_collapsed=${this.onTreeItemCollapsed_}
      >
        <slot @slotchange=${this.onSlotChanged_}></slot>
      </ul>
    `;
    }
    connectedCallback() {
        super.connectedCallback();
        // Binding all these events at the host element level because the blank
        // space of the tree doesn't belong to the root <ul> element.
        this.addEventListener('contextmenu', this.onHostContextMenu_.bind(this));
        this.addEventListener('click', this.onHostClicked_.bind(this));
        this.addEventListener('dblclick', this.onHostDblClicked_.bind(this));
        this.addEventListener('mousedown', this.onHostMouseDown_.bind(this));
        this.addEventListener('keydown', this.onHostKeyDown_.bind(this));
    }
    onSlotChanged_() {
        const oldItems = new Set(this.items_);
        // Update `items_` every time when the children slot changes (e.g.
        // add/remove).
        this.items_ = this.$childrenSlot_.assignedElements().filter(isTreeItem);
        this.ariaSetSize_ = this.tabbableItems.length;
        const newItems = new Set(this.items_);
        handleTreeSlotChange(this, oldItems, newItems);
    }
    /**
     * Handles the collapse event of the tree item.
     */
    onTreeItemCollapsed_(e) {
        const treeItem = e.detail.item;
        // If the currently focused tree item (`oldFocusedItem`) is a descent of
        // another tree item (`treeItem`) which is going to be collapsed, we need to
        // mark the ancestor tree item (`this`) as focused.
        if (this.focusedItem_ !== treeItem) {
            const oldFocusedItem = this.focusedItem_;
            if (oldFocusedItem && treeItem.contains(oldFocusedItem)) {
                this.makeItemFocusable_(treeItem);
            }
        }
    }
    /** Called when the user clicks within the host element. */
    onHostClicked_(e) {
        // Mouse right click won't trigger click event, so this check is not
        // necessary in real scenario. This is mainly for the browser test because
        // waitAndRightClickEvent will actually trigger a click event with button=2.
        if (e.button === 2) {
            return;
        }
        // Stop if the the click target is not a tree item.
        const treeItem = e.target;
        if (treeItem && !isTreeItem(treeItem)) {
            // Clicking the non tree item area should focus the whole tree, which will
            // delegate the focus to the currently focusable child tree item.
            this.focus();
            return;
        }
        if (treeItem.disabled) {
            e.stopImmediatePropagation();
            e.preventDefault();
            return;
        }
        // Use composed path to know which element inside the shadow root
        // has been clicked.
        const innerClickTarget = e.composedPath()[0];
        if (innerClickTarget.className === 'expand-icon') {
            treeItem.expanded = !treeItem.expanded;
        }
        else {
            treeItem.selected = true;
        }
        treeItem.focus();
    }
    /** Called when the user double clicks within the host element. */
    onHostDblClicked_(e) {
        // Stop if the the click target is not a tree item.
        const treeItem = e.target;
        if (treeItem && !isTreeItem(treeItem)) {
            // Double clicking the non tree item area should focus the whole tree,
            // which will delegate the focus to the currently focusable child tree
            // item.
            this.focus();
            return;
        }
        if (treeItem.disabled) {
            e.stopImmediatePropagation();
            e.preventDefault();
            return;
        }
        // Use composed path to know which element inside the shadow root
        // has been clicked.
        const innerClickTarget = e.composedPath()[0];
        if (innerClickTarget.className !== 'expand-icon' &&
            treeItem.hasChildren()) {
            treeItem.expanded = !treeItem.expanded;
            treeItem.focus();
        }
    }
    /** Called when mouse down event happens within the host element. */
    onHostMouseDown_(e) {
        // Only handle the right click here, left click is handled by the click
        // handler above.
        if (e.button !== 2) {
            return;
        }
        // Stop if the the click target is not a tree item.
        const treeItem = e.target;
        if (treeItem && !isTreeItem(treeItem)) {
            // Right clicking the non tree item area should focus the whole tree,
            // which will delegate the focus to the currently focusable child tree
            // item.
            this.focus();
            return;
        }
        if (treeItem.disabled) {
            e.stopImmediatePropagation();
            e.preventDefault();
            return;
        }
        treeItem.focus();
    }
    /** Called when a context menu event happens within the host element. */
    onHostContextMenu_(e) {
        // Delegate the tree level contextmenu event to the focused child tree item.
        // Note: tree item contextmenu event will never arrive here because the
        // event listener registered in ContextMenuHandler stops propagation after
        // showing the context menu. So the handler here is only for right clicking
        // on the blank space area (e.g. outside the root <ul> element).
        if (this.focusedItem_) {
            const domRect = this.focusedItem_.getRectForContextMenu();
            // Calculate the center point of the tree item, so <xf-tree-item> knows
            // where to show the context menu pop-up.
            const x = domRect.x + (domRect.width / 2);
            const y = domRect.y + (domRect.height / 2);
            this.focusedItem_.dispatchEvent(new PointerEvent(e.type, { ...e, clientX: x, clientY: y }));
        }
    }
    /**
     * Handle the keydown within the host element, this mainly handles the
     * navigation and the selection with the keyboard.
     */
    onHostKeyDown_(e) {
        if (e.ctrlKey) {
            return;
        }
        // We allow repeated keydown (e.g. hold the key without releasing to trigger
        // event multiple times) only for ArrowUp/ArrowDown, so users can use hold
        // arrow up/down to quickly navigate to the tree items far away.
        const allowRepeat = e.key === 'ArrowUp' || e.key === 'ArrowDown';
        if (e.repeat && !allowRepeat) {
            return;
        }
        if (!this.focusedItem_) {
            return;
        }
        if (this.tabbableItems.length === 0) {
            return;
        }
        let itemToFocus = null;
        switch (e.key) {
            case 'Enter':
            case ' ':
                this.selectItem_(this.focusedItem_);
                break;
            case 'ArrowUp':
                itemToFocus = this.getPreviousItem_(this.focusedItem_);
                break;
            case 'ArrowDown':
                itemToFocus = this.getNextItem_(this.focusedItem_);
                break;
            case 'ArrowLeft':
            case 'ArrowRight':
                // Don't let back/forward keyboard shortcuts be used.
                if (e.altKey) {
                    break;
                }
                const expandKey = isRTL$1() ? 'ArrowLeft' : 'ArrowRight';
                if (e.key === expandKey) {
                    if (this.focusedItem_.hasChildren() && !this.focusedItem_.expanded) {
                        this.focusedItem_.expanded = true;
                    }
                    else {
                        itemToFocus = this.focusedItem_.tabbableItems[0];
                    }
                }
                else {
                    if (this.focusedItem_.expanded) {
                        this.focusedItem_.expanded = false;
                    }
                    else {
                        itemToFocus = this.focusedItem_.parentItem;
                    }
                }
                break;
            case 'Home':
                itemToFocus = this.tabbableItems[0];
                break;
            case 'End':
                itemToFocus = this.tabbableItems[this.tabbableItems.length - 1];
                break;
        }
        if (itemToFocus) {
            itemToFocus.focus();
            e.preventDefault();
        }
    }
    /**
     * Helper function that returns the next tabbable tree item.
     */
    getNextItem_(item) {
        if (item.expanded && item.tabbableItems.length > 0) {
            return item.tabbableItems[0];
        }
        return this.getNextHelper_(item);
    }
    /**
     * Another helper function that returns the next tabbable tree item.
     */
    getNextHelper_(item) {
        if (!item) {
            return null;
        }
        const nextSibling = item.nextElementSibling;
        if (nextSibling) {
            if (nextSibling.disabled) {
                return this.getNextHelper_(nextSibling);
            }
            return nextSibling;
        }
        return this.getNextHelper_(item.parentItem);
    }
    /**
     * Helper function that returns the previous tabbable tree item.
     */
    getPreviousItem_(item) {
        let previousSibling = item.previousElementSibling;
        while (previousSibling && previousSibling.disabled) {
            previousSibling =
                previousSibling.previousElementSibling;
        }
        if (previousSibling) {
            return this.getLastHelper_(previousSibling);
        }
        return item.parentItem;
    }
    /**
     * Helper function that returns the last tabbable tree item in the subtree.
     */
    getLastHelper_(item) {
        if (!item) {
            return null;
        }
        if (item.expanded && item.tabbableItems.length > 0) {
            const lastChild = item.tabbableItems[item.tabbableItems.length - 1];
            return this.getLastHelper_(lastChild);
        }
        return item;
    }
    /**
     * Make `itemToSelect` become the selected item in the tree, this will
     * also unselect the previously selected tree item to make sure at most
     * one tree item is selected in the tree.
     */
    selectItem_(itemToSelect) {
        const previousSelectedItem = this.selectedItem_;
        if (itemToSelect === previousSelectedItem) {
            return;
        }
        if (previousSelectedItem) {
            previousSelectedItem.selected = false;
        }
        this.selectedItem_ = itemToSelect;
        if (this.selectedItem_) {
            this.selectedItem_.selected = true;
            // When tree item gets selected programmatically (e.g. not through
            // mouse/keyboard), there might be other elements on the page which have
            // the focus, we don't want to steal the focus, so all we do here is to
            // make the item focusable.
            this.makeItemFocusable_(this.selectedItem_);
        }
        const selectionChangeEvent = new CustomEvent(XfTree_1.events.TREE_SELECTION_CHANGED, {
            bubbles: true,
            composed: true,
            detail: {
                previousSelectedItem,
                selectedItem: this.selectedItem,
            },
        });
        this.dispatchEvent(selectionChangeEvent);
    }
    /**
     * Make `itemToFocus` become the focusable, this will also make the previously
     * focused item non-focusable so we can make sure only 1 tree item is
     * focusable, this is essential for "delegatesFocus" to work.
     *
     * Note: this method only make the item to be focusable, it won't actually
     * focus the item, we need to call `.focus()` after to focus it.
     */
    makeItemFocusable_(itemToFocus) {
        const previousFocusedItem = this.focusedItem_;
        if (previousFocusedItem === itemToFocus) {
            return;
        }
        if (previousFocusedItem) {
            previousFocusedItem.toggleFocusable(false);
        }
        this.focusedItem_ = itemToFocus;
        if (this.focusedItem_) {
            this.focusedItem_.toggleFocusable(true);
        }
    }
};
__decorate([
    query('slot')
], XfTree.prototype, "$childrenSlot_", void 0);
__decorate([
    state()
], XfTree.prototype, "ariaSetSize_", void 0);
XfTree = XfTree_1 = __decorate([
    customElement('xf-tree')
], XfTree);
function getCSS$3() {
    return css `
    :host {
      display: block;
    }

    ul {
      list-style: none;
      margin: 0;
      padding: 0;
    }
  `;
}

// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class DirectoryTreeContainer {
    constructor(container, directoryModel_) {
        this.directoryModel_ = directoryModel_;
        /** The root tree widget. */
        this.tree = document.createElement('xf-tree');
        /** Context menu element for root navigation items. */
        this.contextMenuForRootItems = null;
        /** Context menu element for sub navigation items. */
        this.contextMenuForSubitems = null;
        /** Context menu element for disabled navigation items. */
        this.contextMenuForDisabledItems = null;
        /**
         * Mark the tree item with a specific file key as to be renamed. When rename
         * is triggered from outside and the item to be renamed is yet to be rendered
         * (e.g. "New folder" command), we store the file key here in order to attach
         * the rename input to the tree item when it's rendered.
         */
        this.fileKeyToRename_ = null;
        /**
         * Mark the tree item with a specific file key as to be focused. When we need
         * to change the focus to a tree item which is yet to be rendered (e.g. an
         * item is just renamed and the newly renamed item is not rendered yet), we
         * store the file key here in order to focus the tree item when it's
         * rendered.
         */
        this.fileKeyToFocus_ = null;
        /**
         * Sometimes the selected item can be changed from outside (e.g. currently
         * selected directory item gets deleted, or operations from other place which
         * triggers the active directory change), if the selected item is also focused
         * before the change, we need to shift the focus to the newly selected item
         * after it's rendered. This flag is used to control that.
         */
        this.shouldFocusOnNextSelectedItem_ = false;
        /**
         * When current directory changes, if the corresponding tree item has not been
         * rendered yet, an asynchronous read-sub-directory action will be dispatched
         * to read the children until we could find the item. During this asynchronous
         * process, the current directory might change again (either manually by user
         * or other operations), we need this variable to see if we need to trigger
         * another read-sub-directories call or not.
         */
        this.fileKeyToSelect_ = null;
        /**
         * The map of the navigation roots and items, from a navigation key to an
         * object which includes the navigation DOM element and the related data.
         *
         * Note: we are having 2 separate map for roots and items, because root item
         * and normal item can have the same key, e.g. for Shortcut item and its
         * original item, they share the same key but have different DOM elements, so
         * they can't be in the same map.
         */
        this.navigationRootMap_ = new Map();
        this.navigationItemMap_ = new Map();
        /**
         * Indicate if the RequestAnimationFrame is active for scroll or not, check
         * the usage in `onTreeScroll_` below.
         */
        this.scrollRAFActive_ = false;
        /** Navigation roots from the store. */
        this.navigationRoots_ = [];
        /** Volumes data from the store. */
        this.volumes_ = null;
        /** Folder shortcuts data from the store. */
        this.folderShortcuts_ = null;
        /** UI entries data from the store. */
        this.uiEntries_ = null;
        /** Android apps data from the store. */
        this.androidApps_ = null;
        this.tree.id = 'directory-tree';
        container.appendChild(this.tree);
        this.tree.addEventListener(XfTreeItem.events.TREE_ITEM_EXPANDED, this.onNavigationItemExpanded_.bind(this));
        this.tree.addEventListener(XfTreeItem.events.TREE_ITEM_COLLAPSED, this.onNavigationItemCollapsed_.bind(this));
        this.tree.addEventListener(XfTree.events.TREE_SELECTION_CHANGED, this.onNavigationItemSelected_.bind(this));
        this.tree.addEventListener('mouseover', this.onTreeMouseOver_.bind(this), { passive: true });
        const fileFilter = this.directoryModel_.getFileFilter();
        fileFilter.addEventListener('changed', this.onFileFilterChanged_.bind(this));
        this.tree.addEventListener('scroll', this.onTreeScroll_.bind(this), { passive: true });
        // For file watcher.
        chrome.fileManagerPrivate.onDirectoryChanged.addListener(this.onFileWatcherEntryChanged_.bind(this));
        this.store_ = getStore();
        this.store_.subscribe(this);
    }
    async onStateChanged(state) {
        if (this.shouldRefreshNavigationRoots_(state)) {
            this.store_.dispatch(refreshNavigationRoots());
            // Skip this render, and the refreshNavigationRoots() action will trigger
            // another call of `onStateChanged`, which will run the re-render logic
            // below.
            return;
        }
        const { navigation: { roots }, androidApps, currentDirectory } = state;
        if (this.shouldUnselectCurrentDirectoryItem_()) {
            this.tree.selectedItem = null;
        }
        else {
            // When current directory changes in the store, and the selected item in
            // the tree is different from that, select the corresponding navigation
            // item.
            const selectedItemKey = this.tree.selectedItem?.dataset['navigationKey'];
            if (currentDirectory?.key &&
                currentDirectory.status === PropStatus.SUCCESS &&
                currentDirectory.key !== selectedItemKey) {
                await this.selectCurrentDirectoryItem_(currentDirectory);
            }
        }
        // When navigation roots data changes in the store, re-render all navigation
        // root items.
        if (this.navigationRoots_ !== roots) {
            this.renderRoots_(roots);
        }
        // Navigation item can be backed up by either a FileData or a
        // AndroidAppData, we need to compare what we have in the container with the
        // data in the store to see if it changes or not. When
        // FileData/AndroidAppData changes in the store, re-render the corresponding
        // navigation item.
        for (const [key, { fileData, androidAppData }] of this.navigationRootMap_) {
            const newAndroidAppData = androidApps[key];
            const navigationRoot = this.navigationRoots_.find(navigationRoot => navigationRoot.key === key);
            if (navigationRoot.type === NavigationType.ANDROID_APPS) {
                if (androidAppData !== newAndroidAppData) {
                    this.renderItem_(key, newAndroidAppData, navigationRoot);
                }
            }
            else {
                const newFileData = getFileData(state, key);
                if (fileData !== newFileData) {
                    this.renderItem_(key, newFileData, navigationRoot);
                }
            }
        }
        for (const [key, { fileData }] of this.navigationItemMap_) {
            const newFileData = getFileData(state, key);
            if (fileData !== newFileData) {
                this.renderItem_(key, newFileData);
            }
        }
    }
    renameItemWithKeyWhenRendered(fileKey) {
        this.fileKeyToRename_ = fileKey;
    }
    focusItemWithKeyWhenRendered(fileKey) {
        this.fileKeyToFocus_ = fileKey;
    }
    renderRoots_(newRoots) {
        const newRootsSet = new Set(newRoots.map(root => root.key));
        // Remove non-exist navigation roots.
        for (const oldRoot of this.navigationRoots_) {
            if (!newRootsSet.has(oldRoot.key)) {
                this.deleteItem_(oldRoot.key, /* shouldDeleteElement= */ true, /* isRoot= */ true);
            }
        }
        // Add new navigation roots.
        const state = this.store_.getState();
        const { androidApps } = state;
        for (const [index, navigationRoot] of newRoots.entries()) {
            const exists = this.navigationRootMap_.has(navigationRoot.key);
            const navigationData = this.navigationRootMap_.get(navigationRoot.key);
            const navigationRootItem = exists ?
                navigationData.element :
                document.createElement('xf-tree-item');
            if (!exists) {
                this.navigationRootMap_.set(navigationRoot.key, {
                    element: navigationRootItem,
                    fileData: null,
                    androidAppData: null,
                });
                // We put the navigationKey on the element's dataset, so when certain
                // DOM events happens from the element, we know the corresponding
                // navigation key.
                navigationRootItem.dataset['navigationKey'] = navigationRoot.key;
            }
            const isAndroidApp = navigationRoot.type === NavigationType.ANDROID_APPS;
            const fileData = getFileData(state, navigationRoot.key);
            const androidAppData = androidApps[navigationRoot.key];
            // The states here might be lost after `insertBefore`, we need to store
            // it here and restore it later if needed.
            const isFocused = document.activeElement === navigationRootItem;
            const isRenaming = navigationRootItem.renaming;
            if (fileData && isVolumeFileData(fileData)) {
                const volume = getVolume(state, fileData);
                const isOneDriveRoot = volume && isOneDrive(volume);
                if (isOneDriveRoot) {
                    navigationRootItem.toggleAttribute('one-drive', true);
                }
            }
            this.renderItem_(navigationRoot.key, isAndroidApp ? androidAppData : fileData, navigationRoot);
            // Skip `insertBefore` for the tree item if it's an existing item in
            // renaming state, otherwise it will interrupt user's input (via
            // triggering `blur` event). Even we try to re-attach the rename input
            // after `insertBefore`, it still interrupts user's input.
            if (!isRenaming) {
                // Always call insertBefore here even if the element already exists,
                // because the index can change. Calling insertBefore with existing
                // child element will move it to the correct position.
                this.tree.insertBefore(
                // Use `children` here because `items` is asynchronous.
                navigationRootItem, this.tree.children[index] || null);
            }
            // For existing items, `insertBefore` call above might make the element
            // lose some status (e.g. focus), check if we need to restore
            // them or not.
            if (exists) {
                if (isFocused && !fileData?.disabled) {
                    this.restoreFocus_(navigationRootItem, /* isExisting= */ true);
                }
                continue;
            }
            // For newly rendered items, check if they are the next item to
            // focus.
            if (this.fileKeyToFocus_ === navigationRoot.key && !fileData?.disabled) {
                // Item with file key to focus is rendered for the first time (e.g.
                // right after rename finishes), focus on it.
                this.fileKeyToFocus_ = null;
                this.restoreFocus_(navigationRootItem, /* isExisting= */ false);
            }
            // No need to handle `fileKeyToRename_` here, because it's not allowed to
            // create a new folder in the directory tree root.
            if (!isAndroidApp) {
                this.handleInitialRender_(navigationRootItem, fileData, navigationRoot);
            }
        }
        this.navigationRoots_ = newRoots;
    }
    renderItem_(navigationKey, newData, navigationRoot) {
        if (!newData) {
            // The corresponding data is deleted from the store, do nothing here.
            return;
        }
        const navigationData = this.getNavigationDataFromKey_(navigationKey, !!navigationRoot);
        const { element } = navigationData;
        const isAndroidApp = navigationRoot?.type === NavigationType.ANDROID_APPS;
        // Handle navigation items backed up by an android app. Note: only
        // navigation root item can be backed up by an android app.
        if (isAndroidApp) {
            if (navigationData.androidAppData ===
                newData) {
                // Nothing changes, this render might be triggered by its parent.
                return;
            }
            const androidAppData = newData;
            element.label = androidAppData.name;
            if (typeof androidAppData.icon === 'object') {
                element.iconSet = androidAppData.icon;
            }
            else {
                element.icon = androidAppData.icon;
            }
            element.separator = navigationRoot.separator;
            // Setup external link for android app item.
            this.setupAndroidAppLink_(element);
            // Update new data back to the map.
            navigationData.androidAppData =
                androidAppData;
            return;
        }
        // Handle navigation items backed up by a file data.
        if (navigationData.fileData === newData) {
            // Nothing changes, this render might be triggered by its parent.
            return;
        }
        const fileData = newData;
        if (window.IN_TEST) {
            this.addAttributesForTesting_(element, fileData, navigationRoot);
        }
        element.expanded = fileData.expanded;
        element.mayHaveChildren =
            fileData.children.length > 0 || fileData.canExpand;
        element.label = fileData.label;
        if (navigationRoot) {
            element.separator = navigationRoot.separator;
        }
        this.setItemIcon_(element, fileData, navigationRoot);
        element.disabled = fileData.disabled;
        // Add eject button for ejectable item.
        if (fileData.isEjectable) {
            this.setupEjectButton_(element, fileData.label);
        }
        // Handle navigation item's children.
        // For disabled tree or collapsed items, we don't render any children
        // inside, but we always render children for Drive even it's collapsed.
        // TODO(b/308504417): remove the special case for Drive.
        const shouldRenderChildren = !fileData.disabled &&
            (fileData.expanded || fileData.key === driveRootEntryListKey);
        if (shouldRenderChildren) {
            const newChildren = fileData.children || [];
            // Remove non-exist navigation items.
            const newChildrenSet = new Set(newChildren);
            const oldChildren = navigationData.fileData?.children || [];
            for (const childKey of oldChildren) {
                if (!newChildrenSet.has(childKey)) {
                    this.deleteItem_(childKey, /* shouldDeleteElement= */ true, /* isRoot= */ false);
                }
            }
            const state = this.store_.getState();
            for (const [index, childKey] of newChildren.entries()) {
                const exists = this.navigationItemMap_.has(childKey);
                const navigationData = this.navigationItemMap_.get(childKey);
                const navigationItem = exists ? navigationData.element :
                    document.createElement('xf-tree-item');
                if (!exists) {
                    this.navigationItemMap_.set(childKey, {
                        element: navigationItem,
                        fileData: null,
                    });
                    // We put the navigationKey on the element's dataset, so when certain
                    // DOM events happens from the element, we know the corresponding
                    // navigation key.
                    navigationItem.dataset['navigationKey'] = childKey;
                }
                const childFileData = getFileData(state, childKey);
                // The states here might be lost after `insertBefore`, we need to store
                // it here and restore it later if needed.
                const isFocused = document.activeElement === navigationItem;
                const isRenaming = navigationItem.renaming;
                this.renderItem_(childKey, childFileData);
                // Skip `insertBefore` for the tree item if it's an existing item in
                // renaming state, otherwise it will interrupt user's input (via
                // triggering `blur` event). Even we try to re-attach the rename input
                // after `insertBefore`, it still interrupts user's input.
                if (!isRenaming) {
                    // Always call insertBefore here even if the element already exists,
                    // because the index can change. Calling insertBefore with existing
                    // child element will move it to the correct position.
                    element.insertBefore(navigationItem, 
                    // Use `.children` instead of `.items` here because `items` is
                    // asynchronous.
                    element.children[index] || null);
                }
                // For existing items, `insertBefore` call above might make the element
                // lose some status (e.g. focus), check if we need to restore
                // them or not.
                if (exists) {
                    if (isFocused && !childFileData?.disabled) {
                        this.restoreFocus_(navigationItem, /* isExisting= */ true);
                    }
                    continue;
                }
                // For newly rendered items, check if they are the next item to
                // rename/focus.
                if (this.fileKeyToFocus_ === childKey && !childFileData?.disabled) {
                    // Item with file key to focus is rendered for the first time (e.g.
                    // right after rename finishes), focus on it.
                    this.fileKeyToFocus_ = null;
                    this.restoreFocus_(navigationItem, /* isExisting= */ false);
                }
                if (this.fileKeyToRename_ === childKey) {
                    // Item with file key to rename is rendered for the first time (e.g.
                    // "New folder" case), attach the rename input here.
                    this.fileKeyToRename_ = null;
                    this.attachRename_(navigationItem);
                }
                this.handleInitialRender_(navigationItem, childFileData);
            }
        }
        const isOdfs = isOneDriveId(getVolume(this.store_.getState(), fileData)?.providerId);
        if (isOdfs && fileData?.disabled) {
            // The entries under ODFS are not disabled recursively. Collapse ODFS when
            // it is disabled.
            element.expanded = false;
        }
        // Update new data to the map.
        navigationData.fileData = fileData;
    }
    /**
     * Update navigation item icon based on the navigation data and the file data.
     */
    setItemIcon_(element, fileData, navigationRoot) {
        if (navigationRoot?.type === NavigationType.SHORTCUT) {
            element.icon = ICON_TYPES.SHORTCUT;
            return;
        }
        // Navigation icon might be chrome.fileManagerPrivate.IconSet type.
        if (typeof fileData.icon === 'object') {
            element.iconSet = fileData.icon;
        }
        else {
            element.icon = fileData.icon;
        }
        // For drive item, update icon based on the metadata.
        if (shouldSupportDriveSpecificIcons(fileData) && fileData.metadata) {
            const { shared, isMachineRoot, isExternalMedia } = fileData.metadata;
            if (shared) {
                element.icon = ICON_TYPES.SHARED_FOLDER;
            }
            if (isMachineRoot) {
                element.icon = ICON_TYPES.COMPUTER;
            }
            if (isExternalMedia) {
                element.icon = ICON_TYPES.USB;
            }
        }
    }
    /** Add attributes for testing purpose. */
    addAttributesForTesting_(element, fileData, navigationRoot) {
        // Add full-path for all non-root items.
        if (!navigationRoot) {
            element.setAttribute('full-path-for-testing', fileData.fullPath);
        }
        if (!isVolumeFileData(fileData)) {
            return;
        }
        // Add volume-type for the root volume items.
        const volumeData = getVolume(this.store_.getState(), fileData);
        if (!volumeData) {
            return;
        }
        if (volumeData.volumeType === VolumeType.GUEST_OS) {
            element.setAttribute('volume-type-for-testing', vmTypeToIconName(volumeData.vmType));
        }
        else {
            element.setAttribute('volume-type-for-testing', volumeData.volumeType);
        }
    }
    /** Append an eject button as the trailing slot of the navigation item. */
    setupEjectButton_(element, label) {
        let ejectButton = element.querySelector('[slot=trailingIcon]');
        if (!ejectButton) {
            ejectButton = document.createElement('cr-button');
            ejectButton.className = 'root-eject align-right-icon';
            ejectButton.slot = 'trailingIcon';
            ejectButton.tabIndex = 0;
            // These events propagation needs to be stopped otherwise ripple will show
            // on the tree item when the button is pressed.
            // Note: 'up/down' are events from <paper-ripple> component.
            const suppressedEvents = ['mouseup', 'mousedown', 'up', 'down'];
            suppressedEvents.forEach(event => {
                ejectButton.addEventListener(event, event => {
                    event.stopPropagation();
                });
            });
            ejectButton.addEventListener('click', (event) => {
                event.stopPropagation();
                const command = document.querySelector('command#unmount');
                // Ensure 'canExecute' state of the command is properly setup for the
                // root before executing it.
                command.canExecuteChange(element);
                command.execute(element);
            });
            // Add icon.
            const ironIcon = document.createElement('iron-icon');
            ironIcon.setAttribute('icon', 'files20:eject');
            ejectButton.appendChild(ironIcon);
            element.appendChild(ejectButton);
        }
        ejectButton.ariaLabel = strf('UNMOUNT_BUTTON_LABEL', label);
    }
    /** Create an external link icon for android app navigation item.*/
    setupAndroidAppLink_(element) {
        let externalLink = element.querySelector('[slot=trailingIcon]');
        if (!externalLink) {
            // Use aria-describedby attribute to let ChromeVox users know that the
            // link launches an external app window.
            element.setAttribute('aria-describedby', 'external-link-label');
            // Create an external link.
            externalLink = document.createElement('span');
            externalLink.slot = 'trailingIcon';
            externalLink.className = 'external-link-icon align-right-icon';
            // Append external-link iron-icon.
            const ironIcon = document.createElement('iron-icon');
            ironIcon.setAttribute('icon', `files20:external-link`);
            externalLink.appendChild(ironIcon);
            element.appendChild(externalLink);
        }
    }
    /** Handle initial rendering. */
    handleInitialRender_(element, fileData, navigationRoot) {
        if (!fileData) {
            return;
        }
        // Set context menu for the item.
        this.setContextMenu_(element, fileData, navigationRoot);
        // Expand MyFiles by default.
        if (isMyFilesFileData(this.store_.getState(), fileData)) {
            element.expanded = true;
            return;
        }
        // Check if we need to read sub directories to check directory children or
        // not, we are doing this to see if we need to show expand icon or not.
        let shouldCheckDirectoryChildren;
        if (navigationRoot) {
            // For navigation root items, we always check except for Shortcut items.
            shouldCheckDirectoryChildren =
                navigationRoot.type !== NavigationType.SHORTCUT;
        }
        else {
            // For other items, we only check if it's parent is expanded. Usually
            // non-root item's children directory will be checked when expanded, but
            // volume could be added when it's already expanded (e.g. Crostini/Android
            // can be mounted when MyFiles is expanded).
            shouldCheckDirectoryChildren = !!(element.parentItem?.expanded);
        }
        if (shouldCheckDirectoryChildren) {
            this.store_.dispatch(readSubDirectoriesToCheckDirectoryChildren(fileData.key));
        }
    }
    /** Delete the navigation item by navigation key. */
    deleteItem_(navigationKey, shouldDeleteElement, isRoot) {
        const navigationData = this.getNavigationDataFromKey_(navigationKey, isRoot);
        if (!navigationData) {
            console.warn('Couldn\'t find the navigation data for the item to be deleted in the store.');
            return;
        }
        const { element, fileData } = navigationData;
        if (shouldDeleteElement && element.parentElement) {
            const isFocused = element === document.activeElement;
            const isSelected = element.selected;
            element.parentElement.removeChild(element);
            if (isFocused) {
                if (isSelected) {
                    this.shouldFocusOnNextSelectedItem_ = true;
                }
                else {
                    this.tree.focusedItem = this.tree.selectedItem;
                    // The focus now already changes back to BODY because of the
                    // `removeChild` above, we need to restore it back to the tree.
                    this.tree.focus();
                }
            }
        }
        if (isRoot) {
            this.navigationRootMap_.delete(navigationKey);
        }
        else {
            this.navigationItemMap_.delete(navigationKey);
        }
        // Also delete all the children keys from the map.
        if (fileData) {
            for (const childKey of fileData.children) {
                // For children element we don't need to explicitly delete DOM element
                // because removing their parent will also remove them implicitly.
                this.deleteItem_(childKey, /* shouldDeleteElement= */ false, /* isRoot= */ false);
            }
        }
    }
    /**
     * Given an navigation DOM element, find out the corresponding navigation
     * data in the root map or item map.
     */
    getNavigationDataFromKey_(navigationKey, isRoot) {
        // If isRoot is passed, we know clearly which map to search.
        if (isRoot !== undefined) {
            const navigationData = isRoot ?
                this.navigationRootMap_.get(navigationKey) :
                this.navigationItemMap_.get(navigationKey);
            return navigationData || null;
        }
        // Checking if the navigationKey is a navigation root or a regular
        // navigation item.
        if (this.navigationRootMap_.has(navigationKey)) {
            return this.navigationRootMap_.get(navigationKey);
        }
        if (this.navigationItemMap_.has(navigationKey)) {
            return this.navigationItemMap_.get(navigationKey);
        }
        return null;
    }
    /** Handler for navigation item expanded. */
    onNavigationItemExpanded_(event) {
        const treeItem = event.detail.item;
        const navigationKey = treeItem.dataset['navigationKey'];
        const navigationData = this.getNavigationDataFromKey_(navigationKey);
        if (!navigationData || !navigationData.fileData) {
            console.warn('Couldn\'t find the navigation data for the expanded item in the store.');
            return;
        }
        const { fileData } = navigationData;
        this.store_.dispatch(updateFileData({
            key: navigationKey,
            partialFileData: { expanded: true },
        }));
        // UMA: expand time.
        const rootType = fileData.rootType ?? 'unknown';
        const metricName = `DirectoryTree.Expand.${rootType}`;
        this.recordUmaForItemExpandedOrCollapsed_(fileData);
        // Read child entries.
        this.store_.dispatch(readSubDirectories(fileData.key, /* recursive= */ true, metricName));
    }
    /** Handler for navigation item collapsed. */
    onNavigationItemCollapsed_(event) {
        const treeItem = event.detail.item;
        const navigationKey = treeItem.dataset['navigationKey'];
        const navigationData = this.getNavigationDataFromKey_(navigationKey);
        if (!navigationData || !navigationData.fileData) {
            console.warn('Couldn\'t find the navigation data for the collapsed item in the store.');
            return;
        }
        const { fileData } = navigationData;
        if (fileData.expanded) {
            this.store_.dispatch(updateFileData({
                key: navigationKey,
                partialFileData: { expanded: false },
            }));
        }
        this.recordUmaForItemExpandedOrCollapsed_(fileData);
        if (shouldDelayLoadingChildren(fileData, this.store_.getState())) {
            // For file systems where it is performance intensive
            // to update recursively when items expand, this proactively
            // collapses all children to avoid having to traverse large
            // parts of the tree when reopened.
            for (const item of treeItem.items) {
                if (item.expanded) {
                    item.expanded = false;
                }
            }
        }
    }
    /** Handler for navigation item selected. */
    onNavigationItemSelected_(event) {
        const { previousSelectedItem, selectedItem } = event.detail;
        if (previousSelectedItem) {
            previousSelectedItem.removeAttribute('aria-description');
        }
        if (!selectedItem) {
            return;
        }
        selectedItem.setAttribute('aria-description', str('CURRENT_DIRECTORY_LABEL'));
        const navigationKey = selectedItem.dataset['navigationKey'];
        // When the navigation item selection changed from the store (e.g. triggered
        // by other parts of the UI), we don't want to activate the directory again
        // because it's already activated.
        if (this.isCurrentDirectoryActive_(navigationKey)) {
            // An unselected current directory item can be selected by:
            //  1. either change search location back from others to THIS_FOLDER.
            //  2. or users manually click the unselected current directory item to
            //  select it.
            // For 1, we don't need to clear the search, but for 2, we need to clear
            // the search, hence the check here.
            if (this.shouldUnselectCurrentDirectoryItem_()) {
                this.store_.dispatch(clearSearch());
            }
            return;
        }
        const navigationData = this.getNavigationDataFromKey_(navigationKey);
        if (!navigationData) {
            console.warn('Couldn\'t find the navigation data for the selected item in the store.');
            return;
        }
        const isRoot = 'androidAppData' in navigationData;
        const { fileData } = navigationData;
        if (fileData) {
            this.recordUmaForItemSelected_(fileData);
        }
        this.activateDirectory_(selectedItem, isRoot, fileData, isRoot ? navigationData.androidAppData :
            null);
    }
    /** Handler for mouse move event inside the tree. */
    onTreeMouseOver_(event) {
        this.maybeShowToolTip_(event);
    }
    /** Handler for file filter changed event. */
    onFileFilterChanged_() {
        // We don't know which file key is being impacted, we need to refresh all
        // entries we have in the map.
        this.store_.beginBatchUpdate();
        for (const navigationRoot of this.navigationRoots_) {
            if (navigationRoot.type === NavigationType.SHORTCUT) {
                continue;
            }
            const { fileData } = this.navigationRootMap_.get(navigationRoot.key);
            if (!fileData) {
                continue;
            }
            if (!canHaveSubDirectories(fileData)) {
                continue;
            }
            if (shouldDelayLoadingChildren(fileData, this.store_.getState()) &&
                !fileData.expanded) {
                continue;
            }
            this.store_.dispatch(readSubDirectories(fileData.key, /* recursive= */ true));
        }
        this.store_.endBatchUpdate();
    }
    /**
     * Handler for mouse move event inside the tree.
     *
     * The directory tree does not support horizontal scrolling (by design), but
     * can gain a scrollLeft > 0, see crbug.com/1025581. Always clamp scrollLeft
     * back to 0 if needed. In RTL, the scrollLeft clamp is not 0: it depends on
     * the element scrollWidth and clientWidth per crbug.com/721759.
     */
    onTreeScroll_() {
        if (this.scrollRAFActive_ === true) {
            return;
        }
        /**
         * True if a scroll RAF is active: scroll events are frequent and serviced
         * using RAF to throttle our processing of these events.
         */
        this.scrollRAFActive_ = true;
        const tree = this.tree;
        window.requestAnimationFrame(() => {
            this.scrollRAFActive_ = false;
            if (isRTL$1()) {
                const scrollRight = tree.scrollWidth - tree.clientWidth;
                if (tree.scrollLeft !== scrollRight) {
                    tree.scrollLeft = scrollRight;
                }
            }
            else if (tree.scrollLeft) {
                tree.scrollLeft = 0;
            }
        });
    }
    /**
     * Handler for FileWatcher's change event.
     */
    onFileWatcherEntryChanged_(event) {
        if (event.eventType !==
            chrome.fileManagerPrivate.FileWatchEventType.CHANGED ||
            !event.entry) {
            return;
        }
        this.updateTreeByEntry_(event.entry);
    }
    /** Record UMA for item expanded or collapsed. */
    recordUmaForItemExpandedOrCollapsed_(fileData) {
        const rootType = fileData.rootType ?? 'unknown';
        const level = fileData.isRootEntry ? 'TopLevel' : 'NonTopLevel';
        const metricName = `Location.OnEntryExpandedOrCollapsed.${level}`;
        recordEnum(metricName, rootType, RootTypesForUMA);
    }
    /** Record UMA for tree item selected. */
    recordUmaForItemSelected_(fileData) {
        const rootType = fileData.rootType ?? 'unknown';
        const level = fileData.isRootEntry ? 'TopLevel' : 'NonTopLevel';
        const metricName = `Location.OnEntrySelected.${level}`;
        recordEnum(metricName, rootType, RootTypesForUMA);
    }
    /** Activate the directory behind the item. */
    activateDirectory_(element, isRoot, fileData, androidAppData) {
        if (androidAppData) {
            // Exclude "icon" filed before sending it to the API.
            const { icon: _, ...androidAppDataForApi } = androidAppData;
            chrome.fileManagerPrivate.selectAndroidPickerApp(androidAppDataForApi, () => {
                if (chrome.runtime.lastError) {
                    console.error('selectAndroidPickerApp error: ', chrome.runtime.lastError.message);
                }
                else {
                    window.close();
                }
            });
            return;
        }
        if (!fileData) {
            return;
        }
        const fileKey = fileData.key;
        const navigationRootData = isRoot ?
            this.navigationRoots_.find(navigationRoot => navigationRoot.key === fileKey) :
            undefined;
        // TODO(b/308504417): Remove the special case for Drive.
        if (navigationRootData?.type === NavigationType.DRIVE) {
            if (fileData.children.length === 0) {
                // Drive volume isn't not mounted, we can only change directory to the
                // fake drive root.
                this.store_.dispatch(changeDirectory({ toKey: fileKey }));
            }
            else {
                // If Drive fake root is selected and it has Drive volume inside, we
                // expand it and go to the My Drive (1st child) directly.
                element.expanded = true;
                // If "Google Drive" item is the currently focused item, we also need to
                // set `shouldFocusOnNextSelectedItem_` flag to make sure the focus
                // shifts to My Drive when it's rendered after expanding.
                if (document.activeElement === element) {
                    this.shouldFocusOnNextSelectedItem_ = true;
                }
                const myDriveKey = fileData.children[0];
                const isMyDriveActive = this.isCurrentDirectoryActive_(myDriveKey);
                // If My Drive is already active, dispatching the changeDirectory below
                // with STARTED status won't trigger a SUCCESS status in DirectoryModel
                // because toKey is the same with the current directory key in the
                // store. As we rely on the SUCCESS status to decide which tree item to
                // select, we need to dispatch a SUCCESS status changeDirectory action
                // in this case.
                this.store_.dispatch(changeDirectory({
                    toKey: myDriveKey,
                    status: isMyDriveActive ? PropStatus.SUCCESS : PropStatus.STARTED,
                }));
            }
            return;
        }
        if (navigationRootData?.type === NavigationType.SHORTCUT) {
            recordUserAction('FolderShortcut.Navigate');
        }
        // For delayed loading navigation items, read children when it's selected.
        if (shouldDelayLoadingChildren(fileData, this.store_.getState()) &&
            fileData.children.length === 0) {
            this.store_.dispatch(readSubDirectoriesToCheckDirectoryChildren(fileData.key));
        }
        this.store_.dispatch(changeDirectory({ toKey: fileKey }));
    }
    maybeShowToolTip_(event) {
        const treeItem = event.target;
        if (!treeItem || !(treeItem instanceof XfTreeItem)) {
            return;
        }
        const labelElement = treeItem.shadowRoot.querySelector('.tree-label');
        if (!labelElement) {
            return;
        }
        maybeShowTooltip(labelElement, treeItem.label);
    }
    /**
     * Updates tree by entry.
     * `entry` A changed entry. Changed directory entry is passed when watched
     * directory is deleted.
     */
    updateTreeByEntry_(entry) {
        // TODO(b/271485133): Remove `getDirectory` call here and prevent
        // convertEntryToFileData() below.
        entry.getDirectory(entry.fullPath, { create: false }, () => {
            // Can't rely on store data to get entry's rootType, if the entry is
            // grand root entry's first sub folder, the grand root entry might not
            // be the in the store yet.
            const fileData = convertEntryToFileData(entry);
            // If entry exists.
            // e.g. /a/b is deleted while watching /a.
            if (isInsideDrive(fileData) && isGrandRootEntryInDrive(entry)) {
                // For grand root related changes, we need to re-read child
                // entries from the fake drive root level, because the grand root
                // might be show/hide based on if they have children or not.
                this.store_.dispatch(readSubDirectories(driveRootEntryListKey));
            }
            else {
                this.store_.dispatch(readSubDirectories(entry.toURL()));
            }
        }, () => {
            // If entry does not exist, try to get parent and update the subtree
            // by it. e.g. /a/b is deleted while watching /a/b. Try to update /a
            // in this case.
            entry.getParent((parentEntry) => {
                this.store_.dispatch(readSubDirectories(parentEntry.toURL()));
            }, () => {
                // If it fails to get parent, update the subtree by volume.
                // e.g. /a/b is deleted while watching /a/b/c. getParent of
                // /a/b/c fails in this case. We falls back to volume update.
                const state = this.store_.getState();
                const fileData = getFileData(state, entry.toURL());
                const volumeId = fileData?.volumeId;
                if (!volumeId) {
                    return;
                }
                for (const root of this.navigationRoots_) {
                    const { fileData } = this.navigationRootMap_.get(root.key);
                    if (fileData?.volumeId === volumeId) {
                        this.store_.dispatch(readSubDirectories(fileData.key, /* recursive= */ true));
                    }
                }
            });
        });
    }
    /**
     * Check if we need to dispatch an action to refresh navigation roots based
     * on the state.
     */
    shouldRefreshNavigationRoots_(state) {
        const { volumes, folderShortcuts, uiEntries, androidApps } = state;
        if (this.volumes_ !== volumes ||
            this.folderShortcuts_ !== folderShortcuts ||
            this.uiEntries_ !== uiEntries || this.androidApps_ !== androidApps) {
            this.volumes_ = volumes;
            this.folderShortcuts_ = folderShortcuts;
            this.uiEntries_ = uiEntries;
            this.androidApps_ = androidApps;
            return true;
        }
        return false;
    }
    /** Setup context menu for the given element. */
    setContextMenu_(element, fileData, navigationRoot) {
        // Trash is FakeEntry, but we still want to return menus for sub items.
        if (isTrashFileData(fileData)) {
            if (this.contextMenuForSubitems) {
                contextMenuHandler.setContextMenu(element, this.contextMenuForSubitems);
            }
            return;
        }
        // Disable menus for disabled items and RECENT items.
        // NOTE: Drive shared with me and offline are marked as RECENT.
        if (element.disabled || isRecentFileData(fileData)) {
            if (this.contextMenuForDisabledItems) {
                contextMenuHandler.setContextMenu(element, this.contextMenuForDisabledItems);
                return;
            }
        }
        if (navigationRoot) {
            // For MyFiles, show normal file operations menu.
            if (isMyFilesFileData(this.store_.getState(), fileData)) {
                if (this.contextMenuForSubitems) {
                    contextMenuHandler.setContextMenu(element, this.contextMenuForSubitems);
                }
                return;
            }
            // For other navigation roots, always show menus for root items, including
            // the removable entry list.
            if (this.contextMenuForRootItems) {
                contextMenuHandler.setContextMenu(element, this.contextMenuForRootItems);
            }
            return;
        }
        // For non-root navigation items, show menus for sub items.
        if (this.contextMenuForSubitems) {
            contextMenuHandler.setContextMenu(element, this.contextMenuForSubitems);
        }
    }
    /**
     * Attach a rename input to the tree item.
     */
    async attachRename_(element) {
        await element.updateComplete;
        // We need to focus the new folder item before renaming, the focus should
        // be back to this item after renaming finishes (controlled by
        // DirectoryTreeNamingController).
        this.tree.focusedItem = element;
        window.fileManager.directoryTreeNamingController.attachAndStart(element, false, null);
    }
    /**
     * Restore the focus to the tree item.
     */
    async restoreFocus_(element, isExisting) {
        if (!isExisting) {
            // This focus() call below requires the tree item to finish the first
            // render, hence the await above.
            await element.updateComplete;
        }
        element.focus();
    }
    /**
     * Given a NavigationKey, check if the key is the current directory in the
     * store or not.
     */
    isCurrentDirectoryActive_(navigationKey) {
        const { currentDirectory } = this.store_.getState();
        return currentDirectory?.key === navigationKey &&
            currentDirectory.status === PropStatus.SUCCESS;
    }
    async selectCurrentDirectoryItem_(currentDirectory) {
        const currentDirectoryKey = currentDirectory.key;
        const navigationData = this.getNavigationDataFromKey_(currentDirectoryKey);
        if (navigationData) {
            const element = navigationData.element;
            if (element && !element.selected) {
                // Reset fileKeyToSelect_ because we already find the element which
                // represents current directory.
                this.fileKeyToSelect_ = null;
                element.selected = true;
                // We only focus the element if shouldFocusOnNextSelectedItem_ is true.
                // This is because current directory change can't be triggered from
                // other parts of Files UI, e.g. "Go to file location" in Recents, where
                // we shouldn't steal the focus from others.
                if (this.shouldFocusOnNextSelectedItem_) {
                    this.shouldFocusOnNextSelectedItem_ = false;
                    // Wait for the selected change finishes (e.g. expand all its parents)
                    // before we can focus on the element below.
                    await element.updateComplete;
                    element.focus();
                }
            }
            return;
        }
        // The item which represents the current directory can not be found in the
        // tree, we need to read sub directory from the root recursively until we
        // find the targeted current directory.
        if (this.fileKeyToSelect_ === currentDirectoryKey) {
            // Do nothing because we already started a reading call to find this exact
            // same "current directory" (see logic below.)
            return;
        }
        // Set the selected item to null before scanning for the target directory,
        // if we couldn't find the target directory after scanning (e.g. "Go to
        // file location" for Play files in recent view b/265101238), nothing
        // should be selected in the tree.
        this.tree.selectedItem = null;
        this.fileKeyToSelect_ = currentDirectoryKey;
        const pathKeys = currentDirectory.pathComponents.map(pathComponent => pathComponent.key);
        this.store_.dispatch(traverseAndExpandPathEntries(pathKeys));
    }
    /**
     * Check if we need to unselect the current directory item in the tree.
     * When searching is active and we are not searching current folder, we
     * shouldn't have any tree item selected.
     */
    shouldUnselectCurrentDirectoryItem_() {
        const state = this.store_.getState();
        const { search, currentDirectory } = state;
        const isSearchActive = search?.status !== undefined && !!(search?.query);
        let isCurrentDirectoryInsideDrive = false;
        if (currentDirectory?.key) {
            const currentDirectoryData = getFileData(state, currentDirectory.key);
            // The current directory might not exist if it unmounts.
            if (currentDirectoryData) {
                isCurrentDirectoryInsideDrive = isInsideDrive(currentDirectoryData);
            }
        }
        const isSearchInCurrentFolder = 
        // When searching in Drive, the search location option will only include
        // ROOT_FOLDER ("Google Drive"), not include THIS_FOLDER.
        (isCurrentDirectoryInsideDrive &&
            search?.options?.location === SearchLocation.ROOT_FOLDER) ||
            search?.options?.location === SearchLocation.THIS_FOLDER;
        return isSearchActive && !isSearchInCurrentFolder;
    }
}

function getTemplate$n() {
    return getTrustedHTML `<!--_html_template_start_--><style>
#container > * {
  background-color: var(--cros-sys-primary);
  z-index: 999;
}

#dot {
  border-radius: 50%;
  height: 8px;
  left: -8px;
  position: fixed;
  width: 8px;
}

#bubble {
  align-items: center;
  border-radius: 16px;
  color: var(--cros-sys-on_primary);
  display: flex;
  left: -296px;
  max-width: calc(296px - 2 * 16px);
  padding: 8px 16px;
  position: fixed;
  width: fit-content;
}

#bubble.single-line {
  border-radius: 18px;
}

#bubble > .icon {
  -webkit-mask-image: url(/foreground/images/files/ui/nudge_star_icon.svg);
  -webkit-mask-position: center;
  -webkit-mask-repeat: no-repeat;
  background-color: currentColor;
  height: 20px;
  margin-inline-end: 12px;
  width: 20px;
}

#bubble > span {
  font: var(--cros-body-1-font);
}

#dismiss {
  --focus-shadow-color: var(--cros-sys-inverse_primary);
  align-self: center;
  border-radius: 8px;
  color: var(--cros-sys-on_primary);
}
</style>
<div aria-hidden="true" id="container">
  <div id="dot"></div>
  <div id="bubble">
    <span class="icon"></span>
    <span id="text"></span>
    <cr-button id="dismiss" aria-describedby="text" hidden></cr-button>
  </div>
</div>
<!--_html_template_end_-->`;
}

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * The diameter of the dot that appears beside the anchor. Keep this up to date
 * with the width of the dot in the `xf_nudge.html` file.
 */
const DOT_DIAMETER_PX = 8;
/**
 * The default indent that the dot is from the side of the bubble.
 */
const DEFAULT_DOT_INDENT_PX = 32;
/**
 * An XfNudge represents an element on the screen to draw the user's
 * attention to a specific portion of the screen. This can be a new feature, the
 * location of a file that has just changed etc.
 */
class XfNudge extends HTMLElement {
    constructor() {
        super();
        /**
         * The anchor element that the nudge should be highlighting.
         */
        this.anchor_ = undefined;
        /**
         * The direction of the nudge relative to the anchor.
         */
        this.direction_ = NudgeDirection.TOP_STARTWARD;
        /**
         * The content of the nudge.
         */
        this.content_ = '';
        /**
         * Text used in the dismiss button. When empty the button is hidden.
         */
        this.dismissText_ = '';
        /**
         * How many times the nudge has been repositioned, this is reset when the
         * nudge is hidden.
         */
        this.repositions_ = 0;
        const template = document.createElement('template');
        template.innerHTML = getTemplate$n();
        const fragment = template.content.cloneNode(true);
        this.attachShadow({ mode: 'open' }).appendChild(fragment);
        this.bubble_ = this.shadowRoot.getElementById('bubble');
        this.contentSlot_ = this.shadowRoot.getElementById('text');
        this.dismissButton_ = this.shadowRoot.getElementById('dismiss');
        this.dismissButton_.addEventListener('click', this.dismissClicked_.bind(this));
        this.dot_ = this.shadowRoot.getElementById('dot');
    }
    static get events() {
        return {
            DISMISS: 'dismiss',
        };
    }
    dismissClicked_() {
        this.dispatchEvent(new CustomEvent(XfNudge.events.DISMISS, { bubbles: true, composed: true }));
    }
    /**
     * Show the nudge attached to a provided anchor. Note: This class should not
     * handle any logic on _when_ a nudge should be shown. This should be
     * completely handled by the NudgeManager.
     */
    show() {
        if (this.content_ === '') {
            throw new Error('Attempted to show <xf-nudge> without a message');
        }
        if (!this.anchor_) {
            throw new Error('Attempted to show <xf-nudge> without an anchor');
        }
        this.dismissButton_.innerText = this.dismissText_;
        this.dismissButton_.toggleAttribute('hidden', this.dismissText_ === '');
        this.contentSlot_.innerText = this.content_;
        this.reposition();
    }
    /**
     * Hide the nudge. Note: This class should not handle any logic on _when_ a
     * nudge should be hidden. This should be completely handled by the
     * NudgeManager.
     */
    hide() {
        // Rather than removing the nudge elements from the DOM, render them
        // off-screen so that they change size correctly when the nudge contents are
        // updated. In doing this, they will be the correct size before attempting
        // to position the nudge the next time it is shown.
        this.dot_.style.left = `-${DOT_DIAMETER_PX}px`;
        this.bubble_.style.left = '-296px';
        this.repositions_ = 0;
    }
    /**
     * Repositions the nudge component to be anchored to the anchor.
     */
    reposition() {
        if (!this.anchor_) {
            throw new Error('Attempted to position <xf-nudge> without an anchor');
        }
        // Reset CSS values which might not get set.
        this.bubble_.style.left = 'unset';
        this.bubble_.style.right = 'unset';
        this.bubble_.style.top = 'unset';
        this.bubble_.style.bottom = 'unset';
        const anchorRect = this.anchor_.getBoundingClientRect();
        this.positionDot_(anchorRect);
        if (this.positionedVertically_()) {
            this.positionBubbleVertical_(anchorRect);
        }
        else {
            this.positionBubbleHorizontal_(anchorRect);
        }
        this.repositions_++;
    }
    /**
     * Sets the anchor that the nudge is tied to. This element will serve as the
     * point where the nudge will position itself relative to.
     */
    set anchor(anchor) {
        this.anchor_ = anchor;
    }
    /**
     * Get the anchor this nudge is highlighting.
     */
    get anchor() {
        return this.anchor_;
    }
    /**
     * Sets the content that the nudge will show.
     */
    set content(content) {
        this.content_ = content;
    }
    /**
     * Returns the content that the nudge will display.
     */
    get content() {
        return this.content_;
    }
    /**
     * Sets the text for the dismiss button, when empty hides the button.
     */
    set dismissText(text) {
        this.dismissText_ = text;
    }
    get dismissText() {
        return this.dismissText_;
    }
    /**
     * Sets the direction of the nudge to appear relative to the anchor point.
     */
    set direction(direction) {
        this.direction_ = direction;
    }
    /**
     * Helper method that exposes the bounding DOMRect of the dot to introspect in
     * tests.
     */
    get dotRect() {
        return this.dot_.getBoundingClientRect();
    }
    /**
     * Helper method that exposes the bounding DOMRect of the bubble to introspect
     * in tests.
     */
    get bubbleRect() {
        return this.bubble_.getBoundingClientRect();
    }
    /**
     * Returns the number of repositions for the nudge that is currently showing.
     * This is reset when the nudge is hidden.
     */
    get repositions() {
        return this.repositions_;
    }
    /**
     * Position the dot of the nudge to be at the correct position to the anchored
     * element.
     */
    positionDot_(anchorRect) {
        let dotTop = anchorRect.top + anchorRect.height / 2 - DOT_DIAMETER_PX / 2;
        let dotLeft = anchorRect.left + anchorRect.width / 2 - DOT_DIAMETER_PX / 2;
        if (this.positionedTop_()) {
            dotTop = anchorRect.top - DOT_DIAMETER_PX - 4;
        }
        if (this.positionedBottom_()) {
            dotTop = anchorRect.bottom + 4;
        }
        if (this.positionedLeft()) {
            dotLeft = anchorRect.left - DOT_DIAMETER_PX - 4;
        }
        if (this.positionedRight_()) {
            dotLeft = anchorRect.right + 4;
        }
        this.dot_.style.top = `${dotTop}px`;
        this.dot_.style.left = `${dotLeft}px`;
    }
    /**
     * Position the bubble that has the nudge contents vertically above or below
     * the dot.
     */
    positionBubbleVertical_(anchorRect) {
        // Calculate the bubble's vertical position.
        if (this.positionedTop_()) {
            const bubbleBottom = anchorRect.top - DOT_DIAMETER_PX - 2 * 4;
            // Fixed position bottom refers to how far the bottom edge of the element
            // should be from the bottom edge of the window, so transform our value to
            // account for this difference in semantics.
            this.bubble_.style.bottom = `${window.innerHeight - bubbleBottom}px`;
        }
        else {
            this.bubble_.style.top =
                `${anchorRect.bottom + DOT_DIAMETER_PX + 2 * 4}px`;
        }
        // Calculate the bubble's horizontal position.
        if (this.growsLeft_()) {
            // E.g.,
            //  _________________
            //  |  Nudge        |
            //  |_______________|
            //              .
            //             []
            // Calculate the ideal right edge position for the bubble to have it
            // appear towards the left of the dot.
            const dotRightEdge = anchorRect.left + anchorRect.width / 2 + DOT_DIAMETER_PX / 2 + 4;
            // The bubble's right edge should be `DEFAULT_DOT_INDENT_PX` further right
            // than the dot's right edge.
            const idealBubbleRight = dotRightEdge + DEFAULT_DOT_INDENT_PX;
            // The bubble should not be positioned so far right that it goes
            // off-screen.
            const maxBubbleRight = window.innerWidth;
            // Fixed position right refers to how far the right edge of the element
            // should be from the right edge of the window, so transform our value to
            // account for this difference in semantics.
            this.bubble_.style.right =
                `${window.innerWidth - Math.min(idealBubbleRight, maxBubbleRight)}px`;
        }
        else {
            // E.g.,
            //  _________________
            //  |  Nudge        |
            //  |_______________|
            //      .
            //     []
            // Calculate the ideal left offset for the bubble to have it appear
            // towards the right of the dot.
            const dotLeftEdge = anchorRect.left + anchorRect.width / 2 - DOT_DIAMETER_PX / 2 - 4;
            const idealBubbleLeft = dotLeftEdge - DEFAULT_DOT_INDENT_PX;
            this.bubble_.style.left = `${Math.max(idealBubbleLeft, 0)}px`;
        }
    }
    /**
     * Position the bubble that has the nudge contents horizontally to the left or
     * right of the dot.
     */
    positionBubbleHorizontal_(anchorRect) {
        // Calculate the bubble's vertical position.
        if (this.growsUpward_()) {
            // We can't guarantee the height of the anchor, so position the bottom of
            // the bubble 10px below the dot.
            const dotBottom = anchorRect.top + anchorRect.height / 2 + DOT_DIAMETER_PX / 2 + 4;
            const bubbleBottom = dotBottom + 10;
            // Fixed position bottom refers to how far the bottom edge of the element
            // should be from the bottom edge of the window, so transform our value to
            // account for this difference in semantics.
            this.bubble_.style.bottom = `${window.innerHeight - bubbleBottom}px`;
        }
        else {
            // We can't guarantee the height of the anchor, so position the top of the
            // bubble 10px above the dot.
            const dotTop = anchorRect.top + anchorRect.height / 2 - DOT_DIAMETER_PX / 2 - 4;
            const bubbleTop = dotTop - 10;
            this.bubble_.style.top = `${bubbleTop}px`;
        }
        // Calculate the bubble's horizontal position.
        if (this.positionedLeft()) {
            // E.g.,
            //  _________________
            //  |  Nudge        |
            //  |_______________| . []
            const bubbleRight = anchorRect.left - DOT_DIAMETER_PX - 2 * 4;
            // Fixed position right refers to how far the right edge of the element
            // should be from the right edge of the window, so transform our value to
            // account for this difference in semantics.
            this.bubble_.style.right = `${window.innerWidth - bubbleRight}px`;
        }
        else {
            // E.g.,
            //      _________________
            //      |  Nudge        |
            // [] . |_______________|
            const bubbleLeft = anchorRect.right + DOT_DIAMETER_PX + 2 * 4;
            this.bubble_.style.left = `${bubbleLeft}px`;
        }
    }
    /**
     * For the remainder methods, look at the NudgeDirection to understand what
     * they mean.
     */
    positionedTop_() {
        return this.direction_ === NudgeDirection.TOP_STARTWARD ||
            this.direction_ === NudgeDirection.TOP_ENDWARD;
    }
    positionedBottom_() {
        return this.direction_ === NudgeDirection.BOTTOM_STARTWARD ||
            this.direction_ === NudgeDirection.BOTTOM_ENDWARD;
    }
    positionedLeading_() {
        return this.direction_ === NudgeDirection.LEADING_UPWARD ||
            this.direction_ === NudgeDirection.LEADING_DOWNWARD;
    }
    positionedTrailing_() {
        return this.direction_ === NudgeDirection.TRAILING_UPWARD ||
            this.direction_ === NudgeDirection.TRAILING_DOWNWARD;
    }
    positionedLeft() {
        if (document.dir === 'rtl') {
            return this.positionedTrailing_();
        }
        else {
            return this.positionedLeading_();
        }
    }
    positionedRight_() {
        if (document.dir === 'rtl') {
            return this.positionedLeading_();
        }
        else {
            return this.positionedTrailing_();
        }
    }
    positionedVertically_() {
        return this.positionedTop_() || this.positionedBottom_();
    }
    growsUpward_() {
        return this.direction_ === NudgeDirection.LEADING_UPWARD ||
            this.direction_ === NudgeDirection.TRAILING_UPWARD;
    }
    growsLeft_() {
        if (document.dir === 'rtl') {
            return this.direction_ === NudgeDirection.TOP_ENDWARD ||
                this.direction_ === NudgeDirection.BOTTOM_ENDWARD;
        }
        else {
            return this.direction_ === NudgeDirection.TOP_STARTWARD ||
                this.direction_ === NudgeDirection.BOTTOM_STARTWARD;
        }
    }
}
/**
 * The direction a nudge should render relative to its anchor.
 */
var NudgeDirection;
(function (NudgeDirection) {
    /** Shows above the anchor and extends to the left in LTR. */
    NudgeDirection["TOP_STARTWARD"] = "top-startward";
    /** Shows above the anchor and extends to the right in LTR. */
    NudgeDirection["TOP_ENDWARD"] = "top-endward";
    /** Shows below the anchor and extends to the left in LTR. */
    NudgeDirection["BOTTOM_STARTWARD"] = "bottom-startward";
    /** Shows below the anchor and extends to the right in LTR. */
    NudgeDirection["BOTTOM_ENDWARD"] = "bottom-endward";
    /**
     * Shows left of the anchor in LTR and grows upwards if the content spans
     * multiple lines.
     */
    NudgeDirection["LEADING_UPWARD"] = "leading-upward";
    /**
     * Shows left of the anchor in LTR and grows downwards if the content spans
     * multiple lines.
     */
    NudgeDirection["LEADING_DOWNWARD"] = "leading-downward";
    /**
     * Shows right of the anchor in LTR and grows upwards if the content spans
     * multiple lines.
     */
    NudgeDirection["TRAILING_UPWARD"] = "trailing-upward";
    /**
     * Shows right of the anchor in LTR and grows downwards if the content spans
     * multiple lines.
     */
    NudgeDirection["TRAILING_DOWNWARD"] = "trailing-downward";
})(NudgeDirection || (NudgeDirection = {}));
customElements.define('xf-nudge', XfNudge);

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * Class used to emit window.localStorage change events to event listeners.
 * This class does 3 things:
 *
 * 1. Holds the onChanged event listeners for the current window.
 * 2. Sends broadcast event to all windows.
 * 3. Listens to broadcast events and propagates to the listeners in
 *    the current window.
 *
 * NOTE: This doesn't support the `oldValue` because it's simpler and the
 * current clients of `onChanged` don't need it.
 */
class StorageChangeTracker {
    /**
     * @param storageNamespace_ Storage namespace argument added when calling
     *     listeners.
     */
    constructor(storageNamespace_) {
        this.storageNamespace_ = storageNamespace_;
        /** Storage onChanged event listeners for the current window. */
        this.listeners_ = [];
        /** Event to send local storage changes to all window listeners. */
        window.addEventListener('storage', this.onStorageEvent_.bind(this));
    }
    /** Resets for testing: removes all listeners. */
    resetForTesting() {
        this.listeners_ = [];
    }
    /** Adds an onChanged event listener for the current window. */
    addListener(callback) {
        this.listeners_.push(callback);
    }
    /** Notifies listeners of key value changes. */
    keysChanged(changedValues) {
        const changedKeys = {};
        for (const [k, v] of Object.entries(changedValues)) {
            // `oldValue` isn't necessary for the current use case.
            changedKeys[k] = { newValue: v };
        }
        this.notifyLocally_(changedKeys);
    }
    /** Processes storage event and notifies listeners. */
    onStorageEvent_(event) {
        const { key, newValue } = event;
        if (key === null || newValue === null) {
            return;
        }
        const changedKeys = {};
        try {
            changedKeys[key] = { newValue: JSON.parse(newValue) };
        }
        catch (error) {
            // This is expected when window.localStorage is used directly instead of
            // `local.storage` defined below.
            debug(`Cannot parse local storage value from key '${key}' as JSON`, error);
            changedKeys[key] = { newValue };
        }
        this.notifyLocally_(changedKeys);
    }
    /** Notifies local (current window) listeners of key value changes. */
    notifyLocally_(keys) {
        for (const listener of this.listeners_) {
            try {
                listener(keys, this.storageNamespace_);
            }
            catch (error) {
                console.error('Error calling storage.onChanged listener', error);
            }
        }
    }
}
/**
 * StorageAreaImpl using window.localStorage as the storage area.
 */
class StorageAreaImpl {
    constructor(type) {
        this.storageChangeTracker = new StorageChangeTracker(type);
    }
    /** Gets values of `keys` and returns them in the callback. */
    get(keys, callback) {
        const keyList = Array.isArray(keys) ? keys : [keys];
        const result = {};
        for (const key of keyList) {
            result[key] = this.getValue_(key);
        }
        callback(result);
    }
    /** Gets the value of `key` from local storage. */
    getValue_(key) {
        const value = window.localStorage.getItem(key);
        try {
            return JSON.parse(value);
        }
        catch (error) {
            console.warn(`Failed to JSON parse localStorage value from key: "${key}" ` +
                `returning the raw value.`, error);
            return value;
        }
    }
    /** Async version of `this.get()`. */
    async getAsync(keys) {
        return new Promise(resolve => this.get(keys, resolve));
    }
    /**
     * Stores items in local storage.
     * @param items The items to store.
     * @param callback Callback to be called when the items have been stored.
     */
    set(items, callback) {
        for (const key in items) {
            const value = JSON.stringify(items[key]);
            window.localStorage.setItem(key, value);
        }
        this.notifyChange_(Object.keys(items));
        callback?.();
    }
    /**
     * Async version of `this.set()`.
     * @param items The items to store.
     */
    async setAsync(items) {
        return new Promise(resolve => this.set(items, resolve));
    }
    /** Removes the given `keys` from local storage. */
    remove(keys) {
        const keyList = Array.isArray(keys) ? keys : [keys];
        for (const key of keyList) {
            window.localStorage.removeItem(key);
        }
        this.notifyChange_(keyList);
    }
    /** Clears local storage. */
    clear() {
        window.localStorage.clear();
        this.notifyChange_([]);
    }
    /** Notifies key changes to storage change tracker listeners. */
    notifyChange_(keys) {
        const values = {};
        for (const k of keys) {
            values[k] = this.getValue_(k);
        }
        this.storageChangeTracker.keysChanged(values);
    }
}
var storage;
(function (storage) {
    storage.local = new StorageAreaImpl('local');
    storage.onChanged = storage.local.storageChangeTracker;
})(storage || (storage = {}));

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * NudgeContainer maintains the lifetime of a "nudge". A nudge refers to an
 * educational overlay that shows up to highlight new features, currently we
 * only support a single nudge showing in Files app.
 */
class NudgeContainer {
    constructor() {
        /**
         * The educational nudge that is added as a web component to the DOM.
         */
        this.nudge_ = document.querySelector('xf-nudge');
        /**
         * The handle that represents the requestIdleCallback to enable cancellation.
         */
        this.idleCallbackHandle_ = -1;
        /**
         * The current `NudgeType` that is visible.
         */
        this.currentNudgeType_ = undefined;
        /**
         * Each nudge has a described-by <p> tag to enable an announcement to be made
         * when hovering over or tabbing to the anchored element.
         */
        this.anchorAriaDescribedbyElement_ = document.createElement('p');
        /**
         * A controller which sends out an abort signal once we no longer want to
         * listen to events i.e. on nudge hide.
         */
        this.listenerAbortController_ = null;
        /**
         * Cache the DOMRect of the anchor to allow comparison of the previous
         * location and in the case the anchor DOMRect changes, reposition the nudge
         * accordingly.
         */
        this.anchorDomRect_ = undefined;
        /**
         * Stores the ID of the current requestAnimationFrame(). Used to ensure only
         * run callback is running at a time.
         */
        this.requestAnimationFrameId_ = undefined;
        /**
         * True if the expiry period on the nudge is observed. False otherwise.
         */
        this.expiryPeriodEnabled_ = true;
        this.anchorAriaDescribedbyElement_.id = 'nudge-content';
        this.anchorAriaDescribedbyElement_.style.display = 'none';
    }
    /**
     * A callback that repositions the nudge element prior to a repaint. The
     * callback is throttled to only run on animation frames since we call it for
     * scroll events; which can be numerous between frames.
     */
    throttledRepositionCallback_() {
        if (this.requestAnimationFrameId_) {
            return;
        }
        this.requestAnimationFrameId_ = window.requestAnimationFrame(() => {
            if (!this.nudgeShowing_) {
                return;
            }
            const anchorDomRect = this.nudge_.anchor.getBoundingClientRect();
            // First verify that the anchor has changed in some position or dimension
            // before repositioning the nudge. This ensures we're not too aggressive
            // in repositioning.
            if (this.anchorDomRect_ &&
                (anchorDomRect.x !== this.anchorDomRect_.x ||
                    anchorDomRect.y !== this.anchorDomRect_.y ||
                    anchorDomRect.width !== this.anchorDomRect_.width ||
                    anchorDomRect.height !== this.anchorDomRect_.height)) {
                this.anchorDomRect_ = anchorDomRect;
                this.nudge_.reposition();
            }
            this.requestAnimationFrameId_ = undefined;
        });
    }
    /**
     * Attempts to reposition the visible nudge if it is showing. There is no easy
     * way to listen for DOM elements that change without user input (e.g. if a
     * volume is added or removed from the directory tree). So use an IdleCallback
     * to keep checking the nudge is in the right position.
     */
    idleCallback_() {
        if (this.nudgeShowing_) {
            this.throttledRepositionCallback_();
            this.idleCallbackHandle_ = window.requestIdleCallback(this.idleCallback_.bind(this), { timeout: 1000 });
            return;
        }
        window.cancelIdleCallback(this.idleCallbackHandle_);
    }
    /**
     * A method for the nudge manager to decide whether a given nudge has been
     * previously seen and dismissed by the user.
     */
    async checkSeen(nudgeId) {
        const seen = await storage.local.getAsync(nudgeId);
        return seen[nudgeId] === 'true';
    }
    /**
     * A method for the nudge manager to specify that a given nudge has been seen
     * and dismissed by the user.
     */
    async setSeen(nudgeId) {
        return storage.local.setAsync({ [nudgeId]: 'true' });
    }
    /**
     * Clears the `seen` state from the localStorage for the given nudge.
     */
    async clearSeen(nudgeType) {
        storage.local.remove(nudgeType);
    }
    /**
     * Shows the nudge if it has not already been seen before.
     */
    async showNudge(nudge) {
        if (this.nudgeShowing_) {
            return;
        }
        // No nudge info exists for the supplied nudge.
        if (!nudgeInfo[nudge]) {
            console.warn('Nudge', nudge, 'does not exist');
            return;
        }
        if (!nudgeInfo[nudge].anchor()) {
            console.warn('nudge anchor', nudge, 'does not exist');
            return;
        }
        const info = nudgeInfo[nudge];
        const anchor = info.anchor();
        // Don't show the nudge if it's expired and the expiry period is enabled.
        if (info.expiryDate && info.expiryDate < new Date() &&
            this.expiryPeriodEnabled_) {
            return;
        }
        if (await this.checkSeen(nudge)) {
            return;
        }
        this.currentNudgeType_ = nudge;
        // Create a new controller since they can only be aborted once (adding an
        // aborted signal to a listener will result in no listening).
        this.listenerAbortController_ = new AbortController();
        // Anchor container scrolling and document resizes can potentially
        // reposition the anchor, which will need a matching reposition of the nudge
        // element-- so we listen to those events and reposition upon them
        // occurring. Note, it is possible that there are other ways of manipulating
        // the anchor position without triggering any of the events here (e.g.
        // resizing an element within the document); but no such use case exists
        // yet.
        const config = {
            signal: this.listenerAbortController_.signal,
            passive: true,
        };
        let anchorTreeNode = anchor;
        while (anchorTreeNode) {
            if (anchorTreeNode instanceof EventTarget) {
                anchorTreeNode.addEventListener('scroll', this.throttledRepositionCallback_.bind(this), config);
            }
            anchorTreeNode = anchorTreeNode.parentNode;
            if (anchorTreeNode instanceof ShadowRoot) {
                anchorTreeNode = anchorTreeNode.host;
            }
        }
        window.addEventListener('resize', this.throttledRepositionCallback_.bind(this), config);
        if (info.selfDismiss) {
            // Self dismissable nudge only dismisses if the user clicks on the nudge.
            this.nudge_.addEventListener('pointerdown', () => this.closeNudge(this.currentNudgeType_), config);
            anchor.addEventListener('pointerdown', () => this.closeNudge(this.currentNudgeType_), config);
            const dismissOnKeyDown = info.dismissOnKeyDown;
            if (dismissOnKeyDown) {
                document.addEventListener('keydown', (event) => {
                    if (dismissOnKeyDown(anchor, event)) {
                        this.closeNudge(this.currentNudgeType_);
                    }
                }, config);
            }
        }
        else {
            // Otherwise the nudge dismisses when user clicks anywhere in the app.
            document.addEventListener('keydown', e => this.handleKeyDown_(e), config);
            document.addEventListener('pointerdown', e => this.handlePointerDown_(e), config);
            anchor.addEventListener('blur', (_) => this.closeNudge(this.currentNudgeType_), config);
            this.nudge_.dismissText = '';
        }
        this.nudge_.anchor = anchor;
        this.nudge_.content = info.content();
        this.nudge_.direction = info.direction;
        this.nudge_.show();
        this.anchorDomRect_ = anchor.getBoundingClientRect();
        this.setAnchorAriaDescribedby_();
        window.cancelIdleCallback(this.idleCallbackHandle_);
        this.idleCallbackHandle_ = window.requestIdleCallback(this.idleCallback_.bind(this), { timeout: 1000 });
    }
    /**
     * Hide the currently showing nudge and update the seen status if provided.
     */
    async closeNudge(seenNudgeId) {
        window.cancelIdleCallback(this.idleCallbackHandle_);
        if (!this.nudgeShowing_) {
            return;
        }
        if (seenNudgeId) {
            await this.setSeen(seenNudgeId);
        }
        this.nudge_.hide();
        this.currentNudgeType_ = undefined;
        this.anchorDomRect_ = undefined;
        this.removeAnchorAriaDescribedby_();
        // Abort listeners since we don't want to update position after hiding.
        this.listenerAbortController_?.abort();
    }
    /**
     * Used to override the expiry period for nudges in test.
     */
    set setExpiryPeriodEnabledForTesting(value) {
        this.expiryPeriodEnabled_ = value;
    }
    /**
     * Handle key down events such that any "Escape", "Enter" or "Space" should
     * close the nudge.
     */
    handleKeyDown_(event) {
        switch (event.key) {
            case 'Escape':
            case 'Enter':
            case 'Space':
                this.closeNudge(this.currentNudgeType_);
                break;
        }
    }
    /**
     * Handle any pointer down events on the Nudge.
     */
    handlePointerDown_(event) {
        // Ignore pointer events on the nudge to allow copying the nudge's text.
        if (event.composedPath().includes(this.nudge_)) {
            return;
        }
        this.closeNudge(this.currentNudgeType_);
    }
    /**
     * Set the <p> aria-described-by content to enable screen readers to hear the
     * nudge content when navigating over the anchored element.
     */
    setAnchorAriaDescribedby_() {
        if (!this.nudge_.anchor) {
            return;
        }
        this.anchorAriaDescribedbyElement_.innerText = this.nudge_.content;
        // Add a new element as a sibling of the anchor so we can aria-describedBy
        // it to read out the contents of the nudge.
        this.nudge_.anchor.insertAdjacentElement('afterend', this.anchorAriaDescribedbyElement_);
        this.nudge_.anchor.setAttribute('aria-describedby', 'nudge-content');
    }
    /**
     * Remove the <p> aria-described-by content.
     */
    removeAnchorAriaDescribedby_() {
        this.anchorAriaDescribedbyElement_.remove();
        if (!this.nudge_.anchor) {
            return;
        }
        this.nudge_.anchor.removeAttribute('aria-describedby');
    }
    /**
     * Helper function to return whether a current nudge is showing.
     */
    get nudgeShowing_() {
        return this.currentNudgeType_ !== undefined;
    }
}
/**
 * An enum of nudges that can be shown, only a single nudge is shown at a time.
 */
var NudgeType;
(function (NudgeType) {
    NudgeType["TEST_NUDGE"] = "test-nudge";
    NudgeType["MANUAL_TEST_NUDGE"] = "manual-test-nudge";
    NudgeType["ONE_DRIVE_MOVED_FILE_NUDGE"] = "one-drive-moved-file-nudge";
    NudgeType["DRIVE_MOVED_FILE_NUDGE"] = "drive-moved-file-nudge";
    NudgeType["SEARCH_V2_EDUCATION_NUDGE"] = "search-v2-education-nudge";
})(NudgeType || (NudgeType = {}));
/**
 * Dismisses the nudge when the tree-item that anchors the nudge is selected.
 *
 * NOTE: It relies on the nudge anchor being in the icon, to traverse 2 parents
 * up to the tree-item.
 */
function treeDismissOnKeyDownOnTreeItem(anchor, event) {
    const dismissKeys = new Set(['Enter', 'Space']);
    if (!dismissKeys.has(event.key)) {
        return false;
    }
    // When the anchor (tree item) is selected we dismiss.
    const parentTreeItem = anchor?.getRootNode()?.host;
    if (parentTreeItem?.hasAttribute('selected')) {
        return true;
    }
    return false;
}
/**
 * A mapping of nudges to their information that can be shown throughout the
 * Files app.
 */
const nudgeInfo = {
    [NudgeType['TEST_NUDGE']]: {
        anchor: () => document.querySelector('div#test'),
        content: () => 'Test content',
        direction: NudgeDirection.BOTTOM_ENDWARD,
        expiryDate: new Date(2999, 1, 1),
    },
    [NudgeType['MANUAL_TEST_NUDGE']]: {
        anchor: () => {
            const downloadsTreeItem = document.querySelector('xf-tree-item[icon="downloads"]');
            return downloadsTreeItem.shadowRoot.querySelector('xf-icon');
        },
        content: () => str('ONE_DRIVE_MOVED_FILE_NUDGE'),
        direction: NudgeDirection.TRAILING_DOWNWARD,
        expiryDate: new Date(2999, 1, 1),
        selfDismiss: true,
        dismissOnKeyDown: treeDismissOnKeyDownOnTreeItem,
    },
    [NudgeType['ONE_DRIVE_MOVED_FILE_NUDGE']]: {
        anchor: () => {
            const oneDriveTreeItem = document.querySelector('xf-tree-item[one-drive]');
            return oneDriveTreeItem?.shadowRoot.querySelector('.tree-row') || null;
        },
        content: () => str('ONE_DRIVE_MOVED_FILE_NUDGE'),
        direction: NudgeDirection.TRAILING_DOWNWARD,
        expiryDate: new Date(2025, 12, 5),
        selfDismiss: true,
        dismissOnKeyDown: treeDismissOnKeyDownOnTreeItem,
    },
    [NudgeType['DRIVE_MOVED_FILE_NUDGE']]: {
        anchor: () => {
            const driveTreeItem = document.querySelector('xf-tree-item[icon="service_drive"]');
            return driveTreeItem?.shadowRoot.querySelector('.tree-row') || null;
        },
        content: () => str('DRIVE_MOVED_FILE_NUDGE'),
        direction: NudgeDirection.TRAILING_DOWNWARD,
        expiryDate: new Date(2025, 12, 5),
        selfDismiss: true,
        dismissOnKeyDown: treeDismissOnKeyDownOnTreeItem,
    },
    [NudgeType['SEARCH_V2_EDUCATION_NUDGE']]: {
        anchor: () => document.querySelector('#search-button > .icon'),
        content: () => str('SEARCH_V2_EDUCATION_NUDGE'),
        direction: NudgeDirection.BOTTOM_STARTWARD,
        // Expire after 4 releases (expires when M120 hits Stable).
        expiryDate: new Date(2023, 12, 5),
    },
};

// Copyright 2015 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class DriveToggleOfflineAction {
    constructor(entries_, metadataModel_, ui_, value_, onExecute_) {
        this.entries_ = entries_;
        this.metadataModel_ = metadataModel_;
        this.ui_ = ui_;
        this.value_ = value_;
        this.onExecute_ = onExecute_;
    }
    static create(entries, metadataModel, ui, value, onExecute) {
        const actionableEntries = entries.filter(entry => metadataModel.getCache([entry], ['pinned'])[0]?.pinned !== value);
        if (actionableEntries.length === 0) {
            return null;
        }
        return new DriveToggleOfflineAction(actionableEntries, metadataModel, ui, value, onExecute);
    }
    execute() {
        const entries = this.entries_;
        if (entries.length === 0) {
            return;
        }
        let currentEntry;
        let error = false;
        const steps = {
            // Pick an entry and pin it.
            start: () => {
                // Check if all the entries are pinned or not.
                if (entries.length === 0) {
                    return;
                }
                currentEntry = entries.shift();
                // Skip files we cannot pin.
                if (this.metadataModel_.getCache([currentEntry], ['canPin'])[0]
                    ?.canPin) {
                    chrome.fileManagerPrivate.pinDriveFile(unwrapEntry(currentEntry), this.value_, steps.entryPinned);
                }
                else {
                    steps.start();
                }
            },
            // Check the result of pinning.
            entryPinned: () => {
                error = !!chrome.runtime.lastError;
                recordBoolean('DrivePinSuccess', !error);
                if (this.metadataModel_.getCache([currentEntry], ['hosted'])[0]
                    ?.hosted) {
                    recordBoolean('DriveHostedFilePinSuccess', !error);
                }
                if (error && this.value_) {
                    this.metadataModel_.get([currentEntry], ['size']).then(() => {
                        steps.showError();
                    });
                    return;
                }
                this.metadataModel_.notifyEntriesChanged([currentEntry]);
                this.metadataModel_.get([currentEntry], ['pinned'])
                    .then(steps.updateUI);
            },
            // Update the user interface according to the cache state.
            updateUI: () => {
                // After execution of last entry call "onExecute_" to invalidate the
                // model.
                if (entries.length === 0) {
                    this.onExecute_();
                }
                this.ui_.listContainer.currentView.updateListItemsMetadata('external', [currentEntry]);
                if (!error) {
                    steps.start();
                }
            },
            // Show an error.
            // TODO(crbug.com/40725624): Migrate this error message to a visual signal.
            showError: () => {
                this.ui_.alertDialog.show(strf('OFFLINE_FAILURE_MESSAGE', unescape(currentEntry.name)), undefined, undefined);
            },
        };
        steps.start();
    }
    canExecute() {
        return this.metadataModel_.getCache(this.entries_, ['canPin'])
            .some(metadata => metadata.canPin);
    }
    getTitle() {
        return null;
    }
    getEntries() {
        return this.entries_;
    }
}
class DriveCreateFolderShortcutAction {
    constructor(entry_, shortcutsModel_, onExecute_) {
        this.entry_ = entry_;
        this.shortcutsModel_ = shortcutsModel_;
        this.onExecute_ = onExecute_;
    }
    static create(entries, volumeManager, shortcutsModel, onExecute) {
        if (entries.length !== 1 || !isDirectoryEntry(entries[0])) {
            return null;
        }
        const locationInfo = volumeManager.getLocationInfo(entries[0]);
        if (!locationInfo || locationInfo.isSpecialSearchRoot ||
            locationInfo.isRootEntry) {
            return null;
        }
        return new DriveCreateFolderShortcutAction(entries[0], shortcutsModel, onExecute);
    }
    execute() {
        this.shortcutsModel_.add(this.entry_);
        this.onExecute_();
    }
    canExecute() {
        return !this.shortcutsModel_.exists(this.entry_);
    }
    getTitle() {
        return null;
    }
    getEntries() {
        return [this.entry_];
    }
}
class DriveRemoveFolderShortcutAction {
    constructor(entry_, shortcutsModel_, onExecute_) {
        this.entry_ = entry_;
        this.shortcutsModel_ = shortcutsModel_;
        this.onExecute_ = onExecute_;
    }
    static create(entries, shortcutsModel, onExecute) {
        if (entries.length !== 1 || !isDirectoryEntry(entries[0]) ||
            !shortcutsModel.exists(entries[0])) {
            return null;
        }
        return new DriveRemoveFolderShortcutAction(entries[0], shortcutsModel, onExecute);
    }
    execute() {
        this.shortcutsModel_.remove(this.entry_);
        this.onExecute_();
    }
    canExecute() {
        return this.shortcutsModel_.exists(this.entry_);
    }
    getTitle() {
        return null;
    }
    getEntries() {
        return [this.entry_];
    }
}
/**
 * Opens the entry in Drive Web for the user to manage permissions etc.
 */
class DriveManageAction {
    /**
     * @param entry The entry to open the 'Manage' page for.
     */
    constructor(entry_, volumeManager_) {
        this.entry_ = entry_;
        this.volumeManager_ = volumeManager_;
    }
    /**
     * Creates a new DriveManageAction object.
     * |entries| must contain only a single entry.
     */
    static create(entries, volumeManager) {
        if (entries.length !== 1) {
            return null;
        }
        return new DriveManageAction(entries[0], volumeManager);
    }
    execute() {
        const props = [chrome.fileManagerPrivate.EntryPropertyName.ALTERNATE_URL];
        getEntryProperties([this.entry_], props).then((results) => {
            if (results.length !== 1) {
                console.warn(`getEntryProperties for alternateUrl should return 1 entry ` +
                    `(returned ${results.length})`);
                return;
            }
            if (results[0].alternateUrl === undefined) {
                console.warn('getEntryProperties alternateUrl is undefined');
                return;
            }
            visitURL(results[0].alternateUrl);
        });
    }
    canExecute() {
        return this.volumeManager_.getDriveConnectionState().type !==
            chrome.fileManagerPrivate.DriveConnectionStateType.OFFLINE;
    }
    getTitle() {
        return null;
    }
    getEntries() {
        return [this.entry_];
    }
}
/**
 * A custom action set by the FSP API.
 */
class CustomAction {
    constructor(entries_, id_, title_, onExecute_) {
        this.entries_ = entries_;
        this.id_ = id_;
        this.title_ = title_;
        this.onExecute_ = onExecute_;
    }
    execute() {
        chrome.fileManagerPrivate.executeCustomAction(this.entries_.map(e => unwrapEntry(e)), this.id_, () => {
            if (chrome.runtime.lastError) {
                console.error('Failed to execute a custom action because of: ' +
                    chrome.runtime.lastError.message);
            }
            this.onExecute_();
        });
    }
    canExecute() {
        return true; // Custom actions are always executable.
    }
    getTitle() {
        return this.title_;
    }
    getEntries() {
        return this.entries_;
    }
}
/**
 * Represents a set of actions for a set of entries. Includes actions set
 * locally in JS, as well as those retrieved from the FSP API.
 */
class ActionsModel extends NativeEventTarget {
    constructor(volumeManager_, metadataModel_, shortcutsModel_, ui_, entries_) {
        super();
        this.volumeManager_ = volumeManager_;
        this.metadataModel_ = metadataModel_;
        this.shortcutsModel_ = shortcutsModel_;
        this.ui_ = ui_;
        this.entries_ = entries_;
        this.actions_ = {};
        this.initializePromiseReject_ = null;
        this.initializePromise_ = null;
        this.destroyed_ = false;
    }
    /**
     * Initializes the ActionsModel, including populating the list of available
     * actions for the given entries.
     */
    initialize() {
        if (this.initializePromise_) {
            return this.initializePromise_;
        }
        this.initializePromise_ =
            new Promise((fulfill, reject) => {
                if (this.destroyed_) {
                    reject();
                    return;
                }
                this.initializePromiseReject_ = reject;
                const volumeInfo = this.entries_.length >= 1 &&
                    this.volumeManager_.getVolumeInfo(this.entries_[0]);
                // All entries need to be on the same volume to execute ActionsModel
                // commands.
                if (!volumeInfo ||
                    !isSameVolume(this.entries_, this.volumeManager_)) {
                    fulfill({});
                    return;
                }
                const actions = {};
                switch (volumeInfo.volumeType) {
                    // For Drive, actions are constructed directly in the Files app
                    // code.
                    case VolumeType.DRIVE:
                        const saveForOfflineAction = DriveToggleOfflineAction.create(this.entries_, this.metadataModel_, this.ui_, true, this.invalidate_.bind(this));
                        if (saveForOfflineAction) {
                            actions[CommonActionId.SAVE_FOR_OFFLINE] = saveForOfflineAction;
                        }
                        const offlineNotNecessaryAction = DriveToggleOfflineAction.create(this.entries_, this.metadataModel_, this.ui_, false, this.invalidate_.bind(this));
                        if (offlineNotNecessaryAction) {
                            actions[CommonActionId.OFFLINE_NOT_NECESSARY] =
                                offlineNotNecessaryAction;
                        }
                        const createFolderShortcutAction = DriveCreateFolderShortcutAction.create(this.entries_, this.volumeManager_, this.shortcutsModel_, this.invalidate_.bind(this));
                        if (createFolderShortcutAction) {
                            actions[InternalActionId.CREATE_FOLDER_SHORTCUT] =
                                createFolderShortcutAction;
                        }
                        const removeFolderShortcutAction = DriveRemoveFolderShortcutAction.create(this.entries_, this.shortcutsModel_, this.invalidate_.bind(this));
                        if (removeFolderShortcutAction) {
                            actions[InternalActionId.REMOVE_FOLDER_SHORTCUT] =
                                removeFolderShortcutAction;
                        }
                        const manageInDriveAction = DriveManageAction.create(this.entries_, this.volumeManager_);
                        if (manageInDriveAction) {
                            actions[InternalActionId.MANAGE_IN_DRIVE] = manageInDriveAction;
                        }
                        fulfill(actions);
                        break;
                    // For FSP, fetch custom actions via an API.
                    case VolumeType.PROVIDED:
                        chrome.fileManagerPrivate.getCustomActions(this.entries_.map(e => unwrapEntry(e)), (customActions) => {
                            if (chrome.runtime.lastError) {
                                console.warn('Failed to fetch custom actions because of: ' +
                                    chrome.runtime.lastError.message);
                            }
                            else {
                                customActions.forEach(action => {
                                    // Skip fake actions that should not be displayed to the
                                    // user, for example actions that just expose OneDrive
                                    // URLs.
                                    if (FSP_ACTIONS_HIDDEN.includes(action.id)) {
                                        return;
                                    }
                                    actions[action.id] = new CustomAction(this.entries_, action.id, action.title || null, this.invalidate_.bind(this));
                                });
                            }
                            fulfill(actions);
                        });
                        break;
                    default:
                        fulfill(actions);
                }
            }).then(actions => {
                this.actions_ = actions;
            });
        return this.initializePromise_;
    }
    getActions() {
        return this.actions_;
    }
    getAction(id) {
        return this.actions_[id] || null;
    }
    /**
     * Destroys the model and cancels initialization if in progress.
     */
    destroy() {
        this.destroyed_ = true;
        if (this.initializePromiseReject_ !== null) {
            const reject = this.initializePromiseReject_;
            this.initializePromiseReject_ = null;
            reject();
        }
    }
    /**
     * Invalidates the current actions model by emitting an invalidation event.
     * The model has to be initialized again, as the list of actions might have
     * changed.
     */
    invalidate_() {
        if (this.initializePromiseReject_ !== null) {
            const reject = this.initializePromiseReject_;
            this.initializePromiseReject_ = null;
            this.initializePromise_ = null;
            reject();
        }
        dispatchSimpleEvent(this, 'invalidated', true);
    }
    getEntries() {
        return this.entries_;
    }
}
/**
 * List of common actions, used both internally and externally (custom actions).
 * Keep in sync with file_system_provider.idl.
 */
var CommonActionId;
(function (CommonActionId) {
    CommonActionId["SHARE"] = "SHARE";
    CommonActionId["SAVE_FOR_OFFLINE"] = "SAVE_FOR_OFFLINE";
    CommonActionId["OFFLINE_NOT_NECESSARY"] = "OFFLINE_NOT_NECESSARY";
})(CommonActionId || (CommonActionId = {}));
var InternalActionId;
(function (InternalActionId) {
    InternalActionId["CREATE_FOLDER_SHORTCUT"] = "pin-folder";
    InternalActionId["REMOVE_FOLDER_SHORTCUT"] = "unpin-folder";
    InternalActionId["MANAGE_IN_DRIVE"] = "manage-in-drive";
})(InternalActionId || (InternalActionId = {}));

// Copyright 2012 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * The current selection object.
 */
class FileSelection {
    constructor(indexes, entries, volumeManager) {
        this.indexes = indexes;
        this.entries = entries;
        this.mimeTypes = [];
        this.totalCount = 0;
        this.fileCount = 0;
        this.directoryCount = 0;
        this.anyFilesNotInCache = true;
        this.anyFilesHosted = true;
        this.anyFilesEncrypted = true;
        this.additionalPromise_ = null;
        /**
         * If the current selection has any read-only entry.
         */
        this.hasReadOnlyEntry_ = false;
        this.entries.forEach(entry => {
            if (!entry) {
                return;
            }
            if (entry.isFile) {
                this.fileCount += 1;
            }
            else {
                this.directoryCount += 1;
            }
            this.totalCount++;
            if (!this.hasReadOnlyEntry_ &&
                isReadOnlyForDelete(volumeManager, entry)) {
                this.hasReadOnlyEntry_ = true;
            }
        });
    }
    /**
     * @return True if there is any read-only entry in the current selection.
     */
    hasReadOnlyEntry() {
        return this.hasReadOnlyEntry_;
    }
    computeAdditional(metadataModel) {
        if (!this.additionalPromise_) {
            this.additionalPromise_ =
                metadataModel
                    .get(this.entries, FILE_SELECTION_METADATA_PREFETCH_PROPERTY_NAMES)
                    .then(props => {
                    this.anyFilesNotInCache = props.some(p => {
                        // If no availableOffline property, then assume it's
                        // available.
                        return ('availableOffline' in p) && !p.availableOffline;
                    });
                    this.anyFilesHosted = props.some(p => {
                        return p.hosted;
                    });
                    this.anyFilesEncrypted = props.some((p, i) => {
                        return isEncrypted(this.entries[i], p.contentMimeType);
                    });
                    this.mimeTypes = props.map(value => {
                        return value.contentMimeType || '';
                    });
                    return true;
                });
        }
        return this.additionalPromise_;
    }
}
/**
 * This object encapsulates everything related to current selection.
 */
class FileSelectionHandler extends FilesEventTarget {
    constructor(directoryModel_, listContainer_, metadataModel_, volumeManager_, allowedPaths_) {
        super();
        this.directoryModel_ = directoryModel_;
        this.listContainer_ = listContainer_;
        this.metadataModel_ = metadataModel_;
        this.volumeManager_ = volumeManager_;
        this.allowedPaths_ = allowedPaths_;
        this.selection = new FileSelection([], [], this.volumeManager_);
        this.selectionUpdateTimer_ = 0;
        this.store_ = getStore();
        /**
         * The time, in ms since the epoch, when it is OK to post next throttled
         * selection event. Can be directly compared with Date.now().
         */
        this.nextThrottledEventTime_ = 0;
        // Listens to changes in the selection model to propagate to other parts.
        this.directoryModel_.getFileListSelection().addEventListener('change', this.onFileSelectionChanged.bind(this));
        // Register events to update file selections.
        this.directoryModel_.addEventListener('directory-changed', this.onFileSelectionChanged.bind(this));
    }
    /**
     * Update the UI when the selection model changes.
     */
    onFileSelectionChanged() {
        const indexes = this.listContainer_.selectionModel?.selectedIndexes ?? [];
        const entries = indexes
            .map(index => this.directoryModel_.getFileList().item(index))
            // Filter out undefined for invalid index b/277232289.
            .filter((entry) => !!entry);
        this.selection = new FileSelection(indexes, entries, this.volumeManager_);
        if (this.selectionUpdateTimer_) {
            clearTimeout(this.selectionUpdateTimer_);
            this.selectionUpdateTimer_ = null;
        }
        // The rest of the selection properties are computed via (sometimes lengthy)
        // asynchronous calls. We initiate these calls after a timeout. If the
        // selection is changing quickly we only do this once when it slows down.
        let updateDelay = UPDATE_DELAY;
        const now = Date.now();
        if (now >= this.nextThrottledEventTime_ &&
            indexes.length < NUMBER_OF_ITEMS_HEAVY_TO_COMPUTE) {
            // The previous selection change happened a while ago and there is few
            // selected items, so computation is lightweight. Update the UI with
            // 1 millisecond of delay.
            updateDelay = 1;
        }
        this.updateStore_();
        const selection = this.selection;
        this.selectionUpdateTimer_ = setTimeout(() => {
            this.selectionUpdateTimer_ = null;
            this.updateFileSelectionAsync_(selection);
        }, updateDelay);
        this.dispatchEvent(new CustomEvent(EventType$2.CHANGE));
    }
    /**
     * Calculates async selection stats and updates secondary UI elements.
     *
     * @param selection The selection object.
     */
    updateFileSelectionAsync_(selection) {
        if (this.selection !== selection) {
            return;
        }
        // Calculate all additional and heavy properties.
        selection.computeAdditional(this.metadataModel_).then(() => {
            if (this.selection !== selection) {
                return;
            }
            this.nextThrottledEventTime_ = Date.now() + UPDATE_DELAY;
            this.dispatchEvent(new CustomEvent(EventType$2.CHANGE_THROTTLED));
        });
    }
    /**
     * Sends the current selection to the Store.
     */
    updateStore_() {
        const entries = this.selection.entries;
        this.store_.dispatch(updateSelection({
            selectedKeys: entries.map(e => e.toURL()),
            entries,
        }));
    }
    /**
     * Returns true if all files in the selection files are selectable.
     */
    isAvailable() {
        if (!this.directoryModel_.isOnDrive()) {
            return true;
        }
        return !(this.isOfflineWithUncachedFilesSelected_() ||
            this.isDialogWithHostedFilesSelected_() ||
            this.isDialogWithEncryptedFilesSelected_());
    }
    /**
     * Returns true if we're offline with any selected files absent from the
     * cache.
     */
    isOfflineWithUncachedFilesSelected_() {
        return this.volumeManager_.getDriveConnectionState().type ===
            chrome.fileManagerPrivate.DriveConnectionStateType.OFFLINE &&
            this.selection.anyFilesNotInCache;
    }
    /**
     * Returns true if we're a dialog requiring real files with hosted files
     * selected.
     */
    isDialogWithHostedFilesSelected_() {
        return this.allowedPaths_ !== AllowedPaths.ANY_PATH_OR_URL &&
            this.selection.anyFilesHosted;
    }
    /**
     * Returns true if we're a dialog requiring real files with encrypted files
     * selected.
     */
    isDialogWithEncryptedFilesSelected_() {
        return this.allowedPaths_ !== AllowedPaths.ANY_PATH_OR_URL &&
            this.selection.anyFilesEncrypted;
    }
    /**
     * Returns true if any file/directory in the selection is blocked by DLP
     * policy.
     */
    isDlpBlocked() {
        if (!isDlpEnabled()) {
            return false;
        }
        const selectedIndexes = this.directoryModel_.getFileListSelection().selectedIndexes;
        const selectedEntries = selectedIndexes.map(index => {
            return this.directoryModel_.getFileList().item(index);
        });
        // Check if any of the selected entries are blocked by DLP:
        // a volume/directory in case of file-saveas (managed by the VolumeManager),
        // or a file in case file-open dialogs (stored in the metadata).
        for (const entry of selectedEntries) {
            const volumeInfo = this.volumeManager_.getVolumeInfo(entry);
            if (volumeInfo && this.volumeManager_.isDisabled(volumeInfo.volumeType)) {
                return true;
            }
            const metadata = this.metadataModel_.getCache([entry], ['isRestrictedForDestination'])[0];
            if (metadata && !!metadata.isRestrictedForDestination) {
                return true;
            }
        }
        return false;
    }
}
var EventType$2;
(function (EventType) {
    /**
     * Dispatched every time when selection is changed.
     */
    EventType["CHANGE"] = "change";
    /**
     * Dispatched |UPDATE_DELAY| ms after the selection is changed.
     * If multiple changes are happened during the term, only one CHANGE_THROTTLED
     * event is dispatched.
     */
    EventType["CHANGE_THROTTLED"] = "changethrottled";
})(EventType$2 || (EventType$2 = {}));
/**
 * Delay in milliseconds before recalculating the selection in case the
 * selection is changed fast, or there are many items. Used to avoid freezing
 * the UI.
 */
const UPDATE_DELAY = 200;
/**
 * Number of items in the selection which triggers the update delay. Used to
 * let the Material Design animations complete before performing a heavy task
 * which would cause the UI freezing.
 */
const NUMBER_OF_ITEMS_HEAVY_TO_COMPUTE = 100;

// Copyright 2015 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * Manages actions for the current selection.
 */
class ActionsController {
    constructor(volumeManager_, metadataModel_, shortcutsModel_, selectionHandler_, ui_) {
        this.volumeManager_ = volumeManager_;
        this.metadataModel_ = metadataModel_;
        this.shortcutsModel_ = shortcutsModel_;
        this.selectionHandler_ = selectionHandler_;
        this.ui_ = ui_;
        this.readyModels_ = new Map();
        this.initializingModels_ = new Map();
        /**
         * Id for an UI update, when an async update happens we only send the state
         * to the DOM if the sequence hasn't changed since its start.
         */
        this.updateUiSequence_ = 0;
        // Attach listeners to non-user events which will only update the in-memory
        // ActionsModel.
        this.ui_.directoryTree.addEventListener(XfTree.events.TREE_SELECTION_CHANGED, this.onNavigationListSelectionChanged_.bind(this), true);
        this.selectionHandler_.addEventListener(EventType$2.CHANGE_THROTTLED, this.onSelectionChanged_.bind(this));
        // Attach listeners to events based on user action to show the menu, which
        // updates the DOM.
        contextMenuHandler.addEventListener('show', this.onContextMenuShow_.bind(this));
        this.ui_.selectionMenuButton.addEventListener('menushow', this.onMenuShow_.bind(this));
        this.ui_.gearButton.addEventListener('menushow', this.onMenuShow_.bind(this));
        this.metadataModel_.addEventListener('update', this.onMetadataUpdated_.bind(this));
    }
    getEntriesFor_(element) {
        // Element can be null, eg. when invoking a command via a keyboard shortcut.
        if (!element) {
            return [];
        }
        if (this.ui_.listContainer.element.contains(element) ||
            this.ui_.toolbar.contains(element) ||
            this.ui_.fileContextMenu.contains(element) ||
            document.body === element) {
            return this.selectionHandler_.selection.entries;
        }
        const contextMenuForRootItems = this.ui_.directoryTreeContainer.contextMenuForRootItems;
        const contextMenuForSubitems = this.ui_.directoryTreeContainer.contextMenuForSubitems;
        if (this.ui_.directoryTree.contains(element) ||
            contextMenuForRootItems.contains(element) ||
            contextMenuForSubitems.contains(element)) {
            const entry = 'entry' in element ? element.entry : null;
            if (entry) {
                return [entry];
            }
            // DirectoryTree has the focused item.
            const focusedItem = getFocusedTreeItem(element);
            const focusedEntry = getTreeItemEntry(focusedItem);
            if (focusedEntry) {
                return [focusedEntry];
            }
        }
        return [];
    }
    getEntriesKey_(entries) {
        return entries.map(entry => entry.toURL()).join(';');
    }
    /**
     * Clears data associated with the given `key`.
     */
    clearLocalCache_(key) {
        this.readyModels_.delete(key);
        this.initializingModels_.delete(key);
    }
    updateView_(element) {
        const entries = this.getEntriesFor_(element);
        // Try to update synchronously.
        const actionsModel = this.getInitializedActionsForEntries(entries);
        if (actionsModel) {
            this.ui_.actionsSubmenu.setActionsModel(actionsModel, element);
            return;
        }
        // Asynchronously update the UI, after fetching actions from the backend.
        const sequence = ++this.updateUiSequence_;
        this.getActionsForEntries(entries).then((actionsModel) => {
            // Only update if there wasn't another UI update started while the promise
            // was resolving, which could be for different entries and avoids multiple
            // updates for the same entries.
            if (sequence === this.updateUiSequence_) {
                this.ui_.actionsSubmenu.setActionsModel(actionsModel, element);
            }
        });
    }
    onContextMenuShow_(event) {
        this.updateView_(event.detail.element);
    }
    onMenuShow_(event) {
        this.updateView_(event.target);
    }
    onSelectionChanged_() {
        const entries = this.selectionHandler_.selection.entries;
        if (!entries.length) {
            return;
        }
        // To avoid the menu flickering, make this call to start the caching
        // process. We do not return the result on purpose.
        this.getActionsForEntries(entries);
    }
    onNavigationListSelectionChanged_() {
        const focusedItem = getFocusedTreeItem(this.ui_.directoryTree);
        const entry = focusedItem && 'entry' in focusedItem ? focusedItem.entry : null;
        if (!entry) {
            return;
        }
        // Force to recalculate for the new current directory.
        const fileEntry = entry;
        const key = this.getEntriesKey_([fileEntry]);
        this.clearLocalCache_(key);
        // To avoid the menu flickering, make this call to start the caching
        // process. We do not return the result on purpose.
        this.getActionsForEntries([fileEntry]);
    }
    onMetadataUpdated_(event) {
        if (!event) {
            return;
        }
        const evt = event;
        if (!evt.names.has('pinned')) {
            return;
        }
        const entriesMap = evt.entriesMap;
        for (const key of this.readyModels_.keys()) {
            if (key.split(';').some(url => entriesMap.has(url))) {
                this.readyModels_.delete(key);
            }
        }
        for (const key of this.initializingModels_.keys()) {
            if (key.split(';').some(url => entriesMap.has(url))) {
                this.initializingModels_.delete(key);
            }
        }
    }
    getInitializedActionsForEntries(entries) {
        const key = this.getEntriesKey_(entries);
        return this.readyModels_.get(key) || null;
    }
    getActionsForEntries(entries) {
        const key = this.getEntriesKey_(entries);
        if (!key) {
            return Promise.resolve();
        }
        // If it's still initializing, return the cached promise.
        const promise = this.initializingModels_.get(key);
        if (promise) {
            return promise;
        }
        // If it's already initialized, resolve with the model.
        const readyModel = this.readyModels_.get(key);
        if (readyModel) {
            return Promise.resolve(readyModel);
        }
        const freshModel = new ActionsModel(this.volumeManager_, this.metadataModel_, this.shortcutsModel_, this.ui_, entries);
        freshModel.addEventListener('invalidated', () => {
            this.clearLocalCache_(key);
            this.selectionHandler_.onFileSelectionChanged();
        }, { once: true });
        // Once it's initialized, move to readyModels_ so we don't have to construct
        // and initialized again.
        freshModel.initialize().then(() => {
            this.initializingModels_.delete(key);
            this.readyModels_.set(key, freshModel);
        });
        // Cache in the waiting initialization map.
        this.initializingModels_.set(key, Promise.resolve(freshModel));
        return Promise.resolve(freshModel);
    }
    executeAction(action) {
        const entries = action.getEntries();
        const key = this.getEntriesKey_(entries);
        // Invalidate the model early so new UI has to refresh it.
        this.readyModels_.delete(key);
        action.execute();
    }
}

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * Model for managing a list of Android apps.
 */
class AndroidAppListModel extends NativeEventTarget {
    /**
     * @param showAndroidPickerApps Whether to show picker apps in file
     *     selector.
     * @param includeAllFiles Corresponds to LaunchParam.includeAllFiles
     * @param typeList Corresponds to LaunchParam.typeList
     */
    constructor(showAndroidPickerApps, includeAllFiles, typeList) {
        super();
        this.apps_ = [];
        if (!showAndroidPickerApps) {
            return;
        }
        let extensions = [];
        if (!includeAllFiles) {
            for (const type of typeList) {
                extensions = extensions.concat(type.extensions);
            }
        }
        chrome.fileManagerPrivate.getAndroidPickerApps(extensions, apps => {
            this.apps_ = apps;
            getStore().dispatch(addAndroidApps({ apps }));
            this.dispatchEvent(new CustomEvent('permuted'));
        });
    }
    /**
     * @return Number of picker apps.
     */
    length() {
        return this.apps_.length;
    }
    /**
     * @param index Index of the picker app to be retrieved.
     * @return The value of the |index|-th
     *     picker app.
     */
    item(index) {
        return this.apps_[index];
    }
}

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview Recent date bucket definition and util functions.
 */
/**
 * Given a date and now date, return the date bucket it belongs to.
 */
function getRecentDateBucket(date, now) {
    if (!date) {
        return chrome.fileManagerPrivate.RecentDateBucket.OLDER;
    }
    const startOfToday = new Date(now);
    startOfToday.setHours(0, 0, 0);
    if (date >= startOfToday) {
        return chrome.fileManagerPrivate.RecentDateBucket.TODAY;
    }
    const startOfYesterday = new Date(startOfToday);
    startOfYesterday.setDate(startOfToday.getDate() - 1);
    if (date >= startOfYesterday) {
        return chrome.fileManagerPrivate.RecentDateBucket.YESTERDAY;
    }
    const startOfThisWeek = new Date(startOfToday);
    const localeBasedWeekStart = getLocaleBasedWeekStart();
    const daysDiff = (startOfToday.getDay() - localeBasedWeekStart + 7) % 7;
    startOfThisWeek.setDate(startOfToday.getDate() - daysDiff);
    if (date >= startOfThisWeek) {
        return chrome.fileManagerPrivate.RecentDateBucket.EARLIER_THIS_WEEK;
    }
    const startOfThisMonth = new Date(now.getFullYear(), now.getMonth(), 1);
    if (date >= startOfThisMonth) {
        return chrome.fileManagerPrivate.RecentDateBucket.EARLIER_THIS_MONTH;
    }
    const startOfThisYear = new Date(now.getFullYear(), 0, 1);
    if (date >= startOfThisYear) {
        return chrome.fileManagerPrivate.RecentDateBucket.EARLIER_THIS_YEAR;
    }
    return chrome.fileManagerPrivate.RecentDateBucket.OLDER;
}
function getTranslationKeyForDateBucket(dateBucket) {
    const DATE_BUCKET_TO_TRANSLATION_KEY_MAP = new Map([
        [
            chrome.fileManagerPrivate.RecentDateBucket.TODAY,
            'RECENT_TIME_HEADING_TODAY',
        ],
        [
            chrome.fileManagerPrivate.RecentDateBucket.YESTERDAY,
            'RECENT_TIME_HEADING_YESTERDAY',
        ],
        [
            chrome.fileManagerPrivate.RecentDateBucket.EARLIER_THIS_WEEK,
            'RECENT_TIME_HEADING_THIS_WEEK',
        ],
        [
            chrome.fileManagerPrivate.RecentDateBucket.EARLIER_THIS_MONTH,
            'RECENT_TIME_HEADING_THIS_MONTH',
        ],
        [
            chrome.fileManagerPrivate.RecentDateBucket.EARLIER_THIS_YEAR,
            'RECENT_TIME_HEADING_THIS_YEAR',
        ],
        [
            chrome.fileManagerPrivate.RecentDateBucket.OLDER,
            'RECENT_TIME_HEADING_OLDER',
        ],
    ]);
    return DATE_BUCKET_TO_TRANSLATION_KEY_MAP.get(dateBucket);
}
/**
 * Computes the timestamp based on options. If the options ask for today's
 * results, it uses the time in ms from midnight. For yesterday, it goes back
 * by one day from midnight. For week, it goes back by 6 days from midnight.
 * For a month, it goes back by 30 days since midnight, regardless of how
 * many days are in the current month. For a year, it goes back by 365 days
 * since midnight, regardless if the current year is a leap year or not.
 *
 * @return The earliest timestamp for the given recency option.
 */
function getEarliestTimestamp(recency, now) {
    const midnight = new Date(now.getFullYear(), now.getMonth(), now.getDate());
    const midnightMs = midnight.getTime();
    const dayMs = 24 * 60 * 60 * 1000;
    switch (recency) {
        case SearchRecency.TODAY:
            return midnightMs;
        case SearchRecency.YESTERDAY:
            return midnightMs - 1 * dayMs;
        case SearchRecency.LAST_WEEK:
            return midnightMs - 6 * dayMs;
        case SearchRecency.LAST_MONTH:
            return midnightMs - 30 * dayMs;
        case SearchRecency.LAST_YEAR:
            return midnightMs - 365 * dayMs;
        default:
            return 0;
    }
}

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const GROUP_BY_FIELD_MODIFICATION_TIME = 'modificationTime';
const GROUP_BY_FIELD_DIRECTORY = 'isDirectory';
const FIELDS_SUPPORT_GROUP_BY = new Set([
    GROUP_BY_FIELD_MODIFICATION_TIME,
    GROUP_BY_FIELD_DIRECTORY,
]);
/**
 * File list.
 */
class FileListModel extends ArrayDataModel {
    constructor(metadataModel_) {
        super([]);
        this.metadataModel_ = metadataModel_;
        /**
         * Whether this file list is sorted in descending order.
         */
        this.isDescendingOrder_ = false;
        /**
         * The number of folders in the list.
         */
        this.numFolders_ = 0;
        /**
         * The number of files in the list.
         */
        this.numFiles_ = 0;
        /**
         * The number of image files in the list.
         */
        this.numImageFiles_ = 0;
        /**
         * Whether to use modificationByMeTime as "Last Modified" time.
         */
        this.useModificationByMeTime_ = false;
        /**
         * The volume manager.
         */
        this.volumeManager_ = null;
        /**
         * Used to get the label for entries when
         * sorting by label.
         */
        this.locationInfo_ = null;
        this.hasGroupHeadingBeforeSort = false;
        /**
         * The field to do group by on.
         */
        this.groupByField_ = null;
        /**
         * The key is the field name which is used by groupBy. The value is a
         * object with type GroupBySnapshot.
         *
         */
        this.groupBySnapshot_ = Array.from(FIELDS_SUPPORT_GROUP_BY)
            .reduce((acc, field) => {
            acc[field] = {
                sortDirection: 'asc',
                groups: [],
            };
            return acc;
        }, {});
        // Initialize compare functions.
        this.setCompareFunction('name', this.compareName_.bind(this));
        this.setCompareFunction('modificationTime', this.compareMtime_.bind(this));
        this.setCompareFunction('size', this.compareSize_.bind(this));
        this.setCompareFunction('type', this.compareType_.bind(this));
    }
    /**
     * @param fileType Type object returned by getType().
     * @return Localized string representation of file type.
     */
    static getFileTypeString(fileType) {
        // Partitions on removable volumes are treated separately, they don't
        // have translatable names.
        if (fileType.type === 'partition') {
            return fileType.subtype;
        }
        if (fileType.subtype) {
            return strf(fileType.translationKey, fileType.subtype);
        }
        else {
            return str(fileType.translationKey);
        }
    }
    /**
     * Sorts data model according to given field and direction and dispatches
     * sorted event.
     * @param field Sort field.
     * @param direction Sort direction.
     */
    sort(field, direction) {
        this.hasGroupHeadingBeforeSort = this.shouldShowGroupHeading();
        this.isDescendingOrder_ = direction === 'desc';
        ArrayDataModel.prototype.sort.call(this, field, direction);
    }
    /**
     * Removes and adds items to the model.
     *
     * The implementation is similar to ArrayDataModel.splice(), but this
     * has a Files app specific optimization, which sorts only the new items and
     * merge sorted lists.
     * Note that this implementation assumes that the list is always sorted.
     *
     * @param index The index of the item to update.
     * @param deleteCount The number of items to remove.
     * @param args The items to add.
     * @return An array with the removed items.
     */
    splice(index, deleteCount, ...args) {
        const insertPos = Math.max(0, Math.min(index, this.indexes_.length));
        deleteCount = Math.min(deleteCount, this.indexes_.length - insertPos);
        for (let i = insertPos; i < insertPos + deleteCount; i++) {
            this.onRemoveEntryFromList_(this.array_[this.indexes_[i]]);
        }
        for (const arg of args) {
            this.onAddEntryToList_(arg);
        }
        // Prepare a comparison function to sort the list.
        let comp = null;
        if (this.sortStatus.field && this.compareFunctions_) {
            const compareFunction = this.compareFunctions_[this.sortStatus.field];
            if (compareFunction) {
                const dirMultiplier = this.sortStatus.direction === 'desc' ? -1 : 1;
                comp = (a, b) => {
                    return compareFunction(a, b) * dirMultiplier;
                };
            }
        }
        // Store the given new items in |newItems| and sort it before marge them to
        // the existing list.
        const newItems = [];
        for (const arg of args) {
            newItems.push(arg);
        }
        if (comp) {
            newItems.sort(comp);
        }
        // Creating a list of existing items.
        // This doesn't include items which should be deleted by this splice() call.
        const deletedItems = [];
        const currentItems = [];
        for (let i = 0; i < this.indexes_.length; i++) {
            const item = this.array_[this.indexes_[i]];
            if (insertPos <= i && i < insertPos + deleteCount) {
                deletedItems.push(item);
            }
            else {
                currentItems.push(item);
            }
        }
        // Initialize splice permutation with -1s.
        // Values of undeleted items will be filled in following merge step.
        const permutation = new Array(this.indexes_.length);
        for (let i = 0; i < permutation.length; i++) {
            permutation[i] = -1;
        }
        // Merge the list of existing item and the list of new items.
        this.indexes_ = [];
        this.array_ = [];
        let p = 0;
        let q = 0;
        while (p < currentItems.length || q < newItems.length) {
            const currentIndex = p + q;
            this.indexes_.push(currentIndex);
            // Determine which should be inserted to the resulting list earlier, the
            // smallest item of unused current items or the smallest item of unused
            // new items.
            let shouldPushCurrentItem;
            if (q === newItems.length) {
                shouldPushCurrentItem = true;
            }
            else if (p === currentItems.length) {
                shouldPushCurrentItem = false;
            }
            else {
                if (comp) {
                    shouldPushCurrentItem = comp(currentItems[p], newItems[q]) <= 0;
                }
                else {
                    // If the comparator is not defined, new items should be inserted to
                    // the insertion position. That is, the current items before insertion
                    // position should be pushed to the resulting list earlier.
                    shouldPushCurrentItem = p < insertPos;
                }
            }
            if (shouldPushCurrentItem) {
                this.array_.push(currentItems[p]);
                if (p < insertPos) {
                    permutation[p] = currentIndex;
                }
                else {
                    permutation[p + deleteCount] = currentIndex;
                }
                p++;
            }
            else {
                this.array_.push(newItems[q]);
                q++;
            }
        }
        // Calculate the index property of splice event.
        // If no item is inserted, it is simply the insertion/deletion position.
        // If at least one item is inserted, it should be the resulting index of the
        // item which is inserted first.
        let spliceIndex = insertPos;
        if (args.length > 0) {
            for (let i = 0; i < this.indexes_.length; i++) {
                if (this.array_[this.indexes_[i]] === args[0]) {
                    spliceIndex = i;
                    break;
                }
            }
        }
        // Dispatch permute/splice event.
        this.dispatchPermutedEvent_(permutation);
        // TODO(arv): Maybe unify splice and change events?
        const spliceEvent = new CustomEvent('splice', {
            detail: {
                removed: deletedItems,
                added: args,
                index: spliceIndex,
            },
        });
        this.dispatchEvent(spliceEvent);
        this.updateGroupBySnapshot_();
        return deletedItems;
    }
    /**
     */
    replaceItem(oldItem, newItem) {
        this.onRemoveEntryFromList_(oldItem);
        this.onAddEntryToList_(newItem);
        super.replaceItem(oldItem, newItem);
    }
    /**
     * Returns the number of files in this file list.
     * @return The number of files.
     */
    getFileCount() {
        return this.numFiles_;
    }
    /**
     * Returns the number of folders in this file list.
     * @return The number of folders.
     */
    getFolderCount() {
        return this.numFolders_;
    }
    /**
     * Sets whether to use modificationByMeTime as "Last Modified" time.
     */
    setUseModificationByMeTime(useModificationByMeTime) {
        this.useModificationByMeTime_ = useModificationByMeTime;
    }
    /**
     * Updates the statistics about contents when new entry is about to be added.
     * @param entry Entry of the new item.
     */
    onAddEntryToList_(entry) {
        if (entry.isDirectory) {
            this.numFolders_++;
        }
        else {
            this.numFiles_++;
        }
        const mimeType = this.metadataModel_.getCache([entry], ['contentMimeType'])[0]
            ?.contentMimeType;
        if (isImage(entry, mimeType) || isRaw(entry, mimeType)) {
            this.numImageFiles_++;
        }
    }
    /**
     * Updates the statistics about contents when an entry is about to be removed.
     * @param entry Entry of the item to be removed.
     */
    onRemoveEntryFromList_(entry) {
        if (entry.isDirectory) {
            this.numFolders_--;
        }
        else {
            this.numFiles_--;
        }
        const mimeType = this.metadataModel_.getCache([entry], ['contentMimeType'])[0]
            ?.contentMimeType;
        if (isImage(entry, mimeType) || isRaw(entry, mimeType)) {
            this.numImageFiles_--;
        }
    }
    /**
     * Compares entries by name.
     * @param a First entry.
     * @param b Second entry.
     * @return Compare result.
     */
    compareName_(a, b) {
        // Directories always precede files.
        if (a.isDirectory !== b.isDirectory) {
            return a.isDirectory === this.isDescendingOrder_ ? 1 : -1;
        }
        return compareName(a, b);
    }
    /**
     * Compares entries by label (i18n name).
     * @param a First entry.
     * @param b Second entry.
     * @return Compare result.
     */
    compareLabel_(a, b) {
        // Set locationInfo once because we only compare within the same volume.
        if (!this.locationInfo_ && this.volumeManager_) {
            this.locationInfo_ = this.volumeManager_.getLocationInfo(a);
        }
        // Directories always precede files.
        if (a.isDirectory !== b.isDirectory) {
            return a.isDirectory === this.isDescendingOrder_ ? 1 : -1;
        }
        return compareLabel(this.locationInfo_, a, b);
    }
    /**
     * Compares entries by mtime first, then by name.
     * @param a First entry.
     * @param b Second entry.
     * @return Compare result.
     */
    compareMtime_(a, b) {
        // Directories always precede files.
        if (a.isDirectory !== b.isDirectory) {
            return a.isDirectory === this.isDescendingOrder_ ? 1 : -1;
        }
        const properties = this.metadataModel_.getCache([a, b], ['modificationTime', 'modificationByMeTime']);
        const aTime = this.getMtime_(properties[0]);
        const bTime = this.getMtime_(properties[1]);
        if (aTime > bTime) {
            return 1;
        }
        if (aTime < bTime) {
            return -1;
        }
        return compareName(a, b);
    }
    /**
     * Returns the modification time from a properties object.
     * "Modification time" can be modificationTime or modificationByMeTime
     * depending on this.useModificationByMeTime_.
     * @param properties Properties object.
     * @return Modification time.
     */
    getMtime_(properties) {
        if (this.useModificationByMeTime_) {
            return properties.modificationByMeTime || properties.modificationTime ||
                0;
        }
        return properties.modificationTime || 0;
    }
    /**
     * Compares entries by size first, then by name.
     * @param a First entry.
     * @param b Second entry.
     * @return Compare result.
     */
    compareSize_(a, b) {
        // Directories always precede files.
        if (a.isDirectory !== b.isDirectory) {
            return a.isDirectory === this.isDescendingOrder_ ? 1 : -1;
        }
        const properties = this.metadataModel_.getCache([a, b], ['size']);
        const aSize = properties[0].size || 0;
        const bSize = properties[1].size || 0;
        return aSize !== bSize ? aSize - bSize : compareName(a, b);
    }
    /**
     * Compares entries by type first, then by subtype and then by name.
     * @param a First entry.
     * @param b Second entry.
     * @return Compare result.
     */
    compareType_(a, b) {
        // Directories always precede files.
        if (a.isDirectory !== b.isDirectory) {
            return a.isDirectory === this.isDescendingOrder_ ? 1 : -1;
        }
        const properties = this.metadataModel_.getCache([a, b], ['contentMimeType']);
        const aType = FileListModel.getFileTypeString(getType(a, properties[0].contentMimeType));
        const bType = FileListModel.getFileTypeString(getType(b, properties[1].contentMimeType));
        const result = collator.compare(aType, bType);
        return result !== 0 ? result : compareName(a, b);
    }
    initNewDirContents(volumeManager) {
        this.volumeManager_ = volumeManager;
        // Clear the location info, it's reset by compareLabel_ when needed.
        this.locationInfo_ = null;
        // Initialize compare function based on Labels.
        this.setCompareFunction('name', this.compareLabel_.bind(this));
    }
    get groupByField() {
        return this.groupByField_;
    }
    /**
     * @param field the field to group by.
     */
    set groupByField(field) {
        this.groupByField_ = field;
        if (!field || this.groupBySnapshot_[field]?.groups.length === 0) {
            this.updateGroupBySnapshot_();
        }
    }
    /**
     * Should the current list model show group heading or not.
     */
    shouldShowGroupHeading() {
        if (!this.groupByField_) {
            return false;
        }
        // GroupBy modification time is only valid when the current sort field is
        // modification time.
        if (this.groupByField_ === GROUP_BY_FIELD_MODIFICATION_TIME) {
            return this.sortStatus.field === this.groupByField_;
        }
        return FIELDS_SUPPORT_GROUP_BY.has(this.groupByField_);
    }
    /**
     * @param item Item in the file list model.
     * @param now Timestamp represents now.
     */
    getGroupForModificationTime_(item, now) {
        const properties = this.metadataModel_.getCache([item], ['modificationTime', 'modificationByMeTime']);
        return getRecentDateBucket(new Date(this.getMtime_(properties[0])), new Date(now));
    }
    /**
     * @param item Item in the file list model.
     */
    getGroupForDirectory_(item) {
        return item.isDirectory;
    }
    getGroupLabel_(value) {
        switch (this.groupByField_) {
            case GROUP_BY_FIELD_MODIFICATION_TIME:
                const dateBucket = value;
                return str(getTranslationKeyForDateBucket(dateBucket));
            case GROUP_BY_FIELD_DIRECTORY:
                const isDirectory = value;
                return isDirectory ? str('GRID_VIEW_FOLDERS_TITLE') :
                    str('GRID_VIEW_FILES_TITLE');
            default:
                return '';
        }
    }
    /**
     * Update the GroupBy snapshot by the existing sort field.
     */
    updateGroupBySnapshot_() {
        if (!this.shouldShowGroupHeading()) {
            return;
        }
        assert$1(this.groupByField_);
        const snapshot = this.groupBySnapshot_[this.groupByField_];
        assert$1(snapshot);
        snapshot.sortDirection = this.sortStatus.direction;
        snapshot.groups = [];
        const now = Date.now();
        let prevItemGroup = null;
        for (let i = 0; i < this.length; i++) {
            const item = this.item(i);
            let curItemGroup;
            if (this.groupByField_ === GROUP_BY_FIELD_MODIFICATION_TIME) {
                curItemGroup = this.getGroupForModificationTime_(item, now);
            }
            else if (this.groupByField_ === GROUP_BY_FIELD_DIRECTORY) {
                curItemGroup = this.getGroupForDirectory_(item);
            }
            if (prevItemGroup !== curItemGroup) {
                if (i > 0) {
                    snapshot.groups[snapshot.groups.length - 1].endIndex = i - 1;
                }
                snapshot.groups.push({
                    startIndex: i,
                    endIndex: -1,
                    group: curItemGroup,
                    label: this.getGroupLabel_(curItemGroup),
                });
            }
            prevItemGroup = curItemGroup;
        }
        if (snapshot.groups.length > 0) {
            // The last element is always the end of the last group.
            snapshot.groups[snapshot.groups.length - 1].endIndex = this.length - 1;
        }
    }
    /**
     * Refresh the group by data, e.g. when date modified changes due to
     * timezone change.
     */
    refreshGroupBySnapshot() {
        if (this.groupByField_ === GROUP_BY_FIELD_MODIFICATION_TIME) {
            this.updateGroupBySnapshot_();
        }
    }
    /**
     * Return the groupBy snapshot.
     */
    getGroupBySnapshot() {
        if (!this.shouldShowGroupHeading()) {
            return [];
        }
        assert$1(this.groupByField_);
        const snapshot = this.groupBySnapshot_[this.groupByField_];
        if (this.groupByField_ === GROUP_BY_FIELD_MODIFICATION_TIME) {
            if (this.sortStatus.direction === snapshot.sortDirection) {
                return snapshot.groups;
            }
            // Why are we calculating reverse order data in the snapshot instead
            // of calculating it inside sort() function? It's because redraw can
            // happen before sort() finishes, if we generate reverse order data
            // at the end of sort(), that might be too late for redraw.
            const reversedGroups = Array.from(snapshot.groups);
            reversedGroups.reverse();
            return reversedGroups.map(group => {
                return {
                    startIndex: this.length - 1 - group.endIndex,
                    endIndex: this.length - 1 - group.startIndex,
                    group: group.group,
                    label: group.label,
                };
            });
        }
        // Grid view Folders/Files group order never changes, e.g. Folders group
        // always shows first, and then Files group.
        if (this.groupByField_ === GROUP_BY_FIELD_DIRECTORY) {
            return snapshot.groups;
        }
        return [];
    }
}

// Copyright 2012 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * Creates a new selection model that is to be used with lists.
 *
 */
class ListSelectionModel extends FilesEventTarget {
    /**
     * @param length The number items in the selection.
     */
    constructor(length) {
        super();
        // Using a object/record and rely on the ascending order returned by iterating
        // over its keys with `Object.keys()`.
        this.selectedIndexes_ = {};
        // True if any item could be lead or anchor. False if only selected ones.
        this.independentLeadItem = false;
        this.leadIndex_ = -1;
        this.oldLeadIndex_ = null;
        this.anchorIndex_ = -1;
        this.oldAnchorIndex_ = null;
        this.changeCount_ = null;
        this.changedIndexes_ = null;
        this.length_ = length ?? 0;
    }
    /**
     * The number of items in the model.
     */
    get length() {
        return this.length_;
    }
    /**
     * The selected indexes.
     * Setter also changes lead and anchor indexes if value list is nonempty.
     */
    get selectedIndexes() {
        return Object.keys(this.selectedIndexes_).map(Number);
    }
    set selectedIndexes(selectedIndexes) {
        this.beginChange();
        assert$1(this.changedIndexes_);
        const unselected = {};
        for (const index in this.selectedIndexes_) {
            unselected[index] = true;
        }
        for (let i = 0; i < selectedIndexes.length; i++) {
            const index = selectedIndexes[i];
            if (index in this.selectedIndexes_) {
                delete unselected[index];
            }
            else {
                this.selectedIndexes_[index] = index;
                // Mark the index as changed. If previously marked, then unmark,
                // since it just got reverted to the original state.
                if (index in this.changedIndexes_) {
                    delete this.changedIndexes_[index];
                }
                else {
                    this.changedIndexes_[index] = true;
                }
            }
        }
        for (const i of Object.keys(unselected)) {
            const index = Number(i);
            delete this.selectedIndexes_[index];
            // Mark the index as changed. If previously marked, then unmark,
            // since it just got reverted to the original state.
            if (index in this.changedIndexes_) {
                delete this.changedIndexes_[index];
            }
            else {
                this.changedIndexes_[index] = false;
            }
        }
        if (selectedIndexes.length) {
            this.leadIndex = this.anchorIndex = selectedIndexes[0];
        }
        else {
            this.leadIndex = this.anchorIndex = -1;
        }
        this.endChange();
    }
    /**
     * Convenience getter which returns the first selected index.
     * Setter also changes lead and anchor indexes if value is nonnegative.
     */
    get selectedIndex() {
        for (const i in this.selectedIndexes_) {
            return Number(i);
        }
        return -1;
    }
    set selectedIndex(selectedIndex) {
        this.selectedIndexes = selectedIndex !== -1 ? [selectedIndex] : [];
    }
    /**
     * Returns the nearest selected index or -1 if no item selected.
     * @param index The origin index.
     */
    getNearestSelectedIndex_(index) {
        if (index === -1) {
            // If no index is provided, pick the first selected index if there is
            // one.
            if (this.selectedIndexes.length) {
                return this.selectedIndexes[0];
            }
            return -1;
        }
        let result = Infinity;
        for (const j in this.selectedIndexes_) {
            const i = Number(j);
            if (Math.abs(i - index) < Math.abs(result - index)) {
                result = i;
            }
        }
        return result < this.length ? Number(result) : -1;
    }
    /**
     * Selects a range of indexes, starting with `start` and ends with `end`.
     * @param start The first index to select.
     * @param end The last index to select.
     */
    selectRange(start, end) {
        // Swap if starts comes after end.
        if (start > end) {
            const tmp = start;
            start = end;
            end = tmp;
        }
        this.beginChange();
        for (let index = start; index !== end; index++) {
            this.setIndexSelected(index, true);
        }
        this.setIndexSelected(end, true);
        this.endChange();
    }
    /**
     * Selects all indexes.
     */
    selectAll() {
        if (this.length === 0) {
            return;
        }
        this.selectRange(0, this.length - 1);
    }
    /**
     * Clears the selection
     */
    clear() {
        this.beginChange();
        this.length_ = 0;
        this.anchorIndex = this.leadIndex = -1;
        this.unselectAll();
        this.endChange();
    }
    /**
     * Unselects all selected items.
     */
    unselectAll() {
        this.beginChange();
        for (const i in this.selectedIndexes_) {
            this.setIndexSelected(+i, false);
        }
        this.endChange();
    }
    /**
     * Sets the selected state for an index.
     * @param index The index to set the selected state for.
     * @param b Whether to select the index or not.
     */
    setIndexSelected(index, b) {
        const oldSelected = index in this.selectedIndexes_;
        if (oldSelected === b) {
            return;
        }
        if (b) {
            this.selectedIndexes_[index] = index;
        }
        else {
            delete this.selectedIndexes_[index];
        }
        this.beginChange();
        this.changedIndexes_[index] = b;
        // End change dispatches an event which in turn may update the view.
        this.endChange();
    }
    /**
     * Whether a given index is selected or not.
     * @param index The index to check.
     * @return Whether an index is selected.
     */
    getIndexSelected(index) {
        return index in this.selectedIndexes_;
    }
    /**
     * This is used to begin batching changes. Call {@code endChange} when you
     * are done making changes.
     */
    beginChange() {
        if (!this.changeCount_) {
            this.changeCount_ = 0;
            this.changedIndexes_ = {};
            this.oldLeadIndex_ = this.leadIndex_;
            this.oldAnchorIndex_ = this.anchorIndex_;
        }
        this.changeCount_++;
    }
    /**
     * Call this after changes are done and it will dispatch a change event if
     * any changes were actually done.
     */
    endChange() {
        this.changeCount_--;
        if (!this.changeCount_) {
            // Calls delayed |dispatchPropertyChange|s, only when |leadIndex| or
            // |anchorIndex| has been actually changed in the batch.
            this.leadIndex_ = this.adjustIndex_(this.leadIndex_);
            if (this.leadIndex_ !== this.oldLeadIndex_) {
                dispatchPropertyChange(this, 'leadIndex', this.leadIndex_, this.oldLeadIndex_);
            }
            this.oldLeadIndex_ = null;
            this.anchorIndex_ = this.adjustIndex_(this.anchorIndex_);
            if (this.anchorIndex_ !== this.oldAnchorIndex_) {
                dispatchPropertyChange(this, 'anchorIndex', this.anchorIndex_, this.oldAnchorIndex_);
            }
            this.oldAnchorIndex_ = null;
            const indexes = Object.keys(this.changedIndexes_);
            if (indexes.length) {
                const e = new CustomEvent('change', {
                    detail: {
                        changes: indexes.map((index) => {
                            return {
                                index: Number(index),
                                selected: this.changedIndexes_[Number(index)],
                            };
                        }),
                    },
                });
                this.dispatchEvent(e);
            }
            this.changedIndexes_ = {};
        }
    }
    /**
     * The leadIndex is used with multiple selection and it is the index that
     * the user is moving using the arrow keys.
     */
    get leadIndex() {
        return this.leadIndex_;
    }
    set leadIndex(leadIndex) {
        const oldValue = this.leadIndex_;
        const newValue = this.adjustIndex_(leadIndex);
        this.leadIndex_ = newValue;
        // Delays the call of dispatchPropertyChange if batch is running.
        if (!this.changeCount_ && newValue !== oldValue) {
            dispatchPropertyChange(this, 'leadIndex', newValue, oldValue);
        }
    }
    /**
     * The anchorIndex is used with multiple selection.
     */
    get anchorIndex() {
        return this.anchorIndex_;
    }
    set anchorIndex(anchorIndex) {
        const oldValue = this.anchorIndex_;
        const newValue = this.adjustIndex_(anchorIndex);
        this.anchorIndex_ = newValue;
        // Delays the call of dispatchPropertyChange if batch is running.
        if (!this.changeCount_ && newValue !== oldValue) {
            dispatchPropertyChange(this, 'anchorIndex', newValue, oldValue);
        }
    }
    /**
     * Helper method that adjustes a value before assigning it to leadIndex or
     * anchorIndex.
     * @param index New value for leadIndex or anchorIndex.
     * @return Corrected value.
     */
    adjustIndex_(index) {
        index = Math.max(-1, Math.min(this.length_ - 1, index));
        // On Mac and ChromeOS lead and anchor items are forced to be among
        // selected items. This rule is not enforces until end of batch update.
        if (!this.changeCount_ && !this.independentLeadItem &&
            !this.getIndexSelected(index)) {
            const index2 = this.getNearestSelectedIndex_(index);
            index = index2;
        }
        return index;
    }
    /**
     * Whether the selection model supports multiple selected items.
     */
    get multiple() {
        return true;
    }
    /**
     * Adjusts the selection after reordering of items in the table.
     * @param permutation The reordering permutation.
     */
    adjustToReordering(permutation) {
        this.beginChange();
        const oldLeadIndex = this.leadIndex;
        const oldAnchorIndex = this.anchorIndex;
        const oldSelectedItemsCount = this.selectedIndexes.length;
        this.selectedIndexes = this.selectedIndexes
            .map((oldIndex) => {
            return permutation[oldIndex];
        })
            .filter((index) => {
            return index !== -1;
        });
        // Will be adjusted in endChange.
        if (oldLeadIndex !== -1) {
            this.leadIndex = permutation[oldLeadIndex];
        }
        if (oldAnchorIndex !== -1) {
            this.anchorIndex = permutation[oldAnchorIndex];
        }
        if (oldSelectedItemsCount && !this.selectedIndexes.length && this.length_ &&
            oldLeadIndex !== -1) {
            // All selected items are deleted. We move selection to next item of
            // last selected item, following it to its new position.
            let newSelectedIndex = Math.min(oldLeadIndex, this.length_ - 1);
            for (let i = oldLeadIndex + 1; i < permutation.length; ++i) {
                if (permutation[i] !== -1) {
                    newSelectedIndex = permutation[i];
                    break;
                }
            }
            this.selectedIndexes = [newSelectedIndex];
        }
        this.endChange();
    }
    /**
     * Adjusts selection model length.
     * @param length New selection model length.
     */
    adjustLength(length) {
        this.length_ = length;
    }
}

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class TextSearchState {
    constructor() {
        this.text = '';
        this.date = new Date();
    }
}
/**
 * List container for the file table and the grid view.
 */
class ListContainer {
    /**
     * @param element The container element of the file list.
     * @param table File table.
     * @param grid File grid.
     * @param type The type of the main dialog.
     */
    constructor(element, table, grid, type) {
        this.element = element;
        this.table = table;
        this.grid = grid;
        this.currentListType = ListType.UNINITIALIZED;
        this.dataModel = null;
        this.listThumbnailLoader = null;
        this.selectionModel = null;
        /**
         * Data model which is used as a placefolder in inactive file list. This is
         * set by FileManager.
         */
        this.emptyDataModel = null;
        /**
         * Selection model which is used as a placefolder in inactive file list.
         */
        this.emptySelectionModel_ = new ListSelectionModel();
        this.textSearchState = new TextSearchState();
        /**
         * Whtehter to allow or cancel a context menu event.
         */
        this.allowContextMenuByTouch_ = false;
        /**
         * List container needs to know if the current active directory is Recent
         * or not so it can update groupBy filed accordingly.
         */
        this.isOnRecent = false;
        this.renameInput = document.createElement('input');
        assertInstanceof$1(this.renameInput, HTMLInputElement);
        this.renameInput.className = 'rename entry-name';
        this.spinner =
            queryRequiredElement('files-spinner.loading-indicator', element);
        // Overriding the default role 'list' to 'listbox' for better accessibility
        // on ChromeOS.
        this.table.list.setAttribute('role', 'listbox');
        this.table.list.id = 'file-list';
        this.grid.setAttribute('role', 'listbox');
        this.grid.id = 'file-list';
        // Ensure the list and grid are marked ARIA single select for save as.
        if (type === DialogType.SELECT_SAVEAS_FILE) {
            const list = table.querySelector('#file-list');
            list?.setAttribute('aria-multiselectable', 'false');
            grid.setAttribute('aria-multiselectable', 'false');
        }
    }
    /**
     * Avoid adding event listeners in the constructor because the ListContainer
     * isn't fully usable until setCurrentListType() is called.
     */
    addEventListeners_() {
        this.element.addEventListener('keydown', this.onKeyDown_.bind(this));
        this.element.addEventListener('keypress', this.onKeyPress_.bind(this));
        this.element.addEventListener('contextmenu', this.onContextMenu_.bind(this), /* useCapture */ true);
        // Disables context menu by long-tap when long-tap would transition to
        // multi-select mode, but keep it enabled for two-finger tap.
        this.element.addEventListener('touchstart', (e) => {
            if (e.touches.length > 1 || this.currentList.selectedItem) {
                this.allowContextMenuByTouch_ = true;
            }
        }, { passive: true });
        this.element.addEventListener('touchend', (e) => {
            if (e.touches.length === 0) {
                // contextmenu event will be sent right after touchend.
                setTimeout(() => this.allowContextMenuByTouch_ = false);
            }
        });
    }
    get currentView() {
        switch (this.currentListType) {
            case ListType.DETAIL:
                return this.table;
            case ListType.THUMBNAIL:
                return this.grid;
        }
        assertNotReached$1();
    }
    get currentList() {
        switch (this.currentListType) {
            case ListType.DETAIL:
                return this.table.list;
            case ListType.THUMBNAIL:
                return this.grid;
        }
        assertNotReached$1();
    }
    /**
     * Notifies beginning of batch update to the UI.
     */
    startBatchUpdates() {
        this.table.startBatchUpdates();
        this.grid.startBatchUpdates();
    }
    /**
     * Notifies end of batch update to the UI.
     */
    endBatchUpdates() {
        this.table.endBatchUpdates();
        this.grid.endBatchUpdates();
    }
    /**
     * Sets the current list type.
     * @param listType New list type.
     */
    setCurrentListType(listType) {
        assert$1(this.dataModel);
        assert$1(this.selectionModel);
        this.addEventListeners_();
        this.startBatchUpdates();
        this.currentListType = listType;
        this.element.classList.toggle('list-view', listType === ListType.DETAIL);
        this.element.classList.toggle('thumbnail-view', listType === ListType.THUMBNAIL);
        // TODO(dzvorygin): style.display and dataModel setting order shouldn't
        // cause any UI bugs. Currently, the only right way is first to set display
        // style and only then set dataModel.
        // Always sharing the data model between the detail/thumb views confuses
        // them.  Instead we maintain this bogus data model, and hook it up to the
        // view that is not in use.
        switch (listType) {
            case ListType.DETAIL:
                this.dataModel.groupByField =
                    this.isOnRecent ? GROUP_BY_FIELD_MODIFICATION_TIME : null;
                this.table.dataModel = this.dataModel;
                this.table.setListThumbnailLoader(this.listThumbnailLoader);
                this.table.selectionModel = this.selectionModel;
                this.table.hidden = false;
                this.grid.hidden = true;
                this.grid.selectionModel = this.emptySelectionModel_;
                this.grid.setListThumbnailLoader(null);
                this.grid.dataModel = this.emptyDataModel;
                break;
            case ListType.THUMBNAIL:
                if (this.isOnRecent) {
                    this.dataModel.groupByField = GROUP_BY_FIELD_MODIFICATION_TIME;
                }
                else {
                    this.dataModel.groupByField = GROUP_BY_FIELD_DIRECTORY;
                }
                this.grid.dataModel = this.dataModel;
                this.grid.setListThumbnailLoader(this.listThumbnailLoader);
                this.grid.selectionModel = this.selectionModel;
                this.grid.hidden = false;
                this.table.hidden = true;
                this.table.selectionModel = this.emptySelectionModel_;
                this.table.setListThumbnailLoader(null);
                this.table.dataModel = this.emptyDataModel;
                break;
            default:
                assertNotReached$1();
        }
        this.endBatchUpdates();
    }
    /**
     * Finds list item element from the ancestor node.
     */
    findListItemForNode(node) {
        const item = this.currentList.getListItemAncestor(node);
        return item && this.currentList.isItem(item) ? item : null;
    }
    /**
     * Focuses the active file list in the list container.
     */
    focus() {
        switch (this.currentListType) {
            case ListType.DETAIL:
                this.table.list.focus();
                break;
            case ListType.THUMBNAIL:
                this.grid.focus();
                break;
            default:
                assertNotReached$1();
        }
    }
    /**
     * Contextmenu event handler to prevent change of focus on long-tapping the
     * header of the file list.
     * @param e Menu event.
     */
    onContextMenu_(e) {
        // sourceCapabilities isn't defined in TS, because it's experimental.
        const sourceCapabilities = e.sourceCapabilities;
        // Block context menu triggered by touch event unless either:
        // - It is right after a multi-touch, or
        // - We were already in multi-select mode, or
        // - No items are selected (i.e. long-tap on empty area in the current
        // folder).
        if (this.currentList.selectedItem && !this.allowContextMenuByTouch_ &&
            sourceCapabilities && sourceCapabilities.firesTouchEvents) {
            e.stopPropagation();
            e.preventDefault();
        }
        if (!this.allowContextMenuByTouch_ && sourceCapabilities &&
            sourceCapabilities.firesTouchEvents) {
            this.focus();
        }
    }
    /**
     * KeyDown event handler for the div#list-container element.
     * @param event Key event.
     */
    onKeyDown_(event) {
        // Ignore keydown handler in the rename input box.
        const srcElement = event.srcElement;
        if (srcElement?.tagName === 'INPUT') {
            event.stopImmediatePropagation();
            return;
        }
    }
    /**
     * KeyPress event handler for the div#list-container element.
     * @param event Key event.
     */
    onKeyPress_(event) {
        const srcElement = event.srcElement;
        // Ignore keypress handler in the rename input box.
        if (srcElement?.tagName === 'INPUT' || event.ctrlKey || event.metaKey ||
            event.altKey) {
            event.stopImmediatePropagation();
            return;
        }
        const now = new Date();
        const character = String.fromCharCode(event.charCode).toLowerCase();
        const text = Number(now) - Number(this.textSearchState.date) > 1000 ?
            '' :
            this.textSearchState.text;
        this.textSearchState.text = text + character;
        this.textSearchState.date = now;
        if (this.textSearchState.text) {
            dispatchSimpleEvent(this.element, EventType$1.TEXT_SEARCH);
        }
    }
}
var EventType$1;
(function (EventType) {
    EventType["TEXT_SEARCH"] = "textsearch";
})(EventType$1 || (EventType$1 = {}));
var ListType;
(function (ListType) {
    ListType["UNINITIALIZED"] = "uninitialized";
    ListType["DETAIL"] = "detail";
    ListType["THUMBNAIL"] = "thumb";
})(ListType || (ListType = {}));
/**
 * Keep the order of this in sync with FileManagerListType in
 * tools/metrics/histograms/enums.xml.
 * The array indices will be recorded in UMA as enum values. The index for each
 * root type should never be renumbered nor reused in this array.
 */
const ListTypesForUMA = Object.freeze([
    ListType.UNINITIALIZED,
    ListType.DETAIL,
    ListType.THUMBNAIL,
]);
console.assert(Object.keys(ListType).length === ListTypesForUMA.length, 'Members in ListTypesForUMA do not match those in ListType.');

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class AppStateController {
    constructor(dialogType) {
        this.directoryModel_ = null;
        this.ui_ = null;
        this.viewOptions_ = null;
        /**
         * Preferred sort field of file list. This will be ignored in the Recent
         * folder, since it always uses descendant order of date-modified.
         */
        this.fileListSortField_ = DEFAULT_SORT_FIELD;
        /**
         * Preferred sort direction of file list. This will be ignored in the Recent
         * folder, since it always uses descendant order of date-modified.
         */
        this.fileListSortDirection_ = DEFAULT_SORT_DIRECTION;
        this.viewOptionStorageKey_ = 'file-manager-' + dialogType;
    }
    async loadInitialViewOptions() {
        // Load initial view option.
        try {
            const values = await storage.local.getAsync(this.viewOptionStorageKey_);
            this.viewOptions_ = {};
            const value = values[this.viewOptionStorageKey_];
            if (!value) {
                return;
            }
            // Load the global default options.
            try {
                this.viewOptions_ = JSON.parse(value);
            }
            catch (ignore) {
            }
        }
        catch (error) {
            this.viewOptions_ = {};
            console.warn(error);
        }
    }
    initialize(ui, directoryModel) {
        assert$1(this.viewOptions_);
        this.ui_ = ui;
        this.directoryModel_ = directoryModel;
        const { table } = ui.listContainer;
        // Restore preferences.
        ui.setCurrentListType(this.viewOptions_.listType || ListType.DETAIL);
        if (this.viewOptions_.sortField) {
            this.fileListSortField_ = this.viewOptions_.sortField;
        }
        if (this.viewOptions_.sortDirection) {
            this.fileListSortDirection_ = this.viewOptions_.sortDirection;
        }
        this.directoryModel_.getFileList().sort(this.fileListSortField_, this.fileListSortDirection_);
        if (this.viewOptions_.isAllAndroidFoldersVisible) {
            this.directoryModel_.getFileFilter().setAllAndroidFoldersVisible(true);
        }
        if (this.viewOptions_.columnConfig) {
            table.columnModel
                .restoreColumnConfig(this.viewOptions_.columnConfig);
            // The stored config might not match the current table width, do a
            // normalization here after restoration.
            table.columnModel.normalizeWidths(table.clientWidth);
        }
        // Register event listeners.
        table.addEventListener('column-resize-end', this.saveViewOptions.bind(this));
        directoryModel.getFileList().addEventListener('sorted', this.onFileListSorted_.bind(this));
        directoryModel.getFileFilter().addEventListener('changed', this.onFileFilterChanged_.bind(this));
        directoryModel.addEventListener('directory-changed', this.onDirectoryChanged_.bind(this));
    }
    /**
     * Saves current view option.
     */
    async saveViewOptions() {
        const prefs = {
            sortField: this.fileListSortField_,
            sortDirection: this.fileListSortDirection_,
            columnConfig: {},
            listType: this.ui_?.listContainer.currentListType,
            isAllAndroidFoldersVisible: this.directoryModel_?.getFileFilter().isAllAndroidFoldersVisible(),
        };
        assert$1(this.ui_);
        const cm = this.ui_.listContainer.table.columnModel;
        prefs.columnConfig = cm.exportColumnConfig();
        // Save the global default.
        const items = {};
        items[this.viewOptionStorageKey_] = JSON.stringify(prefs);
        storage.local.setAsync(items);
    }
    async onFileListSorted_() {
        assert$1(this.directoryModel_);
        const currentDirectory = this.directoryModel_.getCurrentDirEntry();
        if (!currentDirectory) {
            return;
        }
        // Update preferred sort field and direction only when the current directory
        // is not Recent folder.
        if (!isRecentRoot(currentDirectory)) {
            const currentSortStatus = this.directoryModel_.getFileList().sortStatus;
            this.fileListSortField_ = currentSortStatus.field;
            this.fileListSortDirection_ = currentSortStatus.direction;
        }
        this.saveViewOptions();
    }
    async onFileFilterChanged_() {
        assert$1(this.directoryModel_);
        const isAllAndroidFoldersVisible = this.directoryModel_.getFileFilter().isAllAndroidFoldersVisible();
        if (this.viewOptions_.isAllAndroidFoldersVisible !==
            isAllAndroidFoldersVisible) {
            this.viewOptions_.isAllAndroidFoldersVisible = isAllAndroidFoldersVisible;
            this.saveViewOptions();
        }
    }
    onDirectoryChanged_(event) {
        assert$1(this.directoryModel_);
        assert$1(this.ui_);
        // Sort the file list by:
        // 1) 'date-modified' and 'desc' order on Recent folder.
        // 2) preferred field and direction on other folders.
        const fileData = this.directoryModel_.getCurrentFileData();
        if (!fileData) {
            return;
        }
        const isOnRecent = isRecentFileData(fileData);
        const fileListModel = this.directoryModel_.getFileList();
        this.ui_.listContainer.isOnRecent = isOnRecent;
        // TODO(b/354587005): Capture all recent categories in the store.
        // Currently only fake-entry://recent/all is in the store, but
        // `previousFileKey` can be other categories like fake-entry://recent/images
        // which is not in the store, we can't rely on store data to fetch the entry
        // by the file key here, hence matching the file key string directly here.
        const wasOnRecentBefore = event.detail.previousFileKey?.startsWith('fake-entry://recent/');
        if (isOnRecent !== wasOnRecentBefore) {
            if (isOnRecent) {
                fileListModel.groupByField = GROUP_BY_FIELD_MODIFICATION_TIME;
                fileListModel.sort(DEFAULT_SORT_FIELD, DEFAULT_SORT_DIRECTION);
            }
            else {
                const isGridView = this.ui_?.listContainer.currentListType === ListType.THUMBNAIL;
                fileListModel.groupByField =
                    isGridView ? GROUP_BY_FIELD_DIRECTORY : null;
                fileListModel.sort(this.fileListSortField_, this.fileListSortDirection_);
            }
        }
    }
}
/**
 * Default sort field of the file list.
 */
const DEFAULT_SORT_FIELD = 'modificationTime';
/**
 * Default sort direction of the file list.
 */
const DEFAULT_SORT_DIRECTION = 'desc';

function getTemplate$m() {
    return getTrustedHTML `<!--_html_template_start_--><state-banner>
  <span slot="text"></span>
</state-banner>
<!--_html_template_end_-->`;
}

function getTemplate$l() {
    return getTrustedHTML `<!--_html_template_start_--><style>
  :host {
    width: 100%;
  }

  .state-banner {
    display: flex;
    flex-direction: row;
    flex-wrap: wrap;
    min-height: 32px;
    width: 100%;
  }

  #state-text-group {
    align-items: center;
    display: flex;
    flex-direction: row;
    flex-wrap: nowrap;
  }

  .state-icon-holder {
    align-items: center;
    background-color: var(--icon-holder-bg, var(--cros-sys-surface_variant));
    border-radius: 16px;
    display: flex;
    height: 32px;
    justify-content: center;
    margin-inline-end: 20px;
    margin-inline-start: 16px;
    width: 32px;
  }

  .state-icon {
    -webkit-mask-image: var(--icon-src,
        url(/foreground/images/files/ui/state_banner_icon.svg));
    -webkit-mask-position: center;
    -webkit-mask-repeat: no-repeat;
    background-color: var(--icon-bg, var(--cros-sys-on_surface_variant));
    flex: none;
    height: 20px;
    width: 20px;
  }

  .state-message {
    color: var(--cros-sys-on_surface);
    font: var(--cros-body-2-font);
  }

  .button-group {
    align-items: center;
    display: flex;
    flex: 0 0 auto;
    height: 32px;
    margin-inline-start: auto;
    padding-inline-start: 32px;
  }

  ::slotted(cr-button) {
    --active-bg: none;
    --hover-bg-color: var(--cros-sys-hover_on_subtle);
    --ink-color: var(--cros-sys-ripple_neutral_on_subtle);
    --paper-ripple-opacity: 100%;
    --text-color: var(--cros-sys-primary);
    border: none;
    border-radius: 18px;
    box-shadow: none;
    font: var(--cros-button-2-font);
    height: 36px;
    margin-inline: 4px;
    padding-inline: 16px;
    position: relative;
  }

  :host-context(.focus-outline-visible) ::slotted(cr-button:focus) {
    outline: 2px solid var(--cros-sys-focus_ring);
    outline-offset: 2px;
  }
</style>
<div class="state-banner">
  <div id="state-text-group">
    <div class="state-icon-holder">
      <div class="state-icon"></div>
    </div>
    <div class="state-message">
      <slot name="text"></slot>
    </div>
  </div>
  <div class="button-group">
    <slot name="extra-button"></slot>
  </div>
</div>
<!--_html_template_end_-->`;
}

// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * Events dispatched by concrete banners.
 */
var BannerEvent;
(function (BannerEvent) {
    BannerEvent["BANNER_DISMISSED"] = "banner-dismissed";
    BannerEvent["BANNER_DISMISSED_FOREVER"] = "banner-dismissed-forever";
})(BannerEvent || (BannerEvent = {}));
/**
 * Event source for BANNER_DISMISSED_FOREVER event.
 */
var DismissedForeverEventSource;
(function (DismissedForeverEventSource) {
    DismissedForeverEventSource["EXTRA_BUTTON"] = "extra-button";
    DismissedForeverEventSource["DEFAULT_DISMISS_BUTTON"] = "default-dismiss-button";
    DismissedForeverEventSource["OVERRIDEN_DISMISS_BUTTON"] = "overriden-dismiss-button";
})(DismissedForeverEventSource || (DismissedForeverEventSource = {}));
/**
 * Helper const to define infinite time showing.
 */
const BANNER_INFINITE_TIME = 0;
class Banner extends HTMLElement {
}

// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * State banner is a type of banner that indicates the Files app has reached a
 * certain state, e.g. the current folder is shared with Linux.
 *
 * To implement an StateBanner, extend from this banner and override the
 * allowedVolumes method to define the VolumeType you want the banner to be
 * shown on. All other configuration elements are optional and can be found
 * documented on the Banner externs.
 *
 * For example the following banner will show when a user navigates to the
 * Downloads volume type:
 *
 *    class ConcreteStateBanner extends StateBanner {
 *      allowedVolumes() {
 *        return [{type: VolumeType.DOWNLOADS}];
 *      }
 *    }
 *
 * Create a HTML template with the same file name as the banner and override
 * the text using slots with the content that you want:
 *
 *    <state-banner>
 *      <span slot="text">Main banner text</span>
 *      <cr-button slot="extra-button" href="{{url_to_navigate}}">
 *        Extra button text
 *      </cr-button>
 *    </state-banner>
 */
class StateBanner extends Banner {
    constructor() {
        super();
        const fragment = this.getTemplate();
        this.attachShadow({ mode: 'open' }).appendChild(fragment);
    }
    /**
     * Returns the HTML template for the State Banner.
     */
    getTemplate() {
        const template = document.createElement('template');
        template.innerHTML = getTemplate$l();
        const fragment = template.content.cloneNode(true);
        return fragment;
    }
    /**
     * Called when the web component is connected to the DOM. This will be called
     * for both the inner state-banner component and the concrete
     * implementations that extend from it.
     */
    connectedCallback() {
        // Attach an onclick handler to the extra-button slot. This enables a new
        // element to leverage the href tag on the element to have a URL opened.
        // TODO(crbug.com/40189485): Add UMA trigger to capture number of extra
        // button clicks.
        const extraButton = this.querySelector('[slot="extra-button"]');
        if (extraButton) {
            extraButton.addEventListener('click', (e) => {
                const href = extraButton.getAttribute('href');
                const chromeOsSettingsSubpage = href && href.replace('chrome://os-settings/', '');
                if (chromeOsSettingsSubpage && chromeOsSettingsSubpage !== href) {
                    chrome.fileManagerPrivate.openSettingsSubpage(chromeOsSettingsSubpage);
                    e.preventDefault();
                    return;
                }
                const commandName = extraButton.getAttribute('command');
                if (commandName) {
                    const command = assertInstanceof(document.querySelector(commandName), Command);
                    // Unit tests don't enclose a StateBanner inside a concrete banner,
                    // so we want to ensure the event is appropriately dispatched from the
                    // outer scope otherwise it won't bubble up to the commands.
                    let bannerInstance = this;
                    const parentBanner = this.getRootNode() && this.getRootNode().host;
                    if (parentBanner && parentBanner instanceof StateBanner) {
                        bannerInstance = parentBanner;
                    }
                    command.execute(bannerInstance);
                    e.preventDefault();
                    return;
                }
                visitURL(extraButton.getAttribute('href'));
                e.preventDefault();
            });
        }
    }
    /**
     * All banners that inherit this class should override with their own
     * volume types to allow. Setting this explicitly as an empty array ensures
     * banners that don't override this are not shown by default.
     */
    allowedVolumes() {
        return [];
    }
}
customElements.define('state-banner', StateBanner);

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * The custom element tag name.
 */
const TAG_NAME$h = 'dlp-restricted-banner';
/**
 * A banner that shows that some of the files or folders in the current
 * directory are restricted by Data Leak Prevention (DLP).
 */
class DlpRestrictedBanner extends StateBanner {
    /**
     * Returns the HTML template for this banner.
     */
    getTemplate() {
        const template = document.createElement('template');
        template.innerHTML = getTemplate$m();
        const fragment = template.content.cloneNode(true);
        return fragment;
    }
    /**
     * This banner relies on a custom trigger registered in the BannerController.
     * It is shown in SELECT_OPEN_FILE and SELECT_OPEN_MULTI_FILE dialog types
     * when some files are restricted by DLP, and in SELECT_SAVEAS_FILE dialog
     * when some destinations are restricted. Regardless of the dialog type, the
     * user can navigate to different roots so the banner can be shown in any of
     * them.
     */
    allowedVolumes() {
        return Object.values(RootType).map(x => ({ root: x }));
    }
    /**
     * Persist the banner at all times if the folder is shared.
     */
    timeLimit() {
        return BANNER_INFINITE_TIME;
    }
    /**
     * When the custom filter shows this banner in the controller, it passes the
     * context to the banner. The type, which is either File Picker or File Saver,
     * determines the text used in the banner.
     */
    onFilteredContext(context) {
        if (!context || context.type === null) {
            console.warn('Context not supplied or dialog type key missing.');
            return;
        }
        const text = this.shadowRoot.querySelector('span[slot="text"]');
        switch (context.type) {
            case DialogType.SELECT_OPEN_FILE:
            case DialogType.SELECT_OPEN_MULTI_FILE:
                text.innerText = str('DLP_FILE_PICKER_BANNER');
                return;
            case DialogType.SELECT_SAVEAS_FILE:
                text.innerText = str('DLP_FILE_SAVER_BANNER');
                return;
            default:
                console.warn(`The DLP banner should not be shown for ${context.type}.`);
                return;
        }
    }
}
customElements.define(TAG_NAME$h, DlpRestrictedBanner);

function getTemplate$k() {
    return getTrustedHTML `<!--_html_template_start_--><style>
  educational-banner {
    --feature-icon-src: url(/foreground/images/files/ui/drive_bulk_pinning.svg);
    --buttons-direction: row-reverse;
  }

  /* action-button's hover effect is handled by hoverBackground. */
  cr-button.action-button:hover::part(hoverBackground) {
    background-color: var(--cros-sys-hover_on_prominent);
    display: block;
  }
</style>
<educational-banner role="banner" class="tast-bulk-pinning-banner">
  <span slot="title">$i18n{BULK_PINNING_TITLE}</span>
  <cr-button slot="extra-button" class="action-button">
    $i18n{BULK_PINNING_GET_STARTED}
  </cr-button>
</educational-banner>
<!--_html_template_end_-->`;
}

/**
 * @license
 * Copyright 2022 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
/**
 * A component for elevation.
 */
class Elevation extends LitElement {
    connectedCallback() {
        super.connectedCallback();
        // Needed for VoiceOver, which will create a "group" if the element is a
        // sibling to other content.
        this.setAttribute('aria-hidden', 'true');
    }
    render() {
        return html `<span class="shadow"></span>`;
    }
}

/**
 * @license
 * Copyright 2024 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
// Generated stylesheet for ./elevation/internal/elevation-styles.css.
const styles$4 = css `:host,.shadow,.shadow::before,.shadow::after{border-radius:inherit;inset:0;position:absolute;transition-duration:inherit;transition-property:inherit;transition-timing-function:inherit}:host{display:flex;pointer-events:none;transition-property:box-shadow,opacity}.shadow::before,.shadow::after{content:"";transition-property:box-shadow,opacity;--_level: var(--md-elevation-level, 0);--_shadow-color: var(--md-elevation-shadow-color, var(--md-sys-color-shadow, #000))}.shadow::before{box-shadow:0px calc(1px*(clamp(0,var(--_level),1) + clamp(0,var(--_level) - 3,1) + 2*clamp(0,var(--_level) - 4,1))) calc(1px*(2*clamp(0,var(--_level),1) + clamp(0,var(--_level) - 2,1) + clamp(0,var(--_level) - 4,1))) 0px var(--_shadow-color);opacity:.3}.shadow::after{box-shadow:0px calc(1px*(clamp(0,var(--_level),1) + clamp(0,var(--_level) - 1,1) + 2*clamp(0,var(--_level) - 2,3))) calc(1px*(3*clamp(0,var(--_level),2) + 2*clamp(0,var(--_level) - 2,3))) calc(1px*(clamp(0,var(--_level),4) + 2*clamp(0,var(--_level) - 4,1))) var(--_shadow-color);opacity:.15}
`;

/**
 * @license
 * Copyright 2022 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
/**
 * The `<md-elevation>` custom element with default styles.
 *
 * Elevation is the relative distance between two surfaces along the z-axis.
 *
 * @final
 * @suppress {visibility}
 */
let MdElevation = class MdElevation extends Elevation {
};
MdElevation.styles = [styles$4];
MdElevation = __decorate$1([
    customElement('md-elevation')
], MdElevation);

/**
 * @license
 * Copyright 2023 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
/**
 * Sets up an element's constructor to enable form submission. The element
 * instance should be form associated and have a `type` property.
 *
 * A click listener is added to each element instance. If the click is not
 * default prevented, it will submit the element's form, if any.
 *
 * @example
 * ```ts
 * class MyElement extends mixinElementInternals(LitElement) {
 *   static {
 *     setupFormSubmitter(MyElement);
 *   }
 *
 *   static formAssociated = true;
 *
 *   type: FormSubmitterType = 'submit';
 * }
 * ```
 *
 * @param ctor The form submitter element's constructor.
 */
function setupFormSubmitter(ctor) {
    if (isServer) {
        return;
    }
    ctor.addInitializer((instance) => {
        const submitter = instance;
        submitter.addEventListener('click', async (event) => {
            const { type, [internals]: elementInternals } = submitter;
            const { form } = elementInternals;
            if (!form || type === 'button') {
                return;
            }
            // Wait a full task for event bubbling to complete.
            await new Promise((resolve) => {
                setTimeout(resolve);
            });
            if (event.defaultPrevented) {
                return;
            }
            if (type === 'reset') {
                form.reset();
                return;
            }
            // form.requestSubmit(submitter) does not work with form associated custom
            // elements. This patches the dispatched submit event to add the correct
            // `submitter`.
            // See https://github.com/WICG/webcomponents/issues/814
            form.addEventListener('submit', (submitEvent) => {
                Object.defineProperty(submitEvent, 'submitter', {
                    configurable: true,
                    enumerable: true,
                    get: () => submitter,
                });
            }, { capture: true, once: true });
            elementInternals.setFormValue(submitter.value);
            form.requestSubmit();
        });
    });
}

/**
 * @license
 * Copyright 2019 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
// Separate variable needed for closure.
const buttonBaseClass = mixinDelegatesAria(mixinElementInternals(LitElement));
/**
 * A button component.
 */
let Button$1 = class Button extends buttonBaseClass {
    get name() {
        return this.getAttribute('name') ?? '';
    }
    set name(name) {
        this.setAttribute('name', name);
    }
    /**
     * The associated form element with which this element's value will submit.
     */
    get form() {
        return this[internals].form;
    }
    constructor() {
        super();
        /**
         * Whether or not the button is disabled.
         */
        this.disabled = false;
        /**
         * Whether or not the button is "soft-disabled" (disabled but still
         * focusable).
         *
         * Use this when a button needs increased visibility when disabled. See
         * https://www.w3.org/WAI/ARIA/apg/practices/keyboard-interface/#kbd_disabled_controls
         * for more guidance on when this is needed.
         */
        this.softDisabled = false;
        /**
         * The URL that the link button points to.
         */
        this.href = '';
        /**
         * The filename to use when downloading the linked resource.
         * If not specified, the browser will determine a filename.
         * This is only applicable when the button is used as a link (`href` is set).
         */
        this.download = '';
        /**
         * Where to display the linked `href` URL for a link button. Common options
         * include `_blank` to open in a new tab.
         */
        this.target = '';
        /**
         * Whether to render the icon at the inline end of the label rather than the
         * inline start.
         *
         * _Note:_ Link buttons cannot have trailing icons.
         */
        this.trailingIcon = false;
        /**
         * Whether to display the icon or not.
         */
        this.hasIcon = false;
        /**
         * The default behavior of the button. May be "button", "reset", or "submit"
         * (default).
         */
        this.type = 'submit';
        /**
         * The value added to a form with the button's name when the button submits a
         * form.
         */
        this.value = '';
        if (!isServer) {
            this.addEventListener('click', this.handleClick.bind(this));
        }
    }
    focus() {
        this.buttonElement?.focus();
    }
    blur() {
        this.buttonElement?.blur();
    }
    render() {
        // Link buttons may not be disabled
        const isRippleDisabled = !this.href && (this.disabled || this.softDisabled);
        const buttonOrLink = this.href ? this.renderLink() : this.renderButton();
        // TODO(b/310046938): due to a limitation in focus ring/ripple, we can't use
        // the same ID for different elements, so we change the ID instead.
        const buttonId = this.href ? 'link' : 'button';
        return html `
      ${this.renderElevationOrOutline?.()}
      <div class="background"></div>
      <md-focus-ring part="focus-ring" for=${buttonId}></md-focus-ring>
      <md-ripple
        part="ripple"
        for=${buttonId}
        ?disabled="${isRippleDisabled}"></md-ripple>
      ${buttonOrLink}
    `;
    }
    renderButton() {
        // Needed for closure conformance
        const { ariaLabel, ariaHasPopup, ariaExpanded } = this;
        return html `<button
      id="button"
      class="button"
      ?disabled=${this.disabled}
      aria-disabled=${this.softDisabled || nothing}
      aria-label="${ariaLabel || nothing}"
      aria-haspopup="${ariaHasPopup || nothing}"
      aria-expanded="${ariaExpanded || nothing}">
      ${this.renderContent()}
    </button>`;
    }
    renderLink() {
        // Needed for closure conformance
        const { ariaLabel, ariaHasPopup, ariaExpanded } = this;
        return html `<a
      id="link"
      class="button"
      aria-label="${ariaLabel || nothing}"
      aria-haspopup="${ariaHasPopup || nothing}"
      aria-expanded="${ariaExpanded || nothing}"
      href=${this.href}
      download=${this.download || nothing}
      target=${this.target || nothing}
      >${this.renderContent()}
    </a>`;
    }
    renderContent() {
        const icon = html `<slot
      name="icon"
      @slotchange="${this.handleSlotChange}"></slot>`;
        return html `
      <span class="touch"></span>
      ${this.trailingIcon ? nothing : icon}
      <span class="label"><slot></slot></span>
      ${this.trailingIcon ? icon : nothing}
    `;
    }
    handleClick(event) {
        // If the button is soft-disabled, we need to explicitly prevent the click
        // from propagating to other event listeners as well as prevent the default
        // action.
        if (!this.href && this.softDisabled) {
            event.stopImmediatePropagation();
            event.preventDefault();
            return;
        }
        if (!isActivationClick(event) || !this.buttonElement) {
            return;
        }
        this.focus();
        dispatchActivationClick(this.buttonElement);
    }
    handleSlotChange() {
        this.hasIcon = this.assignedIcons.length > 0;
    }
};
(() => {
    setupFormSubmitter(Button$1);
})();
/** @nocollapse */
Button$1.formAssociated = true;
/** @nocollapse */
Button$1.shadowRootOptions = {
    mode: 'open',
    delegatesFocus: true,
};
__decorate$1([
    property({ type: Boolean, reflect: true })
], Button$1.prototype, "disabled", void 0);
__decorate$1([
    property({ type: Boolean, attribute: 'soft-disabled', reflect: true })
], Button$1.prototype, "softDisabled", void 0);
__decorate$1([
    property()
], Button$1.prototype, "href", void 0);
__decorate$1([
    property()
], Button$1.prototype, "download", void 0);
__decorate$1([
    property()
], Button$1.prototype, "target", void 0);
__decorate$1([
    property({ type: Boolean, attribute: 'trailing-icon', reflect: true })
], Button$1.prototype, "trailingIcon", void 0);
__decorate$1([
    property({ type: Boolean, attribute: 'has-icon', reflect: true })
], Button$1.prototype, "hasIcon", void 0);
__decorate$1([
    property()
], Button$1.prototype, "type", void 0);
__decorate$1([
    property({ reflect: true })
], Button$1.prototype, "value", void 0);
__decorate$1([
    query('.button')
], Button$1.prototype, "buttonElement", void 0);
__decorate$1([
    queryAssignedElements({ slot: 'icon', flatten: true })
], Button$1.prototype, "assignedIcons", void 0);

/**
 * @license
 * Copyright 2021 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
/**
 * A filled button component.
 */
class FilledButton extends Button$1 {
    renderElevationOrOutline() {
        return html `<md-elevation part="elevation"></md-elevation>`;
    }
}

/**
 * @license
 * Copyright 2024 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
// Generated stylesheet for ./button/internal/filled-styles.css.
const styles$3 = css `:host{--_container-color: var(--md-filled-button-container-color, var(--md-sys-color-primary, #6750a4));--_container-elevation: var(--md-filled-button-container-elevation, 0);--_container-height: var(--md-filled-button-container-height, 40px);--_container-shadow-color: var(--md-filled-button-container-shadow-color, var(--md-sys-color-shadow, #000));--_disabled-container-color: var(--md-filled-button-disabled-container-color, var(--md-sys-color-on-surface, #1d1b20));--_disabled-container-elevation: var(--md-filled-button-disabled-container-elevation, 0);--_disabled-container-opacity: var(--md-filled-button-disabled-container-opacity, 0.12);--_disabled-label-text-color: var(--md-filled-button-disabled-label-text-color, var(--md-sys-color-on-surface, #1d1b20));--_disabled-label-text-opacity: var(--md-filled-button-disabled-label-text-opacity, 0.38);--_focus-container-elevation: var(--md-filled-button-focus-container-elevation, 0);--_focus-label-text-color: var(--md-filled-button-focus-label-text-color, var(--md-sys-color-on-primary, #fff));--_hover-container-elevation: var(--md-filled-button-hover-container-elevation, 1);--_hover-label-text-color: var(--md-filled-button-hover-label-text-color, var(--md-sys-color-on-primary, #fff));--_hover-state-layer-color: var(--md-filled-button-hover-state-layer-color, var(--md-sys-color-on-primary, #fff));--_hover-state-layer-opacity: var(--md-filled-button-hover-state-layer-opacity, 0.08);--_label-text-color: var(--md-filled-button-label-text-color, var(--md-sys-color-on-primary, #fff));--_label-text-font: var(--md-filled-button-label-text-font, var(--md-sys-typescale-label-large-font, var(--md-ref-typeface-plain, Roboto)));--_label-text-line-height: var(--md-filled-button-label-text-line-height, var(--md-sys-typescale-label-large-line-height, 1.25rem));--_label-text-size: var(--md-filled-button-label-text-size, var(--md-sys-typescale-label-large-size, 0.875rem));--_label-text-weight: var(--md-filled-button-label-text-weight, var(--md-sys-typescale-label-large-weight, var(--md-ref-typeface-weight-medium, 500)));--_pressed-container-elevation: var(--md-filled-button-pressed-container-elevation, 0);--_pressed-label-text-color: var(--md-filled-button-pressed-label-text-color, var(--md-sys-color-on-primary, #fff));--_pressed-state-layer-color: var(--md-filled-button-pressed-state-layer-color, var(--md-sys-color-on-primary, #fff));--_pressed-state-layer-opacity: var(--md-filled-button-pressed-state-layer-opacity, 0.12);--_disabled-icon-color: var(--md-filled-button-disabled-icon-color, var(--md-sys-color-on-surface, #1d1b20));--_disabled-icon-opacity: var(--md-filled-button-disabled-icon-opacity, 0.38);--_focus-icon-color: var(--md-filled-button-focus-icon-color, var(--md-sys-color-on-primary, #fff));--_hover-icon-color: var(--md-filled-button-hover-icon-color, var(--md-sys-color-on-primary, #fff));--_icon-color: var(--md-filled-button-icon-color, var(--md-sys-color-on-primary, #fff));--_icon-size: var(--md-filled-button-icon-size, 18px);--_pressed-icon-color: var(--md-filled-button-pressed-icon-color, var(--md-sys-color-on-primary, #fff));--_container-shape-start-start: var(--md-filled-button-container-shape-start-start, var(--md-filled-button-container-shape, var(--md-sys-shape-corner-full, 9999px)));--_container-shape-start-end: var(--md-filled-button-container-shape-start-end, var(--md-filled-button-container-shape, var(--md-sys-shape-corner-full, 9999px)));--_container-shape-end-end: var(--md-filled-button-container-shape-end-end, var(--md-filled-button-container-shape, var(--md-sys-shape-corner-full, 9999px)));--_container-shape-end-start: var(--md-filled-button-container-shape-end-start, var(--md-filled-button-container-shape, var(--md-sys-shape-corner-full, 9999px)));--_leading-space: var(--md-filled-button-leading-space, 24px);--_trailing-space: var(--md-filled-button-trailing-space, 24px);--_with-leading-icon-leading-space: var(--md-filled-button-with-leading-icon-leading-space, 16px);--_with-leading-icon-trailing-space: var(--md-filled-button-with-leading-icon-trailing-space, 24px);--_with-trailing-icon-leading-space: var(--md-filled-button-with-trailing-icon-leading-space, 24px);--_with-trailing-icon-trailing-space: var(--md-filled-button-with-trailing-icon-trailing-space, 16px)}
`;

/**
 * @license
 * Copyright 2024 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
// Generated stylesheet for ./button/internal/shared-elevation-styles.css.
const styles$2 = css `md-elevation{transition-duration:280ms}:host(:is([disabled],[soft-disabled])) md-elevation{transition:none}md-elevation{--md-elevation-level: var(--_container-elevation);--md-elevation-shadow-color: var(--_container-shadow-color)}:host(:focus-within) md-elevation{--md-elevation-level: var(--_focus-container-elevation)}:host(:hover) md-elevation{--md-elevation-level: var(--_hover-container-elevation)}:host(:active) md-elevation{--md-elevation-level: var(--_pressed-container-elevation)}:host(:is([disabled],[soft-disabled])) md-elevation{--md-elevation-level: var(--_disabled-container-elevation)}
`;

/**
 * @license
 * Copyright 2024 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
// Generated stylesheet for ./button/internal/shared-styles.css.
const styles$1 = css `:host{border-start-start-radius:var(--_container-shape-start-start);border-start-end-radius:var(--_container-shape-start-end);border-end-start-radius:var(--_container-shape-end-start);border-end-end-radius:var(--_container-shape-end-end);box-sizing:border-box;cursor:pointer;display:inline-flex;gap:8px;min-height:var(--_container-height);outline:none;padding-block:calc((var(--_container-height) - max(var(--_label-text-line-height),var(--_icon-size)))/2);padding-inline-start:var(--_leading-space);padding-inline-end:var(--_trailing-space);place-content:center;place-items:center;position:relative;font-family:var(--_label-text-font);font-size:var(--_label-text-size);line-height:var(--_label-text-line-height);font-weight:var(--_label-text-weight);text-overflow:ellipsis;text-wrap:nowrap;user-select:none;-webkit-tap-highlight-color:rgba(0,0,0,0);vertical-align:top;--md-ripple-hover-color: var(--_hover-state-layer-color);--md-ripple-pressed-color: var(--_pressed-state-layer-color);--md-ripple-hover-opacity: var(--_hover-state-layer-opacity);--md-ripple-pressed-opacity: var(--_pressed-state-layer-opacity)}md-focus-ring{--md-focus-ring-shape-start-start: var(--_container-shape-start-start);--md-focus-ring-shape-start-end: var(--_container-shape-start-end);--md-focus-ring-shape-end-end: var(--_container-shape-end-end);--md-focus-ring-shape-end-start: var(--_container-shape-end-start)}:host(:is([disabled],[soft-disabled])){cursor:default;pointer-events:none}.button{border-radius:inherit;cursor:inherit;display:inline-flex;align-items:center;justify-content:center;border:none;outline:none;-webkit-appearance:none;vertical-align:middle;background:rgba(0,0,0,0);text-decoration:none;min-width:calc(64px - var(--_leading-space) - var(--_trailing-space));width:100%;z-index:0;height:100%;font:inherit;color:var(--_label-text-color);padding:0;gap:inherit;text-transform:inherit}.button::-moz-focus-inner{padding:0;border:0}:host(:hover) .button{color:var(--_hover-label-text-color)}:host(:focus-within) .button{color:var(--_focus-label-text-color)}:host(:active) .button{color:var(--_pressed-label-text-color)}.background{background-color:var(--_container-color);border-radius:inherit;inset:0;position:absolute}.label{overflow:hidden}:is(.button,.label,.label slot),.label ::slotted(*){text-overflow:inherit}:host(:is([disabled],[soft-disabled])) .label{color:var(--_disabled-label-text-color);opacity:var(--_disabled-label-text-opacity)}:host(:is([disabled],[soft-disabled])) .background{background-color:var(--_disabled-container-color);opacity:var(--_disabled-container-opacity)}@media(forced-colors: active){.background{border:1px solid CanvasText}:host(:is([disabled],[soft-disabled])){--_disabled-icon-color: GrayText;--_disabled-icon-opacity: 1;--_disabled-container-opacity: 1;--_disabled-label-text-color: GrayText;--_disabled-label-text-opacity: 1}}:host([has-icon]:not([trailing-icon])){padding-inline-start:var(--_with-leading-icon-leading-space);padding-inline-end:var(--_with-leading-icon-trailing-space)}:host([has-icon][trailing-icon]){padding-inline-start:var(--_with-trailing-icon-leading-space);padding-inline-end:var(--_with-trailing-icon-trailing-space)}::slotted([slot=icon]){display:inline-flex;position:relative;writing-mode:horizontal-tb;fill:currentColor;flex-shrink:0;color:var(--_icon-color);font-size:var(--_icon-size);inline-size:var(--_icon-size);block-size:var(--_icon-size)}:host(:hover) ::slotted([slot=icon]){color:var(--_hover-icon-color)}:host(:focus-within) ::slotted([slot=icon]){color:var(--_focus-icon-color)}:host(:active) ::slotted([slot=icon]){color:var(--_pressed-icon-color)}:host(:is([disabled],[soft-disabled])) ::slotted([slot=icon]){color:var(--_disabled-icon-color);opacity:var(--_disabled-icon-opacity)}.touch{position:absolute;top:50%;height:48px;left:0;right:0;transform:translateY(-50%)}:host([touch-target=wrapper]){margin:max(0px,(48px - var(--_container-height))/2) 0}:host([touch-target=none]) .touch{display:none}
`;

/**
 * @license
 * Copyright 2021 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
/**
 * @summary Buttons help people take action, such as sending an email, sharing a
 * document, or liking a comment.
 *
 * @description
 * __Emphasis:__ High emphasis – For the primary, most important, or most common
 * action on a screen
 *
 * __Rationale:__ The filled button’s contrasting surface color makes it the
 * most prominent button after the FAB. It’s used for final or unblocking
 * actions in a flow.
 *
 * __Example usages:__
 * - Save
 * - Confirm
 * - Done
 *
 * @final
 * @suppress {visibility}
 */
let MdFilledButton = class MdFilledButton extends FilledButton {
};
MdFilledButton.styles = [
    styles$1,
    styles$2,
    styles$3,
];
MdFilledButton = __decorate$1([
    customElement('md-filled-button')
], MdFilledButton);

/**
 * @license
 * Copyright 2021 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
/**
 * A text button component.
 */
class TextButton extends Button$1 {
}

/**
 * @license
 * Copyright 2024 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
// Generated stylesheet for ./button/internal/text-styles.css.
const styles = css `:host{--_container-height: var(--md-text-button-container-height, 40px);--_disabled-label-text-color: var(--md-text-button-disabled-label-text-color, var(--md-sys-color-on-surface, #1d1b20));--_disabled-label-text-opacity: var(--md-text-button-disabled-label-text-opacity, 0.38);--_focus-label-text-color: var(--md-text-button-focus-label-text-color, var(--md-sys-color-primary, #6750a4));--_hover-label-text-color: var(--md-text-button-hover-label-text-color, var(--md-sys-color-primary, #6750a4));--_hover-state-layer-color: var(--md-text-button-hover-state-layer-color, var(--md-sys-color-primary, #6750a4));--_hover-state-layer-opacity: var(--md-text-button-hover-state-layer-opacity, 0.08);--_label-text-color: var(--md-text-button-label-text-color, var(--md-sys-color-primary, #6750a4));--_label-text-font: var(--md-text-button-label-text-font, var(--md-sys-typescale-label-large-font, var(--md-ref-typeface-plain, Roboto)));--_label-text-line-height: var(--md-text-button-label-text-line-height, var(--md-sys-typescale-label-large-line-height, 1.25rem));--_label-text-size: var(--md-text-button-label-text-size, var(--md-sys-typescale-label-large-size, 0.875rem));--_label-text-weight: var(--md-text-button-label-text-weight, var(--md-sys-typescale-label-large-weight, var(--md-ref-typeface-weight-medium, 500)));--_pressed-label-text-color: var(--md-text-button-pressed-label-text-color, var(--md-sys-color-primary, #6750a4));--_pressed-state-layer-color: var(--md-text-button-pressed-state-layer-color, var(--md-sys-color-primary, #6750a4));--_pressed-state-layer-opacity: var(--md-text-button-pressed-state-layer-opacity, 0.12);--_disabled-icon-color: var(--md-text-button-disabled-icon-color, var(--md-sys-color-on-surface, #1d1b20));--_disabled-icon-opacity: var(--md-text-button-disabled-icon-opacity, 0.38);--_focus-icon-color: var(--md-text-button-focus-icon-color, var(--md-sys-color-primary, #6750a4));--_hover-icon-color: var(--md-text-button-hover-icon-color, var(--md-sys-color-primary, #6750a4));--_icon-color: var(--md-text-button-icon-color, var(--md-sys-color-primary, #6750a4));--_icon-size: var(--md-text-button-icon-size, 18px);--_pressed-icon-color: var(--md-text-button-pressed-icon-color, var(--md-sys-color-primary, #6750a4));--_container-shape-start-start: var(--md-text-button-container-shape-start-start, var(--md-text-button-container-shape, var(--md-sys-shape-corner-full, 9999px)));--_container-shape-start-end: var(--md-text-button-container-shape-start-end, var(--md-text-button-container-shape, var(--md-sys-shape-corner-full, 9999px)));--_container-shape-end-end: var(--md-text-button-container-shape-end-end, var(--md-text-button-container-shape, var(--md-sys-shape-corner-full, 9999px)));--_container-shape-end-start: var(--md-text-button-container-shape-end-start, var(--md-text-button-container-shape, var(--md-sys-shape-corner-full, 9999px)));--_leading-space: var(--md-text-button-leading-space, 12px);--_trailing-space: var(--md-text-button-trailing-space, 12px);--_with-leading-icon-leading-space: var(--md-text-button-with-leading-icon-leading-space, 12px);--_with-leading-icon-trailing-space: var(--md-text-button-with-leading-icon-trailing-space, 16px);--_with-trailing-icon-leading-space: var(--md-text-button-with-trailing-icon-leading-space, 16px);--_with-trailing-icon-trailing-space: var(--md-text-button-with-trailing-icon-trailing-space, 12px);--_container-color: none;--_disabled-container-color: none;--_disabled-container-opacity: 0}
`;

/**
 * @license
 * Copyright 2021 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
/**
 * @summary Buttons help people take action, such as sending an email, sharing a
 * document, or liking a comment.
 *
 * @description
 * __Emphasis:__ Low emphasis – For optional or supplementary actions with the
 * least amount of prominence
 *
 * __Rationale:__ Text buttons have less visual prominence, so should be used
 * for low emphasis actions, such as an alternative option.
 *
 * __Example usages:__
 * - Learn more
 * - View all
 * - Change account
 * - Turn on
 *
 * @final
 * @suppress {visibility}
 */
let MdTextButton = class MdTextButton extends TextButton {
};
MdTextButton.styles = [styles$1, styles];
MdTextButton = __decorate$1([
    customElement('md-text-button')
], MdTextButton);

/**
 * @license
 * Copyright 2022 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
// The padding on the label start/end when there is no icons.
const LABEL_PADDING_START_END = css `16px`;
// The padding on the icon start/end when present.
const ICON_PADDING_START_END = css `12px`;
// The inline gap between the label and the optional icons.
const ICON_GAP = css `8px`;
const CONTAINER_HEIGHT = css `36px`;
const ICON_SIZE = css `20px`;
const MIN_WIDTH$1 = css `64px`;
/**
 * A chromeOS compliant button.
 */
class Button extends LitElement {
    /** @nocollapse */
    static { this.shadowRootOptions = { mode: 'open', delegatesFocus: true }; }
    // Note that theme colours have opacity defined in the colour, but default
    // colours have opacities set separately. As a consequence, styles are broken
    // unless a cros theme is present.
    /** @nocollapse */
    static { this.styles = css `
    :host {
      display: inline-block;
      text-overflow: ellipsis;
      text-wrap: nowrap;
      width: fit-content;
    }

    .button {
      max-width: var(--cros-button-max-width,200px);
      min-width: ${MIN_WIDTH$1};
      text-overflow: inherit;
      text-wrap: inherit;
      width: 100%;
      height: 100%;
    }

    .label {
      overflow: hidden;
      text-overflow: inherit;
    }

    :host([overflow="stack"]) {
      text-wrap: wrap;
    }

    ::slotted(*) {
      display: inline-flex;
      block-size: ${ICON_SIZE};
      inline-size: ${ICON_SIZE};
    }

    .content-container {
      align-items: center;
      display: flex;
      gap: ${ICON_GAP};
    }

    md-filled-button:has(.content-container.has-leading-icon)  {
      --md-filled-button-leading-space: ${ICON_PADDING_START_END};
    }

    md-filled-button:has(.content-container.has-trailing-icon)  {
      --md-filled-button-trailing-space: ${ICON_PADDING_START_END};
    }

    md-text-button:has(.content-container.has-leading-icon)  {
      --md-text-button-leading-space: ${ICON_PADDING_START_END};
    }

    md-text-button:has(.content-container.has-trailing-icon)  {
      --md-text-button-trailing-space: ${ICON_PADDING_START_END};
    }

    md-filled-button {
      --md-filled-button-container-height: ${CONTAINER_HEIGHT};
      --md-filled-button-disabled-container-color: var(--cros-sys-disabled_container);
      --md-filled-button-disabled-container-opacity: 100%;
      --md-filled-button-disabled-label-text-color: var(--cros-sys-disabled);
      --md-filled-button-disabled-label-text-opacity: 100%;
      --md-filled-button-focus-state-layer-opacity: 100%;
      --md-filled-button-hover-container-elevation: 0;
      --md-filled-button-hover-state-layer-opacity: 100%;
      --md-filled-button-label-text-font: var(--cros-button-2-font-family);
      --md-filled-button-label-text-size: var(--cros-button-2-font-size);
      --md-filled-button-label-text-line-height: var(--cros-button-2-line-height);
      --md-filled-button-label-text-weight: var(--cros-button-2-font-weight);
      --md-filled-button-leading-space: ${LABEL_PADDING_START_END};
      --md-filled-button-pressed-state-layer-opacity: 100%;
      --md-filled-button-trailing-space: ${LABEL_PADDING_START_END};
      --md-focus-ring-duration: 0s;
      --md-focus-ring-width: 2px;
      --md-sys-color-secondary: var(--cros-sys-focus_ring);
    }

    :host(:not([button-style="secondary"]):is([inverted][disabled])) {
      opacity: var(--cros-disabled-opacity);
    }

    :host([inverted][button-style="primary"]) md-filled-button {
      /** Base styles */
      --md-sys-color-primary: var(--cros-sys-inverse_primary);
      --md-sys-color-secondary: var(--cros-sys-inverse_focus_ring);
      --md-sys-color-on-primary: var(--cros-sys-inverse_on_primary);
      --md-filled-button-label-text-color: var(--cros-sys-inverse_on_primary);
      /** Disabled */
      --md-filled-button-disabled-container-color: var(--cros-sys-inverse_primary);
      --md-filled-button-disabled-label-text-color: var(--cros-sys-inverse_on_primary);
      /** Hover */
      --md-filled-button-hover-state-layer-color: var(--cros-sys-inverse_hover_on_prominent);
      /** Pressed */
      --md-filled-button-pressed-state-layer-color: var(--cros-sys-inverse_ripple_primary);
    }

    :host([button-style="primary"]) md-filled-button {
      --md-sys-color-primary: var(--cros-sys-primary);
      --md-sys-color-on-primary: var(--cros-sys-on_primary);
      --md-filled-button-hover-state-layer-color: var(--cros-sys-hover_on_prominent);
      --md-filled-button-pressed-state-layer-color: var(--cros-sys-ripple_primary);
    }

    :host([button-style="secondary"]) md-filled-button {
      --md-filled-button-hover-state-layer-color: var(--cros-sys-hover_on_subtle);
      --md-filled-button-pressed-state-layer-color: var(--cros-sys-ripple_primary);
      --md-sys-color-primary: var(--cros-sys-primary_container);
      --md-sys-color-on-primary: var(--cros-sys-on_primary_container);
    }

    md-text-button {
      --md-sys-color-primary: var(--cros-sys-primary);
      --md-sys-color-secondary: var(--cros-sys-focus_ring);
      --md-focus-ring-duration: 0s;
      --md-focus-ring-width: 2px;
      --md-text-button-container-height: ${CONTAINER_HEIGHT};
      --md-text-button-disabled-label-text-color: var(--cros-sys-disabled);
      --md-text-button-disabled-label-text-opacity: 100%;
      --md-text-button-focus-state-layer-opacity: 100%;
      --md-text-button-hover-state-layer-color: var(--cros-sys-hover_on_subtle);
      --md-text-button-hover-state-layer-opacity: 100%;
      --md-text-button-label-text-color: var(--cros-sys-primary);
      --md-text-button-label-text-font: var(--cros-button-2-font-family);
      --md-text-button-label-text-size: var(--cros-button-2-font-size);
      --md-text-button-label-text-line-height: var(--cros-button-2-line-height);
      --md-text-button-label-text-weight: var(--cros-button-2-font-weight);
      --md-text-button-leading-space: ${LABEL_PADDING_START_END};
      --md-text-button-pressed-state-layer-color: var(--cros-sys-ripple_neutral_on_subtle);
      --md-text-button-pressed-state-layer-opacity: 100%;
      --md-text-button-trailing-space: ${LABEL_PADDING_START_END};
    }

    :host([inverted]) md-text-button {
      /** Base styles */
      --md-sys-color-primary: var(--cros-sys-inverse_primary);
      --md-sys-color-secondary: var(--cros-sys-inverse_focus_ring);
      --md-text-button-label-text-color: var(--cros-sys-inverse_primary);
      /** Disabled */
      --md-text-button-disabled-label-text-color: var(--cros-sys-inverse_primary);
      --md-text-button-pressed-state-layer-color: var(--cros-sys-inverse_ripple_neutral_on_subtle);
      --md-text-button-hover-state-layer-color: var(--cros-sys-inverse_hover_on_subtle);
    }

    ::slotted(ea-icon) {
      --ea-icon-size: 20px;
    }
  `; }
    /** @nocollapse */
    static { this.properties = {
        ariaLabel: { type: String, reflect: true, attribute: 'aria-label' },
        ariaExpanded: { type: String, reflect: true, attribute: 'aria-expanded' },
        label: { type: String, reflect: true },
        disabled: { type: Boolean, reflect: true },
        buttonStyle: { type: String, reflect: true, attribute: 'button-style' },
        inverted: { type: Boolean, reflect: true },
        ariaHasPopup: { type: String, reflect: true, attribute: 'aria-haspopup' },
        overflow: { type: String, reflect: true },
        href: { type: String },
    }; }
    constructor() {
        super();
        this.ariaLabel = '';
        this.label = '';
        this.disabled = false;
        this.buttonStyle = 'primary';
        this.inverted = false;
        this.overflow = 'truncate';
        this.href = '';
    }
    connectedCallback() {
        super.connectedCallback();
        // All aria properties on button just get proxied down to the real <button>
        // element, as such we set role to presentation so screenreaders ignore
        // this component and instead only read aria attributes off the inner
        // interactive element.
        this.setAttribute('role', 'presentation');
    }
    firstUpdated() {
        this.addEventListener('click', this.clickListener);
    }
    clickListener(e) {
        if (this.disabled) {
            e.stopImmediatePropagation();
            e.preventDefault();
            return;
        }
    }
    render() {
        const ariaHasPopup = (this.ariaHasPopup ?? '');
        const ariaExpanded = (this.ariaExpanded ?? '');
        if (this.buttonStyle === 'floating') {
            return html `
        <md-text-button
            class="button"
            aria-label=${this.ariaLabel || ''}
            aria-haspopup=${ifDefined(ariaHasPopup)}
            aria-expanded=${ifDefined(ariaExpanded)}
            ?disabled=${this.disabled}
            href=${this.href}>
          ${this.renderButtonContent()}
        </md-text-button>
        `;
        }
        return html `
        <md-filled-button
            class="button"
            aria-label=${this.ariaLabel || ''}
            aria-haspopup=${ifDefined(ariaHasPopup)}
            aria-expanded=${ifDefined(ariaExpanded)}
            ?disabled=${this.disabled}
            href=${this.href}>
          ${this.renderButtonContent()}
        </md-filled-button>
        `;
    }
    renderButtonContent() {
        return html `
      <div class="content-container">
        <slot name="leading-icon" @slotchange=${this.onSlotChange}></slot>
        <span class="label">${this.label}</span>
        <slot name="trailing-icon" @slotchange=${this.onSlotChange}></slot>
      </div>
    `;
    }
    hasSlottedIcon(icon) {
        return !!this.querySelector(`*[slot='${icon}-icon']`);
    }
    // The padding before/after the label changes based on whether there is an
    // icon present. We use the slot change event to toggle the different padding
    // styles on the container, as it's easier to achieve here compared with pure
    // CSS selectors. The actual padding is applied to the material button which
    // is difficult to define a pure CSS relationship with due to the nature of
    // how the slots are arranged.
    onSlotChange() {
        const container = this.shadowRoot.querySelector('.content-container');
        container.classList.toggle('has-leading-icon', this.hasSlottedIcon('leading'));
        container.classList.toggle('has-trailing-icon', this.hasSlottedIcon('trailing'));
    }
}
customElements.define('cros-button', Button);

function getTemplate$j() {
    return getTrustedHTML `<!--_html_template_start_--><style>
  :host {
    width: 100%;
  }

  .educational-banner {
    align-items: center;
    display: flex;
    flex-direction: row;
    flex-wrap: wrap;
    min-height: 32px;
    width: 100%;
  }

  #educational-text-group {
    align-items: flex-start;
    display: flex;
    flex: 1 0 0;
    flex-direction: column;
    flex-wrap: nowrap;
  }

  .educational-text-icon {
    align-items: center;
    display: flex;
    flex-direction: row;
    flex-wrap: nowrap;
    margin-bottom: 8px;
    margin-top: 8px;
  }

  .feature-icon {
    -webkit-mask-image: var(--feature-icon-src, none);
    -webkit-mask-position: center;
    -webkit-mask-repeat: no-repeat;
    background-color: var(--feature-icon-bg, var(--cros-sys-primary));
    flex: none;
    height: 32px;
    margin-inline-end: 20px;
    margin-inline-start: 16px;
    width: 32px;
  }

  ::slotted([slot='illustration']) {
    height: 32px;
    width: 32px;
  }

  .title {
    -webkit-box-orient: vertical;
    -webkit-line-clamp: 2;
    color: var(--cros-sys-on_surface);
    display: -webkit-box;
    font: var(--cros-headline-1-font);
    overflow: hidden;
    text-overflow: ellipsis;
  }

  .subtitle {
    color: var(--cros-sys-on_surface);
    font: var(--cros-body-2-font);
  }

  .button-group {
    align-items: center;
    display: flex;
    flex: 0 0 auto;
    flex-direction: var(--buttons-direction, row);
    height: 32px;
    margin-bottom: 8px;
    margin-inline-start: auto;
    margin-top: 8px;
    padding-inline-start: 32px;
  }

  ::slotted(cr-button),
  #dismiss-button-old {
    --active-bg: none;
    --bg-action: var(--cros-sys-primary);
    /* Use the default bg color as hover color because we
       rely on hoverBackground layer below.  */
    --hover-bg-action: var(--cros-sys-primary);
    --hover-bg-color: var(--cros-sys-hover_on_subtle);
    --ink-color: var(--cros-sys-ripple_neutral_on_subtle);
    --ink-color-action: var(--cros-sys-ripple_primary);
    --paper-ripple-opacity: 100%;
    --text-color-action: var(--cros-sys-on_primary);
    --text-color: var(--cros-sys-primary);
    border: none;
    border-radius: 18px;
    box-shadow: none;
    font: var(--cros-button-2-font);
    height: 36px;
    margin-inline: 4px;
    padding-inline: 16px;
    position: relative;
  }

  #dismiss-button {
    margin-inline: 4px;
  }

  :host-context(.focus-outline-visible) ::slotted(cr-button:focus),
  :host-context(.focus-outline-visible) #dismiss-button-old:focus {
    outline: 2px solid var(--cros-sys-focus_ring);
    outline-offset: 2px;
  }
</style>
<div class="educational-banner">
  <div class="educational-text-icon">
    <!-- Use feature-icon to pass a monotone color SVG, use slot illustration
         to pass multiple colored SVG, when slot illustration is used, remember
         to set --feature-icon-src to none. -->
    <div class="feature-icon">
      <slot name="illustration"></slot>
    </div>
    <div id="educational-text-group">
      <div class="title">
        <slot name="title"></slot>
      </div>
      <div class="subtitle">
        <slot name="subtitle"></slot>
      </div>
    </div>
  </div>
  <div class="button-group">
    <slot name="extra-button"></slot>
    <slot name="dismiss-button">
      <xf-jellybean>
        <cr-button id="dismiss-button-old" slot="old">
          $i18n{DRIVE_WELCOME_DISMISS}
        </cr-button>
        <cros-button
            label="$i18n{DRIVE_WELCOME_DISMISS}"
            id="dismiss-button"
            button-style="floating"
            slot="jelly">
        </cros-button>
      </xf-jellybean>
    </slot>
  </div>
</div>
<!--_html_template_end_-->`;
}

// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * EducationalBanner is a type of banner that is the second highest priority
 * type of banner (below WarningBanner). It is used to highlight new features or
 * contextually relevant information in specific part of the Files app.
 *
 * To implement an EducationalBanner, extend from this banner and override the
 * allowedVolumes method to define the VolumeType you want the banner to be
 * shown on. All other configuration elements are optional and can be found
 * documented on the Banner externs.
 *
 * For example the following banner will show when a user navigates to the
 * Downloads volume type:
 *
 *    class ConcreteEducationalBanner extends EducationalBanner {
 *      allowedVolumes() {
 *        return [{type: VolumeType.DOWNLOADS}];
 *      }
 *    }
 *
 * Create a HTML template with the same file name as the banner and override
 * the text using slots with the content that you want:
 *
 *    <educational-banner>
 *      <span slot="title">Main banner text</span>
 *      <span slot="subtitle">Extra information that appears smaller</span>
 *      <cr-button slot="extra-button" href="{{url_to_navigate}}">
 *        Extra button text
 *      </cr-button>
 *    </educational-banner>
 *
 * There is also an optional HTML attribute that can be added to the
 * extra-button slot called dismiss-banner-when-clicked that will dismiss the
 * banner forever when the extra button is pressed. Example:
 *
 *      <cr-button
 *          slot="extra-button"
 *          href="{{url_to_navigate}}"
 *          dismiss-banner-when-clicked>
 *        Extra button text
 *      </cr-button>
 */
class EducationalBanner extends Banner {
    constructor() {
        super();
        const fragment = this.getTemplate();
        this.attachShadow({ mode: 'open' }).appendChild(fragment);
    }
    /**
     * Returns the HTML template for the Educational Banner.
     */
    getTemplate() {
        const template = document.createElement('template');
        template.innerHTML = getTemplate$j();
        const fragment = template.content.cloneNode(true);
        return fragment;
    }
    /**
     * Get the concrete banner instance.
     */
    getBannerInstance_() {
        const parent = this.getRootNode() && this.getRootNode().host;
        let bannerInstance = this;
        // In the case the educational-banner web component is not the root node
        // (e.g. it is contained within another web component) prefer the outer
        // component.
        if (parent && parent instanceof EducationalBanner) {
            bannerInstance = parent;
        }
        return bannerInstance;
    }
    /**
     * Called when the web component is connected to the DOM. This will be called
     * for both the inner warning-banner component and the concrete
     * implementations that extend from it.
     */
    connectedCallback() {
        // If an EducationalBanner subclass overrides the default dismiss button
        // the button will not exist in the shadowRoot. Add the event listener to
        // the overridden dismiss button first and fall back to the default button
        // if no overridden button.
        const overridenDismissButton = this.querySelector('[slot="dismiss-button"]');
        const defaultDismissButton = this.shadowRoot.querySelector(isCrosComponentsEnabled() ? '#dismiss-button' : '#dismiss-button-old');
        if (overridenDismissButton) {
            overridenDismissButton.addEventListener('click', (event) => this.onDismissClickHandler_(event, DismissedForeverEventSource.OVERRIDEN_DISMISS_BUTTON));
        }
        else if (defaultDismissButton) {
            defaultDismissButton.addEventListener('click', (event) => this.onDismissClickHandler_(event, DismissedForeverEventSource.DEFAULT_DISMISS_BUTTON));
        }
        // Attach an onclick handler to the extra-button slot. This enables a new
        // element to leverage the href tag on the element to have a URL opened.
        // TODO(crbug.com/40189485): Add UMA trigger to capture number of extra
        // button clicks.
        const extraButton = this.querySelector('[slot="extra-button"]');
        const href = extraButton?.getAttribute('href');
        if (href && extraButton) {
            extraButton.addEventListener('click', (e) => {
                visitURL(href);
                if (extraButton.hasAttribute('dismiss-banner-when-clicked')) {
                    this.dispatchEvent(new CustomEvent(BannerEvent.BANNER_DISMISSED_FOREVER, {
                        bubbles: true,
                        composed: true,
                        detail: {
                            banner: this.getBannerInstance_(),
                            eventSource: DismissedForeverEventSource.EXTRA_BUTTON,
                        },
                    }));
                }
                e.preventDefault();
            });
        }
    }
    /**
     * Only show the banner 3 Files app sessions (unless dismissed). Please refer
     * to the Banner externs for information about Files app session.
     */
    showLimit() {
        return 3;
    }
    /**
     * All banners that inherit this class should override with their own
     * volume types to allow. Setting this explicitly as an empty array ensures
     * banners that don't override this are not shown by default.
     */
    allowedVolumes() {
        return [];
    }
    /**
     * Handler for the dismiss button on click, switches to the custom banner
     * dismissal event to ensure the controller can catch the event.
     */
    onDismissClickHandler_(_, dismissedForeverEventSource) {
        this.dispatchEvent(new CustomEvent(BannerEvent.BANNER_DISMISSED_FOREVER, {
            bubbles: true,
            composed: true,
            detail: {
                banner: this.getBannerInstance_(),
                eventSource: dismissedForeverEventSource,
            },
        }));
    }
}
customElements.define('educational-banner', EducationalBanner);

// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * The custom element tag name.
 */
const TAG_NAME$g = 'drive-bulk-pinning-banner';
/**
 * A banner that prompts users to bulk pin their files.
 */
class DriveBulkPinningBanner extends EducationalBanner {
    constructor() {
        super();
        this.shadowRoot.querySelector('.action-button').addEventListener('click', (e) => {
            e.preventDefault();
            const dialog = document.querySelector('xf-bulk-pinning-dialog');
            dialog.show();
        });
    }
    /**
     * Returns the HTML template for the Bulk pinning banner.
     */
    getTemplate() {
        const template = document.createElement('template');
        template.innerHTML = getTemplate$k();
        const fragment = template.content.cloneNode(true);
        return fragment;
    }
    /**
     * Only show the banner when the user has navigated to the Drive volume type
     * and the feature flag is enabled.
     */
    allowedVolumes() {
        return [{
                type: VolumeType.DRIVE,
                root: RootType.DRIVE,
            }];
    }
    /**
     * Show this banner for an unlimited number of sessions.
     */
    showLimit() {
        return 0;
    }
}
customElements.define(TAG_NAME$g, DriveBulkPinningBanner);

function getTemplate$i() {
    return getTrustedHTML `<!--_html_template_start_--><warning-banner role="banner" class="tast-drive-low-individual-space">
  <span slot="text"></span>
  <cr-button slot="extra-button" href="$i18n{GOOGLE_DRIVE_MANAGE_STORAGE_URL}">
    $i18n{LEARN_MORE_LABEL}
  </cr-button>
  <cr-button slot="dismiss-button" id="dismiss-button">
    $i18n{DRIVE_WELCOME_DISMISS}
  </cr-button>
</warning-banner>
<!--_html_template_end_-->`;
}

function getTemplate$h() {
    return getTrustedHTML `<!--_html_template_start_--><style>
  :host {
    width: 100%;
  }

  .warning-banner {
    display: flex;
    flex-direction: row;
    flex-wrap: wrap;
    min-height: 32px;
    width: 100%;
  }

  #warning-text-group {
    align-items: center;
    display: flex;
    flex-direction: row;
    flex-wrap: nowrap;
  }

  .warning-icon-holder {
    align-items: center;
    background-color: var(--icon-holder-bg, var(--cros-sys-warning_container));
    border-radius: 16px;
    display: flex;
    height: 32px;
    justify-content: center;
    margin-inline-end: 20px;
    margin-inline-start: 16px;
    width: 32px;
  }

  .warning-icon {
    -webkit-mask-image: var(--icon-src,
        url(/foreground/images/files/ui/warning_banner_icon.svg));
    -webkit-mask-position: center;
    -webkit-mask-repeat: no-repeat;
    background-color: var(--icon-bg, var(--cros-sys-on_warning_container));
    flex: none;
    height: 20px;
    width: 20px;
  }

  .warning-message {
    color: var(--cros-sys-on_surface);
    font: var(--cros-body-2-font);
  }

  .button-group {
    align-items: center;
    display: flex;
    flex: 0 0 auto;
    height: 32px;
    margin-inline-start: auto;
    padding-inline-start: 32px;
  }

  ::slotted(cr-button),
  #dismiss-button {
    --active-bg: none;
    --hover-bg-color: var(--cros-sys-hover_on_subtle);
    --ink-color: var(--cros-sys-ripple_neutral_on_subtle);
    --paper-ripple-opacity: 100%;
    --text-color: var(--cros-sys-primary);
    border: none;
    border-radius: 18px;
    box-shadow: none;
    font: var(--cros-button-2-font);
    height: 36px;
    margin-inline: 4px;
    padding-inline: 16px;
    position: relative;
  }

  :host-context(.focus-outline-visible) ::slotted(cr-button:focus),
  :host-context(.focus-outline-visible) #dismiss-button:focus {
    outline: 2px solid var(--cros-sys-focus_ring);
    outline-offset: 2px;
  }
</style>
<div class="warning-banner">
  <div id="warning-text-group">
    <div class="warning-icon-holder">
      <div class="warning-icon"></div>
    </div>
    <div class="warning-message">
      <slot name="text"></slot>
    </div>
  </div>
  <div class="button-group">
    <slot name="extra-button"></slot>
    <slot name="dismiss-button"></slot>
  </div>
</div>
<!--_html_template_end_-->`;
}

// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * WarningBanner is a type of banner that is highest priority and is used to
 * showcase potential underlying issues for the filesystem (e.g. low disk space)
 * or that are contextually relevant (e.g. Google Drive is offline).
 *
 * To implement a WarningBanner, extend from this banner and override the
 * allowedVolumes method where you want the warning message shown. The
 * connectedCallback method can be used to set the warning text and an optional
 * link to provide more information. All other configuration elements are
 * optional and can be found documented on the Banner extern.
 *
 * For example the following banner will show when a user navigates to the
 * Downloads volume type:
 *
 *    class ConcreteWarningBanner extends WarningBanner {
 *      allowedVolumes() {
 *        return [{type: VolumeType.DOWNLOADS}];
 *      }
 *    }
 *
 * Create a HTML template with the same file name as the banner and override
 * the text using slots with the content that you want:
 *
 *    <warning-banner>
 *      <span slot="text">Warning Banner text</span>
 *      <cr-button slot="extra-button" href="{{url_to_navigate}}">
 *        Extra button text
 *      </cr-button>
 *    </warning-banner>
 */
class WarningBanner extends Banner {
    constructor() {
        super();
        const fragment = this.getTemplate();
        this.attachShadow({ mode: 'open' }).appendChild(fragment);
    }
    /**
     * Returns the HTML template for the Warning Banner.
     */
    getTemplate() {
        const template = document.createElement('template');
        template.innerHTML = getTemplate$h();
        const fragment = template.content.cloneNode(true);
        return fragment;
    }
    /**
     * Called when the web component is connected to the DOM. This will be called
     * for both the inner warning-banner component and the concrete
     * implementations that extend from it.
     */
    connectedCallback() {
        // If a WarningBanner subclass overrides the default dismiss button, the
        // button will not exist in the shadowRoot. Add the event listener to the
        // overridden dismiss button first and fall back to the default button if
        // no overridden button.
        const overridenDismissButton = this.querySelector('[slot="dismiss-button"]');
        const defaultDismissButton = this.shadowRoot.querySelector('#dismiss-button');
        if (overridenDismissButton) {
            overridenDismissButton.addEventListener('click', this.onDismissClickHandler_.bind(this));
        }
        else if (defaultDismissButton) {
            defaultDismissButton.addEventListener('click', this.onDismissClickHandler_.bind(this));
        }
        // Attach an onclick handler to the extra-button slot. This enables a new
        // element to leverage the href tag on the element to have a URL opened.
        // TODO(crbug.com/40189485): Add UMA trigger to capture number of extra
        // button clicks.
        const extraButton = this.querySelector('[slot="extra-button"]');
        if (extraButton) {
            extraButton.addEventListener('click', (e) => {
                if (extraButton.getAttribute('href')) {
                    visitURL(extraButton.getAttribute('href'));
                }
                e.preventDefault();
            });
        }
    }
    /**
     * When a WarningBanner is dismissed, do not show it again for another 36
     * hours.
     */
    hideAfterDismissedDurationSeconds() {
        return 36 * 60 * 60; // 36 hours, 129,600 seconds.
    }
    /**
     * All banners that inherit this class should override with their own
     * volume types to allow. Setting this explicitly as an empty array ensures
     * banners that don't override this are not shown by default.
     */
    allowedVolumes() {
        return [];
    }
    /**
     * Handler for the dismiss button on click, switches to the custom banner
     * dismissal event to ensure the controller can catch the event.
     */
    onDismissClickHandler_(_) {
        const parent = this.getRootNode() && this.getRootNode().host;
        let bannerInstance = this;
        // In the case the warning-banner web component is not the root node (e.g.
        // it is contained within another web component) prefer the outer component.
        if (parent && parent instanceof WarningBanner) {
            bannerInstance = parent;
        }
        this.dispatchEvent(new CustomEvent(BannerEvent.BANNER_DISMISSED, { bubbles: true, composed: true, detail: { banner: bannerInstance } }));
    }
}
customElements.define('warning-banner', WarningBanner);

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * The custom element tag name.
 */
const TAG_NAME$f = 'drive-individual-low-space-banner';
/**
 * A banner that shows a warning when the remaining space on a Google Drive goes
 * below 20%. This is only shown if the user has navigated to the My drive under
 * the Google Drive root excluding other directories such as Computers or
 * Shared drives.
 */
class DriveLowIndividualSpaceBanner extends WarningBanner {
    /**
     * Returns the HTML template for this banner.
     */
    getTemplate() {
        const template = document.createElement('template');
        template.innerHTML = getTemplate$i();
        const fragment = template.content.cloneNode(true);
        return fragment;
    }
    /**
     * Show the banner when the Drive volume has gone below 20% remaining space.
     */
    diskThreshold() {
        return {
            type: RootType.DRIVE,
            minRatio: 0.2,
        };
    }
    /**
     * Only show the banner when the user has navigated to the My drive directory
     * and all children. Having root and type means this warning does not show on
     * Shared drives, Team drives, Computers or Offline.
     */
    allowedVolumes() {
        return [{
                type: VolumeType.DRIVE,
                root: RootType.DRIVE,
            }];
    }
    /**
     * When the custom filter shows this banner in the controller, it passes the
     * context to the banner.
     */
    onFilteredContext(context) {
        if (!context || context.totalBytes === null || context.usedBytes === null) {
            console.warn('Context not supplied or missing data');
            return;
        }
        this.shadowRoot.querySelector('span[slot="text"]').innerText =
            strf('DRIVE_INDIVIDUAL_QUOTA_LOW', Math.ceil((context.totalBytes - context.usedBytes) / context.totalBytes *
                100), bytesToString(context.totalBytes));
    }
}
customElements.define(TAG_NAME$f, DriveLowIndividualSpaceBanner);

function getTemplate$g() {
    return getTrustedHTML `<!--_html_template_start_--><warning-banner role="banner" class="tast-drive-low-shared-drive-space">
  <span slot="text"></span>
  <cr-button slot="extra-button" href="$i18n{GOOGLE_DRIVE_MANAGE_STORAGE_URL}">
    $i18n{LEARN_MORE_LABEL}
  </cr-button>
  <cr-button slot="dismiss-button" id="dismiss-button">
    $i18n{DRIVE_WELCOME_DISMISS}
  </cr-button>
</warning-banner>
<!--_html_template_end_-->`;
}

// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * The custom element tag name.
 */
const TAG_NAME$e = 'drive-shared-drive-low-space-banner';
/**
 * A banner that shows a warning when the remaining space on a Google Shared
 * Drive goes below 20%.
 */
class DriveLowSharedDriveSpaceBanner extends WarningBanner {
    /**
     * Returns the HTML template for this banner.
     */
    getTemplate() {
        const template = document.createElement('template');
        template.innerHTML = getTemplate$g();
        const fragment = template.content.cloneNode(true);
        return fragment;
    }
    /**
     * Show the banner when the Drive volume has gone below 20% remaining space.
     */
    diskThreshold() {
        return {
            type: RootType.DRIVE,
            minRatio: 0.2,
        };
    }
    /**
     * Only show the banner when the user has navigated to a Shared Drive.
     */
    allowedVolumes() {
        return [{
                type: VolumeType.DRIVE,
                root: RootType.SHARED_DRIVE,
            }];
    }
    /**
     * When the custom filter shows this banner in the controller, it passes the
     * context to the banner.
     */
    onFilteredContext(context) {
        if (!context || context.totalBytes === null || context.usedBytes === null) {
            console.warn('Context not supplied or missing data');
            return;
        }
        this.shadowRoot.querySelector('span[slot="text"]').innerText =
            strf('DRIVE_SHARED_DRIVE_QUOTA_LOW', Math.ceil((context.totalBytes - context.usedBytes) / context.totalBytes *
                100), bytesToString(context.totalBytes));
    }
}
customElements.define(TAG_NAME$e, DriveLowSharedDriveSpaceBanner);

function getTemplate$f() {
    return getTrustedHTML `<!--_html_template_start_--><style>
  educational-banner {
    --feature-icon-src: url(/foreground/images/files/ui/drive_offline_icon.svg);
  }
</style>
<educational-banner>
  <span slot="title">$i18n{DRIVE_OFFLINE_BANNER_TITLE}</span>
  <span slot="subtitle"></span>
  <cr-button slot="extra-button" href="$i18n{GOOGLE_DRIVE_OFFLINE_HELP_URL}" dismiss-banner-when-clicked>
    $i18n{DRIVE_LEARN_MORE}
  </cr-button>
</educational-banner>
<!--_html_template_end_-->`;
}

// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * The custom element tag name.
 */
const TAG_NAME$d = 'drive-offline-pinning-banner';
/**
 * A banner that shows users they can pin Docs / Sheets / Slides in Google Drive
 * and have them available offline.
 */
class DriveOfflinePinningBanner extends EducationalBanner {
    /**
     * Returns the HTML template for the Drive Offline Pinning educational banner.
     */
    getTemplate() {
        const template = document.createElement('template');
        template.innerHTML = getTemplate$f();
        const fragment = template.content.cloneNode(true);
        return fragment;
    }
    /**
     * The Drive offline pinning banner uses a templatised string to ensure the
     * toggle name is a reference. This can't be achieved with C++ template
     * replacements, so set it once the web component has been connected to the
     * DOM.
     */
    connectedCallback() {
        super.connectedCallback();
        const subtitle = this.shadowRoot.querySelector('span[slot="subtitle"]');
        subtitle.innerText =
            strf('DRIVE_OFFLINE_BANNER_SUBTITLE', str('OFFLINE_COLUMN_LABEL'));
    }
    /**
     * Only show the banner when the user has navigated to the Drive volume type
     * and the feature flag is enabled.
     */
    allowedVolumes() {
        return [{
                type: VolumeType.DRIVE,
                root: RootType.DRIVE,
            }];
    }
}
customElements.define(TAG_NAME$d, DriveOfflinePinningBanner);

function getTemplate$e() {
    return getTrustedHTML `<!--_html_template_start_--><style>
  warning-banner {
    --icon-bg: var(--cros-sys-on_error_container);
    --icon-holder-bg: var(--cros-sys-error_container);
    --icon-src: url(/foreground/images/files/ui/error_banner_icon.svg);
  }
</style>
<warning-banner role="banner" class="tast-drive-out-of-individual-space">
  <span slot="text" aria-label="$i18n{DRIVE_WARNING_QUOTA_OVER}: $i18n{DRIVE_INDIVIDUAL_QUOTA_OVER}">
    <span aria-hidden="true">
      $i18n{DRIVE_INDIVIDUAL_QUOTA_OVER}
    </span>
  </span>
  <cr-button slot="extra-button" href="$i18n{GOOGLE_DRIVE_MANAGE_STORAGE_URL}">
    $i18n{LEARN_MORE_LABEL}
  </cr-button>
</warning-banner>
<!--_html_template_end_-->`;
}

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * The custom element tag name.
 */
const TAG_NAME$c = 'drive-out-of-individual-space-banner';
/**
 * An error banner displayed when the user runs out of their Google Drive's
 * individual quota. This is only shown if the user has navigated to the My
 * drive under the Google Drive root excluding other directories such as
 * Computers or Shared drives.
 */
class DriveOutOfIndividualSpaceBanner extends WarningBanner {
    /**
     * Returns the HTML template for this banner.
     */
    getTemplate() {
        const template = document.createElement('template');
        template.innerHTML = getTemplate$e();
        const fragment = template.content.cloneNode(true);
        return fragment;
    }
    /**
     * Only show the banner when the user has navigated to the My drive directory
     * and all children. Having root and type means this error does not show on
     * Shared drives, Team drives, Computers or Offline.
     */
    allowedVolumes() {
        return [{
                type: VolumeType.DRIVE,
                root: RootType.DRIVE,
            }];
    }
}
customElements.define(TAG_NAME$c, DriveOutOfIndividualSpaceBanner);

function getTemplate$d() {
    return getTrustedHTML `<!--_html_template_start_--><style>
  warning-banner {
    --icon-bg: var(--cros-sys-on_error_container);
    --icon-holder-bg: var(--cros-sys-error_container);
    --icon-src: url(/foreground/images/files/ui/error_banner_icon.svg);
  }
</style>
<warning-banner role="banner" class="tast-drive-out-of-organization-space">
  <span slot="text"></span>
  <cr-button slot="extra-button" href="$i18n{GOOGLE_DRIVE_MANAGE_STORAGE_URL}">
    $i18n{LEARN_MORE_LABEL}
  </cr-button>
</warning-banner>
<!--_html_template_end_-->`;
}

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * The custom element tag name.
 */
const TAG_NAME$b = 'drive-out-of-organization-space-banner';
/**
 * An error banner displayed when the user's Google Drive organization runs
 * out of quota. This is only shown if the user has navigated to the My drive
 * under the Google Drive root excluding other directories such as Computers or
 * Shared drives.
 */
class DriveOutOfOrganizationSpaceBanner extends WarningBanner {
    /**
     * Returns the HTML template for this banner.
     */
    getTemplate() {
        const template = document.createElement('template');
        template.innerHTML = getTemplate$d();
        const fragment = template.content.cloneNode(true);
        return fragment;
    }
    /**
     * Only show the banner when the user has navigated to the My drive directory
     * and all children. Having root and type means this error does not show on
     * Shared drives, Team drives, Computers or Offline.
     */
    allowedVolumes() {
        return [{
                type: VolumeType.DRIVE,
                root: RootType.DRIVE,
            }];
    }
    /**
     * When the custom filter shows this banner in the controller, it passes the
     * context to the banner.
     */
    onFilteredContext(context) {
        if (context === undefined || context.organizationName === undefined) {
            console.warn('Context not supplied or missing data');
            return;
        }
        const message = strf('DRIVE_ORGANIZATION_QUOTA_OVER', context.organizationName);
        const warning = str('DRIVE_WARNING_QUOTA_OVER');
        const originalSpan = this.shadowRoot.querySelector('span[slot="text"]');
        const replacementSpan = document.createElement('span');
        replacementSpan.setAttribute('slot', 'text');
        replacementSpan.setAttribute('aria-label', `${warning}: ${message}`);
        const replacementSpanInner = document.createElement('span');
        replacementSpanInner.setAttribute('aria-hidden', 'true');
        replacementSpanInner.textContent = message;
        replacementSpan.appendChild(replacementSpanInner);
        originalSpan.replaceWith(replacementSpan);
    }
}
customElements.define(TAG_NAME$b, DriveOutOfOrganizationSpaceBanner);

function getTemplate$c() {
    return getTrustedHTML `<!--_html_template_start_--><style>
  warning-banner {
    --icon-bg: var(--cros-sys-on_error_container);
    --icon-holder-bg: var(--cros-sys-error_container);
    --icon-src: url(/foreground/images/files/ui/error_banner_icon.svg);
  }
</style>
<warning-banner role="banner" class="tast-drive-out-of-shared-drive-space">
  <span slot="text" aria-label="$i18n{DRIVE_WARNING_QUOTA_OVER}: $i18n{DRIVE_SHARED_DRIVE_QUOTA_OVER}">
    <span aria-hidden="true">
      $i18n{DRIVE_SHARED_DRIVE_QUOTA_OVER}
    </span>
  </span>
  <cr-button slot="extra-button" href="$i18n{GOOGLE_DRIVE_MANAGE_STORAGE_URL}">
    $i18n{LEARN_MORE_LABEL}
  </cr-button>
</warning-banner>
<!--_html_template_end_-->`;
}

// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * The custom element tag name.
 */
const TAG_NAME$a = 'drive-out-of-shared-drive-space-banner';
/**
 * An error banner displayed when the user runs out of their Google Drive's
 * individual quota. This is only shown if the user has navigated to the My
 * drive under the Google Drive root excluding other directories such as
 * Computers or Shared drives.
 */
class DriveOutOfSharedDriveSpaceBanner extends WarningBanner {
    /**
     * Returns the HTML template for this banner.
     */
    getTemplate() {
        const template = document.createElement('template');
        template.innerHTML = getTemplate$c();
        const fragment = template.content.cloneNode(true);
        return fragment;
    }
    /**
     * Only show the banner when the user has navigated to the My drive directory
     * and all children. Having root and type means this error does not show on
     * Shared drives, Team drives, Computers or Offline.
     */
    allowedVolumes() {
        return [{
                type: VolumeType.DRIVE,
                root: RootType.SHARED_DRIVE,
            }];
    }
}
customElements.define(TAG_NAME$a, DriveOutOfSharedDriveSpaceBanner);

function getTemplate$b() {
    return getTrustedHTML `<!--_html_template_start_--><style>
  educational-banner {
    --feature-icon-src: url(/foreground/images/files/ui/drive_logo.svg);
  }
</style>
<educational-banner>
  <span slot="title">$i18n{DRIVE_WELCOME_TITLE}</span>
  <span slot="subtitle">$i18n{DRIVE_WELCOME_TEXT_SHORT_FILESNG}</span>
  <cr-button slot="extra-button" href="$i18n{GOOGLE_DRIVE_OVERVIEW_URL}" id="drive-learn-more-button">
    $i18n{DRIVE_LEARN_MORE}
  </cr-button>
</educational-banner>
<!--_html_template_end_-->`;
}

// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * The custom element tag name.
 */
const TAG_NAME$9 = 'drive-welcome-banner';
/**
 * A banner that shows when a user navigates to the Google Drive volume. This
 * banner appears for all children of the Google Drive root (e.g. My Drive,
 * Shared with me, Offline etc.)
 */
class DriveWelcomeBanner extends EducationalBanner {
    /**
     * Returns the HTML template for the Drive Welcome educational banner.
     */
    getTemplate() {
        const template = document.createElement('template');
        template.innerHTML = getTemplate$b();
        const fragment = template.content.cloneNode(true);
        return fragment;
    }
    /**
     * Only show the banner when the user has navigated to the Drive volume type.
     */
    allowedVolumes() {
        return [{
                type: VolumeType.DRIVE,
                root: RootType.DRIVE,
            }];
    }
}
customElements.define(TAG_NAME$9, DriveWelcomeBanner);

function getTemplate$a() {
    return getTrustedHTML `<!--_html_template_start_--><warning-banner role="banner">
    <span slot="text"></span>
</warning-banner>
<!--_html_template_end_-->`;
}

// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * The custom element tag name.
 */
const TAG_NAME$8 = 'files-migrating-to-cloud-banner';
/**
 * A banner that shows a warning when SkyVault policies are set and the user
 * still has some files stored locally that are being moved to the cloud. It's
 * only shown in local directories (My Files/).
 */
class FilesMigratingToCloudBanner extends WarningBanner {
    /**
     * Returns the HTML template for this banner.
     */
    getTemplate() {
        const template = document.createElement('template');
        template.innerHTML = getTemplate$a();
        const fragment = template.content.cloneNode(true);
        return fragment;
    }
    /**
     * Persist the banner at all times.
     */
    timeLimit() {
        return BANNER_INFINITE_TIME;
    }
    /**
     * The context contains SkyVault migration destination, and in case of Delete
     * option, the scheduled start time.
     */
    onFilteredContext(context) {
        if (isNullOrUndefined(context) ||
            isNullOrUndefined(context.migrationDestination)) {
            console.warn('Context not supplied or defaultLocation key missing.');
            return;
        }
        if (context.migrationDestination ===
            chrome.fileManagerPrivate.MigrationDestination.DELETE &&
            isNullOrUndefined(context.migrationStartTime)) {
            console.warn('Start time not supplied for the delete banner.');
            return;
        }
        const text = this.shadowRoot.querySelector('span[slot="text"]');
        switch (context.migrationDestination) {
            case chrome.fileManagerPrivate.MigrationDestination.GOOGLE_DRIVE:
                text.innerText = str('SKYVAULT_MIGRATION_BANNER_GOOGLE_DRIVE');
                return;
            case chrome.fileManagerPrivate.MigrationDestination.ONEDRIVE:
                text.innerText = str('SKYVAULT_MIGRATION_BANNER_ONEDRIVE');
                return;
            case chrome.fileManagerPrivate.MigrationDestination.DELETE:
                text.innerText =
                    strf('SKYVAULT_DELETION_BANNER', context.migrationStartTime);
                return;
            case chrome.fileManagerPrivate.MigrationDestination.NOT_SPECIFIED:
                console.warn(`Cloud provider must be specified.`);
        }
    }
    /**
     * Only show the banner when the user has navigated to a local volume.
     */
    allowedVolumes() {
        return [
            { type: VolumeType.DOWNLOADS },
            { type: VolumeType.MY_FILES },
        ];
    }
}
customElements.define(TAG_NAME$8, FilesMigratingToCloudBanner);

function getTemplate$9() {
    return getTrustedHTML `<!--_html_template_start_--><style>
    educational-banner {
        --feature-icon-src: url(/foreground/images/files/ui/drive_logo.svg);
    }
</style>
<educational-banner>
    <!-- Google One Offer banner is enabled only for en-*. It will be configured by the server. -->
    <span slot="title">Get 100GB of cloud storage</span>
    <span slot="subtitle">Keep your files backed up with 12 months of Google One at no charge</span>
    <cr-button slot="extra-button" href="https://www.google.com/chromebook/perks/?id=google.one.2019" dismiss-banner-when-clicked>Claim now</cr-button>
</educational-banner>
<!--_html_template_end_-->`;
}

// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview The Google One banner highlights the benefit for Chromebook
 * users when navigating to Drive.
 */
/**
 * The custom element tag name.
 */
const TAG_NAME$7 = 'google-one-offer-banner';
/**
 * User actions of GoogleOneOfferBanner.
 */
var UserActions;
(function (UserActions) {
    UserActions["SHOWN"] = "GoogleOneOffer.Shown";
    UserActions["GET_PERK"] = "GoogleOneOffer.GetPerk";
    UserActions["DISMISS"] = "GoogleOneOffer.Dismiss";
})(UserActions || (UserActions = {}));
/**
 * GoogleOneOfferBanner shows when the user navigates to the Google Drive
 * volume. This banner will be shown instead of DriveWelcomeBanner if
 * GoogleOneOfferFilesBanner flag is on.
 */
class GoogleOneOfferBanner extends EducationalBanner {
    /**
     * Returns the HTML template for the Google One offer educational banner.
     */
    getTemplate() {
        const template = document.createElement('template');
        template.innerHTML = getTemplate$9();
        const fragment = template.content.cloneNode(true);
        return fragment;
    }
    /**
     * Only show the banner when the user has navigated to the Drive volume type.
     */
    allowedVolumes() {
        return [{
                type: VolumeType.DRIVE,
                root: RootType.DRIVE,
            }];
    }
    /**
     * Called when the banner gets connected to the DOM.
     */
    connectedCallback() {
        super.connectedCallback();
        const getPerkButton = this.shadowRoot.querySelector('[slot="extra-button"]');
        if (getPerkButton) {
            getPerkButton.addEventListener('click', (_) => this.onGetPerkButtonClickHandler_());
        }
        this.addEventListener(BannerEvent.BANNER_DISMISSED_FOREVER, (event) => this.onBannerDismissedForever_(event));
    }
    /**
     * Called when the banner gets shown in the UI.
     */
    onShow() {
        recordUserAction(UserActions.SHOWN);
    }
    /**
     * Called when the get perk button gets clicked.
     */
    onGetPerkButtonClickHandler_() {
        recordUserAction(UserActions.GET_PERK);
    }
    /**
     * Called when DismissedForeverEvent gets dispatched for this banner. Note
     * that the event can gets dispatched for dismiss caused by a click of get
     * perk button.
     */
    onBannerDismissedForever_(event) {
        // UserActions.DISMISS should not be recorded for dismiss caused by a click
        // of the get perk button.
        if (event.detail.eventSource === DismissedForeverEventSource.EXTRA_BUTTON) {
            return;
        }
        recordUserAction(UserActions.DISMISS);
    }
}
customElements.define(TAG_NAME$7, GoogleOneOfferBanner);

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview Utility methods for the holding space feature.
 */
/**
 * Key in localStorage to store the time (in milliseconds) of the first pin to
 * holding space.
 */
const TIME_OF_FIRST_PIN_KEY = 'holdingSpaceTimeOfFirstPin';
/**
 * Key in localStorage to store the time (in milliseconds) of the first showing
 * of the holding space welcome banner.
 */
const TIME_OF_FIRST_WELCOME_BANNER_SHOW_KEY = 'holdingSpaceTimeOfFirstWelcomeBannerShow';
/** Gets the volume types for which the holding space feature is allowed. */
function getAllowedVolumeTypes() {
    return [
        VolumeType.ANDROID_FILES,
        VolumeType.CROSTINI,
        VolumeType.GUEST_OS,
        VolumeType.DRIVE,
        VolumeType.DOWNLOADS,
    ];
}
/**
 * Returns a promise which resolves to the time (in milliseconds) of the first
 * pin to holding space. If no pin has occurred, resolves to `undefined`.
 */
function getTimeOfFirstPin() {
    const key = TIME_OF_FIRST_PIN_KEY;
    return new Promise(resolve => storage.local.get(key, (values) => resolve(values[key])));
}
/**
 * Returns a promise which resolves to the time (in milliseconds) of the first
 * showing of the holding space welcome banner. If no showing has occurred,
 * resolves to `undefined`.
 */
function getTimeOfFirstWelcomeBannerShow() {
    const key = TIME_OF_FIRST_WELCOME_BANNER_SHOW_KEY;
    return new Promise(resolve => storage.local.get(key, (values) => resolve(values[key])));
}
/**
 * If not previously stored, stores now (in milliseconds) as the time of the
 * first pin to holding space.
 */
async function maybeStoreTimeOfFirstPin() {
    const now = Date.now();
    // Time of first pin should only be stored once.
    if (await getTimeOfFirstPin()) {
        return;
    }
    // Store time of first pin.
    storage.local.set({ [TIME_OF_FIRST_PIN_KEY]: now });
    // Record a metric of the interval from the first time the holding space
    // welcome banner was shown to the time of the first pin to holding space.
    // If the welcome banner was not shown prior to the first pin, record zero.
    const timeOfFirstWelcomeBannerShow = await getTimeOfFirstWelcomeBannerShow() || now;
    // We trim the max value to be 2^31 - 1, which is the maximum integer value
    // that histograms can record.
    const timeFromFirstWelcomeBannerShowToFirstPin = Math.min(2 ** 31 - 1, now - timeOfFirstWelcomeBannerShow);
    // The histogram will use min values of 1 second and max of 1 day. Note
    // that it's permissible to record values smaller/larger than the min/max
    // and they will fall into the histogram's underflow/overflow bucket
    // respectively.
    const oneSecondInMillis = 1000;
    const oneDayInMillis = 24 * 60 * 60 * 1000;
    recordValue(
    /*name=*/ 'HoldingSpace.TimeFromFirstWelcomeBannerShowToFirstPin', chrome.metricsPrivate.MetricTypeType.HISTOGRAM_LOG, 
    /*min=*/ oneSecondInMillis, 
    /*max=*/ oneDayInMillis, 
    /*buckets=*/ 50, 
    /*value=*/ timeFromFirstWelcomeBannerShowToFirstPin);
}
/**
 * If not previously stored, stores now (in milliseconds) as the time of the
 * first showing of the holding space welcome banner.
 */
async function maybeStoreTimeOfFirstWelcomeBannerShow() {
    const now = Date.now();
    // Time of first show should only be stored once.
    if (await getTimeOfFirstWelcomeBannerShow()) {
        return;
    }
    // Store time of first show.
    storage.local.set({ [TIME_OF_FIRST_WELCOME_BANNER_SHOW_KEY]: now });
}

function getTemplate$8() {
    return getTrustedHTML `<!--_html_template_start_--><style>
  educational-banner {
    --feature-icon-bg: none;
  }

  educational-banner [slot=illustration] {
    --holding-space-svg-color-1: var(--cros-sys-illo-color1-2);
    --holding-space-svg-color-2: var(--cros-sys-illo-color1);
    --holding-space-svg-color-3: var(--cros-sys-illo-color2);
    --holding-space-svg-color-4: var(--cros-sys-illo-color5);
    --holding-space-svg-color-5: var(--cros-sys-illo-color4);
  }

  .tablet-mode-enabled {
    display: none;
  }

  :host-context(body.tablet-mode-enabled) .tablet-mode-disabled {
    display: none;
  }

  :host-context(body.tablet-mode-enabled) .tablet-mode-enabled {
    display: block;
    height: auto;
    line-height: 20px;
  }

  .icon {
    -webkit-mask-image: url(/foreground/images/files/ui/menu_ng.svg);
    -webkit-mask-position: center;
    -webkit-mask-repeat: no-repeat;
    -webkit-mask-size: 100%;
    background-color: var(--cros-sys-on_surface);
    display: inline-block;
    height: 20px;
    vertical-align: middle;
    width: 13px;
  }
</style>
<educational-banner>
  <svg slot="illustration">
    <use xlink:href="/foreground/images/files/ui/holding_space_welcome_image.svg#holding_space"></use>
  </svg>
  <span slot="title">$i18n{HOLDING_SPACE_WELCOME_TITLE}</span>
  <span slot="subtitle" class="tablet-mode-disabled">
    $i18n{HOLDING_SPACE_WELCOME_TEXT}
  </span>
  <span slot="subtitle" class="tablet-mode-enabled">
    $i18nRaw{HOLDING_SPACE_WELCOME_TEXT_IN_TABLET_MODE_HTML}
  </span>
</educational-banner>
<!--_html_template_end_-->`;
}

// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * The custom element tag name.
 */
const TAG_NAME$6 = 'holding-space-welcome-banner';
/**
 * A banner that shows when a user navigates to a volume that allows pinning
 * of files to the shelf. Highlights to the user how to use the Holding space
 * feature.
 */
class HoldingSpaceWelcomeBanner extends EducationalBanner {
    /**
     * Returns the HTML template for the Holding Space Welcome educational banner.
     */
    getTemplate() {
        const template = document.createElement('template');
        template.innerHTML = getTemplate$8();
        const fragment = template.content.cloneNode(true);
        return fragment;
    }
    /**
     * Returns the list of allow volume types remapping over the canonical source
     * at HoldingSpaceUtil.
     */
    allowedVolumes() {
        return getAllowedVolumeTypes().map((type) => {
            if (type === VolumeType.DRIVE) {
                return {
                    type: VolumeType.DRIVE,
                    root: RootType.DRIVE,
                };
            }
            return { type: type };
        });
    }
    /**
     * Store the time the banner was first shown.
     */
    onShow() {
        maybeStoreTimeOfFirstWelcomeBannerShow();
    }
}
customElements.define(TAG_NAME$6, HoldingSpaceWelcomeBanner);

function getTemplate$7() {
    return getTrustedHTML `<!--_html_template_start_--><state-banner>
  <span slot="text">$i18n{UNKNOWN_FILESYSTEM_WARNING}</span>
  <cr-button slot="extra-button" command="#format">
    $i18n{FORMAT_DEVICE_BUTTON_LABEL}
  </cr-button>
</state-banner>
<!--_html_template_end_-->`;
}

// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * The custom element tag name.
 */
const TAG_NAME$5 = 'invalid-usb-filesystem-banner';
/**
 * A banner that shows is a removable device is plugged in and it has a
 * filesystem that is either unknown or unsupported. It includes an action
 * button for the user to format the device.
 */
class InvalidUsbFileSystemBanner extends StateBanner {
    /**
     * Returns the HTML template for this banner.
     */
    getTemplate() {
        const template = document.createElement('template');
        template.innerHTML = getTemplate$7();
        const fragment = template.content.cloneNode(true);
        return fragment;
    }
    /**
     * Only show the banner when the user has navigated to the Removable root type
     * this is used in conjunction with a custom filter to ensure only removable
     * roots with errors are shown the banner.
     */
    allowedVolumes() {
        return [{ root: RootType.REMOVABLE }];
    }
    /**
     * When the custom filter shows this banner in the controller, it passes the
     * context to the banner. This is used to identify if the device has an
     * unsupported OR unknown file system.
     */
    onFilteredContext(context) {
        if (!context || !context.error) {
            console.warn('Context not supplied or error key missing');
            return;
        }
        const text = this.shadowRoot.querySelector('span[slot="text"]');
        if (context.error === VolumeError.UNSUPPORTED_FILESYSTEM) {
            text.innerText = str('UNSUPPORTED_FILESYSTEM_WARNING');
            return;
        }
        text.innerText = str('UNKNOWN_FILESYSTEM_WARNING');
    }
}
customElements.define(TAG_NAME$5, InvalidUsbFileSystemBanner);

function getTemplate$6() {
    return getTrustedHTML `<!--_html_template_start_--><warning-banner>
  <span slot="text">$i18n{DOWNLOADS_DIRECTORY_WARNING}</span>
  <cr-button slot="extra-button" href="$i18n{DOWNLOADS_LOW_SPACE_WARNING_HELP_URL}">
    $i18n{LEARN_MORE_LABEL}
  </cr-button>
  <cr-button slot="dismiss-button" id="dismiss-button">
    $i18n{DRIVE_WELCOME_DISMISS}
  </cr-button>
</warning-banner>
<!--_html_template_end_-->`;
}

// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * The custom element tag name.
 */
const TAG_NAME$4 = 'local-disk-low-space-banner';
/**
 * A banner that shows a warning when the remaining space on a local disk goes
 * below 1GB. This is only shown if the user has navigated to the My files /
 * Downloads directories (and any children).
 */
class LocalDiskLowSpaceBanner extends WarningBanner {
    /**
     * Returns the HTML template for this banner.
     */
    getTemplate() {
        const template = document.createElement('template');
        template.innerHTML = getTemplate$6();
        const fragment = template.content.cloneNode(true);
        return fragment;
    }
    /**
     * Show the banner when the Downloads volume (local disk) is less than or
     * equal to 1 GB of remaining space.
     */
    diskThreshold() {
        return {
            type: RootType.DOWNLOADS,
            minSize: 1 * 1024 * 1024 * 1024, // 1 GB
        };
    }
    /**
     * Only show the banner when the user has navigated to the Downloads volume
     * type (this includes the My files directory).
     */
    allowedVolumes() {
        return [{ type: VolumeType.DOWNLOADS }];
    }
}
customElements.define(TAG_NAME$4, LocalDiskLowSpaceBanner);

function getTemplate$5() {
    return getTrustedHTML `<!--_html_template_start_--><warning-banner role="banner">
    <span slot="text">$i18n{ONEDRIVE_OFFLINE_TITLE}</span>
</warning-banner>
<!--_html_template_end_-->`;
}

// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * The custom element tag name.
 */
const TAG_NAME$3 = 'odfs-offline-banner';
/**
 * A banner to emphasize that OneDrive isn't usable while the device is offline.
 */
class OdfsOfflineBanner extends WarningBanner {
    /**
     * Returns the HTML template for this banner.
     */
    getTemplate() {
        const template = document.createElement('template');
        template.innerHTML = getTemplate$5();
        const fragment = template.content.cloneNode(true);
        return fragment;
    }
    /**
     * Persist the banner at all times.
     */
    timeLimit() {
        return BANNER_INFINITE_TIME;
    }
    /**
     * Only show the banner when the user has navigated to a provided volume.
     */
    allowedVolumes() {
        return [
            { type: VolumeType.PROVIDED },
        ];
    }
}
customElements.define(TAG_NAME$3, OdfsOfflineBanner);

function getTemplate$4() {
    return getTrustedHTML `<!--_html_template_start_--><style>
  educational-banner {
    --feature-icon-src: url(/foreground/images/files/ui/photos_logo.svg);
  }
</style>
<educational-banner>
  <span slot="title">$i18n{PHOTOS_WELCOME_TITLE}</span>
  <span slot="subtitle">$i18n{PHOTOS_WELCOME_TEXT}</span>
</educational-banner>
<!--_html_template_end_-->`;
}

// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * The custom element tag name.
 */
const TAG_NAME$2 = 'photos-welcome-banner';
/**
 * A banner that shows when a user navigates to the Google Photos documents
 * provider. Shows helpful information about using Photos on ChromeOS.
 */
class PhotosWelcomeBanner extends EducationalBanner {
    /**
     * Returns the HTML template for the Google Photos Welcome banner.
     */
    getTemplate() {
        const template = document.createElement('template');
        template.innerHTML = getTemplate$4();
        const fragment = template.content.cloneNode(true);
        return fragment;
    }
    /**
     * Only show the banner when the user has navigated to the Documents Provider
     * volume, specifically the Photos document provider.
     */
    allowedVolumes() {
        return [{
                type: VolumeType.DOCUMENTS_PROVIDER,
                id: PHOTOS_DOCUMENTS_PROVIDER_VOLUME_ID,
            }];
    }
}
customElements.define(TAG_NAME$2, PhotosWelcomeBanner);

function getTemplate$3() {
    return getTrustedHTML `<!--_html_template_start_--><state-banner>
  <span slot="text">$i18n{MESSAGE_FOLDER_SHARED_WITH_CROSTINI_AND_PLUGIN_VM}</span>
  <cr-button slot="extra-button">
    $i18n{MANAGE_TOAST_BUTTON_LABEL}
  </cr-button>
</state-banner>
<!--_html_template_end_-->`;
}

// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * The custom element tag name.
 */
const TAG_NAME$1 = 'shared-with-crostini-pluginvm-banner';
/**
 * A banner that shows if the current navigated directory has been shared with
 * Crostini or PluginVM.
 */
class SharedWithCrostiniPluginVmBanner extends StateBanner {
    /**
     * Returns the HTML template for this banner.
     */
    getTemplate() {
        const template = document.createElement('template');
        template.innerHTML = getTemplate$3();
        const fragment = template.content.cloneNode(true);
        return fragment;
    }
    /**
     * This banner relies on a custom trigger registered in the BannerController
     * and thus the following list are root types where sharing to Crostini or
     * PluginVM is allowed and thus a banner may appear.
     */
    allowedVolumes() {
        return [
            { root: RootType.DOWNLOADS },
            { root: RootType.REMOVABLE },
            { root: RootType.ANDROID_FILES },
            { root: RootType.COMPUTERS_GRAND_ROOT },
            { root: RootType.COMPUTER },
            { root: RootType.DRIVE },
            { root: RootType.SHARED_DRIVES_GRAND_ROOT },
            { root: RootType.SHARED_DRIVE },
            { root: RootType.DRIVE_SHARED_WITH_ME },
            { root: RootType.CROSTINI },
            { root: RootType.ARCHIVE },
            { root: RootType.SMB },
        ];
    }
    /**
     * Persist the banner at all times if the folder is shared.
     */
    timeLimit() {
        return BANNER_INFINITE_TIME;
    }
    /**
     * When the custom filter shows this banner in the controller, it passes the
     * context to the banner. This type is used to identify if this folder is
     * shared with Crostini, PluginVM or both and update the text and links
     * accordingly.
     */
    onFilteredContext(context) {
        if (!context || !context.type) {
            console.warn('Context not supplied or type key missing');
            return;
        }
        const text = this.shadowRoot.querySelector('span[slot="text"]');
        const button = this.shadowRoot.querySelector('cr-button[slot="extra-button"]');
        if (context.type === (DEFAULT_CROSTINI_VM + PLUGIN_VM$1)) {
            text.innerText = str('MESSAGE_FOLDER_SHARED_WITH_CROSTINI_AND_PLUGIN_VM');
            button.setAttribute('href', 'chrome://os-settings/app-management/pluginVm/sharedPaths');
            return;
        }
        if (context.type === PLUGIN_VM$1) {
            text.innerText = str('MESSAGE_FOLDER_SHARED_WITH_PLUGIN_VM');
            button.setAttribute('href', 'chrome://os-settings/app-management/pluginVm/sharedPaths');
            return;
        }
        text.innerText = str('MESSAGE_FOLDER_SHARED_WITH_CROSTINI');
        button.setAttribute('href', 'chrome://os-settings/crostini/sharedPaths');
    }
}
customElements.define(TAG_NAME$1, SharedWithCrostiniPluginVmBanner);

function getTemplate$2() {
    return getTrustedHTML `<!--_html_template_start_--><style>
  state-banner {
    --icon-src: url(/foreground/images/files/ui/delete_ng.svg);
  }
</style>
<state-banner>
  <span slot="text">$i18n{TRASH_DELETED_FOREVER}</span>
  <cr-button slot="extra-button" command="#empty-trash">
    $i18n{EMPTY_TRASH_BUTTON_LABEL}
  </cr-button>
</state-banner>
<!--_html_template_end_-->`;
}

// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * The custom element tag name.
 */
const TAG_NAME = 'trash-banner';
/**
 * A banner that shows users navigating to their Trash directory that files in
 * the Trash directory are automatically removed after 30 days.
 */
class TrashBanner extends StateBanner {
    /**
     * Returns the HTML template for this banner.
     */
    getTemplate() {
        const template = document.createElement('template');
        template.innerHTML = getTemplate$2();
        const fragment = template.content.cloneNode(true);
        return fragment;
    }
    /**
     * Only show the banner when the user has navigated to the Trash rootType.
     */
    allowedVolumes() {
        return [{ root: RootType.TRASH }];
    }
    /**
     * The Trash banner should always be visible in the Trash root.
     */
    timeLimit() {
        return BANNER_INFINITE_TIME;
    }
}
customElements.define(TAG_NAME, TrashBanner);

// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * Local storage key suffix for how many times a banner was shown.
 */
const VIEW_COUNTER_SUFFIX = '_VIEW_COUNTER';
/**
 * Local storage key suffix for the last Date a banner was dismissed.
 */
const LAST_DISMISSED_SUFFIX = '_LAST_DISMISSED';
/**
 * Local storage key suffix that stores the total number of seconds a banner has
 * been visible for.
 */
const MS_DISPLAYED_SUFFIX = '_SECONDS_DISPLAYED';
/**
 * Duration between calls to keep the current banners time limit in sync.
 */
const DURATION_BETWEEN_TIME_LIMIT_UPDATES_MS = 10000;
/**
 * Local storage key suffix for a banner that has been dismissed forever.
 */
const DISMISSED_FOREVER_SUFFIX = '_DISMISSED_FOREVER';
/**
 * The HTML attribute to force show a banner, if applied, the banner will always
 * show.
 */
const _BANNER_FORCE_SHOW_ATTRIBUTE = 'force-show-for-testing';
/**
 * Allowed duration between onDirectorySizeChanged events in milliseconds.
 */
const MIN_INTERVAL_BETWEEN_DIRECTORY_SIZE_CHANGED_EVENTS = 5000;
/**
 * The central component to the Banners Framework. The controller maintains the
 * core logic that dictates which banner should be shown as well as what events
 * require a reconciliation of the banners to ensure the right banner is shown
 * at the right time.
 */
class BannerController extends NativeEventTarget {
    constructor(directoryModel_, volumeManager_, crostini_, dialogType_) {
        super();
        this.directoryModel_ = directoryModel_;
        this.volumeManager_ = volumeManager_;
        this.crostini_ = crostini_;
        this.dialogType_ = dialogType_;
        /**
         * Warning banners ordered by priority. Index 0 is the highest priority.
         */
        this.warningBanners_ = [];
        /**
         * Educational banners ordered by priority. Index 0 is the highest
         * priority.
         */
        this.educationalBanners_ = [];
        /**
         * State banners ordered by priority. Index 0 is the highest priority.
         */
        this.stateBanners_ = [];
        /**
         * Keep track of banners that subscribe to volume changes.
         */
        this.volumeSizeObservers_ = {};
        /**
         * Stores the state of each banner, such as view count or last dismissed
         * time. This is kept in sync with local storage.
         */
        this.localStorageCache_ = {};
        /**
         * Maintains the state of the current volume that has been navigated. This
         * is updated by the directory-changed event.
         */
        this.currentVolume_ = null;
        /**
         * Maintains the currently navigated root type. This is updated by the
         * directory-changed event.
         */
        this.currentRootType_ = null;
        /**
         * Maintains the currently navigated shared drive if any. This is updated
         * when a reconcile event is called.
         */
        this.currentSharedDrive_ = '';
        /**
         * Maintains the currently navigated directory entry. This is updated when
         * a reconcile event is called.
         */
        this.currentEntry_ = undefined;
        /**
         * Maintains a cache of the current size for all observed volumes. If a
         * banner requests to observe a volumeType on initialization, the volume
         * size is cached here, keyed by volumeId.
         */
        this.volumeSizeStats_ = {};
        /**
         * The container where all the banners will be appended to.
         */
        this.container_ = document.querySelector('#banners');
        /**
         * Whether banners should be loaded or not during for unit tests.
         */
        this.disableBannerLoading_ = false;
        /**
         * Whether banners should be completely disabled, useful to remove banners
         * during integration tests or tast tests.
         */
        this.disableBanners_ = false;
        /**
         * A single banner to isolate and test it's functionality. Denoted by it's
         * tagName (in uppercase).
         */
        this.isolatedBannerForTesting_ = null;
        /**
         * setInterval handle that keeps track of the total time a banner has
         * been shown for.
         */
        this.timeLimitInterval_ = undefined;
        /**
         * Last time that the setInterval was invoked.
         */
        this.timeLimitIntervalLastInvokedMs_ = null;
        /**
         * An object keyed by a banners tagName (in upper case) that lists custom
         * filters for the specified banner. Used to house banner specific logic
         * that can decide whether to display a banner or not.
         */
        this.customBannerFilters_ = {};
        /**
         * The instance of the store.
         */
        this.store_ = getStore();
        /**
         * Cached value of `this.store_.currentDirectory.hasDisabledFiles`, to avoid
         * unnecessary reconciling.
         */
        this.hasDlpDisabledFiles_ = false;
        /**
         * The volumeId that is pending a volume size update, updateVolumeSizeStats_
         * will remove the volumeId once updated. This is cleared when the debounced
         * version of updateVolumeSizeStats_ executes.
         */
        this.pendingVolumeSizeUpdates_ = new Set();
        /**
         * Bind the onDirectorySizeChanged_ method to this instance once.
         */
        this.onDirectorySizeChangedBound_ = async (event) => this.onDirectorySizeChanged_(event);
        /**
         * Debounced version of updateVolumeSizeStats_ to stop overly aggressive
         * calls coming from onDirectoryChanged_.
         */
        this.updateVolumeSizeStatsDebounced_ = new RateLimiter(async () => this.updateVolumeSizeStats_(), MIN_INTERVAL_BETWEEN_DIRECTORY_SIZE_CHANGED_EVENTS);
        /**
         * Whether the Drive bulk-pinning feature is available on this device.
         */
        this.bulkPinningAvailable_ = false;
        /**
         * Whether the Drive bulk-pinning feature is currently enabled.
         */
        this.bulkPinningEnabled_ = false;
        /**
         * SkyVault migration destination. If set, one of {Google Drive, OneDrive,
         * Delete}.
         */
        this.migrationDestination_ = chrome.fileManagerPrivate.MigrationDestination.NOT_SPECIFIED;
        /**
         * SkyVault migration or deletion start time.
         */
        this.migrationStartTime_ = undefined;
        // Ensure changes are received for store updates.
        this.store_.subscribe(this);
        // Only attach event listeners if the controller is enabled. Used to disable
        // all banners from being loaded.
        if (!this.disableBanners_) {
            storage.onChanged.addListener(this.onStorageChanged_.bind(this));
            this.directoryModel_.addEventListener('directory-changed', (_event) => this.onDirectoryChanged_());
        }
        chrome.fileManagerPrivate.onPreferencesChanged.addListener(this.onPreferencesChanged_.bind(this));
        this.onPreferencesChanged_();
        slice.selector.subscribe(this.reconcile.bind(this));
    }
    onPreferencesChanged_() {
        chrome.fileManagerPrivate.getPreferences(pref => {
            if (this.bulkPinningAvailable_ !== pref.driveFsBulkPinningAvailable ||
                this.bulkPinningEnabled_ !== pref.driveFsBulkPinningEnabled ||
                this.migrationDestination_ !== pref.skyVaultMigrationDestination ||
                this.migrationStartTime_ !== pref.skyVaultMigrationStartTime) {
                this.bulkPinningAvailable_ = pref.driveFsBulkPinningAvailable;
                this.bulkPinningEnabled_ = pref.driveFsBulkPinningEnabled;
                this.migrationDestination_ = pref.skyVaultMigrationDestination;
                this.migrationStartTime_ = pref.skyVaultMigrationStartTime;
                this.reconcile();
            }
        });
    }
    /**
     * Checks if the DlpRestrictedBanner should be shown/hidden based on the
     * latest state and reconciles banners if necessary.
     */
    onStateChanged(state) {
        if (this.dialogType_ !== DialogType.SELECT_OPEN_FILE &&
            this.dialogType_ !== DialogType.SELECT_OPEN_MULTI_FILE) {
            return;
        }
        const changedHasDlpDisabledFiles = !!state.currentDirectory?.hasDlpDisabledFiles;
        if (this.hasDlpDisabledFiles_ !== changedHasDlpDisabledFiles) {
            this.hasDlpDisabledFiles_ = changedHasDlpDisabledFiles;
            this.reconcile();
        }
    }
    /**
     * Ensure all banners are in priority order and any existing local storage
     * values are retrieved.
     */
    async initialize() {
        if (!this.disableBannerLoading_) {
            // Banners are initialized in their priority order. The order of the array
            // denotes the priority of the banner, 0th index is highest priority.
            this.setWarningBannersInOrder([
                TAG_NAME$8,
                TAG_NAME$3,
                TAG_NAME$4,
                TAG_NAME$b,
                TAG_NAME$a,
                TAG_NAME$c,
                TAG_NAME$f,
                TAG_NAME$e,
            ]);
            const educationalBanners = isGoogleOneOfferFilesBannerEligibleAndEnabled() ?
                [TAG_NAME$7] :
                [TAG_NAME$9];
            educationalBanners.push(TAG_NAME$g);
            educationalBanners.push(TAG_NAME$6);
            educationalBanners.push(TAG_NAME$d);
            educationalBanners.push(TAG_NAME$2);
            this.setEducationalBannersInOrder(educationalBanners);
            this.setStateBannersInOrder([
                TAG_NAME$h,
                TAG_NAME$5,
                TAG_NAME$1,
                TAG_NAME,
            ]);
            // Register custom filters that verify whether the currently navigated
            // path is shared with Crostini, PluginVM or both.
            this.registerCustomBannerFilter(TAG_NAME$1, {
                shouldShow: () => isPathSharedWithVm(this.crostini_, this.currentEntry_, DEFAULT_CROSTINI_VM) &&
                    isPathSharedWithVm(this.crostini_, this.currentEntry_, PLUGIN_VM$1),
                context: () => ({ type: DEFAULT_CROSTINI_VM + PLUGIN_VM$1 }),
            });
            this.registerCustomBannerFilter(TAG_NAME$1, {
                shouldShow: () => isPathSharedWithVm(this.crostini_, this.currentEntry_, DEFAULT_CROSTINI_VM),
                context: () => ({ type: DEFAULT_CROSTINI_VM }),
            });
            this.registerCustomBannerFilter(TAG_NAME$1, {
                shouldShow: () => isPathSharedWithVm(this.crostini_, this.currentEntry_, PLUGIN_VM$1),
                context: () => ({ type: PLUGIN_VM$1 }),
            });
            this.registerCustomBannerFilter(TAG_NAME$g, {
                shouldShow: () => this.bulkPinningAvailable_ && !this.bulkPinningEnabled_,
                context: () => ({}),
            });
            this.registerCustomBannerFilter(TAG_NAME$d, {
                shouldShow: () => !this.bulkPinningAvailable_,
                context: () => ({}),
            });
            // Register a custom filter that passes the current size stats down to the
            // the Drive banner only if the volume stats are available. The general
            // volume available handler will run before this ensuring the minimum
            // ratio has been met.
            const notOutOfSpace = () => this.driveQuotaMetadata_ &&
                this.driveQuotaMetadata_.usedBytes <
                    this.driveQuotaMetadata_.totalBytes &&
                this.driveQuotaMetadata_.totalBytes >= 0; // not unlimited
            const outOfSpace = () => this.driveQuotaMetadata_ &&
                this.driveQuotaMetadata_.usedBytes >=
                    this.driveQuotaMetadata_.totalBytes &&
                this.driveQuotaMetadata_.totalBytes >= 0; // not unlimited
            this.registerCustomBannerFilter(TAG_NAME$f, {
                shouldShow: notOutOfSpace,
                context: () => this.driveQuotaMetadata_,
            });
            this.registerCustomBannerFilter(TAG_NAME$c, {
                shouldShow: outOfSpace,
                context: () => ({}),
            });
            this.registerCustomBannerFilter(TAG_NAME$b, {
                shouldShow: () => this.driveQuotaMetadata_ &&
                    this.driveQuotaMetadata_.organizationLimitExceeded,
                context: () => this.driveQuotaMetadata_,
            });
            this.registerCustomBannerFilter(TAG_NAME$e, {
                shouldShow: notOutOfSpace,
                context: () => this.driveQuotaMetadata_,
            });
            this.registerCustomBannerFilter(TAG_NAME$a, {
                shouldShow: outOfSpace,
                context: () => ({}),
            });
            // Register a custom filter that checks if the removable device has an
            // error and show the invalid USB file system banner.
            this.registerCustomBannerFilter(TAG_NAME$5, {
                shouldShow: () => !!(this.currentVolume_?.error),
                context: () => ({ error: this.currentVolume_?.error }),
            });
            // Register a custom filter that checks if DLP restricted banner should
            // be shown.
            this.registerCustomBannerFilter(TAG_NAME$h, {
                shouldShow: () => (this.volumeManager_.hasDisabledVolumes() ||
                    this.hasDlpDisabledFiles_),
                context: () => ({ type: this.dialogType_ }),
            });
            this.registerCustomBannerFilter(TAG_NAME$8, {
                shouldShow: () => this.migrationDestination_ !==
                    chrome.fileManagerPrivate.MigrationDestination.NOT_SPECIFIED,
                context: () => ({
                    migrationDestination: this.migrationDestination_,
                    migrationStartTime: this.migrationStartTime_,
                }),
            });
            this.registerCustomBannerFilter(TAG_NAME$3, {
                shouldShow: () => {
                    if (!isSkyvaultV2Enabled()) {
                        return false;
                    }
                    if (!this.currentVolume_) {
                        return false;
                    }
                    return isOneDrive(this.currentVolume_) &&
                        (this.store_.getState().device.connection ===
                            chrome.fileManagerPrivate.DeviceConnectionState.OFFLINE);
                },
                context: () => ({}),
            });
        }
        for (const banner of this.warningBanners_) {
            this.localStorageCache_[`${banner.tagName}_${LAST_DISMISSED_SUFFIX}`] = 0;
            this.localStorageCache_[`${banner.tagName}_${MS_DISPLAYED_SUFFIX}`] = 0;
            this.localStorageCache_[`${banner.tagName}_${VIEW_COUNTER_SUFFIX}`] = 0;
            this.maybeAddVolumeSizeObserver_(banner);
        }
        for (const banner of this.educationalBanners_) {
            this.localStorageCache_[`${banner.tagName}_${MS_DISPLAYED_SUFFIX}`] = 0;
            this.localStorageCache_[`${banner.tagName}_${VIEW_COUNTER_SUFFIX}`] = 0;
            this.localStorageCache_[`${banner.tagName}_${DISMISSED_FOREVER_SUFFIX}`] =
                0;
            this.maybeAddVolumeSizeObserver_(banner);
        }
        for (const banner of this.stateBanners_) {
            this.localStorageCache_[`${banner.tagName}_${MS_DISPLAYED_SUFFIX}`] = 0;
            this.localStorageCache_[`${banner.tagName}_${VIEW_COUNTER_SUFFIX}`] = 0;
            this.maybeAddVolumeSizeObserver_(banner);
        }
        const cacheKeys = Object.keys(this.localStorageCache_);
        let values = {};
        try {
            values = await storage.local.getAsync(cacheKeys);
        }
        catch (e) {
            console.warn(e.message);
        }
        for (const key of cacheKeys) {
            const storedValue = parseInt(values[key], 10);
            if (storedValue) {
                this.localStorageCache_[key] = storedValue;
            }
        }
    }
    /**
     * Loops through all the banners and checks whether they should be shown or
     * not. If shown, picks the highest priority banner.
     */
    async reconcile() {
        const previousVolume = this.currentVolume_;
        const previousSharedDrive = this.currentSharedDrive_;
        this.currentEntry_ = this.directoryModel_.getCurrentDirEntry();
        if (this.currentEntry_) {
            this.currentSharedDrive_ = getTeamDriveName(this.currentEntry_);
        }
        this.currentRootType_ = this.directoryModel_.getCurrentRootType();
        this.currentVolume_ = this.directoryModel_.getCurrentVolumeInfo();
        // When navigating to a different volume, refresh the volume size stats
        // when first navigating. A listener will keep this in sync.
        const volumeChanged = this.currentVolume_ &&
            previousVolume?.volumeId !== this.currentVolume_.volumeId &&
            this.volumeSizeObservers_[this.currentVolume_.volumeType];
        const sharedDriveChanged = this.currentSharedDrive_ !== previousSharedDrive;
        if (volumeChanged || sharedDriveChanged) {
            if (this.currentVolume_) {
                this.pendingVolumeSizeUpdates_.add(this.currentVolume_);
            }
            this.updateVolumeSizeStatsDebounced_.runImmediately();
            // updateVolumeSizeStats will call reconcile at its end. Return here to
            // avoid calling showBanner_ twice for a banner.
            return;
        }
        let bannerToShow = null;
        // Identify if (given current conditions) any of the banners should be shown
        // or hidden.
        const orderedBanners = this.warningBanners_.concat(this.educationalBanners_, this.stateBanners_);
        for (const banner of orderedBanners) {
            if (!this.shouldShowBanner_(banner)) {
                this.hideBannerIfShown_(banner);
                continue;
            }
            // If a higher priority banner has been chosen, hide any lower priority
            // banners that may already be showing.
            if (bannerToShow) {
                this.hideBannerIfShown_(banner);
                continue;
            }
            bannerToShow = banner;
        }
        if (bannerToShow) {
            await this.showBanner_(bannerToShow);
        }
    }
    /**
     * Checks if the banner should be visible.
     */
    shouldShowBanner_(banner) {
        if (banner.hasAttribute(_BANNER_FORCE_SHOW_ATTRIBUTE)) {
            return true;
        }
        // If a banner has been isolated to be shown for testing, all other banners
        // should not show. The isolated baner should still ensure it should be
        // displayed.
        if (this.isolatedBannerForTesting_ &&
            this.isolatedBannerForTesting_ !== banner.tagName) {
            return false;
        }
        // Check if the banner should be shown on this particular volume type.
        const allowedVolumes = banner.allowedVolumes();
        if (!isAllowedVolume(this.currentVolume_, this.currentRootType_, allowedVolumes)) {
            return false;
        }
        // Check if the banner has been dismissed forever.
        if (this.localStorageCache_[`${banner.tagName}_${DISMISSED_FOREVER_SUFFIX}`] === 1) {
            return false;
        }
        // Check if the banner has exceeded the maximum number of times it can be
        // shown over multiple Files app sessions.
        const showLimit = banner.showLimit && banner.showLimit();
        if (showLimit) {
            const timesShown = this.localStorageCache_[`${banner.tagName}_${VIEW_COUNTER_SUFFIX}`];
            if (timesShown && (timesShown >= showLimit) && !banner.isConnected) {
                return false;
            }
        }
        // Check if the threshold has been breached for the banner to be shown.
        const diskThreshold = banner.diskThreshold && banner.diskThreshold();
        if (diskThreshold) {
            const currentVolumeSizeStats = this.currentVolume_ &&
                this.volumeSizeStats_[this.currentVolume_.volumeId];
            if (!isBelowThreshold(diskThreshold, currentVolumeSizeStats)) {
                return false;
            }
        }
        // Check if the banner has previously been dismissed and should not be shown
        // for a set duration. Date.now returns in milliseconds so convert seconds
        // into milliseconds.
        const hideAfterDismissedDurationSeconds = banner.hideAfterDismissedDurationSeconds &&
            (banner.hideAfterDismissedDurationSeconds() * 1000);
        const lastDismissedMilliseconds = this.localStorageCache_[`${banner.tagName}_${LAST_DISMISSED_SUFFIX}`];
        if (hideAfterDismissedDurationSeconds &&
            (lastDismissedMilliseconds &&
                ((Date.now() - lastDismissedMilliseconds) <
                    hideAfterDismissedDurationSeconds))) {
            return false;
        }
        // Check if the banner has been shown for more than it's required limit.
        // Date.now returns in milliseconds so convert seconds into milliseconds.
        const timeLimitMs = banner.timeLimit && (banner.timeLimit() * 1000);
        const totalTimeShownMs = this.localStorageCache_[`${banner.tagName}_${MS_DISPLAYED_SUFFIX}`];
        if (timeLimitMs && (totalTimeShownMs && timeLimitMs < totalTimeShownMs)) {
            return false;
        }
        // See if the banner has any custom filters assigned, if the shouldShow
        // method returns true, the banner should be shown and the context is passed
        // to the banner in preparation.
        if (this.customBannerFilters_[banner.tagName]) {
            let shownFilter = false;
            for (const bannerFilter of this.customBannerFilters_[banner.tagName]) {
                if (bannerFilter.shouldShow()) {
                    if (banner.onFilteredContext) {
                        banner.onFilteredContext(bannerFilter.context());
                    }
                    shownFilter = true;
                    break;
                }
            }
            if (!shownFilter) {
                return false;
            }
        }
        return true;
    }
    /**
     * Check if the banner exists (add to DOM if not) and ensure it's visible.
     */
    async showBanner_(banner) {
        if (!banner.isConnected) {
            this.container_.appendChild(banner);
            // Views are set when the banner is first appended to the DOM. This
            // denotes a new app session.
            if (banner.showLimit && banner.showLimit()) {
                const localStorageKey = `${banner.tagName}_${VIEW_COUNTER_SUFFIX}`;
                await this.setLocalStorage_(localStorageKey, (this.localStorageCache_[localStorageKey] || 0) + 1);
            }
        }
        // If the banner to be shown needs to checkpoint it's time shown, start
        // the checkpoint interval.
        this.resetTimeLimitInterval_();
        if (banner.timeLimit &&
            (banner.timeLimit() && banner.timeLimit() !== BANNER_INFINITE_TIME)) {
            this.timeLimitInterval_ = setInterval(() => this.updateTimeLimit(banner), DURATION_BETWEEN_TIME_LIMIT_UPDATES_MS);
        }
        banner.removeAttribute('hidden');
        banner.setAttribute('aria-hidden', 'false');
        banner.onShow && banner.onShow();
    }
    /**
     * Hide the banner if it exists in the DOM.
     */
    hideBannerIfShown_(banner) {
        if (!banner.isConnected) {
            return;
        }
        this.resetTimeLimitInterval_();
        banner.toggleAttribute('hidden', true);
        banner.setAttribute('aria-hidden', 'true');
    }
    /**
     * If the banner implements diskThreshold, add the banner to the observers of
     * volume size for the specified volumeType.
     */
    maybeAddVolumeSizeObserver_(banner) {
        if (!banner.diskThreshold || !banner.diskThreshold()) {
            return;
        }
        const diskThreshold = banner.diskThreshold();
        if (!this.volumeSizeObservers_[diskThreshold.type]) {
            this.volumeSizeObservers_[diskThreshold.type] = [];
        }
        this.volumeSizeObservers_[diskThreshold.type].push(banner);
    }
    /**
     * Creates all the warning banners with the supplied tagName's. This will
     * populate the warningBanners_ array with HTMLElement's.
     */
    setWarningBannersInOrder(bannerTagNames) {
        for (const tagName of bannerTagNames) {
            const banner = document.createElement(tagName);
            banner.toggleAttribute('hidden', true);
            banner.setAttribute('aria-hidden', 'true');
            banner.addEventListener(BannerEvent.BANNER_DISMISSED, event => this.onBannerDismissedClick_(event));
            this.warningBanners_.push(banner);
        }
    }
    /**
     * Creates all the educational banners with the supplied tagName's. This will
     * populate the educationalBanners_ array with HTMLElement's.
     */
    setEducationalBannersInOrder(bannerTagNames) {
        for (const tagName of bannerTagNames) {
            const banner = document.createElement(tagName);
            banner.toggleAttribute('hidden', true);
            banner.setAttribute('aria-hidden', 'true');
            banner.addEventListener(BannerEvent.BANNER_DISMISSED_FOREVER, event => this.onBannerDismissedClick_(event));
            this.educationalBanners_.push(banner);
        }
    }
    /**
     * Creates all the state banners with the supplied tagName's. This will
     * populate the stateBanners_ array with HTMLElement's.
     */
    setStateBannersInOrder(bannerTagNames) {
        for (const tagName of bannerTagNames) {
            const banner = document.createElement(tagName);
            banner.toggleAttribute('hidden', true);
            banner.setAttribute('aria-hidden', 'true');
            this.stateBanners_.push(banner);
        }
    }
    /**
     * Disable the banners entirely from executing
     */
    disableBannersForTesting() {
        this.disableBanners_ = true;
    }
    /**
     * Disable the banners from being loaded for testing. This is used to override
     * the loading of actual banners to load fake banners in unit tests.
     */
    disableBannerLoadingForTesting() {
        this.disableBannerLoading_ = true;
    }
    /**
     * Isolates a banner from the priority list for testing. Used to test
     * functionality of a specific banner in integration tests.
     */
    async isolateBannerForTesting(bannerTagName) {
        const tagName = bannerTagName.toUpperCase();
        this.isolatedBannerForTesting_ = tagName;
        await this.reconcile();
    }
    /**
     * Clears the time interval and resets the tracked interval and time in ms
     * back to null.
     * @private
     */
    resetTimeLimitInterval_() {
        clearInterval(this.timeLimitInterval_);
        this.timeLimitInterval_ = undefined;
        this.timeLimitIntervalLastInvokedMs_ = null;
    }
    /**
     * Toggles force show a single banner. If multiple banners are force shown
     * the banner with the highest priority will still be the only one shown.
     */
    async toggleBannerForTesting(bannerTagName) {
        const orderedBanners = this.warningBanners_.concat(this.educationalBanners_, this.stateBanners_);
        for (const banner of orderedBanners) {
            if (banner.tagName === bannerTagName) {
                banner.toggleAttribute(_BANNER_FORCE_SHOW_ATTRIBUTE);
                await this.reconcile();
                return;
            }
        }
        console.warn(`${bannerTagName} not found in initialized banners`);
    }
    /**
     * Create an event handler bound to the specific banner that was created.
     */
    async onBannerDismissedClick_(event) {
        if (!event.detail || !event.detail.banner) {
            console.warn('Banner dismiss event missing banner detail');
            return;
        }
        const banner = event.detail.banner;
        // If the banner has been dismissed forever (in the case of educational
        // banners) set the localStorage value to be 1.
        if (event.type === BannerEvent.BANNER_DISMISSED_FOREVER) {
            this.setLocalStorage_(`${banner.tagName}_${DISMISSED_FOREVER_SUFFIX}`, 1);
        }
        else if (event.type === BannerEvent.BANNER_DISMISSED) {
            // Reset the view counter so that after the dismiss duration elapses the
            // banner can be shown for the showLimit again.
            this.setLocalStorage_(`${banner.tagName}_${VIEW_COUNTER_SUFFIX}`, 0);
            this.setLocalStorage_(`${banner.tagName}_${LAST_DISMISSED_SUFFIX}`, Date.now());
        }
        await this.reconcile();
    }
    /**
     * Writes through the localStorage cache to local storage to ensure values
     * are immediately available.
     */
    async setLocalStorage_(key, value) {
        if (!this.localStorageCache_.hasOwnProperty(key)) {
            console.warn(`Key ${key} not found in localStorage cache`);
            return;
        }
        this.localStorageCache_[key] = value;
        try {
            await storage.local.setAsync({ [key]: value });
        }
        catch (e) {
            console.warn(e.message);
        }
    }
    /**
     * Registers a custom filter against the specified banner tagName.
     */
    registerCustomBannerFilter(bannerTagName, filter) {
        // Canonical tagNames are retrieved from the DOM element which transforms
        // them into uppercase (they are supplied in lowercase, as required by the
        // customElement registry).
        const tagName = bannerTagName.toUpperCase();
        if (!this.customBannerFilters_[tagName]) {
            this.customBannerFilters_[tagName] = [];
        }
        this.customBannerFilters_[tagName].push(filter);
    }
    /**
     * Invoked when a directory has been changed, used to update the local cache
     * and reconcile the current banners being shown.
     */
    async onDirectoryChanged_() {
        const previousVolume = this.currentVolume_;
        await this.reconcile();
        // Don't change subscriptions if the volume hasn't changed.
        if (this.currentVolume_ === previousVolume) {
            return;
        }
        if (!this.currentVolume_ ||
            !this.volumeSizeObservers_[this.currentVolume_.volumeType]) {
            chrome.fileManagerPrivate.onDirectoryChanged.removeListener(this.onDirectorySizeChangedBound_);
            return;
        }
        const isSubscribedByPreviousVolume = previousVolume && this.volumeSizeStats_[previousVolume.volumeType];
        if (!isSubscribedByPreviousVolume &&
            this.volumeSizeObservers_[this.currentVolume_.volumeType]) {
            chrome.fileManagerPrivate.onDirectoryChanged.addListener(this.onDirectorySizeChangedBound_);
        }
    }
    /**
     * When a directory changes, grab the current directory size. This is useful
     * if events are occurring on the current Files app directory (e.g. a copy
     * operation occurs and the disk size changes). Use this event to check if
     * the underlying disk space has changed.
     */
    async onDirectorySizeChanged_(event) {
        if (!event.entry) {
            return;
        }
        const eventVolumeInfo = this.volumeManager_.getVolumeInfo(event.entry);
        if (!eventVolumeInfo || !eventVolumeInfo.volumeId) {
            return;
        }
        this.pendingVolumeSizeUpdates_.add(eventVolumeInfo);
        this.updateVolumeSizeStatsDebounced_.run();
    }
    /**
     * Updates the time limit for the bound banner. Ensures the time limit only
     * loses DURATION_BETWEEN_TIME_LIMIT_UPDATES_MS granularity in the event
     * of a crash or the Files app window is closed.
     */
    async updateTimeLimit(banner) {
        const localStorageKey = `${banner.tagName}_${MS_DISPLAYED_SUFFIX}`;
        const currentDateNowMs = Date.now();
        const durationBannerHasBeenShownMs = (this.timeLimitIntervalLastInvokedMs_) ?
            (Date.now() - this.timeLimitIntervalLastInvokedMs_) :
            DURATION_BETWEEN_TIME_LIMIT_UPDATES_MS;
        await this.setLocalStorage_(localStorageKey, durationBannerHasBeenShownMs +
            (this.localStorageCache_[localStorageKey] || 0));
        this.timeLimitIntervalLastInvokedMs_ = currentDateNowMs;
        // Hide the banner if it's reached the time limit.
        if (!this.shouldShowBanner_(banner)) {
            await this.reconcile();
        }
    }
    /**
     * Refresh the volume size stats for all volumeIds in
     * |pendingVolumeSizeUpdate_|.
     */
    async updateVolumeSizeStats_() {
        if (this.pendingVolumeSizeUpdates_.size === 0) {
            return;
        }
        for (const { volumeType, volumeId } of this.pendingVolumeSizeUpdates_) {
            if (volumeType === VolumeType.DRIVE) {
                try {
                    if (!this.currentEntry_ || isFakeEntry(this.currentEntry_)) {
                        continue;
                    }
                    this.driveQuotaMetadata_ =
                        await getDriveQuotaMetadata(this.currentEntry_);
                    if (this.driveQuotaMetadata_) {
                        this.volumeSizeStats_[volumeId] = {
                            totalSize: this.driveQuotaMetadata_.totalBytes,
                            remainingSize: this.driveQuotaMetadata_.totalBytes -
                                this.driveQuotaMetadata_.usedBytes,
                        };
                    }
                }
                catch (e) {
                    console.warn('Error getting drive quota metadata', e);
                }
                continue;
            }
            try {
                const sizeStats = await getSizeStats(volumeId);
                if (!sizeStats || sizeStats.totalSize === 0) {
                    continue;
                }
                this.volumeSizeStats_[volumeId] = sizeStats;
            }
            catch (e) {
                console.warn('Error getting size stats', e);
            }
        }
        this.pendingVolumeSizeUpdates_.clear();
        await this.reconcile();
    }
    /**
     * Listens for localStorage changes to ensure instance cache is in sync.
     */
    onStorageChanged_(changes, areaName) {
        if (areaName !== 'local') {
            return;
        }
        for (const key in changes) {
            if (this.localStorageCache_.hasOwnProperty(key)) {
                this.localStorageCache_[key] = changes[key].newValue;
            }
        }
    }
}
/**
 * Identifies if the current volume is in the list of allowed volume type
 * array for a specific banner.
 */
function isAllowedVolume(currentVolume, currentRootType, allowedVolumes) {
    let currentVolumeType = null;
    let currentVolumeId = null;
    if (currentVolume) {
        currentVolumeType = currentVolume.volumeType;
        currentVolumeId = currentVolume.volumeId;
    }
    for (let i = 0; i < allowedVolumes.length; i++) {
        const allowedVolume = allowedVolumes[i];
        if (!('root' in allowedVolume) && !('type' in allowedVolume)) {
            continue;
        }
        if (('type' in allowedVolume) && currentVolumeType !== allowedVolume.type) {
            continue;
        }
        if (('root' in allowedVolume) && currentRootType !== allowedVolume.root) {
            continue;
        }
        if (('id' in allowedVolume) && currentVolumeId !== allowedVolume.id) {
            continue;
        }
        return true;
    }
    return false;
}
/**
 * Checks if the current sizeStats are below the threshold required to trigger
 * the banner to show.
 */
function isBelowThreshold(threshold, sizeStats) {
    if (!threshold || !sizeStats) {
        return false;
    }
    if (isNullOrUndefined(sizeStats.remainingSize) ||
        isNullOrUndefined(sizeStats.totalSize)) {
        return false;
    }
    if (('minSize' in threshold) && threshold.minSize < sizeStats.remainingSize) {
        return false;
    }
    const currentRatio = sizeStats.remainingSize / sizeStats.totalSize;
    if (('minRatio' in threshold) && threshold.minRatio < currentRatio) {
        return false;
    }
    return true;
}
/**
 * Identifies if a supplied Entry is shared with a particularly VM. Returns a
 * curried function that takes the vm type.
 */
function isPathSharedWithVm(crostini, entry, vmType) {
    if (!crostini.isEnabled(vmType)) {
        return false;
    }
    if (!entry) {
        return false;
    }
    return crostini.isPathShared(vmType, entry);
}

// Copyright 2012 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/** The next id suffix to use when giving each item an unique id. */
let nextUniqueIdSuffix = 0;
/** Creates a new list item element. */
function createListItem() {
    const el = document.createElement('li');
    crInjectTypeAndInit(el, ListItem);
    return el;
}
class ListItem extends HTMLLIElement {
    constructor() {
        super(...arguments);
        /** This item's index in the containing list. */
        this.listIndex_ = -1;
    }
    /** Plain text label. */
    get label() {
        return this.textContent || '';
    }
    set label(label) {
        this.textContent = label;
    }
    /** This item's index in the containing list. */
    get listIndex() {
        return this.listIndex_;
    }
    set listIndex(value) {
        jsSetter(this, 'listIndex', value);
    }
    /**
     * Whether the item is the lead in a selection. Setting this does not update
     * the underlying selection model. This is only used for display purpose.
     */
    get lead() {
        return this.hasAttribute('lead');
    }
    set lead(value) {
        boolAttrSetter(this, 'lead', value);
    }
    /**
     * Whether the item is selected. Setting this does not update the underlying
     * selection model. This is only used for display purpose.
     */
    get selected() {
        return this.hasAttribute('selected');
    }
    set selected(value) {
        boolAttrSetter(this, 'selected', value);
        this.setAttribute('aria-selected', String(value));
    }
    /** Called when an element is decorated as a list item. */
    initialize() {
        this.listIndex_ = -1;
        this.setAttribute('role', 'listitem');
        if (!this.id) {
            this.id = 'listitem-' + nextUniqueIdSuffix++;
        }
    }
}

// Copyright 2012 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * The selection controller that is to be used with lists. This is implemented
 * for vertical lists but changing the behavior for horizontal lists or icon
 * views is a matter of overriding `getIndexBefore()`, `getIndexAfter()`,
 * `getIndexAbove()` as well as `getIndexBelow()`.
 */
class ListSelectionController {
    /**
     * @param selectionModel The selection model to interact with.
     */
    constructor(selectionModel_) {
        this.selectionModel_ = selectionModel_;
    }
    /**
     * The selection model we are interacting with.
     */
    get selectionModel() {
        return this.selectionModel_;
    }
    /**
     * Returns the index below (y axis) the given element.
     * @param index The index to get the index below.
     * @return The index below or -1 if not found.
     */
    getIndexBelow(index) {
        if (index === this.getLastIndex()) {
            return -1;
        }
        return index + 1;
    }
    /**
     * Returns the index above (y axis) the given element.
     * @param index The index to get the index above.
     * @return The index below or -1 if not found.
     */
    getIndexAbove(index) {
        return index - 1;
    }
    /**
     * Returns the index before (x axis) the given element. This returns -1
     * by default but override this for icon view and horizontal selection
     * models.
     *
     * @param _index The index to get the index before.
     */
    getIndexBefore(_index) {
        return -1;
    }
    /**
     * Returns the index after (x axis) the given element. This returns -1
     * by default but override this for icon view and horizontal selection
     * models.
     *
     * @param index The index to get the index after.
     */
    getIndexAfter(_index) {
        return -1;
    }
    /**
     * Returns the next list index. This is the next logical and should not
     * depend on any kind of layout of the list.
     * @param index The index to get the next index for.
     * @return The next index or -1 if not found.
     */
    getNextIndex(index) {
        if (index === this.getLastIndex()) {
            return -1;
        }
        return index + 1;
    }
    /**
     * Returns the previous list index. This is the previous logical and should
     * not depend on any kind of layout of the list.
     * @param index The index to get the previous index for.
     * @return The previous index or -1 if not found.
     */
    getPreviousIndex(index) {
        return index - 1;
    }
    /**
     * @return The first index.
     */
    getFirstIndex() {
        return 0;
    }
    /**
     * @return The last index.
     */
    getLastIndex() {
        return this.selectionModel.length - 1;
    }
    /**
     * Called by the view when the user does a mousedown or mouseup on the
     * list.
     * @param e The browser mouse event.
     * @param index The index that was under the mouse pointer, -1 if none.
     */
    handlePointerDownUp(e, index) {
        const sm = this.selectionModel;
        const anchorIndex = sm.anchorIndex;
        const isDown = (e.type === 'mousedown');
        sm.beginChange();
        if (index === -1) {
            // On CrOS we always clear the selection if the user clicks a blank area.
            sm.leadIndex = sm.anchorIndex = -1;
            sm.unselectAll();
        }
        else {
            if (sm.multiple && (e.ctrlKey && !e.shiftKey)) {
                // Selection is handled at mouseUp on windows/linux, mouseDown on mac.
                if (!isDown) {
                    // Toggle the current one and make it anchor index.
                    sm.setIndexSelected(index, !sm.getIndexSelected(index));
                    sm.leadIndex = index;
                    sm.anchorIndex = index;
                }
            }
            else if (e.shiftKey && anchorIndex !== -1 && anchorIndex !== index) {
                // Shift is done in mousedown.
                if (isDown) {
                    sm.unselectAll();
                    sm.leadIndex = index;
                    if (sm.multiple) {
                        sm.selectRange(anchorIndex, index);
                    }
                    else {
                        sm.setIndexSelected(index, true);
                    }
                }
            }
            else {
                // Right click for a context menu needs to not clear the selection.
                const isRightClick = e.button === 2;
                // If the index is selected this is handled in mouseup.
                const indexSelected = sm.getIndexSelected(index);
                if ((indexSelected && !isDown || !indexSelected && isDown) &&
                    !(indexSelected && isRightClick)) {
                    sm.selectedIndex = index;
                }
            }
        }
        sm.endChange();
    }
    /**
     * Called by the view when it receives either a touchstart, touchmove,
     * touchend, or touchcancel event.
     * Sub-classes may override this function to handle touch events separately
     * from mouse events, instead of waiting for emulated mouse events sent
     * after the touch events.
     * @param _e The event.
     * @param _index The index that was under the touched point, -1 if none.
     */
    handleTouchEvents(_e, _index) {
        // Do nothing.
    }
    /**
     * Called by the view when it receives a keydown event.
     * @param e The keydown event.
     */
    handleKeyDown(e) {
        const target = e.target;
        const tagName = target.tagName;
        // If focus is in an input field of some kind, only handle navigation keys
        // that aren't likely to conflict with input interaction (e.g., text
        // editing, or changing the value of a checkbox or select).
        if (tagName === 'INPUT') {
            const inputType = target.type;
            // Just protect space (for toggling) for checkbox and radio.
            if (inputType === 'checkbox' || inputType === 'radio') {
                if (e.key === ' ') {
                    return;
                }
                // Protect all but the most basic navigation commands in anything
                // else.
            }
            else if (e.key !== 'ArrowUp' && e.key !== 'ArrowDown') {
                return;
            }
        }
        // Similarly, don't interfere with select element handling.
        if (tagName === 'SELECT') {
            return;
        }
        const sm = this.selectionModel;
        let newIndex = -1;
        const leadIndex = sm.leadIndex;
        let prevent = true;
        // Ctrl/Meta+A
        if (sm.multiple && e.keyCode === 65 && e.ctrlKey) {
            sm.selectAll();
            e.preventDefault();
            return;
        }
        if (e.key === ' ') {
            if (leadIndex !== -1) {
                const selected = sm.getIndexSelected(leadIndex);
                if (e.ctrlKey || !selected) {
                    sm.setIndexSelected(leadIndex, !selected || !sm.multiple);
                    return;
                }
            }
        }
        switch (e.key) {
            case 'Home':
                newIndex = this.getFirstIndex();
                break;
            case 'End':
                newIndex = this.getLastIndex();
                break;
            case 'ArrowUp':
                newIndex = leadIndex === -1 ? this.getLastIndex() :
                    this.getIndexAbove(leadIndex);
                break;
            case 'ArrowDown':
                newIndex = leadIndex === -1 ? this.getFirstIndex() :
                    this.getIndexBelow(leadIndex);
                break;
            case 'ArrowLeft':
            case 'MediaPreviousTrack':
                newIndex = leadIndex === -1 ? this.getLastIndex() :
                    this.getIndexBefore(leadIndex);
                break;
            case 'ArrowRight':
            case 'MediaNextTrack':
                newIndex = leadIndex === -1 ? this.getFirstIndex() :
                    this.getIndexAfter(leadIndex);
                break;
            default:
                prevent = false;
        }
        if (newIndex !== -1) {
            sm.beginChange();
            sm.leadIndex = newIndex;
            if (e.shiftKey) {
                const anchorIndex = sm.anchorIndex;
                if (sm.multiple) {
                    sm.unselectAll();
                }
                if (anchorIndex === -1) {
                    sm.setIndexSelected(newIndex, true);
                    sm.anchorIndex = newIndex;
                }
                else {
                    sm.selectRange(anchorIndex, newIndex);
                }
            }
            else {
                if (sm.multiple) {
                    sm.unselectAll();
                }
                sm.setIndexSelected(newIndex, true);
                sm.anchorIndex = newIndex;
            }
            sm.endChange();
            if (prevent) {
                e.preventDefault();
            }
        }
    }
}

// Copyright 2012 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * Whether a mouse event is inside the element viewport. This will return
 * false if the mouseevent was generated over a border or a scrollbar.
 * @param el The element to test the event with.
 * @param e The mouse event.
 */
function inViewport(el, e) {
    const rect = el.getBoundingClientRect();
    const x = e.clientX;
    const y = e.clientY;
    return x >= rect.left + el.clientLeft &&
        x < rect.left + el.clientLeft + el.clientWidth &&
        y >= rect.top + el.clientTop &&
        y < rect.top + el.clientTop + el.clientHeight;
}
function getComputedStyle$1(el) {
    return el.ownerDocument?.defaultView?.getComputedStyle(el);
}
function createList() {
    const el = document.createElement('list');
    crInjectTypeAndInit(el, List);
    return el;
}
/**
 * Creates a new list element.
 */
class List extends HTMLUListElement {
    constructor() {
        super(...arguments);
        /**
         * Measured size of list items. This is lazily calculated the first time it
         * is needed. Note that lead item is allowed to have a different height, to
         * accommodate lists where a single item at a time can be expanded to show
         * more detail.
         */
        this.measured_ = null;
        /**
         * Whether or not the list is auto-expanding. If true, the list resizes
         * its height to accommodate all children.
         */
        this.autoExpands_ = false;
        this.firstIndex_ = 0;
        this.lastIndex_ = 0;
        this.pinnedItem_ = null;
        /**
         * Whether or not the rows on list have various heights. If true, all the
         * rows have the same fixed height. Otherwise, each row resizes its height
         * to accommodate all contents.
         */
        this.fixedHeight_ = true;
        /**
         * Whether or not the list view has a blank space below the last row.
         */
        this.remainingSpace_ = true;
        /**
         * Function used to create grid items.
         */
        this.itemConstructor_ = createListItem;
        this.dataModel_ = null;
        this.selectionModel_ = null;
        this.selectionController_ = null;
        /**
         * Cached item for measuring the default item size by measureItem().
         */
        this.cachedMeasuredItem_ = null;
        /**
         * Maps the index to the ListItem.
         */
        this.cachedItems_ = {};
        /**
         * Maps the index to the ListItem's height.
         */
        this.cachedItemHeights_ = {};
        this.boundHandleDataModelPermuted_ = null;
        this.boundHandleDataModelChange_ = null;
        this.boundHandleOnChange_ = null;
        this.boundHandleLeadChange_ = null;
        this.beforeFiller_ = null;
        this.afterFiller_ = null;
        /** Managed by DragSelector */
        this.cachedBounds = null;
        this.batchCount_ = 0;
    }
    /**
     * Function used to create grid items.
     */
    get itemConstructor() {
        return this.itemConstructor_;
    }
    set itemConstructor(func) {
        if (func !== this.itemConstructor_) {
            this.itemConstructor_ = func;
            this.cachedItems_ = {};
            this.redraw();
        }
    }
    /**
     * The data model driving the list.
     */
    set dataModel(dataModel) {
        if (this.dataModel_ === dataModel) {
            return;
        }
        if (!this.boundHandleDataModelPermuted_) {
            this.boundHandleDataModelPermuted_ =
                this.handleDataModelPermuted_.bind(this);
            this.boundHandleDataModelChange_ =
                this.handleDataModelChange_.bind(this);
        }
        if (this.dataModel_) {
            this.dataModel_.removeEventListener('permuted', this.boundHandleDataModelPermuted_);
            this.dataModel_.removeEventListener('change', this.boundHandleDataModelChange_);
        }
        this.dataModel_ = dataModel;
        this.cachedItems_ = {};
        this.cachedItemHeights_ = {};
        this.selectionModel?.clear();
        if (dataModel) {
            this.selectionModel?.adjustLength(dataModel.length);
        }
        if (this.dataModel_) {
            this.dataModel_.addEventListener('permuted', this.boundHandleDataModelPermuted_);
            this.dataModel_.addEventListener('change', this.boundHandleDataModelChange_);
        }
        this.redraw();
    }
    get dataModel() {
        return this.dataModel_;
    }
    /**
     * The selection model to use.
     */
    get selectionModel() {
        return this.selectionModel_;
    }
    set selectionModel(sm) {
        const oldSm = this.selectionModel_;
        if (oldSm === sm) {
            return;
        }
        if (!this.boundHandleOnChange_) {
            this.boundHandleOnChange_ =
                this.handleOnChange_.bind(this);
            this.boundHandleLeadChange_ = this.handleLeadChange.bind(this);
        }
        if (oldSm) {
            oldSm.removeEventListener('change', this.boundHandleOnChange_);
            oldSm.removeEventListener('leadIndexChange', this.boundHandleLeadChange_);
        }
        this.selectionModel_ = sm;
        this.selectionController_ = this.createSelectionController(sm);
        if (sm) {
            sm.addEventListener('change', this.boundHandleOnChange_);
            sm.addEventListener('leadIndexChange', this.boundHandleLeadChange_);
        }
    }
    /**
     * Whether or not the list auto-expands.
     */
    get autoExpands() {
        return this.autoExpands_;
    }
    set autoExpands(autoExpands) {
        if (this.autoExpands_ === autoExpands) {
            return;
        }
        this.autoExpands_ = autoExpands;
        this.redraw();
    }
    /**
     * Whether or not the rows on list have various heights.
     */
    get fixedHeight() {
        return this.fixedHeight_;
    }
    set fixedHeight(fixedHeight) {
        if (this.fixedHeight_ === fixedHeight) {
            return;
        }
        this.fixedHeight_ = fixedHeight;
        this.redraw();
    }
    /**
     * Convenience alias for selectionModel.selectedItem
     */
    get selectedItem() {
        const dataModel = this.dataModel;
        if (dataModel) {
            const index = this.selectionModel.selectedIndex;
            if (index !== -1) {
                return dataModel.item(index) ?? null;
            }
        }
        return null;
    }
    set selectedItem(selectedItem) {
        const dataModel = this.dataModel;
        if (dataModel) {
            const index = this.dataModel.indexOf(selectedItem);
            this.selectionModel.selectedIndex = index;
        }
    }
    /**
     * Convenience alias for selectionModel.selectedItems
     */
    get selectedItems() {
        const indexes = this.selectionModel.selectedIndexes;
        const dataModel = this.dataModel;
        if (dataModel) {
            return indexes
                .map(i => dataModel.item(i))
                // b/307500990 somehow this was getting invalid indexes.
                .filter(item => item !== undefined);
        }
        return [];
    }
    /**
     * The HTML elements representing the items.
     */
    get items() {
        return Array.prototype.filter.call(this.children, this.isItem, this);
    }
    /**
     * Returns true if the child is a list item. Subclasses may override this
     * to filter out certain elements.
     */
    isItem(child) {
        return child.nodeType === Node.ELEMENT_NODE &&
            child !== this.beforeFiller_ && child !== this.afterFiller_;
    }
    /**
     * When making a lot of updates to the list, the code could be wrapped in
     * the startBatchUpdates and finishBatchUpdates to increase performance.
     * Be sure that the code will not return without calling endBatchUpdates
     * or the list will not be correctly updated.
     */
    startBatchUpdates() {
        this.batchCount_++;
    }
    /**
     * See startBatchUpdates.
     */
    endBatchUpdates() {
        this.batchCount_--;
        if (this.batchCount_ === 0) {
            this.redraw();
        }
    }
    /**
     * Initializes the element.
     */
    initialize() {
        // Add fillers.
        this.beforeFiller_ = this.ownerDocument.createElement('div');
        this.afterFiller_ = this.ownerDocument.createElement('div');
        this.beforeFiller_.className = 'spacer';
        this.afterFiller_.className = 'spacer';
        this.textContent = '';
        this.appendChild(this.beforeFiller_);
        this.appendChild(this.afterFiller_);
        this.autoExpands_ = false;
        this.fixedHeight_ = true;
        this.remainingSpace_ = true;
        this.batchCount_ = 0;
        this.itemConstructor_ = (label) => {
            const item = createListItem();
            item.label = label;
            return item;
        };
        const length = this.dataModel ? this.dataModel.length : 0;
        this.selectionModel = new ListSelectionModel(length);
        this.addEventListener('dblclick', this.handleDoubleClick_);
        this.addEventListener('mousedown', this.handleMouseDown_.bind(this));
        this.addEventListener('dragstart', this.handleDragStart_.bind(this), true);
        this.addEventListener('mouseup', this.handlePointerDownUp_);
        this.addEventListener('keydown', this.handleKeyDown);
        this.addEventListener('focus', this.handleElementFocus_, true);
        this.addEventListener('blur', this.handleElementBlur_, true);
        this.addEventListener('scroll', this.handleScroll.bind(this));
        this.addEventListener('touchstart', this.handleTouchEvents_);
        this.addEventListener('touchmove', this.handleTouchEvents_);
        this.addEventListener('touchend', this.handleTouchEvents_);
        this.addEventListener('touchcancel', this.handleTouchEvents_);
        this.setAttribute('role', 'list');
        // Make list focusable
        if (!this.hasAttribute('tabindex')) {
            this.tabIndex = 0;
        }
    }
    /**
     * @param item The list item to measure.
     * @return The height of the given item. If the fixed height on CSS
     * is set by 'px', uses that value as height. Otherwise, measures the
     * size.
     */
    measureItemHeight_(item) {
        return this.measureItem(item).height;
    }
    /**
     * The height of default item, measuring it if necessary.
     */
    getDefaultItemHeight_() {
        return this.getDefaultItemSize_().height;
    }
    /**
     * @param index The index of the item.
     * @return The height of the item, measuring it if necessary.
     */
    getItemHeightByIndex_(index) {
        // If |this.fixedHeight_| is true, all the rows have same default height.
        if (this.fixedHeight_) {
            return this.getDefaultItemHeight_();
        }
        if (this.cachedItemHeights_[index]) {
            return this.cachedItemHeights_[index];
        }
        const item = this.getListItemByIndex(index);
        if (item) {
            const h = this.measureItemHeight_(item);
            this.cachedItemHeights_[index] = h;
            return h;
        }
        return this.getDefaultItemHeight_();
    }
    /**
     * The height and width of default item, measuring it if necessary.
     */
    getDefaultItemSize_() {
        if (!this.measured_ || !this.measured_.height) {
            this.measured_ = this.measureItem();
        }
        return this.measured_;
    }
    /**
     * Creates an item (dataModel.item(0)) and measures its height. The item
     * is cached instead of creating a new one every time..
     * @param {ListItem=} item The list item to use to do the measuring. If this
     *     is not provided an item will be created based on the first value in the
     *     model.
     * @return  The height and width of the item, taking margins into account, and
     *     the top, bottom, left and right margins themselves.
     */
    measureItem(item) {
        const dataModel = this.dataModel;
        if (!dataModel || !dataModel.length) {
            return {
                height: 0,
                marginTop: 0,
                marginBottom: 0,
                width: 0,
                marginLeft: 0,
                marginRight: 0,
            };
        }
        const measuredItem = item || this.cachedMeasuredItem_ || this.createItem(dataModel.item(0));
        if (!item) {
            this.cachedMeasuredItem_ = measuredItem;
            this.appendChild(measuredItem);
        }
        const rect = measuredItem.getBoundingClientRect();
        const cs = getComputedStyle$1(measuredItem);
        const mt = parseFloat(cs?.marginTop ?? '');
        const mb = parseFloat(cs?.marginBottom ?? '');
        const ml = parseFloat(cs?.marginLeft ?? '');
        const mr = parseFloat(cs?.marginRight ?? '');
        let h = rect.height;
        let w = rect.width;
        let mh = 0;
        let mv = 0;
        // Handle margin collapsing.
        if (mt < 0 && mb < 0) {
            mv = Math.min(mt, mb);
        }
        else if (mt >= 0 && mb >= 0) {
            mv = Math.max(mt, mb);
        }
        else {
            mv = mt + mb;
        }
        h += mv;
        if (ml < 0 && mr < 0) {
            mh = Math.min(ml, mr);
        }
        else if (ml >= 0 && mr >= 0) {
            mh = Math.max(ml, mr);
        }
        else {
            mh = ml + mr;
        }
        w += mh;
        if (!item) {
            this.removeChild(measuredItem);
        }
        return {
            height: Math.max(0, h),
            marginTop: mt,
            marginBottom: mb,
            width: Math.max(0, w),
            marginLeft: ml,
            marginRight: mr,
        };
    }
    /**
     * Callback for the double click event.
     * @param e The mouse event object.
     */
    handleDoubleClick_(e) {
        if (this.disabled) {
            return;
        }
        const target = e.target;
        const ancestor = this.getListItemAncestor(target);
        let index = -1;
        if (ancestor) {
            index = this.getIndexOfListItem(ancestor);
            this.activateItemAtIndex(index);
        }
        const sm = this.selectionModel;
        const indexSelected = sm?.getIndexSelected(index);
        if (!indexSelected) {
            this.handlePointerDownUp_(e);
        }
    }
    /**
     * Callback for mousedown and mouseup events.
     * @param e The mouse event object.
     */
    handlePointerDownUp_(e) {
        if (this.disabled) {
            return;
        }
        let target = e.target;
        // If the target was this element we need to make sure that the user did
        // not click on a border or a scrollbar.
        if (target === this) {
            if (inViewport(target, e)) {
                this.selectionController_.handlePointerDownUp(e, -1);
            }
            return;
        }
        target = this.getListItemAncestor(target);
        if (!target) {
            return;
        }
        const index = this.getIndexOfListItem(target);
        this.selectionController_.handlePointerDownUp(e, index);
    }
    /**
     * Called when an element in the list is focused. Marks the list as having
     * a focused element, and dispatches an event if it didn't have focus.
     * @param e The focus event.
     */
    handleElementFocus_(_e) {
        if (!this.hasElementFocus) {
            this.hasElementFocus = true;
        }
    }
    /**
     * Called when an element in the list is blurred. If focus moves
     * outside the list, marks the list as no longer having focus and
     * dispatches an event.
     */
    handleElementBlur_(e) {
        if (!this.contains(e.relatedTarget)) {
            this.hasElementFocus = false;
        }
    }
    /**
     * Returns the list item element containing the given element, or null if
     * it doesn't belong to any list item element.
     * @param element The element.
     * @return The list item containing `element`, or null.
     */
    getListItemAncestor(element) {
        let container = element;
        while (container && container.parentNode !== this) {
            container = container.parentNode;
        }
        return (container instanceof HTMLLIElement ? container : null);
    }
    /**
     * Handle a keydown event.
     */
    handleKeyDown(e) {
        if (!this.disabled) {
            this.selectionController_?.handleKeyDown(e);
        }
    }
    /**
     * Handle a scroll event.
     */
    handleScroll(_e) {
        requestAnimationFrame(this.redraw.bind(this));
    }
    /**
     * Handle touchmove/touchcancel events.
     */
    handleTouchEvents_(e) {
        if (this.disabled) {
            return;
        }
        let target = e.target;
        if (target === this) {
            // Unlike the mouse events, we don't check if the touch is inside the
            // viewport because of these reasons:
            // - The scrollbars do not interact with touch.
            // - touch* events are not sent to this element when tapping or
            //   dragging window borders by touch.
            this.selectionController_.handleTouchEvents(e, -1);
            return;
        }
        target = this.getListItemAncestor(target);
        if (!target) {
            return;
        }
        const index = this.getIndexOfListItem(target);
        this.selectionController_.handleTouchEvents(e, index);
    }
    /**
     * Callback from the selection model. We dispatch {@code change} events
     * when the selection changes.
     * @param event Event with change info.
     * @private
     */
    handleOnChange_(event) {
        const changes = event.detail.changes || [];
        for (const change of changes) {
            const listItem = this.getListItemByIndex(change.index);
            if (listItem) {
                listItem.selected = change.selected;
                if (change.selected) {
                    listItem.setAttribute('aria-posinset', String(change.index + 1));
                    listItem.setAttribute('aria-setsize', String(this.dataModel.length));
                }
                else {
                    listItem.removeAttribute('aria-posinset');
                    listItem.removeAttribute('aria-setsize');
                }
            }
        }
        dispatchSimpleEvent(this, 'change');
    }
    /**
     * Handles a change of the lead item from the selection model.
     * @param event The property change event.
     */
    handleLeadChange(event) {
        const e = event;
        let element;
        if (e.oldValue !== -1) {
            if ((element = this.getListItemByIndex(e.oldValue))) {
                element.lead = false;
            }
        }
        if (e.newValue !== -1) {
            if ((element = this.getListItemByIndex(e.newValue))) {
                element.lead = true;
            }
            if (e.oldValue !== e.newValue) {
                if (element) {
                    this.setAttribute('aria-activedescendant', element.id);
                }
                this.scrollIndexIntoView(e.newValue);
                // If the lead item has a different height than other items, then we
                // may run into a problem that requires a second attempt to scroll
                // it into view. The first scroll attempt will trigger a redraw,
                // which will clear out the list and repopulate it with new items.
                // During the redraw, the list may shrink temporarily, which if the
                // lead item is the last item, will move the scrollTop up since it
                // cannot extend beyond the end of the list. (Sadly, being scrolled to
                // the bottom of the list is not "sticky.") So, we set a timeout to
                // rescroll the list after this all gets sorted out. This is perhaps
                // not the most elegant solution, but no others seem obvious.
                setTimeout(() => {
                    this.scrollIndexIntoView(e.newValue);
                });
            }
        }
        else {
            this.removeAttribute('aria-activedescendant');
        }
    }
    /**
     * This handles data model 'permuted' event.
     * this event is dispatched as a part of sort or splice.
     * We need to
     *  - adjust the cache.
     *  - adjust selection.
     *  - redraw. (called in this.endBatchUpdates())
     *  It is important that the cache adjustment happens before selection
     * model adjustments.
     * @param event The 'permuted' event.
     */
    handleDataModelPermuted_(event) {
        const newCachedItems = {};
        for (const index in this.cachedItems_) {
            if (event.detail.permutation[index] !== -1) {
                const newIndex = event.detail.permutation[index];
                newCachedItems[newIndex] = this.cachedItems_[index];
                newCachedItems[newIndex].listIndex = newIndex;
            }
        }
        this.cachedItems_ = newCachedItems;
        this.pinnedItem_ = null;
        const newCachedItemHeights = {};
        for (const index in this.cachedItemHeights_) {
            if (event.detail.permutation[index] !== -1) {
                newCachedItemHeights[event.detail.permutation[index]] =
                    this.cachedItemHeights_[index];
            }
        }
        this.cachedItemHeights_ = newCachedItemHeights;
        this.startBatchUpdates();
        assert$1(this.selectionModel);
        const sm = this.selectionModel;
        sm.adjustLength(event.detail.newLength);
        sm.adjustToReordering(event.detail.permutation);
        this.endBatchUpdates();
    }
    handleDataModelChange_(event) {
        if (isNullOrUndefined(event.detail.index)) {
            return;
        }
        const eventIndex = event.detail.index;
        delete this.cachedItems_[eventIndex];
        delete this.cachedItemHeights_[eventIndex];
        this.cachedMeasuredItem_ = null;
        if (eventIndex >= this.firstIndex_ &&
            (eventIndex < this.lastIndex_ || this.remainingSpace_)) {
            this.redraw();
        }
    }
    /**
     * @param index The index of the item.
     * @return The top position of the item inside the list.
     */
    getItemTop(index) {
        if (this.fixedHeight_) {
            const itemHeight = this.getDefaultItemHeight_();
            return index * itemHeight;
        }
        else {
            this.ensureAllItemSizesInCache();
            let top = 0;
            for (let i = 0; i < index; i++) {
                top += this.getItemHeightByIndex_(i);
            }
            return top;
        }
    }
    /**
     * @param index The index of the item.
     * @return The row of the item. May vary in the case of multiple columns.
     */
    getItemRow(index) {
        return index;
    }
    /**
     * @param row The row.
     * @return The index of the first item in the row.
     */
    getFirstItemInRow(row) {
        return row;
    }
    /**
     * Ensures that a given index is inside the viewport.
     * @param index The index of the item to scroll into view.
     */
    scrollIndexIntoView(index) {
        const dataModel = this.dataModel;
        if (!dataModel || index < 0 || index >= dataModel.length) {
            return;
        }
        const itemHeight = this.getItemHeightByIndex_(index);
        const scrollTop = this.scrollTop;
        const top = this.getItemTop(index);
        const clientHeight = this.clientHeight;
        const cs = getComputedStyle$1(this);
        assert$1(cs);
        const paddingY = parseInt(cs.paddingTop, 10) + parseInt(cs.paddingBottom, 10);
        const availableHeight = clientHeight - paddingY;
        const self = this;
        // Function to adjust the tops of viewport and row.
        function scrollToAdjustTop() {
            self.scrollTop = top;
        }
        // Function to adjust the bottoms of viewport and row.
        function scrollToAdjustBottom() {
            self.scrollTop = top + itemHeight - availableHeight;
        }
        // Check if the entire of given indexed row can be shown in the viewport.
        if (itemHeight <= availableHeight) {
            if (top < scrollTop) {
                scrollToAdjustTop();
            }
            else if (scrollTop + availableHeight < top + itemHeight) {
                scrollToAdjustBottom();
            }
        }
        else {
            if (scrollTop < top) {
                scrollToAdjustTop();
            }
            else if (top + itemHeight < scrollTop + availableHeight) {
                scrollToAdjustBottom();
            }
        }
    }
    /**
     * @return The rect to use for the context menu.
     */
    getRectForContextMenu() {
        assert$1(this.selectionModel);
        const index = this.selectionModel.selectedIndex;
        const el = this.getListItemByIndex(index);
        if (el) {
            return el.getBoundingClientRect();
        }
        return this.getBoundingClientRect();
    }
    /**
     * Takes a value from the data model and finds the associated list item.
     * @param value The value in the data model that we want to get the list item
     *     for.
     * @return The first found list item or null if not found.
     */
    getListItem(value) {
        const dataModel = this.dataModel;
        if (dataModel) {
            const index = dataModel.indexOf(value);
            return this.getListItemByIndex(index);
        }
        return null;
    }
    /**
     * Find the list item element at the given index.
     * @param index The index of the list item to get.
     * @return The found list item or null if not found.
     */
    getListItemByIndex(index) {
        return this.cachedItems_[index] || null;
    }
    /**
     * Find the index of the given list item element.
     * @return  The index of the list item, or -1 if not found.
     */
    getIndexOfListItem(item) {
        const index = item.listIndex;
        if (this.cachedItems_[index] === item) {
            return index;
        }
        return -1;
    }
    /**
     * Creates a new list item.
     * @param label The value to use for the item.
     * @return The newly created list item.
     */
    createItem(label) {
        const item = this.itemConstructor_(label);
        return item;
    }
    /**
     * Creates the selection controller to use internally.
     * @param sm The underlying selection model.
     * @return The newly created selection controller.
     */
    createSelectionController(sm) {
        return new ListSelectionController(sm);
    }
    /**
     * Return the heights (in pixels) of the top of the given item index
     * within the list, and the height of the given item itself, accounting
     * for the possibility that the lead item may be a different height.
     * @param index The index to find the top height of.
     * @return  The heights for the given index.
     */
    getHeightsForIndex(index) {
        const itemHeight = this.getItemHeightByIndex_(index);
        const top = this.getItemTop(index);
        return { top: top, height: itemHeight };
    }
    /**
     * Find the index of the list item containing the given y offset (measured
     * in pixels from the top) within the list. In the case of multiple
     * columns, returns the first index in the row.
     * @param offset The y offset in pixels to get the index of.
     * @return The index of the list item. Returns the list size if given offset
     *     exceeds the height of list.
     */
    getIndexForListOffset_(offset) {
        const itemHeight = this.getDefaultItemHeight_();
        assert$1(this.dataModel);
        if (!itemHeight) {
            return this.dataModel.length;
        }
        if (this.fixedHeight_) {
            return this.getFirstItemInRow(Math.floor(offset / itemHeight));
        }
        // If offset exceeds the height of list.
        let lastHeight = 0;
        if (this.dataModel.length) {
            const h = this.getHeightsForIndex(this.dataModel.length - 1);
            lastHeight = h.top + h.height;
        }
        if (lastHeight < offset) {
            return this.dataModel.length;
        }
        // Estimates index.
        let estimatedIndex = Math.min(Math.floor(offset / itemHeight), this.dataModel.length - 1);
        const isIncrementing = this.getItemTop(estimatedIndex) < offset;
        // Searches the correct index.
        do {
            const heights = this.getHeightsForIndex(estimatedIndex);
            const top = heights.top;
            const height = heights.height;
            if (top <= offset && offset <= (top + height)) {
                break;
            }
            isIncrementing ? ++estimatedIndex : --estimatedIndex;
        } while (0 < estimatedIndex && estimatedIndex < this.dataModel.length);
        return estimatedIndex;
    }
    /**
     * Return the number of items that occupy the range of heights between
     * the top of the start item and the end offset.
     * @param startIndex The index of the first visible item.
     * @param  endOffset The y offset in pixels of the end of the list.
     */
    countItemsInRange_(startIndex, endOffset) {
        const endIndex = this.getIndexForListOffset_(endOffset);
        return endIndex - startIndex + 1;
    }
    /**
     * Calculates the number of items fitting in the given viewport.
     * @param scrollTop The scroll top position.
     * @param clientHeight The height of viewport.
     * @return The index of first item in view port, The number of items, The item
     *     past the last.
     */
    getItemsInViewPort(scrollTop, clientHeight) {
        if (this.autoExpands_) {
            return {
                first: 0,
                length: this.dataModel?.length ?? 0,
                last: this.dataModel?.length ?? 0,
            };
        }
        else {
            const firstIndex = this.getIndexForListOffset_(scrollTop);
            const lastIndex = this.getIndexForListOffset_(scrollTop + clientHeight);
            return {
                first: firstIndex,
                length: lastIndex - firstIndex + 1,
                last: lastIndex + 1,
            };
        }
    }
    /**
     * Merges list items currently existing in the list with items in the
     * range [firstIndex, lastIndex). Removes or adds items if needed. Doesn't
     * delete {@code this.pinnedItem_} if it is present (instead hides it if
     * it is out of the range).
     * @param firstIndex The index of first item, inclusively.
     * @param lastIndex The index of last item, exclusively.
     */
    mergeItems(firstIndex, lastIndex) {
        let currentIndex = firstIndex;
        const insert = () => {
            assert$1(this.dataModel);
            const dataItem = this.dataModel.item(currentIndex);
            const cachedCurrentItem = this.cachedItems_[currentIndex];
            if (cachedCurrentItem) {
                // Emit synthetic event with cached item that is about to be restored.
                this.dispatchEvent(new CustomEvent('cachedItemRestored', {
                    detail: cachedCurrentItem,
                }));
            }
            const newItem = cachedCurrentItem || this.createItem(dataItem);
            newItem.listIndex = currentIndex;
            this.cachedItems_[currentIndex] = newItem;
            this.insertBefore(newItem, item);
            currentIndex++;
        };
        const remove = () => {
            const next = item.nextSibling;
            if (item !== this.pinnedItem_) {
                this.removeChild(item);
            }
            item = next;
        };
        let item;
        for (item = this.beforeFiller_?.nextSibling; item !== this.afterFiller_ && currentIndex < lastIndex;) {
            if (!this.isItem(item)) {
                item = item.nextSibling;
                continue;
            }
            const index = item.listIndex;
            if (this.cachedItems_[index] !== item || index < currentIndex) {
                remove();
            }
            else if (index === currentIndex) {
                this.cachedItems_[currentIndex] = item;
                item = item.nextSibling;
                currentIndex++;
            }
            else { // index > currentIndex
                insert();
            }
        }
        while (item !== this.afterFiller_) {
            if (this.isItem(item)) {
                remove();
            }
            else {
                item = item.nextSibling;
            }
        }
        if (this.pinnedItem_) {
            const index = this.pinnedItem_.listIndex;
            this.pinnedItem_.hidden = index < firstIndex || index >= lastIndex;
            this.cachedItems_[index] = this.pinnedItem_;
            if (index >= lastIndex) {
                item = this.pinnedItem_;
            } // Insert new items before this one.
        }
        while (currentIndex < lastIndex) {
            insert();
        }
    }
    /**
     * Ensures that all the item sizes in the list have been already cached.
     */
    ensureAllItemSizesInCache() {
        const measuringIndexes = [];
        const isElementAppended = [];
        assert$1(this.dataModel);
        for (let y = 0; y < this.dataModel.length; y++) {
            if (!this.cachedItemHeights_[y]) {
                measuringIndexes.push(y);
                isElementAppended.push(false);
            }
        }
        const measuringItems = [];
        // Adds temporary elements.
        for (let y = 0; y < measuringIndexes.length; y++) {
            const index = measuringIndexes[y];
            assert$1(index);
            const dataItem = this.dataModel.item(index);
            const listItem = this.cachedItems_[index] || this.createItem(dataItem);
            listItem.listIndex = index;
            // If `listItems` is not on the list, appends it to the list and sets
            // the flag.
            if (!listItem.parentNode) {
                this.appendChild(listItem);
                isElementAppended[y] = true;
            }
            this.cachedItems_[index] = listItem;
            measuringItems.push(listItem);
        }
        // All mesurings must be placed after adding all the elements, to prevent
        // performance reducing.
        for (let y = 0; y < measuringIndexes.length; y++) {
            const index = measuringIndexes[y];
            assert$1(index);
            this.cachedItemHeights_[index] =
                this.measureItemHeight_(measuringItems[y]);
        }
        // Removes all the temporary elements.
        for (let y = 0; y < measuringIndexes.length; y++) {
            // If the list item has been appended above, removes it.
            if (isElementAppended[y]) {
                this.removeChild(measuringItems[y]);
            }
        }
    }
    /**
     * Returns the height of after filler in the list.
     * @param lastIndex The index of item past the last in viewport.
     */
    getAfterFillerHeight(lastIndex) {
        assert$1(this.dataModel);
        if (this.fixedHeight_) {
            const itemHeight = this.getDefaultItemHeight_();
            return (this.dataModel.length - lastIndex) * itemHeight;
        }
        let height = 0;
        for (let i = lastIndex; i < this.dataModel.length; i++) {
            height += this.getItemHeightByIndex_(i);
        }
        return height;
    }
    /**
     * Redraws the viewport.
     */
    redraw() {
        if (this.batchCount_ !== 0) {
            return;
        }
        const dataModel = this.dataModel;
        if (!dataModel || !this.autoExpands_ && this.clientHeight === 0) {
            this.cachedItems_ = {};
            this.firstIndex_ = 0;
            this.lastIndex_ = 0;
            this.remainingSpace_ = this.clientHeight !== 0;
            this.mergeItems(0, 0);
            return;
        }
        // Save the previous positions before any manipulation of elements.
        const scrollTop = this.scrollTop;
        const clientHeight = this.clientHeight;
        // Store all the item sizes into the cache in advance, to prevent
        // interleave measuring with mutating dom.
        if (!this.fixedHeight_) {
            this.ensureAllItemSizesInCache();
        }
        const itemsInViewPort = this.getItemsInViewPort(scrollTop, clientHeight);
        // Draws the hidden rows just above/below the viewport to prevent
        // flashing in scroll.
        const firstIndex = Math.max(0, Math.min(dataModel.length - 1, itemsInViewPort.first - 1));
        const lastIndex = Math.min(itemsInViewPort.last + 1, dataModel.length);
        const beforeFillerHeight = this.autoExpands ? 0 : this.getItemTop(firstIndex);
        const afterFillerHeight = this.autoExpands ? 0 : this.getAfterFillerHeight(lastIndex);
        this.beforeFiller_.style.height = beforeFillerHeight + 'px';
        assert$1(this.selectionModel);
        const sm = this.selectionModel;
        const leadIndex = sm.leadIndex;
        // If the pinned item is hidden and it is not the lead item, then remove
        // it from cache. Note, that we restore the hidden status to false, since
        // the item is still in cache, and may be reused.
        if (this.pinnedItem_ && this.pinnedItem_ !== this.cachedItems_[leadIndex]) {
            if (this.pinnedItem_.hidden) {
                this.removeChild(this.pinnedItem_);
                this.pinnedItem_.hidden = false;
            }
            this.pinnedItem_ = null;
        }
        this.mergeItems(firstIndex, lastIndex);
        if (!this.pinnedItem_ && this.cachedItems_[leadIndex] &&
            this.cachedItems_[leadIndex].parentNode === this) {
            this.pinnedItem_ = this.cachedItems_[leadIndex] ?? null;
        }
        this.afterFiller_.style.height = afterFillerHeight + 'px';
        // Restores the number of pixels scrolled, since it might be changed while
        // DOM operations.
        this.scrollTop = scrollTop;
        // We don't set the lead or selected properties until after adding all
        // items, in case they force relayout in response to these events.
        if (leadIndex !== -1 && this.cachedItems_[leadIndex]) {
            this.cachedItems_[leadIndex].lead = true;
        }
        for (let y = firstIndex; y < lastIndex; y++) {
            if (sm.getIndexSelected(y) !== this.cachedItems_[y].selected) {
                this.cachedItems_[y].selected = !this.cachedItems_[y].selected;
            }
        }
        this.firstIndex_ = firstIndex;
        this.lastIndex_ = lastIndex;
        this.remainingSpace_ = itemsInViewPort.last > dataModel.length;
        // Mesurings must be placed after adding all the elements, to prevent
        // performance reducing.
        if (!this.fixedHeight_) {
            for (let y = firstIndex; y < lastIndex; y++) {
                this.cachedItemHeights_[y] =
                    this.measureItemHeight_(this.cachedItems_[y]);
            }
        }
    }
    /**
     * Restore the lead item that is present in the list but may be updated
     * in the data model (supposed to be used inside a batch update). Usually
     * such an item would be recreated in the redraw method. If reinsertion
     * is undesirable (for instance to prevent losing focus) the item may be
     * updated and restored. Assumed the listItem relates to the same data
     * item as the lead item in the begin of the batch update.
     *
     * @param leadItem Already existing lead item.
     */
    restoreLeadItem(leadItem) {
        delete this.cachedItems_[leadItem.listIndex];
        leadItem.listIndex = this.selectionModel.leadIndex;
        this.pinnedItem_ = this.cachedItems_[leadItem.listIndex] = leadItem;
    }
    /**
     * Invalidates list by removing cached items.
     */
    invalidate() {
        this.cachedItems_ = {};
    }
    /**
     * Redraws a single item.
     * @param index The row index to redraw.
     */
    redrawItem(index) {
        if (index >= this.firstIndex_ &&
            (index < this.lastIndex_ || this.remainingSpace_)) {
            delete this.cachedItems_[index];
            this.redraw();
        }
    }
    /**
     * Called when a list item is activated, currently only by a double click
     * event.
     * @param _index The index of the activated item.
     */
    activateItemAtIndex(_index) { }
    /**
     * Returns a ListItem for the leadIndex. If the item isn't present in the
     * list creates it and inserts to the list (may be invisible if it's out
     * of the visible range).
     *
     * Item returned from this method won't be removed until it remains a lead
     * item or till the data model changes (unlike other items that could be
     * removed when they go out of the visible range).
     */
    ensureLeadItemExists() {
        const index = this.selectionModel.leadIndex;
        if (index < 0) {
            return null;
        }
        const cachedItems = this.cachedItems_ || {};
        const item = cachedItems[index] || this.createItem(this.dataModel.item(index));
        if (this.pinnedItem_ !== item && this.pinnedItem_ &&
            this.pinnedItem_.hidden) {
            this.removeChild(this.pinnedItem_);
        }
        this.pinnedItem_ = item;
        cachedItems[index] = item;
        item.listIndex = index;
        // 'Element'.;
        if (item.parentNode === this) {
            return item;
        }
        if (this.batchCount_ !== 0) {
            item.hidden = true;
        }
        // Item will get to the right place in redraw. Choose place to insert
        // reducing items reinsertion.
        if (index <= this.firstIndex_) {
            this.insertBefore(item, this.beforeFiller_?.nextSibling);
        }
        else {
            this.insertBefore(item, this.afterFiller_);
        }
        this.redraw();
        return item;
    }
    /**
     * Starts drag selection by reacting 'dragstart' event.
     * @param event Event of dragstart.
     */
    startDragSelection(event) {
        event.preventDefault();
        const border = document.createElement('div');
        border.className = 'drag-selection-border';
        const rect = this.getBoundingClientRect();
        const startX = event.clientX - rect.left + this.scrollLeft;
        const startY = event.clientY - rect.top + this.scrollTop;
        border.style.left = startX + 'px';
        border.style.top = startY + 'px';
        const onMouseMove = (event) => {
            const inRect = this.getBoundingClientRect();
            const x = event.clientX - inRect.left + this.scrollLeft;
            const y = event.clientY - inRect.top + this.scrollTop;
            border.style.left = Math.min(startX, x) + 'px';
            border.style.top = Math.min(startY, y) + 'px';
            border.style.width = Math.abs(startX - x) + 'px';
            border.style.height = Math.abs(startY - y) + 'px';
        };
        const onMouseUp = () => {
            this.removeChild(border);
            document.removeEventListener('mousemove', onMouseMove, true);
            document.removeEventListener('mouseup', onMouseUp, true);
        };
        document.addEventListener('mousemove', onMouseMove, true);
        document.addEventListener('mouseup', onMouseUp, true);
        this.appendChild(border);
    }
    handleMouseDown_(e) {
        const target = e.target;
        const listItem = this.getListItemAncestor(target);
        const wasSelected = listItem && listItem.selected;
        this.handlePointerDownUp_(e);
        if (e.defaultPrevented || e.button !== 0) {
            return;
        }
        // The following hack is required only if the listItem gets selected.
        if (!listItem || wasSelected || !listItem.selected) {
            return;
        }
        // If non-focusable area in a list item is clicked and the item still
        // contains the focused element, the item did a special focus handling
        // [1] and we should not focus on the list.
        //
        // [1] For example, clicking non-focusable area gives focus on the first
        // form control in the item.
        if (!containsFocusableElement(target, listItem) &&
            listItem.contains(listItem.ownerDocument.activeElement)) {
            e.preventDefault();
        }
    }
    /**
     * Dragstart event handler.
     * If there is an item at starting position of drag operation and the item
     * is not selected, select it.
     * @param e The event object for 'dragstart'.
     */
    handleDragStart_(e) {
        const target = e.target;
        const element = target.ownerDocument.elementFromPoint(e.clientX, e.clientY);
        const listItem = this.getListItemAncestor(element);
        if (!listItem) {
            return;
        }
        const index = this.getIndexOfListItem(listItem);
        if (index === -1) {
            return;
        }
        const isAlreadySelected = this.selectionModel_.getIndexSelected(index);
        if (!isAlreadySelected) {
            this.selectionModel_.selectedIndex = index;
        }
    }
    get disabled() {
        return this.hasAttribute('disabled');
    }
    set disabled(value) {
        boolAttrSetter(this, 'disabled', value);
    }
    /**
     * Whether the list or one of its descendents has focus. This is necessary
     * because list items can contain controls that can be focused, and for some
     * purposes (e.g., styling), the list can still be conceptually focused at
     * that point even though it doesn't actually have the page focus.
     */
    get hasElementFocus() {
        return this.hasAttribute('hasElementFocus');
    }
    set hasElementFocus(value) {
        boolAttrSetter(this, 'hasElementFocus', value);
    }
}
/**
 * Check if |start| or its ancestor under |root| is focusable.
 * This is a helper for handleMouseDown.
 * @param start An element which we start to check.
 * @param root An element which we finish to check.
 * @return True if we found a focusable element.
 */
function containsFocusableElement(start, root) {
    for (let element = start; element && element !== root; element = element.parentElement) {
        if (element.tabIndex >= 0 && isDisabled(element)) {
            return true;
        }
    }
    return false;
}
function isDisabled(element) {
    if ('disabled' in element && element.disabled) {
        return true;
    }
    return false;
}

// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * The IDs of elements that can trigger share action.
 */
var SharingActionElementId;
(function (SharingActionElementId) {
    SharingActionElementId["CONTEXT_MENU"] = "file-list";
    SharingActionElementId["SHARE_SHEET"] = "sharesheet-button";
})(SharingActionElementId || (SharingActionElementId = {}));
function isList(element) {
    if (element && 'selectedItems' in element) {
        return true;
    }
    return false;
}
function isMenu(element) {
    if (element && 'contextElement' in element) {
        return true;
    }
    return false;
}
function isMenuItem(element) {
    if (element && 'parentElement' in element &&
        isMenu(element.parentElement)) {
        return true;
    }
    return false;
}
/**
 * Helper function that for the given event returns the launch source of the
 * sharesheet. If the source cannot be determined, this function returns
 * chrome.fileManagerPrivate.SharesheetLaunchSource.UNKNOWN.
 */
function getSharesheetLaunchSource(event) {
    const id = event.target.id;
    switch (id) {
        case SharingActionElementId.CONTEXT_MENU:
            return chrome.fileManagerPrivate.SharesheetLaunchSource.CONTEXT_MENU;
        case SharingActionElementId.SHARE_SHEET:
            return chrome.fileManagerPrivate.SharesheetLaunchSource.SHARESHEET_BUTTON;
        default: {
            console.error('Unrecognized event.target.id for sharesheet launch', id);
            return chrome.fileManagerPrivate.SharesheetLaunchSource.UNKNOWN;
        }
    }
}
/**
 * Extracts entry on which command event was dispatched.
 */
function getCommandEntry(fileManager, element) {
    const entries = getCommandEntries(fileManager, element);
    return entries.length === 0 ? undefined : entries[0];
}
/**
 * Extracts entries on which command event was dispatched.
 */
function getCommandEntries(fileManager, element) {
    if (isTreeItem(element)) {
        const entry = getTreeItemEntry(element);
        if (entry) {
            return [entry];
        }
    }
    // DirectoryTree has the focused item.
    const focusedItem = getFocusedTreeItem(element);
    const entry = getTreeItemEntry(focusedItem);
    if (entry) {
        return [entry];
    }
    const htmlElement = element;
    // The event target could still be a descendant of a legacy TreeItem element
    // (e.g. the eject button).
    // Handle eject button in the new directory tree.
    if (htmlElement.classList.contains('root-eject')) {
        const treeItem = htmlElement.closest('xf-tree-item');
        const entry = treeItem && getTreeItemEntry(treeItem);
        if (entry) {
            return [entry];
        }
    }
    // File list (List).
    if (isList(element) && element.selectedItems.length) {
        const entries = element.selectedItems;
        // Check if it is Entry or not by checking for toURL().
        return entries.filter(entry => ('toURL' in entry));
    }
    // Commands in the action bar can only act in the currently selected files.
    if (fileManager.ui.actionbar.contains(htmlElement)) {
        return fileManager.getSelection().entries;
    }
    // Context Menu: redirect to the element the context menu is displayed for.
    if (isMenu(element) && element.contextElement) {
        return getCommandEntries(fileManager, element.contextElement);
    }
    // Context Menu Item: redirect to the element the context menu is displayed
    // for.
    if (isMenuItem(element)) {
        const menu = element.parentElement;
        if (menu.contextElement) {
            return getCommandEntries(fileManager, menu.contextElement);
        }
    }
    return [];
}
/**
 * Extracts a directory which contains entries on which command event was
 * dispatched.
 */
function getParentEntry(element, directoryModel) {
    const focusedItem = getFocusedTreeItem(element);
    const parentItem = focusedItem?.parentItem;
    if (isTreeItem(parentItem) && getTreeItemEntry(parentItem)) {
        // DirectoryTree has the focused item.
        return getTreeItemEntry(parentItem);
    }
    if (element instanceof List) {
        return directoryModel ? directoryModel.getCurrentDirEntry() : null;
    }
    return null;
}
/**
 * Returns VolumeInfo from the current target for commands, based on |element|.
 * It can be from directory tree (clicked item or selected item), or from file
 * list selected items; or null if can determine it.
 */
function getElementVolumeInfo(element, fileManager) {
    if (element && 'volumeInfo' in element) {
        return element.volumeInfo;
    }
    const entry = getCommandEntry(fileManager, element);
    return entry && fileManager.volumeManager.getVolumeInfo(entry);
}
/**
 * Sets the command as visible only when the current volume is drive and it's
 * running as a normal app, not as a modal dialog.
 * NOTE: This doesn't work for directory tree menu, because user can right-click
 * on any visible volume.
 */
function canExecuteVisibleOnDriveInNormalAppModeOnly(event, fileManager) {
    const enabled = fileManager.directoryModel.isOnDrive() &&
        !isModal(fileManager.dialogType);
    event.canExecute = enabled;
    event.command.setHidden(!enabled);
}
/**
 * Sets the default handler for the commandId and prevents handling
 * the keydown events for this command. Not doing that breaks relationship
 * of original keyboard event and the command. WebKit would handle it
 * differently in some cases.
 */
function forceDefaultHandler(node, commandId) {
    const doc = node.ownerDocument;
    const command = doc.body.querySelector('command[id="' + commandId + '"]');
    node.addEventListener('keydown', e => {
        if (command.matchesEvent(e)) {
            e.stopPropagation();
        }
    });
    node.addEventListener('command', (event) => {
        if (event.detail.command.id !== commandId) {
            return;
        }
        document.execCommand(event.detail.command.id);
        event.cancelBubble = true;
    });
    node.addEventListener('canExecute', ((event) => {
        if (event.command.id !== commandId || event.target !== node) {
            return;
        }
        event.canExecute = document.queryCommandEnabled(event.command.id);
        event.command.setHidden(false);
    }));
}
/**
 * Returns a directory entry when only one entry is selected and it is
 * directory. Otherwise, returns null.
 * @param selection Instance of FileSelection.
 * @return Directory entry which is selected alone.
 */
function getOnlyOneSelectedDirectory(selection) {
    if (!selection) {
        return null;
    }
    if (selection.totalCount !== 1) {
        return null;
    }
    if (!selection.entries[0].isDirectory) {
        return null;
    }
    return selection.entries[0];
}
/**
 * Returns true if the given entry is the root entry of the volume.
 * @param volumeManager
 * @param entry Entry or a fake entry.
 * @return True if the entry is a root entry.
 */
function isRootEntry(volumeManager, entry) {
    if (!volumeManager || !entry) {
        return false;
    }
    const volumeInfo = volumeManager.getVolumeInfo(entry);
    return !!volumeInfo && isSameEntry(volumeInfo.displayRoot, entry);
}
/**
 * Returns true if the given event was triggered by the selection menu button.
 * @param event Command event.
 * @return True if the event was triggered by the selection menu button.
 */
function isFromSelectionMenu(event) {
    return event.target.id === 'selection-menu-button';
}
/**
 * If entry is fake/invalid/non-interactive/root, we don't show menu items
 * intended for regular entries.
 * @param volumeManager
 * @param entry Entry or a fake entry.
 * @return True if we should show the menu items for regular entries.
 */
function shouldShowMenuItemsForEntry(volumeManager, entry) {
    // If the entry is fake entry, hide context menu entries.
    if (isFakeEntry(entry)) {
        return false;
    }
    // If the entry is not a valid entry, hide context menu entries.
    if (!volumeManager) {
        return false;
    }
    const volumeInfo = volumeManager.getVolumeInfo(entry);
    if (!volumeInfo) {
        return false;
    }
    // If the entry belongs to a non-interactive volume, hide context menu
    // entries.
    if (!isInteractiveVolume(volumeInfo)) {
        return false;
    }
    // If the entry is root entry of its volume (but not a team drive root),
    // hide context menu entries.
    if (isRootEntry(volumeManager, entry) && !isTeamDriveRoot(entry)) {
        return false;
    }
    if (isTeamDrivesGrandRoot(entry)) {
        return false;
    }
    return true;
}
/**
 * Returns whether all of the given entries have the given capability.
 *
 * @param fileManager CommandHandlerDeps.
 * @param entries List of entries to check capabilities for.
 * @param capability Name of the capability to check for.
 */
function hasCapability(fileManager, entries, capability) {
    if (entries.length === 0) {
        return false;
    }
    // Check if the capability is true or undefined, but not false. A capability
    // can be undefined if the metadata is not fetched from the server yet (e.g.
    // if we create a new file in offline mode), or if there is a problem with the
    // cache and we don't have data yet. For this reason, we need to allow the
    // functionality even if it's not set.
    // TODO(crbug.com/41392991): Store restrictions instead of capabilities.
    const metadata = fileManager.metadataModel.getCache(entries, [capability]);
    return metadata.length === entries.length &&
        metadata.every(item => item[capability] !== false);
}
/**
 * Checks if the handler should ignore the current event, eg. since there is
 * a popup dialog currently opened.
 *
 * @return True if the event should be ignored, false otherwise.
 */
function shouldIgnoreEvents(doc) {
    // Do not handle commands, when a dialog is shown. Do not use querySelector
    // as it's much slower, and this method is executed often.
    const dialogs = doc.getElementsByClassName('cr-dialog-container');
    if (dialogs.length !== 0 && dialogs[0].classList.contains('shown')) {
        return true;
    }
    return false; // Do not ignore.
}
/**
 * Returns true if all entries is inside Drive volume, which includes all Drive
 * parts (Shared Drives, My Drive, Shared with me, etc).
 */
function isDriveEntries(entries, volumeManager) {
    if (!entries.length) {
        return false;
    }
    const volumeInfo = volumeManager.getVolumeInfo(entries[0]);
    if (!volumeInfo) {
        return false;
    }
    if (volumeInfo.volumeType === VolumeType.DRIVE &&
        isSameVolume(entries, volumeManager)) {
        return true;
    }
    return false;
}
/**
 * Returns true if all entries descend from the My Drive root (e.g. not located
 * within Shared with me or Shared drives).
 */
function isOnlyMyDriveEntries(entries, state) {
    if (!entries.length) {
        return false;
    }
    for (const entry of entries) {
        const fileData = getFileData(state, entry.toURL());
        if (!fileData) {
            return false;
        }
        if (fileData.rootType !== RootType.DRIVE) {
            return false;
        }
    }
    return true;
}
/**
 * Returns true if the current root is Trash. Items in Trash are a fake
 * representation of a file + its metadata. Some actions are infeasible and
 * items should be restored to enable these actions.
 */
function isOnTrashRoot(fileManager) {
    const currentRootType = fileManager.directoryModel.getCurrentRootType();
    if (!currentRootType) {
        return false;
    }
    return isTrashRootType(currentRootType);
}
/**
 * Extracts entry on which command event was dispatched.
 */
function getEventEntry(event, fileManager) {
    let entry;
    const htmlElement = event.target;
    if (fileManager.ui.directoryTree.contains(htmlElement)) {
        // The command is executed from the directory tree context menu.
        entry = getCommandEntry(fileManager, htmlElement);
    }
    else {
        // The command is executed from the gear menu.
        entry = fileManager.directoryModel.getCurrentDirEntry();
    }
    return entry;
}
/**
 * Returns true if the current volume is interactive.
 */
function currentVolumeIsInteractive(fileManager) {
    const volumeInfo = fileManager.directoryModel.getCurrentVolumeInfo();
    if (!volumeInfo) {
        return true;
    }
    return isInteractiveVolume(volumeInfo);
}
/**
 * Returns true if any entry belongs to a non-interactive volume.
 */
function containsNonInteractiveEntry(entries, fileManager) {
    return entries.some(entry => {
        const volumeInfo = fileManager.volumeManager.getVolumeInfo(entry);
        if (!volumeInfo) {
            return false;
        }
        return isInteractiveVolume(volumeInfo);
    });
}

// Copyright 2012 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * Used to filter out `VolumeInfo` that don't exist and maintain the return
 * array is of type `VolumeInfo[]` without null or undefined.
 */
function isVolumeInfo(volumeInfo) {
    return !isNullOrUndefined(volumeInfo);
}
/**
 * A command.
 */
class FilesCommand {
    /**
     * Handles the can execute event.
     * By default, sets the command as always enabled.
     * @param event Can execute event.
     * @param fileManager CommandHandlerDeps.
     */
    canExecute(event, _fileManager) {
        event.canExecute = true;
    }
}
/**
 * Unmounts external drive.
 */
class UnmountCommand extends FilesCommand {
    /**
     * @param event Command event.
     * @param fileManager CommandHandlerDeps.
     */
    async executeImpl_(event, fileManager) {
        const errorCallback = (volumeType) => {
            if (volumeType === VolumeType.REMOVABLE) {
                fileManager.ui.alertDialog.showHtml('', str('UNMOUNT_FAILED'));
            }
            else {
                fileManager.ui.alertDialog.showHtml('', str('UNMOUNT_PROVIDED_FAILED'));
            }
        };
        // Find volumes to unmount.
        let volumes = [];
        let label = '';
        const entry = getCommandEntry(fileManager, event.target);
        if (entry instanceof EntryList) {
            // The element is a group of removable partitions.
            if (!entry) {
                errorCallback();
                return;
            }
            // Add child partitions to the list of volumes to be unmounted.
            volumes = entry.getUiChildren()
                .map(child => ('volumeInfo' in child) ?
                child.volumeInfo :
                null)
                .filter(isVolumeInfo);
            label = entry.label || '';
        }
        else {
            // The element is a removable volume with no partitions.
            const volumeInfo = getElementVolumeInfo(event.target, fileManager);
            if (!volumeInfo) {
                errorCallback();
                return;
            }
            volumes.push(volumeInfo);
            label = volumeInfo.label || '';
        }
        // Eject volumes of which there may be multiple.
        const promises = volumes.map(async (volume) => {
            try {
                await fileManager.volumeManager.unmount(volume);
            }
            catch (error) {
                console.warn('Cannot unmount (redacted):', error);
                debug(`Cannot unmount '${volume.volumeId}':`, error);
                if (error !== VolumeError.PATH_NOT_MOUNTED) {
                    errorCallback(volume.volumeType);
                }
            }
        });
        await Promise.all(promises);
        fileManager.ui.speakA11yMessage(strf('A11Y_VOLUME_EJECT', label));
    }
    execute(event, fileManager) {
        this.executeImpl_(event, fileManager);
    }
    canExecute(event, fileManager) {
        const volumeInfo = getElementVolumeInfo(event.target, fileManager);
        const entry = getCommandEntry(fileManager, event.target);
        let volumeType;
        if (entry && entry instanceof EntryList) {
            volumeType = entry.rootType;
        }
        else if (volumeInfo) {
            volumeType = volumeInfo.volumeType;
        }
        else {
            event.canExecute = false;
            event.command.setHidden(true);
            return;
        }
        event.canExecute =
            (volumeType === VolumeType.ARCHIVE ||
                volumeType === VolumeType.REMOVABLE ||
                volumeType === VolumeType.PROVIDED || volumeType === VolumeType.SMB);
        event.command.setHidden(!event.canExecute);
        switch (volumeType) {
            case VolumeType.ARCHIVE:
            case VolumeType.PROVIDED:
            case VolumeType.SMB:
                event.command.label = str('CLOSE_VOLUME_BUTTON_LABEL');
                break;
            case VolumeType.REMOVABLE:
                event.command.label = str('UNMOUNT_DEVICE_BUTTON_LABEL');
                break;
        }
    }
}
/**
 * Formats external drive.
 */
class FormatCommand extends FilesCommand {
    execute(event, fileManager) {
        const directoryModel = fileManager.directoryModel;
        let root;
        if (fileManager.ui.directoryTree?.contains(event.target)) {
            // The command is executed from the directory tree context menu.
            root = getCommandEntry(fileManager, event.target);
        }
        else {
            // The command is executed from the gear menu.
            root = directoryModel.getCurrentDirEntry();
        }
        // If an entry is not found from the event target, use the current
        // directory. This can happen for the format button for unsupported and
        // unrecognized volumes.
        if (!root) {
            root = directoryModel.getCurrentDirEntry();
        }
        assert$1(root);
        const volumeInfo = fileManager.volumeManager.getVolumeInfo(root);
        if (volumeInfo) {
            fileManager.ui.formatDialog.showModal(volumeInfo);
        }
    }
    canExecute(event, fileManager) {
        const directoryModel = fileManager.directoryModel;
        let root;
        if (fileManager.ui.directoryTree?.contains(event.target)) {
            // The command is executed from the directory tree context menu.
            root = getCommandEntry(fileManager, event.target);
        }
        else {
            // The command is executed from the gear menu.
            root = directoryModel.getCurrentDirEntry();
        }
        // |root| is null for unrecognized volumes. Enable format command for such
        // volumes.
        const isUnrecognizedVolume = (root === null);
        // See the comment in execute() for why doing this.
        if (!root) {
            root = directoryModel.getCurrentDirEntry();
        }
        const location = root && fileManager.volumeManager.getLocationInfo(root);
        const writable = !!location && !location.isReadOnly;
        const isRoot = location && location.isRootEntry;
        // Enable the command if this is a removable device (e.g. a USB drive).
        const removableRoot = location && isRoot && location.rootType === RootType.REMOVABLE;
        event.canExecute = !!removableRoot && (isUnrecognizedVolume || writable);
        if (isSinglePartitionFormatEnabled()) {
            let isDevice = false;
            if (root && root instanceof EntryList) {
                // root entry is device node if it has child (partition).
                isDevice = !!removableRoot && root.getUiChildren().length > 0;
            }
            // Disable format command on device when SinglePartitionFormat on,
            // erase command will be available.
            event.command.setHidden(!removableRoot || isDevice);
        }
        else {
            event.command.setHidden(!removableRoot);
        }
    }
}
/**
 * Deletes removable device partition, creates single partition and formats it.
 */
class EraseDeviceCommand extends FilesCommand {
    execute(event, fileManager) {
        const root = getEventEntry(event, fileManager);
        if (root && root instanceof EntryList) {
            fileManager.ui.formatDialog.showEraseModal(root);
        }
    }
    canExecute(event, fileManager) {
        if (!isSinglePartitionFormatEnabled()) {
            event.canExecute = false;
            event.command.setHidden(true);
            return;
        }
        const root = getEventEntry(event, fileManager);
        const location = root && fileManager.volumeManager.getLocationInfo(root);
        const writable = location && !location.isReadOnly;
        const isRoot = location && location.isRootEntry;
        const removableRoot = location && isRoot && location.rootType === RootType.REMOVABLE;
        let isDevice = false;
        if (root && root instanceof EntryList) {
            // root entry is device node if it has child (partition).
            isDevice = !!removableRoot && root.getUiChildren().length > 0;
        }
        event.canExecute = !!removableRoot && !writable;
        // Enable the command if this is a removable and device node.
        event.command.setHidden(!removableRoot || !isDevice);
    }
}
/**
 * Initiates new folder creation.
 */
class NewFolderCommand extends FilesCommand {
    constructor() {
        super(...arguments);
        /**
         * Whether a new-folder is in progress.
         */
        this.busy_ = false;
    }
    execute(event, fileManager) {
        if (isOnTrashRoot(fileManager)) {
            return;
        }
        let targetDirectory;
        let executedFromDirectoryTree;
        if (isXfTree(event.target)) {
            const focusedTreeItem = getFocusedTreeItem(event.target);
            targetDirectory = getTreeItemEntry(focusedTreeItem);
            executedFromDirectoryTree = true;
        }
        else if (isTreeItem(event.target)) {
            targetDirectory = getTreeItemEntry(event.target);
            executedFromDirectoryTree = true;
        }
        else {
            targetDirectory = fileManager.directoryModel.getCurrentDirEntry();
            executedFromDirectoryTree = false;
        }
        const directoryModel = fileManager.directoryModel;
        const listContainer = fileManager.ui.listContainer;
        this.busy_ = true;
        assert$1(targetDirectory);
        const directoryEntry = unwrapEntry(targetDirectory);
        this.generateNewDirectoryName_(directoryEntry).then((newName) => {
            if (!executedFromDirectoryTree) {
                listContainer.startBatchUpdates();
            }
            return new Promise(directoryEntry.getDirectory.bind(directoryEntry, newName, { create: true, exclusive: true }))
                .then((newDirectory) => {
                recordUserAction('CreateNewFolder');
                // Select new directory and start rename operation.
                if (executedFromDirectoryTree) {
                    const parentFileKey = directoryEntry.toURL();
                    // After new directory is created on parent directory, we
                    // need to expand it otherwise the new child item won't
                    // show, and also trigger a re-scan for the parent
                    // directory.
                    getStore().dispatch(updateFileData({
                        key: parentFileKey,
                        partialFileData: { expanded: true },
                    }));
                    getStore().dispatch(readSubDirectories(parentFileKey));
                    fileManager.ui.directoryTreeContainer
                        ?.renameItemWithKeyWhenRendered(newDirectory.toURL());
                    this.busy_ = false;
                }
                else {
                    directoryModel.updateAndSelectNewDirectory(newDirectory)
                        .then(() => {
                        listContainer.endBatchUpdates();
                        fileManager.namingController.initiateRename();
                        this.busy_ = false;
                    })
                        .catch(error => {
                        listContainer.endBatchUpdates();
                        this.busy_ = false;
                        console.warn(error);
                    });
                }
            }, (error) => {
                if (!executedFromDirectoryTree) {
                    listContainer.endBatchUpdates();
                }
                this.busy_ = false;
                fileManager.ui.alertDialog.show(strf('ERROR_CREATING_FOLDER', newName, getFileErrorString(error.name)));
            });
        });
    }
    /**
     * Generates new directory name.
     */
    generateNewDirectoryName_(parentDirectory, index = 0) {
        const defaultName = str('DEFAULT_NEW_FOLDER_NAME');
        const newName = index === 0 ? defaultName : defaultName + ' (' + index + ')';
        return new Promise(parentDirectory.getDirectory.bind(parentDirectory, newName, { create: false }))
            .then(_newEntry => {
            return this.generateNewDirectoryName_(parentDirectory, index + 1);
        })
            .catch(() => {
            return newName;
        });
    }
    canExecute(event, fileManager) {
        if (isOnTrashRoot(fileManager)) {
            event.canExecute = false;
            event.command.setHidden(true);
            return;
        }
        const entries = getCommandEntries(fileManager, event.target);
        // If there is a selected entry on a non-interactive volume, remove
        // new-folder command.
        if (entries.length > 0 &&
            !containsNonInteractiveEntry(entries, fileManager)) {
            event.canExecute = false;
            event.command.setHidden(true);
            return;
        }
        if (isXfTree(event.target) || isTreeItem(event.target)) {
            const entry = entries[0];
            if (!entry || isFakeEntry(entry) || isTeamDrivesGrandRoot(entry)) {
                event.canExecute = false;
                event.command.setHidden(true);
                return;
            }
            const locationInfo = fileManager.volumeManager.getLocationInfo(entry);
            event.canExecute = !!locationInfo && !locationInfo.isReadOnly &&
                hasCapability(fileManager, [entry], 'canAddChildren');
            event.command.setHidden(false);
        }
        else {
            // If blank space was clicked and current volume is non-interactive,
            // remove new-folder command.
            if (entries.length === 0 && !currentVolumeIsInteractive(fileManager)) {
                event.canExecute = false;
                event.command.setHidden(true);
                return;
            }
            const directoryModel = fileManager.directoryModel;
            const directoryEntry = fileManager.getCurrentDirectoryEntry();
            event.canExecute = !fileManager.directoryModel.isReadOnly() &&
                !fileManager.namingController.isRenamingInProgress() &&
                !directoryModel.isSearching() &&
                hasCapability(fileManager, [directoryEntry], 'canAddChildren');
            event.command.setHidden(false);
        }
        if (this.busy_) {
            event.canExecute = false;
        }
    }
}
/**
 * Initiates new window creation.
 */
class NewWindowCommand extends FilesCommand {
    execute(_event, fileManager) {
        fileManager.launchFileManager({
            currentDirectoryURL: fileManager.getCurrentDirectoryEntry() &&
                fileManager.getCurrentDirectoryEntry().toURL(),
        });
    }
    canExecute(event, fileManager) {
        event.canExecute = !!fileManager.getCurrentDirectoryEntry() &&
            (fileManager.dialogType === DialogType.FULL_PAGE);
    }
}
class SelectAllCommand extends FilesCommand {
    execute(_event, fileManager) {
        fileManager.directoryModel.getFileListSelection().setCheckSelectMode(true);
        fileManager.directoryModel.getFileListSelection().selectAll();
    }
    canExecute(event, fileManager) {
        // Check we can select multiple items.
        const multipleSelect = fileManager.directoryModel.getFileListSelection().multiple;
        // Check we are not inside an input element (e.g. the search box).
        const inputElementActive = document.activeElement instanceof HTMLInputElement ||
            document.activeElement instanceof HTMLTextAreaElement ||
            document.activeElement?.tagName.toLowerCase() === 'cr-input';
        event.canExecute = multipleSelect && !inputElementActive &&
            fileManager.directoryModel.getFileList().length > 0;
    }
}
class ToggleHiddenFilesCommand extends FilesCommand {
    execute(event, fileManager) {
        const visible = !fileManager.fileFilter.isHiddenFilesVisible();
        fileManager.fileFilter.setHiddenFilesVisible(visible);
        event.detail.command.checked =
            visible; // Check-mark for "Show hidden files".
        recordMenuItemSelected(visible ? MenuCommandsForUma.HIDDEN_FILES_SHOW :
            MenuCommandsForUma.HIDDEN_FILES_HIDE);
    }
}
/**
 * Toggles visibility of top-level Android folders which are not visible by
 * default.
 */
class ToggleHiddenAndroidFoldersCommand extends FilesCommand {
    execute(event, fileManager) {
        const visible = !fileManager.fileFilter.isAllAndroidFoldersVisible();
        fileManager.fileFilter.setAllAndroidFoldersVisible(visible);
        event.detail.command.checked = visible;
        recordMenuItemSelected(visible ? MenuCommandsForUma.HIDDEN_ANDROID_FOLDERS_SHOW :
            MenuCommandsForUma.HIDDEN_ANDROID_FOLDERS_HIDE);
    }
    canExecute(event, fileManager) {
        const hasAndroidFilesVolumeInfo = !!fileManager.volumeManager.getCurrentProfileVolumeInfo(VolumeType.ANDROID_FILES);
        const currentRootType = fileManager.directoryModel.getCurrentRootType();
        const isInMyFiles = currentRootType === RootType.MY_FILES ||
            currentRootType === RootType.DOWNLOADS ||
            currentRootType === RootType.CROSTINI ||
            currentRootType === RootType.ANDROID_FILES;
        event.canExecute = hasAndroidFilesVolumeInfo && isInMyFiles;
        event.command.setHidden(!event.canExecute);
        event.command.checked = fileManager.fileFilter.isAllAndroidFoldersVisible();
    }
}
/**
 * Toggles drive sync settings.
 */
class DriveSyncSettingsCommand extends FilesCommand {
    execute(_event, fileManager) {
        const nowDriveSyncEnabledOnMeteredNetwork = fileManager.ui.gearMenu.syncButton.hasAttribute('checked');
        const changeInfo = {
            driveSyncEnabledOnMeteredNetwork: !nowDriveSyncEnabledOnMeteredNetwork,
        };
        chrome.fileManagerPrivate.setPreferences(changeInfo);
        recordMenuItemSelected(nowDriveSyncEnabledOnMeteredNetwork ?
            MenuCommandsForUma.MOBILE_DATA_ON :
            MenuCommandsForUma.MOBILE_DATA_OFF);
    }
    canExecute(event, fileManager) {
        event.canExecute = fileManager.directoryModel.isOnDrive();
        event.command.setHidden(!event.canExecute);
    }
}
/**
 * Delete / Move to Trash command.
 */
class DeleteCommand extends FilesCommand {
    /**
     */
    execute(event, fileManager) {
        const entries = getCommandEntries(fileManager, event.target);
        const permanentlyDelete = event.detail.command.id === 'delete';
        // Execute might be called without a call of canExecute method, e.g.,
        // called directly from code, crbug.com/509483. See toolbar controller
        // delete button handling, for an example.
        this.deleteEntries(entries, fileManager, permanentlyDelete);
    }
    canExecute(event, fileManager) {
        const entries = getCommandEntries(fileManager, event.target);
        // If entries contain fake, non-interactive or root entry, remove delete
        // option.
        if (!entries.every(shouldShowMenuItemsForEntry.bind(null, fileManager.volumeManager))) {
            event.canExecute = false;
            event.command.setHidden(true);
            return;
        }
        event.canExecute = this.canDeleteEntries_(entries, fileManager);
        // Remove if nothing is selected, e.g. user clicked in an empty
        // space in the file list.
        const noEntries = entries.length === 0;
        event.command.setHidden(noEntries);
        const isTrashDisabled = !shouldMoveToTrash(entries, fileManager.volumeManager) ||
            !fileManager.trashEnabled;
        if (event.command.id === 'move-to-trash' && isTrashDisabled) {
            event.canExecute = false;
            event.command.setHidden(true);
        }
        // If the "move-to-trash" command is enabled, don't show the Delete command
        // but still leave it executable.
        if (event.command.id === 'delete' && !isTrashDisabled) {
            event.command.setHidden(true);
        }
    }
    /**
     * Delete the entries (if the entries can be deleted).
     * @param entries
     * @param fileManager
     * @param permanentlyDelete if true, entries are permanently deleted
     *     rather than moved to trash.
     * @param dialog An optional delete confirm dialog.
     *    The default delete confirm dialog will be used if |dialog| is null.
     * @public
     */
    deleteEntries(entries, fileManager, permanentlyDelete, dialog = null) {
        // Verify that the entries are not fake, non-interactive or root entries,
        // and that they can be deleted.
        if (!entries.every(shouldShowMenuItemsForEntry.bind(null, fileManager.volumeManager)) ||
            !this.canDeleteEntries_(entries, fileManager)) {
            return;
        }
        // Trashing an item shows an "Undo" visual signal instead of a confirmation
        // dialog.
        if (!permanentlyDelete &&
            shouldMoveToTrash(entries, fileManager.volumeManager) &&
            fileManager.trashEnabled) {
            startIOTask(chrome.fileManagerPrivate.IoTaskType.TRASH, entries, 
            /*params=*/ {});
            return;
        }
        if (!dialog) {
            dialog = fileManager.ui.deleteConfirmDialog;
        }
        else if (dialog.showModalElement) {
            dialog.showModalElement();
        }
        const dialogDoneCallback = () => {
            dialog?.doneCallback?.();
            document.querySelector('files-tooltip')?.hideTooltip();
        };
        const deleteAction = () => {
            dialogDoneCallback();
            // Start the permanent delete.
            startIOTask(chrome.fileManagerPrivate.IoTaskType.DELETE, entries, /*params=*/ {});
        };
        const cancelAction = () => {
            dialogDoneCallback();
        };
        // Files that are deleted from locations that are trash enabled (except
        // Drive) should instead show copy indicating the files will be permanently
        // deleted. For all other filesystem the permanent deletion can't
        // necessarily be verified (e.g. a copy may be moved to the underlying
        // filesystems version of trash).
        if (deleteIsForever(entries, fileManager.volumeManager)) {
            const title = entries.length === 1 ?
                str('CONFIRM_PERMANENTLY_DELETE_ONE_TITLE') :
                str('CONFIRM_PERMANENTLY_DELETE_SOME_TITLE');
            const message = entries.length === 1 ?
                strf('CONFIRM_PERMANENTLY_DELETE_ONE_DESC', entries[0].name) :
                strf('CONFIRM_PERMANENTLY_DELETE_SOME_DESC', entries.length);
            dialog.setOkLabel(str('PERMANENTLY_DELETE_FOREVER'));
            dialog.showWithTitle(title, message, deleteAction, cancelAction);
            return;
        }
        const deleteMessage = entries.length === 1 ?
            strf('CONFIRM_DELETE_ONE', entries[0].name) :
            strf('CONFIRM_DELETE_SOME', entries.length);
        dialog.setOkLabel(str('DELETE_BUTTON_LABEL'));
        dialog.show(deleteMessage, deleteAction, cancelAction);
    }
    /**
     * Returns true if all entries can be deleted. Note: This does not check for
     * root or fake entries.
     */
    canDeleteEntries_(entries, fileManager) {
        return entries.length > 0 &&
            !this.containsReadOnlyEntry_(entries, fileManager) &&
            hasCapability(fileManager, entries, 'canDelete');
    }
    /**
     * Returns True if entries can be deleted.
     */
    canDeleteEntries(entries, fileManager) {
        // Verify that the entries are not fake, non-interactive or root entries,
        // and that they can be deleted.
        if (!entries.every(shouldShowMenuItemsForEntry.bind(null, fileManager.volumeManager)) ||
            !this.canDeleteEntries_(entries, fileManager)) {
            return false;
        }
        return true;
    }
    /**
     * Returns true if any entry belongs to a read-only volume or is
     * forced to be read-only like MyFiles>Downloads.
     */
    containsReadOnlyEntry_(entries, fileManager) {
        return entries.some(entry => isReadOnlyForDelete(fileManager.volumeManager, entry));
    }
}
/**
 * Restores selected files from trash.
 */
class RestoreFromTrashCommand extends FilesCommand {
    async execute_(event, fileManager) {
        const entries = getCommandEntries(fileManager, event.target);
        const infoEntries = [];
        const failedParents = [];
        for (const entry of entries) {
            try {
                const { exists, parentName } = await this.getParentName(entry.restoreEntry, fileManager.volumeManager);
                if (!exists) {
                    failedParents.push({ fileName: entry.restoreEntry.name, parentName });
                }
                else {
                    infoEntries.push(entry.infoEntry);
                }
            }
            catch (err) {
                console.warn('Failed getting parent metadata for:', err);
            }
        }
        if (failedParents && failedParents.length > 0) {
            // Only a single item is being trashed and the parent doesn't exist.
            if (failedParents.length === 1 && infoEntries.length === 0) {
                recordEnum(RestoreFailedUMA, RestoreFailedType.SINGLE_ITEM, RestoreFailedTypesUMA);
                fileManager.ui.alertDialog.show(strf('CANT_RESTORE_SINGLE_ITEM', failedParents[0].parentName));
                return;
            }
            // More than one item has been trashed but all the items have their
            // parent removed.
            if (failedParents.length > 1 && infoEntries.length === 0) {
                const isParentFolderSame = failedParents.every(p => p.parentName === failedParents[0].parentName);
                // All the items were from the same parent folder.
                if (isParentFolderSame) {
                    recordEnum(RestoreFailedUMA, RestoreFailedType.MULTIPLE_ITEMS_SAME_PARENTS, RestoreFailedTypesUMA);
                    fileManager.ui.alertDialog.show(strf('CANT_RESTORE_MULTIPLE_ITEMS_SAME_PARENTS', failedParents[0].parentName));
                    return;
                }
                // All the items are from different parent folders.
                recordEnum(RestoreFailedUMA, RestoreFailedType.MULTIPLE_ITEMS_DIFFERENT_PARENTS, RestoreFailedTypesUMA);
                fileManager.ui.alertDialog.show(str('CANT_RESTORE_MULTIPLE_ITEMS_DIFFERENT_PARENTS'));
                return;
            }
            // A mix of items with parents and without parents are attempting to be
            // restored.
            recordEnum(RestoreFailedUMA, RestoreFailedType.MULTIPLE_ITEMS_MIXED, RestoreFailedTypesUMA);
            fileManager.ui.alertDialog.show(str('CANT_RESTORE_SOME_ITEMS'));
            return;
        }
        startIOTask(chrome.fileManagerPrivate.IoTaskType.RESTORE, infoEntries, 
        /*params=*/ {});
    }
    execute(event, fileManager) {
        this.execute_(event, fileManager);
    }
    canExecute(event, fileManager) {
        const entries = getCommandEntries(fileManager, event.target);
        const enabled = entries.length > 0 && entries.every(e => isTrashEntry$1(e)) &&
            fileManager.trashEnabled;
        event.canExecute = enabled;
        event.command.setHidden(!enabled);
    }
    /**
     * Check whether the parent exists from a supplied entry and return the folder
     * name (if it exists or doesn't).
     * @param entry The entry to identify the parent from.
     *     volumeManager
     */
    async getParentName(entry, volumeManager) {
        return new Promise((resolve, reject) => {
            entry.getParent(parent => resolve({ exists: true, parentName: parent.name }), err => {
                // If this failed, it may be because the parent doesn't exist.
                // Extract the parent from the path components in that case.
                if (err.name === 'NotFoundError') {
                    const components = PathComponent.computeComponentsFromEntry(entry, volumeManager);
                    resolve({
                        exists: false,
                        parentName: components[components.length - 2]?.name ?? '',
                    });
                    return;
                }
                reject(err);
            });
        });
    }
}
/**
 * Empties (permanently deletes all) files from trash.
 */
class EmptyTrashCommand extends FilesCommand {
    execute(_event, fileManager) {
        fileManager.ui.emptyTrashConfirmDialog.showWithTitle(str('CONFIRM_EMPTY_TRASH_TITLE'), str('CONFIRM_EMPTY_TRASH_DESC'), () => {
            startIOTask(chrome.fileManagerPrivate.IoTaskType.EMPTY_TRASH, /*entries=*/ [], 
            /*params=*/ {});
        });
    }
    canExecute(event, fileManager) {
        const entries = getCommandEntries(fileManager, event.target);
        const trashRoot = entries.length === 1 && isTrashRoot(entries[0]) &&
            fileManager.trashEnabled;
        event.canExecute = trashRoot || isOnTrashRoot(fileManager);
        event.command.setHidden(!trashRoot);
    }
}
/**
 * Pastes files from clipboard.
 */
class PasteCommand extends FilesCommand {
    execute(event, fileManager) {
        if (isOnTrashRoot(fileManager)) {
            return;
        }
        fileManager.document.execCommand(event.detail.command.id);
    }
    canExecute(event, fileManager) {
        if (isOnTrashRoot(fileManager)) {
            event.canExecute = false;
            event.command.setHidden(true);
            return;
        }
        const fileTransferController = fileManager.fileTransferController;
        event.canExecute = !!fileTransferController &&
            !!fileTransferController.queryPasteCommandEnabled(fileManager.directoryModel.getCurrentDirEntry());
        // Hide this command if only one folder is selected.
        event.command.setHidden(!!getOnlyOneSelectedDirectory(fileManager.getSelection()));
        const entries = getCommandEntries(fileManager, event.target);
        // If there is a selected entry on a non-interactive volume, remove paste
        // command.
        if (entries.length > 0 &&
            !containsNonInteractiveEntry(entries, fileManager)) {
            event.canExecute = false;
            event.command.setHidden(true);
            return;
        }
        else if (entries.length === 0 && !currentVolumeIsInteractive(fileManager)) {
            // If blank space was clicked and current volume is non-interactive,
            // remove paste command.
            event.canExecute = false;
            event.command.setHidden(true);
            return;
        }
    }
}
/**
 * Pastes files from clipboard. This is basically same as 'paste'.
 * This command is used for always showing the Paste command to gear menu.
 */
class PasteIntoCurrentFolderCommand extends FilesCommand {
    execute(_event, fileManager) {
        fileManager.document.execCommand('paste');
    }
    canExecute(event, fileManager) {
        const fileTransferController = fileManager.fileTransferController;
        event.canExecute = !!fileTransferController &&
            !!fileTransferController.queryPasteCommandEnabled(fileManager.directoryModel.getCurrentDirEntry());
    }
}
/**
 * Pastes files from clipboard into the selected folder.
 */
class PasteIntoFolderCommand extends FilesCommand {
    execute(event, fileManager) {
        if (isOnTrashRoot(fileManager)) {
            return;
        }
        const entries = getCommandEntries(fileManager, event.target);
        if (entries.length !== 1 || !entries[0].isDirectory ||
            !shouldShowMenuItemsForEntry(fileManager.volumeManager, entries[0])) {
            return;
        }
        // This handler tweaks the Event object for 'paste' event so that
        // the FileTransferController can distinguish this 'paste-into-folder'
        // command and know the destination directory.
        const handler = (inEvent) => {
            inEvent.destDirectory = entries[0];
        };
        fileManager.document.addEventListener('paste', handler, true);
        fileManager.document.execCommand('paste');
        fileManager.document.removeEventListener('paste', handler, true);
    }
    canExecute(event, fileManager) {
        if (isOnTrashRoot(fileManager)) {
            event.canExecute = false;
            event.command.setHidden(true);
            return;
        }
        const entries = getCommandEntries(fileManager, event.target);
        // Show this item only when one directory is selected.
        if (entries.length !== 1 || !entries[0].isDirectory ||
            !shouldShowMenuItemsForEntry(fileManager.volumeManager, entries[0])) {
            event.canExecute = false;
            event.command.setHidden(true);
            return;
        }
        const fileTransferController = fileManager.fileTransferController;
        event.canExecute = !!fileTransferController &&
            !!fileTransferController.queryPasteCommandEnabled(entries[0]);
        event.command.setHidden(false);
    }
}
/**
 * Cut/Copy command.
 */
class CutCopyCommand extends FilesCommand {
    execute(event, fileManager) {
        if (isOnTrashRoot(fileManager)) {
            return;
        }
        // Cancel check-select-mode on cut/copy.  Any further selection of a dir
        // should start a new selection rather than add to the existing selection.
        fileManager.directoryModel.getFileListSelection().setCheckSelectMode(false);
        fileManager.document.execCommand(event.detail.command.id);
    }
    canExecute(event, fileManager) {
        const fileTransferController = fileManager.fileTransferController;
        if (!fileTransferController) {
            // File Open and SaveAs dialogs do not have a fileTransferController.
            event.command.setHidden(true);
            event.canExecute = false;
            return;
        }
        const command = event.command;
        const isMove = command.id === 'cut';
        // Disable Copy command in Trash.
        if (!isMove && isOnTrashRoot(fileManager)) {
            event.command.setHidden(true);
            event.canExecute = false;
            return;
        }
        const entries = getCommandEntries(fileManager, event.target);
        const target = event.target;
        const volumeManager = fileManager.volumeManager;
        command.setHidden(false);
        /** If the operation is allowed in the Directory Tree. */
        function canDoDirectoryTree() {
            let entry;
            if (target && 'entry' in target) {
                entry = target.entry;
            }
            else if (getFocusedTreeItem(target) &&
                getTreeItemEntry(getFocusedTreeItem(target))) {
                entry = getTreeItemEntry(getFocusedTreeItem(target));
            }
            else {
                return false;
            }
            assert$1(entry);
            // If entry is fake, non-interactive or root, remove cut/copy option.
            if (!shouldShowMenuItemsForEntry(volumeManager, entry)) {
                command.setHidden(true);
                return false;
            }
            // For MyFiles/Downloads and MyFiles/PluginVm we only allow copy.
            if (isMove && isNonModifiable(volumeManager, entry)) {
                return false;
            }
            // Cut is unavailable on Shared Drive roots.
            if (isTeamDriveRoot(entry)) {
                return false;
            }
            const metadata = fileManager.metadataModel.getCache([entry], ['canCopy', 'canDelete']);
            assert$1(metadata.length === 1);
            if (!isMove) {
                return metadata[0].canCopy !== false;
            }
            // We need to check source volume is writable for move operation.
            const volumeInfo = volumeManager.getVolumeInfo(entry);
            return !volumeInfo?.isReadOnly && metadata[0].canCopy !== false &&
                metadata[0].canDelete !== false;
        }
        /** @returns If the operation is allowed in the File List. */
        function canDoFileList() {
            assert$1(fileManager.document);
            if (shouldIgnoreEvents(fileManager.document)) {
                return false;
            }
            // If entries contain fake, non-interactive or root entry, remove cut/copy
            // option.
            if (!fileManager.getSelection().entries.every(shouldShowMenuItemsForEntry.bind(null, volumeManager))) {
                command.setHidden(true);
                return false;
            }
            // If blank space was clicked and current volume is non-interactive,
            // remove cut/copy command.
            if (entries.length === 0 && !currentVolumeIsInteractive(fileManager)) {
                command.setHidden(true);
                return false;
            }
            // For MyFiles/Downloads we only allow copy.
            if (isMove &&
                fileManager.getSelection().entries.some(isNonModifiable.bind(null, volumeManager))) {
                return false;
            }
            return isMove ? fileTransferController?.canCutOrDrag() :
                fileTransferController?.canCopyOrDrag();
        }
        const canDo = fileManager.ui.directoryTree?.contains(target) ?
            canDoDirectoryTree() :
            canDoFileList();
        event.canExecute = !!canDo;
        command.disabled = !canDo;
    }
}
/**
 * Initiates file renaming.
 */
class RenameCommand extends FilesCommand {
    execute(event, fileManager) {
        const entry = getCommandEntry(fileManager, event.target);
        if (isNonModifiable(fileManager.volumeManager, entry)) {
            return;
        }
        if (isOnTrashRoot(fileManager)) {
            return;
        }
        let isRemovableRoot = false;
        let volumeInfo = null;
        if (entry) {
            volumeInfo = fileManager.volumeManager.getVolumeInfo(entry);
            // Checks whether the target is an external drive.
            if (volumeInfo && isRootEntry(fileManager.volumeManager, entry)) {
                isRemovableRoot = true;
            }
        }
        if (isXfTree(event.target) || isTreeItem(event.target)) {
            assert$1(fileManager.directoryTreeNamingController);
            assert$1(volumeInfo);
            if (isXfTree(event.target)) {
                const treeItem = getFocusedTreeItem(event.target);
                assert$1(treeItem);
                fileManager.directoryTreeNamingController.attachAndStart(treeItem, isRemovableRoot, volumeInfo);
            }
            else if (isTreeItem(event.target)) {
                fileManager.directoryTreeNamingController.attachAndStart(event.target, isRemovableRoot, volumeInfo);
            }
        }
        else {
            fileManager.namingController.initiateRename(isRemovableRoot, volumeInfo);
        }
    }
    canExecute(event, fileManager) {
        if (isOnTrashRoot(fileManager)) {
            event.canExecute = false;
            event.command.setHidden(true);
            return;
        }
        // Check if it is removable drive
        if ((() => {
            const root = getCommandEntry(fileManager, event.target);
            // |root| is null for unrecognized volumes. Do not enable rename
            // command for such volumes because they need to be formatted prior to
            // rename.
            if (!root || !isRootEntry(fileManager.volumeManager, root)) {
                return false;
            }
            const volumeInfo = fileManager.volumeManager.getVolumeInfo(root);
            const location = fileManager.volumeManager.getLocationInfo(root);
            if (!volumeInfo || !location) {
                event.command.setHidden(true);
                event.canExecute = false;
                return true;
            }
            const writable = !location.isReadOnly;
            const removable = location.rootType === RootType.REMOVABLE;
            event.canExecute =
                removable && writable && !!volumeInfo.diskFileSystemType && [
                    FileSystemType.EXFAT,
                    FileSystemType.VFAT,
                    FileSystemType.NTFS,
                ].indexOf(volumeInfo.diskFileSystemType) > -1;
            event.command.setHidden(!removable);
            return removable;
        })()) {
            return;
        }
        // Check if it is file or folder
        const renameTarget = isFromSelectionMenu(event) ?
            fileManager.ui.listContainer.currentList :
            event.target;
        const entries = getCommandEntries(fileManager, renameTarget);
        if (entries.length === 0 ||
            !shouldShowMenuItemsForEntry(fileManager.volumeManager, entries[0]) ||
            entries.some(isNonModifiable.bind(null, fileManager.volumeManager))) {
            event.canExecute = false;
            event.command.setHidden(true);
            return;
        }
        assert$1(renameTarget);
        const parentEntry = getParentEntry(renameTarget, fileManager.directoryModel);
        const locationInfo = parentEntry ?
            fileManager.volumeManager.getLocationInfo(parentEntry) :
            null;
        const volumeIsNotReadOnly = !!locationInfo && !locationInfo.isReadOnly;
        // ARC doesn't support rename for now. http://b/232152680
        const recentArcEntry = isRecentArcEntry(unwrapEntry(entries[0]));
        // Drive grand roots do not support rename.
        const isDriveGrandRoot = isGrandRootEntryInDrive(entries[0]);
        event.canExecute = entries.length === 1 && volumeIsNotReadOnly &&
            !recentArcEntry && !isDriveGrandRoot &&
            hasCapability(fileManager, entries, 'canRename');
        event.command.setHidden(false);
    }
}
/**
 * Opens settings/files sub page.
 */
class FilesSettingsCommand extends FilesCommand {
    execute(_event, _fileManager) {
        chrome.fileManagerPrivate.openSettingsSubpage('systemPreferences');
    }
    canExecute(event, _fileManager) {
        event.canExecute = true;
    }
}
/**
 * Opens drive help.
 */
class VolumeHelpCommand extends FilesCommand {
    execute(_event, fileManager) {
        if (fileManager.directoryModel.isOnDrive()) {
            visitURL(str('GOOGLE_DRIVE_HELP_URL'));
            recordMenuItemSelected(MenuCommandsForUma.DRIVE_HELP);
        }
        else {
            visitURL(str('FILES_APP_HELP_URL'));
            recordMenuItemSelected(MenuCommandsForUma.HELP);
        }
    }
    canExecute(event, fileManager) {
        // Hides the help menu in modal dialog mode. It does not make much sense
        // because after all, users cannot view the help without closing, and
        // besides that the help page is about the Files app as an app, not about
        // the dialog mode itself. It can also lead to hard-to-fix bug
        // crbug.com/339089.
        const hideHelp = isModal(fileManager.dialogType);
        event.canExecute = !hideHelp;
        event.command.setHidden(hideHelp);
    }
}
/**
 * Opens the send feedback window.
 */
class SendFeedbackCommand extends FilesCommand {
    execute(_event, _fileManager) {
        chrome.fileManagerPrivate.sendFeedback();
    }
}
/**
 * Opens drive buy-more-space url.
 */
class DriveBuyMoreSpaceCommand extends FilesCommand {
    execute(_event, _fileManager) {
        visitURL(str('GOOGLE_DRIVE_BUY_STORAGE_URL'));
        recordMenuItemSelected(MenuCommandsForUma.DRIVE_BUY_MORE_SPACE);
    }
    canExecute(event, fileManager) {
        canExecuteVisibleOnDriveInNormalAppModeOnly(event, fileManager);
    }
}
/**
 * Opens drive.google.com.
 */
class DriveGoToDriveCommand extends FilesCommand {
    execute(_event, _fileManager) {
        visitURL(str('GOOGLE_DRIVE_ROOT_URL'));
        recordMenuItemSelected(MenuCommandsForUma.DRIVE_GO_TO_DRIVE);
    }
    canExecute(event, fileManager) {
        canExecuteVisibleOnDriveInNormalAppModeOnly(event, fileManager);
    }
}
/**
 * Opens a file with default task.
 */
class DefaultTaskCommand extends FilesCommand {
    execute(_event, fileManager) {
        fileManager.taskController.executeDefaultTask();
    }
    canExecute(event, fileManager) {
        event.canExecute = fileManager.taskController.canExecuteDefaultTask();
        event.command.setHidden(fileManager.taskController.shouldHideDefaultTask());
    }
}
/**
 * Displays "open with" dialog for current selection.
 */
class OpenWithCommand extends FilesCommand {
    execute(_event, _fileManager) {
        console.error(`open-with command doesn't execute, ` +
            `instead it only opens the sub-menu`);
    }
    canExecute(event, fileManager) {
        const canExecute = fileManager.taskController.canExecuteOpenActions();
        event.canExecute = canExecute;
        event.command.setHidden(!canExecute);
    }
}
/**
 * Invoke Sharesheet.
 */
class InvokeSharesheetCommand extends FilesCommand {
    execute(event, fileManager) {
        if (isOnTrashRoot(fileManager)) {
            return;
        }
        const entries = fileManager.selectionHandler.selection.entries;
        const launchSource = getSharesheetLaunchSource(event);
        const dlpSourceUrls = fileManager.metadataModel.getCache(entries, ['sourceUrl'])
            .map(m => m.sourceUrl || '');
        chrome.fileManagerPrivate
            .invokeSharesheet(entriesToURLs(entries), launchSource, dlpSourceUrls)
            .catch(console.warn);
    }
    canExecute(event, fileManager) {
        if (isOnTrashRoot(fileManager)) {
            event.canExecute = false;
            event.command.setHidden(true);
            return;
        }
        const entries = fileManager.selectionHandler.selection.entries;
        if (!entries || entries.length === 0 ||
            (entries.some(entry => entry.isDirectory) &&
                (!isDriveEntries(entries, fileManager.volumeManager) ||
                    entries.length > 1))) {
            event.canExecute = false;
            event.command.setHidden(true);
            event.command.disabled = true;
            return;
        }
        event.canExecute = true;
        // In the case where changing focus to action bar elements, it is safe
        // to keep the command enabled if it was visible before, because there
        // should be no change to the selected entries.
        event.command.disabled =
            !fileManager.ui.actionbar.contains(event.target);
        chrome.fileManagerPrivate.sharesheetHasTargets(entriesToURLs(entries))
            .then((hasTargets) => {
            event.command.setHidden(!hasTargets);
            event.canExecute = hasTargets;
            event.command.disabled = !hasTargets;
        })
            .catch(console.warn);
    }
}
class ToggleHoldingSpaceCommand extends FilesCommand {
    execute(_event, fileManager) {
        if (this.addsItems_ === undefined) {
            return;
        }
        // Filter out entries from unsupported volumes.
        const allowedVolumeTypes = getAllowedVolumeTypes();
        const entries = fileManager.selectionHandler.selection.entries.filter(entry => {
            const volumeInfo = fileManager.volumeManager.getVolumeInfo(entry);
            return volumeInfo &&
                allowedVolumeTypes.includes(volumeInfo.volumeType);
        });
        chrome.fileManagerPrivate.toggleAddedToHoldingSpace(entries.map(unwrapEntry), this.addsItems_, () => { });
        if (this.addsItems_) {
            maybeStoreTimeOfFirstPin();
        }
        recordMenuItemSelected(this.addsItems_ ? MenuCommandsForUma.PIN_TO_HOLDING_SPACE :
            MenuCommandsForUma.UNPIN_FROM_HOLDING_SPACE);
    }
    canExecute(event, fileManager) {
        const command = event.command;
        const allowedVolumeTypes = getAllowedVolumeTypes();
        const currentRootType = fileManager.directoryModel.getCurrentRootType();
        if (!isRecentRootType(currentRootType)) {
            const volumeInfo = fileManager.directoryModel.getCurrentVolumeInfo();
            if (!volumeInfo || !allowedVolumeTypes.includes(volumeInfo.volumeType)) {
                event.canExecute = false;
                command.setHidden(true);
                return;
            }
        }
        // Filter out entries from unsupported volumes.
        const entries = fileManager.selectionHandler.selection.entries.filter(entry => {
            const volumeInfo = fileManager.volumeManager.getVolumeInfo(entry);
            return volumeInfo &&
                allowedVolumeTypes.includes(volumeInfo.volumeType);
        });
        if (entries.length === 0) {
            event.canExecute = false;
            command.setHidden(true);
            return;
        }
        event.canExecute = true;
        command.setHidden(false);
        this.checkHoldingSpaceState(entries, command);
    }
    async checkHoldingSpaceState(entries, command) {
        // Update the command to add or remove holding space items depending on
        // the current holding space state - the command will remove items only
        // if all currently selected items are already in the holding space.
        let state;
        try {
            state = await getHoldingSpaceState();
        }
        catch (e) {
            console.warn('Error getting holding space state', e);
        }
        if (!state) {
            command.setHidden(true);
            return;
        }
        const itemsSet = {};
        state.itemUrls.forEach((item) => itemsSet[item] = true);
        const selectedUrls = entriesToURLs(entries);
        this.addsItems_ = selectedUrls.some(url => !itemsSet[url]);
        command.label = this.addsItems_ ? str('HOLDING_SPACE_PIN_COMMAND_LABEL') :
            str('HOLDING_SPACE_UNPIN_COMMAND_LABEL');
    }
}
/**
 * Opens containing folder of the focused file.
 */
class GoToFileLocationCommand extends FilesCommand {
    execute(event, fileManager) {
        const entries = getCommandEntries(fileManager, event.target);
        if (entries.length !== 1) {
            return;
        }
        const components = PathComponent.computeComponentsFromEntry(entries[0], fileManager.volumeManager);
        // Entries in file list table should always have its containing folder.
        // (i.e. Its path have at least two components: its parent and itself.)
        assert$1(components.length >= 2);
        const parentComponent = components[components.length - 2];
        parentComponent?.resolveEntry().then(entry => {
            if (entry && isDirectoryEntry(entry)) {
                fileManager.directoryModel.changeDirectoryEntry(entry);
            }
        });
    }
    canExecute(event, fileManager) {
        // Available in Recents, Audio, Images, and Videos.
        if (!isRecentRootType(fileManager.directoryModel.getCurrentRootType())) {
            event.canExecute = false;
            event.command.setHidden(true);
            return;
        }
        // Available for a single entry.
        const entries = getCommandEntries(fileManager, event.target);
        event.canExecute = entries.length === 1;
        event.command.setHidden(!event.canExecute);
    }
}
/**
 * Displays QuickView for current selection.
 */
class GetInfoCommand extends FilesCommand {
    execute(_event, _fileManager) {
        // 'get-info' command is executed by 'command' event handler in
        // QuickViewController.
    }
    canExecute(event, fileManager) {
        // QuickViewModel refers the file selection instead of event target.
        const entries = fileManager.getSelection().entries;
        if (entries.length === 0) {
            event.canExecute = false;
            event.command.setHidden(true);
            return;
        }
        event.canExecute = entries.length >= 1;
        event.command.setHidden(false);
    }
}
/**
 * Displays the Data Leak Prevention (DLP) Restriction details.
 */
class DlpRestrictionDetailsCommand extends FilesCommand {
    async executeImpl_(_event, fileManager) {
        const entries = fileManager.getSelection().entries;
        const metadata = fileManager.metadataModel.getCache(entries, ['sourceUrl']);
        if (!metadata || metadata.length !== 1 || !metadata[0].sourceUrl) {
            return;
        }
        const sourceUrl = metadata[0].sourceUrl;
        try {
            const details = await getDlpRestrictionDetails(sourceUrl);
            fileManager.ui.dlpRestrictionDetailsDialog
                ?.showDlpRestrictionDetailsDialog(details);
        }
        catch (e) {
            console.warn(`Error showing DLP restriction details `, e);
        }
    }
    execute(event, fileManager) {
        this.executeImpl_(event, fileManager);
    }
    canExecute(event, fileManager) {
        if (!isDlpEnabled()) {
            event.canExecute = false;
            event.command.setHidden(true);
            return;
        }
        const entries = fileManager.getSelection().entries;
        // Show this item only when one file is selected.
        if (entries.length !== 1) {
            event.canExecute = false;
            event.command.setHidden(true);
            return;
        }
        const metadata = fileManager.metadataModel.getCache(entries, ['isDlpRestricted']);
        if (!metadata || metadata.length !== 1) {
            event.canExecute = false;
            event.command.setHidden(true);
        }
        const isDlpRestricted = metadata[0]?.isDlpRestricted;
        event.canExecute = !!isDlpRestricted;
        event.command.setHidden(!isDlpRestricted);
    }
}
/**
 * Focuses search input box.
 */
class SearchCommand extends FilesCommand {
    execute(_event, fileManager) {
        // If the current root is Trash we do nothing on search command. Preventing
        // it from execution (in canExecute) does not work correctly, as then chrome
        // start native search for an app window. Thus we always allow it and do
        // nothing in trash.
        const currentRootType = fileManager.directoryModel.getCurrentRootType();
        if (currentRootType !== RootType.TRASH) {
            // Cancel item selection.
            fileManager.directoryModel.clearSelection();
            // Open the query input via the search container.
            fileManager.ui.searchContainer?.openSearch();
        }
    }
    canExecute(event, fileManager) {
        event.canExecute = !fileManager.namingController.isRenamingInProgress();
    }
}
class VolumeSwitchCommand extends FilesCommand {
    constructor(index_) {
        super();
        this.index_ = index_;
    }
    execute(_event, fileManager) {
        const directoryTree = fileManager.ui.directoryTree;
        const items = directoryTree?.items;
        const treeItemEntry = getTreeItemEntry(items && items[this.index_ - 1]);
        if (treeItemEntry) {
            getStore().dispatch(changeDirectory({ toKey: treeItemEntry.toURL() }));
        }
    }
    canExecute(event, fileManager) {
        event.canExecute = this.index_ > 0 &&
            this.index_ <= (fileManager.ui.directoryTree?.items.length ?? 0);
    }
}
/**
 * Flips 'available offline' flag on the file.
 */
class TogglePinnedCommand extends FilesCommand {
    execute(_event, fileManager) {
        const entries = fileManager.getSelection().entries;
        const actionsController = fileManager.actionsController;
        actionsController.getActionsForEntries(entries).then((actionsModel) => {
            if (!actionsModel) {
                return;
            }
            const saveForOfflineAction = actionsModel.getAction(CommonActionId.SAVE_FOR_OFFLINE);
            const offlineNotNeededAction = actionsModel.getAction(CommonActionId.OFFLINE_NOT_NECESSARY);
            // Saving for offline has a priority if both actions are available.
            let action = offlineNotNeededAction;
            if (saveForOfflineAction && saveForOfflineAction.canExecute()) {
                action = saveForOfflineAction;
            }
            if (action) {
                actionsController.executeAction(action);
            }
        });
    }
    canExecute(event, fileManager) {
        const entries = fileManager.getSelection().entries;
        const command = event.command;
        const actionsController = fileManager.actionsController;
        // Avoid flickering menu height: synchronously define command visibility.
        if (!isDriveEntries(entries, fileManager.volumeManager)) {
            command.setHidden(true);
            return;
        }
        // When the bulk pinning panel is enabled, the "Available offline" toggle
        // should not be visible as the underlying functionality is handled
        // automatically.
        if (isDriveFsBulkPinningEnabled()) {
            const state = getStore().getState();
            const bulkPinningPref = !!state.preferences?.driveFsBulkPinningEnabled;
            if (bulkPinningPref && isOnlyMyDriveEntries(entries, state)) {
                command.setHidden(true);
                event.canExecute = false;
                return;
            }
        }
        command.setHidden(false);
        function canExecutePinned(actionsModel) {
            if (!actionsModel) {
                return;
            }
            const saveForOfflineAction = actionsModel.getAction(CommonActionId.SAVE_FOR_OFFLINE);
            const offlineNotNeededAction = actionsModel.getAction(CommonActionId.OFFLINE_NOT_NECESSARY);
            let action = offlineNotNeededAction;
            command.checked = !!offlineNotNeededAction;
            if (saveForOfflineAction && saveForOfflineAction.canExecute()) {
                action = saveForOfflineAction;
                command.checked = false;
            }
            event.canExecute = !!action && action.canExecute();
            command.disabled = !event.canExecute;
        }
        // Run synchrounously if possible.
        const actionsModel = actionsController.getInitializedActionsForEntries(entries);
        if (actionsModel) {
            canExecutePinned(actionsModel);
            return;
        }
        event.canExecute = true;
        // Run async, otherwise.
        actionsController.getActionsForEntries(entries).then(canExecutePinned);
    }
}
/**
 * Extracts content of ZIP files in the current selection.
 */
class ExtractAllCommand extends FilesCommand {
    execute(_event, fileManager) {
        if (isOnTrashRoot(fileManager)) {
            return;
        }
        let dirEntry = fileManager.getCurrentDirectoryEntry();
        if (!dirEntry ||
            !fileManager.getSelection().entries.every(shouldShowMenuItemsForEntry.bind(null, fileManager.volumeManager))) {
            return;
        }
        const selectionEntries = fileManager.getSelection().entries;
        if (fileManager.directoryModel.isReadOnly()) {
            dirEntry = fileManager.directoryModel.getMyFiles();
        }
        fileManager.taskController.startExtractIoTask(selectionEntries, dirEntry);
    }
    canExecute(event, fileManager) {
        const dirEntry = fileManager.getCurrentDirectoryEntry();
        const selection = fileManager.getSelection();
        if (isOnTrashRoot(fileManager) || !dirEntry || !selection ||
            selection.totalCount === 0) {
            event.command.setHidden(true);
            event.canExecute = false;
        }
        else {
            // Check the selected entries for a ZIP archive in the selected set.
            for (const entry of selection.entries) {
                if (getExtension(entry) === '.zip') {
                    event.command.setHidden(false);
                    event.canExecute = true;
                    return;
                }
            }
            // Didn't find any ZIP files, disable extract-all.
            event.command.setHidden(true);
            event.canExecute = false;
        }
    }
}
/**
 * Creates ZIP file for current selection.
 */
class ZipSelectionCommand extends FilesCommand {
    execute(_event, fileManager) {
        if (isOnTrashRoot(fileManager)) {
            return;
        }
        const dirEntry = fileManager.getCurrentDirectoryEntry();
        if (!dirEntry ||
            !fileManager.getSelection().entries.every(shouldShowMenuItemsForEntry.bind(null, fileManager.volumeManager))) {
            return;
        }
        const selectionEntries = fileManager.getSelection().entries;
        startIOTask(chrome.fileManagerPrivate.IoTaskType.ZIP, selectionEntries, { destinationFolder: dirEntry });
    }
    canExecute(event, fileManager) {
        if (isOnTrashRoot(fileManager)) {
            event.canExecute = false;
            event.command.setHidden(true);
            return;
        }
        const dirEntry = fileManager.getCurrentDirectoryEntry();
        const selection = fileManager.getSelection();
        // Hide ZIP selection for single ZIP file selected.
        if (selection.entries.length === 1 &&
            getExtension(selection.entries[0]) === '.zip') {
            event.command.setHidden(true);
            event.canExecute = false;
            return;
        }
        if (!selection.entries.every(shouldShowMenuItemsForEntry.bind(null, fileManager.volumeManager))) {
            event.canExecute = false;
            event.command.setHidden(true);
            return;
        }
        // Hide if there isn't anything selected, meaning user clicked in an empty
        // space in the file list.
        const noEntries = selection.entries.length === 0;
        event.command.setHidden(noEntries);
        // TODO(crbug/1226915) Make it work with MTP.
        const isOnEligibleLocation = fileManager.directoryModel.isOnNative();
        // Hide if any encrypted files are selected, as we can't read them.
        const hasEncryptedFile = fileManager.metadataModel
            .getCache(selection.entries, ['contentMimeType'])
            .some((metadata, i) => isEncrypted(selection.entries[i], metadata.contentMimeType));
        event.canExecute = !!dirEntry && !fileManager.directoryModel.isReadOnly() &&
            isOnEligibleLocation && selection && selection.totalCount > 0 &&
            !hasEncryptedFile;
    }
}
/**
 * Opens the file in Drive for the user to manage sharing permissions etc.
 */
class ManageInDriveCommand extends FilesCommand {
    execute(event, fileManager) {
        const entries = getCommandEntries(fileManager, event.target);
        const actionsController = fileManager.actionsController;
        fileManager.actionsController.getActionsForEntries(entries).then((actionsModel) => {
            if (!actionsModel) {
                return;
            }
            const action = actionsModel.getAction(InternalActionId.MANAGE_IN_DRIVE);
            if (action) {
                actionsController.executeAction(action);
            }
        });
    }
    canExecute(event, fileManager) {
        const entries = getCommandEntries(fileManager, event.target);
        const command = event.command;
        const actionsController = fileManager.actionsController;
        // Avoid flickering menu height: synchronously define command visibility.
        if (!isDriveEntries(entries, fileManager.volumeManager)) {
            command.setHidden(true);
            return;
        }
        command.setHidden(false);
        function canExecuteManageInDrive(actionsModel) {
            if (!actionsModel) {
                return;
            }
            const action = actionsModel.getAction(InternalActionId.MANAGE_IN_DRIVE);
            if (action) {
                command.setHidden(!action);
                event.canExecute = !!action && action.canExecute();
                command.disabled = !event.canExecute;
            }
        }
        // Run synchronously if possible.
        const actionsModel = actionsController.getInitializedActionsForEntries(entries);
        if (actionsModel) {
            canExecuteManageInDrive(actionsModel);
            return;
        }
        event.canExecute = true;
        // Run async, otherwise.
        actionsController.getActionsForEntries(entries).then(canExecuteManageInDrive);
    }
}
/**
 * Opens the Manage MirrorSync dialog if the flag is enabled.
 */
class ManageMirrorsyncCommand extends FilesCommand {
    execute(_event, _fileManager) {
        chrome.fileManagerPrivate.openManageSyncSettings();
    }
    canExecute(event, fileManager) {
        // MirrorSync is only available to sync local directories, only show the
        // folder when navigated to a local directory.
        const currentRootType = fileManager.directoryModel.getCurrentRootType();
        event.canExecute = (currentRootType === RootType.MY_FILES ||
            currentRootType === RootType.DOWNLOADS) &&
            isMirrorSyncEnabled();
        event.command.setHidden(!event.canExecute);
    }
}
/**
 * A command to share the target folder with the specified Guest OS.
 */
class GuestOsShareCommand extends FilesCommand {
    /**
     * @param vmName Name of the vm to share into.
     * @param typeForStrings VM type to identify the strings used for this VM e.g.
     *     LINUX or PLUGIN_VM.
     * @param settingsPath Path to the page in settings to manage sharing.
     * @param manageUma MenuCommandsForUma entry this command should emit metrics
     *     under when the toast to manage sharing is clicked on.
     * @param shareUma MenuCommandsForUma entry this command should emit metrics
     *     under.
     */
    constructor(vmName_, typeForStrings_, settingsPath_, manageUma_, shareUma_) {
        super();
        this.vmName_ = vmName_;
        this.typeForStrings_ = typeForStrings_;
        this.settingsPath_ = settingsPath_;
        this.manageUma_ = manageUma_;
        this.shareUma_ = shareUma_;
        this.validateTranslationStrings_();
    }
    /**
     * Asserts that the necessary strings have been loaded into loadTimeData.
     */
    validateTranslationStrings_() {
        if (!loadTimeData.isInitialized()) {
            // Tests might not set loadTimeData.
            return;
        }
        const translations = [
            `FOLDER_SHARED_WITH_${this.typeForStrings_}`,
            `SHARE_ROOT_FOLDER_WITH_${this.typeForStrings_}_TITLE`,
            `SHARE_ROOT_FOLDER_WITH_${this.typeForStrings_}`,
            `SHARE_ROOT_FOLDER_WITH_${this.typeForStrings_}_DRIVE`,
        ];
        for (const translation of translations) {
            console.assert(loadTimeData.valueExists(translation), `VM ${this.vmName_} doesn't have the translation string ${translation}`);
        }
    }
    execute(event, fileManager) {
        const entry = getCommandEntry(fileManager, event.target);
        if (!entry || !entry.isDirectory) {
            return;
        }
        const info = fileManager.volumeManager.getLocationInfo(entry);
        if (!info) {
            return;
        }
        const share = () => {
            // Always persist shares via right-click > Share with Linux.
            chrome.fileManagerPrivate.sharePathsWithCrostini(this.vmName_, [unwrapEntry(entry)], true /* persist */, () => {
                if (chrome.runtime.lastError) {
                    console.warn('Error sharing with guest: ' +
                        chrome.runtime.lastError.message);
                }
            });
            // Show the 'Manage $typeForStrings sharing' toast immediately, since
            // the guest may take a while to start.
            fileManager.ui.toast.show(str(`FOLDER_SHARED_WITH_${this.typeForStrings_}`), {
                text: str('MANAGE_TOAST_BUTTON_LABEL'),
                callback: () => {
                    chrome.fileManagerPrivate.openSettingsSubpage(this.settingsPath_);
                    recordMenuItemSelected(this.manageUma_);
                },
            });
        };
        // Show a confirmation dialog if we are sharing the root of a volume.
        // Non-Drive volume roots are always '/'.
        if (entry.fullPath === '/') {
            fileManager.ui.confirmDialog.showHtml(str(`SHARE_ROOT_FOLDER_WITH_${this.typeForStrings_}_TITLE`), strf(`SHARE_ROOT_FOLDER_WITH_${this.typeForStrings_}`, info.volumeInfo?.label), share, () => { });
        }
        else if (info.isRootEntry &&
            (info.rootType === RootType.DRIVE ||
                info.rootType === RootType.COMPUTERS_GRAND_ROOT ||
                info.rootType === RootType.SHARED_DRIVES_GRAND_ROOT)) {
            // Only show the dialog for My Drive, Shared Drives Grand Root and
            // Computers Grand Root.  Do not show for roots of a single Shared
            // Drive or Computer.
            fileManager.ui.confirmDialog.showHtml(str(`SHARE_ROOT_FOLDER_WITH_${this.typeForStrings_}_TITLE`), str(`SHARE_ROOT_FOLDER_WITH_${this.typeForStrings_}_DRIVE`), share, () => { });
        }
        else {
            // This is not a root, share it without confirmation dialog.
            share();
        }
        recordMenuItemSelected(this.shareUma_);
    }
    canExecute(event, fileManager) {
        // Must be single directory not already shared.
        const entries = getCommandEntries(fileManager, event.target);
        event.canExecute = entries.length === 1 && entries[0].isDirectory &&
            !isFakeEntry(entries[0]) &&
            !fileManager.crostini.isPathShared(this.vmName_, entries[0]) &&
            fileManager.crostini.canSharePath(this.vmName_, entries[0], true /* persist */);
        event.command.setHidden(!event.canExecute);
    }
}
/**
 * Creates a command for the gear icon to manage sharing.
 */
class GuestOsManagingSharingGearCommand extends FilesCommand {
    /**
     * @param vmName Name of the vm to share into.
     * @param settingsPath Path to the page in settings to manage sharing.
     * @param manageUma MenuCommandsForUma entry this command should emit metrics
     *     under when the toast to manage sharing is clicked on.
     */
    constructor(vmName_, settingsPath_, manageUma_) {
        super();
        this.vmName_ = vmName_;
        this.settingsPath_ = settingsPath_;
        this.manageUma_ = manageUma_;
    }
    execute(_event, _fileManager) {
        chrome.fileManagerPrivate.openSettingsSubpage(this.settingsPath_);
        recordMenuItemSelected(this.manageUma_);
    }
    canExecute(event, fileManager) {
        event.canExecute = fileManager.crostini.isEnabled(this.vmName_);
        event.command.setHidden(!event.canExecute);
    }
}
/**
 * Creates a command for managing sharing.
 */
class GuestOsManagingSharingCommand extends FilesCommand {
    /**
     * @param vmName Name of the vm to share into.
     * @param settingsPath Path to the page in settings to manage sharing.
     * @param manageUma MenuCommandsForUma entry this command should emit metrics
     *     under when the toast to manage sharing is clicked on.
     */
    constructor(vmName_, settingsPath_, manageUma_) {
        super();
        this.vmName_ = vmName_;
        this.settingsPath_ = settingsPath_;
        this.manageUma_ = manageUma_;
    }
    execute(_event, _fileManager) {
        chrome.fileManagerPrivate.openSettingsSubpage(this.settingsPath_);
        recordMenuItemSelected(this.manageUma_);
    }
    canExecute(event, fileManager) {
        const entries = getCommandEntries(fileManager, event.target);
        event.canExecute = entries.length === 1 && entries[0].isDirectory &&
            fileManager.crostini.isPathShared(this.vmName_, entries[0]);
        event.command.setHidden(!event.canExecute);
    }
}
/**
 * Creates a shortcut of the selected folder (single only).
 */
class PinFolderCommand extends FilesCommand {
    execute(event, fileManager) {
        const entries = getCommandEntries(fileManager, event.target);
        const actionsController = fileManager.actionsController;
        fileManager.actionsController.getActionsForEntries(entries).then((actionsModel) => {
            if (!actionsModel) {
                return;
            }
            const action = actionsModel.getAction(InternalActionId.CREATE_FOLDER_SHORTCUT);
            if (action) {
                actionsController.executeAction(action);
            }
        });
    }
    canExecute(event, fileManager) {
        const entries = getCommandEntries(fileManager, event.target);
        const command = event.command;
        const actionsController = fileManager.actionsController;
        // Avoid flickering menu height: synchronously define command visibility.
        if (!isDriveEntries(entries, fileManager.volumeManager)) {
            command.setHidden(true);
            return;
        }
        command.setHidden(false);
        function canExecuteCreateShortcut(actionsModel) {
            if (!actionsModel) {
                return;
            }
            const action = actionsModel.getAction(InternalActionId.CREATE_FOLDER_SHORTCUT);
            event.canExecute = !!action && action.canExecute();
            command.disabled = !event.canExecute;
            command.setHidden(!action);
        }
        // Run synchrounously if possible.
        const actionsModel = actionsController.getInitializedActionsForEntries(entries);
        if (actionsModel) {
            canExecuteCreateShortcut(actionsModel);
            return;
        }
        event.canExecute = true;
        command.setHidden(false);
        // Run async, otherwise.
        actionsController.getActionsForEntries(entries).then(canExecuteCreateShortcut);
    }
}
/**
 * Removes the folder shortcut.
 */
class UnpinFolderCommand extends FilesCommand {
    execute(event, fileManager) {
        const entries = getCommandEntries(fileManager, event.target);
        const actionsController = fileManager.actionsController;
        fileManager.actionsController.getActionsForEntries(entries).then((actionsModel) => {
            if (!actionsModel) {
                return;
            }
            const action = actionsModel.getAction(InternalActionId.REMOVE_FOLDER_SHORTCUT);
            if (action) {
                actionsController.executeAction(action);
            }
        });
    }
    canExecute(event, fileManager) {
        const entries = getCommandEntries(fileManager, event.target);
        const command = event.command;
        const actionsController = fileManager.actionsController;
        // Avoid flickering menu height: synchronously define command visibility.
        if (!isDriveEntries(entries, fileManager.volumeManager)) {
            command.setHidden(true);
            return;
        }
        command.setHidden(false);
        function canExecuteRemoveShortcut(actionsModel) {
            if (!actionsModel) {
                return;
            }
            const action = actionsModel.getAction(InternalActionId.REMOVE_FOLDER_SHORTCUT);
            command.setHidden(!action);
            event.canExecute = !!action && action.canExecute();
            command.disabled = !event.canExecute;
        }
        // Run synchrounously if possible.
        const actionsModel = actionsController.getInitializedActionsForEntries(entries);
        if (actionsModel) {
            canExecuteRemoveShortcut(actionsModel);
            return;
        }
        event.canExecute = true;
        command.setHidden(false);
        // Run async, otherwise.
        actionsController.getActionsForEntries(entries).then(canExecuteRemoveShortcut);
    }
}
/**
 * Zoom in to the Files app.
 */
class ZoomInCommand extends FilesCommand {
    execute(_event, _fileManager) {
        chrome.fileManagerPrivate.zoom(chrome.fileManagerPrivate.ZoomOperationType.IN);
    }
}
/**
 * Zoom out from the Files app.
 */
class ZoomOutCommand extends FilesCommand {
    execute(_event, _fileManager) {
        chrome.fileManagerPrivate.zoom(chrome.fileManagerPrivate.ZoomOperationType.OUT);
    }
}
/**
 * Reset the zoom factor.
 */
class ZoomResetCommand extends FilesCommand {
    execute(_event, _fileManager) {
        chrome.fileManagerPrivate.zoom(chrome.fileManagerPrivate.ZoomOperationType.RESET);
    }
}
/**
 * Sort the file list by name (in ascending order).
 */
class SortByNameCommand extends FilesCommand {
    execute(_event, fileManager) {
        if (fileManager.directoryModel.getFileList()) {
            fileManager.directoryModel.getFileList().sort('name', 'asc');
            const msg = strf('COLUMN_SORTED_ASC', str('NAME_COLUMN_LABEL'));
            fileManager.ui.speakA11yMessage(msg);
        }
    }
}
/**
 * Sort the file list by size (in descending order).
 */
class SortBySizeCommand extends FilesCommand {
    execute(_event, fileManager) {
        if (fileManager.directoryModel.getFileList()) {
            fileManager.directoryModel.getFileList().sort('size', 'desc');
            const msg = strf('COLUMN_SORTED_DESC', str('SIZE_COLUMN_LABEL'));
            fileManager.ui.speakA11yMessage(msg);
        }
    }
}
/**
 * Sort the file list by type (in ascending order).
 */
class SortByTypeCommand extends FilesCommand {
    execute(_event, fileManager) {
        if (fileManager.directoryModel.getFileList()) {
            fileManager.directoryModel.getFileList().sort('type', 'asc');
            const msg = strf('COLUMN_SORTED_ASC', str('TYPE_COLUMN_LABEL'));
            fileManager.ui.speakA11yMessage(msg);
        }
    }
}
/**
 * Sort the file list by date-modified (in descending order).
 */
class SortByDateCommand extends FilesCommand {
    execute(_event, fileManager) {
        if (fileManager.directoryModel.getFileList()) {
            fileManager.directoryModel.getFileList().sort('modificationTime', 'desc');
            const msg = strf('COLUMN_SORTED_DESC', str('DATE_COLUMN_LABEL'));
            fileManager.ui.speakA11yMessage(msg);
        }
    }
}
/**
 * Open inspector for foreground page.
 */
class InspectNormalCommand extends FilesCommand {
    execute(_event, _fileManager) {
        chrome.fileManagerPrivate.openInspector(chrome.fileManagerPrivate.InspectionType.NORMAL);
    }
}
/**
 * Open inspector for foreground page and bring focus to the console.
 */
class InspectConsoleCommand extends FilesCommand {
    execute(_event, _fileManager) {
        chrome.fileManagerPrivate.openInspector(chrome.fileManagerPrivate.InspectionType.CONSOLE);
    }
}
/**
 * Open inspector for foreground page in inspect element mode.
 */
class InspectElementCommand extends FilesCommand {
    execute(_event, _fileManager) {
        chrome.fileManagerPrivate.openInspector(chrome.fileManagerPrivate.InspectionType.ELEMENT);
    }
}
/**
 * Opens the gear menu.
 */
class OpenGearMenuCommand extends FilesCommand {
    execute(_event, fileManager) {
        fileManager.ui.gearButton.showMenu(true);
    }
}
/**
 * Focus the first button visible on action bar (at the top).
 */
class FocusActionBarCommand extends FilesCommand {
    execute(_event, fileManager) {
        fileManager.ui.actionbar
            .querySelector('button:not([hidden]), cr-button:not([hidden])')
            ?.focus();
    }
}
/**
 * Handle back button.
 */
class BrowserBackCommand extends FilesCommand {
    execute(_event, _fileManager) {
        // TODO(fukino): It should be better to minimize Files app only when there
        // is no back stack, and otherwise use BrowserBack for history navigation.
        // https://crbug.com/624100.
        // TODO(crbug.com/40701086): Implement minimize for files SWA, then
        // call its minimize() function here.
    }
}
/**
 * Configures the currently selected volume.
 */
class ConfigureCommand extends FilesCommand {
    execute(event, fileManager) {
        const volumeInfo = getElementVolumeInfo(event.target, fileManager);
        if (volumeInfo && volumeInfo.configurable) {
            fileManager.volumeManager.configure(volumeInfo);
        }
    }
    canExecute(event, fileManager) {
        const volumeInfo = getElementVolumeInfo(event.target, fileManager);
        event.canExecute = !!volumeInfo && volumeInfo.configurable;
        event.command.setHidden(!event.canExecute);
    }
}
/**
 * Refreshes the currently selected directory.
 */
class RefreshCommand extends FilesCommand {
    execute(_event, fileManager) {
        fileManager.directoryModel.rescan(true /* refresh */);
        fileManager.spinnerController.blink();
    }
    canExecute(event, fileManager) {
        const currentDirEntry = fileManager.directoryModel.getCurrentDirEntry();
        const volumeInfo = currentDirEntry &&
            fileManager.volumeManager.getVolumeInfo(currentDirEntry);
        event.canExecute = !!volumeInfo && !volumeInfo.watchable;
        event.command.setHidden(!event.canExecute ||
            fileManager.directoryModel.getFileListSelection().getCheckSelectMode());
    }
}
/**
 * Sets the system wallpaper to the selected file.
 */
class SetWallpaperCommand extends FilesCommand {
    execute(_event, fileManager) {
        if (isOnTrashRoot(fileManager)) {
            return;
        }
        const entry = fileManager.getSelection().entries[0];
        new Promise((resolve, reject) => {
            entry.file(resolve, reject);
        })
            .then((blob) => {
            const fileReader = new FileReader();
            return new Promise((resolve, reject) => {
                fileReader.onload = () => {
                    resolve(fileReader.result);
                };
                fileReader.onerror = () => {
                    reject(fileReader.error);
                };
                fileReader.readAsArrayBuffer(blob);
            });
        })
            .then((arrayBuffer) => {
            assert$1(arrayBuffer);
            return chrome.wallpaper.setWallpaper({
                data: arrayBuffer,
                layout: chrome.wallpaper.WallpaperLayout.CENTER_CROPPED,
                filename: 'wallpaper',
            });
        })
            .catch(() => {
            fileManager.ui.alertDialog.showHtml('', str('ERROR_INVALID_WALLPAPER'));
        });
    }
    canExecute(event, fileManager) {
        if (isOnTrashRoot(fileManager)) {
            event.canExecute = false;
            event.command.setHidden(true);
            return;
        }
        const entries = fileManager.getSelection().entries;
        if (entries.length === 0) {
            event.canExecute = false;
            event.command.setHidden(true);
            return;
        }
        const type = getType(entries[0]);
        if (entries.length !== 1 || type.type !== 'image') {
            event.canExecute = false;
            event.command.setHidden(true);
            return;
        }
        event.canExecute = type.subtype === 'JPEG' || type.subtype === 'PNG';
        event.command.setHidden(false);
    }
}
/**
 * Opens settings/storage sub page.
 */
class VolumeStorageCommand extends FilesCommand {
    execute(_event, _fileManager) {
        chrome.fileManagerPrivate.openSettingsSubpage('storage');
    }
    canExecute(event, fileManager) {
        event.canExecute = false;
        const currentVolumeInfo = fileManager.directoryModel.getCurrentVolumeInfo();
        if (!currentVolumeInfo) {
            return;
        }
        // Can execute only for local file systems.
        if (currentVolumeInfo.volumeType === VolumeType.MY_FILES ||
            currentVolumeInfo.volumeType === VolumeType.DOWNLOADS ||
            currentVolumeInfo.volumeType === VolumeType.CROSTINI ||
            currentVolumeInfo.volumeType === VolumeType.GUEST_OS ||
            currentVolumeInfo.volumeType === VolumeType.ANDROID_FILES ||
            currentVolumeInfo.volumeType === VolumeType.DOCUMENTS_PROVIDER) {
            event.canExecute = true;
        }
    }
}
/**
 * Opens "providers menu" to allow users to use providers/FSPs.
 */
class ShowProvidersSubmenuCommand extends FilesCommand {
    execute(_event, fileManager) {
        fileManager.ui.gearButton.showSubMenu();
    }
    canExecute(event, fileManager) {
        if (fileManager.dialogType !== DialogType.FULL_PAGE) {
            event.canExecute = false;
        }
        else {
            event.canExecute = !fileManager.guestMode;
        }
    }
}

// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * Name of a command (for UMA).
 */
var MenuCommandsForUma;
(function (MenuCommandsForUma) {
    MenuCommandsForUma["HELP"] = "volume-help";
    MenuCommandsForUma["DRIVE_HELP"] = "volume-help-drive";
    MenuCommandsForUma["DRIVE_BUY_MORE_SPACE"] = "drive-buy-more-space";
    MenuCommandsForUma["DRIVE_GO_TO_DRIVE"] = "drive-go-to-drive";
    MenuCommandsForUma["HIDDEN_FILES_SHOW"] = "toggle-hidden-files-on";
    MenuCommandsForUma["HIDDEN_FILES_HIDE"] = "toggle-hidden-files-off";
    MenuCommandsForUma["MOBILE_DATA_ON"] = "drive-sync-settings-enabled";
    MenuCommandsForUma["MOBILE_DATA_OFF"] = "drive-sync-settings-disabled";
    MenuCommandsForUma["DEPRECATED_SHOW_GOOGLE_DOCS_FILES_OFF"] = "drive-hosted-settings-disabled";
    MenuCommandsForUma["DEPRECATED_SHOW_GOOGLE_DOCS_FILES_ON"] = "drive-hosted-settings-enabled";
    MenuCommandsForUma["HIDDEN_ANDROID_FOLDERS_SHOW"] = "toggle-hidden-android-folders-on";
    MenuCommandsForUma["HIDDEN_ANDROID_FOLDERS_HIDE"] = "toggle-hidden-android-folders-off";
    MenuCommandsForUma["SHARE_WITH_LINUX"] = "share-with-linux";
    MenuCommandsForUma["MANAGE_LINUX_SHARING"] = "manage-linux-sharing";
    MenuCommandsForUma["MANAGE_LINUX_SHARING_TOAST"] = "manage-linux-sharing-toast";
    MenuCommandsForUma["MANAGE_LINUX_SHARING_TOAST_STARTUP"] = "manage-linux-sharing-toast-startup";
    MenuCommandsForUma["SHARE_WITH_PLUGIN_VM"] = "share-with-plugin-vm";
    MenuCommandsForUma["MANAGE_PLUGIN_VM_SHARING"] = "manage-plugin-vm-sharing";
    MenuCommandsForUma["MANAGE_PLUGIN_VM_SHARING_TOAST"] = "manage-plugin-vm-sharing-toast";
    MenuCommandsForUma["MANAGE_PLUGIN_VM_SHARING_TOAST_STARTUP"] = "manage-plugin-vm-sharing-toast-startup";
    MenuCommandsForUma["PIN_TO_HOLDING_SPACE"] = "pin-to-holding-space";
    MenuCommandsForUma["UNPIN_FROM_HOLDING_SPACE"] = "unpin-from-holding-space";
    MenuCommandsForUma["SHARE_WITH_BRUSCHETTA"] = "share-with-bruschetta";
    MenuCommandsForUma["MANAGE_BRUSCHETTA_SHARING"] = "manage-bruschetta-sharing";
    MenuCommandsForUma["MANAGE_BRUSCHETTA_SHARING_TOAST"] = "manage-bruschetta-sharing-toast";
    MenuCommandsForUma["MANAGE_BRUSCHETTA_SHARING_TOAST_STARTUP"] = "manage-bruschetta-sharing-toast-startup";
})(MenuCommandsForUma || (MenuCommandsForUma = {}));
const cutCopyCommand = new CutCopyCommand();
const deleteCommand = new DeleteCommand();
const crostiniSettings = 'crostini/sharedPaths';
const pluginVmSettings = 'app-management/pluginVm/sharedPaths';
const bruschettaSettings = 'bruschetta/sharedPaths';
/**
 * A map of FilesCommand to the ID that is used in the DOM to reference them.
 */
const FilesCommands = {
    'focus-action-bar': new FocusActionBarCommand(),
    'open-gear-menu': new OpenGearMenuCommand(),
    'inspect-element': new InspectElementCommand(),
    'inspect-console': new InspectConsoleCommand(),
    'inspect-normal': new InspectNormalCommand(),
    'sort-by-date': new SortByDateCommand(),
    'sort-by-type': new SortByTypeCommand(),
    'sort-by-size': new SortBySizeCommand(),
    'sort-by-name': new SortByNameCommand(),
    'zoom-reset': new ZoomResetCommand(),
    'zoom-out': new ZoomOutCommand(),
    'zoom-in': new ZoomInCommand(),
    'unpin-folder': new UnpinFolderCommand(),
    'pin-folder': new PinFolderCommand(),
    'manage-mirrorsync': new ManageMirrorsyncCommand(),
    'manage-in-drive': new ManageInDriveCommand(),
    'zip-selection': new ZipSelectionCommand(),
    'extract-all': new ExtractAllCommand(),
    'toggle-pinned': new TogglePinnedCommand(),
    'search': new SearchCommand(),
    'dlp-restriction-details': new DlpRestrictionDetailsCommand(),
    'get-info': new GetInfoCommand(),
    'go-to-file-location': new GoToFileLocationCommand(),
    'toggle-holding-space': new ToggleHoldingSpaceCommand(),
    'invoke-sharesheet': new InvokeSharesheetCommand(),
    'open-with': new OpenWithCommand(),
    'default-task': new DefaultTaskCommand(),
    'drive-go-to-drive': new DriveGoToDriveCommand(),
    'drive-buy-more-space': new DriveBuyMoreSpaceCommand(),
    'send-feedback': new SendFeedbackCommand(),
    'volume-help': new VolumeHelpCommand(),
    'files-settings': new FilesSettingsCommand(),
    'rename': new RenameCommand(),
    'cut': cutCopyCommand,
    'copy': cutCopyCommand,
    'paste-into-folder': new PasteIntoFolderCommand(),
    'paste-into-current-folder': new PasteIntoCurrentFolderCommand(),
    'paste': new PasteCommand(),
    'empty-trash': new EmptyTrashCommand(),
    'restore-from-trash': new RestoreFromTrashCommand(),
    'delete': deleteCommand,
    'move-to-trash': deleteCommand,
    'drive-sync-settings': new DriveSyncSettingsCommand(),
    'toggle-hidden-android-folders': new ToggleHiddenAndroidFoldersCommand(),
    'toggle-hidden-files': new ToggleHiddenFilesCommand(),
    'select-all': new SelectAllCommand(),
    'new-window': new NewWindowCommand(),
    'new-folder': new NewFolderCommand(),
    'erase-device': new EraseDeviceCommand(),
    'format': new FormatCommand(),
    'unmount': new UnmountCommand(),
    'browser-back': new BrowserBackCommand(),
    'configure': new ConfigureCommand(),
    'refresh': new RefreshCommand(),
    'set-wallpaper': new SetWallpaperCommand(),
    'volume-storage': new VolumeStorageCommand(),
    'show-providers-submenu': new ShowProvidersSubmenuCommand(),
    'volume-switch-1': new VolumeSwitchCommand(1),
    'volume-switch-2': new VolumeSwitchCommand(2),
    'volume-switch-3': new VolumeSwitchCommand(3),
    'volume-switch-4': new VolumeSwitchCommand(4),
    'volume-switch-5': new VolumeSwitchCommand(5),
    'volume-switch-6': new VolumeSwitchCommand(6),
    'volume-switch-7': new VolumeSwitchCommand(7),
    'volume-switch-8': new VolumeSwitchCommand(8),
    'volume-switch-9': new VolumeSwitchCommand(9),
    'share-with-linux': new GuestOsShareCommand(DEFAULT_CROSTINI_VM, 'CROSTINI', crostiniSettings, MenuCommandsForUma.MANAGE_LINUX_SHARING_TOAST, MenuCommandsForUma.SHARE_WITH_LINUX),
    'share-with-plugin-vm': new GuestOsShareCommand(PLUGIN_VM$1, 'PLUGIN_VM', pluginVmSettings, MenuCommandsForUma.MANAGE_PLUGIN_VM_SHARING_TOAST, MenuCommandsForUma.SHARE_WITH_PLUGIN_VM),
    'share-with-bruschetta': new GuestOsShareCommand(DEFAULT_BRUSCHETTA_VM, 'BRUSCHETTA', bruschettaSettings, MenuCommandsForUma.MANAGE_BRUSCHETTA_SHARING_TOAST, MenuCommandsForUma.SHARE_WITH_BRUSCHETTA),
    'manage-linux-sharing-gear': new GuestOsManagingSharingGearCommand(DEFAULT_CROSTINI_VM, crostiniSettings, MenuCommandsForUma.MANAGE_LINUX_SHARING),
    'manage-plugin-vm-sharing-gear': new GuestOsManagingSharingGearCommand(PLUGIN_VM$1, pluginVmSettings, MenuCommandsForUma.MANAGE_PLUGIN_VM_SHARING),
    'manage-bruschetta-sharing-gear': new GuestOsManagingSharingGearCommand(DEFAULT_BRUSCHETTA_VM, bruschettaSettings, MenuCommandsForUma.MANAGE_BRUSCHETTA_SHARING),
    'manage-linux-sharing': new GuestOsManagingSharingCommand(DEFAULT_CROSTINI_VM, crostiniSettings, MenuCommandsForUma.MANAGE_LINUX_SHARING),
    'manage-plugin-vm-sharing': new GuestOsManagingSharingCommand(PLUGIN_VM$1, pluginVmSettings, MenuCommandsForUma.MANAGE_PLUGIN_VM_SHARING),
    'manage-bruschetta-sharing': new GuestOsManagingSharingCommand(DEFAULT_BRUSCHETTA_VM, bruschettaSettings, MenuCommandsForUma.MANAGE_BRUSCHETTA_SHARING),
};
/**
 * Handle of the command events.
 */
class CommandHandler {
    /**
     * @param fileManager_ Classes |CommandHandler| depends.
     */
    constructor(fileManager_) {
        this.fileManager_ = fileManager_;
        /**
         * Command elements.
         */
        this.commands_ = {};
        this.lastFocusedElement_ = null;
        // Decorate command tags in the document.
        const commands = this.fileManager_.document.querySelectorAll('command');
        for (const command of commands) {
            crInjectTypeAndInit(command, Command);
            this.commands_[command.id] = command;
        }
        // Register events.
        this.fileManager_.document.addEventListener('command', this.onCommand_.bind(this));
        this.fileManager_.document.addEventListener('canExecute', this.onCanExecute_.bind(this));
        contextMenuHandler.addEventListener('show', this.onContextMenuShow_.bind(this));
        contextMenuHandler.addEventListener('hide', this.onContextMenuHide_.bind(this));
    }
    onContextMenuShow_(event) {
        this.lastFocusedElement_ = document.activeElement;
        const menu = event.detail.menu;
        // Set focus asynchronously to give time for menu "show" event to finish and
        // have all items set up before focusing.
        setTimeout(() => {
            if (!menu.hidden) {
                menu.focusSelectedItem();
            }
        }, 0);
    }
    onContextMenuHide_(_event) {
        if (this.lastFocusedElement_) {
            const activeElement = document.activeElement;
            if (activeElement && activeElement.tagName === 'BODY') {
                this.lastFocusedElement_.focus();
            }
            this.lastFocusedElement_ = null;
        }
    }
    /**
     * Handles command events.
     */
    onCommand_(event) {
        assert$1(this.fileManager_.document);
        if (shouldIgnoreEvents(this.fileManager_.document)) {
            return;
        }
        const commandId = event.detail.command.id;
        const handler = FilesCommands[commandId];
        handler.execute(event, this.fileManager_);
    }
    /**
     * Handles canExecute events.
     */
    onCanExecute_(event) {
        assert$1(this.fileManager_.document);
        if (shouldIgnoreEvents(this.fileManager_.document)) {
            return;
        }
        const commandId = event.command.id;
        const handler = FilesCommands[commandId];
        handler.canExecute(event, this.fileManager_);
    }
    /**
     * Returns command handler by name.
     */
    static getCommand(name) {
        return FilesCommands[name];
    }
}
/**
 * Keep the order of this in sync with FileManagerMenuCommands in
 * tools/metrics/histograms/enums.xml.
 * The array indices will be recorded in UMA as enum values. The index for each
 * root type should never be renumbered nor reused in this array.
 */
const ValidMenuCommandsForUma = [
    MenuCommandsForUma.HELP,
    MenuCommandsForUma.DRIVE_HELP,
    MenuCommandsForUma.DRIVE_BUY_MORE_SPACE,
    MenuCommandsForUma.DRIVE_GO_TO_DRIVE,
    MenuCommandsForUma.HIDDEN_FILES_SHOW,
    MenuCommandsForUma.HIDDEN_FILES_HIDE,
    MenuCommandsForUma.MOBILE_DATA_ON,
    MenuCommandsForUma.MOBILE_DATA_OFF,
    MenuCommandsForUma.DEPRECATED_SHOW_GOOGLE_DOCS_FILES_OFF,
    MenuCommandsForUma.DEPRECATED_SHOW_GOOGLE_DOCS_FILES_ON,
    MenuCommandsForUma.HIDDEN_ANDROID_FOLDERS_SHOW,
    MenuCommandsForUma.HIDDEN_ANDROID_FOLDERS_HIDE,
    MenuCommandsForUma.SHARE_WITH_LINUX,
    MenuCommandsForUma.MANAGE_LINUX_SHARING,
    MenuCommandsForUma.MANAGE_LINUX_SHARING_TOAST,
    MenuCommandsForUma.MANAGE_LINUX_SHARING_TOAST_STARTUP,
    MenuCommandsForUma.SHARE_WITH_PLUGIN_VM,
    MenuCommandsForUma.MANAGE_PLUGIN_VM_SHARING,
    MenuCommandsForUma.MANAGE_PLUGIN_VM_SHARING_TOAST,
    MenuCommandsForUma.MANAGE_PLUGIN_VM_SHARING_TOAST_STARTUP,
    MenuCommandsForUma.PIN_TO_HOLDING_SPACE,
    MenuCommandsForUma.UNPIN_FROM_HOLDING_SPACE,
    MenuCommandsForUma.SHARE_WITH_BRUSCHETTA,
    MenuCommandsForUma.MANAGE_BRUSCHETTA_SHARING,
    MenuCommandsForUma.MANAGE_BRUSCHETTA_SHARING_TOAST,
    MenuCommandsForUma.MANAGE_BRUSCHETTA_SHARING_TOAST_STARTUP,
];
console.assert(Object.keys(MenuCommandsForUma).length === ValidMenuCommandsForUma.length, 'Members in ValidMenuCommandsForUma do not match those in ' +
    'MenuCommandsForUma.');
/**
 * Records the menu item as selected in UMA.
 */
function recordMenuItemSelected(menuItem) {
    recordEnum('MenuItemSelected', menuItem, ValidMenuCommandsForUma);
}

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * Return DirectoryEntry of the first root directory (all volume display root
 * directories) that contains one or more query-matched files, returns null if
 * no such directory is found.
 *
 * @param volumeManager The volume manager.
 * @param dirModel The directory model.
 * @param searchQuery Search query.
 */
async function findQueryMatchedDirectoryEntry(volumeManager, dirModel, searchQuery) {
    for (let i = 0; i < volumeManager.volumeInfoList.length; i++) {
        const volumeInfo = volumeManager.volumeInfoList.item(i);
        // Make sure the volume root is resolved before scanning.
        await volumeInfo.resolveDisplayRoot();
        const dirEntry = volumeInfo.displayRoot;
        let isEntryFound = false;
        function entriesCallback() {
            isEntryFound = true;
        }
        function errorCallback(error) {
            console.warn(error.stack || error);
        }
        const scanner = dirModel.createScannerFactory(dirEntry.toURL(), dirEntry, searchQuery)();
        await new Promise(resolve => scanner.scan(entriesCallback, resolve, errorCallback));
        if (isEntryFound) {
            return dirEntry;
        }
    }
    return null;
}

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * CrostiniController handles the foreground UI relating to crostini.
 */
class CrostiniController {
    /**
     * @param crostini_ Crostini background object.
     */
    constructor(crostini_) {
        this.crostini_ = crostini_;
    }
    /**
     * Refreshes the Linux files item at startup and when crostini enabled
     * changes.
     */
    async redraw() {
        const store = getStore();
        // Setup Linux files fake root.
        if (this.crostini_.isEnabled(DEFAULT_CROSTINI_VM)) {
            const crostiniEntry = new FakeEntryImpl(str('LINUX_FILES_ROOT_LABEL'), RootType.CROSTINI);
            store.dispatch(addUiEntry(crostiniEntry));
        }
        else {
            store.dispatch(removeUiEntry(crostiniPlaceHolderKey));
        }
    }
    /**
     * Load the list of shared paths and show a toast if this is the first time
     * that FilesApp is loaded since login.
     *
     * @param maybeShowToast if true, show toast if this is the first
     *     time FilesApp is opened since login.
     */
    async loadSharedPaths(maybeShowToast, filesToast) {
        let showToast = maybeShowToast;
        const getSharedPaths = async (vmName) => {
            if (!this.crostini_.isEnabled(vmName)) {
                return 0;
            }
            return new Promise(resolve => {
                chrome.fileManagerPrivate.getCrostiniSharedPaths(maybeShowToast, vmName, ({ entries, firstForSession }) => {
                    showToast = showToast && firstForSession;
                    for (const entry of entries) {
                        this.crostini_.registerSharedPath(vmName, entry);
                    }
                    resolve(entries.length);
                });
            });
        };
        const toast = (count, msgSingle, msgPlural, action, subPage, umaItem) => {
            if (!showToast || count === 0) {
                return;
            }
            filesToast.show(count === 1 ? str(msgSingle) : strf(msgPlural, count), {
                text: str(action),
                callback: () => {
                    chrome.fileManagerPrivate.openSettingsSubpage(subPage);
                    recordMenuItemSelected(umaItem);
                },
            });
        };
        const [crostiniShareCount, pluginVmShareCount, bruschettaVmShareCount] = await Promise.all([
            getSharedPaths(DEFAULT_CROSTINI_VM),
            getSharedPaths(PLUGIN_VM$1),
            getSharedPaths(DEFAULT_BRUSCHETTA_VM),
        ]);
        // Toasts are queued and shown one-at-a-time if multiple apply.
        // TODO(b/260521400): Or at least, they will once this bug is fixed.
        toast(crostiniShareCount, 'FOLDER_SHARED_WITH_CROSTINI', 'FOLDER_SHARED_WITH_CROSTINI_PLURAL', 'MANAGE_TOAST_BUTTON_LABEL', 'crostini/sharedPaths', MenuCommandsForUma.MANAGE_LINUX_SHARING_TOAST_STARTUP);
        toast(pluginVmShareCount, 'FOLDER_SHARED_WITH_PLUGIN_VM', 'FOLDER_SHARED_WITH_PLUGIN_VM_PLURAL', 'MANAGE_TOAST_BUTTON_LABEL', 'app-management/pluginVm/sharedPaths', MenuCommandsForUma.MANAGE_PLUGIN_VM_SHARING_TOAST_STARTUP);
        toast(bruschettaVmShareCount, 'FOLDER_SHARED_WITH_BRUSCHETTA', 'FOLDER_SHARED_WITH_BRUSCHETTA_PLURAL', 'MANAGE_TOAST_BUTTON_LABEL', 'bruschetta/sharedPaths', MenuCommandsForUma.MANAGE_BRUSCHETTA_SHARING_TOAST_STARTUP);
    }
}

// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * Keep the order of this in sync with FileManagerVolumeType in
 * tools/metrics/histograms/enums.xml.
 */
const UMA_VOLUME_TYPES = [
    VolumeType.DRIVE,
    VolumeType.DOWNLOADS,
    VolumeType.REMOVABLE,
    VolumeType.ARCHIVE,
    VolumeType.PROVIDED,
    VolumeType.MTP,
    VolumeType.MEDIA_VIEW,
    VolumeType.CROSTINI,
    VolumeType.ANDROID_FILES,
    VolumeType.DOCUMENTS_PROVIDER,
    VolumeType.SMB,
    VolumeType.SYSTEM_INTERNAL,
    VolumeType.GUEST_OS,
];
/**
 * Keep the name and the value in sync with `FileManagerNavigationSurface` in
 * //tools/metrics/histograms/metadata/file/enums.xml
 */
var NavigationSurface;
(function (NavigationSurface) {
    NavigationSurface["PHYSCIAL_LOCATION"] = "0";
    NavigationSurface["SEARCH_RESULTS"] = "1";
    NavigationSurface["RECENT"] = "2";
    NavigationSurface["STARRED_FILES"] = "3";
    NavigationSurface["SCREEN_CAPTURES_VIEW"] = "4";
    NavigationSurface["DRIVE_SHARED_WITH_ME"] = "5";
    NavigationSurface["DRIVE_OFFLINE"] = "6";
})(NavigationSurface || (NavigationSurface = {}));
// The ordering is important.
const UMA_NAVIGATION_SURFACES = [
    NavigationSurface.PHYSCIAL_LOCATION,
    NavigationSurface.SEARCH_RESULTS,
    NavigationSurface.RECENT,
    NavigationSurface.STARRED_FILES,
    NavigationSurface.SCREEN_CAPTURES_VIEW,
    NavigationSurface.DRIVE_SHARED_WITH_ME,
    NavigationSurface.DRIVE_OFFLINE,
];
/**
 * Records the action of opening a file by the file volume type.
 */
function recordViewingVolumeTypeUma(state, fileKey) {
    const fileData = getFileData(state, fileKey);
    if (!fileData || !fileData.volumeId) {
        return;
    }
    const volumeType = state.volumes[fileData.volumeId]?.volumeType;
    if (!volumeType) {
        return;
    }
    if (!UMA_VOLUME_TYPES.includes(volumeType)) {
        debug(`Unknown volume type: ${volumeType} for key ${fileKey}`);
        console.warn(`Unknown volume type: ${volumeType}`);
        return;
    }
    recordEnum(appendAppMode(`ViewingVolumeType`, state), volumeType, UMA_VOLUME_TYPES);
}
function appendAppMode(name, state) {
    const dialogType = state.launchParams.dialogType;
    const appMode = (dialogType === DialogType.SELECT_SAVEAS_FILE || !dialogType) ? 'Other' :
        dialogType === DialogType.FULL_PAGE ? 'Standalone' :
            'FilePicker';
    return `${name}.${appMode}`;
}
/**
 * Records the action of opening a file by the file navigation surface.*
 */
function recordViewingNavigationSurfaceUma(state) {
    const currentDirectoryKey = state.currentDirectory?.key;
    const rootType = state.currentDirectory?.rootType;
    const search = !!state.search?.query && state.search.status === PropStatus.SUCCESS;
    if (!currentDirectoryKey && !search) {
        return;
    }
    let surface = NavigationSurface.PHYSCIAL_LOCATION;
    if (search) {
        surface = NavigationSurface.SEARCH_RESULTS;
    }
    else if (rootType === RootType.RECENT) {
        surface = NavigationSurface.RECENT;
    }
    else if (rootType === RootType.DRIVE_SHARED_WITH_ME) {
        surface = NavigationSurface.DRIVE_SHARED_WITH_ME;
    }
    else if (rootType === RootType.DRIVE_OFFLINE) {
        surface = NavigationSurface.DRIVE_OFFLINE;
    }
    recordEnum(appendAppMode(`ViewingNavigationSurface`, state), surface, UMA_NAVIGATION_SURFACES);
}

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * Controller for handling behaviors of the Files app opened as a file/folder
 * selection dialog.
 */
class DialogActionController {
    /**
     * @param dialogType Dialog type.
     * @param dialogFooter Dialog footer.
     * @param directoryModel Directory model.
     * @param volumeManager Volume manager.
     * @param fileFilter File filter model.
     * @param namingController Naming controller.
     * @param fileSelectionHandler Initial file selection.
     * @param launchParam Whether the dialog should return local path or not.
     */
    constructor(dialogType_, dialogFooter_, directoryModel_, volumeManager_, fileFilter_, namingController_, fileSelectionHandler_, launchParam) {
        this.dialogType_ = dialogType_;
        this.dialogFooter_ = dialogFooter_;
        this.directoryModel_ = directoryModel_;
        this.volumeManager_ = volumeManager_;
        this.fileFilter_ = fileFilter_;
        this.namingController_ = namingController_;
        this.fileSelectionHandler_ = fileSelectionHandler_;
        /**
         * Bound function for onCancel_.
         */
        this.onCancelBound_ = this.processCancelAction_.bind(this);
        this.newFolderCommand_ = document.querySelector('#new-folder');
        /**
         * List of acceptable file types for open dialog.
         */
        this.fileTypes_ = launchParam.typeList || [];
        this.allowedPaths_ = launchParam.allowedPaths;
        this.dialogFooter_.okButton.addEventListener('click', this.processOkAction_.bind(this));
        this.dialogFooter_.cancelButton.addEventListener('click', this.onCancelBound_);
        this.dialogFooter_.newFolderButton.addEventListener('click', this.processNewFolderAction_.bind(this));
        this.dialogFooter_.fileTypeSelector?.addEventListener('change', this.onFileTypeFilterChanged_.bind(this));
        this.dialogFooter_.filenameInput.addEventListener('input', this.updateOkButton_.bind(this));
        this.fileSelectionHandler_.addEventListener(EventType$2.CHANGE_THROTTLED, this.onFileSelectionChanged_.bind(this));
        this.volumeManager_.addEventListener('drive-connection-changed', this.updateOkButton_.bind(this));
        this.dialogFooter_.initFileTypeFilter(this.fileTypes_, launchParam.includeAllFiles);
        this.onFileTypeFilterChanged_();
        this.newFolderCommand_.addEventListener('disabledChange', this.updateNewFolderButton_.bind(this));
    }
    /**
     */
    async processOkActionForSaveDialog_() {
        const selection = this.fileSelectionHandler_.selection;
        // If OK action is clicked when a directory is selected, open the directory.
        if (selection.directoryCount === 1 && selection.fileCount === 0) {
            this.directoryModel_.changeDirectoryEntry(selection.entries[0]);
            return;
        }
        // Save-as doesn't require a valid selection from the list, since
        // we're going to take the filename from the text input.
        this.updateExtensionForSelectedFileType_(true);
        const filename = this.dialogFooter_.filenameInput.value;
        if (!filename) {
            console.warn('Missing filename');
            return;
        }
        try {
            const url = await this.namingController_.validateFileNameForSaving(filename);
            this.selectFilesAndClose_({
                urls: [url],
                multiple: false,
                filterIndex: this.dialogFooter_.selectedFilterIndex,
            });
        }
        catch (error) {
            if (!(error instanceof UserCanceledError)) {
                console.warn(error);
            }
        }
    }
    /**
     * Handle a click of the ok button.
     *
     * The ok button has different UI labels depending on the type of dialog, but
     * in code it's always referred to as 'ok'.
     *
     */
    processOkAction_() {
        if (this.dialogFooter_.okButton.disabled) {
            console.warn('okButton Disabled');
            return;
        }
        if (this.dialogType_ === DialogType.SELECT_SAVEAS_FILE) {
            this.processOkActionForSaveDialog_();
            return;
        }
        const files = [];
        const selectedIndexes = this.directoryModel_.getFileListSelection().selectedIndexes;
        if (isFolderDialogType(this.dialogType_) && selectedIndexes.length === 0) {
            const url = this.directoryModel_.getCurrentDirEntry().toURL();
            const singleSelection = {
                urls: [url],
                multiple: false,
                filterIndex: this.dialogFooter_.selectedFilterIndex,
            };
            this.selectFilesAndClose_(singleSelection);
            return;
        }
        // All other dialog types require at least one selected list item.
        // The logic to control whether or not the ok button is enabled should
        // prevent us from ever getting here, but we sanity check to be sure.
        if (!selectedIndexes.length) {
            console.warn('Nothing selected in the file list');
            return;
        }
        const dm = this.directoryModel_.getFileList();
        for (let i = 0; i < selectedIndexes.length; i++) {
            const index = selectedIndexes[i];
            const entry = index === undefined ? null : dm.item(index);
            if (!entry) {
                console.warn('Error locating selected file at index: ' + i);
                continue;
            }
            files.push(entry.toURL());
        }
        // Multi-file selection has no other restrictions.
        if (this.dialogType_ === DialogType.SELECT_OPEN_MULTI_FILE) {
            const multipleSelection = {
                urls: files,
                multiple: true,
            };
            this.selectFilesAndClose_(multipleSelection);
            return;
        }
        // Everything else must have exactly one.
        if (files.length > 1) {
            console.warn('Too many files selected');
            return;
        }
        const selectedEntry = dm.item(selectedIndexes[0] ?? -1);
        if (isFolderDialogType(this.dialogType_)) {
            if (!selectedEntry.isDirectory) {
                console.warn('Selected entry is not a folder');
                return;
            }
        }
        else if (this.dialogType_ === DialogType.SELECT_OPEN_FILE) {
            if (!selectedEntry.isFile) {
                console.warn('Selected entry is not a file');
                return;
            }
        }
        const singleSelection = {
            urls: [files[0]],
            multiple: false,
            filterIndex: this.dialogFooter_.selectedFilterIndex,
        };
        this.selectFilesAndClose_(singleSelection);
    }
    /**
     * Cancels file selection and closes the file selection dialog.
     */
    processCancelAction_() {
        chrome.fileManagerPrivate.cancelDialog();
        window.close();
    }
    /**
     * Creates a new folder using new-folder command.
     */
    processNewFolderAction_() {
        this.newFolderCommand_.canExecuteChange(this.dialogFooter_.newFolderButton);
        this.newFolderCommand_.execute(this.dialogFooter_.newFolderButton);
    }
    /**
     * Handles disabledChange event to update the new-folder button's
     * avaliability.
     */
    updateNewFolderButton_() {
        this.dialogFooter_.newFolderButton.disabled =
            this.newFolderCommand_.disabled;
    }
    /**
     * Tries to close this modal dialog with some files selected.
     * Performs preprocessing if needed (e.g. for Drive).
     * @param selection Contains urls, filterIndex and multiple fields.
     */
    selectFilesAndClose_(selection) {
        const currentRootType = this.directoryModel_.getCurrentRootType();
        const onFileSelected = () => {
            if (!chrome.runtime.lastError) {
                // Call next method on a timeout, as it's unsafe to
                // close a window from a callback.
                setTimeout(window.close.bind(window), 0);
            }
        };
        // Record the root types of chosen files in OPEN dialog.
        if (this.dialogType_ === DialogType.SELECT_OPEN_FILE ||
            this.dialogType_ === DialogType.SELECT_OPEN_MULTI_FILE) {
            recordEnum('OpenFiles.RootType', currentRootType, RootTypesForUMA);
        }
        const state = getStore().getState();
        for (const url of selection.urls) {
            recordViewingVolumeTypeUma(state, url);
            // Recorded per file.
            recordViewingNavigationSurfaceUma(state);
        }
        if (selection.multiple) {
            chrome.fileManagerPrivate.selectFiles(selection.urls, this.allowedPaths_ === AllowedPaths.NATIVE_PATH, onFileSelected);
        }
        else {
            chrome.fileManagerPrivate.selectFile(selection.urls[0], selection.filterIndex, this.dialogType_ !== DialogType.SELECT_SAVEAS_FILE /* for opening */, this.allowedPaths_ === AllowedPaths.NATIVE_PATH, onFileSelected);
        }
    }
    /**
     * Returns the regex to match against files for the current filter.
     */
    regexpForCurrentFilter_() {
        // Note selectedFilterIndex indexing is 1-based. (0 is "all files").
        const selectedIndex = this.dialogFooter_.selectedFilterIndex;
        if (selectedIndex < 1) {
            return null; // No specific filter selected.
        }
        return new RegExp('\\.(' +
            this.fileTypes_[selectedIndex - 1]
                .extensions
                // RegExp.escape is available since M136, but Typescript doesn't
                // recognize it yet, hence the "as any" below.
                .map(ext => RegExp.escape(ext))
                .join('|') +
            ')$', 'i');
    }
    /**
     * Updates the file input field to agree with the current filter.
     * @param forConfirm The update is for the final confirm step.
     */
    updateExtensionForSelectedFileType_(forConfirm) {
        const regexp = this.regexpForCurrentFilter_();
        if (!regexp) {
            return; // No filter selected.
        }
        let filename = this.dialogFooter_.filenameInput.value;
        if (!filename || regexp.test(filename)) {
            return; // Filename empty or already satisfies filter.
        }
        const selectedIndex = this.dialogFooter_.selectedFilterIndex;
        assert$1(selectedIndex > 0); // Otherwise there would be no regex.
        const newExtension = this.fileTypes_[selectedIndex - 1].extensions[0];
        if (!newExtension) {
            return; // No default extension.
        }
        const extensionIndex = filename.lastIndexOf('.');
        if (extensionIndex < 0) {
            // No current extension.
            if (!forConfirm) {
                return; // Add one later.
            }
            filename = `${filename}.${newExtension}`;
        }
        else {
            if (forConfirm) {
                return; // Keep the current user choice.
            }
            filename = `${filename.substr(0, extensionIndex)}.${newExtension}`;
        }
        this.dialogFooter_.filenameInput.value = filename;
        this.dialogFooter_.selectTargetNameInFilenameInput();
    }
    /**
     * Filters file according to the selected file type.
     */
    onFileTypeFilterChanged_() {
        this.fileFilter_.removeFilter('fileType');
        const regexp = this.regexpForCurrentFilter_();
        if (!regexp) {
            return;
        }
        const filter = (entry) => entry.isDirectory || regexp.test(entry.name);
        this.fileFilter_.addFilter('fileType', filter);
        // In save dialog, update the destination name extension.
        if (this.dialogType_ === DialogType.SELECT_SAVEAS_FILE) {
            this.updateExtensionForSelectedFileType_(false);
        }
    }
    /**
     * Handles selection change.
     */
    onFileSelectionChanged_() {
        // If this is a save-as dialog, copy the selected file into the filename
        // input text box.
        const selection = this.fileSelectionHandler_.selection;
        if (this.dialogType_ === DialogType.SELECT_SAVEAS_FILE &&
            selection.totalCount === 1 && selection.entries[0].isFile &&
            this.dialogFooter_.filenameInput.value !== selection.entries[0].name) {
            this.dialogFooter_.filenameInput.value = selection.entries[0].name;
        }
        this.updateOkButton_();
        if (!this.dialogFooter_.okButton.disabled) {
            testSendMessage('dialog-ready');
        }
    }
    /**
     * Updates the Ok button enabled state.
     */
    updateOkButton_() {
        const selection = this.fileSelectionHandler_.selection;
        if (this.dialogType_ === DialogType.FULL_PAGE) {
            // No "select" buttons on the full page UI.
            this.dialogFooter_.okButton.disabled = false;
            return;
        }
        if (isFolderDialogType(this.dialogType_)) {
            // In SELECT_FOLDER mode, we allow to select current directory
            // when nothing is selected.
            this.dialogFooter_.okButton.disabled =
                selection.directoryCount > 1 || selection.fileCount !== 0;
            return;
        }
        if (this.dialogType_ === DialogType.SELECT_SAVEAS_FILE) {
            if (selection.directoryCount === 1 && selection.fileCount === 0) {
                this.dialogFooter_.okButtonLabel.textContent = str('OPEN_LABEL');
                this.dialogFooter_.okButton.disabled =
                    this.fileSelectionHandler_.isDlpBlocked();
            }
            else {
                this.dialogFooter_.okButtonLabel.textContent = str('SAVE_LABEL');
                this.dialogFooter_.okButton.disabled =
                    this.directoryModel_.isReadOnly() ||
                        this.directoryModel_.isDlpBlocked() ||
                        !this.dialogFooter_.filenameInput.value ||
                        !this.fileSelectionHandler_.isAvailable();
            }
            return;
        }
        if (this.dialogType_ === DialogType.SELECT_OPEN_FILE) {
            this.dialogFooter_.okButton.disabled = selection.directoryCount !== 0 ||
                selection.fileCount !== 1 ||
                !this.fileSelectionHandler_.isAvailable() ||
                this.fileSelectionHandler_.isDlpBlocked();
            return;
        }
        if (this.dialogType_ === DialogType.SELECT_OPEN_MULTI_FILE) {
            this.dialogFooter_.okButton.disabled = selection.directoryCount !== 0 ||
                selection.fileCount === 0 ||
                !this.fileSelectionHandler_.isAvailable() ||
                this.fileSelectionHandler_.isDlpBlocked();
            return;
        }
        assertNotReached$1('Unknown dialog type.');
    }
}

// Copyright 2015 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * Metadata of a file.
 */
class MetadataItem {
}

// Copyright 2012 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * Scanner of the entries.
 */
class ContentScanner {
    constructor() {
        this.canceled_ = false;
    }
    /**
     * Request cancelling of the running scan. When the cancelling is done,
     * an error will be reported from errorCallback passed to scan().
     */
    cancel() {
        this.canceled_ = true;
    }
    /**
     * Whether the scanner pushes the entry directly to the store.
     */
    isStoreBased() {
        return false;
    }
}
/**
 * No-op class to be used for fake entries and such.
 */
class EmptyContentScanner extends ContentScanner {
    /**
     * A dummy implementation of the scan method. It delivers an empty list of
     * entries on the `entriesCallback` and immediately calls the
     * `successCallback`.
     */
    scan(entriesCallback, successCallback, _errorCallback, _invalidateCache) {
        entriesCallback([]);
        successCallback();
        return Promise.resolve();
    }
}
/**
 * Scanner of the entries in a directory.
 */
class DirectoryContentScanner extends ContentScanner {
    constructor(entry_) {
        super();
        this.entry_ = entry_;
    }
    /**
     * Starts to read the entries in the directory.
     */
    async scan(entriesCallback, successCallback, errorCallback, _invalidateCache = false) {
        if (!this.entry_ || !this.entry_.createReader) {
            // If entry is not specified or if entry doesn't implement createReader,
            // we cannot read it.
            errorCallback(createDOMError(FileErrorToDomError.INVALID_MODIFICATION_ERR));
            return;
        }
        startInterval('DirectoryScan');
        const reader = this.entry_.createReader();
        const readEntries = () => {
            reader.readEntries(entries => {
                if (this.canceled_) {
                    errorCallback(createDOMError(FileErrorToDomError.ABORT_ERR));
                    return;
                }
                if (entries.length === 0) {
                    // All entries are read.
                    recordInterval('DirectoryScan');
                    successCallback();
                    return;
                }
                entriesCallback(entries);
                readEntries();
            }, errorCallback);
        };
        readEntries();
    }
}
/**
 * Latency metric variant names supported by the search content scanner.
 */
var LatencyVariant;
(function (LatencyVariant) {
    /** Local volume; typically local SSD */
    LatencyVariant["LOCAL"] = "Local";
    /** Removable storage, typically USB */
    LatencyVariant["REMOVABLE"] = "Removable";
    /** Provided volume, such as OneDrive */
    LatencyVariant["PROVIDED"] = "Provided";
    /** Android based volume exposed via DocumentsProvider type service. */
    LatencyVariant["DOCUMENTS_PROVIDER"] = "DocumentsProvider";
})(LatencyVariant || (LatencyVariant = {}));
/**
 * A content scanner capable of scanning both the local file system and Google
 * Drive. When created you need to specify the root type, current entry
 * in the directory tree, the search query and options. The `rootType` together
 * with `options` is then used to determine if the search is conducted on the
 * local folder, root folder, or on the local file system and Google Drive.
 *
 * NOTE: This class is a stop-gap solution when transitioning to a content
 * scanner that talks to a browser level service. The service ultimately should
 * be the one that determines what is being searched, and aggregates the results
 * for the frontend client.
 */
class SearchV2ContentScanner extends ContentScanner {
    constructor(volumeManager_, entry_, query, options) {
        super();
        this.volumeManager_ = volumeManager_;
        this.entry_ = entry_;
        const locationInfo = this.volumeManager_.getLocationInfo(this.entry_);
        this.rootType_ = locationInfo ? locationInfo.rootType : null;
        this.query_ = query.toLowerCase();
        this.options_ = options || getDefaultSearchOptions();
        this.driveSearchTypeMap_ = new Map([
            [
                RootType.DRIVE_OFFLINE,
                chrome.fileManagerPrivate.SearchType.OFFLINE,
            ],
            [
                RootType.DRIVE_SHARED_WITH_ME,
                chrome.fileManagerPrivate.SearchType.EXCLUDE_DIRECTORIES,
            ],
            [
                RootType.DRIVE_RECENT,
                chrome.fileManagerPrivate.SearchType.EXCLUDE_DIRECTORIES,
            ],
        ]);
    }
    /**
     * For the given `dirEntry` it returns a list of searchable roots. This
     * method exists as we have special volumes that aggregate other volumes.
     * Examples include Crostini, Playfiles, aggregated in My files or
     * USB partitions aggregated by USB root. For those cases we return multiple
     * search roots. For plain directories we just return the directory itself.
     */
    getSearchRoots_(dirEntry) {
        const typeName = 'typeName' in dirEntry ? dirEntry.typeName : null;
        if (typeName !== 'EntryList' && typeName !== 'VolumeEntry') {
            return [dirEntry];
        }
        const children = dirEntry.getUiChildren();
        const allRoots = [dirEntry, ...children];
        return allRoots.filter(entry => !isFakeEntry(entry))
            .map(entry => entry.filesystem.root);
    }
    /**
     * For the given entry attempts to return the top most volume that contains
     * this entry. The reason for this method is that for some entries, getting
     * the root volume is not sufficient. For example, for a Linux folder the root
     * volume would be the Linux volume. However, in the UI Linux is nested inside
     * My files, so we need to get My files as the top-most volume of a Linux
     * directory.
     */
    getTopMostVolume_(entry) {
        const volumeInfo = this.volumeManager_.getVolumeInfo(entry);
        if (!volumeInfo) {
            // It's a placeholder or a fake entry.
            return entry;
        }
        const topEntry = volumeInfo.prefixEntry ?
            // TODO(b/289003444): Fix this cast.
            volumeInfo.prefixEntry :
            volumeInfo.displayRoot;
        // Here entry should never be null, but due to Closure annotations, Closure
        // thinks it may be (both prefixEntry and displayRoot above are not
        // guaranteed to be non-null).
        return topEntry ? this.getWrappedVolumeEntry_(topEntry) : entry;
    }
    getWrappedVolumeEntry_(entry) {
        const state = getStore().getState();
        // Fetch the wrapped VolumeEntry from the store.
        const fileData = state.allEntries[entry.toURL()];
        if (!fileData || !fileData.entry) {
            console.warn(`Missing FileData for ${entry.toURL()}`);
            // TODO(b/289003444): Fix this cast.
            return entry;
        }
        return fileData.entry;
    }
    /**
     * For the given colume type returns root directories for all volumes with the
     * given `volumeType`.
     */
    getRootFoldersByVolumeType_(volumeType) {
        const rootDirs = [];
        const volumeInfoList = this.volumeManager_.volumeInfoList;
        for (let index = 0; index < volumeInfoList.length; ++index) {
            const volumeInfo = volumeInfoList.item(index);
            if (volumeInfo.volumeType === volumeType) {
                const displayRoot = volumeInfo.displayRoot;
                if (displayRoot) {
                    rootDirs.push(...this.getSearchRoots_(displayRoot));
                }
            }
        }
        return rootDirs;
    }
    /**
     * Creates a single promise that, when fulfilled, returns a non-null array of
     * file entries. The array may be empty. The metricVariant must be a valid
     * name of the UMA search metric variant.
     */
    makeFileSearchPromise_(params, metricVariant) {
        return new Promise((resolve, reject) => {
            startInterval(`Search.${metricVariant}.Latency`);
            chrome.fileManagerPrivate.searchFiles(params, (entries) => {
                if (this.canceled_) {
                    reject(createDOMError(FileErrorToDomError.ABORT_ERR));
                }
                else if (chrome.runtime.lastError) {
                    reject(createDOMError(FileErrorToDomError.NOT_READABLE_ERR, chrome.runtime.lastError.message));
                }
                else {
                    recordInterval(`Search.${metricVariant}.Latency`);
                    resolve(entries);
                }
            });
        });
    }
    /**
     * Creates a promise that, when fulfilled, returns a non-null array of
     * file entries. This promise uses a client side recursive entry reader.
     */
    makeReadEntriesRecursivelyPromise_(folder, modifiedTimestamp, category, maxResults, metricVariant) {
        // A promise that resolves to an entry if it is modified after cutoffDate or
        // null, otherwise. Used to filter entries by modified time. If we fail to
        // get metadata for an entry we return it without comparison, to be on the
        // safe side.
        const newDateFilterPromise = (entry, cutoffDate) => new Promise(resolve => {
            entry.getMetadata(
            // TODO(b:289003444): Check if metadata is available in the store.
            (metadata) => {
                resolve(metadata.modificationTime > cutoffDate ? entry : null);
            }, () => {
                resolve(entry);
            });
        });
        return new Promise((resolve, reject) => {
            startInterval(`Search.${metricVariant}.Latency`);
            const collectedEntries = [];
            let workLeft = 1;
            readEntriesRecursively(folder, 
            // More entries found callback.
            (entries) => {
                const filtered = entries.filter((entry) => {
                    if (entry.name.toLowerCase().indexOf(this.query_) < 0) {
                        return false;
                    }
                    if (category !== chrome.fileManagerPrivate.FileCategory.ALL) {
                        if (!isType([category], entry)) {
                            return false;
                        }
                    }
                    return true;
                });
                if (modifiedTimestamp === 0) {
                    collectedEntries.push(...filtered);
                }
                else {
                    workLeft += filtered.length;
                    const cutoff = new Date(modifiedTimestamp);
                    Promise
                        .all(filtered.map((entry) => newDateFilterPromise(entry, cutoff)))
                        .then((modified) => {
                        const nullEntryFilter = (e) => {
                            return e !== null;
                        };
                        collectedEntries.push(...modified.filter(nullEntryFilter));
                        workLeft -= modified.length;
                        if (workLeft <= 0) {
                            recordInterval(`Search.${metricVariant}.Latency`);
                            resolve(collectedEntries);
                        }
                    });
                }
            }, 
            // All entries read callback.
            () => {
                if (--workLeft <= 0) {
                    recordInterval(`Search.${metricVariant}.Latency`);
                    resolve(collectedEntries);
                }
            }, 
            // Error callback.
            () => {
                if (!this.canceled_ && collectedEntries.length >= maxResults) {
                    recordInterval(`Search.${metricVariant}.Latency`);
                    resolve(collectedEntries);
                }
                else {
                    reject();
                }
            }, 
            // Should stop callback.
            () => {
                return collectedEntries.length >= maxResults || this.canceled_;
            });
        });
    }
    /**
     * For the given set of `folders` holding directory entries, creates an array
     * of promises that, when fulfilled, return an array of entries in those
     * directories.
     */
    makeFileSearchPromiseList_(modifiedTimestamp, category, maxResults, metricVariant, folders) {
        const baseParams = {
            rootDir: undefined, // Provided in the loop below.
            query: this.query_,
            types: chrome.fileManagerPrivate.SearchType.ALL,
            maxResults: maxResults,
            modifiedTimestamp: modifiedTimestamp,
            category: category,
        };
        return folders.map((searchDir) => this.makeFileSearchPromise_({
            ...baseParams,
            rootDir: searchDir,
        }, metricVariant));
    }
    /**
     * Returns an array of promises that, when fulfilled, return an array of
     * entries matching the current query, modified timestamp, and category for
     * folders located under My files.
     */
    createMyFilesSearch_(modifiedTimestamp, category, maxResults) {
        const myFilesVolume = this.volumeManager_.getCurrentProfileVolumeInfo(VolumeType.DOWNLOADS);
        if (!myFilesVolume || !myFilesVolume.displayRoot) {
            return [];
        }
        const myFilesEntry = this.getWrappedVolumeEntry_(myFilesVolume.displayRoot);
        return this.makeFileSearchPromiseList_(modifiedTimestamp, category, maxResults, LatencyVariant.LOCAL, this.getSearchRoots_(myFilesEntry));
    }
    /**
     * Returns an array of promises that, when fulfilled, return an array of
     * entries matching the current query, modified timestamp, and category for
     * all known removable drives.
     */
    createRemovablesSearch_(modifiedTimestamp, category, maxResults) {
        return this.makeFileSearchPromiseList_(modifiedTimestamp, category, maxResults, LatencyVariant.REMOVABLE, this.getRootFoldersByVolumeType_(VolumeType.REMOVABLE));
    }
    /**
     * Returns an array of promises that, when fulfilled, return an array of
     * entries matching the current query, modified timestamp, and category for
     * all known document providers.
     */
    createDocumentsProviderSearch_(modifiedTimestamp, category, maxResults) {
        const rootFolderList = this.getRootFoldersByVolumeType_(VolumeType.DOCUMENTS_PROVIDER);
        return rootFolderList.map(rootFolder => this.makeReadEntriesRecursivelyPromise_(rootFolder, modifiedTimestamp, category, maxResults, LatencyVariant.DOCUMENTS_PROVIDER));
    }
    /**
     * Returns an array of promises that, when fulfilled, return an array of
     * entries matching the current query, modified timestamp, and category for
     * all known file system provider volumes.
     */
    createFileSystemProviderSearch_(modifiedTimestamp, category, maxResults) {
        const rootFolderList = this.getRootFoldersByVolumeType_(VolumeType.PROVIDED);
        return rootFolderList.map(rootFolder => this.makeReadEntriesRecursivelyPromise_(rootFolder, modifiedTimestamp, category, maxResults, LatencyVariant.PROVIDED));
    }
    /**
     * Returns a promise that, when fulfilled, returns an array of file entries
     * matching the current query, modified timestamp and category for files
     * located on Drive.
     */
    createDriveSearch_(modifiedTimestamp, category, maxResults) {
        let searchType = this.rootType_ !== null ?
            this.driveSearchTypeMap_.get(this.rootType_) :
            null;
        if (!searchType) {
            searchType = chrome.fileManagerPrivate.SearchType.ALL;
        }
        return new Promise((resolve, reject) => {
            startInterval('Search.Drive.Latency');
            chrome.fileManagerPrivate.searchDriveMetadata({
                query: this.query_,
                category: category,
                types: searchType,
                maxResults: maxResults,
                modifiedTimestamp: modifiedTimestamp,
                rootDir: undefined,
            }, (results) => {
                if (chrome.runtime.lastError) {
                    reject(createDOMError(FileErrorToDomError.NOT_READABLE_ERR, chrome.runtime.lastError.message));
                }
                else if (this.canceled_) {
                    reject(createDOMError(FileErrorToDomError.ABORT_ERR));
                }
                else if (!results) {
                    reject(createDOMError(FileErrorToDomError.INVALID_MODIFICATION_ERR));
                }
                else {
                    recordInterval('Search.Drive.Latency');
                    resolve(results.map(r => r.entry));
                }
            });
        });
    }
    createDirectorySearch_(modifiedTimestamp, category, maxResults) {
        if (isDriveRootType(this.rootType_)) {
            return [
                this.createDriveSearch_(modifiedTimestamp, category, maxResults),
            ];
        }
        const searchFolder = this.options_.location === SearchLocation.THIS_FOLDER ?
            this.entry_ :
            this.getTopMostVolume_(this.entry_);
        if (this.rootType_ === RootType.DOCUMENTS_PROVIDER) {
            return [this.makeReadEntriesRecursivelyPromise_(searchFolder, modifiedTimestamp, category, maxResults, LatencyVariant.DOCUMENTS_PROVIDER)];
        }
        if (this.rootType_ === RootType.PROVIDED) {
            return [this.makeReadEntriesRecursivelyPromise_(searchFolder, modifiedTimestamp, category, maxResults, LatencyVariant.PROVIDED)];
        }
        const metricVariant = this.rootType_ === RootType.REMOVABLE ?
            LatencyVariant.REMOVABLE :
            LatencyVariant.LOCAL;
        // My Files or a folder nested in it.
        return this.makeFileSearchPromiseList_(modifiedTimestamp, category, maxResults, metricVariant, this.getSearchRoots_(searchFolder));
    }
    createEverywhereSearch_(modifiedTimestamp, category, maxResults) {
        return [
            ...this.createMyFilesSearch_(modifiedTimestamp, category, maxResults),
            ...this.createRemovablesSearch_(modifiedTimestamp, category, maxResults),
            this.createDriveSearch_(modifiedTimestamp, category, maxResults),
            ...this.createDocumentsProviderSearch_(modifiedTimestamp, category, maxResults),
            ...this.createFileSystemProviderSearch_(modifiedTimestamp, category, maxResults),
        ];
    }
    /**
     * Starts the file name search.
     */
    async scan(entriesCallback, successCallback, errorCallback, _invalidateCache = false) {
        const category = this.options_.fileCategory;
        const modifiedTimestamp = getEarliestTimestamp(this.options_.recency, new Date());
        const maxResults = 100;
        const searchPromises = this.options_.location === SearchLocation.EVERYWHERE ?
            this.createEverywhereSearch_(modifiedTimestamp, category, maxResults) :
            this.createDirectorySearch_(modifiedTimestamp, category, maxResults);
        if (!searchPromises) {
            console.warn(`No search promises for options ${JSON.stringify(this.options_)}`);
            successCallback();
        }
        // The job of entriesCallbackCaller is to call entriesCallback as soon as
        // entries are available. We call successCallback only once all of them are
        // settled, but we do not wish to wait for all of promises to be settled
        // before showing the entries.
        const entriesCallbackCaller = (entries) => {
            if (entries && entries.length > 0) {
                entriesCallback(entries);
            }
            return entries ? entries.length : 0;
        };
        Promise.allSettled(searchPromises.map(p => p.then(entriesCallbackCaller)))
            .then((results) => {
            let resultCount = 0;
            for (const result of results) {
                if (result.status === 'rejected') {
                    errorCallback(result.reason);
                }
                else if (result.status === 'fulfilled') {
                    resultCount += result.value;
                }
            }
            successCallback();
            recordMediumCount('Search.ResultCount', resultCount);
        });
    }
}
/**
 * Scanner of the entries for the metadata search on Drive File System.
 */
class DriveMetadataSearchContentScanner extends ContentScanner {
    constructor(searchType_) {
        super();
        this.searchType_ = searchType_;
    }
    /**
     * Starts to metadata-search on Drive File System.
     */
    async scan(entriesCallback, successCallback, errorCallback, _invalidateCache = false) {
        chrome.fileManagerPrivate.searchDriveMetadata({
            query: '',
            types: this.searchType_,
            maxResults: 100,
            rootDir: undefined,
            modifiedTimestamp: undefined,
            category: undefined,
        }, (results) => {
            if (chrome.runtime.lastError) {
                console.error(chrome.runtime.lastError.message);
            }
            if (this.canceled_) {
                errorCallback(createDOMError(FileErrorToDomError.ABORT_ERR));
                return;
            }
            if (!results) {
                console.warn('Drive search encountered an error.');
                errorCallback(createDOMError(FileErrorToDomError.INVALID_MODIFICATION_ERR));
                return;
            }
            const entries = results.map(result => {
                return result.entry;
            });
            if (entries.length > 0) {
                entriesCallback(entries);
            }
            successCallback();
        });
    }
}
class RecentContentScanner extends ContentScanner {
    constructor(query, cutoffDays_, volumeManager_, sourceRestriction, fileCategory) {
        super();
        this.cutoffDays_ = cutoffDays_;
        this.volumeManager_ = volumeManager_;
        this.query_ = query.toLowerCase();
        this.sourceRestriction_ = sourceRestriction ||
            chrome.fileManagerPrivate.SourceRestriction.ANY_SOURCE;
        this.fileCategory_ =
            fileCategory || chrome.fileManagerPrivate.FileCategory.ALL;
    }
    async scan(entriesCallback, successCallback, errorCallback, invalidateCache = false) {
        /**
         * Files app launched with "volumeFilter" launch parameter will filter
         * out some volumes. Before returning the recent entries, we need to
         * check if the entry's volume location is valid or not
         * (crbug.com/1333385/#c17).
         */
        const isAllowedVolume = (entry) => this.volumeManager_.getVolumeInfo(entry) !== null;
        chrome.fileManagerPrivate.getRecentFiles(this.sourceRestriction_, this.query_, this.cutoffDays_, this.fileCategory_, invalidateCache, entries => {
            if (chrome.runtime.lastError) {
                console.error(chrome.runtime.lastError.message);
                errorCallback(createDOMError(FileErrorToDomError.INVALID_MODIFICATION_ERR));
                return;
            }
            if (entries.length > 0) {
                entriesCallback(entries.filter(entry => isAllowedVolume(entry)));
            }
            successCallback();
        });
    }
}
/**
 * Scanner of media-view volumes.
 */
class MediaViewContentScanner extends ContentScanner {
    /**
     * Creates a scanner at the given root entry of the media-view volume.
     */
    constructor(rootEntry_) {
        super();
        this.rootEntry_ = rootEntry_;
    }
    /**
     * This scanner provides flattened view of media providers.
     *
     * In FileSystem API level, each media-view root directory has directory
     * hierarchy. We need to list files under the root directory to provide
     * flatten view. A file will not be shown in multiple directories in
     * media-view hierarchy since no folders will be added in media documents
     * provider. We can list all files without duplication by just retrieving
     * files in directories recursively.
     */
    async scan(entriesCallback, successCallback, errorCallback, _invalidateCache = false) {
        // To provide flatten view of files, this media-view scanner retrieves
        // files in directories inside the media's root entry recursively.
        readEntriesRecursively(this.rootEntry_, entries => entriesCallback(entries.filter(entry => !entry.isDirectory)), successCallback, errorCallback, () => false);
    }
}
/**
 * Shows an empty list and spinner whilst starting and mounting the
 * crostini container.
 *
 * This function is only called once to start and mount the crostini
 * container.  When FilesApp starts, the related fake root entry for
 * crostini is shown which uses this CrostiniMounter as its ContentScanner.
 *
 * When the sshfs mount completes, it will show up as a disk volume.
 * `refreshNavigationRootsReducer` will detect that crostini
 * is mounted as a disk volume and hide the fake root item while the
 * disk volume exists.
 */
class CrostiniMounter extends ContentScanner {
    async scan(_entriesCallback, successCallback, errorCallback, _invalidateCache = false) {
        chrome.fileManagerPrivate.mountCrostini(() => {
            if (chrome.runtime.lastError) {
                console.warn(`Cannot mount Crostini volume: ${chrome.runtime.lastError.message}`);
                errorCallback(createDOMError(CROSTINI_CONNECT_ERR, chrome.runtime.lastError.message));
                return;
            }
            successCallback();
        });
    }
}
/**
 * Shows an empty list and spinner whilst starting and mounting a Guest OS's
 * shared files.
 *
 * When FilesApp starts, the related placeholder root entry is shown which uses
 * this GuestOsMounter as its ContentScanner. When the mount succeeds it will
 * show up as a disk volume. `refreshNavigationRootsReducer` will
 * detect thew new volume and hide the placeholder root item while the disk
 * volume exists.
 */
class GuestOsMounter extends ContentScanner {
    /**
     * Creates a new GuestOSMounter. The `guest_id` is the id for the
     * GuestOsMountProvider to use
     */
    constructor(guest_id_) {
        super();
        this.guest_id_ = guest_id_;
    }
    async scan(_entriesCallback, successCallback, errorCallback, _invalidateCache = false) {
        try {
            await mountGuest(this.guest_id_);
            successCallback();
        }
        catch (error) {
            errorCallback(createDOMError(
            // TODO(crbug/1293229): Strings
            CROSTINI_CONNECT_ERR, JSON.stringify(error)));
        }
    }
}
/**
 * Read all the Trash directories for content.
 */
class TrashContentScanner extends ContentScanner {
    /**
     * volumeManager Identifies the underlying filesystem.
     */
    constructor(volumeManager) {
        super();
        this.readers_ = createTrashReaders(volumeManager);
    }
    /**
     * Scan all the trash directories for content.
     */
    async scan(entriesCallback, successCallback, errorCallback, _invalidateCache = false) {
        const readEntries = (idx) => {
            if (idx >= this.readers_.length) {
                // All Trash directories have been read.
                successCallback();
                return;
            }
            this.readers_[idx].readEntries(entries => {
                if (this.canceled_) {
                    errorCallback(createDOMError(FileErrorToDomError.ABORT_ERR));
                    return;
                }
                entriesCallback(entries);
                readEntries(idx + 1);
            }, errorCallback);
        };
        readEntries(0);
        return;
    }
}
/**
 * Top-level Android folders which are visible by default.
 */
const DEFAULT_ANDROID_FOLDERS = ['Documents', 'Movies', 'Music', 'Pictures'];
/**
 * Windows files or folders to hide by default.
 */
const WINDOWS_HIDDEN = ['$RECYCLE.BIN'];
/**
 * This class manages filters and determines a file should be shown or not.
 * When filters are changed, a 'changed' event is fired.
 */
class FileFilter extends NativeEventTarget {
    constructor(volumeManager_) {
        super();
        this.volumeManager_ = volumeManager_;
        this.filters_ = new Map();
        /**
         * Setup initial filters.
         */
        this.setupInitialFilters_();
    }
    setupInitialFilters_() {
        this.setHiddenFilesVisible(false);
        this.setAllAndroidFoldersVisible(false);
        this.hideAndroidDownload();
    }
    /**
     * Registers the given filter with the given name.
     */
    addFilter(name, filterFn) {
        this.filters_.set(name, filterFn);
        dispatchSimpleEvent(this, 'changed');
    }
    /**
     * @param name Filter identifier.
     */
    removeFilter(name) {
        this.filters_.delete(name);
        dispatchSimpleEvent(this, 'changed');
    }
    /**
     * Show/Hide hidden files (i.e. files starting with '.', or other system files
     * for Windows files). Passing `true` as the `visible` parameters means the
     * hidden files should be visible to the user.
     */
    setHiddenFilesVisible(visible) {
        if (!visible) {
            this.addFilter('hidden', (entry) => {
                if (entry.name.startsWith('.')) {
                    return false;
                }
                // Hide folders under .Trash, but we don't want to hide anything showing
                // in "Trash", hence the `!isTrashEntry` check because all entries
                // showing under "Trash" will be TrashEntry.
                const insideTrash = TRASH_CONFIG.map(t => t.trashDir)
                    .some(dir => entry.fullPath.startsWith(dir));
                if (insideTrash && !isTrashEntry$1(entry)) {
                    return false;
                }
                // Only hide WINDOWS_HIDDEN in downloads:/PvmDefault.
                if (entry.fullPath.startsWith('/PvmDefault/') &&
                    WINDOWS_HIDDEN.includes(entry.name)) {
                    const info = this.volumeManager_.getLocationInfo(entry);
                    if (info && info.rootType === RootType.DOWNLOADS) {
                        return false;
                    }
                }
                return true;
            });
        }
        else {
            this.removeFilter('hidden');
        }
    }
    /**
     * Returns whether or not hidden files are visible to the user now.
     */
    isHiddenFilesVisible() {
        return !this.filters_.has('hidden');
    }
    /**
     * Show/Hide uncommon Android folders.
     * @param visible True if uncommon folders should be visible to the
     *     user.
     */
    setAllAndroidFoldersVisible(visible) {
        if (!visible) {
            this.addFilter('android_hidden', (entry) => {
                if (entry.filesystem && entry.filesystem.name !== 'android_files') {
                    return true;
                }
                // Hide top-level folder or sub-folders that should be hidden.
                if (entry.fullPath) {
                    const components = entry.fullPath.split('/');
                    if (components[1] &&
                        DEFAULT_ANDROID_FOLDERS.indexOf(components[1]) === -1) {
                        return false;
                    }
                }
                return true;
            });
        }
        else {
            this.removeFilter('android_hidden');
        }
    }
    /**
     * @return True if uncommon folders is visible to the user now.
     */
    isAllAndroidFoldersVisible() {
        return !this.filters_.has('android_hidden');
    }
    /**
     * Sets up a filter to hide /Download directory in 'Play files' volume.
     *
     * "Play files/Download" is an alias to Chrome OS's Downloads volume. It is
     * convenient in Android file picker, but can be confusing in Chrome OS Files
     * app. This function adds a filter to hide the Android's /Download.
     */
    hideAndroidDownload() {
        this.addFilter('android_download', (entry) => {
            if (entry.filesystem && entry.filesystem.name === 'android_files' &&
                entry.fullPath === '/Download') {
                return false;
            }
            return true;
        });
    }
    /**
     * @param entry File entry.
     * @return True if the file should be shown, false otherwise.
     */
    filter(entry) {
        for (const p of this.filters_.values()) {
            if (!p(entry)) {
                return false;
            }
        }
        return true;
    }
}
/**
 * A context of DirectoryContents.
 * TODO(yoshiki): remove this. crbug.com/224869.
 */
class FileListContext {
    constructor(fileFilter, metadataModel, volumeManager) {
        this.fileFilter = fileFilter;
        this.metadataModel = metadataModel;
        this.volumeManager = volumeManager;
        this.fileList = new FileListModel(metadataModel);
        this.prefetchPropertyNames = Array.from(new Set([
            ...LIST_CONTAINER_METADATA_PREFETCH_PROPERTY_NAMES,
            ...ACTIONS_MODEL_METADATA_PREFETCH_PROPERTY_NAMES,
            ...FILE_SELECTION_METADATA_PREFETCH_PROPERTY_NAMES,
            ...DLP_METADATA_PREFETCH_PROPERTY_NAMES,
        ]));
    }
}
/**
 * This class is responsible for scanning directory (or search results), and
 * filling the fileList. Different descendants handle various types of directory
 * contents shown: basic directory, drive search results, local search results.
 */
class DirectoryContents extends FilesEventTarget {
    /**
     * @param context The file list context.
     * @param isSearch True for search directory contents, otherwise false.
     * @param directoryEntry The entry of the current directory.
     * @param scannerFactory The factory to create ContentScanner instance.
     */
    constructor(context_, isSearch_, directoryEntry_, fileKey_, scannerFactory_) {
        super();
        this.context_ = context_;
        this.isSearch_ = isSearch_;
        this.directoryEntry_ = directoryEntry_;
        this.fileKey_ = fileKey_;
        this.scannerFactory_ = scannerFactory_;
        this.scanner_ = null;
        this.processNewEntriesQueue_ = new AsyncQueue();
        this.scanCanceled_ = false;
        /**
         * Metadata snapshot which is used to know which file is actually changed.
         */
        this.metadataSnapshot_ = null;
        this.fileList_ = this.context_.fileList;
        this.fileList_.initNewDirContents(this.context_.volumeManager);
    }
    /**
     * Create the copy of the object, but without scan started.
     * @return Object copy.
     */
    clone() {
        return new DirectoryContents(this.context_, this.isSearch_, this.directoryEntry_, this.fileKey_, this.scannerFactory_);
    }
    /**
     * Returns the file list length.
     */
    getFileListLength() {
        return this.fileList_.length;
    }
    /**
     * Use a given fileList instead of the fileList from the context.
     * @param fileList The new file list.
     */
    setFileList(fileList) {
        this.fileList_ = fileList;
    }
    /**
     * Creates snapshot of metadata in the directory. Returns Metadata snapshot
     * of current directory contents.
     */
    createMetadataSnapshot() {
        const snapshot = new Map();
        const entries = this.fileList_.slice();
        const metadata = this.context_.metadataModel.getCache(entries, ['modificationTime']);
        for (const [i, entry] of entries.entries()) {
            snapshot.set(entry.toURL(), metadata[i]);
        }
        return snapshot;
    }
    /**
     * Sets metadata snapshot which is used to check changed files.
     * @param metadataSnapshot A metadata snapshot.
     */
    setMetadataSnapshot(metadataSnapshot) {
        this.metadataSnapshot_ = metadataSnapshot;
    }
    /**
     * Use the filelist from the context and replace its contents with the entries
     * from the current fileList. If metadata snapshot is set, this method checks
     * actually updated files and dispatch change events by calling updateIndexes.
     */
    replaceContextFileList() {
        if (this.context_.fileList === this.fileList_) {
            return;
        }
        // TODO(yawano): While we should update the list with adding or deleting
        // what actually added and deleted instead of deleting and adding all
        // items, splice of array data model is expensive since it always runs
        // sort and we replace the list in this way to reduce the number of splice
        // calls.
        const spliceArgs = this.fileList_.slice();
        const fileList = this.context_.fileList;
        fileList.splice(0, fileList.length, ...spliceArgs);
        this.fileList_ = fileList;
        // Check updated files and dispatch change events.
        if (!this.metadataSnapshot_) {
            return;
        }
        const updatedIndexes = [];
        const entries = this.fileList_.slice();
        const freshMetadata = this.context_.metadataModel.getCache(entries, ['modificationTime']);
        for (let i = 0; i < entries.length; i++) {
            const url = entries[i].toURL();
            const entryMetadata = freshMetadata[i];
            // If the Files app fails to obtain both old and new modificationTime,
            // regard the entry as not updated.
            const storedMetadata = this.metadataSnapshot_.get(url);
            if (entryMetadata?.modificationTime?.getTime() !==
                storedMetadata?.modificationTime?.getTime()) {
                updatedIndexes.push(i);
            }
        }
        if (updatedIndexes.length > 0) {
            this.fileList_.updateIndexes(updatedIndexes);
        }
    }
    /**
     * @return If the scan is active.
     */
    isScanning() {
        return this.scanner_ !== null || this.processNewEntriesQueue_.isRunning();
    }
    /**
     * @return True if search results (drive or local).
     */
    isSearch() {
        return this.isSearch_;
    }
    /**
     * @return A DirectoryEntry for
     *     current directory. In case of search -- the top directory from which
     *     search is run.
     */
    getDirectoryEntry() {
        return this.directoryEntry_;
    }
    getFileKey() {
        return this.fileKey_;
    }
    /**
     * Start directory scan/search operation. Either 'dir-contents-scan-completed'
     * or 'dir-contents-scan-failed' event will be fired upon completion.
     *
     * @param refresh True to refresh metadata, or false to use cached one.
     * @param invalidateCache True to invalidate the backend scanning result
     *     cache. This param only works if the corresponding backend scanning
     *     supports cache.
     */
    scan(refresh, invalidateCache) {
        /**
         * Invoked when the scanning is completed successfully.
         */
        const completionCallback = () => {
            this.onScanFinished_();
            this.onScanCompleted_();
        };
        /**
         * Invoked when the scanning is finished but is not completed due to error.
         */
        const errorCallback = (error) => {
            this.onScanFinished_();
            this.onScanError_(error);
        };
        // TODO(hidehiko,mtomasz): this scan method must be
        // called at most once. Remove such a limitation.
        this.scanner_ = this.scannerFactory_();
        this.scanner_.scan(this.onNewEntries_.bind(this, refresh, this.scanner_.isStoreBased()), completionCallback, errorCallback, invalidateCache);
    }
    /**
     * Adds/removes/updates items of file list.
     * @param updatedEntries Entries of updated/added files.
     * @param removedUrls URLs of removed files.
     */
    update(updatedEntries, removedUrls) {
        const removedSet = new Set();
        for (const url of removedUrls) {
            removedSet.add(url);
        }
        const updatedMap = new Map();
        for (const entry of updatedEntries) {
            updatedMap.set(entry.toURL(), entry);
        }
        const updatedList = [];
        const updatedIndexes = [];
        for (let i = 0; i < this.fileList_.length; i++) {
            const url = this.fileList_.item(i).toURL();
            if (removedSet.has(url)) {
                // Find the maximum range in which all items need to be removed.
                const begin = i;
                let end = i + 1;
                while (end < this.fileList_.length &&
                    removedSet.has(this.fileList_.item(end)?.toURL() || '')) {
                    end++;
                }
                // Remove the range [begin, end) at once to avoid multiple sorting.
                this.fileList_.splice(begin, end - begin);
                i--;
                continue;
            }
            const updatedEntry = updatedMap.get(url);
            if (updatedEntry) {
                updatedList.push(updatedEntry);
                updatedIndexes.push(i);
                updatedMap.delete(url);
            }
        }
        if (updatedIndexes.length > 0) {
            this.fileList_.updateIndexes(updatedIndexes);
        }
        const addedList = [];
        for (const updatedEntry of updatedMap.values()) {
            addedList.push(updatedEntry);
        }
        if (removedUrls.length > 0) {
            this.context_.metadataModel.notifyEntriesRemoved(removedUrls);
        }
        this.prefetchMetadata(updatedList, true, () => {
            this.onNewEntries_(true, false, addedList);
            this.onScanFinished_();
            this.onScanCompleted_();
        });
    }
    /**
     * Cancels the running scan.
     */
    cancelScan() {
        if (this.scanCanceled_) {
            return;
        }
        this.scanCanceled_ = true;
        if (this.scanner_) {
            this.scanner_.cancel();
        }
        this.onScanFinished_();
        this.processNewEntriesQueue_.cancel();
        this.dispatchEvent(new CustomEvent('dir-contents-scan-canceled'));
    }
    /**
     * Called when the scanning by scanner_ is done, even when the scanning is
     * succeeded or failed. This is called before completion (or error) callback.
     *
     */
    onScanFinished_() {
        this.scanner_ = null;
    }
    /**
     * Called when the scanning by scanner_ is succeeded.
     */
    onScanCompleted_() {
        if (this.scanCanceled_) {
            return;
        }
        this.processNewEntriesQueue_.run(callback => {
            // Call callback first, so isScanning() returns false in the event
            // handlers.
            callback();
            this.dispatchEvent(new CustomEvent('dir-contents-scan-completed'));
        });
    }
    /**
     * Called in case scan has failed. Should send the event.
     * @param error error.
     */
    onScanError_(error) {
        if (this.scanCanceled_) {
            return;
        }
        this.processNewEntriesQueue_.run(callback => {
            // Call callback first, so isScanning() returns false in the event
            // handlers.
            callback();
            this.dispatchEvent(new CustomEvent('dir-contents-scan-failed', { detail: { error } }));
        });
    }
    /**
     * Called when some chunk of entries are read by scanner.
     *
     * @param refresh True to refresh metadata, or false to use cached one.
     * @param storeBased Whether the scan for `entries` was done in the store.
     * @param entries The list of the scanned entries.
     */
    onNewEntries_(refresh, storeBased, entries) {
        if (this.scanCanceled_) {
            return;
        }
        if (entries.length === 0) {
            return;
        }
        this.processNewEntriesQueue_.run(callbackOuter => {
            const finish = () => {
                if (!this.scanCanceled_) {
                    // From new entries remove all entries that are rejected by the
                    // filters or are already present in the current file list.
                    const currentURLs = new Set();
                    for (let i = 0; i < this.fileList_.length; ++i) {
                        currentURLs.add(this.fileList_.item(i).toURL());
                    }
                    const entriesFiltered = entries.filter((e) => this.context_.fileFilter.filter(e) &&
                        !(currentURLs.has(e.toURL())));
                    // Update the filelist without waiting the metadata.
                    this.fileList_.push.apply(this.fileList_, entriesFiltered);
                    const event = new CustomEvent('dir-contents-scan-updated', {
                        detail: {
                            isStoreBased: storeBased,
                        },
                    });
                    this.dispatchEvent(event);
                }
                callbackOuter();
            };
            // Because the prefetchMetadata can be slow, throttling by splitting
            // entries into smaller chunks to reduce UI latency.
            // TODO(hidehiko,mtomasz): This should be handled in MetadataCache.
            const MAX_CHUNK_SIZE = 25;
            const prefetchMetadataQueue = new ConcurrentQueue(4);
            for (let i = 0; i < entries.length; i += MAX_CHUNK_SIZE) {
                if (prefetchMetadataQueue.isCanceled()) {
                    break;
                }
                const chunk = entries.slice(i, i + MAX_CHUNK_SIZE);
                prefetchMetadataQueue.run(((chunk, callbackInner) => {
                    this.prefetchMetadata(chunk, refresh, () => {
                        if (!prefetchMetadataQueue.isCanceled()) {
                            if (this.scanCanceled_) {
                                prefetchMetadataQueue.cancel();
                            }
                        }
                        // Checks if this is the last task.
                        if (prefetchMetadataQueue.getWaitingTasksCount() === 0 &&
                            prefetchMetadataQueue.getRunningTasksCount() === 1) {
                            // |callbackOuter| in |finish| must be called before
                            // |callbackInner|, to prevent double-calling.
                            finish();
                        }
                        callbackInner();
                    });
                }).bind(null, chunk));
            }
        });
    }
    prefetchMetadata(entries, refresh, callback) {
        if (refresh) {
            this.context_.metadataModel.notifyEntriesChanged(entries);
        }
        this.context_.metadataModel
            .get(entries, this.context_.prefetchPropertyNames)
            .then(callback);
    }
}
/**
 * Scan entries using the Store and ActionsProducer to talk to the backend and
 * propagate the state.
 *
 * This adapts the Store to the existing ContentScanner architecture.
 */
class StoreScanner extends ContentScanner {
    constructor(fileKey_) {
        super();
        this.fileKey_ = fileKey_;
        this.store_ = getStore();
    }
    onDirectoryContentUpdated_(dirContent) {
        if (!dirContent) {
            return;
        }
        if (!(this.entriesCallback_ && this.errorCallback_ &&
            this.successCallbcak_)) {
            return;
        }
        if (dirContent.status === PropStatus.ERROR) {
            // TODO(lucmult): Figure out the DOMError here.
            this.errorCallback_({});
            this.finalize_();
            return;
        }
        if (dirContent.status === PropStatus.STARTED &&
            dirContent.keys.length > 0) {
            const entries = this.getEntries_(dirContent.keys);
            this.entriesCallback_(entries);
            return;
        }
        if (dirContent.status === PropStatus.SUCCESS) {
            const entries = this.getEntries_(dirContent.keys);
            this.entriesCallback_(entries);
            this.successCallbcak_();
            this.finalize_();
            return;
        }
    }
    getEntries_(keys) {
        const state = this.store_.getState();
        const entries = [];
        for (const k of keys) {
            const entry = getFileData(state, k)?.entry;
            if (!entry) {
                debug(`Failed to find entry for ${k}`);
                continue;
            }
            entries.push(entry);
        }
        return entries;
    }
    async scan(entriesCallback, successCallback, errorCallback, _invalidateCache = false) {
        this.entriesCallback_ = entriesCallback;
        this.errorCallback_ = errorCallback;
        this.successCallbcak_ = successCallback;
        // Start listening to the store.
        this.unsubscribe_ = directoryContentSelector.subscribe(this.onDirectoryContentUpdated_.bind(this));
        // Dispatch action to scan in the store.
        this.store_.dispatch(fetchDirectoryContents(this.fileKey_));
    }
    cancel() {
        super.cancel();
        this.finalize_();
    }
    finalize_() {
        // Usubscribe from the store.
        if (this.unsubscribe_) {
            this.unsubscribe_();
        }
        this.unsubscribe_ = undefined;
        this.successCallbcak_ = undefined;
        this.errorCallback_ = undefined;
        this.entriesCallback_ = undefined;
    }
    isStoreBased() {
        return true;
    }
}

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/** Watches for changes in the tracked directory. */
class FileWatcher extends FilesEventTarget {
    constructor() {
        super();
        this.queue_ = new AsyncQueue();
        this.watchedDirectoryEntry_ = null;
        this.onDirectoryChangedBound_ = this.onDirectoryChanged_.bind(this);
        chrome.fileManagerPrivate.onDirectoryChanged.addListener(this.onDirectoryChangedBound_);
    }
    /**
     * Stops watching (must be called before page unload).
     */
    dispose() {
        chrome.fileManagerPrivate.onDirectoryChanged.removeListener(this.onDirectoryChangedBound_);
        if (this.watchedDirectoryEntry_) {
            this.resetWatchedEntry();
        }
    }
    /**
     * Called when a file in the watched directory is changed.
     * @param event Change event.
     */
    onDirectoryChanged_(event) {
        const fireWatcherDirectoryChanged = (changedFiles) => {
            const eventDetails = changedFiles ? { changedFiles } : {};
            const e = new CustomEvent('watcher-directory-changed', { detail: eventDetails });
            this.dispatchEvent(e);
        };
        if (this.watchedDirectoryEntry_) {
            const eventURL = event.entry.toURL();
            const watchedDirURL = this.watchedDirectoryEntry_.toURL();
            if (eventURL === watchedDirURL) {
                fireWatcherDirectoryChanged(event.changedFiles);
            }
            else if (watchedDirURL.startsWith(eventURL)) {
                // When watched directory is deleted by the change in parent directory,
                // notify it as watcher directory changed.
                this.watchedDirectoryEntry_.getDirectory(this.watchedDirectoryEntry_.fullPath, { create: false }, undefined, () => {
                    fireWatcherDirectoryChanged(undefined);
                });
            }
        }
    }
    /**
     * Changes the watched directory. In case of a fake entry, the watch is
     * just released, since there is no reason to track a fake directory.
     *
     * @param entry Directory entry to be tracked, or the fake entry.
     */
    changeWatchedDirectory(entry) {
        if (!isFakeEntry(entry)) {
            return this.changeWatchedEntry_(unwrapEntry(entry));
        }
        else {
            return this.resetWatchedEntry();
        }
    }
    /**
     * Resets the watched entry. It's a best effort method.
     */
    resetWatchedEntry() {
        // Run the tasks in the queue to avoid races.
        return new Promise((fulfill) => {
            this.queue_.run(callback => {
                // Release the watched directory.
                if (this.watchedDirectoryEntry_) {
                    chrome.fileManagerPrivate.removeFileWatch(this.watchedDirectoryEntry_, (_result) => {
                        if (chrome.runtime.lastError) {
                            console.warn(`Cannot remove watcher for (redacted): ${chrome.runtime.lastError.message}`);
                            console.info(`Cannot remove watcher for '${this.watchedDirectoryEntry_?.toURL()}': ${chrome.runtime.lastError.message}`);
                        }
                        // Even on error reset the watcher locally, so at least the
                        // notifications are discarded.
                        this.watchedDirectoryEntry_ = null;
                        fulfill();
                        callback();
                    });
                }
                else {
                    fulfill();
                    callback();
                }
            });
        });
    }
    /**
     * Sets the watched entry to the passed directory. It's a best effort method.
     * @param entry Directory to be watched.
     */
    changeWatchedEntry_(entry) {
        return new Promise((fulfill) => {
            const setEntryClosure = () => {
                // Run the tasks in the queue to avoid races.
                this.queue_.run(callback => {
                    chrome.fileManagerPrivate.addFileWatch(entry, (_result) => {
                        if (chrome.runtime.lastError) {
                            // Most probably setting the watcher is not supported on the
                            // file system type.
                            console.info(`Cannot add watcher for '${entry.toURL()}': ${chrome.runtime.lastError.message}`);
                            this.watchedDirectoryEntry_ = null;
                            fulfill();
                        }
                        else {
                            assert$1(entry);
                            this.watchedDirectoryEntry_ = entry;
                            fulfill();
                        }
                        callback();
                    });
                });
            };
            // Reset the watched directory first, then set the new watched directory.
            return this.resetWatchedEntry().then(setEntryClosure);
        });
    }
    /**
     * @return Current watched directory entry.
     */
    getWatchedDirectoryEntry() {
        return this.watchedDirectoryEntry_;
    }
}

// Copyright 2012 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * Creates a new selection model that is to be used with lists. This only
 * allows a single index to be selected.
 */
class ListSingleSelectionModel extends NativeEventTarget {
    /**
     * @param length The number items in the selection.
     */
    constructor(length) {
        super();
        // True if any item could be lead or anchor. False if only selected ones.
        this.independentLeadItem_ = false;
        this.leadIndex_ = -1;
        this.selectedIndex_ = -1;
        this.selectedIndexBefore_ = -1;
        this.changeCount_ = null;
        this.length_ = length ?? 0;
    }
    /**
     * The number of items in the model.
     */
    get length() {
        return this.length_;
    }
    /**
     *   The selected indexes.
     */
    get selectedIndexes() {
        const i = this.selectedIndex;
        return i !== -1 ? [this.selectedIndex] : [];
    }
    set selectedIndexes(indexes) {
        this.selectedIndex_ = indexes.length ? indexes[0] : -1;
    }
    /**
     * Convenience getter which returns the first selected index.
     * Setter also changes lead and anchor indexes if value is nonegative.
     */
    get selectedIndex() {
        return this.selectedIndex_;
    }
    set selectedIndex(selectedIndex) {
        const oldSelectedIndex = this.selectedIndex;
        const i = Math.max(-1, Math.min(this.length_ - 1, selectedIndex));
        if (i !== oldSelectedIndex) {
            this.beginChange();
            this.selectedIndex_ = i;
            this.leadIndex = i >= 0 ? i : this.leadIndex;
            this.endChange();
        }
    }
    /**
     * Selects a range of indexes, starting with {@code start} and ends with
     * {@code end}.
     * @param start The first index to select.
     * @param end The last index to select.
     */
    selectRange(start, end) {
        // Only select first index.
        this.selectedIndex = Math.min(start, end);
    }
    /**
     * Selects all indexes.
     */
    selectAll() {
        // Select all is not allowed on a single selection model
    }
    /**
     * Clears the selection
     */
    clear() {
        this.beginChange();
        this.length_ = 0;
        this.selectedIndex = this.anchorIndex = this.leadIndex = -1;
        this.endChange();
    }
    /**
     * Unselects all selected items.
     */
    unselectAll() {
        this.selectedIndex = -1;
    }
    /**
     * Sets the selected state for an index.
     * @param index The index to set the selected state for.
     * @param b Whether to select the index or not.
     */
    setIndexSelected(index, b) {
        // Only allow selection
        const oldSelected = index === this.selectedIndex_;
        if (oldSelected === b) {
            return;
        }
        if (b) {
            this.selectedIndex = index;
        }
        else if (index === this.selectedIndex_) {
            this.selectedIndex = -1;
        }
    }
    /**
     * Whether a given index is selected or not.
     * @param index The index to check.
     * @return Whether an index is selected.
     */
    getIndexSelected(index) {
        return index === this.selectedIndex_;
    }
    /**
     * This is used to begin batching changes. Call {@code endChange} when you
     * are done making changes.
     */
    beginChange() {
        if (!this.changeCount_) {
            this.changeCount_ = 0;
            this.selectedIndexBefore_ = this.selectedIndex_;
        }
        this.changeCount_++;
    }
    /**
     * Call this after changes are done and it will dispatch a change event if
     * any changes were actually done.
     */
    endChange() {
        this.changeCount_--;
        if (!this.changeCount_) {
            if (this.selectedIndexBefore_ !== this.selectedIndex_) {
                const indexes = [this.selectedIndexBefore_, this.selectedIndex_];
                this.dispatchEvent(new CustomEvent('change', {
                    detail: {
                        changes: indexes.filter(index => index !== -1)
                            .map((index) => ({
                            index: index,
                            selected: index === this.selectedIndex_,
                        })),
                    },
                }));
            }
        }
    }
    /**
     * The leadIndex is used with multiple selection and it is the index that
     * the user is moving using the arrow keys.
     */
    get leadIndex() {
        return this.leadIndex_;
    }
    set leadIndex(leadIndex) {
        const li = this.adjustIndex_(leadIndex);
        if (li !== this.leadIndex_) {
            const oldLeadIndex = this.leadIndex_;
            this.leadIndex_ = li;
            dispatchPropertyChange(this, 'leadIndex', li, oldLeadIndex);
            dispatchPropertyChange(this, 'anchorIndex', li, oldLeadIndex);
        }
    }
    adjustIndex_(index) {
        index = Math.max(-1, Math.min(this.length_ - 1, index));
        if (!this.independentLeadItem_) {
            index = this.selectedIndex;
        }
        return index;
    }
    /**
     * The anchorIndex is used with multiple selection.
     */
    get anchorIndex() {
        return this.leadIndex;
    }
    set anchorIndex(anchorIndex) {
        this.leadIndex = anchorIndex;
    }
    /**
     * Whether the selection model supports multiple selected items.
     */
    get multiple() {
        return false;
    }
    /**
     * Adjusts the selection after reordering of items in the table.
     * @param permutation The reordering permutation.
     */
    adjustToReordering(permutation) {
        if (this.leadIndex !== -1) {
            this.leadIndex = permutation[this.leadIndex];
        }
        const oldSelectedIndex = this.selectedIndex;
        if (oldSelectedIndex !== -1) {
            this.selectedIndex = permutation[oldSelectedIndex];
        }
    }
    /**
     * Adjusts selection model length.
     * @param length New selection model length.
     */
    adjustLength(length) {
        this.length_ = length;
    }
}

// Copyright 2015 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class FileListSelectionModel extends ListSelectionModel {
    /** @param length The number items in the selection. */
    constructor(length) {
        super(length);
        this.isCheckSelectMode_ = false;
        /**
         * Overwrite ListSelectionModel to allow lead item to be independent of the
         * current selected item(s).
         */
        this.independentLeadItem = true;
        this.addEventListener('change', this.onChangeEvent_.bind(this));
    }
    /**
     * Updates the check-select mode.
     * @param enabled True if check-select mode should be enabled.
     */
    setCheckSelectMode(enabled) {
        this.isCheckSelectMode_ = enabled;
    }
    selectAll() {
        super.selectAll();
        // Force change event when selecting all but with only 1 item, to update the
        // UI with select mode.
        if (this.isCheckSelectMode_ && this.selectedIndexes.length === 1) {
            const e = new CustomEvent('change', { detail: { changes: [] } });
            this.dispatchEvent(e);
            // If force lead index when there is no lead, because doesn't make sense
            // to not have lead when there is selection.
            if (this.leadIndex < 0) {
                this.leadIndex = this.selectedIndexes[0];
            }
        }
    }
    /**
     * Gets the check-select mode.
     * @return True if check-select mode is enabled.
     */
    getCheckSelectMode() {
        return this.isCheckSelectMode_;
    }
    /**
     * Changes to single-select mode if all selected files get deleted.
     */
    adjustToReordering(permutation) {
        // Look at the old state.
        const oldSelectedItemsCount = this.selectedIndexes.length;
        const newSelectedItemsCount = this.selectedIndexes.filter(i => permutation[i] !== -1).length;
        // Call the superclass function.
        super.adjustToReordering(permutation);
        // Leave check-select mode if all items have been deleted.
        if (oldSelectedItemsCount && !newSelectedItemsCount && this.length) {
            this.isCheckSelectMode_ = false;
        }
    }
    /**
     * Handles change event to update isCheckSelectMode_ BEFORE the change event
     * is dispatched to other listeners.
     * @param event Event object of 'change' event.
     */
    onChangeEvent_(_event) {
        // When the number of selected item is not one, update the check-select
        // mode. When the number of selected item is one, the mode depends on the
        // last keyboard/mouse operation. In this case, the mode is controlled from
        // outside. See filelist.handlePointerDownUp and filelist.handleKeyDown.
        const selectedIndexes = this.selectedIndexes;
        if (selectedIndexes.length === 0) {
            this.isCheckSelectMode_ = false;
        }
        else if (selectedIndexes.length >= 2) {
            this.isCheckSelectMode_ = true;
        }
    }
}
class FileListSingleSelectionModel extends ListSingleSelectionModel {
    constructor() {
        super(...arguments);
        this.independentLeadItem = false;
    }
    /**
     * Updates the check-select mode.
     * @param enabled True if check-select mode should be enabled.
     */
    setCheckSelectMode(_enabled) {
        // Do nothing, as check-select mode is invalid in single selection model.
    }
    /**
     * Gets the check-select mode.
     * @return True if check-select mode is enabled.
     */
    getCheckSelectMode() {
        return false;
    }
}

// Copyright 2012 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
// If directory files changes too often, don't rescan directory more than once
// per specified interval
const SIMULTANEOUS_RESCAN_INTERVAL = 500;
// Used for operations that require almost instant rescan.
const SHORT_RESCAN_INTERVAL = 100;
/**
 * Helper function that can decide if the scan of the given entry should be
 * performed by recent scanner or other (search) scanner. In transition period
 * between V1 and V2 versions of search, when the user searches in Recent, and
 * uses Recent as location, we reuse the Recent scanner. Otherwise, the true
 * search scanner is used.
 */
function isRecentScan(entry, options) {
    if (isRecentRootType(getRootType(entry))) {
        // Potential search in Recents. However, if options are present and are
        // indicating that the user wishes to scan current entry, still use Recent
        // scanner.
        if (!options || options.location === SearchLocation.THIS_FOLDER) {
            return true;
        }
    }
    return false;
}
/**
 * Helper function that determines the category of files we are looking for
 * based on the fake entry, query and options.
 */
function getFileCategory(entry, query, options) {
    if (query) {
        if (options) {
            return options.fileCategory;
        }
    }
    return entry.fileCategory;
}
/**
 * Data model for the current directory for Files app.
 *
 * It encapsulates the current directory, the file selection, directory scanner,
 * etc.
 */
class DirectoryModel extends FilesEventTarget {
    /**
     * @param singleSelection True if only one file could be selected at the time.
     */
    constructor(singleSelection, fileFilter_, metadataModel_, volumeManager_) {
        super();
        this.fileFilter_ = fileFilter_;
        this.metadataModel_ = metadataModel_;
        this.volumeManager_ = volumeManager_;
        this.runningScan_ = null;
        this.pendingScan_ = null;
        this.pendingRescan_ = null;
        this.rescanTime_ = null;
        this.changeDirectorySequence_ = 0;
        this.cachedSearch_ = {};
        this.scanFailures_ = 0;
        this.onSearchCompleted_ = null;
        this.ignoreCurrentDirectoryDeletion_ = false;
        this.directoryChangeQueue_ = new AsyncQueue();
        /**
         * Number of running directory change trackers.
         */
        this.numChangeTrackerRunning_ = 0;
        this.rescanAggregator_ = new Aggregator(this.rescanSoon.bind(this, true), 500);
        this.fileWatcher_ = new FileWatcher();
        this.lastSearchQuery_ = '';
        this.volumes_ = null;
        this.fileListSelection_ = singleSelection ?
            new FileListSingleSelectionModel() :
            new FileListSelectionModel();
        this.fileFilter_.addEventListener('changed', this.onFilterChanged_.bind(this));
        this.currentFileListContext_ = new FileListContext(this.fileFilter_, this.metadataModel_, this.volumeManager_);
        this.currentDirContents_ = new DirectoryContents(this.currentFileListContext_, false, undefined, undefined, () => {
            return new DirectoryContentScanner(undefined);
        });
        /**
         * Empty file list which is used as a dummy for inactive view of file list.
         */
        this.emptyFileList_ = new FileListModel(this.metadataModel_);
        this.volumeManager_.volumeInfoList.addEventListener('splice', this.onVolumeInfoListUpdated_.bind(this));
        this.fileWatcher_.addEventListener('watcher-directory-changed', this.onWatcherDirectoryChanged_.bind(this));
        // For non-watchable directories (e.g. FakeEntry) and volumes (MTP) we need
        // to subscribe to the IOTask and manually refresh.
        chrome.fileManagerPrivate.onIOTaskProgressStatus.addListener(this.updateFileListAfterIoTask_.bind(this));
        this.store_ = getStore();
        this.store_.subscribe(this);
    }
    onStateChanged(state) {
        this.handleDirectoryState_(state);
        this.handleSearchState_(state);
    }
    /**
     * Handles the current directory slice of the store's state.
     * @param state latest state from the store.
     */
    handleDirectoryState_(state) {
        const currentURL = this.getCurrentFileKey();
        const newURL = state.currentDirectory ? state.currentDirectory.key : null;
        // Observe volume changes.
        if (this.volumes_ !== state.volumes) {
            this.onStateVolumeChanged_(state);
            this.volumes_ = state.volumes;
        }
        // If the directory is the same or the newURL is null, ignore it.
        if (currentURL === newURL || !newURL) {
            return;
        }
        // When something changed the current directory status to STARTED, Here we
        // initiate the actual change and will update to SUCCESS at the end.
        if (state.currentDirectory?.status === PropStatus.STARTED) {
            const fileData = getFileData(state, newURL);
            const entry = fileData?.entry;
            if (!entry) {
                // TODO(lucmult): Fix potential race condition in this await/then.
                urlToEntry(newURL)
                    .then((entry) => {
                    if (!entry) {
                        throw new Error(`Failed to find the new directory key ${newURL}`);
                    }
                    // Initiate the directory change.
                    this.changeDirectoryEntry(entry);
                })
                    .catch((error) => {
                    console.warn(error);
                    this.store_.dispatch(changeDirectory({ toKey: newURL, status: PropStatus.ERROR }));
                });
                return;
            }
            // Initiate the directory change.
            this.changeDirectoryEntry(entry);
        }
    }
    /**
     * Reacts to changes in the search state of the store. If the search changed
     * and the query is not empty, this method triggers a new directory search.
     */
    handleSearchState_(state) {
        const currentEntry = this.getCurrentDirEntry();
        // Do not handle any search state until we have the current directory set.
        // Requests to handle current search state may be triggered by the files app
        // before it is fully started.
        if (!currentEntry) {
            return;
        }
        const search = state.search;
        if (this.cachedSearch_ === search) {
            // Bail out early if the search part of the state has not changed.
            return;
        }
        // Cache the last received search state for future comparisons.
        const lastSearch = this.cachedSearch_;
        this.cachedSearch_ = search;
        // We change the search state (STARTED, SUCCESS, etc.) so only trigger
        // a new search if the query or the options have changed.
        if (!search) {
            return;
        }
        if (!lastSearch || lastSearch.query !== search.query ||
            lastSearch.options !== search.options) {
            this.search_(search.query || '', search.options || getDefaultSearchOptions());
        }
    }
    /**
     * Disposes the directory model by removing file watchers.
     */
    dispose() {
        this.fileWatcher_.dispose();
    }
    /**
     * @return Files in the current directory.
     */
    getFileList() {
        return this.currentFileListContext_.fileList;
    }
    /**
     * @return File list which is always empty.
     */
    getEmptyFileList() {
        return this.emptyFileList_;
    }
    /**
     * @return Selection in the fileList.
     */
    getFileListSelection() {
        return this.fileListSelection_;
    }
    /**
     * Obtains current volume information.
     */
    getCurrentVolumeInfo() {
        const entry = this.getCurrentDirEntry();
        if (!entry) {
            return null;
        }
        return this.volumeManager_.getVolumeInfo(entry);
    }
    /**
     * @return Root type of current root, or null if not found.
     */
    getCurrentRootType() {
        const entry = this.currentDirContents_.getDirectoryEntry();
        if (!entry) {
            return null;
        }
        const locationInfo = this.volumeManager_.getLocationInfo(entry);
        if (!locationInfo) {
            return null;
        }
        return locationInfo.rootType;
    }
    /**
     * Metadata property names that are expected to be Prefetched.
     */
    getPrefetchPropertyNames() {
        return this.currentFileListContext_.prefetchPropertyNames;
    }
    /**
     * @return True if the current directory is read only. If there is no entry
     *     set, then returns true.
     */
    isReadOnly() {
        const currentDirEntry = this.getCurrentDirEntry();
        if (currentDirEntry) {
            const locationInfo = this.volumeManager_.getLocationInfo(currentDirEntry);
            if (locationInfo) {
                return locationInfo.isReadOnly;
            }
        }
        return true;
    }
    /**
     * @return True if the a scan is active.
     */
    isScanning() {
        return this.currentDirContents_.isScanning();
    }
    /**
     * @return True if search is in progress.
     */
    isSearching() {
        return this.currentDirContents_.isSearch();
    }
    /**
     * @return True if it's on Drive.
     */
    isOnDrive() {
        return this.isCurrentRootVolumeType_(VolumeType.DRIVE);
    }
    /**
     * @return True if it's on a Linux native volume.
     */
    isOnNative() {
        const rootType = this.getCurrentRootType();
        return rootType !== null && !isRecentRootType(rootType) &&
            isNative(getVolumeTypeFromRootType(rootType));
    }
    /**
     * @return True if the current volume is blocked by DLP.
     */
    isDlpBlocked() {
        if (!isDlpEnabled()) {
            return false;
        }
        const info = this.getCurrentVolumeInfo();
        return info ? this.volumeManager_.isDisabled(info.volumeType) : false;
    }
    /**
     * @param volumeType Volume Type
     * @return True if current root volume type is equal to specified volume type.
     */
    isCurrentRootVolumeType_(volumeType) {
        const rootType = this.getCurrentRootType();
        return rootType !== null && !isRecentRootType(rootType) &&
            getVolumeTypeFromRootType(rootType) === volumeType;
    }
    /**
     * Updates the selection by using the updateFunc and publish the change event.
     * If updateFunc returns true, it force to dispatch the change event even if
     * the selection index is not changed.
     *
     * @param selection Selection to be updated.
     * @param updateFunc Function updating the selection.
     */
    updateSelectionAndPublishEvent_(selection, updateFunc) {
        // Begin change.
        selection.beginChange();
        // If dispatchNeeded is true, we should ensure the change event is
        // dispatched.
        let dispatchNeeded = updateFunc();
        // Check if the change event is dispatched in the endChange function
        // or not.
        const eventDispatched = () => {
            dispatchNeeded = false;
        };
        selection.addEventListener('change', eventDispatched);
        selection.endChange();
        selection.removeEventListener('change', eventDispatched);
        // If the change event have been already dispatched, dispatchNeeded is
        // false.
        if (dispatchNeeded) {
            // The selection status (selected or not) is not changed because
            // this event is caused by the change of selected item.
            const event = new CustomEvent('change', { detail: { changes: [] } });
            selection.dispatchEvent(event);
        }
    }
    /**
     * Sets to ignore current directory deletion. This method is used to prevent
     * going up to the volume root with the deletion of current directory by
     * rename operation in directory tree.
     * @param value True to ignore current directory deletion.
     */
    setIgnoringCurrentDirectoryDeletion(value) {
        this.ignoreCurrentDirectoryDeletion_ = value;
    }
    /**
     * Invoked when a change in the directory is detected by the watcher.
     * @param event Event object.
     */
    onWatcherDirectoryChanged_(event) {
        const directoryEntry = this.getCurrentDirEntry();
        if (!this.ignoreCurrentDirectoryDeletion_ && directoryEntry) {
            // If the change is deletion of currentDir, move up to its parent
            // directory.
            directoryEntry.getDirectory(directoryEntry.fullPath, { create: false }, () => { }, async () => {
                assert$1(directoryEntry);
                const volumeInfo = this.volumeManager_.getVolumeInfo(directoryEntry);
                if (volumeInfo) {
                    const displayRoot = await volumeInfo.resolveDisplayRoot();
                    this.changeDirectoryEntry(displayRoot);
                }
            });
        }
        if (event.detail?.changedFiles) {
            const addedOrUpdatedFileUrls = [];
            let deletedFileUrls = [];
            event.detail.changedFiles.forEach(change => {
                if (change.changes.length === 1 && change.changes[0] === 'delete') {
                    deletedFileUrls.push(change.url);
                }
                else {
                    addedOrUpdatedFileUrls.push(change.url);
                }
            });
            convertURLsToEntries(addedOrUpdatedFileUrls)
                .then(result => {
                deletedFileUrls = deletedFileUrls.concat(result.failureUrls);
                // Passing the resolved entries and failed URLs as the removed
                // files. The URLs are removed files and they chan't be resolved.
                this.partialUpdate_(result.entries, deletedFileUrls);
            })
                .catch(error => {
                console.warn('Error in proceeding the changed event.', error, 'Fallback to force-refresh');
                this.rescanAggregator_.run();
            });
        }
        else {
            // Invokes force refresh if the detailed information isn't provided.
            // This can occur very frequently (e.g. when copying files into Downloads)
            // and rescan is heavy operation, so we keep some interval for each
            // rescan.
            this.rescanAggregator_.run();
        }
    }
    /**
     * Invoked when filters are changed.
     */
    async onFilterChanged_() {
        const currentDirectory = this.getCurrentDirEntry();
        if (currentDirectory && isNativeEntry(currentDirectory) &&
            !this.fileFilter_.filter(currentDirectory)) {
            // If the current directory should be hidden in the new filter setting,
            // change the current directory to the current volume's root.
            const volumeInfo = this.volumeManager_.getVolumeInfo(currentDirectory);
            if (volumeInfo) {
                const displayRoot = await volumeInfo.resolveDisplayRoot();
                this.changeDirectoryEntry(displayRoot);
            }
        }
        else {
            this.rescanSoon(false);
        }
    }
    /**
     * Invoked when volumes have been modified in the state.
     * @param state latest state from the store.
     */
    onStateVolumeChanged_(state) {
        if (!state.currentDirectory) {
            return;
        }
        for (const volume of Object.values(state.volumes)) {
            // Navigate out of ODFS if it got disabled and the current directory is
            // under ODFS.
            const isOdfs = isOneDriveId(volume.providerId);
            if (!(isOdfs && volume.isDisabled)) {
                continue;
            }
            const currentDirectoryFileData = getFileData(state, state.currentDirectory.key);
            const currentDirectoryOnOdfs = isOneDriveId(getVolume(state, currentDirectoryFileData)?.providerId);
            if (currentDirectoryOnOdfs) {
                const tracker = this.createDirectoryChangeTracker();
                tracker.start();
                // Normally the default root is MyFiles, however with SkyVault, this
                // is the volume in the Cloud (OneDrive or GoogleDrive).
                this.volumeManager_.getDefaultDisplayRoot().then((displayRoot) => {
                    if (displayRoot && !tracker.hasChanged) {
                        this.changeDirectoryEntry(displayRoot);
                    }
                });
                tracker.stop();
            }
        }
    }
    getFileFilter() {
        return this.fileFilter_;
    }
    getCurrentDirEntry() {
        return this.currentDirContents_.getDirectoryEntry();
    }
    getCurrentDirName() {
        const fileData = this.getCurrentFileData();
        if (fileData) {
            return fileData.label;
        }
        const dirEntry = this.getCurrentDirEntry();
        if (!dirEntry) {
            return '';
        }
        const locationInfo = this.volumeManager_.getLocationInfo(dirEntry);
        return getEntryLabel(locationInfo, dirEntry);
    }
    getCurrentFileKey() {
        return this.currentDirContents_.getFileKey();
    }
    getCurrentFileData() {
        const fileKey = this.getCurrentFileKey();
        if (!fileKey) {
            return;
        }
        return getFileData(this.store_.getState(), fileKey) ?? undefined;
    }
    /**
     * @return Array of selected entries.
     */
    getSelectedEntries_() {
        const indexes = this.fileListSelection_.selectedIndexes;
        const fileList = this.getFileList();
        if (fileList) {
            return indexes.map(i => fileList.item(i));
        }
        return [];
    }
    /**
     * @param value List of selected entries.
     */
    setSelectedEntries_(value) {
        const indexes = [];
        const fileList = this.getFileList();
        const urls = entriesToURLs(value);
        for (let i = 0; i < fileList.length; i++) {
            if (urls.indexOf(fileList.item(i).toURL()) !== -1) {
                indexes.push(i);
            }
        }
        this.fileListSelection_.selectedIndexes = indexes;
    }
    /**
     * @return Lead entry.
     */
    getLeadEntry_() {
        const index = this.fileListSelection_.leadIndex;
        return index >= 0 ? this.getFileList().item(index) : null;
    }
    /**
     * @param value The new lead entry.
     */
    setLeadEntry_(value) {
        const fileList = this.getFileList();
        for (let i = 0; i < fileList.length; i++) {
            if (isSameEntry(fileList.item(i), value)) {
                this.fileListSelection_.leadIndex = i;
                return;
            }
        }
    }
    /**
     * Schedule rescan with short delay.
     * @param refresh True to refresh metadata, or false to use cached one.
     * @param invalidateCache True to invalidate the backend scanning result
     *     cache. This param only works if the corresponding backend scanning
     *     supports cache.
     */
    rescanSoon(refresh, invalidateCache = false) {
        this.scheduleRescan(SHORT_RESCAN_INTERVAL, refresh, invalidateCache);
    }
    /**
     * Schedule rescan with delay. Designed to handle directory change
     * notification.
     * @param refresh True to refresh metadata, or false to use cached one.
     * @param invalidateCache True to invalidate the backend scanning result
     *     cache. This param only works if the corresponding backend scanning
     *     supports cache.
     */
    rescanLater(refresh, invalidateCache = false) {
        this.scheduleRescan(SIMULTANEOUS_RESCAN_INTERVAL, refresh, invalidateCache);
    }
    /**
     * Schedule rescan with delay. If another rescan has been scheduled does
     * nothing. File operation may cause a few notifications what should cause
     * a single refresh.
     * @param delay Delay in ms after which the rescan will be performed.
     * @param refresh True to refresh metadata, or false to use cached one.
     * @param invalidateCache True to invalidate the backend scanning result
     *     cache. This param only works if the corresponding backend scanning
     *     supports cache.
     */
    scheduleRescan(delay, refresh, invalidateCache = false) {
        if (this.rescanTime_) {
            if (this.rescanTime_ <= Date.now() + delay) {
                return;
            }
            clearTimeout(this.rescanTimeoutId_);
        }
        const sequence = this.changeDirectorySequence_;
        this.rescanTime_ = Date.now() + delay;
        this.rescanTimeoutId_ = setTimeout(() => {
            this.rescanTimeoutId_ = undefined;
            if (sequence === this.changeDirectorySequence_) {
                this.rescan(refresh, invalidateCache);
            }
        }, delay);
    }
    /**
     * Cancel a rescan on timeout if it is scheduled.
     */
    clearRescanTimeout_() {
        this.rescanTime_ = null;
        if (this.rescanTimeoutId_) {
            clearTimeout(this.rescanTimeoutId_);
            this.rescanTimeoutId_ = undefined;
        }
    }
    /**
     * Rescan current directory. May be called indirectly through rescanLater or
     * directly in order to reflect user action. Will first cache all the
     * directory contents in an array, then seamlessly substitute the fileList
     * contents, preserving the select element etc.
     *
     * This should be to scan the contents of current directory (or search).
     *
     * @param refresh True to refresh metadata, or false to use cached one.
     * @param invalidateCache True to invalidate the backend scanning result
     *     cache. This param only works if the corresponding backend scanning
     *     supports cache.
     */
    rescan(refresh, invalidateCache = false) {
        this.clearRescanTimeout_();
        if (this.runningScan_) {
            this.pendingRescan_ = true;
            return;
        }
        const dirContents = this.currentDirContents_.clone();
        dirContents.setFileList(new FileListModel(this.metadataModel_));
        dirContents.setMetadataSnapshot(this.currentDirContents_.createMetadataSnapshot());
        const sequence = this.changeDirectorySequence_;
        const successCallback = () => {
            if (sequence === this.changeDirectorySequence_) {
                this.replaceDirectoryContents_(dirContents);
                this.dispatchEvent(new CustomEvent('cur-dir-rescan-completed'));
            }
        };
        this.scan_(dirContents, refresh, invalidateCache, successCallback, () => { }, () => { }, () => { });
    }
    /**
     * Run scan on the current DirectoryContents. The active fileList is cleared
     * and the entries are added directly.
     *
     * This should be used when changing directory or initiating a new search.
     *
     * @param newDirContents New DirectoryContents instance to replace
     *     `currentDirContents_`.
     * @param callback Callback with result. True if the scan is completed
     *     successfully, false if the scan is failed.
     */
    clearAndScan_(newDirContents, callback) {
        if (this.currentDirContents_.isScanning()) {
            this.currentDirContents_.cancelScan();
        }
        this.currentDirContents_ = newDirContents;
        this.clearRescanTimeout_();
        if (this.pendingScan_) {
            this.pendingScan_ = false;
        }
        if (this.runningScan_) {
            if (this.runningScan_.isScanning()) {
                this.runningScan_.cancelScan();
            }
            this.runningScan_ = null;
        }
        const sequence = this.changeDirectorySequence_;
        let cancelled = false;
        const onDone = () => {
            if (cancelled) {
                return;
            }
            this.dispatchEvent(new CustomEvent('cur-dir-scan-completed'));
            callback(true);
        };
        const onFailed = (error) => {
            if (cancelled) {
                return;
            }
            this.dispatchEvent(new CustomEvent('cur-dir-scan-failed', { detail: { error } }));
            callback(false);
        };
        const onUpdated = (event) => {
            if (cancelled) {
                return;
            }
            if (this.changeDirectorySequence_ !== sequence) {
                cancelled = true;
                this.dispatchEvent(new CustomEvent('cur-dir-scan-canceled'));
                callback(false);
                return;
            }
            const newEvent = new CustomEvent('cur-dir-scan-updated', {
                detail: {
                    isStoreBased: event.detail.isStoreBased,
                },
            });
            this.dispatchEvent(newEvent);
        };
        const onCancelled = () => {
            if (cancelled) {
                return;
            }
            cancelled = true;
            this.dispatchEvent(new CustomEvent('cur-dir-scan-canceled'));
            callback(false);
        };
        // Clear metadata information for the old (no longer visible) items in the
        // file list.
        const fileList = this.getFileList();
        const removedUrls = [];
        for (let i = 0; i < fileList.length; i++) {
            removedUrls.push(fileList.item(i).toURL());
        }
        this.metadataModel_.notifyEntriesRemoved(removedUrls);
        // Retrieve metadata information for the newly selected directory.
        const currentEntry = this.currentDirContents_.getDirectoryEntry();
        if (currentEntry) {
            const locationInfo = this.volumeManager_.getLocationInfo(currentEntry);
            // When bulk pinning is enabled, this call is made with more frequency in
            // the UI delegate as hosted documents receive the available offline tick
            // when they are both explicitly pinned and heuristically cached.
            if (locationInfo && locationInfo.isDriveBased &&
                !isDriveFsBulkPinningEnabled()) {
                chrome.fileManagerPrivate.pollDriveHostedFilePinStates();
            }
            if (!isFakeEntry(currentEntry)) {
                this.metadataModel_.get([currentEntry], [
                    ...LIST_CONTAINER_METADATA_PREFETCH_PROPERTY_NAMES,
                    ...DLP_METADATA_PREFETCH_PROPERTY_NAMES,
                ]);
            }
        }
        // Clear the table, and start scanning.
        fileList.splice(0, fileList.length);
        this.dispatchEvent(new CustomEvent('cur-dir-scan-started'));
        this.scan_(this.currentDirContents_, false, true, onDone, onFailed, onUpdated, onCancelled);
    }
    /**
     * Similar to clearAndScan_() but instead of passing a `newDirContents`, it
     * uses the `currentDirContents_`.
     */
    clearCurrentDirAndScan() {
        const sequence = ++this.changeDirectorySequence_;
        this.directoryChangeQueue_.run(callback => {
            if (this.changeDirectorySequence_ !== sequence) {
                callback();
                return;
            }
            const currentDirEntry = this.getCurrentDirEntry();
            assert$1(currentDirEntry);
            const newDirContents = this.createDirectoryContents_(this.currentFileListContext_, currentDirEntry, currentDirEntry.toURL(), this.lastSearchQuery_);
            this.clearAndScan_(newDirContents, callback);
        });
    }
    /**
     * Adds/removes/updates items of file list.
     * @param changedEntries Entries of updated/added files.
     * @param removedUrls URLs of removed files.
     */
    partialUpdate_(changedEntries, removedUrls) {
        // This update should be included in the current running update.
        if (this.pendingScan_) {
            return;
        }
        if (this.runningScan_) {
            // Do update after the current scan is finished.
            const previousScan = this.runningScan_;
            const onPreviousScanCompleted = () => {
                previousScan.removeEventListener('dir-contents-scan-completed', onPreviousScanCompleted);
                // Run the update asynchronously.
                Promise.resolve().then(() => {
                    this.partialUpdate_(changedEntries, removedUrls);
                });
            };
            previousScan.addEventListener('dir-contents-scan-completed', onPreviousScanCompleted);
            return;
        }
        const onFinish = () => {
            this.runningScan_ = null;
            this.currentDirContents_.removeEventListener('dir-contents-scan-completed', onCompleted);
            this.currentDirContents_.removeEventListener('dir-contents-scan-failed', onFailure);
            this.currentDirContents_.removeEventListener('dir-contents-scan-canceled', onCancelled);
        };
        const onCompleted = () => {
            onFinish();
            this.dispatchEvent(new CustomEvent('cur-dir-rescan-completed'));
        };
        const onFailure = () => {
            onFinish();
        };
        const onCancelled = () => {
            onFinish();
        };
        this.runningScan_ = this.currentDirContents_;
        this.currentDirContents_.addEventListener('dir-contents-scan-completed', onCompleted);
        this.currentDirContents_.addEventListener('dir-contents-scan-failed', onFailure);
        this.currentDirContents_.addEventListener('dir-contents-scan-canceled', onCancelled);
        this.currentDirContents_.update(changedEntries, removedUrls);
    }
    /**
     * Perform a directory contents scan. Should be called only from rescan() and
     * clearAndScan_().
     *
     * @param dirContents DirectoryContents instance on which the scan will be
     *     run.
     * @param refresh True to refresh metadata, or false to use cached one.
     * @param invalidateCache True to invalidate scanning result cache.
     * @param successCallback Callback on success.
     * @param failureCallback Callback on failure.
     * @param updatedCallback Callback on update. Only on the last update,
     *     `successCallback` is called instead of this.
     * @param cancelledCallback Callback on cancel.
     */
    scan_(dirContents, refresh, invalidateCache, successCallback, failureCallback, updatedCallback, cancelledCallback) {
        /**
         * Runs pending scan if there is one.
         * @return Did pending scan exist.
         */
        const maybeRunPendingRescan = () => {
            if (this.pendingRescan_) {
                this.rescanSoon(refresh);
                this.pendingRescan_ = false;
                return true;
            }
            return false;
        };
        const onFinished = () => {
            dirContents.removeEventListener('dir-contents-scan-completed', onSuccess);
            dirContents.removeEventListener('dir-