// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{a as assert}from"./shared.rollup.js";class ImageCache{db_=null;initialize(callback){const openRequest=indexedDB.open(DB_NAME,DB_VERSION);openRequest.onsuccess=()=>{this.db_=openRequest.result;callback()};openRequest.onerror=callback;openRequest.onupgradeneeded=()=>{console.info("Cache database creating or upgrading.");const db=openRequest.result;if(db.objectStoreNames.contains("metadata")){db.deleteObjectStore("metadata")}if(db.objectStoreNames.contains("data")){db.deleteObjectStore("data")}if(db.objectStoreNames.contains("settings")){db.deleteObjectStore("settings")}db.createObjectStore("metadata",{keyPath:"key"});db.createObjectStore("data",{keyPath:"key"});db.createObjectStore("settings",{keyPath:"key"})}}setCacheSize_(size,transaction){transaction=transaction||this.db_.transaction(["settings"],"readwrite");const settingsStore=transaction.objectStore("settings");settingsStore.put({key:"size",value:size})}fetchCacheSize_(onSuccess,onFailure,transaction){transaction=transaction||this.db_.transaction(["settings","metadata","data"],"readwrite");const settingsStore=transaction.objectStore("settings");const sizeRequest=settingsStore.get("size");sizeRequest.onsuccess=()=>{const result=sizeRequest.result;if(result){onSuccess(result.value)}else{onSuccess(0)}};sizeRequest.onerror=()=>{console.warn("Failed to fetch size from the database.");onFailure()}}evictCache_(size,onSuccess,onFailure,dbTransaction){const transaction=dbTransaction||this.db_.transaction(["settings","metadata","data"],"readwrite");if(size>MEMORY_LIMIT){onFailure();return}const onCacheSize=cacheSize=>{if(size<MEMORY_LIMIT-cacheSize){this.setCacheSize_(cacheSize+size,transaction);onSuccess();return}let bytesToEvict=Math.max(size,EVICTION_CHUNK_SIZE);const metadataEntries=[];const metadataStore=transaction.objectStore("metadata");const dataStore=transaction.objectStore("data");const onEntriesFetched=()=>{metadataEntries.sort(((a,b)=>b.lastLoadTimestamp-a.lastLoadTimestamp));let totalEvicted=0;while(bytesToEvict>0){const entry=metadataEntries.pop();totalEvicted+=entry.size;bytesToEvict-=entry.size;metadataStore.delete(entry.key);dataStore.delete(entry.key)}this.setCacheSize_(cacheSize-totalEvicted+size,transaction)};const cursor=metadataStore.openCursor();cursor.onsuccess=()=>{const result=cursor.result;if(result){metadataEntries.push(result.value);result.continue()}else{onEntriesFetched()}}};this.fetchCacheSize_(onCacheSize,onFailure,transaction)}saveImage(key,timestamp,width,height,ifd,data){if(!this.db_){console.warn("Cache database not available.");return}const onNotFoundInCache=()=>{const metadataEntry={key:key,timestamp:timestamp,width:width,height:height,ifd:ifd,size:data.length,lastLoadTimestamp:Date.now()};const dataEntry={key:key,data:data};const transaction=this.db_.transaction(["settings","metadata","data"],"readwrite");const metadataStore=transaction.objectStore("metadata");const dataStore=transaction.objectStore("data");const onCacheEvicted=()=>{metadataStore.put(metadataEntry);dataStore.put(dataEntry)};this.evictCache_(data.length,onCacheEvicted,(()=>{}),transaction)};this.loadImage(key,timestamp,(()=>{}),onNotFoundInCache)}loadImage(key,timestamp,onSuccess,onFailure){if(!this.db_){console.warn("Cache database not available.");onFailure();return}const transaction=this.db_.transaction(["settings","metadata","data"],"readwrite");const metadataStore=transaction.objectStore("metadata");const dataStore=transaction.objectStore("data");const metadataRequest=metadataStore.get(key);const dataRequest=dataStore.get(key);let metadataEntry=null;let metadataReceived=false;let dataEntry=null;let dataReceived=false;const onPartialSuccess=()=>{if(!metadataReceived||!dataReceived){return}if(!!metadataEntry!==!!dataEntry){console.warn("Inconsistent cache database.");onFailure();return}if(!metadataEntry){onFailure()}else if(metadataEntry.timestamp!==timestamp){this.removeImage(key,(()=>{}),(()=>{}),transaction);onFailure()}else{metadataEntry.lastLoadTimestamp=Date.now();metadataStore.put(metadataEntry);onSuccess(metadataEntry.width,metadataEntry.height,metadataEntry.ifd,dataEntry.data)}};metadataRequest.onsuccess=()=>{if(metadataRequest.result){metadataEntry=metadataRequest.result}metadataReceived=true;onPartialSuccess()};dataRequest.onsuccess=()=>{if(dataRequest.result){dataEntry=dataRequest.result}dataReceived=true;onPartialSuccess()};metadataRequest.onerror=()=>{console.warn("Failed to fetch metadata from the database.");metadataReceived=true;onPartialSuccess()};dataRequest.onerror=()=>{console.warn("Failed to fetch image data from the database.");dataReceived=true;onPartialSuccess()}}removeImage(key,onSuccess,onFailure,transaction){if(!this.db_){console.warn("Cache database not available.");return}transaction=transaction||this.db_.transaction(["settings","metadata","data"],"readwrite");const metadataStore=transaction.objectStore("metadata");const dataStore=transaction.objectStore("data");let cacheSize=null;let cacheSizeReceived=false;let metadataEntry=null;let metadataReceived=false;const onPartialSuccess=()=>{if(!cacheSizeReceived||!metadataReceived){return}if(cacheSize===null||!metadataEntry){if(onFailure){onFailure()}return}if(onSuccess){onSuccess()}this.setCacheSize_(cacheSize-metadataEntry.size,transaction);metadataStore.delete(key);dataStore.delete(key)};const onCacheSizeFailure=()=>{cacheSizeReceived=true};const onCacheSizeSuccess=result=>{cacheSize=result;cacheSizeReceived=true;onPartialSuccess()};this.fetchCacheSize_(onCacheSizeSuccess,onCacheSizeFailure,transaction);const metadataRequest=metadataStore.get(key);metadataRequest.onsuccess=()=>{if(metadataRequest.result){metadataEntry=metadataRequest.result}metadataReceived=true;onPartialSuccess()};metadataRequest.onerror=()=>{console.warn("Failed to remove an image.");metadataReceived=true;onPartialSuccess()}}}const DB_NAME="image-loader";const DB_VERSION=16;const MEMORY_LIMIT=250*1024*1024;const EVICTION_CHUNK_SIZE=50*1024*1024;class ImageOrientation{a;b;c;d;constructor(a,b,c,d){this.a=a;this.b=b;this.c=c;this.d=d}static fromExifOrientation(orientation){switch(~~orientation){case 1:return new ImageOrientation(1,0,0,1);case 2:return new ImageOrientation(-1,0,0,1);case 3:return new ImageOrientation(-1,0,0,-1);case 4:return new ImageOrientation(1,0,0,-1);case 5:return new ImageOrientation(0,1,1,0);case 6:return new ImageOrientation(0,1,-1,0);case 7:return new ImageOrientation(0,-1,-1,0);case 8:return new ImageOrientation(0,-1,1,0);default:console.error(`Invalid orientation number: ${orientation}`);return new ImageOrientation(1,0,0,1)}}static fromClockwiseRotation(rotation90){switch(~~(rotation90%4)){case 0:return new ImageOrientation(1,0,0,1);case 1:case-3:return new ImageOrientation(0,1,-1,0);case 2:case-2:return new ImageOrientation(-1,0,0,-1);case 3:case-1:return new ImageOrientation(0,-1,1,0);default:console.error(`Invalid rotation number: ${rotation90}`);return new ImageOrientation(1,0,0,1)}}static fromRotationAndScale(transform){const scaleX=transform.scaleX;const scaleY=transform.scaleY;const rotate90=transform.rotate90;const orientation=ImageOrientation.fromClockwiseRotation(rotate90);return new ImageOrientation(orientation.a*scaleX,orientation.b*scaleX,orientation.c*scaleY,orientation.d*scaleY)}getSizeAfterCancelling(imageWidth,imageHeight){const projectedX=this.a*imageWidth+this.c*imageHeight;const projectedY=this.b*imageWidth+this.d*imageHeight;return{width:Math.abs(projectedX),height:Math.abs(projectedY)}}cancelImageOrientation(context,imageWidth,imageHeight){const projectedX=this.a*imageWidth+this.c*imageHeight;const projectedY=this.b*imageWidth+this.d*imageHeight;const offsetX=projectedX<0?-projectedX:0;const offsetY=projectedY<0?-projectedY:0;context.setTransform(this.a,this.b,this.c,this.d,offsetX,offsetY)}isIdentity(){return this.a===1&&this.b===0&&this.c===0&&this.d===1}}function isImageOrientation(orientation){return!!orientation&&"a"in orientation&&"b"in orientation&&"c"in orientation&&"d"in orientation}const EXTENSION_TO_TYPE=new Map([[".jpeg",{extensions:[".jpeg",".jpg",".jfif",".pjpeg",".pjp"],mime:"image/jpeg",subtype:"JPEG",translationKey:"IMAGE_FILE_TYPE",type:"image"}],[".jpg",{extensions:[".jpeg",".jpg",".jfif",".pjpeg",".pjp"],mime:"image/jpeg",subtype:"JPEG",translationKey:"IMAGE_FILE_TYPE",type:"image"}],[".jfif",{extensions:[".jpeg",".jpg",".jfif",".pjpeg",".pjp"],mime:"image/jpeg",subtype:"JPEG",translationKey:"IMAGE_FILE_TYPE",type:"image"}],[".pjpeg",{extensions:[".jpeg",".jpg",".jfif",".pjpeg",".pjp"],mime:"image/jpeg",subtype:"JPEG",translationKey:"IMAGE_FILE_TYPE",type:"image"}],[".pjp",{extensions:[".jpeg",".jpg",".jfif",".pjpeg",".pjp"],mime:"image/jpeg",subtype:"JPEG",translationKey:"IMAGE_FILE_TYPE",type:"image"}],[".bmp",{extensions:[".bmp"],mime:"image/bmp",subtype:"BMP",translationKey:"IMAGE_FILE_TYPE",type:"image"}],[".gif",{extensions:[".gif"],mime:"image/gif",subtype:"GIF",translationKey:"IMAGE_FILE_TYPE",type:"image"}],[".ico",{extensions:[".ico"],mime:"image/x-icon",subtype:"ICO",translationKey:"IMAGE_FILE_TYPE",type:"image"}],[".png",{extensions:[".png"],mime:"image/png",subtype:"PNG",translationKey:"IMAGE_FILE_TYPE",type:"image"}],[".webp",{extensions:[".webp"],mime:"image/webp",subtype:"WebP",translationKey:"IMAGE_FILE_TYPE",type:"image"}],[".tif",{extensions:[".tif",".tiff"],mime:"image/tiff",subtype:"TIFF",translationKey:"IMAGE_FILE_TYPE",type:"image"}],[".tiff",{extensions:[".tif",".tiff"],mime:"image/tiff",subtype:"TIFF",translationKey:"IMAGE_FILE_TYPE",type:"image"}],[".svg",{extensions:[".svg",".svgz"],mime:"image/svg+xml",subtype:"SVG",translationKey:"IMAGE_FILE_TYPE",type:"image"}],[".svgz",{extensions:[".svg",".svgz"],mime:"image/svg+xml",subtype:"SVG",translationKey:"IMAGE_FILE_TYPE",type:"image"}],[".avif",{extensions:[".avif"],mime:"image/avif",subtype:"AVIF",translationKey:"IMAGE_FILE_TYPE",type:"image"}],[".jxl",{extensions:[".jxl"],mime:"image/jxl",subtype:"JXL",translationKey:"IMAGE_FILE_TYPE",type:"image"}],[".xbm",{extensions:[".xbm"],mime:"image/x-xbitmap",subtype:"XBM",translationKey:"IMAGE_FILE_TYPE",type:"image"}],[".arw",{extensions:[".arw"],icon:"image",mime:"image/x-sony-arw",subtype:"ARW",translationKey:"IMAGE_FILE_TYPE",type:"raw"}],[".cr2",{extensions:[".cr2"],icon:"image",mime:"image/x-canon-cr2",subtype:"CR2",translationKey:"IMAGE_FILE_TYPE",type:"raw"}],[".dng",{extensions:[".dng"],icon:"image",mime:"image/x-adobe-dng",subtype:"DNG",translationKey:"IMAGE_FILE_TYPE",type:"raw"}],[".nef",{extensions:[".nef"],icon:"image",mime:"image/x-nikon-nef",subtype:"NEF",translationKey:"IMAGE_FILE_TYPE",type:"raw"}],[".nrw",{extensions:[".nrw"],icon:"image",mime:"image/x-nikon-nrw",subtype:"NRW",translationKey:"IMAGE_FILE_TYPE",type:"raw"}],[".orf",{extensions:[".orf"],icon:"image",mime:"image/x-olympus-orf",subtype:"ORF",translationKey:"IMAGE_FILE_TYPE",type:"raw"}],[".raf",{extensions:[".raf"],icon:"image",mime:"image/x-fuji-raf",subtype:"RAF",translationKey:"IMAGE_FILE_TYPE",type:"raw"}],[".rw2",{extensions:[".rw2"],icon:"image",mime:"image/x-panasonic-rw2",subtype:"RW2",translationKey:"IMAGE_FILE_TYPE",type:"raw"}],[".3gp",{extensions:[".3gp",".3gpp"],mime:"video/3gpp",subtype:"3GP",translationKey:"VIDEO_FILE_TYPE",type:"video"}],[".3gpp",{extensions:[".3gp",".3gpp"],mime:"video/3gpp",subtype:"3GP",translationKey:"VIDEO_FILE_TYPE",type:"video"}],[".avi",{extensions:[".avi"],mime:"video/x-msvideo",subtype:"AVI",translationKey:"VIDEO_FILE_TYPE",type:"video"}],[".mov",{extensions:[".mov"],mime:"video/quicktime",subtype:"QuickTime",translationKey:"VIDEO_FILE_TYPE",type:"video"}],[".mkv",{extensions:[".mkv"],mime:"video/x-matroska",subtype:"MKV",translationKey:"VIDEO_FILE_TYPE",type:"video"}],[".mp4",{extensions:[".mp4",".m4v",".mpg4",".mpeg4"],mime:"video/mp4",subtype:"MPEG",translationKey:"VIDEO_FILE_TYPE",type:"video"}],[".m4v",{extensions:[".mp4",".m4v",".mpg4",".mpeg4"],mime:"video/mp4",subtype:"MPEG",translationKey:"VIDEO_FILE_TYPE",type:"video"}],[".mpg4",{extensions:[".mp4",".m4v",".mpg4",".mpeg4"],mime:"video/mp4",subtype:"MPEG",translationKey:"VIDEO_FILE_TYPE",type:"video"}],[".mpeg4",{extensions:[".mp4",".m4v",".mpg4",".mpeg4"],mime:"video/mp4",subtype:"MPEG",translationKey:"VIDEO_FILE_TYPE",type:"video"}],[".mpg",{extensions:[".mpg",".mpeg"],mime:"video/mpeg",subtype:"MPEG",translationKey:"VIDEO_FILE_TYPE",type:"video"}],[".mpeg",{extensions:[".mpg",".mpeg"],mime:"video/mpeg",subtype:"MPEG",translationKey:"VIDEO_FILE_TYPE",type:"video"}],[".ogm",{extensions:[".ogm",".ogv",".ogx"],mime:"video/ogg",subtype:"OGG",translationKey:"VIDEO_FILE_TYPE",type:"video"}],[".ogv",{extensions:[".ogm",".ogv",".ogx"],mime:"video/ogg",subtype:"OGG",translationKey:"VIDEO_FILE_TYPE",type:"video"}],[".ogx",{extensions:[".ogm",".ogv",".ogx"],mime:"video/ogg",subtype:"OGG",translationKey:"VIDEO_FILE_TYPE",type:"video"}],[".webm",{extensions:[".webm"],mime:"video/webm",subtype:"WebM",translationKey:"VIDEO_FILE_TYPE",type:"video"}],[".amr",{extensions:[".amr"],mime:"audio/amr",subtype:"AMR",translationKey:"AUDIO_FILE_TYPE",type:"audio"}],[".flac",{extensions:[".flac"],mime:"audio/flac",subtype:"FLAC",translationKey:"AUDIO_FILE_TYPE",type:"audio"}],[".mp3",{extensions:[".mp3"],mime:"audio/mpeg",subtype:"MP3",translationKey:"AUDIO_FILE_TYPE",type:"audio"}],[".m4a",{extensions:[".m4a"],mime:"audio/mp4a-latm",subtype:"MPEG",translationKey:"AUDIO_FILE_TYPE",type:"audio"}],[".oga",{extensions:[".oga",".ogg",".opus"],mime:"audio/ogg",subtype:"OGG",translationKey:"AUDIO_FILE_TYPE",type:"audio"}],[".ogg",{extensions:[".oga",".ogg",".opus"],mime:"audio/ogg",subtype:"OGG",translationKey:"AUDIO_FILE_TYPE",type:"audio"}],[".opus",{extensions:[".oga",".ogg",".opus"],mime:"audio/ogg",subtype:"OGG",translationKey:"AUDIO_FILE_TYPE",type:"audio"}],[".wav",{extensions:[".wav"],mime:"audio/x-wav",subtype:"WAV",translationKey:"AUDIO_FILE_TYPE",type:"audio"}],[".weba",{extensions:[".weba"],mime:"audio/webm",subtype:"WEBA",translationKey:"AUDIO_FILE_TYPE",type:"audio"}],[".txt",{extensions:[".txt",".text"],mime:"text/plain",subtype:"TXT",translationKey:"PLAIN_TEXT_FILE_TYPE",type:"text"}],[".text",{extensions:[".txt",".text"],mime:"text/plain",subtype:"TXT",translationKey:"PLAIN_TEXT_FILE_TYPE",type:"text"}],[".csv",{extensions:[".csv"],mime:"text/csv",subtype:"CSV",translationKey:"CSV_TEXT_FILE_TYPE",type:"text"}],[".zip",{extensions:[".zip"],mime:"application/zip",subtype:"ZIP",translationKey:"ARCHIVE_FILE_TYPE",type:"archive"}],[".rar",{extensions:[".rar"],mime:"application/x-rar-compressed",subtype:"RAR",translationKey:"ARCHIVE_FILE_TYPE",type:"archive"}],[".iso",{extensions:[".iso"],mime:"application/x-iso9660-image",subtype:"ISO",translationKey:"ARCHIVE_FILE_TYPE",type:"archive"}],[".7z",{extensions:[".7z"],mime:"application/x-7z-compressed",subtype:"7-Zip",translationKey:"ARCHIVE_FILE_TYPE",type:"archive"}],[".crx",{extensions:[".crx"],mime:"application/x-chrome-extension",subtype:"CRX",translationKey:"ARCHIVE_FILE_TYPE",type:"archive"}],[".tar",{extensions:[".tar"],mime:"application/x-tar",subtype:"TAR",translationKey:"ARCHIVE_FILE_TYPE",type:"archive"}],[".bz2",{extensions:[".bz2",".bz",".tbz",".tbz2",".tz2",".tb2"],mime:"application/x-bzip2",subtype:"BZIP2",translationKey:"ARCHIVE_FILE_TYPE",type:"archive"}],[".bz",{extensions:[".bz2",".bz",".tbz",".tbz2",".tz2",".tb2"],mime:"application/x-bzip2",subtype:"BZIP2",translationKey:"ARCHIVE_FILE_TYPE",type:"archive"}],[".tbz",{extensions:[".bz2",".bz",".tbz",".tbz2",".tz2",".tb2"],mime:"application/x-bzip2",subtype:"BZIP2",translationKey:"ARCHIVE_FILE_TYPE",type:"archive"}],[".tbz2",{extensions:[".bz2",".bz",".tbz",".tbz2",".tz2",".tb2"],mime:"application/x-bzip2",subtype:"BZIP2",translationKey:"ARCHIVE_FILE_TYPE",type:"archive"}],[".tz2",{extensions:[".bz2",".bz",".tbz",".tbz2",".tz2",".tb2"],mime:"application/x-bzip2",subtype:"BZIP2",translationKey:"ARCHIVE_FILE_TYPE",type:"archive"}],[".tb2",{extensions:[".bz2",".bz",".tbz",".tbz2",".tz2",".tb2"],mime:"application/x-bzip2",subtype:"BZIP2",translationKey:"ARCHIVE_FILE_TYPE",type:"archive"}],[".gz",{extensions:[".gz",".tgz"],mime:"application/x-gzip",subtype:"GZIP",translationKey:"ARCHIVE_FILE_TYPE",type:"archive"}],[".tgz",{extensions:[".gz",".tgz"],mime:"application/x-gzip",subtype:"GZIP",translationKey:"ARCHIVE_FILE_TYPE",type:"archive"}],[".lz",{extensions:[".lz"],mime:"application/x-lzip",subtype:"LZIP",translationKey:"ARCHIVE_FILE_TYPE",type:"archive"}],[".lzo",{extensions:[".lzo"],mime:"application/x-lzop",subtype:"LZOP",translationKey:"ARCHIVE_FILE_TYPE",type:"archive"}],[".lzma",{extensions:[".lzma",".tlzma",".tlz"],mime:"application/x-lzma",subtype:"LZMA",translationKey:"ARCHIVE_FILE_TYPE",type:"archive"}],[".tlzma",{extensions:[".lzma",".tlzma",".tlz"],mime:"application/x-lzma",subtype:"LZMA",translationKey:"ARCHIVE_FILE_TYPE",type:"archive"}],[".tlz",{extensions:[".lzma",".tlzma",".tlz"],mime:"application/x-lzma",subtype:"LZMA",translationKey:"ARCHIVE_FILE_TYPE",type:"archive"}],[".xz",{extensions:[".xz",".txz"],mime:"application/x-xz",subtype:"XZ",translationKey:"ARCHIVE_FILE_TYPE",type:"archive"}],[".txz",{extensions:[".xz",".txz"],mime:"application/x-xz",subtype:"XZ",translationKey:"ARCHIVE_FILE_TYPE",type:"archive"}],[".z",{extensions:[".z",".taz",".tz"],mime:"application/x-compress",subtype:"Z",translationKey:"ARCHIVE_FILE_TYPE",type:"archive"}],[".taz",{extensions:[".z",".taz",".tz"],mime:"application/x-compress",subtype:"Z",translationKey:"ARCHIVE_FILE_TYPE",type:"archive"}],[".tz",{extensions:[".z",".taz",".tz"],mime:"application/x-compress",subtype:"Z",translationKey:"ARCHIVE_FILE_TYPE",type:"archive"}],[".zst",{extensions:[".zst",".tzst"],mime:"application/zstd",subtype:"Zstandard",translationKey:"ARCHIVE_FILE_TYPE",type:"archive"}],[".tzst",{extensions:[".zst",".tzst"],mime:"application/zstd",subtype:"Zstandard",translationKey:"ARCHIVE_FILE_TYPE",type:"archive"}],[".gdoc",{extensions:[".gdoc"],icon:"gdoc",mime:"application/vnd.google-apps.document",subtype:"doc",translationKey:"GDOC_DOCUMENT_FILE_TYPE",type:"hosted"}],[".gsheet",{extensions:[".gsheet"],icon:"gsheet",mime:"application/vnd.google-apps.spreadsheet",subtype:"sheet",translationKey:"GSHEET_DOCUMENT_FILE_TYPE",type:"hosted"}],[".gslides",{extensions:[".gslides"],icon:"gslides",mime:"application/vnd.google-apps.presentation",subtype:"slides",translationKey:"GSLIDES_DOCUMENT_FILE_TYPE",type:"hosted"}],[".gdraw",{extensions:[".gdraw"],icon:"gdraw",mime:"application/vnd.google-apps.drawing",subtype:"draw",translationKey:"GDRAW_DOCUMENT_FILE_TYPE",type:"hosted"}],[".gtable",{extensions:[".gtable"],icon:"gtable",mime:"application/vnd.google-apps.fusiontable",subtype:"table",translationKey:"GTABLE_DOCUMENT_FILE_TYPE",type:"hosted"}],[".glink",{extensions:[".glink"],icon:"glink",mime:"application/vnd.google-apps.shortcut",subtype:"glink",translationKey:"GLINK_DOCUMENT_FILE_TYPE",type:"hosted"}],[".gform",{extensions:[".gform"],icon:"gform",mime:"application/vnd.google-apps.form",subtype:"form",translationKey:"GFORM_DOCUMENT_FILE_TYPE",type:"hosted"}],[".gmap",{extensions:[".gmap"],icon:"gmap",mime:"application/vnd.google-apps.map",subtype:"map",translationKey:"GMAP_DOCUMENT_FILE_TYPE",type:"hosted"}],[".gsite",{extensions:[".gsite"],icon:"gsite",mime:"application/vnd.google-apps.site",subtype:"site",translationKey:"GSITE_DOCUMENT_FILE_TYPE",type:"hosted"}],[".gmaillayout",{extensions:[".gmaillayout"],icon:"gmaillayout",mime:"application/vnd.google-apps.mail-layout",subtype:"emaillayouts",translationKey:"EMAIL_LAYOUTS_DOCUMENT_FILE_TYPE",type:"hosted"}],[".pdf",{extensions:[".pdf"],icon:"pdf",mime:"application/pdf",subtype:"PDF",translationKey:"PDF_DOCUMENT_FILE_TYPE",type:"document"}],[".htm",{extensions:[".htm",".html",".mht",".mhtml",".shtml",".xht",".xhtml"],mime:"text/html",subtype:"HTML",translationKey:"HTML_DOCUMENT_FILE_TYPE",type:"document"}],[".html",{extensions:[".htm",".html",".mht",".mhtml",".shtml",".xht",".xhtml"],mime:"text/html",subtype:"HTML",translationKey:"HTML_DOCUMENT_FILE_TYPE",type:"document"}],[".mht",{extensions:[".htm",".html",".mht",".mhtml",".shtml",".xht",".xhtml"],mime:"text/html",subtype:"HTML",translationKey:"HTML_DOCUMENT_FILE_TYPE",type:"document"}],[".mhtml",{extensions:[".htm",".html",".mht",".mhtml",".shtml",".xht",".xhtml"],mime:"text/html",subtype:"HTML",translationKey:"HTML_DOCUMENT_FILE_TYPE",type:"document"}],[".shtml",{extensions:[".htm",".html",".mht",".mhtml",".shtml",".xht",".xhtml"],mime:"text/html",subtype:"HTML",translationKey:"HTML_DOCUMENT_FILE_TYPE",type:"document"}],[".xht",{extensions:[".htm",".html",".mht",".mhtml",".shtml",".xht",".xhtml"],mime:"text/html",subtype:"HTML",translationKey:"HTML_DOCUMENT_FILE_TYPE",type:"document"}],[".xhtml",{extensions:[".htm",".html",".mht",".mhtml",".shtml",".xht",".xhtml"],mime:"text/html",subtype:"HTML",translationKey:"HTML_DOCUMENT_FILE_TYPE",type:"document"}],[".doc",{extensions:[".doc"],icon:"word",mime:"application/msword",subtype:"Word",translationKey:"WORD_DOCUMENT_FILE_TYPE",type:"document"}],[".docx",{extensions:[".docx"],icon:"word",mime:"application/vnd.openxmlformats-officedocument.wordprocessingml.document",subtype:"Word",translationKey:"WORD_DOCUMENT_FILE_TYPE",type:"document"}],[".ppt",{extensions:[".ppt"],icon:"ppt",mime:"application/vnd.ms-powerpoint",subtype:"PPT",translationKey:"POWERPOINT_PRESENTATION_FILE_TYPE",type:"document"}],[".pptx",{extensions:[".pptx"],icon:"ppt",mime:"application/vnd.openxmlformats-officedocument.presentationml.presentation",subtype:"PPT",translationKey:"POWERPOINT_PRESENTATION_FILE_TYPE",type:"document"}],[".xls",{extensions:[".xls"],icon:"excel",mime:"application/vnd.ms-excel",subtype:"Excel",translationKey:"EXCEL_FILE_TYPE",type:"document"}],[".xlsx",{extensions:[".xlsx"],icon:"excel",mime:"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet",subtype:"Excel",translationKey:"EXCEL_FILE_TYPE",type:"document"}],[".xlsm",{extensions:[".xlsm"],icon:"excel",mime:"application/vnd.ms-excel.sheet.macroEnabled.12",subtype:"Excel",translationKey:"EXCEL_FILE_TYPE",type:"document"}],[".tini",{extensions:[".tini"],icon:"tini",subtype:"TGZ",translationKey:"TINI_FILE_TYPE",type:"archive"}]]);const PLACEHOLDER={translationKey:"NO_EXTENSION_FILE_TYPE",type:"UNKNOWN",icon:"",subtype:"",extensions:undefined,mime:undefined,encrypted:undefined,originalMimeType:undefined};function getFinalExtension(fileName){if(!fileName){return""}const lowerCaseFileName=fileName.toLowerCase();const parts=lowerCaseFileName.split(".");if(parts.length===1){return""}if(parts.length===2){return`.${parts.pop()}`}const last=`.${parts.pop()}`;const secondLast=`.${parts.pop()}`;const doubleExtension=`${secondLast}${last}`;if(EXTENSION_TO_TYPE.has(doubleExtension)){return doubleExtension}return last}function getFileTypeForName(name){const extension=getFinalExtension(name);if(EXTENSION_TO_TYPE.has(extension)){return EXTENSION_TO_TYPE.get(extension)}if(extension===""){return PLACEHOLDER}return{translationKey:"GENERIC_FILE_TYPE",type:"UNKNOWN",subtype:extension.substr(1).toUpperCase(),icon:"",extensions:undefined,mime:undefined,encrypted:undefined,originalMimeType:undefined}}function shouldProcess(width,height,request){const targetDimensions=resizeDimensions(width,height,request);if(targetDimensions.width!==width||targetDimensions.height!==height){return true}if(isImageOrientation(request.orientation)&&!request.orientation.isIdentity()){return true}return false}function resizeDimensions(width,height,request){const scale=request.scale||1;assert(isImageOrientation(request.orientation));const targetDimensions=request.orientation.getSizeAfterCancelling(width*scale,height*scale);let targetWidth=targetDimensions.width;let targetHeight=targetDimensions.height;if(request.maxWidth&&targetWidth>request.maxWidth){const scale=request.maxWidth/targetWidth;targetWidth*=scale;targetHeight*=scale}if(request.maxHeight&&targetHeight>request.maxHeight){const scale=request.maxHeight/targetHeight;targetWidth*=scale;targetHeight*=scale}if(request.width){targetWidth=request.width}if(request.height){targetHeight=request.height}targetWidth=Math.round(targetWidth);targetHeight=Math.round(targetHeight);return{width:targetWidth,height:targetHeight}}function resizeAndCrop(source,target,request){const copyParameters=calculateCopyParameters(source,request);target.width=copyParameters.canvas.width;target.height=copyParameters.canvas.height;const targetContext=target.getContext("2d");targetContext.save();assert(isImageOrientation(request.orientation));request.orientation.cancelImageOrientation(targetContext,copyParameters.target.width,copyParameters.target.height);targetContext.drawImage(source,copyParameters.source.x,copyParameters.source.y,copyParameters.source.width,copyParameters.source.height,copyParameters.target.x,copyParameters.target.y,copyParameters.target.width,copyParameters.target.height);targetContext.restore()}function calculateCopyParameters(source,request){if(request.crop){assert(request.width);assert(request.height);assert(request.width===request.height);const cropSourceDimension=Math.min(source.width,source.height);return{source:{x:Math.floor(source.width/2-cropSourceDimension/2),y:Math.floor(source.height/2-cropSourceDimension/2),width:cropSourceDimension,height:cropSourceDimension},target:{x:0,y:0,width:request.width,height:request.height},canvas:{width:request.width,height:request.height}}}const targetCanvasDimensions=resizeDimensions(source.width,source.height,request);assert(isImageOrientation(request.orientation));const targetDimensions=request.orientation.getSizeAfterCancelling(targetCanvasDimensions.width,targetCanvasDimensions.height);return{source:{x:0,y:0,width:source.width,height:source.height},target:{x:0,y:0,width:targetDimensions.width,height:targetDimensions.height},canvas:{width:targetCanvasDimensions.width,height:targetCanvasDimensions.height}}}var LoadImageResponseStatus;(function(LoadImageResponseStatus){LoadImageResponseStatus["SUCCESS"]="success";LoadImageResponseStatus["ERROR"]="error"})(LoadImageResponseStatus||(LoadImageResponseStatus={}));class LoadImageResponse{status;taskId;width;height;ifd;data;constructor(status,taskId,result){this.status=status;this.taskId=taskId;if(status===LoadImageResponseStatus.ERROR){return}assert(result);this.width=result.width;this.height=result.height;this.ifd=result.ifd;this.data=result.data}static cacheValue(response,timestamp){if(!response||response.status===LoadImageResponseStatus.ERROR){return null}assert(response.width);assert(response.height);assert(response.data);return{timestamp:timestamp||null,width:response.width,height:response.height,ifd:response.ifd,data:response.data}}}function cacheKey(request){if(/^data:/i.test(request.url??"")){return null}return JSON.stringify({url:request.url,orientation:request.orientation,scale:request.scale,width:request.width,height:request.height,maxWidth:request.maxWidth,maxHeight:request.maxHeight})}let PiexModule;const initPiexModule=globalThis.createPiexModule;console.info(`[PiexLoader] available [init=${typeof initPiexModule}]`);let piexFailed=false;const MODULE_SETTINGS={onAbort:error=>{piexFailed=true;throw error}};let initPiexModulePromise=null;function piexModuleInitialized(){if(!initPiexModulePromise){initPiexModulePromise=new Promise((resolve=>{initPiexModule(MODULE_SETTINGS).then((module=>{PiexModule=module;console.info(`[PiexLoader] loaded [module=${typeof module}]`);resolve()}))}))}return initPiexModulePromise}function piexModuleFailed(){if(piexFailed||!PiexModule.calledRun){console.error("[PiexLoader] piex wasm module failed");return true}return false}class PiexLoaderResponse{thumbnail;mimeType;orientation;colorSpace;ifd;constructor(data){this.thumbnail=data.thumbnail;this.mimeType=data.mimeType||"image/jpeg";this.orientation=data.orientation;this.colorSpace=data.colorSpace;this.ifd=data.ifd||null}}const adobeProfile=new Uint8Array([255,226,2,64,73,67,67,95,80,82,79,70,73,76,69,0,1,1,0,0,2,48,65,68,66,69,2,16,0,0,109,110,116,114,82,71,66,32,88,89,90,32,7,208,0,8,0,11,0,19,0,51,0,59,97,99,115,112,65,80,80,76,0,0,0,0,110,111,110,101,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,246,214,0,1,0,0,0,0,211,45,65,68,66,69,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,99,112,114,116,0,0,0,252,0,0,0,50,100,101,115,99,0,0,1,48,0,0,0,107,119,116,112,116,0,0,1,156,0,0,0,20,98,107,112,116,0,0,1,176,0,0,0,20,114,84,82,67,0,0,1,196,0,0,0,14,103,84,82,67,0,0,1,212,0,0,0,14,98,84,82,67,0,0,1,228,0,0,0,14,114,88,89,90,0,0,1,244,0,0,0,20,103,88,89,90,0,0,2,8,0,0,0,20,98,88,89,90,0,0,2,28,0,0,0,20,116,101,120,116,0,0,0,0,67,111,112,121,114,105,103,104,116,32,50,48,48,48,32,65,100,111,98,101,32,83,121,115,116,101,109,115,32,73,110,99,111,114,112,111,114,97,116,101,100,0,0,0,100,101,115,99,0,0,0,0,0,0,0,17,65,100,111,98,101,32,82,71,66,32,40,49,57,57,56,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,88,89,90,32,0,0,0,0,0,0,243,81,0,1,0,0,0,1,22,204,88,89,90,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,99,117,114,118,0,0,0,0,0,0,0,1,2,51,0,0,99,117,114,118,0,0,0,0,0,0,0,1,2,51,0,0,99,117,114,118,0,0,0,0,0,0,0,1,2,51,0,0,88,89,90,32,0,0,0,0,0,0,156,24,0,0,79,165,0,0,4,252,88,89,90,32,0,0,0,0,0,0,52,141,0,0,160,44,0,0,15,149,88,89,90,32,0,0,0,0,0,0,38,49,0,0,16,47,0,0,190,156]);class ImageBuffer{source;length;memory=0;constructor(buffer){this.source=new Uint8Array(buffer);this.length=buffer.byteLength}process(){this.memory=PiexModule._malloc(this.length);if(!this.memory){throw new Error("Image malloc failed: "+this.length+" bytes")}PiexModule.HEAP8.set(this.source,this.memory);const result=PiexModule.image(this.memory,this.length);if(result.error){throw new Error(result.error)}return result}preview(result){const preview=result.preview;if(!preview){return this.thumbnail_(result)}const offset=preview.offset;const length=preview.length;if(offset>this.length||this.length-offset<length){throw new Error("Preview image access failed")}const view=new Uint8Array(this.source.buffer,offset,length);return{thumbnail:this.createImageDataArray_(view,preview).buffer,mimeType:"image/jpeg",ifd:this.details_(result,preview.orientation),orientation:preview.orientation,colorSpace:preview.colorSpace}}thumbnail_(result){const thumbnail=result.thumbnail;if(!thumbnail){return{thumbnail:new ArrayBuffer(0),colorSpace:"sRgb",orientation:1,ifd:null}}if(thumbnail.format){return this.rgb_(result)}const offset=thumbnail.offset;const length=thumbnail.length;if(offset>this.length||this.length-offset<length){throw new Error("Thumbnail image access failed")}const view=new Uint8Array(this.source.buffer,offset,length);return{thumbnail:this.createImageDataArray_(view,thumbnail).buffer,mimeType:"image/jpeg",ifd:this.details_(result,thumbnail.orientation),orientation:thumbnail.orientation,colorSpace:thumbnail.colorSpace}}rgb_(result){const thumbnail=result.thumbnail;if(!thumbnail||thumbnail.format!==1){return{thumbnail:new ArrayBuffer(0),colorSpace:"sRgb",orientation:1,ifd:null}}if(!thumbnail.width||!thumbnail.height){throw new Error("invalid image width or height")}const offset=thumbnail.offset;const length=thumbnail.length;if(offset>this.length||this.length-offset<length){throw new Error("Thumbnail image access failed")}const view=new Uint8Array(this.source.buffer,offset,length);const usesWidthAsHeight=thumbnail.orientation>=5;const height=usesWidthAsHeight?thumbnail.width:thumbnail.height;const width=usesWidthAsHeight?thumbnail.height:thumbnail.width;const rowPad=width&3;const rowStride=3*width+rowPad;const pixelDataOffset=14+108;const fileSize=pixelDataOffset+rowStride*height;const bitmap=new DataView(new ArrayBuffer(fileSize));bitmap.setUint8(0,"B".charCodeAt(0));bitmap.setUint8(1,"M".charCodeAt(0));bitmap.setUint32(2,fileSize,true);bitmap.setUint32(6,0,true);bitmap.setUint32(10,pixelDataOffset,true);bitmap.setUint32(14,108,true);bitmap.setInt32(18,width,true);bitmap.setInt32(22,-height,true);bitmap.setInt16(26,1,true);bitmap.setInt16(28,24,true);bitmap.setUint32(30,0,true);bitmap.setUint32(34,0,true);bitmap.setInt32(38,0,true);bitmap.setInt32(42,0,true);bitmap.setUint32(46,0,true);bitmap.setUint32(50,0,true);bitmap.setUint32(54,0,true);bitmap.setUint32(58,0,true);bitmap.setUint32(62,0,true);bitmap.setUint32(66,0,true);let rx=0;let ry=0;let gx=0;let gy=0;let bx=0;let by=0;let zz=0;let gg=0;if(thumbnail.colorSpace!=="adobeRgb"){bitmap.setUint8(70,"s".charCodeAt(0));bitmap.setUint8(71,"R".charCodeAt(0));bitmap.setUint8(72,"G".charCodeAt(0));bitmap.setUint8(73,"B".charCodeAt(0))}else{bitmap.setUint32(70,0);rx=Math.round(.64*(1<<30));ry=Math.round(.33*(1<<30));gx=Math.round(.21*(1<<30));gy=Math.round(.71*(1<<30));bx=Math.round(.15*(1<<30));by=Math.round(.06*(1<<30));zz=Math.round(1*(1<<30));gg=Math.round(2.1992187*(1<<16))}bitmap.setUint32(74,rx,true);bitmap.setUint32(78,ry,true);bitmap.setUint32(82,zz,true);bitmap.setUint32(86,gx,true);bitmap.setUint32(90,gy,true);bitmap.setUint32(94,zz,true);bitmap.setUint32(98,bx,true);bitmap.setUint32(102,by,true);bitmap.setUint32(106,zz,true);bitmap.setUint32(110,gg,true);bitmap.setUint32(114,gg,true);bitmap.setUint32(118,gg,true);const h=thumbnail.height-1;const w=thumbnail.width-1;let dx=0;for(let input=0,y=0;y<=h;++y){let output=pixelDataOffset;switch(thumbnail.orientation){case 1:output+=y*rowStride;dx=3;break;case 2:output+=y*rowStride+3*w;dx=-3;break;case 3:output+=(h-y)*rowStride+3*w;dx=-3;break;case 4:output+=(h-y)*rowStride;dx=3;break;case 5:output+=3*y;dx=rowStride;break;case 6:output+=3*(h-y);dx=rowStride;break;case 7:output+=w*rowStride+3*(h-y);dx=-rowStride;break;case 8:output+=w*rowStride+3*y;dx=-rowStride;break}for(let x=0;x<=w;++x,input+=3,output+=dx){bitmap.setUint8(output+0,view[input+2]);bitmap.setUint8(output+1,view[input+1]);bitmap.setUint8(output+2,view[input+0])}}if(rowPad){let paddingOffset=pixelDataOffset+3*width;for(let y=0;y<height;++y){let output=paddingOffset;switch(rowPad){case 1:bitmap.setUint8(output++,0);break;case 2:bitmap.setUint8(output++,0);bitmap.setUint8(output++,0);break;case 3:bitmap.setUint8(output++,0);bitmap.setUint8(output++,0);bitmap.setUint8(output++,0);break}paddingOffset+=rowStride}}return{thumbnail:bitmap.buffer,mimeType:"image/bmp",ifd:this.details_(result,thumbnail.orientation),colorSpace:thumbnail.colorSpace,orientation:1}}createImageDataArray_(view,preview){const jpeg=view.byteLength>2&&view[0]===255&&view[1]===216;if(jpeg&&preview.colorSpace==="adobeRgb"){const data=new Uint8Array(view.byteLength+adobeProfile.byteLength);data.set(view.subarray(2),2+adobeProfile.byteLength);data.set(adobeProfile,2);data.set([255,216],0);return data}return new Uint8Array(view)}details_(result,orientation){const details=result.details;if(!details){return null}const format={};for(const[key,value]of Object.entries(details)){if(typeof value==="string"){format[key]=value.replace(/\0+$/,"").trim()}else if(typeof value==="number"){if(!Number.isInteger(value)){format[key]=Number(value.toFixed(3).replace(/0+$/,""))}else{format[key]=value}}}const usesWidthAsHeight=orientation>=5;if(usesWidthAsHeight){const width=format["width"];format["width"]=format["height"];format["height"]=width}return JSON.stringify(format)}close(){const memory=this.memory;if(memory){PiexModule._free(memory);this.memory=0}}}const PiexLoader={load(buffer,onPiexModuleFailed){let imageBuffer;return piexModuleInitialized().then((()=>{if(piexModuleFailed()){throw new Error("piex wasm module failed")}imageBuffer=new ImageBuffer(buffer);return imageBuffer.process()})).then((result=>new PiexLoaderResponse(imageBuffer.preview(result)))).catch((error=>{if(piexModuleFailed()){setTimeout(onPiexModuleFailed,0);return Promise.reject("piex wasm module failed")}console.warn("[PiexLoader] "+error);return Promise.reject(error)})).finally((()=>{imageBuffer&&imageBuffer.close()}))}};const ExtensionContentTypeMap=new Map([["gif","image/gif"],["png","image/png"],["svg","image/svg"],["bmp","image/bmp"],["jpg","image/jpeg"],["jpeg","image/jpeg"]]);const adpRegExp=RegExp("^filesystem:chrome-extension://[a-z]+/external/arc-documents-provider/");function callImageLoaderPrivate(msg){return new Promise(((resolve,reject)=>{chrome.runtime.sendMessage(null,msg,undefined,(thumbnailDataUrl=>{if(chrome.runtime.lastError){console.warn(chrome.runtime.lastError.message);reject(chrome.runtime.lastError)}else if(thumbnailDataUrl){resolve(thumbnailDataUrl)}else{reject()}}))}))}class ImageRequestTask{id_;cache_;request_;sendResponse_;static MAX_MILLISECONDS_TO_LOAD_VIDEO=1e4;static DEFAULT_THUMBNAIL_SQUARE_SIZE=360;static DEFAULT_THUMBNAIL_WIDTH=500;static DEFAULT_THUMBNAIL_HEIGHT=500;image_=new Image;contentType_;ifd_;xhr_=null;canvas_;renderOrientation_=null;downloadCallback_=null;aborted_=false;constructor(id_,cache_,request_,sendResponse_){this.id_=id_;this.cache_=cache_;this.request_=request_;this.sendResponse_=sendResponse_;this.canvas_=document.createElement("canvas")}static getDataUrlMimeType(dataUrl){const dataUrlMatches=(dataUrl||"").match(/^data:([^,;]*)[,;]/);return dataUrlMatches?dataUrlMatches[1]:undefined}getId(){return this.id_}getClientTaskId(){assert(this.request_.taskId);return this.request_.taskId}getPriority(){return this.request_.priority!==undefined?this.request_.priority:2}loadFromCacheAndProcess(onSuccess,onFailure){this.loadFromCache_(((width,height,ifd,data)=>{this.ifd_=ifd;this.sendImageData_(width,height,data);onSuccess()}),onFailure)}downloadAndProcess(callback){if(this.downloadCallback_){throw new Error("Downloading already started.")}this.downloadCallback_=callback;this.downloadThumbnail_(this.onImageLoad_.bind(this),this.onImageError_.bind(this))}loadFromCache_(onSuccess,onFailure){const key=cacheKey(this.request_);if(!key){onFailure();return}if(!this.request_.cache){this.cache_.removeImage(key);onFailure();return}const timestamp=this.request_.timestamp;if(!timestamp){onFailure();return}this.cache_.loadImage(key,timestamp,onSuccess,onFailure)}saveToCache_(width,height,data){const timestamp=this.request_.timestamp;if(!this.request_.cache||!timestamp){return}const key=cacheKey(this.request_);if(!key){return}this.cache_.saveImage(key,timestamp,width,height,this.ifd_,data)}targetThumbnailSize_(){const crop=!!this.request_.crop;const defaultWidth=crop?ImageRequestTask.DEFAULT_THUMBNAIL_SQUARE_SIZE:ImageRequestTask.DEFAULT_THUMBNAIL_WIDTH;const defaultHeight=crop?ImageRequestTask.DEFAULT_THUMBNAIL_SQUARE_SIZE:ImageRequestTask.DEFAULT_THUMBNAIL_HEIGHT;return{width:this.request_.width||defaultWidth,height:this.request_.height||defaultHeight}}async downloadThumbnail_(onSuccess,onFailure){this.image_.onload=()=>{URL.revokeObjectURL(this.image_.src);onSuccess()};this.image_.onerror=()=>{URL.revokeObjectURL(this.image_.src);onFailure()};const dataUrlMimeType=ImageRequestTask.getDataUrlMimeType(this.request_.url);const requestUrl=this.request_.url??"";if(dataUrlMimeType){this.image_.src=requestUrl;this.contentType_=dataUrlMimeType;return}const onExternalThumbnail=dataUrl=>{this.image_.src=dataUrl;this.contentType_=ImageRequestTask.getDataUrlMimeType(dataUrl)};const drivefsUrlMatches=requestUrl.match(/^drivefs:(.*)/);if(drivefsUrlMatches){callImageLoaderPrivate({apiMethod:"getDriveThumbnail",params:{url:drivefsUrlMatches[1]||"",cropToSquare:!!this.request_.crop}}).then(onExternalThumbnail).catch(onFailure);return}if(requestUrl.endsWith(".pdf")){const{width:width,height:height}=this.targetThumbnailSize_();callImageLoaderPrivate({apiMethod:"getPdfThumbnail",params:{url:requestUrl,width:width,height:height}}).then(onExternalThumbnail).catch(onFailure);return}if(requestUrl.match(adpRegExp)){const{width:width,height:height}=this.targetThumbnailSize_();callImageLoaderPrivate({apiMethod:"getArcDocumentsProviderThumbnail",params:{url:requestUrl,widthHint:width,heightHint:height}}).then(onExternalThumbnail).catch(onFailure);return}const fileType=getFileTypeForName(requestUrl);if(fileType.type==="video"){this.createVideoThumbnailUrl_(requestUrl).then((url=>{this.image_.src=url})).catch((error=>{console.warn("Video thumbnail error: ",error);onFailure()}));return}this.load(requestUrl,((contentType,blob)=>{if(fileType.type==="raw"){blob.arrayBuffer().then((buffer=>PiexLoader.load(buffer,chrome.runtime.reload))).then((data=>{this.renderOrientation_=ImageOrientation.fromExifOrientation(data.orientation);this.ifd_=data.ifd??undefined;this.contentType_=data.mimeType;const blob=new Blob([data.thumbnail],{type:data.mimeType});this.image_.src=URL.createObjectURL(blob)})).catch(onFailure);return}this.image_.src=blob?URL.createObjectURL(blob):"!";this.contentType_=contentType||undefined;if(this.contentType_==="image/jpeg"){this.renderOrientation_=ImageOrientation.fromExifOrientation(1)}}),onFailure)}createVideoThumbnailUrl_(url){const video=document.createElement("video");return Promise.race([new Promise(((resolve,reject)=>{video.addEventListener("loadedmetadata",(()=>{video.addEventListener("seeked",(()=>{if(video.readyState>=video.HAVE_CURRENT_DATA){resolve()}else{video.addEventListener("loadeddata",(()=>resolve()))}}));const thumbnailPosition=Math.min(video.duration/2,3);video.currentTime=thumbnailPosition}));video.addEventListener("error",reject);video.preload="metadata";video.src=url;video.load()})),new Promise((resolve=>{setTimeout(resolve,ImageRequestTask.MAX_MILLISECONDS_TO_LOAD_VIDEO)})).then((()=>{video.src="";throw new Error("Seeking video failed.")}))]).then((()=>{const canvas=document.createElement("canvas");canvas.width=video.videoWidth;canvas.height=video.videoHeight;canvas.getContext("2d").drawImage(video,0,0);video.src="";return canvas.toDataURL()}))}load(url,onSuccess,onFailure){this.aborted_=false;const onMaybeSuccess=(contentType,response)=>{if(!contentType){contentType=ExtensionContentTypeMap.get(this.extractExtension_(url))}if(!this.aborted_){onSuccess(contentType,response)}};const onMaybeFailure=()=>{if(!this.aborted_){onFailure()}};const noCacheUrl=url+"?nocache="+Date.now();this.xhr_=ImageRequestTask.load_(noCacheUrl,onMaybeSuccess,onMaybeFailure)}extractExtension_(url){const result=/\.([a-zA-Z]+)$/i.exec(url);return result?result[1]??"":""}static load_(url,onSuccess,onFailure){const xhr=new XMLHttpRequest;xhr.responseType="blob";xhr.onreadystatechange=()=>{if(xhr.readyState!==4){return}if(xhr.status!==200){onFailure(xhr.status);return}const response=xhr.response;const contentType=xhr.getResponseHeader("Content-Type")||response.type;onSuccess(contentType,response)};try{xhr.open("GET",url,true);xhr.send()}catch(e){onFailure()}return xhr}sendImage_(imageChanged){let width;let height;let data;if(!imageChanged){width=this.image_.width;height=this.image_.height;data=this.image_.src}else{width=this.canvas_.width;height=this.canvas_.height;switch(this.contentType_){case"image/jpeg":data=this.canvas_.toDataURL("image/jpeg",.9);break;default:data=this.canvas_.toDataURL("image/png");break}}this.sendImageData_(width,height,data);this.saveToCache_(width,height,data)}sendImageData_(width,height,data){const result={width:width,height:height,ifd:this.ifd_,data:data};this.sendResponse_(new LoadImageResponse(LoadImageResponseStatus.SUCCESS,this.getClientTaskId(),result))}onImageLoad_(){const requestOrientation=this.request_.orientation;if(this.renderOrientation_){this.request_.orientation=this.renderOrientation_}let imageChanged=false;const reqUrl=this.request_.url??"";if(!(reqUrl.match(/^data/)||reqUrl.match(/^drivefs:/))||shouldProcess(this.image_.width,this.image_.height,this.request_)){resizeAndCrop(this.image_,this.canvas_,this.request_);imageChanged=true}if(this.renderOrientation_){this.request_.orientation=requestOrientation}this.sendImage_(imageChanged);this.cleanup_();if(this.downloadCallback_){this.downloadCallback_()}}onImageError_(){this.sendResponse_(new LoadImageResponse(LoadImageResponseStatus.ERROR,this.getClientTaskId()));this.cleanup_();if(this.downloadCallback_){this.downloadCallback_()}}cancel(){this.cleanup_();if(this.downloadCallback_){this.downloadCallback_()}}cleanup_(){this.image_.onerror=()=>{};this.image_.onload=()=>{};this.image_.src="data:image/gif;base64,R0lGODlhAQABAAAAACH5BAEKAAEALAAAAA"+"ABAAEAAAICTAEAOw==";this.aborted_=true;if(this.xhr_){this.xhr_.abort()}this.canvas_.width=0;this.canvas_.height=0}}const memory=Math.max(2,navigator.deviceMemory);const resourceCount=Math.min(navigator.hardwareConcurrency,memory,10);const MAXIMUM_IN_PARALLEL=resourceCount/2;console.warn(`Image Loader maximum parallel tasks: ${MAXIMUM_IN_PARALLEL}`);class Scheduler{newTasks_=[];pendingTasks_=[];activeTasks_=[];tasks_={};started_=false;add(task){if(!this.started_){this.newTasks_.push(task);this.tasks_[task.getId()]=task;return}this.pendingTasks_.push(task);this.sortPendingTasks_();this.continue_()}remove(taskId){const task=this.tasks_[taskId];if(!task){return}const newIndex=this.newTasks_.indexOf(task);if(newIndex!==-1){this.newTasks_.splice(newIndex,1)}const pendingIndex=this.pendingTasks_.indexOf(task);if(pendingIndex!==-1){this.pendingTasks_.splice(pendingIndex,1)}task.cancel();delete this.tasks_[taskId]}start(){this.started_=true;this.pendingTasks_=this.newTasks_;this.sortPendingTasks_();this.newTasks_=[];this.continue_()}sortPendingTasks_(){this.pendingTasks_.sort(((a,b)=>a.getPriority()-b.getPriority()))}continue_(){while(this.pendingTasks_.length>0&&this.activeTasks_.length<MAXIMUM_IN_PARALLEL){const task=this.pendingTasks_.shift();this.activeTasks_.push(task);task.loadFromCacheAndProcess((()=>this.finish_(task)),(()=>task.downloadAndProcess((()=>this.finish_(task)))))}}finish_(task){const index=this.activeTasks_.indexOf(task);if(index<0){console.warn("ImageRequestTask not found.")}this.activeTasks_.splice(index,1);delete this.tasks_[task.getId()];if(this.started_){this.continue_()}}}let instance=null;class ImageLoader{cache_=new ImageCache;scheduler_=new Scheduler;constructor(){this.cache_.initialize((()=>this.scheduler_.start()))}handle(request,sendResponse){assert(request.imageLoaderRequestId);if(request.cancel){this.scheduler_.remove(request.imageLoaderRequestId);return false}const failSafeSendResponse=function(response){try{sendResponse(response)}catch(e){}};assert(!(request.orientation instanceof ImageOrientation));assert(typeof request.orientation!=="number");if(request.orientation){request.orientation=ImageOrientation.fromRotationAndScale(request.orientation)}else{request.orientation=new ImageOrientation(1,0,0,1)}this.scheduler_.add(new ImageRequestTask(request.imageLoaderRequestId,this.cache_,request,failSafeSendResponse));return true}static getInstance(){if(!instance){instance=new ImageLoader}return instance}}const EXTENSION_ID="pmfjbimdmchhbnneeidfognadeopoehp";chrome.runtime.onMessage.addListener(((msg,sender,sendResponse)=>{if(sender.id!==EXTENSION_ID||!msg.imageLoaderRequestId){return false}return ImageLoader.getInstance().handle(msg,sendResponse)}));