// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{a as assert}from"./shared.rollup.js";const EXTENSION_ID="pmfjbimdmchhbnneeidfognadeopoehp";const ALLOW_LISTED_FILE_MANAGER_SWA="chrome://file-manager";const ALLOW_LISTED_NATIVE="com.google.ash_thumbnail_loader";let creatingOffscreenDocument;async function setupOffscreenDocument(){const url=chrome.runtime.getURL("offscreen.html");const existingContexts=await chrome.runtime.getContexts({contextTypes:[chrome.runtime.ContextType.OFFSCREEN_DOCUMENT],documentUrls:[url]});if(existingContexts.length>0){return}if(creatingOffscreenDocument){await creatingOffscreenDocument;return}creatingOffscreenDocument=chrome.offscreen.createDocument({url:url,reasons:[chrome.offscreen.Reason.USER_MEDIA],justification:"Lets us use <img>, <canvas> and XMLHttpRequest"});await creatingOffscreenDocument;creatingOffscreenDocument=undefined}async function sendToOffscreenDocument(msg,senderOrigin,sendResponse){assert(msg);try{await setupOffscreenDocument()}catch(e){console.error("setupOffscreenDocument:",e);return}msg.imageLoaderRequestId=senderOrigin+":"+msg.taskId;chrome.runtime.sendMessage(null,msg,undefined,(response=>{sendResponse(response)}))}if(chrome.runtime.getManifest().version!=="0.5"){chrome.runtime.reload()}else{chrome.runtime.onMessage.addListener(((msg,sender,sendResponse)=>{if(sender.id!==EXTENSION_ID){return false}else if(msg.apiMethod==="getArcDocumentsProviderThumbnail"){chrome.imageLoaderPrivate.getArcDocumentsProviderThumbnail(msg.params.url,msg.params.widthHint,msg.params.heightHint,sendResponse);return true}else if(msg.apiMethod==="getDriveThumbnail"){chrome.imageLoaderPrivate.getDriveThumbnail(msg.params.url,msg.params.cropToSquare,sendResponse);return true}else if(msg.apiMethod==="getPdfThumbnail"){chrome.imageLoaderPrivate.getPdfThumbnail(msg.params.url,msg.params.width,msg.params.height,sendResponse);return true}return false}));chrome.runtime.onMessageExternal.addListener(((msg,sender,sendResponse)=>{if(!msg||sender.origin!==ALLOW_LISTED_FILE_MANAGER_SWA){return false}sendToOffscreenDocument(msg,ALLOW_LISTED_FILE_MANAGER_SWA,sendResponse);return!msg.cancel}));chrome.runtime.onConnectNative.addListener((port=>{assert(port.sender);if(port.sender.nativeApplication!==ALLOW_LISTED_NATIVE){port.disconnect();return}port.onMessage.addListener((msg=>{if(!msg){port.disconnect();return}else if(msg.cancel){port.disconnect()}sendToOffscreenDocument(msg,ALLOW_LISTED_NATIVE,(response=>{assert(!msg.cancel);port.postMessage(response);port.disconnect()}))}))}))}