// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview Entry point for the Image Loader's offscreen document.
 */
import { ImageLoader } from './image_loader.js';
const EXTENSION_ID = 'pmfjbimdmchhbnneeidfognadeopoehp';
chrome.runtime.onMessage.addListener((msg, sender, sendResponse) => {
    if ((sender.id !== EXTENSION_ID) || !msg.imageLoaderRequestId) {
        return false;
    }
    return ImageLoader.getInstance().handle(msg, sendResponse);
});
