// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
export const LEGACY_FILES_EXTENSION_ID = 'hhaomjibdihmijegdhdafkllkbggdgoj';
/** App ID generated by the SWA framework. */
export const SWA_APP_ID = 'fkiggjmkendpmbegkagpmagjepfkpmeb';
export const SWA_FILES_APP_HOST = 'file-manager';
/**
 * Special key for when we are showing search results. Search results do not
 * have a corresponding entry in the directory tree. As a result we need to
 * fake the PathComponent that represents the "current" directory. This constant
 * corresponds to the key field of the PathComponent object.
 */
export const SEARCH_RESULTS_KEY = 'fake-entry://search/';
/** The URL of the legacy version of File Manager. */
export const LEGACY_FILES_APP_URL = new URL(`chrome-extension://${LEGACY_FILES_EXTENSION_ID}`);
/** The URL of the System Web App version of File Manager. */
export const SWA_FILES_APP_URL = new URL(`chrome://${SWA_FILES_APP_HOST}`);
/** The path to the File Manager icon. */
export const FILES_APP_ICON_PATH = 'common/images/icon96.png';
/**
 * @param path relative to the Files app root.
 * @return The absolute URL for a path within the Files app.
 */
export function toFilesAppURL(path = '') {
    return new URL(path, SWA_FILES_APP_URL);
}
/**
 * @param path relative to the sandboxed page origin.
 * @return The absolute URL.
 */
export function toSandboxedURL(path = '') {
    const SANDBOXED_URL = new URL(`chrome-untrusted://${SWA_FILES_APP_HOST}`);
    return new URL(path, SANDBOXED_URL);
}
/**
 * @return The URL of the file that holds Files App icon.
 */
export function getFilesAppIconURL() {
    return toFilesAppURL(FILES_APP_ICON_PATH);
}
