import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><!--
Copyright 2019 The Chromium Authors
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
-->
<style include="cr-shared-style md-select">[slot='body']>div{font:var(--cros-body-1-font);margin-bottom:var(--cr-form-field-bottom-spacing)}[slot='body']>#disk-format{margin-bottom:0;padding:0 2px 2px}[slot='button-container']{--cr-dialog-button-container-padding-bottom:0;--cr-dialog-button-container-padding-horizontal:0;padding-top:32px}#warning-icon{--iron-icon-fill-color:var(--cros-sys-error)}#warning-message{color:var(--cros-sys-error);display:inline-block;margin-inline-start:8px}cr-dialog::part(dialog){--cr-dialog-background-color:var(--cros-sys-dialog_container);border-radius:20px}cr-dialog::part(dialog)::backdrop{background-color:var(--cros-sys-scrim)}cr-dialog::part(wrapper){padding:32px;padding-bottom:28px}[slot='title']{--cr-dialog-title-slot-padding-bottom:16px;--cr-dialog-title-slot-padding-end:0;--cr-dialog-title-slot-padding-start:0;--cr-dialog-title-slot-padding-top:0;--cr-primary-text-color:var(--cros-sys-on_surface);font:var(--cros-display-7-font)}[slot='body']{--cr-dialog-body-padding-horizontal:0;--cr-secondary-text-color:var(--cros-sys-on_surface_variant);font:var(--cros-body-1-font)}.md-select{--md-select-bg-color:var(--cros-sys-input_field_on_base);--md-select-focus-shadow-color:var(--cros-sys-focus_ring);--md-select-text-color:var(--cros-sys-on_surface);--md-select-side-padding:16px;border-radius:8px;height:36px;width:100%}cr-input{--cr-form-field-label-color:var(--cros-sys-on_surface);--cr-input-background-color:var(--cros-sys-input_field_on_base);--cr-input-border-radius:8px;--cr-input-color:var(--cros-sys-on_surface);--cr-input-error-color:var(--cros-sys-error);--cr-input-focus-color:var(--cros-sys-primary);--cr-input-min-height:36px;--cr-input-padding-end:16px;--cr-input-padding-start:16px;--cr-input-placeholder-color:var(--cros-sys-secondary);font:var(--cros-body-2-font)}cr-button{--active-bg:transparent;--active-shadow:none;--active-shadow-action:none;--bg-action:var(--cros-sys-primary);--cr-button-height:36px;--disabled-bg-action:var(--cros-sys-disabled_container);--disabled-bg:var(--cros-sys-disabled_container);--disabled-text-color:var(--cros-sys-disabled);--hover-bg-action:var(--cros-sys-primary);--hover-bg-color:var(--cros-sys-primary_container);--ink-color:var(--cros-sys-ripple_primary);--ripple-opacity-action:1;--ripple-opacity:1;--text-color-action:var(--cros-sys-on_primary);--text-color:var(--cros-sys-on_primary_container);border:none;border-radius:18px;box-shadow:none;font:var(--cros-button-2-font);position:relative}cr-button.cancel-button{background-color:var(--cros-sys-primary_container)}cr-button.cancel-button:hover::part(hoverBackground){background-color:var(--cros-sys-hover_on_subtle);display:block}cr-button.action-button:hover::part(hoverBackground){background-color:var(--cros-sys-hover_on_prominent);display:block}:host-context(.focus-outline-visible) cr-button:focus{outline:2px solid var(--cros-sys-focus_ring);outline-offset:2px}</style>

<cr-dialog id="dialog" close-text="$i18n{CLOSE_LABEL}"
           single-partition-format$="[[getSinglePartitionFormat()]]">
  <div slot="title">
    [[getStrf('FORMAT_DIALOG_TITLE', title)]]
  </div>
  <div slot="body">
    <div>[[getDialogMessage(isErase_)]]</div>
    <div id="warning-container" hidden="[[!spaceUsed_]]" role="alert">
      <iron-icon id="warning-icon" icon="cr:warning"></iron-icon>
      <div id="warning-message">
        [[getStrf('FORMAT_DIALOG_DELETE_WARNING', spaceUsed_)]]
      </div>
    </div>
    <cr-input label="$i18n{FORMAT_DIALOG_DRIVE_NAME_LABEL}"
        id="label" value="{{label_}}" auto-validate="true">
    </cr-input>
    <div id="disk-format">
      <label id="format-type-label" class="cr-form-field-label">
        $i18n{FORMAT_DIALOG_FORMAT_LABEL}
      </label>
      <select class="md-select" aria-labelledby="format-type-label"
          value="{{formatType_::change}}">
        <option value="vfat">FAT32</option>
        <option value="exfat">exFAT</option>
        <option value="ntfs">NTFS</option>
      </select>
    </div>
  </div>
  <div slot="button-container">
    <cr-button class="cancel-button" on-click="cancel" id="cancel">
      $i18n{CANCEL_LABEL}
    </cr-button>
    <cr-button class="action-button" on-click="format"
        id="format-button">
      [[getConfirmLabel(isErase_)]]
    </cr-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`;
}
