import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><!--
Copyright 2016 The Chromium Authors
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
-->

<style>div{margin:0;padding:0}div[hidden]{display:none}#box{display:block;overflow:auto;padding-bottom:16px;padding-top:16px;width:320px}.category{color:var(--cros-sys-on_surface);font:var(--cros-button-1-font);padding-bottom:16px;padding-inline:32px 16px;padding-top:16px}hr{border-color:var(--cros-sys-separator);border-top-width:1px !important;border-width:0;margin-bottom:16px;margin-top:16px}</style>
<div id="box">
  <div class="category">$i18n{METADATA_BOX_GENERAL_INFO}</div>
  <files-metadata-entry key="$i18n{METADATA_BOX_FILE_SIZE}" value="[[size]]" loading="[[isSizeLoading]]"></files-metadata-entry>
  <files-metadata-entry key="$i18n{METADATA_BOX_MODIFICATION_TIME}" value="[[modificationTime]]"></files-metadata-entry>
  <files-metadata-entry key="$i18n{METADATA_BOX_MEDIA_MIME_TYPE}" value="[[mediaMimeType]]"></files-metadata-entry>
  <files-metadata-entry key="$i18n{METADATA_BOX_FILE_LOCATION}" value="[[fileLocation]]" hidden="[[!isTrashEntry(originalLocation)]]"></files-metadata-entry>
  <files-metadata-entry key="$i18n{METADATA_BOX_ORIGINAL_LOCATION}" value="[[originalLocation]]" hidden="[[isTrashEntry(originalLocation)]]"></files-metadata-entry>

  <div hidden="[[!hasFileSpecificMetadata_]]">
    <hr>
    <div class="category" hidden="[[!isImage(type)]]">$i18n{METADATA_BOX_IMAGE_INFO}</div>
    <div class="category" hidden="[[!isAudio(type)]]">$i18n{METADATA_BOX_AUDIO_INFO}</div>
    <div class="category" hidden="[[!isVideo(type)]]">$i18n{METADATA_BOX_VIDEO_INFO}</div>
    <files-metadata-entry key="$i18n{METADATA_BOX_DIMENSION}" value="[[dimension(imageWidth, imageHeight)]]"></files-metadata-entry>
    <files-metadata-entry key="$i18n{METADATA_BOX_ALBUM_TITLE}" value="[[mediaAlbum]]"></files-metadata-entry>
    <files-metadata-entry key="$i18n{METADATA_BOX_MEDIA_TITLE}" value="[[mediaTitle]]"></files-metadata-entry>
    <files-metadata-entry key="$i18n{METADATA_BOX_MEDIA_ARTIST}" value="[[mediaArtist]]"></files-metadata-entry>
    <files-metadata-entry key="$i18n{METADATA_BOX_DURATION}" value="[[time2string(mediaDuration)]]"></files-metadata-entry>
    <files-metadata-entry key="$i18n{METADATA_BOX_GENRE}" value="[[mediaGenre]]"></files-metadata-entry>
    <files-metadata-entry key="$i18n{METADATA_BOX_TRACK}" value="[[mediaTrack]]"></files-metadata-entry>
    <files-metadata-entry key="$i18n{METADATA_BOX_EXIF_DEVICE_MODEL}" value="[[deviceModel(ifd)]]"></files-metadata-entry>
    <files-metadata-entry key="$i18n{METADATA_BOX_EXIF_DEVICE_SETTINGS}" value="[[deviceSettings(ifd)]]"></files-metadata-entry>
    <files-metadata-entry key="$i18n{METADATA_BOX_EXIF_GEOGRAPHY}" value="[[geography(ifd)]]"></files-metadata-entry>
    <files-metadata-entry key="$i18n{METADATA_BOX_YEAR_RECORDED}" value="[[mediaYearRecorded]]"></files-metadata-entry>
    <files-metadata-entry key="$i18n{METADATA_BOX_DATE_TAKEN}" value="[[dateTaken(ifd)]]"></files-metadata-entry>
  </div>
</div>
<!--_html_template_end_-->`;
}
