// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { ArrayDataModel } from '../../common/js/array_data_model.js';
/**
 * Mock FolderShortcutDataModel.
 */
export class MockFolderShortcutDataModel extends ArrayDataModel {
    /**
     */
    constructor(array) {
        super(array);
    }
    /**
     * @public
     */
    asFolderShortcutsDataModel() {
        return this;
    }
    /**
     * Mock function for FolderShortcutDataModel.compare().
     * @param a First parameter to be compared.
     * @param b Second parameter to be compared with.
     * @return Negative if a < b, positive if a > b, or zero if a === b.
     */
    compare(a, b) {
        return a.fullPath.localeCompare(b.fullPath);
    }
}
