import { getTrustedHTML } from '//resources/js/static_types.js';
export function getTemplate() {
    return getTrustedHTML `<!--_html_template_start_--><style>
  :host {
    width: 100%;
  }

  .educational-banner {
    align-items: center;
    display: flex;
    flex-direction: row;
    flex-wrap: wrap;
    min-height: 32px;
    width: 100%;
  }

  #educational-text-group {
    align-items: flex-start;
    display: flex;
    flex: 1 0 0;
    flex-direction: column;
    flex-wrap: nowrap;
  }

  .educational-text-icon {
    align-items: center;
    display: flex;
    flex-direction: row;
    flex-wrap: nowrap;
    margin-bottom: 8px;
    margin-top: 8px;
  }

  .feature-icon {
    -webkit-mask-image: var(--feature-icon-src, none);
    -webkit-mask-position: center;
    -webkit-mask-repeat: no-repeat;
    background-color: var(--feature-icon-bg, var(--cros-sys-primary));
    flex: none;
    height: 32px;
    margin-inline-end: 20px;
    margin-inline-start: 16px;
    width: 32px;
  }

  ::slotted([slot='illustration']) {
    height: 32px;
    width: 32px;
  }

  .title {
    -webkit-box-orient: vertical;
    -webkit-line-clamp: 2;
    color: var(--cros-sys-on_surface);
    display: -webkit-box;
    font: var(--cros-headline-1-font);
    overflow: hidden;
    text-overflow: ellipsis;
  }

  .subtitle {
    color: var(--cros-sys-on_surface);
    font: var(--cros-body-2-font);
  }

  .button-group {
    align-items: center;
    display: flex;
    flex: 0 0 auto;
    flex-direction: var(--buttons-direction, row);
    height: 32px;
    margin-bottom: 8px;
    margin-inline-start: auto;
    margin-top: 8px;
    padding-inline-start: 32px;
  }

  ::slotted(cr-button),
  #dismiss-button-old {
    --active-bg: none;
    --bg-action: var(--cros-sys-primary);
    /* Use the default bg color as hover color because we
       rely on hoverBackground layer below.  */
    --hover-bg-action: var(--cros-sys-primary);
    --hover-bg-color: var(--cros-sys-hover_on_subtle);
    --ink-color: var(--cros-sys-ripple_neutral_on_subtle);
    --ink-color-action: var(--cros-sys-ripple_primary);
    --paper-ripple-opacity: 100%;
    --text-color-action: var(--cros-sys-on_primary);
    --text-color: var(--cros-sys-primary);
    border: none;
    border-radius: 18px;
    box-shadow: none;
    font: var(--cros-button-2-font);
    height: 36px;
    margin-inline: 4px;
    padding-inline: 16px;
    position: relative;
  }

  #dismiss-button {
    margin-inline: 4px;
  }

  :host-context(.focus-outline-visible) ::slotted(cr-button:focus),
  :host-context(.focus-outline-visible) #dismiss-button-old:focus {
    outline: 2px solid var(--cros-sys-focus_ring);
    outline-offset: 2px;
  }
</style>
<div class="educational-banner">
  <div class="educational-text-icon">
    <!-- Use feature-icon to pass a monotone color SVG, use slot illustration
         to pass multiple colored SVG, when slot illustration is used, remember
         to set --feature-icon-src to none. -->
    <div class="feature-icon">
      <slot name="illustration"></slot>
    </div>
    <div id="educational-text-group">
      <div class="title">
        <slot name="title"></slot>
      </div>
      <div class="subtitle">
        <slot name="subtitle"></slot>
      </div>
    </div>
  </div>
  <div class="button-group">
    <slot name="extra-button"></slot>
    <slot name="dismiss-button">
      <xf-jellybean>
        <cr-button id="dismiss-button-old" slot="old">
          $i18n{DRIVE_WELCOME_DISMISS}
        </cr-button>
        <cros-button
            label="$i18n{DRIVE_WELCOME_DISMISS}"
            id="dismiss-button"
            button-style="floating"
            slot="jelly">
        </cros-button>
      </xf-jellybean>
    </slot>
  </div>
</div>
<!--_html_template_end_-->`;
}
