import { getTrustedHTML } from '//resources/js/static_types.js';
export function getTemplate() {
    return getTrustedHTML `<!--_html_template_start_--><style>
  educational-banner {
    --feature-icon-bg: none;
  }

  educational-banner [slot=illustration] {
    --holding-space-svg-color-1: var(--cros-sys-illo-color1-2);
    --holding-space-svg-color-2: var(--cros-sys-illo-color1);
    --holding-space-svg-color-3: var(--cros-sys-illo-color2);
    --holding-space-svg-color-4: var(--cros-sys-illo-color5);
    --holding-space-svg-color-5: var(--cros-sys-illo-color4);
  }

  .tablet-mode-enabled {
    display: none;
  }

  :host-context(body.tablet-mode-enabled) .tablet-mode-disabled {
    display: none;
  }

  :host-context(body.tablet-mode-enabled) .tablet-mode-enabled {
    display: block;
    height: auto;
    line-height: 20px;
  }

  .icon {
    -webkit-mask-image: url(/foreground/images/files/ui/menu_ng.svg);
    -webkit-mask-position: center;
    -webkit-mask-repeat: no-repeat;
    -webkit-mask-size: 100%;
    background-color: var(--cros-sys-on_surface);
    display: inline-block;
    height: 20px;
    vertical-align: middle;
    width: 13px;
  }
</style>
<educational-banner>
  <svg slot="illustration">
    <use xlink:href="/foreground/images/files/ui/holding_space_welcome_image.svg#holding_space"></use>
  </svg>
  <span slot="title">$i18n{HOLDING_SPACE_WELCOME_TITLE}</span>
  <span slot="subtitle" class="tablet-mode-disabled">
    $i18n{HOLDING_SPACE_WELCOME_TEXT}
  </span>
  <span slot="subtitle" class="tablet-mode-enabled">
    $i18nRaw{HOLDING_SPACE_WELCOME_TEXT_IN_TABLET_MODE_HTML}
  </span>
</educational-banner>
<!--_html_template_end_-->`;
}
