import { getTrustedHTML } from '//resources/js/static_types.js';
export function getTemplate() {
    return getTrustedHTML `<!--_html_template_start_--><style>
  :host {
    width: 100%;
  }

  .state-banner {
    display: flex;
    flex-direction: row;
    flex-wrap: wrap;
    min-height: 32px;
    width: 100%;
  }

  #state-text-group {
    align-items: center;
    display: flex;
    flex-direction: row;
    flex-wrap: nowrap;
  }

  .state-icon-holder {
    align-items: center;
    background-color: var(--icon-holder-bg, var(--cros-sys-surface_variant));
    border-radius: 16px;
    display: flex;
    height: 32px;
    justify-content: center;
    margin-inline-end: 20px;
    margin-inline-start: 16px;
    width: 32px;
  }

  .state-icon {
    -webkit-mask-image: var(--icon-src,
        url(/foreground/images/files/ui/state_banner_icon.svg));
    -webkit-mask-position: center;
    -webkit-mask-repeat: no-repeat;
    background-color: var(--icon-bg, var(--cros-sys-on_surface_variant));
    flex: none;
    height: 20px;
    width: 20px;
  }

  .state-message {
    color: var(--cros-sys-on_surface);
    font: var(--cros-body-2-font);
  }

  .button-group {
    align-items: center;
    display: flex;
    flex: 0 0 auto;
    height: 32px;
    margin-inline-start: auto;
    padding-inline-start: 32px;
  }

  ::slotted(cr-button) {
    --active-bg: none;
    --hover-bg-color: var(--cros-sys-hover_on_subtle);
    --ink-color: var(--cros-sys-ripple_neutral_on_subtle);
    --paper-ripple-opacity: 100%;
    --text-color: var(--cros-sys-primary);
    border: none;
    border-radius: 18px;
    box-shadow: none;
    font: var(--cros-button-2-font);
    height: 36px;
    margin-inline: 4px;
    padding-inline: 16px;
    position: relative;
  }

  :host-context(.focus-outline-visible) ::slotted(cr-button:focus) {
    outline: 2px solid var(--cros-sys-focus_ring);
    outline-offset: 2px;
  }
</style>
<div class="state-banner">
  <div id="state-text-group">
    <div class="state-icon-holder">
      <div class="state-icon"></div>
    </div>
    <div class="state-message">
      <slot name="text"></slot>
    </div>
  </div>
  <div class="button-group">
    <slot name="extra-button"></slot>
  </div>
</div>
<!--_html_template_end_-->`;
}
