import { getTrustedHTML } from '//resources/js/static_types.js';
export function getTemplate() {
    return getTrustedHTML `<!--_html_template_start_--><style>
  :host {
    width: 100%;
  }

  .warning-banner {
    display: flex;
    flex-direction: row;
    flex-wrap: wrap;
    min-height: 32px;
    width: 100%;
  }

  #warning-text-group {
    align-items: center;
    display: flex;
    flex-direction: row;
    flex-wrap: nowrap;
  }

  .warning-icon-holder {
    align-items: center;
    background-color: var(--icon-holder-bg, var(--cros-sys-warning_container));
    border-radius: 16px;
    display: flex;
    height: 32px;
    justify-content: center;
    margin-inline-end: 20px;
    margin-inline-start: 16px;
    width: 32px;
  }

  .warning-icon {
    -webkit-mask-image: var(--icon-src,
        url(/foreground/images/files/ui/warning_banner_icon.svg));
    -webkit-mask-position: center;
    -webkit-mask-repeat: no-repeat;
    background-color: var(--icon-bg, var(--cros-sys-on_warning_container));
    flex: none;
    height: 20px;
    width: 20px;
  }

  .warning-message {
    color: var(--cros-sys-on_surface);
    font: var(--cros-body-2-font);
  }

  .button-group {
    align-items: center;
    display: flex;
    flex: 0 0 auto;
    height: 32px;
    margin-inline-start: auto;
    padding-inline-start: 32px;
  }

  ::slotted(cr-button),
  #dismiss-button {
    --active-bg: none;
    --hover-bg-color: var(--cros-sys-hover_on_subtle);
    --ink-color: var(--cros-sys-ripple_neutral_on_subtle);
    --paper-ripple-opacity: 100%;
    --text-color: var(--cros-sys-primary);
    border: none;
    border-radius: 18px;
    box-shadow: none;
    font: var(--cros-button-2-font);
    height: 36px;
    margin-inline: 4px;
    padding-inline: 16px;
    position: relative;
  }

  :host-context(.focus-outline-visible) ::slotted(cr-button:focus),
  :host-context(.focus-outline-visible) #dismiss-button:focus {
    outline: 2px solid var(--cros-sys-focus_ring);
    outline-offset: 2px;
  }
</style>
<div class="warning-banner">
  <div id="warning-text-group">
    <div class="warning-icon-holder">
      <div class="warning-icon"></div>
    </div>
    <div class="warning-message">
      <slot name="text"></slot>
    </div>
  </div>
  <div class="button-group">
    <slot name="extra-button"></slot>
    <slot name="dismiss-button"></slot>
  </div>
</div>
<!--_html_template_end_-->`;
}
