import { getTrustedHTML } from '//resources/js/static_types.js';
export function getTemplate() {
    return getTrustedHTML `<!--_html_template_start_--><style include="cr-shared-style">
    [slot='title'] {
      font: var(--cros-display-7-font);
    }

    [slot='body'] {
      font: var(--cros-body-1-font);
    }

    [slot='body'] #message {
      margin-bottom: 20px;
    }

    cr-dialog::part(dialog) {
      border-radius: 20px;
      box-shadow: var(--cros-elevation-3-shadow);
      max-height: 480px;
      width: 512px;
    }

    cr-dialog {
      --cr-dialog-background-color: var(--cros-sys-dialog_container);
      --cr-dialog-body-padding-horizontal: 0;
      --cr-dialog-button-container-padding-bottom: 0;
      --cr-dialog-button-container-padding-horizontal: 0;
      --cr-dialog-title-slot-padding-bottom: 16px;
      --cr-dialog-title-slot-padding-end: 0;
      --cr-dialog-title-slot-padding-start: 0;
      /* horizontally align with the  close button */
      --cr-dialog-title-slot-padding-top: 8px;
      --cr-primary-text-color: var(--cros-sys-on_surface);
      --cr-secondary-text-color: var(--cros-sys-on_surface_variant);
    }

    cr-dialog::part(dialog)::backdrop {
      background-color: var(--cros-sys-scrim);
    }

    cr-dialog::part(wrapper) {
      padding: 32px;
      padding-bottom: 28px;
    }
</style>

<cr-dialog id="dialog"
  consume-keydown-event show-close-button close-text=$i18n{CLOSE_LABEL}>
  <div slot="title">
    $i18n{DLP_RESTRICTION_DETAILS_TITLE}
  </div>
  <div slot="body">
    <div id="message" cr-dialog-text>$i18n{DLP_RESTRICTION_DETAILS_MESSAGE}</div>
    <div id="details-container">
      <span id="block-details" hidden=true>
        <label>$i18n{DLP_RESTRICTION_DETAILS_BLOCK}</label>
        <ul id="block-list">
          <li id="block-li-urls" hidden=true>
            <label id="block-urls"></label>
          </li>
          <li id="block-li-components" hidden=true>
            <label id="block-components"></label>
          </li>
        </ul>
      </span>
      <span id="warn-details" hidden=true>
        <label>$i18n{DLP_RESTRICTION_DETAILS_WARN}</label>
        <ul id="warn-list">
          <li id="warn-li-urls" hidden=true>
            <label id="warn-urls"></label>
          </li>
          <li id="warn-li-components" hidden=true>
            <label id="warn-components"></label>
          </li>
        </ul>
      </span>
      <span id="report-details" hidden=true>
        <label>$i18n{DLP_RESTRICTION_DETAILS_REPORT}</label>
          <ul id="report-list">
            <li id="report-li-urls" hidden=true>
              <label id="report-urls"></label>
            </li>
            <li id="report-li-components" hidden=true>
              <label id="report-components"></label>
            </li>
          </ul>
        </span>
    </div>
  </div>
</cr-dialog>
<!--_html_template_end_-->`;
}
