import { getTrustedHTML } from '//resources/js/static_types.js';
export function getTemplate() {
    return getTrustedHTML `<!--_html_template_start_--><style>
#container > * {
  background-color: var(--cros-sys-primary);
  z-index: 999;
}

#dot {
  border-radius: 50%;
  height: 8px;
  left: -8px;
  position: fixed;
  width: 8px;
}

#bubble {
  align-items: center;
  border-radius: 16px;
  color: var(--cros-sys-on_primary);
  display: flex;
  left: -296px;
  max-width: calc(296px - 2 * 16px);
  padding: 8px 16px;
  position: fixed;
  width: fit-content;
}

#bubble.single-line {
  border-radius: 18px;
}

#bubble > .icon {
  -webkit-mask-image: url(/foreground/images/files/ui/nudge_star_icon.svg);
  -webkit-mask-position: center;
  -webkit-mask-repeat: no-repeat;
  background-color: currentColor;
  height: 20px;
  margin-inline-end: 12px;
  width: 20px;
}

#bubble > span {
  font: var(--cros-body-1-font);
}

#dismiss {
  --focus-shadow-color: var(--cros-sys-inverse_primary);
  align-self: center;
  border-radius: 8px;
  color: var(--cros-sys-on_primary);
}
</style>
<div aria-hidden="true" id="container">
  <div id="dot"></div>
  <div id="bubble">
    <span class="icon"></span>
    <span id="text"></span>
    <cr-button id="dismiss" aria-describedby="text" hidden></cr-button>
  </div>
</div>
<!--_html_template_end_-->`;
}
