// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{assert}from"//resources/js/assert.js";import{EventTracker}from"//resources/js/event_tracker.js";import{debounceEnd}from"//resources/js/util.js";import{dedupingMixin}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{HELP_BUBBLE_DISMISSED_EVENT,HELP_BUBBLE_TIMED_OUT_EVENT}from"./help_bubble.js";import{HelpBubbleClosedReason}from"./help_bubble.mojom-webui.js";import{HelpBubbleController}from"./help_bubble_controller.js";import{HelpBubbleProxyImpl}from"./help_bubble_proxy.js";export const HelpBubbleMixin=dedupingMixin((superClass=>{class HelpBubbleMixin extends superClass{trackedElementHandler_;helpBubbleHandler_;helpBubbleCallbackRouter_;helpBubbleControllerById_=new Map;helpBubbleListenerIds_=[];helpBubbleFixedAnchorObserver_=null;helpBubbleResizeObserver_=null;helpBubbleDismissedEventTracker_=new EventTracker;debouncedAnchorMayHaveChangedCallback_=null;constructor(...args){super(...args);this.trackedElementHandler_=HelpBubbleProxyImpl.getInstance().getTrackedElementHandler();this.helpBubbleHandler_=HelpBubbleProxyImpl.getInstance().getHandler();this.helpBubbleCallbackRouter_=HelpBubbleProxyImpl.getInstance().getCallbackRouter()}connectedCallback(){super.connectedCallback();const router=this.helpBubbleCallbackRouter_;this.helpBubbleListenerIds_.push(router.showHelpBubble.addListener(this.onShowHelpBubble_.bind(this)),router.toggleFocusForAccessibility.addListener(this.onToggleHelpBubbleFocusForAccessibility_.bind(this)),router.hideHelpBubble.addListener(this.onHideHelpBubble_.bind(this)),router.externalHelpBubbleUpdated.addListener(this.onExternalHelpBubbleUpdated_.bind(this)));const isVisible=element=>{const rect=element.getBoundingClientRect();return rect.height>0&&rect.width>0};this.debouncedAnchorMayHaveChangedCallback_=debounceEnd(this.onAnchorBoundsMayHaveChanged_.bind(this),50);this.helpBubbleResizeObserver_=new ResizeObserver((entries=>entries.forEach((({target:target})=>{if(target===document.body){if(this.debouncedAnchorMayHaveChangedCallback_){this.debouncedAnchorMayHaveChangedCallback_()}}else{this.onAnchorVisibilityChanged_(target,isVisible(target))}}))));this.helpBubbleFixedAnchorObserver_=new IntersectionObserver((entries=>entries.forEach((({target:target,isIntersecting:isIntersecting})=>this.onAnchorVisibilityChanged_(target,isIntersecting)))),{root:null});document.addEventListener("scroll",this.debouncedAnchorMayHaveChangedCallback_,{passive:true});this.helpBubbleResizeObserver_.observe(document.body);this.controllers.forEach((ctrl=>this.observeControllerAnchor_(ctrl)))}get controllers(){return Array.from(this.helpBubbleControllerById_.values())}disconnectedCallback(){super.disconnectedCallback();for(const listenerId of this.helpBubbleListenerIds_){this.helpBubbleCallbackRouter_.removeListener(listenerId)}this.helpBubbleListenerIds_=[];assert(this.helpBubbleResizeObserver_);this.helpBubbleResizeObserver_.disconnect();this.helpBubbleResizeObserver_=null;assert(this.helpBubbleFixedAnchorObserver_);this.helpBubbleFixedAnchorObserver_.disconnect();this.helpBubbleFixedAnchorObserver_=null;this.helpBubbleDismissedEventTracker_.removeAll();this.helpBubbleControllerById_.clear();if(this.debouncedAnchorMayHaveChangedCallback_){document.removeEventListener("scroll",this.debouncedAnchorMayHaveChangedCallback_);this.debouncedAnchorMayHaveChangedCallback_=null}}registerHelpBubble(nativeId,trackable,options={}){if(this.helpBubbleControllerById_.has(nativeId)){const ctrl=this.helpBubbleControllerById_.get(nativeId);if(ctrl&&ctrl.isBubbleShowing()){return null}this.unregisterHelpBubble(nativeId)}const controller=new HelpBubbleController(nativeId,this.shadowRoot);controller.track(trackable,parseOptions(options));this.helpBubbleControllerById_.set(nativeId,controller);if(this.helpBubbleResizeObserver_){this.observeControllerAnchor_(controller)}return controller}unregisterHelpBubble(nativeId){const ctrl=this.helpBubbleControllerById_.get(nativeId);if(ctrl&&ctrl.hasAnchor()){this.onAnchorVisibilityChanged_(ctrl.getAnchor(),false);this.unobserveControllerAnchor_(ctrl)}this.helpBubbleControllerById_.delete(nativeId)}observeControllerAnchor_(controller){const anchor=controller.getAnchor();assert(anchor,"Help bubble does not have anchor");if(controller.isAnchorFixed()){assert(this.helpBubbleFixedAnchorObserver_);this.helpBubbleFixedAnchorObserver_.observe(anchor)}else{assert(this.helpBubbleResizeObserver_);this.helpBubbleResizeObserver_.observe(anchor)}}unobserveControllerAnchor_(controller){const anchor=controller.getAnchor();assert(anchor,"Help bubble does not have anchor");if(controller.isAnchorFixed()){assert(this.helpBubbleFixedAnchorObserver_);this.helpBubbleFixedAnchorObserver_.unobserve(anchor)}else{assert(this.helpBubbleResizeObserver_);this.helpBubbleResizeObserver_.unobserve(anchor)}}isHelpBubbleShowing(){return this.controllers.some((ctrl=>ctrl.isBubbleShowing()))}isHelpBubbleShowingForTesting(id){const ctrls=this.controllers.filter(this.filterMatchingIdForTesting_(id));return!!ctrls[0]}getHelpBubbleForTesting(id){const ctrls=this.controllers.filter(this.filterMatchingIdForTesting_(id));return ctrls[0]?ctrls[0].getBubble():null}filterMatchingIdForTesting_(anchorId){return ctrl=>ctrl.isBubbleShowing()&&ctrl.getAnchor()!==null&&ctrl.getAnchor().id===anchorId}getSortedAnchorStatusesForTesting(){return this.controllers.sort(((a,b)=>a.getNativeId().localeCompare(b.getNativeId()))).map((ctrl=>[ctrl.getNativeId(),ctrl.hasAnchor()]))}canShowHelpBubble(controller){if(!this.helpBubbleControllerById_.has(controller.getNativeId())){return false}if(!controller.canShowBubble()){return false}const anchor=controller.getAnchor();const anchorIsUsed=this.controllers.some((otherCtrl=>otherCtrl.isBubbleShowing()&&otherCtrl.getAnchor()===anchor));return!anchorIsUsed}showHelpBubble(controller,params){assert(this.canShowHelpBubble(controller),"Can't show help bubble");const bubble=controller.createBubble(params);this.helpBubbleDismissedEventTracker_.add(bubble,HELP_BUBBLE_DISMISSED_EVENT,this.onHelpBubbleDismissed_.bind(this));this.helpBubbleDismissedEventTracker_.add(bubble,HELP_BUBBLE_TIMED_OUT_EVENT,this.onHelpBubbleTimedOut_.bind(this));controller.show()}hideHelpBubble(nativeId){const ctrl=this.helpBubbleControllerById_.get(nativeId);if(!ctrl||!ctrl.hasBubble()){return false}this.helpBubbleDismissedEventTracker_.remove(ctrl.getBubble(),HELP_BUBBLE_DISMISSED_EVENT);this.helpBubbleDismissedEventTracker_.remove(ctrl.getBubble(),HELP_BUBBLE_TIMED_OUT_EVENT);ctrl.hide();return true}notifyHelpBubbleAnchorActivated(nativeId){const ctrl=this.helpBubbleControllerById_.get(nativeId);if(!ctrl||!ctrl.isBubbleShowing()){return false}this.trackedElementHandler_.trackedElementActivated(nativeId);return true}notifyHelpBubbleAnchorCustomEvent(nativeId,customEvent){const ctrl=this.helpBubbleControllerById_.get(nativeId);if(!ctrl||!ctrl.isBubbleShowing()){return false}this.trackedElementHandler_.trackedElementCustomEvent(nativeId,customEvent);return true}onAnchorVisibilityChanged_(target,isVisible){const nativeId=target.dataset["nativeId"];assert(nativeId);const ctrl=this.helpBubbleControllerById_.get(nativeId);const hidden=this.hideHelpBubble(nativeId);if(hidden){this.helpBubbleHandler_.helpBubbleClosed(nativeId,HelpBubbleClosedReason.kPageChanged)}const bounds=isVisible?this.getElementBounds_(target):{x:0,y:0,width:0,height:0};if(!ctrl||ctrl.updateAnchorVisibility(isVisible,bounds)){this.trackedElementHandler_.trackedElementVisibilityChanged(nativeId,isVisible,bounds)}}onAnchorBoundsMayHaveChanged_(){for(const ctrl of this.controllers){if(ctrl.hasAnchor()&&ctrl.getAnchorVisibility()){const bounds=this.getElementBounds_(ctrl.getAnchor());if(ctrl.updateAnchorVisibility(true,bounds)){this.trackedElementHandler_.trackedElementVisibilityChanged(ctrl.getNativeId(),true,bounds)}}}}getElementBounds_(element){const rect={x:0,y:0,width:0,height:0};const bounds=element.getBoundingClientRect();rect.x=bounds.x;rect.y=bounds.y;rect.width=bounds.width;rect.height=bounds.height;const nativeId=element.dataset["nativeId"];if(!nativeId){return rect}const ctrl=this.helpBubbleControllerById_.get(nativeId);if(ctrl){const padding=ctrl.getPadding();rect.x-=padding.left;rect.y-=padding.top;rect.width+=padding.left+padding.right;rect.height+=padding.top+padding.bottom}return rect}onShowHelpBubble_(params){if(!this.helpBubbleControllerById_.has(params.nativeIdentifier)){return}const ctrl=this.helpBubbleControllerById_.get(params.nativeIdentifier);this.showHelpBubble(ctrl,params)}onToggleHelpBubbleFocusForAccessibility_(nativeId){if(!this.helpBubbleControllerById_.has(nativeId)){return}const ctrl=this.helpBubbleControllerById_.get(nativeId);if(ctrl){const anchor=ctrl.getAnchor();if(anchor){anchor.focus()}}}onHideHelpBubble_(nativeId){this.hideHelpBubble(nativeId)}onExternalHelpBubbleUpdated_(nativeId,shown){if(!this.helpBubbleControllerById_.has(nativeId)){return}const ctrl=this.helpBubbleControllerById_.get(nativeId);ctrl.updateExternalShowingStatus(shown)}onHelpBubbleDismissed_(e){const nativeId=e.detail.nativeId;assert(nativeId);const hidden=this.hideHelpBubble(nativeId);assert(hidden);if(nativeId){if(e.detail.fromActionButton){this.helpBubbleHandler_.helpBubbleButtonPressed(nativeId,e.detail.buttonIndex)}else{this.helpBubbleHandler_.helpBubbleClosed(nativeId,HelpBubbleClosedReason.kDismissedByUser)}}}onHelpBubbleTimedOut_(e){const nativeId=e.detail.nativeId;const ctrl=this.helpBubbleControllerById_.get(nativeId);assert(ctrl);const hidden=this.hideHelpBubble(nativeId);assert(hidden);if(nativeId){this.helpBubbleHandler_.helpBubbleClosed(nativeId,HelpBubbleClosedReason.kTimedOut)}}}return HelpBubbleMixin}));export function parseOptions(options){const padding={top:0,bottom:0,left:0,right:0};padding.top=clampPadding(options.anchorPaddingTop);padding.left=clampPadding(options.anchorPaddingLeft);padding.bottom=clampPadding(options.anchorPaddingBottom);padding.right=clampPadding(options.anchorPaddingRight);return{padding:padding,fixed:!!options.fixed}}function clampPadding(n=0){return Math.max(0,Math.min(20,n))}