// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{getFaviconUrl}from"//resources/js/icon.js";import{loadTimeData}from"//resources/js/load_time_data.js";import{CrLitElement}from"//resources/lit/v3_0/lit.rollup.js";import{getCss}from"./searchbox_icon.css.js";import{getHtml}from"./searchbox_icon.html.js";const CALCULATOR="search-calculator-answer";const DOCUMENT_MATCH_TYPE="document";const FEATURED_ENTERPRISE_SEARCH="featured-enterprise-search";const HISTORY_CLUSTER_MATCH_TYPE="history-cluster";const PEDAL="pedal";const STARTER_PACK="starter-pack";export class SearchboxIconElement extends CrLitElement{static get is(){return"cr-searchbox-icon"}static get styles(){return getCss()}render(){return getHtml.bind(this)()}static get properties(){return{defaultIcon:{type:String},hasIconContainerBackground:{type:Boolean,reflect:true},inSearchbox:{type:Boolean,reflect:true},isAnswer:{type:Boolean,reflect:true},isStarterPack:{type:Boolean,reflect:true},isFeaturedEnterpriseSearch:{type:Boolean,reflect:true},isWeatherAnswer:{type:Boolean,reflect:true},isEnterpriseSearchAggregatorPeopleType:{type:Boolean,reflect:true},maskImage:{type:String,reflect:true},match:{type:Object},faviconImage_:{type:String,reflect:true},faviconImageSrcSet_:{state:true,type:String},hasImage_:{type:Boolean,reflect:true},showFaviconImage_:{state:true,type:Boolean},faviconLoading_:{state:true,type:Boolean},faviconError_:{state:true,type:Boolean},iconSrc_:{state:true,type:String},iconLoading_:{state:true,type:Boolean},showIconImg_:{state:true,type:Boolean},showImage_:{state:true,type:Boolean},imageSrc_:{state:true,type:String},imageLoading_:{state:true,type:Boolean},imageError_:{state:true,type:Boolean},isTopChromeSearchbox_:{state:true,type:Boolean},isLensSearchbox_:{type:Boolean,reflect:true}}}#defaultIcon_accessor_storage="";get defaultIcon(){return this.#defaultIcon_accessor_storage}set defaultIcon(value){this.#defaultIcon_accessor_storage=value}#hasIconContainerBackground_accessor_storage=false;get hasIconContainerBackground(){return this.#hasIconContainerBackground_accessor_storage}set hasIconContainerBackground(value){this.#hasIconContainerBackground_accessor_storage=value}#inSearchbox_accessor_storage=false;get inSearchbox(){return this.#inSearchbox_accessor_storage}set inSearchbox(value){this.#inSearchbox_accessor_storage=value}#isAnswer_accessor_storage=false;get isAnswer(){return this.#isAnswer_accessor_storage}set isAnswer(value){this.#isAnswer_accessor_storage=value}#isStarterPack_accessor_storage=false;get isStarterPack(){return this.#isStarterPack_accessor_storage}set isStarterPack(value){this.#isStarterPack_accessor_storage=value}#isFeaturedEnterpriseSearch_accessor_storage=false;get isFeaturedEnterpriseSearch(){return this.#isFeaturedEnterpriseSearch_accessor_storage}set isFeaturedEnterpriseSearch(value){this.#isFeaturedEnterpriseSearch_accessor_storage=value}#isWeatherAnswer_accessor_storage=false;get isWeatherAnswer(){return this.#isWeatherAnswer_accessor_storage}set isWeatherAnswer(value){this.#isWeatherAnswer_accessor_storage=value}#isEnterpriseSearchAggregatorPeopleType_accessor_storage=false;get isEnterpriseSearchAggregatorPeopleType(){return this.#isEnterpriseSearchAggregatorPeopleType_accessor_storage}set isEnterpriseSearchAggregatorPeopleType(value){this.#isEnterpriseSearchAggregatorPeopleType_accessor_storage=value}#maskImage_accessor_storage="";get maskImage(){return this.#maskImage_accessor_storage}set maskImage(value){this.#maskImage_accessor_storage=value}#match_accessor_storage=null;get match(){return this.#match_accessor_storage}set match(value){this.#match_accessor_storage=value}#faviconImage__accessor_storage="";get faviconImage_(){return this.#faviconImage__accessor_storage}set faviconImage_(value){this.#faviconImage__accessor_storage=value}#faviconImageSrcSet__accessor_storage="";get faviconImageSrcSet_(){return this.#faviconImageSrcSet__accessor_storage}set faviconImageSrcSet_(value){this.#faviconImageSrcSet__accessor_storage=value}#hasImage__accessor_storage=false;get hasImage_(){return this.#hasImage__accessor_storage}set hasImage_(value){this.#hasImage__accessor_storage=value}#showFaviconImage__accessor_storage=false;get showFaviconImage_(){return this.#showFaviconImage__accessor_storage}set showFaviconImage_(value){this.#showFaviconImage__accessor_storage=value}#faviconLoading__accessor_storage=false;get faviconLoading_(){return this.#faviconLoading__accessor_storage}set faviconLoading_(value){this.#faviconLoading__accessor_storage=value}#faviconError__accessor_storage=false;get faviconError_(){return this.#faviconError__accessor_storage}set faviconError_(value){this.#faviconError__accessor_storage=value}#iconSrc__accessor_storage="";get iconSrc_(){return this.#iconSrc__accessor_storage}set iconSrc_(value){this.#iconSrc__accessor_storage=value}#iconLoading__accessor_storage=false;get iconLoading_(){return this.#iconLoading__accessor_storage}set iconLoading_(value){this.#iconLoading__accessor_storage=value}#showIconImg__accessor_storage=false;get showIconImg_(){return this.#showIconImg__accessor_storage}set showIconImg_(value){this.#showIconImg__accessor_storage=value}#showImage__accessor_storage=false;get showImage_(){return this.#showImage__accessor_storage}set showImage_(value){this.#showImage__accessor_storage=value}#imageSrc__accessor_storage="";get imageSrc_(){return this.#imageSrc__accessor_storage}set imageSrc_(value){this.#imageSrc__accessor_storage=value}#imageLoading__accessor_storage=false;get imageLoading_(){return this.#imageLoading__accessor_storage}set imageLoading_(value){this.#imageLoading__accessor_storage=value}#imageError__accessor_storage=false;get imageError_(){return this.#imageError__accessor_storage}set imageError_(value){this.#imageError__accessor_storage=value}#isTopChromeSearchbox__accessor_storage=loadTimeData.getBoolean("isTopChromeSearchbox");get isTopChromeSearchbox_(){return this.#isTopChromeSearchbox__accessor_storage}set isTopChromeSearchbox_(value){this.#isTopChromeSearchbox__accessor_storage=value}#isLensSearchbox__accessor_storage=loadTimeData.getBoolean("isLensSearchbox");get isLensSearchbox_(){return this.#isLensSearchbox__accessor_storage}set isLensSearchbox_(value){this.#isLensSearchbox__accessor_storage=value}willUpdate(changedProperties){super.willUpdate(changedProperties);if(changedProperties.has("match")){this.iconSrc_=this.computeIconSrc_();this.imageSrc_=this.computeImageSrc_();this.isAnswer=this.computeIsAnswer_();this.isEnterpriseSearchAggregatorPeopleType=this.computeIsEnterpriseSearchAggregatorPeopleType_();this.isStarterPack=this.computeIsStarterPack_();this.isFeaturedEnterpriseSearch=this.computeIsFeaturedEnterpriseSearch();this.isWeatherAnswer=this.computeIsWeatherAnswer_();this.hasImage_=this.computeHasImage_();this.maskImage=this.computeMaskImage_()}if(changedProperties.has("match")||changedProperties.has("isWeatherAnswer")){this.hasIconContainerBackground=this.computeHasIconContainerBackground_()}const changedPrivateProperties=changedProperties;if(changedProperties.has("match")||changedProperties.has("defaultIcon")||changedPrivateProperties.has("isTopChromeSearchbox_")){this.faviconImage_=this.computeFaviconImage_()}if(changedProperties.has("match")||changedPrivateProperties.has("faviconImage_")||changedPrivateProperties.has("isTopChromeSearchbox_")){this.faviconImageSrcSet_=this.computeFaviconImageSrcSet_()}if(changedPrivateProperties.has("faviconImage_")){this.faviconLoading_=!!this.faviconImage_;this.faviconError_=false}if(changedProperties.has("match")||changedPrivateProperties.has("isLensSearchbox_")||changedPrivateProperties.has("faviconImage_")||changedPrivateProperties.has("faviconLoading_")||changedPrivateProperties.has("faviconError_")){this.showFaviconImage_=this.computeShowFaviconImage_()}if(changedPrivateProperties.has("iconSrc_")){this.iconLoading_=!!this.iconSrc_}if(changedPrivateProperties.has("imageSrc_")){this.imageLoading_=!!this.imageSrc_;this.imageError_=false}if(changedPrivateProperties.has("imageSrc_")||changedPrivateProperties.has("imageError_")){this.showImage_=this.computeShowImage_()}if(changedProperties.has("match")||changedPrivateProperties.has("isLensSearchbox_")||changedPrivateProperties.has("iconLoading_")){this.showIconImg_=this.computeShowIconImg_()}}computeFaviconUrl_(scaleFactor){if(!this.match?.destinationUrl.url){return""}return getFaviconUrl(this.match.destinationUrl.url,{forceLightMode:!this.isTopChromeSearchbox_,ignoreCache:true,forceEmptyDefaultFavicon:true,scaleFactor:`${scaleFactor}x`})}computeFaviconImageSrcSet_(){if(!this.faviconImage_.startsWith("chrome://favicon2/")){return""}return[`${this.computeFaviconUrl_(1)} 1x`,`${this.computeFaviconUrl_(2)} 2x`].join(", ")}computeFaviconImage_(){if(this.match&&!this.match.isSearchType){if(this.match.type===DOCUMENT_MATCH_TYPE||this.match.type===PEDAL||this.match.isEnterpriseSearchAggregatorPeopleType){return this.match.iconPath}if(this.match.type!==HISTORY_CLUSTER_MATCH_TYPE&&this.match.type!==FEATURED_ENTERPRISE_SEARCH){return this.computeFaviconUrl_(1)}}if(this.defaultIcon==="//resources/cr_components/searchbox/icons/google_g.svg"||this.defaultIcon==="//resources/cr_components/searchbox/icons/google_g_gradient.svg"){return this.defaultIcon}return""}computeIsAnswer_(){return!!this.match&&!!this.match.answer}computeIsWeatherAnswer_(){return this.match?.isWeatherAnswerSuggestion||false}computeHasImage_(){return!!this.match&&!!this.match.imageUrl}computeIsEnterpriseSearchAggregatorPeopleType_(){return this.match?.isEnterpriseSearchAggregatorPeopleType||false}computeShowIconImg_(){return!this.isLensSearchbox_&&!!this.match&&!!this.match.iconUrl.url&&!this.iconLoading_}computeMaskImage_(){if(this.isLensSearchbox_&&this.inSearchbox){return`url(${this.defaultIcon})`}if(this.match&&(!this.match.isRichSuggestion||this.match.type===STARTER_PACK||this.match.type===FEATURED_ENTERPRISE_SEARCH||this.match.isEnterpriseSearchAggregatorPeopleType||!this.inSearchbox)){return`url(${this.match.iconPath})`}else{return`url(${this.defaultIcon})`}}computeShowFaviconImage_(){if(!this.faviconImage_){return false}if(this.faviconLoading_||this.faviconError_){return false}if(!this.isLensSearchbox_&&this.match&&!this.match.isSearchType&&this.match.type!==STARTER_PACK&&this.match.type!==PEDAL){return true}const themedIcons=["calendar","drive_docs","drive_folder","drive_form","drive_image","drive_logo","drive_pdf","drive_sheets","drive_slides","drive_video","google_agentspace_logo","google_agentspace_logo_25","google_g","google_g_gradient","note","sites"];for(const icon of themedIcons){if(this.faviconImage_==="//resources/cr_components/searchbox/icons/"+icon+".svg"){return true}}return false}computeSrc_(url){if(!url){return""}if(url.startsWith("data:image/")){return url}return`//image?staticEncode=true&encodeType=webp&url=${url}`}computeIconSrc_(){return this.computeSrc_(this.match?.iconUrl?.url)}computeShowImage_(){return!!this.imageSrc_&&!this.imageError_}computeImageSrc_(){return this.computeSrc_(this.match?.imageUrl)}getContainerBgColor_(){return(this.imageLoading_||this.imageError_)&&this.match?.imageDominantColor?this.match.imageDominantColor?`${this.match.imageDominantColor}40`:"var(--cr-searchbox-match-icon-container-background-fallback)":"transparent"}onFaviconLoad_(){this.faviconLoading_=false;this.faviconError_=false}onFaviconError_(){this.faviconLoading_=false;this.faviconError_=true}onIconLoad_(){this.iconLoading_=false}onImageLoad_(){this.imageLoading_=false;this.imageError_=false}onImageError_(){this.imageLoading_=false;this.imageError_=true}computeHasIconContainerBackground_(){if(this.match){return this.match.type===PEDAL||this.match.type===HISTORY_CLUSTER_MATCH_TYPE||this.match.type===CALCULATOR||this.match.type===STARTER_PACK||this.match.type===FEATURED_ENTERPRISE_SEARCH||!!this.match.answer&&!this.isWeatherAnswer}return false}computeIsStarterPack_(){return this.match?.type===STARTER_PACK}computeIsFeaturedEnterpriseSearch(){return this.match?.type===FEATURED_ENTERPRISE_SEARCH}}customElements.define(SearchboxIconElement.is,SearchboxIconElement);