// Copyright 2017 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"./cr_tooltip_icon.js";import{assertNotReached}from"//resources/js/assert.js";import{CrLitElement}from"//resources/lit/v3_0/lit.rollup.js";import{getCss}from"./cr_policy_indicator.css.js";import{getHtml}from"./cr_policy_indicator.html.js";import{CrPolicyIndicatorType}from"./cr_policy_types.js";export class CrPolicyIndicatorElement extends CrLitElement{static get is(){return"cr-policy-indicator"}static get styles(){return getCss()}render(){return getHtml.bind(this)()}static get properties(){return{iconAriaLabel:{type:String},indicatorType:{type:String},indicatorSourceName:{type:String}}}#iconAriaLabel_accessor_storage="";get iconAriaLabel(){return this.#iconAriaLabel_accessor_storage}set iconAriaLabel(value){this.#iconAriaLabel_accessor_storage=value}#indicatorType_accessor_storage=CrPolicyIndicatorType.NONE;get indicatorType(){return this.#indicatorType_accessor_storage}set indicatorType(value){this.#indicatorType_accessor_storage=value}#indicatorSourceName_accessor_storage="";get indicatorSourceName(){return this.#indicatorSourceName_accessor_storage}set indicatorSourceName(value){this.#indicatorSourceName_accessor_storage=value}getIndicatorVisible_(){return this.indicatorType!==CrPolicyIndicatorType.NONE}getIndicatorIcon_(){switch(this.indicatorType){case CrPolicyIndicatorType.EXTENSION:return"cr:extension";case CrPolicyIndicatorType.NONE:return"";case CrPolicyIndicatorType.PRIMARY_USER:return"cr:group";case CrPolicyIndicatorType.OWNER:return"cr:person";case CrPolicyIndicatorType.USER_POLICY:case CrPolicyIndicatorType.DEVICE_POLICY:case CrPolicyIndicatorType.RECOMMENDED:return"cr20:domain";case CrPolicyIndicatorType.PARENT:case CrPolicyIndicatorType.CHILD_RESTRICTION:return"cr20:kite";default:assertNotReached()}}getIndicatorTooltip_(){if(!window.CrPolicyStrings){return""}const CrPolicyStrings=window.CrPolicyStrings;switch(this.indicatorType){case CrPolicyIndicatorType.EXTENSION:return this.indicatorSourceName.length>0?CrPolicyStrings.controlledSettingExtension.replace("$1",this.indicatorSourceName):CrPolicyStrings.controlledSettingExtensionWithoutName;case CrPolicyIndicatorType.PRIMARY_USER:return CrPolicyStrings.controlledSettingShared.replace("$1",this.indicatorSourceName);case CrPolicyIndicatorType.OWNER:return this.indicatorSourceName.length>0?CrPolicyStrings.controlledSettingWithOwner.replace("$1",this.indicatorSourceName):CrPolicyStrings.controlledSettingNoOwner;case CrPolicyIndicatorType.USER_POLICY:case CrPolicyIndicatorType.DEVICE_POLICY:return CrPolicyStrings.controlledSettingPolicy;case CrPolicyIndicatorType.RECOMMENDED:return CrPolicyStrings.controlledSettingRecommendedDiffers;case CrPolicyIndicatorType.PARENT:return CrPolicyStrings.controlledSettingParent;case CrPolicyIndicatorType.CHILD_RESTRICTION:return CrPolicyStrings.controlledSettingChildRestriction}return""}}customElements.define(CrPolicyIndicatorElement.is,CrPolicyIndicatorElement);