// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const scriptPolicy=window.trustedTypes.createPolicy("webui-test-script",{createHTML:()=>"",createScriptURL:urlString=>{const url=new URL(window.location.href);if(["chrome:","chrome-untrusted:"].includes(url.protocol)&&urlString.startsWith("//")){return urlString}console.error(`Invalid test URL ${urlString} found.`);return""},createScript:()=>""});function loadScript(url){return new Promise(((resolve,reject)=>{const script=document.createElement("script");script.type="module";script.src=scriptPolicy.createScriptURL(url);script.onerror=function(){reject(new Error(`test_loader_util: Failed to load ${url}`))};script.onload=function(){resolve()};document.body.appendChild(script)}))}export async function loadTestModule(){const params=new URLSearchParams(window.location.search);const module=params.get("module");if(!module){return Promise.resolve(false)}await loadScript(`//webui-test/${module}`);return Promise.resolve(true)}export async function loadMochaAdapter(){const params=new URLSearchParams(window.location.search);const adapter=params.get("adapter")||"chromeos/mocha_adapter.js";if(!["mocha_adapter_simple.js","chromeos/mocha_adapter.js"].includes(adapter)){return Promise.reject(new Error(`Invalid adapter=${adapter} parameter`))}await loadScript(`//webui-test/${adapter}`);return Promise.resolve(true)}