// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{mojo}from"//resources/mojo/mojo/public/js/bindings.js";export const AuthFactorSpec={$:mojo.internal.Enum()};export var AuthFactor;(function(AuthFactor){AuthFactor[AuthFactor["MIN_VALUE"]=0]="MIN_VALUE";AuthFactor[AuthFactor["MAX_VALUE"]=5]="MAX_VALUE";AuthFactor[AuthFactor["kRecovery"]=0]="kRecovery";AuthFactor[AuthFactor["kPrefBasedPin"]=1]="kPrefBasedPin";AuthFactor[AuthFactor["kCryptohomePin"]=2]="kCryptohomePin";AuthFactor[AuthFactor["kCryptohomePinV2"]=3]="kCryptohomePinV2";AuthFactor[AuthFactor["kGaiaPassword"]=4]="kGaiaPassword";AuthFactor[AuthFactor["kLocalPassword"]=5]="kLocalPassword"})(AuthFactor||(AuthFactor={}));export const ManagementTypeSpec={$:mojo.internal.Enum()};export var ManagementType;(function(ManagementType){ManagementType[ManagementType["MIN_VALUE"]=0]="MIN_VALUE";ManagementType[ManagementType["MAX_VALUE"]=3]="MAX_VALUE";ManagementType[ManagementType["kNone"]=0]="kNone";ManagementType[ManagementType["kDevice"]=1]="kDevice";ManagementType[ManagementType["kUser"]=2]="kUser";ManagementType[ManagementType["kChildRestriction"]=3]="kChildRestriction"})(ManagementType||(ManagementType={}));export const ConfigureResultSpec={$:mojo.internal.Enum()};export var ConfigureResult;(function(ConfigureResult){ConfigureResult[ConfigureResult["MIN_VALUE"]=0]="MIN_VALUE";ConfigureResult[ConfigureResult["MAX_VALUE"]=2]="MAX_VALUE";ConfigureResult[ConfigureResult["kSuccess"]=0]="kSuccess";ConfigureResult[ConfigureResult["kInvalidTokenError"]=1]="kInvalidTokenError";ConfigureResult[ConfigureResult["kFatalError"]=2]="kFatalError"})(ConfigureResult||(ConfigureResult={}));export const PasswordComplexitySpec={$:mojo.internal.Enum()};export var PasswordComplexity;(function(PasswordComplexity){PasswordComplexity[PasswordComplexity["MIN_VALUE"]=0]="MIN_VALUE";PasswordComplexity[PasswordComplexity["MAX_VALUE"]=1]="MAX_VALUE";PasswordComplexity[PasswordComplexity["kOk"]=0]="kOk";PasswordComplexity[PasswordComplexity["kTooShort"]=1]="kTooShort"})(PasswordComplexity||(PasswordComplexity={}));export class FactorObserverPendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"ash.auth.mojom.FactorObserver",scope)}}export class FactorObserverRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(FactorObserverPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}onFactorChanged(factor){this.proxy.sendMessage(0,FactorObserver_OnFactorChanged_ParamsSpec.$,null,[factor],false)}}export class FactorObserverReceiver{helper_internal_;$;onConnectionError;constructor(impl){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(FactorObserverRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.helper_internal_.registerHandler(0,FactorObserver_OnFactorChanged_ParamsSpec.$,null,impl.onFactorChanged.bind(impl),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}}export class FactorObserver{static get $interfaceName(){return"ash.auth.mojom.FactorObserver"}static getRemote(){let remote=new FactorObserverRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}export class FactorObserverCallbackRouter{helper_internal_;$;router_;onFactorChanged;onConnectionError;constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(FactorObserverRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.onFactorChanged=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,FactorObserver_OnFactorChanged_ParamsSpec.$,null,this.onFactorChanged.createReceiverHandler(false),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}export class AuthFactorConfigPendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"ash.auth.mojom.AuthFactorConfig",scope)}}export class AuthFactorConfigRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(AuthFactorConfigPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}observeFactorChanges(observer){this.proxy.sendMessage(0,AuthFactorConfig_ObserveFactorChanges_ParamsSpec.$,null,[observer],false)}isSupported(authToken,factor){return this.proxy.sendMessage(1,AuthFactorConfig_IsSupported_ParamsSpec.$,AuthFactorConfig_IsSupported_ResponseParamsSpec.$,[authToken,factor],false)}isConfigured(authToken,factor){return this.proxy.sendMessage(2,AuthFactorConfig_IsConfigured_ParamsSpec.$,AuthFactorConfig_IsConfigured_ResponseParamsSpec.$,[authToken,factor],false)}getManagementType(authToken,factor){return this.proxy.sendMessage(3,AuthFactorConfig_GetManagementType_ParamsSpec.$,AuthFactorConfig_GetManagementType_ResponseParamsSpec.$,[authToken,factor],false)}isEditable(authToken,factor){return this.proxy.sendMessage(4,AuthFactorConfig_IsEditable_ParamsSpec.$,AuthFactorConfig_IsEditable_ResponseParamsSpec.$,[authToken,factor],false)}}export class AuthFactorConfigReceiver{helper_internal_;$;onConnectionError;constructor(impl){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(AuthFactorConfigRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.helper_internal_.registerHandler(0,AuthFactorConfig_ObserveFactorChanges_ParamsSpec.$,null,impl.observeFactorChanges.bind(impl),false);this.helper_internal_.registerHandler(1,AuthFactorConfig_IsSupported_ParamsSpec.$,AuthFactorConfig_IsSupported_ResponseParamsSpec.$,impl.isSupported.bind(impl),false);this.helper_internal_.registerHandler(2,AuthFactorConfig_IsConfigured_ParamsSpec.$,AuthFactorConfig_IsConfigured_ResponseParamsSpec.$,impl.isConfigured.bind(impl),false);this.helper_internal_.registerHandler(3,AuthFactorConfig_GetManagementType_ParamsSpec.$,AuthFactorConfig_GetManagementType_ResponseParamsSpec.$,impl.getManagementType.bind(impl),false);this.helper_internal_.registerHandler(4,AuthFactorConfig_IsEditable_ParamsSpec.$,AuthFactorConfig_IsEditable_ResponseParamsSpec.$,impl.isEditable.bind(impl),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}}export class AuthFactorConfig{static get $interfaceName(){return"ash.auth.mojom.AuthFactorConfig"}static getRemote(){let remote=new AuthFactorConfigRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}export class AuthFactorConfigCallbackRouter{helper_internal_;$;router_;observeFactorChanges;isSupported;isConfigured;getManagementType;isEditable;onConnectionError;constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(AuthFactorConfigRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.observeFactorChanges=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,AuthFactorConfig_ObserveFactorChanges_ParamsSpec.$,null,this.observeFactorChanges.createReceiverHandler(false),false);this.isSupported=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(1,AuthFactorConfig_IsSupported_ParamsSpec.$,AuthFactorConfig_IsSupported_ResponseParamsSpec.$,this.isSupported.createReceiverHandler(true),false);this.isConfigured=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(2,AuthFactorConfig_IsConfigured_ParamsSpec.$,AuthFactorConfig_IsConfigured_ResponseParamsSpec.$,this.isConfigured.createReceiverHandler(true),false);this.getManagementType=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(3,AuthFactorConfig_GetManagementType_ParamsSpec.$,AuthFactorConfig_GetManagementType_ResponseParamsSpec.$,this.getManagementType.createReceiverHandler(true),false);this.isEditable=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(4,AuthFactorConfig_IsEditable_ParamsSpec.$,AuthFactorConfig_IsEditable_ResponseParamsSpec.$,this.isEditable.createReceiverHandler(true),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}export class RecoveryFactorEditorPendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"ash.auth.mojom.RecoveryFactorEditor",scope)}}export class RecoveryFactorEditorRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(RecoveryFactorEditorPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}configure(authToken,enabled){return this.proxy.sendMessage(0,RecoveryFactorEditor_Configure_ParamsSpec.$,RecoveryFactorEditor_Configure_ResponseParamsSpec.$,[authToken,enabled],false)}}export class RecoveryFactorEditorReceiver{helper_internal_;$;onConnectionError;constructor(impl){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(RecoveryFactorEditorRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.helper_internal_.registerHandler(0,RecoveryFactorEditor_Configure_ParamsSpec.$,RecoveryFactorEditor_Configure_ResponseParamsSpec.$,impl.configure.bind(impl),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}}export class RecoveryFactorEditor{static get $interfaceName(){return"ash.auth.mojom.RecoveryFactorEditor"}static getRemote(){let remote=new RecoveryFactorEditorRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}export class RecoveryFactorEditorCallbackRouter{helper_internal_;$;router_;configure;onConnectionError;constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(RecoveryFactorEditorRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.configure=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,RecoveryFactorEditor_Configure_ParamsSpec.$,RecoveryFactorEditor_Configure_ResponseParamsSpec.$,this.configure.createReceiverHandler(true),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}export class PinFactorEditorPendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"ash.auth.mojom.PinFactorEditor",scope)}}export class PinFactorEditorRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(PinFactorEditorPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}setPin(authToken,pin){return this.proxy.sendMessage(0,PinFactorEditor_SetPin_ParamsSpec.$,PinFactorEditor_SetPin_ResponseParamsSpec.$,[authToken,pin],false)}updatePin(authToken,pin){return this.proxy.sendMessage(1,PinFactorEditor_UpdatePin_ParamsSpec.$,PinFactorEditor_UpdatePin_ResponseParamsSpec.$,[authToken,pin],false)}removePin(authToken){return this.proxy.sendMessage(2,PinFactorEditor_RemovePin_ParamsSpec.$,PinFactorEditor_RemovePin_ResponseParamsSpec.$,[authToken],false)}getConfiguredPinFactor(authToken){return this.proxy.sendMessage(3,PinFactorEditor_GetConfiguredPinFactor_ParamsSpec.$,PinFactorEditor_GetConfiguredPinFactor_ResponseParamsSpec.$,[authToken],false)}}export class PinFactorEditorReceiver{helper_internal_;$;onConnectionError;constructor(impl){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PinFactorEditorRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.helper_internal_.registerHandler(0,PinFactorEditor_SetPin_ParamsSpec.$,PinFactorEditor_SetPin_ResponseParamsSpec.$,impl.setPin.bind(impl),false);this.helper_internal_.registerHandler(1,PinFactorEditor_UpdatePin_ParamsSpec.$,PinFactorEditor_UpdatePin_ResponseParamsSpec.$,impl.updatePin.bind(impl),false);this.helper_internal_.registerHandler(2,PinFactorEditor_RemovePin_ParamsSpec.$,PinFactorEditor_RemovePin_ResponseParamsSpec.$,impl.removePin.bind(impl),false);this.helper_internal_.registerHandler(3,PinFactorEditor_GetConfiguredPinFactor_ParamsSpec.$,PinFactorEditor_GetConfiguredPinFactor_ResponseParamsSpec.$,impl.getConfiguredPinFactor.bind(impl),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}}export class PinFactorEditor{static get $interfaceName(){return"ash.auth.mojom.PinFactorEditor"}static getRemote(){let remote=new PinFactorEditorRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}export class PinFactorEditorCallbackRouter{helper_internal_;$;router_;setPin;updatePin;removePin;getConfiguredPinFactor;onConnectionError;constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PinFactorEditorRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.setPin=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,PinFactorEditor_SetPin_ParamsSpec.$,PinFactorEditor_SetPin_ResponseParamsSpec.$,this.setPin.createReceiverHandler(true),false);this.updatePin=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(1,PinFactorEditor_UpdatePin_ParamsSpec.$,PinFactorEditor_UpdatePin_ResponseParamsSpec.$,this.updatePin.createReceiverHandler(true),false);this.removePin=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(2,PinFactorEditor_RemovePin_ParamsSpec.$,PinFactorEditor_RemovePin_ResponseParamsSpec.$,this.removePin.createReceiverHandler(true),false);this.getConfiguredPinFactor=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(3,PinFactorEditor_GetConfiguredPinFactor_ParamsSpec.$,PinFactorEditor_GetConfiguredPinFactor_ResponseParamsSpec.$,this.getConfiguredPinFactor.createReceiverHandler(true),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}export class PasswordFactorEditorPendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"ash.auth.mojom.PasswordFactorEditor",scope)}}export class PasswordFactorEditorRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(PasswordFactorEditorPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}updateOrSetLocalPassword(authToken,newPassword){return this.proxy.sendMessage(0,PasswordFactorEditor_UpdateOrSetLocalPassword_ParamsSpec.$,PasswordFactorEditor_UpdateOrSetLocalPassword_ResponseParamsSpec.$,[authToken,newPassword],false)}updateOrSetOnlinePassword(authToken,newPassword){return this.proxy.sendMessage(1,PasswordFactorEditor_UpdateOrSetOnlinePassword_ParamsSpec.$,PasswordFactorEditor_UpdateOrSetOnlinePassword_ResponseParamsSpec.$,[authToken,newPassword],false)}setLocalPassword(authToken,newPassword){return this.proxy.sendMessage(2,PasswordFactorEditor_SetLocalPassword_ParamsSpec.$,PasswordFactorEditor_SetLocalPassword_ResponseParamsSpec.$,[authToken,newPassword],false)}setOnlinePassword(authToken,newPassword){return this.proxy.sendMessage(3,PasswordFactorEditor_SetOnlinePassword_ParamsSpec.$,PasswordFactorEditor_SetOnlinePassword_ResponseParamsSpec.$,[authToken,newPassword],false)}checkLocalPasswordComplexity(password){return this.proxy.sendMessage(4,PasswordFactorEditor_CheckLocalPasswordComplexity_ParamsSpec.$,PasswordFactorEditor_CheckLocalPasswordComplexity_ResponseParamsSpec.$,[password],false)}removePassword(authToken){return this.proxy.sendMessage(5,PasswordFactorEditor_RemovePassword_ParamsSpec.$,PasswordFactorEditor_RemovePassword_ResponseParamsSpec.$,[authToken],false)}}export class PasswordFactorEditorReceiver{helper_internal_;$;onConnectionError;constructor(impl){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PasswordFactorEditorRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.helper_internal_.registerHandler(0,PasswordFactorEditor_UpdateOrSetLocalPassword_ParamsSpec.$,PasswordFactorEditor_UpdateOrSetLocalPassword_ResponseParamsSpec.$,impl.updateOrSetLocalPassword.bind(impl),false);this.helper_internal_.registerHandler(1,PasswordFactorEditor_UpdateOrSetOnlinePassword_ParamsSpec.$,PasswordFactorEditor_UpdateOrSetOnlinePassword_ResponseParamsSpec.$,impl.updateOrSetOnlinePassword.bind(impl),false);this.helper_internal_.registerHandler(2,PasswordFactorEditor_SetLocalPassword_ParamsSpec.$,PasswordFactorEditor_SetLocalPassword_ResponseParamsSpec.$,impl.setLocalPassword.bind(impl),false);this.helper_internal_.registerHandler(3,PasswordFactorEditor_SetOnlinePassword_ParamsSpec.$,PasswordFactorEditor_SetOnlinePassword_ResponseParamsSpec.$,impl.setOnlinePassword.bind(impl),false);this.helper_internal_.registerHandler(4,PasswordFactorEditor_CheckLocalPasswordComplexity_ParamsSpec.$,PasswordFactorEditor_CheckLocalPasswordComplexity_ResponseParamsSpec.$,impl.checkLocalPasswordComplexity.bind(impl),false);this.helper_internal_.registerHandler(5,PasswordFactorEditor_RemovePassword_ParamsSpec.$,PasswordFactorEditor_RemovePassword_ResponseParamsSpec.$,impl.removePassword.bind(impl),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}}export class PasswordFactorEditor{static get $interfaceName(){return"ash.auth.mojom.PasswordFactorEditor"}static getRemote(){let remote=new PasswordFactorEditorRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}export class PasswordFactorEditorCallbackRouter{helper_internal_;$;router_;updateOrSetLocalPassword;updateOrSetOnlinePassword;setLocalPassword;setOnlinePassword;checkLocalPasswordComplexity;removePassword;onConnectionError;constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PasswordFactorEditorRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.updateOrSetLocalPassword=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,PasswordFactorEditor_UpdateOrSetLocalPassword_ParamsSpec.$,PasswordFactorEditor_UpdateOrSetLocalPassword_ResponseParamsSpec.$,this.updateOrSetLocalPassword.createReceiverHandler(true),false);this.updateOrSetOnlinePassword=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(1,PasswordFactorEditor_UpdateOrSetOnlinePassword_ParamsSpec.$,PasswordFactorEditor_UpdateOrSetOnlinePassword_ResponseParamsSpec.$,this.updateOrSetOnlinePassword.createReceiverHandler(true),false);this.setLocalPassword=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(2,PasswordFactorEditor_SetLocalPassword_ParamsSpec.$,PasswordFactorEditor_SetLocalPassword_ResponseParamsSpec.$,this.setLocalPassword.createReceiverHandler(true),false);this.setOnlinePassword=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(3,PasswordFactorEditor_SetOnlinePassword_ParamsSpec.$,PasswordFactorEditor_SetOnlinePassword_ResponseParamsSpec.$,this.setOnlinePassword.createReceiverHandler(true),false);this.checkLocalPasswordComplexity=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(4,PasswordFactorEditor_CheckLocalPasswordComplexity_ParamsSpec.$,PasswordFactorEditor_CheckLocalPasswordComplexity_ResponseParamsSpec.$,this.checkLocalPasswordComplexity.createReceiverHandler(true),false);this.removePassword=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(5,PasswordFactorEditor_RemovePassword_ParamsSpec.$,PasswordFactorEditor_RemovePassword_ResponseParamsSpec.$,this.removePassword.createReceiverHandler(true),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}export const FactorObserver_OnFactorChanged_ParamsSpec={$:{}};export const AuthFactorConfig_ObserveFactorChanges_ParamsSpec={$:{}};export const AuthFactorConfig_IsSupported_ParamsSpec={$:{}};export const AuthFactorConfig_IsSupported_ResponseParamsSpec={$:{}};export const AuthFactorConfig_IsConfigured_ParamsSpec={$:{}};export const AuthFactorConfig_IsConfigured_ResponseParamsSpec={$:{}};export const AuthFactorConfig_GetManagementType_ParamsSpec={$:{}};export const AuthFactorConfig_GetManagementType_ResponseParamsSpec={$:{}};export const AuthFactorConfig_IsEditable_ParamsSpec={$:{}};export const AuthFactorConfig_IsEditable_ResponseParamsSpec={$:{}};export const RecoveryFactorEditor_Configure_ParamsSpec={$:{}};export const RecoveryFactorEditor_Configure_ResponseParamsSpec={$:{}};export const PinFactorEditor_SetPin_ParamsSpec={$:{}};export const PinFactorEditor_SetPin_ResponseParamsSpec={$:{}};export const PinFactorEditor_UpdatePin_ParamsSpec={$:{}};export const PinFactorEditor_UpdatePin_ResponseParamsSpec={$:{}};export const PinFactorEditor_RemovePin_ParamsSpec={$:{}};export const PinFactorEditor_RemovePin_ResponseParamsSpec={$:{}};export const PinFactorEditor_GetConfiguredPinFactor_ParamsSpec={$:{}};export const PinFactorEditor_GetConfiguredPinFactor_ResponseParamsSpec={$:{}};export const PasswordFactorEditor_UpdateOrSetLocalPassword_ParamsSpec={$:{}};export const PasswordFactorEditor_UpdateOrSetLocalPassword_ResponseParamsSpec={$:{}};export const PasswordFactorEditor_UpdateOrSetOnlinePassword_ParamsSpec={$:{}};export const PasswordFactorEditor_UpdateOrSetOnlinePassword_ResponseParamsSpec={$:{}};export const PasswordFactorEditor_SetLocalPassword_ParamsSpec={$:{}};export const PasswordFactorEditor_SetLocalPassword_ResponseParamsSpec={$:{}};export const PasswordFactorEditor_SetOnlinePassword_ParamsSpec={$:{}};export const PasswordFactorEditor_SetOnlinePassword_ResponseParamsSpec={$:{}};export const PasswordFactorEditor_CheckLocalPasswordComplexity_ParamsSpec={$:{}};export const PasswordFactorEditor_CheckLocalPasswordComplexity_ResponseParamsSpec={$:{}};export const PasswordFactorEditor_RemovePassword_ParamsSpec={$:{}};export const PasswordFactorEditor_RemovePassword_ResponseParamsSpec={$:{}};mojo.internal.Struct(FactorObserver_OnFactorChanged_ParamsSpec.$,"FactorObserver_OnFactorChanged_Params",[mojo.internal.StructField("factor",0,0,AuthFactorSpec.$,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(AuthFactorConfig_ObserveFactorChanges_ParamsSpec.$,"AuthFactorConfig_ObserveFactorChanges_Params",[mojo.internal.StructField("observer",0,0,mojo.internal.InterfaceProxy(FactorObserverRemote),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(AuthFactorConfig_IsSupported_ParamsSpec.$,"AuthFactorConfig_IsSupported_Params",[mojo.internal.StructField("authToken",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("factor",8,0,AuthFactorSpec.$,0,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(AuthFactorConfig_IsSupported_ResponseParamsSpec.$,"AuthFactorConfig_IsSupported_ResponseParams",[mojo.internal.StructField("supported",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(AuthFactorConfig_IsConfigured_ParamsSpec.$,"AuthFactorConfig_IsConfigured_Params",[mojo.internal.StructField("authToken",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("factor",8,0,AuthFactorSpec.$,0,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(AuthFactorConfig_IsConfigured_ResponseParamsSpec.$,"AuthFactorConfig_IsConfigured_ResponseParams",[mojo.internal.StructField("configured",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(AuthFactorConfig_GetManagementType_ParamsSpec.$,"AuthFactorConfig_GetManagementType_Params",[mojo.internal.StructField("authToken",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("factor",8,0,AuthFactorSpec.$,0,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(AuthFactorConfig_GetManagementType_ResponseParamsSpec.$,"AuthFactorConfig_GetManagementType_ResponseParams",[mojo.internal.StructField("management",0,0,ManagementTypeSpec.$,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(AuthFactorConfig_IsEditable_ParamsSpec.$,"AuthFactorConfig_IsEditable_Params",[mojo.internal.StructField("authToken",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("factor",8,0,AuthFactorSpec.$,0,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(AuthFactorConfig_IsEditable_ResponseParamsSpec.$,"AuthFactorConfig_IsEditable_ResponseParams",[mojo.internal.StructField("editable",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(RecoveryFactorEditor_Configure_ParamsSpec.$,"RecoveryFactorEditor_Configure_Params",[mojo.internal.StructField("authToken",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("enabled",8,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(RecoveryFactorEditor_Configure_ResponseParamsSpec.$,"RecoveryFactorEditor_Configure_ResponseParams",[mojo.internal.StructField("result",0,0,ConfigureResultSpec.$,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PinFactorEditor_SetPin_ParamsSpec.$,"PinFactorEditor_SetPin_Params",[mojo.internal.StructField("authToken",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("pin",8,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(PinFactorEditor_SetPin_ResponseParamsSpec.$,"PinFactorEditor_SetPin_ResponseParams",[mojo.internal.StructField("result",0,0,ConfigureResultSpec.$,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PinFactorEditor_UpdatePin_ParamsSpec.$,"PinFactorEditor_UpdatePin_Params",[mojo.internal.StructField("authToken",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("pin",8,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(PinFactorEditor_UpdatePin_ResponseParamsSpec.$,"PinFactorEditor_UpdatePin_ResponseParams",[mojo.internal.StructField("result",0,0,ConfigureResultSpec.$,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PinFactorEditor_RemovePin_ParamsSpec.$,"PinFactorEditor_RemovePin_Params",[mojo.internal.StructField("authToken",0,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PinFactorEditor_RemovePin_ResponseParamsSpec.$,"PinFactorEditor_RemovePin_ResponseParams",[mojo.internal.StructField("result",0,0,ConfigureResultSpec.$,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PinFactorEditor_GetConfiguredPinFactor_ParamsSpec.$,"PinFactorEditor_GetConfiguredPinFactor_Params",[mojo.internal.StructField("authToken",0,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PinFactorEditor_GetConfiguredPinFactor_ResponseParamsSpec.$,"PinFactorEditor_GetConfiguredPinFactor_ResponseParams",[mojo.internal.StructField("pin_factor_$flag",0,0,mojo.internal.Bool,false,false,0,{isPrimary:true,linkedValueFieldName:"pin_factor_$value",originalFieldName:"pinFactor"},undefined),mojo.internal.StructField("pin_factor_$value",4,0,AuthFactorSpec.$,0,false,0,{isPrimary:false,originalFieldName:"pinFactor"},undefined)],[[0,16]]);mojo.internal.Struct(PasswordFactorEditor_UpdateOrSetLocalPassword_ParamsSpec.$,"PasswordFactorEditor_UpdateOrSetLocalPassword_Params",[mojo.internal.StructField("authToken",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("newPassword",8,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(PasswordFactorEditor_UpdateOrSetLocalPassword_ResponseParamsSpec.$,"PasswordFactorEditor_UpdateOrSetLocalPassword_ResponseParams",[mojo.internal.StructField("result",0,0,ConfigureResultSpec.$,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PasswordFactorEditor_UpdateOrSetOnlinePassword_ParamsSpec.$,"PasswordFactorEditor_UpdateOrSetOnlinePassword_Params",[mojo.internal.StructField("authToken",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("newPassword",8,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(PasswordFactorEditor_UpdateOrSetOnlinePassword_ResponseParamsSpec.$,"PasswordFactorEditor_UpdateOrSetOnlinePassword_ResponseParams",[mojo.internal.StructField("result",0,0,ConfigureResultSpec.$,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PasswordFactorEditor_SetLocalPassword_ParamsSpec.$,"PasswordFactorEditor_SetLocalPassword_Params",[mojo.internal.StructField("authToken",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("newPassword",8,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(PasswordFactorEditor_SetLocalPassword_ResponseParamsSpec.$,"PasswordFactorEditor_SetLocalPassword_ResponseParams",[mojo.internal.StructField("result",0,0,ConfigureResultSpec.$,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PasswordFactorEditor_SetOnlinePassword_ParamsSpec.$,"PasswordFactorEditor_SetOnlinePassword_Params",[mojo.internal.StructField("authToken",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("newPassword",8,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(PasswordFactorEditor_SetOnlinePassword_ResponseParamsSpec.$,"PasswordFactorEditor_SetOnlinePassword_ResponseParams",[mojo.internal.StructField("result",0,0,ConfigureResultSpec.$,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PasswordFactorEditor_CheckLocalPasswordComplexity_ParamsSpec.$,"PasswordFactorEditor_CheckLocalPasswordComplexity_Params",[mojo.internal.StructField("password",0,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PasswordFactorEditor_CheckLocalPasswordComplexity_ResponseParamsSpec.$,"PasswordFactorEditor_CheckLocalPasswordComplexity_ResponseParams",[mojo.internal.StructField("complexity",0,0,PasswordComplexitySpec.$,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PasswordFactorEditor_RemovePassword_ParamsSpec.$,"PasswordFactorEditor_RemovePassword_Params",[mojo.internal.StructField("authToken",0,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PasswordFactorEditor_RemovePassword_ResponseParamsSpec.$,"PasswordFactorEditor_RemovePassword_ResponseParams",[mojo.internal.StructField("result",0,0,ConfigureResultSpec.$,0,false,0,undefined,undefined)],[[0,16]]);