// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{mojo}from"//resources/mojo/mojo/public/js/bindings.js";export const HotspotStateSpec={$:mojo.internal.Enum()};export var HotspotState;(function(HotspotState){HotspotState[HotspotState["MIN_VALUE"]=0]="MIN_VALUE";HotspotState[HotspotState["MAX_VALUE"]=3]="MAX_VALUE";HotspotState[HotspotState["kDisabled"]=0]="kDisabled";HotspotState[HotspotState["kEnabled"]=1]="kEnabled";HotspotState[HotspotState["kEnabling"]=2]="kEnabling";HotspotState[HotspotState["kDisabling"]=3]="kDisabling"})(HotspotState||(HotspotState={}));export const WiFiSecurityModeSpec={$:mojo.internal.Enum()};export var WiFiSecurityMode;(function(WiFiSecurityMode){WiFiSecurityMode[WiFiSecurityMode["MIN_VALUE"]=0]="MIN_VALUE";WiFiSecurityMode[WiFiSecurityMode["MAX_VALUE"]=2]="MAX_VALUE";WiFiSecurityMode[WiFiSecurityMode["kWpa2"]=0]="kWpa2";WiFiSecurityMode[WiFiSecurityMode["kWpa3"]=1]="kWpa3";WiFiSecurityMode[WiFiSecurityMode["kWpa2Wpa3"]=2]="kWpa2Wpa3"})(WiFiSecurityMode||(WiFiSecurityMode={}));export const WiFiBandSpec={$:mojo.internal.Enum()};export var WiFiBand;(function(WiFiBand){WiFiBand[WiFiBand["MIN_VALUE"]=0]="MIN_VALUE";WiFiBand[WiFiBand["MAX_VALUE"]=1]="MAX_VALUE";WiFiBand[WiFiBand["k2_4GHz"]=0]="k2_4GHz";WiFiBand[WiFiBand["kAutoChoose"]=1]="kAutoChoose"})(WiFiBand||(WiFiBand={}));export const SetHotspotConfigResultSpec={$:mojo.internal.Enum()};export var SetHotspotConfigResult;(function(SetHotspotConfigResult){SetHotspotConfigResult[SetHotspotConfigResult["MIN_VALUE"]=0]="MIN_VALUE";SetHotspotConfigResult[SetHotspotConfigResult["MAX_VALUE"]=3]="MAX_VALUE";SetHotspotConfigResult[SetHotspotConfigResult["kSuccess"]=0]="kSuccess";SetHotspotConfigResult[SetHotspotConfigResult["kFailedNotLogin"]=1]="kFailedNotLogin";SetHotspotConfigResult[SetHotspotConfigResult["kFailedInvalidConfiguration"]=2]="kFailedInvalidConfiguration";SetHotspotConfigResult[SetHotspotConfigResult["kFailedShillOperation"]=3]="kFailedShillOperation"})(SetHotspotConfigResult||(SetHotspotConfigResult={}));export const HotspotAllowStatusSpec={$:mojo.internal.Enum()};export var HotspotAllowStatus;(function(HotspotAllowStatus){HotspotAllowStatus[HotspotAllowStatus["MIN_VALUE"]=0]="MIN_VALUE";HotspotAllowStatus[HotspotAllowStatus["MAX_VALUE"]=6]="MAX_VALUE";HotspotAllowStatus[HotspotAllowStatus["kDisallowedNoCellularUpstream"]=0]="kDisallowedNoCellularUpstream";HotspotAllowStatus[HotspotAllowStatus["kDisallowedNoWiFiDownstream"]=1]="kDisallowedNoWiFiDownstream";HotspotAllowStatus[HotspotAllowStatus["kDisallowedNoWiFiSecurityModes"]=2]="kDisallowedNoWiFiSecurityModes";HotspotAllowStatus[HotspotAllowStatus["kDisallowedNoMobileData"]=3]="kDisallowedNoMobileData";HotspotAllowStatus[HotspotAllowStatus["kDisallowedReadinessCheckFail"]=4]="kDisallowedReadinessCheckFail";HotspotAllowStatus[HotspotAllowStatus["kDisallowedByPolicy"]=5]="kDisallowedByPolicy";HotspotAllowStatus[HotspotAllowStatus["kAllowed"]=6]="kAllowed"})(HotspotAllowStatus||(HotspotAllowStatus={}));export const HotspotControlResultSpec={$:mojo.internal.Enum()};export var HotspotControlResult;(function(HotspotControlResult){HotspotControlResult[HotspotControlResult["MIN_VALUE"]=0]="MIN_VALUE";HotspotControlResult[HotspotControlResult["MAX_VALUE"]=16]="MAX_VALUE";HotspotControlResult[HotspotControlResult["kSuccess"]=0]="kSuccess";HotspotControlResult[HotspotControlResult["kNotAllowed"]=1]="kNotAllowed";HotspotControlResult[HotspotControlResult["kReadinessCheckFailed"]=2]="kReadinessCheckFailed";HotspotControlResult[HotspotControlResult["kDisableWifiFailed"]=3]="kDisableWifiFailed";HotspotControlResult[HotspotControlResult["kInvalidConfiguration"]=4]="kInvalidConfiguration";HotspotControlResult[HotspotControlResult["kUpstreamNotAvailable"]=5]="kUpstreamNotAvailable";HotspotControlResult[HotspotControlResult["kNetworkSetupFailure"]=6]="kNetworkSetupFailure";HotspotControlResult[HotspotControlResult["kDownstreamWifiFailure"]=7]="kDownstreamWifiFailure";HotspotControlResult[HotspotControlResult["kUpstreamFailure"]=8]="kUpstreamFailure";HotspotControlResult[HotspotControlResult["kShillOperationFailed"]=9]="kShillOperationFailed";HotspotControlResult[HotspotControlResult["kAlreadyFulfilled"]=10]="kAlreadyFulfilled";HotspotControlResult[HotspotControlResult["kAborted"]=11]="kAborted";HotspotControlResult[HotspotControlResult["kInvalid"]=12]="kInvalid";HotspotControlResult[HotspotControlResult["kBusy"]=13]="kBusy";HotspotControlResult[HotspotControlResult["kConcurrencyNotSupported"]=14]="kConcurrencyNotSupported";HotspotControlResult[HotspotControlResult["kOperationFailure"]=15]="kOperationFailure";HotspotControlResult[HotspotControlResult["kUnknownFailure"]=16]="kUnknownFailure"})(HotspotControlResult||(HotspotControlResult={}));export const DisableReasonSpec={$:mojo.internal.Enum()};export var DisableReason;(function(DisableReason){DisableReason[DisableReason["MIN_VALUE"]=0]="MIN_VALUE";DisableReason[DisableReason["MAX_VALUE"]=14]="MAX_VALUE";DisableReason[DisableReason["kAutoDisabled"]=0]="kAutoDisabled";DisableReason[DisableReason["kInternalError"]=1]="kInternalError";DisableReason[DisableReason["kUserInitiated"]=2]="kUserInitiated";DisableReason[DisableReason["kWifiEnabled"]=3]="kWifiEnabled";DisableReason[DisableReason["kProhibitedByPolicy"]=4]="kProhibitedByPolicy";DisableReason[DisableReason["kUpstreamNetworkNotAvailable"]=5]="kUpstreamNetworkNotAvailable";DisableReason[DisableReason["kSuspended"]=6]="kSuspended";DisableReason[DisableReason["kRestart"]=7]="kRestart";DisableReason[DisableReason["kUpstreamNoInternet"]=8]="kUpstreamNoInternet";DisableReason[DisableReason["kDownstreamLinkDisconnect"]=9]="kDownstreamLinkDisconnect";DisableReason[DisableReason["kDownstreamNetworkDisconnect"]=10]="kDownstreamNetworkDisconnect";DisableReason[DisableReason["kStartTimeout"]=11]="kStartTimeout";DisableReason[DisableReason["kUpstreamNotAvailable"]=12]="kUpstreamNotAvailable";DisableReason[DisableReason["kResourceBusy"]=13]="kResourceBusy";DisableReason[DisableReason["kUnknownError"]=14]="kUnknownError"})(DisableReason||(DisableReason={}));export class CrosHotspotConfigPendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"ash.hotspot_config.mojom.CrosHotspotConfig",scope)}}export class CrosHotspotConfigRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(CrosHotspotConfigPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}addObserver(observer){this.proxy.sendMessage(0,CrosHotspotConfig_AddObserver_ParamsSpec.$,null,[observer],false)}observeEnabledStateChanges(observer){this.proxy.sendMessage(1,CrosHotspotConfig_ObserveEnabledStateChanges_ParamsSpec.$,null,[observer],false)}getHotspotInfo(){return this.proxy.sendMessage(2,CrosHotspotConfig_GetHotspotInfo_ParamsSpec.$,CrosHotspotConfig_GetHotspotInfo_ResponseParamsSpec.$,[],false)}setHotspotConfig(config){return this.proxy.sendMessage(3,CrosHotspotConfig_SetHotspotConfig_ParamsSpec.$,CrosHotspotConfig_SetHotspotConfig_ResponseParamsSpec.$,[config],false)}enableHotspot(){return this.proxy.sendMessage(4,CrosHotspotConfig_EnableHotspot_ParamsSpec.$,CrosHotspotConfig_EnableHotspot_ResponseParamsSpec.$,[],false)}disableHotspot(){return this.proxy.sendMessage(5,CrosHotspotConfig_DisableHotspot_ParamsSpec.$,CrosHotspotConfig_DisableHotspot_ResponseParamsSpec.$,[],false)}}export class CrosHotspotConfigReceiver{helper_internal_;$;onConnectionError;constructor(impl){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(CrosHotspotConfigRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.helper_internal_.registerHandler(0,CrosHotspotConfig_AddObserver_ParamsSpec.$,null,impl.addObserver.bind(impl),false);this.helper_internal_.registerHandler(1,CrosHotspotConfig_ObserveEnabledStateChanges_ParamsSpec.$,null,impl.observeEnabledStateChanges.bind(impl),false);this.helper_internal_.registerHandler(2,CrosHotspotConfig_GetHotspotInfo_ParamsSpec.$,CrosHotspotConfig_GetHotspotInfo_ResponseParamsSpec.$,impl.getHotspotInfo.bind(impl),false);this.helper_internal_.registerHandler(3,CrosHotspotConfig_SetHotspotConfig_ParamsSpec.$,CrosHotspotConfig_SetHotspotConfig_ResponseParamsSpec.$,impl.setHotspotConfig.bind(impl),false);this.helper_internal_.registerHandler(4,CrosHotspotConfig_EnableHotspot_ParamsSpec.$,CrosHotspotConfig_EnableHotspot_ResponseParamsSpec.$,impl.enableHotspot.bind(impl),false);this.helper_internal_.registerHandler(5,CrosHotspotConfig_DisableHotspot_ParamsSpec.$,CrosHotspotConfig_DisableHotspot_ResponseParamsSpec.$,impl.disableHotspot.bind(impl),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}}export class CrosHotspotConfig{static get $interfaceName(){return"ash.hotspot_config.mojom.CrosHotspotConfig"}static getRemote(){let remote=new CrosHotspotConfigRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}export class CrosHotspotConfigCallbackRouter{helper_internal_;$;router_;addObserver;observeEnabledStateChanges;getHotspotInfo;setHotspotConfig;enableHotspot;disableHotspot;onConnectionError;constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(CrosHotspotConfigRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.addObserver=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,CrosHotspotConfig_AddObserver_ParamsSpec.$,null,this.addObserver.createReceiverHandler(false),false);this.observeEnabledStateChanges=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(1,CrosHotspotConfig_ObserveEnabledStateChanges_ParamsSpec.$,null,this.observeEnabledStateChanges.createReceiverHandler(false),false);this.getHotspotInfo=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(2,CrosHotspotConfig_GetHotspotInfo_ParamsSpec.$,CrosHotspotConfig_GetHotspotInfo_ResponseParamsSpec.$,this.getHotspotInfo.createReceiverHandler(true),false);this.setHotspotConfig=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(3,CrosHotspotConfig_SetHotspotConfig_ParamsSpec.$,CrosHotspotConfig_SetHotspotConfig_ResponseParamsSpec.$,this.setHotspotConfig.createReceiverHandler(true),false);this.enableHotspot=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(4,CrosHotspotConfig_EnableHotspot_ParamsSpec.$,CrosHotspotConfig_EnableHotspot_ResponseParamsSpec.$,this.enableHotspot.createReceiverHandler(true),false);this.disableHotspot=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(5,CrosHotspotConfig_DisableHotspot_ParamsSpec.$,CrosHotspotConfig_DisableHotspot_ResponseParamsSpec.$,this.disableHotspot.createReceiverHandler(true),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}export class CrosHotspotConfigObserverPendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"ash.hotspot_config.mojom.CrosHotspotConfigObserver",scope)}}export class CrosHotspotConfigObserverRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(CrosHotspotConfigObserverPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}onHotspotInfoChanged(){this.proxy.sendMessage(0,CrosHotspotConfigObserver_OnHotspotInfoChanged_ParamsSpec.$,null,[],false)}}export class CrosHotspotConfigObserverReceiver{helper_internal_;$;onConnectionError;constructor(impl){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(CrosHotspotConfigObserverRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.helper_internal_.registerHandler(0,CrosHotspotConfigObserver_OnHotspotInfoChanged_ParamsSpec.$,null,impl.onHotspotInfoChanged.bind(impl),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}}export class CrosHotspotConfigObserver{static get $interfaceName(){return"ash.hotspot_config.mojom.CrosHotspotConfigObserver"}static getRemote(){let remote=new CrosHotspotConfigObserverRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}export class CrosHotspotConfigObserverCallbackRouter{helper_internal_;$;router_;onHotspotInfoChanged;onConnectionError;constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(CrosHotspotConfigObserverRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.onHotspotInfoChanged=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,CrosHotspotConfigObserver_OnHotspotInfoChanged_ParamsSpec.$,null,this.onHotspotInfoChanged.createReceiverHandler(false),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}export class HotspotEnabledStateObserverPendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"ash.hotspot_config.mojom.HotspotEnabledStateObserver",scope)}}export class HotspotEnabledStateObserverRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(HotspotEnabledStateObserverPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}onHotspotTurnedOn(){this.proxy.sendMessage(0,HotspotEnabledStateObserver_OnHotspotTurnedOn_ParamsSpec.$,null,[],false)}onHotspotTurnedOff(reason){this.proxy.sendMessage(1,HotspotEnabledStateObserver_OnHotspotTurnedOff_ParamsSpec.$,null,[reason],false)}}export class HotspotEnabledStateObserverReceiver{helper_internal_;$;onConnectionError;constructor(impl){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(HotspotEnabledStateObserverRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.helper_internal_.registerHandler(0,HotspotEnabledStateObserver_OnHotspotTurnedOn_ParamsSpec.$,null,impl.onHotspotTurnedOn.bind(impl),false);this.helper_internal_.registerHandler(1,HotspotEnabledStateObserver_OnHotspotTurnedOff_ParamsSpec.$,null,impl.onHotspotTurnedOff.bind(impl),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}}export class HotspotEnabledStateObserver{static get $interfaceName(){return"ash.hotspot_config.mojom.HotspotEnabledStateObserver"}static getRemote(){let remote=new HotspotEnabledStateObserverRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}export class HotspotEnabledStateObserverCallbackRouter{helper_internal_;$;router_;onHotspotTurnedOn;onHotspotTurnedOff;onConnectionError;constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(HotspotEnabledStateObserverRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.onHotspotTurnedOn=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,HotspotEnabledStateObserver_OnHotspotTurnedOn_ParamsSpec.$,null,this.onHotspotTurnedOn.createReceiverHandler(false),false);this.onHotspotTurnedOff=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(1,HotspotEnabledStateObserver_OnHotspotTurnedOff_ParamsSpec.$,null,this.onHotspotTurnedOff.createReceiverHandler(false),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}export const HotspotConfigSpec={$:{}};export const HotspotInfoSpec={$:{}};export const CrosHotspotConfig_AddObserver_ParamsSpec={$:{}};export const CrosHotspotConfig_ObserveEnabledStateChanges_ParamsSpec={$:{}};export const CrosHotspotConfig_GetHotspotInfo_ParamsSpec={$:{}};export const CrosHotspotConfig_GetHotspotInfo_ResponseParamsSpec={$:{}};export const CrosHotspotConfig_SetHotspotConfig_ParamsSpec={$:{}};export const CrosHotspotConfig_SetHotspotConfig_ResponseParamsSpec={$:{}};export const CrosHotspotConfig_EnableHotspot_ParamsSpec={$:{}};export const CrosHotspotConfig_EnableHotspot_ResponseParamsSpec={$:{}};export const CrosHotspotConfig_DisableHotspot_ParamsSpec={$:{}};export const CrosHotspotConfig_DisableHotspot_ResponseParamsSpec={$:{}};export const CrosHotspotConfigObserver_OnHotspotInfoChanged_ParamsSpec={$:{}};export const HotspotEnabledStateObserver_OnHotspotTurnedOn_ParamsSpec={$:{}};export const HotspotEnabledStateObserver_OnHotspotTurnedOff_ParamsSpec={$:{}};mojo.internal.Struct(HotspotConfigSpec.$,"HotspotConfig",[mojo.internal.StructField("autoDisable",0,0,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("security",4,0,WiFiSecurityModeSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("band",8,0,WiFiBandSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("ssid",16,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("passphrase",24,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("bssidRandomization",0,1,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,40]]);mojo.internal.Struct(HotspotInfoSpec.$,"HotspotInfo",[mojo.internal.StructField("state",0,0,HotspotStateSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("clientCount",4,0,mojo.internal.Uint32,0,false,0,undefined,undefined),mojo.internal.StructField("allowStatus",8,0,HotspotAllowStatusSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("allowedWifiSecurityModes",16,0,mojo.internal.Array(WiFiSecurityModeSpec.$,false),null,false,0,undefined,undefined),mojo.internal.StructField("config",24,0,HotspotConfigSpec.$,null,true,0,undefined,undefined)],[[0,40]]);mojo.internal.Struct(CrosHotspotConfig_AddObserver_ParamsSpec.$,"CrosHotspotConfig_AddObserver_Params",[mojo.internal.StructField("observer",0,0,mojo.internal.InterfaceProxy(CrosHotspotConfigObserverRemote),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(CrosHotspotConfig_ObserveEnabledStateChanges_ParamsSpec.$,"CrosHotspotConfig_ObserveEnabledStateChanges_Params",[mojo.internal.StructField("observer",0,0,mojo.internal.InterfaceProxy(HotspotEnabledStateObserverRemote),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(CrosHotspotConfig_GetHotspotInfo_ParamsSpec.$,"CrosHotspotConfig_GetHotspotInfo_Params",[],[[0,8]]);mojo.internal.Struct(CrosHotspotConfig_GetHotspotInfo_ResponseParamsSpec.$,"CrosHotspotConfig_GetHotspotInfo_ResponseParams",[mojo.internal.StructField("hotspotInfo",0,0,HotspotInfoSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(CrosHotspotConfig_SetHotspotConfig_ParamsSpec.$,"CrosHotspotConfig_SetHotspotConfig_Params",[mojo.internal.StructField("config",0,0,HotspotConfigSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(CrosHotspotConfig_SetHotspotConfig_ResponseParamsSpec.$,"CrosHotspotConfig_SetHotspotConfig_ResponseParams",[mojo.internal.StructField("result",0,0,SetHotspotConfigResultSpec.$,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(CrosHotspotConfig_EnableHotspot_ParamsSpec.$,"CrosHotspotConfig_EnableHotspot_Params",[],[[0,8]]);mojo.internal.Struct(CrosHotspotConfig_EnableHotspot_ResponseParamsSpec.$,"CrosHotspotConfig_EnableHotspot_ResponseParams",[mojo.internal.StructField("result",0,0,HotspotControlResultSpec.$,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(CrosHotspotConfig_DisableHotspot_ParamsSpec.$,"CrosHotspotConfig_DisableHotspot_Params",[],[[0,8]]);mojo.internal.Struct(CrosHotspotConfig_DisableHotspot_ResponseParamsSpec.$,"CrosHotspotConfig_DisableHotspot_ResponseParams",[mojo.internal.StructField("result",0,0,HotspotControlResultSpec.$,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(CrosHotspotConfigObserver_OnHotspotInfoChanged_ParamsSpec.$,"CrosHotspotConfigObserver_OnHotspotInfoChanged_Params",[],[[0,8]]);mojo.internal.Struct(HotspotEnabledStateObserver_OnHotspotTurnedOn_ParamsSpec.$,"HotspotEnabledStateObserver_OnHotspotTurnedOn_Params",[],[[0,8]]);mojo.internal.Struct(HotspotEnabledStateObserver_OnHotspotTurnedOff_ParamsSpec.$,"HotspotEnabledStateObserver_OnHotspotTurnedOff_Params",[mojo.internal.StructField("reason",0,0,DisableReasonSpec.$,0,false,0,undefined,undefined)],[[0,16]]);