// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{mojo}from"//resources/mojo/mojo/public/js/bindings.js";import{TimeDeltaSpec as mojoBase_mojom_TimeDeltaSpec}from"../../../../mojo/public/mojom/base/time.mojom-webui.js";export const ReasonSpec={$:mojo.internal.Enum()};export var Reason;(function(Reason){Reason[Reason["MIN_VALUE"]=0]="MIN_VALUE";Reason[Reason["MAX_VALUE"]=2]="MAX_VALUE";Reason[Reason["kAccessPasswordManager"]=0]="kAccessPasswordManager";Reason[Reason["kAccessAuthenticationSettings"]=1]="kAccessAuthenticationSettings";Reason[Reason["kAccessMultideviceSettings"]=2]="kAccessMultideviceSettings"})(Reason||(Reason={}));export class InSessionAuthPendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"chromeos.auth.mojom.InSessionAuth",scope)}}export class InSessionAuthRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(InSessionAuthPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}requestToken(reason,prompt){return this.proxy.sendMessage(0,InSessionAuth_RequestToken_ParamsSpec.$,InSessionAuth_RequestToken_ResponseParamsSpec.$,[reason,prompt],false)}checkToken(reason,token){return this.proxy.sendMessage(1,InSessionAuth_CheckToken_ParamsSpec.$,InSessionAuth_CheckToken_ResponseParamsSpec.$,[reason,token],false)}invalidateToken(token){this.proxy.sendMessage(2,InSessionAuth_InvalidateToken_ParamsSpec.$,null,[token],false)}requestLegacyWebAuthn(rpId,windowId){return this.proxy.sendMessage(3,InSessionAuth_RequestLegacyWebAuthn_ParamsSpec.$,InSessionAuth_RequestLegacyWebAuthn_ResponseParamsSpec.$,[rpId,windowId],false)}}export class InSessionAuthReceiver{helper_internal_;$;onConnectionError;constructor(impl){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(InSessionAuthRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.helper_internal_.registerHandler(0,InSessionAuth_RequestToken_ParamsSpec.$,InSessionAuth_RequestToken_ResponseParamsSpec.$,impl.requestToken.bind(impl),false);this.helper_internal_.registerHandler(1,InSessionAuth_CheckToken_ParamsSpec.$,InSessionAuth_CheckToken_ResponseParamsSpec.$,impl.checkToken.bind(impl),false);this.helper_internal_.registerHandler(2,InSessionAuth_InvalidateToken_ParamsSpec.$,null,impl.invalidateToken.bind(impl),false);this.helper_internal_.registerHandler(3,InSessionAuth_RequestLegacyWebAuthn_ParamsSpec.$,InSessionAuth_RequestLegacyWebAuthn_ResponseParamsSpec.$,impl.requestLegacyWebAuthn.bind(impl),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}}export class InSessionAuth{static get $interfaceName(){return"chromeos.auth.mojom.InSessionAuth"}static getRemote(){let remote=new InSessionAuthRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}export class InSessionAuthCallbackRouter{helper_internal_;$;router_;requestToken;checkToken;invalidateToken;requestLegacyWebAuthn;onConnectionError;constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(InSessionAuthRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.requestToken=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,InSessionAuth_RequestToken_ParamsSpec.$,InSessionAuth_RequestToken_ResponseParamsSpec.$,this.requestToken.createReceiverHandler(true),false);this.checkToken=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(1,InSessionAuth_CheckToken_ParamsSpec.$,InSessionAuth_CheckToken_ResponseParamsSpec.$,this.checkToken.createReceiverHandler(true),false);this.invalidateToken=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(2,InSessionAuth_InvalidateToken_ParamsSpec.$,null,this.invalidateToken.createReceiverHandler(false),false);this.requestLegacyWebAuthn=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(3,InSessionAuth_RequestLegacyWebAuthn_ParamsSpec.$,InSessionAuth_RequestLegacyWebAuthn_ResponseParamsSpec.$,this.requestLegacyWebAuthn.createReceiverHandler(true),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}export const RequestTokenReplySpec={$:{}};export const InSessionAuth_RequestToken_ParamsSpec={$:{}};export const InSessionAuth_RequestToken_ResponseParamsSpec={$:{}};export const InSessionAuth_CheckToken_ParamsSpec={$:{}};export const InSessionAuth_CheckToken_ResponseParamsSpec={$:{}};export const InSessionAuth_InvalidateToken_ParamsSpec={$:{}};export const InSessionAuth_RequestLegacyWebAuthn_ParamsSpec={$:{}};export const InSessionAuth_RequestLegacyWebAuthn_ResponseParamsSpec={$:{}};mojo.internal.Struct(RequestTokenReplySpec.$,"RequestTokenReply",[mojo.internal.StructField("token",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("timeout",8,0,mojoBase_mojom_TimeDeltaSpec.$,null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(InSessionAuth_RequestToken_ParamsSpec.$,"InSessionAuth_RequestToken_Params",[mojo.internal.StructField("reason",0,0,ReasonSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("prompt",8,0,mojo.internal.String,null,true,1,undefined,undefined)],[[0,16],[1,24]]);mojo.internal.Struct(InSessionAuth_RequestToken_ResponseParamsSpec.$,"InSessionAuth_RequestToken_ResponseParams",[mojo.internal.StructField("reply",0,0,RequestTokenReplySpec.$,null,true,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(InSessionAuth_CheckToken_ParamsSpec.$,"InSessionAuth_CheckToken_Params",[mojo.internal.StructField("reason",0,0,ReasonSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("token",8,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(InSessionAuth_CheckToken_ResponseParamsSpec.$,"InSessionAuth_CheckToken_ResponseParams",[mojo.internal.StructField("valid",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(InSessionAuth_InvalidateToken_ParamsSpec.$,"InSessionAuth_InvalidateToken_Params",[mojo.internal.StructField("token",0,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(InSessionAuth_RequestLegacyWebAuthn_ParamsSpec.$,"InSessionAuth_RequestLegacyWebAuthn_Params",[mojo.internal.StructField("rpId",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("windowId",8,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(InSessionAuth_RequestLegacyWebAuthn_ResponseParamsSpec.$,"InSessionAuth_RequestLegacyWebAuthn_ResponseParams",[mojo.internal.StructField("success",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);