// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{mojo}from"//resources/mojo/mojo/public/js/bindings.js";import{TimeSpec as mojoBase_mojom_TimeSpec}from"../../../../../mojo/public/mojom/base/time.mojom-webui.js";import{IPAddressSpec as network_mojom_IPAddressSpec}from"../../../../../services/network/public/mojom/ip_address.mojom-webui.js";import{UrlSpec as url_mojom_UrlSpec}from"../../../../../url/mojom/url.mojom-webui.js";import{ConnectionStateTypeSpec as chromeos_networkConfig_mojom_ConnectionStateTypeSpec,ConnectionStateType as chromeos_networkConfig_mojom_ConnectionStateType,DeviceStateTypeSpec as chromeos_networkConfig_mojom_DeviceStateTypeSpec,IPConfigTypeSpec as chromeos_networkConfig_mojom_IPConfigTypeSpec,NetworkTypeSpec as chromeos_networkConfig_mojom_NetworkTypeSpec,OncSourceSpec as chromeos_networkConfig_mojom_OncSourceSpec,PolicySourceSpec as chromeos_networkConfig_mojom_PolicySourceSpec,PolicySource as chromeos_networkConfig_mojom_PolicySource,PortalStateSpec as chromeos_networkConfig_mojom_PortalStateSpec,PortalState as chromeos_networkConfig_mojom_PortalState}from"./network_types.mojom-webui.js";export const MAX_NUM_CUSTOM_APNS=10;export const NO_LIMIT=0;export const NO_ROUTING_PREFIX=0;export const ActivationStateTypeSpec={$:mojo.internal.Enum()};export var ActivationStateType;(function(ActivationStateType){ActivationStateType[ActivationStateType["MIN_VALUE"]=0]="MIN_VALUE";ActivationStateType[ActivationStateType["MAX_VALUE"]=5]="MAX_VALUE";ActivationStateType[ActivationStateType["kUnknown"]=0]="kUnknown";ActivationStateType[ActivationStateType["kNotActivated"]=1]="kNotActivated";ActivationStateType[ActivationStateType["kActivating"]=2]="kActivating";ActivationStateType[ActivationStateType["kPartiallyActivated"]=3]="kPartiallyActivated";ActivationStateType[ActivationStateType["kActivated"]=4]="kActivated";ActivationStateType[ActivationStateType["kNoService"]=5]="kNoService"})(ActivationStateType||(ActivationStateType={}));export const AuthenticationTypeSpec={$:mojo.internal.Enum()};export var AuthenticationType;(function(AuthenticationType){AuthenticationType[AuthenticationType["MIN_VALUE"]=0]="MIN_VALUE";AuthenticationType[AuthenticationType["MAX_VALUE"]=1]="MAX_VALUE";AuthenticationType[AuthenticationType["kNone"]=0]="kNone";AuthenticationType[AuthenticationType["k8021x"]=1]="k8021x"})(AuthenticationType||(AuthenticationType={}));export const HiddenSsidModeSpec={$:mojo.internal.Enum()};export var HiddenSsidMode;(function(HiddenSsidMode){HiddenSsidMode[HiddenSsidMode["MIN_VALUE"]=0]="MIN_VALUE";HiddenSsidMode[HiddenSsidMode["MAX_VALUE"]=2]="MAX_VALUE";HiddenSsidMode[HiddenSsidMode["kAutomatic"]=0]="kAutomatic";HiddenSsidMode[HiddenSsidMode["kDisabled"]=1]="kDisabled";HiddenSsidMode[HiddenSsidMode["kEnabled"]=2]="kEnabled"})(HiddenSsidMode||(HiddenSsidMode={}));export const ProxyModeSpec={$:mojo.internal.Enum()};export var ProxyMode;(function(ProxyMode){ProxyMode[ProxyMode["MIN_VALUE"]=0]="MIN_VALUE";ProxyMode[ProxyMode["MAX_VALUE"]=4]="MAX_VALUE";ProxyMode[ProxyMode["kDirect"]=0]="kDirect";ProxyMode[ProxyMode["kAutoDetect"]=1]="kAutoDetect";ProxyMode[ProxyMode["kPacScript"]=2]="kPacScript";ProxyMode[ProxyMode["kFixedServers"]=3]="kFixedServers";ProxyMode[ProxyMode["kSystem"]=4]="kSystem"})(ProxyMode||(ProxyMode={}));export const SecurityTypeSpec={$:mojo.internal.Enum()};export var SecurityType;(function(SecurityType){SecurityType[SecurityType["MIN_VALUE"]=0]="MIN_VALUE";SecurityType[SecurityType["MAX_VALUE"]=4]="MAX_VALUE";SecurityType[SecurityType["kNone"]=0]="kNone";SecurityType[SecurityType["kWep8021x"]=1]="kWep8021x";SecurityType[SecurityType["kWepPsk"]=2]="kWepPsk";SecurityType[SecurityType["kWpaEap"]=3]="kWpaEap";SecurityType[SecurityType["kWpaPsk"]=4]="kWpaPsk"})(SecurityType||(SecurityType={}));export const MatchTypeSpec={$:mojo.internal.Enum()};export var MatchType;(function(MatchType){MatchType[MatchType["MIN_VALUE"]=0]="MIN_VALUE";MatchType[MatchType["MAX_VALUE"]=3]="MAX_VALUE";MatchType[MatchType["kNoMatch"]=0]="kNoMatch";MatchType[MatchType["kHome"]=1]="kHome";MatchType[MatchType["kRoaming"]=2]="kRoaming";MatchType[MatchType["kUnknown"]=3]="kUnknown"})(MatchType||(MatchType={}));export const VpnTypeSpec={$:mojo.internal.Enum()};export var VpnType;(function(VpnType){VpnType[VpnType["MIN_VALUE"]=0]="MIN_VALUE";VpnType[VpnType["MAX_VALUE"]=5]="MAX_VALUE";VpnType[VpnType["kIKEv2"]=0]="kIKEv2";VpnType[VpnType["kL2TPIPsec"]=1]="kL2TPIPsec";VpnType[VpnType["kOpenVPN"]=2]="kOpenVPN";VpnType[VpnType["kWireGuard"]=3]="kWireGuard";VpnType[VpnType["kExtension"]=4]="kExtension";VpnType[VpnType["kArc"]=5]="kArc"})(VpnType||(VpnType={}));export const FilterTypeSpec={$:mojo.internal.Enum()};export var FilterType;(function(FilterType){FilterType[FilterType["MIN_VALUE"]=0]="MIN_VALUE";FilterType[FilterType["MAX_VALUE"]=3]="MAX_VALUE";FilterType[FilterType["kActive"]=0]="kActive";FilterType[FilterType["kVisible"]=1]="kVisible";FilterType[FilterType["kConfigured"]=2]="kConfigured";FilterType[FilterType["kAll"]=3]="kAll"})(FilterType||(FilterType={}));export const StartConnectResultSpec={$:mojo.internal.Enum()};export var StartConnectResult;(function(StartConnectResult){StartConnectResult[StartConnectResult["MIN_VALUE"]=0]="MIN_VALUE";StartConnectResult[StartConnectResult["MAX_VALUE"]=6]="MAX_VALUE";StartConnectResult[StartConnectResult["kSuccess"]=0]="kSuccess";StartConnectResult[StartConnectResult["kInvalidGuid"]=1]="kInvalidGuid";StartConnectResult[StartConnectResult["kInvalidState"]=2]="kInvalidState";StartConnectResult[StartConnectResult["kCanceled"]=3]="kCanceled";StartConnectResult[StartConnectResult["kNotConfigured"]=4]="kNotConfigured";StartConnectResult[StartConnectResult["kBlocked"]=5]="kBlocked";StartConnectResult[StartConnectResult["kUnknown"]=6]="kUnknown"})(StartConnectResult||(StartConnectResult={}));export const CertificateTypeSpec={$:mojo.internal.Enum()};export var CertificateType;(function(CertificateType){CertificateType[CertificateType["MIN_VALUE"]=0]="MIN_VALUE";CertificateType[CertificateType["MAX_VALUE"]=1]="MAX_VALUE";CertificateType[CertificateType["kServerCA"]=0]="kServerCA";CertificateType[CertificateType["kUserCert"]=1]="kUserCert"})(CertificateType||(CertificateType={}));export const InhibitReasonSpec={$:mojo.internal.Enum()};export var InhibitReason;(function(InhibitReason){InhibitReason[InhibitReason["MIN_VALUE"]=0]="MIN_VALUE";InhibitReason[InhibitReason["MAX_VALUE"]=8]="MAX_VALUE";InhibitReason[InhibitReason["kNotInhibited"]=0]="kNotInhibited";InhibitReason[InhibitReason["kInstallingProfile"]=1]="kInstallingProfile";InhibitReason[InhibitReason["kRenamingProfile"]=2]="kRenamingProfile";InhibitReason[InhibitReason["kRemovingProfile"]=3]="kRemovingProfile";InhibitReason[InhibitReason["kConnectingToProfile"]=4]="kConnectingToProfile";InhibitReason[InhibitReason["kRefreshingProfileList"]=5]="kRefreshingProfileList";InhibitReason[InhibitReason["kResettingEuiccMemory"]=6]="kResettingEuiccMemory";InhibitReason[InhibitReason["kDisablingProfile"]=7]="kDisablingProfile";InhibitReason[InhibitReason["kRequestingAvailableProfiles"]=8]="kRequestingAvailableProfiles"})(InhibitReason||(InhibitReason={}));export const AlwaysOnVpnModeSpec={$:mojo.internal.Enum()};export var AlwaysOnVpnMode;(function(AlwaysOnVpnMode){AlwaysOnVpnMode[AlwaysOnVpnMode["MIN_VALUE"]=0]="MIN_VALUE";AlwaysOnVpnMode[AlwaysOnVpnMode["MAX_VALUE"]=2]="MAX_VALUE";AlwaysOnVpnMode[AlwaysOnVpnMode["kOff"]=0]="kOff";AlwaysOnVpnMode[AlwaysOnVpnMode["kBestEffort"]=1]="kBestEffort";AlwaysOnVpnMode[AlwaysOnVpnMode["kStrict"]=2]="kStrict"})(AlwaysOnVpnMode||(AlwaysOnVpnMode={}));export const ApnStateSpec={$:mojo.internal.Enum()};export var ApnState;(function(ApnState){ApnState[ApnState["MIN_VALUE"]=0]="MIN_VALUE";ApnState[ApnState["MAX_VALUE"]=1]="MAX_VALUE";ApnState[ApnState["kEnabled"]=0]="kEnabled";ApnState[ApnState["kDisabled"]=1]="kDisabled"})(ApnState||(ApnState={}));export const ApnAuthenticationTypeSpec={$:mojo.internal.Enum()};export var ApnAuthenticationType;(function(ApnAuthenticationType){ApnAuthenticationType[ApnAuthenticationType["MIN_VALUE"]=0]="MIN_VALUE";ApnAuthenticationType[ApnAuthenticationType["MAX_VALUE"]=2]="MAX_VALUE";ApnAuthenticationType[ApnAuthenticationType["kAutomatic"]=0]="kAutomatic";ApnAuthenticationType[ApnAuthenticationType["kPap"]=1]="kPap";ApnAuthenticationType[ApnAuthenticationType["kChap"]=2]="kChap"})(ApnAuthenticationType||(ApnAuthenticationType={}));export const ApnIpTypeSpec={$:mojo.internal.Enum()};export var ApnIpType;(function(ApnIpType){ApnIpType[ApnIpType["MIN_VALUE"]=0]="MIN_VALUE";ApnIpType[ApnIpType["MAX_VALUE"]=3]="MAX_VALUE";ApnIpType[ApnIpType["kAutomatic"]=0]="kAutomatic";ApnIpType[ApnIpType["kIpv4"]=1]="kIpv4";ApnIpType[ApnIpType["kIpv6"]=2]="kIpv6";ApnIpType[ApnIpType["kIpv4Ipv6"]=3]="kIpv4Ipv6"})(ApnIpType||(ApnIpType={}));export const ApnTypeSpec={$:mojo.internal.Enum()};export var ApnType;(function(ApnType){ApnType[ApnType["MIN_VALUE"]=0]="MIN_VALUE";ApnType[ApnType["MAX_VALUE"]=2]="MAX_VALUE";ApnType[ApnType["kDefault"]=0]="kDefault";ApnType[ApnType["kAttach"]=1]="kAttach";ApnType[ApnType["kTether"]=2]="kTether"})(ApnType||(ApnType={}));export const ApnSourceSpec={$:mojo.internal.Enum()};export var ApnSource;(function(ApnSource){ApnSource[ApnSource["MIN_VALUE"]=0]="MIN_VALUE";ApnSource[ApnSource["MAX_VALUE"]=2]="MAX_VALUE";ApnSource[ApnSource["kModem"]=0]="kModem";ApnSource[ApnSource["kModb"]=1]="kModb";ApnSource[ApnSource["kUi"]=2]="kUi"})(ApnSource||(ApnSource={}));export const SuppressionTypeSpec={$:mojo.internal.Enum()};export var SuppressionType;(function(SuppressionType){SuppressionType[SuppressionType["MIN_VALUE"]=0]="MIN_VALUE";SuppressionType[SuppressionType["MAX_VALUE"]=2]="MAX_VALUE";SuppressionType[SuppressionType["kUnset"]=0]="kUnset";SuppressionType[SuppressionType["kAllow"]=1]="kAllow";SuppressionType[SuppressionType["kSuppress"]=2]="kSuppress"})(SuppressionType||(SuppressionType={}));export const TrafficCounterSourceSpec={$:mojo.internal.Enum()};export var TrafficCounterSource;(function(TrafficCounterSource){TrafficCounterSource[TrafficCounterSource["MIN_VALUE"]=0]="MIN_VALUE";TrafficCounterSource[TrafficCounterSource["MAX_VALUE"]=8]="MAX_VALUE";TrafficCounterSource[TrafficCounterSource["kUnknown"]=0]="kUnknown";TrafficCounterSource[TrafficCounterSource["kChrome"]=1]="kChrome";TrafficCounterSource[TrafficCounterSource["kUser"]=2]="kUser";TrafficCounterSource[TrafficCounterSource["kArc"]=3]="kArc";TrafficCounterSource[TrafficCounterSource["kCrosvm"]=4]="kCrosvm";TrafficCounterSource[TrafficCounterSource["kPluginvm"]=5]="kPluginvm";TrafficCounterSource[TrafficCounterSource["kUpdateEngine"]=6]="kUpdateEngine";TrafficCounterSource[TrafficCounterSource["kVpn"]=7]="kVpn";TrafficCounterSource[TrafficCounterSource["kSystem"]=8]="kSystem"})(TrafficCounterSource||(TrafficCounterSource={}));export class CrosNetworkConfigPendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"chromeos.network_config.mojom.CrosNetworkConfig",scope)}}export class CrosNetworkConfigRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(CrosNetworkConfigPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}addObserver(observer){this.proxy.sendMessage(0,CrosNetworkConfig_AddObserver_ParamsSpec.$,null,[observer],false)}getNetworkState(guid){return this.proxy.sendMessage(1,CrosNetworkConfig_GetNetworkState_ParamsSpec.$,CrosNetworkConfig_GetNetworkState_ResponseParamsSpec.$,[guid],false)}getNetworkStateList(filter){return this.proxy.sendMessage(2,CrosNetworkConfig_GetNetworkStateList_ParamsSpec.$,CrosNetworkConfig_GetNetworkStateList_ResponseParamsSpec.$,[filter],false)}getDeviceStateList(){return this.proxy.sendMessage(3,CrosNetworkConfig_GetDeviceStateList_ParamsSpec.$,CrosNetworkConfig_GetDeviceStateList_ResponseParamsSpec.$,[],false)}getManagedProperties(guid){return this.proxy.sendMessage(4,CrosNetworkConfig_GetManagedProperties_ParamsSpec.$,CrosNetworkConfig_GetManagedProperties_ResponseParamsSpec.$,[guid],false)}setProperties(guid,properties){return this.proxy.sendMessage(5,CrosNetworkConfig_SetProperties_ParamsSpec.$,CrosNetworkConfig_SetProperties_ResponseParamsSpec.$,[guid,properties],false)}configureNetwork(properties,shared){return this.proxy.sendMessage(6,CrosNetworkConfig_ConfigureNetwork_ParamsSpec.$,CrosNetworkConfig_ConfigureNetwork_ResponseParamsSpec.$,[properties,shared],false)}forgetNetwork(guid){return this.proxy.sendMessage(7,CrosNetworkConfig_ForgetNetwork_ParamsSpec.$,CrosNetworkConfig_ForgetNetwork_ResponseParamsSpec.$,[guid],false)}setNetworkTypeEnabledState(type,enabled){return this.proxy.sendMessage(8,CrosNetworkConfig_SetNetworkTypeEnabledState_ParamsSpec.$,CrosNetworkConfig_SetNetworkTypeEnabledState_ResponseParamsSpec.$,[type,enabled],false)}setCellularSimState(state){return this.proxy.sendMessage(9,CrosNetworkConfig_SetCellularSimState_ParamsSpec.$,CrosNetworkConfig_SetCellularSimState_ResponseParamsSpec.$,[state],false)}selectCellularMobileNetwork(guid,networkId){return this.proxy.sendMessage(10,CrosNetworkConfig_SelectCellularMobileNetwork_ParamsSpec.$,CrosNetworkConfig_SelectCellularMobileNetwork_ResponseParamsSpec.$,[guid,networkId],false)}requestNetworkScan(type){this.proxy.sendMessage(11,CrosNetworkConfig_RequestNetworkScan_ParamsSpec.$,null,[type],false)}getGlobalPolicy(){return this.proxy.sendMessage(12,CrosNetworkConfig_GetGlobalPolicy_ParamsSpec.$,CrosNetworkConfig_GetGlobalPolicy_ResponseParamsSpec.$,[],false)}startConnect(guid){return this.proxy.sendMessage(13,CrosNetworkConfig_StartConnect_ParamsSpec.$,CrosNetworkConfig_StartConnect_ResponseParamsSpec.$,[guid],false)}startDisconnect(guid){return this.proxy.sendMessage(14,CrosNetworkConfig_StartDisconnect_ParamsSpec.$,CrosNetworkConfig_StartDisconnect_ResponseParamsSpec.$,[guid],false)}setVpnProviders(providers){this.proxy.sendMessage(15,CrosNetworkConfig_SetVpnProviders_ParamsSpec.$,null,[providers],false)}getVpnProviders(){return this.proxy.sendMessage(16,CrosNetworkConfig_GetVpnProviders_ParamsSpec.$,CrosNetworkConfig_GetVpnProviders_ResponseParamsSpec.$,[],false)}getNetworkCertificates(){return this.proxy.sendMessage(17,CrosNetworkConfig_GetNetworkCertificates_ParamsSpec.$,CrosNetworkConfig_GetNetworkCertificates_ResponseParamsSpec.$,[],false)}getAlwaysOnVpn(){return this.proxy.sendMessage(18,CrosNetworkConfig_GetAlwaysOnVpn_ParamsSpec.$,CrosNetworkConfig_GetAlwaysOnVpn_ResponseParamsSpec.$,[],false)}setAlwaysOnVpn(properties){this.proxy.sendMessage(19,CrosNetworkConfig_SetAlwaysOnVpn_ParamsSpec.$,null,[properties],false)}getSupportedVpnTypes(){return this.proxy.sendMessage(20,CrosNetworkConfig_GetSupportedVpnTypes_ParamsSpec.$,CrosNetworkConfig_GetSupportedVpnTypes_ResponseParamsSpec.$,[],false)}requestTrafficCounters(guid){return this.proxy.sendMessage(21,CrosNetworkConfig_RequestTrafficCounters_ParamsSpec.$,CrosNetworkConfig_RequestTrafficCounters_ResponseParamsSpec.$,[guid],false)}resetTrafficCounters(guid){this.proxy.sendMessage(22,CrosNetworkConfig_ResetTrafficCounters_ParamsSpec.$,null,[guid],false)}setTrafficCountersResetDay(guid,day){return this.proxy.sendMessage(23,CrosNetworkConfig_SetTrafficCountersResetDay_ParamsSpec.$,CrosNetworkConfig_SetTrafficCountersResetDay_ResponseParamsSpec.$,[guid,day],false)}createCustomApn(networkGuid,apn){return this.proxy.sendMessage(24,CrosNetworkConfig_CreateCustomApn_ParamsSpec.$,CrosNetworkConfig_CreateCustomApn_ResponseParamsSpec.$,[networkGuid,apn],false)}createExclusivelyEnabledCustomApn(networkGuid,apn){return this.proxy.sendMessage(25,CrosNetworkConfig_CreateExclusivelyEnabledCustomApn_ParamsSpec.$,CrosNetworkConfig_CreateExclusivelyEnabledCustomApn_ResponseParamsSpec.$,[networkGuid,apn],false)}removeCustomApn(networkGuid,apnId){this.proxy.sendMessage(26,CrosNetworkConfig_RemoveCustomApn_ParamsSpec.$,null,[networkGuid,apnId],false)}modifyCustomApn(networkGuid,apn){this.proxy.sendMessage(27,CrosNetworkConfig_ModifyCustomApn_ParamsSpec.$,null,[networkGuid,apn],false)}}export class CrosNetworkConfigReceiver{helper_internal_;$;onConnectionError;constructor(impl){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(CrosNetworkConfigRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.helper_internal_.registerHandler(0,CrosNetworkConfig_AddObserver_ParamsSpec.$,null,impl.addObserver.bind(impl),false);this.helper_internal_.registerHandler(1,CrosNetworkConfig_GetNetworkState_ParamsSpec.$,CrosNetworkConfig_GetNetworkState_ResponseParamsSpec.$,impl.getNetworkState.bind(impl),false);this.helper_internal_.registerHandler(2,CrosNetworkConfig_GetNetworkStateList_ParamsSpec.$,CrosNetworkConfig_GetNetworkStateList_ResponseParamsSpec.$,impl.getNetworkStateList.bind(impl),false);this.helper_internal_.registerHandler(3,CrosNetworkConfig_GetDeviceStateList_ParamsSpec.$,CrosNetworkConfig_GetDeviceStateList_ResponseParamsSpec.$,impl.getDeviceStateList.bind(impl),false);this.helper_internal_.registerHandler(4,CrosNetworkConfig_GetManagedProperties_ParamsSpec.$,CrosNetworkConfig_GetManagedProperties_ResponseParamsSpec.$,impl.getManagedProperties.bind(impl),false);this.helper_internal_.registerHandler(5,CrosNetworkConfig_SetProperties_ParamsSpec.$,CrosNetworkConfig_SetProperties_ResponseParamsSpec.$,impl.setProperties.bind(impl),false);this.helper_internal_.registerHandler(6,CrosNetworkConfig_ConfigureNetwork_ParamsSpec.$,CrosNetworkConfig_ConfigureNetwork_ResponseParamsSpec.$,impl.configureNetwork.bind(impl),false);this.helper_internal_.registerHandler(7,CrosNetworkConfig_ForgetNetwork_ParamsSpec.$,CrosNetworkConfig_ForgetNetwork_ResponseParamsSpec.$,impl.forgetNetwork.bind(impl),false);this.helper_internal_.registerHandler(8,CrosNetworkConfig_SetNetworkTypeEnabledState_ParamsSpec.$,CrosNetworkConfig_SetNetworkTypeEnabledState_ResponseParamsSpec.$,impl.setNetworkTypeEnabledState.bind(impl),false);this.helper_internal_.registerHandler(9,CrosNetworkConfig_SetCellularSimState_ParamsSpec.$,CrosNetworkConfig_SetCellularSimState_ResponseParamsSpec.$,impl.setCellularSimState.bind(impl),false);this.helper_internal_.registerHandler(10,CrosNetworkConfig_SelectCellularMobileNetwork_ParamsSpec.$,CrosNetworkConfig_SelectCellularMobileNetwork_ResponseParamsSpec.$,impl.selectCellularMobileNetwork.bind(impl),false);this.helper_internal_.registerHandler(11,CrosNetworkConfig_RequestNetworkScan_ParamsSpec.$,null,impl.requestNetworkScan.bind(impl),false);this.helper_internal_.registerHandler(12,CrosNetworkConfig_GetGlobalPolicy_ParamsSpec.$,CrosNetworkConfig_GetGlobalPolicy_ResponseParamsSpec.$,impl.getGlobalPolicy.bind(impl),false);this.helper_internal_.registerHandler(13,CrosNetworkConfig_StartConnect_ParamsSpec.$,CrosNetworkConfig_StartConnect_ResponseParamsSpec.$,impl.startConnect.bind(impl),false);this.helper_internal_.registerHandler(14,CrosNetworkConfig_StartDisconnect_ParamsSpec.$,CrosNetworkConfig_StartDisconnect_ResponseParamsSpec.$,impl.startDisconnect.bind(impl),false);this.helper_internal_.registerHandler(15,CrosNetworkConfig_SetVpnProviders_ParamsSpec.$,null,impl.setVpnProviders.bind(impl),false);this.helper_internal_.registerHandler(16,CrosNetworkConfig_GetVpnProviders_ParamsSpec.$,CrosNetworkConfig_GetVpnProviders_ResponseParamsSpec.$,impl.getVpnProviders.bind(impl),false);this.helper_internal_.registerHandler(17,CrosNetworkConfig_GetNetworkCertificates_ParamsSpec.$,CrosNetworkConfig_GetNetworkCertificates_ResponseParamsSpec.$,impl.getNetworkCertificates.bind(impl),false);this.helper_internal_.registerHandler(18,CrosNetworkConfig_GetAlwaysOnVpn_ParamsSpec.$,CrosNetworkConfig_GetAlwaysOnVpn_ResponseParamsSpec.$,impl.getAlwaysOnVpn.bind(impl),false);this.helper_internal_.registerHandler(19,CrosNetworkConfig_SetAlwaysOnVpn_ParamsSpec.$,null,impl.setAlwaysOnVpn.bind(impl),false);this.helper_internal_.registerHandler(20,CrosNetworkConfig_GetSupportedVpnTypes_ParamsSpec.$,CrosNetworkConfig_GetSupportedVpnTypes_ResponseParamsSpec.$,impl.getSupportedVpnTypes.bind(impl),false);this.helper_internal_.registerHandler(21,CrosNetworkConfig_RequestTrafficCounters_ParamsSpec.$,CrosNetworkConfig_RequestTrafficCounters_ResponseParamsSpec.$,impl.requestTrafficCounters.bind(impl),false);this.helper_internal_.registerHandler(22,CrosNetworkConfig_ResetTrafficCounters_ParamsSpec.$,null,impl.resetTrafficCounters.bind(impl),false);this.helper_internal_.registerHandler(23,CrosNetworkConfig_SetTrafficCountersResetDay_ParamsSpec.$,CrosNetworkConfig_SetTrafficCountersResetDay_ResponseParamsSpec.$,impl.setTrafficCountersResetDay.bind(impl),false);this.helper_internal_.registerHandler(24,CrosNetworkConfig_CreateCustomApn_ParamsSpec.$,CrosNetworkConfig_CreateCustomApn_ResponseParamsSpec.$,impl.createCustomApn.bind(impl),false);this.helper_internal_.registerHandler(25,CrosNetworkConfig_CreateExclusivelyEnabledCustomApn_ParamsSpec.$,CrosNetworkConfig_CreateExclusivelyEnabledCustomApn_ResponseParamsSpec.$,impl.createExclusivelyEnabledCustomApn.bind(impl),false);this.helper_internal_.registerHandler(26,CrosNetworkConfig_RemoveCustomApn_ParamsSpec.$,null,impl.removeCustomApn.bind(impl),false);this.helper_internal_.registerHandler(27,CrosNetworkConfig_ModifyCustomApn_ParamsSpec.$,null,impl.modifyCustomApn.bind(impl),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}}export class CrosNetworkConfig{static get $interfaceName(){return"chromeos.network_config.mojom.CrosNetworkConfig"}static getRemote(){let remote=new CrosNetworkConfigRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}export class CrosNetworkConfigCallbackRouter{helper_internal_;$;router_;addObserver;getNetworkState;getNetworkStateList;getDeviceStateList;getManagedProperties;setProperties;configureNetwork;forgetNetwork;setNetworkTypeEnabledState;setCellularSimState;selectCellularMobileNetwork;requestNetworkScan;getGlobalPolicy;startConnect;startDisconnect;setVpnProviders;getVpnProviders;getNetworkCertificates;getAlwaysOnVpn;setAlwaysOnVpn;getSupportedVpnTypes;requestTrafficCounters;resetTrafficCounters;setTrafficCountersResetDay;createCustomApn;createExclusivelyEnabledCustomApn;removeCustomApn;modifyCustomApn;onConnectionError;constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(CrosNetworkConfigRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.addObserver=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,CrosNetworkConfig_AddObserver_ParamsSpec.$,null,this.addObserver.createReceiverHandler(false),false);this.getNetworkState=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(1,CrosNetworkConfig_GetNetworkState_ParamsSpec.$,CrosNetworkConfig_GetNetworkState_ResponseParamsSpec.$,this.getNetworkState.createReceiverHandler(true),false);this.getNetworkStateList=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(2,CrosNetworkConfig_GetNetworkStateList_ParamsSpec.$,CrosNetworkConfig_GetNetworkStateList_ResponseParamsSpec.$,this.getNetworkStateList.createReceiverHandler(true),false);this.getDeviceStateList=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(3,CrosNetworkConfig_GetDeviceStateList_ParamsSpec.$,CrosNetworkConfig_GetDeviceStateList_ResponseParamsSpec.$,this.getDeviceStateList.createReceiverHandler(true),false);this.getManagedProperties=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(4,CrosNetworkConfig_GetManagedProperties_ParamsSpec.$,CrosNetworkConfig_GetManagedProperties_ResponseParamsSpec.$,this.getManagedProperties.createReceiverHandler(true),false);this.setProperties=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(5,CrosNetworkConfig_SetProperties_ParamsSpec.$,CrosNetworkConfig_SetProperties_ResponseParamsSpec.$,this.setProperties.createReceiverHandler(true),false);this.configureNetwork=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(6,CrosNetworkConfig_ConfigureNetwork_ParamsSpec.$,CrosNetworkConfig_ConfigureNetwork_ResponseParamsSpec.$,this.configureNetwork.createReceiverHandler(true),false);this.forgetNetwork=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(7,CrosNetworkConfig_ForgetNetwork_ParamsSpec.$,CrosNetworkConfig_ForgetNetwork_ResponseParamsSpec.$,this.forgetNetwork.createReceiverHandler(true),false);this.setNetworkTypeEnabledState=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(8,CrosNetworkConfig_SetNetworkTypeEnabledState_ParamsSpec.$,CrosNetworkConfig_SetNetworkTypeEnabledState_ResponseParamsSpec.$,this.setNetworkTypeEnabledState.createReceiverHandler(true),false);this.setCellularSimState=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(9,CrosNetworkConfig_SetCellularSimState_ParamsSpec.$,CrosNetworkConfig_SetCellularSimState_ResponseParamsSpec.$,this.setCellularSimState.createReceiverHandler(true),false);this.selectCellularMobileNetwork=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(10,CrosNetworkConfig_SelectCellularMobileNetwork_ParamsSpec.$,CrosNetworkConfig_SelectCellularMobileNetwork_ResponseParamsSpec.$,this.selectCellularMobileNetwork.createReceiverHandler(true),false);this.requestNetworkScan=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(11,CrosNetworkConfig_RequestNetworkScan_ParamsSpec.$,null,this.requestNetworkScan.createReceiverHandler(false),false);this.getGlobalPolicy=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(12,CrosNetworkConfig_GetGlobalPolicy_ParamsSpec.$,CrosNetworkConfig_GetGlobalPolicy_ResponseParamsSpec.$,this.getGlobalPolicy.createReceiverHandler(true),false);this.startConnect=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(13,CrosNetworkConfig_StartConnect_ParamsSpec.$,CrosNetworkConfig_StartConnect_ResponseParamsSpec.$,this.startConnect.createReceiverHandler(true),false);this.startDisconnect=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(14,CrosNetworkConfig_StartDisconnect_ParamsSpec.$,CrosNetworkConfig_StartDisconnect_ResponseParamsSpec.$,this.startDisconnect.createReceiverHandler(true),false);this.setVpnProviders=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(15,CrosNetworkConfig_SetVpnProviders_ParamsSpec.$,null,this.setVpnProviders.createReceiverHandler(false),false);this.getVpnProviders=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(16,CrosNetworkConfig_GetVpnProviders_ParamsSpec.$,CrosNetworkConfig_GetVpnProviders_ResponseParamsSpec.$,this.getVpnProviders.createReceiverHandler(true),false);this.getNetworkCertificates=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(17,CrosNetworkConfig_GetNetworkCertificates_ParamsSpec.$,CrosNetworkConfig_GetNetworkCertificates_ResponseParamsSpec.$,this.getNetworkCertificates.createReceiverHandler(true),false);this.getAlwaysOnVpn=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(18,CrosNetworkConfig_GetAlwaysOnVpn_ParamsSpec.$,CrosNetworkConfig_GetAlwaysOnVpn_ResponseParamsSpec.$,this.getAlwaysOnVpn.createReceiverHandler(true),false);this.setAlwaysOnVpn=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(19,CrosNetworkConfig_SetAlwaysOnVpn_ParamsSpec.$,null,this.setAlwaysOnVpn.createReceiverHandler(false),false);this.getSupportedVpnTypes=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(20,CrosNetworkConfig_GetSupportedVpnTypes_ParamsSpec.$,CrosNetworkConfig_GetSupportedVpnTypes_ResponseParamsSpec.$,this.getSupportedVpnTypes.createReceiverHandler(true),false);this.requestTrafficCounters=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(21,CrosNetworkConfig_RequestTrafficCounters_ParamsSpec.$,CrosNetworkConfig_RequestTrafficCounters_ResponseParamsSpec.$,this.requestTrafficCounters.createReceiverHandler(true),false);this.resetTrafficCounters=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(22,CrosNetworkConfig_ResetTrafficCounters_ParamsSpec.$,null,this.resetTrafficCounters.createReceiverHandler(false),false);this.setTrafficCountersResetDay=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(23,CrosNetworkConfig_SetTrafficCountersResetDay_ParamsSpec.$,CrosNetworkConfig_SetTrafficCountersResetDay_ResponseParamsSpec.$,this.setTrafficCountersResetDay.createReceiverHandler(true),false);this.createCustomApn=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(24,CrosNetworkConfig_CreateCustomApn_ParamsSpec.$,CrosNetworkConfig_CreateCustomApn_ResponseParamsSpec.$,this.createCustomApn.createReceiverHandler(true),false);this.createExclusivelyEnabledCustomApn=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(25,CrosNetworkConfig_CreateExclusivelyEnabledCustomApn_ParamsSpec.$,CrosNetworkConfig_CreateExclusivelyEnabledCustomApn_ResponseParamsSpec.$,this.createExclusivelyEnabledCustomApn.createReceiverHandler(true),false);this.removeCustomApn=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(26,CrosNetworkConfig_RemoveCustomApn_ParamsSpec.$,null,this.removeCustomApn.createReceiverHandler(false),false);this.modifyCustomApn=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(27,CrosNetworkConfig_ModifyCustomApn_ParamsSpec.$,null,this.modifyCustomApn.createReceiverHandler(false),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}export class CrosNetworkConfigObserverPendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"chromeos.network_config.mojom.CrosNetworkConfigObserver",scope)}}export class CrosNetworkConfigObserverRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(CrosNetworkConfigObserverPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}onActiveNetworksChanged(networks){this.proxy.sendMessage(0,CrosNetworkConfigObserver_OnActiveNetworksChanged_ParamsSpec.$,null,[networks],false)}onNetworkStateChanged(network){this.proxy.sendMessage(1,CrosNetworkConfigObserver_OnNetworkStateChanged_ParamsSpec.$,null,[network],false)}onNetworkStateListChanged(){this.proxy.sendMessage(2,CrosNetworkConfigObserver_OnNetworkStateListChanged_ParamsSpec.$,null,[],false)}onDeviceStateListChanged(){this.proxy.sendMessage(3,CrosNetworkConfigObserver_OnDeviceStateListChanged_ParamsSpec.$,null,[],false)}onVpnProvidersChanged(){this.proxy.sendMessage(4,CrosNetworkConfigObserver_OnVpnProvidersChanged_ParamsSpec.$,null,[],false)}onNetworkCertificatesChanged(){this.proxy.sendMessage(5,CrosNetworkConfigObserver_OnNetworkCertificatesChanged_ParamsSpec.$,null,[],false)}onPoliciesApplied(userhash){this.proxy.sendMessage(6,CrosNetworkConfigObserver_OnPoliciesApplied_ParamsSpec.$,null,[userhash],false)}}export class CrosNetworkConfigObserverReceiver{helper_internal_;$;onConnectionError;constructor(impl){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(CrosNetworkConfigObserverRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.helper_internal_.registerHandler(0,CrosNetworkConfigObserver_OnActiveNetworksChanged_ParamsSpec.$,null,impl.onActiveNetworksChanged.bind(impl),false);this.helper_internal_.registerHandler(1,CrosNetworkConfigObserver_OnNetworkStateChanged_ParamsSpec.$,null,impl.onNetworkStateChanged.bind(impl),false);this.helper_internal_.registerHandler(2,CrosNetworkConfigObserver_OnNetworkStateListChanged_ParamsSpec.$,null,impl.onNetworkStateListChanged.bind(impl),false);this.helper_internal_.registerHandler(3,CrosNetworkConfigObserver_OnDeviceStateListChanged_ParamsSpec.$,null,impl.onDeviceStateListChanged.bind(impl),false);this.helper_internal_.registerHandler(4,CrosNetworkConfigObserver_OnVpnProvidersChanged_ParamsSpec.$,null,impl.onVpnProvidersChanged.bind(impl),false);this.helper_internal_.registerHandler(5,CrosNetworkConfigObserver_OnNetworkCertificatesChanged_ParamsSpec.$,null,impl.onNetworkCertificatesChanged.bind(impl),false);this.helper_internal_.registerHandler(6,CrosNetworkConfigObserver_OnPoliciesApplied_ParamsSpec.$,null,impl.onPoliciesApplied.bind(impl),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}}export class CrosNetworkConfigObserver{static get $interfaceName(){return"chromeos.network_config.mojom.CrosNetworkConfigObserver"}static getRemote(){let remote=new CrosNetworkConfigObserverRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}export class CrosNetworkConfigObserverCallbackRouter{helper_internal_;$;router_;onActiveNetworksChanged;onNetworkStateChanged;onNetworkStateListChanged;onDeviceStateListChanged;onVpnProvidersChanged;onNetworkCertificatesChanged;onPoliciesApplied;onConnectionError;constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(CrosNetworkConfigObserverRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.onActiveNetworksChanged=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,CrosNetworkConfigObserver_OnActiveNetworksChanged_ParamsSpec.$,null,this.onActiveNetworksChanged.createReceiverHandler(false),false);this.onNetworkStateChanged=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(1,CrosNetworkConfigObserver_OnNetworkStateChanged_ParamsSpec.$,null,this.onNetworkStateChanged.createReceiverHandler(false),false);this.onNetworkStateListChanged=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(2,CrosNetworkConfigObserver_OnNetworkStateListChanged_ParamsSpec.$,null,this.onNetworkStateListChanged.createReceiverHandler(false),false);this.onDeviceStateListChanged=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(3,CrosNetworkConfigObserver_OnDeviceStateListChanged_ParamsSpec.$,null,this.onDeviceStateListChanged.createReceiverHandler(false),false);this.onVpnProvidersChanged=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(4,CrosNetworkConfigObserver_OnVpnProvidersChanged_ParamsSpec.$,null,this.onVpnProvidersChanged.createReceiverHandler(false),false);this.onNetworkCertificatesChanged=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(5,CrosNetworkConfigObserver_OnNetworkCertificatesChanged_ParamsSpec.$,null,this.onNetworkCertificatesChanged.createReceiverHandler(false),false);this.onPoliciesApplied=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(6,CrosNetworkConfigObserver_OnPoliciesApplied_ParamsSpec.$,null,this.onPoliciesApplied.createReceiverHandler(false),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}export const SIMLockStatusSpec={$:{}};export const SIMInfoSpec={$:{}};export const CellularStatePropertiesSpec={$:{}};export const EthernetStatePropertiesSpec={$:{}};export const TetherStatePropertiesSpec={$:{}};export const VPNStatePropertiesSpec={$:{}};export const WiFiStatePropertiesSpec={$:{}};export const NetworkStatePropertiesSpec={$:{}};export const DeviceStatePropertiesSpec={$:{}};export const NetworkFilterSpec={$:{}};export const ApnPropertiesSpec={$:{}};export const RoamingPropertiesSpec={$:{}};export const CellularProviderPropertiesSpec={$:{}};export const FoundNetworkPropertiesSpec={$:{}};export const IPConfigPropertiesSpec={$:{}};export const PaymentPortalPropertiesSpec={$:{}};export const WireGuardPeerPropertiesSpec={$:{}};export const ManagedBooleanSpec={$:{}};export const ManagedInt32Spec={$:{}};export const ManagedStringSpec={$:{}};export const ManagedStringListSpec={$:{}};export const ManagedApnPropertiesSpec={$:{}};export const ManagedApnListSpec={$:{}};export const ManagedIssuerSubjectPatternSpec={$:{}};export const ManagedCertificatePatternSpec={$:{}};export const ManagedEAPPropertiesSpec={$:{}};export const ManagedSubjectAltNameMatchListSpec={$:{}};export const ManagedIPConfigPropertiesSpec={$:{}};export const ManagedIPSecPropertiesSpec={$:{}};export const ManagedL2TPPropertiesSpec={$:{}};export const ManagedProxyLocationSpec={$:{}};export const ManagedManualProxySettingsSpec={$:{}};export const ManagedProxySettingsSpec={$:{}};export const ManagedVerifyX509PropertiesSpec={$:{}};export const ManagedOpenVPNPropertiesSpec={$:{}};export const ManagedWireGuardPeerListSpec={$:{}};export const ManagedWireGuardPropertiesSpec={$:{}};export const ManagedCellularPropertiesSpec={$:{}};export const ManagedEthernetPropertiesSpec={$:{}};export const ManagedVPNPropertiesSpec={$:{}};export const ManagedWiFiPropertiesSpec={$:{}};export const UInt32ValueSpec={$:{}};export const TrafficCounterPropertiesSpec={$:{}};export const ManagedPropertiesSpec={$:{}};export const AutoConnectConfigSpec={$:{}};export const MeteredConfigSpec={$:{}};export const PriorityConfigSpec={$:{}};export const VpnTypeConfigSpec={$:{}};export const ProxyLocationSpec={$:{}};export const ManualProxySettingsSpec={$:{}};export const ProxySettingsSpec={$:{}};export const EAPConfigPropertiesSpec={$:{}};export const SubjectAltNameSpec={$:{}};export const IPSecConfigPropertiesSpec={$:{}};export const L2TPConfigPropertiesSpec={$:{}};export const OpenVPNConfigPropertiesSpec={$:{}};export const WireGuardConfigPropertiesSpec={$:{}};export const TextMessagesAllowStateSpec={$:{}};export const CellularConfigPropertiesSpec={$:{}};export const EthernetConfigPropertiesSpec={$:{}};export const VPNConfigPropertiesSpec={$:{}};export const WiFiConfigPropertiesSpec={$:{}};export const ConfigPropertiesSpec={$:{}};export const CellularSimStateSpec={$:{}};export const GlobalPolicySpec={$:{}};export const VpnProviderSpec={$:{}};export const NetworkCertificateSpec={$:{}};export const AlwaysOnVpnPropertiesSpec={$:{}};export const TrafficCounterSpec={$:{}};export const CrosNetworkConfig_AddObserver_ParamsSpec={$:{}};export const CrosNetworkConfig_GetNetworkState_ParamsSpec={$:{}};export const CrosNetworkConfig_GetNetworkState_ResponseParamsSpec={$:{}};export const CrosNetworkConfig_GetNetworkStateList_ParamsSpec={$:{}};export const CrosNetworkConfig_GetNetworkStateList_ResponseParamsSpec={$:{}};export const CrosNetworkConfig_GetDeviceStateList_ParamsSpec={$:{}};export const CrosNetworkConfig_GetDeviceStateList_ResponseParamsSpec={$:{}};export const CrosNetworkConfig_GetManagedProperties_ParamsSpec={$:{}};export const CrosNetworkConfig_GetManagedProperties_ResponseParamsSpec={$:{}};export const CrosNetworkConfig_SetProperties_ParamsSpec={$:{}};export const CrosNetworkConfig_SetProperties_ResponseParamsSpec={$:{}};export const CrosNetworkConfig_ConfigureNetwork_ParamsSpec={$:{}};export const CrosNetworkConfig_ConfigureNetwork_ResponseParamsSpec={$:{}};export const CrosNetworkConfig_ForgetNetwork_ParamsSpec={$:{}};export const CrosNetworkConfig_ForgetNetwork_ResponseParamsSpec={$:{}};export const CrosNetworkConfig_SetNetworkTypeEnabledState_ParamsSpec={$:{}};export const CrosNetworkConfig_SetNetworkTypeEnabledState_ResponseParamsSpec={$:{}};export const CrosNetworkConfig_SetCellularSimState_ParamsSpec={$:{}};export const CrosNetworkConfig_SetCellularSimState_ResponseParamsSpec={$:{}};export const CrosNetworkConfig_SelectCellularMobileNetwork_ParamsSpec={$:{}};export const CrosNetworkConfig_SelectCellularMobileNetwork_ResponseParamsSpec={$:{}};export const CrosNetworkConfig_RequestNetworkScan_ParamsSpec={$:{}};export const CrosNetworkConfig_GetGlobalPolicy_ParamsSpec={$:{}};export const CrosNetworkConfig_GetGlobalPolicy_ResponseParamsSpec={$:{}};export const CrosNetworkConfig_StartConnect_ParamsSpec={$:{}};export const CrosNetworkConfig_StartConnect_ResponseParamsSpec={$:{}};export const CrosNetworkConfig_StartDisconnect_ParamsSpec={$:{}};export const CrosNetworkConfig_StartDisconnect_ResponseParamsSpec={$:{}};export const CrosNetworkConfig_SetVpnProviders_ParamsSpec={$:{}};export const CrosNetworkConfig_GetVpnProviders_ParamsSpec={$:{}};export const CrosNetworkConfig_GetVpnProviders_ResponseParamsSpec={$:{}};export const CrosNetworkConfig_GetNetworkCertificates_ParamsSpec={$:{}};export const CrosNetworkConfig_GetNetworkCertificates_ResponseParamsSpec={$:{}};export const CrosNetworkConfig_GetAlwaysOnVpn_ParamsSpec={$:{}};export const CrosNetworkConfig_GetAlwaysOnVpn_ResponseParamsSpec={$:{}};export const CrosNetworkConfig_SetAlwaysOnVpn_ParamsSpec={$:{}};export const CrosNetworkConfig_GetSupportedVpnTypes_ParamsSpec={$:{}};export const CrosNetworkConfig_GetSupportedVpnTypes_ResponseParamsSpec={$:{}};export const CrosNetworkConfig_RequestTrafficCounters_ParamsSpec={$:{}};export const CrosNetworkConfig_RequestTrafficCounters_ResponseParamsSpec={$:{}};export const CrosNetworkConfig_ResetTrafficCounters_ParamsSpec={$:{}};export const CrosNetworkConfig_SetTrafficCountersResetDay_ParamsSpec={$:{}};export const CrosNetworkConfig_SetTrafficCountersResetDay_ResponseParamsSpec={$:{}};export const CrosNetworkConfig_CreateCustomApn_ParamsSpec={$:{}};export const CrosNetworkConfig_CreateCustomApn_ResponseParamsSpec={$:{}};export const CrosNetworkConfig_CreateExclusivelyEnabledCustomApn_ParamsSpec={$:{}};export const CrosNetworkConfig_CreateExclusivelyEnabledCustomApn_ResponseParamsSpec={$:{}};export const CrosNetworkConfig_RemoveCustomApn_ParamsSpec={$:{}};export const CrosNetworkConfig_ModifyCustomApn_ParamsSpec={$:{}};export const CrosNetworkConfigObserver_OnActiveNetworksChanged_ParamsSpec={$:{}};export const CrosNetworkConfigObserver_OnNetworkStateChanged_ParamsSpec={$:{}};export const CrosNetworkConfigObserver_OnNetworkStateListChanged_ParamsSpec={$:{}};export const CrosNetworkConfigObserver_OnDeviceStateListChanged_ParamsSpec={$:{}};export const CrosNetworkConfigObserver_OnVpnProvidersChanged_ParamsSpec={$:{}};export const CrosNetworkConfigObserver_OnNetworkCertificatesChanged_ParamsSpec={$:{}};export const CrosNetworkConfigObserver_OnPoliciesApplied_ParamsSpec={$:{}};export const NetworkTypeStatePropertiesSpec={$:{}};export const NetworkTypeManagedPropertiesSpec={$:{}};export const NetworkTypeConfigPropertiesSpec={$:{}};mojo.internal.Struct(SIMLockStatusSpec.$,"SIMLockStatus",[mojo.internal.StructField("lockType",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("lockEnabled",8,0,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("retriesLeft",12,0,mojo.internal.Int32,0,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(SIMInfoSpec.$,"SIMInfo",[mojo.internal.StructField("slotId",0,0,mojo.internal.Int32,0,false,0,undefined,undefined),mojo.internal.StructField("eid",8,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("iccid",16,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("isPrimary",4,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,32]]);mojo.internal.Struct(CellularStatePropertiesSpec.$,"CellularStateProperties",[mojo.internal.StructField("iccid",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("eid",8,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("activationState",16,0,ActivationStateTypeSpec.$,ActivationStateType.kUnknown,false,0,undefined,undefined),mojo.internal.StructField("networkTechnology",24,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("roaming",20,0,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("signalStrength",32,0,mojo.internal.Int32,0,false,0,undefined,undefined),mojo.internal.StructField("simLockEnabled",20,1,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("simLocked",20,2,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("simLockType",40,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("hasNickName",20,3,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("networkOperator",48,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("paymentPortal",56,0,PaymentPortalPropertiesSpec.$,null,true,0,undefined,undefined)],[[0,72]]);mojo.internal.Struct(EthernetStatePropertiesSpec.$,"EthernetStateProperties",[mojo.internal.StructField("authentication",0,0,AuthenticationTypeSpec.$,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(TetherStatePropertiesSpec.$,"TetherStateProperties",[mojo.internal.StructField("batteryPercentage",0,0,mojo.internal.Int32,0,false,0,undefined,undefined),mojo.internal.StructField("carrier",8,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("hasConnectedToHost",4,0,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("signalStrength",16,0,mojo.internal.Int32,0,false,0,undefined,undefined)],[[0,32]]);mojo.internal.Struct(VPNStatePropertiesSpec.$,"VPNStateProperties",[mojo.internal.StructField("type",0,0,VpnTypeSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("providerId",8,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("providerName",16,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,32]]);mojo.internal.Struct(WiFiStatePropertiesSpec.$,"WiFiStateProperties",[mojo.internal.StructField("bssid",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("frequency",8,0,mojo.internal.Int32,0,false,0,undefined,undefined),mojo.internal.StructField("hexSsid",16,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("security",12,0,SecurityTypeSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("signalStrength",24,0,mojo.internal.Int32,0,false,0,undefined,undefined),mojo.internal.StructField("ssid",32,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("visible",28,0,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("hiddenSsid",28,1,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("passpointId",40,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,56]]);mojo.internal.Struct(NetworkStatePropertiesSpec.$,"NetworkStateProperties",[mojo.internal.StructField("connectable",0,0,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("connectRequested",0,1,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("connectionState",4,0,chromeos_networkConfig_mojom_ConnectionStateTypeSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("errorState",8,0,mojo.internal.String,null,true,0,undefined,undefined),mojo.internal.StructField("guid",16,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("name",24,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("portalState",32,0,chromeos_networkConfig_mojom_PortalStateSpec.$,chromeos_networkConfig_mojom_PortalState.kUnknown,false,0,undefined,undefined),mojo.internal.StructField("portalProbeUrl",40,0,url_mojom_UrlSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("priority",36,0,mojo.internal.Int32,0,false,0,undefined,undefined),mojo.internal.StructField("proxyMode",48,0,ProxyModeSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("prohibitedByPolicy",0,2,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("source",52,0,chromeos_networkConfig_mojom_OncSourceSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("type",56,0,chromeos_networkConfig_mojom_NetworkTypeSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("typeState",64,0,NetworkTypeStatePropertiesSpec.$,null,false,0,undefined,undefined)],[[0,88]]);mojo.internal.Struct(DeviceStatePropertiesSpec.$,"DeviceStateProperties",[mojo.internal.StructField("ipv4Address",0,0,network_mojom_IPAddressSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("ipv6Address",8,0,network_mojom_IPAddressSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("imei",16,0,mojo.internal.String,null,true,0,undefined,undefined),mojo.internal.StructField("macAddress",24,0,mojo.internal.String,null,true,0,undefined,undefined),mojo.internal.StructField("scanning",32,0,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("simLockStatus",40,0,SIMLockStatusSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("simInfos",48,0,mojo.internal.Array(SIMInfoSpec.$,false),null,true,0,undefined,undefined),mojo.internal.StructField("inhibitReason",36,0,InhibitReasonSpec.$,InhibitReason.kNotInhibited,false,0,undefined,undefined),mojo.internal.StructField("simAbsent",32,1,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("deviceState",56,0,chromeos_networkConfig_mojom_DeviceStateTypeSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("type",60,0,chromeos_networkConfig_mojom_NetworkTypeSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("managedNetworkAvailable",32,2,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("serial",64,0,mojo.internal.String,null,true,0,undefined,undefined),mojo.internal.StructField("isCarrierLocked",32,3,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("isFlashing",32,4,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,80]]);mojo.internal.Struct(NetworkFilterSpec.$,"NetworkFilter",[mojo.internal.StructField("filter",0,0,FilterTypeSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("networkType",4,0,chromeos_networkConfig_mojom_NetworkTypeSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("limit",8,0,mojo.internal.Int32,NO_LIMIT,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(ApnPropertiesSpec.$,"ApnProperties",[mojo.internal.StructField("accessPointName",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("id",8,0,mojo.internal.String,null,true,0,undefined,undefined),mojo.internal.StructField("authentication",16,0,ApnAuthenticationTypeSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("language",24,0,mojo.internal.String,null,true,0,undefined,undefined),mojo.internal.StructField("localizedName",32,0,mojo.internal.String,null,true,0,undefined,undefined),mojo.internal.StructField("name",40,0,mojo.internal.String,null,true,0,undefined,undefined),mojo.internal.StructField("password",48,0,mojo.internal.String,null,true,0,undefined,undefined),mojo.internal.StructField("username",56,0,mojo.internal.String,null,true,0,undefined,undefined),mojo.internal.StructField("attach",64,0,mojo.internal.String,null,true,0,undefined,undefined),mojo.internal.StructField("state",20,0,ApnStateSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("ipType",72,0,ApnIpTypeSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("apnTypes",80,0,mojo.internal.Array(ApnTypeSpec.$,false),null,false,0,undefined,undefined),mojo.internal.StructField("source",76,0,ApnSourceSpec.$,0,false,0,undefined,undefined)],[[0,96]]);mojo.internal.Struct(RoamingPropertiesSpec.$,"RoamingProperties",[mojo.internal.StructField("allowRoaming",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(CellularProviderPropertiesSpec.$,"CellularProviderProperties",[mojo.internal.StructField("name",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("code",8,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("country",16,0,mojo.internal.String,null,true,0,undefined,undefined)],[[0,32]]);mojo.internal.Struct(FoundNetworkPropertiesSpec.$,"FoundNetworkProperties",[mojo.internal.StructField("status",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("networkId",8,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("technology",16,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("shortName",24,0,mojo.internal.String,null,true,0,undefined,undefined),mojo.internal.StructField("longName",32,0,mojo.internal.String,null,true,0,undefined,undefined)],[[0,48]]);mojo.internal.Struct(IPConfigPropertiesSpec.$,"IPConfigProperties",[mojo.internal.StructField("gateway",0,0,mojo.internal.String,null,true,0,undefined,undefined),mojo.internal.StructField("ipAddress",8,0,mojo.internal.String,null,true,0,undefined,undefined),mojo.internal.StructField("excludedRoutes",16,0,mojo.internal.Array(mojo.internal.String,false),null,true,0,undefined,undefined),mojo.internal.StructField("includedRoutes",24,0,mojo.internal.Array(mojo.internal.String,false),null,true,0,undefined,undefined),mojo.internal.StructField("nameServers",32,0,mojo.internal.Array(mojo.internal.String,false),null,true,0,undefined,undefined),mojo.internal.StructField("searchDomains",40,0,mojo.internal.Array(mojo.internal.String,false),null,true,0,undefined,undefined),mojo.internal.StructField("routingPrefix",48,0,mojo.internal.Int32,NO_ROUTING_PREFIX,false,0,undefined,undefined),mojo.internal.StructField("type",52,0,chromeos_networkConfig_mojom_IPConfigTypeSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("webProxyAutoDiscoveryUrl",56,0,mojo.internal.String,null,true,0,undefined,undefined)],[[0,72]]);mojo.internal.Struct(PaymentPortalPropertiesSpec.$,"PaymentPortalProperties",[mojo.internal.StructField("method",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("postData",8,0,mojo.internal.String,null,true,0,undefined,undefined),mojo.internal.StructField("url",16,0,mojo.internal.String,null,true,0,undefined,undefined)],[[0,32]]);mojo.internal.Struct(WireGuardPeerPropertiesSpec.$,"WireGuardPeerProperties",[mojo.internal.StructField("publicKey",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("presharedKey",8,0,mojo.internal.String,null,true,0,undefined,undefined),mojo.internal.StructField("allowedIps",16,0,mojo.internal.String,null,true,0,undefined,undefined),mojo.internal.StructField("endpoint",24,0,mojo.internal.String,null,true,0,undefined,undefined),mojo.internal.StructField("persistentKeepaliveInterval",32,0,mojo.internal.Int32,0,false,0,undefined,undefined)],[[0,48]]);mojo.internal.Struct(ManagedBooleanSpec.$,"ManagedBoolean",[mojo.internal.StructField("activeValue",0,0,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("policySource",4,0,chromeos_networkConfig_mojom_PolicySourceSpec.$,chromeos_networkConfig_mojom_PolicySource.kNone,false,0,undefined,undefined),mojo.internal.StructField("policyValue",0,1,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(ManagedInt32Spec.$,"ManagedInt32",[mojo.internal.StructField("activeValue",0,0,mojo.internal.Int32,0,false,0,undefined,undefined),mojo.internal.StructField("policySource",4,0,chromeos_networkConfig_mojom_PolicySourceSpec.$,chromeos_networkConfig_mojom_PolicySource.kNone,false,0,undefined,undefined),mojo.internal.StructField("policyValue",8,0,mojo.internal.Int32,0,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(ManagedStringSpec.$,"ManagedString",[mojo.internal.StructField("activeValue",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("policySource",8,0,chromeos_networkConfig_mojom_PolicySourceSpec.$,chromeos_networkConfig_mojom_PolicySource.kNone,false,0,undefined,undefined),mojo.internal.StructField("policyValue",16,0,mojo.internal.String,null,true,0,undefined,undefined)],[[0,32]]);mojo.internal.Struct(ManagedStringListSpec.$,"ManagedStringList",[mojo.internal.StructField("activeValue",0,0,mojo.internal.Array(mojo.internal.String,false),null,false,0,undefined,undefined),mojo.internal.StructField("policySource",8,0,chromeos_networkConfig_mojom_PolicySourceSpec.$,chromeos_networkConfig_mojom_PolicySource.kNone,false,0,undefined,undefined),mojo.internal.StructField("policyValue",16,0,mojo.internal.Array(mojo.internal.String,false),null,true,0,undefined,undefined)],[[0,32]]);mojo.internal.Struct(ManagedApnPropertiesSpec.$,"ManagedApnProperties",[mojo.internal.StructField("accessPointName",0,0,ManagedStringSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("authentication",8,0,ManagedStringSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("language",16,0,ManagedStringSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("localizedName",24,0,ManagedStringSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("name",32,0,ManagedStringSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("password",40,0,ManagedStringSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("username",48,0,ManagedStringSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("attach",56,0,ManagedStringSpec.$,null,true,0,undefined,undefined)],[[0,72]]);mojo.internal.Struct(ManagedApnListSpec.$,"ManagedApnList",[mojo.internal.StructField("activeValue",0,0,mojo.internal.Array(ApnPropertiesSpec.$,false),null,false,0,undefined,undefined),mojo.internal.StructField("policySource",8,0,chromeos_networkConfig_mojom_PolicySourceSpec.$,chromeos_networkConfig_mojom_PolicySource.kNone,false,0,undefined,undefined),mojo.internal.StructField("policyValue",16,0,mojo.internal.Array(ApnPropertiesSpec.$,false),null,true,0,undefined,undefined)],[[0,32]]);mojo.internal.Struct(ManagedIssuerSubjectPatternSpec.$,"ManagedIssuerSubjectPattern",[mojo.internal.StructField("commonName",0,0,ManagedStringSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("locality",8,0,ManagedStringSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("organization",16,0,ManagedStringSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("organizationalUnit",24,0,ManagedStringSpec.$,null,true,0,undefined,undefined)],[[0,40]]);mojo.internal.Struct(ManagedCertificatePatternSpec.$,"ManagedCertificatePattern",[mojo.internal.StructField("enrollmentUri",0,0,ManagedStringListSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("issuer",8,0,ManagedIssuerSubjectPatternSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("issuerCaRef",16,0,ManagedStringListSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("subject",24,0,ManagedIssuerSubjectPatternSpec.$,null,true,0,undefined,undefined)],[[0,40]]);mojo.internal.Struct(ManagedEAPPropertiesSpec.$,"ManagedEAPProperties",[mojo.internal.StructField("anonymousIdentity",0,0,ManagedStringSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("clientCertPattern",8,0,ManagedCertificatePatternSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("clientCertPkcs11Id",16,0,ManagedStringSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("clientCertProvisioningProfileId",24,0,ManagedStringSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("clientCertRef",32,0,ManagedStringSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("clientCertType",40,0,ManagedStringSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("domainSuffixMatch",48,0,ManagedStringListSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("identity",56,0,ManagedStringSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("inner",64,0,ManagedStringSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("outer",72,0,ManagedStringSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("password",80,0,ManagedStringSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("saveCredentials",88,0,ManagedBooleanSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("serverCaPems",96,0,ManagedStringListSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("serverCaRefs",104,0,ManagedStringListSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("subjectAltNameMatch",112,0,ManagedSubjectAltNameMatchListSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("subjectMatch",120,0,ManagedStringSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("tlsVersionMax",128,0,ManagedStringSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("useProactiveKeyCaching",136,0,ManagedBooleanSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("useSystemCas",144,0,ManagedBooleanSpec.$,null,true,0,undefined,undefined)],[[0,160]]);mojo.internal.Struct(ManagedSubjectAltNameMatchListSpec.$,"ManagedSubjectAltNameMatchList",[mojo.internal.StructField("activeValue",0,0,mojo.internal.Array(SubjectAltNameSpec.$,false),null,false,0,undefined,undefined),mojo.internal.StructField("policySource",8,0,chromeos_networkConfig_mojom_PolicySourceSpec.$,chromeos_networkConfig_mojom_PolicySource.kNone,false,0,undefined,undefined),mojo.internal.StructField("policyValue",16,0,mojo.internal.Array(SubjectAltNameSpec.$,false),null,false,0,undefined,undefined)],[[0,32]]);mojo.internal.Struct(ManagedIPConfigPropertiesSpec.$,"ManagedIPConfigProperties",[mojo.internal.StructField("gateway",0,0,ManagedStringSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("ipAddress",8,0,ManagedStringSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("nameServers",16,0,ManagedStringListSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("routingPrefix",24,0,ManagedInt32Spec.$,null,true,0,undefined,undefined),mojo.internal.StructField("type",32,0,chromeos_networkConfig_mojom_IPConfigTypeSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("webProxyAutoDiscoveryUrl",40,0,ManagedStringSpec.$,null,true,0,undefined,undefined)],[[0,56]]);mojo.internal.Struct(ManagedIPSecPropertiesSpec.$,"ManagedIPSecProperties",[mojo.internal.StructField("authenticationType",0,0,ManagedStringSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("clientCertPattern",8,0,ManagedCertificatePatternSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("clientCertPkcs11Id",16,0,ManagedStringSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("clientCertProvisioningProfileId",24,0,ManagedStringSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("clientCertRef",32,0,ManagedStringSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("clientCertType",40,0,ManagedStringSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("eap",48,0,ManagedEAPPropertiesSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("group",56,0,ManagedStringSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("ikeVersion",64,0,ManagedInt32Spec.$,null,true,0,undefined,undefined),mojo.internal.StructField("localIdentity",72,0,ManagedStringSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("psk",80,0,ManagedStringSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("remoteIdentity",88,0,ManagedStringSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("saveCredentials",96,0,ManagedBooleanSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("serverCaPems",104,0,ManagedStringListSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("serverCaRefs",112,0,ManagedStringListSpec.$,null,true,0,undefined,undefined)],[[0,128]]);mojo.internal.Struct(ManagedL2TPPropertiesSpec.$,"ManagedL2TPProperties",[mojo.internal.StructField("lcpEchoDisabled",0,0,ManagedBooleanSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("password",8,0,ManagedStringSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("saveCredentials",16,0,ManagedBooleanSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("username",24,0,ManagedStringSpec.$,null,true,0,undefined,undefined)],[[0,40]]);mojo.internal.Struct(ManagedProxyLocationSpec.$,"ManagedProxyLocation",[mojo.internal.StructField("host",0,0,ManagedStringSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("port",8,0,ManagedInt32Spec.$,null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(ManagedManualProxySettingsSpec.$,"ManagedManualProxySettings",[mojo.internal.StructField("httpProxy",0,0,ManagedProxyLocationSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("secureHttpProxy",8,0,ManagedProxyLocationSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("ftpProxy",16,0,ManagedProxyLocationSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("socks",24,0,ManagedProxyLocationSpec.$,null,true,0,undefined,undefined)],[[0,40]]);mojo.internal.Struct(ManagedProxySettingsSpec.$,"ManagedProxySettings",[mojo.internal.StructField("type",0,0,ManagedStringSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("manual",8,0,ManagedManualProxySettingsSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("excludeDomains",16,0,ManagedStringListSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("pac",24,0,ManagedStringSpec.$,null,true,0,undefined,undefined)],[[0,40]]);mojo.internal.Struct(ManagedVerifyX509PropertiesSpec.$,"ManagedVerifyX509Properties",[mojo.internal.StructField("name",0,0,ManagedStringSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("type",8,0,ManagedStringSpec.$,null,true,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(ManagedOpenVPNPropertiesSpec.$,"ManagedOpenVPNProperties",[mojo.internal.StructField("auth",0,0,ManagedStringSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("authRetry",8,0,ManagedStringSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("authNoCache",16,0,ManagedBooleanSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("cipher",24,0,ManagedStringSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("clientCertPkcs11Id",32,0,ManagedStringSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("clientCertPattern",40,0,ManagedCertificatePatternSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("clientCertProvisioningProfileId",48,0,ManagedStringSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("clientCertRef",56,0,ManagedStringSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("clientCertType",64,0,ManagedStringSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("compressionAlgorithm",72,0,ManagedStringSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("extraHosts",80,0,ManagedStringListSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("ignoreDefaultRoute",88,0,ManagedBooleanSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("keyDirection",96,0,ManagedStringSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("nsCertType",104,0,ManagedStringSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("password",112,0,ManagedStringSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("port",120,0,ManagedInt32Spec.$,null,true,0,undefined,undefined),mojo.internal.StructField("proto",128,0,ManagedStringSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("pushPeerInfo",136,0,ManagedBooleanSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("remoteCertEku",144,0,ManagedStringSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("remoteCertKu",152,0,ManagedStringListSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("remoteCertTls",160,0,ManagedStringSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("renegSec",168,0,ManagedInt32Spec.$,null,true,0,undefined,undefined),mojo.internal.StructField("saveCredentials",176,0,ManagedBooleanSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("serverCaPems",184,0,ManagedStringListSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("serverCaRefs",192,0,ManagedStringListSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("serverCertRef",200,0,ManagedStringSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("serverPollTimeout",208,0,ManagedInt32Spec.$,null,true,0,undefined,undefined),mojo.internal.StructField("shaper",216,0,ManagedInt32Spec.$,null,true,0,undefined,undefined),mojo.internal.StructField("staticChallenge",224,0,ManagedStringSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("tlsAuthContents",232,0,ManagedStringSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("tlsRemote",240,0,ManagedStringSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("tlsVersionMin",248,0,ManagedStringSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("userAuthenticationType",256,0,ManagedStringSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("username",264,0,ManagedStringSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("verb",272,0,ManagedStringSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("verifyHash",280,0,ManagedStringSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("verifyX509",288,0,ManagedVerifyX509PropertiesSpec.$,null,true,0,undefined,undefined)],[[0,304]]);mojo.internal.Struct(ManagedWireGuardPeerListSpec.$,"ManagedWireGuardPeerList",[mojo.internal.StructField("activeValue",0,0,mojo.internal.Array(WireGuardPeerPropertiesSpec.$,false),null,false,0,undefined,undefined),mojo.internal.StructField("policySource",8,0,chromeos_networkConfig_mojom_PolicySourceSpec.$,chromeos_networkConfig_mojom_PolicySource.kNone,false,0,undefined,undefined),mojo.internal.StructField("policyValue",16,0,mojo.internal.Array(WireGuardPeerPropertiesSpec.$,false),null,true,0,undefined,undefined)],[[0,32]]);mojo.internal.Struct(ManagedWireGuardPropertiesSpec.$,"ManagedWireGuardProperties",[mojo.internal.StructField("ipAddresses",0,0,ManagedStringListSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("privateKey",8,0,ManagedStringSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("publicKey",16,0,ManagedStringSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("peers",24,0,ManagedWireGuardPeerListSpec.$,null,false,0,undefined,undefined)],[[0,40]]);mojo.internal.Struct(ManagedCellularPropertiesSpec.$,"ManagedCellularProperties",[mojo.internal.StructField("activationState",0,0,ActivationStateTypeSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("simLocked",4,0,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("allowRoaming",8,0,ManagedBooleanSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("allowTextMessages",16,0,ManagedBooleanSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("apnList",24,0,ManagedApnListSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("autoConnect",32,0,ManagedBooleanSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("customApnList",40,0,mojo.internal.Array(ApnPropertiesSpec.$,false),null,true,0,undefined,undefined),mojo.internal.StructField("eid",48,0,mojo.internal.String,null,true,0,undefined,undefined),mojo.internal.StructField("esn",56,0,mojo.internal.String,null,true,0,undefined,undefined),mojo.internal.StructField("family",64,0,mojo.internal.String,null,true,0,undefined,undefined),mojo.internal.StructField("firmwareRevision",72,0,mojo.internal.String,null,true,0,undefined,undefined),mojo.internal.StructField("foundNetworks",80,0,mojo.internal.Array(FoundNetworkPropertiesSpec.$,false),null,true,0,undefined,undefined),mojo.internal.StructField("hardwareRevision",88,0,mojo.internal.String,null,true,0,undefined,undefined),mojo.internal.StructField("homeProvider",96,0,CellularProviderPropertiesSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("iccid",104,0,mojo.internal.String,null,true,0,undefined,undefined),mojo.internal.StructField("imei",112,0,mojo.internal.String,null,true,0,undefined,undefined),mojo.internal.StructField("lastGoodApn",120,0,ApnPropertiesSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("connectedApn",128,0,ApnPropertiesSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("manufacturer",136,0,mojo.internal.String,null,true,0,undefined,undefined),mojo.internal.StructField("mdn",144,0,mojo.internal.String,null,true,0,undefined,undefined),mojo.internal.StructField("meid",152,0,mojo.internal.String,null,true,0,undefined,undefined),mojo.internal.StructField("min",160,0,mojo.internal.String,null,true,0,undefined,undefined),mojo.internal.StructField("modelId",168,0,mojo.internal.String,null,true,0,undefined,undefined),mojo.internal.StructField("networkTechnology",176,0,mojo.internal.String,null,true,0,undefined,undefined),mojo.internal.StructField("simLockType",184,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("paymentPortal",192,0,PaymentPortalPropertiesSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("roamingState",200,0,mojo.internal.String,null,true,0,undefined,undefined),mojo.internal.StructField("selectedApn",208,0,ManagedApnPropertiesSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("servingOperator",216,0,CellularProviderPropertiesSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("signalStrength",224,0,mojo.internal.Int32,0,false,0,undefined,undefined),mojo.internal.StructField("supportNetworkScan",4,1,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,240]]);mojo.internal.Struct(ManagedEthernetPropertiesSpec.$,"ManagedEthernetProperties",[mojo.internal.StructField("authentication",0,0,ManagedStringSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("eap",8,0,ManagedEAPPropertiesSpec.$,null,true,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(ManagedVPNPropertiesSpec.$,"ManagedVPNProperties",[mojo.internal.StructField("autoConnect",0,0,ManagedBooleanSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("host",8,0,ManagedStringSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("ipSec",16,0,ManagedIPSecPropertiesSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("l2tp",24,0,ManagedL2TPPropertiesSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("openVpn",32,0,ManagedOpenVPNPropertiesSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("wireguard",40,0,ManagedWireGuardPropertiesSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("providerId",48,0,ManagedStringSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("providerName",56,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("type",64,0,VpnTypeSpec.$,0,false,0,undefined,undefined)],[[0,80]]);mojo.internal.Struct(ManagedWiFiPropertiesSpec.$,"ManagedWiFiProperties",[mojo.internal.StructField("allowGatewayArpPolling",0,0,ManagedBooleanSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("autoConnect",8,0,ManagedBooleanSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("bssid",16,0,mojo.internal.String,null,true,0,undefined,undefined),mojo.internal.StructField("eap",24,0,ManagedEAPPropertiesSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("frequency",32,0,mojo.internal.Int32,0,false,0,undefined,undefined),mojo.internal.StructField("frequencyList",40,0,mojo.internal.Array(mojo.internal.Int32,false),null,true,0,undefined,undefined),mojo.internal.StructField("hexSsid",48,0,ManagedStringSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("hiddenSsid",56,0,ManagedBooleanSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("passphrase",64,0,ManagedStringSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("ssid",72,0,ManagedStringSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("security",36,0,SecurityTypeSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("signalStrength",80,0,mojo.internal.Int32,0,false,0,undefined,undefined),mojo.internal.StructField("isSyncable",84,0,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("isConfiguredByActiveUser",84,1,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("passpointId",88,0,mojo.internal.String,null,true,0,undefined,undefined),mojo.internal.StructField("passpointMatchType",96,0,MatchTypeSpec.$,0,false,0,undefined,undefined)],[[0,112]]);mojo.internal.Struct(UInt32ValueSpec.$,"UInt32Value",[mojo.internal.StructField("value",0,0,mojo.internal.Uint32,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(TrafficCounterPropertiesSpec.$,"TrafficCounterProperties",[mojo.internal.StructField("lastResetTime",0,0,mojoBase_mojom_TimeSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("friendlyDate",8,0,mojo.internal.String,null,true,0,undefined,undefined),mojo.internal.StructField("autoReset",16,0,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("userSpecifiedResetDay",20,0,mojo.internal.Uint32,0,false,0,undefined,undefined)],[[0,32]]);mojo.internal.Struct(ManagedPropertiesSpec.$,"ManagedProperties",[mojo.internal.StructField("connectionState",0,0,chromeos_networkConfig_mojom_ConnectionStateTypeSpec.$,chromeos_networkConfig_mojom_ConnectionStateType.kNotConnected,false,0,undefined,undefined),mojo.internal.StructField("source",4,0,chromeos_networkConfig_mojom_OncSourceSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("connectable",8,0,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("errorState",16,0,mojo.internal.String,null,true,0,undefined,undefined),mojo.internal.StructField("guid",24,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("ipAddressConfigType",32,0,ManagedStringSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("ipConfigs",40,0,mojo.internal.Array(IPConfigPropertiesSpec.$,false),null,true,0,undefined,undefined),mojo.internal.StructField("metered",48,0,ManagedBooleanSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("name",56,0,ManagedStringSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("nameServersConfigType",64,0,ManagedStringSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("priority",72,0,ManagedInt32Spec.$,null,true,0,undefined,undefined),mojo.internal.StructField("proxySettings",80,0,ManagedProxySettingsSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("portalState",12,0,chromeos_networkConfig_mojom_PortalStateSpec.$,chromeos_networkConfig_mojom_PortalState.kUnknown,false,0,undefined,undefined),mojo.internal.StructField("staticIpConfig",88,0,ManagedIPConfigPropertiesSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("savedIpConfig",96,0,IPConfigPropertiesSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("type",104,0,chromeos_networkConfig_mojom_NetworkTypeSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("typeProperties",112,0,NetworkTypeManagedPropertiesSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("trafficCounterProperties",128,0,TrafficCounterPropertiesSpec.$,null,true,0,undefined,undefined)],[[0,144]]);mojo.internal.Struct(AutoConnectConfigSpec.$,"AutoConnectConfig",[mojo.internal.StructField("value",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(MeteredConfigSpec.$,"MeteredConfig",[mojo.internal.StructField("value",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PriorityConfigSpec.$,"PriorityConfig",[mojo.internal.StructField("value",0,0,mojo.internal.Int32,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(VpnTypeConfigSpec.$,"VpnTypeConfig",[mojo.internal.StructField("value",0,0,VpnTypeSpec.$,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(ProxyLocationSpec.$,"ProxyLocation",[mojo.internal.StructField("host",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("port",8,0,mojo.internal.Int32,0,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(ManualProxySettingsSpec.$,"ManualProxySettings",[mojo.internal.StructField("httpProxy",0,0,ProxyLocationSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("secureHttpProxy",8,0,ProxyLocationSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("ftpProxy",16,0,ProxyLocationSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("socks",24,0,ProxyLocationSpec.$,null,true,0,undefined,undefined)],[[0,40]]);mojo.internal.Struct(ProxySettingsSpec.$,"ProxySettings",[mojo.internal.StructField("type",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("manual",8,0,ManualProxySettingsSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("excludeDomains",16,0,mojo.internal.Array(mojo.internal.String,false),null,true,0,undefined,undefined),mojo.internal.StructField("pac",24,0,mojo.internal.String,null,true,0,undefined,undefined)],[[0,40]]);mojo.internal.Struct(EAPConfigPropertiesSpec.$,"EAPConfigProperties",[mojo.internal.StructField("anonymousIdentity",0,0,mojo.internal.String,null,true,0,undefined,undefined),mojo.internal.StructField("clientCertPkcs11Id",8,0,mojo.internal.String,null,true,0,undefined,undefined),mojo.internal.StructField("clientCertType",16,0,mojo.internal.String,null,true,0,undefined,undefined),mojo.internal.StructField("domainSuffixMatch",24,0,mojo.internal.Array(mojo.internal.String,false),null,false,0,undefined,undefined),mojo.internal.StructField("identity",32,0,mojo.internal.String,null,true,0,undefined,undefined),mojo.internal.StructField("inner",40,0,mojo.internal.String,null,true,0,undefined,undefined),mojo.internal.StructField("outer",48,0,mojo.internal.String,null,true,0,undefined,undefined),mojo.internal.StructField("password",56,0,mojo.internal.String,null,true,0,undefined,undefined),mojo.internal.StructField("saveCredentials",64,0,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("serverCaPems",72,0,mojo.internal.Array(mojo.internal.String,false),null,true,0,undefined,undefined),mojo.internal.StructField("subjectAltNameMatch",80,0,mojo.internal.Array(SubjectAltNameSpec.$,false),null,false,0,undefined,undefined),mojo.internal.StructField("subjectMatch",88,0,mojo.internal.String,null,true,0,undefined,undefined),mojo.internal.StructField("useSystemCas",64,1,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,104]]);export const SubjectAltName_TypeSpec={$:mojo.internal.Enum()};export var SubjectAltName_Type;(function(SubjectAltName_Type){SubjectAltName_Type[SubjectAltName_Type["MIN_VALUE"]=0]="MIN_VALUE";SubjectAltName_Type[SubjectAltName_Type["MAX_VALUE"]=2]="MAX_VALUE";SubjectAltName_Type[SubjectAltName_Type["kEmail"]=0]="kEmail";SubjectAltName_Type[SubjectAltName_Type["kDns"]=1]="kDns";SubjectAltName_Type[SubjectAltName_Type["kUri"]=2]="kUri"})(SubjectAltName_Type||(SubjectAltName_Type={}));mojo.internal.Struct(SubjectAltNameSpec.$,"SubjectAltName",[mojo.internal.StructField("type",0,0,SubjectAltName_TypeSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("value",8,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(IPSecConfigPropertiesSpec.$,"IPSecConfigProperties",[mojo.internal.StructField("authenticationType",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("clientCertPkcs11Id",8,0,mojo.internal.String,null,true,0,undefined,undefined),mojo.internal.StructField("clientCertType",16,0,mojo.internal.String,null,true,0,undefined,undefined),mojo.internal.StructField("eap",24,0,EAPConfigPropertiesSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("group",32,0,mojo.internal.String,null,true,0,undefined,undefined),mojo.internal.StructField("ikeVersion",40,0,mojo.internal.Int32,1,false,0,undefined,undefined),mojo.internal.StructField("localIdentity",48,0,mojo.internal.String,null,true,0,undefined,undefined),mojo.internal.StructField("psk",56,0,mojo.internal.String,null,true,0,undefined,undefined),mojo.internal.StructField("remoteIdentity",64,0,mojo.internal.String,null,true,0,undefined,undefined),mojo.internal.StructField("saveCredentials",44,0,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("serverCaPems",72,0,mojo.internal.Array(mojo.internal.String,false),null,true,0,undefined,undefined),mojo.internal.StructField("serverCaRefs",80,0,mojo.internal.Array(mojo.internal.String,false),null,true,0,undefined,undefined)],[[0,96]]);mojo.internal.Struct(L2TPConfigPropertiesSpec.$,"L2TPConfigProperties",[mojo.internal.StructField("lcpEchoDisabled",0,0,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("password",8,0,mojo.internal.String,null,true,0,undefined,undefined),mojo.internal.StructField("saveCredentials",0,1,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("username",16,0,mojo.internal.String,null,true,0,undefined,undefined)],[[0,32]]);mojo.internal.Struct(OpenVPNConfigPropertiesSpec.$,"OpenVPNConfigProperties",[mojo.internal.StructField("clientCertPkcs11Id",0,0,mojo.internal.String,null,true,0,undefined,undefined),mojo.internal.StructField("clientCertType",8,0,mojo.internal.String,null,true,0,undefined,undefined),mojo.internal.StructField("extraHosts",16,0,mojo.internal.Array(mojo.internal.String,false),null,true,0,undefined,undefined),mojo.internal.StructField("otp",24,0,mojo.internal.String,null,true,0,undefined,undefined),mojo.internal.StructField("password",32,0,mojo.internal.String,null,true,0,undefined,undefined),mojo.internal.StructField("saveCredentials",40,0,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("serverCaPems",48,0,mojo.internal.Array(mojo.internal.String,false),null,true,0,undefined,undefined),mojo.internal.StructField("serverCaRefs",56,0,mojo.internal.Array(mojo.internal.String,false),null,true,0,undefined,undefined),mojo.internal.StructField("username",64,0,mojo.internal.String,null,true,0,undefined,undefined),mojo.internal.StructField("userAuthenticationType",72,0,mojo.internal.String,null,true,0,undefined,undefined)],[[0,88]]);mojo.internal.Struct(WireGuardConfigPropertiesSpec.$,"WireGuardConfigProperties",[mojo.internal.StructField("ipAddresses",0,0,mojo.internal.Array(mojo.internal.String,false),null,true,0,undefined,undefined),mojo.internal.StructField("privateKey",8,0,mojo.internal.String,null,true,0,undefined,undefined),mojo.internal.StructField("peers",16,0,mojo.internal.Array(WireGuardPeerPropertiesSpec.$,false),null,true,0,undefined,undefined)],[[0,32]]);mojo.internal.Struct(TextMessagesAllowStateSpec.$,"TextMessagesAllowState",[mojo.internal.StructField("allowTextMessages",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(CellularConfigPropertiesSpec.$,"CellularConfigProperties",[mojo.internal.StructField("apn",0,0,ApnPropertiesSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("roaming",8,0,RoamingPropertiesSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("textMessageAllowState",16,0,TextMessagesAllowStateSpec.$,null,true,0,undefined,undefined)],[[0,32]]);mojo.internal.Struct(EthernetConfigPropertiesSpec.$,"EthernetConfigProperties",[mojo.internal.StructField("authentication",0,0,mojo.internal.String,null,true,0,undefined,undefined),mojo.internal.StructField("eap",8,0,EAPConfigPropertiesSpec.$,null,true,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(VPNConfigPropertiesSpec.$,"VPNConfigProperties",[mojo.internal.StructField("host",0,0,mojo.internal.String,null,true,0,undefined,undefined),mojo.internal.StructField("ipSec",8,0,IPSecConfigPropertiesSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("l2tp",16,0,L2TPConfigPropertiesSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("openVpn",24,0,OpenVPNConfigPropertiesSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("wireguard",32,0,WireGuardConfigPropertiesSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("type",40,0,VpnTypeConfigSpec.$,null,true,0,undefined,undefined)],[[0,56]]);mojo.internal.Struct(WiFiConfigPropertiesSpec.$,"WiFiConfigProperties",[mojo.internal.StructField("eap",0,0,EAPConfigPropertiesSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("passphrase",8,0,mojo.internal.String,null,true,0,undefined,undefined),mojo.internal.StructField("ssid",16,0,mojo.internal.String,null,true,0,undefined,undefined),mojo.internal.StructField("security",24,0,SecurityTypeSpec.$,SecurityType.kNone,false,0,undefined,undefined),mojo.internal.StructField("hiddenSsid",28,0,HiddenSsidModeSpec.$,HiddenSsidMode.kAutomatic,false,0,undefined,undefined)],[[0,40]]);mojo.internal.Struct(ConfigPropertiesSpec.$,"ConfigProperties",[mojo.internal.StructField("autoConnect",0,0,AutoConnectConfigSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("guid",8,0,mojo.internal.String,null,true,0,undefined,undefined),mojo.internal.StructField("ipAddressConfigType",16,0,mojo.internal.String,null,true,0,undefined,undefined),mojo.internal.StructField("metered",24,0,MeteredConfigSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("name",32,0,mojo.internal.String,null,true,0,undefined,undefined),mojo.internal.StructField("nameServersConfigType",40,0,mojo.internal.String,null,true,0,undefined,undefined),mojo.internal.StructField("priority",48,0,PriorityConfigSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("proxySettings",56,0,ProxySettingsSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("staticIpConfig",64,0,IPConfigPropertiesSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("typeConfig",72,0,NetworkTypeConfigPropertiesSpec.$,null,false,0,undefined,undefined)],[[0,96]]);mojo.internal.Struct(CellularSimStateSpec.$,"CellularSimState",[mojo.internal.StructField("currentPinOrPuk",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("newPin",8,0,mojo.internal.String,null,true,0,undefined,undefined),mojo.internal.StructField("requirePin",16,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,32]]);mojo.internal.Struct(GlobalPolicySpec.$,"GlobalPolicy",[mojo.internal.StructField("allowApnModification",0,0,mojo.internal.Bool,true,false,0,undefined,undefined),mojo.internal.StructField("allowCellularSimLock",0,1,mojo.internal.Bool,true,false,0,undefined,undefined),mojo.internal.StructField("allowCellularHotspot",0,2,mojo.internal.Bool,true,false,0,undefined,undefined),mojo.internal.StructField("allowOnlyPolicyCellularNetworks",0,3,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("allowOnlyPolicyNetworksToAutoconnect",0,4,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("allowOnlyPolicyWifiNetworksToConnect",0,5,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("allowOnlyPolicyWifiNetworksToConnectIfAvailable",0,6,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("dnsQueriesMonitored",0,7,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("reportXdrEventsEnabled",1,0,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("blockedHexSsids",8,0,mojo.internal.Array(mojo.internal.String,false),null,false,0,undefined,undefined),mojo.internal.StructField("recommendedValuesAreEphemeral",1,1,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("userCreatedNetworkConfigurationsAreEphemeral",1,2,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("allowTextMessages",4,0,SuppressionTypeSpec.$,SuppressionType.kUnset,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(VpnProviderSpec.$,"VpnProvider",[mojo.internal.StructField("type",0,0,VpnTypeSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("providerId",8,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("providerName",16,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("appId",24,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("lastLaunchTime",32,0,mojoBase_mojom_TimeSpec.$,null,false,0,undefined,undefined)],[[0,48]]);mojo.internal.Struct(NetworkCertificateSpec.$,"NetworkCertificate",[mojo.internal.StructField("type",0,0,CertificateTypeSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("hash",8,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("issuedBy",16,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("issuedTo",24,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("pemOrId",32,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("availableForNetworkAuth",4,0,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("hardwareBacked",4,1,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("deviceWide",4,2,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,48]]);mojo.internal.Struct(AlwaysOnVpnPropertiesSpec.$,"AlwaysOnVpnProperties",[mojo.internal.StructField("mode",0,0,AlwaysOnVpnModeSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("serviceGuid",8,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(TrafficCounterSpec.$,"TrafficCounter",[mojo.internal.StructField("source",0,0,TrafficCounterSourceSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("rxBytes",8,0,mojo.internal.Uint64,BigInt(0),false,0,undefined,undefined),mojo.internal.StructField("txBytes",16,0,mojo.internal.Uint64,BigInt(0),false,0,undefined,undefined)],[[0,32]]);mojo.internal.Struct(CrosNetworkConfig_AddObserver_ParamsSpec.$,"CrosNetworkConfig_AddObserver_Params",[mojo.internal.StructField("observer",0,0,mojo.internal.InterfaceProxy(CrosNetworkConfigObserverRemote),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(CrosNetworkConfig_GetNetworkState_ParamsSpec.$,"CrosNetworkConfig_GetNetworkState_Params",[mojo.internal.StructField("guid",0,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(CrosNetworkConfig_GetNetworkState_ResponseParamsSpec.$,"CrosNetworkConfig_GetNetworkState_ResponseParams",[mojo.internal.StructField("result",0,0,NetworkStatePropertiesSpec.$,null,true,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(CrosNetworkConfig_GetNetworkStateList_ParamsSpec.$,"CrosNetworkConfig_GetNetworkStateList_Params",[mojo.internal.StructField("filter",0,0,NetworkFilterSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(CrosNetworkConfig_GetNetworkStateList_ResponseParamsSpec.$,"CrosNetworkConfig_GetNetworkStateList_ResponseParams",[mojo.internal.StructField("result",0,0,mojo.internal.Array(NetworkStatePropertiesSpec.$,false),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(CrosNetworkConfig_GetDeviceStateList_ParamsSpec.$,"CrosNetworkConfig_GetDeviceStateList_Params",[],[[0,8]]);mojo.internal.Struct(CrosNetworkConfig_GetDeviceStateList_ResponseParamsSpec.$,"CrosNetworkConfig_GetDeviceStateList_ResponseParams",[mojo.internal.StructField("result",0,0,mojo.internal.Array(DeviceStatePropertiesSpec.$,false),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(CrosNetworkConfig_GetManagedProperties_ParamsSpec.$,"CrosNetworkConfig_GetManagedProperties_Params",[mojo.internal.StructField("guid",0,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(CrosNetworkConfig_GetManagedProperties_ResponseParamsSpec.$,"CrosNetworkConfig_GetManagedProperties_ResponseParams",[mojo.internal.StructField("result",0,0,ManagedPropertiesSpec.$,null,true,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(CrosNetworkConfig_SetProperties_ParamsSpec.$,"CrosNetworkConfig_SetProperties_Params",[mojo.internal.StructField("guid",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("properties",8,0,ConfigPropertiesSpec.$,null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(CrosNetworkConfig_SetProperties_ResponseParamsSpec.$,"CrosNetworkConfig_SetProperties_ResponseParams",[mojo.internal.StructField("success",0,0,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("errorMessage",8,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(CrosNetworkConfig_ConfigureNetwork_ParamsSpec.$,"CrosNetworkConfig_ConfigureNetwork_Params",[mojo.internal.StructField("properties",0,0,ConfigPropertiesSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("shared",8,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(CrosNetworkConfig_ConfigureNetwork_ResponseParamsSpec.$,"CrosNetworkConfig_ConfigureNetwork_ResponseParams",[mojo.internal.StructField("guid",0,0,mojo.internal.String,null,true,0,undefined,undefined),mojo.internal.StructField("errorMessage",8,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(CrosNetworkConfig_ForgetNetwork_ParamsSpec.$,"CrosNetworkConfig_ForgetNetwork_Params",[mojo.internal.StructField("guid",0,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(CrosNetworkConfig_ForgetNetwork_ResponseParamsSpec.$,"CrosNetworkConfig_ForgetNetwork_ResponseParams",[mojo.internal.StructField("success",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(CrosNetworkConfig_SetNetworkTypeEnabledState_ParamsSpec.$,"CrosNetworkConfig_SetNetworkTypeEnabledState_Params",[mojo.internal.StructField("type",0,0,chromeos_networkConfig_mojom_NetworkTypeSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("enabled",4,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(CrosNetworkConfig_SetNetworkTypeEnabledState_ResponseParamsSpec.$,"CrosNetworkConfig_SetNetworkTypeEnabledState_ResponseParams",[mojo.internal.StructField("success",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(CrosNetworkConfig_SetCellularSimState_ParamsSpec.$,"CrosNetworkConfig_SetCellularSimState_Params",[mojo.internal.StructField("state",0,0,CellularSimStateSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(CrosNetworkConfig_SetCellularSimState_ResponseParamsSpec.$,"CrosNetworkConfig_SetCellularSimState_ResponseParams",[mojo.internal.StructField("success",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(CrosNetworkConfig_SelectCellularMobileNetwork_ParamsSpec.$,"CrosNetworkConfig_SelectCellularMobileNetwork_Params",[mojo.internal.StructField("guid",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("networkId",8,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(CrosNetworkConfig_SelectCellularMobileNetwork_ResponseParamsSpec.$,"CrosNetworkConfig_SelectCellularMobileNetwork_ResponseParams",[mojo.internal.StructField("success",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(CrosNetworkConfig_RequestNetworkScan_ParamsSpec.$,"CrosNetworkConfig_RequestNetworkScan_Params",[mojo.internal.StructField("type",0,0,chromeos_networkConfig_mojom_NetworkTypeSpec.$,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(CrosNetworkConfig_GetGlobalPolicy_ParamsSpec.$,"CrosNetworkConfig_GetGlobalPolicy_Params",[],[[0,8]]);mojo.internal.Struct(CrosNetworkConfig_GetGlobalPolicy_ResponseParamsSpec.$,"CrosNetworkConfig_GetGlobalPolicy_ResponseParams",[mojo.internal.StructField("result",0,0,GlobalPolicySpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(CrosNetworkConfig_StartConnect_ParamsSpec.$,"CrosNetworkConfig_StartConnect_Params",[mojo.internal.StructField("guid",0,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(CrosNetworkConfig_StartConnect_ResponseParamsSpec.$,"CrosNetworkConfig_StartConnect_ResponseParams",[mojo.internal.StructField("result",0,0,StartConnectResultSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("message",8,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(CrosNetworkConfig_StartDisconnect_ParamsSpec.$,"CrosNetworkConfig_StartDisconnect_Params",[mojo.internal.StructField("guid",0,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(CrosNetworkConfig_StartDisconnect_ResponseParamsSpec.$,"CrosNetworkConfig_StartDisconnect_ResponseParams",[mojo.internal.StructField("success",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(CrosNetworkConfig_SetVpnProviders_ParamsSpec.$,"CrosNetworkConfig_SetVpnProviders_Params",[mojo.internal.StructField("providers",0,0,mojo.internal.Array(VpnProviderSpec.$,false),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(CrosNetworkConfig_GetVpnProviders_ParamsSpec.$,"CrosNetworkConfig_GetVpnProviders_Params",[],[[0,8]]);mojo.internal.Struct(CrosNetworkConfig_GetVpnProviders_ResponseParamsSpec.$,"CrosNetworkConfig_GetVpnProviders_ResponseParams",[mojo.internal.StructField("providers",0,0,mojo.internal.Array(VpnProviderSpec.$,false),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(CrosNetworkConfig_GetNetworkCertificates_ParamsSpec.$,"CrosNetworkConfig_GetNetworkCertificates_Params",[],[[0,8]]);mojo.internal.Struct(CrosNetworkConfig_GetNetworkCertificates_ResponseParamsSpec.$,"CrosNetworkConfig_GetNetworkCertificates_ResponseParams",[mojo.internal.StructField("serverCas",0,0,mojo.internal.Array(NetworkCertificateSpec.$,false),null,false,0,undefined,undefined),mojo.internal.StructField("userCerts",8,0,mojo.internal.Array(NetworkCertificateSpec.$,false),null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(CrosNetworkConfig_GetAlwaysOnVpn_ParamsSpec.$,"CrosNetworkConfig_GetAlwaysOnVpn_Params",[],[[0,8]]);mojo.internal.Struct(CrosNetworkConfig_GetAlwaysOnVpn_ResponseParamsSpec.$,"CrosNetworkConfig_GetAlwaysOnVpn_ResponseParams",[mojo.internal.StructField("properties",0,0,AlwaysOnVpnPropertiesSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(CrosNetworkConfig_SetAlwaysOnVpn_ParamsSpec.$,"CrosNetworkConfig_SetAlwaysOnVpn_Params",[mojo.internal.StructField("properties",0,0,AlwaysOnVpnPropertiesSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(CrosNetworkConfig_GetSupportedVpnTypes_ParamsSpec.$,"CrosNetworkConfig_GetSupportedVpnTypes_Params",[],[[0,8]]);mojo.internal.Struct(CrosNetworkConfig_GetSupportedVpnTypes_ResponseParamsSpec.$,"CrosNetworkConfig_GetSupportedVpnTypes_ResponseParams",[mojo.internal.StructField("vpnTypes",0,0,mojo.internal.Array(mojo.internal.String,false),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(CrosNetworkConfig_RequestTrafficCounters_ParamsSpec.$,"CrosNetworkConfig_RequestTrafficCounters_Params",[mojo.internal.StructField("guid",0,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(CrosNetworkConfig_RequestTrafficCounters_ResponseParamsSpec.$,"CrosNetworkConfig_RequestTrafficCounters_ResponseParams",[mojo.internal.StructField("trafficCounters",0,0,mojo.internal.Array(TrafficCounterSpec.$,false),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(CrosNetworkConfig_ResetTrafficCounters_ParamsSpec.$,"CrosNetworkConfig_ResetTrafficCounters_Params",[mojo.internal.StructField("guid",0,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(CrosNetworkConfig_SetTrafficCountersResetDay_ParamsSpec.$,"CrosNetworkConfig_SetTrafficCountersResetDay_Params",[mojo.internal.StructField("guid",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("day",8,0,UInt32ValueSpec.$,null,true,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(CrosNetworkConfig_SetTrafficCountersResetDay_ResponseParamsSpec.$,"CrosNetworkConfig_SetTrafficCountersResetDay_ResponseParams",[mojo.internal.StructField("success",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(CrosNetworkConfig_CreateCustomApn_ParamsSpec.$,"CrosNetworkConfig_CreateCustomApn_Params",[mojo.internal.StructField("networkGuid",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("apn",8,0,ApnPropertiesSpec.$,null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(CrosNetworkConfig_CreateCustomApn_ResponseParamsSpec.$,"CrosNetworkConfig_CreateCustomApn_ResponseParams",[mojo.internal.StructField("success",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(CrosNetworkConfig_CreateExclusivelyEnabledCustomApn_ParamsSpec.$,"CrosNetworkConfig_CreateExclusivelyEnabledCustomApn_Params",[mojo.internal.StructField("networkGuid",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("apn",8,0,ApnPropertiesSpec.$,null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(CrosNetworkConfig_CreateExclusivelyEnabledCustomApn_ResponseParamsSpec.$,"CrosNetworkConfig_CreateExclusivelyEnabledCustomApn_ResponseParams",[mojo.internal.StructField("success",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(CrosNetworkConfig_RemoveCustomApn_ParamsSpec.$,"CrosNetworkConfig_RemoveCustomApn_Params",[mojo.internal.StructField("networkGuid",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("apnId",8,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(CrosNetworkConfig_ModifyCustomApn_ParamsSpec.$,"CrosNetworkConfig_ModifyCustomApn_Params",[mojo.internal.StructField("networkGuid",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("apn",8,0,ApnPropertiesSpec.$,null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(CrosNetworkConfigObserver_OnActiveNetworksChanged_ParamsSpec.$,"CrosNetworkConfigObserver_OnActiveNetworksChanged_Params",[mojo.internal.StructField("networks",0,0,mojo.internal.Array(NetworkStatePropertiesSpec.$,false),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(CrosNetworkConfigObserver_OnNetworkStateChanged_ParamsSpec.$,"CrosNetworkConfigObserver_OnNetworkStateChanged_Params",[mojo.internal.StructField("network",0,0,NetworkStatePropertiesSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(CrosNetworkConfigObserver_OnNetworkStateListChanged_ParamsSpec.$,"CrosNetworkConfigObserver_OnNetworkStateListChanged_Params",[],[[0,8]]);mojo.internal.Struct(CrosNetworkConfigObserver_OnDeviceStateListChanged_ParamsSpec.$,"CrosNetworkConfigObserver_OnDeviceStateListChanged_Params",[],[[0,8]]);mojo.internal.Struct(CrosNetworkConfigObserver_OnVpnProvidersChanged_ParamsSpec.$,"CrosNetworkConfigObserver_OnVpnProvidersChanged_Params",[],[[0,8]]);mojo.internal.Struct(CrosNetworkConfigObserver_OnNetworkCertificatesChanged_ParamsSpec.$,"CrosNetworkConfigObserver_OnNetworkCertificatesChanged_Params",[],[[0,8]]);mojo.internal.Struct(CrosNetworkConfigObserver_OnPoliciesApplied_ParamsSpec.$,"CrosNetworkConfigObserver_OnPoliciesApplied_Params",[mojo.internal.StructField("userhash",0,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Union(NetworkTypeStatePropertiesSpec.$,"NetworkTypeStateProperties",{cellular:{ordinal:0,type:CellularStatePropertiesSpec.$},ethernet:{ordinal:1,type:EthernetStatePropertiesSpec.$},tether:{ordinal:2,type:TetherStatePropertiesSpec.$},vpn:{ordinal:3,type:VPNStatePropertiesSpec.$},wifi:{ordinal:4,type:WiFiStatePropertiesSpec.$}});export var NetworkTypeStatePropertiesFieldTags;(function(NetworkTypeStatePropertiesFieldTags){NetworkTypeStatePropertiesFieldTags[NetworkTypeStatePropertiesFieldTags["CELLULAR"]=0]="CELLULAR";NetworkTypeStatePropertiesFieldTags[NetworkTypeStatePropertiesFieldTags["ETHERNET"]=1]="ETHERNET";NetworkTypeStatePropertiesFieldTags[NetworkTypeStatePropertiesFieldTags["TETHER"]=2]="TETHER";NetworkTypeStatePropertiesFieldTags[NetworkTypeStatePropertiesFieldTags["VPN"]=3]="VPN";NetworkTypeStatePropertiesFieldTags[NetworkTypeStatePropertiesFieldTags["WIFI"]=4]="WIFI"})(NetworkTypeStatePropertiesFieldTags||(NetworkTypeStatePropertiesFieldTags={}));export function whichNetworkTypeStateProperties(u){if(u.cellular!==null&&u.cellular!==undefined){return NetworkTypeStatePropertiesFieldTags.CELLULAR}if(u.ethernet!==null&&u.ethernet!==undefined){return NetworkTypeStatePropertiesFieldTags.ETHERNET}if(u.tether!==null&&u.tether!==undefined){return NetworkTypeStatePropertiesFieldTags.TETHER}if(u.vpn!==null&&u.vpn!==undefined){return NetworkTypeStatePropertiesFieldTags.VPN}if(u.wifi!==null&&u.wifi!==undefined){return NetworkTypeStatePropertiesFieldTags.WIFI}throw new Error("no union field has been set, this is an illegal state")}mojo.internal.Union(NetworkTypeManagedPropertiesSpec.$,"NetworkTypeManagedProperties",{cellular:{ordinal:0,type:ManagedCellularPropertiesSpec.$},ethernet:{ordinal:1,type:ManagedEthernetPropertiesSpec.$},tether:{ordinal:2,type:TetherStatePropertiesSpec.$},vpn:{ordinal:3,type:ManagedVPNPropertiesSpec.$},wifi:{ordinal:4,type:ManagedWiFiPropertiesSpec.$}});export var NetworkTypeManagedPropertiesFieldTags;(function(NetworkTypeManagedPropertiesFieldTags){NetworkTypeManagedPropertiesFieldTags[NetworkTypeManagedPropertiesFieldTags["CELLULAR"]=0]="CELLULAR";NetworkTypeManagedPropertiesFieldTags[NetworkTypeManagedPropertiesFieldTags["ETHERNET"]=1]="ETHERNET";NetworkTypeManagedPropertiesFieldTags[NetworkTypeManagedPropertiesFieldTags["TETHER"]=2]="TETHER";NetworkTypeManagedPropertiesFieldTags[NetworkTypeManagedPropertiesFieldTags["VPN"]=3]="VPN";NetworkTypeManagedPropertiesFieldTags[NetworkTypeManagedPropertiesFieldTags["WIFI"]=4]="WIFI"})(NetworkTypeManagedPropertiesFieldTags||(NetworkTypeManagedPropertiesFieldTags={}));export function whichNetworkTypeManagedProperties(u){if(u.cellular!==null&&u.cellular!==undefined){return NetworkTypeManagedPropertiesFieldTags.CELLULAR}if(u.ethernet!==null&&u.ethernet!==undefined){return NetworkTypeManagedPropertiesFieldTags.ETHERNET}if(u.tether!==null&&u.tether!==undefined){return NetworkTypeManagedPropertiesFieldTags.TETHER}if(u.vpn!==null&&u.vpn!==undefined){return NetworkTypeManagedPropertiesFieldTags.VPN}if(u.wifi!==null&&u.wifi!==undefined){return NetworkTypeManagedPropertiesFieldTags.WIFI}throw new Error("no union field has been set, this is an illegal state")}mojo.internal.Union(NetworkTypeConfigPropertiesSpec.$,"NetworkTypeConfigProperties",{cellular:{ordinal:0,type:CellularConfigPropertiesSpec.$},ethernet:{ordinal:1,type:EthernetConfigPropertiesSpec.$},vpn:{ordinal:2,type:VPNConfigPropertiesSpec.$},wifi:{ordinal:3,type:WiFiConfigPropertiesSpec.$}});export var NetworkTypeConfigPropertiesFieldTags;(function(NetworkTypeConfigPropertiesFieldTags){NetworkTypeConfigPropertiesFieldTags[NetworkTypeConfigPropertiesFieldTags["CELLULAR"]=0]="CELLULAR";NetworkTypeConfigPropertiesFieldTags[NetworkTypeConfigPropertiesFieldTags["ETHERNET"]=1]="ETHERNET";NetworkTypeConfigPropertiesFieldTags[NetworkTypeConfigPropertiesFieldTags["VPN"]=2]="VPN";NetworkTypeConfigPropertiesFieldTags[NetworkTypeConfigPropertiesFieldTags["WIFI"]=3]="WIFI"})(NetworkTypeConfigPropertiesFieldTags||(NetworkTypeConfigPropertiesFieldTags={}));export function whichNetworkTypeConfigProperties(u){if(u.cellular!==null&&u.cellular!==undefined){return NetworkTypeConfigPropertiesFieldTags.CELLULAR}if(u.ethernet!==null&&u.ethernet!==undefined){return NetworkTypeConfigPropertiesFieldTags.ETHERNET}if(u.vpn!==null&&u.vpn!==undefined){return NetworkTypeConfigPropertiesFieldTags.VPN}if(u.wifi!==null&&u.wifi!==undefined){return NetworkTypeConfigPropertiesFieldTags.WIFI}throw new Error("no union field has been set, this is an illegal state")}