// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{mojo}from"//resources/mojo/mojo/public/js/bindings.js";import{TimeSpec as mojoBase_mojom_TimeSpec,TimeDeltaSpec as mojoBase_mojom_TimeDeltaSpec}from"../../../../../mojo/public/mojom/base/time.mojom-webui.js";export const RoutineTypeSpec={$:mojo.internal.Enum()};export var RoutineType;(function(RoutineType){RoutineType[RoutineType["MIN_VALUE"]=0]="MIN_VALUE";RoutineType[RoutineType["MAX_VALUE"]=14]="MAX_VALUE";RoutineType[RoutineType["kLanConnectivity"]=0]="kLanConnectivity";RoutineType[RoutineType["kSignalStrength"]=1]="kSignalStrength";RoutineType[RoutineType["kGatewayCanBePinged"]=2]="kGatewayCanBePinged";RoutineType[RoutineType["kHasSecureWiFiConnection"]=3]="kHasSecureWiFiConnection";RoutineType[RoutineType["kDnsResolverPresent"]=4]="kDnsResolverPresent";RoutineType[RoutineType["kDnsLatency"]=5]="kDnsLatency";RoutineType[RoutineType["kDnsResolution"]=6]="kDnsResolution";RoutineType[RoutineType["kCaptivePortal"]=7]="kCaptivePortal";RoutineType[RoutineType["kHttpFirewall"]=8]="kHttpFirewall";RoutineType[RoutineType["kHttpsFirewall"]=9]="kHttpsFirewall";RoutineType[RoutineType["kHttpsLatency"]=10]="kHttpsLatency";RoutineType[RoutineType["kVideoConferencing"]=11]="kVideoConferencing";RoutineType[RoutineType["kArcHttp"]=12]="kArcHttp";RoutineType[RoutineType["kArcDnsResolution"]=13]="kArcDnsResolution";RoutineType[RoutineType["kArcPing"]=14]="kArcPing"})(RoutineType||(RoutineType={}));export const RoutineVerdictSpec={$:mojo.internal.Enum()};export var RoutineVerdict;(function(RoutineVerdict){RoutineVerdict[RoutineVerdict["MIN_VALUE"]=0]="MIN_VALUE";RoutineVerdict[RoutineVerdict["MAX_VALUE"]=2]="MAX_VALUE";RoutineVerdict[RoutineVerdict["kNoProblem"]=0]="kNoProblem";RoutineVerdict[RoutineVerdict["kProblem"]=1]="kProblem";RoutineVerdict[RoutineVerdict["kNotRun"]=2]="kNotRun"})(RoutineVerdict||(RoutineVerdict={}));export const RoutineCallSourceSpec={$:mojo.internal.Enum()};export var RoutineCallSource;(function(RoutineCallSource){RoutineCallSource[RoutineCallSource["MIN_VALUE"]=0]="MIN_VALUE";RoutineCallSource[RoutineCallSource["MAX_VALUE"]=5]="MAX_VALUE";RoutineCallSource[RoutineCallSource["kUnknown"]=0]="kUnknown";RoutineCallSource[RoutineCallSource["kDiagnosticsUI"]=1]="kDiagnosticsUI";RoutineCallSource[RoutineCallSource["kChromeNetworkPage"]=2]="kChromeNetworkPage";RoutineCallSource[RoutineCallSource["kCrosHealthd"]=3]="kCrosHealthd";RoutineCallSource[RoutineCallSource["kMetricsReporting"]=4]="kMetricsReporting";RoutineCallSource[RoutineCallSource["kNetworkHealthSource"]=5]="kNetworkHealthSource"})(RoutineCallSource||(RoutineCallSource={}));export const LanConnectivityProblemSpec={$:mojo.internal.Enum()};export var LanConnectivityProblem;(function(LanConnectivityProblem){LanConnectivityProblem[LanConnectivityProblem["MIN_VALUE"]=0]="MIN_VALUE";LanConnectivityProblem[LanConnectivityProblem["MAX_VALUE"]=0]="MAX_VALUE";LanConnectivityProblem[LanConnectivityProblem["kNoLanConnectivity"]=0]="kNoLanConnectivity"})(LanConnectivityProblem||(LanConnectivityProblem={}));export const SignalStrengthProblemSpec={$:mojo.internal.Enum()};export var SignalStrengthProblem;(function(SignalStrengthProblem){SignalStrengthProblem[SignalStrengthProblem["MIN_VALUE"]=0]="MIN_VALUE";SignalStrengthProblem[SignalStrengthProblem["MAX_VALUE"]=0]="MAX_VALUE";SignalStrengthProblem[SignalStrengthProblem["kWeakSignal"]=0]="kWeakSignal"})(SignalStrengthProblem||(SignalStrengthProblem={}));export const GatewayCanBePingedProblemSpec={$:mojo.internal.Enum()};export var GatewayCanBePingedProblem;(function(GatewayCanBePingedProblem){GatewayCanBePingedProblem[GatewayCanBePingedProblem["MIN_VALUE"]=0]="MIN_VALUE";GatewayCanBePingedProblem[GatewayCanBePingedProblem["MAX_VALUE"]=4]="MAX_VALUE";GatewayCanBePingedProblem[GatewayCanBePingedProblem["kUnreachableGateway"]=0]="kUnreachableGateway";GatewayCanBePingedProblem[GatewayCanBePingedProblem["kFailedToPingDefaultNetwork"]=1]="kFailedToPingDefaultNetwork";GatewayCanBePingedProblem[GatewayCanBePingedProblem["kDefaultNetworkAboveLatencyThreshold"]=2]="kDefaultNetworkAboveLatencyThreshold";GatewayCanBePingedProblem[GatewayCanBePingedProblem["kUnsuccessfulNonDefaultNetworksPings"]=3]="kUnsuccessfulNonDefaultNetworksPings";GatewayCanBePingedProblem[GatewayCanBePingedProblem["kNonDefaultNetworksAboveLatencyThreshold"]=4]="kNonDefaultNetworksAboveLatencyThreshold"})(GatewayCanBePingedProblem||(GatewayCanBePingedProblem={}));export const HasSecureWiFiConnectionProblemSpec={$:mojo.internal.Enum()};export var HasSecureWiFiConnectionProblem;(function(HasSecureWiFiConnectionProblem){HasSecureWiFiConnectionProblem[HasSecureWiFiConnectionProblem["MIN_VALUE"]=0]="MIN_VALUE";HasSecureWiFiConnectionProblem[HasSecureWiFiConnectionProblem["MAX_VALUE"]=3]="MAX_VALUE";HasSecureWiFiConnectionProblem[HasSecureWiFiConnectionProblem["kSecurityTypeNone"]=0]="kSecurityTypeNone";HasSecureWiFiConnectionProblem[HasSecureWiFiConnectionProblem["kSecurityTypeWep8021x"]=1]="kSecurityTypeWep8021x";HasSecureWiFiConnectionProblem[HasSecureWiFiConnectionProblem["kSecurityTypeWepPsk"]=2]="kSecurityTypeWepPsk";HasSecureWiFiConnectionProblem[HasSecureWiFiConnectionProblem["kUnknownSecurityType"]=3]="kUnknownSecurityType"})(HasSecureWiFiConnectionProblem||(HasSecureWiFiConnectionProblem={}));export const DnsResolverPresentProblemSpec={$:mojo.internal.Enum()};export var DnsResolverPresentProblem;(function(DnsResolverPresentProblem){DnsResolverPresentProblem[DnsResolverPresentProblem["MIN_VALUE"]=0]="MIN_VALUE";DnsResolverPresentProblem[DnsResolverPresentProblem["MAX_VALUE"]=2]="MAX_VALUE";DnsResolverPresentProblem[DnsResolverPresentProblem["kNoNameServersFound"]=0]="kNoNameServersFound";DnsResolverPresentProblem[DnsResolverPresentProblem["kMalformedNameServers"]=1]="kMalformedNameServers";DnsResolverPresentProblem[DnsResolverPresentProblem["kEmptyNameServers"]=2]="kEmptyNameServers"})(DnsResolverPresentProblem||(DnsResolverPresentProblem={}));export const DnsLatencyProblemSpec={$:mojo.internal.Enum()};export var DnsLatencyProblem;(function(DnsLatencyProblem){DnsLatencyProblem[DnsLatencyProblem["MIN_VALUE"]=0]="MIN_VALUE";DnsLatencyProblem[DnsLatencyProblem["MAX_VALUE"]=2]="MAX_VALUE";DnsLatencyProblem[DnsLatencyProblem["kHostResolutionFailure"]=0]="kHostResolutionFailure";DnsLatencyProblem[DnsLatencyProblem["kSlightlyAboveThreshold"]=1]="kSlightlyAboveThreshold";DnsLatencyProblem[DnsLatencyProblem["kSignificantlyAboveThreshold"]=2]="kSignificantlyAboveThreshold"})(DnsLatencyProblem||(DnsLatencyProblem={}));export const DnsResolutionProblemSpec={$:mojo.internal.Enum()};export var DnsResolutionProblem;(function(DnsResolutionProblem){DnsResolutionProblem[DnsResolutionProblem["MIN_VALUE"]=0]="MIN_VALUE";DnsResolutionProblem[DnsResolutionProblem["MAX_VALUE"]=0]="MAX_VALUE";DnsResolutionProblem[DnsResolutionProblem["kFailedToResolveHost"]=0]="kFailedToResolveHost"})(DnsResolutionProblem||(DnsResolutionProblem={}));export const CaptivePortalProblemSpec={$:mojo.internal.Enum()};export var CaptivePortalProblem;(function(CaptivePortalProblem){CaptivePortalProblem[CaptivePortalProblem["MIN_VALUE"]=0]="MIN_VALUE";CaptivePortalProblem[CaptivePortalProblem["MAX_VALUE"]=5]="MAX_VALUE";CaptivePortalProblem[CaptivePortalProblem["kNoActiveNetworks"]=0]="kNoActiveNetworks";CaptivePortalProblem[CaptivePortalProblem["kUnknownPortalState"]=1]="kUnknownPortalState";CaptivePortalProblem[CaptivePortalProblem["kPortalSuspected"]=2]="kPortalSuspected";CaptivePortalProblem[CaptivePortalProblem["kPortal"]=3]="kPortal";CaptivePortalProblem[CaptivePortalProblem["kProxyAuthRequired"]=4]="kProxyAuthRequired";CaptivePortalProblem[CaptivePortalProblem["kNoInternet"]=5]="kNoInternet"})(CaptivePortalProblem||(CaptivePortalProblem={}));export const HttpFirewallProblemSpec={$:mojo.internal.Enum()};export var HttpFirewallProblem;(function(HttpFirewallProblem){HttpFirewallProblem[HttpFirewallProblem["MIN_VALUE"]=0]="MIN_VALUE";HttpFirewallProblem[HttpFirewallProblem["MAX_VALUE"]=2]="MAX_VALUE";HttpFirewallProblem[HttpFirewallProblem["kDnsResolutionFailuresAboveThreshold"]=0]="kDnsResolutionFailuresAboveThreshold";HttpFirewallProblem[HttpFirewallProblem["kFirewallDetected"]=1]="kFirewallDetected";HttpFirewallProblem[HttpFirewallProblem["kPotentialFirewall"]=2]="kPotentialFirewall"})(HttpFirewallProblem||(HttpFirewallProblem={}));export const HttpsFirewallProblemSpec={$:mojo.internal.Enum()};export var HttpsFirewallProblem;(function(HttpsFirewallProblem){HttpsFirewallProblem[HttpsFirewallProblem["MIN_VALUE"]=0]="MIN_VALUE";HttpsFirewallProblem[HttpsFirewallProblem["MAX_VALUE"]=2]="MAX_VALUE";HttpsFirewallProblem[HttpsFirewallProblem["kHighDnsResolutionFailureRate"]=0]="kHighDnsResolutionFailureRate";HttpsFirewallProblem[HttpsFirewallProblem["kFirewallDetected"]=1]="kFirewallDetected";HttpsFirewallProblem[HttpsFirewallProblem["kPotentialFirewall"]=2]="kPotentialFirewall"})(HttpsFirewallProblem||(HttpsFirewallProblem={}));export const HttpsLatencyProblemSpec={$:mojo.internal.Enum()};export var HttpsLatencyProblem;(function(HttpsLatencyProblem){HttpsLatencyProblem[HttpsLatencyProblem["MIN_VALUE"]=0]="MIN_VALUE";HttpsLatencyProblem[HttpsLatencyProblem["MAX_VALUE"]=3]="MAX_VALUE";HttpsLatencyProblem[HttpsLatencyProblem["kFailedDnsResolutions"]=0]="kFailedDnsResolutions";HttpsLatencyProblem[HttpsLatencyProblem["kFailedHttpsRequests"]=1]="kFailedHttpsRequests";HttpsLatencyProblem[HttpsLatencyProblem["kHighLatency"]=2]="kHighLatency";HttpsLatencyProblem[HttpsLatencyProblem["kVeryHighLatency"]=3]="kVeryHighLatency"})(HttpsLatencyProblem||(HttpsLatencyProblem={}));export const VideoConferencingProblemSpec={$:mojo.internal.Enum()};export var VideoConferencingProblem;(function(VideoConferencingProblem){VideoConferencingProblem[VideoConferencingProblem["MIN_VALUE"]=0]="MIN_VALUE";VideoConferencingProblem[VideoConferencingProblem["MAX_VALUE"]=2]="MAX_VALUE";VideoConferencingProblem[VideoConferencingProblem["kUdpFailure"]=0]="kUdpFailure";VideoConferencingProblem[VideoConferencingProblem["kTcpFailure"]=1]="kTcpFailure";VideoConferencingProblem[VideoConferencingProblem["kMediaFailure"]=2]="kMediaFailure"})(VideoConferencingProblem||(VideoConferencingProblem={}));export const ArcHttpProblemSpec={$:mojo.internal.Enum()};export var ArcHttpProblem;(function(ArcHttpProblem){ArcHttpProblem[ArcHttpProblem["MIN_VALUE"]=0]="MIN_VALUE";ArcHttpProblem[ArcHttpProblem["MAX_VALUE"]=4]="MAX_VALUE";ArcHttpProblem[ArcHttpProblem["kFailedToGetArcServiceManager"]=0]="kFailedToGetArcServiceManager";ArcHttpProblem[ArcHttpProblem["kFailedToGetNetInstanceForHttpTest"]=1]="kFailedToGetNetInstanceForHttpTest";ArcHttpProblem[ArcHttpProblem["kHighLatency"]=2]="kHighLatency";ArcHttpProblem[ArcHttpProblem["kVeryHighLatency"]=3]="kVeryHighLatency";ArcHttpProblem[ArcHttpProblem["kFailedHttpRequests"]=4]="kFailedHttpRequests"})(ArcHttpProblem||(ArcHttpProblem={}));export const ArcDnsResolutionProblemSpec={$:mojo.internal.Enum()};export var ArcDnsResolutionProblem;(function(ArcDnsResolutionProblem){ArcDnsResolutionProblem[ArcDnsResolutionProblem["MIN_VALUE"]=0]="MIN_VALUE";ArcDnsResolutionProblem[ArcDnsResolutionProblem["MAX_VALUE"]=4]="MAX_VALUE";ArcDnsResolutionProblem[ArcDnsResolutionProblem["kFailedToGetArcServiceManager"]=0]="kFailedToGetArcServiceManager";ArcDnsResolutionProblem[ArcDnsResolutionProblem["kFailedToGetNetInstanceForDnsResolutionTest"]=1]="kFailedToGetNetInstanceForDnsResolutionTest";ArcDnsResolutionProblem[ArcDnsResolutionProblem["kHighLatency"]=2]="kHighLatency";ArcDnsResolutionProblem[ArcDnsResolutionProblem["kVeryHighLatency"]=3]="kVeryHighLatency";ArcDnsResolutionProblem[ArcDnsResolutionProblem["kFailedDnsQueries"]=4]="kFailedDnsQueries"})(ArcDnsResolutionProblem||(ArcDnsResolutionProblem={}));export const ArcPingProblemSpec={$:mojo.internal.Enum()};export var ArcPingProblem;(function(ArcPingProblem){ArcPingProblem[ArcPingProblem["MIN_VALUE"]=0]="MIN_VALUE";ArcPingProblem[ArcPingProblem["MAX_VALUE"]=7]="MAX_VALUE";ArcPingProblem[ArcPingProblem["kFailedToGetArcServiceManager"]=0]="kFailedToGetArcServiceManager";ArcPingProblem[ArcPingProblem["kFailedToGetNetInstanceForPingTest"]=1]="kFailedToGetNetInstanceForPingTest";ArcPingProblem[ArcPingProblem["kGetManagedPropertiesTimeoutFailure"]=2]="kGetManagedPropertiesTimeoutFailure";ArcPingProblem[ArcPingProblem["kUnreachableGateway"]=3]="kUnreachableGateway";ArcPingProblem[ArcPingProblem["kFailedToPingDefaultNetwork"]=4]="kFailedToPingDefaultNetwork";ArcPingProblem[ArcPingProblem["kDefaultNetworkAboveLatencyThreshold"]=5]="kDefaultNetworkAboveLatencyThreshold";ArcPingProblem[ArcPingProblem["kUnsuccessfulNonDefaultNetworksPings"]=6]="kUnsuccessfulNonDefaultNetworksPings";ArcPingProblem[ArcPingProblem["kNonDefaultNetworksAboveLatencyThreshold"]=7]="kNonDefaultNetworksAboveLatencyThreshold"})(ArcPingProblem||(ArcPingProblem={}));export class NetworkDiagnosticsRoutinesPendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"chromeos.network_diagnostics.mojom.NetworkDiagnosticsRoutines",scope)}}export class NetworkDiagnosticsRoutinesRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(NetworkDiagnosticsRoutinesPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}getResult(routine){return this.proxy.sendMessage(27,NetworkDiagnosticsRoutines_GetResult_ParamsSpec.$,NetworkDiagnosticsRoutines_GetResult_ResponseParamsSpec.$,[routine],false)}getAllResults(){return this.proxy.sendMessage(28,NetworkDiagnosticsRoutines_GetAllResults_ParamsSpec.$,NetworkDiagnosticsRoutines_GetAllResults_ResponseParamsSpec.$,[],false)}runLanConnectivity(source){return this.proxy.sendMessage(12,NetworkDiagnosticsRoutines_RunLanConnectivity_ParamsSpec.$,NetworkDiagnosticsRoutines_RunLanConnectivity_ResponseParamsSpec.$,[source],false)}runSignalStrength(source){return this.proxy.sendMessage(13,NetworkDiagnosticsRoutines_RunSignalStrength_ParamsSpec.$,NetworkDiagnosticsRoutines_RunSignalStrength_ResponseParamsSpec.$,[source],false)}runGatewayCanBePinged(source){return this.proxy.sendMessage(14,NetworkDiagnosticsRoutines_RunGatewayCanBePinged_ParamsSpec.$,NetworkDiagnosticsRoutines_RunGatewayCanBePinged_ResponseParamsSpec.$,[source],false)}runHasSecureWiFiConnection(source){return this.proxy.sendMessage(15,NetworkDiagnosticsRoutines_RunHasSecureWiFiConnection_ParamsSpec.$,NetworkDiagnosticsRoutines_RunHasSecureWiFiConnection_ResponseParamsSpec.$,[source],false)}runDnsResolverPresent(source){return this.proxy.sendMessage(16,NetworkDiagnosticsRoutines_RunDnsResolverPresent_ParamsSpec.$,NetworkDiagnosticsRoutines_RunDnsResolverPresent_ResponseParamsSpec.$,[source],false)}runDnsLatency(source){return this.proxy.sendMessage(17,NetworkDiagnosticsRoutines_RunDnsLatency_ParamsSpec.$,NetworkDiagnosticsRoutines_RunDnsLatency_ResponseParamsSpec.$,[source],false)}runDnsResolution(source){return this.proxy.sendMessage(18,NetworkDiagnosticsRoutines_RunDnsResolution_ParamsSpec.$,NetworkDiagnosticsRoutines_RunDnsResolution_ResponseParamsSpec.$,[source],false)}runCaptivePortal(source){return this.proxy.sendMessage(19,NetworkDiagnosticsRoutines_RunCaptivePortal_ParamsSpec.$,NetworkDiagnosticsRoutines_RunCaptivePortal_ResponseParamsSpec.$,[source],false)}runHttpFirewall(source){return this.proxy.sendMessage(20,NetworkDiagnosticsRoutines_RunHttpFirewall_ParamsSpec.$,NetworkDiagnosticsRoutines_RunHttpFirewall_ResponseParamsSpec.$,[source],false)}runHttpsFirewall(source){return this.proxy.sendMessage(21,NetworkDiagnosticsRoutines_RunHttpsFirewall_ParamsSpec.$,NetworkDiagnosticsRoutines_RunHttpsFirewall_ResponseParamsSpec.$,[source],false)}runHttpsLatency(source){return this.proxy.sendMessage(22,NetworkDiagnosticsRoutines_RunHttpsLatency_ParamsSpec.$,NetworkDiagnosticsRoutines_RunHttpsLatency_ResponseParamsSpec.$,[source],false)}runVideoConferencing(stunServerHostname,source){return this.proxy.sendMessage(23,NetworkDiagnosticsRoutines_RunVideoConferencing_ParamsSpec.$,NetworkDiagnosticsRoutines_RunVideoConferencing_ResponseParamsSpec.$,[stunServerHostname,source],false)}runArcHttp(source){return this.proxy.sendMessage(24,NetworkDiagnosticsRoutines_RunArcHttp_ParamsSpec.$,NetworkDiagnosticsRoutines_RunArcHttp_ResponseParamsSpec.$,[source],false)}runArcPing(source){return this.proxy.sendMessage(25,NetworkDiagnosticsRoutines_RunArcPing_ParamsSpec.$,NetworkDiagnosticsRoutines_RunArcPing_ResponseParamsSpec.$,[source],false)}runArcDnsResolution(source){return this.proxy.sendMessage(26,NetworkDiagnosticsRoutines_RunArcDnsResolution_ParamsSpec.$,NetworkDiagnosticsRoutines_RunArcDnsResolution_ResponseParamsSpec.$,[source],false)}}export class NetworkDiagnosticsRoutinesReceiver{helper_internal_;$;onConnectionError;constructor(impl){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(NetworkDiagnosticsRoutinesRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.helper_internal_.registerHandler(27,NetworkDiagnosticsRoutines_GetResult_ParamsSpec.$,NetworkDiagnosticsRoutines_GetResult_ResponseParamsSpec.$,impl.getResult.bind(impl),false);this.helper_internal_.registerHandler(28,NetworkDiagnosticsRoutines_GetAllResults_ParamsSpec.$,NetworkDiagnosticsRoutines_GetAllResults_ResponseParamsSpec.$,impl.getAllResults.bind(impl),false);this.helper_internal_.registerHandler(12,NetworkDiagnosticsRoutines_RunLanConnectivity_ParamsSpec.$,NetworkDiagnosticsRoutines_RunLanConnectivity_ResponseParamsSpec.$,impl.runLanConnectivity.bind(impl),false);this.helper_internal_.registerHandler(13,NetworkDiagnosticsRoutines_RunSignalStrength_ParamsSpec.$,NetworkDiagnosticsRoutines_RunSignalStrength_ResponseParamsSpec.$,impl.runSignalStrength.bind(impl),false);this.helper_internal_.registerHandler(14,NetworkDiagnosticsRoutines_RunGatewayCanBePinged_ParamsSpec.$,NetworkDiagnosticsRoutines_RunGatewayCanBePinged_ResponseParamsSpec.$,impl.runGatewayCanBePinged.bind(impl),false);this.helper_internal_.registerHandler(15,NetworkDiagnosticsRoutines_RunHasSecureWiFiConnection_ParamsSpec.$,NetworkDiagnosticsRoutines_RunHasSecureWiFiConnection_ResponseParamsSpec.$,impl.runHasSecureWiFiConnection.bind(impl),false);this.helper_internal_.registerHandler(16,NetworkDiagnosticsRoutines_RunDnsResolverPresent_ParamsSpec.$,NetworkDiagnosticsRoutines_RunDnsResolverPresent_ResponseParamsSpec.$,impl.runDnsResolverPresent.bind(impl),false);this.helper_internal_.registerHandler(17,NetworkDiagnosticsRoutines_RunDnsLatency_ParamsSpec.$,NetworkDiagnosticsRoutines_RunDnsLatency_ResponseParamsSpec.$,impl.runDnsLatency.bind(impl),false);this.helper_internal_.registerHandler(18,NetworkDiagnosticsRoutines_RunDnsResolution_ParamsSpec.$,NetworkDiagnosticsRoutines_RunDnsResolution_ResponseParamsSpec.$,impl.runDnsResolution.bind(impl),false);this.helper_internal_.registerHandler(19,NetworkDiagnosticsRoutines_RunCaptivePortal_ParamsSpec.$,NetworkDiagnosticsRoutines_RunCaptivePortal_ResponseParamsSpec.$,impl.runCaptivePortal.bind(impl),false);this.helper_internal_.registerHandler(20,NetworkDiagnosticsRoutines_RunHttpFirewall_ParamsSpec.$,NetworkDiagnosticsRoutines_RunHttpFirewall_ResponseParamsSpec.$,impl.runHttpFirewall.bind(impl),false);this.helper_internal_.registerHandler(21,NetworkDiagnosticsRoutines_RunHttpsFirewall_ParamsSpec.$,NetworkDiagnosticsRoutines_RunHttpsFirewall_ResponseParamsSpec.$,impl.runHttpsFirewall.bind(impl),false);this.helper_internal_.registerHandler(22,NetworkDiagnosticsRoutines_RunHttpsLatency_ParamsSpec.$,NetworkDiagnosticsRoutines_RunHttpsLatency_ResponseParamsSpec.$,impl.runHttpsLatency.bind(impl),false);this.helper_internal_.registerHandler(23,NetworkDiagnosticsRoutines_RunVideoConferencing_ParamsSpec.$,NetworkDiagnosticsRoutines_RunVideoConferencing_ResponseParamsSpec.$,impl.runVideoConferencing.bind(impl),false);this.helper_internal_.registerHandler(24,NetworkDiagnosticsRoutines_RunArcHttp_ParamsSpec.$,NetworkDiagnosticsRoutines_RunArcHttp_ResponseParamsSpec.$,impl.runArcHttp.bind(impl),false);this.helper_internal_.registerHandler(25,NetworkDiagnosticsRoutines_RunArcPing_ParamsSpec.$,NetworkDiagnosticsRoutines_RunArcPing_ResponseParamsSpec.$,impl.runArcPing.bind(impl),false);this.helper_internal_.registerHandler(26,NetworkDiagnosticsRoutines_RunArcDnsResolution_ParamsSpec.$,NetworkDiagnosticsRoutines_RunArcDnsResolution_ResponseParamsSpec.$,impl.runArcDnsResolution.bind(impl),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}}export class NetworkDiagnosticsRoutines{static get $interfaceName(){return"chromeos.network_diagnostics.mojom.NetworkDiagnosticsRoutines"}static getRemote(){let remote=new NetworkDiagnosticsRoutinesRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}export class NetworkDiagnosticsRoutinesCallbackRouter{helper_internal_;$;router_;getResult;getAllResults;runLanConnectivity;runSignalStrength;runGatewayCanBePinged;runHasSecureWiFiConnection;runDnsResolverPresent;runDnsLatency;runDnsResolution;runCaptivePortal;runHttpFirewall;runHttpsFirewall;runHttpsLatency;runVideoConferencing;runArcHttp;runArcPing;runArcDnsResolution;onConnectionError;constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(NetworkDiagnosticsRoutinesRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.getResult=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(27,NetworkDiagnosticsRoutines_GetResult_ParamsSpec.$,NetworkDiagnosticsRoutines_GetResult_ResponseParamsSpec.$,this.getResult.createReceiverHandler(true),false);this.getAllResults=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(28,NetworkDiagnosticsRoutines_GetAllResults_ParamsSpec.$,NetworkDiagnosticsRoutines_GetAllResults_ResponseParamsSpec.$,this.getAllResults.createReceiverHandler(true),false);this.runLanConnectivity=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(12,NetworkDiagnosticsRoutines_RunLanConnectivity_ParamsSpec.$,NetworkDiagnosticsRoutines_RunLanConnectivity_ResponseParamsSpec.$,this.runLanConnectivity.createReceiverHandler(true),false);this.runSignalStrength=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(13,NetworkDiagnosticsRoutines_RunSignalStrength_ParamsSpec.$,NetworkDiagnosticsRoutines_RunSignalStrength_ResponseParamsSpec.$,this.runSignalStrength.createReceiverHandler(true),false);this.runGatewayCanBePinged=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(14,NetworkDiagnosticsRoutines_RunGatewayCanBePinged_ParamsSpec.$,NetworkDiagnosticsRoutines_RunGatewayCanBePinged_ResponseParamsSpec.$,this.runGatewayCanBePinged.createReceiverHandler(true),false);this.runHasSecureWiFiConnection=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(15,NetworkDiagnosticsRoutines_RunHasSecureWiFiConnection_ParamsSpec.$,NetworkDiagnosticsRoutines_RunHasSecureWiFiConnection_ResponseParamsSpec.$,this.runHasSecureWiFiConnection.createReceiverHandler(true),false);this.runDnsResolverPresent=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(16,NetworkDiagnosticsRoutines_RunDnsResolverPresent_ParamsSpec.$,NetworkDiagnosticsRoutines_RunDnsResolverPresent_ResponseParamsSpec.$,this.runDnsResolverPresent.createReceiverHandler(true),false);this.runDnsLatency=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(17,NetworkDiagnosticsRoutines_RunDnsLatency_ParamsSpec.$,NetworkDiagnosticsRoutines_RunDnsLatency_ResponseParamsSpec.$,this.runDnsLatency.createReceiverHandler(true),false);this.runDnsResolution=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(18,NetworkDiagnosticsRoutines_RunDnsResolution_ParamsSpec.$,NetworkDiagnosticsRoutines_RunDnsResolution_ResponseParamsSpec.$,this.runDnsResolution.createReceiverHandler(true),false);this.runCaptivePortal=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(19,NetworkDiagnosticsRoutines_RunCaptivePortal_ParamsSpec.$,NetworkDiagnosticsRoutines_RunCaptivePortal_ResponseParamsSpec.$,this.runCaptivePortal.createReceiverHandler(true),false);this.runHttpFirewall=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(20,NetworkDiagnosticsRoutines_RunHttpFirewall_ParamsSpec.$,NetworkDiagnosticsRoutines_RunHttpFirewall_ResponseParamsSpec.$,this.runHttpFirewall.createReceiverHandler(true),false);this.runHttpsFirewall=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(21,NetworkDiagnosticsRoutines_RunHttpsFirewall_ParamsSpec.$,NetworkDiagnosticsRoutines_RunHttpsFirewall_ResponseParamsSpec.$,this.runHttpsFirewall.createReceiverHandler(true),false);this.runHttpsLatency=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(22,NetworkDiagnosticsRoutines_RunHttpsLatency_ParamsSpec.$,NetworkDiagnosticsRoutines_RunHttpsLatency_ResponseParamsSpec.$,this.runHttpsLatency.createReceiverHandler(true),false);this.runVideoConferencing=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(23,NetworkDiagnosticsRoutines_RunVideoConferencing_ParamsSpec.$,NetworkDiagnosticsRoutines_RunVideoConferencing_ResponseParamsSpec.$,this.runVideoConferencing.createReceiverHandler(true),false);this.runArcHttp=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(24,NetworkDiagnosticsRoutines_RunArcHttp_ParamsSpec.$,NetworkDiagnosticsRoutines_RunArcHttp_ResponseParamsSpec.$,this.runArcHttp.createReceiverHandler(true),false);this.runArcPing=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(25,NetworkDiagnosticsRoutines_RunArcPing_ParamsSpec.$,NetworkDiagnosticsRoutines_RunArcPing_ResponseParamsSpec.$,this.runArcPing.createReceiverHandler(true),false);this.runArcDnsResolution=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(26,NetworkDiagnosticsRoutines_RunArcDnsResolution_ParamsSpec.$,NetworkDiagnosticsRoutines_RunArcDnsResolution_ResponseParamsSpec.$,this.runArcDnsResolution.createReceiverHandler(true),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}export const HttpsLatencyResultValueSpec={$:{}};export const RoutineResultSpec={$:{}};export const NetworkDiagnosticsRoutines_GetResult_ParamsSpec={$:{}};export const NetworkDiagnosticsRoutines_GetResult_ResponseParamsSpec={$:{}};export const NetworkDiagnosticsRoutines_GetAllResults_ParamsSpec={$:{}};export const NetworkDiagnosticsRoutines_GetAllResults_ResponseParamsSpec={$:{}};export const NetworkDiagnosticsRoutines_RunLanConnectivity_ParamsSpec={$:{}};export const NetworkDiagnosticsRoutines_RunLanConnectivity_ResponseParamsSpec={$:{}};export const NetworkDiagnosticsRoutines_RunSignalStrength_ParamsSpec={$:{}};export const NetworkDiagnosticsRoutines_RunSignalStrength_ResponseParamsSpec={$:{}};export const NetworkDiagnosticsRoutines_RunGatewayCanBePinged_ParamsSpec={$:{}};export const NetworkDiagnosticsRoutines_RunGatewayCanBePinged_ResponseParamsSpec={$:{}};export const NetworkDiagnosticsRoutines_RunHasSecureWiFiConnection_ParamsSpec={$:{}};export const NetworkDiagnosticsRoutines_RunHasSecureWiFiConnection_ResponseParamsSpec={$:{}};export const NetworkDiagnosticsRoutines_RunDnsResolverPresent_ParamsSpec={$:{}};export const NetworkDiagnosticsRoutines_RunDnsResolverPresent_ResponseParamsSpec={$:{}};export const NetworkDiagnosticsRoutines_RunDnsLatency_ParamsSpec={$:{}};export const NetworkDiagnosticsRoutines_RunDnsLatency_ResponseParamsSpec={$:{}};export const NetworkDiagnosticsRoutines_RunDnsResolution_ParamsSpec={$:{}};export const NetworkDiagnosticsRoutines_RunDnsResolution_ResponseParamsSpec={$:{}};export const NetworkDiagnosticsRoutines_RunCaptivePortal_ParamsSpec={$:{}};export const NetworkDiagnosticsRoutines_RunCaptivePortal_ResponseParamsSpec={$:{}};export const NetworkDiagnosticsRoutines_RunHttpFirewall_ParamsSpec={$:{}};export const NetworkDiagnosticsRoutines_RunHttpFirewall_ResponseParamsSpec={$:{}};export const NetworkDiagnosticsRoutines_RunHttpsFirewall_ParamsSpec={$:{}};export const NetworkDiagnosticsRoutines_RunHttpsFirewall_ResponseParamsSpec={$:{}};export const NetworkDiagnosticsRoutines_RunHttpsLatency_ParamsSpec={$:{}};export const NetworkDiagnosticsRoutines_RunHttpsLatency_ResponseParamsSpec={$:{}};export const NetworkDiagnosticsRoutines_RunVideoConferencing_ParamsSpec={$:{}};export const NetworkDiagnosticsRoutines_RunVideoConferencing_ResponseParamsSpec={$:{}};export const NetworkDiagnosticsRoutines_RunArcHttp_ParamsSpec={$:{}};export const NetworkDiagnosticsRoutines_RunArcHttp_ResponseParamsSpec={$:{}};export const NetworkDiagnosticsRoutines_RunArcPing_ParamsSpec={$:{}};export const NetworkDiagnosticsRoutines_RunArcPing_ResponseParamsSpec={$:{}};export const NetworkDiagnosticsRoutines_RunArcDnsResolution_ParamsSpec={$:{}};export const NetworkDiagnosticsRoutines_RunArcDnsResolution_ResponseParamsSpec={$:{}};export const RoutineProblemsSpec={$:{}};export const RoutineResultValueSpec={$:{}};mojo.internal.Struct(HttpsLatencyResultValueSpec.$,"HttpsLatencyResultValue",[mojo.internal.StructField("latency",0,0,mojoBase_mojom_TimeDeltaSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(RoutineResultSpec.$,"RoutineResult",[mojo.internal.StructField("verdict",0,0,RoutineVerdictSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("problems",8,0,RoutineProblemsSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("timestamp",24,0,mojoBase_mojom_TimeSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("resultValue",32,0,RoutineResultValueSpec.$,null,true,1,undefined,undefined),mojo.internal.StructField("source",4,0,RoutineCallSourceSpec.$,0,false,2,undefined,undefined)],[[0,40],[1,56],[2,56]]);mojo.internal.Struct(NetworkDiagnosticsRoutines_GetResult_ParamsSpec.$,"NetworkDiagnosticsRoutines_GetResult_Params",[mojo.internal.StructField("routine",0,0,RoutineTypeSpec.$,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(NetworkDiagnosticsRoutines_GetResult_ResponseParamsSpec.$,"NetworkDiagnosticsRoutines_GetResult_ResponseParams",[mojo.internal.StructField("result",0,0,RoutineResultSpec.$,null,true,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(NetworkDiagnosticsRoutines_GetAllResults_ParamsSpec.$,"NetworkDiagnosticsRoutines_GetAllResults_Params",[],[[0,8]]);mojo.internal.Struct(NetworkDiagnosticsRoutines_GetAllResults_ResponseParamsSpec.$,"NetworkDiagnosticsRoutines_GetAllResults_ResponseParams",[mojo.internal.StructField("results",0,0,mojo.internal.Map(RoutineTypeSpec.$,RoutineResultSpec.$,false),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(NetworkDiagnosticsRoutines_RunLanConnectivity_ParamsSpec.$,"NetworkDiagnosticsRoutines_RunLanConnectivity_Params",[mojo.internal.StructField("source_$flag",0,0,mojo.internal.Bool,false,false,2,{isPrimary:true,linkedValueFieldName:"source_$value",originalFieldName:"source"},undefined),mojo.internal.StructField("source_$value",4,0,RoutineCallSourceSpec.$,0,false,2,{isPrimary:false,originalFieldName:"source"},undefined)],[[0,8],[2,16]]);mojo.internal.Struct(NetworkDiagnosticsRoutines_RunLanConnectivity_ResponseParamsSpec.$,"NetworkDiagnosticsRoutines_RunLanConnectivity_ResponseParams",[mojo.internal.StructField("result",0,0,RoutineResultSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(NetworkDiagnosticsRoutines_RunSignalStrength_ParamsSpec.$,"NetworkDiagnosticsRoutines_RunSignalStrength_Params",[mojo.internal.StructField("source_$flag",0,0,mojo.internal.Bool,false,false,2,{isPrimary:true,linkedValueFieldName:"source_$value",originalFieldName:"source"},undefined),mojo.internal.StructField("source_$value",4,0,RoutineCallSourceSpec.$,0,false,2,{isPrimary:false,originalFieldName:"source"},undefined)],[[0,8],[2,16]]);mojo.internal.Struct(NetworkDiagnosticsRoutines_RunSignalStrength_ResponseParamsSpec.$,"NetworkDiagnosticsRoutines_RunSignalStrength_ResponseParams",[mojo.internal.StructField("result",0,0,RoutineResultSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(NetworkDiagnosticsRoutines_RunGatewayCanBePinged_ParamsSpec.$,"NetworkDiagnosticsRoutines_RunGatewayCanBePinged_Params",[mojo.internal.StructField("source_$flag",0,0,mojo.internal.Bool,false,false,2,{isPrimary:true,linkedValueFieldName:"source_$value",originalFieldName:"source"},undefined),mojo.internal.StructField("source_$value",4,0,RoutineCallSourceSpec.$,0,false,2,{isPrimary:false,originalFieldName:"source"},undefined)],[[0,8],[2,16]]);mojo.internal.Struct(NetworkDiagnosticsRoutines_RunGatewayCanBePinged_ResponseParamsSpec.$,"NetworkDiagnosticsRoutines_RunGatewayCanBePinged_ResponseParams",[mojo.internal.StructField("result",0,0,RoutineResultSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(NetworkDiagnosticsRoutines_RunHasSecureWiFiConnection_ParamsSpec.$,"NetworkDiagnosticsRoutines_RunHasSecureWiFiConnection_Params",[mojo.internal.StructField("source_$flag",0,0,mojo.internal.Bool,false,false,2,{isPrimary:true,linkedValueFieldName:"source_$value",originalFieldName:"source"},undefined),mojo.internal.StructField("source_$value",4,0,RoutineCallSourceSpec.$,0,false,2,{isPrimary:false,originalFieldName:"source"},undefined)],[[0,8],[2,16]]);mojo.internal.Struct(NetworkDiagnosticsRoutines_RunHasSecureWiFiConnection_ResponseParamsSpec.$,"NetworkDiagnosticsRoutines_RunHasSecureWiFiConnection_ResponseParams",[mojo.internal.StructField("result",0,0,RoutineResultSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(NetworkDiagnosticsRoutines_RunDnsResolverPresent_ParamsSpec.$,"NetworkDiagnosticsRoutines_RunDnsResolverPresent_Params",[mojo.internal.StructField("source_$flag",0,0,mojo.internal.Bool,false,false,2,{isPrimary:true,linkedValueFieldName:"source_$value",originalFieldName:"source"},undefined),mojo.internal.StructField("source_$value",4,0,RoutineCallSourceSpec.$,0,false,2,{isPrimary:false,originalFieldName:"source"},undefined)],[[0,8],[2,16]]);mojo.internal.Struct(NetworkDiagnosticsRoutines_RunDnsResolverPresent_ResponseParamsSpec.$,"NetworkDiagnosticsRoutines_RunDnsResolverPresent_ResponseParams",[mojo.internal.StructField("result",0,0,RoutineResultSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(NetworkDiagnosticsRoutines_RunDnsLatency_ParamsSpec.$,"NetworkDiagnosticsRoutines_RunDnsLatency_Params",[mojo.internal.StructField("source_$flag",0,0,mojo.internal.Bool,false,false,2,{isPrimary:true,linkedValueFieldName:"source_$value",originalFieldName:"source"},undefined),mojo.internal.StructField("source_$value",4,0,RoutineCallSourceSpec.$,0,false,2,{isPrimary:false,originalFieldName:"source"},undefined)],[[0,8],[2,16]]);mojo.internal.Struct(NetworkDiagnosticsRoutines_RunDnsLatency_ResponseParamsSpec.$,"NetworkDiagnosticsRoutines_RunDnsLatency_ResponseParams",[mojo.internal.StructField("result",0,0,RoutineResultSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(NetworkDiagnosticsRoutines_RunDnsResolution_ParamsSpec.$,"NetworkDiagnosticsRoutines_RunDnsResolution_Params",[mojo.internal.StructField("source_$flag",0,0,mojo.internal.Bool,false,false,2,{isPrimary:true,linkedValueFieldName:"source_$value",originalFieldName:"source"},undefined),mojo.internal.StructField("source_$value",4,0,RoutineCallSourceSpec.$,0,false,2,{isPrimary:false,originalFieldName:"source"},undefined)],[[0,8],[2,16]]);mojo.internal.Struct(NetworkDiagnosticsRoutines_RunDnsResolution_ResponseParamsSpec.$,"NetworkDiagnosticsRoutines_RunDnsResolution_ResponseParams",[mojo.internal.StructField("result",0,0,RoutineResultSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(NetworkDiagnosticsRoutines_RunCaptivePortal_ParamsSpec.$,"NetworkDiagnosticsRoutines_RunCaptivePortal_Params",[mojo.internal.StructField("source_$flag",0,0,mojo.internal.Bool,false,false,2,{isPrimary:true,linkedValueFieldName:"source_$value",originalFieldName:"source"},undefined),mojo.internal.StructField("source_$value",4,0,RoutineCallSourceSpec.$,0,false,2,{isPrimary:false,originalFieldName:"source"},undefined)],[[0,8],[2,16]]);mojo.internal.Struct(NetworkDiagnosticsRoutines_RunCaptivePortal_ResponseParamsSpec.$,"NetworkDiagnosticsRoutines_RunCaptivePortal_ResponseParams",[mojo.internal.StructField("result",0,0,RoutineResultSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(NetworkDiagnosticsRoutines_RunHttpFirewall_ParamsSpec.$,"NetworkDiagnosticsRoutines_RunHttpFirewall_Params",[mojo.internal.StructField("source_$flag",0,0,mojo.internal.Bool,false,false,2,{isPrimary:true,linkedValueFieldName:"source_$value",originalFieldName:"source"},undefined),mojo.internal.StructField("source_$value",4,0,RoutineCallSourceSpec.$,0,false,2,{isPrimary:false,originalFieldName:"source"},undefined)],[[0,8],[2,16]]);mojo.internal.Struct(NetworkDiagnosticsRoutines_RunHttpFirewall_ResponseParamsSpec.$,"NetworkDiagnosticsRoutines_RunHttpFirewall_ResponseParams",[mojo.internal.StructField("result",0,0,RoutineResultSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(NetworkDiagnosticsRoutines_RunHttpsFirewall_ParamsSpec.$,"NetworkDiagnosticsRoutines_RunHttpsFirewall_Params",[mojo.internal.StructField("source_$flag",0,0,mojo.internal.Bool,false,false,2,{isPrimary:true,linkedValueFieldName:"source_$value",originalFieldName:"source"},undefined),mojo.internal.StructField("source_$value",4,0,RoutineCallSourceSpec.$,0,false,2,{isPrimary:false,originalFieldName:"source"},undefined)],[[0,8],[2,16]]);mojo.internal.Struct(NetworkDiagnosticsRoutines_RunHttpsFirewall_ResponseParamsSpec.$,"NetworkDiagnosticsRoutines_RunHttpsFirewall_ResponseParams",[mojo.internal.StructField("result",0,0,RoutineResultSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(NetworkDiagnosticsRoutines_RunHttpsLatency_ParamsSpec.$,"NetworkDiagnosticsRoutines_RunHttpsLatency_Params",[mojo.internal.StructField("source_$flag",0,0,mojo.internal.Bool,false,false,2,{isPrimary:true,linkedValueFieldName:"source_$value",originalFieldName:"source"},undefined),mojo.internal.StructField("source_$value",4,0,RoutineCallSourceSpec.$,0,false,2,{isPrimary:false,originalFieldName:"source"},undefined)],[[0,8],[2,16]]);mojo.internal.Struct(NetworkDiagnosticsRoutines_RunHttpsLatency_ResponseParamsSpec.$,"NetworkDiagnosticsRoutines_RunHttpsLatency_ResponseParams",[mojo.internal.StructField("result",0,0,RoutineResultSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(NetworkDiagnosticsRoutines_RunVideoConferencing_ParamsSpec.$,"NetworkDiagnosticsRoutines_RunVideoConferencing_Params",[mojo.internal.StructField("stunServerHostname",0,0,mojo.internal.String,null,true,0,undefined,undefined),mojo.internal.StructField("source_$flag",8,0,mojo.internal.Bool,false,false,2,{isPrimary:true,linkedValueFieldName:"source_$value",originalFieldName:"source"},undefined),mojo.internal.StructField("source_$value",12,0,RoutineCallSourceSpec.$,0,false,2,{isPrimary:false,originalFieldName:"source"},undefined)],[[0,16],[2,24]]);mojo.internal.Struct(NetworkDiagnosticsRoutines_RunVideoConferencing_ResponseParamsSpec.$,"NetworkDiagnosticsRoutines_RunVideoConferencing_ResponseParams",[mojo.internal.StructField("result",0,0,RoutineResultSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(NetworkDiagnosticsRoutines_RunArcHttp_ParamsSpec.$,"NetworkDiagnosticsRoutines_RunArcHttp_Params",[mojo.internal.StructField("source_$flag",0,0,mojo.internal.Bool,false,false,2,{isPrimary:true,linkedValueFieldName:"source_$value",originalFieldName:"source"},undefined),mojo.internal.StructField("source_$value",4,0,RoutineCallSourceSpec.$,0,false,2,{isPrimary:false,originalFieldName:"source"},undefined)],[[0,8],[2,16]]);mojo.internal.Struct(NetworkDiagnosticsRoutines_RunArcHttp_ResponseParamsSpec.$,"NetworkDiagnosticsRoutines_RunArcHttp_ResponseParams",[mojo.internal.StructField("result",0,0,RoutineResultSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(NetworkDiagnosticsRoutines_RunArcPing_ParamsSpec.$,"NetworkDiagnosticsRoutines_RunArcPing_Params",[mojo.internal.StructField("source_$flag",0,0,mojo.internal.Bool,false,false,2,{isPrimary:true,linkedValueFieldName:"source_$value",originalFieldName:"source"},undefined),mojo.internal.StructField("source_$value",4,0,RoutineCallSourceSpec.$,0,false,2,{isPrimary:false,originalFieldName:"source"},undefined)],[[0,8],[2,16]]);mojo.internal.Struct(NetworkDiagnosticsRoutines_RunArcPing_ResponseParamsSpec.$,"NetworkDiagnosticsRoutines_RunArcPing_ResponseParams",[mojo.internal.StructField("result",0,0,RoutineResultSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(NetworkDiagnosticsRoutines_RunArcDnsResolution_ParamsSpec.$,"NetworkDiagnosticsRoutines_RunArcDnsResolution_Params",[mojo.internal.StructField("source_$flag",0,0,mojo.internal.Bool,false,false,2,{isPrimary:true,linkedValueFieldName:"source_$value",originalFieldName:"source"},undefined),mojo.internal.StructField("source_$value",4,0,RoutineCallSourceSpec.$,0,false,2,{isPrimary:false,originalFieldName:"source"},undefined)],[[0,8],[2,16]]);mojo.internal.Struct(NetworkDiagnosticsRoutines_RunArcDnsResolution_ResponseParamsSpec.$,"NetworkDiagnosticsRoutines_RunArcDnsResolution_ResponseParams",[mojo.internal.StructField("result",0,0,RoutineResultSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Union(RoutineProblemsSpec.$,"RoutineProblems",{lanConnectivityProblems:{ordinal:0,type:mojo.internal.Array(LanConnectivityProblemSpec.$,false)},signalStrengthProblems:{ordinal:1,type:mojo.internal.Array(SignalStrengthProblemSpec.$,false)},gatewayCanBePingedProblems:{ordinal:2,type:mojo.internal.Array(GatewayCanBePingedProblemSpec.$,false)},hasSecureWifiConnectionProblems:{ordinal:3,type:mojo.internal.Array(HasSecureWiFiConnectionProblemSpec.$,false)},dnsResolverPresentProblems:{ordinal:4,type:mojo.internal.Array(DnsResolverPresentProblemSpec.$,false)},dnsLatencyProblems:{ordinal:5,type:mojo.internal.Array(DnsLatencyProblemSpec.$,false)},dnsResolutionProblems:{ordinal:6,type:mojo.internal.Array(DnsResolutionProblemSpec.$,false)},captivePortalProblems:{ordinal:7,type:mojo.internal.Array(CaptivePortalProblemSpec.$,false)},httpFirewallProblems:{ordinal:8,type:mojo.internal.Array(HttpFirewallProblemSpec.$,false)},httpsFirewallProblems:{ordinal:9,type:mojo.internal.Array(HttpsFirewallProblemSpec.$,false)},httpsLatencyProblems:{ordinal:10,type:mojo.internal.Array(HttpsLatencyProblemSpec.$,false)},videoConferencingProblems:{ordinal:11,type:mojo.internal.Array(VideoConferencingProblemSpec.$,false)},arcHttpProblems:{ordinal:12,type:mojo.internal.Array(ArcHttpProblemSpec.$,false)},arcDnsResolutionProblems:{ordinal:13,type:mojo.internal.Array(ArcDnsResolutionProblemSpec.$,false)},arcPingProblems:{ordinal:14,type:mojo.internal.Array(ArcPingProblemSpec.$,false)}});export var RoutineProblemsFieldTags;(function(RoutineProblemsFieldTags){RoutineProblemsFieldTags[RoutineProblemsFieldTags["LAN_CONNECTIVITY_PROBLEMS"]=0]="LAN_CONNECTIVITY_PROBLEMS";RoutineProblemsFieldTags[RoutineProblemsFieldTags["SIGNAL_STRENGTH_PROBLEMS"]=1]="SIGNAL_STRENGTH_PROBLEMS";RoutineProblemsFieldTags[RoutineProblemsFieldTags["GATEWAY_CAN_BE_PINGED_PROBLEMS"]=2]="GATEWAY_CAN_BE_PINGED_PROBLEMS";RoutineProblemsFieldTags[RoutineProblemsFieldTags["HAS_SECURE_WIFI_CONNECTION_PROBLEMS"]=3]="HAS_SECURE_WIFI_CONNECTION_PROBLEMS";RoutineProblemsFieldTags[RoutineProblemsFieldTags["DNS_RESOLVER_PRESENT_PROBLEMS"]=4]="DNS_RESOLVER_PRESENT_PROBLEMS";RoutineProblemsFieldTags[RoutineProblemsFieldTags["DNS_LATENCY_PROBLEMS"]=5]="DNS_LATENCY_PROBLEMS";RoutineProblemsFieldTags[RoutineProblemsFieldTags["DNS_RESOLUTION_PROBLEMS"]=6]="DNS_RESOLUTION_PROBLEMS";RoutineProblemsFieldTags[RoutineProblemsFieldTags["CAPTIVE_PORTAL_PROBLEMS"]=7]="CAPTIVE_PORTAL_PROBLEMS";RoutineProblemsFieldTags[RoutineProblemsFieldTags["HTTP_FIREWALL_PROBLEMS"]=8]="HTTP_FIREWALL_PROBLEMS";RoutineProblemsFieldTags[RoutineProblemsFieldTags["HTTPS_FIREWALL_PROBLEMS"]=9]="HTTPS_FIREWALL_PROBLEMS";RoutineProblemsFieldTags[RoutineProblemsFieldTags["HTTPS_LATENCY_PROBLEMS"]=10]="HTTPS_LATENCY_PROBLEMS";RoutineProblemsFieldTags[RoutineProblemsFieldTags["VIDEO_CONFERENCING_PROBLEMS"]=11]="VIDEO_CONFERENCING_PROBLEMS";RoutineProblemsFieldTags[RoutineProblemsFieldTags["ARC_HTTP_PROBLEMS"]=12]="ARC_HTTP_PROBLEMS";RoutineProblemsFieldTags[RoutineProblemsFieldTags["ARC_DNS_RESOLUTION_PROBLEMS"]=13]="ARC_DNS_RESOLUTION_PROBLEMS";RoutineProblemsFieldTags[RoutineProblemsFieldTags["ARC_PING_PROBLEMS"]=14]="ARC_PING_PROBLEMS"})(RoutineProblemsFieldTags||(RoutineProblemsFieldTags={}));export function whichRoutineProblems(u){if(u.lanConnectivityProblems!==null&&u.lanConnectivityProblems!==undefined){return RoutineProblemsFieldTags.LAN_CONNECTIVITY_PROBLEMS}if(u.signalStrengthProblems!==null&&u.signalStrengthProblems!==undefined){return RoutineProblemsFieldTags.SIGNAL_STRENGTH_PROBLEMS}if(u.gatewayCanBePingedProblems!==null&&u.gatewayCanBePingedProblems!==undefined){return RoutineProblemsFieldTags.GATEWAY_CAN_BE_PINGED_PROBLEMS}if(u.hasSecureWifiConnectionProblems!==null&&u.hasSecureWifiConnectionProblems!==undefined){return RoutineProblemsFieldTags.HAS_SECURE_WIFI_CONNECTION_PROBLEMS}if(u.dnsResolverPresentProblems!==null&&u.dnsResolverPresentProblems!==undefined){return RoutineProblemsFieldTags.DNS_RESOLVER_PRESENT_PROBLEMS}if(u.dnsLatencyProblems!==null&&u.dnsLatencyProblems!==undefined){return RoutineProblemsFieldTags.DNS_LATENCY_PROBLEMS}if(u.dnsResolutionProblems!==null&&u.dnsResolutionProblems!==undefined){return RoutineProblemsFieldTags.DNS_RESOLUTION_PROBLEMS}if(u.captivePortalProblems!==null&&u.captivePortalProblems!==undefined){return RoutineProblemsFieldTags.CAPTIVE_PORTAL_PROBLEMS}if(u.httpFirewallProblems!==null&&u.httpFirewallProblems!==undefined){return RoutineProblemsFieldTags.HTTP_FIREWALL_PROBLEMS}if(u.httpsFirewallProblems!==null&&u.httpsFirewallProblems!==undefined){return RoutineProblemsFieldTags.HTTPS_FIREWALL_PROBLEMS}if(u.httpsLatencyProblems!==null&&u.httpsLatencyProblems!==undefined){return RoutineProblemsFieldTags.HTTPS_LATENCY_PROBLEMS}if(u.videoConferencingProblems!==null&&u.videoConferencingProblems!==undefined){return RoutineProblemsFieldTags.VIDEO_CONFERENCING_PROBLEMS}if(u.arcHttpProblems!==null&&u.arcHttpProblems!==undefined){return RoutineProblemsFieldTags.ARC_HTTP_PROBLEMS}if(u.arcDnsResolutionProblems!==null&&u.arcDnsResolutionProblems!==undefined){return RoutineProblemsFieldTags.ARC_DNS_RESOLUTION_PROBLEMS}if(u.arcPingProblems!==null&&u.arcPingProblems!==undefined){return RoutineProblemsFieldTags.ARC_PING_PROBLEMS}throw new Error("no union field has been set, this is an illegal state")}mojo.internal.Union(RoutineResultValueSpec.$,"RoutineResultValue",{httpsLatencyResultValue:{ordinal:0,type:HttpsLatencyResultValueSpec.$}});export var RoutineResultValueFieldTags;(function(RoutineResultValueFieldTags){RoutineResultValueFieldTags[RoutineResultValueFieldTags["HTTPS_LATENCY_RESULT_VALUE"]=0]="HTTPS_LATENCY_RESULT_VALUE"})(RoutineResultValueFieldTags||(RoutineResultValueFieldTags={}));export function whichRoutineResultValue(u){if(u.httpsLatencyResultValue!==null&&u.httpsLatencyResultValue!==undefined){return RoutineResultValueFieldTags.HTTPS_LATENCY_RESULT_VALUE}throw new Error("no union field has been set, this is an illegal state")}