// ui/webui/resources/cr_components/app_management/app_management.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
import { UrlSpec as url_mojom_UrlSpec } from '//resources/mojo/url/mojom/url.mojom-webui.js';
export const AppTypeSpec = { $: mojo.internal.Enum() };
export var AppType;
(function (AppType) {
    AppType[AppType["MIN_VALUE"] = 0] = "MIN_VALUE";
    AppType[AppType["MAX_VALUE"] = 10] = "MAX_VALUE";
    AppType[AppType["kUnknown"] = 0] = "kUnknown";
    AppType[AppType["kArc"] = 1] = "kArc";
    AppType[AppType["kCrostini"] = 2] = "kCrostini";
    AppType[AppType["kChromeApp"] = 3] = "kChromeApp";
    AppType[AppType["kWeb"] = 4] = "kWeb";
    AppType[AppType["kPluginVm"] = 5] = "kPluginVm";
    AppType[AppType["kRemote"] = 6] = "kRemote";
    AppType[AppType["kBorealis"] = 7] = "kBorealis";
    AppType[AppType["kSystemWeb"] = 8] = "kSystemWeb";
    AppType[AppType["kExtension"] = 9] = "kExtension";
    AppType[AppType["kBruschetta"] = 10] = "kBruschetta";
})(AppType || (AppType = {}));
export const PermissionTypeSpec = { $: mojo.internal.Enum() };
export var PermissionType;
(function (PermissionType) {
    PermissionType[PermissionType["MIN_VALUE"] = 0] = "MIN_VALUE";
    PermissionType[PermissionType["MAX_VALUE"] = 8] = "MAX_VALUE";
    PermissionType[PermissionType["kUnknown"] = 0] = "kUnknown";
    PermissionType[PermissionType["kCamera"] = 1] = "kCamera";
    PermissionType[PermissionType["kLocation"] = 2] = "kLocation";
    PermissionType[PermissionType["kMicrophone"] = 3] = "kMicrophone";
    PermissionType[PermissionType["kNotifications"] = 4] = "kNotifications";
    PermissionType[PermissionType["kContacts"] = 5] = "kContacts";
    PermissionType[PermissionType["kStorage"] = 6] = "kStorage";
    PermissionType[PermissionType["kPrinting"] = 7] = "kPrinting";
    PermissionType[PermissionType["kFileHandling"] = 8] = "kFileHandling";
})(PermissionType || (PermissionType = {}));
export const TriStateSpec = { $: mojo.internal.Enum() };
export var TriState;
(function (TriState) {
    TriState[TriState["MIN_VALUE"] = 0] = "MIN_VALUE";
    TriState[TriState["MAX_VALUE"] = 2] = "MAX_VALUE";
    TriState[TriState["kAllow"] = 0] = "kAllow";
    TriState[TriState["kBlock"] = 1] = "kBlock";
    TriState[TriState["kAsk"] = 2] = "kAsk";
})(TriState || (TriState = {}));
export const InstallReasonSpec = { $: mojo.internal.Enum() };
export var InstallReason;
(function (InstallReason) {
    InstallReason[InstallReason["MIN_VALUE"] = 0] = "MIN_VALUE";
    InstallReason[InstallReason["MAX_VALUE"] = 9] = "MAX_VALUE";
    InstallReason[InstallReason["kUnknown"] = 0] = "kUnknown";
    InstallReason[InstallReason["kSystem"] = 1] = "kSystem";
    InstallReason[InstallReason["kPolicy"] = 2] = "kPolicy";
    InstallReason[InstallReason["kOem"] = 3] = "kOem";
    InstallReason[InstallReason["kDefault"] = 4] = "kDefault";
    InstallReason[InstallReason["kSync"] = 5] = "kSync";
    InstallReason[InstallReason["kUser"] = 6] = "kUser";
    InstallReason[InstallReason["kSubApp"] = 7] = "kSubApp";
    InstallReason[InstallReason["kKiosk"] = 8] = "kKiosk";
    InstallReason[InstallReason["kCommandLine"] = 9] = "kCommandLine";
})(InstallReason || (InstallReason = {}));
export const InstallSourceSpec = { $: mojo.internal.Enum() };
export var InstallSource;
(function (InstallSource) {
    InstallSource[InstallSource["MIN_VALUE"] = 0] = "MIN_VALUE";
    InstallSource[InstallSource["MAX_VALUE"] = 5] = "MAX_VALUE";
    InstallSource[InstallSource["kUnknown"] = 0] = "kUnknown";
    InstallSource[InstallSource["kSystem"] = 1] = "kSystem";
    InstallSource[InstallSource["kSync"] = 2] = "kSync";
    InstallSource[InstallSource["kPlayStore"] = 3] = "kPlayStore";
    InstallSource[InstallSource["kChromeWebStore"] = 4] = "kChromeWebStore";
    InstallSource[InstallSource["kBrowser"] = 5] = "kBrowser";
})(InstallSource || (InstallSource = {}));
export const WindowModeSpec = { $: mojo.internal.Enum() };
export var WindowMode;
(function (WindowMode) {
    WindowMode[WindowMode["MIN_VALUE"] = 0] = "MIN_VALUE";
    WindowMode[WindowMode["MAX_VALUE"] = 3] = "MAX_VALUE";
    WindowMode[WindowMode["kUnknown"] = 0] = "kUnknown";
    WindowMode[WindowMode["kWindow"] = 1] = "kWindow";
    WindowMode[WindowMode["kBrowser"] = 2] = "kBrowser";
    WindowMode[WindowMode["kTabbedWindow"] = 3] = "kTabbedWindow";
})(WindowMode || (WindowMode = {}));
export const RunOnOsLoginModeSpec = { $: mojo.internal.Enum() };
export var RunOnOsLoginMode;
(function (RunOnOsLoginMode) {
    RunOnOsLoginMode[RunOnOsLoginMode["MIN_VALUE"] = 0] = "MIN_VALUE";
    RunOnOsLoginMode[RunOnOsLoginMode["MAX_VALUE"] = 2] = "MAX_VALUE";
    RunOnOsLoginMode[RunOnOsLoginMode["kUnknown"] = 0] = "kUnknown";
    RunOnOsLoginMode[RunOnOsLoginMode["kNotRun"] = 1] = "kNotRun";
    RunOnOsLoginMode[RunOnOsLoginMode["kWindowed"] = 2] = "kWindowed";
})(RunOnOsLoginMode || (RunOnOsLoginMode = {}));
export class PageHandlerFactoryPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'app_management.mojom.PageHandlerFactory', scope);
    }
}
export class PageHandlerFactoryRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PageHandlerFactoryPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    createPageHandler(page, handler) {
        this.proxy.sendMessage(0, PageHandlerFactory_CreatePageHandler_ParamsSpec.$, null, [
            page,
            handler
        ], false);
    }
}
;
/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerFactoryReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerFactoryRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, PageHandlerFactory_CreatePageHandler_ParamsSpec.$, null, impl.createPageHandler.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class PageHandlerFactory {
    static get $interfaceName() {
        return "app_management.mojom.PageHandlerFactory";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new PageHandlerFactoryRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerFactoryCallbackRouter {
    helper_internal_;
    $;
    router_;
    createPageHandler;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerFactoryRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.createPageHandler =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, PageHandlerFactory_CreatePageHandler_ParamsSpec.$, null, this.createPageHandler.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class PageHandlerPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'app_management.mojom.PageHandler', scope);
    }
}
export class PageHandlerRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PageHandlerPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    getApps() {
        return this.proxy.sendMessage(0, PageHandler_GetApps_ParamsSpec.$, PageHandler_GetApps_ResponseParamsSpec.$, [], false);
    }
    getApp(appId) {
        return this.proxy.sendMessage(1, PageHandler_GetApp_ParamsSpec.$, PageHandler_GetApp_ResponseParamsSpec.$, [
            appId
        ], false);
    }
    getSubAppToParentMap() {
        return this.proxy.sendMessage(2, PageHandler_GetSubAppToParentMap_ParamsSpec.$, PageHandler_GetSubAppToParentMap_ResponseParamsSpec.$, [], false);
    }
    getExtensionAppPermissionMessages(appId) {
        return this.proxy.sendMessage(3, PageHandler_GetExtensionAppPermissionMessages_ParamsSpec.$, PageHandler_GetExtensionAppPermissionMessages_ResponseParamsSpec.$, [
            appId
        ], false);
    }
    setPinned(appId, pinned) {
        this.proxy.sendMessage(4, PageHandler_SetPinned_ParamsSpec.$, null, [
            appId,
            pinned
        ], false);
    }
    setPermission(appId, permission) {
        this.proxy.sendMessage(5, PageHandler_SetPermission_ParamsSpec.$, null, [
            appId,
            permission
        ], false);
    }
    setResizeLocked(appId, locked) {
        this.proxy.sendMessage(6, PageHandler_SetResizeLocked_ParamsSpec.$, null, [
            appId,
            locked
        ], false);
    }
    uninstall(appId) {
        this.proxy.sendMessage(7, PageHandler_Uninstall_ParamsSpec.$, null, [
            appId
        ], false);
    }
    openNativeSettings(appId) {
        this.proxy.sendMessage(8, PageHandler_OpenNativeSettings_ParamsSpec.$, null, [
            appId
        ], false);
    }
    setPreferredApp(appId, isPreferredApp) {
        this.proxy.sendMessage(9, PageHandler_SetPreferredApp_ParamsSpec.$, null, [
            appId,
            isPreferredApp
        ], false);
    }
    getOverlappingPreferredApps(appId) {
        return this.proxy.sendMessage(10, PageHandler_GetOverlappingPreferredApps_ParamsSpec.$, PageHandler_GetOverlappingPreferredApps_ResponseParamsSpec.$, [
            appId
        ], false);
    }
    updateAppSize(appId) {
        this.proxy.sendMessage(11, PageHandler_UpdateAppSize_ParamsSpec.$, null, [
            appId
        ], false);
    }
    setWindowMode(appId, windowMode) {
        this.proxy.sendMessage(12, PageHandler_SetWindowMode_ParamsSpec.$, null, [
            appId,
            windowMode
        ], false);
    }
    setRunOnOsLoginMode(appId, runOnOsLoginMode) {
        this.proxy.sendMessage(13, PageHandler_SetRunOnOsLoginMode_ParamsSpec.$, null, [
            appId,
            runOnOsLoginMode
        ], false);
    }
    setFileHandlingEnabled(appId, enabled) {
        this.proxy.sendMessage(14, PageHandler_SetFileHandlingEnabled_ParamsSpec.$, null, [
            appId,
            enabled
        ], false);
    }
    showDefaultAppAssociationsUi() {
        this.proxy.sendMessage(15, PageHandler_ShowDefaultAppAssociationsUi_ParamsSpec.$, null, [], false);
    }
    openStorePage(appId) {
        this.proxy.sendMessage(16, PageHandler_OpenStorePage_ParamsSpec.$, null, [
            appId
        ], false);
    }
    setAppLocale(appId, localeTag) {
        this.proxy.sendMessage(17, PageHandler_SetAppLocale_ParamsSpec.$, null, [
            appId,
            localeTag
        ], false);
    }
}
;
/**
 * An object which receives request messages for the PageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, PageHandler_GetApps_ParamsSpec.$, PageHandler_GetApps_ResponseParamsSpec.$, impl.getApps.bind(impl), false);
        this.helper_internal_.registerHandler(1, PageHandler_GetApp_ParamsSpec.$, PageHandler_GetApp_ResponseParamsSpec.$, impl.getApp.bind(impl), false);
        this.helper_internal_.registerHandler(2, PageHandler_GetSubAppToParentMap_ParamsSpec.$, PageHandler_GetSubAppToParentMap_ResponseParamsSpec.$, impl.getSubAppToParentMap.bind(impl), false);
        this.helper_internal_.registerHandler(3, PageHandler_GetExtensionAppPermissionMessages_ParamsSpec.$, PageHandler_GetExtensionAppPermissionMessages_ResponseParamsSpec.$, impl.getExtensionAppPermissionMessages.bind(impl), false);
        this.helper_internal_.registerHandler(4, PageHandler_SetPinned_ParamsSpec.$, null, impl.setPinned.bind(impl), false);
        this.helper_internal_.registerHandler(5, PageHandler_SetPermission_ParamsSpec.$, null, impl.setPermission.bind(impl), false);
        this.helper_internal_.registerHandler(6, PageHandler_SetResizeLocked_ParamsSpec.$, null, impl.setResizeLocked.bind(impl), false);
        this.helper_internal_.registerHandler(7, PageHandler_Uninstall_ParamsSpec.$, null, impl.uninstall.bind(impl), false);
        this.helper_internal_.registerHandler(8, PageHandler_OpenNativeSettings_ParamsSpec.$, null, impl.openNativeSettings.bind(impl), false);
        this.helper_internal_.registerHandler(9, PageHandler_SetPreferredApp_ParamsSpec.$, null, impl.setPreferredApp.bind(impl), false);
        this.helper_internal_.registerHandler(10, PageHandler_GetOverlappingPreferredApps_ParamsSpec.$, PageHandler_GetOverlappingPreferredApps_ResponseParamsSpec.$, impl.getOverlappingPreferredApps.bind(impl), false);
        this.helper_internal_.registerHandler(11, PageHandler_UpdateAppSize_ParamsSpec.$, null, impl.updateAppSize.bind(impl), false);
        this.helper_internal_.registerHandler(12, PageHandler_SetWindowMode_ParamsSpec.$, null, impl.setWindowMode.bind(impl), false);
        this.helper_internal_.registerHandler(13, PageHandler_SetRunOnOsLoginMode_ParamsSpec.$, null, impl.setRunOnOsLoginMode.bind(impl), false);
        this.helper_internal_.registerHandler(14, PageHandler_SetFileHandlingEnabled_ParamsSpec.$, null, impl.setFileHandlingEnabled.bind(impl), false);
        this.helper_internal_.registerHandler(15, PageHandler_ShowDefaultAppAssociationsUi_ParamsSpec.$, null, impl.showDefaultAppAssociationsUi.bind(impl), false);
        this.helper_internal_.registerHandler(16, PageHandler_OpenStorePage_ParamsSpec.$, null, impl.openStorePage.bind(impl), false);
        this.helper_internal_.registerHandler(17, PageHandler_SetAppLocale_ParamsSpec.$, null, impl.setAppLocale.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class PageHandler {
    static get $interfaceName() {
        return "app_management.mojom.PageHandler";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new PageHandlerRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the PageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerCallbackRouter {
    helper_internal_;
    $;
    router_;
    getApps;
    getApp;
    getSubAppToParentMap;
    getExtensionAppPermissionMessages;
    setPinned;
    setPermission;
    setResizeLocked;
    uninstall;
    openNativeSettings;
    setPreferredApp;
    getOverlappingPreferredApps;
    updateAppSize;
    setWindowMode;
    setRunOnOsLoginMode;
    setFileHandlingEnabled;
    showDefaultAppAssociationsUi;
    openStorePage;
    setAppLocale;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.getApps =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, PageHandler_GetApps_ParamsSpec.$, PageHandler_GetApps_ResponseParamsSpec.$, this.getApps.createReceiverHandler(true /* expectsResponse */), false);
        this.getApp =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, PageHandler_GetApp_ParamsSpec.$, PageHandler_GetApp_ResponseParamsSpec.$, this.getApp.createReceiverHandler(true /* expectsResponse */), false);
        this.getSubAppToParentMap =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, PageHandler_GetSubAppToParentMap_ParamsSpec.$, PageHandler_GetSubAppToParentMap_ResponseParamsSpec.$, this.getSubAppToParentMap.createReceiverHandler(true /* expectsResponse */), false);
        this.getExtensionAppPermissionMessages =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, PageHandler_GetExtensionAppPermissionMessages_ParamsSpec.$, PageHandler_GetExtensionAppPermissionMessages_ResponseParamsSpec.$, this.getExtensionAppPermissionMessages.createReceiverHandler(true /* expectsResponse */), false);
        this.setPinned =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(4, PageHandler_SetPinned_ParamsSpec.$, null, this.setPinned.createReceiverHandler(false /* expectsResponse */), false);
        this.setPermission =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(5, PageHandler_SetPermission_ParamsSpec.$, null, this.setPermission.createReceiverHandler(false /* expectsResponse */), false);
        this.setResizeLocked =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(6, PageHandler_SetResizeLocked_ParamsSpec.$, null, this.setResizeLocked.createReceiverHandler(false /* expectsResponse */), false);
        this.uninstall =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(7, PageHandler_Uninstall_ParamsSpec.$, null, this.uninstall.createReceiverHandler(false /* expectsResponse */), false);
        this.openNativeSettings =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(8, PageHandler_OpenNativeSettings_ParamsSpec.$, null, this.openNativeSettings.createReceiverHandler(false /* expectsResponse */), false);
        this.setPreferredApp =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(9, PageHandler_SetPreferredApp_ParamsSpec.$, null, this.setPreferredApp.createReceiverHandler(false /* expectsResponse */), false);
        this.getOverlappingPreferredApps =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(10, PageHandler_GetOverlappingPreferredApps_ParamsSpec.$, PageHandler_GetOverlappingPreferredApps_ResponseParamsSpec.$, this.getOverlappingPreferredApps.createReceiverHandler(true /* expectsResponse */), false);
        this.updateAppSize =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(11, PageHandler_UpdateAppSize_ParamsSpec.$, null, this.updateAppSize.createReceiverHandler(false /* expectsResponse */), false);
        this.setWindowMode =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(12, PageHandler_SetWindowMode_ParamsSpec.$, null, this.setWindowMode.createReceiverHandler(false /* expectsResponse */), false);
        this.setRunOnOsLoginMode =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(13, PageHandler_SetRunOnOsLoginMode_ParamsSpec.$, null, this.setRunOnOsLoginMode.createReceiverHandler(false /* expectsResponse */), false);
        this.setFileHandlingEnabled =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(14, PageHandler_SetFileHandlingEnabled_ParamsSpec.$, null, this.setFileHandlingEnabled.createReceiverHandler(false /* expectsResponse */), false);
        this.showDefaultAppAssociationsUi =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(15, PageHandler_ShowDefaultAppAssociationsUi_ParamsSpec.$, null, this.showDefaultAppAssociationsUi.createReceiverHandler(false /* expectsResponse */), false);
        this.openStorePage =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(16, PageHandler_OpenStorePage_ParamsSpec.$, null, this.openStorePage.createReceiverHandler(false /* expectsResponse */), false);
        this.setAppLocale =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(17, PageHandler_SetAppLocale_ParamsSpec.$, null, this.setAppLocale.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class PagePendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'app_management.mojom.Page', scope);
    }
}
export class PageRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PagePendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onAppAdded(app) {
        this.proxy.sendMessage(0, Page_OnAppAdded_ParamsSpec.$, null, [
            app
        ], false);
    }
    onAppChanged(update) {
        this.proxy.sendMessage(1, Page_OnAppChanged_ParamsSpec.$, null, [
            update
        ], false);
    }
    onAppRemoved(appId) {
        this.proxy.sendMessage(2, Page_OnAppRemoved_ParamsSpec.$, null, [
            appId
        ], false);
    }
}
;
/**
 * An object which receives request messages for the Page
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, Page_OnAppAdded_ParamsSpec.$, null, impl.onAppAdded.bind(impl), false);
        this.helper_internal_.registerHandler(1, Page_OnAppChanged_ParamsSpec.$, null, impl.onAppChanged.bind(impl), false);
        this.helper_internal_.registerHandler(2, Page_OnAppRemoved_ParamsSpec.$, null, impl.onAppRemoved.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class Page {
    static get $interfaceName() {
        return "app_management.mojom.Page";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new PageRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the Page
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageCallbackRouter {
    helper_internal_;
    $;
    router_;
    onAppAdded;
    onAppChanged;
    onAppRemoved;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.onAppAdded =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, Page_OnAppAdded_ParamsSpec.$, null, this.onAppAdded.createReceiverHandler(false /* expectsResponse */), false);
        this.onAppChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, Page_OnAppChanged_ParamsSpec.$, null, this.onAppChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.onAppRemoved =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, Page_OnAppRemoved_ParamsSpec.$, null, this.onAppRemoved.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export const PermissionSpec = { $: {} };
export const RunOnOsLoginSpec = { $: {} };
export const LocaleSpec = { $: {} };
export const AppSpec = { $: {} };
export const ExtensionAppPermissionMessageSpec = { $: {} };
export const FileHandlingStateSpec = { $: {} };
export const PageHandlerFactory_CreatePageHandler_ParamsSpec = { $: {} };
export const PageHandler_GetApps_ParamsSpec = { $: {} };
export const PageHandler_GetApps_ResponseParamsSpec = { $: {} };
export const PageHandler_GetApp_ParamsSpec = { $: {} };
export const PageHandler_GetApp_ResponseParamsSpec = { $: {} };
export const PageHandler_GetSubAppToParentMap_ParamsSpec = { $: {} };
export const PageHandler_GetSubAppToParentMap_ResponseParamsSpec = { $: {} };
export const PageHandler_GetExtensionAppPermissionMessages_ParamsSpec = { $: {} };
export const PageHandler_GetExtensionAppPermissionMessages_ResponseParamsSpec = { $: {} };
export const PageHandler_SetPinned_ParamsSpec = { $: {} };
export const PageHandler_SetPermission_ParamsSpec = { $: {} };
export const PageHandler_SetResizeLocked_ParamsSpec = { $: {} };
export const PageHandler_Uninstall_ParamsSpec = { $: {} };
export const PageHandler_OpenNativeSettings_ParamsSpec = { $: {} };
export const PageHandler_SetPreferredApp_ParamsSpec = { $: {} };
export const PageHandler_GetOverlappingPreferredApps_ParamsSpec = { $: {} };
export const PageHandler_GetOverlappingPreferredApps_ResponseParamsSpec = { $: {} };
export const PageHandler_UpdateAppSize_ParamsSpec = { $: {} };
export const PageHandler_SetWindowMode_ParamsSpec = { $: {} };
export const PageHandler_SetRunOnOsLoginMode_ParamsSpec = { $: {} };
export const PageHandler_SetFileHandlingEnabled_ParamsSpec = { $: {} };
export const PageHandler_ShowDefaultAppAssociationsUi_ParamsSpec = { $: {} };
export const PageHandler_OpenStorePage_ParamsSpec = { $: {} };
export const PageHandler_SetAppLocale_ParamsSpec = { $: {} };
export const Page_OnAppAdded_ParamsSpec = { $: {} };
export const Page_OnAppChanged_ParamsSpec = { $: {} };
export const Page_OnAppRemoved_ParamsSpec = { $: {} };
export const PermissionValueSpec = { $: {} };
mojo.internal.Struct(PermissionSpec.$, 'Permission', [
    mojo.internal.StructField('permissionType', 0, 0, PermissionTypeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('value', 8, 0, PermissionValueSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('isManaged', 4, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('details', 24, 0, mojo.internal.String, null, true /* nullable */, 0, undefined, undefined),
], [[0, 40],]);
mojo.internal.Struct(RunOnOsLoginSpec.$, 'RunOnOsLogin', [
    mojo.internal.StructField('loginMode', 0, 0, RunOnOsLoginModeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('isManaged', 4, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(LocaleSpec.$, 'Locale', [
    mojo.internal.StructField('localeTag', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('displayName', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('nativeDisplayName', 16, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 32],]);
mojo.internal.Struct(AppSpec.$, 'App', [
    mojo.internal.StructField('id', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('type', 8, 0, AppTypeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('title', 16, 0, mojo.internal.String, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('description', 24, 0, mojo.internal.String, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('is_pinned_$flag', 12, 0, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: true,
        linkedValueFieldName: "is_pinned_$value",
        originalFieldName: "isPinned",
    }, undefined),
    mojo.internal.StructField('is_pinned_$value', 12, 1, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: false,
        originalFieldName: "isPinned",
    }, undefined),
    mojo.internal.StructField('is_policy_pinned_$flag', 12, 2, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: true,
        linkedValueFieldName: "is_policy_pinned_$value",
        originalFieldName: "isPolicyPinned",
    }, undefined),
    mojo.internal.StructField('is_policy_pinned_$value', 12, 3, mojo.internal.Bool, false, false /* nullable */, 0, {
        isPrimary: false,
        originalFieldName: "isPolicyPinned",
    }, undefined),
    mojo.internal.StructField('version', 32, 0, mojo.internal.String, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('size', 40, 0, mojo.internal.String, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('permissions', 48, 0, mojo.internal.Map(PermissionTypeSpec.$, PermissionSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('installReason', 56, 0, InstallReasonSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('installSource', 60, 0, InstallSourceSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('hideMoreSettings', 12, 4, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('hidePinToShelf', 12, 5, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('isPreferredApp', 12, 6, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('windowMode', 64, 0, WindowModeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('hideWindowMode', 12, 7, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('resizeLocked', 13, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('hideResizeLocked', 13, 1, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('supportedLinks', 72, 0, mojo.internal.Array(mojo.internal.String, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('runOnOsLogin', 80, 0, RunOnOsLoginSpec.$, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('fileHandlingState', 88, 0, FileHandlingStateSpec.$, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('appSize', 96, 0, mojo.internal.String, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('dataSize', 104, 0, mojo.internal.String, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('publisherId', 112, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('formattedOrigin', 120, 0, mojo.internal.String, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('scopeExtensions', 128, 0, mojo.internal.Array(mojo.internal.String, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('supportedLocales', 136, 0, mojo.internal.Array(LocaleSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('selectedLocale', 144, 0, LocaleSpec.$, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('showSystemNotificationsSettingsLink', 13, 2, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('allowUninstall', 13, 3, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('disableUserChoiceNavigationCapturing', 13, 4, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 160],]);
mojo.internal.Struct(ExtensionAppPermissionMessageSpec.$, 'ExtensionAppPermissionMessage', [
    mojo.internal.StructField('message', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('submessages', 8, 0, mojo.internal.Array(mojo.internal.String, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(FileHandlingStateSpec.$, 'FileHandlingState', [
    mojo.internal.StructField('enabled', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('isManaged', 0, 1, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('userVisibleTypes', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('userVisibleTypesLabel', 16, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('learnMoreUrl', 24, 0, url_mojom_UrlSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 40],]);
mojo.internal.Struct(PageHandlerFactory_CreatePageHandler_ParamsSpec.$, 'PageHandlerFactory_CreatePageHandler_Params', [
    mojo.internal.StructField('page', 0, 0, mojo.internal.InterfaceProxy(PageRemote), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('handler', 8, 0, mojo.internal.InterfaceRequest(PageHandlerPendingReceiver), null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(PageHandler_GetApps_ParamsSpec.$, 'PageHandler_GetApps_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_GetApps_ResponseParamsSpec.$, 'PageHandler_GetApps_ResponseParams', [
    mojo.internal.StructField('apps', 0, 0, mojo.internal.Array(AppSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_GetApp_ParamsSpec.$, 'PageHandler_GetApp_Params', [
    mojo.internal.StructField('appId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_GetApp_ResponseParamsSpec.$, 'PageHandler_GetApp_ResponseParams', [
    mojo.internal.StructField('app', 0, 0, AppSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_GetSubAppToParentMap_ParamsSpec.$, 'PageHandler_GetSubAppToParentMap_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_GetSubAppToParentMap_ResponseParamsSpec.$, 'PageHandler_GetSubAppToParentMap_ResponseParams', [
    mojo.internal.StructField('subAppToParentMap', 0, 0, mojo.internal.Map(mojo.internal.String, mojo.internal.String, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_GetExtensionAppPermissionMessages_ParamsSpec.$, 'PageHandler_GetExtensionAppPermissionMessages_Params', [
    mojo.internal.StructField('appId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_GetExtensionAppPermissionMessages_ResponseParamsSpec.$, 'PageHandler_GetExtensionAppPermissionMessages_ResponseParams', [
    mojo.internal.StructField('messages', 0, 0, mojo.internal.Array(ExtensionAppPermissionMessageSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_SetPinned_ParamsSpec.$, 'PageHandler_SetPinned_Params', [
    mojo.internal.StructField('appId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('pinned', 8, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(PageHandler_SetPermission_ParamsSpec.$, 'PageHandler_SetPermission_Params', [
    mojo.internal.StructField('appId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('permission', 8, 0, PermissionSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(PageHandler_SetResizeLocked_ParamsSpec.$, 'PageHandler_SetResizeLocked_Params', [
    mojo.internal.StructField('appId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('locked', 8, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(PageHandler_Uninstall_ParamsSpec.$, 'PageHandler_Uninstall_Params', [
    mojo.internal.StructField('appId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_OpenNativeSettings_ParamsSpec.$, 'PageHandler_OpenNativeSettings_Params', [
    mojo.internal.StructField('appId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_SetPreferredApp_ParamsSpec.$, 'PageHandler_SetPreferredApp_Params', [
    mojo.internal.StructField('appId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('isPreferredApp', 8, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(PageHandler_GetOverlappingPreferredApps_ParamsSpec.$, 'PageHandler_GetOverlappingPreferredApps_Params', [
    mojo.internal.StructField('appId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_GetOverlappingPreferredApps_ResponseParamsSpec.$, 'PageHandler_GetOverlappingPreferredApps_ResponseParams', [
    mojo.internal.StructField('appIds', 0, 0, mojo.internal.Array(mojo.internal.String, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_UpdateAppSize_ParamsSpec.$, 'PageHandler_UpdateAppSize_Params', [
    mojo.internal.StructField('appId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_SetWindowMode_ParamsSpec.$, 'PageHandler_SetWindowMode_Params', [
    mojo.internal.StructField('appId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('windowMode', 8, 0, WindowModeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(PageHandler_SetRunOnOsLoginMode_ParamsSpec.$, 'PageHandler_SetRunOnOsLoginMode_Params', [
    mojo.internal.StructField('appId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('runOnOsLoginMode', 8, 0, RunOnOsLoginModeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(PageHandler_SetFileHandlingEnabled_ParamsSpec.$, 'PageHandler_SetFileHandlingEnabled_Params', [
    mojo.internal.StructField('appId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('enabled', 8, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(PageHandler_ShowDefaultAppAssociationsUi_ParamsSpec.$, 'PageHandler_ShowDefaultAppAssociationsUi_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_OpenStorePage_ParamsSpec.$, 'PageHandler_OpenStorePage_Params', [
    mojo.internal.StructField('appId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_SetAppLocale_ParamsSpec.$, 'PageHandler_SetAppLocale_Params', [
    mojo.internal.StructField('appId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('localeTag', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(Page_OnAppAdded_ParamsSpec.$, 'Page_OnAppAdded_Params', [
    mojo.internal.StructField('app', 0, 0, AppSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Page_OnAppChanged_ParamsSpec.$, 'Page_OnAppChanged_Params', [
    mojo.internal.StructField('update', 0, 0, AppSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Page_OnAppRemoved_ParamsSpec.$, 'Page_OnAppRemoved_Params', [
    mojo.internal.StructField('appId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Union(PermissionValueSpec.$, 'PermissionValue', {
    'boolValue': {
        'ordinal': 0,
        'type': mojo.internal.Bool,
    },
    'tristateValue': {
        'ordinal': 1,
        'type': TriStateSpec.$,
    },
});
export var PermissionValueFieldTags;
(function (PermissionValueFieldTags) {
    PermissionValueFieldTags[PermissionValueFieldTags["BOOL_VALUE"] = 0] = "BOOL_VALUE";
    PermissionValueFieldTags[PermissionValueFieldTags["TRISTATE_VALUE"] = 1] = "TRISTATE_VALUE";
})(PermissionValueFieldTags || (PermissionValueFieldTags = {}));
export function whichPermissionValue(u) {
    if (u.boolValue !== null && u.boolValue !== undefined) {
        return PermissionValueFieldTags.BOOL_VALUE;
    }
    if (u.tristateValue !== null && u.tristateValue !== undefined) {
        return PermissionValueFieldTags.TRISTATE_VALUE;
    }
    throw new Error("no union field has been set, this is an illegal state");
}
