// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import '//resources/cr_elements/cr_button/cr_button.js';
import { I18nMixinLit } from '//resources/cr_elements/i18n_mixin_lit.js';
import { loadTimeData } from '//resources/js/load_time_data.js';
import { CrLitElement } from '//resources/lit/v3_0/lit.rollup.js';
import { getCss } from './searchbox_compose_button.css.js';
import { getHtml } from './searchbox_compose_button.html.js';
const SearchboxComposeButtonElementBase = I18nMixinLit(CrLitElement);
export class SearchboxComposeButtonElement extends SearchboxComposeButtonElementBase {
    static get is() {
        return 'cr-searchbox-compose-button';
    }
    static get styles() {
        return getCss();
    }
    render() {
        return getHtml.bind(this)();
    }
    static get properties() {
        return {
            composeIcon_: {
                type: String,
                reflect: true,
            },
            showAnimation_: {
                type: Boolean,
                reflect: true,
            },
        };
    }
    #composeIcon__accessor_storage = '//resources/cr_components/searchbox/icons/search_spark.svg';
    get composeIcon_() { return this.#composeIcon__accessor_storage; }
    set composeIcon_(value) { this.#composeIcon__accessor_storage = value; }
    #showAnimation__accessor_storage = loadTimeData.getBoolean('searchboxShowComposeAnimation');
    get showAnimation_() { return this.#showAnimation__accessor_storage; }
    set showAnimation_(value) { this.#showAnimation__accessor_storage = value; }
    firstUpdated() {
        if (this.$.glowAnimationWrapper) {
            if (!this.showAnimation_) {
                this.$.glowAnimationWrapper.classList.remove('play');
            }
            else {
                this.$.glowAnimationWrapper.addEventListener('animationend', () => {
                    this.$.glowAnimationWrapper.classList.remove('play');
                });
            }
        }
    }
    onClick_(e) {
        e.preventDefault();
        this.fire('compose-click', {
            button: e.button,
            ctrlKey: e.ctrlKey,
            metaKey: e.metaKey,
            shiftKey: e.shiftKey,
        });
    }
}
customElements.define(SearchboxComposeButtonElement.is, SearchboxComposeButtonElement);
