/**
 * @license
 * Copyright 2023 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
import { css, html, LitElement } from '//resources/mwc/lit/index.js';
/**
 * A ChromeOS compliant tag.
 */
export class Tag extends LitElement {
    static { this.HEIGHT = 32; }
    static { this.PADDING = 12; }
    static { this.RADIUS = 8; }
    // Required '@nocollapse' defends properties from being removed by Closure.
    /** @nocollapse */
    static { this.properties = {
        // Component attribute, kept in sync, and known as 'on-base' in the DOM.
        onBase: { type: Boolean, reflect: true, attribute: 'on-base' },
    }; }
    /** @nocollapse */
    static { this.styles = css `
    :host {
      align-items: center;
      // Background customized by component CSS '--cros-tag-surface-color'
      background: var(--cros-tag-surface-color, var(--cros-sys-app_base));
      border-radius: ${Tag.RADIUS}px;
      color: var(--cros-sys-on_surface);
      display: flex;
      font: var(--cros-button-2-font);
      height: ${Tag.HEIGHT}px;
      justify-items: center;
      margin: 0;
      padding: 0 ${Tag.PADDING}px;
    }
    :host([on-base]) {
      background: var(--cros-tag-surface-color, var(--cros-sys-hover_on_subtle));
    }
    `; }
    constructor() {
        super();
        this.onBase = false;
    }
    render() {
        return html `
      <div><slot></slot></div>
    `;
    }
}
// Required because Lit @customElement decorators are not approved for use.
customElements.define('cros-tag', Tag);
