/**
 * @license
 * Copyright 2023 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
/** Check if an `Element` is a sidenav or not. */
export function isSidenav(element) {
    return element instanceof Element && element.tagName === 'CROS-SIDENAV';
}
/** Check if an `Element` is a sidenav item or not. */
export function isSidenavItem(element) {
    return element instanceof Element && element.tagName === 'CROS-SIDENAV-ITEM';
}
/** Returns the active element, if it's a SidenavItem, or null. */
export function shadowPiercingActiveItem() {
    let activeElement = document.activeElement;
    while (activeElement && !isSidenavItem(activeElement)) {
        activeElement = activeElement.shadowRoot ?
            activeElement.shadowRoot.activeElement :
            null;
    }
    return activeElement;
}
