// chromeos/ash/services/bluetooth_config/public/mojom/cros_bluetooth_config.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
import { String16Spec as mojoBase_mojom_String16Spec } from '../../../../../../mojo/public/mojom/base/string16.mojom-webui.js';
import { UrlSpec as url_mojom_UrlSpec } from '../../../../../../url/mojom/url.mojom-webui.js';
export const DEVICE_NICKNAME_CHARACTER_LIMIT = 32;
export const BluetoothSystemStateSpec = { $: mojo.internal.Enum() };
export var BluetoothSystemState;
(function (BluetoothSystemState) {
    BluetoothSystemState[BluetoothSystemState["MIN_VALUE"] = 0] = "MIN_VALUE";
    BluetoothSystemState[BluetoothSystemState["MAX_VALUE"] = 4] = "MAX_VALUE";
    BluetoothSystemState[BluetoothSystemState["kUnavailable"] = 0] = "kUnavailable";
    BluetoothSystemState[BluetoothSystemState["kDisabled"] = 1] = "kDisabled";
    BluetoothSystemState[BluetoothSystemState["kDisabling"] = 2] = "kDisabling";
    BluetoothSystemState[BluetoothSystemState["kEnabled"] = 3] = "kEnabled";
    BluetoothSystemState[BluetoothSystemState["kEnabling"] = 4] = "kEnabling";
})(BluetoothSystemState || (BluetoothSystemState = {}));
export const BluetoothModificationStateSpec = { $: mojo.internal.Enum() };
export var BluetoothModificationState;
(function (BluetoothModificationState) {
    BluetoothModificationState[BluetoothModificationState["MIN_VALUE"] = 0] = "MIN_VALUE";
    BluetoothModificationState[BluetoothModificationState["MAX_VALUE"] = 1] = "MAX_VALUE";
    BluetoothModificationState[BluetoothModificationState["kCannotModifyBluetooth"] = 0] = "kCannotModifyBluetooth";
    BluetoothModificationState[BluetoothModificationState["kCanModifyBluetooth"] = 1] = "kCanModifyBluetooth";
})(BluetoothModificationState || (BluetoothModificationState = {}));
export const DeviceTypeSpec = { $: mojo.internal.Enum() };
export var DeviceType;
(function (DeviceType) {
    DeviceType[DeviceType["MIN_VALUE"] = 0] = "MIN_VALUE";
    DeviceType[DeviceType["MAX_VALUE"] = 9] = "MAX_VALUE";
    DeviceType[DeviceType["kUnknown"] = 0] = "kUnknown";
    DeviceType[DeviceType["kComputer"] = 1] = "kComputer";
    DeviceType[DeviceType["kPhone"] = 2] = "kPhone";
    DeviceType[DeviceType["kHeadset"] = 3] = "kHeadset";
    DeviceType[DeviceType["kVideoCamera"] = 4] = "kVideoCamera";
    DeviceType[DeviceType["kGameController"] = 5] = "kGameController";
    DeviceType[DeviceType["kKeyboard"] = 6] = "kKeyboard";
    DeviceType[DeviceType["kKeyboardMouseCombo"] = 7] = "kKeyboardMouseCombo";
    DeviceType[DeviceType["kMouse"] = 8] = "kMouse";
    DeviceType[DeviceType["kTablet"] = 9] = "kTablet";
})(DeviceType || (DeviceType = {}));
export const AudioOutputCapabilitySpec = { $: mojo.internal.Enum() };
export var AudioOutputCapability;
(function (AudioOutputCapability) {
    AudioOutputCapability[AudioOutputCapability["MIN_VALUE"] = 0] = "MIN_VALUE";
    AudioOutputCapability[AudioOutputCapability["MAX_VALUE"] = 1] = "MAX_VALUE";
    AudioOutputCapability[AudioOutputCapability["kNotCapableOfAudioOutput"] = 0] = "kNotCapableOfAudioOutput";
    AudioOutputCapability[AudioOutputCapability["kCapableOfAudioOutput"] = 1] = "kCapableOfAudioOutput";
})(AudioOutputCapability || (AudioOutputCapability = {}));
export const DeviceConnectionStateSpec = { $: mojo.internal.Enum() };
export var DeviceConnectionState;
(function (DeviceConnectionState) {
    DeviceConnectionState[DeviceConnectionState["MIN_VALUE"] = 0] = "MIN_VALUE";
    DeviceConnectionState[DeviceConnectionState["MAX_VALUE"] = 2] = "MAX_VALUE";
    DeviceConnectionState[DeviceConnectionState["kNotConnected"] = 0] = "kNotConnected";
    DeviceConnectionState[DeviceConnectionState["kConnecting"] = 1] = "kConnecting";
    DeviceConnectionState[DeviceConnectionState["kConnected"] = 2] = "kConnected";
})(DeviceConnectionState || (DeviceConnectionState = {}));
export const PairingResultSpec = { $: mojo.internal.Enum() };
export var PairingResult;
(function (PairingResult) {
    PairingResult[PairingResult["MIN_VALUE"] = 0] = "MIN_VALUE";
    PairingResult[PairingResult["MAX_VALUE"] = 2] = "MAX_VALUE";
    PairingResult[PairingResult["kSuccess"] = 0] = "kSuccess";
    PairingResult[PairingResult["kAuthFailed"] = 1] = "kAuthFailed";
    PairingResult[PairingResult["kNonAuthFailure"] = 2] = "kNonAuthFailure";
})(PairingResult || (PairingResult = {}));
export class SystemPropertiesObserverPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.bluetooth_config.mojom.SystemPropertiesObserver', scope);
    }
}
export class SystemPropertiesObserverRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(SystemPropertiesObserverPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onPropertiesUpdated(properties) {
        this.proxy.sendMessage(0, SystemPropertiesObserver_OnPropertiesUpdated_ParamsSpec.$, null, [
            properties
        ], false);
    }
}
;
/**
 * An object which receives request messages for the SystemPropertiesObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class SystemPropertiesObserverReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(SystemPropertiesObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, SystemPropertiesObserver_OnPropertiesUpdated_ParamsSpec.$, null, impl.onPropertiesUpdated.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class SystemPropertiesObserver {
    static get $interfaceName() {
        return "ash.bluetooth_config.mojom.SystemPropertiesObserver";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new SystemPropertiesObserverRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the SystemPropertiesObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class SystemPropertiesObserverCallbackRouter {
    helper_internal_;
    $;
    router_;
    onPropertiesUpdated;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(SystemPropertiesObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.onPropertiesUpdated =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, SystemPropertiesObserver_OnPropertiesUpdated_ParamsSpec.$, null, this.onPropertiesUpdated.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class BluetoothDeviceStatusObserverPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.bluetooth_config.mojom.BluetoothDeviceStatusObserver', scope);
    }
}
export class BluetoothDeviceStatusObserverRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(BluetoothDeviceStatusObserverPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onDevicePaired(device) {
        this.proxy.sendMessage(0, BluetoothDeviceStatusObserver_OnDevicePaired_ParamsSpec.$, null, [
            device
        ], false);
    }
    onDeviceConnected(device) {
        this.proxy.sendMessage(1, BluetoothDeviceStatusObserver_OnDeviceConnected_ParamsSpec.$, null, [
            device
        ], false);
    }
    onDeviceDisconnected(device) {
        this.proxy.sendMessage(2, BluetoothDeviceStatusObserver_OnDeviceDisconnected_ParamsSpec.$, null, [
            device
        ], false);
    }
}
;
/**
 * An object which receives request messages for the BluetoothDeviceStatusObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class BluetoothDeviceStatusObserverReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(BluetoothDeviceStatusObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, BluetoothDeviceStatusObserver_OnDevicePaired_ParamsSpec.$, null, impl.onDevicePaired.bind(impl), false);
        this.helper_internal_.registerHandler(1, BluetoothDeviceStatusObserver_OnDeviceConnected_ParamsSpec.$, null, impl.onDeviceConnected.bind(impl), false);
        this.helper_internal_.registerHandler(2, BluetoothDeviceStatusObserver_OnDeviceDisconnected_ParamsSpec.$, null, impl.onDeviceDisconnected.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class BluetoothDeviceStatusObserver {
    static get $interfaceName() {
        return "ash.bluetooth_config.mojom.BluetoothDeviceStatusObserver";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new BluetoothDeviceStatusObserverRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the BluetoothDeviceStatusObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class BluetoothDeviceStatusObserverCallbackRouter {
    helper_internal_;
    $;
    router_;
    onDevicePaired;
    onDeviceConnected;
    onDeviceDisconnected;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(BluetoothDeviceStatusObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.onDevicePaired =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, BluetoothDeviceStatusObserver_OnDevicePaired_ParamsSpec.$, null, this.onDevicePaired.createReceiverHandler(false /* expectsResponse */), false);
        this.onDeviceConnected =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, BluetoothDeviceStatusObserver_OnDeviceConnected_ParamsSpec.$, null, this.onDeviceConnected.createReceiverHandler(false /* expectsResponse */), false);
        this.onDeviceDisconnected =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, BluetoothDeviceStatusObserver_OnDeviceDisconnected_ParamsSpec.$, null, this.onDeviceDisconnected.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class DiscoverySessionStatusObserverPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.bluetooth_config.mojom.DiscoverySessionStatusObserver', scope);
    }
}
export class DiscoverySessionStatusObserverRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(DiscoverySessionStatusObserverPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onHasAtLeastOneDiscoverySessionChanged(hasAtLeastOneDiscoverySession) {
        this.proxy.sendMessage(0, DiscoverySessionStatusObserver_OnHasAtLeastOneDiscoverySessionChanged_ParamsSpec.$, null, [
            hasAtLeastOneDiscoverySession
        ], false);
    }
}
;
/**
 * An object which receives request messages for the DiscoverySessionStatusObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class DiscoverySessionStatusObserverReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(DiscoverySessionStatusObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, DiscoverySessionStatusObserver_OnHasAtLeastOneDiscoverySessionChanged_ParamsSpec.$, null, impl.onHasAtLeastOneDiscoverySessionChanged.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class DiscoverySessionStatusObserver {
    static get $interfaceName() {
        return "ash.bluetooth_config.mojom.DiscoverySessionStatusObserver";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new DiscoverySessionStatusObserverRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the DiscoverySessionStatusObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class DiscoverySessionStatusObserverCallbackRouter {
    helper_internal_;
    $;
    router_;
    onHasAtLeastOneDiscoverySessionChanged;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(DiscoverySessionStatusObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.onHasAtLeastOneDiscoverySessionChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, DiscoverySessionStatusObserver_OnHasAtLeastOneDiscoverySessionChanged_ParamsSpec.$, null, this.onHasAtLeastOneDiscoverySessionChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class KeyEnteredHandlerPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.bluetooth_config.mojom.KeyEnteredHandler', scope);
    }
}
export class KeyEnteredHandlerRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(KeyEnteredHandlerPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    handleKeyEntered(numKeysEntered) {
        this.proxy.sendMessage(0, KeyEnteredHandler_HandleKeyEntered_ParamsSpec.$, null, [
            numKeysEntered
        ], false);
    }
}
;
/**
 * An object which receives request messages for the KeyEnteredHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class KeyEnteredHandlerReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(KeyEnteredHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, KeyEnteredHandler_HandleKeyEntered_ParamsSpec.$, null, impl.handleKeyEntered.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class KeyEnteredHandler {
    static get $interfaceName() {
        return "ash.bluetooth_config.mojom.KeyEnteredHandler";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new KeyEnteredHandlerRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the KeyEnteredHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class KeyEnteredHandlerCallbackRouter {
    helper_internal_;
    $;
    router_;
    handleKeyEntered;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(KeyEnteredHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.handleKeyEntered =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, KeyEnteredHandler_HandleKeyEntered_ParamsSpec.$, null, this.handleKeyEntered.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class DevicePairingDelegatePendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.bluetooth_config.mojom.DevicePairingDelegate', scope);
    }
}
export class DevicePairingDelegateRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(DevicePairingDelegatePendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    requestPinCode() {
        return this.proxy.sendMessage(0, DevicePairingDelegate_RequestPinCode_ParamsSpec.$, DevicePairingDelegate_RequestPinCode_ResponseParamsSpec.$, [], false);
    }
    requestPasskey() {
        return this.proxy.sendMessage(1, DevicePairingDelegate_RequestPasskey_ParamsSpec.$, DevicePairingDelegate_RequestPasskey_ResponseParamsSpec.$, [], false);
    }
    displayPinCode(pinCode, handler) {
        this.proxy.sendMessage(2, DevicePairingDelegate_DisplayPinCode_ParamsSpec.$, null, [
            pinCode,
            handler
        ], false);
    }
    displayPasskey(passkey, handler) {
        this.proxy.sendMessage(3, DevicePairingDelegate_DisplayPasskey_ParamsSpec.$, null, [
            passkey,
            handler
        ], false);
    }
    confirmPasskey(passkey) {
        return this.proxy.sendMessage(4, DevicePairingDelegate_ConfirmPasskey_ParamsSpec.$, DevicePairingDelegate_ConfirmPasskey_ResponseParamsSpec.$, [
            passkey
        ], false);
    }
    authorizePairing() {
        return this.proxy.sendMessage(5, DevicePairingDelegate_AuthorizePairing_ParamsSpec.$, DevicePairingDelegate_AuthorizePairing_ResponseParamsSpec.$, [], false);
    }
}
;
/**
 * An object which receives request messages for the DevicePairingDelegate
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class DevicePairingDelegateReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(DevicePairingDelegateRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, DevicePairingDelegate_RequestPinCode_ParamsSpec.$, DevicePairingDelegate_RequestPinCode_ResponseParamsSpec.$, impl.requestPinCode.bind(impl), false);
        this.helper_internal_.registerHandler(1, DevicePairingDelegate_RequestPasskey_ParamsSpec.$, DevicePairingDelegate_RequestPasskey_ResponseParamsSpec.$, impl.requestPasskey.bind(impl), false);
        this.helper_internal_.registerHandler(2, DevicePairingDelegate_DisplayPinCode_ParamsSpec.$, null, impl.displayPinCode.bind(impl), false);
        this.helper_internal_.registerHandler(3, DevicePairingDelegate_DisplayPasskey_ParamsSpec.$, null, impl.displayPasskey.bind(impl), false);
        this.helper_internal_.registerHandler(4, DevicePairingDelegate_ConfirmPasskey_ParamsSpec.$, DevicePairingDelegate_ConfirmPasskey_ResponseParamsSpec.$, impl.confirmPasskey.bind(impl), false);
        this.helper_internal_.registerHandler(5, DevicePairingDelegate_AuthorizePairing_ParamsSpec.$, DevicePairingDelegate_AuthorizePairing_ResponseParamsSpec.$, impl.authorizePairing.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class DevicePairingDelegate {
    static get $interfaceName() {
        return "ash.bluetooth_config.mojom.DevicePairingDelegate";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new DevicePairingDelegateRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the DevicePairingDelegate
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class DevicePairingDelegateCallbackRouter {
    helper_internal_;
    $;
    router_;
    requestPinCode;
    requestPasskey;
    displayPinCode;
    displayPasskey;
    confirmPasskey;
    authorizePairing;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(DevicePairingDelegateRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.requestPinCode =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, DevicePairingDelegate_RequestPinCode_ParamsSpec.$, DevicePairingDelegate_RequestPinCode_ResponseParamsSpec.$, this.requestPinCode.createReceiverHandler(true /* expectsResponse */), false);
        this.requestPasskey =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, DevicePairingDelegate_RequestPasskey_ParamsSpec.$, DevicePairingDelegate_RequestPasskey_ResponseParamsSpec.$, this.requestPasskey.createReceiverHandler(true /* expectsResponse */), false);
        this.displayPinCode =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, DevicePairingDelegate_DisplayPinCode_ParamsSpec.$, null, this.displayPinCode.createReceiverHandler(false /* expectsResponse */), false);
        this.displayPasskey =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, DevicePairingDelegate_DisplayPasskey_ParamsSpec.$, null, this.displayPasskey.createReceiverHandler(false /* expectsResponse */), false);
        this.confirmPasskey =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(4, DevicePairingDelegate_ConfirmPasskey_ParamsSpec.$, DevicePairingDelegate_ConfirmPasskey_ResponseParamsSpec.$, this.confirmPasskey.createReceiverHandler(true /* expectsResponse */), false);
        this.authorizePairing =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(5, DevicePairingDelegate_AuthorizePairing_ParamsSpec.$, DevicePairingDelegate_AuthorizePairing_ResponseParamsSpec.$, this.authorizePairing.createReceiverHandler(true /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class DevicePairingHandlerPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.bluetooth_config.mojom.DevicePairingHandler', scope);
    }
}
export class DevicePairingHandlerRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(DevicePairingHandlerPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    pairDevice(deviceId, delegate) {
        return this.proxy.sendMessage(0, DevicePairingHandler_PairDevice_ParamsSpec.$, DevicePairingHandler_PairDevice_ResponseParamsSpec.$, [
            deviceId,
            delegate
        ], false);
    }
    fetchDevice(deviceAddress) {
        return this.proxy.sendMessage(1, DevicePairingHandler_FetchDevice_ParamsSpec.$, DevicePairingHandler_FetchDevice_ResponseParamsSpec.$, [
            deviceAddress
        ], false);
    }
}
;
/**
 * An object which receives request messages for the DevicePairingHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class DevicePairingHandlerReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(DevicePairingHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, DevicePairingHandler_PairDevice_ParamsSpec.$, DevicePairingHandler_PairDevice_ResponseParamsSpec.$, impl.pairDevice.bind(impl), false);
        this.helper_internal_.registerHandler(1, DevicePairingHandler_FetchDevice_ParamsSpec.$, DevicePairingHandler_FetchDevice_ResponseParamsSpec.$, impl.fetchDevice.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class DevicePairingHandler {
    static get $interfaceName() {
        return "ash.bluetooth_config.mojom.DevicePairingHandler";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new DevicePairingHandlerRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the DevicePairingHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class DevicePairingHandlerCallbackRouter {
    helper_internal_;
    $;
    router_;
    pairDevice;
    fetchDevice;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(DevicePairingHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.pairDevice =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, DevicePairingHandler_PairDevice_ParamsSpec.$, DevicePairingHandler_PairDevice_ResponseParamsSpec.$, this.pairDevice.createReceiverHandler(true /* expectsResponse */), false);
        this.fetchDevice =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, DevicePairingHandler_FetchDevice_ParamsSpec.$, DevicePairingHandler_FetchDevice_ResponseParamsSpec.$, this.fetchDevice.createReceiverHandler(true /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class BluetoothDiscoveryDelegatePendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.bluetooth_config.mojom.BluetoothDiscoveryDelegate', scope);
    }
}
export class BluetoothDiscoveryDelegateRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(BluetoothDiscoveryDelegatePendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onBluetoothDiscoveryStarted(handler) {
        this.proxy.sendMessage(0, BluetoothDiscoveryDelegate_OnBluetoothDiscoveryStarted_ParamsSpec.$, null, [
            handler
        ], false);
    }
    onBluetoothDiscoveryStopped() {
        this.proxy.sendMessage(1, BluetoothDiscoveryDelegate_OnBluetoothDiscoveryStopped_ParamsSpec.$, null, [], false);
    }
    onDiscoveredDevicesListChanged(discoveredDevices) {
        this.proxy.sendMessage(2, BluetoothDiscoveryDelegate_OnDiscoveredDevicesListChanged_ParamsSpec.$, null, [
            discoveredDevices
        ], false);
    }
}
;
/**
 * An object which receives request messages for the BluetoothDiscoveryDelegate
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class BluetoothDiscoveryDelegateReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(BluetoothDiscoveryDelegateRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, BluetoothDiscoveryDelegate_OnBluetoothDiscoveryStarted_ParamsSpec.$, null, impl.onBluetoothDiscoveryStarted.bind(impl), false);
        this.helper_internal_.registerHandler(1, BluetoothDiscoveryDelegate_OnBluetoothDiscoveryStopped_ParamsSpec.$, null, impl.onBluetoothDiscoveryStopped.bind(impl), false);
        this.helper_internal_.registerHandler(2, BluetoothDiscoveryDelegate_OnDiscoveredDevicesListChanged_ParamsSpec.$, null, impl.onDiscoveredDevicesListChanged.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class BluetoothDiscoveryDelegate {
    static get $interfaceName() {
        return "ash.bluetooth_config.mojom.BluetoothDiscoveryDelegate";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new BluetoothDiscoveryDelegateRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the BluetoothDiscoveryDelegate
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class BluetoothDiscoveryDelegateCallbackRouter {
    helper_internal_;
    $;
    router_;
    onBluetoothDiscoveryStarted;
    onBluetoothDiscoveryStopped;
    onDiscoveredDevicesListChanged;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(BluetoothDiscoveryDelegateRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.onBluetoothDiscoveryStarted =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, BluetoothDiscoveryDelegate_OnBluetoothDiscoveryStarted_ParamsSpec.$, null, this.onBluetoothDiscoveryStarted.createReceiverHandler(false /* expectsResponse */), false);
        this.onBluetoothDiscoveryStopped =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, BluetoothDiscoveryDelegate_OnBluetoothDiscoveryStopped_ParamsSpec.$, null, this.onBluetoothDiscoveryStopped.createReceiverHandler(false /* expectsResponse */), false);
        this.onDiscoveredDevicesListChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, BluetoothDiscoveryDelegate_OnDiscoveredDevicesListChanged_ParamsSpec.$, null, this.onDiscoveredDevicesListChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class CrosBluetoothConfigPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.bluetooth_config.mojom.CrosBluetoothConfig', scope);
    }
}
export class CrosBluetoothConfigRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(CrosBluetoothConfigPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    observeSystemProperties(observer) {
        this.proxy.sendMessage(0, CrosBluetoothConfig_ObserveSystemProperties_ParamsSpec.$, null, [
            observer
        ], false);
    }
    observeDeviceStatusChanges(observer) {
        this.proxy.sendMessage(1, CrosBluetoothConfig_ObserveDeviceStatusChanges_ParamsSpec.$, null, [
            observer
        ], false);
    }
    observeDiscoverySessionStatusChanges(observer) {
        this.proxy.sendMessage(2, CrosBluetoothConfig_ObserveDiscoverySessionStatusChanges_ParamsSpec.$, null, [
            observer
        ], false);
    }
    setBluetoothEnabledState(enabled) {
        this.proxy.sendMessage(3, CrosBluetoothConfig_SetBluetoothEnabledState_ParamsSpec.$, null, [
            enabled
        ], false);
    }
    setBluetoothEnabledWithoutPersistence() {
        this.proxy.sendMessage(4, CrosBluetoothConfig_SetBluetoothEnabledWithoutPersistence_ParamsSpec.$, null, [], false);
    }
    setBluetoothHidDetectionInactive(isUsingBluetooth) {
        this.proxy.sendMessage(5, CrosBluetoothConfig_SetBluetoothHidDetectionInactive_ParamsSpec.$, null, [
            isUsingBluetooth
        ], false);
    }
    startDiscovery(delegate) {
        this.proxy.sendMessage(6, CrosBluetoothConfig_StartDiscovery_ParamsSpec.$, null, [
            delegate
        ], false);
    }
    connect(deviceId) {
        return this.proxy.sendMessage(7, CrosBluetoothConfig_Connect_ParamsSpec.$, CrosBluetoothConfig_Connect_ResponseParamsSpec.$, [
            deviceId
        ], false);
    }
    disconnect(deviceId) {
        return this.proxy.sendMessage(8, CrosBluetoothConfig_Disconnect_ParamsSpec.$, CrosBluetoothConfig_Disconnect_ResponseParamsSpec.$, [
            deviceId
        ], false);
    }
    forget(deviceId) {
        return this.proxy.sendMessage(9, CrosBluetoothConfig_Forget_ParamsSpec.$, CrosBluetoothConfig_Forget_ResponseParamsSpec.$, [
            deviceId
        ], false);
    }
    setDeviceNickname(deviceId, nickname) {
        this.proxy.sendMessage(10, CrosBluetoothConfig_SetDeviceNickname_ParamsSpec.$, null, [
            deviceId,
            nickname
        ], false);
    }
}
;
/**
 * An object which receives request messages for the CrosBluetoothConfig
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class CrosBluetoothConfigReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(CrosBluetoothConfigRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, CrosBluetoothConfig_ObserveSystemProperties_ParamsSpec.$, null, impl.observeSystemProperties.bind(impl), false);
        this.helper_internal_.registerHandler(1, CrosBluetoothConfig_ObserveDeviceStatusChanges_ParamsSpec.$, null, impl.observeDeviceStatusChanges.bind(impl), false);
        this.helper_internal_.registerHandler(2, CrosBluetoothConfig_ObserveDiscoverySessionStatusChanges_ParamsSpec.$, null, impl.observeDiscoverySessionStatusChanges.bind(impl), false);
        this.helper_internal_.registerHandler(3, CrosBluetoothConfig_SetBluetoothEnabledState_ParamsSpec.$, null, impl.setBluetoothEnabledState.bind(impl), false);
        this.helper_internal_.registerHandler(4, CrosBluetoothConfig_SetBluetoothEnabledWithoutPersistence_ParamsSpec.$, null, impl.setBluetoothEnabledWithoutPersistence.bind(impl), false);
        this.helper_internal_.registerHandler(5, CrosBluetoothConfig_SetBluetoothHidDetectionInactive_ParamsSpec.$, null, impl.setBluetoothHidDetectionInactive.bind(impl), false);
        this.helper_internal_.registerHandler(6, CrosBluetoothConfig_StartDiscovery_ParamsSpec.$, null, impl.startDiscovery.bind(impl), false);
        this.helper_internal_.registerHandler(7, CrosBluetoothConfig_Connect_ParamsSpec.$, CrosBluetoothConfig_Connect_ResponseParamsSpec.$, impl.connect.bind(impl), false);
        this.helper_internal_.registerHandler(8, CrosBluetoothConfig_Disconnect_ParamsSpec.$, CrosBluetoothConfig_Disconnect_ResponseParamsSpec.$, impl.disconnect.bind(impl), false);
        this.helper_internal_.registerHandler(9, CrosBluetoothConfig_Forget_ParamsSpec.$, CrosBluetoothConfig_Forget_ResponseParamsSpec.$, impl.forget.bind(impl), false);
        this.helper_internal_.registerHandler(10, CrosBluetoothConfig_SetDeviceNickname_ParamsSpec.$, null, impl.setDeviceNickname.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class CrosBluetoothConfig {
    static get $interfaceName() {
        return "ash.bluetooth_config.mojom.CrosBluetoothConfig";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new CrosBluetoothConfigRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the CrosBluetoothConfig
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class CrosBluetoothConfigCallbackRouter {
    helper_internal_;
    $;
    router_;
    observeSystemProperties;
    observeDeviceStatusChanges;
    observeDiscoverySessionStatusChanges;
    setBluetoothEnabledState;
    setBluetoothEnabledWithoutPersistence;
    setBluetoothHidDetectionInactive;
    startDiscovery;
    connect;
    disconnect;
    forget;
    setDeviceNickname;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(CrosBluetoothConfigRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.observeSystemProperties =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, CrosBluetoothConfig_ObserveSystemProperties_ParamsSpec.$, null, this.observeSystemProperties.createReceiverHandler(false /* expectsResponse */), false);
        this.observeDeviceStatusChanges =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, CrosBluetoothConfig_ObserveDeviceStatusChanges_ParamsSpec.$, null, this.observeDeviceStatusChanges.createReceiverHandler(false /* expectsResponse */), false);
        this.observeDiscoverySessionStatusChanges =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, CrosBluetoothConfig_ObserveDiscoverySessionStatusChanges_ParamsSpec.$, null, this.observeDiscoverySessionStatusChanges.createReceiverHandler(false /* expectsResponse */), false);
        this.setBluetoothEnabledState =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, CrosBluetoothConfig_SetBluetoothEnabledState_ParamsSpec.$, null, this.setBluetoothEnabledState.createReceiverHandler(false /* expectsResponse */), false);
        this.setBluetoothEnabledWithoutPersistence =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(4, CrosBluetoothConfig_SetBluetoothEnabledWithoutPersistence_ParamsSpec.$, null, this.setBluetoothEnabledWithoutPersistence.createReceiverHandler(false /* expectsResponse */), false);
        this.setBluetoothHidDetectionInactive =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(5, CrosBluetoothConfig_SetBluetoothHidDetectionInactive_ParamsSpec.$, null, this.setBluetoothHidDetectionInactive.createReceiverHandler(false /* expectsResponse */), false);
        this.startDiscovery =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(6, CrosBluetoothConfig_StartDiscovery_ParamsSpec.$, null, this.startDiscovery.createReceiverHandler(false /* expectsResponse */), false);
        this.connect =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(7, CrosBluetoothConfig_Connect_ParamsSpec.$, CrosBluetoothConfig_Connect_ResponseParamsSpec.$, this.connect.createReceiverHandler(true /* expectsResponse */), false);
        this.disconnect =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(8, CrosBluetoothConfig_Disconnect_ParamsSpec.$, CrosBluetoothConfig_Disconnect_ResponseParamsSpec.$, this.disconnect.createReceiverHandler(true /* expectsResponse */), false);
        this.forget =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(9, CrosBluetoothConfig_Forget_ParamsSpec.$, CrosBluetoothConfig_Forget_ResponseParamsSpec.$, this.forget.createReceiverHandler(true /* expectsResponse */), false);
        this.setDeviceNickname =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(10, CrosBluetoothConfig_SetDeviceNickname_ParamsSpec.$, null, this.setDeviceNickname.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export const BatteryPropertiesSpec = { $: {} };
export const DeviceBatteryInfoSpec = { $: {} };
export const TrueWirelessImageInfoSpec = { $: {} };
export const DeviceImageInfoSpec = { $: {} };
export const BluetoothDevicePropertiesSpec = { $: {} };
export const PairedBluetoothDevicePropertiesSpec = { $: {} };
export const BluetoothSystemPropertiesSpec = { $: {} };
export const SystemPropertiesObserver_OnPropertiesUpdated_ParamsSpec = { $: {} };
export const BluetoothDeviceStatusObserver_OnDevicePaired_ParamsSpec = { $: {} };
export const BluetoothDeviceStatusObserver_OnDeviceConnected_ParamsSpec = { $: {} };
export const BluetoothDeviceStatusObserver_OnDeviceDisconnected_ParamsSpec = { $: {} };
export const DiscoverySessionStatusObserver_OnHasAtLeastOneDiscoverySessionChanged_ParamsSpec = { $: {} };
export const KeyEnteredHandler_HandleKeyEntered_ParamsSpec = { $: {} };
export const DevicePairingDelegate_RequestPinCode_ParamsSpec = { $: {} };
export const DevicePairingDelegate_RequestPinCode_ResponseParamsSpec = { $: {} };
export const DevicePairingDelegate_RequestPasskey_ParamsSpec = { $: {} };
export const DevicePairingDelegate_RequestPasskey_ResponseParamsSpec = { $: {} };
export const DevicePairingDelegate_DisplayPinCode_ParamsSpec = { $: {} };
export const DevicePairingDelegate_DisplayPasskey_ParamsSpec = { $: {} };
export const DevicePairingDelegate_ConfirmPasskey_ParamsSpec = { $: {} };
export const DevicePairingDelegate_ConfirmPasskey_ResponseParamsSpec = { $: {} };
export const DevicePairingDelegate_AuthorizePairing_ParamsSpec = { $: {} };
export const DevicePairingDelegate_AuthorizePairing_ResponseParamsSpec = { $: {} };
export const DevicePairingHandler_PairDevice_ParamsSpec = { $: {} };
export const DevicePairingHandler_PairDevice_ResponseParamsSpec = { $: {} };
export const DevicePairingHandler_FetchDevice_ParamsSpec = { $: {} };
export const DevicePairingHandler_FetchDevice_ResponseParamsSpec = { $: {} };
export const BluetoothDiscoveryDelegate_OnBluetoothDiscoveryStarted_ParamsSpec = { $: {} };
export const BluetoothDiscoveryDelegate_OnBluetoothDiscoveryStopped_ParamsSpec = { $: {} };
export const BluetoothDiscoveryDelegate_OnDiscoveredDevicesListChanged_ParamsSpec = { $: {} };
export const CrosBluetoothConfig_ObserveSystemProperties_ParamsSpec = { $: {} };
export const CrosBluetoothConfig_ObserveDeviceStatusChanges_ParamsSpec = { $: {} };
export const CrosBluetoothConfig_ObserveDiscoverySessionStatusChanges_ParamsSpec = { $: {} };
export const CrosBluetoothConfig_SetBluetoothEnabledState_ParamsSpec = { $: {} };
export const CrosBluetoothConfig_SetBluetoothEnabledWithoutPersistence_ParamsSpec = { $: {} };
export const CrosBluetoothConfig_SetBluetoothHidDetectionInactive_ParamsSpec = { $: {} };
export const CrosBluetoothConfig_StartDiscovery_ParamsSpec = { $: {} };
export const CrosBluetoothConfig_Connect_ParamsSpec = { $: {} };
export const CrosBluetoothConfig_Connect_ResponseParamsSpec = { $: {} };
export const CrosBluetoothConfig_Disconnect_ParamsSpec = { $: {} };
export const CrosBluetoothConfig_Disconnect_ResponseParamsSpec = { $: {} };
export const CrosBluetoothConfig_Forget_ParamsSpec = { $: {} };
export const CrosBluetoothConfig_Forget_ResponseParamsSpec = { $: {} };
export const CrosBluetoothConfig_SetDeviceNickname_ParamsSpec = { $: {} };
mojo.internal.Struct(BatteryPropertiesSpec.$, 'BatteryProperties', [
    mojo.internal.StructField('batteryPercentage', 0, 0, mojo.internal.Uint8, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(DeviceBatteryInfoSpec.$, 'DeviceBatteryInfo', [
    mojo.internal.StructField('defaultProperties', 0, 0, BatteryPropertiesSpec.$, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('leftBudInfo', 8, 0, BatteryPropertiesSpec.$, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('rightBudInfo', 16, 0, BatteryPropertiesSpec.$, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('caseInfo', 24, 0, BatteryPropertiesSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 40],]);
mojo.internal.Struct(TrueWirelessImageInfoSpec.$, 'TrueWirelessImageInfo', [
    mojo.internal.StructField('leftBudImageUrl', 0, 0, url_mojom_UrlSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('rightBudImageUrl', 8, 0, url_mojom_UrlSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('caseImageUrl', 16, 0, url_mojom_UrlSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 32],]);
mojo.internal.Struct(DeviceImageInfoSpec.$, 'DeviceImageInfo', [
    mojo.internal.StructField('defaultImageUrl', 0, 0, url_mojom_UrlSpec.$, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('trueWirelessImages', 8, 0, TrueWirelessImageInfoSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(BluetoothDevicePropertiesSpec.$, 'BluetoothDeviceProperties', [
    mojo.internal.StructField('id', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('address', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('publicName', 16, 0, mojoBase_mojom_String16Spec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('deviceType', 24, 0, DeviceTypeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('audioCapability', 28, 0, AudioOutputCapabilitySpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('batteryInfo', 32, 0, DeviceBatteryInfoSpec.$, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('imageInfo', 40, 0, DeviceImageInfoSpec.$, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('connectionState', 48, 0, DeviceConnectionStateSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('isBlockedByPolicy', 52, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 64],]);
mojo.internal.Struct(PairedBluetoothDevicePropertiesSpec.$, 'PairedBluetoothDeviceProperties', [
    mojo.internal.StructField('deviceProperties', 0, 0, BluetoothDevicePropertiesSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('nickname', 8, 0, mojo.internal.String, null, true /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(BluetoothSystemPropertiesSpec.$, 'BluetoothSystemProperties', [
    mojo.internal.StructField('systemState', 0, 0, BluetoothSystemStateSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('modificationState', 4, 0, BluetoothModificationStateSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('pairedDevices', 8, 0, mojo.internal.Array(PairedBluetoothDevicePropertiesSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(SystemPropertiesObserver_OnPropertiesUpdated_ParamsSpec.$, 'SystemPropertiesObserver_OnPropertiesUpdated_Params', [
    mojo.internal.StructField('properties', 0, 0, BluetoothSystemPropertiesSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(BluetoothDeviceStatusObserver_OnDevicePaired_ParamsSpec.$, 'BluetoothDeviceStatusObserver_OnDevicePaired_Params', [
    mojo.internal.StructField('device', 0, 0, PairedBluetoothDevicePropertiesSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(BluetoothDeviceStatusObserver_OnDeviceConnected_ParamsSpec.$, 'BluetoothDeviceStatusObserver_OnDeviceConnected_Params', [
    mojo.internal.StructField('device', 0, 0, PairedBluetoothDevicePropertiesSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(BluetoothDeviceStatusObserver_OnDeviceDisconnected_ParamsSpec.$, 'BluetoothDeviceStatusObserver_OnDeviceDisconnected_Params', [
    mojo.internal.StructField('device', 0, 0, PairedBluetoothDevicePropertiesSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(DiscoverySessionStatusObserver_OnHasAtLeastOneDiscoverySessionChanged_ParamsSpec.$, 'DiscoverySessionStatusObserver_OnHasAtLeastOneDiscoverySessionChanged_Params', [
    mojo.internal.StructField('hasAtLeastOneDiscoverySession', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(KeyEnteredHandler_HandleKeyEntered_ParamsSpec.$, 'KeyEnteredHandler_HandleKeyEntered_Params', [
    mojo.internal.StructField('numKeysEntered', 0, 0, mojo.internal.Uint8, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(DevicePairingDelegate_RequestPinCode_ParamsSpec.$, 'DevicePairingDelegate_RequestPinCode_Params', [], [[0, 8],]);
mojo.internal.Struct(DevicePairingDelegate_RequestPinCode_ResponseParamsSpec.$, 'DevicePairingDelegate_RequestPinCode_ResponseParams', [
    mojo.internal.StructField('pinCode', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(DevicePairingDelegate_RequestPasskey_ParamsSpec.$, 'DevicePairingDelegate_RequestPasskey_Params', [], [[0, 8],]);
mojo.internal.Struct(DevicePairingDelegate_RequestPasskey_ResponseParamsSpec.$, 'DevicePairingDelegate_RequestPasskey_ResponseParams', [
    mojo.internal.StructField('passkey', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(DevicePairingDelegate_DisplayPinCode_ParamsSpec.$, 'DevicePairingDelegate_DisplayPinCode_Params', [
    mojo.internal.StructField('pinCode', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('handler', 8, 0, mojo.internal.InterfaceRequest(KeyEnteredHandlerPendingReceiver), null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(DevicePairingDelegate_DisplayPasskey_ParamsSpec.$, 'DevicePairingDelegate_DisplayPasskey_Params', [
    mojo.internal.StructField('passkey', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('handler', 8, 0, mojo.internal.InterfaceRequest(KeyEnteredHandlerPendingReceiver), null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(DevicePairingDelegate_ConfirmPasskey_ParamsSpec.$, 'DevicePairingDelegate_ConfirmPasskey_Params', [
    mojo.internal.StructField('passkey', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(DevicePairingDelegate_ConfirmPasskey_ResponseParamsSpec.$, 'DevicePairingDelegate_ConfirmPasskey_ResponseParams', [
    mojo.internal.StructField('confirmed', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(DevicePairingDelegate_AuthorizePairing_ParamsSpec.$, 'DevicePairingDelegate_AuthorizePairing_Params', [], [[0, 8],]);
mojo.internal.Struct(DevicePairingDelegate_AuthorizePairing_ResponseParamsSpec.$, 'DevicePairingDelegate_AuthorizePairing_ResponseParams', [
    mojo.internal.StructField('confirmed', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(DevicePairingHandler_PairDevice_ParamsSpec.$, 'DevicePairingHandler_PairDevice_Params', [
    mojo.internal.StructField('deviceId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('delegate', 8, 0, mojo.internal.InterfaceProxy(DevicePairingDelegateRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(DevicePairingHandler_PairDevice_ResponseParamsSpec.$, 'DevicePairingHandler_PairDevice_ResponseParams', [
    mojo.internal.StructField('result', 0, 0, PairingResultSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(DevicePairingHandler_FetchDevice_ParamsSpec.$, 'DevicePairingHandler_FetchDevice_Params', [
    mojo.internal.StructField('deviceAddress', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(DevicePairingHandler_FetchDevice_ResponseParamsSpec.$, 'DevicePairingHandler_FetchDevice_ResponseParams', [
    mojo.internal.StructField('device', 0, 0, BluetoothDevicePropertiesSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(BluetoothDiscoveryDelegate_OnBluetoothDiscoveryStarted_ParamsSpec.$, 'BluetoothDiscoveryDelegate_OnBluetoothDiscoveryStarted_Params', [
    mojo.internal.StructField('handler', 0, 0, mojo.internal.InterfaceProxy(DevicePairingHandlerRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(BluetoothDiscoveryDelegate_OnBluetoothDiscoveryStopped_ParamsSpec.$, 'BluetoothDiscoveryDelegate_OnBluetoothDiscoveryStopped_Params', [], [[0, 8],]);
mojo.internal.Struct(BluetoothDiscoveryDelegate_OnDiscoveredDevicesListChanged_ParamsSpec.$, 'BluetoothDiscoveryDelegate_OnDiscoveredDevicesListChanged_Params', [
    mojo.internal.StructField('discoveredDevices', 0, 0, mojo.internal.Array(BluetoothDevicePropertiesSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CrosBluetoothConfig_ObserveSystemProperties_ParamsSpec.$, 'CrosBluetoothConfig_ObserveSystemProperties_Params', [
    mojo.internal.StructField('observer', 0, 0, mojo.internal.InterfaceProxy(SystemPropertiesObserverRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CrosBluetoothConfig_ObserveDeviceStatusChanges_ParamsSpec.$, 'CrosBluetoothConfig_ObserveDeviceStatusChanges_Params', [
    mojo.internal.StructField('observer', 0, 0, mojo.internal.InterfaceProxy(BluetoothDeviceStatusObserverRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CrosBluetoothConfig_ObserveDiscoverySessionStatusChanges_ParamsSpec.$, 'CrosBluetoothConfig_ObserveDiscoverySessionStatusChanges_Params', [
    mojo.internal.StructField('observer', 0, 0, mojo.internal.InterfaceProxy(DiscoverySessionStatusObserverRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CrosBluetoothConfig_SetBluetoothEnabledState_ParamsSpec.$, 'CrosBluetoothConfig_SetBluetoothEnabledState_Params', [
    mojo.internal.StructField('enabled', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CrosBluetoothConfig_SetBluetoothEnabledWithoutPersistence_ParamsSpec.$, 'CrosBluetoothConfig_SetBluetoothEnabledWithoutPersistence_Params', [], [[0, 8],]);
mojo.internal.Struct(CrosBluetoothConfig_SetBluetoothHidDetectionInactive_ParamsSpec.$, 'CrosBluetoothConfig_SetBluetoothHidDetectionInactive_Params', [
    mojo.internal.StructField('isUsingBluetooth', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CrosBluetoothConfig_StartDiscovery_ParamsSpec.$, 'CrosBluetoothConfig_StartDiscovery_Params', [
    mojo.internal.StructField('delegate', 0, 0, mojo.internal.InterfaceProxy(BluetoothDiscoveryDelegateRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CrosBluetoothConfig_Connect_ParamsSpec.$, 'CrosBluetoothConfig_Connect_Params', [
    mojo.internal.StructField('deviceId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CrosBluetoothConfig_Connect_ResponseParamsSpec.$, 'CrosBluetoothConfig_Connect_ResponseParams', [
    mojo.internal.StructField('success', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CrosBluetoothConfig_Disconnect_ParamsSpec.$, 'CrosBluetoothConfig_Disconnect_Params', [
    mojo.internal.StructField('deviceId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CrosBluetoothConfig_Disconnect_ResponseParamsSpec.$, 'CrosBluetoothConfig_Disconnect_ResponseParams', [
    mojo.internal.StructField('success', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CrosBluetoothConfig_Forget_ParamsSpec.$, 'CrosBluetoothConfig_Forget_Params', [
    mojo.internal.StructField('deviceId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CrosBluetoothConfig_Forget_ResponseParamsSpec.$, 'CrosBluetoothConfig_Forget_ResponseParams', [
    mojo.internal.StructField('success', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CrosBluetoothConfig_SetDeviceNickname_ParamsSpec.$, 'CrosBluetoothConfig_SetDeviceNickname_Params', [
    mojo.internal.StructField('deviceId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('nickname', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
