// chromeos/ash/services/connectivity/public/mojom/passpoint.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
export class PasspointEventsListenerPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'chromeos.connectivity.mojom.PasspointEventsListener', scope);
    }
}
export class PasspointEventsListenerRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PasspointEventsListenerPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onPasspointSubscriptionAdded(subscription) {
        this.proxy.sendMessage(0, PasspointEventsListener_OnPasspointSubscriptionAdded_ParamsSpec.$, null, [
            subscription
        ], false);
    }
    onPasspointSubscriptionRemoved(subscription) {
        this.proxy.sendMessage(1, PasspointEventsListener_OnPasspointSubscriptionRemoved_ParamsSpec.$, null, [
            subscription
        ], false);
    }
}
;
/**
 * An object which receives request messages for the PasspointEventsListener
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PasspointEventsListenerReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PasspointEventsListenerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, PasspointEventsListener_OnPasspointSubscriptionAdded_ParamsSpec.$, null, impl.onPasspointSubscriptionAdded.bind(impl), false);
        this.helper_internal_.registerHandler(1, PasspointEventsListener_OnPasspointSubscriptionRemoved_ParamsSpec.$, null, impl.onPasspointSubscriptionRemoved.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class PasspointEventsListener {
    static get $interfaceName() {
        return "chromeos.connectivity.mojom.PasspointEventsListener";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new PasspointEventsListenerRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the PasspointEventsListener
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PasspointEventsListenerCallbackRouter {
    helper_internal_;
    $;
    router_;
    onPasspointSubscriptionAdded;
    onPasspointSubscriptionRemoved;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PasspointEventsListenerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.onPasspointSubscriptionAdded =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, PasspointEventsListener_OnPasspointSubscriptionAdded_ParamsSpec.$, null, this.onPasspointSubscriptionAdded.createReceiverHandler(false /* expectsResponse */), false);
        this.onPasspointSubscriptionRemoved =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, PasspointEventsListener_OnPasspointSubscriptionRemoved_ParamsSpec.$, null, this.onPasspointSubscriptionRemoved.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class PasspointServicePendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'chromeos.connectivity.mojom.PasspointService', scope);
    }
}
export class PasspointServiceRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PasspointServicePendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    getPasspointSubscription(id) {
        return this.proxy.sendMessage(0, PasspointService_GetPasspointSubscription_ParamsSpec.$, PasspointService_GetPasspointSubscription_ResponseParamsSpec.$, [
            id
        ], false);
    }
    listPasspointSubscriptions() {
        return this.proxy.sendMessage(1, PasspointService_ListPasspointSubscriptions_ParamsSpec.$, PasspointService_ListPasspointSubscriptions_ResponseParamsSpec.$, [], false);
    }
    deletePasspointSubscription(id) {
        return this.proxy.sendMessage(2, PasspointService_DeletePasspointSubscription_ParamsSpec.$, PasspointService_DeletePasspointSubscription_ResponseParamsSpec.$, [
            id
        ], false);
    }
    registerPasspointListener(listener) {
        this.proxy.sendMessage(3, PasspointService_RegisterPasspointListener_ParamsSpec.$, null, [
            listener
        ], false);
    }
}
;
/**
 * An object which receives request messages for the PasspointService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PasspointServiceReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PasspointServiceRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, PasspointService_GetPasspointSubscription_ParamsSpec.$, PasspointService_GetPasspointSubscription_ResponseParamsSpec.$, impl.getPasspointSubscription.bind(impl), false);
        this.helper_internal_.registerHandler(1, PasspointService_ListPasspointSubscriptions_ParamsSpec.$, PasspointService_ListPasspointSubscriptions_ResponseParamsSpec.$, impl.listPasspointSubscriptions.bind(impl), false);
        this.helper_internal_.registerHandler(2, PasspointService_DeletePasspointSubscription_ParamsSpec.$, PasspointService_DeletePasspointSubscription_ResponseParamsSpec.$, impl.deletePasspointSubscription.bind(impl), false);
        this.helper_internal_.registerHandler(3, PasspointService_RegisterPasspointListener_ParamsSpec.$, null, impl.registerPasspointListener.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class PasspointService {
    static get $interfaceName() {
        return "chromeos.connectivity.mojom.PasspointService";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new PasspointServiceRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the PasspointService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PasspointServiceCallbackRouter {
    helper_internal_;
    $;
    router_;
    getPasspointSubscription;
    listPasspointSubscriptions;
    deletePasspointSubscription;
    registerPasspointListener;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PasspointServiceRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.getPasspointSubscription =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, PasspointService_GetPasspointSubscription_ParamsSpec.$, PasspointService_GetPasspointSubscription_ResponseParamsSpec.$, this.getPasspointSubscription.createReceiverHandler(true /* expectsResponse */), false);
        this.listPasspointSubscriptions =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, PasspointService_ListPasspointSubscriptions_ParamsSpec.$, PasspointService_ListPasspointSubscriptions_ResponseParamsSpec.$, this.listPasspointSubscriptions.createReceiverHandler(true /* expectsResponse */), false);
        this.deletePasspointSubscription =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, PasspointService_DeletePasspointSubscription_ParamsSpec.$, PasspointService_DeletePasspointSubscription_ResponseParamsSpec.$, this.deletePasspointSubscription.createReceiverHandler(true /* expectsResponse */), false);
        this.registerPasspointListener =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, PasspointService_RegisterPasspointListener_ParamsSpec.$, null, this.registerPasspointListener.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export const PasspointSubscriptionSpec = { $: {} };
export const PasspointEventsListener_OnPasspointSubscriptionAdded_ParamsSpec = { $: {} };
export const PasspointEventsListener_OnPasspointSubscriptionRemoved_ParamsSpec = { $: {} };
export const PasspointService_GetPasspointSubscription_ParamsSpec = { $: {} };
export const PasspointService_GetPasspointSubscription_ResponseParamsSpec = { $: {} };
export const PasspointService_ListPasspointSubscriptions_ParamsSpec = { $: {} };
export const PasspointService_ListPasspointSubscriptions_ResponseParamsSpec = { $: {} };
export const PasspointService_DeletePasspointSubscription_ParamsSpec = { $: {} };
export const PasspointService_DeletePasspointSubscription_ResponseParamsSpec = { $: {} };
export const PasspointService_RegisterPasspointListener_ParamsSpec = { $: {} };
mojo.internal.Struct(PasspointSubscriptionSpec.$, 'PasspointSubscription', [
    mojo.internal.StructField('id', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('domains', 8, 0, mojo.internal.Array(mojo.internal.String, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('friendlyName', 16, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('provisioningSource', 24, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('trustedCa', 32, 0, mojo.internal.String, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('expirationEpochMs', 40, 0, mojo.internal.Int64, BigInt(0), false /* nullable */, 0, undefined, undefined),
], [[0, 56],]);
mojo.internal.Struct(PasspointEventsListener_OnPasspointSubscriptionAdded_ParamsSpec.$, 'PasspointEventsListener_OnPasspointSubscriptionAdded_Params', [
    mojo.internal.StructField('subscription', 0, 0, PasspointSubscriptionSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PasspointEventsListener_OnPasspointSubscriptionRemoved_ParamsSpec.$, 'PasspointEventsListener_OnPasspointSubscriptionRemoved_Params', [
    mojo.internal.StructField('subscription', 0, 0, PasspointSubscriptionSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PasspointService_GetPasspointSubscription_ParamsSpec.$, 'PasspointService_GetPasspointSubscription_Params', [
    mojo.internal.StructField('id', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PasspointService_GetPasspointSubscription_ResponseParamsSpec.$, 'PasspointService_GetPasspointSubscription_ResponseParams', [
    mojo.internal.StructField('result', 0, 0, PasspointSubscriptionSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PasspointService_ListPasspointSubscriptions_ParamsSpec.$, 'PasspointService_ListPasspointSubscriptions_Params', [], [[0, 8],]);
mojo.internal.Struct(PasspointService_ListPasspointSubscriptions_ResponseParamsSpec.$, 'PasspointService_ListPasspointSubscriptions_ResponseParams', [
    mojo.internal.StructField('result', 0, 0, mojo.internal.Array(PasspointSubscriptionSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PasspointService_DeletePasspointSubscription_ParamsSpec.$, 'PasspointService_DeletePasspointSubscription_Params', [
    mojo.internal.StructField('id', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PasspointService_DeletePasspointSubscription_ResponseParamsSpec.$, 'PasspointService_DeletePasspointSubscription_ResponseParams', [
    mojo.internal.StructField('success', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PasspointService_RegisterPasspointListener_ParamsSpec.$, 'PasspointService_RegisterPasspointListener_Params', [
    mojo.internal.StructField('listener', 0, 0, mojo.internal.InterfaceProxy(PasspointEventsListenerRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
