// chromeos/ash/services/multidevice_setup/public/mojom/multidevice_setup.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
import { RemoteDeviceSpec as ash_multidevice_mojom_RemoteDeviceSpec } from '../../../../components/multidevice/mojom/multidevice_types.mojom-webui.js';
import { ConnectivityStatusSpec as ash_deviceSync_mojom_ConnectivityStatusSpec } from '../../../device_sync/public/mojom/device_sync.mojom-webui.js';
export const CameraRollOptInEntryPointSpec = { $: mojo.internal.Enum() };
export var CameraRollOptInEntryPoint;
(function (CameraRollOptInEntryPoint) {
    CameraRollOptInEntryPoint[CameraRollOptInEntryPoint["MIN_VALUE"] = 0] = "MIN_VALUE";
    CameraRollOptInEntryPoint[CameraRollOptInEntryPoint["MAX_VALUE"] = 2] = "MAX_VALUE";
    CameraRollOptInEntryPoint[CameraRollOptInEntryPoint["kSetupFlow"] = 0] = "kSetupFlow";
    CameraRollOptInEntryPoint[CameraRollOptInEntryPoint["kOnboardingDialog"] = 1] = "kOnboardingDialog";
    CameraRollOptInEntryPoint[CameraRollOptInEntryPoint["kSettings"] = 2] = "kSettings";
})(CameraRollOptInEntryPoint || (CameraRollOptInEntryPoint = {}));
export const EventTypeForDebuggingSpec = { $: mojo.internal.Enum() };
export var EventTypeForDebugging;
(function (EventTypeForDebugging) {
    EventTypeForDebugging[EventTypeForDebugging["MIN_VALUE"] = 0] = "MIN_VALUE";
    EventTypeForDebugging[EventTypeForDebugging["MAX_VALUE"] = 2] = "MAX_VALUE";
    EventTypeForDebugging[EventTypeForDebugging["kNewUserPotentialHostExists"] = 0] = "kNewUserPotentialHostExists";
    EventTypeForDebugging[EventTypeForDebugging["kExistingUserConnectedHostSwitched"] = 1] = "kExistingUserConnectedHostSwitched";
    EventTypeForDebugging[EventTypeForDebugging["kExistingUserNewChromebookAdded"] = 2] = "kExistingUserNewChromebookAdded";
})(EventTypeForDebugging || (EventTypeForDebugging = {}));
export const HostStatusSpec = { $: mojo.internal.Enum() };
export var HostStatus;
(function (HostStatus) {
    HostStatus[HostStatus["MIN_VALUE"] = 0] = "MIN_VALUE";
    HostStatus[HostStatus["MAX_VALUE"] = 4] = "MAX_VALUE";
    HostStatus[HostStatus["kNoEligibleHosts"] = 0] = "kNoEligibleHosts";
    HostStatus[HostStatus["kEligibleHostExistsButNoHostSet"] = 1] = "kEligibleHostExistsButNoHostSet";
    HostStatus[HostStatus["kHostSetLocallyButWaitingForBackendConfirmation"] = 2] = "kHostSetLocallyButWaitingForBackendConfirmation";
    HostStatus[HostStatus["kHostSetButNotYetVerified"] = 3] = "kHostSetButNotYetVerified";
    HostStatus[HostStatus["kHostVerified"] = 4] = "kHostVerified";
})(HostStatus || (HostStatus = {}));
export const FeatureSpec = { $: mojo.internal.Enum() };
export var Feature;
(function (Feature) {
    Feature[Feature["MIN_VALUE"] = 0] = "MIN_VALUE";
    Feature[Feature["MAX_VALUE"] = 9] = "MAX_VALUE";
    Feature[Feature["kBetterTogetherSuite"] = 0] = "kBetterTogetherSuite";
    Feature[Feature["kInstantTethering"] = 1] = "kInstantTethering";
    Feature[Feature["kMessages"] = 2] = "kMessages";
    Feature[Feature["kSmartLock"] = 3] = "kSmartLock";
    Feature[Feature["kPhoneHub"] = 4] = "kPhoneHub";
    Feature[Feature["kPhoneHubNotifications"] = 5] = "kPhoneHubNotifications";
    Feature[Feature["kPhoneHubTaskContinuation"] = 6] = "kPhoneHubTaskContinuation";
    Feature[Feature["kWifiSync"] = 7] = "kWifiSync";
    Feature[Feature["kEche"] = 8] = "kEche";
    Feature[Feature["kPhoneHubCameraRoll"] = 9] = "kPhoneHubCameraRoll";
})(Feature || (Feature = {}));
export const FeatureStateSpec = { $: mojo.internal.Enum() };
export var FeatureState;
(function (FeatureState) {
    FeatureState[FeatureState["MIN_VALUE"] = 0] = "MIN_VALUE";
    FeatureState[FeatureState["MAX_VALUE"] = 12] = "MAX_VALUE";
    FeatureState[FeatureState["kProhibitedByPolicy"] = 0] = "kProhibitedByPolicy";
    FeatureState[FeatureState["kDisabledByUser"] = 1] = "kDisabledByUser";
    FeatureState[FeatureState["kEnabledByUser"] = 2] = "kEnabledByUser";
    FeatureState[FeatureState["kNotSupportedByChromebook"] = 3] = "kNotSupportedByChromebook";
    FeatureState[FeatureState["kNotSupportedByPhone"] = 4] = "kNotSupportedByPhone";
    FeatureState[FeatureState["kUnavailableInsufficientSecurity"] = 6] = "kUnavailableInsufficientSecurity";
    FeatureState[FeatureState["kUnavailableSuiteDisabled"] = 7] = "kUnavailableSuiteDisabled";
    FeatureState[FeatureState["kUnavailableTopLevelFeatureDisabled"] = 9] = "kUnavailableTopLevelFeatureDisabled";
    FeatureState[FeatureState["kUnavailableNoVerifiedHost_ClientNotReady"] = 10] = "kUnavailableNoVerifiedHost_ClientNotReady";
    FeatureState[FeatureState["kUnavailableNoVerifiedHost_NoEligibleHosts"] = 11] = "kUnavailableNoVerifiedHost_NoEligibleHosts";
    FeatureState[FeatureState["kUnavailableNoVerifiedHost_HostExistsButNotSetAndVerified"] = 12] = "kUnavailableNoVerifiedHost_HostExistsButNotSetAndVerified";
})(FeatureState || (FeatureState = {}));
export class AccountStatusChangeDelegatePendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.multidevice_setup.mojom.AccountStatusChangeDelegate', scope);
    }
}
export class AccountStatusChangeDelegateRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(AccountStatusChangeDelegatePendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onPotentialHostExistsForNewUser() {
        this.proxy.sendMessage(0, AccountStatusChangeDelegate_OnPotentialHostExistsForNewUser_ParamsSpec.$, null, [], false);
    }
    onNoLongerNewUser() {
        this.proxy.sendMessage(1, AccountStatusChangeDelegate_OnNoLongerNewUser_ParamsSpec.$, null, [], false);
    }
    onConnectedHostSwitchedForExistingUser(newHostDeviceName) {
        this.proxy.sendMessage(2, AccountStatusChangeDelegate_OnConnectedHostSwitchedForExistingUser_ParamsSpec.$, null, [
            newHostDeviceName
        ], false);
    }
    onNewChromebookAddedForExistingUser(newHostDeviceName) {
        this.proxy.sendMessage(3, AccountStatusChangeDelegate_OnNewChromebookAddedForExistingUser_ParamsSpec.$, null, [
            newHostDeviceName
        ], false);
    }
    onBecameEligibleForWifiSync() {
        this.proxy.sendMessage(4, AccountStatusChangeDelegate_OnBecameEligibleForWifiSync_ParamsSpec.$, null, [], false);
    }
}
;
/**
 * An object which receives request messages for the AccountStatusChangeDelegate
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class AccountStatusChangeDelegateReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(AccountStatusChangeDelegateRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, AccountStatusChangeDelegate_OnPotentialHostExistsForNewUser_ParamsSpec.$, null, impl.onPotentialHostExistsForNewUser.bind(impl), false);
        this.helper_internal_.registerHandler(1, AccountStatusChangeDelegate_OnNoLongerNewUser_ParamsSpec.$, null, impl.onNoLongerNewUser.bind(impl), false);
        this.helper_internal_.registerHandler(2, AccountStatusChangeDelegate_OnConnectedHostSwitchedForExistingUser_ParamsSpec.$, null, impl.onConnectedHostSwitchedForExistingUser.bind(impl), false);
        this.helper_internal_.registerHandler(3, AccountStatusChangeDelegate_OnNewChromebookAddedForExistingUser_ParamsSpec.$, null, impl.onNewChromebookAddedForExistingUser.bind(impl), false);
        this.helper_internal_.registerHandler(4, AccountStatusChangeDelegate_OnBecameEligibleForWifiSync_ParamsSpec.$, null, impl.onBecameEligibleForWifiSync.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class AccountStatusChangeDelegate {
    static get $interfaceName() {
        return "ash.multidevice_setup.mojom.AccountStatusChangeDelegate";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new AccountStatusChangeDelegateRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the AccountStatusChangeDelegate
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class AccountStatusChangeDelegateCallbackRouter {
    helper_internal_;
    $;
    router_;
    onPotentialHostExistsForNewUser;
    onNoLongerNewUser;
    onConnectedHostSwitchedForExistingUser;
    onNewChromebookAddedForExistingUser;
    onBecameEligibleForWifiSync;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(AccountStatusChangeDelegateRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.onPotentialHostExistsForNewUser =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, AccountStatusChangeDelegate_OnPotentialHostExistsForNewUser_ParamsSpec.$, null, this.onPotentialHostExistsForNewUser.createReceiverHandler(false /* expectsResponse */), false);
        this.onNoLongerNewUser =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, AccountStatusChangeDelegate_OnNoLongerNewUser_ParamsSpec.$, null, this.onNoLongerNewUser.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectedHostSwitchedForExistingUser =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, AccountStatusChangeDelegate_OnConnectedHostSwitchedForExistingUser_ParamsSpec.$, null, this.onConnectedHostSwitchedForExistingUser.createReceiverHandler(false /* expectsResponse */), false);
        this.onNewChromebookAddedForExistingUser =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, AccountStatusChangeDelegate_OnNewChromebookAddedForExistingUser_ParamsSpec.$, null, this.onNewChromebookAddedForExistingUser.createReceiverHandler(false /* expectsResponse */), false);
        this.onBecameEligibleForWifiSync =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(4, AccountStatusChangeDelegate_OnBecameEligibleForWifiSync_ParamsSpec.$, null, this.onBecameEligibleForWifiSync.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class HostStatusObserverPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.multidevice_setup.mojom.HostStatusObserver', scope);
    }
}
export class HostStatusObserverRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(HostStatusObserverPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onHostStatusChanged(hostStatus, hostDevice) {
        this.proxy.sendMessage(0, HostStatusObserver_OnHostStatusChanged_ParamsSpec.$, null, [
            hostStatus,
            hostDevice
        ], false);
    }
}
;
/**
 * An object which receives request messages for the HostStatusObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class HostStatusObserverReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(HostStatusObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, HostStatusObserver_OnHostStatusChanged_ParamsSpec.$, null, impl.onHostStatusChanged.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class HostStatusObserver {
    static get $interfaceName() {
        return "ash.multidevice_setup.mojom.HostStatusObserver";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new HostStatusObserverRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the HostStatusObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class HostStatusObserverCallbackRouter {
    helper_internal_;
    $;
    router_;
    onHostStatusChanged;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(HostStatusObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.onHostStatusChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, HostStatusObserver_OnHostStatusChanged_ParamsSpec.$, null, this.onHostStatusChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class FeatureStateObserverPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.multidevice_setup.mojom.FeatureStateObserver', scope);
    }
}
export class FeatureStateObserverRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(FeatureStateObserverPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onFeatureStatesChanged(featureStatesMap) {
        this.proxy.sendMessage(0, FeatureStateObserver_OnFeatureStatesChanged_ParamsSpec.$, null, [
            featureStatesMap
        ], false);
    }
}
;
/**
 * An object which receives request messages for the FeatureStateObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class FeatureStateObserverReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(FeatureStateObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, FeatureStateObserver_OnFeatureStatesChanged_ParamsSpec.$, null, impl.onFeatureStatesChanged.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class FeatureStateObserver {
    static get $interfaceName() {
        return "ash.multidevice_setup.mojom.FeatureStateObserver";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new FeatureStateObserverRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the FeatureStateObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class FeatureStateObserverCallbackRouter {
    helper_internal_;
    $;
    router_;
    onFeatureStatesChanged;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(FeatureStateObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.onFeatureStatesChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, FeatureStateObserver_OnFeatureStatesChanged_ParamsSpec.$, null, this.onFeatureStatesChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class MultiDeviceSetupPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.multidevice_setup.mojom.MultiDeviceSetup', scope);
    }
}
export class MultiDeviceSetupRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(MultiDeviceSetupPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    setAccountStatusChangeDelegate(delegate) {
        this.proxy.sendMessage(0, MultiDeviceSetup_SetAccountStatusChangeDelegate_ParamsSpec.$, null, [
            delegate
        ], false);
    }
    addHostStatusObserver(observer) {
        this.proxy.sendMessage(1, MultiDeviceSetup_AddHostStatusObserver_ParamsSpec.$, null, [
            observer
        ], false);
    }
    addFeatureStateObserver(observer) {
        this.proxy.sendMessage(2, MultiDeviceSetup_AddFeatureStateObserver_ParamsSpec.$, null, [
            observer
        ], false);
    }
    getEligibleHostDevices() {
        return this.proxy.sendMessage(3, MultiDeviceSetup_GetEligibleHostDevices_ParamsSpec.$, MultiDeviceSetup_GetEligibleHostDevices_ResponseParamsSpec.$, [], false);
    }
    getEligibleActiveHostDevices() {
        return this.proxy.sendMessage(4, MultiDeviceSetup_GetEligibleActiveHostDevices_ParamsSpec.$, MultiDeviceSetup_GetEligibleActiveHostDevices_ResponseParamsSpec.$, [], false);
    }
    setHostDevice(instanceIdOrLegacyDeviceId, authToken) {
        return this.proxy.sendMessage(5, MultiDeviceSetup_SetHostDevice_ParamsSpec.$, MultiDeviceSetup_SetHostDevice_ResponseParamsSpec.$, [
            instanceIdOrLegacyDeviceId,
            authToken
        ], false);
    }
    removeHostDevice() {
        this.proxy.sendMessage(6, MultiDeviceSetup_RemoveHostDevice_ParamsSpec.$, null, [], false);
    }
    getHostStatus() {
        return this.proxy.sendMessage(7, MultiDeviceSetup_GetHostStatus_ParamsSpec.$, MultiDeviceSetup_GetHostStatus_ResponseParamsSpec.$, [], false);
    }
    setFeatureEnabledState(feature, enabled, authToken) {
        return this.proxy.sendMessage(8, MultiDeviceSetup_SetFeatureEnabledState_ParamsSpec.$, MultiDeviceSetup_SetFeatureEnabledState_ResponseParamsSpec.$, [
            feature,
            enabled,
            authToken
        ], false);
    }
    getFeatureStates() {
        return this.proxy.sendMessage(9, MultiDeviceSetup_GetFeatureStates_ParamsSpec.$, MultiDeviceSetup_GetFeatureStates_ResponseParamsSpec.$, [], false);
    }
    retrySetHostNow() {
        return this.proxy.sendMessage(10, MultiDeviceSetup_RetrySetHostNow_ParamsSpec.$, MultiDeviceSetup_RetrySetHostNow_ResponseParamsSpec.$, [], false);
    }
    triggerEventForDebugging(type) {
        return this.proxy.sendMessage(11, MultiDeviceSetup_TriggerEventForDebugging_ParamsSpec.$, MultiDeviceSetup_TriggerEventForDebugging_ResponseParamsSpec.$, [
            type
        ], false);
    }
    setQuickStartPhoneInstanceID(qsPhoneInstanceId) {
        this.proxy.sendMessage(12, MultiDeviceSetup_SetQuickStartPhoneInstanceID_ParamsSpec.$, null, [
            qsPhoneInstanceId
        ], false);
    }
    getQuickStartPhoneInstanceID() {
        return this.proxy.sendMessage(13, MultiDeviceSetup_GetQuickStartPhoneInstanceID_ParamsSpec.$, MultiDeviceSetup_GetQuickStartPhoneInstanceID_ResponseParamsSpec.$, [], false);
    }
}
;
/**
 * An object which receives request messages for the MultiDeviceSetup
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class MultiDeviceSetupReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(MultiDeviceSetupRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, MultiDeviceSetup_SetAccountStatusChangeDelegate_ParamsSpec.$, null, impl.setAccountStatusChangeDelegate.bind(impl), false);
        this.helper_internal_.registerHandler(1, MultiDeviceSetup_AddHostStatusObserver_ParamsSpec.$, null, impl.addHostStatusObserver.bind(impl), false);
        this.helper_internal_.registerHandler(2, MultiDeviceSetup_AddFeatureStateObserver_ParamsSpec.$, null, impl.addFeatureStateObserver.bind(impl), false);
        this.helper_internal_.registerHandler(3, MultiDeviceSetup_GetEligibleHostDevices_ParamsSpec.$, MultiDeviceSetup_GetEligibleHostDevices_ResponseParamsSpec.$, impl.getEligibleHostDevices.bind(impl), false);
        this.helper_internal_.registerHandler(4, MultiDeviceSetup_GetEligibleActiveHostDevices_ParamsSpec.$, MultiDeviceSetup_GetEligibleActiveHostDevices_ResponseParamsSpec.$, impl.getEligibleActiveHostDevices.bind(impl), false);
        this.helper_internal_.registerHandler(5, MultiDeviceSetup_SetHostDevice_ParamsSpec.$, MultiDeviceSetup_SetHostDevice_ResponseParamsSpec.$, impl.setHostDevice.bind(impl), false);
        this.helper_internal_.registerHandler(6, MultiDeviceSetup_RemoveHostDevice_ParamsSpec.$, null, impl.removeHostDevice.bind(impl), false);
        this.helper_internal_.registerHandler(7, MultiDeviceSetup_GetHostStatus_ParamsSpec.$, MultiDeviceSetup_GetHostStatus_ResponseParamsSpec.$, impl.getHostStatus.bind(impl), false);
        this.helper_internal_.registerHandler(8, MultiDeviceSetup_SetFeatureEnabledState_ParamsSpec.$, MultiDeviceSetup_SetFeatureEnabledState_ResponseParamsSpec.$, impl.setFeatureEnabledState.bind(impl), false);
        this.helper_internal_.registerHandler(9, MultiDeviceSetup_GetFeatureStates_ParamsSpec.$, MultiDeviceSetup_GetFeatureStates_ResponseParamsSpec.$, impl.getFeatureStates.bind(impl), false);
        this.helper_internal_.registerHandler(10, MultiDeviceSetup_RetrySetHostNow_ParamsSpec.$, MultiDeviceSetup_RetrySetHostNow_ResponseParamsSpec.$, impl.retrySetHostNow.bind(impl), false);
        this.helper_internal_.registerHandler(11, MultiDeviceSetup_TriggerEventForDebugging_ParamsSpec.$, MultiDeviceSetup_TriggerEventForDebugging_ResponseParamsSpec.$, impl.triggerEventForDebugging.bind(impl), false);
        this.helper_internal_.registerHandler(12, MultiDeviceSetup_SetQuickStartPhoneInstanceID_ParamsSpec.$, null, impl.setQuickStartPhoneInstanceID.bind(impl), false);
        this.helper_internal_.registerHandler(13, MultiDeviceSetup_GetQuickStartPhoneInstanceID_ParamsSpec.$, MultiDeviceSetup_GetQuickStartPhoneInstanceID_ResponseParamsSpec.$, impl.getQuickStartPhoneInstanceID.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class MultiDeviceSetup {
    static get $interfaceName() {
        return "ash.multidevice_setup.mojom.MultiDeviceSetup";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new MultiDeviceSetupRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the MultiDeviceSetup
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class MultiDeviceSetupCallbackRouter {
    helper_internal_;
    $;
    router_;
    setAccountStatusChangeDelegate;
    addHostStatusObserver;
    addFeatureStateObserver;
    getEligibleHostDevices;
    getEligibleActiveHostDevices;
    setHostDevice;
    removeHostDevice;
    getHostStatus;
    setFeatureEnabledState;
    getFeatureStates;
    retrySetHostNow;
    triggerEventForDebugging;
    setQuickStartPhoneInstanceID;
    getQuickStartPhoneInstanceID;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(MultiDeviceSetupRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.setAccountStatusChangeDelegate =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, MultiDeviceSetup_SetAccountStatusChangeDelegate_ParamsSpec.$, null, this.setAccountStatusChangeDelegate.createReceiverHandler(false /* expectsResponse */), false);
        this.addHostStatusObserver =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, MultiDeviceSetup_AddHostStatusObserver_ParamsSpec.$, null, this.addHostStatusObserver.createReceiverHandler(false /* expectsResponse */), false);
        this.addFeatureStateObserver =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, MultiDeviceSetup_AddFeatureStateObserver_ParamsSpec.$, null, this.addFeatureStateObserver.createReceiverHandler(false /* expectsResponse */), false);
        this.getEligibleHostDevices =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, MultiDeviceSetup_GetEligibleHostDevices_ParamsSpec.$, MultiDeviceSetup_GetEligibleHostDevices_ResponseParamsSpec.$, this.getEligibleHostDevices.createReceiverHandler(true /* expectsResponse */), false);
        this.getEligibleActiveHostDevices =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(4, MultiDeviceSetup_GetEligibleActiveHostDevices_ParamsSpec.$, MultiDeviceSetup_GetEligibleActiveHostDevices_ResponseParamsSpec.$, this.getEligibleActiveHostDevices.createReceiverHandler(true /* expectsResponse */), false);
        this.setHostDevice =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(5, MultiDeviceSetup_SetHostDevice_ParamsSpec.$, MultiDeviceSetup_SetHostDevice_ResponseParamsSpec.$, this.setHostDevice.createReceiverHandler(true /* expectsResponse */), false);
        this.removeHostDevice =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(6, MultiDeviceSetup_RemoveHostDevice_ParamsSpec.$, null, this.removeHostDevice.createReceiverHandler(false /* expectsResponse */), false);
        this.getHostStatus =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(7, MultiDeviceSetup_GetHostStatus_ParamsSpec.$, MultiDeviceSetup_GetHostStatus_ResponseParamsSpec.$, this.getHostStatus.createReceiverHandler(true /* expectsResponse */), false);
        this.setFeatureEnabledState =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(8, MultiDeviceSetup_SetFeatureEnabledState_ParamsSpec.$, MultiDeviceSetup_SetFeatureEnabledState_ResponseParamsSpec.$, this.setFeatureEnabledState.createReceiverHandler(true /* expectsResponse */), false);
        this.getFeatureStates =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(9, MultiDeviceSetup_GetFeatureStates_ParamsSpec.$, MultiDeviceSetup_GetFeatureStates_ResponseParamsSpec.$, this.getFeatureStates.createReceiverHandler(true /* expectsResponse */), false);
        this.retrySetHostNow =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(10, MultiDeviceSetup_RetrySetHostNow_ParamsSpec.$, MultiDeviceSetup_RetrySetHostNow_ResponseParamsSpec.$, this.retrySetHostNow.createReceiverHandler(true /* expectsResponse */), false);
        this.triggerEventForDebugging =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(11, MultiDeviceSetup_TriggerEventForDebugging_ParamsSpec.$, MultiDeviceSetup_TriggerEventForDebugging_ResponseParamsSpec.$, this.triggerEventForDebugging.createReceiverHandler(true /* expectsResponse */), false);
        this.setQuickStartPhoneInstanceID =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(12, MultiDeviceSetup_SetQuickStartPhoneInstanceID_ParamsSpec.$, null, this.setQuickStartPhoneInstanceID.createReceiverHandler(false /* expectsResponse */), false);
        this.getQuickStartPhoneInstanceID =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(13, MultiDeviceSetup_GetQuickStartPhoneInstanceID_ParamsSpec.$, MultiDeviceSetup_GetQuickStartPhoneInstanceID_ResponseParamsSpec.$, this.getQuickStartPhoneInstanceID.createReceiverHandler(true /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class PrivilegedHostDeviceSetterPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.multidevice_setup.mojom.PrivilegedHostDeviceSetter', scope);
    }
}
export class PrivilegedHostDeviceSetterRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PrivilegedHostDeviceSetterPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    setHostDevice(instanceIdOrLegacyDeviceId) {
        return this.proxy.sendMessage(0, PrivilegedHostDeviceSetter_SetHostDevice_ParamsSpec.$, PrivilegedHostDeviceSetter_SetHostDevice_ResponseParamsSpec.$, [
            instanceIdOrLegacyDeviceId
        ], false);
    }
}
;
/**
 * An object which receives request messages for the PrivilegedHostDeviceSetter
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PrivilegedHostDeviceSetterReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PrivilegedHostDeviceSetterRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, PrivilegedHostDeviceSetter_SetHostDevice_ParamsSpec.$, PrivilegedHostDeviceSetter_SetHostDevice_ResponseParamsSpec.$, impl.setHostDevice.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class PrivilegedHostDeviceSetter {
    static get $interfaceName() {
        return "ash.multidevice_setup.mojom.PrivilegedHostDeviceSetter";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new PrivilegedHostDeviceSetterRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the PrivilegedHostDeviceSetter
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PrivilegedHostDeviceSetterCallbackRouter {
    helper_internal_;
    $;
    router_;
    setHostDevice;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PrivilegedHostDeviceSetterRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.setHostDevice =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, PrivilegedHostDeviceSetter_SetHostDevice_ParamsSpec.$, PrivilegedHostDeviceSetter_SetHostDevice_ResponseParamsSpec.$, this.setHostDevice.createReceiverHandler(true /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export const HostDeviceSpec = { $: {} };
export const AccountStatusChangeDelegate_OnPotentialHostExistsForNewUser_ParamsSpec = { $: {} };
export const AccountStatusChangeDelegate_OnNoLongerNewUser_ParamsSpec = { $: {} };
export const AccountStatusChangeDelegate_OnConnectedHostSwitchedForExistingUser_ParamsSpec = { $: {} };
export const AccountStatusChangeDelegate_OnNewChromebookAddedForExistingUser_ParamsSpec = { $: {} };
export const AccountStatusChangeDelegate_OnBecameEligibleForWifiSync_ParamsSpec = { $: {} };
export const HostStatusObserver_OnHostStatusChanged_ParamsSpec = { $: {} };
export const FeatureStateObserver_OnFeatureStatesChanged_ParamsSpec = { $: {} };
export const MultiDeviceSetup_SetAccountStatusChangeDelegate_ParamsSpec = { $: {} };
export const MultiDeviceSetup_AddHostStatusObserver_ParamsSpec = { $: {} };
export const MultiDeviceSetup_AddFeatureStateObserver_ParamsSpec = { $: {} };
export const MultiDeviceSetup_GetEligibleHostDevices_ParamsSpec = { $: {} };
export const MultiDeviceSetup_GetEligibleHostDevices_ResponseParamsSpec = { $: {} };
export const MultiDeviceSetup_GetEligibleActiveHostDevices_ParamsSpec = { $: {} };
export const MultiDeviceSetup_GetEligibleActiveHostDevices_ResponseParamsSpec = { $: {} };
export const MultiDeviceSetup_SetHostDevice_ParamsSpec = { $: {} };
export const MultiDeviceSetup_SetHostDevice_ResponseParamsSpec = { $: {} };
export const MultiDeviceSetup_RemoveHostDevice_ParamsSpec = { $: {} };
export const MultiDeviceSetup_GetHostStatus_ParamsSpec = { $: {} };
export const MultiDeviceSetup_GetHostStatus_ResponseParamsSpec = { $: {} };
export const MultiDeviceSetup_SetFeatureEnabledState_ParamsSpec = { $: {} };
export const MultiDeviceSetup_SetFeatureEnabledState_ResponseParamsSpec = { $: {} };
export const MultiDeviceSetup_GetFeatureStates_ParamsSpec = { $: {} };
export const MultiDeviceSetup_GetFeatureStates_ResponseParamsSpec = { $: {} };
export const MultiDeviceSetup_RetrySetHostNow_ParamsSpec = { $: {} };
export const MultiDeviceSetup_RetrySetHostNow_ResponseParamsSpec = { $: {} };
export const MultiDeviceSetup_TriggerEventForDebugging_ParamsSpec = { $: {} };
export const MultiDeviceSetup_TriggerEventForDebugging_ResponseParamsSpec = { $: {} };
export const MultiDeviceSetup_SetQuickStartPhoneInstanceID_ParamsSpec = { $: {} };
export const MultiDeviceSetup_GetQuickStartPhoneInstanceID_ParamsSpec = { $: {} };
export const MultiDeviceSetup_GetQuickStartPhoneInstanceID_ResponseParamsSpec = { $: {} };
export const PrivilegedHostDeviceSetter_SetHostDevice_ParamsSpec = { $: {} };
export const PrivilegedHostDeviceSetter_SetHostDevice_ResponseParamsSpec = { $: {} };
mojo.internal.Struct(HostDeviceSpec.$, 'HostDevice', [
    mojo.internal.StructField('remoteDevice', 0, 0, ash_multidevice_mojom_RemoteDeviceSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('connectivityStatus', 8, 0, ash_deviceSync_mojom_ConnectivityStatusSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(AccountStatusChangeDelegate_OnPotentialHostExistsForNewUser_ParamsSpec.$, 'AccountStatusChangeDelegate_OnPotentialHostExistsForNewUser_Params', [], [[0, 8],]);
mojo.internal.Struct(AccountStatusChangeDelegate_OnNoLongerNewUser_ParamsSpec.$, 'AccountStatusChangeDelegate_OnNoLongerNewUser_Params', [], [[0, 8],]);
mojo.internal.Struct(AccountStatusChangeDelegate_OnConnectedHostSwitchedForExistingUser_ParamsSpec.$, 'AccountStatusChangeDelegate_OnConnectedHostSwitchedForExistingUser_Params', [
    mojo.internal.StructField('newHostDeviceName', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(AccountStatusChangeDelegate_OnNewChromebookAddedForExistingUser_ParamsSpec.$, 'AccountStatusChangeDelegate_OnNewChromebookAddedForExistingUser_Params', [
    mojo.internal.StructField('newHostDeviceName', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(AccountStatusChangeDelegate_OnBecameEligibleForWifiSync_ParamsSpec.$, 'AccountStatusChangeDelegate_OnBecameEligibleForWifiSync_Params', [], [[0, 8],]);
mojo.internal.Struct(HostStatusObserver_OnHostStatusChanged_ParamsSpec.$, 'HostStatusObserver_OnHostStatusChanged_Params', [
    mojo.internal.StructField('hostStatus', 0, 0, HostStatusSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('hostDevice', 8, 0, ash_multidevice_mojom_RemoteDeviceSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(FeatureStateObserver_OnFeatureStatesChanged_ParamsSpec.$, 'FeatureStateObserver_OnFeatureStatesChanged_Params', [
    mojo.internal.StructField('featureStatesMap', 0, 0, mojo.internal.Map(FeatureSpec.$, FeatureStateSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(MultiDeviceSetup_SetAccountStatusChangeDelegate_ParamsSpec.$, 'MultiDeviceSetup_SetAccountStatusChangeDelegate_Params', [
    mojo.internal.StructField('delegate', 0, 0, mojo.internal.InterfaceProxy(AccountStatusChangeDelegateRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(MultiDeviceSetup_AddHostStatusObserver_ParamsSpec.$, 'MultiDeviceSetup_AddHostStatusObserver_Params', [
    mojo.internal.StructField('observer', 0, 0, mojo.internal.InterfaceProxy(HostStatusObserverRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(MultiDeviceSetup_AddFeatureStateObserver_ParamsSpec.$, 'MultiDeviceSetup_AddFeatureStateObserver_Params', [
    mojo.internal.StructField('observer', 0, 0, mojo.internal.InterfaceProxy(FeatureStateObserverRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(MultiDeviceSetup_GetEligibleHostDevices_ParamsSpec.$, 'MultiDeviceSetup_GetEligibleHostDevices_Params', [], [[0, 8],]);
mojo.internal.Struct(MultiDeviceSetup_GetEligibleHostDevices_ResponseParamsSpec.$, 'MultiDeviceSetup_GetEligibleHostDevices_ResponseParams', [
    mojo.internal.StructField('eligibleHostDevices', 0, 0, mojo.internal.Array(ash_multidevice_mojom_RemoteDeviceSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(MultiDeviceSetup_GetEligibleActiveHostDevices_ParamsSpec.$, 'MultiDeviceSetup_GetEligibleActiveHostDevices_Params', [], [[0, 8],]);
mojo.internal.Struct(MultiDeviceSetup_GetEligibleActiveHostDevices_ResponseParamsSpec.$, 'MultiDeviceSetup_GetEligibleActiveHostDevices_ResponseParams', [
    mojo.internal.StructField('eligibleHostDevices', 0, 0, mojo.internal.Array(HostDeviceSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(MultiDeviceSetup_SetHostDevice_ParamsSpec.$, 'MultiDeviceSetup_SetHostDevice_Params', [
    mojo.internal.StructField('instanceIdOrLegacyDeviceId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('authToken', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(MultiDeviceSetup_SetHostDevice_ResponseParamsSpec.$, 'MultiDeviceSetup_SetHostDevice_ResponseParams', [
    mojo.internal.StructField('success', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(MultiDeviceSetup_RemoveHostDevice_ParamsSpec.$, 'MultiDeviceSetup_RemoveHostDevice_Params', [], [[0, 8],]);
mojo.internal.Struct(MultiDeviceSetup_GetHostStatus_ParamsSpec.$, 'MultiDeviceSetup_GetHostStatus_Params', [], [[0, 8],]);
mojo.internal.Struct(MultiDeviceSetup_GetHostStatus_ResponseParamsSpec.$, 'MultiDeviceSetup_GetHostStatus_ResponseParams', [
    mojo.internal.StructField('hostStatus', 0, 0, HostStatusSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('hostDevice', 8, 0, ash_multidevice_mojom_RemoteDeviceSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(MultiDeviceSetup_SetFeatureEnabledState_ParamsSpec.$, 'MultiDeviceSetup_SetFeatureEnabledState_Params', [
    mojo.internal.StructField('feature', 0, 0, FeatureSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('enabled', 4, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('authToken', 8, 0, mojo.internal.String, null, true /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(MultiDeviceSetup_SetFeatureEnabledState_ResponseParamsSpec.$, 'MultiDeviceSetup_SetFeatureEnabledState_ResponseParams', [
    mojo.internal.StructField('success', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(MultiDeviceSetup_GetFeatureStates_ParamsSpec.$, 'MultiDeviceSetup_GetFeatureStates_Params', [], [[0, 8],]);
mojo.internal.Struct(MultiDeviceSetup_GetFeatureStates_ResponseParamsSpec.$, 'MultiDeviceSetup_GetFeatureStates_ResponseParams', [
    mojo.internal.StructField('featureStatesMap', 0, 0, mojo.internal.Map(FeatureSpec.$, FeatureStateSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(MultiDeviceSetup_RetrySetHostNow_ParamsSpec.$, 'MultiDeviceSetup_RetrySetHostNow_Params', [], [[0, 8],]);
mojo.internal.Struct(MultiDeviceSetup_RetrySetHostNow_ResponseParamsSpec.$, 'MultiDeviceSetup_RetrySetHostNow_ResponseParams', [
    mojo.internal.StructField('success', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(MultiDeviceSetup_TriggerEventForDebugging_ParamsSpec.$, 'MultiDeviceSetup_TriggerEventForDebugging_Params', [
    mojo.internal.StructField('type', 0, 0, EventTypeForDebuggingSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(MultiDeviceSetup_TriggerEventForDebugging_ResponseParamsSpec.$, 'MultiDeviceSetup_TriggerEventForDebugging_ResponseParams', [
    mojo.internal.StructField('success', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(MultiDeviceSetup_SetQuickStartPhoneInstanceID_ParamsSpec.$, 'MultiDeviceSetup_SetQuickStartPhoneInstanceID_Params', [
    mojo.internal.StructField('qsPhoneInstanceId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(MultiDeviceSetup_GetQuickStartPhoneInstanceID_ParamsSpec.$, 'MultiDeviceSetup_GetQuickStartPhoneInstanceID_Params', [], [[0, 8],]);
mojo.internal.Struct(MultiDeviceSetup_GetQuickStartPhoneInstanceID_ResponseParamsSpec.$, 'MultiDeviceSetup_GetQuickStartPhoneInstanceID_ResponseParams', [
    mojo.internal.StructField('qsPhoneInstanceId', 0, 0, mojo.internal.String, null, true /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PrivilegedHostDeviceSetter_SetHostDevice_ParamsSpec.$, 'PrivilegedHostDeviceSetter_SetHostDevice_Params', [
    mojo.internal.StructField('instanceIdOrLegacyDeviceId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PrivilegedHostDeviceSetter_SetHostDevice_ResponseParamsSpec.$, 'PrivilegedHostDeviceSetter_SetHostDevice_ResponseParams', [
    mojo.internal.StructField('success', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
