// chromeos/ash/services/nearby/public/mojom/nearby_share_settings.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
import { UrlSpec as url_mojom_UrlSpec } from '../../../../../../url/mojom/url.mojom-webui.js';
export const DataUsageSpec = { $: mojo.internal.Enum() };
export var DataUsage;
(function (DataUsage) {
    DataUsage[DataUsage["MIN_VALUE"] = 0] = "MIN_VALUE";
    DataUsage[DataUsage["MAX_VALUE"] = 3] = "MAX_VALUE";
    DataUsage[DataUsage["kUnknown"] = 0] = "kUnknown";
    DataUsage[DataUsage["kOffline"] = 1] = "kOffline";
    DataUsage[DataUsage["kOnline"] = 2] = "kOnline";
    DataUsage[DataUsage["kWifiOnly"] = 3] = "kWifiOnly";
})(DataUsage || (DataUsage = {}));
export const VisibilitySpec = { $: mojo.internal.Enum() };
export var Visibility;
(function (Visibility) {
    Visibility[Visibility["MIN_VALUE"] = 0] = "MIN_VALUE";
    Visibility[Visibility["MAX_VALUE"] = 4] = "MAX_VALUE";
    Visibility[Visibility["kUnknown"] = 0] = "kUnknown";
    Visibility[Visibility["kNoOne"] = 1] = "kNoOne";
    Visibility[Visibility["kAllContacts"] = 2] = "kAllContacts";
    Visibility[Visibility["kSelectedContacts"] = 3] = "kSelectedContacts";
    Visibility[Visibility["kYourDevices"] = 4] = "kYourDevices";
})(Visibility || (Visibility = {}));
export const DeviceNameValidationResultSpec = { $: mojo.internal.Enum() };
export var DeviceNameValidationResult;
(function (DeviceNameValidationResult) {
    DeviceNameValidationResult[DeviceNameValidationResult["MIN_VALUE"] = 0] = "MIN_VALUE";
    DeviceNameValidationResult[DeviceNameValidationResult["MAX_VALUE"] = 3] = "MAX_VALUE";
    DeviceNameValidationResult[DeviceNameValidationResult["kValid"] = 0] = "kValid";
    DeviceNameValidationResult[DeviceNameValidationResult["kErrorEmpty"] = 1] = "kErrorEmpty";
    DeviceNameValidationResult[DeviceNameValidationResult["kErrorTooLong"] = 2] = "kErrorTooLong";
    DeviceNameValidationResult[DeviceNameValidationResult["kErrorNotValidUtf8"] = 3] = "kErrorNotValidUtf8";
})(DeviceNameValidationResult || (DeviceNameValidationResult = {}));
export const FastInitiationNotificationStateSpec = { $: mojo.internal.Enum() };
export var FastInitiationNotificationState;
(function (FastInitiationNotificationState) {
    FastInitiationNotificationState[FastInitiationNotificationState["MIN_VALUE"] = 0] = "MIN_VALUE";
    FastInitiationNotificationState[FastInitiationNotificationState["MAX_VALUE"] = 2] = "MAX_VALUE";
    FastInitiationNotificationState[FastInitiationNotificationState["kEnabled"] = 0] = "kEnabled";
    FastInitiationNotificationState[FastInitiationNotificationState["kDisabledByUser"] = 1] = "kDisabledByUser";
    FastInitiationNotificationState[FastInitiationNotificationState["kDisabledByFeature"] = 2] = "kDisabledByFeature";
})(FastInitiationNotificationState || (FastInitiationNotificationState = {}));
export class NearbyShareSettingsObserverPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'nearby_share.mojom.NearbyShareSettingsObserver', scope);
    }
}
export class NearbyShareSettingsObserverRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(NearbyShareSettingsObserverPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onEnabledChanged(enabled) {
        this.proxy.sendMessage(0, NearbyShareSettingsObserver_OnEnabledChanged_ParamsSpec.$, null, [
            enabled
        ], false);
    }
    onFastInitiationNotificationStateChanged(state) {
        this.proxy.sendMessage(1, NearbyShareSettingsObserver_OnFastInitiationNotificationStateChanged_ParamsSpec.$, null, [
            state
        ], false);
    }
    onIsFastInitiationHardwareSupportedChanged(isSupported) {
        this.proxy.sendMessage(2, NearbyShareSettingsObserver_OnIsFastInitiationHardwareSupportedChanged_ParamsSpec.$, null, [
            isSupported
        ], false);
    }
    onDeviceNameChanged(deviceName) {
        this.proxy.sendMessage(3, NearbyShareSettingsObserver_OnDeviceNameChanged_ParamsSpec.$, null, [
            deviceName
        ], false);
    }
    onDataUsageChanged(dataUsage) {
        this.proxy.sendMessage(4, NearbyShareSettingsObserver_OnDataUsageChanged_ParamsSpec.$, null, [
            dataUsage
        ], false);
    }
    onVisibilityChanged(visibility) {
        this.proxy.sendMessage(5, NearbyShareSettingsObserver_OnVisibilityChanged_ParamsSpec.$, null, [
            visibility
        ], false);
    }
    onAllowedContactsChanged(visibleContactIds) {
        this.proxy.sendMessage(6, NearbyShareSettingsObserver_OnAllowedContactsChanged_ParamsSpec.$, null, [
            visibleContactIds
        ], false);
    }
    onIsOnboardingCompleteChanged(isComplete) {
        this.proxy.sendMessage(7, NearbyShareSettingsObserver_OnIsOnboardingCompleteChanged_ParamsSpec.$, null, [
            isComplete
        ], false);
    }
}
;
/**
 * An object which receives request messages for the NearbyShareSettingsObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class NearbyShareSettingsObserverReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(NearbyShareSettingsObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, NearbyShareSettingsObserver_OnEnabledChanged_ParamsSpec.$, null, impl.onEnabledChanged.bind(impl), false);
        this.helper_internal_.registerHandler(1, NearbyShareSettingsObserver_OnFastInitiationNotificationStateChanged_ParamsSpec.$, null, impl.onFastInitiationNotificationStateChanged.bind(impl), false);
        this.helper_internal_.registerHandler(2, NearbyShareSettingsObserver_OnIsFastInitiationHardwareSupportedChanged_ParamsSpec.$, null, impl.onIsFastInitiationHardwareSupportedChanged.bind(impl), false);
        this.helper_internal_.registerHandler(3, NearbyShareSettingsObserver_OnDeviceNameChanged_ParamsSpec.$, null, impl.onDeviceNameChanged.bind(impl), false);
        this.helper_internal_.registerHandler(4, NearbyShareSettingsObserver_OnDataUsageChanged_ParamsSpec.$, null, impl.onDataUsageChanged.bind(impl), false);
        this.helper_internal_.registerHandler(5, NearbyShareSettingsObserver_OnVisibilityChanged_ParamsSpec.$, null, impl.onVisibilityChanged.bind(impl), false);
        this.helper_internal_.registerHandler(6, NearbyShareSettingsObserver_OnAllowedContactsChanged_ParamsSpec.$, null, impl.onAllowedContactsChanged.bind(impl), false);
        this.helper_internal_.registerHandler(7, NearbyShareSettingsObserver_OnIsOnboardingCompleteChanged_ParamsSpec.$, null, impl.onIsOnboardingCompleteChanged.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class NearbyShareSettingsObserver {
    static get $interfaceName() {
        return "nearby_share.mojom.NearbyShareSettingsObserver";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new NearbyShareSettingsObserverRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the NearbyShareSettingsObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class NearbyShareSettingsObserverCallbackRouter {
    helper_internal_;
    $;
    router_;
    onEnabledChanged;
    onFastInitiationNotificationStateChanged;
    onIsFastInitiationHardwareSupportedChanged;
    onDeviceNameChanged;
    onDataUsageChanged;
    onVisibilityChanged;
    onAllowedContactsChanged;
    onIsOnboardingCompleteChanged;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(NearbyShareSettingsObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.onEnabledChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, NearbyShareSettingsObserver_OnEnabledChanged_ParamsSpec.$, null, this.onEnabledChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.onFastInitiationNotificationStateChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, NearbyShareSettingsObserver_OnFastInitiationNotificationStateChanged_ParamsSpec.$, null, this.onFastInitiationNotificationStateChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.onIsFastInitiationHardwareSupportedChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, NearbyShareSettingsObserver_OnIsFastInitiationHardwareSupportedChanged_ParamsSpec.$, null, this.onIsFastInitiationHardwareSupportedChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.onDeviceNameChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, NearbyShareSettingsObserver_OnDeviceNameChanged_ParamsSpec.$, null, this.onDeviceNameChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.onDataUsageChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(4, NearbyShareSettingsObserver_OnDataUsageChanged_ParamsSpec.$, null, this.onDataUsageChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.onVisibilityChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(5, NearbyShareSettingsObserver_OnVisibilityChanged_ParamsSpec.$, null, this.onVisibilityChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.onAllowedContactsChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(6, NearbyShareSettingsObserver_OnAllowedContactsChanged_ParamsSpec.$, null, this.onAllowedContactsChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.onIsOnboardingCompleteChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(7, NearbyShareSettingsObserver_OnIsOnboardingCompleteChanged_ParamsSpec.$, null, this.onIsOnboardingCompleteChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class NearbyShareSettingsPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'nearby_share.mojom.NearbyShareSettings', scope);
    }
}
export class NearbyShareSettingsRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(NearbyShareSettingsPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    addSettingsObserver(observer) {
        this.proxy.sendMessage(0, NearbyShareSettings_AddSettingsObserver_ParamsSpec.$, null, [
            observer
        ], false);
    }
    getEnabled() {
        return this.proxy.sendMessage(1, NearbyShareSettings_GetEnabled_ParamsSpec.$, NearbyShareSettings_GetEnabled_ResponseParamsSpec.$, [], false);
    }
    setEnabled(enabled) {
        this.proxy.sendMessage(2, NearbyShareSettings_SetEnabled_ParamsSpec.$, null, [
            enabled
        ], false);
    }
    isOnboardingComplete() {
        return this.proxy.sendMessage(3, NearbyShareSettings_IsOnboardingComplete_ParamsSpec.$, NearbyShareSettings_IsOnboardingComplete_ResponseParamsSpec.$, [], false);
    }
    setIsOnboardingComplete(completed) {
        this.proxy.sendMessage(4, NearbyShareSettings_SetIsOnboardingComplete_ParamsSpec.$, null, [
            completed
        ], false);
    }
    getFastInitiationNotificationState() {
        return this.proxy.sendMessage(5, NearbyShareSettings_GetFastInitiationNotificationState_ParamsSpec.$, NearbyShareSettings_GetFastInitiationNotificationState_ResponseParamsSpec.$, [], false);
    }
    setFastInitiationNotificationState(state) {
        this.proxy.sendMessage(6, NearbyShareSettings_SetFastInitiationNotificationState_ParamsSpec.$, null, [
            state
        ], false);
    }
    getIsFastInitiationHardwareSupported() {
        return this.proxy.sendMessage(7, NearbyShareSettings_GetIsFastInitiationHardwareSupported_ParamsSpec.$, NearbyShareSettings_GetIsFastInitiationHardwareSupported_ResponseParamsSpec.$, [], false);
    }
    getDeviceName() {
        return this.proxy.sendMessage(8, NearbyShareSettings_GetDeviceName_ParamsSpec.$, NearbyShareSettings_GetDeviceName_ResponseParamsSpec.$, [], false);
    }
    validateDeviceName(deviceName) {
        return this.proxy.sendMessage(9, NearbyShareSettings_ValidateDeviceName_ParamsSpec.$, NearbyShareSettings_ValidateDeviceName_ResponseParamsSpec.$, [
            deviceName
        ], false);
    }
    setDeviceName(deviceName) {
        return this.proxy.sendMessage(10, NearbyShareSettings_SetDeviceName_ParamsSpec.$, NearbyShareSettings_SetDeviceName_ResponseParamsSpec.$, [
            deviceName
        ], false);
    }
    getDataUsage() {
        return this.proxy.sendMessage(11, NearbyShareSettings_GetDataUsage_ParamsSpec.$, NearbyShareSettings_GetDataUsage_ResponseParamsSpec.$, [], false);
    }
    setDataUsage(dataUsage) {
        this.proxy.sendMessage(12, NearbyShareSettings_SetDataUsage_ParamsSpec.$, null, [
            dataUsage
        ], false);
    }
    getVisibility() {
        return this.proxy.sendMessage(13, NearbyShareSettings_GetVisibility_ParamsSpec.$, NearbyShareSettings_GetVisibility_ResponseParamsSpec.$, [], false);
    }
    setVisibility(visibility) {
        this.proxy.sendMessage(14, NearbyShareSettings_SetVisibility_ParamsSpec.$, null, [
            visibility
        ], false);
    }
    getAllowedContacts() {
        return this.proxy.sendMessage(15, NearbyShareSettings_GetAllowedContacts_ParamsSpec.$, NearbyShareSettings_GetAllowedContacts_ResponseParamsSpec.$, [], false);
    }
    setAllowedContacts(allowedContacts) {
        this.proxy.sendMessage(16, NearbyShareSettings_SetAllowedContacts_ParamsSpec.$, null, [
            allowedContacts
        ], false);
    }
}
;
/**
 * An object which receives request messages for the NearbyShareSettings
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class NearbyShareSettingsReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(NearbyShareSettingsRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, NearbyShareSettings_AddSettingsObserver_ParamsSpec.$, null, impl.addSettingsObserver.bind(impl), false);
        this.helper_internal_.registerHandler(1, NearbyShareSettings_GetEnabled_ParamsSpec.$, NearbyShareSettings_GetEnabled_ResponseParamsSpec.$, impl.getEnabled.bind(impl), false);
        this.helper_internal_.registerHandler(2, NearbyShareSettings_SetEnabled_ParamsSpec.$, null, impl.setEnabled.bind(impl), false);
        this.helper_internal_.registerHandler(3, NearbyShareSettings_IsOnboardingComplete_ParamsSpec.$, NearbyShareSettings_IsOnboardingComplete_ResponseParamsSpec.$, impl.isOnboardingComplete.bind(impl), false);
        this.helper_internal_.registerHandler(4, NearbyShareSettings_SetIsOnboardingComplete_ParamsSpec.$, null, impl.setIsOnboardingComplete.bind(impl), false);
        this.helper_internal_.registerHandler(5, NearbyShareSettings_GetFastInitiationNotificationState_ParamsSpec.$, NearbyShareSettings_GetFastInitiationNotificationState_ResponseParamsSpec.$, impl.getFastInitiationNotificationState.bind(impl), false);
        this.helper_internal_.registerHandler(6, NearbyShareSettings_SetFastInitiationNotificationState_ParamsSpec.$, null, impl.setFastInitiationNotificationState.bind(impl), false);
        this.helper_internal_.registerHandler(7, NearbyShareSettings_GetIsFastInitiationHardwareSupported_ParamsSpec.$, NearbyShareSettings_GetIsFastInitiationHardwareSupported_ResponseParamsSpec.$, impl.getIsFastInitiationHardwareSupported.bind(impl), false);
        this.helper_internal_.registerHandler(8, NearbyShareSettings_GetDeviceName_ParamsSpec.$, NearbyShareSettings_GetDeviceName_ResponseParamsSpec.$, impl.getDeviceName.bind(impl), false);
        this.helper_internal_.registerHandler(9, NearbyShareSettings_ValidateDeviceName_ParamsSpec.$, NearbyShareSettings_ValidateDeviceName_ResponseParamsSpec.$, impl.validateDeviceName.bind(impl), false);
        this.helper_internal_.registerHandler(10, NearbyShareSettings_SetDeviceName_ParamsSpec.$, NearbyShareSettings_SetDeviceName_ResponseParamsSpec.$, impl.setDeviceName.bind(impl), false);
        this.helper_internal_.registerHandler(11, NearbyShareSettings_GetDataUsage_ParamsSpec.$, NearbyShareSettings_GetDataUsage_ResponseParamsSpec.$, impl.getDataUsage.bind(impl), false);
        this.helper_internal_.registerHandler(12, NearbyShareSettings_SetDataUsage_ParamsSpec.$, null, impl.setDataUsage.bind(impl), false);
        this.helper_internal_.registerHandler(13, NearbyShareSettings_GetVisibility_ParamsSpec.$, NearbyShareSettings_GetVisibility_ResponseParamsSpec.$, impl.getVisibility.bind(impl), false);
        this.helper_internal_.registerHandler(14, NearbyShareSettings_SetVisibility_ParamsSpec.$, null, impl.setVisibility.bind(impl), false);
        this.helper_internal_.registerHandler(15, NearbyShareSettings_GetAllowedContacts_ParamsSpec.$, NearbyShareSettings_GetAllowedContacts_ResponseParamsSpec.$, impl.getAllowedContacts.bind(impl), false);
        this.helper_internal_.registerHandler(16, NearbyShareSettings_SetAllowedContacts_ParamsSpec.$, null, impl.setAllowedContacts.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class NearbyShareSettings {
    static get $interfaceName() {
        return "nearby_share.mojom.NearbyShareSettings";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new NearbyShareSettingsRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the NearbyShareSettings
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class NearbyShareSettingsCallbackRouter {
    helper_internal_;
    $;
    router_;
    addSettingsObserver;
    getEnabled;
    setEnabled;
    isOnboardingComplete;
    setIsOnboardingComplete;
    getFastInitiationNotificationState;
    setFastInitiationNotificationState;
    getIsFastInitiationHardwareSupported;
    getDeviceName;
    validateDeviceName;
    setDeviceName;
    getDataUsage;
    setDataUsage;
    getVisibility;
    setVisibility;
    getAllowedContacts;
    setAllowedContacts;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(NearbyShareSettingsRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.addSettingsObserver =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, NearbyShareSettings_AddSettingsObserver_ParamsSpec.$, null, this.addSettingsObserver.createReceiverHandler(false /* expectsResponse */), false);
        this.getEnabled =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, NearbyShareSettings_GetEnabled_ParamsSpec.$, NearbyShareSettings_GetEnabled_ResponseParamsSpec.$, this.getEnabled.createReceiverHandler(true /* expectsResponse */), false);
        this.setEnabled =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, NearbyShareSettings_SetEnabled_ParamsSpec.$, null, this.setEnabled.createReceiverHandler(false /* expectsResponse */), false);
        this.isOnboardingComplete =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, NearbyShareSettings_IsOnboardingComplete_ParamsSpec.$, NearbyShareSettings_IsOnboardingComplete_ResponseParamsSpec.$, this.isOnboardingComplete.createReceiverHandler(true /* expectsResponse */), false);
        this.setIsOnboardingComplete =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(4, NearbyShareSettings_SetIsOnboardingComplete_ParamsSpec.$, null, this.setIsOnboardingComplete.createReceiverHandler(false /* expectsResponse */), false);
        this.getFastInitiationNotificationState =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(5, NearbyShareSettings_GetFastInitiationNotificationState_ParamsSpec.$, NearbyShareSettings_GetFastInitiationNotificationState_ResponseParamsSpec.$, this.getFastInitiationNotificationState.createReceiverHandler(true /* expectsResponse */), false);
        this.setFastInitiationNotificationState =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(6, NearbyShareSettings_SetFastInitiationNotificationState_ParamsSpec.$, null, this.setFastInitiationNotificationState.createReceiverHandler(false /* expectsResponse */), false);
        this.getIsFastInitiationHardwareSupported =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(7, NearbyShareSettings_GetIsFastInitiationHardwareSupported_ParamsSpec.$, NearbyShareSettings_GetIsFastInitiationHardwareSupported_ResponseParamsSpec.$, this.getIsFastInitiationHardwareSupported.createReceiverHandler(true /* expectsResponse */), false);
        this.getDeviceName =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(8, NearbyShareSettings_GetDeviceName_ParamsSpec.$, NearbyShareSettings_GetDeviceName_ResponseParamsSpec.$, this.getDeviceName.createReceiverHandler(true /* expectsResponse */), false);
        this.validateDeviceName =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(9, NearbyShareSettings_ValidateDeviceName_ParamsSpec.$, NearbyShareSettings_ValidateDeviceName_ResponseParamsSpec.$, this.validateDeviceName.createReceiverHandler(true /* expectsResponse */), false);
        this.setDeviceName =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(10, NearbyShareSettings_SetDeviceName_ParamsSpec.$, NearbyShareSettings_SetDeviceName_ResponseParamsSpec.$, this.setDeviceName.createReceiverHandler(true /* expectsResponse */), false);
        this.getDataUsage =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(11, NearbyShareSettings_GetDataUsage_ParamsSpec.$, NearbyShareSettings_GetDataUsage_ResponseParamsSpec.$, this.getDataUsage.createReceiverHandler(true /* expectsResponse */), false);
        this.setDataUsage =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(12, NearbyShareSettings_SetDataUsage_ParamsSpec.$, null, this.setDataUsage.createReceiverHandler(false /* expectsResponse */), false);
        this.getVisibility =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(13, NearbyShareSettings_GetVisibility_ParamsSpec.$, NearbyShareSettings_GetVisibility_ResponseParamsSpec.$, this.getVisibility.createReceiverHandler(true /* expectsResponse */), false);
        this.setVisibility =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(14, NearbyShareSettings_SetVisibility_ParamsSpec.$, null, this.setVisibility.createReceiverHandler(false /* expectsResponse */), false);
        this.getAllowedContacts =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(15, NearbyShareSettings_GetAllowedContacts_ParamsSpec.$, NearbyShareSettings_GetAllowedContacts_ResponseParamsSpec.$, this.getAllowedContacts.createReceiverHandler(true /* expectsResponse */), false);
        this.setAllowedContacts =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(16, NearbyShareSettings_SetAllowedContacts_ParamsSpec.$, null, this.setAllowedContacts.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class DownloadContactsObserverPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'nearby_share.mojom.DownloadContactsObserver', scope);
    }
}
export class DownloadContactsObserverRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(DownloadContactsObserverPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onContactsDownloaded(allowedContacts, contacts, numUnreachableContactsFilteredOut) {
        this.proxy.sendMessage(0, DownloadContactsObserver_OnContactsDownloaded_ParamsSpec.$, null, [
            allowedContacts,
            contacts,
            numUnreachableContactsFilteredOut
        ], false);
    }
    onContactsDownloadFailed() {
        this.proxy.sendMessage(1, DownloadContactsObserver_OnContactsDownloadFailed_ParamsSpec.$, null, [], false);
    }
}
;
/**
 * An object which receives request messages for the DownloadContactsObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class DownloadContactsObserverReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(DownloadContactsObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, DownloadContactsObserver_OnContactsDownloaded_ParamsSpec.$, null, impl.onContactsDownloaded.bind(impl), false);
        this.helper_internal_.registerHandler(1, DownloadContactsObserver_OnContactsDownloadFailed_ParamsSpec.$, null, impl.onContactsDownloadFailed.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class DownloadContactsObserver {
    static get $interfaceName() {
        return "nearby_share.mojom.DownloadContactsObserver";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new DownloadContactsObserverRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the DownloadContactsObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class DownloadContactsObserverCallbackRouter {
    helper_internal_;
    $;
    router_;
    onContactsDownloaded;
    onContactsDownloadFailed;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(DownloadContactsObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.onContactsDownloaded =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, DownloadContactsObserver_OnContactsDownloaded_ParamsSpec.$, null, this.onContactsDownloaded.createReceiverHandler(false /* expectsResponse */), false);
        this.onContactsDownloadFailed =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, DownloadContactsObserver_OnContactsDownloadFailed_ParamsSpec.$, null, this.onContactsDownloadFailed.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class ContactManagerPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'nearby_share.mojom.ContactManager', scope);
    }
}
export class ContactManagerRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(ContactManagerPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    addDownloadContactsObserver(observer) {
        this.proxy.sendMessage(0, ContactManager_AddDownloadContactsObserver_ParamsSpec.$, null, [
            observer
        ], false);
    }
    downloadContacts() {
        this.proxy.sendMessage(1, ContactManager_DownloadContacts_ParamsSpec.$, null, [], false);
    }
    setAllowedContacts(allowedContacts) {
        this.proxy.sendMessage(2, ContactManager_SetAllowedContacts_ParamsSpec.$, null, [
            allowedContacts
        ], false);
    }
}
;
/**
 * An object which receives request messages for the ContactManager
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ContactManagerReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(ContactManagerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, ContactManager_AddDownloadContactsObserver_ParamsSpec.$, null, impl.addDownloadContactsObserver.bind(impl), false);
        this.helper_internal_.registerHandler(1, ContactManager_DownloadContacts_ParamsSpec.$, null, impl.downloadContacts.bind(impl), false);
        this.helper_internal_.registerHandler(2, ContactManager_SetAllowedContacts_ParamsSpec.$, null, impl.setAllowedContacts.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class ContactManager {
    static get $interfaceName() {
        return "nearby_share.mojom.ContactManager";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new ContactManagerRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the ContactManager
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ContactManagerCallbackRouter {
    helper_internal_;
    $;
    router_;
    addDownloadContactsObserver;
    downloadContacts;
    setAllowedContacts;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(ContactManagerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.addDownloadContactsObserver =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, ContactManager_AddDownloadContactsObserver_ParamsSpec.$, null, this.addDownloadContactsObserver.createReceiverHandler(false /* expectsResponse */), false);
        this.downloadContacts =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, ContactManager_DownloadContacts_ParamsSpec.$, null, this.downloadContacts.createReceiverHandler(false /* expectsResponse */), false);
        this.setAllowedContacts =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, ContactManager_SetAllowedContacts_ParamsSpec.$, null, this.setAllowedContacts.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export const ContactRecordSpec = { $: {} };
export const NearbyShareSettingsObserver_OnEnabledChanged_ParamsSpec = { $: {} };
export const NearbyShareSettingsObserver_OnFastInitiationNotificationStateChanged_ParamsSpec = { $: {} };
export const NearbyShareSettingsObserver_OnIsFastInitiationHardwareSupportedChanged_ParamsSpec = { $: {} };
export const NearbyShareSettingsObserver_OnDeviceNameChanged_ParamsSpec = { $: {} };
export const NearbyShareSettingsObserver_OnDataUsageChanged_ParamsSpec = { $: {} };
export const NearbyShareSettingsObserver_OnVisibilityChanged_ParamsSpec = { $: {} };
export const NearbyShareSettingsObserver_OnAllowedContactsChanged_ParamsSpec = { $: {} };
export const NearbyShareSettingsObserver_OnIsOnboardingCompleteChanged_ParamsSpec = { $: {} };
export const NearbyShareSettings_AddSettingsObserver_ParamsSpec = { $: {} };
export const NearbyShareSettings_GetEnabled_ParamsSpec = { $: {} };
export const NearbyShareSettings_GetEnabled_ResponseParamsSpec = { $: {} };
export const NearbyShareSettings_SetEnabled_ParamsSpec = { $: {} };
export const NearbyShareSettings_IsOnboardingComplete_ParamsSpec = { $: {} };
export const NearbyShareSettings_IsOnboardingComplete_ResponseParamsSpec = { $: {} };
export const NearbyShareSettings_SetIsOnboardingComplete_ParamsSpec = { $: {} };
export const NearbyShareSettings_GetFastInitiationNotificationState_ParamsSpec = { $: {} };
export const NearbyShareSettings_GetFastInitiationNotificationState_ResponseParamsSpec = { $: {} };
export const NearbyShareSettings_SetFastInitiationNotificationState_ParamsSpec = { $: {} };
export const NearbyShareSettings_GetIsFastInitiationHardwareSupported_ParamsSpec = { $: {} };
export const NearbyShareSettings_GetIsFastInitiationHardwareSupported_ResponseParamsSpec = { $: {} };
export const NearbyShareSettings_GetDeviceName_ParamsSpec = { $: {} };
export const NearbyShareSettings_GetDeviceName_ResponseParamsSpec = { $: {} };
export const NearbyShareSettings_ValidateDeviceName_ParamsSpec = { $: {} };
export const NearbyShareSettings_ValidateDeviceName_ResponseParamsSpec = { $: {} };
export const NearbyShareSettings_SetDeviceName_ParamsSpec = { $: {} };
export const NearbyShareSettings_SetDeviceName_ResponseParamsSpec = { $: {} };
export const NearbyShareSettings_GetDataUsage_ParamsSpec = { $: {} };
export const NearbyShareSettings_GetDataUsage_ResponseParamsSpec = { $: {} };
export const NearbyShareSettings_SetDataUsage_ParamsSpec = { $: {} };
export const NearbyShareSettings_GetVisibility_ParamsSpec = { $: {} };
export const NearbyShareSettings_GetVisibility_ResponseParamsSpec = { $: {} };
export const NearbyShareSettings_SetVisibility_ParamsSpec = { $: {} };
export const NearbyShareSettings_GetAllowedContacts_ParamsSpec = { $: {} };
export const NearbyShareSettings_GetAllowedContacts_ResponseParamsSpec = { $: {} };
export const NearbyShareSettings_SetAllowedContacts_ParamsSpec = { $: {} };
export const DownloadContactsObserver_OnContactsDownloaded_ParamsSpec = { $: {} };
export const DownloadContactsObserver_OnContactsDownloadFailed_ParamsSpec = { $: {} };
export const ContactManager_AddDownloadContactsObserver_ParamsSpec = { $: {} };
export const ContactManager_DownloadContacts_ParamsSpec = { $: {} };
export const ContactManager_SetAllowedContacts_ParamsSpec = { $: {} };
export const ContactIdentifierSpec = { $: {} };
mojo.internal.Struct(ContactRecordSpec.$, 'ContactRecord', [
    mojo.internal.StructField('id', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('personName', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('imageUrl', 16, 0, url_mojom_UrlSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('identifiers', 24, 0, mojo.internal.Array(ContactIdentifierSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 40],]);
mojo.internal.Struct(NearbyShareSettingsObserver_OnEnabledChanged_ParamsSpec.$, 'NearbyShareSettingsObserver_OnEnabledChanged_Params', [
    mojo.internal.StructField('enabled', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(NearbyShareSettingsObserver_OnFastInitiationNotificationStateChanged_ParamsSpec.$, 'NearbyShareSettingsObserver_OnFastInitiationNotificationStateChanged_Params', [
    mojo.internal.StructField('state', 0, 0, FastInitiationNotificationStateSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(NearbyShareSettingsObserver_OnIsFastInitiationHardwareSupportedChanged_ParamsSpec.$, 'NearbyShareSettingsObserver_OnIsFastInitiationHardwareSupportedChanged_Params', [
    mojo.internal.StructField('isSupported', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(NearbyShareSettingsObserver_OnDeviceNameChanged_ParamsSpec.$, 'NearbyShareSettingsObserver_OnDeviceNameChanged_Params', [
    mojo.internal.StructField('deviceName', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(NearbyShareSettingsObserver_OnDataUsageChanged_ParamsSpec.$, 'NearbyShareSettingsObserver_OnDataUsageChanged_Params', [
    mojo.internal.StructField('dataUsage', 0, 0, DataUsageSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(NearbyShareSettingsObserver_OnVisibilityChanged_ParamsSpec.$, 'NearbyShareSettingsObserver_OnVisibilityChanged_Params', [
    mojo.internal.StructField('visibility', 0, 0, VisibilitySpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(NearbyShareSettingsObserver_OnAllowedContactsChanged_ParamsSpec.$, 'NearbyShareSettingsObserver_OnAllowedContactsChanged_Params', [
    mojo.internal.StructField('visibleContactIds', 0, 0, mojo.internal.Array(mojo.internal.String, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(NearbyShareSettingsObserver_OnIsOnboardingCompleteChanged_ParamsSpec.$, 'NearbyShareSettingsObserver_OnIsOnboardingCompleteChanged_Params', [
    mojo.internal.StructField('isComplete', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(NearbyShareSettings_AddSettingsObserver_ParamsSpec.$, 'NearbyShareSettings_AddSettingsObserver_Params', [
    mojo.internal.StructField('observer', 0, 0, mojo.internal.InterfaceProxy(NearbyShareSettingsObserverRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(NearbyShareSettings_GetEnabled_ParamsSpec.$, 'NearbyShareSettings_GetEnabled_Params', [], [[0, 8],]);
mojo.internal.Struct(NearbyShareSettings_GetEnabled_ResponseParamsSpec.$, 'NearbyShareSettings_GetEnabled_ResponseParams', [
    mojo.internal.StructField('enabled', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(NearbyShareSettings_SetEnabled_ParamsSpec.$, 'NearbyShareSettings_SetEnabled_Params', [
    mojo.internal.StructField('enabled', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(NearbyShareSettings_IsOnboardingComplete_ParamsSpec.$, 'NearbyShareSettings_IsOnboardingComplete_Params', [], [[0, 8],]);
mojo.internal.Struct(NearbyShareSettings_IsOnboardingComplete_ResponseParamsSpec.$, 'NearbyShareSettings_IsOnboardingComplete_ResponseParams', [
    mojo.internal.StructField('completed', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(NearbyShareSettings_SetIsOnboardingComplete_ParamsSpec.$, 'NearbyShareSettings_SetIsOnboardingComplete_Params', [
    mojo.internal.StructField('completed', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(NearbyShareSettings_GetFastInitiationNotificationState_ParamsSpec.$, 'NearbyShareSettings_GetFastInitiationNotificationState_Params', [], [[0, 8],]);
mojo.internal.Struct(NearbyShareSettings_GetFastInitiationNotificationState_ResponseParamsSpec.$, 'NearbyShareSettings_GetFastInitiationNotificationState_ResponseParams', [
    mojo.internal.StructField('state', 0, 0, FastInitiationNotificationStateSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(NearbyShareSettings_SetFastInitiationNotificationState_ParamsSpec.$, 'NearbyShareSettings_SetFastInitiationNotificationState_Params', [
    mojo.internal.StructField('state', 0, 0, FastInitiationNotificationStateSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(NearbyShareSettings_GetIsFastInitiationHardwareSupported_ParamsSpec.$, 'NearbyShareSettings_GetIsFastInitiationHardwareSupported_Params', [], [[0, 8],]);
mojo.internal.Struct(NearbyShareSettings_GetIsFastInitiationHardwareSupported_ResponseParamsSpec.$, 'NearbyShareSettings_GetIsFastInitiationHardwareSupported_ResponseParams', [
    mojo.internal.StructField('supported', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(NearbyShareSettings_GetDeviceName_ParamsSpec.$, 'NearbyShareSettings_GetDeviceName_Params', [], [[0, 8],]);
mojo.internal.Struct(NearbyShareSettings_GetDeviceName_ResponseParamsSpec.$, 'NearbyShareSettings_GetDeviceName_ResponseParams', [
    mojo.internal.StructField('deviceName', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(NearbyShareSettings_ValidateDeviceName_ParamsSpec.$, 'NearbyShareSettings_ValidateDeviceName_Params', [
    mojo.internal.StructField('deviceName', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(NearbyShareSettings_ValidateDeviceName_ResponseParamsSpec.$, 'NearbyShareSettings_ValidateDeviceName_ResponseParams', [
    mojo.internal.StructField('result', 0, 0, DeviceNameValidationResultSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(NearbyShareSettings_SetDeviceName_ParamsSpec.$, 'NearbyShareSettings_SetDeviceName_Params', [
    mojo.internal.StructField('deviceName', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(NearbyShareSettings_SetDeviceName_ResponseParamsSpec.$, 'NearbyShareSettings_SetDeviceName_ResponseParams', [
    mojo.internal.StructField('result', 0, 0, DeviceNameValidationResultSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(NearbyShareSettings_GetDataUsage_ParamsSpec.$, 'NearbyShareSettings_GetDataUsage_Params', [], [[0, 8],]);
mojo.internal.Struct(NearbyShareSettings_GetDataUsage_ResponseParamsSpec.$, 'NearbyShareSettings_GetDataUsage_ResponseParams', [
    mojo.internal.StructField('dataUsage', 0, 0, DataUsageSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(NearbyShareSettings_SetDataUsage_ParamsSpec.$, 'NearbyShareSettings_SetDataUsage_Params', [
    mojo.internal.StructField('dataUsage', 0, 0, DataUsageSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(NearbyShareSettings_GetVisibility_ParamsSpec.$, 'NearbyShareSettings_GetVisibility_Params', [], [[0, 8],]);
mojo.internal.Struct(NearbyShareSettings_GetVisibility_ResponseParamsSpec.$, 'NearbyShareSettings_GetVisibility_ResponseParams', [
    mojo.internal.StructField('visibility', 0, 0, VisibilitySpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(NearbyShareSettings_SetVisibility_ParamsSpec.$, 'NearbyShareSettings_SetVisibility_Params', [
    mojo.internal.StructField('visibility', 0, 0, VisibilitySpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(NearbyShareSettings_GetAllowedContacts_ParamsSpec.$, 'NearbyShareSettings_GetAllowedContacts_Params', [], [[0, 8],]);
mojo.internal.Struct(NearbyShareSettings_GetAllowedContacts_ResponseParamsSpec.$, 'NearbyShareSettings_GetAllowedContacts_ResponseParams', [
    mojo.internal.StructField('allowedContacts', 0, 0, mojo.internal.Array(mojo.internal.String, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(NearbyShareSettings_SetAllowedContacts_ParamsSpec.$, 'NearbyShareSettings_SetAllowedContacts_Params', [
    mojo.internal.StructField('allowedContacts', 0, 0, mojo.internal.Array(mojo.internal.String, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(DownloadContactsObserver_OnContactsDownloaded_ParamsSpec.$, 'DownloadContactsObserver_OnContactsDownloaded_Params', [
    mojo.internal.StructField('allowedContacts', 0, 0, mojo.internal.Array(mojo.internal.String, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('contacts', 8, 0, mojo.internal.Array(ContactRecordSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('numUnreachableContactsFilteredOut', 16, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 32],]);
mojo.internal.Struct(DownloadContactsObserver_OnContactsDownloadFailed_ParamsSpec.$, 'DownloadContactsObserver_OnContactsDownloadFailed_Params', [], [[0, 8],]);
mojo.internal.Struct(ContactManager_AddDownloadContactsObserver_ParamsSpec.$, 'ContactManager_AddDownloadContactsObserver_Params', [
    mojo.internal.StructField('observer', 0, 0, mojo.internal.InterfaceProxy(DownloadContactsObserverRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ContactManager_DownloadContacts_ParamsSpec.$, 'ContactManager_DownloadContacts_Params', [], [[0, 8],]);
mojo.internal.Struct(ContactManager_SetAllowedContacts_ParamsSpec.$, 'ContactManager_SetAllowedContacts_Params', [
    mojo.internal.StructField('allowedContacts', 0, 0, mojo.internal.Array(mojo.internal.String, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Union(ContactIdentifierSpec.$, 'ContactIdentifier', {
    'obfuscatedGaia': {
        'ordinal': 0,
        'type': mojo.internal.String,
    },
    'phoneNumber': {
        'ordinal': 1,
        'type': mojo.internal.String,
    },
    'accountName': {
        'ordinal': 2,
        'type': mojo.internal.String,
    },
});
export var ContactIdentifierFieldTags;
(function (ContactIdentifierFieldTags) {
    ContactIdentifierFieldTags[ContactIdentifierFieldTags["OBFUSCATED_GAIA"] = 0] = "OBFUSCATED_GAIA";
    ContactIdentifierFieldTags[ContactIdentifierFieldTags["PHONE_NUMBER"] = 1] = "PHONE_NUMBER";
    ContactIdentifierFieldTags[ContactIdentifierFieldTags["ACCOUNT_NAME"] = 2] = "ACCOUNT_NAME";
})(ContactIdentifierFieldTags || (ContactIdentifierFieldTags = {}));
export function whichContactIdentifier(u) {
    if (u.obfuscatedGaia !== null && u.obfuscatedGaia !== undefined) {
        return ContactIdentifierFieldTags.OBFUSCATED_GAIA;
    }
    if (u.phoneNumber !== null && u.phoneNumber !== undefined) {
        return ContactIdentifierFieldTags.PHONE_NUMBER;
    }
    if (u.accountName !== null && u.accountName !== undefined) {
        return ContactIdentifierFieldTags.ACCOUNT_NAME;
    }
    throw new Error("no union field has been set, this is an illegal state");
}
