// chromeos/services/network_health/public/mojom/network_health.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
import { NetworkStateSpec as chromeos_networkHealth_mojom_NetworkStateSpec, NetworkSpec as chromeos_networkHealth_mojom_NetworkSpec, NetworkHealthStateSpec as chromeos_networkHealth_mojom_NetworkHealthStateSpec, UInt32ValueSpec as chromeos_networkHealth_mojom_UInt32ValueSpec } from './network_health_types.mojom-webui.js';
export class NetworkEventsObserverPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'chromeos.network_health.mojom.NetworkEventsObserver', scope);
    }
}
export class NetworkEventsObserverRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(NetworkEventsObserverPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onConnectionStateChanged(guid, state) {
        this.proxy.sendMessage(0, NetworkEventsObserver_OnConnectionStateChanged_ParamsSpec.$, null, [
            guid,
            state
        ], false);
    }
    onSignalStrengthChanged(guid, signalStrength) {
        this.proxy.sendMessage(1, NetworkEventsObserver_OnSignalStrengthChanged_ParamsSpec.$, null, [
            guid,
            signalStrength
        ], false);
    }
    onNetworkListChanged(networks) {
        this.proxy.sendMessage(2, NetworkEventsObserver_OnNetworkListChanged_ParamsSpec.$, null, [
            networks
        ], false);
    }
}
;
/**
 * An object which receives request messages for the NetworkEventsObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class NetworkEventsObserverReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(NetworkEventsObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, NetworkEventsObserver_OnConnectionStateChanged_ParamsSpec.$, null, impl.onConnectionStateChanged.bind(impl), false);
        this.helper_internal_.registerHandler(1, NetworkEventsObserver_OnSignalStrengthChanged_ParamsSpec.$, null, impl.onSignalStrengthChanged.bind(impl), false);
        this.helper_internal_.registerHandler(2, NetworkEventsObserver_OnNetworkListChanged_ParamsSpec.$, null, impl.onNetworkListChanged.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class NetworkEventsObserver {
    static get $interfaceName() {
        return "chromeos.network_health.mojom.NetworkEventsObserver";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new NetworkEventsObserverRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the NetworkEventsObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class NetworkEventsObserverCallbackRouter {
    helper_internal_;
    $;
    router_;
    onConnectionStateChanged;
    onSignalStrengthChanged;
    onNetworkListChanged;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(NetworkEventsObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.onConnectionStateChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, NetworkEventsObserver_OnConnectionStateChanged_ParamsSpec.$, null, this.onConnectionStateChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.onSignalStrengthChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, NetworkEventsObserver_OnSignalStrengthChanged_ParamsSpec.$, null, this.onSignalStrengthChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.onNetworkListChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, NetworkEventsObserver_OnNetworkListChanged_ParamsSpec.$, null, this.onNetworkListChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class NetworkHealthServicePendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'chromeos.network_health.mojom.NetworkHealthService', scope);
    }
}
export class NetworkHealthServiceRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(NetworkHealthServicePendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    addObserver(observer) {
        this.proxy.sendMessage(0, NetworkHealthService_AddObserver_ParamsSpec.$, null, [
            observer
        ], false);
    }
    getNetworkList() {
        return this.proxy.sendMessage(1, NetworkHealthService_GetNetworkList_ParamsSpec.$, NetworkHealthService_GetNetworkList_ResponseParamsSpec.$, [], false);
    }
    getHealthSnapshot() {
        return this.proxy.sendMessage(2, NetworkHealthService_GetHealthSnapshot_ParamsSpec.$, NetworkHealthService_GetHealthSnapshot_ResponseParamsSpec.$, [], false);
    }
    getRecentlyActiveNetworks() {
        return this.proxy.sendMessage(3, NetworkHealthService_GetRecentlyActiveNetworks_ParamsSpec.$, NetworkHealthService_GetRecentlyActiveNetworks_ResponseParamsSpec.$, [], false);
    }
}
;
/**
 * An object which receives request messages for the NetworkHealthService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class NetworkHealthServiceReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(NetworkHealthServiceRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, NetworkHealthService_AddObserver_ParamsSpec.$, null, impl.addObserver.bind(impl), false);
        this.helper_internal_.registerHandler(1, NetworkHealthService_GetNetworkList_ParamsSpec.$, NetworkHealthService_GetNetworkList_ResponseParamsSpec.$, impl.getNetworkList.bind(impl), false);
        this.helper_internal_.registerHandler(2, NetworkHealthService_GetHealthSnapshot_ParamsSpec.$, NetworkHealthService_GetHealthSnapshot_ResponseParamsSpec.$, impl.getHealthSnapshot.bind(impl), false);
        this.helper_internal_.registerHandler(3, NetworkHealthService_GetRecentlyActiveNetworks_ParamsSpec.$, NetworkHealthService_GetRecentlyActiveNetworks_ResponseParamsSpec.$, impl.getRecentlyActiveNetworks.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class NetworkHealthService {
    static get $interfaceName() {
        return "chromeos.network_health.mojom.NetworkHealthService";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new NetworkHealthServiceRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the NetworkHealthService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class NetworkHealthServiceCallbackRouter {
    helper_internal_;
    $;
    router_;
    addObserver;
    getNetworkList;
    getHealthSnapshot;
    getRecentlyActiveNetworks;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(NetworkHealthServiceRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.addObserver =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, NetworkHealthService_AddObserver_ParamsSpec.$, null, this.addObserver.createReceiverHandler(false /* expectsResponse */), false);
        this.getNetworkList =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, NetworkHealthService_GetNetworkList_ParamsSpec.$, NetworkHealthService_GetNetworkList_ResponseParamsSpec.$, this.getNetworkList.createReceiverHandler(true /* expectsResponse */), false);
        this.getHealthSnapshot =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, NetworkHealthService_GetHealthSnapshot_ParamsSpec.$, NetworkHealthService_GetHealthSnapshot_ResponseParamsSpec.$, this.getHealthSnapshot.createReceiverHandler(true /* expectsResponse */), false);
        this.getRecentlyActiveNetworks =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, NetworkHealthService_GetRecentlyActiveNetworks_ParamsSpec.$, NetworkHealthService_GetRecentlyActiveNetworks_ResponseParamsSpec.$, this.getRecentlyActiveNetworks.createReceiverHandler(true /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export const NetworkEventsObserver_OnConnectionStateChanged_ParamsSpec = { $: {} };
export const NetworkEventsObserver_OnSignalStrengthChanged_ParamsSpec = { $: {} };
export const NetworkEventsObserver_OnNetworkListChanged_ParamsSpec = { $: {} };
export const NetworkHealthService_AddObserver_ParamsSpec = { $: {} };
export const NetworkHealthService_GetNetworkList_ParamsSpec = { $: {} };
export const NetworkHealthService_GetNetworkList_ResponseParamsSpec = { $: {} };
export const NetworkHealthService_GetHealthSnapshot_ParamsSpec = { $: {} };
export const NetworkHealthService_GetHealthSnapshot_ResponseParamsSpec = { $: {} };
export const NetworkHealthService_GetRecentlyActiveNetworks_ParamsSpec = { $: {} };
export const NetworkHealthService_GetRecentlyActiveNetworks_ResponseParamsSpec = { $: {} };
mojo.internal.Struct(NetworkEventsObserver_OnConnectionStateChanged_ParamsSpec.$, 'NetworkEventsObserver_OnConnectionStateChanged_Params', [
    mojo.internal.StructField('guid', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('state', 8, 0, chromeos_networkHealth_mojom_NetworkStateSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(NetworkEventsObserver_OnSignalStrengthChanged_ParamsSpec.$, 'NetworkEventsObserver_OnSignalStrengthChanged_Params', [
    mojo.internal.StructField('guid', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('signalStrength', 8, 0, chromeos_networkHealth_mojom_UInt32ValueSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(NetworkEventsObserver_OnNetworkListChanged_ParamsSpec.$, 'NetworkEventsObserver_OnNetworkListChanged_Params', [
    mojo.internal.StructField('networks', 0, 0, mojo.internal.Array(chromeos_networkHealth_mojom_NetworkSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(NetworkHealthService_AddObserver_ParamsSpec.$, 'NetworkHealthService_AddObserver_Params', [
    mojo.internal.StructField('observer', 0, 0, mojo.internal.InterfaceProxy(NetworkEventsObserverRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(NetworkHealthService_GetNetworkList_ParamsSpec.$, 'NetworkHealthService_GetNetworkList_Params', [], [[0, 8],]);
mojo.internal.Struct(NetworkHealthService_GetNetworkList_ResponseParamsSpec.$, 'NetworkHealthService_GetNetworkList_ResponseParams', [
    mojo.internal.StructField('networks', 0, 0, mojo.internal.Array(chromeos_networkHealth_mojom_NetworkSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(NetworkHealthService_GetHealthSnapshot_ParamsSpec.$, 'NetworkHealthService_GetHealthSnapshot_Params', [], [[0, 8],]);
mojo.internal.Struct(NetworkHealthService_GetHealthSnapshot_ResponseParamsSpec.$, 'NetworkHealthService_GetHealthSnapshot_ResponseParams', [
    mojo.internal.StructField('state', 0, 0, chromeos_networkHealth_mojom_NetworkHealthStateSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(NetworkHealthService_GetRecentlyActiveNetworks_ParamsSpec.$, 'NetworkHealthService_GetRecentlyActiveNetworks_Params', [], [[0, 8],]);
mojo.internal.Struct(NetworkHealthService_GetRecentlyActiveNetworks_ResponseParamsSpec.$, 'NetworkHealthService_GetRecentlyActiveNetworks_ResponseParams', [
    mojo.internal.StructField('guids', 0, 0, mojo.internal.Array(mojo.internal.String, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
