/**
 * @license
 * Copyright 2021 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
import { __decorate } from "//resources/mwc/tslib/tslib.js";
import { customElement } from '//resources/mwc/lit/index.js';
import { styles as sharedStyles } from './internal/shared-styles.js';
import { TextButton } from './internal/text-button.js';
import { styles as textStyles } from './internal/text-styles.js';
/**
 * @summary Buttons help people take action, such as sending an email, sharing a
 * document, or liking a comment.
 *
 * @description
 * __Emphasis:__ Low emphasis – For optional or supplementary actions with the
 * least amount of prominence
 *
 * __Rationale:__ Text buttons have less visual prominence, so should be used
 * for low emphasis actions, such as an alternative option.
 *
 * __Example usages:__
 * - Learn more
 * - View all
 * - Change account
 * - Turn on
 *
 * @final
 * @suppress {visibility}
 */
let MdTextButton = class MdTextButton extends TextButton {
};
MdTextButton.styles = [sharedStyles, textStyles];
MdTextButton = __decorate([
    customElement('md-text-button')
], MdTextButton);
export { MdTextButton };
//# sourceMappingURL=text-button.js.map