/**
 * @license
 * Copyright 2023 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
import { __decorate } from "//resources/mwc/tslib/tslib.js";
import { customElement } from '//resources/mwc/lit/index.js';
import { CircularProgress } from './internal/circular-progress.js';
import { styles } from './internal/circular-progress-styles.js';
/**
 * @summary Circular progress indicators display progress by animating along an
 * invisible circular track in a clockwise direction. They can be applied
 * directly to a surface, such as a button or card.
 *
 * @description
 * Progress indicators inform users about the status of ongoing processes.
 * - Determinate indicators display how long a process will take.
 * - Indeterminate indicators express an unspecified amount of wait time.
 *
 * @final
 * @suppress {visibility}
 */
let MdCircularProgress = class MdCircularProgress extends CircularProgress {
};
MdCircularProgress.styles = [styles];
MdCircularProgress = __decorate([
    customElement('md-circular-progress')
], MdCircularProgress);
export { MdCircularProgress };
//# sourceMappingURL=circular-progress.js.map