// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{TestImportManager}from"../../../../../../../../../../../../../../../../../../common/testing/test_import_manager.js";import{Flags,FlagName}from"../../../../../../../../../../../../../../../../../../common/flags.js";import{InstanceChecker}from"../../../../../../../../../../../../../../../../../../common/mv2/instance_checker.js";import"../../../../../../../../../../../../../../../../../../common/array_util.js";import{AutomationPredicate}from"../../../../../../../../../../../../../../../../../../common/automation_predicate.js";import"../../../../../../../../../../../../../../../../../../common/tree_walker.js";import"../../../../../../../../../../../../../../../../../../common/automation_util.js";import{RectUtil}from"../../../../../../../../../../../../../../../../../../common/rect_util.js";import"../../../../../../../../../../../../../../../../../../common/cursors/cursor.js";import"../../../../../../../../../../../../../../../../../../common/cursors/range.js";import{EventGenerator}from"../../../../../../../../../../../../../../../../../../common/event_generator.js";import"../../../../../../../../../../../../../../../../../../common/keep_alive.js";import"../../../../../../../../../../../../../../../../../../common/local_storage.js";import{EventHandler}from"../../../../../../../../../../../../../../../../../../common/event_handler.js";import{Context}from"../../../../../../../../../../../../../../../../../../common/action_fulfillment/context_checker.js";import{MacroName}from"../../../../../../../../../../../../../../../../../../common/action_fulfillment/macros/macro_names.js";import{AsyncUtil}from"../../../../../../../../../../../../../../../../../../common/async_util.js";import{InputController}from"../../../../../../../../../../../../../../../../../../common/action_fulfillment/input_controller.js";import{InputTextViewMacro,NewLineMacro}from"../../../../../../../../../../../../../../../../../../common/action_fulfillment/macros/input_text_view_macro.js";import{DeletePrevSentMacro}from"../../../../../../../../../../../../../../../../../../common/action_fulfillment/macros/delete_prev_sent_macro.js";import{NavPrevSentMacro,NavNextSentMacro}from"../../../../../../../../../../../../../../../../../../common/action_fulfillment/macros/nav_sent_macro.js";import{RepeatMacro}from"../../../../../../../../../../../../../../../../../../common/action_fulfillment/macros/repeat_macro.js";import*as RepeatableKeyPressMacro from"../../../../../../../../../../../../../../../../../../common/action_fulfillment/macros/repeatable_key_press_macro.js";import{SmartDeletePhraseMacro}from"../../../../../../../../../../../../../../../../../../common/action_fulfillment/macros/smart_delete_phrase_macro.js";import{SmartInsertBeforeMacro}from"../../../../../../../../../../../../../../../../../../common/action_fulfillment/macros/smart_insert_before_macro.js";import{SmartReplacePhraseMacro}from"../../../../../../../../../../../../../../../../../../common/action_fulfillment/macros/smart_replace_phrase_macro.js";import{SmartSelectBetweenMacro}from"../../../../../../../../../../../../../../../../../../common/action_fulfillment/macros/smart_select_between_macro.js";import{ToggleDictationMacro}from"../../../../../../../../../../../../../../../../../../common/action_fulfillment/macros/toggle_dictation_macro.js";import{Macro,ToggleDirection,MacroError}from"../../../../../../../../../../../../../../../../../../common/action_fulfillment/macros/macro.js";import{CustomCallbackMacro}from"../../../../../../../../../../../../../../../../../../common/action_fulfillment/macros/custom_callback_macro.js";import{KeyPressMacro}from"../../../../../../../../../../../../../../../../../../common/action_fulfillment/macros/key_press_macro.js";import{MouseClickLeftTripleMacro,MouseClickLeftDoubleMacro,MouseClickMacro}from"../../../../../../../../../../../../../../../../../../common/action_fulfillment/macros/mouse_click_macro.js";import{KeyCode}from"../../../../../../../../../../../../../../../../../../common/key_code.js";import{FaceLandmarker}from"../../../../../../../../../../../../../../../../../../accessibility_common/mv2/third_party/mediapipe_task_vision/vision_bundle.mjs";import{ChromeEventHandler}from"../../../../../../../../../../../../../../../../../../common/chrome_event_handler.js";const AUTOCLICK_FOCUS_RING_COLOR="#aac9fa";const AUTOCLICK_FOCUS_RING_DISPLAY_TIME_MS=250;class Autoclick{blinkFocusRings_=true;desktop_=null;scrollableBoundsListener_=null;hitTestHandler_;onLoadDesktopCallbackForTest_=null;constructor(){this.hitTestHandler_=new EventHandler([],chrome.automation.EventType.MOUSE_PRESSED,(event=>this.onAutomationHitTestResult_(event)),{capture:true,exactMatch:false,listenOnce:false,predicate:undefined});this.init_()}setNoBlinkFocusRingsForTest(){this.blinkFocusRings_=false}onAutoclickDisabled(){if(this.scrollableBoundsListener_){chrome.accessibilityPrivate.onScrollableBoundsForPointRequested.removeListener(this.scrollableBoundsListener_);this.scrollableBoundsListener_=null}this.hitTestHandler_.stop()}init_(){this.scrollableBoundsListener_=(x,y)=>this.findScrollingContainerForPoint_(x,y);chrome.automation.getDesktop((desktop=>{this.desktop_=desktop;this.hitTestHandler_.setNodes(this.desktop_);this.hitTestHandler_.start();if(this.onLoadDesktopCallbackForTest_){this.onLoadDesktopCallbackForTest_();this.onLoadDesktopCallbackForTest_=null}}));chrome.accessibilityPrivate.onScrollableBoundsForPointRequested.addListener(this.scrollableBoundsListener_)}setFocusRings_(rects){chrome.accessibilityPrivate.setFocusRings([{rects:rects,type:chrome.accessibilityPrivate.FocusType.SOLID,color:AUTOCLICK_FOCUS_RING_COLOR,secondaryColor:AUTOCLICK_FOCUS_RING_COLOR}],chrome.accessibilityPrivate.AssistiveTechnologyType.AUTO_CLICK)}shouldHighlightAsScrollable_(node){if(node.scrollable===undefined||!node.scrollable){return false}return node.scrollXMax-node.scrollXMin>node.location.width||node.scrollYMax-node?.scrollYMin>node.location.height}onAutomationHitTestResult_(event){let node=event.target;while(node.parent&&node.role!==chrome.automation.RoleType.WINDOW&&node.role!==chrome.automation.RoleType.ROOT_WEB_AREA&&node.role!==chrome.automation.RoleType.DESKTOP&&node.role!==chrome.automation.RoleType.DIALOG&&node.role!==chrome.automation.RoleType.ALERT_DIALOG&&node.role!==chrome.automation.RoleType.TOOLBAR){if(this.shouldHighlightAsScrollable_(node)){break}node=node.parent}if(!node.location){return}const bounds=node.location;this.setFocusRings_([bounds]);if(this.blinkFocusRings_){setTimeout((()=>{this.setFocusRings_([])}),AUTOCLICK_FOCUS_RING_DISPLAY_TIME_MS*2);setTimeout((()=>{this.setFocusRings_([bounds])}),AUTOCLICK_FOCUS_RING_DISPLAY_TIME_MS*3);setTimeout((()=>{this.setFocusRings_([])}),AUTOCLICK_FOCUS_RING_DISPLAY_TIME_MS*5)}chrome.accessibilityPrivate.handleScrollableBoundsForPointFound(bounds)}findScrollingContainerForPoint_(x,y){this.desktop_.hitTest(x,y,chrome.automation.EventType.MOUSE_PRESSED)}setOnLoadDesktopCallbackForTest(callback){if(!this.desktop_){this.onLoadDesktopCallbackForTest_=callback;return}callback()}}var EventType$2=chrome.automation.EventType;class FocusHandler{active_=false;editableNode_=null;deactivateTimeoutId_=null;eventHandler_=null;onActiveChangedForTesting_=null;onEditableNodeChangedForTesting_=null;onFocusChangedForTesting_=null;async refresh(){if(this.deactivateTimeoutId_!==null){clearTimeout(this.deactivateTimeoutId_)}this.deactivateTimeoutId_=setTimeout((()=>this.deactivate_()),FocusHandler.DEACTIVATE_TIMEOUT_MS_);await this.activate_()}async activate_(){if(this.active_){return}const desktop=await AsyncUtil.getDesktop();const focus=await AsyncUtil.getFocus();if(focus&&AutomationPredicate.editText(focus)){this.setEditableNode_(focus)}if(!this.eventHandler_){this.eventHandler_=new EventHandler([],EventType$2.FOCUS,(event=>this.onFocusChanged_(event)))}this.eventHandler_.setNodes(desktop);this.eventHandler_.start();this.setActive_(true)}deactivate_(){this.eventHandler_.stop();this.eventHandler_=null;this.setActive_(false);this.setEditableNode_(null)}onFocusChanged_(event){const node=event.target;if(!node||!AutomationPredicate.editText(node)){this.setEditableNode_(null);return}this.setEditableNode_(node);if(this.onFocusChangedForTesting_){this.onFocusChangedForTesting_()}}getEditableNode(){return this.editableNode_}setActive_(value){this.active_=value;if(this.onActiveChangedForTesting_){this.onActiveChangedForTesting_()}}setEditableNode_(node){this.editableNode_=node;if(this.onEditableNodeChangedForTesting_){this.onEditableNodeChangedForTesting_()}}isReadyForTesting(expectedClassName){return this.active_&&this.editableNode_!==null&&this.editableNode_.className===expectedClassName}}(function(FocusHandler){FocusHandler.DEACTIVATE_TIMEOUT_MS_=45*1e3})(FocusHandler||(FocusHandler={}));TestImportManager.exportForTesting(FocusHandler);class LocaleInfo{static allowSmartCapAndSpacing(){const language=LocaleInfo.locale.split("-")[0];return LocaleInfo.SMART_CAP_AND_SPACING_LANGUAGES_.has(language)}static allowSmartEditing(){return!LocaleInfo.isRTLLocale()}static isRTLLocale(){const locale=LocaleInfo.locale;return LocaleInfo.RTL_LOCALES_.has(locale)}static getUILanguage(){const locale=LocaleInfo.locale.toLowerCase();return LocaleInfo.LOCALE_TO_UI_LANGUAGE_MAP_[locale]}static areCommandsSupported(){const systemLocale=chrome.i18n.getUILanguage().toLowerCase();const systemLanguage=systemLocale.split("-")[0];const dictationLanguage=LocaleInfo.locale.toLowerCase().split("-")[0];if(systemLanguage===dictationLanguage){return true}return LocaleInfo.alwaysEnableCommandsForTesting||Boolean(LocaleInfo.getUILanguage())&&(LocaleInfo.getUILanguage()===systemLanguage||LocaleInfo.getUILanguage()===systemLocale)}static considerSpaces(){const language=LocaleInfo.locale.toLowerCase().split("-")[0];return!LocaleInfo.NO_SPACE_LANGUAGES_.has(language)}}(function(LocaleInfo){LocaleInfo.locale="";LocaleInfo.alwaysEnableCommandsForTesting=false;LocaleInfo.SMART_CAP_AND_SPACING_LANGUAGES_=new Set(["en","fr","it","de","es"]);LocaleInfo.RTL_LOCALES_=new Set(["ar-AE","ar-BH","ar-DZ","ar-EG","ar-IL","ar-IQ","ar-JO","ar-KW","ar-LB","ar-MA","ar-OM","ar-PS","ar-QA","ar-SA","ar-TN","ar-YE","fa-IR","iw-IL","ur-IN","ur-PK"]);LocaleInfo.LOCALE_TO_UI_LANGUAGE_MAP_={"iw-il":"he","yue-hant-hk":"zh-tw","no-no":"nb"};LocaleInfo.NO_SPACE_LANGUAGES_=new Set(["ja","zh"])})(LocaleInfo||(LocaleInfo={}));TestImportManager.exportForTesting(LocaleInfo);class EditingUtil{static getReplacePhraseData(value,caretIndex,deletePhrase){const leftOfCaret=value.substring(0,caretIndex);deletePhrase=deletePhrase.trim();let re;if(LocaleInfo.considerSpaces()){re=EditingUtil.getPhraseRegex_(deletePhrase)}else{re=EditingUtil.getPhraseRegexNoWordBoundaries_(deletePhrase)}const reWithLeadingSpace=EditingUtil.getPhraseRegexLeadingSpace_(deletePhrase);const reWithTrailingSpace=EditingUtil.getPhraseRegexTrailingSpace_(deletePhrase);const leadingSpaceResult=EditingUtil.getIndexFromRegex_(reWithLeadingSpace,leftOfCaret);const trailingSpaceResult=EditingUtil.getIndexFromRegex_(reWithTrailingSpace,leftOfCaret);const noSpacesResult=EditingUtil.getIndexFromRegex_(re,leftOfCaret);let newIndex=caretIndex;let deleteLength=0;if(leadingSpaceResult!==-1){newIndex=leadingSpaceResult;deleteLength=deletePhrase.length+1}else if(trailingSpaceResult!==-1){newIndex=trailingSpaceResult;deleteLength=deletePhrase.length+1}else if(noSpacesResult!==-1){newIndex=noSpacesResult;deleteLength=deletePhrase.length}else{return null}return{newIndex:newIndex,deleteLength:deleteLength}}static getInsertBeforeIndex(value,caretIndex,beforePhrase){const result=EditingUtil.getReplacePhraseData(value,caretIndex,beforePhrase);return result?result.newIndex:-1}static selectBetween(value,caretIndex,startPhrase,endPhrase){const leftOfCaret=value.substring(0,caretIndex);startPhrase=startPhrase.trim();endPhrase=endPhrase.trim();let startRe;let endRe;if(LocaleInfo.considerSpaces()){startRe=EditingUtil.getPhraseRegex_(startPhrase);endRe=EditingUtil.getPhraseRegex_(endPhrase)}else{startRe=EditingUtil.getPhraseRegexNoWordBoundaries_(startPhrase);endRe=EditingUtil.getPhraseRegexNoWordBoundaries_(endPhrase)}const start=leftOfCaret.search(startRe);let end=leftOfCaret.search(endRe);if(start===-1||end===-1){return null}end+=endPhrase.length;if(start>end){return null}return{start:start,end:end}}static navNextSent(value,caretIndex){const rightOfCaret=value.substring(caretIndex);const index=rightOfCaret.search(EditingUtil.END_OF_SENTENCE_REGEX_);if(index===-1){return value.length}return index+caretIndex+1}static navPrevSent(value,caretIndex){let encounteredText=false;if(caretIndex===value.length){--caretIndex}while(caretIndex>=0){const valueAtCaret=value[caretIndex];if(encounteredText&&EditingUtil.END_OF_SENTENCE_REGEX_.test(valueAtCaret)){return EditingUtil.BEGINS_WITH_WHITESPACE_REGEX_.test(value[caretIndex+1])?caretIndex+1:caretIndex}if(!EditingUtil.BEGINS_WITH_WHITESPACE_REGEX_.test(valueAtCaret)&&!EditingUtil.PUNCTUATION_REGEX_.test(valueAtCaret)){encounteredText=true}--caretIndex}return 0}static smartSpacing(value,caretIndex,commitText){if(!value||EditingUtil.BEGINS_WITH_WHITESPACE_REGEX_.test(commitText)||EditingUtil.BEGINS_WITH_PUNCTUATION_REGEX_.test(commitText)){return commitText}commitText=commitText.trim();const leftOfCaret=value.substring(0,caretIndex);const rightOfCaret=value.substring(caretIndex);if(leftOfCaret&&!EditingUtil.ENDS_WITH_WHITESPACE_REGEX_.test(leftOfCaret)){commitText=" "+commitText}if(rightOfCaret&&(!EditingUtil.BEGINS_WITH_WHITESPACE_REGEX_.test(rightOfCaret)||EditingUtil.BEGINS_WITH_PUNCTUATION_REGEX_.test(rightOfCaret))){commitText=commitText+" "}return commitText}static smartCapitalization(value,caretIndex,commitText){if(EditingUtil.BEGINS_WITH_PUNCTUATION_REGEX_.test(commitText)){return commitText}if(!value){return EditingUtil.capitalize_(commitText)}const leftOfCaret=value.substring(0,caretIndex).trim();if(!leftOfCaret){return EditingUtil.capitalize_(commitText)}return EditingUtil.ENDS_WITH_END_OF_SENTENCE_REGEX_.test(leftOfCaret)?EditingUtil.capitalize_(commitText):EditingUtil.lowercase_(commitText)}static capitalize_(text){return text.charAt(0).toUpperCase()+text.substring(1)}static lowercase_(text){return text.charAt(0).toLowerCase()+text.substring(1)}static getPhraseRegex_(phrase){return new RegExp(`(\\b${phrase}\\b)(?!.*\\b\\1\\b)`,"i")}static getPhraseRegexNoWordBoundaries_(phrase){return new RegExp(`(${phrase})(?!.*\\1)`,"i")}static getPhraseRegexLeadingSpace_(phrase){return new RegExp(`( \\b${phrase}\\b)(?!.*\\b\\1\\b)`,"i")}static getPhraseRegexTrailingSpace_(phrase){return new RegExp(`(\\b${phrase}\\b )(?!.*\\b\\1\\b)`,"i")}static getIndexFromRegex_(re,str){const result=re.exec(str);return result?result.index:-1}}(function(EditingUtil){EditingUtil.END_OF_SENTENCE_REGEX_=/[;!.?。．？！]/;EditingUtil.ENDS_WITH_END_OF_SENTENCE_REGEX_=/[;!.?。．？！]$/;EditingUtil.BEGINS_WITH_WHITESPACE_REGEX_=/^\s/;EditingUtil.ENDS_WITH_WHITESPACE_REGEX_=/\s$/;EditingUtil.PUNCTUATION_REGEX_=/[-$#"()*;:<>\\\/\{\}\[\]+='~`!@_.,?%。．？！\u2022\u25e6\u25a0]/g;EditingUtil.BEGINS_WITH_PUNCTUATION_REGEX_=/^[-$#"()*;:<>\\\/\{\}\[\]+='~`!@_.,?%。．？！\u2022\u25e6\u25a0]/})(EditingUtil||(EditingUtil={}));TestImportManager.exportForTesting(EditingUtil);var EventType$1=chrome.automation.EventType;var PositionType=chrome.automation.PositionType;var StateType$1=chrome.automation.StateType;class AutomationImeEventWaiter{node_;event_;constructor(node,event){this.node_=node;this.event_=event}async doActionAndWait(doAction){let surroundingTextChanged=false;let eventSeen=false;return new Promise((resolve=>{const onSurroundingTextChanged=()=>{surroundingTextChanged=true;chrome.input.ime.onSurroundingTextChanged.removeListener(onSurroundingTextChanged);if(eventSeen){resolve()}};let handler=new EventHandler([this.node_],this.event_,(()=>{eventSeen=true;handler.stop();handler=null;if(surroundingTextChanged){resolve()}}));handler.start();chrome.input.ime.onSurroundingTextChanged.addListener(onSurroundingTextChanged);doAction()}))}}class InputControllerImpl extends InputController{stopDictationCallback_;focusHandler_;activeImeContextId_=InputControllerImpl.NO_ACTIVE_IME_CONTEXT_ID_;onConnectCallback_=null;onFocusListener_=null;onBlurListener_=null;onSurroundingTextChangedListener_=null;surroundingInfo_=null;onSurroundingTextChangedForTesting_=null;onSelectionChangedForTesting_=null;previousImeEngineId_="";constructor(stopDictationCallback,focusHandler){super();this.stopDictationCallback_=stopDictationCallback;this.focusHandler_=focusHandler;this.initialize_()}initialize_(){this.onFocusListener_=context=>this.onImeFocus_(context);this.onBlurListener_=contextId=>this.onImeBlur_(contextId);this.onSurroundingTextChangedListener_=(engineID,surroundingInfo)=>this.onSurroundingTextChanged_(engineID,surroundingInfo);chrome.input.ime.onFocus.addListener(this.onFocusListener_);chrome.input.ime.onBlur.addListener(this.onBlurListener_);chrome.input.ime.onSurroundingTextChanged.addListener(this.onSurroundingTextChangedListener_)}removeListeners(){if(this.onFocusListener_){chrome.input.ime.onFocus.removeListener(this.onFocusListener_)}if(this.onBlurListener_){chrome.input.ime.onBlur.removeListener(this.onBlurListener_)}if(this.onSurroundingTextChangedListener_){chrome.input.ime.onSurroundingTextChanged.removeListener(this.onSurroundingTextChangedListener_)}}isActive(){return this.activeImeContextId_!==InputControllerImpl.NO_ACTIVE_IME_CONTEXT_ID_}connect(callback){this.onConnectCallback_=callback;chrome.inputMethodPrivate.getCurrentInputMethod((method=>this.saveCurrentInputMethodAndStart_(method)))}saveCurrentInputMethodAndStart_(method){this.previousImeEngineId_=method;chrome.languageSettingsPrivate.addInputMethod(InputControllerImpl.IME_ENGINE_ID);chrome.inputMethodPrivate.setCurrentInputMethod(InputControllerImpl.IME_ENGINE_ID)}disconnect(){this.activeImeContextId_=InputControllerImpl.NO_ACTIVE_IME_CONTEXT_ID_;chrome.inputMethodPrivate.setCurrentInputMethod(this.previousImeEngineId_);this.previousImeEngineId_="";this.surroundingInfo_=null}commitText(text){if(!this.isActive()||!text){return}const data=this.getEditableNodeData();if(LocaleInfo.allowSmartCapAndSpacing()&&this.checkEditableNodeData_(data)){const{value:value,selStart:selStart}=data;text=EditingUtil.smartCapitalization(value,selStart,text);text=EditingUtil.smartSpacing(value,selStart,text)}if(!LocaleInfo.considerSpaces()){let textNoSpaces="";for(const char of text){if(char===" "){continue}textNoSpaces+=char}text=textNoSpaces}chrome.input.ime.commitText({contextID:this.activeImeContextId_,text:text})}onImeFocus_(context){this.activeImeContextId_=context.contextID;if(this.onConnectCallback_){this.onConnectCallback_();this.onConnectCallback_=null}}onImeBlur_(contextId){if(contextId===this.activeImeContextId_){this.activeImeContextId_=InputControllerImpl.NO_ACTIVE_IME_CONTEXT_ID_;this.surroundingInfo_=null;this.stopDictationCallback_()}}onSurroundingTextChanged_(engineID,surroundingInfo){if(engineID!==InputControllerImpl.ON_SURROUNDING_TEXT_CHANGED_ENGINE_ID){return}this.surroundingInfo_=surroundingInfo;if(this.onSurroundingTextChangedForTesting_){this.onSurroundingTextChangedForTesting_()}}deletePrevSentence(){const data=this.getEditableNodeData();if(!this.checkEditableNodeData_(data)){return}const{value:value,selStart:selStart}=data;const prevSentenceStart=EditingUtil.navPrevSent(value,selStart);const length=selStart-prevSentenceStart;this.deleteSurroundingText_(length,-length)}async deleteSurroundingText_(length,offset){const editableNode=this.focusHandler_.getEditableNode();if(!editableNode){throw new Error("deleteSurroundingText_ requires a valid editable node")}const deleteSurroundingText=()=>{chrome.input.ime.deleteSurroundingText({contextID:this.activeImeContextId_,engineID:InputControllerImpl.IME_ENGINE_ID,length:length,offset:offset})};const waiter=new AutomationImeEventWaiter(editableNode,EventType$1.VALUE_IN_TEXT_FIELD_CHANGED);await waiter.doActionAndWait(deleteSurroundingText)}deletePhrase(phrase){this.replacePhrase(phrase,"")}async replacePhrase(deletePhrase,insertPhrase){const data=this.getEditableNodeData();if(!this.checkEditableNodeData_(data)){return}const{value:value,selStart:selStart}=data;const replacePhraseData=EditingUtil.getReplacePhraseData(value,selStart,deletePhrase);if(!replacePhraseData){return}const{newIndex:newIndex,deleteLength:deleteLength}=replacePhraseData;await this.setSelection_(newIndex,newIndex);await this.deleteSurroundingText_(deleteLength,deleteLength);if(insertPhrase){this.commitText(insertPhrase)}}async setSelection_(selStart,selEnd){const editableNode=this.focusHandler_.getEditableNode();if(!editableNode){return}let anchorObject=editableNode;let anchorOffset=selStart;let focusObject=editableNode;let focusOffset=selEnd;const isContentEditable=editableNode.state[StateType$1.RICHLY_EDITABLE];if(isContentEditable){let data=this.textNodeAndIndex_(selStart);if(data){anchorObject=data.node;anchorOffset=data.index}data=this.textNodeAndIndex_(selEnd);if(data){focusObject=data.node;focusOffset=data.index}}const setDocumentSelection=()=>{chrome.automation.setDocumentSelection({anchorObject:anchorObject,anchorOffset:anchorOffset,focusObject:focusObject,focusOffset:focusOffset})};const waiter=new AutomationImeEventWaiter(editableNode,EventType$1.TEXT_SELECTION_CHANGED);await waiter.doActionAndWait(setDocumentSelection);if(this.onSelectionChangedForTesting_){this.onSelectionChangedForTesting_()}}async insertBefore(insertPhrase,beforePhrase){const data=this.getEditableNodeData();if(!this.checkEditableNodeData_(data)){return}const{value:value,selStart:selStart}=data;const newIndex=EditingUtil.getInsertBeforeIndex(value,selStart,beforePhrase);if(newIndex===-1){return}await this.setSelection_(newIndex,newIndex);this.commitText(insertPhrase)}selectBetween(startPhrase,endPhrase){const data=this.getEditableNodeData();if(!this.checkEditableNodeData_(data)){return}const{value:value,selStart:selStart}=data;const selection=EditingUtil.selectBetween(value,selStart,startPhrase,endPhrase);if(!selection){return}this.setSelection_(selection.start,selection.end)}async navNextSent(){const data=this.getEditableNodeData();if(!this.checkEditableNodeData_(data)){return}const{value:value,selStart:selStart}=data;const newCaretIndex=EditingUtil.navNextSent(value,selStart);await this.setSelection_(newCaretIndex,newCaretIndex)}async navPrevSent(){const data=this.getEditableNodeData();if(!this.checkEditableNodeData_(data)){return}const{value:value,selStart:selStart}=data;const newCaretIndex=EditingUtil.navPrevSent(value,selStart);await this.setSelection_(newCaretIndex,newCaretIndex)}getEditableNodeData(){const node=this.focusHandler_.getEditableNode();if(!node){return null}let value;let selStart;let selEnd;const isContentEditable=node.state[StateType$1.RICHLY_EDITABLE];if(isContentEditable&&this.surroundingInfo_){const info=this.surroundingInfo_;value=info.text;selStart=Math.min(info.anchor,info.focus);selEnd=Math.max(info.anchor,info.focus);return{node:node,value:value,selStart:selStart,selEnd:selEnd}}value=node.value||"";selStart=node.textSelStart!==undefined&&node.textSelStart!==-1?node.textSelStart:value.length;selEnd=node.textSelEnd!==undefined&&node.textSelEnd!==-1?node.textSelEnd:value.length;return{node:node,value:value,selStart:Math.min(selStart,selEnd),selEnd:Math.max(selStart,selEnd)}}checkEditableNodeData_(data){if(!data||data.selStart!==data.selEnd){return false}return true}textNodeAndIndex_(index){const editableNode=this.focusHandler_.getEditableNode();if(!editableNode||!editableNode.state[StateType$1.RICHLY_EDITABLE]){throw new Error("textNodeAndIndex_ requires a content editable node")}const position=editableNode.createPosition(PositionType.TEXT,index);position.asLeafTextPosition();if(!position||!position.node||position.textOffset===undefined){return null}return{node:position.node,index:position.textOffset}}}(function(InputControllerImpl){InputControllerImpl.IME_ENGINE_ID="_ext_ime_egfdjlfmgnehecnclamagfafdccgfndpdictation";InputControllerImpl.ON_SURROUNDING_TEXT_CHANGED_ENGINE_ID="dictation";InputControllerImpl.NO_ACTIVE_IME_CONTEXT_ID_=-1})(InputControllerImpl||(InputControllerImpl={}));TestImportManager.exportForTesting(InputControllerImpl);var SpeechRecognitionType$1=chrome.speechRecognitionPrivate.SpeechRecognitionType;let MetricsUtils$1=class MetricsUtils{onDevice_;locale_;speechRecognitionStartTime_=null;constructor(type,locale){this.onDevice_=type===SpeechRecognitionType$1.ON_DEVICE;this.locale_=locale}static recordMacroRecognized(macro){chrome.metricsPrivate.recordSparseValue(MetricsUtils.MACRO_RECOGNIZED_METRIC,macro.getName())}static recordMacroSucceeded(macro){chrome.metricsPrivate.recordSparseValue(MetricsUtils.MACRO_SUCCEEDED_METRIC,macro.getName())}static recordMacroFailed(macro){chrome.metricsPrivate.recordSparseValue(MetricsUtils.MACRO_FAILED_METRIC,macro.getName())}static recordPumpkinUsed(used){chrome.metricsPrivate.recordBoolean(MetricsUtils.PUMPKIN_USED_METRIC,used)}static recordPumpkinSucceeded(succeeded){chrome.metricsPrivate.recordBoolean(MetricsUtils.PUMPKIN_SUCCEEDED_METRIC,succeeded)}recordSpeechRecognitionStarted(){chrome.metricsPrivate.recordBoolean(MetricsUtils.ON_DEVICE_SPEECH_METRIC,this.onDevice_);chrome.metricsPrivate.recordSparseValueWithHashMetricName(MetricsUtils.LOCALE_METRIC,this.locale_);this.speechRecognitionStartTime_=new Date}recordSpeechRecognitionStopped(){if(this.speechRecognitionStartTime_===null){console.warn(`Failed to record metrics when speech recognition stopped, valid\n          speech recognition start time required.`);return}const metricName=this.onDevice_?MetricsUtils.LISTENING_DURATION_METRIC_ON_DEVICE:MetricsUtils.LISTENING_DURATION_METRIC_NETWORK;const listeningDuration=(new Date).getTime()-this.speechRecognitionStartTime_.getTime();chrome.metricsPrivate.recordLongTime(metricName,listeningDuration)}};(function(MetricsUtils){MetricsUtils.ON_DEVICE_SPEECH_METRIC="Accessibility.CrosDictation.UsedOnDeviceSpeech";MetricsUtils.LOCALE_METRIC="Accessibility.CrosDictation.Language";MetricsUtils.LISTENING_DURATION_METRIC_ON_DEVICE="Accessibility.CrosDictation.ListeningDuration.OnDeviceRecognition";MetricsUtils.LISTENING_DURATION_METRIC_NETWORK="Accessibility.CrosDictation.ListeningDuration.NetworkRecognition";MetricsUtils.MACRO_RECOGNIZED_METRIC="Accessibility.CrosDictation.MacroRecognized";MetricsUtils.MACRO_SUCCEEDED_METRIC="Accessibility.CrosDictation.MacroSucceeded";MetricsUtils.MACRO_FAILED_METRIC="Accessibility.CrosDictation.MacroFailed";MetricsUtils.PUMPKIN_USED_METRIC="Accessibility.CrosDictation.UsedPumpkin";MetricsUtils.PUMPKIN_SUCCEEDED_METRIC="Accessibility.CrosDictation.PumpkinSucceeded"})(MetricsUtils$1||(MetricsUtils$1={}));class ParseStrategy{inputController_;enabled=false;constructor(inputController){this.inputController_=inputController}getInputController(){return this.inputController_}isEnabled(){return this.enabled}setEnabled(enabled){this.enabled=enabled}refresh(){}async parse(text){throw new Error(`The parse() function must be implemented by each subclass. Trying to parse text: ${text}`)}}class InputTextStrategy extends ParseStrategy{constructor(inputController){super(inputController);this.enabled=true}async parse(text){return new InputTextViewMacro(text,this.getInputController())}}class ListCommandsMacro extends Macro{constructor(){super(MacroName.LIST_COMMANDS)}run(){globalThis.open("https://support.google.com/chromebook?p=text_dictation_m100","_blank");return this.createRunMacroResult_(true)}}var FromPumpkinTaggerCommand;(function(FromPumpkinTaggerCommand){FromPumpkinTaggerCommand["READY"]="ready";FromPumpkinTaggerCommand["FULLY_INITIALIZED"]="fullyInitialized";FromPumpkinTaggerCommand["TAG_RESULTS"]="tagResults";FromPumpkinTaggerCommand["REFRESHED"]="refreshed"})(FromPumpkinTaggerCommand||(FromPumpkinTaggerCommand={}));var ToPumpkinTaggerCommand;(function(ToPumpkinTaggerCommand){ToPumpkinTaggerCommand["LOAD"]="load";ToPumpkinTaggerCommand["TAG"]="tagAndGetNBestHypotheses";ToPumpkinTaggerCommand["REFRESH"]="refresh"})(ToPumpkinTaggerCommand||(ToPumpkinTaggerCommand={}));var PumpkinLocale;(function(PumpkinLocale){PumpkinLocale["EN_US"]="en_us";PumpkinLocale["FR_FR"]="fr_fr";PumpkinLocale["IT_IT"]="it_it";PumpkinLocale["DE_DE"]="de_de";PumpkinLocale["ES_ES"]="es_es"})(PumpkinLocale||(PumpkinLocale={}));const SUPPORTED_LOCALES={"en-US":PumpkinLocale.EN_US,"en-AU":PumpkinLocale.EN_US,"en-CA":PumpkinLocale.EN_US,"en-GB":PumpkinLocale.EN_US,"en-GH":PumpkinLocale.EN_US,"en-HK":PumpkinLocale.EN_US,"en-IN":PumpkinLocale.EN_US,"en-KE":PumpkinLocale.EN_US,"en-NG":PumpkinLocale.EN_US,"en-NZ":PumpkinLocale.EN_US,"en-PH":PumpkinLocale.EN_US,"en-PK":PumpkinLocale.EN_US,"en-SG":PumpkinLocale.EN_US,"en-TZ":PumpkinLocale.EN_US,"en-ZA":PumpkinLocale.EN_US,"fr-BE":PumpkinLocale.FR_FR,"fr-CA":PumpkinLocale.FR_FR,"fr-CH":PumpkinLocale.FR_FR,"fr-FR":PumpkinLocale.FR_FR,"it-CH":PumpkinLocale.IT_IT,"it-IT":PumpkinLocale.IT_IT,"de-AT":PumpkinLocale.DE_DE,"de-CH":PumpkinLocale.DE_DE,"de-DE":PumpkinLocale.DE_DE,"es-AR":PumpkinLocale.ES_ES,"es-BO":PumpkinLocale.ES_ES,"es-CL":PumpkinLocale.ES_ES,"es-CO":PumpkinLocale.ES_ES,"es-CR":PumpkinLocale.ES_ES,"es-DO":PumpkinLocale.ES_ES,"es-EC":PumpkinLocale.ES_ES,"es-ES":PumpkinLocale.ES_ES,"es-GT":PumpkinLocale.ES_ES,"es-HN":PumpkinLocale.ES_ES,"es-MX":PumpkinLocale.ES_ES,"es-NI":PumpkinLocale.ES_ES,"es-PA":PumpkinLocale.ES_ES,"es-PE":PumpkinLocale.ES_ES,"es-PR":PumpkinLocale.ES_ES,"es-PY":PumpkinLocale.ES_ES,"es-SV":PumpkinLocale.ES_ES,"es-US":PumpkinLocale.ES_ES,"es-UY":PumpkinLocale.ES_ES,"es-VE":PumpkinLocale.ES_ES};var HypothesisArgumentName;(function(HypothesisArgumentName){HypothesisArgumentName["SEM_TAG"]="SEM_TAG";HypothesisArgumentName["NUM_ARG"]="NUM_ARG";HypothesisArgumentName["OPEN_ENDED_TEXT"]="OPEN_ENDED_TEXT";HypothesisArgumentName["BEGIN_PHRASE"]="BEGIN_PHRASE";HypothesisArgumentName["END_PHRASE"]="END_PHRASE"})(HypothesisArgumentName||(HypothesisArgumentName={}));const SANDBOXED_PUMPKIN_TAGGER_JS_FILE="dictation/parse/sandboxed_pumpkin_tagger.rollup.js";TestImportManager.exportForTesting(["SUPPORTED_LOCALES",SUPPORTED_LOCALES]);class PumpkinParseStrategy extends ParseStrategy{constructor(inputController){super(inputController);this.init_()}pumpkinData_=null;pumpkinTaggerReady_=false;tagResolver_=null;worker_=null;locale_=null;requestedPumpkinInstall_=false;onPumpkinTaggerReadyChangedForTesting_=null;init_(){this.refreshLocale_();if(!this.locale_){return}this.requestedPumpkinInstall_=true;chrome.accessibilityPrivate.installPumpkinForDictation((data=>{this.onPumpkinInstalled_(data)}))}onPumpkinInstalled_(data){if(!data){console.warn("Pumpkin installed, but data is empty");return}for(const[key,value]of Object.entries(data)){if(!value||value.byteLength===0){throw new Error(`Pumpkin data incomplete, missing data for ${key}`)}}this.refreshLocale_();if(!this.locale_||!this.isEnabled()){return}this.setPumpkinTaggerReady_(false);this.pumpkinData_=data;this.worker_=new Worker(new URL(SANDBOXED_PUMPKIN_TAGGER_JS_FILE,import.meta.url),{type:"module"});this.worker_.onmessage=message=>this.onMessage_(message)}onMessage_(message){const command=message.data;switch(command.type){case FromPumpkinTaggerCommand.READY:this.refreshLocale_();if(!this.locale_){throw new Error(`Can't load SandboxedPumpkinTagger in an unsupported locale ${LocaleInfo.locale}`)}this.sendToSandboxedPumpkinTagger_({type:ToPumpkinTaggerCommand.LOAD,locale:this.locale_,pumpkinData:this.pumpkinData_});this.pumpkinData_=null;return;case FromPumpkinTaggerCommand.FULLY_INITIALIZED:this.setPumpkinTaggerReady_(true);this.maybeRefresh_();return;case FromPumpkinTaggerCommand.TAG_RESULTS:this.tagResolver_(command.results);return;case FromPumpkinTaggerCommand.REFRESHED:this.setPumpkinTaggerReady_(true);this.maybeRefresh_();return;default:throw new Error(`Unrecognized message received from SandboxedPumpkinTagger: ${command.type}`)}}sendToSandboxedPumpkinTagger_(command){if(!this.worker_){throw new Error(`Worker not ready, cannot send command to SandboxedPumpkinTagger: ${command.type}`)}this.worker_.postMessage(command)}macroFromPumpkinHypothesis_(hypothesis){const numArgs=hypothesis.actionArgumentList.length;if(!numArgs){return null}let repeat=1;let text="";let tag=MacroName.UNSPECIFIED;let beginPhrase="";let endPhrase="";for(let i=0;i<numArgs;i++){const argument=hypothesis.actionArgumentList[i];if(argument.name===HypothesisArgumentName.SEM_TAG){if(argument.value==="STOP_LISTENING"){tag=MacroName.TOGGLE_DICTATION}else{tag=MacroName[argument.value]}}else if(argument.name===HypothesisArgumentName.NUM_ARG){repeat=argument.value}else if(argument.name===HypothesisArgumentName.OPEN_ENDED_TEXT){text=argument.value}else if(argument.name===HypothesisArgumentName.BEGIN_PHRASE){beginPhrase=argument.value}else if(argument.name===HypothesisArgumentName.END_PHRASE){endPhrase=argument.value}}switch(tag){case MacroName.INPUT_TEXT_VIEW:return new InputTextViewMacro(text,this.getInputController());case MacroName.DELETE_PREV_CHAR:return new RepeatableKeyPressMacro.DeletePreviousCharacterMacro(this.getInputController(),repeat);case MacroName.NAV_PREV_CHAR:return new RepeatableKeyPressMacro.NavPreviousCharMacro(this.getInputController(),LocaleInfo.isRTLLocale(),repeat);case MacroName.NAV_NEXT_CHAR:return new RepeatableKeyPressMacro.NavNextCharMacro(this.getInputController(),LocaleInfo.isRTLLocale(),repeat);case MacroName.NAV_PREV_LINE:return new RepeatableKeyPressMacro.NavPreviousLineMacro(this.getInputController(),repeat);case MacroName.NAV_NEXT_LINE:return new RepeatableKeyPressMacro.NavNextLineMacro(this.getInputController(),repeat);case MacroName.COPY_SELECTED_TEXT:return new RepeatableKeyPressMacro.CopySelectedTextMacro(this.getInputController());case MacroName.PASTE_TEXT:return new RepeatableKeyPressMacro.PasteTextMacro;case MacroName.CUT_SELECTED_TEXT:return new RepeatableKeyPressMacro.CutSelectedTextMacro(this.getInputController());case MacroName.UNDO_TEXT_EDIT:return new RepeatableKeyPressMacro.UndoTextEditMacro;case MacroName.REDO_ACTION:return new RepeatableKeyPressMacro.RedoActionMacro;case MacroName.SELECT_ALL_TEXT:return new RepeatableKeyPressMacro.SelectAllTextMacro(this.getInputController());case MacroName.UNSELECT_TEXT:return new RepeatableKeyPressMacro.UnselectTextMacro(this.getInputController(),LocaleInfo.isRTLLocale());case MacroName.LIST_COMMANDS:return new ListCommandsMacro;case MacroName.TOGGLE_DICTATION:return new ToggleDictationMacro(this.getInputController().isActive());case MacroName.DELETE_PREV_WORD:return new RepeatableKeyPressMacro.DeletePrevWordMacro(this.getInputController(),repeat);case MacroName.DELETE_PREV_SENT:return new DeletePrevSentMacro(this.getInputController());case MacroName.NAV_NEXT_WORD:return new RepeatableKeyPressMacro.NavNextWordMacro(this.getInputController(),LocaleInfo.isRTLLocale(),repeat);case MacroName.NAV_PREV_WORD:return new RepeatableKeyPressMacro.NavPrevWordMacro(this.getInputController(),LocaleInfo.isRTLLocale(),repeat);case MacroName.SMART_DELETE_PHRASE:return new SmartDeletePhraseMacro(this.getInputController(),text);case MacroName.SMART_REPLACE_PHRASE:return new SmartReplacePhraseMacro(this.getInputController(),beginPhrase,text);case MacroName.SMART_INSERT_BEFORE:return new SmartInsertBeforeMacro(this.getInputController(),text,endPhrase);case MacroName.SMART_SELECT_BTWN_INCL:return new SmartSelectBetweenMacro(this.getInputController(),beginPhrase,endPhrase);case MacroName.NAV_NEXT_SENT:return new NavNextSentMacro(this.getInputController());case MacroName.NAV_PREV_SENT:return new NavPrevSentMacro(this.getInputController());case MacroName.DELETE_ALL_TEXT:return new RepeatableKeyPressMacro.DeleteAllText(this.getInputController());case MacroName.NAV_START_TEXT:return new RepeatableKeyPressMacro.NavStartText(this.getInputController());case MacroName.NAV_END_TEXT:return new RepeatableKeyPressMacro.NavEndText(this.getInputController());case MacroName.SELECT_PREV_WORD:return new RepeatableKeyPressMacro.SelectPrevWord(this.getInputController(),repeat);case MacroName.SELECT_NEXT_WORD:return new RepeatableKeyPressMacro.SelectNextWord(this.getInputController(),repeat);case MacroName.SELECT_NEXT_CHAR:return new RepeatableKeyPressMacro.SelectNextChar(this.getInputController(),repeat);case MacroName.SELECT_PREV_CHAR:return new RepeatableKeyPressMacro.SelectPrevChar(this.getInputController(),repeat);case MacroName.REPEAT:return new RepeatMacro;default:console.log("Unsupported Pumpkin action: ",tag);return null}}refreshLocale_(){this.locale_=SUPPORTED_LOCALES[LocaleInfo.locale]||null}maybeRefresh_(){const dictationLocale=SUPPORTED_LOCALES[LocaleInfo.locale]||null;if(dictationLocale!==this.locale_){this.refresh()}}refresh(){this.refreshLocale_();this.enabled=Boolean(this.locale_)&&LocaleInfo.areCommandsSupported();if(!this.requestedPumpkinInstall_){this.init_();return}if(!this.isEnabled()||!this.locale_||!this.pumpkinTaggerReady_){return}this.setPumpkinTaggerReady_(false);this.sendToSandboxedPumpkinTagger_({type:ToPumpkinTaggerCommand.REFRESH,locale:this.locale_})}async parse(text){if(!this.isEnabled()||!this.pumpkinTaggerReady_){return null}this.tagResolver_=null;this.sendToSandboxedPumpkinTagger_({type:ToPumpkinTaggerCommand.TAG,text:text,numResults:1});const taggerResults=await new Promise((resolve=>{this.tagResolver_=resolve}));if(!taggerResults||taggerResults.hypothesisList.length===0){return null}return this.macroFromPumpkinHypothesis_(taggerResults.hypothesisList[0])}isEnabled(){return this.enabled}setPumpkinTaggerReady_(ready){this.pumpkinTaggerReady_=ready;if(this.onPumpkinTaggerReadyChangedForTesting_){this.onPumpkinTaggerReadyChangedForTesting_()}}}class SimpleMacroFactory{macroName_;inputController_;commandRegex_=null;constructor(macroName,inputController){if(!SimpleMacroFactory.getData_()[macroName]){throw new Error("Macro is not supported by SimpleMacroFactory: "+macroName)}this.macroName_=macroName;this.inputController_=inputController;this.initializeCommandRegex_(this.macroName_)}initializeCommandRegex_(macroName){const matchAnythingPattern="(.*)";const args=[];switch(macroName){case MacroName.INPUT_TEXT_VIEW:case MacroName.SMART_DELETE_PHRASE:args.push(matchAnythingPattern);break;case MacroName.SMART_REPLACE_PHRASE:case MacroName.SMART_INSERT_BEFORE:case MacroName.SMART_SELECT_BTWN_INCL:args.push(matchAnythingPattern,matchAnythingPattern);break}const message=chrome.i18n.getMessage(SimpleMacroFactory.getData_()[macroName].messageId,args);const pattern=`^${message}$`;if(LocaleInfo.considerSpaces()){this.commandRegex_=new RegExp(pattern,"i")}else{this.commandRegex_=new RegExp(pattern.replace(/\s+/g,""),"i")}}createMacro(text){text=text.trim().toLowerCase();if(!this.commandRegex_.test(text)){return null}const initialArgs=[];switch(this.macroName_){case MacroName.COPY_SELECTED_TEXT:case MacroName.CUT_SELECTED_TEXT:case MacroName.DELETE_ALL_TEXT:case MacroName.DELETE_PREV_CHAR:case MacroName.DELETE_PREV_SENT:case MacroName.DELETE_PREV_WORD:case MacroName.NAV_END_TEXT:case MacroName.NAV_NEXT_CHAR:case MacroName.NAV_NEXT_LINE:case MacroName.NAV_NEXT_SENT:case MacroName.NAV_NEXT_WORD:case MacroName.NAV_START_TEXT:case MacroName.NAV_PREV_CHAR:case MacroName.NAV_PREV_LINE:case MacroName.NAV_PREV_SENT:case MacroName.NAV_PREV_WORD:case MacroName.NEW_LINE:case MacroName.SELECT_ALL_TEXT:case MacroName.SELECT_NEXT_CHAR:case MacroName.SELECT_NEXT_WORD:case MacroName.SELECT_PREV_CHAR:case MacroName.SELECT_PREV_WORD:case MacroName.SMART_DELETE_PHRASE:case MacroName.SMART_INSERT_BEFORE:case MacroName.SMART_REPLACE_PHRASE:case MacroName.SMART_SELECT_BTWN_INCL:case MacroName.UNSELECT_TEXT:initialArgs.push(this.inputController_);break}const result=this.commandRegex_.exec(text);if(!result){return null}const extractedArgs=result.slice(1);const finalArgs=initialArgs.concat(extractedArgs);const data=SimpleMacroFactory.getData_();const macro=new data[this.macroName_].build(...finalArgs);if(macro.isSmart()&&!LocaleInfo.allowSmartEditing()){return null}return macro}static getData_(){return{[MacroName.DELETE_PREV_CHAR]:{messageId:"dictation_command_delete_prev_char",build:RepeatableKeyPressMacro.DeletePreviousCharacterMacro},[MacroName.NAV_PREV_CHAR]:{messageId:"dictation_command_nav_prev_char",build:RepeatableKeyPressMacro.NavPreviousCharMacro},[MacroName.NAV_NEXT_CHAR]:{messageId:"dictation_command_nav_next_char",build:RepeatableKeyPressMacro.NavNextCharMacro},[MacroName.NAV_PREV_LINE]:{messageId:"dictation_command_nav_prev_line",build:RepeatableKeyPressMacro.NavPreviousLineMacro},[MacroName.NAV_NEXT_LINE]:{messageId:"dictation_command_nav_next_line",build:RepeatableKeyPressMacro.NavNextLineMacro},[MacroName.COPY_SELECTED_TEXT]:{messageId:"dictation_command_copy_selected_text",build:RepeatableKeyPressMacro.CopySelectedTextMacro},[MacroName.PASTE_TEXT]:{messageId:"dictation_command_paste_text",build:RepeatableKeyPressMacro.PasteTextMacro},[MacroName.CUT_SELECTED_TEXT]:{messageId:"dictation_command_cut_selected_text",build:RepeatableKeyPressMacro.CutSelectedTextMacro},[MacroName.UNDO_TEXT_EDIT]:{messageId:"dictation_command_undo_text_edit",build:RepeatableKeyPressMacro.UndoTextEditMacro},[MacroName.REDO_ACTION]:{messageId:"dictation_command_redo_action",build:RepeatableKeyPressMacro.RedoActionMacro},[MacroName.SELECT_ALL_TEXT]:{messageId:"dictation_command_select_all_text",build:RepeatableKeyPressMacro.SelectAllTextMacro},[MacroName.UNSELECT_TEXT]:{messageId:"dictation_command_unselect_text",build:RepeatableKeyPressMacro.UnselectTextMacro},[MacroName.LIST_COMMANDS]:{messageId:"dictation_command_list_commands",build:ListCommandsMacro},[MacroName.NEW_LINE]:{messageId:"dictation_command_new_line",build:NewLineMacro},[MacroName.TOGGLE_DICTATION]:{messageId:"dictation_command_stop_listening",build:ToggleDictationMacro},[MacroName.DELETE_PREV_WORD]:{messageId:"dictation_command_delete_prev_word",build:RepeatableKeyPressMacro.DeletePrevWordMacro},[MacroName.DELETE_PREV_SENT]:{messageId:"dictation_command_delete_prev_sent",build:DeletePrevSentMacro},[MacroName.NAV_NEXT_WORD]:{messageId:"dictation_command_nav_next_word",build:RepeatableKeyPressMacro.NavNextWordMacro},[MacroName.NAV_PREV_WORD]:{messageId:"dictation_command_nav_prev_word",build:RepeatableKeyPressMacro.NavPrevWordMacro},[MacroName.SMART_DELETE_PHRASE]:{messageId:"dictation_command_smart_delete_phrase",build:SmartDeletePhraseMacro},[MacroName.SMART_REPLACE_PHRASE]:{messageId:"dictation_command_smart_replace_phrase",build:SmartReplacePhraseMacro},[MacroName.SMART_INSERT_BEFORE]:{messageId:"dictation_command_smart_insert_before",build:SmartInsertBeforeMacro},[MacroName.SMART_SELECT_BTWN_INCL]:{messageId:"dictation_command_smart_select_btwn_incl",build:SmartSelectBetweenMacro},[MacroName.NAV_NEXT_SENT]:{messageId:"dictation_command_nav_next_sent",build:NavNextSentMacro},[MacroName.NAV_PREV_SENT]:{messageId:"dictation_command_nav_prev_sent",build:NavPrevSentMacro}}}}class SimpleParseStrategy extends ParseStrategy{macroFactoryMap_=new Map;supportedMacros_=new Set;constructor(inputController){super(inputController);this.initialize_()}initialize_(){this.supportedMacros_.add(MacroName.DELETE_PREV_CHAR).add(MacroName.NAV_PREV_CHAR).add(MacroName.NAV_NEXT_CHAR).add(MacroName.NAV_PREV_LINE).add(MacroName.NAV_NEXT_LINE).add(MacroName.COPY_SELECTED_TEXT).add(MacroName.PASTE_TEXT).add(MacroName.CUT_SELECTED_TEXT).add(MacroName.UNDO_TEXT_EDIT).add(MacroName.REDO_ACTION).add(MacroName.SELECT_ALL_TEXT).add(MacroName.UNSELECT_TEXT).add(MacroName.LIST_COMMANDS).add(MacroName.NEW_LINE).add(MacroName.TOGGLE_DICTATION).add(MacroName.DELETE_PREV_WORD).add(MacroName.DELETE_PREV_SENT).add(MacroName.NAV_NEXT_WORD).add(MacroName.NAV_PREV_WORD).add(MacroName.SMART_DELETE_PHRASE).add(MacroName.SMART_REPLACE_PHRASE).add(MacroName.SMART_INSERT_BEFORE).add(MacroName.SMART_SELECT_BTWN_INCL).add(MacroName.NAV_NEXT_SENT).add(MacroName.NAV_PREV_SENT);this.supportedMacros_.forEach((name=>{this.macroFactoryMap_.set(name,new SimpleMacroFactory(name,this.getInputController()))}))}refresh(){this.enabled=LocaleInfo.areCommandsSupported();if(!this.enabled){return}this.macroFactoryMap_=new Map;this.initialize_()}async parse(text){const macros=[];for(const[_,factory]of this.macroFactoryMap_){const macro=factory.createMacro(text);if(macro){macros.push(macro)}}if(macros.length===1){return macros[0]}else if(macros.length===2){return macros[0].getName()===MacroName.SMART_DELETE_PHRASE?macros[1]:macros[0]}else if(macros.length>2){console.warn(`Unexpected ambiguous macros found for text: ${text}.`);return macros[0]}const typePrefix=chrome.i18n.getMessage("dictation_command_input_text_view");if(text.trim().toLowerCase().startsWith(typePrefix)){text=text.toLowerCase().replace(typePrefix,"").trimStart()}return new InputTextViewMacro(text,this.getInputController())}}class SpeechParser{inputController_;inputTextStrategy_;simpleParseStrategy_;pumpkinParseStrategy_;constructor(inputController){this.inputController_=inputController;this.inputTextStrategy_=new InputTextStrategy(this.inputController_);this.simpleParseStrategy_=new SimpleParseStrategy(this.inputController_);this.pumpkinParseStrategy_=new PumpkinParseStrategy(this.inputController_)}refresh(){this.simpleParseStrategy_.refresh();this.pumpkinParseStrategy_.refresh()}async parse(text){if(this.pumpkinParseStrategy_.isEnabled()){MetricsUtils$1.recordPumpkinUsed(true);const macro=await this.pumpkinParseStrategy_.parse(text);MetricsUtils$1.recordPumpkinSucceeded(Boolean(macro));if(macro){return macro}}if(this.simpleParseStrategy_.isEnabled()){MetricsUtils$1.recordPumpkinUsed(false);return await this.simpleParseStrategy_.parse(text)}MetricsUtils$1.recordPumpkinUsed(false);return await this.inputTextStrategy_.parse(text)}disablePumpkinForTesting(){this.pumpkinParseStrategy_.setEnabled(false)}}TestImportManager.exportForTesting(SpeechParser);var HintType=chrome.accessibilityPrivate.DictationBubbleHintType;var IconType=chrome.accessibilityPrivate.DictationBubbleIconType;var UIState;(function(UIState){UIState["STANDBY"]="standby";UIState["RECOGNIZING_TEXT"]="recognizing_text";UIState["MACRO_SUCCESS"]="macro_success";UIState["MACRO_FAIL"]="macro_fail";UIState["HIDDEN"]="hidden"})(UIState||(UIState={}));var HintContext;(function(HintContext){HintContext["STANDBY"]="standby";HintContext["TEXT_COMMITTED"]="text_committed";HintContext["TEXT_SELECTED"]="text_selected";HintContext["MACRO_SUCCESS"]="macro_success"})(HintContext||(HintContext={}));class UIController{showHintsTimeoutId_=null;showHintsTimeoutMs_=UIController.HintsTimeouts.STANDARD_HINT_TIMEOUT_MS_;setState(state,properties){const props=properties||{};const{text:text,context:context}=props;this.clearHintsTimeout_();switch(state){case UIState.STANDBY:chrome.accessibilityPrivate.updateDictationBubble({visible:true,icon:IconType.STANDBY});break;case UIState.RECOGNIZING_TEXT:chrome.accessibilityPrivate.updateDictationBubble({visible:true,icon:IconType.HIDDEN,text:text});break;case UIState.MACRO_SUCCESS:chrome.accessibilityPrivate.updateDictationBubble({visible:true,icon:IconType.MACRO_SUCCESS,text:text});break;case UIState.MACRO_FAIL:chrome.accessibilityPrivate.updateDictationBubble({visible:true,icon:IconType.MACRO_FAIL,text:text});break;case UIState.HIDDEN:chrome.accessibilityPrivate.updateDictationBubble({visible:false,icon:IconType.HIDDEN});break}if(!context||!LocaleInfo.areCommandsSupported()){return}const hints=UIController.getHintsForContext_(context);this.showHintsTimeoutId_=setTimeout((()=>this.showHints_(hints)),this.showHintsTimeoutMs_)}clearHintsTimeout_(){if(this.showHintsTimeoutId_!==null){clearTimeout(this.showHintsTimeoutId_);this.showHintsTimeoutId_=null}}showHints_(hints){chrome.accessibilityPrivate.updateDictationBubble({visible:true,icon:IconType.STANDBY,hints:hints})}setHintsTimeoutDuration(longerDuration){this.showHintsTimeoutMs_=longerDuration?UIController.HintsTimeouts.LONGER_HINT_TIMEOUT_MS_:UIController.HintsTimeouts.STANDARD_HINT_TIMEOUT_MS_}static getHintsForContext_(context){return UIController.CONTEXT_TO_HINTS_MAP_[context]}}(function(UIController){UIController.HintsTimeouts={STANDARD_HINT_TIMEOUT_MS_:2*1e3,LONGER_HINT_TIMEOUT_MS_:6*1e3};UIController.CONTEXT_TO_HINTS_MAP_={[HintContext.STANDBY]:[HintType.TRY_SAYING,HintType.TYPE,HintType.HELP],[HintContext.TEXT_COMMITTED]:[HintType.TRY_SAYING,HintType.UNDO,HintType.DELETE,HintType.SELECT_ALL,HintType.HELP],[HintContext.TEXT_SELECTED]:[HintType.TRY_SAYING,HintType.UNSELECT,HintType.COPY,HintType.DELETE,HintType.HELP],[HintContext.MACRO_SUCCESS]:[HintType.TRY_SAYING,HintType.UNDO,HintType.HELP]}})(UIController||(UIController={}));TestImportManager.exportForTesting(UIController);var StreamType=chrome.audio.StreamType;var SpeechRecognitionType=chrome.speechRecognitionPrivate.SpeechRecognitionType;var ToastType=chrome.accessibilityPrivate.ToastType;class Dictation{inputController_=null;uiController_=null;speechParser_=null;active_=false;cancelTone_=new Audio("dictation/earcons/null_selection.wav");startTone_=new Audio("dictation/earcons/audio_initiate.wav");endTone_=new Audio("dictation/earcons/audio_end.wav");noSpeechTimeoutMs_=Dictation.Timeouts.NO_SPEECH_NETWORK_MS;stopTimeoutId_=null;interimText_="";chromeVoxEnabled_=false;speechRecognitionOptions_=null;metricsUtils_=null;focusHandler_=null;speechRecognitionStopListener_=null;speechRecognitionResultListener_=null;speechRecognitionErrorListener_=null;prefsListener_=null;onToggleDictationListener_=null;isContextCheckingFeatureEnabled_=false;prevMacro_=null;constructor(){this.initialize_()}initialize_(){this.focusHandler_=new FocusHandler;this.inputController_=new InputControllerImpl((()=>this.stopDictation_(true)),this.focusHandler_);this.uiController_=new UIController;this.speechParser_=new SpeechParser(this.inputController_);this.speechParser_.refresh();this.speechRecognitionOptions_={locale:"en-US",interimResults:true};this.speechRecognitionStopListener_=()=>this.onSpeechRecognitionStopped_();this.speechRecognitionResultListener_=event=>this.onSpeechRecognitionResult_(event);this.speechRecognitionErrorListener_=()=>this.onSpeechRecognitionError_();this.prefsListener_=prefs=>this.updateFromPrefs_(prefs);this.onToggleDictationListener_=activated=>this.onToggleDictation_(activated);chrome.speechRecognitionPrivate.onStop.addListener(this.speechRecognitionStopListener_);chrome.speechRecognitionPrivate.onResult.addListener(this.speechRecognitionResultListener_);chrome.speechRecognitionPrivate.onError.addListener(this.speechRecognitionErrorListener_);chrome.settingsPrivate.getAllPrefs((prefs=>this.updateFromPrefs_(prefs)));chrome.settingsPrivate.onPrefsChanged.addListener(this.prefsListener_);chrome.accessibilityPrivate.onToggleDictation.addListener(this.onToggleDictationListener_);const contextCheckingFeature=chrome.accessibilityPrivate.AccessibilityFeature.DICTATION_CONTEXT_CHECKING;chrome.accessibilityPrivate.isFeatureEnabled(contextCheckingFeature,(enabled=>{this.isContextCheckingFeatureEnabled_=enabled}))}onDictationDisabled(){if(this.speechRecognitionStopListener_){chrome.speechRecognitionPrivate.onStop.removeListener(this.speechRecognitionStopListener_)}if(this.speechRecognitionResultListener_){chrome.speechRecognitionPrivate.onResult.removeListener(this.speechRecognitionResultListener_)}if(this.speechRecognitionErrorListener_){chrome.speechRecognitionPrivate.onError.removeListener(this.speechRecognitionErrorListener_)}if(this.prefsListener_){chrome.settingsPrivate.onPrefsChanged.removeListener(this.prefsListener_)}if(this.onToggleDictationListener_){chrome.accessibilityPrivate.onToggleDictation.removeListener(this.onToggleDictationListener_)}if(this.inputController_){this.inputController_.removeListeners()}}isActive(){return this.active_}onToggleDictation_(activated){if(activated&&!this.active_){this.startDictation_()}else{this.stopDictation_(false)}}startDictation_(){this.active_=true;if(this.chromeVoxEnabled_){chrome.accessibilityPrivate.silenceSpokenFeedback()}this.setStopTimeout_(Dictation.Timeouts.NO_FOCUSED_IME_MS,Dictation.StopReason.NO_FOCUSED_IME);this.inputController_.connect((()=>this.verifyMicrophoneNotMuted_()))}verifyMicrophoneNotMuted_(){if(!this.active_){this.stopDictation_(true);return}chrome.audio.getMute(StreamType.INPUT,(muted=>{if(muted){this.stopDictation_(true);chrome.accessibilityPrivate.showToast(ToastType.DICTATION_MIC_MUTED);return}this.maybeStartSpeechRecognition_()}))}maybeStartSpeechRecognition_(){if(this.active_){chrome.speechRecognitionPrivate.start(this.speechRecognitionOptions_,(type=>this.onSpeechRecognitionStarted_(type)))}else{this.stopDictation_(true)}}stopDictation_(notify){if(!this.active_){return}this.active_=false;chrome.speechRecognitionPrivate.stop({},(()=>{}));if(this.interimText_){this.endTone_.play()}else{this.cancelTone_.play()}this.clearStopTimeout_();this.inputController_.commitText(this.interimText_);this.hideCommandsUI_();this.inputController_.disconnect();Dictation.removeAsInputMethod();if(notify){chrome.accessibilityPrivate.toggleDictation()}}setStopTimeout_(durationMs,reason){if(this.stopTimeoutId_!==null){clearTimeout(this.stopTimeoutId_)}this.stopTimeoutId_=setTimeout((()=>{this.stopDictation_(true);if(reason===Dictation.StopReason.NO_FOCUSED_IME){chrome.accessibilityPrivate.showToast(ToastType.DICTATION_NO_FOCUSED_TEXT_FIELD)}}),durationMs)}async onSpeechRecognitionResult_(event){if(!this.active_){return}const transcript=event.transcript;const isFinal=event.isFinal;this.setStopTimeout_(isFinal?this.noSpeechTimeoutMs_:Dictation.Timeouts.NO_NEW_SPEECH_MS);await this.processSpeechRecognitionResult_(transcript,isFinal)}async processSpeechRecognitionResult_(transcript,isFinal){if(!isFinal){this.showInterimText_(transcript);return}let macro=await this.speechParser_.parse(transcript);MetricsUtils$1.recordMacroRecognized(macro);macro=this.handleRepeat_(macro);const checkContextResult=macro.checkContext();if(!checkContextResult.canTryAction&&this.isContextCheckingFeatureEnabled_){this.showMacroExecutionFailed_(macro,transcript,checkContextResult.failedContext);return}const runMacroResult=macro.run();if(!runMacroResult.isSuccess){this.showMacroExecutionFailed_(macro,transcript);return}if(macro.getName()===MacroName.LIST_COMMANDS){return}this.showMacroExecuted_(macro,transcript)}onSpeechRecognitionStarted_(type){if(chrome.runtime.lastError){this.stopDictation_(true);return}if(!this.active_){return}this.noSpeechTimeoutMs_=type===SpeechRecognitionType.NETWORK?Dictation.Timeouts.NO_SPEECH_NETWORK_MS:Dictation.Timeouts.NO_SPEECH_ONDEVICE_MS;this.setStopTimeout_(this.noSpeechTimeoutMs_);this.startTone_.play();this.clearInterimText_();this.metricsUtils_=new MetricsUtils$1(type,LocaleInfo.locale);this.metricsUtils_.recordSpeechRecognitionStarted();this.uiController_.setState(UIState.STANDBY,{context:HintContext.STANDBY});this.focusHandler_.refresh()}onSpeechRecognitionStopped_(){if(this.metricsUtils_!==null){this.metricsUtils_.recordSpeechRecognitionStopped()}this.metricsUtils_=null;this.stopDictation_(true)}onSpeechRecognitionError_(){this.stopDictation_(true)}updateFromPrefs_(prefs){prefs.forEach((pref=>{switch(pref.key){case Dictation.DICTATION_LOCALE_PREF:if(pref.value){const locale=pref.value;this.speechRecognitionOptions_.locale=locale;LocaleInfo.locale=locale;this.speechParser_.refresh()}break;case Dictation.SPOKEN_FEEDBACK_PREF:if(pref.value){this.chromeVoxEnabled_=true}else{this.chromeVoxEnabled_=false}this.uiController_.setHintsTimeoutDuration(this.chromeVoxEnabled_);break;default:return}}))}showInterimText_(text){this.interimText_=text;this.uiController_.setState(UIState.RECOGNIZING_TEXT,{text:text})}clearInterimText_(){this.interimText_="";this.uiController_.setState(UIState.STANDBY)}showMacroExecuted_(macro,transcript){MetricsUtils$1.recordMacroSucceeded(macro);if(macro.getName()===MacroName.INPUT_TEXT_VIEW||macro.getName()===MacroName.NEW_LINE){this.clearInterimText_();this.uiController_.setState(UIState.STANDBY,{context:HintContext.TEXT_COMMITTED});return}this.interimText_="";const context=macro.getName()===MacroName.SELECT_ALL_TEXT?HintContext.TEXT_SELECTED:HintContext.MACRO_SUCCESS;this.uiController_.setState(UIState.MACRO_SUCCESS,{text:transcript,context:context})}showMacroExecutionFailed_(macro,transcript,failedContext){MetricsUtils$1.recordMacroFailed(macro);this.interimText_="";let text="";if(!failedContext){text=chrome.i18n.getMessage("dictation_command_failed_generic",[transcript])}else{const reason=Dictation.getFailedContextReason(failedContext);text=chrome.i18n.getMessage("dictation_command_failed_with_reason",[transcript,reason])}this.uiController_.setState(UIState.MACRO_FAIL,{text:text,context:HintContext.STANDBY})}hideCommandsUI_(){this.interimText_="";this.uiController_.setState(UIState.HIDDEN)}clearStopTimeout_(){if(this.stopTimeoutId_!==null){clearTimeout(this.stopTimeoutId_);this.stopTimeoutId_=null}}static removeAsInputMethod(){chrome.languageSettingsPrivate.removeInputMethod(InputControllerImpl.IME_ENGINE_ID)}setNoFocusedImeTimeoutForTesting(duration){Dictation.Timeouts.NO_FOCUSED_IME_MS=duration}handleRepeat_(macro){if(macro.getName()!==MacroName.REPEAT){this.prevMacro_=macro;return macro}if(!this.prevMacro_){return macro}return this.prevMacro_}disablePumpkinForTesting(){this.speechParser_.disablePumpkinForTesting()}static getFailedContextReason(context){switch(context){case Context.INACTIVE_INPUT_CONTROLLER:return chrome.i18n.getMessage("dictation_context_error_reason_inactive_input_controller");case Context.EMPTY_EDITABLE:return chrome.i18n.getMessage("dictation_context_error_reason_empty_editable");case Context.NO_SELECTION:return chrome.i18n.getMessage("dictation_context_error_reason_no_selection");case Context.INVALID_INPUT:return chrome.i18n.getMessage("dictation_context_error_reason_invalid_input");case Context.NO_PREVIOUS_MACRO:return chrome.i18n.getMessage("dictation_context_error_reason_no_previous_macro")}throw new Error("Cannot get error message for unsupported context: "+context)}}(function(Dictation){Dictation.DICTATION_LOCALE_PREF="settings.a11y.dictation_locale";Dictation.SPOKEN_FEEDBACK_PREF="settings.accessibility";Dictation.Timeouts={NO_SPEECH_NETWORK_MS:10*1e3,NO_SPEECH_ONDEVICE_MS:20*1e3,NO_NEW_SPEECH_MS:5*1e3,NO_FOCUSED_IME_MS:1e3};(function(StopReason){StopReason["NO_FOCUSED_IME"]="Dictation stopped automatically: No focused IME"})(Dictation.StopReason||(Dictation.StopReason={}))})(Dictation||(Dictation={}));TestImportManager.exportForTesting(Dictation);var FacialGesture;(function(FacialGesture){FacialGesture["BROW_INNER_UP"]="browInnerUp";FacialGesture["BROWS_DOWN"]="browsDown";FacialGesture["EYE_SQUINT_LEFT"]="eyeSquintLeft";FacialGesture["EYE_SQUINT_RIGHT"]="eyeSquintRight";FacialGesture["EYES_BLINK"]="eyesBlink";FacialGesture["EYES_LOOK_DOWN"]="eyesLookDown";FacialGesture["EYES_LOOK_LEFT"]="eyesLookLeft";FacialGesture["EYES_LOOK_RIGHT"]="eyesLookRight";FacialGesture["EYES_LOOK_UP"]="eyesLookUp";FacialGesture["JAW_LEFT"]="jawLeft";FacialGesture["JAW_OPEN"]="jawOpen";FacialGesture["JAW_RIGHT"]="jawRight";FacialGesture["MOUTH_FUNNEL"]="mouthFunnel";FacialGesture["MOUTH_LEFT"]="mouthLeft";FacialGesture["MOUTH_PUCKER"]="mouthPucker";FacialGesture["MOUTH_RIGHT"]="mouthRight";FacialGesture["MOUTH_SMILE"]="mouthSmile";FacialGesture["MOUTH_UPPER_UP"]="mouthUpperUp"})(FacialGesture||(FacialGesture={}));class BubbleController{resetBubbleTimeoutId_;baseText_=[];getState_;constructor(getState){this.getState_=getState}updateBubble(text){chrome.accessibilityPrivate.updateFaceGazeBubble(text,false);this.setResetBubbleTimeout_()}setResetBubbleTimeout_(){this.clearTimeout_();this.resetBubbleTimeoutId_=setTimeout((()=>this.resetBubble()),BubbleController.RESET_BUBBLE_TIMEOUT_MS)}clearTimeout_(){if(this.resetBubbleTimeoutId_!==undefined){clearTimeout(this.resetBubbleTimeoutId_);this.resetBubbleTimeoutId_=undefined}}resetBubble(){this.baseText_=[];const{paused:paused,scrollMode:scrollMode,longClick:longClick,dictation:dictation,heldMacros:heldMacros,precision:precision,isFaceLandmarkerResultValid:isFaceLandmarkerResultValid,isCameraMuted:isCameraMuted}=this.getState_();if(isFaceLandmarkerResultValid!==undefined&&!isFaceLandmarkerResultValid){this.baseText_.push(chrome.i18n.getMessage("facegaze_invalid_result"))}if(isCameraMuted){this.baseText_.push(chrome.i18n.getMessage("facegaze_camera_muted"))}if(heldMacros){heldMacros.forEach((displayText=>{this.baseText_.push(displayText)}))}if(precision){this.baseText_.push(chrome.i18n.getMessage("facegaze_state_precision_active",BubbleController.getDisplayTextForGesture_(precision)))}if(paused){this.baseText_.push(chrome.i18n.getMessage("facegaze_state_paused",BubbleController.getDisplayTextForGesture_(paused)))}else if(scrollMode){this.baseText_.push(chrome.i18n.getMessage("facegaze_state_scroll_active",BubbleController.getDisplayTextForGesture_(scrollMode)))}else if(longClick){this.baseText_.push(chrome.i18n.getMessage("facegaze_state_long_click_active",BubbleController.getDisplayTextForGesture_(longClick)))}else if(dictation){this.baseText_.push(chrome.i18n.getMessage("facegaze_state_dictation_active",BubbleController.getDisplayTextForGesture_(dictation)))}const isWarning=this.baseText_.length>0;if(this.baseText_.length===0){this.baseText_.push(chrome.i18n.getMessage("facegaze_active"))}chrome.accessibilityPrivate.updateFaceGazeBubble(this.baseText_.join(", "),isWarning)}static getDisplayText(gesture,macro){if(macro.getName()===MacroName.TOGGLE_PRECISION_CLICK&&macro.getToggleDirection()===ToggleDirection.OFF){return undefined}return chrome.i18n.getMessage("facegaze_display_text",[BubbleController.getDisplayTextForMacro_(macro),BubbleController.getDisplayTextForGesture_(gesture)])}static getDisplayTextForMacro_(macro){const macroName=macro.getName();switch(macroName){case MacroName.CUSTOM_KEY_COMBINATION:return chrome.i18n.getMessage("facegaze_macro_text_custom_key_combo",this.getDisplayTextForKeyCombo_(macro));case MacroName.KEY_PRESS_DOWN:return chrome.i18n.getMessage("facegaze_macro_text_key_press_down");case MacroName.KEY_PRESS_LEFT:return chrome.i18n.getMessage("facegaze_macro_text_key_press_left");case MacroName.KEY_PRESS_MEDIA_PLAY_PAUSE:return chrome.i18n.getMessage("facegaze_macro_text_media_play_pause");case MacroName.KEY_PRESS_RIGHT:return chrome.i18n.getMessage("facegaze_macro_text_key_press_right");case MacroName.KEY_PRESS_SCREENSHOT:return chrome.i18n.getMessage("facegaze_macro_text_screenshot");case MacroName.KEY_PRESS_SPACE:return chrome.i18n.getMessage("facegaze_macro_text_key_press_space");case MacroName.KEY_PRESS_TOGGLE_OVERVIEW:return chrome.i18n.getMessage("facegaze_macro_text_toggle_overview");case MacroName.KEY_PRESS_UP:return chrome.i18n.getMessage("facegaze_macro_text_key_press_up");case MacroName.MOUSE_CLICK_LEFT:return chrome.i18n.getMessage("facegaze_macro_text_mouse_click_left");case MacroName.MOUSE_CLICK_LEFT_DOUBLE:return chrome.i18n.getMessage("facegaze_macro_text_mouse_click_left_double");case MacroName.MOUSE_CLICK_LEFT_TRIPLE:return chrome.i18n.getMessage("facegaze_macro_text_mouse_click_left_triple");case MacroName.MOUSE_CLICK_RIGHT:return chrome.i18n.getMessage("facegaze_macro_text_mouse_click_right");case MacroName.MOUSE_LONG_CLICK_LEFT:return macro.getToggleDirection()===ToggleDirection.ON?chrome.i18n.getMessage("facegaze_macro_text_mouse_long_click_left_on"):chrome.i18n.getMessage("facegaze_macro_text_mouse_long_click_left_off");case MacroName.RESET_CURSOR:return chrome.i18n.getMessage("facegaze_macro_text_reset_cursor");case MacroName.TOGGLE_DICTATION:return macro.getToggleDirection()===ToggleDirection.ON?chrome.i18n.getMessage("facegaze_macro_text_toggle_dictation_on"):chrome.i18n.getMessage("facegaze_macro_text_toggle_dictation_off");case MacroName.TOGGLE_FACEGAZE:return macro.getToggleDirection()===ToggleDirection.ON?chrome.i18n.getMessage("facegaze_macro_text_toggle_facegaze_on"):chrome.i18n.getMessage("facegaze_macro_text_toggle_facegaze_off");case MacroName.TOGGLE_PRECISION_CLICK:return chrome.i18n.getMessage("facegaze_macro_text_toggle_precision_on");case MacroName.TOGGLE_SCROLL_MODE:return macro.getToggleDirection()===ToggleDirection.ON?chrome.i18n.getMessage("facegaze_macro_text_toggle_scroll_mode_on"):chrome.i18n.getMessage("facegaze_macro_text_toggle_scroll_mode_off");case MacroName.TOGGLE_VIRTUAL_KEYBOARD:return chrome.i18n.getMessage("facegaze_macro_text_toggle_virtual_keyboard");default:console.error(`Display text requested for unsupported macro ${macroName}`);return""}}static getDisplayTextForKeyCombo_(macro){const keyCombo=macro.getKeyCombination();if(!keyCombo||!keyCombo.keyDisplay){console.error(`Key combo text requested for unsupported macro ${macro.getName()}`);return""}const keys=[];if(keyCombo.modifiers?.ctrl){keys.push(chrome.i18n.getMessage("facegaze_macro_text_key_ctrl"))}if(keyCombo.modifiers?.alt){keys.push(chrome.i18n.getMessage("facegaze_macro_text_key_alt"))}if(keyCombo.modifiers?.shift){keys.push(chrome.i18n.getMessage("facegaze_macro_text_key_shift"))}if(keyCombo.modifiers?.search){keys.push(chrome.i18n.getMessage("facegaze_macro_text_key_search"))}keys.push(keyCombo.keyDisplay);switch(keys.length){case 2:return chrome.i18n.getMessage("facegaze_macro_text_keyboard_combo_one_modifier",keys);case 3:return chrome.i18n.getMessage("facegaze_macro_text_keyboard_combo_two_modifiers",keys);case 4:return chrome.i18n.getMessage("facegaze_macro_text_keyboard_combo_three_modifiers",keys);case 5:return chrome.i18n.getMessage("facegaze_macro_text_keyboard_combo_four_modifiers",keys);default:return keyCombo.keyDisplay}}static getDisplayTextForGesture_(gesture){switch(gesture){case FacialGesture.BROW_INNER_UP:return chrome.i18n.getMessage("facegaze_gesture_text_brow_inner_up");case FacialGesture.BROWS_DOWN:return chrome.i18n.getMessage("facegaze_gesture_text_brows_down");case FacialGesture.EYE_SQUINT_LEFT:return chrome.i18n.getMessage("facegaze_gesture_text_eye_squint_left");case FacialGesture.EYE_SQUINT_RIGHT:return chrome.i18n.getMessage("facegaze_gesture_text_eye_squint_right");case FacialGesture.EYES_BLINK:return chrome.i18n.getMessage("facegaze_gesture_text_eyes_blink");case FacialGesture.EYES_LOOK_DOWN:return chrome.i18n.getMessage("facegaze_gesture_text_eyes_look_down");case FacialGesture.EYES_LOOK_LEFT:return chrome.i18n.getMessage("facegaze_gesture_text_eyes_look_left");case FacialGesture.EYES_LOOK_RIGHT:return chrome.i18n.getMessage("facegaze_gesture_text_eyes_look_right");case FacialGesture.EYES_LOOK_UP:return chrome.i18n.getMessage("facegaze_gesture_text_eyes_look_up");case FacialGesture.JAW_LEFT:return chrome.i18n.getMessage("facegaze_gesture_text_jaw_left");case FacialGesture.JAW_OPEN:return chrome.i18n.getMessage("facegaze_gesture_text_jaw_open");case FacialGesture.JAW_RIGHT:return chrome.i18n.getMessage("facegaze_gesture_text_jaw_right");case FacialGesture.MOUTH_FUNNEL:return chrome.i18n.getMessage("facegaze_gesture_text_mouth_funnel");case FacialGesture.MOUTH_LEFT:return chrome.i18n.getMessage("facegaze_gesture_text_mouth_left");case FacialGesture.MOUTH_PUCKER:return chrome.i18n.getMessage("facegaze_gesture_text_mouth_pucker");case FacialGesture.MOUTH_RIGHT:return chrome.i18n.getMessage("facegaze_gesture_text_mouth_right");case FacialGesture.MOUTH_SMILE:return chrome.i18n.getMessage("facegaze_gesture_text_mouth_smile");case FacialGesture.MOUTH_UPPER_UP:return chrome.i18n.getMessage("facegaze_gesture_text_mouth_upper_up");default:console.error("Display text requested for unsupported FacialGesture "+gesture);return""}}}(function(BubbleController){BubbleController.RESET_BUBBLE_TIMEOUT_MS=2500})(BubbleController||(BubbleController={}));TestImportManager.exportForTesting(BubbleController);const SettingsPath="manageAccessibility/faceGaze";var PrefNames;(function(PrefNames){PrefNames["ACCELERATOR_DIALOG_HAS_BEEN_ACCEPTED"]="settings.a11y.face_gaze.accelerator_dialog_has_been_accepted";PrefNames["ACTIONS_ENABLED"]="settings.a11y.face_gaze.actions_enabled";PrefNames["ACTIONS_ENABLED_SENTINEL"]="settings.a11y.face_gaze.actions_enabled_sentinel";PrefNames["CURSOR_CONTROL_ENABLED"]="settings.a11y.face_gaze.cursor_control_enabled";PrefNames["CURSOR_CONTROL_ENABLED_SENTINEL"]="settings.a11y.face_gaze.cursor_control_enabled_sentinel";PrefNames["CURSOR_USE_ACCELERATION"]="settings.a11y.face_gaze.cursor_use_acceleration";PrefNames["FACE_GAZE_ENABLED"]="settings.a11y.face_gaze.enabled";PrefNames["FACE_GAZE_ENABLED_SENTINEL"]="settings.a11y.face_gaze.enabled_sentinel";PrefNames["FACE_GAZE_ENABLED_SENTINEL_SHOW_DIALOG"]="settings.a11y.face_gaze.enabled_sentinel_show_dialog";PrefNames["GESTURE_TO_CONFIDENCE"]="settings.a11y.face_gaze.gestures_to_confidence";PrefNames["GESTURE_TO_KEY_COMBO"]="settings.a11y.face_gaze.gestures_to_key_combos";PrefNames["GESTURE_TO_MACRO"]="settings.a11y.face_gaze.gestures_to_macros";PrefNames["PRECISION_CLICK"]="settings.a11y.face_gaze.precision_click";PrefNames["PRECISION_CLICK_SPEED_FACTOR"]="settings.a11y.face_gaze.precision_click_speed_factor";PrefNames["SPD_DOWN"]="settings.a11y.face_gaze.cursor_speed_down";PrefNames["SPD_LEFT"]="settings.a11y.face_gaze.cursor_speed_left";PrefNames["SPD_RIGHT"]="settings.a11y.face_gaze.cursor_speed_right";PrefNames["SPD_UP"]="settings.a11y.face_gaze.cursor_speed_up";PrefNames["VELOCITY_THRESHOLD"]="settings.a11y.face_gaze.velocity_threshold"})(PrefNames||(PrefNames={}));TestImportManager.exportForTesting(["PrefNames",PrefNames]);var MediapipeFacialGesture;(function(MediapipeFacialGesture){MediapipeFacialGesture["BROW_DOWN_LEFT"]="browDownLeft";MediapipeFacialGesture["BROW_DOWN_RIGHT"]="browDownRight";MediapipeFacialGesture["BROW_INNER_UP"]="browInnerUp";MediapipeFacialGesture["EYE_BLINK_LEFT"]="eyeBlinkLeft";MediapipeFacialGesture["EYE_BLINK_RIGHT"]="eyeBlinkRight";MediapipeFacialGesture["EYE_LOOK_DOWN_LEFT"]="eyeLookDownLeft";MediapipeFacialGesture["EYE_LOOK_DOWN_RIGHT"]="eyeLookDownRight";MediapipeFacialGesture["EYE_LOOK_IN_LEFT"]="eyeLookInLeft";MediapipeFacialGesture["EYE_LOOK_IN_RIGHT"]="eyeLookInRight";MediapipeFacialGesture["EYE_LOOK_OUT_LEFT"]="eyeLookOutLeft";MediapipeFacialGesture["EYE_LOOK_OUT_RIGHT"]="eyeLookOutRight";MediapipeFacialGesture["EYE_LOOK_UP_LEFT"]="eyeLookUpLeft";MediapipeFacialGesture["EYE_LOOK_UP_RIGHT"]="eyeLookUpRight";MediapipeFacialGesture["EYE_SQUINT_LEFT"]="eyeSquintLeft";MediapipeFacialGesture["EYE_SQUINT_RIGHT"]="eyeSquintRight";MediapipeFacialGesture["JAW_LEFT"]="jawLeft";MediapipeFacialGesture["JAW_OPEN"]="jawOpen";MediapipeFacialGesture["JAW_RIGHT"]="jawRight";MediapipeFacialGesture["MOUTH_FUNNEL"]="mouthFunnel";MediapipeFacialGesture["MOUTH_LEFT"]="mouthLeft";MediapipeFacialGesture["MOUTH_PUCKER"]="mouthPucker";MediapipeFacialGesture["MOUTH_RIGHT"]="mouthRight";MediapipeFacialGesture["MOUTH_SMILE_LEFT"]="mouthSmileLeft";MediapipeFacialGesture["MOUTH_SMILE_RIGHT"]="mouthSmileRight";MediapipeFacialGesture["MOUTH_UPPER_UP_LEFT"]="mouthUpperUpLeft";MediapipeFacialGesture["MOUTH_UPPER_UP_RIGHT"]="mouthUpperUpRight"})(MediapipeFacialGesture||(MediapipeFacialGesture={}));const FacialGesturesToMediapipeGestures=new Map([[FacialGesture.BROW_INNER_UP,[MediapipeFacialGesture.BROW_INNER_UP]],[FacialGesture.BROWS_DOWN,[MediapipeFacialGesture.BROW_DOWN_LEFT,MediapipeFacialGesture.BROW_DOWN_RIGHT]],[FacialGesture.EYE_SQUINT_LEFT,[MediapipeFacialGesture.EYE_SQUINT_LEFT]],[FacialGesture.EYE_SQUINT_RIGHT,[MediapipeFacialGesture.EYE_SQUINT_RIGHT]],[FacialGesture.EYES_BLINK,[MediapipeFacialGesture.EYE_BLINK_LEFT,MediapipeFacialGesture.EYE_BLINK_RIGHT]],[FacialGesture.EYES_LOOK_DOWN,[MediapipeFacialGesture.EYE_LOOK_DOWN_LEFT,MediapipeFacialGesture.EYE_LOOK_DOWN_RIGHT]],[FacialGesture.EYES_LOOK_LEFT,[MediapipeFacialGesture.EYE_LOOK_OUT_LEFT,MediapipeFacialGesture.EYE_LOOK_IN_RIGHT]],[FacialGesture.EYES_LOOK_RIGHT,[MediapipeFacialGesture.EYE_LOOK_OUT_RIGHT,MediapipeFacialGesture.EYE_LOOK_IN_LEFT]],[FacialGesture.EYES_LOOK_UP,[MediapipeFacialGesture.EYE_LOOK_UP_LEFT,MediapipeFacialGesture.EYE_LOOK_UP_RIGHT]],[FacialGesture.JAW_LEFT,[MediapipeFacialGesture.JAW_LEFT]],[FacialGesture.JAW_OPEN,[MediapipeFacialGesture.JAW_OPEN]],[FacialGesture.JAW_RIGHT,[MediapipeFacialGesture.JAW_RIGHT]],[FacialGesture.MOUTH_FUNNEL,[MediapipeFacialGesture.MOUTH_FUNNEL]],[FacialGesture.MOUTH_LEFT,[MediapipeFacialGesture.MOUTH_LEFT]],[FacialGesture.MOUTH_PUCKER,[MediapipeFacialGesture.MOUTH_PUCKER]],[FacialGesture.MOUTH_RIGHT,[MediapipeFacialGesture.MOUTH_RIGHT]],[FacialGesture.MOUTH_SMILE,[MediapipeFacialGesture.MOUTH_SMILE_LEFT,MediapipeFacialGesture.MOUTH_SMILE_RIGHT]],[FacialGesture.MOUTH_UPPER_UP,[MediapipeFacialGesture.MOUTH_UPPER_UP_LEFT,MediapipeFacialGesture.MOUTH_UPPER_UP_RIGHT]]]);const FacialGesturesToExcludedMediapipeGestures=new Map([[FacialGesture.EYE_SQUINT_LEFT,[MediapipeFacialGesture.EYE_BLINK_RIGHT,MediapipeFacialGesture.EYE_SQUINT_RIGHT]],[FacialGesture.EYE_SQUINT_RIGHT,[MediapipeFacialGesture.EYE_BLINK_LEFT,MediapipeFacialGesture.EYE_SQUINT_LEFT]]]);const EXCLUDED_GESTURE_THRESHOLD=.5;class GestureDetector{static mediapipeFacialGestureSet_=new Set(Object.values(MediapipeFacialGesture));static toggleSendGestureDetectionInfo(enabled){this.shouldSendGestureDetectionInfo_=enabled}static detect(result,confidenceMap){const recognizedGestures=new Map;for(const classification of result.faceBlendshapes){for(const category of classification.categories){const gesture=category.categoryName;if(GestureDetector.mediapipeFacialGestureSet_.has(gesture)){recognizedGestures.set(gesture,category.score)}}}if(recognizedGestures.size===0){return[]}const gestures=[];const gestureInfoForSettings=[];for(const[faceGazeGesture,mediapipeGestures]of FacialGesturesToMediapipeGestures){const confidence=confidenceMap.get(faceGazeGesture);if(!this.shouldSendGestureDetectionInfo_&&!confidence){continue}let score=-1;let hasCompoundGesture=true;for(const mediapipeGesture of mediapipeGestures){if(!recognizedGestures.has(mediapipeGesture)){hasCompoundGesture=false;break}score=Math.max(score,recognizedGestures.get(mediapipeGesture))}if(!hasCompoundGesture){continue}let hasExcludedGesture=false;const excludedGestures=FacialGesturesToExcludedMediapipeGestures.get(faceGazeGesture);if(excludedGestures){for(const excludedGesture of excludedGestures){if(recognizedGestures.has(excludedGesture)&&recognizedGestures.get(excludedGesture)>EXCLUDED_GESTURE_THRESHOLD){hasExcludedGesture=true}}}if(hasExcludedGesture){continue}if(this.shouldSendGestureDetectionInfo_&&score>=.01){gestureInfoForSettings.push({gesture:faceGazeGesture,confidence:score*100})}if(confidence&&score<confidence){continue}gestures.push(faceGazeGesture)}if(this.shouldSendGestureDetectionInfo_&&gestureInfoForSettings.length>0){chrome.accessibilityPrivate.sendGestureInfoToSettings(gestureInfoForSettings)}return gestures}}TestImportManager.exportForTesting(GestureDetector,["FacialGesture",FacialGesture],["MediapipeFacialGesture",MediapipeFacialGesture],["FacialGesturesToMediapipeGestures",FacialGesturesToMediapipeGestures]);const DEFAULT_MINIMUM_DURATION_MS=150;const DEFAULT_REPEAT_DELAY_MS=1e3;class GestureTimer{repeatDelayMs_=DEFAULT_REPEAT_DELAY_MS;minDurationMs_=DEFAULT_MINIMUM_DURATION_MS;gestureStart_=new Map;gestureLastRecognized_=new Map;useGestureDuration_=true;mark(gesture,timestamp){if(!this.gestureStart_.has(gesture)){this.gestureStart_.set(gesture,timestamp)}}getLastRecognized(gesture){return this.gestureLastRecognized_.get(gesture)}setLastRecognized(gesture,timestamp){this.gestureLastRecognized_.set(gesture,timestamp)}resetTimer(gesture){this.gestureStart_.delete(gesture)}resetAll(){this.gestureStart_.clear();this.gestureLastRecognized_.clear()}isRepeatDelayValid(gesture,timestamp){const lastRecognized=this.gestureLastRecognized_.get(gesture);if(!lastRecognized){return true}return timestamp.getTime()-lastRecognized.getTime()>=this.repeatDelayMs_}isDurationValid(gesture,timestamp){if(!this.useGestureDuration_){return true}const startTime=this.gestureStart_.get(gesture);if(!startTime){return false}return timestamp.getTime()-startTime.getTime()>this.minDurationMs_}setGestureDurationForTesting(useDuration){this.useGestureDuration_=useDuration}}class MouseLongClickMacro extends Macro{mouseController_;constructor(mouseController){super(MacroName.MOUSE_LONG_CLICK_LEFT);this.mouseController_=mouseController}isToggle(){return true}getToggleDirection(){return this.mouseController_.isLongClickActive()?ToggleDirection.OFF:ToggleDirection.ON}checkContext(){if(!this.mouseController_.mouseLocation()){return this.createFailureCheckContextResult_(MacroError.BAD_CONTEXT)}return this.createSuccessCheckContextResult_()}run(){if(!this.mouseController_.mouseLocation()){return this.createRunMacroResult_(false)}this.mouseController_.toggleLongClick();return this.createRunMacroResult_(true)}}class MouseScrollMacro extends Macro{mouseController_;constructor(mouseController){super(MacroName.TOGGLE_SCROLL_MODE);this.mouseController_=mouseController}isToggle(){return true}getToggleDirection(){return this.mouseController_.isScrollModeActive()?ToggleDirection.OFF:ToggleDirection.ON}run(){this.mouseController_.toggleScrollMode();return this.createRunMacroResult_(true)}}class ResetCursorMacro extends Macro{mouseController_;constructor(mouseController){super(MacroName.RESET_CURSOR);this.mouseController_=mouseController}run(){this.mouseController_.resetLocation();return this.createRunMacroResult_(true)}}var RoleType$1=chrome.automation.RoleType;var StateType=chrome.automation.StateType;const DEFAULT_CONFIDENCE_THRESHOLD=.5;class GestureHandler{bubbleController_;gestureTimer_;mouseController_;gesturesToKeyCombos_=new Map;gestureToMacroName_=new Map;gestureToConfidence_=new Map;isDictationActive_;toggleInfoListener_;macrosToCompleteLater_=new Map;paused_=false;lastPrecisionGesture_=undefined;previousGestures_=[];constructor(mouseController,bubbleController,isDictationActive){this.mouseController_=mouseController;this.bubbleController_=bubbleController;this.isDictationActive_=isDictationActive;this.toggleInfoListener_=enabled=>GestureDetector.toggleSendGestureDetectionInfo(enabled);this.gestureTimer_=new GestureTimer}start(){this.paused_=false;chrome.accessibilityPrivate.onToggleGestureInfoForSettings.addListener(this.toggleInfoListener_)}stop(){this.paused_=false;chrome.accessibilityPrivate.onToggleGestureInfoForSettings.removeListener(this.toggleInfoListener_);this.previousGestures_=[];this.gestureTimer_.resetAll();this.macrosToCompleteLater_.forEach((entry=>{entry.macro.run()}));this.macrosToCompleteLater_.clear();this.lastPrecisionGesture_=undefined}isPaused(){return this.paused_}getHeldMacroDisplayStrings(){const displayStrings=[];for(const entry of this.macrosToCompleteLater_.values()){displayStrings.push(entry.displayText)}return displayStrings}detectMacros(result){const gestures=GestureDetector.detect(result,this.gestureToConfidence_);const{macros:macros,displayText:displayText}=this.gesturesToMacros_(gestures);const macrosOnGestureEnd=this.popMacrosOnGestureEnd(gestures,this.previousGestures_);if(macrosOnGestureEnd.length>0){this.bubbleController_.resetBubble()}macros.push(...macrosOnGestureEnd);this.previousGestures_=gestures;return{macros:macros,displayText:displayText}}togglePaused(gesture){const newPaused=!this.paused_;const lastToggledTime=this.gestureTimer_.getLastRecognized(gesture);newPaused?this.stop():this.start();if(lastToggledTime){this.gestureTimer_.setLastRecognized(gesture,lastToggledTime)}this.paused_=newPaused}getGestureForPause(){return this.getGestureFor_(MacroName.TOGGLE_FACEGAZE)}getGestureForScroll(){return this.getGestureFor_(MacroName.TOGGLE_SCROLL_MODE)}getGestureForLongClick(){return this.getGestureFor_(MacroName.MOUSE_LONG_CLICK_LEFT)}getGestureForDictation(){return this.getGestureFor_(MacroName.TOGGLE_DICTATION)}getGestureForPrecision(){return this.lastPrecisionGesture_}getGestureFor_(macroName){for(const[gesture,macro]of this.gestureToMacroName_.entries()){if(macro===macroName){return gesture}}return undefined}gesturesToMacros_(gestures){const macroNames=new Map;for(const gesture of gestures){const currentTime=new Date;const isDurationValid=this.gestureTimer_.isDurationValid(gesture,currentTime);this.gestureTimer_.mark(gesture,currentTime);if(!isDurationValid){continue}if(!this.gestureTimer_.isRepeatDelayValid(gesture,currentTime)){continue}if(this.macrosToCompleteLater_.has(gesture)){continue}this.gestureTimer_.setLastRecognized(gesture,currentTime);const name=this.gestureToMacroName_.get(gesture);if(name){macroNames.set(name,gesture)}}const displayStrings=[];const result=[];for(const[macroName,gesture]of macroNames){const initialMacro=this.macroFromName_(macroName,gesture);if(!initialMacro){continue}const macros=this.handlePrecisionClick_(initialMacro,gesture);for(const macro of macros){result.push(macro);const displayText=BubbleController.getDisplayText(gesture,macro);if(displayText){displayStrings.push(displayText)}if(macro.triggersAtActionStartAndEnd()){this.macrosToCompleteLater_.set(gesture,{macro:macro,displayText:displayText})}}}const displayText=displayStrings.join(", ");return{macros:result,displayText:displayText}}popMacrosOnGestureEnd(gestures,previousGestures){const macrosForLater=[];previousGestures.forEach((previousGesture=>{if(!gestures.includes(previousGesture)){this.gestureTimer_.resetTimer(previousGesture);const entry=this.macrosToCompleteLater_.get(previousGesture);if(!entry||!entry.macro){return}macrosForLater.push(entry.macro);this.macrosToCompleteLater_.delete(previousGesture)}}));return macrosForLater}macroFromName_(name,gesture){if(!this.isMacroAllowed_(name)){return}switch(name){case MacroName.TOGGLE_DICTATION:return new ToggleDictationMacro(this.isDictationActive_());case MacroName.MOUSE_CLICK_LEFT:return new MouseClickMacro(this.mouseController_.mouseLocation());case MacroName.MOUSE_CLICK_RIGHT:return new MouseClickMacro(this.mouseController_.mouseLocation(),false);case MacroName.MOUSE_LONG_CLICK_LEFT:return new MouseLongClickMacro(this.mouseController_);case MacroName.MOUSE_CLICK_LEFT_DOUBLE:return new MouseClickLeftDoubleMacro(this.mouseController_.mouseLocation());case MacroName.MOUSE_CLICK_LEFT_TRIPLE:return new MouseClickLeftTripleMacro(this.mouseController_.mouseLocation());case MacroName.RESET_CURSOR:return new ResetCursorMacro(this.mouseController_);case MacroName.KEY_PRESS_SPACE:return new KeyPressMacro(name,{key:KeyCode.SPACE});case MacroName.KEY_PRESS_DOWN:return new KeyPressMacro(name,{key:KeyCode.DOWN});case MacroName.KEY_PRESS_LEFT:return new KeyPressMacro(name,{key:KeyCode.LEFT});case MacroName.KEY_PRESS_RIGHT:return new KeyPressMacro(name,{key:KeyCode.RIGHT});case MacroName.KEY_PRESS_UP:return new KeyPressMacro(name,{key:KeyCode.UP});case MacroName.KEY_PRESS_TOGGLE_OVERVIEW:return new KeyPressMacro(name,{key:KeyCode.MEDIA_LAUNCH_APP1});case MacroName.KEY_PRESS_MEDIA_PLAY_PAUSE:return new KeyPressMacro(name,{key:KeyCode.MEDIA_PLAY_PAUSE});case MacroName.KEY_PRESS_SCREENSHOT:return new KeyPressMacro(name,{key:KeyCode.SNAPSHOT});case MacroName.OPEN_FACEGAZE_SETTINGS:return new CustomCallbackMacro(MacroName.OPEN_FACEGAZE_SETTINGS,(()=>{chrome.accessibilityPrivate.openSettingsSubpage(SettingsPath)}));case MacroName.TOGGLE_FACEGAZE:return new CustomCallbackMacro(MacroName.TOGGLE_FACEGAZE,(()=>{this.mouseController_.togglePaused();this.togglePaused(gesture)}),this.paused_?ToggleDirection.ON:ToggleDirection.OFF);case MacroName.TOGGLE_SCROLL_MODE:return new MouseScrollMacro(this.mouseController_);case MacroName.TOGGLE_VIRTUAL_KEYBOARD:return new CustomCallbackMacro(MacroName.TOGGLE_VIRTUAL_KEYBOARD,(async()=>{const isVisible=node=>Boolean(!node.state[StateType.OFFSCREEN]&&node.location&&node.location.top>=0&&node.location.left>=0&&!node.state[StateType.INVISIBLE]);const desktop=await AsyncUtil.getDesktop();const keyboard=desktop.find({role:RoleType$1.KEYBOARD});const currentlyVisible=Boolean(keyboard&&isVisible(keyboard)&&keyboard.find({role:RoleType$1.ROOT_WEB_AREA}));chrome.accessibilityPrivate.setVirtualKeyboardVisible(!currentlyVisible)}));case MacroName.CUSTOM_KEY_COMBINATION:const keyCombination=this.gesturesToKeyCombos_.get(gesture);if(!keyCombination){throw new Error(`Expected a custom key combination for gesture: ${gesture}`)}return new KeyPressMacro(name,keyCombination);default:return}}isMacroAllowed_(name){if(this.isDictationActive_()&&name!==MacroName.TOGGLE_DICTATION){return false}if(this.mouseController_.isScrollModeActive()&&name!==MacroName.TOGGLE_SCROLL_MODE){return false}if(this.paused_&&name!==MacroName.TOGGLE_FACEGAZE){return false}if(this.mouseController_.isLongClickActive()&&name!==MacroName.MOUSE_LONG_CLICK_LEFT){return false}return true}gesturesToMacrosChanged(bindings){if(!bindings){return}this.gestureToMacroName_.clear();let hasScrollModeAction=false;let hasLongClickAction=false;for(const[gesture,assignedMacro]of Object.entries(bindings)){if(assignedMacro===MacroName.UNSPECIFIED){continue}if(assignedMacro===MacroName.TOGGLE_SCROLL_MODE){hasScrollModeAction=true}if(assignedMacro===MacroName.MOUSE_LONG_CLICK_LEFT){hasLongClickAction=true}this.gestureToMacroName_.set(gesture,Number(assignedMacro));if(!this.gestureToConfidence_.has(gesture)){this.gestureToConfidence_.set(gesture,DEFAULT_CONFIDENCE_THRESHOLD)}}if(this.mouseController_.isScrollModeActive()&&!hasScrollModeAction){this.mouseController_.toggleScrollMode()}if(this.mouseController_.isLongClickActive()&&!hasLongClickAction){this.mouseController_.toggleLongClick()}}gesturesToConfidencesChanged(confidences){if(!confidences){return}for(const[gesture,confidence]of Object.entries(confidences)){this.gestureToConfidence_.set(gesture,Number(confidence)/100)}}gesturesToKeyCombosChanged(keyCombos){if(!keyCombos){return}this.gesturesToKeyCombos_.clear();for(const[gesture,keyCombinationAsString]of Object.entries(keyCombos)){const keyCombination=JSON.parse(keyCombinationAsString);this.gesturesToKeyCombos_.set(gesture,keyCombination)}}handlePrecisionClick_(macro,gesture){if(!this.mouseController_.usePrecision()){return[macro]}const isClickMacro=()=>{const name=macro.getName();if(name===MacroName.MOUSE_CLICK_LEFT||name===MacroName.MOUSE_CLICK_LEFT_DOUBLE||name===MacroName.MOUSE_CLICK_LEFT_TRIPLE||name===MacroName.MOUSE_CLICK_RIGHT){return true}return false};const result=[];if(!this.mouseController_.isPrecisionActive()){if(!isClickMacro()){result.push(macro)}else{this.lastPrecisionGesture_=gesture;result.push(new CustomCallbackMacro(MacroName.TOGGLE_PRECISION_CLICK,(()=>this.mouseController_.togglePrecision()),ToggleDirection.ON))}}else{result.push(macro,new CustomCallbackMacro(MacroName.TOGGLE_PRECISION_CLICK,(()=>this.mouseController_.togglePrecision()),ToggleDirection.OFF))}return result}}TestImportManager.exportForTesting(GestureHandler);const FACELANDMARKER_PERFORMANCE_METRIC="Accessibility.FaceGaze.AverageFaceLandmarkerLatency";class MetricsUtils{latencies_=[];addFaceLandmarkerResultLatency(val){this.latencies_.push(val);if(this.latencies_.length>=100){this.writeHistogram_();this.latencies_=[]}}writeHistogram_(){let sum=0;for(const val of this.latencies_){sum+=val}const average=Math.ceil(sum/this.latencies_.length);chrome.metricsPrivate.recordMediumTime(FACELANDMARKER_PERFORMANCE_METRIC,average)}}TestImportManager.exportForTesting(MetricsUtils);var ScrollDirection=chrome.accessibilityPrivate.ScrollDirection;const VERTICAL_CUSHION_FACTOR=.1;class ScrollModeController{active_=false;scrollLocation_;lastScrollTime_=0;screenBounds_;originalCursorControlPref_;active(){return this.active_}toggle(mouseLocation,screenBounds){if(!mouseLocation||!screenBounds){return}this.active_?this.stop_():this.start_(mouseLocation,screenBounds)}updateScrollLocation(mouseLocation){if(!mouseLocation){return}this.scrollLocation_=mouseLocation}async start_(mouseLocation,screenBounds){this.active_=true;this.scrollLocation_=mouseLocation;this.screenBounds_=screenBounds;chrome.settingsPrivate.getPref(PrefNames.CURSOR_CONTROL_ENABLED,(pref=>{this.originalCursorControlPref_=pref.value;chrome.settingsPrivate.setPref(PrefNames.CURSOR_CONTROL_ENABLED,true)}))}stop_(){this.active_=false;this.scrollLocation_=undefined;this.screenBounds_=undefined;this.lastScrollTime_=0;chrome.settingsPrivate.setPref(PrefNames.CURSOR_CONTROL_ENABLED,Boolean(this.originalCursorControlPref_));this.originalCursorControlPref_=undefined}scroll(mouseLocation){if(!this.active_||!this.scrollLocation_||!this.screenBounds_||(new Date).getTime()-this.lastScrollTime_<ScrollModeController.RATE_LIMIT){return}const verticalCushion=this.screenBounds_.height*VERTICAL_CUSHION_FACTOR;let direction;if(mouseLocation.y<=this.screenBounds_.top+verticalCushion){direction=ScrollDirection.UP}else if(mouseLocation.y>=this.screenBounds_.height+this.screenBounds_.top-verticalCushion){direction=ScrollDirection.DOWN}else if(mouseLocation.x<=this.screenBounds_.left){direction=ScrollDirection.LEFT}else if(mouseLocation.x>=this.screenBounds_.width+this.screenBounds_.left){direction=ScrollDirection.RIGHT}if(!direction){return}this.lastScrollTime_=(new Date).getTime();chrome.accessibilityPrivate.scrollAtPoint(this.scrollLocation_,direction)}}(function(ScrollModeController){ScrollModeController.RATE_LIMIT=50})(ScrollModeController||(ScrollModeController={}));TestImportManager.exportForTesting(ScrollModeController);var SyntheticMouseEventButton=chrome.accessibilityPrivate.SyntheticMouseEventButton;var LandmarkType;(function(LandmarkType){LandmarkType["FOREHEAD"]="forehead";LandmarkType["FOREHEAD_TOP"]="foreheadTop";LandmarkType["LEFT_TEMPLE"]="leftTemple";LandmarkType["NOSE_TIP"]="noseTip";LandmarkType["RIGHT_TEMPLE"]="rightTemple";LandmarkType["ROTATION"]="rotation"})(LandmarkType||(LandmarkType={}));const DEFAULT_MOUSE_SPEED=10;const DEFAULT_USE_MOUSE_ACCELERATION=true;const DEFAULT_BUFFER_SIZE=7;const DEFAULT_PRECISION_SPEED_FACTOR=50;const DEFAULT_VELOCITY_FACTOR=.45;const IGNORE_UPDATES_AFTER_MOUSE_MOVE_MS=500;const LANDMARK_INDICES=[{name:LandmarkType.FOREHEAD,index:8},{name:LandmarkType.FOREHEAD_TOP,index:10},{name:LandmarkType.NOSE_TIP,index:4},{name:LandmarkType.RIGHT_TEMPLE,index:127},{name:LandmarkType.LEFT_TEMPLE,index:356},{name:LandmarkType.ROTATION,index:-1}];const MAX_VELOCITY_THRESHOLD_PREF_VALUE=20;const MOUSE_INTERVAL_MS=16;class MouseController{scrollModeController_;bubbleController_;mouseLocation_;onMouseMovedHandler_;onMouseDraggedHandler_;screenBounds_;targetBufferSize_=DEFAULT_BUFFER_SIZE;useMouseAcceleration_=DEFAULT_USE_MOUSE_ACCELERATION;spdRight_=DEFAULT_MOUSE_SPEED;spdLeft_=DEFAULT_MOUSE_SPEED;spdUp_=DEFAULT_MOUSE_SPEED;spdDown_=DEFAULT_MOUSE_SPEED;velocityThreshold_=0;velocityThresholdFactor_=DEFAULT_VELOCITY_FACTOR;useVelocityThreshold_=true;buffer_=[];smoothKernel_=[];previousSmoothedLocation_;lastLandmarkLocation_;mouseInterval_=-1;lastMouseMovedTime_=0;landmarkWeights_;paused_=false;longClickActive_=false;usePrecision_=false;precisionActive_=false;precisionSpeedFactor_=DEFAULT_PRECISION_SPEED_FACTOR;constructor(bubbleController){this.bubbleController_=bubbleController;this.onMouseMovedHandler_=new EventHandler([],chrome.automation.EventType.MOUSE_MOVED,(event=>this.onMouseMovedOrDragged_(event)));this.onMouseDraggedHandler_=new EventHandler([],chrome.automation.EventType.MOUSE_DRAGGED,(event=>this.onMouseMovedOrDragged_(event)));this.scrollModeController_=new ScrollModeController;this.calcSmoothKernel_();this.calcVelocityThreshold_();this.landmarkWeights_=new Map;this.landmarkWeights_.set(LandmarkType.FOREHEAD,.1275);this.landmarkWeights_.set(LandmarkType.FOREHEAD_TOP,.0738);this.landmarkWeights_.set(LandmarkType.NOSE_TIP,.3355);this.landmarkWeights_.set(LandmarkType.LEFT_TEMPLE,.0336);this.landmarkWeights_.set(LandmarkType.RIGHT_TEMPLE,.0336);this.landmarkWeights_.set(LandmarkType.ROTATION,.396);this.init()}async init(){chrome.accessibilityPrivate.enableMouseEvents(true);const desktop=await AsyncUtil.getDesktop();this.onMouseMovedHandler_.setNodes(desktop);this.onMouseMovedHandler_.start();this.onMouseDraggedHandler_.setNodes(desktop);this.onMouseDraggedHandler_.start()}isScrollModeActive(){return this.scrollModeController_.active()}isLongClickActive(){return this.longClickActive_}usePrecision(){return this.usePrecision_}isPrecisionActive(){return this.precisionActive_}togglePrecision(){if(!this.usePrecision_){return}this.precisionActive_=!this.precisionActive_;if(!this.precisionActive_){this.bubbleController_.resetBubble()}}async start(){this.paused_=false;const screens=await new Promise((resolve=>{chrome.accessibilityPrivate.getDisplayBounds((screens=>{resolve(screens)}))}));if(!screens.length){return}this.screenBounds_=screens[0];if(!this.mouseLocation_){this.resetLocation()}this.mouseInterval_=setInterval((()=>this.updateMouseLocation_()),MOUSE_INTERVAL_MS)}onFaceLandmarkerResult(result){if(this.paused_||!this.screenBounds_||!result.faceLandmarks||!result.faceLandmarks[0]){return}const avgLandmarkLocation={x:0,y:0};let hasLandmarks=false;for(const landmark of LANDMARK_INDICES){let landmarkLocation;if(landmark.name==="rotation"&&result.facialTransformationMatrixes&&result.facialTransformationMatrixes.length){landmarkLocation=MouseController.calculateRotationFromFacialTransformationMatrix(result.facialTransformationMatrixes[0])}else if(result.faceLandmarks[0][landmark.index]!==undefined){landmarkLocation=result.faceLandmarks[0][landmark.index]}if(!landmarkLocation){continue}const x=landmarkLocation.x;const y=landmarkLocation.y;let weight=this.landmarkWeights_.get(landmark.name);if(!weight){weight=0}avgLandmarkLocation.x+=x*weight;avgLandmarkLocation.y+=y*weight;hasLandmarks=true}if(!hasLandmarks){return}const absoluteY=Math.round(avgLandmarkLocation.y*this.screenBounds_.height+this.screenBounds_.top);const scaledX=Math.round(avgLandmarkLocation.x*this.screenBounds_.width);const absoluteX=this.screenBounds_.width-scaledX+this.screenBounds_.left;this.lastLandmarkLocation_={x:absoluteX,y:absoluteY}}updateMouseLocation_(){if(this.paused_||!this.lastLandmarkLocation_||!this.mouseLocation_||!this.screenBounds_){return}this.addPointToBuffer_(this.lastLandmarkLocation_);const smoothed=this.applySmoothing_();if(!this.previousSmoothedLocation_){this.previousSmoothedLocation_=smoothed}const velocityX=smoothed.x-this.previousSmoothedLocation_.x;const velocityY=smoothed.y-this.previousSmoothedLocation_.y;const scaledVel=this.asymmetryScale_({x:velocityX,y:velocityY});this.previousSmoothedLocation_=smoothed;if(this.useMouseAcceleration_){scaledVel.x*=this.applySigmoidAcceleration_(scaledVel.x);scaledVel.y*=this.applySigmoidAcceleration_(scaledVel.y)}if(!this.scrollModeController_.active()&&!this.exceedsVelocityThreshold_(scaledVel.x)&&!this.exceedsVelocityThreshold_(scaledVel.y)){return}scaledVel.x=this.applyVelocityThreshold_(scaledVel.x);scaledVel.y=this.applyVelocityThreshold_(scaledVel.y);const newX=this.mouseLocation_.x+scaledVel.x;const newY=this.mouseLocation_.y+scaledVel.y;this.mouseLocation_={x:Math.max(Math.min(this.screenBounds_.width,Math.round(newX)),this.screenBounds_.left),y:Math.max(Math.min(this.screenBounds_.height,Math.round(newY)),this.screenBounds_.top)};if(this.scrollModeController_.active()){this.scrollModeController_.scroll(this.mouseLocation_);return}if((new Date).getTime()-this.lastMouseMovedTime_>IGNORE_UPDATES_AFTER_MOUSE_MOVE_MS){EventGenerator.sendMouseMove(this.mouseLocation_.x,this.mouseLocation_.y,{useRewriters:true,forceNotSynthetic:true});chrome.accessibilityPrivate.setCursorPosition(this.mouseLocation_)}}addPointToBuffer_(point){if(this.buffer_.length===this.targetBufferSize_){this.buffer_.shift()}while(this.buffer_.length<this.targetBufferSize_){this.buffer_.push(point)}}mouseLocation(){return this.mouseLocation_}resetLocation(){if(this.paused_||!this.screenBounds_||this.scrollModeController_.active()){return}const x=Math.round(this.screenBounds_.width/2)+this.screenBounds_.left;const y=Math.round(this.screenBounds_.height/2)+this.screenBounds_.top;this.mouseLocation_={x:x,y:y};chrome.accessibilityPrivate.setCursorPosition({x:x,y:y})}reset(){this.stop();this.onMouseMovedHandler_.stop();this.onMouseDraggedHandler_.stop()}stop(){if(this.longClickActive_&&this.mouseLocation_){EventGenerator.sendMouseRelease(this.mouseLocation_.x,this.mouseLocation_.y,{forceNotSynthetic:true});this.longClickActive_=false}if(this.precisionActive_){this.togglePrecision()}if(this.mouseInterval_!==-1){clearInterval(this.mouseInterval_);this.mouseInterval_=-1}this.lastLandmarkLocation_=undefined;this.previousSmoothedLocation_=undefined;this.lastMouseMovedTime_=0;this.buffer_=[];this.paused_=false}togglePaused(){const newPaused=!this.paused_;newPaused?this.stop():this.start();this.paused_=newPaused}toggleScrollMode(){this.scrollModeController_.toggle(this.mouseLocation_,this.screenBounds_);if(!this.isScrollModeActive()){this.bubbleController_.resetBubble()}}toggleLongClick(){if(!this.mouseLocation_){return}this.longClickActive_=!this.longClickActive_;if(this.longClickActive_){EventGenerator.sendMousePress(this.mouseLocation_.x,this.mouseLocation_.y,SyntheticMouseEventButton.LEFT,{forceNotSynthetic:true});chrome.accessibilityPrivate.enableDragEventRewriter(true)}else{EventGenerator.sendMouseRelease(this.mouseLocation_.x,this.mouseLocation_.y,{forceNotSynthetic:true});chrome.accessibilityPrivate.enableDragEventRewriter(false)}if(!this.isLongClickActive()){this.bubbleController_.resetBubble()}}onMouseMovedOrDragged_(event){if(event.eventFrom==="user"){this.mouseLocation_={x:event.mouseX,y:event.mouseY};this.lastMouseMovedTime_=(new Date).getTime();if(this.scrollModeController_.active()){this.scrollModeController_.updateScrollLocation(this.mouseLocation_)}if(this.longClickActive_){EventGenerator.sendMouseMove(event.mouseX,event.mouseY,{useRewriters:true,forceNotSynthetic:true})}}}calcSmoothKernel_(){this.smoothKernel_=[];let sum=0;const step=1/this.targetBufferSize_;for(let i=step;i<=1;i+=step){const smoothFactor=Math.E;const numerator=Math.E**(smoothFactor*i)-1;const denominator=Math.E**smoothFactor-1;const value=.92*(numerator/denominator)+.08;this.smoothKernel_.push(value);sum+=value}for(let i=0;i<this.targetBufferSize_;i++){this.smoothKernel_[i]/=sum}}applySmoothing_(){const result={x:0,y:0};for(let i=0;i<this.targetBufferSize_;i++){const kernelPart=this.smoothKernel_[i];result.x+=this.buffer_[i].x*kernelPart;result.y+=this.buffer_[i].y*kernelPart}return result}asymmetryScale_(vel){const precisionClickMultiplier=(100-this.precisionSpeedFactor_)/100;const spdRight=this.usePrecision_&&this.precisionActive_?this.spdRight_*precisionClickMultiplier:this.spdRight_;const spdLeft=this.usePrecision_&&this.precisionActive_?this.spdLeft_*precisionClickMultiplier:this.spdLeft_;const spdDown=this.usePrecision_&&this.precisionActive_?this.spdDown_*precisionClickMultiplier:this.spdDown_;const spdUp=this.usePrecision_&&this.precisionActive_?this.spdUp_*precisionClickMultiplier:this.spdUp_;if(vel.x>0){vel.x*=spdRight}else{vel.x*=spdLeft}if(vel.y>0){vel.y*=spdDown}else{vel.y*=spdUp}return vel}applySigmoidAcceleration_(velocity){const shift=5;const slope=.3;const multiply=1.2;velocity=Math.abs(velocity);const sig=1/(1+Math.exp(-slope*(velocity-shift)));return multiply*sig}calcVelocityThreshold_(){const averageSpeed=(this.spdUp_+this.spdDown_+this.spdLeft_+this.spdRight_)/4;this.velocityThreshold_=averageSpeed*this.velocityThresholdFactor_}exceedsVelocityThreshold_(velocity){if(!this.useVelocityThreshold_||this.usePrecision_&&this.precisionActive_){return true}return Math.abs(velocity)>this.velocityThreshold_}applyVelocityThreshold_(velocity){if(!this.useVelocityThreshold_||this.usePrecision_&&this.precisionActive_){return velocity}if(Math.abs(velocity)<this.velocityThreshold_){return 0}return velocity>0?velocity-this.velocityThreshold_:velocity+this.velocityThreshold_}setLandmarkWeightsForTesting(useWeights){if(!useWeights){this.landmarkWeights_=new Map;this.landmarkWeights_.set("forehead",1)}}setVelocityThresholdForTesting(useThreshold){this.useVelocityThreshold_=useThreshold}setBufferSizeForTesting(size){this.targetBufferSize_=size;this.calcSmoothKernel_();while(this.buffer_.length>this.targetBufferSize_){this.buffer_.shift()}}speedUpChanged(speed){this.spdUp_=speed;this.calcVelocityThreshold_()}speedDownChanged(speed){this.spdDown_=speed;this.calcVelocityThreshold_()}speedLeftChanged(speed){this.spdLeft_=speed;this.calcVelocityThreshold_()}speedRightChanged(speed){this.spdRight_=speed;this.calcVelocityThreshold_()}useCursorAccelerationChanged(useAcceleration){this.useMouseAcceleration_=useAcceleration}velocityThresholdChanged(threshold){this.velocityThresholdFactor_=threshold/MAX_VELOCITY_THRESHOLD_PREF_VALUE;this.calcVelocityThreshold_()}precisionClickChanged(usePrecision){this.usePrecision_=usePrecision}precisionSpeedFactorChanged(speedFactor){this.precisionSpeedFactor_=speedFactor}static calculateRotationFromFacialTransformationMatrix(facialTransformationMatrix){const mat=facialTransformationMatrix.data;const m11=mat[0];const m12=mat[1];const m13=mat[2];const m21=mat[4];const m22=mat[5];const m23=mat[6];const m31=mat[8];const m32=mat[9];const m33=mat[10];if(m31===1){console.log("cannot process matrix with m[3][1] == 1 yet.");return}const scaling=[Math.hypot(m11,m12,m13),Math.hypot(m21,m22,m23),Math.hypot(m31,m32,m33)];const sm31=m31/scaling[0];const sm32=m32/scaling[1];const sm33=m33/scaling[2];const xRotation=-1*Math.asin(sm31);const yRotation=Math.atan2(sm32/Math.cos(xRotation),sm33/Math.cos(xRotation));const x=.5-xRotation/(Math.PI*2);const y=.5-yRotation/(Math.PI*2);return{x:x,y:y}}}TestImportManager.exportForTesting(MouseController);const CONNECT_TO_WEBCAM_TIMEOUT=1e3;const DEFAULT_CONNECT_TO_WEBCAM_RETRIES=10;const DETECT_FACE_LANDMARKS_INTERVAL_MS=60;const VIDEO_FRAME_DIMENSIONS=192;const WASM_LOADER_PATH="accessibility_common/mv2/third_party/mediapipe_task_vision/"+"vision_wasm_internal.js";class WebCamFaceLandmarker{faceLandmarker_=null;imageCapture_;bubbleController_;onFaceLandmarkerResult_;onTrackMuted_;onTrackUnmuted_;onTrackEndedHandler_;onTrackMutedHandler_;onTrackUnmutedHandler_;stopped_=true;connectToWebCamRetriesRemaining_=DEFAULT_CONNECT_TO_WEBCAM_RETRIES;setWebCamConnected_;setReadyForTesting_;constructor(bubbleController,onFaceLandmarkerResult,onTrackMuted,onTrackUnmuted){this.bubbleController_=bubbleController;this.onFaceLandmarkerResult_=onFaceLandmarkerResult;this.onTrackMuted_=onTrackMuted;this.onTrackUnmuted_=onTrackUnmuted;this.onTrackEndedHandler_=()=>this.onTrackEnded_();this.onTrackMutedHandler_=()=>{this.onTrackMuted_()};this.onTrackUnmutedHandler_=()=>this.onTrackUnmuted_();this.intervalID_=null;this.webCamConnected_=new Promise((resolve=>{this.setWebCamConnected_=resolve}));this.readyForTesting_=new Promise((resolve=>{this.setReadyForTesting_=resolve}))}async init(){this.stopped_=false;await this.createFaceLandmarker_();this.connectToWebCam_();await this.webCamConnected_;this.startDetectingFaceLandmarks_()}async createFaceLandmarker_(){let proceed;chrome.accessibilityPrivate.installFaceGazeAssets((async assets=>{if(!assets){console.error(`Couldn't create FaceLandmarker because FaceGaze assets couldn't be\n              installed.`);chrome.settingsPrivate.setPref(PrefNames.FACE_GAZE_ENABLED,false);return}const blob=new Blob([assets.wasm]);const customFileset={wasmLoaderPath:chrome.runtime.getURL(WASM_LOADER_PATH),wasmBinaryPath:URL.createObjectURL(blob)};this.faceLandmarker_=await FaceLandmarker.createFromModelBuffer(customFileset,new Uint8Array(assets.model));const options={outputFaceBlendshapes:true,outputFacialTransformationMatrixes:true,runningMode:"IMAGE",numFaces:1};this.faceLandmarker_.setOptions(options);if(this.setReadyForTesting_){this.setReadyForTesting_()}proceed()}));return new Promise((resolve=>{proceed=resolve}))}async connectToWebCam_(){const constraints={video:{height:VIDEO_FRAME_DIMENSIONS,width:VIDEO_FRAME_DIMENSIONS,facingMode:"user"}};let stream;try{stream=await navigator.mediaDevices.getUserMedia(constraints)}catch(error){if(this.connectToWebCamRetriesRemaining_>0){const message=chrome.i18n.getMessage("facegaze_connect_to_camera",[this.connectToWebCamRetriesRemaining_]);this.bubbleController_.updateBubble(message);this.connectToWebCamRetriesRemaining_-=1;setTimeout((()=>this.connectToWebCam_()),CONNECT_TO_WEBCAM_TIMEOUT)}else{chrome.settingsPrivate.setPref(PrefNames.FACE_GAZE_ENABLED,false)}return}const tracks=stream.getVideoTracks();if(this.stopped_){tracks[0].stop();return}this.imageCapture_=new ImageCapture(tracks[0]);this.imageCapture_.track.addEventListener("ended",this.onTrackEndedHandler_);this.imageCapture_.track.addEventListener("mute",this.onTrackMutedHandler_);this.imageCapture_.track.addEventListener("unmute",this.onTrackUnmutedHandler_);this.connectToWebCamRetriesRemaining_=DEFAULT_CONNECT_TO_WEBCAM_RETRIES;this.setWebCamConnected_()}onTrackEnded_(){if(this.imageCapture_){this.imageCapture_.track.stop();this.removeEventListeners_()}this.imageCapture_=undefined;this.connectToWebCam_()}startDetectingFaceLandmarks_(){this.intervalID_=setInterval((()=>this.detectFaceLandmarks_()),DETECT_FACE_LANDMARKS_INTERVAL_MS)}async detectFaceLandmarks_(){if(!this.faceLandmarker_){return}let frame;try{frame=await this.imageCapture_.grabFrame()}catch(error){return}const startTime=performance.now();const result=this.faceLandmarker_.detect(frame);const latency=performance.now()-startTime;this.onFaceLandmarkerResult_({result:result,latency:latency})}removeEventListeners_(){if(this.imageCapture_){this.imageCapture_.track.removeEventListener("ended",this.onTrackEndedHandler_);this.imageCapture_.track.removeEventListener("mute",this.onTrackMutedHandler_);this.imageCapture_.track.removeEventListener("unmute",this.onTrackUnmutedHandler_)}}stop(){this.stopped_=true;if(this.imageCapture_){this.removeEventListeners_();this.imageCapture_.track.stop();this.imageCapture_=undefined}this.faceLandmarker_=null;if(this.intervalID_!==null){clearInterval(this.intervalID_);this.intervalID_=null}}}TestImportManager.exportForTesting(WebCamFaceLandmarker);class FaceGaze{bubbleController_;gestureHandler_;metricsUtils_;mouseController_;webCamFaceLandmarker_;actionsEnabled_=false;cursorControlEnabled_=false;initialized_=false;isFaceLandmarkerResultValid_=true;isCameraMuted_=false;onInitCallbackForTest_;prefsListener_;constructor(isDictationActive){this.bubbleController_=new BubbleController((()=>({paused:this.gestureHandler_.isPaused()?this.gestureHandler_.getGestureForPause():undefined,scrollMode:this.mouseController_.isScrollModeActive()?this.gestureHandler_.getGestureForScroll():undefined,longClick:this.mouseController_.isLongClickActive()?this.gestureHandler_.getGestureForLongClick():undefined,dictation:isDictationActive()?this.gestureHandler_.getGestureForDictation():undefined,heldMacros:this.gestureHandler_.getHeldMacroDisplayStrings(),precision:this.mouseController_.isPrecisionActive()?this.gestureHandler_.getGestureForPrecision():undefined,isFaceLandmarkerResultValid:this.isFaceLandmarkerResultValid_,isCameraMuted:this.isCameraMuted_})));this.webCamFaceLandmarker_=new WebCamFaceLandmarker(this.bubbleController_,(resultWithLatency=>{const{result:result,latency:latency}=resultWithLatency;this.processFaceLandmarkerResult_(result,latency)}),(()=>this.onCameraFeedMuted_()),(()=>this.onCameraFeedUnmuted_()));this.mouseController_=new MouseController(this.bubbleController_);this.gestureHandler_=new GestureHandler(this.mouseController_,this.bubbleController_,isDictationActive);this.metricsUtils_=new MetricsUtils;this.prefsListener_=prefs=>this.updateFromPrefs_(prefs);this.init_()}init_(){chrome.settingsPrivate.getAllPrefs((prefs=>this.updateFromPrefs_(prefs)));chrome.settingsPrivate.onPrefsChanged.addListener(this.prefsListener_);if(this.onInitCallbackForTest_){this.onInitCallbackForTest_();this.onInitCallbackForTest_=undefined}this.initialized_=true;this.maybeShowConfirmationDialog_()}maybeShowConfirmationDialog_(){chrome.settingsPrivate.getPref(PrefNames.ACCELERATOR_DIALOG_HAS_BEEN_ACCEPTED,(pref=>{if(pref.value===undefined||pref.value===null){return}if(pref.value){this.onConfirmationDialog_(true);return}const title=chrome.i18n.getMessage("facegaze_confirmation_dialog_title");const description=chrome.i18n.getMessage("facegaze_confirmation_dialog_desc");chrome.accessibilityPrivate.showConfirmationDialog(title,description,undefined,(accepted=>{this.onConfirmationDialog_(accepted)}))}))}onConfirmationDialog_(accepted){chrome.settingsPrivate.setPref(PrefNames.ACCELERATOR_DIALOG_HAS_BEEN_ACCEPTED,accepted);if(!accepted){chrome.settingsPrivate.setPref(PrefNames.FACE_GAZE_ENABLED,false);return}chrome.accessibilityPrivate.openSettingsSubpage(SettingsPath);this.bubbleController_.updateBubble("");this.webCamFaceLandmarker_.init()}updateFromPrefs_(prefs){prefs.forEach((pref=>{if(pref.value===undefined||pref.value===null){return}switch(pref.key){case PrefNames.ACTIONS_ENABLED:this.actionsEnabledChanged_(pref.value);break;case PrefNames.CURSOR_CONTROL_ENABLED:this.cursorControlEnabledChanged_(pref.value);break;case PrefNames.CURSOR_USE_ACCELERATION:this.mouseController_.useCursorAccelerationChanged(pref.value);break;case PrefNames.GESTURE_TO_CONFIDENCE:this.gestureHandler_.gesturesToConfidencesChanged(pref.value);break;case PrefNames.GESTURE_TO_KEY_COMBO:this.gestureHandler_.gesturesToKeyCombosChanged(pref.value);break;case PrefNames.GESTURE_TO_MACRO:this.gestureHandler_.gesturesToMacrosChanged(pref.value);break;case PrefNames.PRECISION_CLICK:this.mouseController_.precisionClickChanged(pref.value);break;case PrefNames.PRECISION_CLICK_SPEED_FACTOR:this.mouseController_.precisionSpeedFactorChanged(pref.value);break;case PrefNames.SPD_UP:this.mouseController_.speedUpChanged(pref.value);break;case PrefNames.SPD_DOWN:this.mouseController_.speedDownChanged(pref.value);break;case PrefNames.SPD_LEFT:this.mouseController_.speedLeftChanged(pref.value);break;case PrefNames.SPD_RIGHT:this.mouseController_.speedRightChanged(pref.value);break;case PrefNames.VELOCITY_THRESHOLD:this.mouseController_.velocityThresholdChanged(pref.value);break;default:return}}))}cursorControlEnabledChanged_(value){if(this.cursorControlEnabled_===value){return}this.cursorControlEnabled_=value;if(this.cursorControlEnabled_){this.mouseController_.start()}else{this.mouseController_.stop()}}actionsEnabledChanged_(value){if(this.actionsEnabled_===value){return}this.actionsEnabled_=value;if(this.actionsEnabled_){this.gestureHandler_.start()}else{this.gestureHandler_.stop();if(this.mouseController_.isScrollModeActive()){this.mouseController_.toggleScrollMode()}if(this.mouseController_.isLongClickActive()){this.mouseController_.toggleLongClick()}if(this.mouseController_.isPrecisionActive()){this.mouseController_.togglePrecision()}}}processFaceLandmarkerResult_(result,latency){if(!result){return}if(result.faceBlendshapes.length===0&&result.faceLandmarks.length===0&&result.facialTransformationMatrixes.length===0){this.updateIsFaceLandmarkerResultValid_(false);return}this.updateIsFaceLandmarkerResultValid_(true);if(latency!==undefined){this.metricsUtils_.addFaceLandmarkerResultLatency(latency)}if(this.cursorControlEnabled_){this.mouseController_.onFaceLandmarkerResult(result)}if(this.actionsEnabled_){const{macros:macros,displayText:displayText}=this.gestureHandler_.detectMacros(result);for(const macro of macros){const checkContextResult=macro.checkContext();if(!checkContextResult.canTryAction){console.warn("Cannot execute macro in this context",macro.getName(),checkContextResult.error,checkContextResult.failedContext);continue}const runMacroResult=macro.run();if(!runMacroResult.isSuccess){console.warn("Failed to execute macro ",macro.getName(),runMacroResult.error)}}if(displayText){this.bubbleController_.updateBubble(displayText)}}}updateIsFaceLandmarkerResultValid_(valid){if(valid===this.isFaceLandmarkerResultValid_){return}this.isFaceLandmarkerResultValid_=valid;this.bubbleController_.resetBubble()}onCameraFeedMuted_(){if(this.isCameraMuted_){return}this.isCameraMuted_=true;this.bubbleController_.resetBubble()}onCameraFeedUnmuted_(){if(!this.isCameraMuted_){return}this.isCameraMuted_=false;this.bubbleController_.resetBubble()}onFaceGazeDisabled(){this.mouseController_.reset();this.gestureHandler_.stop();this.webCamFaceLandmarker_.stop();chrome.settingsPrivate.onPrefsChanged.removeListener(this.prefsListener_)}setOnInitCallbackForTest(callback){if(!this.initialized_){this.onInitCallbackForTest_=callback;return}callback()}}TestImportManager.exportForTesting(FaceGaze);var EventType=chrome.automation.EventType;var RoleType=chrome.automation.RoleType;class Magnifier{type;screenMagnifierFocusFollowing_;screenMagnifierFollowsChromeVox_=true;screenMagnifierFollowsSts_=true;isInitializing_=true;lastMouseMovedTime_;lastFocusSelectionOrCaretMove_;focusHandler_;activeDescendantHandler_;selectionHandler_;onCaretBoundsChangedHandler;onMagnifierBoundsChangedHandler_;onChromeVoxFocusChangedHandler_;onSelectToSpeakFocusChangedHandler_;updateFromPrefsHandler_;onMouseMovedHandler_;onMouseDraggedHandler_;lastChromeVoxBounds_;lastSelectToSpeakBounds_;onLoadDesktopCallbackForTest_;constructor(type){this.type=type;this.focusHandler_=new EventHandler([],EventType.FOCUS,(event=>this.onFocusOrSelectionChanged_(event)));this.activeDescendantHandler_=new EventHandler([],EventType.ACTIVE_DESCENDANT_CHANGED,(event=>this.onActiveDescendantChanged_(event)));this.selectionHandler_=new EventHandler([],EventType.SELECTION,(event=>this.onFocusOrSelectionChanged_(event)));this.onCaretBoundsChangedHandler=new EventHandler([],EventType.CARET_BOUNDS_CHANGED,(event=>this.onCaretBoundsChanged(event)));this.onMagnifierBoundsChangedHandler_=new ChromeEventHandler(chrome.accessibilityPrivate.onMagnifierBoundsChanged,(bounds=>this.onMagnifierBoundsChanged_(bounds)));this.onChromeVoxFocusChangedHandler_=new ChromeEventHandler(chrome.accessibilityPrivate.onChromeVoxFocusChanged,(bounds=>this.onChromeVoxFocusChanged_(bounds)));this.onSelectToSpeakFocusChangedHandler_=new ChromeEventHandler(chrome.accessibilityPrivate.onSelectToSpeakFocusChanged,(bounds=>this.onSelectToSpeakFocusChanged_(bounds)));this.updateFromPrefsHandler_=new ChromeEventHandler(chrome.settingsPrivate.onPrefsChanged,(prefs=>this.updateFromPrefs_(prefs)));this.onMouseMovedHandler_=new EventHandler([],chrome.automation.EventType.MOUSE_MOVED,(()=>this.onMouseMovedOrDragged_()));this.onMouseDraggedHandler_=new EventHandler([],chrome.automation.EventType.MOUSE_DRAGGED,(()=>this.onMouseMovedOrDragged_()));this.onLoadDesktopCallbackForTest_=null;this.init_()}onMagnifierDisabled(){this.focusHandler_.stop();this.activeDescendantHandler_.stop();this.selectionHandler_.stop();this.onCaretBoundsChangedHandler.stop();this.onMagnifierBoundsChangedHandler_.stop();this.onChromeVoxFocusChangedHandler_.stop();this.onSelectToSpeakFocusChangedHandler_.stop();this.updateFromPrefsHandler_.stop();this.onMouseMovedHandler_.stop();this.onMouseDraggedHandler_.stop();this.lastMouseMovedTime_=undefined;this.lastChromeVoxBounds_=undefined;this.lastSelectToSpeakBounds_=undefined;this.lastFocusSelectionOrCaretMove_=undefined}init_(){chrome.settingsPrivate.getAllPrefs((prefs=>this.updateFromPrefs_(prefs)));this.updateFromPrefsHandler_.start();chrome.automation.getDesktop((desktop=>{this.focusHandler_.setNodes(desktop);this.focusHandler_.start();this.activeDescendantHandler_.setNodes(desktop);this.activeDescendantHandler_.start();this.selectionHandler_.setNodes(desktop);this.selectionHandler_.start();this.onCaretBoundsChangedHandler.setNodes(desktop);this.onCaretBoundsChangedHandler.start();this.onMouseMovedHandler_.setNodes(desktop);this.onMouseMovedHandler_.start();this.onMouseDraggedHandler_.setNodes(desktop);this.onMouseDraggedHandler_.start();if(this.onLoadDesktopCallbackForTest_){this.onLoadDesktopCallbackForTest_();this.onLoadDesktopCallbackForTest_=null}}));this.onMagnifierBoundsChangedHandler_.start();this.onChromeVoxFocusChangedHandler_.start();this.onSelectToSpeakFocusChangedHandler_.start();chrome.accessibilityPrivate.enableMouseEvents(true);this.isInitializing_=true;setTimeout((()=>{this.isInitializing_=false}),Magnifier.IGNORE_FOCUS_UPDATES_INITIALIZATION_MS)}drawDebugRect_(){return Boolean(Flags.isEnabled(FlagName.MAGNIFIER_DEBUG_DRAW_RECT))}onMagnifierBoundsChanged_(bounds){if(this.drawDebugRect_()){chrome.accessibilityPrivate.setFocusRings([{rects:[bounds],type:chrome.accessibilityPrivate.FocusType.GLOW,color:"#22d"}],chrome.accessibilityPrivate.AssistiveTechnologyType.MAGNIFIER)}}onChromeVoxFocusChanged_(bounds){if(!this.shouldFollowChromeVoxFocus()){return}const now=(new Date).getTime();if(this.lastMouseMovedTime_!==undefined&&now-this.lastMouseMovedTime_.getTime()<Magnifier.IGNORE_AT_UPDATES_AFTER_OTHER_MOVE_MS||this.lastFocusSelectionOrCaretMove_!==undefined&&now-this.lastFocusSelectionOrCaretMove_.getTime()<Magnifier.IGNORE_AT_UPDATES_AFTER_OTHER_MOVE_MS){return}if(bounds!==this.lastChromeVoxBounds_){this.lastChromeVoxBounds_=bounds;chrome.accessibilityPrivate.moveMagnifierToRect(bounds)}}onSelectToSpeakFocusChanged_(bounds){if(!this.shouldFollowStsFocus()){return}const now=(new Date).getTime();if(this.lastMouseMovedTime_!==undefined&&now-this.lastMouseMovedTime_.getTime()<Magnifier.IGNORE_AT_UPDATES_AFTER_OTHER_MOVE_MS||this.lastFocusSelectionOrCaretMove_!==undefined&&now-this.lastFocusSelectionOrCaretMove_.getTime()<Magnifier.IGNORE_AT_UPDATES_AFTER_OTHER_MOVE_MS){return}if(bounds!==this.lastSelectToSpeakBounds_){this.lastSelectToSpeakBounds_=bounds;chrome.accessibilityPrivate.moveMagnifierToRect(bounds)}}setIsInitializingForTest(isInitializing){this.isInitializing_=isInitializing}setIgnoreAssistiveTechnologyUpdatesAfterOtherMoveDurationForTest(duration){Magnifier.IGNORE_AT_UPDATES_AFTER_OTHER_MOVE_MS=duration}updateFromPrefs_(prefs){prefs.forEach((pref=>{switch(pref.key){case Magnifier.Prefs.SCREEN_MAGNIFIER_CHROMEVOX_FOCUS_FOLLOWING:this.screenMagnifierFollowsChromeVox_=Boolean(pref.value);break;case Magnifier.Prefs.SCREEN_MAGNIFIER_FOCUS_FOLLOWING:this.screenMagnifierFocusFollowing_=Boolean(pref.value);break;case Magnifier.Prefs.SCREEN_MAGNIFIER_SELECT_TO_SPEAK_FOCUS_FOLLOWING:this.screenMagnifierFollowsSts_=Boolean(pref.value);break;default:return}}))}shouldFollowFocus(){return Boolean(!this.isInitializing_&&(this.type===Magnifier.Type.DOCKED||this.type===Magnifier.Type.FULL_SCREEN&&this.screenMagnifierFocusFollowing_))}shouldFollowChromeVoxFocus(){return!this.isInitializing_&&this.screenMagnifierFollowsChromeVox_}shouldFollowStsFocus(){return!this.isInitializing_&&this.screenMagnifierFollowsSts_}onFocusOrSelectionChanged_(event){const node=event.target;if(!node.location||!this.shouldFollowFocus()){return}if(Number(new Date)-Number(this.lastMouseMovedTime_)<Magnifier.IGNORE_FOCUS_UPDATES_AFTER_MOUSE_MOVE_MS){return}const isTooBig=AutomationPredicate.roles([RoleType.WEB_VIEW,RoleType.EMBEDDED_OBJECT]);if(node.isRootNode||isTooBig(node)){return}this.lastFocusSelectionOrCaretMove_=new Date;chrome.accessibilityPrivate.moveMagnifierToRect(node.location)}onActiveDescendantChanged_(event){const{activeDescendant:activeDescendant}=event.target;if(!activeDescendant||!this.shouldFollowFocus()){return}const{location:location}=activeDescendant;if(!location){return}chrome.accessibilityPrivate.moveMagnifierToRect(location)}onCaretBoundsChanged(event){const{target:target}=event;if(!target||!target.caretBounds){return}if(Number(new Date)-Number(this.lastMouseMovedTime_)<Magnifier.IGNORE_FOCUS_UPDATES_AFTER_MOUSE_MOVE_MS){return}if(target.caretBounds.width===0&&target.caretBounds.height===0){return}this.lastFocusSelectionOrCaretMove_=new Date;const caretBoundsCenter=RectUtil.center(target.caretBounds);chrome.accessibilityPrivate.magnifierCenterOnPoint(caretBoundsCenter)}onMouseMovedOrDragged_(){this.lastMouseMovedTime_=new Date}setOnLoadDesktopCallbackForTest(callback){if(!this.focusHandler_.listening()){this.onLoadDesktopCallbackForTest_=callback;return}callback()}}(function(Magnifier){(function(Type){Type["FULL_SCREEN"]="fullScreen";Type["DOCKED"]="docked"})(Magnifier.Type||(Magnifier.Type={}));(function(Prefs){Prefs["SCREEN_MAGNIFIER_FOCUS_FOLLOWING"]="settings.a11y.screen_magnifier_focus_following";Prefs["SCREEN_MAGNIFIER_CHROMEVOX_FOCUS_FOLLOWING"]="settings.a11y.screen_magnifier_chromevox_focus_following";Prefs["SCREEN_MAGNIFIER_SELECT_TO_SPEAK_FOCUS_FOLLOWING"]="settings.a11y.screen_magnifier_select_to_speak_focus_following"})(Magnifier.Prefs||(Magnifier.Prefs={}));Magnifier.IGNORE_FOCUS_UPDATES_INITIALIZATION_MS=500;Magnifier.IGNORE_FOCUS_UPDATES_AFTER_MOUSE_MOVE_MS=250;Magnifier.IGNORE_AT_UPDATES_AFTER_OTHER_MOVE_MS=1500})(Magnifier||(Magnifier={}));TestImportManager.exportForTesting(Magnifier);class AccessibilityCommon{autoclick_=null;magnifier_=null;dictation_=null;faceGaze_=null;autoclickLoadCallbackForTest_=null;magnifierLoadCallbackForTest_=null;dictationLoadCallbackForTest_=null;facegazeLoadCallbackForTest_=null;static FACEGAZE_PREF_NAME="settings.a11y.face_gaze.enabled";constructor(){this.init_()}static async init(){await Flags.init();globalThis.accessibilityCommon=new AccessibilityCommon}getAutoclickForTest(){return this.autoclick_}getFaceGazeForTest(){return this.faceGaze_}getMagnifierForTest(){return this.magnifier_}init_(){chrome.accessibilityFeatures.autoclick.get({},(details=>this.onAutoclickUpdated_(details)));chrome.accessibilityFeatures.autoclick.onChange.addListener((details=>this.onAutoclickUpdated_(details)));chrome.accessibilityFeatures.screenMagnifier.get({},(details=>this.onMagnifierUpdated_(Magnifier.Type.FULL_SCREEN,details)));chrome.accessibilityFeatures.screenMagnifier.onChange.addListener((details=>this.onMagnifierUpdated_(Magnifier.Type.FULL_SCREEN,details)));chrome.accessibilityFeatures.dockedMagnifier.get({},(details=>this.onMagnifierUpdated_(Magnifier.Type.DOCKED,details)));chrome.accessibilityFeatures.dockedMagnifier.onChange.addListener((details=>this.onMagnifierUpdated_(Magnifier.Type.DOCKED,details)));chrome.accessibilityFeatures.dictation.get({},(details=>this.onDictationUpdated_(details)));chrome.accessibilityFeatures.dictation.onChange.addListener((details=>this.onDictationUpdated_(details)));chrome.settingsPrivate.getPref(AccessibilityCommon.FACEGAZE_PREF_NAME,(pref=>this.onFaceGazeUpdated_(pref)));chrome.settingsPrivate.onPrefsChanged.addListener((prefs=>{for(const pref of prefs){if(pref.key===AccessibilityCommon.FACEGAZE_PREF_NAME){this.onFaceGazeUpdated_(pref);break}}}));Dictation.removeAsInputMethod()}onAutoclickUpdated_(details){if(details.value&&!this.autoclick_){this.autoclick_=new Autoclick;if(this.autoclickLoadCallbackForTest_){this.autoclick_.setOnLoadDesktopCallbackForTest(this.autoclickLoadCallbackForTest_);this.autoclickLoadCallbackForTest_=null}}else if(!details.value&&this.autoclick_){this.autoclick_.onAutoclickDisabled();this.autoclick_=null}}onFaceGazeUpdated_(details){if(details.value&&!this.faceGaze_){this.faceGaze_=new FaceGaze((()=>{if(!this.dictation_){return false}return this.dictation_.isActive()}));if(this.facegazeLoadCallbackForTest_){this.facegazeLoadCallbackForTest_();this.facegazeLoadCallbackForTest_=null}}else if(!details.value&&this.faceGaze_){this.faceGaze_.onFaceGazeDisabled();this.faceGaze_=null}}onMagnifierUpdated_(type,details){if(details.value&&!this.magnifier_){this.magnifier_=new Magnifier(type);if(this.magnifierLoadCallbackForTest_){this.magnifier_.setOnLoadDesktopCallbackForTest(this.magnifierLoadCallbackForTest_);this.magnifierLoadCallbackForTest_=null}}else if(!details.value&&this.magnifier_&&this.magnifier_.type===type){this.magnifier_.onMagnifierDisabled();this.magnifier_=null}}onDictationUpdated_(details){if(details.value&&!this.dictation_){this.dictation_=new Dictation;if(this.dictationLoadCallbackForTest_){this.dictationLoadCallbackForTest_();this.dictationLoadCallbackForTest_=null}}else if(!details.value&&this.dictation_){this.dictation_.onDictationDisabled();this.dictation_=null}}setFeatureLoadCallbackForTest(feature,callback){if(feature==="autoclick"){if(!this.autoclick_){this.autoclickLoadCallbackForTest_=callback;return}this.autoclick_.setOnLoadDesktopCallbackForTest(callback)}else if(feature==="dictation"){if(!this.dictation_){this.dictationLoadCallbackForTest_=callback;return}callback()}else if(feature==="magnifier"){if(!this.magnifier_){this.magnifierLoadCallbackForTest_=callback;return}this.magnifier_.setOnLoadDesktopCallbackForTest(callback)}else if(feature==="facegaze"){if(!this.faceGaze_){this.facegazeLoadCallbackForTest_=callback;return}callback()}}}InstanceChecker.closeExtraInstances();AccessibilityCommon.init();TestImportManager.exportForTesting(["AccessibilityCommon",AccessibilityCommon]);export{AccessibilityCommon};