// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{TestImportManager}from"../../../../../../../../../../../../../../../../../../../../common/testing/test_import_manager.js";var FromPumpkinTaggerCommand;(function(FromPumpkinTaggerCommand){FromPumpkinTaggerCommand["READY"]="ready";FromPumpkinTaggerCommand["FULLY_INITIALIZED"]="fullyInitialized";FromPumpkinTaggerCommand["TAG_RESULTS"]="tagResults";FromPumpkinTaggerCommand["REFRESHED"]="refreshed"})(FromPumpkinTaggerCommand||(FromPumpkinTaggerCommand={}));var ToPumpkinTaggerCommand;(function(ToPumpkinTaggerCommand){ToPumpkinTaggerCommand["LOAD"]="load";ToPumpkinTaggerCommand["TAG"]="tagAndGetNBestHypotheses";ToPumpkinTaggerCommand["REFRESH"]="refresh"})(ToPumpkinTaggerCommand||(ToPumpkinTaggerCommand={}));var PumpkinLocale;(function(PumpkinLocale){PumpkinLocale["EN_US"]="en_us";PumpkinLocale["FR_FR"]="fr_fr";PumpkinLocale["IT_IT"]="it_it";PumpkinLocale["DE_DE"]="de_de";PumpkinLocale["ES_ES"]="es_es"})(PumpkinLocale||(PumpkinLocale={}));const SUPPORTED_LOCALES={"en-US":PumpkinLocale.EN_US,"en-AU":PumpkinLocale.EN_US,"en-CA":PumpkinLocale.EN_US,"en-GB":PumpkinLocale.EN_US,"en-GH":PumpkinLocale.EN_US,"en-HK":PumpkinLocale.EN_US,"en-IN":PumpkinLocale.EN_US,"en-KE":PumpkinLocale.EN_US,"en-NG":PumpkinLocale.EN_US,"en-NZ":PumpkinLocale.EN_US,"en-PH":PumpkinLocale.EN_US,"en-PK":PumpkinLocale.EN_US,"en-SG":PumpkinLocale.EN_US,"en-TZ":PumpkinLocale.EN_US,"en-ZA":PumpkinLocale.EN_US,"fr-BE":PumpkinLocale.FR_FR,"fr-CA":PumpkinLocale.FR_FR,"fr-CH":PumpkinLocale.FR_FR,"fr-FR":PumpkinLocale.FR_FR,"it-CH":PumpkinLocale.IT_IT,"it-IT":PumpkinLocale.IT_IT,"de-AT":PumpkinLocale.DE_DE,"de-CH":PumpkinLocale.DE_DE,"de-DE":PumpkinLocale.DE_DE,"es-AR":PumpkinLocale.ES_ES,"es-BO":PumpkinLocale.ES_ES,"es-CL":PumpkinLocale.ES_ES,"es-CO":PumpkinLocale.ES_ES,"es-CR":PumpkinLocale.ES_ES,"es-DO":PumpkinLocale.ES_ES,"es-EC":PumpkinLocale.ES_ES,"es-ES":PumpkinLocale.ES_ES,"es-GT":PumpkinLocale.ES_ES,"es-HN":PumpkinLocale.ES_ES,"es-MX":PumpkinLocale.ES_ES,"es-NI":PumpkinLocale.ES_ES,"es-PA":PumpkinLocale.ES_ES,"es-PE":PumpkinLocale.ES_ES,"es-PR":PumpkinLocale.ES_ES,"es-PY":PumpkinLocale.ES_ES,"es-SV":PumpkinLocale.ES_ES,"es-US":PumpkinLocale.ES_ES,"es-UY":PumpkinLocale.ES_ES,"es-VE":PumpkinLocale.ES_ES};var HypothesisArgumentName;(function(HypothesisArgumentName){HypothesisArgumentName["SEM_TAG"]="SEM_TAG";HypothesisArgumentName["NUM_ARG"]="NUM_ARG";HypothesisArgumentName["OPEN_ENDED_TEXT"]="OPEN_ENDED_TEXT";HypothesisArgumentName["BEGIN_PHRASE"]="BEGIN_PHRASE";HypothesisArgumentName["END_PHRASE"]="END_PHRASE"})(HypothesisArgumentName||(HypothesisArgumentName={}));TestImportManager.exportForTesting(["SUPPORTED_LOCALES",SUPPORTED_LOCALES]);class SandboxedPumpkinTagger{constructor(){this.init_()}pumpkinTagger_=null;pumpkinData_=null;init_(){globalThis.addEventListener("message",(message=>this.onMessage_(message)));this.sendToBackground_({type:FromPumpkinTaggerCommand.READY})}onMessage_(message){const command=message.data;switch(command.type){case ToPumpkinTaggerCommand.LOAD:if(!command.pumpkinData){throw new Error(`Can't load pumpkin tagger from empty data`)}if(!command.locale){throw new Error(`Can't load pumpkin tagger from empty locale`)}this.load_(command.pumpkinData,command.locale);return;case ToPumpkinTaggerCommand.TAG:this.tagAndGetNBestHypotheses_(command.text,command.numResults);return;case ToPumpkinTaggerCommand.REFRESH:if(!command.locale){throw new Error(`Can't load pumpkin tagger from empty locale`)}this.refresh_(command.locale);return;default:throw new Error(`Unrecognized message received in SandboxedPumpkinTagger: ${command.type}`)}}sendToBackground_(command){postMessage(command)}tagAndGetNBestHypotheses_(text,numResults){const results=this.pumpkinTagger_.tagAndGetNBestHypotheses(text,numResults);this.sendToBackground_({type:FromPumpkinTaggerCommand.TAG_RESULTS,results:results})}async load_(data,locale){this.pumpkinData_=data;const pumpkinTaggerBytes=data.js_pumpkin_tagger_bin_js;if(!pumpkinTaggerBytes){throw new Error(`Pumpkin tagger bytes must be valid`)}const pumpkinTaggerFile=(new TextDecoder).decode(pumpkinTaggerBytes);const indirectEval=eval;const pumpkinTaggerModule=indirectEval(pumpkinTaggerFile);if(!pumpkinTaggerModule){throw new Error("Failed to eval pumpkin tagger file")}const pumpkinTagger=new pumpkinTaggerModule;globalThis.fetch=async()=>new Promise((resolve=>{const response=new Response(null,{status:200});response.arrayBuffer=async()=>new Promise((resolve=>{resolve(data.tagger_wasm_main_wasm)}));resolve(response)}));const taggerWasmBytes=data.tagger_wasm_main_js;if(!taggerWasmBytes){throw new Error(`Pumpkin wasm bytes must be valid`)}const taggerWasmJsFile=(new TextDecoder).decode(taggerWasmBytes);const wasmLoadPromise=new Promise((resolve=>{globalThis["goog"]["global"]["Module"]={onRuntimeInitialized(){resolve()}}}));indirectEval(taggerWasmJsFile);await wasmLoadPromise;const{pumpkinConfig:pumpkinConfig,actionConfig:actionConfig}=this.getConfigsForLocale(locale);pumpkinTagger.initializeFromPumpkinConfig(pumpkinConfig);pumpkinTagger.loadActionFrame(actionConfig);this.pumpkinTagger_=pumpkinTagger;this.sendToBackground_({type:FromPumpkinTaggerCommand.FULLY_INITIALIZED})}refresh_(locale){if(!this.pumpkinTagger_){throw new Error("SandboxedPumpkinTagger must be initialized before calling refresh")}const{pumpkinConfig:pumpkinConfig,actionConfig:actionConfig}=this.getConfigsForLocale(locale);this.pumpkinTagger_.initializeFromPumpkinConfig(pumpkinConfig);this.pumpkinTagger_.loadActionFrame(actionConfig);this.sendToBackground_({type:FromPumpkinTaggerCommand.REFRESHED})}getConfigsForLocale(locale){let pumpkinConfig;let actionConfig;switch(locale){case PumpkinLocale.EN_US:pumpkinConfig=this.pumpkinData_.en_us_pumpkin_config_binarypb;actionConfig=this.pumpkinData_.en_us_action_config_binarypb;break;case PumpkinLocale.FR_FR:pumpkinConfig=this.pumpkinData_.fr_fr_pumpkin_config_binarypb;actionConfig=this.pumpkinData_.fr_fr_action_config_binarypb;break;case PumpkinLocale.IT_IT:pumpkinConfig=this.pumpkinData_.it_it_pumpkin_config_binarypb;actionConfig=this.pumpkinData_.it_it_action_config_binarypb;break;case PumpkinLocale.DE_DE:pumpkinConfig=this.pumpkinData_.de_de_pumpkin_config_binarypb;actionConfig=this.pumpkinData_.de_de_action_config_binarypb;break;case PumpkinLocale.ES_ES:pumpkinConfig=this.pumpkinData_.es_es_pumpkin_config_binarypb;actionConfig=this.pumpkinData_.es_es_action_config_binarypb;break;default:throw new Error(`Can't initialize Pumpkin in unsupported locale: ${locale}`)}if(!pumpkinConfig||!actionConfig){throw new Error(`Either pumpkinConfig or actionConfig is invalid for locale: ${locale}`)}return{pumpkinConfig:pumpkinConfig,actionConfig:actionConfig}}}new SandboxedPumpkinTagger;