// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{BridgeHelper}from"../../../../../../../../../../../../../../../../../../../common/bridge_helper.js";import{BrowserUtil}from"../../../../../../../../../../../../../../../../../../../common/browser_util.js";import{constants}from"../../../../../../../../../../../../../../../../../../../common/constants.js";import{LocalStorage}from"../../../../../../../../../../../../../../../../../../../common/local_storage.js";import{TestImportManager}from"../../../../../../../../../../../../../../../../../../../common/testing/test_import_manager.js";import{MessageFormat}from"../../../../../../../../../../../../../../../../../../../chromevox/mv2/third_party/messageformat/messageformat.rollup.js";import{Settings}from"../../../../../../../../../../../../../../../../../../../common/settings.js";import{StringUtil}from"../../../../../../../../../../../../../../../../../../../common/string_util.js";import{KeyCode}from"../../../../../../../../../../../../../../../../../../../common/key_code.js";import{AsyncUtil}from"../../../../../../../../../../../../../../../../../../../common/async_util.js";import{AutomationPredicate}from"../../../../../../../../../../../../../../../../../../../common/automation_predicate.js";import{BridgeCallbackManager}from"../../../../../../../../../../../../../../../../../../../common/bridge_callback_manager.js";var BridgeContext;(function(BridgeContext){BridgeContext["BACKGROUND"]="background";BridgeContext["LEARN_MODE"]="learnMode";BridgeContext["LOG_PAGE"]="logPage";BridgeContext["OPTIONS"]="options";BridgeContext["PANEL"]="panel"})(BridgeContext||(BridgeContext={}));const BridgeConstants={Braille:{TARGET:"Braille",Action:{BACK_TRANSLATE:"backTranslate",PAN_LEFT:"panLeft",PAN_RIGHT:"panRight",SET_BYPASS:"setBypass",WRITE:"write"}},ChromeVoxPrefs:{TARGET:"ChromeVoxPrefs",Action:{GET_PREFS:"getPrefs",GET_STICKY_PREF:"getStickyPref",SET_LOGGING_PREFS:"setLoggingPrefs",SET_PREF:"setPref"}},ChromeVoxRange:{TARGET:"ChromeVoxRange",Action:{CLEAR_CURRENT_RANGE:"clearCurrentRange"}},CommandHandler:{TARGET:"CommandHandler",Action:{ON_COMMAND:"onCommand"}},Earcons:{TARGET:"Earcons",Action:{CANCEL_EARCON:"cancelEarcon",PLAY_EARCON:"playEarcon"}},EventSource:{TARGET:"EventSource",Action:{GET:"get"}},EventStreamLogger:{TARGET:"EventStreamLogger",Action:{NOTIFY_EVENT_STREAM_FILTER_CHANGED:"notifyEventStreamFilterChanged"}},ForcedActionPath:{TARGET:"ForcedActionPath",Action:{LISTEN_FOR:"listenFor",ON_KEY_DOWN:"onKeyDown",STOP_LISTENING:"stopListening"}},GestureCommandHandler:{TARGET:"GestureCommandHandler",Action:{SET_BYPASS:"setBypass"}},LearnMode:{TARGET:"LearnMode",Action:{CLEAR_TOUCH_EXPLORE_OUTPUT_TIME:"clearTouchExploreOutputTime",ON_ACCESSIBILITY_GESTURE:"onAccessibilityGesture",ON_BRAILLE_KEY_EVENT:"onBrailleKeyEvent",ON_KEY_DOWN:"onKeyDown",ON_KEY_UP:"onKeyUp",READY:"ready"}},LogStore:{TARGET:"LogStore",Action:{CLEAR_LOG:"clearLog",GET_LOGS:"getLogs"}},Panel:{TARGET:"Panel",Action:{ADD_MENU_ITEM:"addMenuItem",ON_CURRENT_RANGE_CHANGED:"onCurrentRangeChanged"}},PanelBackground:{TARGET:"PanelBackground",Action:{CLEAR_SAVED_NODE:"clearSavedNode",CREATE_ALL_NODE_MENU_BACKGROUNDS:"createAllNodeMenuBackgrounds",CREATE_NEW_I_SEARCH:"createNewISearch",DESTROY_I_SEARCH:"destroyISearch",GET_ACTIONS_FOR_CURRENT_NODE:"getActionsForCurrentNode",INCREMENTAL_SEARCH:"incrementalSearch",NODE_MENU_CALLBACK:"nodeMenuCallback",ON_TUTORIAL_READY:"onTutorialReady",PERFORM_CUSTOM_ACTION_ON_CURRENT_NODE:"performCustomActionOnCurrentNode",PERFORM_STANDARD_ACTION_ON_CURRENT_NODE:"performStandardActionOnCurrentNode",SAVE_CURRENT_NODE:"saveCurrentNode",SET_PANEL_COLLAPSE_WATCHER:"setPanelCollapseWatcher",SET_RANGE_TO_I_SEARCH_NODE:"setRangeToISearchNode",WAIT_FOR_PANEL_COLLAPSE:"waitForPanelCollapse"}},TtsBackground:{TARGET:"TtsBackground",Action:{GET_CURRENT_VOICE:"getCurrentVoice",SPEAK:"speak",UPDATE_PUNCTUATION_ECHO:"updatePunctuationEcho"}}};const BackgroundBridge={Braille:{backTranslate(cells){return BridgeHelper.sendMessage(BridgeConstants.Braille.TARGET,BridgeConstants.Braille.Action.BACK_TRANSLATE,cells)},panLeft(){return BridgeHelper.sendMessage(BridgeConstants.Braille.TARGET,BridgeConstants.Braille.Action.PAN_LEFT)},panRight(){return BridgeHelper.sendMessage(BridgeConstants.Braille.TARGET,BridgeConstants.Braille.Action.PAN_RIGHT)},setBypass(bypassed){return BridgeHelper.sendMessage(BridgeConstants.Braille.TARGET,BridgeConstants.Braille.Action.SET_BYPASS,bypassed)},write(text){return BridgeHelper.sendMessage(BridgeConstants.Braille.TARGET,BridgeConstants.Braille.Action.WRITE,text)}},ChromeVoxPrefs:{getPrefs(){return BridgeHelper.sendMessage(BridgeConstants.ChromeVoxPrefs.TARGET,BridgeConstants.ChromeVoxPrefs.Action.GET_PREFS)},getStickyPref(){return BridgeHelper.sendMessage(BridgeConstants.ChromeVoxPrefs.TARGET,BridgeConstants.ChromeVoxPrefs.Action.GET_STICKY_PREF)},setLoggingPrefs(key,value){return BridgeHelper.sendMessage(BridgeConstants.ChromeVoxPrefs.TARGET,BridgeConstants.ChromeVoxPrefs.Action.SET_LOGGING_PREFS,key,value)},setPref(key,value){return BridgeHelper.sendMessage(BridgeConstants.ChromeVoxPrefs.TARGET,BridgeConstants.ChromeVoxPrefs.Action.SET_PREF,key,value)}},ChromeVoxRange:{clearCurrentRange(){return BridgeHelper.sendMessage(BridgeConstants.ChromeVoxRange.TARGET,BridgeConstants.ChromeVoxRange.Action.CLEAR_CURRENT_RANGE)}},CommandHandler:{onCommand(command){return BridgeHelper.sendMessage(BridgeConstants.CommandHandler.TARGET,BridgeConstants.CommandHandler.Action.ON_COMMAND,command)}},Earcons:{cancelEarcon(earconId){return BridgeHelper.sendMessage(BridgeConstants.Earcons.TARGET,BridgeConstants.Earcons.Action.CANCEL_EARCON,earconId)},playEarcon(earconId){return BridgeHelper.sendMessage(BridgeConstants.Earcons.TARGET,BridgeConstants.Earcons.Action.PLAY_EARCON,earconId)}},EventSource:{get(){return BridgeHelper.sendMessage(BridgeConstants.EventSource.TARGET,BridgeConstants.EventSource.Action.GET)}},GestureCommandHandler:{setBypass(bypassed){return BridgeHelper.sendMessage(BridgeConstants.GestureCommandHandler.TARGET,BridgeConstants.GestureCommandHandler.Action.SET_BYPASS,bypassed)}},EventStreamLogger:{notifyEventStreamFilterChanged(name,enabled){return BridgeHelper.sendMessage(BridgeConstants.EventStreamLogger.TARGET,BridgeConstants.EventStreamLogger.Action.NOTIFY_EVENT_STREAM_FILTER_CHANGED,name,enabled)}},ForcedActionPath:{listenFor(actions){return BridgeHelper.sendMessage(BridgeConstants.ForcedActionPath.TARGET,BridgeConstants.ForcedActionPath.Action.LISTEN_FOR,actions)},stopListening(){return BridgeHelper.sendMessage(BridgeConstants.ForcedActionPath.TARGET,BridgeConstants.ForcedActionPath.Action.STOP_LISTENING)},onKeyDown(event){return BridgeHelper.sendMessage(BridgeConstants.ForcedActionPath.TARGET,BridgeConstants.ForcedActionPath.Action.ON_KEY_DOWN,event)}},LogStore:{clearLog(){return BridgeHelper.sendMessage(BridgeConstants.LogStore.TARGET,BridgeConstants.LogStore.Action.CLEAR_LOG)},getLogs(){return BridgeHelper.sendMessage(BridgeConstants.LogStore.TARGET,BridgeConstants.LogStore.Action.GET_LOGS)}},PanelBackground:{clearSavedNode(){return BridgeHelper.sendMessage(BridgeConstants.PanelBackground.TARGET,BridgeConstants.PanelBackground.Action.CLEAR_SAVED_NODE)},createAllNodeMenuBackgrounds(activatedMenuTitle){return BridgeHelper.sendMessage(BridgeConstants.PanelBackground.TARGET,BridgeConstants.PanelBackground.Action.CREATE_ALL_NODE_MENU_BACKGROUNDS,activatedMenuTitle)},createNewISearch(){return BridgeHelper.sendMessage(BridgeConstants.PanelBackground.TARGET,BridgeConstants.PanelBackground.Action.CREATE_NEW_I_SEARCH)},destroyISearch(){return BridgeHelper.sendMessage(BridgeConstants.PanelBackground.TARGET,BridgeConstants.PanelBackground.Action.DESTROY_I_SEARCH)},getActionsForCurrentNode(){return BridgeHelper.sendMessage(BridgeConstants.PanelBackground.TARGET,BridgeConstants.PanelBackground.Action.GET_ACTIONS_FOR_CURRENT_NODE)},incrementalSearch(searchStr,dir,nextObject){return BridgeHelper.sendMessage(BridgeConstants.PanelBackground.TARGET,BridgeConstants.PanelBackground.Action.INCREMENTAL_SEARCH,searchStr,dir,nextObject)},onTutorialReady(){return BridgeHelper.sendMessage(BridgeConstants.PanelBackground.TARGET,BridgeConstants.PanelBackground.Action.ON_TUTORIAL_READY)},performCustomActionOnCurrentNode(actionId){return BridgeHelper.sendMessage(BridgeConstants.PanelBackground.TARGET,BridgeConstants.PanelBackground.Action.PERFORM_CUSTOM_ACTION_ON_CURRENT_NODE,actionId)},performStandardActionOnCurrentNode(action){return BridgeHelper.sendMessage(BridgeConstants.PanelBackground.TARGET,BridgeConstants.PanelBackground.Action.PERFORM_STANDARD_ACTION_ON_CURRENT_NODE,action)},saveCurrentNode(){return BridgeHelper.sendMessage(BridgeConstants.PanelBackground.TARGET,BridgeConstants.PanelBackground.Action.SAVE_CURRENT_NODE)},async setPanelCollapseWatcher(){return BridgeHelper.sendMessage(BridgeConstants.PanelBackground.TARGET,BridgeConstants.PanelBackground.Action.SET_PANEL_COLLAPSE_WATCHER)},setRangeToISearchNode(){return BridgeHelper.sendMessage(BridgeConstants.PanelBackground.TARGET,BridgeConstants.PanelBackground.Action.SET_RANGE_TO_I_SEARCH_NODE)},waitForPanelCollapse(){return BridgeHelper.sendMessage(BridgeConstants.PanelBackground.TARGET,BridgeConstants.PanelBackground.Action.WAIT_FOR_PANEL_COLLAPSE)}},TtsBackground:{getCurrentVoice(){return BridgeHelper.sendMessage(BridgeConstants.TtsBackground.TARGET,BridgeConstants.TtsBackground.Action.GET_CURRENT_VOICE)},speak(textString,queueMode,properties){return BridgeHelper.sendMessage(BridgeConstants.TtsBackground.TARGET,BridgeConstants.TtsBackground.Action.SPEAK,textString,queueMode,properties)},updatePunctuationEcho(punctuationEcho){return BridgeHelper.sendMessage(BridgeConstants.TtsBackground.TARGET,BridgeConstants.TtsBackground.Action.UPDATE_PUNCTUATION_ECHO,punctuationEcho)}}};var Command;(function(Command){Command["ANNOUNCE_BATTERY_DESCRIPTION"]="announceBatteryDescription";Command["ANNOUNCE_HEADERS"]="announceHeaders";Command["ANNOUNCE_RICH_TEXT_DESCRIPTION"]="announceRichTextDescription";Command["AUTORUNNER"]="autorunner";Command["BACKWARD"]="backward";Command["BOTTOM"]="bottom";Command["CONTEXT_MENU"]="contextMenu";Command["COPY"]="copy";Command["CYCLE_PUNCTUATION_ECHO"]="cyclePunctuationEcho";Command["CYCLE_TYPING_ECHO"]="cycleTypingEcho";Command["DEBUG"]="debug";Command["DECREASE_TTS_PITCH"]="decreaseTtsPitch";Command["DECREASE_TTS_RATE"]="decreaseTtsRate";Command["DECREASE_TTS_VOLUME"]="decreaseTtsVolume";Command["DISABLE_CHROMEVOX_ARC_SUPPORT_FOR_CURRENT_APP"]="disableChromeVoxArcSupportForCurrentApp";Command["DISABLE_LOGGING"]="disableLogging";Command["DUMP_TREE"]="dumpTree";Command["ENABLE_CHROMEVOX_ARC_SUPPORT_FOR_CURRENT_APP"]="enableChromeVoxArcSupportForCurrentApp";Command["ENABLE_CONSOLE_TTS"]="enableConsoleTts";Command["ENABLE_LOGGING"]="enableLogging";Command["ENTER_SHIFTER"]="enterShifter";Command["EXIT_SHIFTER"]="exitShifter";Command["EXIT_SHIFTER_CONTENT"]="exitShifterContent";Command["FORCE_CLICK_ON_CURRENT_ITEM"]="forceClickOnCurrentItem";Command["FORCE_DOUBLE_CLICK_ON_CURRENT_ITEM"]="forceDoubleClickOnCurrentItem";Command["FORCE_LONG_CLICK_ON_CURRENT_ITEM"]="forceLongClickOnCurrentItem";Command["FORWARD"]="forward";Command["FULLY_DESCRIBE"]="fullyDescribe";Command["GO_TO_COL_FIRST_CELL"]="goToColFirstCell";Command["GO_TO_COL_LAST_CELL"]="goToColLastCell";Command["GO_TO_FIRST_CELL"]="goToFirstCell";Command["GO_TO_LAST_CELL"]="goToLastCell";Command["GO_TO_ROW_FIRST_CELL"]="goToRowFirstCell";Command["GO_TO_ROW_LAST_CELL"]="goToRowLastCell";Command["HANDLE_TAB"]="handleTab";Command["HANDLE_TAB_PREV"]="handleTabPrev";Command["HELP"]="help";Command["INCREASE_TTS_PITCH"]="increaseTtsPitch";Command["INCREASE_TTS_RATE"]="increaseTtsRate";Command["INCREASE_TTS_VOLUME"]="increaseTtsVolume";Command["JUMP_TO_BOTTOM"]="jumpToBottom";Command["JUMP_TO_DETAILS"]="jumpToDetails";Command["JUMP_TO_TOP"]="jumpToTop";Command["LEFT"]="left";Command["LINE_DOWN"]="lineDown";Command["LINE_UP"]="lineUp";Command["MOVE_TO_END_OF_LINE"]="moveToEndOfLine";Command["MOVE_TO_START_OF_LINE"]="moveToStartOfLine";Command["NOP"]="nop";Command["NATIVE_NEXT_CHARACTER"]="nativeNextCharacter";Command["NATIVE_NEXT_WORD"]="nativeNextWord";Command["NATIVE_PREVIOUS_CHARACTER"]="nativePreviousCharacter";Command["NATIVE_PREVIOUS_WORD"]="nativePreviousWord";Command["NEXT_ARTICLE"]="nextArticle";Command["NEXT_AT_GRANULARITY"]="nextAtGranularity";Command["NEXT_BUTTON"]="nextButton";Command["NEXT_CHARACTER"]="nextCharacter";Command["NEXT_CHECKBOX"]="nextCheckbox";Command["NEXT_COL"]="nextCol";Command["NEXT_COMBO_BOX"]="nextComboBox";Command["NEXT_CONTROL"]="nextControl";Command["NEXT_EDIT_TEXT"]="nextEditText";Command["NEXT_FORM_FIELD"]="nextFormField";Command["NEXT_GRANULARITY"]="nextGranularity";Command["NEXT_GRAPHIC"]="nextGraphic";Command["NEXT_GROUP"]="nextGroup";Command["NEXT_HEADING"]="nextHeading";Command["NEXT_HEADING_1"]="nextHeading1";Command["NEXT_HEADING_2"]="nextHeading2";Command["NEXT_HEADING_3"]="nextHeading3";Command["NEXT_HEADING_4"]="nextHeading4";Command["NEXT_HEADING_5"]="nextHeading5";Command["NEXT_HEADING_6"]="nextHeading6";Command["NEXT_INVALID_ITEM"]="nextInvalidItem";Command["NEXT_LANDMARK"]="nextLandmark";Command["NEXT_LINE"]="nextLine";Command["NEXT_LINK"]="nextLink";Command["NEXT_LIST"]="nextList";Command["NEXT_LIST_ITEM"]="nextListItem";Command["NEXT_MATH"]="nextMath";Command["NEXT_MEDIA"]="nextMedia";Command["NEXT_OBJECT"]="nextObject";Command["NEXT_PAGE"]="nextPage";Command["NEXT_RADIO"]="nextRadio";Command["NEXT_ROW"]="nextRow";Command["NEXT_SECTION"]="nextSection";Command["NEXT_SENTENCE"]="nextSentence";Command["NEXT_SIMILAR_ITEM"]="nextSimilarItem";Command["NEXT_SLIDER"]="nextSlider";Command["NEXT_TABLE"]="nextTable";Command["NEXT_VISITED_LINK"]="nextVisitedLink";Command["NEXT_WORD"]="nextWord";Command["OPEN_CHROMEVOX_MENUS"]="openChromeVoxMenus";Command["OPEN_KEYBOARD_SHORTCUTS"]="openKeyboardShortcuts";Command["OPEN_LONG_DESC"]="openLongDesc";Command["PAN_LEFT"]="panLeft";Command["PAN_RIGHT"]="panRight";Command["PASS_THROUGH_MODE"]="passThroughMode";Command["PAUSE_ALL_MEDIA"]="pauseAllMedia";Command["PREVIOUS_ARTICLE"]="previousArticle";Command["PREVIOUS_AT_GRANULARITY"]="previousAtGranularity";Command["PREVIOUS_BUTTON"]="previousButton";Command["PREVIOUS_CHARACTER"]="previousCharacter";Command["PREVIOUS_CHECKBOX"]="previousCheckbox";Command["PREVIOUS_COMBO_BOX"]="previousComboBox";Command["PREVIOUS_COL"]="previousCol";Command["PREVIOUS_CONTROL"]="previousControl";Command["PREVIOUS_EDIT_TEXT"]="previousEditText";Command["PREVIOUS_FORM_FIELD"]="previousFormField";Command["PREVIOUS_GRANULARITY"]="previousGranularity";Command["PREVIOUS_GRAPHIC"]="previousGraphic";Command["PREVIOUS_GROUP"]="previousGroup";Command["PREVIOUS_HEADING"]="previousHeading";Command["PREVIOUS_HEADING_1"]="previousHeading1";Command["PREVIOUS_HEADING_2"]="previousHeading2";Command["PREVIOUS_HEADING_3"]="previousHeading3";Command["PREVIOUS_HEADING_4"]="previousHeading4";Command["PREVIOUS_HEADING_5"]="previousHeading5";Command["PREVIOUS_HEADING_6"]="previousHeading6";Command["PREVIOUS_INVALID_ITEM"]="previousInvalidItem";Command["PREVIOUS_LANDMARK"]="previousLandmark";Command["PREVIOUS_LINE"]="previousLine";Command["PREVIOUS_LINK"]="previousLink";Command["PREVIOUS_LIST"]="previousList";Command["PREVIOUS_LIST_ITEM"]="previousListItem";Command["PREVIOUS_MATH"]="previousMath";Command["PREVIOUS_MEDIA"]="previousMedia";Command["PREVIOUS_OBJECT"]="previousObject";Command["PREVIOUS_PAGE"]="previousPage";Command["PREVIOUS_RADIO"]="previousRadio";Command["PREVIOUS_ROW"]="previousRow";Command["PREVIOUS_SECTION"]="previousSection";Command["PREVIOUS_SENTENCE"]="previousSentence";Command["PREVIOUS_SIMILAR_ITEM"]="previousSimilarItem";Command["PREVIOUS_SLIDER"]="previousSlider";Command["PREVIOUS_TABLE"]="previousTable";Command["PREVIOUS_VISITED_LINK"]="previousVisitedLink";Command["PREVIOUS_WORD"]="previousWord";Command["READ_CURRENT_TITLE"]="readCurrentTitle";Command["READ_CURRENT_URL"]="readCurrentURL";Command["READ_FROM_HERE"]="readFromHere";Command["READ_LINK_URL"]="readLinkURL";Command["READ_PHONETIC_PRONUNCIATION"]="readPhoneticPronunciation";Command["REPORT_ISSUE"]="reportIssue";Command["RESET_TEXT_TO_SPEECH_SETTINGS"]="resetTextToSpeechSettings";Command["RIGHT"]="right";Command["ROUTING"]="routing";Command["SCROLL_BACKWARD"]="scrollBackward";Command["SCROLL_FORWARD"]="scrollForward";Command["SHOW_ACTIONS_MENU"]="showActionsMenu";Command["SHOW_FORMS_LIST"]="showFormsList";Command["SHOW_HEADINGS_LIST"]="showHeadingsList";Command["SHOW_LANDMARKS_LIST"]="showLandmarksList";Command["SHOW_LEARN_MODE_PAGE"]="showLearnModePage";Command["SHOW_LINKS_LIST"]="showLinksList";Command["SHOW_LOG_PAGE"]="showLogPage";Command["SHOW_OPTIONS_PAGE"]="showOptionsPage";Command["SHOW_PANEL_MENU_MOST_RECENT"]="showPanelMenuMostRecent";Command["SHOW_TABLES_LIST"]="showTablesList";Command["SHOW_TALKBACK_KEYBOARD_SHORTCUTS"]="showTalkBackKeyboardShortcuts";Command["SHOW_TTS_SETTINGS"]="showTtsSettings";Command["SPEAK_TABLE_LOCATION"]="speakTableLocation";Command["SPEAK_TIME_AND_DATE"]="speakTimeAndDate";Command["START_HISTORY_RECORDING"]="startHistoryRecording";Command["STOP_HISTORY_RECORDING"]="stopHistoryRecording";Command["STOP_SPEECH"]="stopSpeech";Command["TOGGLE_BRAILLE_CAPTIONS"]="toggleBrailleCaptions";Command["TOGGLE_BRAILLE_TABLE"]="toggleBrailleTable";Command["TOGGLE_DICTATION"]="toggleDictation";Command["TOGGLE_EARCONS"]="toggleEarcons";Command["TOGGLE_KEYBOARD_HELP"]="toggleKeyboardHelp";Command["TOGGLE_SCREEN"]="toggleScreen";Command["TOGGLE_SEARCH_WIDGET"]="toggleSearchWidget";Command["TOGGLE_SELECTION"]="toggleSelection";Command["TOGGLE_SEMANTICS"]="toggleSemantics";Command["TOGGLE_SPEECH_ON_OR_OFF"]="toggleSpeechOnOrOff";Command["TOGGLE_STICKY_MODE"]="toggleStickyMode";Command["TOP"]="top";Command["VIEW_GRAPHIC_AS_BRAILLE"]="viewGraphicAsBraille";Command["TOGGLE_CAPTIONS"]="toggleCaptions"})(Command||(Command={}));var CommandCategory;(function(CommandCategory){CommandCategory["ACTIONS"]="actions";CommandCategory["CONTROLLING_SPEECH"]="controlling_speech";CommandCategory["HELP_COMMANDS"]="help_commands";CommandCategory["INFORMATION"]="information";CommandCategory["JUMP_COMMANDS"]="jump_commands";CommandCategory["MODIFIER_KEYS"]="modifier_keys";CommandCategory["NAVIGATION"]="navigation";CommandCategory["OVERVIEW"]="overview";CommandCategory["TABLES"]="tables";CommandCategory["BRAILLE"]="braille";CommandCategory["DEVELOPER"]="developer";CommandCategory["NO_CATEGORY"]="no_category"})(CommandCategory||(CommandCategory={}));class Msgs{static getLocale(){return chrome.i18n.getMessage("locale")}static getMsg(messageId,subs){let message=Msgs.Untranslated[messageId.toUpperCase()];if(message!==undefined){return Msgs.applySubstitutions_(message,subs)}message=chrome.i18n.getMessage(Msgs.NAMESPACE_+messageId,subs);if((message===undefined||message==="")&&messageId.endsWith("_brl")){message=chrome.i18n.getMessage(Msgs.NAMESPACE_+messageId.replace("_brl",""),subs)}if(message===undefined||message===""){throw new Error("Invalid ChromeVox message id: "+messageId)}return message}static getMsgWithCount(messageId,count){const msg=Msgs.getMsg(messageId);const formatter=new MessageFormat(chrome.i18n.getUILanguage(),msg);return formatter.format({COUNT:count},(()=>{}))}static addTranslatedMessagesToDom(root){const elts=root.querySelectorAll(".i18n");for(let i=0;i<elts.length;i++){const msgid=elts[i].getAttribute("msgid");if(!msgid){throw new Error("Element has no msgid attribute: "+elts[i])}const val=Msgs.getMsg(msgid);if(elts[i].tagName==="INPUT"){elts[i].setAttribute("placeholder",val)}else{elts[i].textContent=val}elts[i].classList.add("i18n-processed")}}static getNumber(num){return""+num}static applySubstitutions_(message,subs){if(subs){for(let i=0;i<subs.length;i++){message=message.replace("$"+(i+1),subs[i])}}return message}}(function(Msgs){Msgs.NAMESPACE_="chromevox_";Msgs.Untranslated={CHECKBOX_UNCHECKED_STATE_BRL:"( )",CHECKBOX_CHECKED_STATE_BRL:"(x)",RADIO_UNSELECTED_STATE_BRL:"( )",RADIO_SELECTED_STATE_BRL:"(x)",ARIA_HAS_SUBMENU_BRL:"->",ROLE_OPTION:" ",ROLE_OPTION_BRL:" ",CHECKED_TRUE_BRL:"(x)",CHECKED_FALSE_BRL:"( )",CHECKED_MIXED_BRL:"(-)",ARIA_DISABLED_TRUE_BRL:"xx",ARIA_EXPANDED_TRUE_BRL:"-",ARIA_EXPANDED_FALSE_BRL:"+",ARIA_INVALID_TRUE_BRL:"!",ARIA_PRESSED_TRUE_BRL:"=",ARIA_PRESSED_FALSE_BRL:" ",ARIA_PRESSED_MIXED_BRL:"-",ARIA_SELECTED_TRUE_BRL:"(x)",ARIA_SELECTED_FALSE_BRL:"( )",HAS_SUBMENU_BRL:"->",TAG_TIME_BRL:" ",ARIA_VALUE_NOW:"$1",ARIA_VALUE_NOW_BRL:"$1",ARIA_VALUE_TEXT:"$1",ARIA_VALUE_TEXT_BRL:"$1"}})(Msgs||(Msgs={}));TestImportManager.exportForTesting(Msgs);class LocaleOutputHelper{availableVoices_;currentLocale_;lastSpokenLocale_;static instance;constructor(){this.currentLocale_=BROWSER_UI_LOCALE||"";this.lastSpokenLocale_=this.currentLocale_;this.availableVoices_=[];const setAvailableVoices=()=>{chrome.tts.getVoices((voices=>{this.availableVoices_=voices||[]}))};setAvailableVoices();if(window.speechSynthesis){window.speechSynthesis.addEventListener("voiceschanged",setAvailableVoices,false)}}computeTextAndLocale(text,contextNode){if(!text||!contextNode){return{text:text,locale:BROWSER_UI_LOCALE}}const nodeLocale=contextNode.detectedLanguage||contextNode.language||"";const newLocale=this.computeNewLocale_(nodeLocale);let outputString=text;const shouldAnnounce=this.shouldAnnounceLocale_(newLocale);if(this.hasVoiceForLocale_(newLocale)){this.setCurrentLocale_(newLocale);if(shouldAnnounce){this.lastSpokenLocale_=newLocale;const displayLanguage=chrome.accessibilityPrivate.getDisplayNameForLocale(newLocale,newLocale);outputString=Msgs.getMsg("language_switch",[displayLanguage,outputString])}}else{this.setCurrentLocale_(BROWSER_UI_LOCALE);const displayLanguage=chrome.accessibilityPrivate.getDisplayNameForLocale(newLocale,BROWSER_UI_LOCALE);outputString=Msgs.getMsg("voice_unavailable_for_language",[displayLanguage])}return{text:outputString,locale:this.currentLocale_}}computeNewLocale_(nodeLocale){nodeLocale=nodeLocale.toLowerCase();if(LocaleOutputHelper.isValidLocale_(nodeLocale)){return nodeLocale}return BROWSER_UI_LOCALE}hasVoiceForLocale_(targetLocale){const components=targetLocale.split("-");if(!components||components.length===0){return false}const targetLanguage=components[0];for(const voice of this.availableVoices_){if(!voice.lang){continue}const candidateLanguage=voice.lang.toLowerCase().split("-")[0];if(candidateLanguage===targetLanguage){return true}}return false}setCurrentLocale_(locale){if(LocaleOutputHelper.isValidLocale_(locale)){this.currentLocale_=locale}}shouldAnnounceLocale_(newLocale){const[lastSpokenLanguage,lastSpokenCountry]=this.lastSpokenLocale_.split("-");const[newLanguage,newCountry]=newLocale.split("-");if(lastSpokenLanguage!==newLanguage){return true}if(!newCountry){return false}return lastSpokenCountry!==newCountry}static init(){if(LocaleOutputHelper.instance!==undefined){throw new Error("LocaleOutputHelper is a singleton, can only initialize once")}LocaleOutputHelper.instance=new LocaleOutputHelper}static isValidLocale_(locale){return chrome.accessibilityPrivate.getDisplayNameForLocale(locale,locale)!==""}}const BROWSER_UI_LOCALE=chrome.i18n.getUILanguage().toLowerCase();TestImportManager.exportForTesting(LocaleOutputHelper);class PanelCommand{type;data;constructor(type,data){this.type=type;this.data=data}getPanelWindow(){const views=chrome.extension.getViews();for(let i=0;i<views.length;i++){if(views[i]["location"].href.indexOf("panel/panel.html")>0){return views[i]}}throw new Error("Could not find the panel window")}waitForPanel(){return new Promise((resolve=>{const panelWindow=this.getPanelWindow();if(panelWindow.document.readyState==="complete"){resolve()}panelWindow.addEventListener("load",(()=>{resolve()}))}))}async send(){await this.waitForPanel();const panelWindow=this.getPanelWindow();panelWindow.postMessage(JSON.stringify(this),window.location.origin)}}var PanelCommandType;(function(PanelCommandType){PanelCommandType["CLEAR_SPEECH"]="clear_speech";PanelCommandType["ADD_NORMAL_SPEECH"]="add_normal_speech";PanelCommandType["ADD_ANNOTATION_SPEECH"]="add_annotation_speech";PanelCommandType["CLOSE_CHROMEVOX"]="close_chromevox";PanelCommandType["UPDATE_BRAILLE"]="update_braille";PanelCommandType["OPEN_MENUS"]="open_menus";PanelCommandType["OPEN_MENUS_MOST_RECENT"]="open_menus_most_recent";PanelCommandType["SEARCH"]="search";PanelCommandType["TUTORIAL"]="tutorial";PanelCommandType["ENABLE_TEST_HOOKS"]="enable_test_hooks"})(PanelCommandType||(PanelCommandType={}));TestImportManager.exportForTesting(PanelCommand,["PanelCommandType",PanelCommandType]);class SettingsManager{static instance;static CHROMEVOX_PREFS;static LIVE_CAPTION_PREF;static EVENT_STREAM_FILTERS;static async init(){if(SettingsManager.instance){throw new Error("SettingsManager.init() should be called at most once in each "+"browser context.")}SettingsManager.instance=new SettingsManager;await Settings.init(SettingsManager.getAllPrefNames());SettingsManager.migrateFromChromeStorage_()}static getPrefName_(localStorageKey){return"settings.a11y.chromevox."+StringUtil.camelToSnake(localStorageKey)}static getAllPrefNames(){return SettingsManager.CHROMEVOX_PREFS.map(SettingsManager.getPrefName_).concat([SettingsManager.LIVE_CAPTION_PREF])}static migrateFromChromeStorage_(){for(const key of SettingsManager.CHROMEVOX_PREFS){let value=LocalStorage.get(key);if(value===undefined){continue}if(["virtualBrailleColumns","virtualBrailleRows"].includes(key)){value=parseInt(value,10)}const prefName=SettingsManager.getPrefName_(key);try{Settings.set(prefName,value);LocalStorage.remove(key)}catch{console.error("Invalid settings pref name:",prefName)}}let eventStreamFilters={};for(const key of SettingsManager.EVENT_STREAM_FILTERS){const value=LocalStorage.get(key);if(value===undefined){continue}eventStreamFilters[key]=value;LocalStorage.remove(key)}if(Object.keys(eventStreamFilters).length){eventStreamFilters={...Settings.get(this.getPrefName_("eventStreamFilters")),...eventStreamFilters};Settings.set(this.getPrefName_("eventStreamFilters"),eventStreamFilters)}}static addListenerForKey(key,callback){const pref=SettingsManager.getPrefName_(key);Settings.addListener(pref,callback)}static get(key,isChromeVox=true){let pref=key;if(isChromeVox){pref=SettingsManager.getPrefName_(key)}return Settings.get(pref)}static getTypeChecked(key,type,isChromeVox=true){const value=SettingsManager.get(key,isChromeVox);if(typeof type==="string"&&typeof value===type){return value}throw new Error('Value in SettingsManager for key "'+key+'" is not a '+type)}static getBoolean(key,isChromeVox=true){const value=SettingsManager.getTypeChecked(key,"boolean",isChromeVox);return Boolean(value)}static getNumber(key){const value=SettingsManager.getTypeChecked(key,"number");if(isNaN(value)){throw new Error('Value in SettingsManager for key "'+key+'" is NaN')}return Number(value)}static getString(key){const value=SettingsManager.getTypeChecked(key,"string");return String(value)}static set(key,value){const pref=SettingsManager.getPrefName_(key);Settings.set(pref,value)}static getEventStreamFilters(){return Settings.get(this.getPrefName_("eventStreamFilters"))}static setEventStreamFilter(key,value){if(!SettingsManager.EVENT_STREAM_FILTERS.includes(key)){throw new Error("Cannot set unknown event stream filter: "+key)}const eventStreamFilters=Settings.get(this.getPrefName_("eventStreamFilters"));eventStreamFilters[key]=value;Settings.set(this.getPrefName_("eventStreamFilters"),eventStreamFilters)}}SettingsManager.CHROMEVOX_PREFS=["announceDownloadNotifications","announceRichTextAttributes","audioStrategy","autoRead","brailleSideBySide","brailleTable","brailleTable6","brailleTable8","brailleTableType","brailleWordWrap","capitalStrategy","capitalStrategyBackup","enableBrailleLogging","enableEarconLogging","enableEventStreamLogging","enableSpeechLogging","eventStreamFilters","languageSwitching","menuBrailleCommands","numberReadingStyle","preferredBrailleDisplayAddress","punctuationEcho","smartStickyMode","speakTextUnderMouse","usePitchChanges","useVerboseMode","virtualBrailleColumns","virtualBrailleRows","voiceName"];SettingsManager.LIVE_CAPTION_PREF="accessibility.captions.live_caption_enabled";SettingsManager.EVENT_STREAM_FILTERS=["activedescendantchanged","alert","ariaAttributeChangedDeprecated","autocorrectionOccured","blur","checkedStateChanged","childrenChanged","clicked","documentSelectionChanged","documentTitleChanged","expandedChanged","focus","focusContext","hide","hitTestResult","hover","imageFrameUpdated","invalidStatusChanged","layoutComplete","liveRegionChanged","liveRegionCreated","loadComplete","locationChanged","mediaStartedPlaying","mediaStoppedPlaying","menuEnd","menuItemSelected","menuListValueChangedDeprecated","menuPopupEnd","menuPopupStart","menuStart","mouseCanceled","mouseDragged","mouseMoved","mousePressed","mouseReleased","rowCollapsed","rowCountChanged","rowExpanded","scrollPositionChanged","scrolledToAnchor","selectedChildrenChanged","selection","selectionAdd","selectionRemove","show","stateChanged","textChanged","textSelectionChanged","treeChanged","valueInTextFieldChanged"];TestImportManager.exportForTesting(SettingsManager);class PanelInterface{static instance}const Dir=constants.Dir;class ISearchUI{static instance;onKeyDown;onTextInput;input_;dir_=Dir.FORWARD;constructor(input){this.input_=input;this.onKeyDown=event=>this.onKeyDown_(event);this.onTextInput=event=>this.onTextInput_(event);input.addEventListener("keydown",this.onKeyDown,true);input.addEventListener("textInput",this.onTextInput,false)}static async init(input){if(ISearchUI.instance){ISearchUI.instance.destroy()}await BackgroundBridge.PanelBackground.createNewISearch();ISearchUI.instance=new ISearchUI(input);input.focus();input.select();return ISearchUI.instance}onKeyDown_(evt){switch(evt.key){case"ArrowUp":this.dir_=Dir.BACKWARD;break;case"ArrowDown":this.dir_=Dir.FORWARD;break;case"Escape":PanelInterface.instance.closeMenusAndRestoreFocus();return false;case"Enter":PanelInterface.instance.setPendingCallback((async()=>await BackgroundBridge.PanelBackground.setRangeToISearchNode()));PanelInterface.instance.closeMenusAndRestoreFocus();return false;default:return false}BackgroundBridge.PanelBackground.incrementalSearch(this.input_.value,this.dir_,true);evt.preventDefault();evt.stopPropagation();return false}onTextInput_(evt){const searchStr=evt.target.value+evt.data;BackgroundBridge.PanelBackground.incrementalSearch(searchStr,this.dir_);return true}destroy(){BackgroundBridge.PanelBackground.destroyISearch();const input=this.input_;this.input_=null;input?.removeEventListener("keydown",this.onKeyDown,true);input?.removeEventListener("textInput",this.onTextInput,false)}}var BrailleCommandData;(function(BrailleCommandData){BrailleCommandData.DOT_PATTERN_TO_COMMAND={};function makeDotPattern(dots){return dots.reduce(((pattern,cell)=>pattern|1<<cell-1),0)}BrailleCommandData.makeDotPattern=makeDotPattern;function getCommand(dots){return BrailleCommandData.DOT_PATTERN_TO_COMMAND[dots]}BrailleCommandData.getCommand=getCommand;function getDotShortcut(command,chord){const commandDots=getDots(command);return makeShortcutText(commandDots,chord)}BrailleCommandData.getDotShortcut=getDotShortcut;function makeShortcutText(pattern,chord){const dots=[];for(let shifter=0;shifter<=7;shifter++){if(1<<shifter&pattern){dots.push(shifter+1)}}let msgid;if(dots.length>1){msgid="braille_dots"}else if(dots.length===1){msgid="braille_dot"}if(msgid){let dotText=Msgs.getMsg(msgid,[dots.join("-")]);if(chord){dotText=Msgs.getMsg("braille_chord",[dotText])}return dotText}return""}BrailleCommandData.makeShortcutText=makeShortcutText;function getDots(command){for(const keyStr in BrailleCommandData.DOT_PATTERN_TO_COMMAND){const key=parseInt(keyStr,10);if(command===BrailleCommandData.DOT_PATTERN_TO_COMMAND[key]){return key}}return 0}BrailleCommandData.getDots=getDots;function init(){const map=function(dots,command){const pattern=makeDotPattern(dots);const existingCommand=BrailleCommandData.DOT_PATTERN_TO_COMMAND[pattern];if(existingCommand){throw"Braille command pattern already exists: "+dots+" "+existingCommand+". Trying to map "+command}BrailleCommandData.DOT_PATTERN_TO_COMMAND[pattern]=command};map([2,3],Command.PREVIOUS_GROUP);map([5,6],Command.NEXT_GROUP);map([1],Command.PREVIOUS_OBJECT);map([4],Command.NEXT_OBJECT);map([2],Command.PREVIOUS_WORD);map([5],Command.NEXT_WORD);map([3],Command.PREVIOUS_CHARACTER);map([6],Command.NEXT_CHARACTER);map([1,2,3],Command.JUMP_TO_TOP);map([4,5,6],Command.JUMP_TO_BOTTOM);map([1,4],Command.FULLY_DESCRIBE);map([1,3,4],Command.CONTEXT_MENU);map([1,2,3,5],Command.READ_FROM_HERE);map([2,3,4],Command.TOGGLE_SELECTION);map([1,2],Command.NEXT_BUTTON);map([1,5],Command.NEXT_EDIT_TEXT);map([1,2,4],Command.NEXT_FORM_FIELD);map([1,2,5],Command.NEXT_HEADING);map([4,5],Command.NEXT_LINK);map([2,3,4,5],Command.NEXT_TABLE);map([1,2,7],Command.PREVIOUS_BUTTON);map([1,5,7],Command.PREVIOUS_EDIT_TEXT);map([1,2,4,7],Command.PREVIOUS_FORM_FIELD);map([1,2,5,7],Command.PREVIOUS_HEADING);map([4,5,7],Command.PREVIOUS_LINK);map([2,3,4,5,7],Command.PREVIOUS_TABLE);map([8],Command.FORCE_CLICK_ON_CURRENT_ITEM);map([3,4],Command.TOGGLE_SEARCH_WIDGET);map([1,4,7],Command.TOGGLE_CAPTIONS);map([1,4,5,6],Command.TOGGLE_KEYBOARD_HELP);map([1,2,3,4,5,6],Command.TOGGLE_SCREEN);map([1,2,3,4,5],Command.TOGGLE_SPEECH_ON_OR_OFF);map([1,2,4,5],Command.TOGGLE_BRAILLE_TABLE);map([5,6,7],Command.STOP_SPEECH)}BrailleCommandData.init=init;init()})(BrailleCommandData||(BrailleCommandData={}));TestImportManager.exportForTesting(["BrailleCommandData",BrailleCommandData]);class KeySequence{cvoxModifier;doubleTap;requireStickyMode;prefixKey;skipStripping;stickyMode;keys={ctrlKey:[],searchKeyHeld:[],altKey:[],altGraphKey:[],shiftKey:[],metaKey:[],keyCode:[]};constructor(originalEvent,cvoxModifier,doubleTap,skipStripping,requireStickyMode){this.doubleTap=Boolean(doubleTap);this.requireStickyMode=Boolean(requireStickyMode);this.skipStripping=Boolean(skipStripping);this.cvoxModifier=cvoxModifier??this.isCVoxModifierActive(originalEvent);this.stickyMode=Boolean(originalEvent.stickyMode);this.prefixKey=Boolean(originalEvent.keyPrefix);if(this.stickyMode&&this.prefixKey){throw"Prefix key and sticky mode cannot both be enabled: "+originalEvent}this.extractKey_(originalEvent)}addKeyEvent(additionalKeyEvent){if(this.keys.keyCode.length>1){return false}this.extractKey_(additionalKeyEvent);return true}equals(rhs){if(!this.checkKeyEquality_(rhs)){return false}if(this.doubleTap!==rhs.doubleTap){return false}if(this.requireStickyMode||rhs.requireStickyMode){return(this.stickyMode||rhs.stickyMode)&&!this.cvoxModifier&&!rhs.cvoxModifier}if(this.cvoxModifier===rhs.cvoxModifier){return true}const unmodified=this.cvoxModifier?rhs:this;return unmodified.stickyMode||unmodified.prefixKey}extractKey_(keyEvent){let keyCode;if(keyEvent.type==="keypress"&&keyEvent.keyCode>=97&&keyEvent.keyCode<=122){keyCode=keyEvent.keyCode-32}else if(keyEvent.type==="keypress"){keyCode=KEY_PRESS_CODE[keyEvent.keyCode]}this.keys.keyCode.push(keyCode||keyEvent.keyCode);for(const prop in this.keys){if(prop!=="keyCode"){if(this.isKeyModifierActive(keyEvent,prop)){this.keys[prop].push(true)}else{this.keys[prop].push(false)}}}if(this.cvoxModifier){this.rationalizeKeys_()}}rationalizeKeys_(){if(this.skipStripping){return}const modifierKeyCombo=KeySequence.modKeyStr.split(/\+/g);const index=this.keys.keyCode.length-1;if(modifierKeyCombo.indexOf("Ctrl")!==-1){this.keys.ctrlKey[index]=false}if(modifierKeyCombo.indexOf("Alt")!==-1){this.keys.altKey[index]=false}if(modifierKeyCombo.indexOf("Shift")!==-1){this.keys.shiftKey[index]=false}const metaKeyName=this.getMetaKeyName_();if(modifierKeyCombo.indexOf(metaKeyName)!==-1){if(metaKeyName==="Search"){this.keys.searchKeyHeld[index]=false;this.keys.metaKey[index]=false}else if(metaKeyName==="Cmd"||metaKeyName==="Win"){this.keys.metaKey[index]=false}}}getMetaKeyName_(){return"Search"}checkKeyEquality_(rhs){for(const i in this.keys){for(let j=this.keys[i].length;j--;){if(this.keys[i][j]!==rhs.keys[i][j]){return false}}}return true}getFirstKeyCode(){return this.keys.keyCode[0]}length(){return this.keys.keyCode.length}isModifierKey(keyCode){return keyCode===KeyCode.SHIFT||keyCode===KeyCode.CONTROL||keyCode===KeyCode.ALT||keyCode===KeyCode.SEARCH||keyCode===KeyCode.APPS}isCVoxModifierActive(keyEvent){let modifierKeyCombo=KeySequence.modKeyStr.split(/\+/g);if(this.isKeyModifierActive(keyEvent,"ctrlKey")){modifierKeyCombo=modifierKeyCombo.filter((modifier=>modifier!=="Ctrl"))}if(this.isKeyModifierActive(keyEvent,"altKey")){modifierKeyCombo=modifierKeyCombo.filter((modifier=>modifier!=="Alt"))}if(this.isKeyModifierActive(keyEvent,"shiftKey")){modifierKeyCombo=modifierKeyCombo.filter((modifier=>modifier!=="Shift"))}if(this.isKeyModifierActive(keyEvent,"metaKey")||this.isKeyModifierActive(keyEvent,"searchKeyHeld")){const metaKeyName=this.getMetaKeyName_();modifierKeyCombo=modifierKeyCombo.filter((modifier=>modifier!==metaKeyName))}return modifierKeyCombo.length===0}isKeyModifierActive(keyEvent,modifier){switch(modifier){case"ctrlKey":return keyEvent.ctrlKey||keyEvent.keyCode===KeyCode.CONTROL;case"altKey":return keyEvent.altKey||keyEvent.keyCode===KeyCode.ALT;case"shiftKey":return keyEvent.shiftKey||keyEvent.keyCode===KeyCode.SHIFT;case"metaKey":return keyEvent.metaKey||keyEvent.keyCode===KeyCode.SEARCH;case"searchKeyHeld":return keyEvent.keyCode===KeyCode.SEARCH||keyEvent["searchKeyHeld"]}return false}isAnyModifierActive(){for(const modifierType in this.keys){for(let i=0;i<this.length();i++){if(this.keys[modifierType][i]&&modifierType!=="keyCode"){return true}}}return false}static deserialize(sequenceObject){const firstSequenceEvent=newEventLikeObject();firstSequenceEvent["stickyMode"]=sequenceObject.stickyMode===undefined?false:sequenceObject.stickyMode;firstSequenceEvent["prefixKey"]=sequenceObject.prefixKey===undefined?false:sequenceObject.prefixKey;const secondKeyPressed=sequenceObject.keys.keyCode.length>1;const secondSequenceEvent=newEventLikeObject();for(const keyPressed in sequenceObject.keys){firstSequenceEvent[keyPressed]=sequenceObject.keys[keyPressed][0];if(secondKeyPressed){secondSequenceEvent[keyPressed]=sequenceObject.keys[keyPressed][1]}}const skipStripping=sequenceObject.skipStripping!==undefined?sequenceObject.skipStripping:true;const keySeq=new KeySequence(firstSequenceEvent,sequenceObject.cvoxModifier,sequenceObject.doubleTap,skipStripping,sequenceObject.requireStickyMode);if(secondKeyPressed){KeySequence.sequenceSwitchKeyCodes.push(new KeySequence(firstSequenceEvent,sequenceObject.cvoxModifier));keySeq.addKeyEvent(secondSequenceEvent)}if(sequenceObject.doubleTap){KeySequence.doubleTapCache.push(keySeq)}return keySeq}static fromStr(keyStr){const sequenceEvent=newEventLikeObject();const secondSequenceEvent=newEventLikeObject();let secondKeyPressed;if(keyStr.indexOf(">")===-1){secondKeyPressed=false}else{secondKeyPressed=true}let cvoxPressed=false;sequenceEvent["stickyMode"]=false;sequenceEvent["prefixKey"]=false;const tokens=keyStr.split("+");for(let i=0;i<tokens.length;i++){const seqs=tokens[i].split(">");for(let j=0;j<seqs.length;j++){if(seqs[j].charAt(0)==="#"){const keyCode=parseInt(seqs[j].substr(1),10);if(j>0){secondSequenceEvent["keyCode"]=keyCode}else{sequenceEvent["keyCode"]=keyCode}}const keyName=seqs[j];if(seqs[j].length===1){if(j>0){secondSequenceEvent["keyCode"]=seqs[j].charCodeAt(0)}else{sequenceEvent["keyCode"]=seqs[j].charCodeAt(0)}}else{if(j>0){KeySequence.setModifiersOnEvent_(keyName,secondSequenceEvent);if(keyName==="Cvox"){cvoxPressed=true}}else{KeySequence.setModifiersOnEvent_(keyName,sequenceEvent);if(keyName==="Cvox"){cvoxPressed=true}}}}}const keySeq=new KeySequence(sequenceEvent,cvoxPressed);if(secondKeyPressed){keySeq.addKeyEvent(secondSequenceEvent)}return keySeq}static setModifiersOnEvent_(keyName,seqEvent){if(keyName==="Ctrl"){seqEvent["ctrlKey"]=true;seqEvent["keyCode"]=KeyCode.CONTROL}else if(keyName==="Alt"){seqEvent["altKey"]=true;seqEvent["keyCode"]=KeyCode.ALT}else if(keyName==="Shift"){seqEvent["shiftKey"]=true;seqEvent["keyCode"]=KeyCode.SHIFT}else if(keyName==="Search"){seqEvent["searchKeyHeld"]=true;seqEvent["keyCode"]=KeyCode.SEARCH}else if(keyName==="Cmd"){seqEvent["metaKey"]=true;seqEvent["keyCode"]=KeyCode.SEARCH}else if(keyName==="Win"){seqEvent["metaKey"]=true;seqEvent["keyCode"]=KeyCode.SEARCH}else if(keyName==="Insert"){seqEvent["keyCode"]=KeyCode.INSERT}}static doubleTapCache=[];static sequenceSwitchKeyCodes=[];static modKeyStr="Search"}function newEventLikeObject(){return Object.assign({},{type:"",keyCode:0})}const KEY_PRESS_CODE={39:222,44:188,45:189,46:190,47:191,59:186,91:219,92:220,93:221};TestImportManager.exportForTesting(KeySequence);class CommandStore{static messageForCommand(command){return COMMAND_DATA[command]?.msgId}static categoryForCommand(command){return COMMAND_DATA[command]?.category}static commandForMessage(msgId){for(const commandName in COMMAND_DATA){const command=COMMAND_DATA[commandName];if(command.msgId===msgId){return commandName}}}static commandsForCategory(category){const ret=[];for(const cmd in COMMAND_DATA){const struct=COMMAND_DATA[cmd];if(category===struct.category){ret.push(cmd)}}return ret}static denySignedOut(command){return Boolean(COMMAND_DATA[command]?.denySignedOut)}static getKeyBindings(){const primaryKeyBindings=Object.entries(COMMAND_DATA).filter((([_command,data])=>data.sequence)).map((([command,data])=>{if(data.sequence){return{command:command,sequence:KeySequence.deserialize(data.sequence)}}return undefined}));const secondaryKeyBindings=Object.entries(COMMAND_DATA).filter((([_command,data])=>data.altSequence)).map((([command,data])=>{if(data.altSequence){return{command:command,sequence:KeySequence.deserialize(data.altSequence)}}return undefined}));return primaryKeyBindings.concat(secondaryKeyBindings)}}const COMMAND_DATA={[Command.ANNOUNCE_BATTERY_DESCRIPTION]:{category:CommandCategory.INFORMATION,msgId:"announce_battery_description",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.O,KeyCode.B]}}},[Command.ANNOUNCE_HEADERS]:{category:CommandCategory.TABLES,msgId:"announce_headers"},[Command.ANNOUNCE_RICH_TEXT_DESCRIPTION]:{category:CommandCategory.INFORMATION,msgId:"announce_rich_text_description",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.A,KeyCode.F]}}},[Command.AUTORUNNER]:{category:CommandCategory.NO_CATEGORY},[Command.BACKWARD]:{category:CommandCategory.NAVIGATION,msgId:"backward"},[Command.BOTTOM]:{category:CommandCategory.BRAILLE,msgId:"braille_bottom"},[Command.CONTEXT_MENU]:{category:CommandCategory.INFORMATION,msgId:"show_context_menu",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.M]}}},[Command.COPY]:{category:CommandCategory.NO_CATEGORY,sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.C],ctrlKey:[true]}}},[Command.CYCLE_PUNCTUATION_ECHO]:{category:CommandCategory.CONTROLLING_SPEECH,msgId:"cycle_punctuation_echo",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.A,KeyCode.P]}}},[Command.CYCLE_TYPING_ECHO]:{category:CommandCategory.CONTROLLING_SPEECH,msgId:"cycle_typing_echo",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.A,KeyCode.T]}}},[Command.DEBUG]:{category:CommandCategory.NO_CATEGORY},[Command.DECREASE_TTS_PITCH]:{category:CommandCategory.CONTROLLING_SPEECH,msgId:"decrease_tts_pitch",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.OEM_6],shiftKey:[true]}}},[Command.DECREASE_TTS_RATE]:{category:CommandCategory.CONTROLLING_SPEECH,msgId:"decrease_tts_rate",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.OEM_4],shiftKey:[true]}}},[Command.DECREASE_TTS_VOLUME]:{category:CommandCategory.CONTROLLING_SPEECH,msgId:"decrease_tts_volume"},[Command.DISABLE_CHROMEVOX_ARC_SUPPORT_FOR_CURRENT_APP]:{category:CommandCategory.NO_CATEGORY,sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.A,KeyCode.OEM_6]}}},[Command.DISABLE_LOGGING]:{category:CommandCategory.NO_CATEGORY,sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.O,KeyCode.D]}}},[Command.DUMP_TREE]:{category:CommandCategory.NO_CATEGORY,sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.D,KeyCode.T],ctrlKey:[true]}}},[Command.ENABLE_CHROMEVOX_ARC_SUPPORT_FOR_CURRENT_APP]:{category:CommandCategory.NO_CATEGORY,sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.A,KeyCode.OEM_4]}}},[Command.ENABLE_CONSOLE_TTS]:{category:CommandCategory.DEVELOPER,msgId:"enable_tts_log"},[Command.ENABLE_LOGGING]:{category:CommandCategory.NO_CATEGORY,sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.O,KeyCode.E]}}},[Command.ENTER_SHIFTER]:{category:CommandCategory.NAVIGATION,msgId:"enter_content"},[Command.EXIT_SHIFTER]:{category:CommandCategory.NAVIGATION,msgId:"exit_content"},[Command.EXIT_SHIFTER_CONTENT]:{category:CommandCategory.NO_CATEGORY},[Command.FORCE_CLICK_ON_CURRENT_ITEM]:{category:CommandCategory.ACTIONS,msgId:"force_click_on_current_item",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.SPACE]}}},[Command.FORCE_DOUBLE_CLICK_ON_CURRENT_ITEM]:{category:CommandCategory.NO_CATEGORY,sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.SPACE]},doubleTap:true}},[Command.FORCE_LONG_CLICK_ON_CURRENT_ITEM]:{category:CommandCategory.NO_CATEGORY,msgId:"force_long_click_on_current_item",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.SPACE],shiftKey:[true]}}},[Command.FORWARD]:{category:CommandCategory.NAVIGATION,msgId:"forward"},[Command.FULLY_DESCRIBE]:{category:CommandCategory.INFORMATION,msgId:"fully_describe",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.K]}}},[Command.GO_TO_COL_FIRST_CELL]:{category:CommandCategory.TABLES,msgId:"skip_to_col_beginning",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.UP],ctrlKey:[true],altKey:[true],shiftKey:[true]}}},[Command.GO_TO_COL_LAST_CELL]:{category:CommandCategory.TABLES,msgId:"skip_to_col_end",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.DOWN],ctrlKey:[true],altKey:[true],shiftKey:[true]}}},[Command.GO_TO_FIRST_CELL]:{category:CommandCategory.TABLES,msgId:"skip_to_beginning",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.LEFT],altKey:[true],shiftKey:[true]}}},[Command.GO_TO_LAST_CELL]:{category:CommandCategory.TABLES,msgId:"skip_to_end",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.RIGHT],altKey:[true],shiftKey:[true]}}},[Command.GO_TO_ROW_FIRST_CELL]:{category:CommandCategory.TABLES,msgId:"skip_to_row_beginning",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.LEFT],ctrlKey:[true],altKey:[true],shiftKey:[true]}}},[Command.GO_TO_ROW_LAST_CELL]:{category:CommandCategory.TABLES,msgId:"skip_to_row_end",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.RIGHT],ctrlKey:[true],altKey:[true],shiftKey:[true]}}},[Command.HANDLE_TAB]:{category:CommandCategory.NAVIGATION,msgId:"handle_tab_next"},[Command.HANDLE_TAB_PREV]:{category:CommandCategory.NAVIGATION,msgId:"handle_tab_prev"},[Command.HELP]:{category:CommandCategory.HELP_COMMANDS,msgId:"help",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.O,KeyCode.T]}}},[Command.INCREASE_TTS_PITCH]:{category:CommandCategory.CONTROLLING_SPEECH,msgId:"increase_tts_pitch",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.OEM_6]}}},[Command.INCREASE_TTS_RATE]:{category:CommandCategory.CONTROLLING_SPEECH,msgId:"increase_tts_rate",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.OEM_4]}}},[Command.INCREASE_TTS_VOLUME]:{category:CommandCategory.CONTROLLING_SPEECH,msgId:"increase_tts_volume"},[Command.JUMP_TO_BOTTOM]:{category:CommandCategory.NAVIGATION,msgId:"jump_to_bottom",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.RIGHT],ctrlKey:[true]}}},[Command.JUMP_TO_DETAILS]:{category:CommandCategory.NAVIGATION,msgId:"jump_to_details",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.A,KeyCode.J]}}},[Command.JUMP_TO_TOP]:{category:CommandCategory.NAVIGATION,msgId:"jump_to_top",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.LEFT],ctrlKey:[true]}}},[Command.LEFT]:{category:CommandCategory.NAVIGATION,msgId:"left"},[Command.LINE_DOWN]:{category:CommandCategory.BRAILLE,msgId:"braille_line_down"},[Command.LINE_UP]:{category:CommandCategory.BRAILLE,msgId:"braille_line_up"},[Command.MOVE_TO_START_OF_LINE]:{category:CommandCategory.NO_CATEGORY},[Command.MOVE_TO_END_OF_LINE]:{category:CommandCategory.NO_CATEGORY},[Command.NEXT_ARTICLE]:{category:CommandCategory.NO_CATEGORY},[Command.NEXT_AT_GRANULARITY]:{category:CommandCategory.NAVIGATION,msgId:"next_at_granularity"},[Command.NEXT_BUTTON]:{category:CommandCategory.JUMP_COMMANDS,msgId:"next_button",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.B]}}},[Command.NEXT_CHARACTER]:{category:CommandCategory.NAVIGATION,msgId:"next_character",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.RIGHT],shiftKey:[true]}}},[Command.NEXT_CHECKBOX]:{category:CommandCategory.JUMP_COMMANDS,msgId:"next_checkbox",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.X]}}},[Command.NEXT_COL]:{category:CommandCategory.TABLES,msgId:"skip_to_next_col",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.RIGHT],ctrlKey:[true],altKey:[true]}}},[Command.NEXT_COMBO_BOX]:{category:CommandCategory.JUMP_COMMANDS,msgId:"next_combo_box",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.C]}}},[Command.NEXT_CONTROL]:{category:CommandCategory.NO_CATEGORY},[Command.NEXT_EDIT_TEXT]:{category:CommandCategory.JUMP_COMMANDS,msgId:"next_edit_text",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.E]}}},[Command.NEXT_FORM_FIELD]:{category:CommandCategory.JUMP_COMMANDS,msgId:"next_form_field",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.F]}}},[Command.NEXT_GRANULARITY]:{category:CommandCategory.NAVIGATION,msgId:"next_granularity"},[Command.NEXT_GRAPHIC]:{category:CommandCategory.JUMP_COMMANDS,msgId:"next_graphic",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.G]}}},[Command.NEXT_GROUP]:{category:CommandCategory.NAVIGATION,msgId:"next_group",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.DOWN],ctrlKey:[true]}}},[Command.NEXT_HEADING]:{category:CommandCategory.JUMP_COMMANDS,msgId:"next_heading",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.H]}}},[Command.NEXT_HEADING_1]:{category:CommandCategory.JUMP_COMMANDS,msgId:"next_heading1",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.ONE]}}},[Command.NEXT_HEADING_2]:{category:CommandCategory.JUMP_COMMANDS,msgId:"next_heading2",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.TWO]}}},[Command.NEXT_HEADING_3]:{category:CommandCategory.JUMP_COMMANDS,msgId:"next_heading3",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.THREE]}}},[Command.NEXT_HEADING_4]:{category:CommandCategory.JUMP_COMMANDS,msgId:"next_heading4",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.FOUR]}}},[Command.NEXT_HEADING_5]:{category:CommandCategory.JUMP_COMMANDS,msgId:"next_heading5",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.FIVE]}}},[Command.NEXT_HEADING_6]:{category:CommandCategory.JUMP_COMMANDS,msgId:"next_heading6",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.SIX]}}},[Command.NEXT_INVALID_ITEM]:{category:CommandCategory.NAVIGATION,msgId:"next_invalid_item",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.N,KeyCode.I]}}},[Command.NEXT_LANDMARK]:{category:CommandCategory.JUMP_COMMANDS,msgId:"next_landmark",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.OEM_1]}}},[Command.NEXT_LINE]:{category:CommandCategory.NAVIGATION,msgId:"next_line",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.DOWN]}}},[Command.NEXT_LINK]:{category:CommandCategory.JUMP_COMMANDS,msgId:"next_link",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.L]}}},[Command.NEXT_LIST]:{category:CommandCategory.JUMP_COMMANDS,msgId:"next_list",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.J,KeyCode.L]}}},[Command.NEXT_LIST_ITEM]:{category:CommandCategory.JUMP_COMMANDS,msgId:"next_list_item"},[Command.NEXT_MATH]:{category:CommandCategory.JUMP_COMMANDS,msgId:"next_math"},[Command.NEXT_MEDIA]:{category:CommandCategory.JUMP_COMMANDS,msgId:"next_media"},[Command.NEXT_OBJECT]:{category:CommandCategory.NAVIGATION,msgId:"next_object",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.RIGHT]}}},[Command.NEXT_PAGE]:{category:CommandCategory.NO_CATEGORY},[Command.NEXT_RADIO]:{category:CommandCategory.JUMP_COMMANDS,msgId:"next_radio"},[Command.NEXT_ROW]:{category:CommandCategory.TABLES,msgId:"skip_to_next_row",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.DOWN],ctrlKey:[true],altKey:[true]}}},[Command.NEXT_SECTION]:{category:CommandCategory.NO_CATEGORY},[Command.NEXT_SENTENCE]:{category:CommandCategory.NAVIGATION,msgId:"next_sentence"},[Command.NEXT_SIMILAR_ITEM]:{category:CommandCategory.NAVIGATION,msgId:"next_similar_item",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.I]}}},[Command.NEXT_SLIDER]:{category:CommandCategory.NO_CATEGORY},[Command.NEXT_TABLE]:{category:CommandCategory.JUMP_COMMANDS,msgId:"next_table",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.T]}}},[Command.NEXT_VISITED_LINK]:{category:CommandCategory.JUMP_COMMANDS,msgId:"next_visited_link",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.V]}}},[Command.NEXT_WORD]:{category:CommandCategory.NAVIGATION,msgId:"next_word",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.RIGHT],ctrlKey:[true],shiftKey:[true]}}},[Command.NOP]:{category:CommandCategory.NO_CATEGORY},[Command.OPEN_CHROMEVOX_MENUS]:{category:CommandCategory.NO_CATEGORY,msgId:"menus_title"},[Command.OPEN_KEYBOARD_SHORTCUTS]:{category:CommandCategory.HELP_COMMANDS,denySignedOut:true,msgId:"open_keyboard_shortcuts_menu",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.S],ctrlKey:[true]}}},[Command.OPEN_LONG_DESC]:{category:CommandCategory.INFORMATION,msgId:"open_long_desc"},[Command.PAN_LEFT]:{category:CommandCategory.BRAILLE,msgId:"braille_pan_left"},[Command.PAN_RIGHT]:{category:CommandCategory.BRAILLE,msgId:"braille_pan_right"},[Command.PASS_THROUGH_MODE]:{category:CommandCategory.MODIFIER_KEYS,msgId:"pass_through_key_description",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.ESCAPE],shiftKey:[true]}}},[Command.PAUSE_ALL_MEDIA]:{category:CommandCategory.INFORMATION,msgId:"pause_all_media"},[Command.PREVIOUS_ARTICLE]:{category:CommandCategory.NO_CATEGORY},[Command.PREVIOUS_AT_GRANULARITY]:{category:CommandCategory.NAVIGATION,msgId:"previous_at_granularity"},[Command.PREVIOUS_BUTTON]:{category:CommandCategory.JUMP_COMMANDS,msgId:"previous_button",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.B],shiftKey:[true]}}},[Command.PREVIOUS_CHARACTER]:{category:CommandCategory.NAVIGATION,msgId:"previous_character",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.LEFT],shiftKey:[true]}}},[Command.PREVIOUS_CHECKBOX]:{category:CommandCategory.JUMP_COMMANDS,msgId:"previous_checkbox",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.X],shiftKey:[true]}}},[Command.PREVIOUS_COL]:{category:CommandCategory.TABLES,msgId:"skip_to_prev_col",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.LEFT],ctrlKey:[true],altKey:[true]}}},[Command.PREVIOUS_COMBO_BOX]:{category:CommandCategory.JUMP_COMMANDS,msgId:"previous_combo_box",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.C],shiftKey:[true]}}},[Command.PREVIOUS_CONTROL]:{category:CommandCategory.NO_CATEGORY},[Command.PREVIOUS_EDIT_TEXT]:{category:CommandCategory.JUMP_COMMANDS,msgId:"previous_edit_text",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.E],shiftKey:[true]}}},[Command.PREVIOUS_FORM_FIELD]:{category:CommandCategory.JUMP_COMMANDS,msgId:"previous_form_field",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.F],shiftKey:[true]}}},[Command.PREVIOUS_GRANULARITY]:{category:CommandCategory.NAVIGATION,msgId:"previous_granularity"},[Command.PREVIOUS_GRAPHIC]:{category:CommandCategory.JUMP_COMMANDS,msgId:"previous_graphic",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.G],shiftKey:[true]}}},[Command.PREVIOUS_GROUP]:{category:CommandCategory.NAVIGATION,msgId:"previous_group",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.UP],ctrlKey:[true]}}},[Command.PREVIOUS_HEADING]:{category:CommandCategory.JUMP_COMMANDS,msgId:"previous_heading",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.H],shiftKey:[true]}}},[Command.PREVIOUS_HEADING_1]:{category:CommandCategory.JUMP_COMMANDS,msgId:"previous_heading1",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.ONE],shiftKey:[true]}}},[Command.PREVIOUS_HEADING_2]:{category:CommandCategory.JUMP_COMMANDS,msgId:"previous_heading2",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.TWO],shiftKey:[true]}}},[Command.PREVIOUS_HEADING_3]:{category:CommandCategory.JUMP_COMMANDS,msgId:"previous_heading3",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.THREE],shiftKey:[true]}}},[Command.PREVIOUS_HEADING_4]:{category:CommandCategory.JUMP_COMMANDS,msgId:"previous_heading4",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.FOUR],shiftKey:[true]}}},[Command.PREVIOUS_HEADING_5]:{category:CommandCategory.JUMP_COMMANDS,msgId:"previous_heading5",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.FIVE],shiftKey:[true]}}},[Command.PREVIOUS_HEADING_6]:{category:CommandCategory.JUMP_COMMANDS,msgId:"previous_heading6",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.SIX],shiftKey:[true]}}},[Command.PREVIOUS_INVALID_ITEM]:{category:CommandCategory.NAVIGATION,msgId:"previous_invalid_item",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.P,KeyCode.I]}}},[Command.PREVIOUS_LANDMARK]:{category:CommandCategory.JUMP_COMMANDS,msgId:"previous_landmark",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.OEM_1],shiftKey:[true]}}},[Command.PREVIOUS_LINE]:{category:CommandCategory.NAVIGATION,msgId:"previous_line",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.UP]}}},[Command.PREVIOUS_LINK]:{category:CommandCategory.JUMP_COMMANDS,msgId:"previous_link",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.L],shiftKey:[true]}}},[Command.PREVIOUS_LIST]:{category:CommandCategory.JUMP_COMMANDS,msgId:"previous_list",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.J,KeyCode.L],shiftKey:[true]}}},[Command.PREVIOUS_LIST_ITEM]:{category:CommandCategory.JUMP_COMMANDS,msgId:"previous_list_item"},[Command.PREVIOUS_MATH]:{category:CommandCategory.JUMP_COMMANDS,msgId:"previous_math"},[Command.PREVIOUS_MEDIA]:{category:CommandCategory.JUMP_COMMANDS,msgId:"previous_media"},[Command.PREVIOUS_OBJECT]:{category:CommandCategory.NAVIGATION,msgId:"previous_object",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.LEFT]}}},[Command.PREVIOUS_PAGE]:{category:CommandCategory.NO_CATEGORY},[Command.PREVIOUS_RADIO]:{category:CommandCategory.JUMP_COMMANDS,msgId:"previous_radio"},[Command.PREVIOUS_ROW]:{category:CommandCategory.TABLES,msgId:"skip_to_prev_row",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.UP],ctrlKey:[true],altKey:[true]}}},[Command.PREVIOUS_SECTION]:{category:CommandCategory.NO_CATEGORY},[Command.PREVIOUS_SENTENCE]:{category:CommandCategory.NAVIGATION,msgId:"previous_sentence"},[Command.PREVIOUS_SIMILAR_ITEM]:{category:CommandCategory.NAVIGATION,msgId:"previous_similar_item",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.I],shiftKey:[true]}}},[Command.PREVIOUS_SLIDER]:{category:CommandCategory.NO_CATEGORY},[Command.PREVIOUS_TABLE]:{category:CommandCategory.JUMP_COMMANDS,msgId:"previous_table",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.T],shiftKey:[true]}}},[Command.PREVIOUS_VISITED_LINK]:{category:CommandCategory.JUMP_COMMANDS,msgId:"previous_visited_link",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.V],shiftKey:[true]}}},[Command.PREVIOUS_WORD]:{category:CommandCategory.NAVIGATION,msgId:"previous_word",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.LEFT],ctrlKey:[true],shiftKey:[true]}}},[Command.READ_CURRENT_TITLE]:{category:CommandCategory.INFORMATION,msgId:"read_current_title",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.A,KeyCode.W]}}},[Command.READ_CURRENT_URL]:{category:CommandCategory.INFORMATION,msgId:"read_current_url",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.A,KeyCode.U]}}},[Command.READ_FROM_HERE]:{category:CommandCategory.NAVIGATION,msgId:"read_from_here",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.R]}}},[Command.READ_LINK_URL]:{category:CommandCategory.INFORMATION,msgId:"read_link_url",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.A,KeyCode.L]}}},[Command.READ_PHONETIC_PRONUNCIATION]:{category:CommandCategory.INFORMATION,msgId:"read_phonetic_pronunciation",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.A,KeyCode.C]}}},[Command.REPORT_ISSUE]:{category:CommandCategory.HELP_COMMANDS,denySignedOut:true,msgId:"panel_menu_item_report_issue",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.A,KeyCode.I]}}},[Command.RESET_TEXT_TO_SPEECH_SETTINGS]:{category:CommandCategory.CONTROLLING_SPEECH,msgId:"reset_tts_settings",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.OEM_5],ctrlKey:[true],shiftKey:[true]}}},[Command.RIGHT]:{category:CommandCategory.NAVIGATION,msgId:"right"},[Command.ROUTING]:{category:CommandCategory.BRAILLE,msgId:"braille_routing"},[Command.SCROLL_BACKWARD]:{category:CommandCategory.NO_CATEGORY,msgId:"action_scroll_backward_description"},[Command.SCROLL_FORWARD]:{category:CommandCategory.NO_CATEGORY,msgId:"action_scroll_forward_description"},[Command.SHOW_ACTIONS_MENU]:{category:CommandCategory.NO_CATEGORY,sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.A],ctrlKey:[true]}}},[Command.SHOW_FORMS_LIST]:{category:CommandCategory.OVERVIEW,msgId:"show_forms_list",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.F],ctrlKey:[true]}}},[Command.SHOW_HEADINGS_LIST]:{category:CommandCategory.OVERVIEW,msgId:"show_headings_list",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.H],ctrlKey:[true]}}},[Command.SHOW_LANDMARKS_LIST]:{category:CommandCategory.OVERVIEW,msgId:"show_landmarks_list",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.OEM_1],ctrlKey:[true]}}},[Command.SHOW_LEARN_MODE_PAGE]:{category:CommandCategory.HELP_COMMANDS,denySignedOut:true,msgId:"show_kb_explorer_page",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.O,KeyCode.K]}}},[Command.SHOW_LINKS_LIST]:{category:CommandCategory.OVERVIEW,msgId:"show_links_list",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.L],ctrlKey:[true]}}},[Command.SHOW_LOG_PAGE]:{category:CommandCategory.HELP_COMMANDS,denySignedOut:true,msgId:"show_log_page",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.O,KeyCode.W]}}},[Command.SHOW_OPTIONS_PAGE]:{category:CommandCategory.HELP_COMMANDS,denySignedOut:true,msgId:"show_options_page",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.O,KeyCode.O]}}},[Command.SHOW_PANEL_MENU_MOST_RECENT]:{category:CommandCategory.HELP_COMMANDS,msgId:"show_panel_menu"},[Command.SHOW_TABLES_LIST]:{category:CommandCategory.OVERVIEW,msgId:"show_tables_list",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.T],ctrlKey:[true]}}},[Command.SHOW_TALKBACK_KEYBOARD_SHORTCUTS]:{category:CommandCategory.NO_CATEGORY,sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.A,KeyCode.K]}}},[Command.SHOW_TTS_SETTINGS]:{category:CommandCategory.HELP_COMMANDS,denySignedOut:true,msgId:"show_tts_settings",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.O,KeyCode.S]}}},[Command.SPEAK_TABLE_LOCATION]:{category:CommandCategory.TABLES,msgId:"speak_table_location"},[Command.SPEAK_TIME_AND_DATE]:{category:CommandCategory.INFORMATION,msgId:"speak_time_and_date",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.A,KeyCode.D]}}},[Command.START_HISTORY_RECORDING]:{category:CommandCategory.NO_CATEGORY},[Command.STOP_HISTORY_RECORDING]:{category:CommandCategory.NO_CATEGORY},[Command.STOP_SPEECH]:{category:CommandCategory.CONTROLLING_SPEECH,msgId:"stop_speech_key",sequence:{cvoxModifier:false,keys:{ctrlKey:[true],keyCode:[KeyCode.CONTROL]}},altSequence:{keys:{ctrlKey:[true],keyCode:[KeyCode.CONTROL]}}},[Command.TOGGLE_BRAILLE_CAPTIONS]:{category:CommandCategory.HELP_COMMANDS,msgId:"braille_captions",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.A,KeyCode.B]}}},[Command.TOGGLE_BRAILLE_TABLE]:{category:CommandCategory.HELP_COMMANDS,msgId:"toggle_braille_table",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.A,KeyCode.G]}}},[Command.TOGGLE_CAPTIONS]:{category:CommandCategory.NO_CATEGORY,msgId:"toggle_captions",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.O,KeyCode.C]}}},[Command.TOGGLE_DICTATION]:{category:CommandCategory.ACTIONS,msgId:"toggle_dictation",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.D]}}},[Command.TOGGLE_EARCONS]:{category:CommandCategory.CONTROLLING_SPEECH,msgId:"toggle_earcons",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.A,KeyCode.E]}}},[Command.TOGGLE_KEYBOARD_HELP]:{category:CommandCategory.HELP_COMMANDS,msgId:"show_panel_menu",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.OEM_PERIOD]}}},[Command.TOGGLE_SCREEN]:{category:CommandCategory.MODIFIER_KEYS,msgId:"toggle_screen",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.BRIGHTNESS_UP]}}},[Command.TOGGLE_SEARCH_WIDGET]:{category:CommandCategory.INFORMATION,msgId:"toggle_search_widget",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.OEM_2]}}},[Command.TOGGLE_SELECTION]:{category:CommandCategory.ACTIONS,msgId:"toggle_selection",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.S]}}},[Command.TOGGLE_SEMANTICS]:{category:CommandCategory.INFORMATION,msgId:"toggle_semantics"},[Command.TOGGLE_SPEECH_ON_OR_OFF]:{category:CommandCategory.CONTROLLING_SPEECH,msgId:"speech_on_off_description",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.VOLUME_MUTE]}}},[Command.TOGGLE_STICKY_MODE]:{category:CommandCategory.MODIFIER_KEYS,msgId:"toggle_sticky_mode",sequence:{skipStripping:false,doubleTap:true,keys:{keyCode:[KeyCode.SEARCH]}}},[Command.TOP]:{category:CommandCategory.BRAILLE,msgId:"braille_top"},[Command.VIEW_GRAPHIC_AS_BRAILLE]:{category:CommandCategory.BRAILLE,msgId:"view_graphic_as_braille",sequence:{cvoxModifier:true,keys:{keyCode:[KeyCode.G],altKey:[true]}}},[Command.NATIVE_NEXT_CHARACTER]:{category:CommandCategory.NO_CATEGORY,sequence:{cvoxModifier:false,keys:{keyCode:[KeyCode.RIGHT]}}},[Command.NATIVE_NEXT_WORD]:{category:CommandCategory.NO_CATEGORY,sequence:{cvoxModifier:false,keys:{keyCode:[KeyCode.RIGHT],ctrlKey:[true]}}},[Command.NATIVE_PREVIOUS_CHARACTER]:{category:CommandCategory.NO_CATEGORY,sequence:{cvoxModifier:false,keys:{keyCode:[KeyCode.LEFT]}}},[Command.NATIVE_PREVIOUS_WORD]:{category:CommandCategory.NO_CATEGORY,sequence:{cvoxModifier:false,keys:{keyCode:[KeyCode.LEFT],ctrlKey:[true]}}}};var EventSourceType;(function(EventSourceType){EventSourceType["NONE"]="none";EventSourceType["BRAILLE_KEYBOARD"]="brailleKeyboard";EventSourceType["STANDARD_KEYBOARD"]="standardKeyboard";EventSourceType["TOUCH_GESTURE"]="touchGesture"})(EventSourceType||(EventSourceType={}));TestImportManager.exportForTesting(["EventSourceType",EventSourceType]);var GestureCommandData;(function(GestureCommandData){GestureCommandData.GESTURE_COMMAND_MAP={click:{command:Command.FORCE_CLICK_ON_CURRENT_ITEM,msgId:"click_gesture"},swipeUp1:{msgId:"swipeup1_gesture",command:Command.PREVIOUS_AT_GRANULARITY,menuKeyOverride:{keyCode:KeyCode.UP}},swipeDown1:{msgId:"swipedown1_gesture",command:Command.NEXT_AT_GRANULARITY,menuKeyOverride:{keyCode:KeyCode.DOWN}},swipeLeft1:{msgId:"swipeleft1_gesture",command:Command.PREVIOUS_OBJECT,menuKeyOverride:{keyCode:KeyCode.LEFT}},swipeRight1:{msgId:"swiperight1_gesture",command:Command.NEXT_OBJECT,menuKeyOverride:{keyCode:KeyCode.RIGHT}},swipeUp2:{msgId:"swipeup2_gesture",command:Command.JUMP_TO_TOP},swipeDown2:{msgId:"swipedown2_gesture",command:Command.READ_FROM_HERE},swipeLeft2:{msgId:"swipeleft2_gesture",commandDescriptionMsgId:"escape_gesture_description",globalKey:{keyCode:KeyCode.ESCAPE}},swipeRight2:{msgId:"swiperight2_gesture",commandDescriptionMsgId:"enter_gesture_description",globalKey:{keyCode:KeyCode.RETURN}},swipeUp3:{msgId:"swipeup3_gesture",commandDescriptionMsgId:"next_page_gesture_description",command:Command.NEXT_PAGE},swipeDown3:{msgId:"swipedown3_gesture",commandDescriptionMsgId:"previous_page_gesture_description",command:Command.PREVIOUS_PAGE},swipeLeft3:{msgId:"swipeleft3_gesture",command:Command.PREVIOUS_GRANULARITY},swipeRight3:{msgId:"swiperight3_gesture",command:Command.NEXT_GRANULARITY},swipeLeft4:{msgId:"swipeleft4_gesture",commandDescriptionMsgId:"previous_pane_gesture_description",acceleratorAction:chrome.accessibilityPrivate.AcceleratorAction.FOCUS_PREVIOUS_PANE},swipeRight4:{msgId:"swiperight4_gesture",commandDescriptionMsgId:"next_pane_gesture_description",acceleratorAction:chrome.accessibilityPrivate.AcceleratorAction.FOCUS_NEXT_PANE},touchExplore:{msgId:"touch_explore_gesture"},tap2:{msgId:"tap2_gesture",command:Command.STOP_SPEECH},tap4:{msgId:"tap4_gesture",command:Command.SHOW_PANEL_MENU_MOST_RECENT}}})(GestureCommandData||(GestureCommandData={}));var GestureGranularity;(function(GestureGranularity){GestureGranularity[GestureGranularity["CHARACTER"]=0]="CHARACTER";GestureGranularity[GestureGranularity["WORD"]=1]="WORD";GestureGranularity[GestureGranularity["LINE"]=2]="LINE";GestureGranularity[GestureGranularity["HEADING"]=3]="HEADING";GestureGranularity[GestureGranularity["LINK"]=4]="LINK";GestureGranularity[GestureGranularity["FORM_FIELD_CONTROL"]=5]="FORM_FIELD_CONTROL";GestureGranularity[GestureGranularity["COUNT"]=6]="COUNT"})(GestureGranularity||(GestureGranularity={}));class KeyMap{bindings_;commandToKey_={};static instance;constructor(keyBindings){this.bindings_=keyBindings;this.buildCommandToKey_()}length(){return this.bindings_.length}keys(){return this.bindings_.map((binding=>binding.sequence))}bindings(){return this.bindings_.slice()}hasBinding(command,sequence){if(this.commandToKey_!=null){return this.commandToKey_[command]===sequence}return this.bindings_.some((b=>b.command===command&&b.sequence.equals(sequence)))}hasCommand(command){if(this.commandToKey_!=null){return this.commandToKey_[command]!==undefined}return this.bindings_.some((b=>b.command===command))}hasKey(key){return this.bindings_.some((b=>b.sequence.equals(key)))}commandForKey(key){return this.bindings_.find((b=>b.sequence.equals(key)))?.command}keyForCommand(command){if(this.commandToKey_!=null){return[this.commandToKey_[command]]}return this.bindings_.filter((b=>b.command===command)).map((b=>b.sequence))}static get(){if(KeyMap.instance){return KeyMap.instance}const keyBindings=CommandStore.getKeyBindings();KeyMap.instance=new KeyMap(keyBindings);return KeyMap.instance}buildCommandToKey_(){for(const binding of this.bindings_){if(this.commandToKey_[binding.command]!==undefined){continue}this.commandToKey_[binding.command]=binding.sequence}}}TestImportManager.exportForTesting(KeyMap);var KeyUtil;(function(KeyUtil){function keyEventToKeySequence(keyEvent){if(KeyUtil.prevKeySequence&&KeyUtil.maxSeqLength===KeyUtil.prevKeySequence.length()){KeyUtil.sequencing=false;KeyUtil.prevKeySequence=null}const hasKeyPrefix=keyEvent.keyPrefix;const stickyMode=keyEvent.stickyMode;const keyIsPrefixed=KeyUtil.sequencing||hasKeyPrefix||stickyMode;let keySequence=new KeySequence(keyEvent);const keyWasCvox=keySequence.cvoxModifier;if(keyIsPrefixed||keyWasCvox){if(!KeyUtil.sequencing&&KeyUtil.isSequenceSwitchKeyCode(keySequence)){KeyUtil.sequencing=true;KeyUtil.prevKeySequence=keySequence;return keySequence}else if(KeyUtil.sequencing){if(KeyUtil.prevKeySequence.addKeyEvent(keyEvent)){keySequence=KeyUtil.prevKeySequence;KeyUtil.prevKeySequence=null;KeyUtil.sequencing=false;return keySequence}else{throw"Think sequencing is enabled, yet KeyUtil.prevKeySequence"+"already has two key codes ("+KeyUtil.prevKeySequence+")"}}}else{KeyUtil.sequencing=false}const currTime=(new Date).getTime();if(KeyUtil.isDoubleTapKey(keySequence)&&KeyUtil.prevKeySequence&&keySequence.equals(KeyUtil.prevKeySequence)){const prevTime=KeyUtil.modeKeyPressTime;const delta=currTime-prevTime;if(!keyEvent.repeat&&prevTime>0&&delta<300){keySequence=KeyUtil.prevKeySequence;keySequence.doubleTap=true;KeyUtil.prevKeySequence=null;KeyUtil.sequencing=false;return keySequence}}KeyUtil.prevKeySequence=keySequence;KeyUtil.modeKeyPressTime=currTime;return keySequence}KeyUtil.keyEventToKeySequence=keyEventToKeySequence;function keyCodeToString(keyCode){if(keyCode===KeyCode.CONTROL){return"Ctrl"}if(KeyCode.name(keyCode)){return KeyCode.name(keyCode)}return"#"+keyCode}KeyUtil.keyCodeToString=keyCodeToString;function modStringToKeyCode(keyString){switch(keyString){case"Ctrl":return KeyCode.CONTROL;case"Alt":return KeyCode.ALT;case"Shift":return KeyCode.SHIFT;case"Cmd":case"Win":return KeyCode.SEARCH}return-1}KeyUtil.modStringToKeyCode=modStringToKeyCode;function cvoxModKeyCodes(){const modKeyCombo=KeySequence.modKeyStr.split(/\+/g);const modKeyCodes=modKeyCombo.map((keyString=>KeyUtil.modStringToKeyCode(keyString)));return modKeyCodes}KeyUtil.cvoxModKeyCodes=cvoxModKeyCodes;function isSequenceSwitchKeyCode(rhKeySeq){for(let i=0;i<KeySequence.sequenceSwitchKeyCodes.length;i++){const lhKeySeq=KeySequence.sequenceSwitchKeyCodes[i];if(lhKeySeq.equals(rhKeySeq)){return true}}return false}KeyUtil.isSequenceSwitchKeyCode=isSequenceSwitchKeyCode;function getReadableNameForKeyCode(keyCode){const msg=Msgs.getMsg.bind(Msgs);switch(keyCode){case KeyCode.BROWSER_BACK:return msg("back_key");case KeyCode.BROWSER_FORWARD:return msg("forward_key");case KeyCode.BROWSER_REFRESH:return msg("refresh_key");case KeyCode.ZOOM:return msg("toggle_full_screen_key");case KeyCode.MEDIA_LAUNCH_APP1:return msg("window_overview_key");case KeyCode.BRIGHTNESS_DOWN:return msg("brightness_down_key");case KeyCode.BRIGHTNESS_UP:return msg("brightness_up_key");case KeyCode.VOLUME_MUTE:return msg("volume_mute_key");case KeyCode.VOLUME_DOWN:return msg("volume_down_key");case KeyCode.VOLUME_UP:return msg("volume_up_key");case KeyCode.ASSISTANT:return msg("assistant_key");case KeyCode.MEDIA_PLAY_PAUSE:return msg("media_play_pause")}return KeyCode.name(keyCode)}KeyUtil.getReadableNameForKeyCode=getReadableNameForKeyCode;function getStickyKeyCode(){return KeyCode.SEARCH}KeyUtil.getStickyKeyCode=getStickyKeyCode;function getReadableNameForStr(_keyStr){return null}KeyUtil.getReadableNameForStr=getReadableNameForStr;async function keySequenceToString(keySequence,readableKeyCode,modifiers){let str="";const numKeys=keySequence.length();for(let index=0;index<numKeys;index++){if(str!==""&&!modifiers){str+=", then "}else if(str!==""){str+="+"}let tempStr="";for(const keyPressed in keySequence.keys){if(!keySequence.keys[keyPressed][index]){continue}let modifier="";switch(keyPressed){case"ctrlKey":modifier="Ctrl";break;case"searchKeyHeld":const searchKey=KeyUtil.getReadableNameForKeyCode(KeyCode.SEARCH);modifier=searchKey;break;case"altKey":modifier="Alt";break;case"altGraphKey":modifier="AltGraph";break;case"shiftKey":modifier="Shift";break;case"metaKey":const metaKey=KeyUtil.getReadableNameForKeyCode(KeyCode.SEARCH);modifier=metaKey;break;case"keyCode":const keyCode=keySequence.keys[keyPressed][index];if(keySequence.isModifierKey(keyCode)||modifiers){break}if(!readableKeyCode){tempStr+=KeyUtil.keyCodeToString(keyCode);break}let domKeyString=await AsyncUtil.getLocalizedDomKeyStringForKeyCode(keyCode);if(!domKeyString){tempStr+=KeyUtil.getReadableNameForKeyCode(keyCode);break}if(domKeyString.length===1){domKeyString=domKeyString.toUpperCase()}tempStr+=domKeyString;break}if(str.indexOf(modifier)===-1){tempStr+=modifier+"+"}}str+=tempStr;if(str[str.length-1]==="+"){str=str.slice(0,-1)}}if(keySequence.cvoxModifier||keySequence.prefixKey){if(str!==""){str="Search+"+str}else{str="Search+Search"}}else if(keySequence.stickyMode){const cut=str.slice(str.length-", then ".length);if(cut===", then "){str=str.slice(0,str.length-cut.length)}str=str+"+"+str}return str}KeyUtil.keySequenceToString=keySequenceToString;function isDoubleTapKey(key){let isSet=false;const originalState=key.doubleTap;key.doubleTap=true;for(let i=0,keySeq;keySeq=KeySequence.doubleTapCache[i];i++){if(keySeq.equals(key)){isSet=true;break}}key.doubleTap=originalState;return isSet}KeyUtil.isDoubleTapKey=isDoubleTapKey;KeyUtil.modeKeyPressTime=0;KeyUtil.sequencing=false;KeyUtil.prevKeySequence=null;KeyUtil.stickyKeySequence=null;KeyUtil.maxSeqLength=2})(KeyUtil||(KeyUtil={}));var PanelNodeMenuId;(function(PanelNodeMenuId){PanelNodeMenuId[PanelNodeMenuId["HEADING"]=1]="HEADING";PanelNodeMenuId[PanelNodeMenuId["LANDMARK"]=2]="LANDMARK";PanelNodeMenuId[PanelNodeMenuId["LINK"]=3]="LINK";PanelNodeMenuId[PanelNodeMenuId["FORM_CONTROL"]=4]="FORM_CONTROL";PanelNodeMenuId[PanelNodeMenuId["TABLE"]=5]="TABLE"})(PanelNodeMenuId||(PanelNodeMenuId={}));const ALL_PANEL_MENU_NODE_DATA=[{menuId:PanelNodeMenuId.HEADING,titleId:"role_heading",predicate:AutomationPredicate.heading},{menuId:PanelNodeMenuId.LANDMARK,titleId:"role_landmark",predicate:AutomationPredicate.landmark},{menuId:PanelNodeMenuId.LINK,titleId:"role_link",predicate:AutomationPredicate.link},{menuId:PanelNodeMenuId.FORM_CONTROL,titleId:"panel_menu_form_controls",predicate:AutomationPredicate.formField},{menuId:PanelNodeMenuId.TABLE,titleId:"role_table",predicate:AutomationPredicate.table}];TestImportManager.exportForTesting(["PanelNodeMenuId",PanelNodeMenuId],["ALL_PANEL_MENU_NODE_DATA",ALL_PANEL_MENU_NODE_DATA]);class PanelMenuItem{callback;element;gesture;menuItemBraille;menuItemShortcut;menuItemTitle;enabled_=true;constructor(menuItemTitle,menuItemShortcut,menuItemBraille,gesture,callback,optId){this.menuItemTitle=menuItemTitle;this.menuItemShortcut=menuItemShortcut;this.menuItemBraille=menuItemBraille;this.gesture=gesture;this.callback=callback;this.init_(optId)}async init_(optId){this.element=document.createElement("tr");this.element.className="menu-item";this.element.tabIndex=-1;this.element.setAttribute("role","menuitem");if(optId){this.element.id=optId}this.element.addEventListener("mouseover",(()=>this.element.focus()),false);const title=document.createElement("td");title.className="menu-item-title";title.textContent=this.menuItemTitle;title.title=this.menuItemTitle;this.element.appendChild(title);const eventSource=await BackgroundBridge.EventSource.get();if(eventSource===EventSourceType.TOUCH_GESTURE){const gestureNode=document.createElement("td");gestureNode.className="menu-item-shortcut";gestureNode.textContent=this.gesture??null;this.element.appendChild(gestureNode);return}const shortcut=document.createElement("td");shortcut.className="menu-item-shortcut";shortcut.textContent=this.menuItemShortcut??null;this.element.appendChild(shortcut);if(LocalStorage.get("brailleCaptions")||SettingsManager.get("menuBrailleCommands")){const braille=document.createElement("td");braille.className="menu-item-shortcut";braille.textContent=this.menuItemBraille??null;this.element.appendChild(braille)}}get text(){return this.element.textContent}get enabled(){return this.enabled_}disable(){this.enabled_=false;this.element.classList.add("disabled");this.element.setAttribute("aria-disabled",String(true))}}class PanelMenu{menuBarItemElement;menuContainerElement;menuElement;menuMsg;activeIndex_=-1;enabled_=true;items_=[];updateScrollbarsTimeout_=null;constructor(menuMsg){this.menuMsg=menuMsg;this.menuBarItemElement=document.createElement("div");this.menuBarItemElement.className="menu-bar-item";this.menuBarItemElement.setAttribute("role","menu");const menuTitle=Msgs.getMsg(menuMsg);this.menuBarItemElement.textContent=menuTitle;this.menuContainerElement=document.createElement("div");this.menuContainerElement.className="menu-container";this.menuContainerElement.style.visibility="hidden";this.menuElement=document.createElement("table");this.menuElement.className="menu";this.menuElement.setAttribute("role","menu");this.menuElement.setAttribute("aria-label",menuTitle);this.menuContainerElement.appendChild(this.menuElement);this.menuElement.addEventListener("keypress",this.onKeyPress_.bind(this),true)}addMenuItem(menuItemTitle,menuItemShortcut,menuItemBraille,gesture,callback,id){const menuItem=new PanelMenuItem(menuItemTitle,menuItemShortcut,menuItemBraille,gesture,callback,id);const menuElement=menuItem.element;this.items_.push(menuItem);this.menuElement.appendChild(menuElement);const lastItemIndex=this.items_.length-1;menuElement.addEventListener("focus",(()=>this.activeIndex_=lastItemIndex),false);if(!this.updateScrollbarsTimeout_){this.updateScrollbarsTimeout_=setTimeout((()=>{const menuBounds=this.menuElement.getBoundingClientRect();const maxHeight=window.innerHeight-menuBounds.top;this.menuContainerElement.style.maxHeight=maxHeight+"px";this.updateScrollbarsTimeout_=null}),0)}return menuItem}activate(activateFirstItem){if(!this.enabled_){this.menuBarItemElement.focus();return}this.menuContainerElement.style.visibility="visible";this.menuContainerElement.style.opacity=String(1);this.menuBarItemElement.classList.add("active");const barBounds=this.menuBarItemElement.parentElement.getBoundingClientRect();const titleBounds=this.menuBarItemElement.getBoundingClientRect();const menuBounds=this.menuElement.getBoundingClientRect();this.menuElement.style.minWidth=titleBounds.width+"px";this.menuContainerElement.style.minWidth=titleBounds.width+"px";if(titleBounds.left+menuBounds.width<barBounds.width){this.menuContainerElement.style.left=titleBounds.left+"px"}else{this.menuContainerElement.style.left=titleBounds.right-menuBounds.width+"px"}if(activateFirstItem){this.activateItem(0)}}disable(){this.enabled_=false;this.menuBarItemElement.classList.add("disabled");this.menuBarItemElement.setAttribute("aria-disabled",String(true));this.menuBarItemElement.setAttribute("tabindex",String(0));this.menuBarItemElement.setAttribute("aria-label",this.menuBarItemElement.textContent);this.activeIndex_=-1}deactivate(){this.menuContainerElement.style.opacity=String(.001);this.menuBarItemElement.classList.remove("active");this.activeIndex_=-1;setTimeout((()=>this.menuContainerElement.style.visibility="hidden"),0)}activateItem(itemIndex){this.activeIndex_=itemIndex;if(this.activeIndex_>=0&&this.activeIndex_<this.items_.length){this.items_[this.activeIndex_].element.focus()}}advanceItemBy(delta){if(!this.enabled_){return}if(this.activeIndex_>=0){this.activeIndex_+=delta;this.activeIndex_=(this.activeIndex_+this.items_.length)%this.items_.length}else{if(delta>=0){this.activeIndex_=0}else{this.activeIndex_=this.items_.length-1}}this.activeIndex_=this.findEnabledItemIndex_(this.activeIndex_,delta>0?1:-1);if(this.activeIndex_===-1){return}this.items_[this.activeIndex_].element.focus()}scrollToTop(){this.activeIndex_=0;this.items_[this.activeIndex_].element.focus()}scrollToBottom(){this.activeIndex_=this.items_.length-1;this.items_[this.activeIndex_].element.focus()}getCallbackForCurrentItem(){if(this.activeIndex_>=0&&this.activeIndex_<this.items_.length){return this.items_[this.activeIndex_].callback}return null}getCallbackForElement(element){for(let i=0;i<this.items_.length;i++){if(element===this.items_[i].element){return this.items_[i].callback}}return null}onKeyPress_(evt){if(!this.items_.length){return}const query=String.fromCharCode(evt.charCode).toLowerCase();for(let i=this.activeIndex_+1;i!==this.activeIndex_;i=(i+1)%this.items_.length){if(this.items_[i].text.toLowerCase().indexOf(query)===0){this.activateItem(i);break}}}get enabled(){return this.enabled_}get items(){return this.items_}findEnabledItemIndex_(startIndex,delta){const endIndex=delta>0?this.items_.length:-1;while(startIndex!==endIndex){if(this.items_[startIndex].enabled){return startIndex}startIndex+=delta}return-1}}class PanelNodeMenu extends PanelMenu{activate(activateFirstItem){super.activate(false);if(activateFirstItem){const index=this.activeIndex_===-1?0:this.activeIndex_;this.activateItem(index)}}addItemFromData(data){this.addMenuItem(data.title,"","","",(async()=>{if(data.callbackId){BridgeCallbackManager.performCallback(data.callbackId)}}));if(data.isActive){this.activeIndex_=this.items_.length-1}}}class PanelSearchMenu extends PanelMenu{searchBar;searchResultCounter_=0;constructor(menuMsg){super(menuMsg);this.menuElement.setAttribute("id","search-results");this.searchBar=document.createElement("input");this.searchBar.setAttribute("id","menus-search-bar");this.searchBar.setAttribute("type","search");this.searchBar.setAttribute("aria-controls","search-results");this.searchBar.setAttribute("aria-activedescendant","");this.searchBar.setAttribute("placeholder",Msgs.getMsg("search_chromevox_menus_placeholder"));this.searchBar.setAttribute("aria-description",Msgs.getMsg("search_chromevox_menus_description"));this.searchBar.setAttribute("role","searchbox");const menuItem=document.createElement("tr");menuItem.tabIndex=-1;menuItem.setAttribute("role","menuitem");menuItem.appendChild(this.searchBar);this.menuContainerElement.insertBefore(menuItem,this.menuElement)}activate(_activateFirstItem){PanelMenu.prototype.activate.call(this,false);if(this.searchBar.value===""){this.clear()}if(this.items.length>0){this.activateItem(this.activeIndex_)}this.searchBar.focus()}activateItem(index){this.resetItemAtActiveIndex();if(this.items.length===0){return}if(index>=0){index=(index+this.items.length)%this.items.length}else{if(index>=this.activeIndex_){index=0}else{index=this.items.length-1}}this.activeIndex_=index;const item=this.items[this.activeIndex_];this.searchBar.setAttribute("aria-activedescendant",item.element.id);item.element.classList.add("active");const itemBounds=item.element.getBoundingClientRect();const menuBarBounds=this.menuBarItemElement.getBoundingClientRect();const topThreshold=menuBarBounds.bottom;const bottomThreshold=window.innerHeight;if(itemBounds.bottom>bottomThreshold){item.element.scrollIntoView(true)}else if(itemBounds.top<topThreshold){item.element.scrollIntoView(false)}}addMenuItem(menuItemTitle,menuItemShortcut,menuItemBraille,gesture,callback,_id){this.searchResultCounter_+=1;const item=PanelMenu.prototype.addMenuItem.call(this,menuItemTitle,menuItemShortcut,menuItemBraille,gesture,callback,"result-number-"+this.searchResultCounter_.toString());item.element.addEventListener("mouseover",(()=>this.resetItemAtActiveIndex()),true);return item}advanceItemBy(delta){this.activateItem(this.activeIndex_+delta)}clear(){this.items_=[];this.activeIndex_=-1;while(this.menuElement.children.length!==0){this.menuElement.removeChild(this.menuElement.firstChild)}this.searchBar.setAttribute("aria-activedescendant","")}copyAndAddMenuItem(item){return this.addMenuItem(item.menuItemTitle,item.menuItemShortcut,item.menuItemBraille,item.gesture,item.callback)}deactivate(){this.resetItemAtActiveIndex();PanelMenu.prototype.deactivate.call(this)}resetItemAtActiveIndex(){if(this.activeIndex_<0||this.activeIndex_>=this.items.length){return}this.items_[this.activeIndex_].element.classList.remove("active")}scrollToTop(){this.activateItem(0)}scrollToBottom(){this.activateItem(this.items_.length-1)}}var PanelMode;(function(PanelMode){PanelMode["COLLAPSED"]="collapsed";PanelMode["FOCUSED"]="focused";PanelMode["FULLSCREEN_MENUS"]="menus";PanelMode["FULLSCREEN_TUTORIAL"]="tutorial";PanelMode["SEARCH"]="search"})(PanelMode||(PanelMode={}));const PanelModeInfo={[PanelMode.COLLAPSED]:{title:"panel_title",location:"#"},[PanelMode.FOCUSED]:{title:"panel_title",location:"#focus"},[PanelMode.FULLSCREEN_MENUS]:{title:"panel_menus_title",location:"#fullscreen"},[PanelMode.FULLSCREEN_TUTORIAL]:{title:"panel_tutorial_title",location:"#fullscreen"},[PanelMode.SEARCH]:{title:"panel_title",location:"#focus"}};const $$2=id=>document.getElementById(id);class MenuManager{activeMenu_=null;lastMenu_="";menus_=[];nodeMenuDictionary_={};searchMenu_=null;static disableMissingMsgsErrorsForTesting=false;activateMenu(menu,activateFirstItem){if(menu===this.activeMenu_){return}if(this.activeMenu_){this.activeMenu_.deactivate();this.activeMenu_=null}this.activeMenu_=menu;PanelInterface.instance.setPendingCallback(null);if(this.activeMenu_){this.activeMenu_.activate(activateFirstItem)}}async addActionsMenuItems(actionsMenu,bindingMap){const actions=await BackgroundBridge.PanelBackground.getActionsForCurrentNode();for(const standardAction of actions.standardActions){const actionMsg=ACTION_TO_MSG_ID[standardAction];if(!actionMsg){continue}const commandName=CommandStore.commandForMessage(actionMsg);let shortcutName="";if(commandName){const commandBinding=bindingMap.get(commandName);shortcutName=commandBinding?commandBinding.keySeq:""}const actionDesc=Msgs.getMsg(actionMsg);actionsMenu.addMenuItem(actionDesc,shortcutName,"","",(()=>BackgroundBridge.PanelBackground.performStandardActionOnCurrentNode(standardAction)))}for(const customAction of actions.customActions){actionsMenu.addMenuItem(customAction.description,"","","",(()=>BackgroundBridge.PanelBackground.performCustomActionOnCurrentNode(customAction.id)))}}addMenu(menuMsg){const menu=new PanelMenu(menuMsg);$$2("menu-bar").appendChild(menu.menuBarItemElement);menu.menuBarItemElement.addEventListener("mouseover",(()=>this.activateMenu(menu,true)),false);menu.menuBarItemElement.addEventListener("mouseup",(event=>this.onMouseUpOnMenuTitle(menu,event)),false);$$2("menus_background").appendChild(menu.menuContainerElement);this.menus_.push(menu);return menu}addMenuItemFromKeyBinding(binding,menu,isTouchScreen){if(!binding.title||!menu){return}let keyText;let brailleText;let gestureText;if(isTouchScreen){const gestureData=Object.values(GestureCommandData.GESTURE_COMMAND_MAP);const data=gestureData.find((data=>data.command===binding.command));if(data){gestureText=Msgs.getMsg(data.msgId)}}else{keyText=binding.keySeq;brailleText=BrailleCommandData.getDotShortcut(binding.command,true)}menu.addMenuItem(binding.title,keyText,brailleText,gestureText,(()=>BackgroundBridge.CommandHandler.onCommand(binding.command)),binding.command)}addNodeMenu(menuData){const menu=new PanelNodeMenu(menuData.titleId);$$2("menu-bar").appendChild(menu.menuBarItemElement);menu.menuBarItemElement.addEventListener("mouseover",(()=>this.activateMenu(menu,true)));menu.menuBarItemElement.addEventListener("mouseup",(event=>this.onMouseUpOnMenuTitle(menu,event)));$$2("menus_background").appendChild(menu.menuContainerElement);this.menus_.push(menu);this.nodeMenuDictionary_[menuData.menuId]=menu}addNodeMenuItem(itemData){this.nodeMenuDictionary_[itemData.menuId]?.addItemFromData(itemData)}addSearchMenu(menuMsg){this.searchMenu_=new PanelSearchMenu(menuMsg);this.searchMenu_.searchBar.addEventListener("input",(event=>this.onSearchBarQuery(event)),false);this.searchMenu_.searchBar.addEventListener("mouseup",(event=>{event.preventDefault();event.stopPropagation()}),false);$$2("menu-bar").appendChild(this.searchMenu_.menuBarItemElement);this.searchMenu_.menuBarItemElement.addEventListener("mouseover",(()=>this.activateMenu(this.searchMenu_,false)),false);this.searchMenu_.menuBarItemElement.addEventListener("mouseup",(event=>this.onMouseUpOnMenuTitle(this.searchMenu_,event)),false);$$2("menus_background").appendChild(this.searchMenu_.menuContainerElement);this.menus_.push(this.searchMenu_);return this.searchMenu_}addTouchGestureMenuItems(touchMenu){const touchGestureItems=[];for(const data of Object.values(GestureCommandData.GESTURE_COMMAND_MAP)){const command=data.command;if(!command){continue}const gestureText=Msgs.getMsg(data.msgId);const msgForCmd=data.commandDescriptionMsgId||CommandStore.messageForCommand(command);let titleText;if(msgForCmd){titleText=Msgs.getMsg(msgForCmd)}else{console.error("No localization for: "+command+" (gesture)");titleText=""}touchGestureItems.push({titleText:titleText,gestureText:gestureText,command:command})}touchGestureItems.sort(((item1,item2)=>item1.titleText.localeCompare(item2.titleText)));for(const item of touchGestureItems){touchMenu.addMenuItem(item.titleText,"","",item.gestureText,(()=>BackgroundBridge.CommandHandler.onCommand(item.command)),item.command)}}advanceActiveMenuBy(delta){let activeIndex=this.menus_.findIndex((menu=>menu===this.activeMenu_));if(activeIndex>=0){activeIndex+=delta;activeIndex=(activeIndex+this.menus_.length)%this.menus_.length}else{if(delta>=0){activeIndex=0}else{activeIndex=this.menus_.length-1}}activeIndex=this.findEnabledMenuIndex(activeIndex,delta>0?1:-1);if(activeIndex===-1){return}this.activateMenu(this.menus_[activeIndex],true)}advanceItemBy(delta){if(this.activeMenu_){this.activeMenu_.advanceItemBy(delta)}}clearMenus(){while(this.menus_.length){const menu=this.menus_.pop();$$2("menu-bar").removeChild(menu.menuBarItemElement);$$2("menus_background").removeChild(menu.menuContainerElement);if(this.activeMenu_){this.lastMenu_=this.activeMenu_.menuMsg}this.activeMenu_=null}}denySignedOut(){for(const menu of this.menus_){for(const item of menu.items){if(CommandStore.denySignedOut(item.element.id)){item.disable()}}}}findEnabledMenuIndex(startIndex,delta){const endIndex=delta>0?this.menus_.length:-1;while(startIndex!==endIndex){if(this.menus_[startIndex].enabled){return startIndex}startIndex+=delta}return-1}getCallbackForCurrentItem(){if(this.activeMenu_){return this.activeMenu_.getCallbackForCurrentItem()}return null}getSelectedMenu(menuTitle){const specifiedMenu=this.menus_.find((menu=>menu.menuMsg===menuTitle));return specifiedMenu||this.searchMenu_||this.menus_[0]}async getSortedKeyBindings(){const keymap=KeyMap.get();const sortedBindings=keymap.bindings();for(const binding of sortedBindings){const command=binding.command;const keySeq=binding.sequence;binding.keySeq=await KeyUtil.keySequenceToString(keySeq,true);const titleMsgId=CommandStore.messageForCommand(command);if(!titleMsgId){if(!(command in COMMANDS_WITH_NO_MSG_ID)&&!MenuManager.disableMissingMsgsErrorsForTesting){console.log("No localization for: "+command)}binding.title="";continue}const title=Msgs.getMsg(titleMsgId);binding.title=StringUtil.toTitleCase(title)}sortedBindings.sort(((binding1,binding2)=>binding1.title.localeCompare(String(binding2.title))));return sortedBindings}makeBindingMap(sortedBindings){const bindingMap=new Map;for(const binding of sortedBindings){bindingMap.set(binding.command,binding)}return bindingMap}makeCategoryMapping(actionsMenu,chromevoxMenu,jumpMenu,speechMenu){return{[CommandCategory.ACTIONS]:actionsMenu,[CommandCategory.BRAILLE]:null,[CommandCategory.CONTROLLING_SPEECH]:speechMenu,[CommandCategory.DEVELOPER]:null,[CommandCategory.HELP_COMMANDS]:chromevoxMenu,[CommandCategory.INFORMATION]:speechMenu,[CommandCategory.JUMP_COMMANDS]:jumpMenu,[CommandCategory.MODIFIER_KEYS]:chromevoxMenu,[CommandCategory.NAVIGATION]:jumpMenu,[CommandCategory.NO_CATEGORY]:null,[CommandCategory.OVERVIEW]:jumpMenu,[CommandCategory.TABLES]:jumpMenu}}onKeyDown(event){if(!this.activeMenu){return false}if(event.altKey||event.ctrlKey||event.metaKey||event.shiftKey){return false}if(this.searchMenu_&&event.target===this.searchMenu_.searchBar){const input=event.target;switch(event.key){case"ArrowLeft":case"ArrowRight":if(input.value){const cursorIndex=input.selectionStart+(event.key==="ArrowRight"?1:-1);const queryLength=input.value.length;if(cursorIndex>=0&&cursorIndex<=queryLength){return false}}break;case" ":return false}}switch(event.key){case"ArrowLeft":this.advanceActiveMenuBy(-1);break;case"ArrowRight":this.advanceActiveMenuBy(1);break;case"ArrowUp":this.advanceItemBy(-1);break;case"ArrowDown":this.advanceItemBy(1);break;case"Escape":PanelInterface.instance.closeMenusAndRestoreFocus();break;case"PageUp":this.advanceItemBy(10);break;case"PageDown":this.advanceItemBy(-10);break;case"Home":this.scrollToTop();break;case"End":this.scrollToBottom();break;case"Enter":case" ":if(!this.getCallbackForCurrentItem()){return false}PanelInterface.instance.setPendingCallback(this.getCallbackForCurrentItem());PanelInterface.instance.closeMenusAndRestoreFocus();break;default:return false}return true}onMouseUp(event){if(!this.activeMenu_){return}let target=event.target;while(target&&!target.classList.contains("menu-item")){if(target.id==="menus_button"){return}target=target.parentElement}if(target&&this.activeMenu_){PanelInterface.instance.setPendingCallback(this.activeMenu_.getCallbackForElement(target))}PanelInterface.instance.closeMenusAndRestoreFocus()}onMouseUpOnMenuTitle(menu,mouseUpEvent){this.activateMenu(menu,true);mouseUpEvent.preventDefault();mouseUpEvent.stopPropagation()}async onOpenMenus(event,activateMenuTitle){if(PanelInterface.instance.mode!==PanelMode.COLLAPSED){PanelInterface.instance.setMode(PanelMode.COLLAPSED);return}if(event){event.stopPropagation();event.preventDefault()}await BackgroundBridge.PanelBackground.saveCurrentNode();PanelInterface.instance.setMode(PanelMode.FULLSCREEN_MENUS);if(!document.hasFocus()){await waitForWindowFocus()}const eventSource=await BackgroundBridge.EventSource.get();const touchScreen=eventSource===EventSourceType.TOUCH_GESTURE;this.addSearchMenu("panel_search_menu");const jumpMenu=this.addMenu("panel_menu_jump");const speechMenu=this.addMenu("panel_menu_speech");const touchMenu=touchScreen?this.addMenu("panel_menu_touchgestures"):null;const chromevoxMenu=this.addMenu("panel_menu_chromevox");const actionsMenu=this.addMenu("panel_menu_actions");const categoryToMenu=this.makeCategoryMapping(actionsMenu,chromevoxMenu,jumpMenu,speechMenu);const sortedBindings=await this.getSortedKeyBindings();const bindingMap=this.makeBindingMap(sortedBindings);for(const binding of bindingMap.values()){const category=CommandStore.categoryForCommand(binding.command);const menu=category?categoryToMenu[category]:null;this.addMenuItemFromKeyBinding(binding,menu,touchScreen)}if(touchMenu){this.addTouchGestureMenuItems(touchMenu)}if(PanelInterface.instance.sessionState!=="IN_SESSION"){this.denySignedOut()}chromevoxMenu.addMenuItem(Msgs.getMsg("disable_chromevox"),"Ctrl+Alt+Z","","",(async()=>PanelInterface.instance.onClose()));for(const menuData of ALL_PANEL_MENU_NODE_DATA){this.addNodeMenu(menuData)}await BackgroundBridge.PanelBackground.createAllNodeMenuBackgrounds(activateMenuTitle);await this.addActionsMenuItems(actionsMenu,bindingMap);const selectedMenu=this.getSelectedMenu(activateMenuTitle);const activateFirstItem=selectedMenu!==this.searchMenu;this.activateMenu(selectedMenu,activateFirstItem)}onSearchBarQuery(event){if(!this.searchMenu_){throw Error("MenuManager.searchMenu_ must be defined")}const query=event.target.value.toLowerCase();this.searchMenu_.clear();this.activateMenu(this.searchMenu_,false);if(query){for(const menu of this.menus_){if(menu===this.searchMenu_||menu instanceof PanelNodeMenu){continue}for(const item of menu.items){if(!item.menuItemShortcut){continue}const itemText=item.text.toLowerCase();const match=itemText.includes(query)&&itemText!==Msgs.getMsg("panel_menu_item_none").toLowerCase()&&item.enabled;if(match){this.searchMenu_.copyAndAddMenuItem(item)}}}}if(this.searchMenu_.items.length===0){this.searchMenu_.addMenuItem(Msgs.getMsg("panel_menu_item_none"),"","","",(()=>Promise.resolve()))}this.searchMenu_.activateItem(0)}scrollToBottom(){this.activeMenu_.scrollToBottom()}scrollToTop(){this.activeMenu_.scrollToTop()}get activeMenu(){return this.activeMenu_}set activeMenu(menu){this.activeMenu_=menu}get lastMenu(){return this.lastMenu_}set lastMenu(menuMsg){this.lastMenu_=menuMsg}get menus(){return this.menus_}get nodeMenuDictionary(){return this.nodeMenuDictionary_}get searchMenu(){return this.searchMenu_}set searchMenu(menu){this.searchMenu_=menu}}const COMMANDS_WITH_NO_MSG_ID=["nativeNextCharacter","nativePreviousCharacter","nativeNextWord","nativePreviousWord","enableLogging","disableLogging","dumpTree","showActionsMenu","enableChromeVoxArcSupportForCurrentApp","disableChromeVoxArcSupportForCurrentApp","showTalkBackKeyboardShortcuts","copy"];const ACTION_TO_MSG_ID={decrement:"action_decrement_description",doDefault:"perform_default_action",increment:"action_increment_description",scrollBackward:"action_scroll_backward_description",scrollForward:"action_scroll_forward_description",showContextMenu:"show_context_menu",longClick:"force_long_click_on_current_item"};async function waitForWindowFocus(){return new Promise((resolve=>window.addEventListener("focus",resolve,{once:true})))}TestImportManager.exportForTesting(MenuManager);class BrailleCaptions{brailleTableElement_=$$1("braille-table");brailleTableElement2_=$$1("braille-table2");addBorders(cell){if(cell.tagName==="TD"){cell.className="highlighted-cell";const companionIDs=cell.getAttribute("data-companionIDs");companionIDs.split(" ").forEach((companionID=>$$1(companionID).className="highlighted-cell"))}}clearTables(){this.clearTable_(this.brailleTableElement_);this.clearTable_(this.brailleTableElement2_)}removeBorders(cell){if(cell.tagName==="TD"){cell.className="unhighlighted-cell";const companionIDs=cell.getAttribute("data-companionIDs");companionIDs.split(" ").forEach((companionID=>$$1(companionID).className="unhighlighted-cell"))}}routeCursor(cell){if(cell.tagName==="TD"){const displayPosition=parseInt(cell.id.split("-")[0],10);if(Number.isNaN(displayPosition)){throw new Error("The display position is calculated assuming that the cell ID "+"is formatted like int-string. For example, 0-brailleCell is a "+"valid cell ID.")}chrome.extension.getBackgroundPage()["ChromeVox"].braille.route(displayPosition)}}clearTable_(table){const rowCount=table.rows.length;for(let i=0;i<rowCount;i++){table.deleteRow(0)}}}function $$1(id){return document.getElementById(id)}var PanelCaptions;(function(PanelCaptions){function init(){if(PanelCaptions.braille){throw new Error("Cannot create two PanelCaptions instances")}PanelCaptions.braille=new BrailleCaptions}PanelCaptions.init=init})(PanelCaptions||(PanelCaptions={}));const $=id=>document.getElementById(id);class Panel{menuManager_=new MenuManager;mode_=PanelMode.COLLAPSED;originalStickyState_=false;pendingCallback_=null;sessionState_="";tutorial_=null;brailleContainer_=$("braille-container");brailleTableElement_=$("braille-table");brailleTableElement2_=$("braille-table2");searchContainer_=$("search-container");searchInput_=$("search");speechContainer_=$("speech-container");speechElement_=$("speech");tutorialReadyForTesting_=false;getMenuManagerForTesting(){return this.menuManager_}constructor(){this.initListeners_()}initListeners_(){chrome.loginState.getSessionState((state=>this.updateSessionState_(state)));chrome.loginState.onSessionStateChanged.addListener((state=>this.updateSessionState_(state)));$("braille-pan-left").addEventListener("click",(()=>this.onPanLeft_()),false);$("braille-pan-right").addEventListener("click",(()=>this.onPanRight_()),false);$("menus_button").addEventListener("mousedown",(event=>this.menuManager_.onOpenMenus(event)),false);$("options").addEventListener("click",(()=>this.onOptions_()),false);$("close").addEventListener("click",(()=>this.onClose()),false);document.addEventListener("keydown",(event=>this.onKeyDown_(event)),false);document.addEventListener("mouseup",(event=>this.menuManager_.onMouseUp(event)),false);window.addEventListener("storage",(event=>this.onStorageChanged_(event)),false);window.addEventListener("message",(message=>this.onMessage_(message)),false);window.addEventListener("blur",(event=>this.onBlur_(event)),false);window.addEventListener("hashchange",(()=>this.onHashChange_()),false);BridgeHelper.registerHandler(BridgeConstants.Panel.TARGET,BridgeConstants.Panel.Action.ADD_MENU_ITEM,(itemData=>this.menuManager_.addNodeMenuItem(itemData)));BridgeHelper.registerHandler(BridgeConstants.Panel.TARGET,BridgeConstants.Panel.Action.ON_CURRENT_RANGE_CHANGED,(()=>this.onCurrentRangeChanged_()));this.updateFromPrefs_()}static async init(){if(Panel.instance){throw new Error("Cannot call Panel.init() more than once")}await LocalStorage.init();await SettingsManager.init();LocaleOutputHelper.init();PanelCaptions.init();Panel.instance=new Panel;PanelInterface.instance=Panel.instance;Msgs.addTranslatedMessagesToDom(document);if(location.search.slice(1)==="tutorial"){Panel.instance.onTutorial_()}}setPendingCallback(callback){this.pendingCallback_=callback}get mode(){return this.mode_}get sessionState(){return this.sessionState_}static exportBackgroundBridgeForTesting(){window["BackgroundBridge"]=BackgroundBridge}updateFromPrefs_(){if(this.mode_===PanelMode.SEARCH){this.speechContainer_.hidden=true;this.brailleContainer_.hidden=true;this.searchContainer_.hidden=false;return}this.speechContainer_.hidden=false;this.brailleContainer_.hidden=false;this.searchContainer_.hidden=true;if(LocalStorage.get("brailleCaptions")){this.speechContainer_.style.visibility="hidden";this.brailleContainer_.style.visibility="visible"}else{this.speechContainer_.style.visibility="visible";this.brailleContainer_.style.visibility="hidden"}}exec_(command){function escapeForHtml(str){return String(str).replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/\>/g,"&gt;").replace(/"/g,"&quot;").replace(/'/g,"&#039;").replace(/\//g,"&#x2F;")}switch(command.type){case PanelCommandType.CLEAR_SPEECH:this.speechElement_.innerHTML="";break;case PanelCommandType.ADD_NORMAL_SPEECH:if(this.speechElement_.innerHTML!==""){this.speechElement_.innerHTML+="&nbsp;&nbsp;"}this.speechElement_.innerHTML+='<span class="usertext">'+escapeForHtml(command.data)+"</span>";break;case PanelCommandType.ADD_ANNOTATION_SPEECH:if(this.speechElement_.innerHTML!==""){this.speechElement_.innerHTML+="&nbsp;&nbsp;"}this.speechElement_.innerHTML+=escapeForHtml(command.data);break;case PanelCommandType.UPDATE_BRAILLE:this.onUpdateBraille_(command.data);break;case PanelCommandType.OPEN_MENUS:this.menuManager_.onOpenMenus(undefined,String(command.data));break;case PanelCommandType.OPEN_MENUS_MOST_RECENT:this.menuManager_.onOpenMenus(undefined,this.menuManager_.lastMenu);break;case PanelCommandType.SEARCH:this.onSearch_();break;case PanelCommandType.TUTORIAL:this.onTutorial_();break;case PanelCommandType.CLOSE_CHROMEVOX:this.onClose();break;case PanelCommandType.ENABLE_TEST_HOOKS:window["MenuManager"]=MenuManager;window["Msgs"]=Msgs;window["Panel"]=Panel;break}}setMode(mode){if(this.mode_===mode){return}$("menus_title").setAttribute("msgid",mode===PanelMode.FULLSCREEN_MENUS?"menus_collapse_title":"menus_title");Msgs.addTranslatedMessagesToDom(document);this.mode_=mode;document.title=Msgs.getMsg(PanelModeInfo[this.mode_].title);window.location.assign(chrome.extension.getURL("chromevox/mv2/panel/panel.html")+PanelModeInfo[this.mode_].location);$("main").hidden=this.mode_===PanelMode.FULLSCREEN_TUTORIAL;$("menus_background").hidden=this.mode_!==PanelMode.FULLSCREEN_MENUS;const iTutorialContainer=$("chromevox-tutorial-container");if(iTutorialContainer){iTutorialContainer.hidden=this.mode_!==PanelMode.FULLSCREEN_TUTORIAL}this.updateFromPrefs_();if(mode===PanelMode.FULLSCREEN_MENUS){$("triangle").style.transform="rotate(180deg)"}else if(mode===PanelMode.COLLAPSED){$("triangle").style.transform=""}}async onSearch_(){this.setMode(PanelMode.SEARCH);this.menuManager_.clearMenus();this.pendingCallback_=null;this.updateFromPrefs_();await ISearchUI.init(this.searchInput_)}onUpdateBraille_(data){const{groups:groups,cols:cols,rows:rows}=data;const sideBySide=SettingsManager.get("brailleSideBySide");this.brailleContainer_.addEventListener("mouseover",(event=>PanelCaptions.braille.addBorders(event.target)));this.brailleContainer_.addEventListener("mouseout",(event=>PanelCaptions.braille.removeBorders(event.target)));this.brailleContainer_.addEventListener("click",(event=>PanelCaptions.braille.routeCursor(event.target)));PanelCaptions.braille.clearTables();let row1;let row2;let rowCount=0;let cellCount=cols;for(let i=0;i<groups.length;i++){if(cellCount===cols){cellCount=0;if(rowCount===rows){break}rowCount++;row1=this.brailleTableElement_.insertRow(-1);if(sideBySide){row2=this.brailleTableElement2_.insertRow(-1)}else{row2=this.brailleTableElement_.insertRow(-1)}}const topCell=row1.insertCell(-1);topCell.innerHTML=groups[i][0];topCell.id=i+"-textCell";topCell.setAttribute("data-companionIDs",i+"-brailleCell");topCell.className="unhighlighted-cell";let bottomCell=row2.insertCell(-1);bottomCell.id=i+"-brailleCell";bottomCell.setAttribute("data-companionIDs",i+"-textCell");bottomCell.className="unhighlighted-cell";if(cellCount+groups[i][1].length>cols){let brailleText=groups[i][1];while(cellCount+brailleText.length>cols){bottomCell.innerHTML=brailleText.substring(0,cols-cellCount);brailleText=brailleText.substring(cols-cellCount);if(rowCount===rows){break}rowCount++;row1=this.brailleTableElement_.insertRow(-1);if(sideBySide){row2=this.brailleTableElement2_.insertRow(-1)}else{row2=this.brailleTableElement_.insertRow(-1)}const bottomCell2=row2.insertCell(-1);bottomCell2.id=i+"-brailleCell2";bottomCell2.setAttribute("data-companionIDs",i+"-textCell "+i+"-brailleCell");bottomCell.setAttribute("data-companionIDs",bottomCell.getAttribute("data-companionIDs")+" "+i+"-brailleCell2");topCell.setAttribute("data-companionID2",bottomCell.getAttribute("data-companionIDs")+" "+i+"-brailleCell2");bottomCell2.className="unhighlighted-cell";bottomCell=bottomCell2;cellCount=0}bottomCell.innerHTML=brailleText;cellCount=brailleText.length}else{bottomCell.innerHTML=groups[i][1];cellCount+=groups[i][1].length}}}onKeyDown_(event){if(event.key==="Escape"&&this.mode_===PanelMode.FULLSCREEN_TUTORIAL){this.setMode(PanelMode.COLLAPSED);return}if(!this.menuManager_.onKeyDown(event)){return}event.preventDefault();event.stopPropagation()}onOptions_(){chrome.accessibilityPrivate.openSettingsSubpage("textToSpeech/chromeVox");this.setMode(PanelMode.COLLAPSED)}onClose(){window.location.assign(chrome.extension.getURL("chromevox/mv2/panel/panel.html")+"#close")}async closeMenusAndRestoreFocus(){const pendingCallback=this.pendingCallback_;this.pendingCallback_=null;await BackgroundBridge.PanelBackground.setPanelCollapseWatcher();this.menuManager_.clearMenus();this.setMode(PanelMode.COLLAPSED);await BackgroundBridge.PanelBackground.waitForPanelCollapse();if(pendingCallback){await pendingCallback()}BackgroundBridge.PanelBackground.clearSavedNode()}onTutorial_(){chrome.chromeosInfoPrivate.isTabletModeEnabled((enabled=>{const medium=enabled?constants.InteractionMedium.TOUCH:constants.InteractionMedium.KEYBOARD;if(!$("chromevox-tutorial")){let curriculum=null;if(this.sessionState_===chrome.loginState.SessionState.IN_OOBE_SCREEN){curriculum=medium===constants.InteractionMedium.KEYBOARD?"quick_orientation":"touch_orientation"}this.createITutorial_(curriculum,medium)}this.setMode(PanelMode.FULLSCREEN_TUTORIAL);const tutorial=this.tutorial_;if(tutorial&&tutorial.show){tutorial.medium=medium;tutorial.show()}}))}createITutorial_(curriculum,medium){const tutorialScript=document.createElement("script");tutorialScript.src="../../../common/tutorial/components/chromevox_tutorial.js";tutorialScript.setAttribute("type","module");document.body.appendChild(tutorialScript);const tutorialContainer=document.createElement("div");tutorialContainer.setAttribute("id","chromevox-tutorial-container");tutorialContainer.hidden=true;const element=document.createElement("chromevox-tutorial");element.setAttribute("id","chromevox-tutorial");const tutorialElement=element;if(curriculum){tutorialElement.curriculum=curriculum}tutorialElement.medium=medium;tutorialContainer.appendChild(element);document.body.appendChild(tutorialContainer);this.tutorial_=tutorialElement;const elementInPage=$("chromevox-tutorial");if(!elementInPage){throw new Error("Tutorial element was not added to the DOM")}elementInPage.addEventListener("closetutorial",(async _evt=>{await BackgroundBridge.ForcedActionPath.stopListening();this.onCloseTutorial_()}));elementInPage.addEventListener("startinteractivemode",(async evt=>{const actions=evt.detail.actions;await BackgroundBridge.ForcedActionPath.listenFor(actions);await BackgroundBridge.ForcedActionPath.stopListening();const tutorial=this.tutorial_;if(this.tutorial_&&tutorial.showNextLesson){tutorial.showNextLesson()}}));elementInPage.addEventListener("stopinteractivemode",(async _evt=>{await BackgroundBridge.ForcedActionPath.stopListening()}));elementInPage.addEventListener("requestfullydescribe",(_evt=>{BackgroundBridge.CommandHandler.onCommand(Command.FULLY_DESCRIBE)}));elementInPage.addEventListener("requestearcon",(evt=>{const earconId=evt.detail.earconId;BackgroundBridge.Earcons.playEarcon(earconId)}));elementInPage.addEventListener("cancelearcon",(evt=>{const earconId=evt.detail.earconId;BackgroundBridge.Earcons.cancelEarcon(earconId)}));elementInPage.addEventListener("readyfortesting",(()=>{this.tutorialReadyForTesting_||=true}));elementInPage.addEventListener("openUrl",(async evt=>{const url=evt.detail.url;await BackgroundBridge.ForcedActionPath.stopListening();this.onCloseTutorial_();BrowserUtil.openBrowserUrl(url)}))}onCloseTutorial_(){this.setMode(PanelMode.COLLAPSED)}onCurrentRangeChanged_(){if(this.mode_===PanelMode.FULLSCREEN_TUTORIAL){const tutorial=this.tutorial_;if(this.tutorial_&&tutorial.restartNudges){tutorial.restartNudges()}}}onBlur_(event){const target=event.target;if(target!==window||document.activeElement===document.body){return}this.closeMenusAndRestoreFocus()}async onHashChange_(){if(location.hash==="#fullscreen"||location.hash==="#focus"){this.originalStickyState_=await BackgroundBridge.ChromeVoxPrefs.getStickyPref()}if(this.originalStickyState_){BackgroundBridge.CommandHandler.onCommand(Command.TOGGLE_STICKY_MODE)}}onMessage_(message){const command=JSON.parse(message.data);this.exec_(command)}async onPanLeft_(){await BackgroundBridge.Braille.panLeft()}async onPanRight_(){await BackgroundBridge.Braille.panRight()}onStorageChanged_(event){if(event.key==="brailleCaptions"){this.updateFromPrefs_()}}updateSessionState_(sessionState){this.sessionState_=sessionState;const options=$("options");options.disabled=sessionState!=="IN_SESSION"}}(function(Panel){})(Panel||(Panel={}));window.addEventListener("load",(async()=>await Panel.init()),false);export{Panel};