// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * List of commands. A new command needs to be added to the end of this list.
 * These values and indices are persisted to logs. Entries should not be
 * reordered and their indices should never be reused.
 */
export var Command;
(function (Command) {
    // LINT.IfChange
    Command["ANNOUNCE_BATTERY_DESCRIPTION"] = "announceBatteryDescription";
    Command["ANNOUNCE_HEADERS"] = "announceHeaders";
    Command["ANNOUNCE_RICH_TEXT_DESCRIPTION"] = "announceRichTextDescription";
    Command["AUTORUNNER"] = "autorunner";
    Command["BACKWARD"] = "backward";
    Command["BOTTOM"] = "bottom";
    Command["CONTEXT_MENU"] = "contextMenu";
    Command["COPY"] = "copy";
    Command["CYCLE_PUNCTUATION_ECHO"] = "cyclePunctuationEcho";
    Command["CYCLE_TYPING_ECHO"] = "cycleTypingEcho";
    Command["DEBUG"] = "debug";
    Command["DECREASE_TTS_PITCH"] = "decreaseTtsPitch";
    Command["DECREASE_TTS_RATE"] = "decreaseTtsRate";
    Command["DECREASE_TTS_VOLUME"] = "decreaseTtsVolume";
    Command["DISABLE_CHROMEVOX_ARC_SUPPORT_FOR_CURRENT_APP"] = "disableChromeVoxArcSupportForCurrentApp";
    Command["DISABLE_LOGGING"] = "disableLogging";
    Command["DUMP_TREE"] = "dumpTree";
    Command["ENABLE_CHROMEVOX_ARC_SUPPORT_FOR_CURRENT_APP"] = "enableChromeVoxArcSupportForCurrentApp";
    Command["ENABLE_CONSOLE_TTS"] = "enableConsoleTts";
    Command["ENABLE_LOGGING"] = "enableLogging";
    Command["ENTER_SHIFTER"] = "enterShifter";
    Command["EXIT_SHIFTER"] = "exitShifter";
    Command["EXIT_SHIFTER_CONTENT"] = "exitShifterContent";
    Command["FORCE_CLICK_ON_CURRENT_ITEM"] = "forceClickOnCurrentItem";
    Command["FORCE_DOUBLE_CLICK_ON_CURRENT_ITEM"] = "forceDoubleClickOnCurrentItem";
    Command["FORCE_LONG_CLICK_ON_CURRENT_ITEM"] = "forceLongClickOnCurrentItem";
    Command["FORWARD"] = "forward";
    Command["FULLY_DESCRIBE"] = "fullyDescribe";
    Command["GO_TO_COL_FIRST_CELL"] = "goToColFirstCell";
    Command["GO_TO_COL_LAST_CELL"] = "goToColLastCell";
    Command["GO_TO_FIRST_CELL"] = "goToFirstCell";
    Command["GO_TO_LAST_CELL"] = "goToLastCell";
    Command["GO_TO_ROW_FIRST_CELL"] = "goToRowFirstCell";
    Command["GO_TO_ROW_LAST_CELL"] = "goToRowLastCell";
    Command["HANDLE_TAB"] = "handleTab";
    Command["HANDLE_TAB_PREV"] = "handleTabPrev";
    Command["HELP"] = "help";
    Command["INCREASE_TTS_PITCH"] = "increaseTtsPitch";
    Command["INCREASE_TTS_RATE"] = "increaseTtsRate";
    Command["INCREASE_TTS_VOLUME"] = "increaseTtsVolume";
    Command["JUMP_TO_BOTTOM"] = "jumpToBottom";
    Command["JUMP_TO_DETAILS"] = "jumpToDetails";
    Command["JUMP_TO_TOP"] = "jumpToTop";
    Command["LEFT"] = "left";
    Command["LINE_DOWN"] = "lineDown";
    Command["LINE_UP"] = "lineUp";
    Command["MOVE_TO_END_OF_LINE"] = "moveToEndOfLine";
    Command["MOVE_TO_START_OF_LINE"] = "moveToStartOfLine";
    Command["NOP"] = "nop";
    Command["NATIVE_NEXT_CHARACTER"] = "nativeNextCharacter";
    Command["NATIVE_NEXT_WORD"] = "nativeNextWord";
    Command["NATIVE_PREVIOUS_CHARACTER"] = "nativePreviousCharacter";
    Command["NATIVE_PREVIOUS_WORD"] = "nativePreviousWord";
    Command["NEXT_ARTICLE"] = "nextArticle";
    Command["NEXT_AT_GRANULARITY"] = "nextAtGranularity";
    Command["NEXT_BUTTON"] = "nextButton";
    Command["NEXT_CHARACTER"] = "nextCharacter";
    Command["NEXT_CHECKBOX"] = "nextCheckbox";
    Command["NEXT_COL"] = "nextCol";
    Command["NEXT_COMBO_BOX"] = "nextComboBox";
    Command["NEXT_CONTROL"] = "nextControl";
    Command["NEXT_EDIT_TEXT"] = "nextEditText";
    Command["NEXT_FORM_FIELD"] = "nextFormField";
    Command["NEXT_GRANULARITY"] = "nextGranularity";
    Command["NEXT_GRAPHIC"] = "nextGraphic";
    Command["NEXT_GROUP"] = "nextGroup";
    Command["NEXT_HEADING"] = "nextHeading";
    Command["NEXT_HEADING_1"] = "nextHeading1";
    Command["NEXT_HEADING_2"] = "nextHeading2";
    Command["NEXT_HEADING_3"] = "nextHeading3";
    Command["NEXT_HEADING_4"] = "nextHeading4";
    Command["NEXT_HEADING_5"] = "nextHeading5";
    Command["NEXT_HEADING_6"] = "nextHeading6";
    Command["NEXT_INVALID_ITEM"] = "nextInvalidItem";
    Command["NEXT_LANDMARK"] = "nextLandmark";
    Command["NEXT_LINE"] = "nextLine";
    Command["NEXT_LINK"] = "nextLink";
    Command["NEXT_LIST"] = "nextList";
    Command["NEXT_LIST_ITEM"] = "nextListItem";
    Command["NEXT_MATH"] = "nextMath";
    Command["NEXT_MEDIA"] = "nextMedia";
    Command["NEXT_OBJECT"] = "nextObject";
    Command["NEXT_PAGE"] = "nextPage";
    Command["NEXT_RADIO"] = "nextRadio";
    Command["NEXT_ROW"] = "nextRow";
    Command["NEXT_SECTION"] = "nextSection";
    Command["NEXT_SENTENCE"] = "nextSentence";
    Command["NEXT_SIMILAR_ITEM"] = "nextSimilarItem";
    Command["NEXT_SLIDER"] = "nextSlider";
    Command["NEXT_TABLE"] = "nextTable";
    Command["NEXT_VISITED_LINK"] = "nextVisitedLink";
    Command["NEXT_WORD"] = "nextWord";
    Command["OPEN_CHROMEVOX_MENUS"] = "openChromeVoxMenus";
    Command["OPEN_KEYBOARD_SHORTCUTS"] = "openKeyboardShortcuts";
    Command["OPEN_LONG_DESC"] = "openLongDesc";
    Command["PAN_LEFT"] = "panLeft";
    Command["PAN_RIGHT"] = "panRight";
    Command["PASS_THROUGH_MODE"] = "passThroughMode";
    Command["PAUSE_ALL_MEDIA"] = "pauseAllMedia";
    Command["PREVIOUS_ARTICLE"] = "previousArticle";
    Command["PREVIOUS_AT_GRANULARITY"] = "previousAtGranularity";
    Command["PREVIOUS_BUTTON"] = "previousButton";
    Command["PREVIOUS_CHARACTER"] = "previousCharacter";
    Command["PREVIOUS_CHECKBOX"] = "previousCheckbox";
    Command["PREVIOUS_COMBO_BOX"] = "previousComboBox";
    Command["PREVIOUS_COL"] = "previousCol";
    Command["PREVIOUS_CONTROL"] = "previousControl";
    Command["PREVIOUS_EDIT_TEXT"] = "previousEditText";
    Command["PREVIOUS_FORM_FIELD"] = "previousFormField";
    Command["PREVIOUS_GRANULARITY"] = "previousGranularity";
    Command["PREVIOUS_GRAPHIC"] = "previousGraphic";
    Command["PREVIOUS_GROUP"] = "previousGroup";
    Command["PREVIOUS_HEADING"] = "previousHeading";
    Command["PREVIOUS_HEADING_1"] = "previousHeading1";
    Command["PREVIOUS_HEADING_2"] = "previousHeading2";
    Command["PREVIOUS_HEADING_3"] = "previousHeading3";
    Command["PREVIOUS_HEADING_4"] = "previousHeading4";
    Command["PREVIOUS_HEADING_5"] = "previousHeading5";
    Command["PREVIOUS_HEADING_6"] = "previousHeading6";
    Command["PREVIOUS_INVALID_ITEM"] = "previousInvalidItem";
    Command["PREVIOUS_LANDMARK"] = "previousLandmark";
    Command["PREVIOUS_LINE"] = "previousLine";
    Command["PREVIOUS_LINK"] = "previousLink";
    Command["PREVIOUS_LIST"] = "previousList";
    Command["PREVIOUS_LIST_ITEM"] = "previousListItem";
    Command["PREVIOUS_MATH"] = "previousMath";
    Command["PREVIOUS_MEDIA"] = "previousMedia";
    Command["PREVIOUS_OBJECT"] = "previousObject";
    Command["PREVIOUS_PAGE"] = "previousPage";
    Command["PREVIOUS_RADIO"] = "previousRadio";
    Command["PREVIOUS_ROW"] = "previousRow";
    Command["PREVIOUS_SECTION"] = "previousSection";
    Command["PREVIOUS_SENTENCE"] = "previousSentence";
    Command["PREVIOUS_SIMILAR_ITEM"] = "previousSimilarItem";
    Command["PREVIOUS_SLIDER"] = "previousSlider";
    Command["PREVIOUS_TABLE"] = "previousTable";
    Command["PREVIOUS_VISITED_LINK"] = "previousVisitedLink";
    Command["PREVIOUS_WORD"] = "previousWord";
    Command["READ_CURRENT_TITLE"] = "readCurrentTitle";
    Command["READ_CURRENT_URL"] = "readCurrentURL";
    Command["READ_FROM_HERE"] = "readFromHere";
    Command["READ_LINK_URL"] = "readLinkURL";
    Command["READ_PHONETIC_PRONUNCIATION"] = "readPhoneticPronunciation";
    Command["REPORT_ISSUE"] = "reportIssue";
    Command["RESET_TEXT_TO_SPEECH_SETTINGS"] = "resetTextToSpeechSettings";
    Command["RIGHT"] = "right";
    Command["ROUTING"] = "routing";
    Command["SCROLL_BACKWARD"] = "scrollBackward";
    Command["SCROLL_FORWARD"] = "scrollForward";
    Command["SHOW_ACTIONS_MENU"] = "showActionsMenu";
    Command["SHOW_FORMS_LIST"] = "showFormsList";
    Command["SHOW_HEADINGS_LIST"] = "showHeadingsList";
    Command["SHOW_LANDMARKS_LIST"] = "showLandmarksList";
    Command["SHOW_LEARN_MODE_PAGE"] = "showLearnModePage";
    Command["SHOW_LINKS_LIST"] = "showLinksList";
    Command["SHOW_LOG_PAGE"] = "showLogPage";
    Command["SHOW_OPTIONS_PAGE"] = "showOptionsPage";
    Command["SHOW_PANEL_MENU_MOST_RECENT"] = "showPanelMenuMostRecent";
    Command["SHOW_TABLES_LIST"] = "showTablesList";
    Command["SHOW_TALKBACK_KEYBOARD_SHORTCUTS"] = "showTalkBackKeyboardShortcuts";
    Command["SHOW_TTS_SETTINGS"] = "showTtsSettings";
    Command["SPEAK_TABLE_LOCATION"] = "speakTableLocation";
    Command["SPEAK_TIME_AND_DATE"] = "speakTimeAndDate";
    Command["START_HISTORY_RECORDING"] = "startHistoryRecording";
    Command["STOP_HISTORY_RECORDING"] = "stopHistoryRecording";
    Command["STOP_SPEECH"] = "stopSpeech";
    Command["TOGGLE_BRAILLE_CAPTIONS"] = "toggleBrailleCaptions";
    Command["TOGGLE_BRAILLE_TABLE"] = "toggleBrailleTable";
    Command["TOGGLE_DICTATION"] = "toggleDictation";
    Command["TOGGLE_EARCONS"] = "toggleEarcons";
    Command["TOGGLE_KEYBOARD_HELP"] = "toggleKeyboardHelp";
    Command["TOGGLE_SCREEN"] = "toggleScreen";
    Command["TOGGLE_SEARCH_WIDGET"] = "toggleSearchWidget";
    Command["TOGGLE_SELECTION"] = "toggleSelection";
    Command["TOGGLE_SEMANTICS"] = "toggleSemantics";
    Command["TOGGLE_SPEECH_ON_OR_OFF"] = "toggleSpeechOnOrOff";
    Command["TOGGLE_STICKY_MODE"] = "toggleStickyMode";
    Command["TOP"] = "top";
    Command["VIEW_GRAPHIC_AS_BRAILLE"] = "viewGraphicAsBraille";
    Command["TOGGLE_CAPTIONS"] = "toggleCaptions";
    // Add a new command to the end of this list.
    // LINT.ThenChange(//tools/metrics/histograms/metadata/accessibility/enums.xml)
})(Command || (Command = {}));
/**
 * List of categories for the commands.
 * Note that the values here must correspond to the message resource tag for the
 * category.
 */
export var CommandCategory;
(function (CommandCategory) {
    CommandCategory["ACTIONS"] = "actions";
    CommandCategory["CONTROLLING_SPEECH"] = "controlling_speech";
    CommandCategory["HELP_COMMANDS"] = "help_commands";
    CommandCategory["INFORMATION"] = "information";
    CommandCategory["JUMP_COMMANDS"] = "jump_commands";
    CommandCategory["MODIFIER_KEYS"] = "modifier_keys";
    CommandCategory["NAVIGATION"] = "navigation";
    CommandCategory["OVERVIEW"] = "overview";
    CommandCategory["TABLES"] = "tables";
    // The following categories are not displayed in the ChromeVox menus:
    CommandCategory["BRAILLE"] = "braille";
    CommandCategory["DEVELOPER"] = "developer";
    CommandCategory["NO_CATEGORY"] = "no_category";
})(CommandCategory || (CommandCategory = {}));
