// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{TestImportManager}from"../../../../../../../../../../../../../../../../../../common/testing/test_import_manager.js";import{InstanceChecker}from"../../../../../../../../../../../../../../../../../../common/mv2/instance_checker.js";class EnhancedNetworkTts{processingQueue_;api_;constructor(){this.processingQueue_=[];this.api_=null;chrome.ttsEngine.onSpeakWithAudioStream.addListener(((utterance,options,audioStreamOptions,sendTtsAudio,sendError)=>this.onSpeakWithAudioStreamEvent(utterance,options,audioStreamOptions,sendTtsAudio,sendError)));chrome.ttsEngine.onStop.addListener((()=>this.onStopEvent()))}async onSpeakWithAudioStreamEvent(utterance,options,audioStreamOptions,sendTtsAudio,sendError){this.processingQueue_=[];if(!this.api_){try{this.api_=await chrome.mojoPrivate.requireAsync("ash.enhanced_network_tts")}catch(e){console.warn("Could not get mojoPrivate bindings: "+e.message);sendError("Error: unable to get mojoPrivate bindings");return}}const request=EnhancedNetworkTts.generateRequest(utterance,options);await this.api_.getAudioDataWithCallback(request,(response=>this.queueResponse_(response,audioStreamOptions,sendTtsAudio,sendError)))}queueResponse_(response,audioStreamOptions,sendTtsAudio,sendError){const sampleRate=audioStreamOptions.sampleRate;const bufferSize=audioStreamOptions.bufferSize;this.processingQueue_.push({response:response,sampleRate:sampleRate,bufferSize:bufferSize,sendTtsAudio:sendTtsAudio,sendError:sendError});if(this.processingQueue_.length===1){this.processResponse_()}}async processResponse_(){if(this.processingQueue_.length===0){return}const{response:response,sampleRate:sampleRate,bufferSize:bufferSize,sendTtsAudio:sendTtsAudio,sendError:sendError}=this.processingQueue_[0];if(!response.data){console.warn("Could not get the data from Enhanced Network mojo API.");if(response.errorCode===undefined){return}switch(response.errorCode){case ash.enhancedNetworkTts.mojom.TtsRequestError.kEmptyUtterance:sendError("Error: empty utterance");break;case ash.enhancedNetworkTts.mojom.TtsRequestError.kOverLength:sendError("Error: utterance too long");break;case ash.enhancedNetworkTts.mojom.TtsRequestError.kServerError:sendError("Error: unable to reach server");break;case ash.enhancedNetworkTts.mojom.TtsRequestError.kReceivedUnexpectedData:sendError("Error: unexpected data");break;case ash.enhancedNetworkTts.mojom.TtsRequestError.kRequestOverride:break}return}const lastData=response.data.lastData;const audioData=new Uint8Array(response.data.audio).buffer;const timeInfo=response.data.timeInfo;const decodedAudioData=await EnhancedNetworkTts.decodeAudioDataAtSampleRate(audioData,sampleRate);EnhancedNetworkTts.sendAudioDataInBuffers(decodedAudioData,sampleRate,bufferSize,timeInfo,sendTtsAudio,lastData);this.processingQueue_.shift();if(this.processingQueue_.length>0){await this.processResponse_()}}async onStopEvent(){this.processingQueue_=[];if(this.api_){this.api_.resetApi()}}static generateRequest(utterance,options){const rate=options.rate||1;let voice;let lang;const voiceStr=options.voiceName||"";let langStr=options.lang||"";langStr=langStr.trim().split(/_/)[0];if(voiceStr.trim().length===0||langStr.trim().length===0){voice=undefined;lang=undefined}else if(voice==="default-wavenet"){voice=undefined;lang=undefined}else{voice=voiceStr;lang=langStr}return{utterance:utterance,rate:rate,voice:voice,lang:lang}}static async decodeAudioDataAtSampleRate(inputAudioData,targetSampleRate){const context=new AudioContext({sampleRate:targetSampleRate});let audioBuffer;try{audioBuffer=await context.decodeAudioData(inputAudioData)}catch(e){console.warn("Could not decode audio data");return new Promise((resolve=>resolve(null)))}finally{context.close()}if(!audioBuffer){return new Promise((resolve=>resolve(null)))}return audioBuffer.getChannelData(0)}static subarrayFrom(array,startIdx,subarraySize){const subarray=new Float32Array(subarraySize);subarray.set(array.subarray(startIdx,Math.min(startIdx+subarraySize,array.length)),0);return subarray}static sendAudioDataInBuffers(audioData,sampleRate,bufferSize,timeInfo,sendTtsAudio,lastData){if(!audioData){return}let timeInfoIdx=0;let wordStartAtAudioData=Math.floor(parseFloat(timeInfo[0].timeOffset)*sampleRate);for(let i=0;i<audioData.length;i+=bufferSize){const audioBuffer=EnhancedNetworkTts.subarrayFrom(audioData,i,bufferSize);let charIndex;if(i<=wordStartAtAudioData&&i+bufferSize>wordStartAtAudioData){charIndex=timeInfo[timeInfoIdx].textOffset;if(timeInfoIdx<timeInfo.length-1){timeInfoIdx++;wordStartAtAudioData=Math.floor(parseFloat(timeInfo[timeInfoIdx].timeOffset)*sampleRate)}}const isLastBuffer=lastData&&i+bufferSize>=audioData.length;sendTtsAudio({audioBuffer:audioBuffer,charIndex:charIndex,isLastBuffer:isLastBuffer})}}}TestImportManager.exportForTesting(EnhancedNetworkTts);InstanceChecker.closeExtraInstances();const enhancedNetworkTts=new EnhancedNetworkTts;TestImportManager.exportForTesting(["enhancedNetworkTts",enhancedNetworkTts]);export{enhancedNetworkTts};