// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{TestImportManager}from"../../../../../../../../../../../../../../../../../../common/testing/test_import_manager.js";import{InstanceChecker}from"../../../../../../../../../../../../../../../../../../common/mv3/instance_checker.js";import{S as ServiceWorkerCommand,O as OffscreenCommand}from"./shared.rollup.js";class EnhancedNetworkTts{processingQueue_;api_;offscreenReadyPromise_=null;constructor(){this.processingQueue_=[];this.api_=null;chrome.ttsEngine.onSpeakWithAudioStream.addListener(((utterance,options,audioStreamOptions,sendTtsAudio,sendError)=>this.onSpeakWithAudioStreamEvent(utterance,options,audioStreamOptions,sendTtsAudio,sendError)));chrome.ttsEngine.onStop.addListener((()=>this.onStopEvent()))}async ensureOffscreenReady_(){const offscreenUrl=chrome.runtime.getURL("enhanced_network_tts/mv3/offscreen.html");const existingContexts=await chrome.runtime.getContexts({contextTypes:[chrome.runtime.ContextType.OFFSCREEN_DOCUMENT],documentUrls:[offscreenUrl]});if(existingContexts.length>0){return}if(this.offscreenReadyPromise_){await this.offscreenReadyPromise_;return}try{let readyResolver;this.offscreenReadyPromise_=new Promise((resolve=>{readyResolver=resolve}));chrome.runtime.onMessage.addListener((message=>{if(message.command===ServiceWorkerCommand.READY){readyResolver()}return false}));await chrome.offscreen.createDocument({url:offscreenUrl,reasons:[chrome.offscreen.Reason.AUDIO_PLAYBACK],justification:"Audio decoding for Enhanced Network TTS"});await this.offscreenReadyPromise_}catch(error){console.error("Failed to create offscreen document: ",error)}finally{this.offscreenReadyPromise_=null}}async onSpeakWithAudioStreamEvent(utterance,options,audioStreamOptions,sendTtsAudio,sendError){this.processingQueue_=[];if(!this.api_){try{this.api_=await chrome.mojoPrivate.requireAsync("ash.enhanced_network_tts")}catch(e){console.warn("Could not get mojoPrivate bindings: "+e.message);sendError("Error: unable to get mojoPrivate bindings");return}}const request=EnhancedNetworkTts.generateRequest(utterance,options);await this.api_.getAudioDataWithCallback(request,(response=>this.queueResponse_(response,audioStreamOptions,sendTtsAudio,sendError)))}queueResponse_(response,audioStreamOptions,sendTtsAudio,sendError){const sampleRate=audioStreamOptions.sampleRate;const bufferSize=audioStreamOptions.bufferSize;this.processingQueue_.push({response:response,sampleRate:sampleRate,bufferSize:bufferSize,sendTtsAudio:sendTtsAudio,sendError:sendError});if(this.processingQueue_.length===1){this.processResponse_()}}async processResponse_(){if(this.processingQueue_.length===0){return}const{response:response,sampleRate:sampleRate,bufferSize:bufferSize,sendTtsAudio:sendTtsAudio,sendError:sendError}=this.processingQueue_[0];if(!response.data){console.warn("Could not get the data from Enhanced Network mojo API.");if(response.errorCode===undefined){return}switch(response.errorCode){case ash.enhancedNetworkTts.mojom.TtsRequestError.kEmptyUtterance:sendError("Error: empty utterance");break;case ash.enhancedNetworkTts.mojom.TtsRequestError.kOverLength:sendError("Error: utterance too long");break;case ash.enhancedNetworkTts.mojom.TtsRequestError.kServerError:sendError("Error: unable to reach server");break;case ash.enhancedNetworkTts.mojom.TtsRequestError.kReceivedUnexpectedData:sendError("Error: unexpected data");break;case ash.enhancedNetworkTts.mojom.TtsRequestError.kRequestOverride:break}return}const lastData=response.data.lastData;const timeInfo=response.data.timeInfo;const audioData=response.data.audio;const decodedAudioData=await this.decodeAudioData_(audioData,sampleRate);EnhancedNetworkTts.sendAudioDataInBuffers(decodedAudioData,sampleRate,bufferSize,timeInfo,sendTtsAudio,lastData);this.processingQueue_.shift();if(this.processingQueue_.length>0){await this.processResponse_()}}async decodeAudioData_(audioData,sampleRate){await this.ensureOffscreenReady_();const decodedAudioData=await chrome.runtime.sendMessage(undefined,{command:OffscreenCommand.DECODE_AUDIO,request:{audioData:audioData,sampleRate:sampleRate}});if(chrome.runtime.lastError){console.error("Error decoding audio: ",chrome.runtime.lastError.message);return null}return decodedAudioData?new Float32Array(Object.values(decodedAudioData)):null}async onStopEvent(){this.processingQueue_=[];if(this.api_){this.api_.resetApi()}}static generateRequest(utterance,options){const rate=options.rate||1;let voice;let lang;const voiceStr=options.voiceName||"";let langStr=options.lang||"";langStr=langStr.trim().split(/_/)[0];if(voiceStr.trim().length===0||langStr.trim().length===0){voice=undefined;lang=undefined}else if(voice==="default-wavenet"){voice=undefined;lang=undefined}else{voice=voiceStr;lang=langStr}return{utterance:utterance,rate:rate,voice:voice,lang:lang}}static subarrayFrom(array,startIdx,subarraySize){const subarray=new Float32Array(subarraySize);subarray.set(array.subarray(startIdx,Math.min(startIdx+subarraySize,array.length)),0);return subarray}static sendAudioDataInBuffers(audioData,sampleRate,bufferSize,timeInfo,sendTtsAudio,lastData){if(!audioData){return}let timeInfoIdx=0;let wordStartAtAudioData=Math.floor(parseFloat(timeInfo[0].timeOffset)*sampleRate);for(let i=0;i<audioData.length;i+=bufferSize){const audioBuffer=EnhancedNetworkTts.subarrayFrom(audioData,i,bufferSize);let charIndex;if(i<=wordStartAtAudioData&&i+bufferSize>wordStartAtAudioData){charIndex=timeInfo[timeInfoIdx].textOffset;if(timeInfoIdx<timeInfo.length-1){timeInfoIdx++;wordStartAtAudioData=Math.floor(parseFloat(timeInfo[timeInfoIdx].timeOffset)*sampleRate)}}const isLastBuffer=lastData&&i+bufferSize>=audioData.length;sendTtsAudio({audioBuffer:audioBuffer,charIndex:charIndex,isLastBuffer:isLastBuffer})}}async decodeAudioDataAtSampleRateForTesting(sampleAudioData,sampleRate){return this.decodeAudioData_(sampleAudioData,sampleRate)}}TestImportManager.exportForTesting(EnhancedNetworkTts);InstanceChecker.closeExtraInstances();const enhancedNetworkTts=new EnhancedNetworkTts;TestImportManager.exportForTesting(["enhancedNetworkTts",enhancedNetworkTts]);export{enhancedNetworkTts};