// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{S as ServiceWorkerCommand,O as OffscreenCommand}from"./shared.rollup.js";class DecodeAudioHandler{constructor(){chrome.runtime.onMessage.addListener(((message,_sender,sendResponse)=>this.onMessage_(message,sendResponse)));this.notifyServiceWorker_()}async notifyServiceWorker_(){await chrome.runtime.sendMessage(undefined,{command:ServiceWorkerCommand.READY});if(chrome.runtime.lastError){console.error("Could not send ready message to service worker: ",chrome.runtime.lastError.message)}}onMessage_(message,sendResponse){switch(message.command){case OffscreenCommand.DECODE_AUDIO:(async()=>{const decodedData=await this.decodeAudioData_(message.request);sendResponse(decodedData)})();return true}return false}async decodeAudioData_(request){const audioData=new Uint8Array(request.audioData).buffer;const context=new AudioContext({sampleRate:request.sampleRate});let audioBuffer;try{audioBuffer=await context.decodeAudioData(audioData)}catch(e){console.warn("Could not decode audio data",e);return null}finally{context.close()}if(!audioBuffer){return null}return audioBuffer.getChannelData(0)}}document.addEventListener("DOMContentLoaded",(()=>new DecodeAudioHandler));