// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"../../../../../../../../../../../../../../../../../../common/async_util.js";import"../../../../../../../../../../../../../../../../../../common/event_generator.js";import{InstanceChecker}from"../../../../../../../../../../../../../../../../../../common/mv2/instance_checker.js";import{TestImportManager}from"../../../../../../../../../../../../../../../../../../common/testing/test_import_manager.js";import{AutomationPredicate}from"../../../../../../../../../../../../../../../../../../common/automation_predicate.js";import{AutomationUtil}from"../../../../../../../../../../../../../../../../../../common/automation_util.js";import{constants}from"../../../../../../../../../../../../../../../../../../common/constants.js";import{Flags,FlagName}from"../../../../../../../../../../../../../../../../../../common/flags.js";import{NodeNavigationUtils}from"../../../../../../../../../../../../../../../../../../common/node_navigation_utils.js";import{NodeUtils}from"../../../../../../../../../../../../../../../../../../common/node_utils.js";import{ParagraphUtils}from"../../../../../../../../../../../../../../../../../../common/paragraph_utils.js";import{WordUtils}from"../../../../../../../../../../../../../../../../../../common/word_utils.js";import{RectUtil}from"../../../../../../../../../../../../../../../../../../common/rect_util.js";import{KeyCode}from"../../../../../../../../../../../../../../../../../../common/key_code.js";var SelectToSpeakConstants;(function(SelectToSpeakConstants){SelectToSpeakConstants.SEARCH_KEY_CODE=KeyCode.SEARCH;SelectToSpeakConstants.CONTROL_KEY_CODE=KeyCode.CONTROL;SelectToSpeakConstants.READ_SELECTION_KEY_CODE=KeyCode.S;SelectToSpeakConstants.NODE_STATE_TEST_INTERVAL_MS=500;SelectToSpeakConstants.PARAGRAPH_SELECTION_MAX_SIZE=5})(SelectToSpeakConstants||(SelectToSpeakConstants={}));TestImportManager.exportForTesting(["SelectToSpeakConstants",SelectToSpeakConstants]);class InputHandler{callbacks_;didTrackMouse_;isSearchKeyDown_;isSelectionKeyDown_;keysCurrentlyDown_;keysPressedTogether_;lastClearClipboardDataTime_;lastReadClipboardDataTime_;mouseStart_;mouseEnd_;trackingMouse_;static kClipboardClearMaxDelayMs;static kClipboardReadMaxDelayMs;constructor(callbacks){this.callbacks_=callbacks;this.didTrackMouse_=false;this.isSearchKeyDown_=false;this.isSelectionKeyDown_=false;this.keysCurrentlyDown_=new Set;this.keysPressedTogether_=new Set;this.lastClearClipboardDataTime_=new Date(0);this.lastReadClipboardDataTime_=new Date(0);this.mouseStart_={x:0,y:0};this.mouseEnd_={x:0,y:0};this.trackingMouse_=false}clearClipboard_(){this.lastClearClipboardDataTime_=new Date;document.execCommand("copy")}onClipboardCopy_(evt){if((new Date).getTime()-this.lastClearClipboardDataTime_.getTime()<InputHandler.kClipboardClearMaxDelayMs){evt.clipboardData.setData("text/plain","");evt.preventDefault();this.lastClearClipboardDataTime_=new Date(0)}}onClipboardDataChanged_(){if((new Date).getTime()-this.lastReadClipboardDataTime_.getTime()<InputHandler.kClipboardReadMaxDelayMs){document.execCommand("paste")}}onClipboardPaste_(evt){if((new Date).getTime()-this.lastReadClipboardDataTime_.getTime()<InputHandler.kClipboardReadMaxDelayMs){evt.preventDefault();this.callbacks_.onTextReceived(evt.clipboardData.getData("text/plain"));this.lastReadClipboardDataTime_=new Date(0);setTimeout((()=>this.clearClipboard_()),0)}}setUpEventListeners(){chrome.clipboard.onClipboardDataChanged.addListener((()=>this.onClipboardDataChanged_()));document.addEventListener("paste",(evt=>this.onClipboardPaste_(evt)));document.addEventListener("copy",(evt=>this.onClipboardCopy_(evt)));chrome.accessibilityPrivate.onSelectToSpeakKeysPressedChanged.addListener((keysPressed=>{this.onKeysPressedChanged(new Set(keysPressed))}));chrome.accessibilityPrivate.onSelectToSpeakMouseChanged.addListener(((eventType,mouseX,mouseY)=>{this.onMouseEvent(eventType,mouseX,mouseY)}))}setTrackingMouse(tracking){this.trackingMouse_=tracking}getMouseRect(){return RectUtil.rectFromPoints(this.mouseStart_.x,this.mouseStart_.y,this.mouseEnd_.x,this.mouseEnd_.y)}onRequestReadClipboardData(){this.lastReadClipboardDataTime_=new Date}onMouseEvent(type,mouseX,mouseY){if(type===chrome.accessibilityPrivate.SyntheticMouseEventType.PRESS){this.onMouseDown_(mouseX,mouseY)}else if(type===chrome.accessibilityPrivate.SyntheticMouseEventType.RELEASE){this.onMouseUp_(mouseX,mouseY)}else{this.onMouseMove_(mouseX,mouseY)}}onMouseDown_(mouseX,mouseY){if(this.callbacks_.canStartSelecting()&&(!this.isSearchKeyDown_||this.isSelectionKeyDown_)){return false}this.callbacks_.onSelectingStateChanged(true,mouseX,mouseY);this.trackingMouse_=true;this.didTrackMouse_=true;this.mouseStart_={x:mouseX,y:mouseY};this.onMouseMove_(mouseX,mouseY);return false}onMouseMove_(mouseX,mouseY){if(!this.trackingMouse_){return}const rect=RectUtil.rectFromPoints(this.mouseStart_.x,this.mouseStart_.y,mouseX,mouseY);this.callbacks_.onSelectionChanged(rect)}onMouseUp_(mouseX,mouseY){if(!this.trackingMouse_){return}this.onMouseMove_(mouseX,mouseY);this.trackingMouse_=false;if(!this.keysCurrentlyDown_.has(SelectToSpeakConstants.SEARCH_KEY_CODE)){this.didTrackMouse_=false}this.mouseEnd_={x:mouseX,y:mouseY};const ctrX=Math.floor((this.mouseStart_.x+this.mouseEnd_.x)/2);const ctrY=Math.floor((this.mouseStart_.y+this.mouseEnd_.y)/2);this.callbacks_.onSelectingStateChanged(false,ctrX,ctrY)}onKeysPressedChanged(keysCurrentlyPressed){if(keysCurrentlyPressed.size>this.keysCurrentlyDown_.size){for(const key of keysCurrentlyPressed){this.keysPressedTogether_.add(key)}if(this.keysPressedTogether_.size===1&&keysCurrentlyPressed.has(SelectToSpeakConstants.SEARCH_KEY_CODE)){this.isSearchKeyDown_=true}else if(this.isSearchKeyDown_&&keysCurrentlyPressed.size===2&&keysCurrentlyPressed.has(SelectToSpeakConstants.READ_SELECTION_KEY_CODE)&&!this.trackingMouse_){this.isSelectionKeyDown_=true}else if(!this.trackingMouse_){this.isSearchKeyDown_=false}}else{const searchKeyReleased=this.keysCurrentlyDown_.has(SelectToSpeakConstants.SEARCH_KEY_CODE)&&!keysCurrentlyPressed.has(SelectToSpeakConstants.SEARCH_KEY_CODE);const ctrlKeyReleased=this.keysCurrentlyDown_.has(SelectToSpeakConstants.CONTROL_KEY_CODE)&&!keysCurrentlyPressed.has(SelectToSpeakConstants.CONTROL_KEY_CODE);const speakSelectionKeyReleased=this.keysCurrentlyDown_.has(SelectToSpeakConstants.READ_SELECTION_KEY_CODE)&&!keysCurrentlyPressed.has(SelectToSpeakConstants.READ_SELECTION_KEY_CODE);if(speakSelectionKeyReleased){if(this.isSelectionKeyDown_&&this.keysPressedTogether_.size===2&&this.keysPressedTogether_.has(SelectToSpeakConstants.SEARCH_KEY_CODE)){this.callbacks_.onKeystrokeSelection()}this.isSelectionKeyDown_=false}else if(searchKeyReleased){this.isSearchKeyDown_=false;if(this.trackingMouse_){this.trackingMouse_=false;this.callbacks_.onRequestCancel()}}if(!this.didTrackMouse_&&(ctrlKeyReleased||searchKeyReleased)&&this.keysPressedTogether_.size===1){this.trackingMouse_=false;this.callbacks_.onRequestCancel()}}this.keysCurrentlyDown_=keysCurrentlyPressed;if(this.keysCurrentlyDown_.size===0){this.didTrackMouse_=false;this.keysPressedTogether_.clear()}}}InputHandler.kClipboardReadMaxDelayMs=1e3;InputHandler.kClipboardClearMaxDelayMs=500;class PrefsManager{backgroundShadingEnabled_=false;color_="#da36e8";enhancedNetworkVoicesAllowed_=true;enhancedNetworkVoicesEnabled_=false;enhancedVoiceName_=PrefsManager.DEFAULT_NETWORK_VOICE;enhancedVoicesDialogShown_=false;extensionForVoice_=new Map;highlightColor_="#5e9bff";migrationInProgress_=false;navigationControlsEnabled_=true;speechRate_=1;validVoiceNames_=new Set;voiceNameFromLocale_=null;voiceNameFromPrefs_=null;wordHighlight_=true;voiceSwitching_=false;updateSettingsPrefsCallbackForTest_=null;constructor(){}updateDefaultVoice_(){let uiLocale=chrome.i18n.getMessage("@@ui_locale");uiLocale=uiLocale.replace("_","-").toLowerCase();chrome.tts.getVoices((voices=>{this.validVoiceNames_=new Set;if(voices.length===0){return}voices.forEach((voice=>{if(!voice.eventTypes.includes(chrome.tts.EventType.START)||!voice.eventTypes.includes(chrome.tts.EventType.END)||!voice.eventTypes.includes(chrome.tts.EventType.WORD)||!voice.eventTypes.includes(chrome.tts.EventType.CANCELLED)){return}if(voice.voiceName){this.extensionForVoice_.set(voice.voiceName,voice.extensionId||"");if(voice.extensionId!==PrefsManager.ENHANCED_TTS_EXTENSION_ID&&!voice.remote){this.validVoiceNames_.add(voice.voiceName)}}}));voices.sort((function(a,b){function score(voice){if(voice.lang===undefined){return-1}const lang=voice.lang.toLowerCase();let s=0;if(lang===uiLocale){s+=2}if(lang.substr(0,2)===uiLocale.substr(0,2)){s+=1}return s}return score(b)-score(a)}));const firstVoiceName=voices[0].voiceName;if(firstVoiceName){this.voiceNameFromLocale_=firstVoiceName}}))}migrateToGlobalTtsSettings_(rateStr,pitchStr){if(this.migrationInProgress_){return}this.migrationInProgress_=true;let stsRate=PrefsManager.DEFAULT_RATE;let stsPitch=PrefsManager.DEFAULT_PITCH;let globalRate=PrefsManager.DEFAULT_RATE;let globalPitch=PrefsManager.DEFAULT_PITCH;if(rateStr!==undefined){stsRate=parseFloat(rateStr)}if(pitchStr!==undefined){stsPitch=parseFloat(pitchStr)}const getPrefsPromises=[];getPrefsPromises.push(new Promise(((resolve,reject)=>{chrome.settingsPrivate.getPref("settings.tts.speech_rate",(pref=>{if(pref===undefined){reject()}globalRate=pref.value;resolve()}))})));getPrefsPromises.push(new Promise(((resolve,reject)=>{chrome.settingsPrivate.getPref("settings.tts.speech_pitch",(pref=>{if(pref===undefined){reject()}globalPitch=pref.value;resolve()}))})));Promise.all(getPrefsPromises).then((()=>{const stsOptionsModified=stsRate!==PrefsManager.DEFAULT_RATE||stsPitch!==PrefsManager.DEFAULT_PITCH;const globalOptionsModified=globalRate!==PrefsManager.DEFAULT_RATE||globalPitch!==PrefsManager.DEFAULT_PITCH;const optionsEqual=stsRate===globalRate&&stsPitch===globalPitch;if(optionsEqual){this.onTtsSettingsMigrationSuccess_();return}if(stsOptionsModified&&!globalOptionsModified){const setPrefsPromises=[];setPrefsPromises.push(new Promise(((resolve,reject)=>{chrome.settingsPrivate.setPref("settings.tts.speech_rate",stsRate,"",(success=>{if(success){resolve()}else{reject()}}))})));setPrefsPromises.push(new Promise(((resolve,reject)=>{chrome.settingsPrivate.setPref("settings.tts.speech_pitch",stsPitch,"",(success=>{if(success){resolve()}else{reject()}}))})));Promise.all(setPrefsPromises).then((()=>this.onTtsSettingsMigrationSuccess_()),(error=>{console.log(error);this.migrationInProgress_=false}))}else if(globalOptionsModified){this.onTtsSettingsMigrationSuccess_()}}),(error=>{console.log(error);this.migrationInProgress_=false}))}onTtsSettingsMigrationSuccess_(){chrome.storage.sync.remove("rate");chrome.storage.sync.remove("pitch");this.migrationInProgress_=false}updateSettingsPrefs_(prefs){for(const pref of prefs){switch(pref.key){case PrefsManager.VOICE_NAME_KEY:this.voiceNameFromPrefs_=pref.value;break;case PrefsManager.SPEECH_RATE_KEY:this.speechRate_=pref.value;break;case PrefsManager.WORD_HIGHLIGHT_KEY:this.wordHighlight_=pref.value;break;case PrefsManager.HIGHLIGHT_COLOR_KEY:this.highlightColor_=pref.value;break;case PrefsManager.BACKGROUND_SHADING_KEY:this.backgroundShadingEnabled_=pref.value;break;case PrefsManager.NAVIGATION_CONTROLS_KEY:this.navigationControlsEnabled_=pref.value;break;case PrefsManager.ENHANCED_NETWORK_VOICES_KEY:this.enhancedNetworkVoicesEnabled_=pref.value;break;case PrefsManager.ENHANCED_VOICES_DIALOG_SHOWN_KEY:this.enhancedVoicesDialogShown_=pref.value;break;case PrefsManager.ENHANCED_VOICE_NAME_KEY:this.enhancedVoiceName_=pref.value;break;case PrefsManager.ENHANCED_VOICES_POLICY_KEY:this.enhancedNetworkVoicesAllowed_=pref.value;break;case PrefsManager.VOICE_SWITCHING_KEY:this.voiceSwitching_=pref.value;break}}if(this.updateSettingsPrefsCallbackForTest_){this.updateSettingsPrefsCallbackForTest_()}}migrateStorageToSettingsPref_(storagePrefName,settingsPrefName,value){chrome.settingsPrivate.setPref(settingsPrefName,value);chrome.storage.sync.remove(storagePrefName)}async updateStoragePrefs_(){const prefs=await new Promise((resolve=>chrome.storage.sync.get(["voice","rate","pitch","wordHighlight","highlightColor","backgroundShading","navigationControls","enhancedNetworkVoices","enhancedVoicesDialogShown","enhancedVoiceName","voiceSwitching"],resolve)));if(prefs["voice"]){this.voiceNameFromPrefs_=prefs["voice"];this.migrateStorageToSettingsPref_("voice",PrefsManager.VOICE_NAME_KEY,this.voiceNameFromPrefs_)}if(prefs["wordHighlight"]!==undefined){this.wordHighlight_=prefs["wordHighlight"];this.migrateStorageToSettingsPref_("wordHighlight",PrefsManager.WORD_HIGHLIGHT_KEY,this.wordHighlight_)}if(prefs["highlightColor"]){this.highlightColor_=prefs["highlightColor"];this.migrateStorageToSettingsPref_("highlightColor",PrefsManager.HIGHLIGHT_COLOR_KEY,this.highlightColor_)}if(prefs["backgroundShading"]!==undefined){this.backgroundShadingEnabled_=prefs["backgroundShading"];this.migrateStorageToSettingsPref_("backgroundShading",PrefsManager.BACKGROUND_SHADING_KEY,this.backgroundShadingEnabled_)}if(prefs["navigationControls"]!==undefined){this.navigationControlsEnabled_=prefs["navigationControls"];this.migrateStorageToSettingsPref_("navigationControls",PrefsManager.NAVIGATION_CONTROLS_KEY,this.navigationControlsEnabled_)}if(prefs["enhancedNetworkVoices"]!==undefined){this.enhancedNetworkVoicesEnabled_=prefs["enhancedNetworkVoices"];this.migrateStorageToSettingsPref_("enhancedNetworkVoices",PrefsManager.ENHANCED_NETWORK_VOICES_KEY,this.enhancedNetworkVoicesEnabled_)}if(prefs["enhancedVoicesDialogShown"]!==undefined){this.enhancedVoicesDialogShown_=prefs["enhancedVoicesDialogShown"];this.migrateStorageToSettingsPref_("enhancedVoicesDialogShown",PrefsManager.ENHANCED_VOICES_DIALOG_SHOWN_KEY,this.enhancedVoicesDialogShown_)}if(prefs["enhancedVoiceName"]!==undefined){this.enhancedVoiceName_=prefs["enhancedVoiceName"];this.migrateStorageToSettingsPref_("enhancedVoiceName",PrefsManager.ENHANCED_VOICE_NAME_KEY,this.enhancedVoiceName_)}if(prefs["voiceSwitching"]!==undefined){this.voiceSwitching_=prefs["voiceSwitching"];this.migrateStorageToSettingsPref_("voiceSwitching",PrefsManager.VOICE_SWITCHING_KEY,this.voiceSwitching_)}if(prefs["rate"]&&prefs["pitch"]){this.migrateToGlobalTtsSettings_(prefs["rate"],prefs["pitch"])}}async initPreferences(){await this.updateStoragePrefs_();const settingsPrefs=await new Promise((resolve=>chrome.settingsPrivate.getAllPrefs(resolve)));this.updateSettingsPrefs_(settingsPrefs);chrome.settingsPrivate.onPrefsChanged.addListener((prefs=>this.updateSettingsPrefs_(prefs)));chrome.storage.onChanged.addListener((()=>this.updateStoragePrefs_()));this.updateDefaultVoice_();chrome.tts.onVoicesChanged.addListener((()=>{this.updateDefaultVoice_()}))}getLocalVoice(){if(this.voiceNameFromPrefs_===PrefsManager.SYSTEM_VOICE){return undefined}if(this.voiceNameFromPrefs_&&this.validVoiceNames_.has(this.voiceNameFromPrefs_)){return this.voiceNameFromPrefs_}else if(this.voiceNameFromLocale_&&this.validVoiceNames_.has(this.voiceNameFromLocale_)){return this.voiceNameFromLocale_}return undefined}getSpeechOptions(voiceSwitchingData){const options={};const data=voiceSwitchingData||{language:undefined,useVoiceSwitching:false};const useEnhancedVoices=this.enhancedNetworkVoicesEnabled()&&navigator.onLine;if(useEnhancedVoices){options["voiceName"]=this.enhancedVoiceName_}else{const useVoiceSwitching=data.useVoiceSwitching;const language=data.language;const localVoice=useVoiceSwitching?undefined:this.getLocalVoice();if(localVoice!==undefined){options["voiceName"]=localVoice}if(language!==undefined){options["lang"]=language}}return options}ttsExtensionForVoice(voiceName){return this.extensionForVoice_.get(voiceName)||""}isNetworkVoice(voiceName){return this.ttsExtensionForVoice(voiceName)===PrefsManager.ENHANCED_TTS_EXTENSION_ID}wordHighlightingEnabled(){return this.wordHighlight_}highlightColor(){return this.highlightColor_}focusRingColor(){return this.color_}backgroundShadingEnabled(){return this.backgroundShadingEnabled_}navigationControlsEnabled(){return this.navigationControlsEnabled_}speechRate(){return this.speechRate_}enhancedNetworkVoicesEnabled(){return this.enhancedNetworkVoicesAllowed_?this.enhancedNetworkVoicesEnabled_:false}enhancedNetworkVoicesAllowed(){return this.enhancedNetworkVoicesAllowed_}enhancedVoicesDialogShown(){return this.enhancedVoicesDialogShown_}setEnhancedNetworkVoicesFromDialog(enabled){if(enabled===undefined){return}this.enhancedNetworkVoicesEnabled_=enabled;chrome.settingsPrivate.setPref(PrefsManager.ENHANCED_NETWORK_VOICES_KEY,this.enhancedNetworkVoicesEnabled_);this.enhancedVoicesDialogShown_=true;chrome.settingsPrivate.setPref(PrefsManager.ENHANCED_VOICES_DIALOG_SHOWN_KEY,this.enhancedVoicesDialogShown_);if(!this.enhancedNetworkVoicesAllowed_){console.warn("Network voices dialog was shown when the policy disallows it.")}}voiceSwitchingEnabled(){return this.voiceSwitching_}}(function(PrefsManager){PrefsManager.USE_DEVICE_LANGUAGE="select_to_speak_device_language";PrefsManager.SYSTEM_VOICE="select_to_speak_system_voice";PrefsManager.DEFAULT_NETWORK_VOICE="default-wavenet";PrefsManager.ENHANCED_TTS_EXTENSION_ID="jacnkoglebceckolkoapelihnglgaicd";PrefsManager.GOOGLE_TTS_EXTENSION_ID="gjjabgpgjpampikjhjpfhneeoapjbjaf";PrefsManager.ESPEAK_EXTENSION_ID="dakbfdmgjiabojdgbiljlhgjbokobjpg";PrefsManager.DEFAULT_RATE=1;PrefsManager.DEFAULT_PITCH=1;PrefsManager.BACKGROUND_SHADING_KEY="settings.a11y.select_to_speak_background_shading";PrefsManager.ENHANCED_NETWORK_VOICES_KEY="settings.a11y.select_to_speak_enhanced_network_voices";PrefsManager.ENHANCED_VOICE_NAME_KEY="settings.a11y.select_to_speak_enhanced_voice_name";PrefsManager.ENHANCED_VOICES_DIALOG_SHOWN_KEY="settings.a11y.select_to_speak_enhanced_voices_dialog_shown";PrefsManager.ENHANCED_VOICES_POLICY_KEY="settings.a11y.enhanced_network_voices_in_select_to_speak_allowed";PrefsManager.HIGHLIGHT_COLOR_KEY="settings.a11y.select_to_speak_highlight_color";PrefsManager.NAVIGATION_CONTROLS_KEY="settings.a11y.select_to_speak_navigation_controls";PrefsManager.SPEECH_RATE_KEY="settings.tts.speech_rate";PrefsManager.VOICE_NAME_KEY="settings.a11y.select_to_speak_voice_name";PrefsManager.VOICE_SWITCHING_KEY="settings.a11y.select_to_speak_voice_switching";PrefsManager.WORD_HIGHLIGHT_KEY="settings.a11y.select_to_speak_word_highlight"})(PrefsManager||(PrefsManager={}));TestImportManager.exportForTesting(PrefsManager);class MetricsUtils{static recordCancelIfSpeaking(){chrome.tts.isSpeaking((speaking=>{if(speaking){MetricsUtils.recordCancelEvent_()}}))}static recordStartEvent(method,prefsManager){chrome.metricsPrivate.recordUserAction(MetricsUtils.START_SPEECH_METRIC);chrome.metricsPrivate.recordEnumerationValue(MetricsUtils.START_SPEECH_METHOD_METRIC.METRIC_NAME,method,MetricsUtils.START_SPEECH_METHOD_METRIC.EVENT_COUNT);chrome.metricsPrivate.recordBoolean(MetricsUtils.BACKGROUND_SHADING_METRIC,prefsManager.backgroundShadingEnabled());chrome.metricsPrivate.recordBoolean(MetricsUtils.NAVIGATION_CONTROLS_METRIC,prefsManager.navigationControlsEnabled());chrome.metricsPrivate.recordBoolean(MetricsUtils.ENHANCED_NETWORK_VOICES_METRIC,prefsManager.enhancedNetworkVoicesEnabled())}static recordCancelEvent_(){chrome.metricsPrivate.recordUserAction(MetricsUtils.CANCEL_SPEECH_METRIC)}static recordPauseEvent(){chrome.metricsPrivate.recordUserAction(MetricsUtils.PAUSE_SPEECH_METRIC)}static recordResumeEvent(){chrome.metricsPrivate.recordUserAction(MetricsUtils.RESUME_SPEECH_METRIC)}static recordSelectToSpeakStateChangeEvent(changeType){chrome.metricsPrivate.recordEnumerationValue(MetricsUtils.STATE_CHANGE_METRIC.METRIC_NAME,changeType,MetricsUtils.STATE_CHANGE_METRIC.EVENT_COUNT)}static speechMultiplierToSparseHistogramInt_(speechRate){return Math.floor(speechRate*100)}static recordSpeechRateOverrideMultiplier(rate){chrome.metricsPrivate.recordSparseValue(MetricsUtils.OVERRIDE_SPEECH_RATE_MULTIPLIER_METRIC,MetricsUtils.speechMultiplierToSparseHistogramInt_(rate))}static recordTtsEngineUsed(voiceName,prefsManager){let ttsEngine;if(voiceName===""){ttsEngine=MetricsUtils.TtsEngineUsed.SYSTEM_DEFAULT}else{const extensionId=prefsManager.ttsExtensionForVoice(voiceName);ttsEngine=MetricsUtils.ttsEngineForExtensionId_(extensionId)}chrome.metricsPrivate.recordEnumerationValue(MetricsUtils.TTS_ENGINE_USED_METRIC.METRIC_NAME,ttsEngine,MetricsUtils.TTS_ENGINE_USED_METRIC.EVENT_COUNT)}static ttsEngineForExtensionId_(extensionId){switch(extensionId){case PrefsManager.ENHANCED_TTS_EXTENSION_ID:return MetricsUtils.TtsEngineUsed.GOOGLE_NETWORK;case PrefsManager.ESPEAK_EXTENSION_ID:return MetricsUtils.TtsEngineUsed.ESPEAK;case PrefsManager.GOOGLE_TTS_EXTENSION_ID:return MetricsUtils.TtsEngineUsed.GOOGLE_LOCAL;default:return MetricsUtils.TtsEngineUsed.UNKNOWN}}static recordNumPdfPagesOcred(numOcredPages){chrome.metricsPrivate.recordMediumCount(MetricsUtils.PDF_OCR_PAGES_OCRED_METRIC,numOcredPages)}}(function(MetricsUtils){let StartSpeechMethod;(function(StartSpeechMethod){StartSpeechMethod[StartSpeechMethod["MOUSE"]=0]="MOUSE";StartSpeechMethod[StartSpeechMethod["KEYSTROKE"]=1]="KEYSTROKE";StartSpeechMethod[StartSpeechMethod["CONTEXT_MENU"]=2]="CONTEXT_MENU"})(StartSpeechMethod=MetricsUtils.StartSpeechMethod||(MetricsUtils.StartSpeechMethod={}));MetricsUtils.START_SPEECH_METHOD_METRIC={EVENT_COUNT:Object.keys(StartSpeechMethod).length,METRIC_NAME:"Accessibility.CrosSelectToSpeak.StartSpeechMethod"};let StateChangeEvent;(function(StateChangeEvent){StateChangeEvent[StateChangeEvent["START_SELECTION"]=0]="START_SELECTION";StateChangeEvent[StateChangeEvent["CANCEL_SPEECH"]=1]="CANCEL_SPEECH";StateChangeEvent[StateChangeEvent["CANCEL_SELECTION"]=2]="CANCEL_SELECTION"})(StateChangeEvent=MetricsUtils.StateChangeEvent||(MetricsUtils.StateChangeEvent={}));MetricsUtils.STATE_CHANGE_METRIC={EVENT_COUNT:Object.keys(StateChangeEvent).length,METRIC_NAME:"Accessibility.CrosSelectToSpeak.StateChangeEvent"};let TtsEngineUsed;(function(TtsEngineUsed){TtsEngineUsed[TtsEngineUsed["UNKNOWN"]=0]="UNKNOWN";TtsEngineUsed[TtsEngineUsed["SYSTEM_DEFAULT"]=1]="SYSTEM_DEFAULT";TtsEngineUsed[TtsEngineUsed["ESPEAK"]=2]="ESPEAK";TtsEngineUsed[TtsEngineUsed["GOOGLE_LOCAL"]=3]="GOOGLE_LOCAL";TtsEngineUsed[TtsEngineUsed["GOOGLE_NETWORK"]=4]="GOOGLE_NETWORK"})(TtsEngineUsed=MetricsUtils.TtsEngineUsed||(MetricsUtils.TtsEngineUsed={}));MetricsUtils.TTS_ENGINE_USED_METRIC={EVENT_COUNT:Object.keys(TtsEngineUsed).length,METRIC_NAME:"Accessibility.CrosSelectToSpeak.TtsEngineUsed"};MetricsUtils.START_SPEECH_METRIC="Accessibility.CrosSelectToSpeak.StartSpeech";MetricsUtils.CANCEL_SPEECH_METRIC="Accessibility.CrosSelectToSpeak.CancelSpeech";MetricsUtils.PAUSE_SPEECH_METRIC="Accessibility.CrosSelectToSpeak.PauseSpeech";MetricsUtils.RESUME_SPEECH_METRIC="Accessibility.CrosSelectToSpeak.ResumeSpeech";MetricsUtils.BACKGROUND_SHADING_METRIC="Accessibility.CrosSelectToSpeak.BackgroundShading";MetricsUtils.NAVIGATION_CONTROLS_METRIC="Accessibility.CrosSelectToSpeak.NavigationControls";MetricsUtils.ENHANCED_NETWORK_VOICES_METRIC="Accessibility.CrosSelectToSpeak.EnhancedNetworkVoices";MetricsUtils.OVERRIDE_SPEECH_RATE_MULTIPLIER_METRIC="Accessibility.CrosSelectToSpeak.OverrideSpeechRateMultiplier";MetricsUtils.PDF_OCR_PAGES_OCRED_METRIC="Accessibility.PdfOcr.CrosSelectToSpeak.PagesOcred"})(MetricsUtils||(MetricsUtils={}));class TtsManager{clientTtsOptions_;currentCharIndex_;fallbackVoice_;isNetworkVoice_;isSpeaking_;pauseCompleteCallback_;text_;constructor(){this.clientTtsOptions_={};this.currentCharIndex_=0;this.fallbackVoice_=undefined;this.isNetworkVoice_=false;this.isSpeaking_=false;this.pauseCompleteCallback_=null;this.text_=null}isSpeaking(){return this.isSpeaking_}speak(text,ttsOptions,networkVoice,fallbackVoice){if(ttsOptions.enqueued){console.warn("TtsManager does not support a queue of utterances.");return}this.cleanTtsState_();this.text_=text;this.isNetworkVoice_=networkVoice;this.fallbackVoice_=fallbackVoice;this.startSpeakingTextWithOffset_(0,false,ttsOptions)}startSpeakingTextWithOffset_(offset,resume,ttsOptions){const text=this.text_.slice(offset);const modifiedOptions=Object.assign({},ttsOptions);Object.assign(this.clientTtsOptions_,ttsOptions);modifiedOptions.onEvent=event=>{switch(event.type){case chrome.tts.EventType.ERROR:if(this.isNetworkVoice_){console.warn("Network TTS error, retrying with local voice");const localOptions=Object.assign({},modifiedOptions);localOptions.voiceName=this.fallbackVoice_;if(this.text_){this.speak(this.text_,localOptions,false,undefined)}}break;case chrome.tts.EventType.START:this.isSpeaking_=true;this.currentCharIndex_=(text||"").search(/\S|$/)+offset;if(resume){TtsManager.sendEventToOptions(ttsOptions,{type:chrome.tts.EventType.RESUME,charIndex:this.currentCharIndex_});break}TtsManager.sendEventToOptions(ttsOptions,{type:chrome.tts.EventType.START,charIndex:this.currentCharIndex_});break;case chrome.tts.EventType.END:this.isSpeaking_=false;this.currentCharIndex_=text.length+offset;TtsManager.sendEventToOptions(ttsOptions,{type:chrome.tts.EventType.END,charIndex:this.currentCharIndex_});break;case chrome.tts.EventType.WORD:this.isSpeaking_=true;this.currentCharIndex_=event.charIndex+offset;TtsManager.sendEventToOptions(ttsOptions,{type:chrome.tts.EventType.WORD,charIndex:this.currentCharIndex_,length:event.length});break;case chrome.tts.EventType.INTERRUPTED:case chrome.tts.EventType.CANCELLED:this.isSpeaking_=false;if(this.pauseCompleteCallback_){TtsManager.sendEventToOptions(ttsOptions,{type:chrome.tts.EventType.PAUSE,charIndex:this.currentCharIndex_});this.pauseCompleteCallback_();break}TtsManager.sendEventToOptions(ttsOptions,event);break;default:TtsManager.sendEventToOptions(ttsOptions,event);break}};chrome.tts.speak(text,modifiedOptions)}pause(){return new Promise((resolve=>{this.pauseCompleteCallback_=()=>{this.pauseCompleteCallback_=null;resolve()};chrome.tts.stop()}))}resume(ttsOptions){ttsOptions=ttsOptions||this.clientTtsOptions_;if(this.isSpeaking_){return}if(this.text_.slice(this.currentCharIndex_).trim().length===0){TtsManager.sendEventToOptions(ttsOptions,{type:chrome.tts.EventType.ERROR,errorMessage:TtsManager.ErrorMessage.RESUME_WITH_EMPTY_CONTENT});return}this.startSpeakingTextWithOffset_(this.currentCharIndex_,true,ttsOptions)}stop(){chrome.tts.stop()}cleanTtsState_(){this.text_=null;this.clientTtsOptions_={};this.currentCharIndex_=0;this.pauseCompleteCallback_=null;this.isSpeaking_=false;this.isNetworkVoice_=false}static sendEventToOptions(options,event){if(options.onEvent){options.onEvent(event);return}console.warn("onEvent is not defined in the TtsOptions")}}(function(TtsManager){(function(ErrorMessage){ErrorMessage["RESUME_WITH_EMPTY_CONTENT"]="Cannot resume with empty content."})(TtsManager.ErrorMessage||(TtsManager.ErrorMessage={}))})(TtsManager||(TtsManager={}));TestImportManager.exportForTesting(TtsManager);const EventType$1=chrome.automation.EventType;const FocusRingStackingOrder=chrome.accessibilityPrivate.FocusRingStackingOrder;const SELECT_TO_SPEAK_TRAY_CLASS_NAME="SelectToSpeakTray";const SELECT_TO_SPEAK_MENU_CLASS_NAME="SelectToSpeakMenuView";const SELECT_TO_SPEAK_SPEED_CLASS_NAME="SelectToSpeakSpeedView";const TRAY_BUBBLE_VIEW_CLASS_NAME="TrayBubbleView";const FLOATING_MENU_BUTTON_CLASS_NAME="FloatingMenuButton";const DEFAULT_BACKGROUND_SHADING_COLOR="#0006";class UiManager{desktop_;listener_;panelButton_;prefsManager_;constructor(prefsManager,listener){this.desktop_=null;this.listener_=listener;this.panelButton_=null;this.prefsManager_=prefsManager;this.init_()}init_(){chrome.automation.getDesktop((desktop=>{this.desktop_=desktop;desktop.addEventListener(EventType$1.FOCUS,(evt=>{this.onFocusChange_(evt)}),true)}));chrome.accessibilityPrivate.onSelectToSpeakPanelAction.addListener(((panelAction,value)=>{this.onPanelAction_(panelAction,value)}));chrome.accessibilityPrivate.onSelectToSpeakStateChangeRequested.addListener((()=>{this.listener_.onStateChangeRequested()}))}onPanelAction_(panelAction,value){switch(panelAction){case chrome.accessibilityPrivate.SelectToSpeakPanelAction.NEXT_PARAGRAPH:this.listener_.onNextParagraphRequested();break;case chrome.accessibilityPrivate.SelectToSpeakPanelAction.PREVIOUS_PARAGRAPH:this.listener_.onPreviousParagraphRequested();break;case chrome.accessibilityPrivate.SelectToSpeakPanelAction.NEXT_SENTENCE:this.listener_.onNextSentenceRequested();break;case chrome.accessibilityPrivate.SelectToSpeakPanelAction.PREVIOUS_SENTENCE:this.listener_.onPreviousSentenceRequested();break;case chrome.accessibilityPrivate.SelectToSpeakPanelAction.EXIT:this.listener_.onExitRequested();break;case chrome.accessibilityPrivate.SelectToSpeakPanelAction.PAUSE:this.listener_.onPauseRequested();break;case chrome.accessibilityPrivate.SelectToSpeakPanelAction.RESUME:this.listener_.onResumeRequested();break;case chrome.accessibilityPrivate.SelectToSpeakPanelAction.CHANGE_SPEED:if(!value){console.warn("Change speed request receieved with invalid value",value);return}this.listener_.onChangeSpeedRequested(value);break;default:console.warn("Unknown panel action received",panelAction)}}onFocusChange_(evt){const focusedNode=evt.target;if(focusedNode.className!==FLOATING_MENU_BUTTON_CLASS_NAME){return}const windowParent=AutomationUtil.getFirstAncestorWithRole(focusedNode,chrome.automation.RoleType.WINDOW);if(windowParent&&windowParent.className===TRAY_BUBBLE_VIEW_CLASS_NAME&&windowParent.children.length===1&&windowParent.children[0].className===SELECT_TO_SPEAK_MENU_CLASS_NAME){this.panelButton_=focusedNode}}setFocusToPanel(){if(this.panelButton_&&this.panelButton_.role){this.panelButton_.focus();return}this.panelButton_=null;if(!this.desktop_){console.error("No cached desktop object, cannot focus panel");return}const menuView=this.desktop_.find({attributes:{className:SELECT_TO_SPEAK_MENU_CLASS_NAME}});if(menuView!==null&&menuView.parent&&menuView.parent.className===TRAY_BUBBLE_VIEW_CLASS_NAME){this.panelButton_=menuView.find({role:chrome.automation.RoleType.TOGGLE_BUTTON});this.panelButton_.focus()}}setFocusRings_(rects,drawBackground,panelVisible){let color="#0000";if(drawBackground&&this.prefsManager_.backgroundShadingEnabled()){color=DEFAULT_BACKGROUND_SHADING_COLOR}const stackingOrder=panelVisible?FocusRingStackingOrder.BELOW_ACCESSIBILITY_BUBBLES:FocusRingStackingOrder.ABOVE_ACCESSIBILITY_BUBBLES;chrome.accessibilityPrivate.setFocusRings([{rects:rects,type:chrome.accessibilityPrivate.FocusType.GLOW,stackingOrder:stackingOrder,color:this.prefsManager_.focusRingColor(),backgroundColor:color}],chrome.accessibilityPrivate.AssistiveTechnologyType.SELECT_TO_SPEAK)}updatePanel_(showPanel,anchorRect,paused,speechRateMultiplier){if(showPanel){if(anchorRect===undefined||paused===undefined||speechRateMultiplier===undefined){console.error("Cannot display panel: missing required parameters");return}chrome.accessibilityPrivate.updateSelectToSpeakPanel(true,anchorRect,paused,speechRateMultiplier)}else{chrome.accessibilityPrivate.updateSelectToSpeakPanel(false)}}updateHighlight_(node,currentWord,paused){if(!currentWord){chrome.accessibilityPrivate.setHighlights([],this.prefsManager_.highlightColor());return}const charIndexInParent=node.role===chrome.automation.RoleType.INLINE_TEXT_BOX?ParagraphUtils.getStartCharIndexInParent(node):0;node.boundsForRange(currentWord.start-charIndexInParent,currentWord.end-charIndexInParent,(bounds=>{const highlights=bounds?[bounds]:[];chrome.accessibilityPrivate.setHighlights(highlights,this.prefsManager_.highlightColor());if(!paused){chrome.accessibilityPrivate.setSelectToSpeakFocus(bounds?bounds:node.location)}}))}setSelectionRect(rect){this.setFocusRings_([rect],false,false)}update(nodeGroup,node,currentWord,panelState){const{showPanel:showPanel,paused:paused,speechRateMultiplier:speechRateMultiplier}=panelState;let focusRingRect;const currentBlockParent=nodeGroup.blockParent;if(currentBlockParent!==null&&nodeGroup.nodes.length>1){focusRingRect=currentBlockParent.location}else{focusRingRect=node.location}this.updateHighlight_(node,currentWord,paused);if(focusRingRect){this.setFocusRings_([focusRingRect],true,showPanel);this.updatePanel_(showPanel,focusRingRect,paused,speechRateMultiplier)}else{console.warn("No node location; cannot render focus ring or panel")}}clear(){this.setFocusRings_([],false,false);chrome.accessibilityPrivate.setHighlights([],this.prefsManager_.highlightColor());this.updatePanel_(false)}static isPanel(node){if(!node){return false}return node.className===TRAY_BUBBLE_VIEW_CLASS_NAME&&node.children.length===1&&(node.children[0].className===SELECT_TO_SPEAK_MENU_CLASS_NAME||node.children[0].className===SELECT_TO_SPEAK_SPEED_CLASS_NAME)}static isTrayButton(node){if(!node){return false}return AutomationUtil.getAncestors(node).find((n=>n.className===SELECT_TO_SPEAK_TRAY_CLASS_NAME))!==undefined}}TestImportManager.exportForTesting(UiManager,["SELECT_TO_SPEAK_TRAY_CLASS_NAME",SELECT_TO_SPEAK_TRAY_CLASS_NAME]);var EventType=chrome.automation.EventType;var RoleType=chrome.automation.RoleType;var SelectToSpeakState=chrome.accessibilityPrivate.SelectToSpeakState;const GSUITE_APP_REGEXP=/^https:\/\/docs\.(?:sandbox\.)?google\.com\/(?:(?:presentation)|(?:document)|(?:spreadsheets)|(?:drawings)|(?:scenes)){1}\//;function getGSuiteAppRoot(node){while(node!==undefined&&node.root!==undefined){if(node.root.url!==undefined&&GSUITE_APP_REGEXP.exec(node.root.url)){return node.root}node=node.root.parent}return null}class SelectToSpeak{currentCharIndex_;currentNodeGroupIndex_;currentNodeGroupItem_;currentNodeGroupItemIndex_;currentNodeGroups_;currentNodeWord_;desktop_;inputHandler_;intervalId_;nullSelectionTone_;onStateChangeRequestedCallbackForTest_;prefsManager_;scrollToSpokenNode_;speechRateMultiplier_;state_;supportsNavigationPanel_;ttsManager_;uiManager_;onLoadDesktopCallbackForTest_;readyForTestingPromise=new Promise((resolve=>this.readyForTestingCallback_=resolve));constructor(){this.currentCharIndex_=-1;this.currentNodeGroupIndex_=-1;this.currentNodeGroupItem_=null;this.currentNodeGroupItemIndex_=-1;this.currentNodeGroups_=[];this.currentNodeWord_=null;this.desktop_;this.inputHandler_=null;this.intervalId_;this.nullSelectionTone_=new Audio("earcons/null_selection.ogg");this.onStateChangeRequestedCallbackForTest_=null;this.prefsManager_=new PrefsManager;this.scrollToSpokenNode_=false;this.speechRateMultiplier_=1;this.state_=SelectToSpeakState.INACTIVE;this.supportsNavigationPanel_=true;this.ttsManager_=new TtsManager;this.uiManager_=new UiManager(this.prefsManager_,this);this.onLoadDesktopCallbackForTest_=null;this.init_()}async init_(){chrome.automation.getDesktop((desktop=>{this.desktop_=desktop;desktop.addEventListener(EventType.MOUSE_RELEASED,(evt=>this.onAutomationHitTest_(evt)),true);desktop.addEventListener(EventType.LAYOUT_COMPLETE,(evt=>this.onLayoutComplete_(evt)),true);if(this.onLoadDesktopCallbackForTest_){this.onLoadDesktopCallbackForTest_();this.onLoadDesktopCallbackForTest_=null}}));this.prefsManager_.initPreferences();this.runContentScripts_();this.setUpEventListeners_();await Flags.init();const createArgs={title:chrome.i18n.getMessage("select_to_speak_listen_context_menu_option_text"),contexts:[chrome.contextMenus.ContextType.SELECTION],id:"select_to_speak"};if(Flags.isEnabled(FlagName.MANIFEST_V3)){chrome.contextMenus.onClicked.addListener((()=>{this.getFocusedNodeAndSpeakSelectedText_()}))}else{createArgs["onclick"]=()=>{this.getFocusedNodeAndSpeakSelectedText_()}}await chrome.contextMenus.create(createArgs);chrome.accessibilityPrivate.onSelectToSpeakContextMenuClicked.addListener((()=>{this.getFocusedNodeAndSpeakSelectedText_()}));this.readyForTestingCallback_()}getCurrentNodeGroup_(){if(this.currentNodeGroups_.length===0){return undefined}return this.currentNodeGroups_[this.currentNodeGroupIndex_]}shouldShowNavigationControls_(){return this.prefsManager_.navigationControlsEnabled()&&this.supportsNavigationPanel_}readPdfStatusNodeIfStillLoading_(pdfRoot){if(pdfRoot.role===RoleType.PDF_ROOT&&pdfRoot.children.length===1&&pdfRoot.firstChild.role===RoleType.BANNER&&pdfRoot.firstChild.children.length===1&&pdfRoot.firstChild.firstChild.role===RoleType.STATUS&&pdfRoot.firstChild.firstChild.children.length===1&&pdfRoot.firstChild.firstChild.firstChild.role===RoleType.STATIC_TEXT){this.startSpeechQueue_([pdfRoot.firstChild.firstChild.firstChild],{clearFocusRing:true});return true}return false}onLayoutComplete_(evt){const root=evt.target;if(!root.url||!root.url.endsWith(".pdf")){return}const pdfRoot=root.find({role:RoleType.PDF_ROOT});if(!pdfRoot){return}this.recordOcredPagesInPdf_(pdfRoot)}recordOcredPagesInPdf_(pdfRoot){const orcedPages=pdfRoot.findAll({attributes:{className:"ocred_page"}});MetricsUtils.recordNumPdfPagesOcred(orcedPages.length)}onAutomationHitTest_(evt){let root=evt.target;if((root.role===RoleType.EMBEDDED_OBJECT||root.role===RoleType.GRAPHICS_DOCUMENT)&&root.children.length===1&&root.firstChild.role===RoleType.PDF_ROOT&&root.firstChild.children.length===1&&this.readPdfStatusNodeIfStillLoading_(root.firstChild)){return}while(root.parent&&root.role!==RoleType.WINDOW&&root.role!==RoleType.ROOT_WEB_AREA&&root.role!==RoleType.DESKTOP&&root.role!==RoleType.DIALOG&&root.role!==RoleType.ALERT_DIALOG&&root.role!==RoleType.TOOLBAR&&root.role!==RoleType.DOCUMENT&&root.role!==RoleType.GRAPHICS_DOCUMENT){root=root.parent}const rect=this.inputHandler_.getMouseRect();let nodes=[];chrome.automation.getFocus((focusedNode=>{if(!NodeUtils.findAllMatching(root,rect,nodes)&&focusedNode&&focusedNode.root.role!==RoleType.DESKTOP){NodeUtils.findAllMatching(focusedNode.root,rect,nodes)}if(nodes.length===1&&UiManager.isTrayButton(nodes[0])){return}if(this.shouldShowNavigationControls_()&&nodes.length>0&&(rect.width<=SelectToSpeakConstants.PARAGRAPH_SELECTION_MAX_SIZE||rect.height<=SelectToSpeakConstants.PARAGRAPH_SELECTION_MAX_SIZE)){nodes=NodeUtils.getAllNodesInParagraph(nodes[0])}this.startSpeechQueue_(nodes,{clearFocusRing:true});MetricsUtils.recordStartEvent(MetricsUtils.StartSpeechMethod.MOUSE,this.prefsManager_)}))}getFocusedNodeAndSpeakSelectedText_(){chrome.automation.getFocus((focusedNode=>this.requestSpeakSelectedText_(MetricsUtils.StartSpeechMethod.CONTEXT_MENU,focusedNode)))}requestSpeakSelectedText_(method,focusedNode){if(!focusedNode||!focusedNode.root){this.onNullSelection_();return}const hasSelectionObjects=focusedNode.root.selectionStartObject&&focusedNode.root.selectionEndObject;const hasTextSelection=focusedNode.textSelStart!==undefined&&focusedNode.textSelEnd!==undefined;if(!hasSelectionObjects&&!hasTextSelection){this.onNullSelection_();return}let startObject;let startOffset=0;let endObject;let endOffset=0;if(hasSelectionObjects){startObject=focusedNode.root.selectionStartObject;startOffset=focusedNode.root.selectionStartOffset||0;endObject=focusedNode.root.selectionEndObject;endOffset=focusedNode.root.selectionEndOffset||0}else if(hasTextSelection){startObject=focusedNode;startOffset=focusedNode.textSelStart||0;endObject=focusedNode;endOffset=focusedNode.textSelEnd||0}if(startObject===endObject&&startOffset===endOffset){this.onNullSelection_();return}const startPosition=NodeUtils.getDeepEquivalentForSelection(startObject,startOffset,true);const endPosition=NodeUtils.getDeepEquivalentForSelection(endObject,endOffset,false);let firstPosition;let lastPosition;if(startPosition.node===endPosition.node){if(startPosition.offset<endPosition.offset){firstPosition=startPosition;lastPosition=endPosition}else{lastPosition=startPosition;firstPosition=endPosition}}else{const dir=AutomationUtil.getDirection(startPosition.node,endPosition.node);if(dir===constants.Dir.FORWARD){firstPosition=startPosition;lastPosition=endPosition}else{lastPosition=startPosition;firstPosition=endPosition}}this.cancelIfSpeaking_(true);this.readNodesBetweenPositions_(firstPosition,lastPosition,method,focusedNode)}readNodesBetweenPositions_(firstPosition,lastPosition,method,focusedNode){const nodes=[];let selectedNode=firstPosition.node;const userRequested=method!==null;const methodNumber=method!==null?method:-1;const nodeName=ParagraphUtils.getNodeName(selectedNode);if(nodeName&&firstPosition.offset<nodeName.length&&!NodeUtils.shouldIgnoreNode(selectedNode,true)&&!NodeUtils.isNotSelectable(selectedNode)){nodes.push(selectedNode)}else{firstPosition.offset=0}while(selectedNode&&selectedNode!==lastPosition.node&&AutomationUtil.getDirection(selectedNode,lastPosition.node)===constants.Dir.FORWARD){selectedNode=AutomationUtil.findNextNode(selectedNode,constants.Dir.FORWARD,AutomationPredicate.leafWithText);if(!selectedNode){break}else if(NodeUtils.isTextField(selectedNode)){selectedNode=AutomationUtil.findNextNode(selectedNode,constants.Dir.FORWARD,AutomationPredicate.leafWithText);if(!selectedNode){break}}if(!NodeUtils.shouldIgnoreNode(selectedNode,true)&&!NodeUtils.isNotSelectable(selectedNode)){nodes.push(selectedNode)}}if(nodes.length>0){if(lastPosition.node!==nodes[nodes.length-1]){this.startSpeechQueue_(nodes,{clearFocusRing:userRequested,startCharIndex:firstPosition.offset})}else{this.startSpeechQueue_(nodes,{clearFocusRing:userRequested,startCharIndex:firstPosition.offset,endCharIndex:lastPosition.offset})}if(focusedNode){this.initializeScrollingToOffscreenNodes_(focusedNode.root)}if(userRequested){MetricsUtils.recordStartEvent(methodNumber,this.prefsManager_)}}else{const gsuiteAppRootNode=getGSuiteAppRoot(focusedNode);if(!gsuiteAppRootNode){return}chrome.tabs.query({active:true},(tabs=>{if(!gsuiteAppRootNode||gsuiteAppRootNode.url===undefined){return}this.inputHandler_.onRequestReadClipboardData();this.currentNodeGroupItem_=new ParagraphUtils.NodeGroupItem(gsuiteAppRootNode,0,false);if(tabs.length===0||tabs[0].url!==gsuiteAppRootNode.url){return}const tab=tabs[0];chrome.tabs.executeScript(tab.id,{allFrames:true,matchAboutBlank:true,code:'document.execCommand("copy");'});if(userRequested){MetricsUtils.recordStartEvent(methodNumber,this.prefsManager_)}}))}}initializeScrollingToOffscreenNodes_(root){if(!root){return}this.scrollToSpokenNode_=true;const listener=event=>{if(event.eventFrom!=="action"){this.scrollToSpokenNode_=false;root.removeEventListener(EventType.SCROLL_POSITION_CHANGED,listener,false);root.removeEventListener(EventType.SCROLL_HORIZONTAL_POSITION_CHANGED,listener,false);root.removeEventListener(EventType.SCROLL_VERTICAL_POSITION_CHANGED,listener,false)}};root.addEventListener(EventType.SCROLL_POSITION_CHANGED,listener,false);root.addEventListener(EventType.SCROLL_HORIZONTAL_POSITION_CHANGED,listener,false);root.addEventListener(EventType.SCROLL_VERTICAL_POSITION_CHANGED,listener,false)}onNullSelection_(){if(!this.shouldShowNavigationControls_()){this.nullSelectionTone_.play();return}this.uiManager_.setFocusToPanel()}isPaused_(){return!this.ttsManager_.isSpeaking()&&this.state_===SelectToSpeakState.SPEAKING}pause_(){return this.ttsManager_.pause()}resume_(){if(!this.isPaused_()){return}const currentNodeGroup=this.getCurrentNodeGroup_();if(!currentNodeGroup){return}this.ttsManager_.resume(this.getTtsOptionsForCurrentNodeGroup_())}onTtsResumeSucceedEvent_(event){const currentNodeGroup=this.getCurrentNodeGroup_();if(!currentNodeGroup){console.warn("Unexpected invalid node group on TTS resume event.");return}this.onTtsWordEvent_(event,currentNodeGroup)}onTtsResumeErrorEvent_(_event){const currentNodeGroup=this.getCurrentNodeGroup_();if(!currentNodeGroup){console.warn("Unexpected invalid node group on TTS error event when resuming.");return}const currentPosition=NodeUtils.getPositionFromNodeGroup(currentNodeGroup,this.currentCharIndex_,true);const{nodes:remainingNodes,offset:offset}=NodeNavigationUtils.getNextNodesInParagraphFromPosition(currentPosition,constants.Dir.FORWARD);if(remainingNodes.length===0){this.navigateToNextParagraph_(constants.Dir.FORWARD);return}this.startSpeechQueue_(remainingNodes,{clearFocusRing:false,startCharIndex:offset})}stopAll_(){this.ttsManager_.stop();this.uiManager_.clear();this.onStateChanged_(SelectToSpeakState.INACTIVE)}clearFocusRingAndNode_(){this.uiManager_.clear();this.resetNodes_();this.supportsNavigationPanel_=true;if(this.intervalId_!==undefined){clearInterval(this.intervalId_);this.intervalId_=undefined}this.scrollToSpokenNode_=false}resetNodes_(){this.currentNodeGroups_=[];this.currentNodeGroupIndex_=-1;this.currentNodeGroupItem_=null;this.currentNodeGroupItemIndex_=-1;this.currentNodeWord_=null;this.currentCharIndex_=-1}runContentScripts_(){const scripts=chrome.runtime.getManifest()["content_scripts"][0]["js"];if(scripts.length!==1){throw new Error("Only expected one script; got "+JSON.stringify(scripts))}const script=scripts[0];chrome.tabs.query({url:["https://docs.google.com/document*","https://docs.sandbox.google.com/*"]},(tabs=>{tabs.forEach((tab=>{chrome.tabs.executeScript(tab.id,{file:script})}))}))}setUpEventListeners_(){this.inputHandler_=new InputHandler({canStartSelecting:()=>this.state_!==SelectToSpeakState.SELECTING,onSelectingStateChanged:(isSelecting,x,y)=>{if(isSelecting){this.onStateChanged_(SelectToSpeakState.SELECTING);this.cancelIfSpeaking_(false);this.desktop_.hitTest(x,y,EventType.MOUSE_PRESSED)}else{this.onStateChanged_(SelectToSpeakState.INACTIVE);this.desktop_.hitTest(x,y,EventType.MOUSE_RELEASED)}},onSelectionChanged:rect=>{this.uiManager_.setSelectionRect(rect)},onKeystrokeSelection:()=>{chrome.automation.getFocus((focusedNode=>this.requestSpeakSelectedText_(MetricsUtils.StartSpeechMethod.KEYSTROKE,focusedNode)))},onRequestCancel:()=>{MetricsUtils.recordCancelIfSpeaking();this.cancelIfSpeaking_(true)},onTextReceived:text=>this.startSpeech_(text)});this.inputHandler_.setUpEventListeners();chrome.accessibilityPrivate.setSelectToSpeakState(this.state_)}onStateChangeRequested(){switch(this.state_){case SelectToSpeakState.INACTIVE:this.inputHandler_.setTrackingMouse(true);this.onStateChanged_(SelectToSpeakState.SELECTING);MetricsUtils.recordSelectToSpeakStateChangeEvent(MetricsUtils.StateChangeEvent.START_SELECTION);break;case SelectToSpeakState.SPEAKING:MetricsUtils.recordCancelIfSpeaking();this.cancelIfSpeaking_(true);MetricsUtils.recordSelectToSpeakStateChangeEvent(MetricsUtils.StateChangeEvent.CANCEL_SPEECH);break;case SelectToSpeakState.SELECTING:this.inputHandler_.setTrackingMouse(false);this.onStateChanged_(SelectToSpeakState.INACTIVE);MetricsUtils.recordSelectToSpeakStateChangeEvent(MetricsUtils.StateChangeEvent.CANCEL_SELECTION)}this.onStateChangeRequestedCallbackForTest_&&this.onStateChangeRequestedCallbackForTest_()}onNextParagraphRequested(){this.navigateToNextParagraph_(constants.Dir.FORWARD)}onPreviousParagraphRequested(){this.navigateToNextParagraph_(constants.Dir.BACKWARD)}onNextSentenceRequested(){this.navigateToNextSentence_(constants.Dir.FORWARD)}onPreviousSentenceRequested(){this.navigateToNextSentence_(constants.Dir.BACKWARD)}onExitRequested(){MetricsUtils.recordCancelIfSpeaking();this.stopAll_()}onPauseRequested(){MetricsUtils.recordPauseEvent();this.pause_()}onResumeRequested(){if(this.isPaused_()){MetricsUtils.recordResumeEvent();this.resume_()}}onChangeSpeedRequested(rateMultiplier){this.speechRateMultiplier_=rateMultiplier;if(!this.isPaused_()){this.pause_().then((()=>{this.resume_()}))}}async navigateToNextSentence_(direction){if(!this.isPaused_()){await this.pause_()}const{nodes:nodes,offset:offset}=NodeNavigationUtils.getNodesForNextSentence(this.getCurrentNodeGroup_(),this.currentCharIndex_,direction,(nodes=>this.skipPanel_(nodes)));if(nodes.length===0){return}nodes[0].makeVisible();this.startSpeechQueue_(nodes,{startCharIndex:offset})}async navigateToNextParagraph_(direction){if(!this.isPaused_()){await this.pause_()}const nodes=NodeNavigationUtils.getNodesForNextParagraph(this.getCurrentNodeGroup_(),direction,(nodes=>this.skipPanel_(nodes)));if(nodes.length===0){return}nodes[0].makeVisible();this.startSpeechQueue_(nodes)}skipPanel_(nodes){return!AutomationUtil.getAncestors(nodes[0]).find((n=>UiManager.isPanel(n)))}startSpeech_(text){this.prepareForSpeech_(true);this.maybeShowEnhancedVoicesDialog_((()=>{const options=this.prefsManager_.getSpeechOptions(null);const fallbackVoiceName=this.prefsManager_.getLocalVoice();this.supportsNavigationPanel_=false;options.onEvent=event=>{if(event.type==="start"){this.onStateChanged_(SelectToSpeakState.SPEAKING);this.updateUi_()}else if(event.type==="end"||event.type==="interrupted"||event.type==="cancelled"){this.onStateChanged_(SelectToSpeakState.INACTIVE)}};const voiceName=options["voiceName"]||"";MetricsUtils.recordTtsEngineUsed(voiceName||"",this.prefsManager_);this.ttsManager_.speak(text,options,this.prefsManager_.isNetworkVoice(voiceName),fallbackVoiceName)}))}startSpeechQueue_(nodes,optParams){this.maybeShowEnhancedVoicesDialog_((()=>{const params=optParams||{};const clearFocusRing=params.clearFocusRing||false;let startCharIndex=params.startCharIndex;let endCharIndex=params.endCharIndex;this.prepareForSpeech_(clearFocusRing);if(nodes.length===0){return}const originalFirstNode=nodes[0];const originalLastNode=nodes[nodes.length-1];NodeUtils.sortSvgNodesByReadingOrder(nodes);if(originalFirstNode!==nodes[0]){startCharIndex=undefined}if(originalLastNode!==nodes[nodes.length-1]){endCharIndex=undefined}this.supportsNavigationPanel_=this.isNavigationPanelSupported_(nodes);this.updateNodeGroups_(nodes,startCharIndex,endCharIndex);this.startCurrentNodeGroup_()}))}updateNodeGroups_(nodes,startCharIndex,endCharIndex){this.resetNodes_();for(let i=0;i<nodes.length;i++){const nodeGroup=ParagraphUtils.buildNodeGroup(nodes,i,{splitOnLanguage:this.shouldUseVoiceSwitching_(),clipOverflowWords:!this.shouldShowNavigationControls_()});const isFirstNodeGroup=i===0;const shouldApplyStartOffset=isFirstNodeGroup&&startCharIndex!==undefined;const firstNodeHasInlineText=nodeGroup.nodes.length>0&&nodeGroup.nodes[0].hasInlineText;if(shouldApplyStartOffset){let startIndexInNodeGroup;if(firstNodeHasInlineText){const startIndexInNodeParent=ParagraphUtils.getStartCharIndexInParent(nodes[0]);startIndexInNodeGroup=startCharIndex+startIndexInNodeParent+nodeGroup.nodes[0].startChar}else{startIndexInNodeGroup=startCharIndex+nodeGroup.nodes[0].startChar}this.applyOffset(nodeGroup,startIndexInNodeGroup,true)}i=nodeGroup.endIndex;const isLastNodeGroup=i===nodes.length-1;const shouldApplyEndOffset=isLastNodeGroup&&endCharIndex!==undefined;const lastNodeHasInlineText=nodeGroup.nodes.length>0&&nodeGroup.nodes[nodeGroup.nodes.length-1].hasInlineText;if(shouldApplyEndOffset){let endIndexInNodeGroup;if(lastNodeHasInlineText){const startIndexInNodeParent=ParagraphUtils.getStartCharIndexInParent(nodes[i]);endIndexInNodeGroup=endCharIndex+startIndexInNodeParent+nodeGroup.nodes[nodeGroup.nodes.length-1].startChar}else{endIndexInNodeGroup=endCharIndex+nodeGroup.nodes[nodeGroup.nodes.length-1].startChar}this.applyOffset(nodeGroup,endIndexInNodeGroup,false)}if(nodeGroup.nodes.length===0&&!isLastNodeGroup){continue}this.currentNodeGroups_.push(nodeGroup)}if(this.currentNodeGroups_.length>0){this.currentNodeGroupIndex_=0}}startCurrentNodeGroup_(){const nodeGroup=this.getCurrentNodeGroup_();if(!nodeGroup){return}if(!nodeGroup.text){this.onNodeGroupSpeakingCompleted_();return}const options=this.getTtsOptionsForCurrentNodeGroup_();const voiceName=options&&options["voiceName"]||"";const fallbackVoiceName=this.prefsManager_.getLocalVoice();MetricsUtils.recordTtsEngineUsed(voiceName,this.prefsManager_);this.ttsManager_.speak(nodeGroup.text,options,this.prefsManager_.isNetworkVoice(voiceName),fallbackVoiceName)}getTtsOptionsForCurrentNodeGroup_(){const nodeGroup=this.getCurrentNodeGroup_();if(!nodeGroup){return}const options={};let language;let useVoiceSwitching=false;if(this.shouldUseVoiceSwitching_()&&nodeGroup.detectedLanguage){language=nodeGroup.detectedLanguage;useVoiceSwitching=true}Object.assign(options,this.prefsManager_.getSpeechOptions({language:language,useVoiceSwitching:useVoiceSwitching}));if(this.shouldShowNavigationControls_()){options.rate=this.getSpeechRate_();MetricsUtils.recordSpeechRateOverrideMultiplier(this.speechRateMultiplier_)}const nodeGroupText=nodeGroup.text||"";options.onEvent=event=>{switch(event.type){case chrome.tts.EventType.START:if(nodeGroup.nodes.length<=0){break}this.onStateChanged_(SelectToSpeakState.SPEAKING);this.currentCharIndex_=nodeGroupText.search(/\S|$/);this.syncCurrentNodeWithCharIndex_(nodeGroup,this.currentCharIndex_);if(this.prefsManager_.wordHighlightingEnabled()){this.currentNodeWord_=null;this.updateNodeHighlight_(nodeGroupText,this.currentCharIndex_,this.currentCharIndex_!==0?this.currentCharIndex_:undefined)}else{this.updateUi_()}break;case chrome.tts.EventType.RESUME:this.onTtsResumeSucceedEvent_(event);break;case chrome.tts.EventType.ERROR:if(event.errorMessage===TtsManager.ErrorMessage.RESUME_WITH_EMPTY_CONTENT){this.onTtsResumeErrorEvent_(event)}break;case chrome.tts.EventType.PAUSE:this.onStateChanged_(SelectToSpeakState.SPEAKING);case chrome.tts.EventType.INTERRUPTED:case chrome.tts.EventType.CANCELLED:if(!this.shouldShowNavigationControls_()){this.onStateChanged_(SelectToSpeakState.INACTIVE);break}if(this.state_===SelectToSpeakState.SELECTING){break}break;case chrome.tts.EventType.END:this.onNodeGroupSpeakingCompleted_();break;case chrome.tts.EventType.WORD:this.onTtsWordEvent_(event,nodeGroup);break}};return options}onNodeGroupSpeakingCompleted_(){const currentNodeGroup=this.getCurrentNodeGroup_();if(currentNodeGroup&&currentNodeGroup.endOffset!==undefined){this.currentCharIndex_=currentNodeGroup.endOffset}else{const nodeGroupText=currentNodeGroup&&currentNodeGroup.text||"";this.currentCharIndex_=nodeGroupText.length}const isLastNodeGroup=this.currentNodeGroupIndex_===this.currentNodeGroups_.length-1;if(isLastNodeGroup){if(!this.shouldShowNavigationControls_()){this.onStateChanged_(SelectToSpeakState.INACTIVE)}else{this.onStateChanged_(SelectToSpeakState.SPEAKING)}return}this.currentNodeGroupIndex_++;this.startCurrentNodeGroup_()}syncCurrentNodeWithCharIndex_(nodeGroup,charIndex,optStartFromNodeGroupIndex){if(optStartFromNodeGroupIndex===undefined){optStartFromNodeGroupIndex=0}if(charIndex<=0){this.currentNodeGroupItemIndex_=0;this.currentNodeGroupItem_=nodeGroup.nodes[this.currentNodeGroupItemIndex_];return this.currentNodeGroupItemIndex_===optStartFromNodeGroupIndex}this.currentNodeGroupItemIndex_=optStartFromNodeGroupIndex;this.currentNodeGroupItem_=nodeGroup.nodes[this.currentNodeGroupItemIndex_];if(this.currentNodeGroupItemIndex_+1<nodeGroup.nodes.length){let next=nodeGroup.nodes[this.currentNodeGroupItemIndex_+1];let nodeUpdated=false;while(next&&charIndex>=next.startChar&&this.currentNodeGroupItemIndex_+1<nodeGroup.nodes.length){next=this.incrementCurrentNodeAndGetNext_(nodeGroup);nodeUpdated=true}return nodeUpdated}return false}applyOffset(nodeGroup,offset,isStartOffset){if(isStartOffset){nodeGroup.text=" ".repeat(offset)+nodeGroup.text.substr(offset)}else{nodeGroup.text=nodeGroup.text.substr(0,offset);nodeGroup.endOffset=offset}}prepareForSpeech_(clearFocusRing){this.cancelIfSpeaking_(clearFocusRing);if(this.intervalId_!==undefined){clearInterval(this.intervalId_)}this.intervalId_=setInterval((()=>this.updateUi_()),SelectToSpeakConstants.NODE_STATE_TEST_INTERVAL_MS)}onTtsWordEvent_(event,nodeGroup){if(event.charIndex===undefined){return}const hasLength=event.length!==undefined&&event.length>=0;const length=event.length||0;this.currentCharIndex_=Math.max(event.charIndex,this.currentCharIndex_);console.debug(nodeGroup.text+" (index "+event.charIndex+")");let debug="-".repeat(event.charIndex);if(hasLength){debug+="^".repeat(length)}else{debug+="^"}console.debug(debug);const nodeUpdated=this.syncCurrentNodeWithCharIndex_(nodeGroup,event.charIndex,this.currentNodeGroupItemIndex_);if(nodeUpdated&&!this.prefsManager_.wordHighlightingEnabled()){this.updateUi_()}if(this.prefsManager_.wordHighlightingEnabled()){if(hasLength){this.currentNodeWord_={start:event.charIndex-this.currentNodeGroupItem_.startChar,end:event.charIndex+length-this.currentNodeGroupItem_.startChar};this.updateUi_()}else{this.updateNodeHighlight_(nodeGroup.text,event.charIndex)}}else{this.currentNodeWord_=null}}incrementCurrentNodeAndGetNext_(nodeGroup){this.currentNodeGroupItemIndex_+=1;this.currentNodeGroupItem_=nodeGroup.nodes[this.currentNodeGroupItemIndex_];this.currentNodeWord_=null;if(this.currentNodeGroupItemIndex_+1>=nodeGroup.nodes.length){return null}return nodeGroup.nodes[this.currentNodeGroupItemIndex_+1]}onStateChanged_(state){if(this.state_!==state){if(state===SelectToSpeakState.INACTIVE){this.clearFocusRingAndNode_()}chrome.accessibilityPrivate.setSelectToSpeakState(state);this.state_=state}}cancelIfSpeaking_(clearFocusRing){if(clearFocusRing){this.stopAll_()}else{this.ttsManager_.stop()}}isNodeInForeground_(node){return new Promise((resolve=>{this.desktop_.hitTestWithReply(node.location.left,node.location.top,(nodeAtLocation=>{chrome.automation.getFocus((focusedNode=>{const window=NodeUtils.getNearestContainingWindow(nodeAtLocation);const currentWindow=NodeUtils.getNearestContainingWindow(node);if(currentWindow!=null&&window!=null&&currentWindow===window){resolve(true);return}if(UiManager.isPanel(window)||UiManager.isPanel(NodeUtils.getNearestContainingWindow(focusedNode))){resolve(true);return}if(focusedNode&&currentWindow){const focusedWindow=NodeUtils.getNearestContainingWindow(focusedNode.root);if(focusedWindow!=null&&currentWindow===focusedWindow){resolve(true);return}}resolve(false)}))}))}))}getCurrentSpokenNode_(){if(!this.currentNodeGroupItem_){return null}if(this.currentNodeGroupItem_.hasInlineText&&this.currentNodeWord_){return ParagraphUtils.findInlineTextNodeByCharacterIndex(this.currentNodeGroupItem_.node,this.currentNodeWord_.start)}else if(this.currentNodeGroupItem_.hasInlineText&&this.shouldShowNavigationControls_()){return ParagraphUtils.findInlineTextNodeByCharacterIndex(this.currentNodeGroupItem_.node,0)}return this.currentNodeGroupItem_.node}async updateUi_(){if(this.currentNodeGroupItem_===null){return}const node=this.currentNodeGroupItem_.node;const inForeground=node.location!==undefined?await this.isNodeInForeground_(node):false;if(this.currentNodeGroupItem_===null||this.currentNodeGroupItem_.node!==node){return}const nodeState=NodeUtils.getNodeState(node);if(nodeState===NodeUtils.NodeState.NODE_STATE_INVALID||nodeState===NodeUtils.NodeState.NODE_STATE_INVISIBLE||!inForeground){this.uiManager_.clear();return}const spokenNode=this.getCurrentSpokenNode_();const currentNodeGroup=this.getCurrentNodeGroup_();if(!currentNodeGroup||!spokenNode){console.warn("Could not update UI; no node group or spoken node");return}if(this.scrollToSpokenNode_&&spokenNode.state["offscreen"]){spokenNode.makeVisible()}const currentWord=this.prefsManager_.wordHighlightingEnabled()?this.currentNodeWord_:null;this.uiManager_.update(currentNodeGroup,spokenNode,currentWord,{showPanel:this.shouldShowNavigationControls_(),paused:this.isPaused_(),speechRateMultiplier:this.speechRateMultiplier_})}maybeShowEnhancedVoicesDialog_(callback){if(!this.prefsManager_.enhancedVoicesDialogShown()&&this.prefsManager_.enhancedNetworkVoicesAllowed()){const title=chrome.i18n.getMessage("select_to_speak_natural_voice_dialog_title");const description=chrome.i18n.getMessage("select_to_speak_natural_voice_dialog_description");const cancelName=chrome.i18n.getMessage("select_to_speak_natural_voice_dialog_cancel");chrome.accessibilityPrivate.showConfirmationDialog(title,description,cancelName,(confirm=>{this.prefsManager_.setEnhancedNetworkVoicesFromDialog(confirm);if(callback!==undefined){callback()}}))}else{if(callback!==undefined){callback()}}}updateNodeHighlight_(text,charIndex,optStartIndex){if(charIndex>=text.length){return}const nextWordStart=WordUtils.getNextWordStart(text,charIndex,this.currentNodeGroupItem_);const nextWordEnd=WordUtils.getNextWordEnd(text,optStartIndex===undefined?nextWordStart:optStartIndex,this.currentNodeGroupItem_);const nodeStart=optStartIndex===undefined?nextWordStart-this.currentNodeGroupItem_.startChar:optStartIndex-this.currentNodeGroupItem_.startChar;const nodeEnd=Math.min(nextWordEnd-this.currentNodeGroupItem_.startChar,NodeUtils.nameLength(this.currentNodeGroupItem_.node));if((this.currentNodeWord_==null||nodeStart>=this.currentNodeWord_.end)&&nodeStart<=nodeEnd){this.currentNodeWord_={start:nodeStart,end:nodeEnd};this.updateUi_()}}getSpeechRate_(){const rate=this.prefsManager_.speechRate()*this.speechRateMultiplier_;return Math.round(rate*10)/10}isNavigationPanelSupported_(nodes){if(nodes.length===0){return true}if(nodes.length===1&&nodes[0]===nodes[0].root&&nodes[0].parent&&nodes[0].parent.root&&nodes[0].parent.root.role===RoleType.DESKTOP){return false}return!nodes.some((n=>n.root&&n.root.role===RoleType.DESKTOP))}sendMockSelectToSpeakKeysPressedChanged(keysPressed){this.inputHandler_.onKeysPressedChanged(new Set(keysPressed))}fireMockMouseEvent(type,mouseX,mouseY){this.inputHandler_.onMouseEvent(type,mouseX,mouseY)}shouldUseVoiceSwitching_(){return this.prefsManager_.voiceSwitchingEnabled()}setOnLoadDesktopCallbackForTest(callback){if(!this.desktop_){this.onLoadDesktopCallbackForTest_=callback;return}callback()}}TestImportManager.exportForTesting(getGSuiteAppRoot);let selectToSpeak;if(InstanceChecker.isActiveInstance()){selectToSpeak=new SelectToSpeak;TestImportManager.exportForTesting(["selectToSpeak",selectToSpeak])}export{selectToSpeak};